// pkg_changelog.cc
//
//  Copyright 2000 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.

#include "pkg_changelog.h"
#include "pkg_acqfile.h"

#include "../../config.h"

#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/stat.h>

#include <apt-pkg/error.h>
#include <apt-pkg/configuration.h>
#include <apt-pkg/acquire-item.h>
#include <apt-pkg/strutl.h>

pkg_changelog::pkg_changelog(string _filename):filename(_filename)
{
}

pkg_changelog::~pkg_changelog()
{
  if(unlink(filename.c_str())==-1)
    _error->WarningE("unlink", "%s", filename.c_str());
}

pkg_changelog *get_changelog(string package, pkgAcquireStatus *status)
{
  string filename="aptitudeXXXXXX";
  if(getenv("HOME"))
    {
      string dotdir(getenv("HOME"));
      dotdir+="/.aptitude";
      if(mkdir(dotdir.c_str(), 0700)<0 && errno!=EEXIST)
	{
	  _error->Errno("mkdir", "%s", dotdir.c_str());
	  return NULL;
	}
      string tmpdotdir(dotdir+"/.tmp");
      if(mkdir(tmpdotdir.c_str(), 0700)<0 && errno!=EEXIST)
	{
	  _error->Errno("mkdir", "%s", tmpdotdir.c_str());
	  return NULL;
	}
      filename=tmpdotdir+"/"+filename;
    }
  else
    {
      _error->Warning("Can't get value of $HOME, using TMPDIR (insecure)");
      if(getenv("TMPDIR"))
	filename=getenv("TMPDIR")+("/"+filename);
      else
	filename="/tmp/"+filename;
    }
  filename=mktemp((char *) filename.c_str());

  char uribuf[300];

  snprintf(uribuf,
	   sizeof(uribuf),
	   _config->Find(PACKAGE "::Changelog-URL-Template",
			 "http://cgi.debian.org/cgi-bin/get-changelog?package=%s").c_str(),
	   package.c_str());

  pkgAcquire fetcher(status);
  new pkgAcqFileSane(&fetcher,
		     uribuf,
		     "ChangeLog of "+package,
		     "ChangeLog of "+package,
		     filename);

  sigset_t signals,oldsigs;
  sigemptyset(&signals);
  sigaddset(&signals, SIGWINCH);
  sigprocmask(SIG_UNBLOCK, &signals, &oldsigs);

  if(fetcher.Run()!=pkgAcquire::Continue)
    {
      sigprocmask(SIG_SETMASK, &oldsigs, &signals);
      if(unlink(filename.c_str())<0 && errno!=EEXIST)
	_error->WarningE("unlink", "%s", filename.c_str());
      return NULL;
    }

  sigprocmask(SIG_SETMASK, &oldsigs, &signals);
  return new pkg_changelog(filename);
}
