// pkg_changelog.h    -*-c++-*-
//
//  Copyright 2000 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  Routines to download a Debian changelog for a given package.

#ifndef PKG_CHANGELOG_H
#define PKG_CHANGELOG_H

#include <string>

#include <apt-pkg/acquire.h>

class pkg_changelog
// Mainly used to make it easy (transparent) to clean up the changelog when
// you're done with it.
{
  string filename;

  pkg_changelog::pkg_changelog(string _filename);
  friend pkg_changelog *get_changelog(string, pkgAcquireStatus *);
public:
  string get_filename() {return filename;}

  ~pkg_changelog();
};

pkg_changelog *get_changelog(string package, pkgAcquireStatus *status);

#endif
