// load_config.cc
//
//  Copyright 2000,2001 Daniel Burrows

#include "aptitude.h"

#include "vscreen/config/colors.h"
#include "vscreen/config/keybindings.h"

#include <apt-pkg/configuration.h>
#include <apt-pkg/error.h>

#include <generic/apt.h>
#include <generic/config_signal.h>

#include <ctype.h>

using namespace std;

void load_colors(std::string group, bool use_theme)
{
  Configuration::Item const *cfg_grp=aptcfg->get_cfg(use_theme)->Tree(group.c_str());

  if(!cfg_grp)
    return;

  for(Configuration::Item const *i=cfg_grp->Child; i; i=i->Next)
    {
      if(!i->Value.empty())
	_error->Error(_("Invalid entry in color definition group: \"%s\""), i->Tag.c_str());
      else if(i->Tag.empty())
	_error->Error(_("Invalid tagless entry in color definition group: \"%s\""), i->Value.c_str());
      else if(!i->Child || !i->Child->Next || i->Child->Next->Next)
	_error->Error(_("Need exactly two colors in color definition \"%s\""), i->Tag.c_str());
      else
	{
	  short fg, bg;
	  int attr=0;
	  string fgstr=i->Child->Value;

	  // Support bold attribute on the foreground color.
	  if(tolower(fgstr[0])=='b' && tolower(fgstr[1])=='o' &&
	     tolower(fgstr[2])=='l' && tolower(fgstr[3])=='d')
	    {
	      attr|=A_BOLD;
	      fgstr=string(fgstr,4);
	    }

	  if(!parse_color(i->Child->Value, fg))
	    _error->Error(_("Can't parse foreground of color \"%s\""), i->Tag.c_str());
	  else if(!parse_color(i->Child->Next->Value, bg))
	    _error->Error(_("Can't parse background of color \"%s\""), i->Tag.c_str());
	  else
	    set_color(i->Tag, fg, bg, attr);
	}
    }
}

void load_bindings(std::string group, keybindings *toload, bool use_theme)
{
  Configuration::Item const *cfg_grp=aptcfg->get_cfg(use_theme)->Tree(group.c_str());

  if(!cfg_grp)
    return;

  for(Configuration::Item const *i=cfg_grp->Child; i; i=i->Next)
    if(!i->Child)
      {
	if(i->Value.empty())
	  _error->Error(_("Invalid entry in keybinding group: \"%s\""), i->Tag.c_str());
	else if(i->Tag.empty())
	  _error->Error(_("Invalid entry in keybinding group: \"%s\""), i->Value.c_str());
	else
	  {
	    std::string::size_type split=0,newsplit;
	    keybinding newbinding;
	    do
	      {
		newsplit=i->Value.find(',',split);
		string currval(i->Value, split, newsplit-split);

		chtype ch=parse_key(currval);

		if(ch!=(chtype) ERR)
		  newbinding.push_back(ch);
		else
		  _error->Error(_("Ignoring invalid keybinding \"%s\" -> \"%s\""), i->Tag.c_str(), currval.c_str());
		split=newsplit+1;
	      } while(newsplit!=string::npos);
	    global_bindings.set(i->Tag, newbinding);
	  }
      }
}
