// pkg_item.h  -*-c++-*-
//
//  Copyright 1999,2000 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  A tree item which represents a package.

#ifndef PKG_ITEM_H
#define PKG_ITEM_H

#include "pkg_node.h"

#include <apt-pkg/pkgcache.h>

#include <sigc++/basic_signal.h>

class pkg_item:public pkg_tree_node
{
  pkgCache::PkgIterator package;

  SigC::Signal2<void,
		const pkgCache::PkgIterator &,
		const pkgCache::VerIterator &> *info_signal;
  // To be called when we're highlighted or unhighlighted..

  // These perform the given action.  They are idempotent, like dselect's
  // keyboard commands.
  void do_select(undo_group *undo);
  void do_hold(undo_group *undo);
  void do_remove(undo_group *undo);
public:
  class pkg_columnizer;
  static pkgCache::VerIterator visible_version(const pkgCache::PkgIterator &pkg);
  pkg_item(const pkgCache::PkgIterator &_package,
	   SigC::Signal2<void,
	   const pkgCache::PkgIterator &,
	   const pkgCache::VerIterator &> *sig)
    :package(_package), info_signal(sig) {}

  virtual void paint(vs_tree *win, int y, bool hierarchical);

  virtual const char *tag() const {return package.Name();}
  virtual const char *label() const {return package.Name();}
  virtual bool matches(std::string s) const;

  virtual void select(undo_group *undo);
  virtual void hold(undo_group *undo);
  virtual void remove(undo_group *undo);
  virtual void purge(undo_group *undo);
  virtual void reinstall(undo_group *undo);
  virtual void set_auto(bool isauto, undo_group *undo);

  virtual void highlighted(vs_tree *win);
  virtual void unhighlighted(vs_tree *win);

  virtual int get_normal_attr();

  const pkgCache::PkgIterator &get_package() const {return package;}
  pkgCache::VerIterator visible_version() const
  {return visible_version(package);}

  bool dispatch_char(chtype ch, vs_tree *owner);
  void dispatch_mouse(short id, int x, mmask_t bstate, vs_tree *owner);
};

#endif
