// pkg_tree.h      -*-c++-*-
//
//  Copyright 1999,2000 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  Uses the vs_tree classes to display a tree containing packages.  A generic
// version of this, suitable only for displaying the current state of the
// package cache, is provided; it can be extended as needed.

#ifndef PKG_TREE_H
#define PKG_TREE_H

#include <vscreen/vs_tree.h>
#include <vscreen/vs_editline.h>

#include "generic/matchers.h"

class pkg_grouppolicy_factory;

class pkg_sortpolicy;
class pkg_grouppolicy;

class pkg_tree:public vs_tree
{
  pkg_grouppolicy_factory *grouping;
  std::string groupingstr;
  pkg_sortpolicy *sorting;

  pkg_matcher *limit;
  std::string limitstr;
  // Defines the limits on the display (what packages will be allowed
  // to be displayed)  This could be a grouping policy, but hardcoding the
  // filter here makes it easier to alter from the UI.

  std::string last_search_term;
  // The last thing we searched for.
  pkg_matcher *last_search_matcher;
  // As a matcher.

  static vs_editline::history_list limit_history, grouping_history,
    sorting_history, search_history;

  bool doing_incsearch;
  vs_treeiterator pre_incsearch_selected;

  void do_search(std::string s);
  void do_incsearch(std::string s);
  void do_cancel_incsearch();
  void redirect_cancel_incsearch(std::string s);
  void handle_cache_close();
protected:
  virtual bool handle_char(chtype ch);
public:
  pkg_tree(const char *groupingstr,
	   pkg_grouppolicy_factory *_grouping,
	   const char *limitstr);
  // Should you be able to just pass in a string (?)
  ~pkg_tree();

  void build_tree();
  // [re]builds the tree using the current grouping strategy.
  // (also sorts it)

  void set_grouping(pkg_grouppolicy_factory *_grouping);
  void set_grouping(std::string s);
  void set_sorting(pkg_sortpolicy *_sorting);
  void set_sorting(std::string s);
  void set_limit(string _limit);
  // Selects a new limit and rebuilds the tree.
  string get_limit_str() {return limitstr;}

  // Local bindings:
  static keybindings *bindings;
  static void init_bindings();

  SigC::Signal2<void, const pkgCache::PkgIterator &, const pkgCache::VerIterator &> selected_signal;
  SigC::Signal1<void, std::string> selected_desc_signal;
};

#endif
