// vs_bin.cc

#include "vs_bin.h"

#include "vscreen.h"

#include <sigc++/bind.h>

vs_bin::vs_bin()
  :vs_passthrough(), subwidget(NULL)
{
}

vs_bin::~vs_bin()
{
  if(subwidget)
    set_subwidget(NULL);
}

vscreen_widget *vs_bin::get_focus()
{
  if(subwidget && subwidget->get_visible())
    return subwidget;
  else
    return NULL;
}

void vs_bin::set_subwidget(vscreen_widget *w)
{
  if(subwidget)
    {
      subwidget->set_owner(NULL);
      subwidget->unfocussed();
      subwidget=NULL;
      show_conn.disconnect();
      hide_conn.disconnect();
    }

  subwidget=w;

  if(w)
    {
      show_conn=w->shown_sig.connect(bind(slot(this, &vs_bin::show_widget), w));
      hide_conn=w->hidden_sig.connect(bind(slot(this, &vs_bin::hide_widget), w));
      w->set_owner(this);
      if(get_isfocussed())
	w->focussed();
    }

  vscreen_queuelayout();
}

void vs_bin::add_widget(vscreen_widget *w)
{
  assert(subwidget==NULL);
  assert(w!=NULL);
  set_subwidget(w);

  // I assume that we're hidden right now.
  if(w->get_visible())
    show();

  if(get_isfocussed())
    w->focussed();
}

void vs_bin::rem_widget(vscreen_widget *w)
{
  assert(w==subwidget);
  set_subwidget(NULL);

  if(get_visible())
    hide();

  if(get_isfocussed())
    w->unfocussed();
}

void vs_bin::show_all()
{
  if(subwidget)
    subwidget->show_all();

  show();
}

void vs_bin::show_widget(vscreen_widget *w)
{
  assert(w==subwidget);

  show();
}

void vs_bin::hide_widget(vscreen_widget *w)
{
  assert(w==subwidget);
  hide();
}
