// vs_radiogroup.cc

#include "vs_radiogroup.h"

#include <sigc++/bind.h>

vs_radiogroup::~vs_radiogroup()
{
}

void vs_radiogroup::button_pressed(itemlist::size_type index)
{
  assert(index<items.size());

  if(selected!=items.max_size())
    items[selected].b->set_checked(false);
  selected=index;

  if(index!=items.max_size())
    {
      items[index].b->set_checked(true);
      item_selected(items[index].id);
    }
}

void vs_radiogroup::add_button(vs_togglebutton *b, int id)
{
  assert(id>=0);

  for(itemlist::iterator i=items.begin(); i!=items.end(); i++)
    assert(i->b!=b);

  items.push_back(item(b, id, b->destroyed.connect(bind(slot(this, &vs_radiogroup::rem_button), b)), b->pressed.connect(bind(slot(this, &vs_radiogroup::button_pressed), items.size()))));

  if(selected==items.max_size() || b->get_checked())
    button_pressed(items.size()-1);
}

void vs_radiogroup::rem_button(vs_togglebutton *b)
{
  for(itemlist::size_type i=0; i<items.size(); i++)
    if(items[i].b==b)
      {
	items[i].destroyed_conn.disconnect();
	items[i].pressed_conn.disconnect();
	if(selected==i)
	  button_pressed(i-1);

	if(i==items.size()-1)
	  items.pop_back();
	else
	  {
	    items[i]=items[items.size()-1];
	    if(selected==items.size()-1)
	      selected=i;
	    items.pop_back();
	    items[i].pressed_conn.disconnect();
	    items[i].pressed_conn=items[i].b->pressed.connect(bind(slot(this, &vs_radiogroup::button_pressed), i));
	  }

	return;
      }
}

void vs_radiogroup::select(int id)
{
  for(itemlist::size_type i=0; i<items.size(); i++)
    if(items[i].id==id)
      {
	button_pressed(i);

	return;
      }

  // Er, no buttons match the given ID.
  abort();
}
