// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opBatchCreatePartition = "BatchCreatePartition"

// BatchCreatePartitionRequest generates a "aws/request.Request" representing the
// client's request for the BatchCreatePartition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchCreatePartition for more information on using the BatchCreatePartition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchCreatePartitionRequest method.
//    req, resp := client.BatchCreatePartitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchCreatePartition
func (c *Glue) BatchCreatePartitionRequest(input *BatchCreatePartitionInput) (req *request.Request, output *BatchCreatePartitionOutput) {
	op := &request.Operation{
		Name:       opBatchCreatePartition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchCreatePartitionInput{}
	}

	output = &BatchCreatePartitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchCreatePartition API operation for AWS Glue.
//
// Creates one or more partitions in a batch operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation BatchCreatePartition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeAlreadyExistsException "AlreadyExistsException"
//   A resource to be created or added already exists.
//
//   * ErrCodeResourceNumberLimitExceededException "ResourceNumberLimitExceededException"
//   A resource numerical limit was exceeded.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchCreatePartition
func (c *Glue) BatchCreatePartition(input *BatchCreatePartitionInput) (*BatchCreatePartitionOutput, error) {
	req, out := c.BatchCreatePartitionRequest(input)
	return out, req.Send()
}

// BatchCreatePartitionWithContext is the same as BatchCreatePartition with the addition of
// the ability to pass a context and additional request options.
//
// See BatchCreatePartition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) BatchCreatePartitionWithContext(ctx aws.Context, input *BatchCreatePartitionInput, opts ...request.Option) (*BatchCreatePartitionOutput, error) {
	req, out := c.BatchCreatePartitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDeleteConnection = "BatchDeleteConnection"

// BatchDeleteConnectionRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeleteConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeleteConnection for more information on using the BatchDeleteConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDeleteConnectionRequest method.
//    req, resp := client.BatchDeleteConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteConnection
func (c *Glue) BatchDeleteConnectionRequest(input *BatchDeleteConnectionInput) (req *request.Request, output *BatchDeleteConnectionOutput) {
	op := &request.Operation{
		Name:       opBatchDeleteConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDeleteConnectionInput{}
	}

	output = &BatchDeleteConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDeleteConnection API operation for AWS Glue.
//
// Deletes a list of connection definitions from the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation BatchDeleteConnection for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteConnection
func (c *Glue) BatchDeleteConnection(input *BatchDeleteConnectionInput) (*BatchDeleteConnectionOutput, error) {
	req, out := c.BatchDeleteConnectionRequest(input)
	return out, req.Send()
}

// BatchDeleteConnectionWithContext is the same as BatchDeleteConnection with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeleteConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) BatchDeleteConnectionWithContext(ctx aws.Context, input *BatchDeleteConnectionInput, opts ...request.Option) (*BatchDeleteConnectionOutput, error) {
	req, out := c.BatchDeleteConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDeletePartition = "BatchDeletePartition"

// BatchDeletePartitionRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeletePartition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeletePartition for more information on using the BatchDeletePartition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDeletePartitionRequest method.
//    req, resp := client.BatchDeletePartitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeletePartition
func (c *Glue) BatchDeletePartitionRequest(input *BatchDeletePartitionInput) (req *request.Request, output *BatchDeletePartitionOutput) {
	op := &request.Operation{
		Name:       opBatchDeletePartition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDeletePartitionInput{}
	}

	output = &BatchDeletePartitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDeletePartition API operation for AWS Glue.
//
// Deletes one or more partitions in a batch operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation BatchDeletePartition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeletePartition
func (c *Glue) BatchDeletePartition(input *BatchDeletePartitionInput) (*BatchDeletePartitionOutput, error) {
	req, out := c.BatchDeletePartitionRequest(input)
	return out, req.Send()
}

// BatchDeletePartitionWithContext is the same as BatchDeletePartition with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeletePartition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) BatchDeletePartitionWithContext(ctx aws.Context, input *BatchDeletePartitionInput, opts ...request.Option) (*BatchDeletePartitionOutput, error) {
	req, out := c.BatchDeletePartitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDeleteTable = "BatchDeleteTable"

// BatchDeleteTableRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeleteTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeleteTable for more information on using the BatchDeleteTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDeleteTableRequest method.
//    req, resp := client.BatchDeleteTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteTable
func (c *Glue) BatchDeleteTableRequest(input *BatchDeleteTableInput) (req *request.Request, output *BatchDeleteTableOutput) {
	op := &request.Operation{
		Name:       opBatchDeleteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDeleteTableInput{}
	}

	output = &BatchDeleteTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDeleteTable API operation for AWS Glue.
//
// Deletes multiple tables at once.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation BatchDeleteTable for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteTable
func (c *Glue) BatchDeleteTable(input *BatchDeleteTableInput) (*BatchDeleteTableOutput, error) {
	req, out := c.BatchDeleteTableRequest(input)
	return out, req.Send()
}

// BatchDeleteTableWithContext is the same as BatchDeleteTable with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeleteTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) BatchDeleteTableWithContext(ctx aws.Context, input *BatchDeleteTableInput, opts ...request.Option) (*BatchDeleteTableOutput, error) {
	req, out := c.BatchDeleteTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDeleteTableVersion = "BatchDeleteTableVersion"

// BatchDeleteTableVersionRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeleteTableVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeleteTableVersion for more information on using the BatchDeleteTableVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDeleteTableVersionRequest method.
//    req, resp := client.BatchDeleteTableVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteTableVersion
func (c *Glue) BatchDeleteTableVersionRequest(input *BatchDeleteTableVersionInput) (req *request.Request, output *BatchDeleteTableVersionOutput) {
	op := &request.Operation{
		Name:       opBatchDeleteTableVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDeleteTableVersionInput{}
	}

	output = &BatchDeleteTableVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDeleteTableVersion API operation for AWS Glue.
//
// Deletes a specified batch of versions of a table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation BatchDeleteTableVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchDeleteTableVersion
func (c *Glue) BatchDeleteTableVersion(input *BatchDeleteTableVersionInput) (*BatchDeleteTableVersionOutput, error) {
	req, out := c.BatchDeleteTableVersionRequest(input)
	return out, req.Send()
}

// BatchDeleteTableVersionWithContext is the same as BatchDeleteTableVersion with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeleteTableVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) BatchDeleteTableVersionWithContext(ctx aws.Context, input *BatchDeleteTableVersionInput, opts ...request.Option) (*BatchDeleteTableVersionOutput, error) {
	req, out := c.BatchDeleteTableVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetPartition = "BatchGetPartition"

// BatchGetPartitionRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetPartition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetPartition for more information on using the BatchGetPartition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetPartitionRequest method.
//    req, resp := client.BatchGetPartitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetPartition
func (c *Glue) BatchGetPartitionRequest(input *BatchGetPartitionInput) (req *request.Request, output *BatchGetPartitionOutput) {
	op := &request.Operation{
		Name:       opBatchGetPartition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetPartitionInput{}
	}

	output = &BatchGetPartitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetPartition API operation for AWS Glue.
//
// Retrieves partitions in a batch request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation BatchGetPartition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchGetPartition
func (c *Glue) BatchGetPartition(input *BatchGetPartitionInput) (*BatchGetPartitionOutput, error) {
	req, out := c.BatchGetPartitionRequest(input)
	return out, req.Send()
}

// BatchGetPartitionWithContext is the same as BatchGetPartition with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetPartition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) BatchGetPartitionWithContext(ctx aws.Context, input *BatchGetPartitionInput, opts ...request.Option) (*BatchGetPartitionOutput, error) {
	req, out := c.BatchGetPartitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchStopJobRun = "BatchStopJobRun"

// BatchStopJobRunRequest generates a "aws/request.Request" representing the
// client's request for the BatchStopJobRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchStopJobRun for more information on using the BatchStopJobRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchStopJobRunRequest method.
//    req, resp := client.BatchStopJobRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchStopJobRun
func (c *Glue) BatchStopJobRunRequest(input *BatchStopJobRunInput) (req *request.Request, output *BatchStopJobRunOutput) {
	op := &request.Operation{
		Name:       opBatchStopJobRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchStopJobRunInput{}
	}

	output = &BatchStopJobRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchStopJobRun API operation for AWS Glue.
//
// Stops one or more job runs for a specified Job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation BatchStopJobRun for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/BatchStopJobRun
func (c *Glue) BatchStopJobRun(input *BatchStopJobRunInput) (*BatchStopJobRunOutput, error) {
	req, out := c.BatchStopJobRunRequest(input)
	return out, req.Send()
}

// BatchStopJobRunWithContext is the same as BatchStopJobRun with the addition of
// the ability to pass a context and additional request options.
//
// See BatchStopJobRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) BatchStopJobRunWithContext(ctx aws.Context, input *BatchStopJobRunInput, opts ...request.Option) (*BatchStopJobRunOutput, error) {
	req, out := c.BatchStopJobRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateClassifier = "CreateClassifier"

// CreateClassifierRequest generates a "aws/request.Request" representing the
// client's request for the CreateClassifier operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateClassifier for more information on using the CreateClassifier
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateClassifierRequest method.
//    req, resp := client.CreateClassifierRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateClassifier
func (c *Glue) CreateClassifierRequest(input *CreateClassifierInput) (req *request.Request, output *CreateClassifierOutput) {
	op := &request.Operation{
		Name:       opCreateClassifier,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateClassifierInput{}
	}

	output = &CreateClassifierOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateClassifier API operation for AWS Glue.
//
// Creates a classifier in the user's account. This may be a GrokClassifier,
// an XMLClassifier, or abbrev JsonClassifier, depending on which field of the
// request is present.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CreateClassifier for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAlreadyExistsException "AlreadyExistsException"
//   A resource to be created or added already exists.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateClassifier
func (c *Glue) CreateClassifier(input *CreateClassifierInput) (*CreateClassifierOutput, error) {
	req, out := c.CreateClassifierRequest(input)
	return out, req.Send()
}

// CreateClassifierWithContext is the same as CreateClassifier with the addition of
// the ability to pass a context and additional request options.
//
// See CreateClassifier for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CreateClassifierWithContext(ctx aws.Context, input *CreateClassifierInput, opts ...request.Option) (*CreateClassifierOutput, error) {
	req, out := c.CreateClassifierRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConnection = "CreateConnection"

// CreateConnectionRequest generates a "aws/request.Request" representing the
// client's request for the CreateConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConnection for more information on using the CreateConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateConnectionRequest method.
//    req, resp := client.CreateConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateConnection
func (c *Glue) CreateConnectionRequest(input *CreateConnectionInput) (req *request.Request, output *CreateConnectionOutput) {
	op := &request.Operation{
		Name:       opCreateConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateConnectionInput{}
	}

	output = &CreateConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConnection API operation for AWS Glue.
//
// Creates a connection definition in the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CreateConnection for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAlreadyExistsException "AlreadyExistsException"
//   A resource to be created or added already exists.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
//   * ErrCodeResourceNumberLimitExceededException "ResourceNumberLimitExceededException"
//   A resource numerical limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateConnection
func (c *Glue) CreateConnection(input *CreateConnectionInput) (*CreateConnectionOutput, error) {
	req, out := c.CreateConnectionRequest(input)
	return out, req.Send()
}

// CreateConnectionWithContext is the same as CreateConnection with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CreateConnectionWithContext(ctx aws.Context, input *CreateConnectionInput, opts ...request.Option) (*CreateConnectionOutput, error) {
	req, out := c.CreateConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCrawler = "CreateCrawler"

// CreateCrawlerRequest generates a "aws/request.Request" representing the
// client's request for the CreateCrawler operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCrawler for more information on using the CreateCrawler
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCrawlerRequest method.
//    req, resp := client.CreateCrawlerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateCrawler
func (c *Glue) CreateCrawlerRequest(input *CreateCrawlerInput) (req *request.Request, output *CreateCrawlerOutput) {
	op := &request.Operation{
		Name:       opCreateCrawler,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCrawlerInput{}
	}

	output = &CreateCrawlerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCrawler API operation for AWS Glue.
//
// Creates a new crawler with specified targets, role, configuration, and optional
// schedule. At least one crawl target must be specified, in either the s3Targets
// or the jdbcTargets field.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CreateCrawler for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeAlreadyExistsException "AlreadyExistsException"
//   A resource to be created or added already exists.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
//   * ErrCodeResourceNumberLimitExceededException "ResourceNumberLimitExceededException"
//   A resource numerical limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateCrawler
func (c *Glue) CreateCrawler(input *CreateCrawlerInput) (*CreateCrawlerOutput, error) {
	req, out := c.CreateCrawlerRequest(input)
	return out, req.Send()
}

// CreateCrawlerWithContext is the same as CreateCrawler with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCrawler for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CreateCrawlerWithContext(ctx aws.Context, input *CreateCrawlerInput, opts ...request.Option) (*CreateCrawlerOutput, error) {
	req, out := c.CreateCrawlerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDatabase = "CreateDatabase"

// CreateDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the CreateDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDatabase for more information on using the CreateDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDatabaseRequest method.
//    req, resp := client.CreateDatabaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateDatabase
func (c *Glue) CreateDatabaseRequest(input *CreateDatabaseInput) (req *request.Request, output *CreateDatabaseOutput) {
	op := &request.Operation{
		Name:       opCreateDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDatabaseInput{}
	}

	output = &CreateDatabaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDatabase API operation for AWS Glue.
//
// Creates a new database in a Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CreateDatabase for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeAlreadyExistsException "AlreadyExistsException"
//   A resource to be created or added already exists.
//
//   * ErrCodeResourceNumberLimitExceededException "ResourceNumberLimitExceededException"
//   A resource numerical limit was exceeded.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateDatabase
func (c *Glue) CreateDatabase(input *CreateDatabaseInput) (*CreateDatabaseOutput, error) {
	req, out := c.CreateDatabaseRequest(input)
	return out, req.Send()
}

// CreateDatabaseWithContext is the same as CreateDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CreateDatabaseWithContext(ctx aws.Context, input *CreateDatabaseInput, opts ...request.Option) (*CreateDatabaseOutput, error) {
	req, out := c.CreateDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDevEndpoint = "CreateDevEndpoint"

// CreateDevEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateDevEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDevEndpoint for more information on using the CreateDevEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDevEndpointRequest method.
//    req, resp := client.CreateDevEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateDevEndpoint
func (c *Glue) CreateDevEndpointRequest(input *CreateDevEndpointInput) (req *request.Request, output *CreateDevEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateDevEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDevEndpointInput{}
	}

	output = &CreateDevEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDevEndpoint API operation for AWS Glue.
//
// Creates a new DevEndpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CreateDevEndpoint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   Access to a resource was denied.
//
//   * ErrCodeAlreadyExistsException "AlreadyExistsException"
//   A resource to be created or added already exists.
//
//   * ErrCodeIdempotentParameterMismatchException "IdempotentParameterMismatchException"
//   The same unique identifier was associated with two different records.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeValidationException "ValidationException"
//   A value could not be validated.
//
//   * ErrCodeResourceNumberLimitExceededException "ResourceNumberLimitExceededException"
//   A resource numerical limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateDevEndpoint
func (c *Glue) CreateDevEndpoint(input *CreateDevEndpointInput) (*CreateDevEndpointOutput, error) {
	req, out := c.CreateDevEndpointRequest(input)
	return out, req.Send()
}

// CreateDevEndpointWithContext is the same as CreateDevEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDevEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CreateDevEndpointWithContext(ctx aws.Context, input *CreateDevEndpointInput, opts ...request.Option) (*CreateDevEndpointOutput, error) {
	req, out := c.CreateDevEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateJob = "CreateJob"

// CreateJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateJob for more information on using the CreateJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateJobRequest method.
//    req, resp := client.CreateJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateJob
func (c *Glue) CreateJobRequest(input *CreateJobInput) (req *request.Request, output *CreateJobOutput) {
	op := &request.Operation{
		Name:       opCreateJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateJobInput{}
	}

	output = &CreateJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateJob API operation for AWS Glue.
//
// Creates a new job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CreateJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeIdempotentParameterMismatchException "IdempotentParameterMismatchException"
//   The same unique identifier was associated with two different records.
//
//   * ErrCodeAlreadyExistsException "AlreadyExistsException"
//   A resource to be created or added already exists.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
//   * ErrCodeResourceNumberLimitExceededException "ResourceNumberLimitExceededException"
//   A resource numerical limit was exceeded.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateJob
func (c *Glue) CreateJob(input *CreateJobInput) (*CreateJobOutput, error) {
	req, out := c.CreateJobRequest(input)
	return out, req.Send()
}

// CreateJobWithContext is the same as CreateJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CreateJobWithContext(ctx aws.Context, input *CreateJobInput, opts ...request.Option) (*CreateJobOutput, error) {
	req, out := c.CreateJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePartition = "CreatePartition"

// CreatePartitionRequest generates a "aws/request.Request" representing the
// client's request for the CreatePartition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePartition for more information on using the CreatePartition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePartitionRequest method.
//    req, resp := client.CreatePartitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreatePartition
func (c *Glue) CreatePartitionRequest(input *CreatePartitionInput) (req *request.Request, output *CreatePartitionOutput) {
	op := &request.Operation{
		Name:       opCreatePartition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePartitionInput{}
	}

	output = &CreatePartitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePartition API operation for AWS Glue.
//
// Creates a new partition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CreatePartition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeAlreadyExistsException "AlreadyExistsException"
//   A resource to be created or added already exists.
//
//   * ErrCodeResourceNumberLimitExceededException "ResourceNumberLimitExceededException"
//   A resource numerical limit was exceeded.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreatePartition
func (c *Glue) CreatePartition(input *CreatePartitionInput) (*CreatePartitionOutput, error) {
	req, out := c.CreatePartitionRequest(input)
	return out, req.Send()
}

// CreatePartitionWithContext is the same as CreatePartition with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePartition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CreatePartitionWithContext(ctx aws.Context, input *CreatePartitionInput, opts ...request.Option) (*CreatePartitionOutput, error) {
	req, out := c.CreatePartitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateScript = "CreateScript"

// CreateScriptRequest generates a "aws/request.Request" representing the
// client's request for the CreateScript operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateScript for more information on using the CreateScript
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateScriptRequest method.
//    req, resp := client.CreateScriptRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateScript
func (c *Glue) CreateScriptRequest(input *CreateScriptInput) (req *request.Request, output *CreateScriptOutput) {
	op := &request.Operation{
		Name:       opCreateScript,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateScriptInput{}
	}

	output = &CreateScriptOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateScript API operation for AWS Glue.
//
// Transforms a directed acyclic graph (DAG) into code.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CreateScript for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateScript
func (c *Glue) CreateScript(input *CreateScriptInput) (*CreateScriptOutput, error) {
	req, out := c.CreateScriptRequest(input)
	return out, req.Send()
}

// CreateScriptWithContext is the same as CreateScript with the addition of
// the ability to pass a context and additional request options.
//
// See CreateScript for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CreateScriptWithContext(ctx aws.Context, input *CreateScriptInput, opts ...request.Option) (*CreateScriptOutput, error) {
	req, out := c.CreateScriptRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTable = "CreateTable"

// CreateTableRequest generates a "aws/request.Request" representing the
// client's request for the CreateTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTable for more information on using the CreateTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTableRequest method.
//    req, resp := client.CreateTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateTable
func (c *Glue) CreateTableRequest(input *CreateTableInput) (req *request.Request, output *CreateTableOutput) {
	op := &request.Operation{
		Name:       opCreateTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTableInput{}
	}

	output = &CreateTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTable API operation for AWS Glue.
//
// Creates a new table definition in the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CreateTable for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAlreadyExistsException "AlreadyExistsException"
//   A resource to be created or added already exists.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeResourceNumberLimitExceededException "ResourceNumberLimitExceededException"
//   A resource numerical limit was exceeded.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateTable
func (c *Glue) CreateTable(input *CreateTableInput) (*CreateTableOutput, error) {
	req, out := c.CreateTableRequest(input)
	return out, req.Send()
}

// CreateTableWithContext is the same as CreateTable with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CreateTableWithContext(ctx aws.Context, input *CreateTableInput, opts ...request.Option) (*CreateTableOutput, error) {
	req, out := c.CreateTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTrigger = "CreateTrigger"

// CreateTriggerRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrigger operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTrigger for more information on using the CreateTrigger
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTriggerRequest method.
//    req, resp := client.CreateTriggerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateTrigger
func (c *Glue) CreateTriggerRequest(input *CreateTriggerInput) (req *request.Request, output *CreateTriggerOutput) {
	op := &request.Operation{
		Name:       opCreateTrigger,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTriggerInput{}
	}

	output = &CreateTriggerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTrigger API operation for AWS Glue.
//
// Creates a new trigger.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CreateTrigger for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAlreadyExistsException "AlreadyExistsException"
//   A resource to be created or added already exists.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeIdempotentParameterMismatchException "IdempotentParameterMismatchException"
//   The same unique identifier was associated with two different records.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
//   * ErrCodeResourceNumberLimitExceededException "ResourceNumberLimitExceededException"
//   A resource numerical limit was exceeded.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateTrigger
func (c *Glue) CreateTrigger(input *CreateTriggerInput) (*CreateTriggerOutput, error) {
	req, out := c.CreateTriggerRequest(input)
	return out, req.Send()
}

// CreateTriggerWithContext is the same as CreateTrigger with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTrigger for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CreateTriggerWithContext(ctx aws.Context, input *CreateTriggerInput, opts ...request.Option) (*CreateTriggerOutput, error) {
	req, out := c.CreateTriggerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUserDefinedFunction = "CreateUserDefinedFunction"

// CreateUserDefinedFunctionRequest generates a "aws/request.Request" representing the
// client's request for the CreateUserDefinedFunction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUserDefinedFunction for more information on using the CreateUserDefinedFunction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateUserDefinedFunctionRequest method.
//    req, resp := client.CreateUserDefinedFunctionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateUserDefinedFunction
func (c *Glue) CreateUserDefinedFunctionRequest(input *CreateUserDefinedFunctionInput) (req *request.Request, output *CreateUserDefinedFunctionOutput) {
	op := &request.Operation{
		Name:       opCreateUserDefinedFunction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserDefinedFunctionInput{}
	}

	output = &CreateUserDefinedFunctionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUserDefinedFunction API operation for AWS Glue.
//
// Creates a new function definition in the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation CreateUserDefinedFunction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAlreadyExistsException "AlreadyExistsException"
//   A resource to be created or added already exists.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
//   * ErrCodeResourceNumberLimitExceededException "ResourceNumberLimitExceededException"
//   A resource numerical limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/CreateUserDefinedFunction
func (c *Glue) CreateUserDefinedFunction(input *CreateUserDefinedFunctionInput) (*CreateUserDefinedFunctionOutput, error) {
	req, out := c.CreateUserDefinedFunctionRequest(input)
	return out, req.Send()
}

// CreateUserDefinedFunctionWithContext is the same as CreateUserDefinedFunction with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUserDefinedFunction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) CreateUserDefinedFunctionWithContext(ctx aws.Context, input *CreateUserDefinedFunctionInput, opts ...request.Option) (*CreateUserDefinedFunctionOutput, error) {
	req, out := c.CreateUserDefinedFunctionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteClassifier = "DeleteClassifier"

// DeleteClassifierRequest generates a "aws/request.Request" representing the
// client's request for the DeleteClassifier operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteClassifier for more information on using the DeleteClassifier
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteClassifierRequest method.
//    req, resp := client.DeleteClassifierRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteClassifier
func (c *Glue) DeleteClassifierRequest(input *DeleteClassifierInput) (req *request.Request, output *DeleteClassifierOutput) {
	op := &request.Operation{
		Name:       opDeleteClassifier,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteClassifierInput{}
	}

	output = &DeleteClassifierOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteClassifier API operation for AWS Glue.
//
// Removes a classifier from the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeleteClassifier for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteClassifier
func (c *Glue) DeleteClassifier(input *DeleteClassifierInput) (*DeleteClassifierOutput, error) {
	req, out := c.DeleteClassifierRequest(input)
	return out, req.Send()
}

// DeleteClassifierWithContext is the same as DeleteClassifier with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteClassifier for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeleteClassifierWithContext(ctx aws.Context, input *DeleteClassifierInput, opts ...request.Option) (*DeleteClassifierOutput, error) {
	req, out := c.DeleteClassifierRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConnection = "DeleteConnection"

// DeleteConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConnection for more information on using the DeleteConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConnectionRequest method.
//    req, resp := client.DeleteConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteConnection
func (c *Glue) DeleteConnectionRequest(input *DeleteConnectionInput) (req *request.Request, output *DeleteConnectionOutput) {
	op := &request.Operation{
		Name:       opDeleteConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConnectionInput{}
	}

	output = &DeleteConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteConnection API operation for AWS Glue.
//
// Deletes a connection from the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeleteConnection for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteConnection
func (c *Glue) DeleteConnection(input *DeleteConnectionInput) (*DeleteConnectionOutput, error) {
	req, out := c.DeleteConnectionRequest(input)
	return out, req.Send()
}

// DeleteConnectionWithContext is the same as DeleteConnection with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeleteConnectionWithContext(ctx aws.Context, input *DeleteConnectionInput, opts ...request.Option) (*DeleteConnectionOutput, error) {
	req, out := c.DeleteConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCrawler = "DeleteCrawler"

// DeleteCrawlerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCrawler operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCrawler for more information on using the DeleteCrawler
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCrawlerRequest method.
//    req, resp := client.DeleteCrawlerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteCrawler
func (c *Glue) DeleteCrawlerRequest(input *DeleteCrawlerInput) (req *request.Request, output *DeleteCrawlerOutput) {
	op := &request.Operation{
		Name:       opDeleteCrawler,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCrawlerInput{}
	}

	output = &DeleteCrawlerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCrawler API operation for AWS Glue.
//
// Removes a specified crawler from the Data Catalog, unless the crawler state
// is RUNNING.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeleteCrawler for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeCrawlerRunningException "CrawlerRunningException"
//   The operation cannot be performed because the crawler is already running.
//
//   * ErrCodeSchedulerTransitioningException "SchedulerTransitioningException"
//   The specified scheduler is transitioning.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteCrawler
func (c *Glue) DeleteCrawler(input *DeleteCrawlerInput) (*DeleteCrawlerOutput, error) {
	req, out := c.DeleteCrawlerRequest(input)
	return out, req.Send()
}

// DeleteCrawlerWithContext is the same as DeleteCrawler with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCrawler for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeleteCrawlerWithContext(ctx aws.Context, input *DeleteCrawlerInput, opts ...request.Option) (*DeleteCrawlerOutput, error) {
	req, out := c.DeleteCrawlerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDatabase = "DeleteDatabase"

// DeleteDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDatabase for more information on using the DeleteDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDatabaseRequest method.
//    req, resp := client.DeleteDatabaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteDatabase
func (c *Glue) DeleteDatabaseRequest(input *DeleteDatabaseInput) (req *request.Request, output *DeleteDatabaseOutput) {
	op := &request.Operation{
		Name:       opDeleteDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDatabaseInput{}
	}

	output = &DeleteDatabaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDatabase API operation for AWS Glue.
//
// Removes a specified Database from a Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeleteDatabase for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteDatabase
func (c *Glue) DeleteDatabase(input *DeleteDatabaseInput) (*DeleteDatabaseOutput, error) {
	req, out := c.DeleteDatabaseRequest(input)
	return out, req.Send()
}

// DeleteDatabaseWithContext is the same as DeleteDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeleteDatabaseWithContext(ctx aws.Context, input *DeleteDatabaseInput, opts ...request.Option) (*DeleteDatabaseOutput, error) {
	req, out := c.DeleteDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDevEndpoint = "DeleteDevEndpoint"

// DeleteDevEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDevEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDevEndpoint for more information on using the DeleteDevEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDevEndpointRequest method.
//    req, resp := client.DeleteDevEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteDevEndpoint
func (c *Glue) DeleteDevEndpointRequest(input *DeleteDevEndpointInput) (req *request.Request, output *DeleteDevEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteDevEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDevEndpointInput{}
	}

	output = &DeleteDevEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDevEndpoint API operation for AWS Glue.
//
// Deletes a specified DevEndpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeleteDevEndpoint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteDevEndpoint
func (c *Glue) DeleteDevEndpoint(input *DeleteDevEndpointInput) (*DeleteDevEndpointOutput, error) {
	req, out := c.DeleteDevEndpointRequest(input)
	return out, req.Send()
}

// DeleteDevEndpointWithContext is the same as DeleteDevEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDevEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeleteDevEndpointWithContext(ctx aws.Context, input *DeleteDevEndpointInput, opts ...request.Option) (*DeleteDevEndpointOutput, error) {
	req, out := c.DeleteDevEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteJob = "DeleteJob"

// DeleteJobRequest generates a "aws/request.Request" representing the
// client's request for the DeleteJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteJob for more information on using the DeleteJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteJobRequest method.
//    req, resp := client.DeleteJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteJob
func (c *Glue) DeleteJobRequest(input *DeleteJobInput) (req *request.Request, output *DeleteJobOutput) {
	op := &request.Operation{
		Name:       opDeleteJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteJobInput{}
	}

	output = &DeleteJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteJob API operation for AWS Glue.
//
// Deletes a specified job. If the job is not found, no exception is thrown.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeleteJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteJob
func (c *Glue) DeleteJob(input *DeleteJobInput) (*DeleteJobOutput, error) {
	req, out := c.DeleteJobRequest(input)
	return out, req.Send()
}

// DeleteJobWithContext is the same as DeleteJob with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeleteJobWithContext(ctx aws.Context, input *DeleteJobInput, opts ...request.Option) (*DeleteJobOutput, error) {
	req, out := c.DeleteJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePartition = "DeletePartition"

// DeletePartitionRequest generates a "aws/request.Request" representing the
// client's request for the DeletePartition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePartition for more information on using the DeletePartition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePartitionRequest method.
//    req, resp := client.DeletePartitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeletePartition
func (c *Glue) DeletePartitionRequest(input *DeletePartitionInput) (req *request.Request, output *DeletePartitionOutput) {
	op := &request.Operation{
		Name:       opDeletePartition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePartitionInput{}
	}

	output = &DeletePartitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeletePartition API operation for AWS Glue.
//
// Deletes a specified partition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeletePartition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeletePartition
func (c *Glue) DeletePartition(input *DeletePartitionInput) (*DeletePartitionOutput, error) {
	req, out := c.DeletePartitionRequest(input)
	return out, req.Send()
}

// DeletePartitionWithContext is the same as DeletePartition with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePartition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeletePartitionWithContext(ctx aws.Context, input *DeletePartitionInput, opts ...request.Option) (*DeletePartitionOutput, error) {
	req, out := c.DeletePartitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTable = "DeleteTable"

// DeleteTableRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTable for more information on using the DeleteTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTableRequest method.
//    req, resp := client.DeleteTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTable
func (c *Glue) DeleteTableRequest(input *DeleteTableInput) (req *request.Request, output *DeleteTableOutput) {
	op := &request.Operation{
		Name:       opDeleteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTableInput{}
	}

	output = &DeleteTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTable API operation for AWS Glue.
//
// Removes a table definition from the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeleteTable for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTable
func (c *Glue) DeleteTable(input *DeleteTableInput) (*DeleteTableOutput, error) {
	req, out := c.DeleteTableRequest(input)
	return out, req.Send()
}

// DeleteTableWithContext is the same as DeleteTable with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeleteTableWithContext(ctx aws.Context, input *DeleteTableInput, opts ...request.Option) (*DeleteTableOutput, error) {
	req, out := c.DeleteTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTableVersion = "DeleteTableVersion"

// DeleteTableVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTableVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTableVersion for more information on using the DeleteTableVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTableVersionRequest method.
//    req, resp := client.DeleteTableVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTableVersion
func (c *Glue) DeleteTableVersionRequest(input *DeleteTableVersionInput) (req *request.Request, output *DeleteTableVersionOutput) {
	op := &request.Operation{
		Name:       opDeleteTableVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTableVersionInput{}
	}

	output = &DeleteTableVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTableVersion API operation for AWS Glue.
//
// Deletes a specified version of a table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeleteTableVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTableVersion
func (c *Glue) DeleteTableVersion(input *DeleteTableVersionInput) (*DeleteTableVersionOutput, error) {
	req, out := c.DeleteTableVersionRequest(input)
	return out, req.Send()
}

// DeleteTableVersionWithContext is the same as DeleteTableVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTableVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeleteTableVersionWithContext(ctx aws.Context, input *DeleteTableVersionInput, opts ...request.Option) (*DeleteTableVersionOutput, error) {
	req, out := c.DeleteTableVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTrigger = "DeleteTrigger"

// DeleteTriggerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTrigger operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTrigger for more information on using the DeleteTrigger
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTriggerRequest method.
//    req, resp := client.DeleteTriggerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTrigger
func (c *Glue) DeleteTriggerRequest(input *DeleteTriggerInput) (req *request.Request, output *DeleteTriggerOutput) {
	op := &request.Operation{
		Name:       opDeleteTrigger,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTriggerInput{}
	}

	output = &DeleteTriggerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTrigger API operation for AWS Glue.
//
// Deletes a specified trigger. If the trigger is not found, no exception is
// thrown.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeleteTrigger for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteTrigger
func (c *Glue) DeleteTrigger(input *DeleteTriggerInput) (*DeleteTriggerOutput, error) {
	req, out := c.DeleteTriggerRequest(input)
	return out, req.Send()
}

// DeleteTriggerWithContext is the same as DeleteTrigger with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTrigger for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeleteTriggerWithContext(ctx aws.Context, input *DeleteTriggerInput, opts ...request.Option) (*DeleteTriggerOutput, error) {
	req, out := c.DeleteTriggerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUserDefinedFunction = "DeleteUserDefinedFunction"

// DeleteUserDefinedFunctionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUserDefinedFunction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUserDefinedFunction for more information on using the DeleteUserDefinedFunction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserDefinedFunctionRequest method.
//    req, resp := client.DeleteUserDefinedFunctionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteUserDefinedFunction
func (c *Glue) DeleteUserDefinedFunctionRequest(input *DeleteUserDefinedFunctionInput) (req *request.Request, output *DeleteUserDefinedFunctionOutput) {
	op := &request.Operation{
		Name:       opDeleteUserDefinedFunction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserDefinedFunctionInput{}
	}

	output = &DeleteUserDefinedFunctionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteUserDefinedFunction API operation for AWS Glue.
//
// Deletes an existing function definition from the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation DeleteUserDefinedFunction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeleteUserDefinedFunction
func (c *Glue) DeleteUserDefinedFunction(input *DeleteUserDefinedFunctionInput) (*DeleteUserDefinedFunctionOutput, error) {
	req, out := c.DeleteUserDefinedFunctionRequest(input)
	return out, req.Send()
}

// DeleteUserDefinedFunctionWithContext is the same as DeleteUserDefinedFunction with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUserDefinedFunction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) DeleteUserDefinedFunctionWithContext(ctx aws.Context, input *DeleteUserDefinedFunctionInput, opts ...request.Option) (*DeleteUserDefinedFunctionOutput, error) {
	req, out := c.DeleteUserDefinedFunctionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCatalogImportStatus = "GetCatalogImportStatus"

// GetCatalogImportStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetCatalogImportStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCatalogImportStatus for more information on using the GetCatalogImportStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCatalogImportStatusRequest method.
//    req, resp := client.GetCatalogImportStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCatalogImportStatus
func (c *Glue) GetCatalogImportStatusRequest(input *GetCatalogImportStatusInput) (req *request.Request, output *GetCatalogImportStatusOutput) {
	op := &request.Operation{
		Name:       opGetCatalogImportStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCatalogImportStatusInput{}
	}

	output = &GetCatalogImportStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCatalogImportStatus API operation for AWS Glue.
//
// Retrieves the status of a migration operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetCatalogImportStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCatalogImportStatus
func (c *Glue) GetCatalogImportStatus(input *GetCatalogImportStatusInput) (*GetCatalogImportStatusOutput, error) {
	req, out := c.GetCatalogImportStatusRequest(input)
	return out, req.Send()
}

// GetCatalogImportStatusWithContext is the same as GetCatalogImportStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetCatalogImportStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetCatalogImportStatusWithContext(ctx aws.Context, input *GetCatalogImportStatusInput, opts ...request.Option) (*GetCatalogImportStatusOutput, error) {
	req, out := c.GetCatalogImportStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetClassifier = "GetClassifier"

// GetClassifierRequest generates a "aws/request.Request" representing the
// client's request for the GetClassifier operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetClassifier for more information on using the GetClassifier
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetClassifierRequest method.
//    req, resp := client.GetClassifierRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetClassifier
func (c *Glue) GetClassifierRequest(input *GetClassifierInput) (req *request.Request, output *GetClassifierOutput) {
	op := &request.Operation{
		Name:       opGetClassifier,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetClassifierInput{}
	}

	output = &GetClassifierOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetClassifier API operation for AWS Glue.
//
// Retrieve a classifier by name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetClassifier for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetClassifier
func (c *Glue) GetClassifier(input *GetClassifierInput) (*GetClassifierOutput, error) {
	req, out := c.GetClassifierRequest(input)
	return out, req.Send()
}

// GetClassifierWithContext is the same as GetClassifier with the addition of
// the ability to pass a context and additional request options.
//
// See GetClassifier for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetClassifierWithContext(ctx aws.Context, input *GetClassifierInput, opts ...request.Option) (*GetClassifierOutput, error) {
	req, out := c.GetClassifierRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetClassifiers = "GetClassifiers"

// GetClassifiersRequest generates a "aws/request.Request" representing the
// client's request for the GetClassifiers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetClassifiers for more information on using the GetClassifiers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetClassifiersRequest method.
//    req, resp := client.GetClassifiersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetClassifiers
func (c *Glue) GetClassifiersRequest(input *GetClassifiersInput) (req *request.Request, output *GetClassifiersOutput) {
	op := &request.Operation{
		Name:       opGetClassifiers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetClassifiersInput{}
	}

	output = &GetClassifiersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetClassifiers API operation for AWS Glue.
//
// Lists all classifier objects in the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetClassifiers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetClassifiers
func (c *Glue) GetClassifiers(input *GetClassifiersInput) (*GetClassifiersOutput, error) {
	req, out := c.GetClassifiersRequest(input)
	return out, req.Send()
}

// GetClassifiersWithContext is the same as GetClassifiers with the addition of
// the ability to pass a context and additional request options.
//
// See GetClassifiers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetClassifiersWithContext(ctx aws.Context, input *GetClassifiersInput, opts ...request.Option) (*GetClassifiersOutput, error) {
	req, out := c.GetClassifiersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetClassifiersPages iterates over the pages of a GetClassifiers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetClassifiers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetClassifiers operation.
//    pageNum := 0
//    err := client.GetClassifiersPages(params,
//        func(page *GetClassifiersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetClassifiersPages(input *GetClassifiersInput, fn func(*GetClassifiersOutput, bool) bool) error {
	return c.GetClassifiersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetClassifiersPagesWithContext same as GetClassifiersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetClassifiersPagesWithContext(ctx aws.Context, input *GetClassifiersInput, fn func(*GetClassifiersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetClassifiersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetClassifiersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetClassifiersOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetConnection = "GetConnection"

// GetConnectionRequest generates a "aws/request.Request" representing the
// client's request for the GetConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConnection for more information on using the GetConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetConnectionRequest method.
//    req, resp := client.GetConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetConnection
func (c *Glue) GetConnectionRequest(input *GetConnectionInput) (req *request.Request, output *GetConnectionOutput) {
	op := &request.Operation{
		Name:       opGetConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetConnectionInput{}
	}

	output = &GetConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConnection API operation for AWS Glue.
//
// Retrieves a connection definition from the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetConnection for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetConnection
func (c *Glue) GetConnection(input *GetConnectionInput) (*GetConnectionOutput, error) {
	req, out := c.GetConnectionRequest(input)
	return out, req.Send()
}

// GetConnectionWithContext is the same as GetConnection with the addition of
// the ability to pass a context and additional request options.
//
// See GetConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetConnectionWithContext(ctx aws.Context, input *GetConnectionInput, opts ...request.Option) (*GetConnectionOutput, error) {
	req, out := c.GetConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConnections = "GetConnections"

// GetConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the GetConnections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConnections for more information on using the GetConnections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetConnectionsRequest method.
//    req, resp := client.GetConnectionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetConnections
func (c *Glue) GetConnectionsRequest(input *GetConnectionsInput) (req *request.Request, output *GetConnectionsOutput) {
	op := &request.Operation{
		Name:       opGetConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetConnectionsInput{}
	}

	output = &GetConnectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConnections API operation for AWS Glue.
//
// Retrieves a list of connection definitions from the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetConnections for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetConnections
func (c *Glue) GetConnections(input *GetConnectionsInput) (*GetConnectionsOutput, error) {
	req, out := c.GetConnectionsRequest(input)
	return out, req.Send()
}

// GetConnectionsWithContext is the same as GetConnections with the addition of
// the ability to pass a context and additional request options.
//
// See GetConnections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetConnectionsWithContext(ctx aws.Context, input *GetConnectionsInput, opts ...request.Option) (*GetConnectionsOutput, error) {
	req, out := c.GetConnectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetConnectionsPages iterates over the pages of a GetConnections operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetConnections method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetConnections operation.
//    pageNum := 0
//    err := client.GetConnectionsPages(params,
//        func(page *GetConnectionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetConnectionsPages(input *GetConnectionsInput, fn func(*GetConnectionsOutput, bool) bool) error {
	return c.GetConnectionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetConnectionsPagesWithContext same as GetConnectionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetConnectionsPagesWithContext(ctx aws.Context, input *GetConnectionsInput, fn func(*GetConnectionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetConnectionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetConnectionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetConnectionsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetCrawler = "GetCrawler"

// GetCrawlerRequest generates a "aws/request.Request" representing the
// client's request for the GetCrawler operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCrawler for more information on using the GetCrawler
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCrawlerRequest method.
//    req, resp := client.GetCrawlerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawler
func (c *Glue) GetCrawlerRequest(input *GetCrawlerInput) (req *request.Request, output *GetCrawlerOutput) {
	op := &request.Operation{
		Name:       opGetCrawler,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCrawlerInput{}
	}

	output = &GetCrawlerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCrawler API operation for AWS Glue.
//
// Retrieves metadata for a specified crawler.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetCrawler for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawler
func (c *Glue) GetCrawler(input *GetCrawlerInput) (*GetCrawlerOutput, error) {
	req, out := c.GetCrawlerRequest(input)
	return out, req.Send()
}

// GetCrawlerWithContext is the same as GetCrawler with the addition of
// the ability to pass a context and additional request options.
//
// See GetCrawler for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetCrawlerWithContext(ctx aws.Context, input *GetCrawlerInput, opts ...request.Option) (*GetCrawlerOutput, error) {
	req, out := c.GetCrawlerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCrawlerMetrics = "GetCrawlerMetrics"

// GetCrawlerMetricsRequest generates a "aws/request.Request" representing the
// client's request for the GetCrawlerMetrics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCrawlerMetrics for more information on using the GetCrawlerMetrics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCrawlerMetricsRequest method.
//    req, resp := client.GetCrawlerMetricsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawlerMetrics
func (c *Glue) GetCrawlerMetricsRequest(input *GetCrawlerMetricsInput) (req *request.Request, output *GetCrawlerMetricsOutput) {
	op := &request.Operation{
		Name:       opGetCrawlerMetrics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetCrawlerMetricsInput{}
	}

	output = &GetCrawlerMetricsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCrawlerMetrics API operation for AWS Glue.
//
// Retrieves metrics about specified crawlers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetCrawlerMetrics for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawlerMetrics
func (c *Glue) GetCrawlerMetrics(input *GetCrawlerMetricsInput) (*GetCrawlerMetricsOutput, error) {
	req, out := c.GetCrawlerMetricsRequest(input)
	return out, req.Send()
}

// GetCrawlerMetricsWithContext is the same as GetCrawlerMetrics with the addition of
// the ability to pass a context and additional request options.
//
// See GetCrawlerMetrics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetCrawlerMetricsWithContext(ctx aws.Context, input *GetCrawlerMetricsInput, opts ...request.Option) (*GetCrawlerMetricsOutput, error) {
	req, out := c.GetCrawlerMetricsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetCrawlerMetricsPages iterates over the pages of a GetCrawlerMetrics operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetCrawlerMetrics method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetCrawlerMetrics operation.
//    pageNum := 0
//    err := client.GetCrawlerMetricsPages(params,
//        func(page *GetCrawlerMetricsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetCrawlerMetricsPages(input *GetCrawlerMetricsInput, fn func(*GetCrawlerMetricsOutput, bool) bool) error {
	return c.GetCrawlerMetricsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetCrawlerMetricsPagesWithContext same as GetCrawlerMetricsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetCrawlerMetricsPagesWithContext(ctx aws.Context, input *GetCrawlerMetricsInput, fn func(*GetCrawlerMetricsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetCrawlerMetricsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetCrawlerMetricsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetCrawlerMetricsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetCrawlers = "GetCrawlers"

// GetCrawlersRequest generates a "aws/request.Request" representing the
// client's request for the GetCrawlers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCrawlers for more information on using the GetCrawlers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCrawlersRequest method.
//    req, resp := client.GetCrawlersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawlers
func (c *Glue) GetCrawlersRequest(input *GetCrawlersInput) (req *request.Request, output *GetCrawlersOutput) {
	op := &request.Operation{
		Name:       opGetCrawlers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetCrawlersInput{}
	}

	output = &GetCrawlersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCrawlers API operation for AWS Glue.
//
// Retrieves metadata for all crawlers defined in the customer account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetCrawlers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetCrawlers
func (c *Glue) GetCrawlers(input *GetCrawlersInput) (*GetCrawlersOutput, error) {
	req, out := c.GetCrawlersRequest(input)
	return out, req.Send()
}

// GetCrawlersWithContext is the same as GetCrawlers with the addition of
// the ability to pass a context and additional request options.
//
// See GetCrawlers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetCrawlersWithContext(ctx aws.Context, input *GetCrawlersInput, opts ...request.Option) (*GetCrawlersOutput, error) {
	req, out := c.GetCrawlersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetCrawlersPages iterates over the pages of a GetCrawlers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetCrawlers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetCrawlers operation.
//    pageNum := 0
//    err := client.GetCrawlersPages(params,
//        func(page *GetCrawlersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetCrawlersPages(input *GetCrawlersInput, fn func(*GetCrawlersOutput, bool) bool) error {
	return c.GetCrawlersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetCrawlersPagesWithContext same as GetCrawlersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetCrawlersPagesWithContext(ctx aws.Context, input *GetCrawlersInput, fn func(*GetCrawlersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetCrawlersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetCrawlersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetCrawlersOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetDatabase = "GetDatabase"

// GetDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the GetDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDatabase for more information on using the GetDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDatabaseRequest method.
//    req, resp := client.GetDatabaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDatabase
func (c *Glue) GetDatabaseRequest(input *GetDatabaseInput) (req *request.Request, output *GetDatabaseOutput) {
	op := &request.Operation{
		Name:       opGetDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDatabaseInput{}
	}

	output = &GetDatabaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDatabase API operation for AWS Glue.
//
// Retrieves the definition of a specified database.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetDatabase for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDatabase
func (c *Glue) GetDatabase(input *GetDatabaseInput) (*GetDatabaseOutput, error) {
	req, out := c.GetDatabaseRequest(input)
	return out, req.Send()
}

// GetDatabaseWithContext is the same as GetDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See GetDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetDatabaseWithContext(ctx aws.Context, input *GetDatabaseInput, opts ...request.Option) (*GetDatabaseOutput, error) {
	req, out := c.GetDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDatabases = "GetDatabases"

// GetDatabasesRequest generates a "aws/request.Request" representing the
// client's request for the GetDatabases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDatabases for more information on using the GetDatabases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDatabasesRequest method.
//    req, resp := client.GetDatabasesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDatabases
func (c *Glue) GetDatabasesRequest(input *GetDatabasesInput) (req *request.Request, output *GetDatabasesOutput) {
	op := &request.Operation{
		Name:       opGetDatabases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetDatabasesInput{}
	}

	output = &GetDatabasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDatabases API operation for AWS Glue.
//
// Retrieves all Databases defined in a given Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetDatabases for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDatabases
func (c *Glue) GetDatabases(input *GetDatabasesInput) (*GetDatabasesOutput, error) {
	req, out := c.GetDatabasesRequest(input)
	return out, req.Send()
}

// GetDatabasesWithContext is the same as GetDatabases with the addition of
// the ability to pass a context and additional request options.
//
// See GetDatabases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetDatabasesWithContext(ctx aws.Context, input *GetDatabasesInput, opts ...request.Option) (*GetDatabasesOutput, error) {
	req, out := c.GetDatabasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetDatabasesPages iterates over the pages of a GetDatabases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetDatabases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetDatabases operation.
//    pageNum := 0
//    err := client.GetDatabasesPages(params,
//        func(page *GetDatabasesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetDatabasesPages(input *GetDatabasesInput, fn func(*GetDatabasesOutput, bool) bool) error {
	return c.GetDatabasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetDatabasesPagesWithContext same as GetDatabasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetDatabasesPagesWithContext(ctx aws.Context, input *GetDatabasesInput, fn func(*GetDatabasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetDatabasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetDatabasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetDatabasesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetDataflowGraph = "GetDataflowGraph"

// GetDataflowGraphRequest generates a "aws/request.Request" representing the
// client's request for the GetDataflowGraph operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDataflowGraph for more information on using the GetDataflowGraph
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDataflowGraphRequest method.
//    req, resp := client.GetDataflowGraphRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataflowGraph
func (c *Glue) GetDataflowGraphRequest(input *GetDataflowGraphInput) (req *request.Request, output *GetDataflowGraphOutput) {
	op := &request.Operation{
		Name:       opGetDataflowGraph,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDataflowGraphInput{}
	}

	output = &GetDataflowGraphOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDataflowGraph API operation for AWS Glue.
//
// Transforms a Python script into a directed acyclic graph (DAG).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetDataflowGraph for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDataflowGraph
func (c *Glue) GetDataflowGraph(input *GetDataflowGraphInput) (*GetDataflowGraphOutput, error) {
	req, out := c.GetDataflowGraphRequest(input)
	return out, req.Send()
}

// GetDataflowGraphWithContext is the same as GetDataflowGraph with the addition of
// the ability to pass a context and additional request options.
//
// See GetDataflowGraph for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetDataflowGraphWithContext(ctx aws.Context, input *GetDataflowGraphInput, opts ...request.Option) (*GetDataflowGraphOutput, error) {
	req, out := c.GetDataflowGraphRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDevEndpoint = "GetDevEndpoint"

// GetDevEndpointRequest generates a "aws/request.Request" representing the
// client's request for the GetDevEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDevEndpoint for more information on using the GetDevEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDevEndpointRequest method.
//    req, resp := client.GetDevEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDevEndpoint
func (c *Glue) GetDevEndpointRequest(input *GetDevEndpointInput) (req *request.Request, output *GetDevEndpointOutput) {
	op := &request.Operation{
		Name:       opGetDevEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDevEndpointInput{}
	}

	output = &GetDevEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDevEndpoint API operation for AWS Glue.
//
// Retrieves information about a specified DevEndpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetDevEndpoint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDevEndpoint
func (c *Glue) GetDevEndpoint(input *GetDevEndpointInput) (*GetDevEndpointOutput, error) {
	req, out := c.GetDevEndpointRequest(input)
	return out, req.Send()
}

// GetDevEndpointWithContext is the same as GetDevEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See GetDevEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetDevEndpointWithContext(ctx aws.Context, input *GetDevEndpointInput, opts ...request.Option) (*GetDevEndpointOutput, error) {
	req, out := c.GetDevEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDevEndpoints = "GetDevEndpoints"

// GetDevEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the GetDevEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDevEndpoints for more information on using the GetDevEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDevEndpointsRequest method.
//    req, resp := client.GetDevEndpointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDevEndpoints
func (c *Glue) GetDevEndpointsRequest(input *GetDevEndpointsInput) (req *request.Request, output *GetDevEndpointsOutput) {
	op := &request.Operation{
		Name:       opGetDevEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetDevEndpointsInput{}
	}

	output = &GetDevEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDevEndpoints API operation for AWS Glue.
//
// Retrieves all the DevEndpoints in this AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetDevEndpoints for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetDevEndpoints
func (c *Glue) GetDevEndpoints(input *GetDevEndpointsInput) (*GetDevEndpointsOutput, error) {
	req, out := c.GetDevEndpointsRequest(input)
	return out, req.Send()
}

// GetDevEndpointsWithContext is the same as GetDevEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See GetDevEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetDevEndpointsWithContext(ctx aws.Context, input *GetDevEndpointsInput, opts ...request.Option) (*GetDevEndpointsOutput, error) {
	req, out := c.GetDevEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetDevEndpointsPages iterates over the pages of a GetDevEndpoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetDevEndpoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetDevEndpoints operation.
//    pageNum := 0
//    err := client.GetDevEndpointsPages(params,
//        func(page *GetDevEndpointsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetDevEndpointsPages(input *GetDevEndpointsInput, fn func(*GetDevEndpointsOutput, bool) bool) error {
	return c.GetDevEndpointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetDevEndpointsPagesWithContext same as GetDevEndpointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetDevEndpointsPagesWithContext(ctx aws.Context, input *GetDevEndpointsInput, fn func(*GetDevEndpointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetDevEndpointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetDevEndpointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetDevEndpointsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetJob = "GetJob"

// GetJobRequest generates a "aws/request.Request" representing the
// client's request for the GetJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetJob for more information on using the GetJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetJobRequest method.
//    req, resp := client.GetJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJob
func (c *Glue) GetJobRequest(input *GetJobInput) (req *request.Request, output *GetJobOutput) {
	op := &request.Operation{
		Name:       opGetJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetJobInput{}
	}

	output = &GetJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetJob API operation for AWS Glue.
//
// Retrieves an existing job definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJob
func (c *Glue) GetJob(input *GetJobInput) (*GetJobOutput, error) {
	req, out := c.GetJobRequest(input)
	return out, req.Send()
}

// GetJobWithContext is the same as GetJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetJobWithContext(ctx aws.Context, input *GetJobInput, opts ...request.Option) (*GetJobOutput, error) {
	req, out := c.GetJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetJobRun = "GetJobRun"

// GetJobRunRequest generates a "aws/request.Request" representing the
// client's request for the GetJobRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetJobRun for more information on using the GetJobRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetJobRunRequest method.
//    req, resp := client.GetJobRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobRun
func (c *Glue) GetJobRunRequest(input *GetJobRunInput) (req *request.Request, output *GetJobRunOutput) {
	op := &request.Operation{
		Name:       opGetJobRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetJobRunInput{}
	}

	output = &GetJobRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetJobRun API operation for AWS Glue.
//
// Retrieves the metadata for a given job run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetJobRun for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobRun
func (c *Glue) GetJobRun(input *GetJobRunInput) (*GetJobRunOutput, error) {
	req, out := c.GetJobRunRequest(input)
	return out, req.Send()
}

// GetJobRunWithContext is the same as GetJobRun with the addition of
// the ability to pass a context and additional request options.
//
// See GetJobRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetJobRunWithContext(ctx aws.Context, input *GetJobRunInput, opts ...request.Option) (*GetJobRunOutput, error) {
	req, out := c.GetJobRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetJobRuns = "GetJobRuns"

// GetJobRunsRequest generates a "aws/request.Request" representing the
// client's request for the GetJobRuns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetJobRuns for more information on using the GetJobRuns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetJobRunsRequest method.
//    req, resp := client.GetJobRunsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobRuns
func (c *Glue) GetJobRunsRequest(input *GetJobRunsInput) (req *request.Request, output *GetJobRunsOutput) {
	op := &request.Operation{
		Name:       opGetJobRuns,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetJobRunsInput{}
	}

	output = &GetJobRunsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetJobRuns API operation for AWS Glue.
//
// Retrieves metadata for all runs of a given job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetJobRuns for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobRuns
func (c *Glue) GetJobRuns(input *GetJobRunsInput) (*GetJobRunsOutput, error) {
	req, out := c.GetJobRunsRequest(input)
	return out, req.Send()
}

// GetJobRunsWithContext is the same as GetJobRuns with the addition of
// the ability to pass a context and additional request options.
//
// See GetJobRuns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetJobRunsWithContext(ctx aws.Context, input *GetJobRunsInput, opts ...request.Option) (*GetJobRunsOutput, error) {
	req, out := c.GetJobRunsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetJobRunsPages iterates over the pages of a GetJobRuns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetJobRuns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetJobRuns operation.
//    pageNum := 0
//    err := client.GetJobRunsPages(params,
//        func(page *GetJobRunsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetJobRunsPages(input *GetJobRunsInput, fn func(*GetJobRunsOutput, bool) bool) error {
	return c.GetJobRunsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetJobRunsPagesWithContext same as GetJobRunsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetJobRunsPagesWithContext(ctx aws.Context, input *GetJobRunsInput, fn func(*GetJobRunsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetJobRunsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetJobRunsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetJobRunsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetJobs = "GetJobs"

// GetJobsRequest generates a "aws/request.Request" representing the
// client's request for the GetJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetJobs for more information on using the GetJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetJobsRequest method.
//    req, resp := client.GetJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobs
func (c *Glue) GetJobsRequest(input *GetJobsInput) (req *request.Request, output *GetJobsOutput) {
	op := &request.Operation{
		Name:       opGetJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetJobsInput{}
	}

	output = &GetJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetJobs API operation for AWS Glue.
//
// Retrieves all current jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetJobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetJobs
func (c *Glue) GetJobs(input *GetJobsInput) (*GetJobsOutput, error) {
	req, out := c.GetJobsRequest(input)
	return out, req.Send()
}

// GetJobsWithContext is the same as GetJobs with the addition of
// the ability to pass a context and additional request options.
//
// See GetJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetJobsWithContext(ctx aws.Context, input *GetJobsInput, opts ...request.Option) (*GetJobsOutput, error) {
	req, out := c.GetJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetJobsPages iterates over the pages of a GetJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetJobs operation.
//    pageNum := 0
//    err := client.GetJobsPages(params,
//        func(page *GetJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetJobsPages(input *GetJobsInput, fn func(*GetJobsOutput, bool) bool) error {
	return c.GetJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetJobsPagesWithContext same as GetJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetJobsPagesWithContext(ctx aws.Context, input *GetJobsInput, fn func(*GetJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetJobsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetMapping = "GetMapping"

// GetMappingRequest generates a "aws/request.Request" representing the
// client's request for the GetMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMapping for more information on using the GetMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMappingRequest method.
//    req, resp := client.GetMappingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMapping
func (c *Glue) GetMappingRequest(input *GetMappingInput) (req *request.Request, output *GetMappingOutput) {
	op := &request.Operation{
		Name:       opGetMapping,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMappingInput{}
	}

	output = &GetMappingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMapping API operation for AWS Glue.
//
// Creates mappings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetMapping for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetMapping
func (c *Glue) GetMapping(input *GetMappingInput) (*GetMappingOutput, error) {
	req, out := c.GetMappingRequest(input)
	return out, req.Send()
}

// GetMappingWithContext is the same as GetMapping with the addition of
// the ability to pass a context and additional request options.
//
// See GetMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetMappingWithContext(ctx aws.Context, input *GetMappingInput, opts ...request.Option) (*GetMappingOutput, error) {
	req, out := c.GetMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPartition = "GetPartition"

// GetPartitionRequest generates a "aws/request.Request" representing the
// client's request for the GetPartition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPartition for more information on using the GetPartition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPartitionRequest method.
//    req, resp := client.GetPartitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartition
func (c *Glue) GetPartitionRequest(input *GetPartitionInput) (req *request.Request, output *GetPartitionOutput) {
	op := &request.Operation{
		Name:       opGetPartition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPartitionInput{}
	}

	output = &GetPartitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPartition API operation for AWS Glue.
//
// Retrieves information about a specified partition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetPartition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartition
func (c *Glue) GetPartition(input *GetPartitionInput) (*GetPartitionOutput, error) {
	req, out := c.GetPartitionRequest(input)
	return out, req.Send()
}

// GetPartitionWithContext is the same as GetPartition with the addition of
// the ability to pass a context and additional request options.
//
// See GetPartition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetPartitionWithContext(ctx aws.Context, input *GetPartitionInput, opts ...request.Option) (*GetPartitionOutput, error) {
	req, out := c.GetPartitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPartitions = "GetPartitions"

// GetPartitionsRequest generates a "aws/request.Request" representing the
// client's request for the GetPartitions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPartitions for more information on using the GetPartitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPartitionsRequest method.
//    req, resp := client.GetPartitionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartitions
func (c *Glue) GetPartitionsRequest(input *GetPartitionsInput) (req *request.Request, output *GetPartitionsOutput) {
	op := &request.Operation{
		Name:       opGetPartitions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetPartitionsInput{}
	}

	output = &GetPartitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPartitions API operation for AWS Glue.
//
// Retrieves information about the partitions in a table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetPartitions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPartitions
func (c *Glue) GetPartitions(input *GetPartitionsInput) (*GetPartitionsOutput, error) {
	req, out := c.GetPartitionsRequest(input)
	return out, req.Send()
}

// GetPartitionsWithContext is the same as GetPartitions with the addition of
// the ability to pass a context and additional request options.
//
// See GetPartitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetPartitionsWithContext(ctx aws.Context, input *GetPartitionsInput, opts ...request.Option) (*GetPartitionsOutput, error) {
	req, out := c.GetPartitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetPartitionsPages iterates over the pages of a GetPartitions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetPartitions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetPartitions operation.
//    pageNum := 0
//    err := client.GetPartitionsPages(params,
//        func(page *GetPartitionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetPartitionsPages(input *GetPartitionsInput, fn func(*GetPartitionsOutput, bool) bool) error {
	return c.GetPartitionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetPartitionsPagesWithContext same as GetPartitionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetPartitionsPagesWithContext(ctx aws.Context, input *GetPartitionsInput, fn func(*GetPartitionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetPartitionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetPartitionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetPartitionsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetPlan = "GetPlan"

// GetPlanRequest generates a "aws/request.Request" representing the
// client's request for the GetPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPlan for more information on using the GetPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPlanRequest method.
//    req, resp := client.GetPlanRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPlan
func (c *Glue) GetPlanRequest(input *GetPlanInput) (req *request.Request, output *GetPlanOutput) {
	op := &request.Operation{
		Name:       opGetPlan,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPlanInput{}
	}

	output = &GetPlanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPlan API operation for AWS Glue.
//
// Gets code to perform a specified mapping.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetPlan for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPlan
func (c *Glue) GetPlan(input *GetPlanInput) (*GetPlanOutput, error) {
	req, out := c.GetPlanRequest(input)
	return out, req.Send()
}

// GetPlanWithContext is the same as GetPlan with the addition of
// the ability to pass a context and additional request options.
//
// See GetPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetPlanWithContext(ctx aws.Context, input *GetPlanInput, opts ...request.Option) (*GetPlanOutput, error) {
	req, out := c.GetPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTable = "GetTable"

// GetTableRequest generates a "aws/request.Request" representing the
// client's request for the GetTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTable for more information on using the GetTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTableRequest method.
//    req, resp := client.GetTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTable
func (c *Glue) GetTableRequest(input *GetTableInput) (req *request.Request, output *GetTableOutput) {
	op := &request.Operation{
		Name:       opGetTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTableInput{}
	}

	output = &GetTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTable API operation for AWS Glue.
//
// Retrieves the Table definition in a Data Catalog for a specified table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetTable for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTable
func (c *Glue) GetTable(input *GetTableInput) (*GetTableOutput, error) {
	req, out := c.GetTableRequest(input)
	return out, req.Send()
}

// GetTableWithContext is the same as GetTable with the addition of
// the ability to pass a context and additional request options.
//
// See GetTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetTableWithContext(ctx aws.Context, input *GetTableInput, opts ...request.Option) (*GetTableOutput, error) {
	req, out := c.GetTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTableVersion = "GetTableVersion"

// GetTableVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetTableVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTableVersion for more information on using the GetTableVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTableVersionRequest method.
//    req, resp := client.GetTableVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTableVersion
func (c *Glue) GetTableVersionRequest(input *GetTableVersionInput) (req *request.Request, output *GetTableVersionOutput) {
	op := &request.Operation{
		Name:       opGetTableVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTableVersionInput{}
	}

	output = &GetTableVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTableVersion API operation for AWS Glue.
//
// Retrieves a specified version of a table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetTableVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTableVersion
func (c *Glue) GetTableVersion(input *GetTableVersionInput) (*GetTableVersionOutput, error) {
	req, out := c.GetTableVersionRequest(input)
	return out, req.Send()
}

// GetTableVersionWithContext is the same as GetTableVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetTableVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetTableVersionWithContext(ctx aws.Context, input *GetTableVersionInput, opts ...request.Option) (*GetTableVersionOutput, error) {
	req, out := c.GetTableVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTableVersions = "GetTableVersions"

// GetTableVersionsRequest generates a "aws/request.Request" representing the
// client's request for the GetTableVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTableVersions for more information on using the GetTableVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTableVersionsRequest method.
//    req, resp := client.GetTableVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTableVersions
func (c *Glue) GetTableVersionsRequest(input *GetTableVersionsInput) (req *request.Request, output *GetTableVersionsOutput) {
	op := &request.Operation{
		Name:       opGetTableVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetTableVersionsInput{}
	}

	output = &GetTableVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTableVersions API operation for AWS Glue.
//
// Retrieves a list of strings that identify available versions of a specified
// table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetTableVersions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTableVersions
func (c *Glue) GetTableVersions(input *GetTableVersionsInput) (*GetTableVersionsOutput, error) {
	req, out := c.GetTableVersionsRequest(input)
	return out, req.Send()
}

// GetTableVersionsWithContext is the same as GetTableVersions with the addition of
// the ability to pass a context and additional request options.
//
// See GetTableVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetTableVersionsWithContext(ctx aws.Context, input *GetTableVersionsInput, opts ...request.Option) (*GetTableVersionsOutput, error) {
	req, out := c.GetTableVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetTableVersionsPages iterates over the pages of a GetTableVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetTableVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetTableVersions operation.
//    pageNum := 0
//    err := client.GetTableVersionsPages(params,
//        func(page *GetTableVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetTableVersionsPages(input *GetTableVersionsInput, fn func(*GetTableVersionsOutput, bool) bool) error {
	return c.GetTableVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetTableVersionsPagesWithContext same as GetTableVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetTableVersionsPagesWithContext(ctx aws.Context, input *GetTableVersionsInput, fn func(*GetTableVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetTableVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetTableVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetTableVersionsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetTables = "GetTables"

// GetTablesRequest generates a "aws/request.Request" representing the
// client's request for the GetTables operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTables for more information on using the GetTables
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTablesRequest method.
//    req, resp := client.GetTablesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTables
func (c *Glue) GetTablesRequest(input *GetTablesInput) (req *request.Request, output *GetTablesOutput) {
	op := &request.Operation{
		Name:       opGetTables,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetTablesInput{}
	}

	output = &GetTablesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTables API operation for AWS Glue.
//
// Retrieves the definitions of some or all of the tables in a given Database.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetTables for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTables
func (c *Glue) GetTables(input *GetTablesInput) (*GetTablesOutput, error) {
	req, out := c.GetTablesRequest(input)
	return out, req.Send()
}

// GetTablesWithContext is the same as GetTables with the addition of
// the ability to pass a context and additional request options.
//
// See GetTables for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetTablesWithContext(ctx aws.Context, input *GetTablesInput, opts ...request.Option) (*GetTablesOutput, error) {
	req, out := c.GetTablesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetTablesPages iterates over the pages of a GetTables operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetTables method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetTables operation.
//    pageNum := 0
//    err := client.GetTablesPages(params,
//        func(page *GetTablesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetTablesPages(input *GetTablesInput, fn func(*GetTablesOutput, bool) bool) error {
	return c.GetTablesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetTablesPagesWithContext same as GetTablesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetTablesPagesWithContext(ctx aws.Context, input *GetTablesInput, fn func(*GetTablesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetTablesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetTablesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetTablesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetTrigger = "GetTrigger"

// GetTriggerRequest generates a "aws/request.Request" representing the
// client's request for the GetTrigger operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTrigger for more information on using the GetTrigger
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTriggerRequest method.
//    req, resp := client.GetTriggerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTrigger
func (c *Glue) GetTriggerRequest(input *GetTriggerInput) (req *request.Request, output *GetTriggerOutput) {
	op := &request.Operation{
		Name:       opGetTrigger,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTriggerInput{}
	}

	output = &GetTriggerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTrigger API operation for AWS Glue.
//
// Retrieves the definition of a trigger.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetTrigger for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTrigger
func (c *Glue) GetTrigger(input *GetTriggerInput) (*GetTriggerOutput, error) {
	req, out := c.GetTriggerRequest(input)
	return out, req.Send()
}

// GetTriggerWithContext is the same as GetTrigger with the addition of
// the ability to pass a context and additional request options.
//
// See GetTrigger for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetTriggerWithContext(ctx aws.Context, input *GetTriggerInput, opts ...request.Option) (*GetTriggerOutput, error) {
	req, out := c.GetTriggerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTriggers = "GetTriggers"

// GetTriggersRequest generates a "aws/request.Request" representing the
// client's request for the GetTriggers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTriggers for more information on using the GetTriggers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTriggersRequest method.
//    req, resp := client.GetTriggersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTriggers
func (c *Glue) GetTriggersRequest(input *GetTriggersInput) (req *request.Request, output *GetTriggersOutput) {
	op := &request.Operation{
		Name:       opGetTriggers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetTriggersInput{}
	}

	output = &GetTriggersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTriggers API operation for AWS Glue.
//
// Gets all the triggers associated with a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetTriggers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetTriggers
func (c *Glue) GetTriggers(input *GetTriggersInput) (*GetTriggersOutput, error) {
	req, out := c.GetTriggersRequest(input)
	return out, req.Send()
}

// GetTriggersWithContext is the same as GetTriggers with the addition of
// the ability to pass a context and additional request options.
//
// See GetTriggers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetTriggersWithContext(ctx aws.Context, input *GetTriggersInput, opts ...request.Option) (*GetTriggersOutput, error) {
	req, out := c.GetTriggersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetTriggersPages iterates over the pages of a GetTriggers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetTriggers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetTriggers operation.
//    pageNum := 0
//    err := client.GetTriggersPages(params,
//        func(page *GetTriggersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetTriggersPages(input *GetTriggersInput, fn func(*GetTriggersOutput, bool) bool) error {
	return c.GetTriggersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetTriggersPagesWithContext same as GetTriggersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetTriggersPagesWithContext(ctx aws.Context, input *GetTriggersInput, fn func(*GetTriggersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetTriggersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetTriggersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetTriggersOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetUserDefinedFunction = "GetUserDefinedFunction"

// GetUserDefinedFunctionRequest generates a "aws/request.Request" representing the
// client's request for the GetUserDefinedFunction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUserDefinedFunction for more information on using the GetUserDefinedFunction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUserDefinedFunctionRequest method.
//    req, resp := client.GetUserDefinedFunctionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUserDefinedFunction
func (c *Glue) GetUserDefinedFunctionRequest(input *GetUserDefinedFunctionInput) (req *request.Request, output *GetUserDefinedFunctionOutput) {
	op := &request.Operation{
		Name:       opGetUserDefinedFunction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetUserDefinedFunctionInput{}
	}

	output = &GetUserDefinedFunctionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUserDefinedFunction API operation for AWS Glue.
//
// Retrieves a specified function definition from the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetUserDefinedFunction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUserDefinedFunction
func (c *Glue) GetUserDefinedFunction(input *GetUserDefinedFunctionInput) (*GetUserDefinedFunctionOutput, error) {
	req, out := c.GetUserDefinedFunctionRequest(input)
	return out, req.Send()
}

// GetUserDefinedFunctionWithContext is the same as GetUserDefinedFunction with the addition of
// the ability to pass a context and additional request options.
//
// See GetUserDefinedFunction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetUserDefinedFunctionWithContext(ctx aws.Context, input *GetUserDefinedFunctionInput, opts ...request.Option) (*GetUserDefinedFunctionOutput, error) {
	req, out := c.GetUserDefinedFunctionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUserDefinedFunctions = "GetUserDefinedFunctions"

// GetUserDefinedFunctionsRequest generates a "aws/request.Request" representing the
// client's request for the GetUserDefinedFunctions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUserDefinedFunctions for more information on using the GetUserDefinedFunctions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUserDefinedFunctionsRequest method.
//    req, resp := client.GetUserDefinedFunctionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUserDefinedFunctions
func (c *Glue) GetUserDefinedFunctionsRequest(input *GetUserDefinedFunctionsInput) (req *request.Request, output *GetUserDefinedFunctionsOutput) {
	op := &request.Operation{
		Name:       opGetUserDefinedFunctions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetUserDefinedFunctionsInput{}
	}

	output = &GetUserDefinedFunctionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUserDefinedFunctions API operation for AWS Glue.
//
// Retrieves a multiple function definitions from the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation GetUserDefinedFunctions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetUserDefinedFunctions
func (c *Glue) GetUserDefinedFunctions(input *GetUserDefinedFunctionsInput) (*GetUserDefinedFunctionsOutput, error) {
	req, out := c.GetUserDefinedFunctionsRequest(input)
	return out, req.Send()
}

// GetUserDefinedFunctionsWithContext is the same as GetUserDefinedFunctions with the addition of
// the ability to pass a context and additional request options.
//
// See GetUserDefinedFunctions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetUserDefinedFunctionsWithContext(ctx aws.Context, input *GetUserDefinedFunctionsInput, opts ...request.Option) (*GetUserDefinedFunctionsOutput, error) {
	req, out := c.GetUserDefinedFunctionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetUserDefinedFunctionsPages iterates over the pages of a GetUserDefinedFunctions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetUserDefinedFunctions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetUserDefinedFunctions operation.
//    pageNum := 0
//    err := client.GetUserDefinedFunctionsPages(params,
//        func(page *GetUserDefinedFunctionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Glue) GetUserDefinedFunctionsPages(input *GetUserDefinedFunctionsInput, fn func(*GetUserDefinedFunctionsOutput, bool) bool) error {
	return c.GetUserDefinedFunctionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetUserDefinedFunctionsPagesWithContext same as GetUserDefinedFunctionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) GetUserDefinedFunctionsPagesWithContext(ctx aws.Context, input *GetUserDefinedFunctionsInput, fn func(*GetUserDefinedFunctionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetUserDefinedFunctionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetUserDefinedFunctionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetUserDefinedFunctionsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opImportCatalogToGlue = "ImportCatalogToGlue"

// ImportCatalogToGlueRequest generates a "aws/request.Request" representing the
// client's request for the ImportCatalogToGlue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportCatalogToGlue for more information on using the ImportCatalogToGlue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ImportCatalogToGlueRequest method.
//    req, resp := client.ImportCatalogToGlueRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ImportCatalogToGlue
func (c *Glue) ImportCatalogToGlueRequest(input *ImportCatalogToGlueInput) (req *request.Request, output *ImportCatalogToGlueOutput) {
	op := &request.Operation{
		Name:       opImportCatalogToGlue,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportCatalogToGlueInput{}
	}

	output = &ImportCatalogToGlueOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportCatalogToGlue API operation for AWS Glue.
//
// Imports an existing Athena Data Catalog to AWS Glue
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation ImportCatalogToGlue for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ImportCatalogToGlue
func (c *Glue) ImportCatalogToGlue(input *ImportCatalogToGlueInput) (*ImportCatalogToGlueOutput, error) {
	req, out := c.ImportCatalogToGlueRequest(input)
	return out, req.Send()
}

// ImportCatalogToGlueWithContext is the same as ImportCatalogToGlue with the addition of
// the ability to pass a context and additional request options.
//
// See ImportCatalogToGlue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) ImportCatalogToGlueWithContext(ctx aws.Context, input *ImportCatalogToGlueInput, opts ...request.Option) (*ImportCatalogToGlueOutput, error) {
	req, out := c.ImportCatalogToGlueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResetJobBookmark = "ResetJobBookmark"

// ResetJobBookmarkRequest generates a "aws/request.Request" representing the
// client's request for the ResetJobBookmark operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResetJobBookmark for more information on using the ResetJobBookmark
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResetJobBookmarkRequest method.
//    req, resp := client.ResetJobBookmarkRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ResetJobBookmark
func (c *Glue) ResetJobBookmarkRequest(input *ResetJobBookmarkInput) (req *request.Request, output *ResetJobBookmarkOutput) {
	op := &request.Operation{
		Name:       opResetJobBookmark,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetJobBookmarkInput{}
	}

	output = &ResetJobBookmarkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResetJobBookmark API operation for AWS Glue.
//
// Resets a bookmark entry.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation ResetJobBookmark for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/ResetJobBookmark
func (c *Glue) ResetJobBookmark(input *ResetJobBookmarkInput) (*ResetJobBookmarkOutput, error) {
	req, out := c.ResetJobBookmarkRequest(input)
	return out, req.Send()
}

// ResetJobBookmarkWithContext is the same as ResetJobBookmark with the addition of
// the ability to pass a context and additional request options.
//
// See ResetJobBookmark for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) ResetJobBookmarkWithContext(ctx aws.Context, input *ResetJobBookmarkInput, opts ...request.Option) (*ResetJobBookmarkOutput, error) {
	req, out := c.ResetJobBookmarkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartCrawler = "StartCrawler"

// StartCrawlerRequest generates a "aws/request.Request" representing the
// client's request for the StartCrawler operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartCrawler for more information on using the StartCrawler
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartCrawlerRequest method.
//    req, resp := client.StartCrawlerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartCrawler
func (c *Glue) StartCrawlerRequest(input *StartCrawlerInput) (req *request.Request, output *StartCrawlerOutput) {
	op := &request.Operation{
		Name:       opStartCrawler,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartCrawlerInput{}
	}

	output = &StartCrawlerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartCrawler API operation for AWS Glue.
//
// Starts a crawl using the specified crawler, regardless of what is scheduled.
// If the crawler is already running, does nothing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation StartCrawler for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeCrawlerRunningException "CrawlerRunningException"
//   The operation cannot be performed because the crawler is already running.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartCrawler
func (c *Glue) StartCrawler(input *StartCrawlerInput) (*StartCrawlerOutput, error) {
	req, out := c.StartCrawlerRequest(input)
	return out, req.Send()
}

// StartCrawlerWithContext is the same as StartCrawler with the addition of
// the ability to pass a context and additional request options.
//
// See StartCrawler for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) StartCrawlerWithContext(ctx aws.Context, input *StartCrawlerInput, opts ...request.Option) (*StartCrawlerOutput, error) {
	req, out := c.StartCrawlerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartCrawlerSchedule = "StartCrawlerSchedule"

// StartCrawlerScheduleRequest generates a "aws/request.Request" representing the
// client's request for the StartCrawlerSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartCrawlerSchedule for more information on using the StartCrawlerSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartCrawlerScheduleRequest method.
//    req, resp := client.StartCrawlerScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartCrawlerSchedule
func (c *Glue) StartCrawlerScheduleRequest(input *StartCrawlerScheduleInput) (req *request.Request, output *StartCrawlerScheduleOutput) {
	op := &request.Operation{
		Name:       opStartCrawlerSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartCrawlerScheduleInput{}
	}

	output = &StartCrawlerScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartCrawlerSchedule API operation for AWS Glue.
//
// Changes the schedule state of the specified crawler to SCHEDULED, unless
// the crawler is already running or the schedule state is already SCHEDULED.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation StartCrawlerSchedule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeSchedulerRunningException "SchedulerRunningException"
//   The specified scheduler is already running.
//
//   * ErrCodeSchedulerTransitioningException "SchedulerTransitioningException"
//   The specified scheduler is transitioning.
//
//   * ErrCodeNoScheduleException "NoScheduleException"
//   There is no applicable schedule.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartCrawlerSchedule
func (c *Glue) StartCrawlerSchedule(input *StartCrawlerScheduleInput) (*StartCrawlerScheduleOutput, error) {
	req, out := c.StartCrawlerScheduleRequest(input)
	return out, req.Send()
}

// StartCrawlerScheduleWithContext is the same as StartCrawlerSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See StartCrawlerSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) StartCrawlerScheduleWithContext(ctx aws.Context, input *StartCrawlerScheduleInput, opts ...request.Option) (*StartCrawlerScheduleOutput, error) {
	req, out := c.StartCrawlerScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartJobRun = "StartJobRun"

// StartJobRunRequest generates a "aws/request.Request" representing the
// client's request for the StartJobRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartJobRun for more information on using the StartJobRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartJobRunRequest method.
//    req, resp := client.StartJobRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartJobRun
func (c *Glue) StartJobRunRequest(input *StartJobRunInput) (req *request.Request, output *StartJobRunOutput) {
	op := &request.Operation{
		Name:       opStartJobRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartJobRunInput{}
	}

	output = &StartJobRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartJobRun API operation for AWS Glue.
//
// Runs a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation StartJobRun for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
//   * ErrCodeResourceNumberLimitExceededException "ResourceNumberLimitExceededException"
//   A resource numerical limit was exceeded.
//
//   * ErrCodeConcurrentRunsExceededException "ConcurrentRunsExceededException"
//   Too many jobs are being run concurrently.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartJobRun
func (c *Glue) StartJobRun(input *StartJobRunInput) (*StartJobRunOutput, error) {
	req, out := c.StartJobRunRequest(input)
	return out, req.Send()
}

// StartJobRunWithContext is the same as StartJobRun with the addition of
// the ability to pass a context and additional request options.
//
// See StartJobRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) StartJobRunWithContext(ctx aws.Context, input *StartJobRunInput, opts ...request.Option) (*StartJobRunOutput, error) {
	req, out := c.StartJobRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartTrigger = "StartTrigger"

// StartTriggerRequest generates a "aws/request.Request" representing the
// client's request for the StartTrigger operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartTrigger for more information on using the StartTrigger
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartTriggerRequest method.
//    req, resp := client.StartTriggerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartTrigger
func (c *Glue) StartTriggerRequest(input *StartTriggerInput) (req *request.Request, output *StartTriggerOutput) {
	op := &request.Operation{
		Name:       opStartTrigger,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartTriggerInput{}
	}

	output = &StartTriggerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartTrigger API operation for AWS Glue.
//
// Starts an existing trigger. See Triggering Jobs (http://docs.aws.amazon.com/glue/latest/dg/trigger-job.html)
// for information about how different types of trigger are started.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation StartTrigger for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
//   * ErrCodeResourceNumberLimitExceededException "ResourceNumberLimitExceededException"
//   A resource numerical limit was exceeded.
//
//   * ErrCodeConcurrentRunsExceededException "ConcurrentRunsExceededException"
//   Too many jobs are being run concurrently.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StartTrigger
func (c *Glue) StartTrigger(input *StartTriggerInput) (*StartTriggerOutput, error) {
	req, out := c.StartTriggerRequest(input)
	return out, req.Send()
}

// StartTriggerWithContext is the same as StartTrigger with the addition of
// the ability to pass a context and additional request options.
//
// See StartTrigger for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) StartTriggerWithContext(ctx aws.Context, input *StartTriggerInput, opts ...request.Option) (*StartTriggerOutput, error) {
	req, out := c.StartTriggerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopCrawler = "StopCrawler"

// StopCrawlerRequest generates a "aws/request.Request" representing the
// client's request for the StopCrawler operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopCrawler for more information on using the StopCrawler
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopCrawlerRequest method.
//    req, resp := client.StopCrawlerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopCrawler
func (c *Glue) StopCrawlerRequest(input *StopCrawlerInput) (req *request.Request, output *StopCrawlerOutput) {
	op := &request.Operation{
		Name:       opStopCrawler,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopCrawlerInput{}
	}

	output = &StopCrawlerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopCrawler API operation for AWS Glue.
//
// If the specified crawler is running, stops the crawl.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation StopCrawler for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeCrawlerNotRunningException "CrawlerNotRunningException"
//   The specified crawler is not running.
//
//   * ErrCodeCrawlerStoppingException "CrawlerStoppingException"
//   The specified crawler is stopping.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopCrawler
func (c *Glue) StopCrawler(input *StopCrawlerInput) (*StopCrawlerOutput, error) {
	req, out := c.StopCrawlerRequest(input)
	return out, req.Send()
}

// StopCrawlerWithContext is the same as StopCrawler with the addition of
// the ability to pass a context and additional request options.
//
// See StopCrawler for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) StopCrawlerWithContext(ctx aws.Context, input *StopCrawlerInput, opts ...request.Option) (*StopCrawlerOutput, error) {
	req, out := c.StopCrawlerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopCrawlerSchedule = "StopCrawlerSchedule"

// StopCrawlerScheduleRequest generates a "aws/request.Request" representing the
// client's request for the StopCrawlerSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopCrawlerSchedule for more information on using the StopCrawlerSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopCrawlerScheduleRequest method.
//    req, resp := client.StopCrawlerScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopCrawlerSchedule
func (c *Glue) StopCrawlerScheduleRequest(input *StopCrawlerScheduleInput) (req *request.Request, output *StopCrawlerScheduleOutput) {
	op := &request.Operation{
		Name:       opStopCrawlerSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopCrawlerScheduleInput{}
	}

	output = &StopCrawlerScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopCrawlerSchedule API operation for AWS Glue.
//
// Sets the schedule state of the specified crawler to NOT_SCHEDULED, but does
// not stop the crawler if it is already running.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation StopCrawlerSchedule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeSchedulerNotRunningException "SchedulerNotRunningException"
//   The specified scheduler is not running.
//
//   * ErrCodeSchedulerTransitioningException "SchedulerTransitioningException"
//   The specified scheduler is transitioning.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopCrawlerSchedule
func (c *Glue) StopCrawlerSchedule(input *StopCrawlerScheduleInput) (*StopCrawlerScheduleOutput, error) {
	req, out := c.StopCrawlerScheduleRequest(input)
	return out, req.Send()
}

// StopCrawlerScheduleWithContext is the same as StopCrawlerSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See StopCrawlerSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) StopCrawlerScheduleWithContext(ctx aws.Context, input *StopCrawlerScheduleInput, opts ...request.Option) (*StopCrawlerScheduleOutput, error) {
	req, out := c.StopCrawlerScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopTrigger = "StopTrigger"

// StopTriggerRequest generates a "aws/request.Request" representing the
// client's request for the StopTrigger operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopTrigger for more information on using the StopTrigger
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopTriggerRequest method.
//    req, resp := client.StopTriggerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopTrigger
func (c *Glue) StopTriggerRequest(input *StopTriggerInput) (req *request.Request, output *StopTriggerOutput) {
	op := &request.Operation{
		Name:       opStopTrigger,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopTriggerInput{}
	}

	output = &StopTriggerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopTrigger API operation for AWS Glue.
//
// Stops a specified trigger.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation StopTrigger for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/StopTrigger
func (c *Glue) StopTrigger(input *StopTriggerInput) (*StopTriggerOutput, error) {
	req, out := c.StopTriggerRequest(input)
	return out, req.Send()
}

// StopTriggerWithContext is the same as StopTrigger with the addition of
// the ability to pass a context and additional request options.
//
// See StopTrigger for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) StopTriggerWithContext(ctx aws.Context, input *StopTriggerInput, opts ...request.Option) (*StopTriggerOutput, error) {
	req, out := c.StopTriggerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateClassifier = "UpdateClassifier"

// UpdateClassifierRequest generates a "aws/request.Request" representing the
// client's request for the UpdateClassifier operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateClassifier for more information on using the UpdateClassifier
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateClassifierRequest method.
//    req, resp := client.UpdateClassifierRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateClassifier
func (c *Glue) UpdateClassifierRequest(input *UpdateClassifierInput) (req *request.Request, output *UpdateClassifierOutput) {
	op := &request.Operation{
		Name:       opUpdateClassifier,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateClassifierInput{}
	}

	output = &UpdateClassifierOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateClassifier API operation for AWS Glue.
//
// Modifies an existing classifier (a GrokClassifier, XMLClassifier, or JsonClassifier,
// depending on which field is present).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation UpdateClassifier for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeVersionMismatchException "VersionMismatchException"
//   There was a version conflict.
//
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateClassifier
func (c *Glue) UpdateClassifier(input *UpdateClassifierInput) (*UpdateClassifierOutput, error) {
	req, out := c.UpdateClassifierRequest(input)
	return out, req.Send()
}

// UpdateClassifierWithContext is the same as UpdateClassifier with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateClassifier for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) UpdateClassifierWithContext(ctx aws.Context, input *UpdateClassifierInput, opts ...request.Option) (*UpdateClassifierOutput, error) {
	req, out := c.UpdateClassifierRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConnection = "UpdateConnection"

// UpdateConnectionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConnection for more information on using the UpdateConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateConnectionRequest method.
//    req, resp := client.UpdateConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateConnection
func (c *Glue) UpdateConnectionRequest(input *UpdateConnectionInput) (req *request.Request, output *UpdateConnectionOutput) {
	op := &request.Operation{
		Name:       opUpdateConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateConnectionInput{}
	}

	output = &UpdateConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateConnection API operation for AWS Glue.
//
// Updates a connection definition in the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation UpdateConnection for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateConnection
func (c *Glue) UpdateConnection(input *UpdateConnectionInput) (*UpdateConnectionOutput, error) {
	req, out := c.UpdateConnectionRequest(input)
	return out, req.Send()
}

// UpdateConnectionWithContext is the same as UpdateConnection with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) UpdateConnectionWithContext(ctx aws.Context, input *UpdateConnectionInput, opts ...request.Option) (*UpdateConnectionOutput, error) {
	req, out := c.UpdateConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCrawler = "UpdateCrawler"

// UpdateCrawlerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCrawler operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCrawler for more information on using the UpdateCrawler
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateCrawlerRequest method.
//    req, resp := client.UpdateCrawlerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateCrawler
func (c *Glue) UpdateCrawlerRequest(input *UpdateCrawlerInput) (req *request.Request, output *UpdateCrawlerOutput) {
	op := &request.Operation{
		Name:       opUpdateCrawler,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCrawlerInput{}
	}

	output = &UpdateCrawlerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCrawler API operation for AWS Glue.
//
// Updates a crawler. If a crawler is running, you must stop it using StopCrawler
// before updating it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation UpdateCrawler for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeVersionMismatchException "VersionMismatchException"
//   There was a version conflict.
//
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeCrawlerRunningException "CrawlerRunningException"
//   The operation cannot be performed because the crawler is already running.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateCrawler
func (c *Glue) UpdateCrawler(input *UpdateCrawlerInput) (*UpdateCrawlerOutput, error) {
	req, out := c.UpdateCrawlerRequest(input)
	return out, req.Send()
}

// UpdateCrawlerWithContext is the same as UpdateCrawler with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCrawler for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) UpdateCrawlerWithContext(ctx aws.Context, input *UpdateCrawlerInput, opts ...request.Option) (*UpdateCrawlerOutput, error) {
	req, out := c.UpdateCrawlerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCrawlerSchedule = "UpdateCrawlerSchedule"

// UpdateCrawlerScheduleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCrawlerSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCrawlerSchedule for more information on using the UpdateCrawlerSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateCrawlerScheduleRequest method.
//    req, resp := client.UpdateCrawlerScheduleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateCrawlerSchedule
func (c *Glue) UpdateCrawlerScheduleRequest(input *UpdateCrawlerScheduleInput) (req *request.Request, output *UpdateCrawlerScheduleOutput) {
	op := &request.Operation{
		Name:       opUpdateCrawlerSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCrawlerScheduleInput{}
	}

	output = &UpdateCrawlerScheduleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCrawlerSchedule API operation for AWS Glue.
//
// Updates the schedule of a crawler using a cron expression.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation UpdateCrawlerSchedule for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeVersionMismatchException "VersionMismatchException"
//   There was a version conflict.
//
//   * ErrCodeSchedulerTransitioningException "SchedulerTransitioningException"
//   The specified scheduler is transitioning.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateCrawlerSchedule
func (c *Glue) UpdateCrawlerSchedule(input *UpdateCrawlerScheduleInput) (*UpdateCrawlerScheduleOutput, error) {
	req, out := c.UpdateCrawlerScheduleRequest(input)
	return out, req.Send()
}

// UpdateCrawlerScheduleWithContext is the same as UpdateCrawlerSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCrawlerSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) UpdateCrawlerScheduleWithContext(ctx aws.Context, input *UpdateCrawlerScheduleInput, opts ...request.Option) (*UpdateCrawlerScheduleOutput, error) {
	req, out := c.UpdateCrawlerScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDatabase = "UpdateDatabase"

// UpdateDatabaseRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDatabase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDatabase for more information on using the UpdateDatabase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDatabaseRequest method.
//    req, resp := client.UpdateDatabaseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateDatabase
func (c *Glue) UpdateDatabaseRequest(input *UpdateDatabaseInput) (req *request.Request, output *UpdateDatabaseOutput) {
	op := &request.Operation{
		Name:       opUpdateDatabase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDatabaseInput{}
	}

	output = &UpdateDatabaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDatabase API operation for AWS Glue.
//
// Updates an existing database definition in a Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation UpdateDatabase for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateDatabase
func (c *Glue) UpdateDatabase(input *UpdateDatabaseInput) (*UpdateDatabaseOutput, error) {
	req, out := c.UpdateDatabaseRequest(input)
	return out, req.Send()
}

// UpdateDatabaseWithContext is the same as UpdateDatabase with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDatabase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) UpdateDatabaseWithContext(ctx aws.Context, input *UpdateDatabaseInput, opts ...request.Option) (*UpdateDatabaseOutput, error) {
	req, out := c.UpdateDatabaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDevEndpoint = "UpdateDevEndpoint"

// UpdateDevEndpointRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDevEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDevEndpoint for more information on using the UpdateDevEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDevEndpointRequest method.
//    req, resp := client.UpdateDevEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateDevEndpoint
func (c *Glue) UpdateDevEndpointRequest(input *UpdateDevEndpointInput) (req *request.Request, output *UpdateDevEndpointOutput) {
	op := &request.Operation{
		Name:       opUpdateDevEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDevEndpointInput{}
	}

	output = &UpdateDevEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDevEndpoint API operation for AWS Glue.
//
// Updates a specified DevEndpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation UpdateDevEndpoint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeValidationException "ValidationException"
//   A value could not be validated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateDevEndpoint
func (c *Glue) UpdateDevEndpoint(input *UpdateDevEndpointInput) (*UpdateDevEndpointOutput, error) {
	req, out := c.UpdateDevEndpointRequest(input)
	return out, req.Send()
}

// UpdateDevEndpointWithContext is the same as UpdateDevEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDevEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) UpdateDevEndpointWithContext(ctx aws.Context, input *UpdateDevEndpointInput, opts ...request.Option) (*UpdateDevEndpointOutput, error) {
	req, out := c.UpdateDevEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateJob = "UpdateJob"

// UpdateJobRequest generates a "aws/request.Request" representing the
// client's request for the UpdateJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateJob for more information on using the UpdateJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateJobRequest method.
//    req, resp := client.UpdateJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateJob
func (c *Glue) UpdateJobRequest(input *UpdateJobInput) (req *request.Request, output *UpdateJobOutput) {
	op := &request.Operation{
		Name:       opUpdateJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateJobInput{}
	}

	output = &UpdateJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateJob API operation for AWS Glue.
//
// Updates an existing job definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation UpdateJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateJob
func (c *Glue) UpdateJob(input *UpdateJobInput) (*UpdateJobOutput, error) {
	req, out := c.UpdateJobRequest(input)
	return out, req.Send()
}

// UpdateJobWithContext is the same as UpdateJob with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) UpdateJobWithContext(ctx aws.Context, input *UpdateJobInput, opts ...request.Option) (*UpdateJobOutput, error) {
	req, out := c.UpdateJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePartition = "UpdatePartition"

// UpdatePartitionRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePartition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePartition for more information on using the UpdatePartition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdatePartitionRequest method.
//    req, resp := client.UpdatePartitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdatePartition
func (c *Glue) UpdatePartitionRequest(input *UpdatePartitionInput) (req *request.Request, output *UpdatePartitionOutput) {
	op := &request.Operation{
		Name:       opUpdatePartition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdatePartitionInput{}
	}

	output = &UpdatePartitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePartition API operation for AWS Glue.
//
// Updates a partition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation UpdatePartition for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdatePartition
func (c *Glue) UpdatePartition(input *UpdatePartitionInput) (*UpdatePartitionOutput, error) {
	req, out := c.UpdatePartitionRequest(input)
	return out, req.Send()
}

// UpdatePartitionWithContext is the same as UpdatePartition with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePartition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) UpdatePartitionWithContext(ctx aws.Context, input *UpdatePartitionInput, opts ...request.Option) (*UpdatePartitionOutput, error) {
	req, out := c.UpdatePartitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTable = "UpdateTable"

// UpdateTableRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTable for more information on using the UpdateTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTableRequest method.
//    req, resp := client.UpdateTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateTable
func (c *Glue) UpdateTableRequest(input *UpdateTableInput) (req *request.Request, output *UpdateTableOutput) {
	op := &request.Operation{
		Name:       opUpdateTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTableInput{}
	}

	output = &UpdateTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTable API operation for AWS Glue.
//
// Updates a metadata table in the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation UpdateTable for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Two processes are trying to modify a resource simultaneously.
//
//   * ErrCodeResourceNumberLimitExceededException "ResourceNumberLimitExceededException"
//   A resource numerical limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateTable
func (c *Glue) UpdateTable(input *UpdateTableInput) (*UpdateTableOutput, error) {
	req, out := c.UpdateTableRequest(input)
	return out, req.Send()
}

// UpdateTableWithContext is the same as UpdateTable with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) UpdateTableWithContext(ctx aws.Context, input *UpdateTableInput, opts ...request.Option) (*UpdateTableOutput, error) {
	req, out := c.UpdateTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTrigger = "UpdateTrigger"

// UpdateTriggerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTrigger operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTrigger for more information on using the UpdateTrigger
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTriggerRequest method.
//    req, resp := client.UpdateTriggerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateTrigger
func (c *Glue) UpdateTriggerRequest(input *UpdateTriggerInput) (req *request.Request, output *UpdateTriggerOutput) {
	op := &request.Operation{
		Name:       opUpdateTrigger,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTriggerInput{}
	}

	output = &UpdateTriggerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTrigger API operation for AWS Glue.
//
// Updates a trigger definition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation UpdateTrigger for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
//   * ErrCodeConcurrentModificationException "ConcurrentModificationException"
//   Two processes are trying to modify a resource simultaneously.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateTrigger
func (c *Glue) UpdateTrigger(input *UpdateTriggerInput) (*UpdateTriggerOutput, error) {
	req, out := c.UpdateTriggerRequest(input)
	return out, req.Send()
}

// UpdateTriggerWithContext is the same as UpdateTrigger with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTrigger for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) UpdateTriggerWithContext(ctx aws.Context, input *UpdateTriggerInput, opts ...request.Option) (*UpdateTriggerOutput, error) {
	req, out := c.UpdateTriggerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserDefinedFunction = "UpdateUserDefinedFunction"

// UpdateUserDefinedFunctionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserDefinedFunction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserDefinedFunction for more information on using the UpdateUserDefinedFunction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserDefinedFunctionRequest method.
//    req, resp := client.UpdateUserDefinedFunctionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateUserDefinedFunction
func (c *Glue) UpdateUserDefinedFunctionRequest(input *UpdateUserDefinedFunctionInput) (req *request.Request, output *UpdateUserDefinedFunctionOutput) {
	op := &request.Operation{
		Name:       opUpdateUserDefinedFunction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUserDefinedFunctionInput{}
	}

	output = &UpdateUserDefinedFunctionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateUserDefinedFunction API operation for AWS Glue.
//
// Updates an existing function definition in the Data Catalog.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Glue's
// API operation UpdateUserDefinedFunction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityNotFoundException "EntityNotFoundException"
//   A specified entity does not exist
//
//   * ErrCodeInvalidInputException "InvalidInputException"
//   The input provided was not valid.
//
//   * ErrCodeInternalServiceException "InternalServiceException"
//   An internal service error occurred.
//
//   * ErrCodeOperationTimeoutException "OperationTimeoutException"
//   The operation timed out.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/UpdateUserDefinedFunction
func (c *Glue) UpdateUserDefinedFunction(input *UpdateUserDefinedFunctionInput) (*UpdateUserDefinedFunctionOutput, error) {
	req, out := c.UpdateUserDefinedFunctionRequest(input)
	return out, req.Send()
}

// UpdateUserDefinedFunctionWithContext is the same as UpdateUserDefinedFunction with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserDefinedFunction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Glue) UpdateUserDefinedFunctionWithContext(ctx aws.Context, input *UpdateUserDefinedFunctionInput, opts ...request.Option) (*UpdateUserDefinedFunctionOutput, error) {
	req, out := c.UpdateUserDefinedFunctionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Defines an action to be initiated by a trigger.
type Action struct {
	_ struct{} `type:"structure"`

	// Arguments to be passed to the job.
	//
	// You can specify arguments here that your own job-execution script consumes,
	// as well as arguments that AWS Glue itself consumes.
	//
	// For information about how to specify and consume your own Job arguments,
	// see the Calling AWS Glue APIs in Python (http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html)
	// topic in the developer guide.
	//
	// For information about the key-value pairs that AWS Glue consumes to set up
	// your job, see the Special Parameters Used by AWS Glue (http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-glue-arguments.html)
	// topic in the developer guide.
	Arguments map[string]*string `type:"map"`

	// The name of a job to be executed.
	JobName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Action) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Action) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Action) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Action"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArguments sets the Arguments field's value.
func (s *Action) SetArguments(v map[string]*string) *Action {
	s.Arguments = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *Action) SetJobName(v string) *Action {
	s.JobName = &v
	return s
}

type BatchCreatePartitionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the catalog in which the partion is to be created. Currently, this
	// should be the AWS account ID.
	CatalogId *string `min:"1" type:"string"`

	// The name of the metadata database in which the partition is to be created.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// A list of PartitionInput structures that define the partitions to be created.
	//
	// PartitionInputList is a required field
	PartitionInputList []*PartitionInput `type:"list" required:"true"`

	// The name of the metadata table in which the partition is to be created.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s BatchCreatePartitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchCreatePartitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchCreatePartitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchCreatePartitionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.PartitionInputList == nil {
		invalidParams.Add(request.NewErrParamRequired("PartitionInputList"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}
	if s.PartitionInputList != nil {
		for i, v := range s.PartitionInputList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PartitionInputList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *BatchCreatePartitionInput) SetCatalogId(v string) *BatchCreatePartitionInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *BatchCreatePartitionInput) SetDatabaseName(v string) *BatchCreatePartitionInput {
	s.DatabaseName = &v
	return s
}

// SetPartitionInputList sets the PartitionInputList field's value.
func (s *BatchCreatePartitionInput) SetPartitionInputList(v []*PartitionInput) *BatchCreatePartitionInput {
	s.PartitionInputList = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *BatchCreatePartitionInput) SetTableName(v string) *BatchCreatePartitionInput {
	s.TableName = &v
	return s
}

type BatchCreatePartitionOutput struct {
	_ struct{} `type:"structure"`

	// Errors encountered when trying to create the requested partitions.
	Errors []*PartitionError `type:"list"`
}

// String returns the string representation
func (s BatchCreatePartitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchCreatePartitionOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchCreatePartitionOutput) SetErrors(v []*PartitionError) *BatchCreatePartitionOutput {
	s.Errors = v
	return s
}

type BatchDeleteConnectionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog in which the connections reside. If none is supplied,
	// the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// A list of names of the connections to delete.
	//
	// ConnectionNameList is a required field
	ConnectionNameList []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDeleteConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeleteConnectionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.ConnectionNameList == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionNameList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *BatchDeleteConnectionInput) SetCatalogId(v string) *BatchDeleteConnectionInput {
	s.CatalogId = &v
	return s
}

// SetConnectionNameList sets the ConnectionNameList field's value.
func (s *BatchDeleteConnectionInput) SetConnectionNameList(v []*string) *BatchDeleteConnectionInput {
	s.ConnectionNameList = v
	return s
}

type BatchDeleteConnectionOutput struct {
	_ struct{} `type:"structure"`

	// A map of the names of connections that were not successfully deleted to error
	// details.
	Errors map[string]*ErrorDetail `type:"map"`

	// A list of names of the connection definitions that were successfully deleted.
	Succeeded []*string `type:"list"`
}

// String returns the string representation
func (s BatchDeleteConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteConnectionOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchDeleteConnectionOutput) SetErrors(v map[string]*ErrorDetail) *BatchDeleteConnectionOutput {
	s.Errors = v
	return s
}

// SetSucceeded sets the Succeeded field's value.
func (s *BatchDeleteConnectionOutput) SetSucceeded(v []*string) *BatchDeleteConnectionOutput {
	s.Succeeded = v
	return s
}

type BatchDeletePartitionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the partition to be deleted resides. If
	// none is supplied, the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The name of the catalog database in which the table in question resides.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// A list of PartitionInput structures that define the partitions to be deleted.
	//
	// PartitionsToDelete is a required field
	PartitionsToDelete []*PartitionValueList `type:"list" required:"true"`

	// The name of the table where the partitions to be deleted is located.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s BatchDeletePartitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeletePartitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeletePartitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeletePartitionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.PartitionsToDelete == nil {
		invalidParams.Add(request.NewErrParamRequired("PartitionsToDelete"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}
	if s.PartitionsToDelete != nil {
		for i, v := range s.PartitionsToDelete {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PartitionsToDelete", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *BatchDeletePartitionInput) SetCatalogId(v string) *BatchDeletePartitionInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *BatchDeletePartitionInput) SetDatabaseName(v string) *BatchDeletePartitionInput {
	s.DatabaseName = &v
	return s
}

// SetPartitionsToDelete sets the PartitionsToDelete field's value.
func (s *BatchDeletePartitionInput) SetPartitionsToDelete(v []*PartitionValueList) *BatchDeletePartitionInput {
	s.PartitionsToDelete = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *BatchDeletePartitionInput) SetTableName(v string) *BatchDeletePartitionInput {
	s.TableName = &v
	return s
}

type BatchDeletePartitionOutput struct {
	_ struct{} `type:"structure"`

	// Errors encountered when trying to delete the requested partitions.
	Errors []*PartitionError `type:"list"`
}

// String returns the string representation
func (s BatchDeletePartitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeletePartitionOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchDeletePartitionOutput) SetErrors(v []*PartitionError) *BatchDeletePartitionOutput {
	s.Errors = v
	return s
}

type BatchDeleteTableInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the table resides. If none is supplied,
	// the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The name of the catalog database where the tables to delete reside. For Hive
	// compatibility, this name is entirely lowercase.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// A list of the table to delete.
	//
	// TablesToDelete is a required field
	TablesToDelete []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDeleteTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeleteTableInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.TablesToDelete == nil {
		invalidParams.Add(request.NewErrParamRequired("TablesToDelete"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *BatchDeleteTableInput) SetCatalogId(v string) *BatchDeleteTableInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *BatchDeleteTableInput) SetDatabaseName(v string) *BatchDeleteTableInput {
	s.DatabaseName = &v
	return s
}

// SetTablesToDelete sets the TablesToDelete field's value.
func (s *BatchDeleteTableInput) SetTablesToDelete(v []*string) *BatchDeleteTableInput {
	s.TablesToDelete = v
	return s
}

type BatchDeleteTableOutput struct {
	_ struct{} `type:"structure"`

	// A list of errors encountered in attempting to delete the specified tables.
	Errors []*TableError `type:"list"`
}

// String returns the string representation
func (s BatchDeleteTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteTableOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchDeleteTableOutput) SetErrors(v []*TableError) *BatchDeleteTableOutput {
	s.Errors = v
	return s
}

type BatchDeleteTableVersionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the tables reside. If none is supplied,
	// the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The database in the catalog in which the table resides. For Hive compatibility,
	// this name is entirely lowercase.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The name of the table. For Hive compatibility, this name is entirely lowercase.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`

	// A list of the IDs of versions to be deleted.
	//
	// VersionIds is a required field
	VersionIds []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDeleteTableVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteTableVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteTableVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeleteTableVersionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}
	if s.VersionIds == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *BatchDeleteTableVersionInput) SetCatalogId(v string) *BatchDeleteTableVersionInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *BatchDeleteTableVersionInput) SetDatabaseName(v string) *BatchDeleteTableVersionInput {
	s.DatabaseName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *BatchDeleteTableVersionInput) SetTableName(v string) *BatchDeleteTableVersionInput {
	s.TableName = &v
	return s
}

// SetVersionIds sets the VersionIds field's value.
func (s *BatchDeleteTableVersionInput) SetVersionIds(v []*string) *BatchDeleteTableVersionInput {
	s.VersionIds = v
	return s
}

type BatchDeleteTableVersionOutput struct {
	_ struct{} `type:"structure"`

	// A list of errors encountered while trying to delete the specified table versions.
	Errors []*TableVersionError `type:"list"`
}

// String returns the string representation
func (s BatchDeleteTableVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteTableVersionOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchDeleteTableVersionOutput) SetErrors(v []*TableVersionError) *BatchDeleteTableVersionOutput {
	s.Errors = v
	return s
}

type BatchGetPartitionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the partitions in question reside. If none
	// is supplied, the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The name of the catalog database where the partitions reside.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// A list of partition values identifying the partitions to retrieve.
	//
	// PartitionsToGet is a required field
	PartitionsToGet []*PartitionValueList `type:"list" required:"true"`

	// The name of the partitions' table.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s BatchGetPartitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetPartitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetPartitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetPartitionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.PartitionsToGet == nil {
		invalidParams.Add(request.NewErrParamRequired("PartitionsToGet"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}
	if s.PartitionsToGet != nil {
		for i, v := range s.PartitionsToGet {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PartitionsToGet", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *BatchGetPartitionInput) SetCatalogId(v string) *BatchGetPartitionInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *BatchGetPartitionInput) SetDatabaseName(v string) *BatchGetPartitionInput {
	s.DatabaseName = &v
	return s
}

// SetPartitionsToGet sets the PartitionsToGet field's value.
func (s *BatchGetPartitionInput) SetPartitionsToGet(v []*PartitionValueList) *BatchGetPartitionInput {
	s.PartitionsToGet = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *BatchGetPartitionInput) SetTableName(v string) *BatchGetPartitionInput {
	s.TableName = &v
	return s
}

type BatchGetPartitionOutput struct {
	_ struct{} `type:"structure"`

	// A list of the requested partitions.
	Partitions []*Partition `type:"list"`

	// A list of the partition values in the request for which partions were not
	// returned.
	UnprocessedKeys []*PartitionValueList `type:"list"`
}

// String returns the string representation
func (s BatchGetPartitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetPartitionOutput) GoString() string {
	return s.String()
}

// SetPartitions sets the Partitions field's value.
func (s *BatchGetPartitionOutput) SetPartitions(v []*Partition) *BatchGetPartitionOutput {
	s.Partitions = v
	return s
}

// SetUnprocessedKeys sets the UnprocessedKeys field's value.
func (s *BatchGetPartitionOutput) SetUnprocessedKeys(v []*PartitionValueList) *BatchGetPartitionOutput {
	s.UnprocessedKeys = v
	return s
}

// Records an error that occurred when attempting to stop a specified JobRun.
type BatchStopJobRunError struct {
	_ struct{} `type:"structure"`

	// Specifies details about the error that was encountered.
	ErrorDetail *ErrorDetail `type:"structure"`

	// The name of the Job in question.
	JobName *string `min:"1" type:"string"`

	// The JobRunId of the JobRun in question.
	JobRunId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s BatchStopJobRunError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchStopJobRunError) GoString() string {
	return s.String()
}

// SetErrorDetail sets the ErrorDetail field's value.
func (s *BatchStopJobRunError) SetErrorDetail(v *ErrorDetail) *BatchStopJobRunError {
	s.ErrorDetail = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *BatchStopJobRunError) SetJobName(v string) *BatchStopJobRunError {
	s.JobName = &v
	return s
}

// SetJobRunId sets the JobRunId field's value.
func (s *BatchStopJobRunError) SetJobRunId(v string) *BatchStopJobRunError {
	s.JobRunId = &v
	return s
}

type BatchStopJobRunInput struct {
	_ struct{} `type:"structure"`

	// The name of the Job in question.
	//
	// JobName is a required field
	JobName *string `min:"1" type:"string" required:"true"`

	// A list of the JobRunIds that should be stopped for that Job.
	//
	// JobRunIds is a required field
	JobRunIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchStopJobRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchStopJobRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchStopJobRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchStopJobRunInput"}
	if s.JobName == nil {
		invalidParams.Add(request.NewErrParamRequired("JobName"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.JobRunIds == nil {
		invalidParams.Add(request.NewErrParamRequired("JobRunIds"))
	}
	if s.JobRunIds != nil && len(s.JobRunIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobRunIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *BatchStopJobRunInput) SetJobName(v string) *BatchStopJobRunInput {
	s.JobName = &v
	return s
}

// SetJobRunIds sets the JobRunIds field's value.
func (s *BatchStopJobRunInput) SetJobRunIds(v []*string) *BatchStopJobRunInput {
	s.JobRunIds = v
	return s
}

type BatchStopJobRunOutput struct {
	_ struct{} `type:"structure"`

	// A list of the errors that were encountered in tryng to stop JobRuns, including
	// the JobRunId for which each error was encountered and details about the error.
	Errors []*BatchStopJobRunError `type:"list"`

	// A list of the JobRuns that were successfully submitted for stopping.
	SuccessfulSubmissions []*BatchStopJobRunSuccessfulSubmission `type:"list"`
}

// String returns the string representation
func (s BatchStopJobRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchStopJobRunOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchStopJobRunOutput) SetErrors(v []*BatchStopJobRunError) *BatchStopJobRunOutput {
	s.Errors = v
	return s
}

// SetSuccessfulSubmissions sets the SuccessfulSubmissions field's value.
func (s *BatchStopJobRunOutput) SetSuccessfulSubmissions(v []*BatchStopJobRunSuccessfulSubmission) *BatchStopJobRunOutput {
	s.SuccessfulSubmissions = v
	return s
}

// Records a successful request to stop a specified JobRun.
type BatchStopJobRunSuccessfulSubmission struct {
	_ struct{} `type:"structure"`

	// The Name of the Job in question.
	JobName *string `min:"1" type:"string"`

	// The JobRunId of the JobRun in question.
	JobRunId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s BatchStopJobRunSuccessfulSubmission) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchStopJobRunSuccessfulSubmission) GoString() string {
	return s.String()
}

// SetJobName sets the JobName field's value.
func (s *BatchStopJobRunSuccessfulSubmission) SetJobName(v string) *BatchStopJobRunSuccessfulSubmission {
	s.JobName = &v
	return s
}

// SetJobRunId sets the JobRunId field's value.
func (s *BatchStopJobRunSuccessfulSubmission) SetJobRunId(v string) *BatchStopJobRunSuccessfulSubmission {
	s.JobRunId = &v
	return s
}

// Specifies a table definition in the Data Catalog.
type CatalogEntry struct {
	_ struct{} `type:"structure"`

	// The database in which the table metadata resides.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The name of the table in question.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CatalogEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CatalogEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CatalogEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CatalogEntry"}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *CatalogEntry) SetDatabaseName(v string) *CatalogEntry {
	s.DatabaseName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *CatalogEntry) SetTableName(v string) *CatalogEntry {
	s.TableName = &v
	return s
}

// A structure containing migration status information.
type CatalogImportStatus struct {
	_ struct{} `type:"structure"`

	// True if the migration has completed, or False otherwise.
	ImportCompleted *bool `type:"boolean"`

	// The time that the migration was started.
	ImportTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name of the person who initiated the migration.
	ImportedBy *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CatalogImportStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CatalogImportStatus) GoString() string {
	return s.String()
}

// SetImportCompleted sets the ImportCompleted field's value.
func (s *CatalogImportStatus) SetImportCompleted(v bool) *CatalogImportStatus {
	s.ImportCompleted = &v
	return s
}

// SetImportTime sets the ImportTime field's value.
func (s *CatalogImportStatus) SetImportTime(v time.Time) *CatalogImportStatus {
	s.ImportTime = &v
	return s
}

// SetImportedBy sets the ImportedBy field's value.
func (s *CatalogImportStatus) SetImportedBy(v string) *CatalogImportStatus {
	s.ImportedBy = &v
	return s
}

// Classifiers are written in Python and triggered during a crawl task. You
// can write your own classifiers to best categorize your data sources and specify
// the appropriate schemas to use for them. A classifier checks whether a given
// file is in a format it can handle, and if it is, the classifier creates a
// schema in the form of a StructType object that matches that data format.
//
// A classifier can be a grok classifier, an XML classifier, or a JSON classifier,
// asspecified in one of the fields in the Classifier object.
type Classifier struct {
	_ struct{} `type:"structure"`

	// A GrokClassifier object.
	GrokClassifier *GrokClassifier `type:"structure"`

	// A JsonClassifier object.
	JsonClassifier *JsonClassifier `type:"structure"`

	// An XMLClassifier object.
	XMLClassifier *XMLClassifier `type:"structure"`
}

// String returns the string representation
func (s Classifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Classifier) GoString() string {
	return s.String()
}

// SetGrokClassifier sets the GrokClassifier field's value.
func (s *Classifier) SetGrokClassifier(v *GrokClassifier) *Classifier {
	s.GrokClassifier = v
	return s
}

// SetJsonClassifier sets the JsonClassifier field's value.
func (s *Classifier) SetJsonClassifier(v *JsonClassifier) *Classifier {
	s.JsonClassifier = v
	return s
}

// SetXMLClassifier sets the XMLClassifier field's value.
func (s *Classifier) SetXMLClassifier(v *XMLClassifier) *Classifier {
	s.XMLClassifier = v
	return s
}

// Represents a directional edge in a directed acyclic graph (DAG).
type CodeGenEdge struct {
	_ struct{} `type:"structure"`

	// The ID of the node at which the edge starts.
	//
	// Source is a required field
	Source *string `min:"1" type:"string" required:"true"`

	// The ID of the node at which the edge ends.
	//
	// Target is a required field
	Target *string `min:"1" type:"string" required:"true"`

	// The target of the edge.
	TargetParameter *string `type:"string"`
}

// String returns the string representation
func (s CodeGenEdge) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CodeGenEdge) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeGenEdge) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CodeGenEdge"}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Source != nil && len(*s.Source) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Source", 1))
	}
	if s.Target == nil {
		invalidParams.Add(request.NewErrParamRequired("Target"))
	}
	if s.Target != nil && len(*s.Target) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Target", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSource sets the Source field's value.
func (s *CodeGenEdge) SetSource(v string) *CodeGenEdge {
	s.Source = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *CodeGenEdge) SetTarget(v string) *CodeGenEdge {
	s.Target = &v
	return s
}

// SetTargetParameter sets the TargetParameter field's value.
func (s *CodeGenEdge) SetTargetParameter(v string) *CodeGenEdge {
	s.TargetParameter = &v
	return s
}

// Represents a node in a directed acyclic graph (DAG)
type CodeGenNode struct {
	_ struct{} `type:"structure"`

	// Properties of the node, in the form of name-value pairs.
	//
	// Args is a required field
	Args []*CodeGenNodeArg `type:"list" required:"true"`

	// A node identifier that is unique within the node's graph.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The line number of the node.
	LineNumber *int64 `type:"integer"`

	// The type of node this is.
	//
	// NodeType is a required field
	NodeType *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CodeGenNode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CodeGenNode) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeGenNode) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CodeGenNode"}
	if s.Args == nil {
		invalidParams.Add(request.NewErrParamRequired("Args"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.NodeType == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeType"))
	}
	if s.Args != nil {
		for i, v := range s.Args {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Args", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArgs sets the Args field's value.
func (s *CodeGenNode) SetArgs(v []*CodeGenNodeArg) *CodeGenNode {
	s.Args = v
	return s
}

// SetId sets the Id field's value.
func (s *CodeGenNode) SetId(v string) *CodeGenNode {
	s.Id = &v
	return s
}

// SetLineNumber sets the LineNumber field's value.
func (s *CodeGenNode) SetLineNumber(v int64) *CodeGenNode {
	s.LineNumber = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *CodeGenNode) SetNodeType(v string) *CodeGenNode {
	s.NodeType = &v
	return s
}

// An argument or property of a node.
type CodeGenNodeArg struct {
	_ struct{} `type:"structure"`

	// The name of the argument or property.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// True if the value is used as a parameter.
	Param *bool `type:"boolean"`

	// The value of the argument or property.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CodeGenNodeArg) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CodeGenNodeArg) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeGenNodeArg) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CodeGenNodeArg"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CodeGenNodeArg) SetName(v string) *CodeGenNodeArg {
	s.Name = &v
	return s
}

// SetParam sets the Param field's value.
func (s *CodeGenNodeArg) SetParam(v bool) *CodeGenNodeArg {
	s.Param = &v
	return s
}

// SetValue sets the Value field's value.
func (s *CodeGenNodeArg) SetValue(v string) *CodeGenNodeArg {
	s.Value = &v
	return s
}

// A column in a Table.
type Column struct {
	_ struct{} `type:"structure"`

	// Free-form text comment.
	Comment *string `type:"string"`

	// The name of the Column.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The datatype of data in the Column.
	Type *string `type:"string"`
}

// String returns the string representation
func (s Column) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Column) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Column) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Column"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComment sets the Comment field's value.
func (s *Column) SetComment(v string) *Column {
	s.Comment = &v
	return s
}

// SetName sets the Name field's value.
func (s *Column) SetName(v string) *Column {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *Column) SetType(v string) *Column {
	s.Type = &v
	return s
}

// Defines a condition under which a trigger fires.
type Condition struct {
	_ struct{} `type:"structure"`

	// The name of the Job to whose JobRuns this condition applies and on which
	// this trigger waits.
	JobName *string `min:"1" type:"string"`

	// A logical operator.
	LogicalOperator *string `type:"string" enum:"LogicalOperator"`

	// The condition state. Currently, the values supported are SUCCEEDED, STOPPED
	// and FAILED.
	State *string `type:"string" enum:"JobRunState"`
}

// String returns the string representation
func (s Condition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Condition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Condition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Condition"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *Condition) SetJobName(v string) *Condition {
	s.JobName = &v
	return s
}

// SetLogicalOperator sets the LogicalOperator field's value.
func (s *Condition) SetLogicalOperator(v string) *Condition {
	s.LogicalOperator = &v
	return s
}

// SetState sets the State field's value.
func (s *Condition) SetState(v string) *Condition {
	s.State = &v
	return s
}

// Defines a connection to a data source.
type Connection struct {
	_ struct{} `type:"structure"`

	// A list of key-value pairs used as parameters for this connection.
	ConnectionProperties map[string]*string `type:"map"`

	// The type of the connection. Currently, only JDBC is supported; SFTP is not
	// supported.
	ConnectionType *string `type:"string" enum:"ConnectionType"`

	// The time this connection definition was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Description of the connection.
	Description *string `type:"string"`

	// The user, group or role that last updated this connection definition.
	LastUpdatedBy *string `min:"1" type:"string"`

	// The last time this connection definition was updated.
	LastUpdatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A list of criteria that can be used in selecting this connection.
	MatchCriteria []*string `type:"list"`

	// The name of the connection definition.
	Name *string `min:"1" type:"string"`

	// A map of physical connection requirements, such as VPC and SecurityGroup,
	// needed for making this connection successfully.
	PhysicalConnectionRequirements *PhysicalConnectionRequirements `type:"structure"`
}

// String returns the string representation
func (s Connection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Connection) GoString() string {
	return s.String()
}

// SetConnectionProperties sets the ConnectionProperties field's value.
func (s *Connection) SetConnectionProperties(v map[string]*string) *Connection {
	s.ConnectionProperties = v
	return s
}

// SetConnectionType sets the ConnectionType field's value.
func (s *Connection) SetConnectionType(v string) *Connection {
	s.ConnectionType = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Connection) SetCreationTime(v time.Time) *Connection {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Connection) SetDescription(v string) *Connection {
	s.Description = &v
	return s
}

// SetLastUpdatedBy sets the LastUpdatedBy field's value.
func (s *Connection) SetLastUpdatedBy(v string) *Connection {
	s.LastUpdatedBy = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Connection) SetLastUpdatedTime(v time.Time) *Connection {
	s.LastUpdatedTime = &v
	return s
}

// SetMatchCriteria sets the MatchCriteria field's value.
func (s *Connection) SetMatchCriteria(v []*string) *Connection {
	s.MatchCriteria = v
	return s
}

// SetName sets the Name field's value.
func (s *Connection) SetName(v string) *Connection {
	s.Name = &v
	return s
}

// SetPhysicalConnectionRequirements sets the PhysicalConnectionRequirements field's value.
func (s *Connection) SetPhysicalConnectionRequirements(v *PhysicalConnectionRequirements) *Connection {
	s.PhysicalConnectionRequirements = v
	return s
}

// A structure used to specify a connection to create or update.
type ConnectionInput struct {
	_ struct{} `type:"structure"`

	// A list of key-value pairs used as parameters for this connection.
	//
	// ConnectionProperties is a required field
	ConnectionProperties map[string]*string `type:"map" required:"true"`

	// The type of the connection. Currently, only JDBC is supported; SFTP is not
	// supported.
	//
	// ConnectionType is a required field
	ConnectionType *string `type:"string" required:"true" enum:"ConnectionType"`

	// Description of the connection.
	Description *string `type:"string"`

	// A list of criteria that can be used in selecting this connection.
	MatchCriteria []*string `type:"list"`

	// The name of the connection.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A map of physical connection requirements, such as VPC and SecurityGroup,
	// needed for making this connection successfully.
	PhysicalConnectionRequirements *PhysicalConnectionRequirements `type:"structure"`
}

// String returns the string representation
func (s ConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConnectionInput"}
	if s.ConnectionProperties == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionProperties"))
	}
	if s.ConnectionType == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionType"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.PhysicalConnectionRequirements != nil {
		if err := s.PhysicalConnectionRequirements.Validate(); err != nil {
			invalidParams.AddNested("PhysicalConnectionRequirements", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionProperties sets the ConnectionProperties field's value.
func (s *ConnectionInput) SetConnectionProperties(v map[string]*string) *ConnectionInput {
	s.ConnectionProperties = v
	return s
}

// SetConnectionType sets the ConnectionType field's value.
func (s *ConnectionInput) SetConnectionType(v string) *ConnectionInput {
	s.ConnectionType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ConnectionInput) SetDescription(v string) *ConnectionInput {
	s.Description = &v
	return s
}

// SetMatchCriteria sets the MatchCriteria field's value.
func (s *ConnectionInput) SetMatchCriteria(v []*string) *ConnectionInput {
	s.MatchCriteria = v
	return s
}

// SetName sets the Name field's value.
func (s *ConnectionInput) SetName(v string) *ConnectionInput {
	s.Name = &v
	return s
}

// SetPhysicalConnectionRequirements sets the PhysicalConnectionRequirements field's value.
func (s *ConnectionInput) SetPhysicalConnectionRequirements(v *PhysicalConnectionRequirements) *ConnectionInput {
	s.PhysicalConnectionRequirements = v
	return s
}

// Specifies the connections used by a job.
type ConnectionsList struct {
	_ struct{} `type:"structure"`

	// A list of connections used by the job.
	Connections []*string `type:"list"`
}

// String returns the string representation
func (s ConnectionsList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectionsList) GoString() string {
	return s.String()
}

// SetConnections sets the Connections field's value.
func (s *ConnectionsList) SetConnections(v []*string) *ConnectionsList {
	s.Connections = v
	return s
}

// Specifies a crawler program that examines a data source and uses classifiers
// to try to determine its schema. If successful, the crawler records metadata
// concerning the data source in the AWS Glue Data Catalog.
type Crawler struct {
	_ struct{} `type:"structure"`

	// A list of custom classifiers associated with the crawler.
	Classifiers []*string `type:"list"`

	// Crawler configuration information. This versioned JSON string allows users
	// to specify aspects of a Crawler's behavior.
	//
	// You can use this field to force partitions to inherit metadata such as classification,
	// input format, output format, serde information, and schema from their parent
	// table, rather than detect this information separately for each partition.
	// Use the following JSON string to specify that behavior:
	//
	// Example: '{ "Version": 1.0, "CrawlerOutput": { "Partitions": { "AddOrUpdateBehavior":
	// "InheritFromTable" } } }'
	Configuration *string `type:"string"`

	// If the crawler is running, contains the total time elapsed since the last
	// crawl began.
	CrawlElapsedTime *int64 `type:"long"`

	// The time when the crawler was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The database where metadata is written by this crawler.
	DatabaseName *string `type:"string"`

	// A description of the crawler.
	Description *string `type:"string"`

	// The status of the last crawl, and potentially error information if an error
	// occurred.
	LastCrawl *LastCrawlInfo `type:"structure"`

	// The time the crawler was last updated.
	LastUpdated *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The crawler name.
	Name *string `min:"1" type:"string"`

	// The IAM role (or ARN of an IAM role) used to access customer resources, such
	// as data in Amazon S3.
	Role *string `type:"string"`

	// For scheduled crawlers, the schedule when the crawler runs.
	Schedule *Schedule `type:"structure"`

	// Sets the behavior when the crawler finds a changed or deleted object.
	SchemaChangePolicy *SchemaChangePolicy `type:"structure"`

	// Indicates whether the crawler is running, or whether a run is pending.
	State *string `type:"string" enum:"CrawlerState"`

	// The prefix added to the names of tables that are created.
	TablePrefix *string `type:"string"`

	// A collection of targets to crawl.
	Targets *CrawlerTargets `type:"structure"`

	// The version of the crawler.
	Version *int64 `type:"long"`
}

// String returns the string representation
func (s Crawler) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Crawler) GoString() string {
	return s.String()
}

// SetClassifiers sets the Classifiers field's value.
func (s *Crawler) SetClassifiers(v []*string) *Crawler {
	s.Classifiers = v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *Crawler) SetConfiguration(v string) *Crawler {
	s.Configuration = &v
	return s
}

// SetCrawlElapsedTime sets the CrawlElapsedTime field's value.
func (s *Crawler) SetCrawlElapsedTime(v int64) *Crawler {
	s.CrawlElapsedTime = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Crawler) SetCreationTime(v time.Time) *Crawler {
	s.CreationTime = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *Crawler) SetDatabaseName(v string) *Crawler {
	s.DatabaseName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Crawler) SetDescription(v string) *Crawler {
	s.Description = &v
	return s
}

// SetLastCrawl sets the LastCrawl field's value.
func (s *Crawler) SetLastCrawl(v *LastCrawlInfo) *Crawler {
	s.LastCrawl = v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *Crawler) SetLastUpdated(v time.Time) *Crawler {
	s.LastUpdated = &v
	return s
}

// SetName sets the Name field's value.
func (s *Crawler) SetName(v string) *Crawler {
	s.Name = &v
	return s
}

// SetRole sets the Role field's value.
func (s *Crawler) SetRole(v string) *Crawler {
	s.Role = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *Crawler) SetSchedule(v *Schedule) *Crawler {
	s.Schedule = v
	return s
}

// SetSchemaChangePolicy sets the SchemaChangePolicy field's value.
func (s *Crawler) SetSchemaChangePolicy(v *SchemaChangePolicy) *Crawler {
	s.SchemaChangePolicy = v
	return s
}

// SetState sets the State field's value.
func (s *Crawler) SetState(v string) *Crawler {
	s.State = &v
	return s
}

// SetTablePrefix sets the TablePrefix field's value.
func (s *Crawler) SetTablePrefix(v string) *Crawler {
	s.TablePrefix = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *Crawler) SetTargets(v *CrawlerTargets) *Crawler {
	s.Targets = v
	return s
}

// SetVersion sets the Version field's value.
func (s *Crawler) SetVersion(v int64) *Crawler {
	s.Version = &v
	return s
}

// Metrics for a specified crawler.
type CrawlerMetrics struct {
	_ struct{} `type:"structure"`

	// The name of the crawler.
	CrawlerName *string `min:"1" type:"string"`

	// The duration of the crawler's most recent run, in seconds.
	LastRuntimeSeconds *float64 `type:"double"`

	// The median duration of this crawler's runs, in seconds.
	MedianRuntimeSeconds *float64 `type:"double"`

	// True if the crawler is still estimating how long it will take to complete
	// this run.
	StillEstimating *bool `type:"boolean"`

	// The number of tables created by this crawler.
	TablesCreated *int64 `type:"integer"`

	// The number of tables deleted by this crawler.
	TablesDeleted *int64 `type:"integer"`

	// The number of tables updated by this crawler.
	TablesUpdated *int64 `type:"integer"`

	// The estimated time left to complete a running crawl.
	TimeLeftSeconds *float64 `type:"double"`
}

// String returns the string representation
func (s CrawlerMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CrawlerMetrics) GoString() string {
	return s.String()
}

// SetCrawlerName sets the CrawlerName field's value.
func (s *CrawlerMetrics) SetCrawlerName(v string) *CrawlerMetrics {
	s.CrawlerName = &v
	return s
}

// SetLastRuntimeSeconds sets the LastRuntimeSeconds field's value.
func (s *CrawlerMetrics) SetLastRuntimeSeconds(v float64) *CrawlerMetrics {
	s.LastRuntimeSeconds = &v
	return s
}

// SetMedianRuntimeSeconds sets the MedianRuntimeSeconds field's value.
func (s *CrawlerMetrics) SetMedianRuntimeSeconds(v float64) *CrawlerMetrics {
	s.MedianRuntimeSeconds = &v
	return s
}

// SetStillEstimating sets the StillEstimating field's value.
func (s *CrawlerMetrics) SetStillEstimating(v bool) *CrawlerMetrics {
	s.StillEstimating = &v
	return s
}

// SetTablesCreated sets the TablesCreated field's value.
func (s *CrawlerMetrics) SetTablesCreated(v int64) *CrawlerMetrics {
	s.TablesCreated = &v
	return s
}

// SetTablesDeleted sets the TablesDeleted field's value.
func (s *CrawlerMetrics) SetTablesDeleted(v int64) *CrawlerMetrics {
	s.TablesDeleted = &v
	return s
}

// SetTablesUpdated sets the TablesUpdated field's value.
func (s *CrawlerMetrics) SetTablesUpdated(v int64) *CrawlerMetrics {
	s.TablesUpdated = &v
	return s
}

// SetTimeLeftSeconds sets the TimeLeftSeconds field's value.
func (s *CrawlerMetrics) SetTimeLeftSeconds(v float64) *CrawlerMetrics {
	s.TimeLeftSeconds = &v
	return s
}

// Specifies data stores to crawl.
type CrawlerTargets struct {
	_ struct{} `type:"structure"`

	// Specifies JDBC targets.
	JdbcTargets []*JdbcTarget `type:"list"`

	// Specifies Amazon S3 targets.
	S3Targets []*S3Target `type:"list"`
}

// String returns the string representation
func (s CrawlerTargets) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CrawlerTargets) GoString() string {
	return s.String()
}

// SetJdbcTargets sets the JdbcTargets field's value.
func (s *CrawlerTargets) SetJdbcTargets(v []*JdbcTarget) *CrawlerTargets {
	s.JdbcTargets = v
	return s
}

// SetS3Targets sets the S3Targets field's value.
func (s *CrawlerTargets) SetS3Targets(v []*S3Target) *CrawlerTargets {
	s.S3Targets = v
	return s
}

type CreateClassifierInput struct {
	_ struct{} `type:"structure"`

	// A GrokClassifier object specifying the classifier to create.
	GrokClassifier *CreateGrokClassifierRequest `type:"structure"`

	// A JsonClassifier object specifying the classifier to create.
	JsonClassifier *CreateJsonClassifierRequest `type:"structure"`

	// An XMLClassifier object specifying the classifier to create.
	XMLClassifier *CreateXMLClassifierRequest `type:"structure"`
}

// String returns the string representation
func (s CreateClassifierInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClassifierInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClassifierInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateClassifierInput"}
	if s.GrokClassifier != nil {
		if err := s.GrokClassifier.Validate(); err != nil {
			invalidParams.AddNested("GrokClassifier", err.(request.ErrInvalidParams))
		}
	}
	if s.JsonClassifier != nil {
		if err := s.JsonClassifier.Validate(); err != nil {
			invalidParams.AddNested("JsonClassifier", err.(request.ErrInvalidParams))
		}
	}
	if s.XMLClassifier != nil {
		if err := s.XMLClassifier.Validate(); err != nil {
			invalidParams.AddNested("XMLClassifier", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrokClassifier sets the GrokClassifier field's value.
func (s *CreateClassifierInput) SetGrokClassifier(v *CreateGrokClassifierRequest) *CreateClassifierInput {
	s.GrokClassifier = v
	return s
}

// SetJsonClassifier sets the JsonClassifier field's value.
func (s *CreateClassifierInput) SetJsonClassifier(v *CreateJsonClassifierRequest) *CreateClassifierInput {
	s.JsonClassifier = v
	return s
}

// SetXMLClassifier sets the XMLClassifier field's value.
func (s *CreateClassifierInput) SetXMLClassifier(v *CreateXMLClassifierRequest) *CreateClassifierInput {
	s.XMLClassifier = v
	return s
}

type CreateClassifierOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateClassifierOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClassifierOutput) GoString() string {
	return s.String()
}

type CreateConnectionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog in which to create the connection. If none is
	// supplied, the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// A ConnectionInput object defining the connection to create.
	//
	// ConnectionInput is a required field
	ConnectionInput *ConnectionInput `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConnectionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.ConnectionInput == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionInput"))
	}
	if s.ConnectionInput != nil {
		if err := s.ConnectionInput.Validate(); err != nil {
			invalidParams.AddNested("ConnectionInput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *CreateConnectionInput) SetCatalogId(v string) *CreateConnectionInput {
	s.CatalogId = &v
	return s
}

// SetConnectionInput sets the ConnectionInput field's value.
func (s *CreateConnectionInput) SetConnectionInput(v *ConnectionInput) *CreateConnectionInput {
	s.ConnectionInput = v
	return s
}

type CreateConnectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConnectionOutput) GoString() string {
	return s.String()
}

type CreateCrawlerInput struct {
	_ struct{} `type:"structure"`

	// A list of custom classifiers that the user has registered. By default, all
	// AWS classifiers are included in a crawl, but these custom classifiers always
	// override the default classifiers for a given classification.
	Classifiers []*string `type:"list"`

	// Crawler configuration information. This versioned JSON string allows users
	// to specify aspects of a Crawler's behavior.
	//
	// You can use this field to force partitions to inherit metadata such as classification,
	// input format, output format, serde information, and schema from their parent
	// table, rather than detect this information separately for each partition.
	// Use the following JSON string to specify that behavior:
	//
	// Example: '{ "Version": 1.0, "CrawlerOutput": { "Partitions": { "AddOrUpdateBehavior":
	// "InheritFromTable" } } }'
	Configuration *string `type:"string"`

	// The AWS Glue database where results are written, such as: arn:aws:daylight:us-east-1::database/sometable/*.
	//
	// DatabaseName is a required field
	DatabaseName *string `type:"string" required:"true"`

	// A description of the new crawler.
	Description *string `type:"string"`

	// Name of the new crawler.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The IAM role (or ARN of an IAM role) used by the new crawler to access customer
	// resources.
	//
	// Role is a required field
	Role *string `type:"string" required:"true"`

	// A cron expression used to specify the schedule (see Time-Based Schedules
	// for Jobs and Crawlers (http://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html).
	// For example, to run something every day at 12:15 UTC, you would specify:
	// cron(15 12 * * ? *).
	Schedule *string `type:"string"`

	// Policy for the crawler's update and deletion behavior.
	SchemaChangePolicy *SchemaChangePolicy `type:"structure"`

	// The table prefix used for catalog tables that are created.
	TablePrefix *string `type:"string"`

	// A list of collection of targets to crawl.
	//
	// Targets is a required field
	Targets *CrawlerTargets `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateCrawlerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCrawlerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCrawlerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCrawlerInput"}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Role == nil {
		invalidParams.Add(request.NewErrParamRequired("Role"))
	}
	if s.Targets == nil {
		invalidParams.Add(request.NewErrParamRequired("Targets"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClassifiers sets the Classifiers field's value.
func (s *CreateCrawlerInput) SetClassifiers(v []*string) *CreateCrawlerInput {
	s.Classifiers = v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateCrawlerInput) SetConfiguration(v string) *CreateCrawlerInput {
	s.Configuration = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *CreateCrawlerInput) SetDatabaseName(v string) *CreateCrawlerInput {
	s.DatabaseName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateCrawlerInput) SetDescription(v string) *CreateCrawlerInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCrawlerInput) SetName(v string) *CreateCrawlerInput {
	s.Name = &v
	return s
}

// SetRole sets the Role field's value.
func (s *CreateCrawlerInput) SetRole(v string) *CreateCrawlerInput {
	s.Role = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *CreateCrawlerInput) SetSchedule(v string) *CreateCrawlerInput {
	s.Schedule = &v
	return s
}

// SetSchemaChangePolicy sets the SchemaChangePolicy field's value.
func (s *CreateCrawlerInput) SetSchemaChangePolicy(v *SchemaChangePolicy) *CreateCrawlerInput {
	s.SchemaChangePolicy = v
	return s
}

// SetTablePrefix sets the TablePrefix field's value.
func (s *CreateCrawlerInput) SetTablePrefix(v string) *CreateCrawlerInput {
	s.TablePrefix = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *CreateCrawlerInput) SetTargets(v *CrawlerTargets) *CreateCrawlerInput {
	s.Targets = v
	return s
}

type CreateCrawlerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateCrawlerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCrawlerOutput) GoString() string {
	return s.String()
}

type CreateDatabaseInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog in which to create the database. If none is supplied,
	// the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// A DatabaseInput object defining the metadata database to create in the catalog.
	//
	// DatabaseInput is a required field
	DatabaseInput *DatabaseInput `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateDatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDatabaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDatabaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDatabaseInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseInput == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseInput"))
	}
	if s.DatabaseInput != nil {
		if err := s.DatabaseInput.Validate(); err != nil {
			invalidParams.AddNested("DatabaseInput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *CreateDatabaseInput) SetCatalogId(v string) *CreateDatabaseInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseInput sets the DatabaseInput field's value.
func (s *CreateDatabaseInput) SetDatabaseInput(v *DatabaseInput) *CreateDatabaseInput {
	s.DatabaseInput = v
	return s
}

type CreateDatabaseOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateDatabaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDatabaseOutput) GoString() string {
	return s.String()
}

type CreateDevEndpointInput struct {
	_ struct{} `type:"structure"`

	// The name to be assigned to the new DevEndpoint.
	//
	// EndpointName is a required field
	EndpointName *string `type:"string" required:"true"`

	// Path to one or more Java Jars in an S3 bucket that should be loaded in your
	// DevEndpoint.
	ExtraJarsS3Path *string `type:"string"`

	// Path(s) to one or more Python libraries in an S3 bucket that should be loaded
	// in your DevEndpoint. Multiple values must be complete paths separated by
	// a comma.
	//
	// Please note that only pure Python libraries can currently be used on a DevEndpoint.
	// Libraries that rely on C extensions, such as the pandas (http://pandas.pydata.org/)
	// Python data analysis library, are not yet supported.
	ExtraPythonLibsS3Path *string `type:"string"`

	// The number of AWS Glue Data Processing Units (DPUs) to allocate to this DevEndpoint.
	NumberOfNodes *int64 `type:"integer"`

	// The public key to use for authentication.
	PublicKey *string `type:"string"`

	// The IAM role for the DevEndpoint.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`

	// Security group IDs for the security groups to be used by the new DevEndpoint.
	SecurityGroupIds []*string `type:"list"`

	// The subnet ID for the new DevEndpoint to use.
	SubnetId *string `type:"string"`
}

// String returns the string representation
func (s CreateDevEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDevEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDevEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDevEndpointInput"}
	if s.EndpointName == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointName"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointName sets the EndpointName field's value.
func (s *CreateDevEndpointInput) SetEndpointName(v string) *CreateDevEndpointInput {
	s.EndpointName = &v
	return s
}

// SetExtraJarsS3Path sets the ExtraJarsS3Path field's value.
func (s *CreateDevEndpointInput) SetExtraJarsS3Path(v string) *CreateDevEndpointInput {
	s.ExtraJarsS3Path = &v
	return s
}

// SetExtraPythonLibsS3Path sets the ExtraPythonLibsS3Path field's value.
func (s *CreateDevEndpointInput) SetExtraPythonLibsS3Path(v string) *CreateDevEndpointInput {
	s.ExtraPythonLibsS3Path = &v
	return s
}

// SetNumberOfNodes sets the NumberOfNodes field's value.
func (s *CreateDevEndpointInput) SetNumberOfNodes(v int64) *CreateDevEndpointInput {
	s.NumberOfNodes = &v
	return s
}

// SetPublicKey sets the PublicKey field's value.
func (s *CreateDevEndpointInput) SetPublicKey(v string) *CreateDevEndpointInput {
	s.PublicKey = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateDevEndpointInput) SetRoleArn(v string) *CreateDevEndpointInput {
	s.RoleArn = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *CreateDevEndpointInput) SetSecurityGroupIds(v []*string) *CreateDevEndpointInput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *CreateDevEndpointInput) SetSubnetId(v string) *CreateDevEndpointInput {
	s.SubnetId = &v
	return s
}

type CreateDevEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The AWS availability zone where this DevEndpoint is located.
	AvailabilityZone *string `type:"string"`

	// The point in time at which this DevEndpoint was created.
	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name assigned to the new DevEndpoint.
	EndpointName *string `type:"string"`

	// Path to one or more Java Jars in an S3 bucket that will be loaded in your
	// DevEndpoint.
	ExtraJarsS3Path *string `type:"string"`

	// Path(s) to one or more Python libraries in an S3 bucket that will be loaded
	// in your DevEndpoint.
	ExtraPythonLibsS3Path *string `type:"string"`

	// The reason for a current failure in this DevEndpoint.
	FailureReason *string `type:"string"`

	// The number of AWS Glue Data Processing Units (DPUs) allocated to this DevEndpoint.
	NumberOfNodes *int64 `type:"integer"`

	// The AWS ARN of the role assigned to the new DevEndpoint.
	RoleArn *string `type:"string"`

	// The security groups assigned to the new DevEndpoint.
	SecurityGroupIds []*string `type:"list"`

	// The current status of the new DevEndpoint.
	Status *string `type:"string"`

	// The subnet ID assigned to the new DevEndpoint.
	SubnetId *string `type:"string"`

	// The ID of the VPC used by this DevEndpoint.
	VpcId *string `type:"string"`

	// The address of the YARN endpoint used by this DevEndpoint.
	YarnEndpointAddress *string `type:"string"`

	// The Apache Zeppelin port for the remote Apache Spark interpreter.
	ZeppelinRemoteSparkInterpreterPort *int64 `type:"integer"`
}

// String returns the string representation
func (s CreateDevEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDevEndpointOutput) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateDevEndpointOutput) SetAvailabilityZone(v string) *CreateDevEndpointOutput {
	s.AvailabilityZone = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *CreateDevEndpointOutput) SetCreatedTimestamp(v time.Time) *CreateDevEndpointOutput {
	s.CreatedTimestamp = &v
	return s
}

// SetEndpointName sets the EndpointName field's value.
func (s *CreateDevEndpointOutput) SetEndpointName(v string) *CreateDevEndpointOutput {
	s.EndpointName = &v
	return s
}

// SetExtraJarsS3Path sets the ExtraJarsS3Path field's value.
func (s *CreateDevEndpointOutput) SetExtraJarsS3Path(v string) *CreateDevEndpointOutput {
	s.ExtraJarsS3Path = &v
	return s
}

// SetExtraPythonLibsS3Path sets the ExtraPythonLibsS3Path field's value.
func (s *CreateDevEndpointOutput) SetExtraPythonLibsS3Path(v string) *CreateDevEndpointOutput {
	s.ExtraPythonLibsS3Path = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *CreateDevEndpointOutput) SetFailureReason(v string) *CreateDevEndpointOutput {
	s.FailureReason = &v
	return s
}

// SetNumberOfNodes sets the NumberOfNodes field's value.
func (s *CreateDevEndpointOutput) SetNumberOfNodes(v int64) *CreateDevEndpointOutput {
	s.NumberOfNodes = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateDevEndpointOutput) SetRoleArn(v string) *CreateDevEndpointOutput {
	s.RoleArn = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *CreateDevEndpointOutput) SetSecurityGroupIds(v []*string) *CreateDevEndpointOutput {
	s.SecurityGroupIds = v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateDevEndpointOutput) SetStatus(v string) *CreateDevEndpointOutput {
	s.Status = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *CreateDevEndpointOutput) SetSubnetId(v string) *CreateDevEndpointOutput {
	s.SubnetId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateDevEndpointOutput) SetVpcId(v string) *CreateDevEndpointOutput {
	s.VpcId = &v
	return s
}

// SetYarnEndpointAddress sets the YarnEndpointAddress field's value.
func (s *CreateDevEndpointOutput) SetYarnEndpointAddress(v string) *CreateDevEndpointOutput {
	s.YarnEndpointAddress = &v
	return s
}

// SetZeppelinRemoteSparkInterpreterPort sets the ZeppelinRemoteSparkInterpreterPort field's value.
func (s *CreateDevEndpointOutput) SetZeppelinRemoteSparkInterpreterPort(v int64) *CreateDevEndpointOutput {
	s.ZeppelinRemoteSparkInterpreterPort = &v
	return s
}

// Specifies a grok classifier for CreateClassifier to create.
type CreateGrokClassifierRequest struct {
	_ struct{} `type:"structure"`

	// An identifier of the data format that the classifier matches, such as Twitter,
	// JSON, Omniture logs, Amazon CloudWatch Logs, and so on.
	//
	// Classification is a required field
	Classification *string `type:"string" required:"true"`

	// Optional custom grok patterns used by this classifier.
	CustomPatterns *string `type:"string"`

	// The grok pattern used by this classifier.
	//
	// GrokPattern is a required field
	GrokPattern *string `min:"1" type:"string" required:"true"`

	// The name of the new classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateGrokClassifierRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGrokClassifierRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGrokClassifierRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGrokClassifierRequest"}
	if s.Classification == nil {
		invalidParams.Add(request.NewErrParamRequired("Classification"))
	}
	if s.GrokPattern == nil {
		invalidParams.Add(request.NewErrParamRequired("GrokPattern"))
	}
	if s.GrokPattern != nil && len(*s.GrokPattern) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GrokPattern", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClassification sets the Classification field's value.
func (s *CreateGrokClassifierRequest) SetClassification(v string) *CreateGrokClassifierRequest {
	s.Classification = &v
	return s
}

// SetCustomPatterns sets the CustomPatterns field's value.
func (s *CreateGrokClassifierRequest) SetCustomPatterns(v string) *CreateGrokClassifierRequest {
	s.CustomPatterns = &v
	return s
}

// SetGrokPattern sets the GrokPattern field's value.
func (s *CreateGrokClassifierRequest) SetGrokPattern(v string) *CreateGrokClassifierRequest {
	s.GrokPattern = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateGrokClassifierRequest) SetName(v string) *CreateGrokClassifierRequest {
	s.Name = &v
	return s
}

type CreateJobInput struct {
	_ struct{} `type:"structure"`

	// The number of AWS Glue data processing units (DPUs) to allocate to this Job.
	// From 2 to 100 DPUs can be allocated; the default is 10. A DPU is a relative
	// measure of processing power that consists of 4 vCPUs of compute capacity
	// and 16 GB of memory. For more information, see the AWS Glue pricing page
	// (https://aws.amazon.com/glue/pricing/).
	AllocatedCapacity *int64 `type:"integer"`

	// The JobCommand that executes this job.
	//
	// Command is a required field
	Command *JobCommand `type:"structure" required:"true"`

	// The connections used for this job.
	Connections *ConnectionsList `type:"structure"`

	// The default arguments for this job.
	//
	// You can specify arguments here that your own job-execution script consumes,
	// as well as arguments that AWS Glue itself consumes.
	//
	// For information about how to specify and consume your own Job arguments,
	// see the Calling AWS Glue APIs in Python (http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html)
	// topic in the developer guide.
	//
	// For information about the key-value pairs that AWS Glue consumes to set up
	// your job, see the Special Parameters Used by AWS Glue (http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-glue-arguments.html)
	// topic in the developer guide.
	DefaultArguments map[string]*string `type:"map"`

	// Description of the job.
	Description *string `type:"string"`

	// An ExecutionProperty specifying the maximum number of concurrent runs allowed
	// for this job.
	ExecutionProperty *ExecutionProperty `type:"structure"`

	// This field is reserved for future use.
	LogUri *string `type:"string"`

	// The maximum number of times to retry this job if it fails.
	MaxRetries *int64 `type:"integer"`

	// The name you assign to this job. It must be unique in your account.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The name of the IAM role associated with this job.
	//
	// Role is a required field
	Role *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateJobInput"}
	if s.Command == nil {
		invalidParams.Add(request.NewErrParamRequired("Command"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Role == nil {
		invalidParams.Add(request.NewErrParamRequired("Role"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllocatedCapacity sets the AllocatedCapacity field's value.
func (s *CreateJobInput) SetAllocatedCapacity(v int64) *CreateJobInput {
	s.AllocatedCapacity = &v
	return s
}

// SetCommand sets the Command field's value.
func (s *CreateJobInput) SetCommand(v *JobCommand) *CreateJobInput {
	s.Command = v
	return s
}

// SetConnections sets the Connections field's value.
func (s *CreateJobInput) SetConnections(v *ConnectionsList) *CreateJobInput {
	s.Connections = v
	return s
}

// SetDefaultArguments sets the DefaultArguments field's value.
func (s *CreateJobInput) SetDefaultArguments(v map[string]*string) *CreateJobInput {
	s.DefaultArguments = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateJobInput) SetDescription(v string) *CreateJobInput {
	s.Description = &v
	return s
}

// SetExecutionProperty sets the ExecutionProperty field's value.
func (s *CreateJobInput) SetExecutionProperty(v *ExecutionProperty) *CreateJobInput {
	s.ExecutionProperty = v
	return s
}

// SetLogUri sets the LogUri field's value.
func (s *CreateJobInput) SetLogUri(v string) *CreateJobInput {
	s.LogUri = &v
	return s
}

// SetMaxRetries sets the MaxRetries field's value.
func (s *CreateJobInput) SetMaxRetries(v int64) *CreateJobInput {
	s.MaxRetries = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateJobInput) SetName(v string) *CreateJobInput {
	s.Name = &v
	return s
}

// SetRole sets the Role field's value.
func (s *CreateJobInput) SetRole(v string) *CreateJobInput {
	s.Role = &v
	return s
}

type CreateJobOutput struct {
	_ struct{} `type:"structure"`

	// The unique name that was provided.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateJobOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *CreateJobOutput) SetName(v string) *CreateJobOutput {
	s.Name = &v
	return s
}

// Specifies a JSON classifier for CreateClassifier to create.
type CreateJsonClassifierRequest struct {
	_ struct{} `type:"structure"`

	// A JsonPath string defining the JSON data for the classifier to classify.
	// AWS Glue supports a subset of JsonPath, as described in Writing JsonPath
	// Custom Classifiers (https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json).
	//
	// JsonPath is a required field
	JsonPath *string `type:"string" required:"true"`

	// The name of the classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateJsonClassifierRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateJsonClassifierRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateJsonClassifierRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateJsonClassifierRequest"}
	if s.JsonPath == nil {
		invalidParams.Add(request.NewErrParamRequired("JsonPath"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJsonPath sets the JsonPath field's value.
func (s *CreateJsonClassifierRequest) SetJsonPath(v string) *CreateJsonClassifierRequest {
	s.JsonPath = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateJsonClassifierRequest) SetName(v string) *CreateJsonClassifierRequest {
	s.Name = &v
	return s
}

type CreatePartitionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the catalog in which the partion is to be created. Currently, this
	// should be the AWS account ID.
	CatalogId *string `min:"1" type:"string"`

	// The name of the metadata database in which the partition is to be created.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// A PartitionInput structure defining the partition to be created.
	//
	// PartitionInput is a required field
	PartitionInput *PartitionInput `type:"structure" required:"true"`

	// The name of the metadata table in which the partition is to be created.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePartitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePartitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePartitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePartitionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.PartitionInput == nil {
		invalidParams.Add(request.NewErrParamRequired("PartitionInput"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}
	if s.PartitionInput != nil {
		if err := s.PartitionInput.Validate(); err != nil {
			invalidParams.AddNested("PartitionInput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *CreatePartitionInput) SetCatalogId(v string) *CreatePartitionInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *CreatePartitionInput) SetDatabaseName(v string) *CreatePartitionInput {
	s.DatabaseName = &v
	return s
}

// SetPartitionInput sets the PartitionInput field's value.
func (s *CreatePartitionInput) SetPartitionInput(v *PartitionInput) *CreatePartitionInput {
	s.PartitionInput = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *CreatePartitionInput) SetTableName(v string) *CreatePartitionInput {
	s.TableName = &v
	return s
}

type CreatePartitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreatePartitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePartitionOutput) GoString() string {
	return s.String()
}

type CreateScriptInput struct {
	_ struct{} `type:"structure"`

	// A list of the edges in the DAG.
	DagEdges []*CodeGenEdge `type:"list"`

	// A list of the nodes in the DAG.
	DagNodes []*CodeGenNode `type:"list"`

	// The programming language of the resulting code from the DAG.
	Language *string `type:"string" enum:"Language"`
}

// String returns the string representation
func (s CreateScriptInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateScriptInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateScriptInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateScriptInput"}
	if s.DagEdges != nil {
		for i, v := range s.DagEdges {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DagEdges", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DagNodes != nil {
		for i, v := range s.DagNodes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DagNodes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDagEdges sets the DagEdges field's value.
func (s *CreateScriptInput) SetDagEdges(v []*CodeGenEdge) *CreateScriptInput {
	s.DagEdges = v
	return s
}

// SetDagNodes sets the DagNodes field's value.
func (s *CreateScriptInput) SetDagNodes(v []*CodeGenNode) *CreateScriptInput {
	s.DagNodes = v
	return s
}

// SetLanguage sets the Language field's value.
func (s *CreateScriptInput) SetLanguage(v string) *CreateScriptInput {
	s.Language = &v
	return s
}

type CreateScriptOutput struct {
	_ struct{} `type:"structure"`

	// The Python script generated from the DAG.
	PythonScript *string `type:"string"`

	// The Scala code generated from the DAG.
	ScalaCode *string `type:"string"`
}

// String returns the string representation
func (s CreateScriptOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateScriptOutput) GoString() string {
	return s.String()
}

// SetPythonScript sets the PythonScript field's value.
func (s *CreateScriptOutput) SetPythonScript(v string) *CreateScriptOutput {
	s.PythonScript = &v
	return s
}

// SetScalaCode sets the ScalaCode field's value.
func (s *CreateScriptOutput) SetScalaCode(v string) *CreateScriptOutput {
	s.ScalaCode = &v
	return s
}

type CreateTableInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog in which to create the Table. If none is supplied,
	// the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The catalog database in which to create the new table. For Hive compatibility,
	// this name is entirely lowercase.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The TableInput object that defines the metadata table to create in the catalog.
	//
	// TableInput is a required field
	TableInput *TableInput `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTableInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.TableInput == nil {
		invalidParams.Add(request.NewErrParamRequired("TableInput"))
	}
	if s.TableInput != nil {
		if err := s.TableInput.Validate(); err != nil {
			invalidParams.AddNested("TableInput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *CreateTableInput) SetCatalogId(v string) *CreateTableInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *CreateTableInput) SetDatabaseName(v string) *CreateTableInput {
	s.DatabaseName = &v
	return s
}

// SetTableInput sets the TableInput field's value.
func (s *CreateTableInput) SetTableInput(v *TableInput) *CreateTableInput {
	s.TableInput = v
	return s
}

type CreateTableOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTableOutput) GoString() string {
	return s.String()
}

type CreateTriggerInput struct {
	_ struct{} `type:"structure"`

	// The actions initiated by this trigger when it fires.
	//
	// Actions is a required field
	Actions []*Action `type:"list" required:"true"`

	// A description of the new trigger.
	Description *string `type:"string"`

	// The name of the trigger.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A predicate to specify when the new trigger should fire.
	//
	// This field is required when the trigger type is CONDITIONAL.
	Predicate *Predicate `type:"structure"`

	// A cron expression used to specify the schedule (see Time-Based Schedules
	// for Jobs and Crawlers (http://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html).
	// For example, to run something every day at 12:15 UTC, you would specify:
	// cron(15 12 * * ? *).
	//
	// This field is required when the trigger type is SCHEDULED.
	Schedule *string `type:"string"`

	// The type of the new trigger.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"TriggerType"`
}

// String returns the string representation
func (s CreateTriggerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTriggerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTriggerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTriggerInput"}
	if s.Actions == nil {
		invalidParams.Add(request.NewErrParamRequired("Actions"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Predicate != nil {
		if err := s.Predicate.Validate(); err != nil {
			invalidParams.AddNested("Predicate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *CreateTriggerInput) SetActions(v []*Action) *CreateTriggerInput {
	s.Actions = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateTriggerInput) SetDescription(v string) *CreateTriggerInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateTriggerInput) SetName(v string) *CreateTriggerInput {
	s.Name = &v
	return s
}

// SetPredicate sets the Predicate field's value.
func (s *CreateTriggerInput) SetPredicate(v *Predicate) *CreateTriggerInput {
	s.Predicate = v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *CreateTriggerInput) SetSchedule(v string) *CreateTriggerInput {
	s.Schedule = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateTriggerInput) SetType(v string) *CreateTriggerInput {
	s.Type = &v
	return s
}

type CreateTriggerOutput struct {
	_ struct{} `type:"structure"`

	// The name of the trigger.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateTriggerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTriggerOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *CreateTriggerOutput) SetName(v string) *CreateTriggerOutput {
	s.Name = &v
	return s
}

type CreateUserDefinedFunctionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog in which to create the function. If none is supplied,
	// the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The name of the catalog database in which to create the function.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// A FunctionInput object that defines the function to create in the Data Catalog.
	//
	// FunctionInput is a required field
	FunctionInput *UserDefinedFunctionInput `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateUserDefinedFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserDefinedFunctionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserDefinedFunctionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserDefinedFunctionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.FunctionInput == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionInput"))
	}
	if s.FunctionInput != nil {
		if err := s.FunctionInput.Validate(); err != nil {
			invalidParams.AddNested("FunctionInput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *CreateUserDefinedFunctionInput) SetCatalogId(v string) *CreateUserDefinedFunctionInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *CreateUserDefinedFunctionInput) SetDatabaseName(v string) *CreateUserDefinedFunctionInput {
	s.DatabaseName = &v
	return s
}

// SetFunctionInput sets the FunctionInput field's value.
func (s *CreateUserDefinedFunctionInput) SetFunctionInput(v *UserDefinedFunctionInput) *CreateUserDefinedFunctionInput {
	s.FunctionInput = v
	return s
}

type CreateUserDefinedFunctionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateUserDefinedFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserDefinedFunctionOutput) GoString() string {
	return s.String()
}

// Specifies an XML classifier for CreateClassifier to create.
type CreateXMLClassifierRequest struct {
	_ struct{} `type:"structure"`

	// An identifier of the data format that the classifier matches.
	//
	// Classification is a required field
	Classification *string `type:"string" required:"true"`

	// The name of the classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The XML tag designating the element that contains each record in an XML document
	// being parsed. Note that this cannot identify a self-closing element (closed
	// by />). An empty row element that contains only attributes can be parsed
	// as long as it ends with a closing tag (for example, <row item_a="A" item_b="B"></row>
	// is okay, but <row item_a="A" item_b="B" /> is not).
	RowTag *string `type:"string"`
}

// String returns the string representation
func (s CreateXMLClassifierRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateXMLClassifierRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateXMLClassifierRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateXMLClassifierRequest"}
	if s.Classification == nil {
		invalidParams.Add(request.NewErrParamRequired("Classification"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClassification sets the Classification field's value.
func (s *CreateXMLClassifierRequest) SetClassification(v string) *CreateXMLClassifierRequest {
	s.Classification = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateXMLClassifierRequest) SetName(v string) *CreateXMLClassifierRequest {
	s.Name = &v
	return s
}

// SetRowTag sets the RowTag field's value.
func (s *CreateXMLClassifierRequest) SetRowTag(v string) *CreateXMLClassifierRequest {
	s.RowTag = &v
	return s
}

// The Database object represents a logical grouping of tables that may reside
// in a Hive metastore or an RDBMS.
type Database struct {
	_ struct{} `type:"structure"`

	// The time at which the metadata database was created in the catalog.
	CreateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Description of the database.
	Description *string `type:"string"`

	// The location of the database (for example, an HDFS path).
	LocationUri *string `min:"1" type:"string"`

	// Name of the database. For Hive compatibility, this is folded to lowercase
	// when it is stored.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A list of key-value pairs that define parameters and properties of the database.
	Parameters map[string]*string `type:"map"`
}

// String returns the string representation
func (s Database) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Database) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *Database) SetCreateTime(v time.Time) *Database {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Database) SetDescription(v string) *Database {
	s.Description = &v
	return s
}

// SetLocationUri sets the LocationUri field's value.
func (s *Database) SetLocationUri(v string) *Database {
	s.LocationUri = &v
	return s
}

// SetName sets the Name field's value.
func (s *Database) SetName(v string) *Database {
	s.Name = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *Database) SetParameters(v map[string]*string) *Database {
	s.Parameters = v
	return s
}

// The structure used to create or update a database.
type DatabaseInput struct {
	_ struct{} `type:"structure"`

	// Description of the database
	Description *string `type:"string"`

	// The location of the database (for example, an HDFS path).
	LocationUri *string `min:"1" type:"string"`

	// Name of the database. For Hive compatibility, this is folded to lowercase
	// when it is stored.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A list of key-value pairs that define parameters and properties of the database.
	Parameters map[string]*string `type:"map"`
}

// String returns the string representation
func (s DatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DatabaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatabaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatabaseInput"}
	if s.LocationUri != nil && len(*s.LocationUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocationUri", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *DatabaseInput) SetDescription(v string) *DatabaseInput {
	s.Description = &v
	return s
}

// SetLocationUri sets the LocationUri field's value.
func (s *DatabaseInput) SetLocationUri(v string) *DatabaseInput {
	s.LocationUri = &v
	return s
}

// SetName sets the Name field's value.
func (s *DatabaseInput) SetName(v string) *DatabaseInput {
	s.Name = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *DatabaseInput) SetParameters(v map[string]*string) *DatabaseInput {
	s.Parameters = v
	return s
}

type DeleteClassifierInput struct {
	_ struct{} `type:"structure"`

	// Name of the classifier to remove.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteClassifierInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClassifierInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClassifierInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteClassifierInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteClassifierInput) SetName(v string) *DeleteClassifierInput {
	s.Name = &v
	return s
}

type DeleteClassifierOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteClassifierOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClassifierOutput) GoString() string {
	return s.String()
}

type DeleteConnectionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog in which the connection resides. If none is supplied,
	// the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The name of the connection to delete.
	//
	// ConnectionName is a required field
	ConnectionName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConnectionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.ConnectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionName"))
	}
	if s.ConnectionName != nil && len(*s.ConnectionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *DeleteConnectionInput) SetCatalogId(v string) *DeleteConnectionInput {
	s.CatalogId = &v
	return s
}

// SetConnectionName sets the ConnectionName field's value.
func (s *DeleteConnectionInput) SetConnectionName(v string) *DeleteConnectionInput {
	s.ConnectionName = &v
	return s
}

type DeleteConnectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConnectionOutput) GoString() string {
	return s.String()
}

type DeleteCrawlerInput struct {
	_ struct{} `type:"structure"`

	// Name of the crawler to remove.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCrawlerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCrawlerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCrawlerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCrawlerInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteCrawlerInput) SetName(v string) *DeleteCrawlerInput {
	s.Name = &v
	return s
}

type DeleteCrawlerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCrawlerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCrawlerOutput) GoString() string {
	return s.String()
}

type DeleteDatabaseInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog in which the database resides. If none is supplied,
	// the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The name of the Database to delete. For Hive compatibility, this must be
	// all lowercase.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDatabaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDatabaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDatabaseInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *DeleteDatabaseInput) SetCatalogId(v string) *DeleteDatabaseInput {
	s.CatalogId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteDatabaseInput) SetName(v string) *DeleteDatabaseInput {
	s.Name = &v
	return s
}

type DeleteDatabaseOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDatabaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDatabaseOutput) GoString() string {
	return s.String()
}

type DeleteDevEndpointInput struct {
	_ struct{} `type:"structure"`

	// The name of the DevEndpoint.
	//
	// EndpointName is a required field
	EndpointName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDevEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDevEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDevEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDevEndpointInput"}
	if s.EndpointName == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointName sets the EndpointName field's value.
func (s *DeleteDevEndpointInput) SetEndpointName(v string) *DeleteDevEndpointInput {
	s.EndpointName = &v
	return s
}

type DeleteDevEndpointOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDevEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDevEndpointOutput) GoString() string {
	return s.String()
}

type DeleteJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the job to delete.
	//
	// JobName is a required field
	JobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteJobInput"}
	if s.JobName == nil {
		invalidParams.Add(request.NewErrParamRequired("JobName"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *DeleteJobInput) SetJobName(v string) *DeleteJobInput {
	s.JobName = &v
	return s
}

type DeleteJobOutput struct {
	_ struct{} `type:"structure"`

	// The name of the job that was deleted.
	JobName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteJobOutput) GoString() string {
	return s.String()
}

// SetJobName sets the JobName field's value.
func (s *DeleteJobOutput) SetJobName(v string) *DeleteJobOutput {
	s.JobName = &v
	return s
}

type DeletePartitionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the partition to be deleted resides. If
	// none is supplied, the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The name of the catalog database in which the table in question resides.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The values that define the partition.
	//
	// PartitionValues is a required field
	PartitionValues []*string `type:"list" required:"true"`

	// The name of the table where the partition to be deleted is located.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePartitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePartitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePartitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePartitionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.PartitionValues == nil {
		invalidParams.Add(request.NewErrParamRequired("PartitionValues"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *DeletePartitionInput) SetCatalogId(v string) *DeletePartitionInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *DeletePartitionInput) SetDatabaseName(v string) *DeletePartitionInput {
	s.DatabaseName = &v
	return s
}

// SetPartitionValues sets the PartitionValues field's value.
func (s *DeletePartitionInput) SetPartitionValues(v []*string) *DeletePartitionInput {
	s.PartitionValues = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *DeletePartitionInput) SetTableName(v string) *DeletePartitionInput {
	s.TableName = &v
	return s
}

type DeletePartitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePartitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePartitionOutput) GoString() string {
	return s.String()
}

type DeleteTableInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the table resides. If none is supplied,
	// the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The name of the catalog database in which the table resides. For Hive compatibility,
	// this name is entirely lowercase.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The name of the table to be deleted. For Hive compatibility, this name is
	// entirely lowercase.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTableInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *DeleteTableInput) SetCatalogId(v string) *DeleteTableInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *DeleteTableInput) SetDatabaseName(v string) *DeleteTableInput {
	s.DatabaseName = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteTableInput) SetName(v string) *DeleteTableInput {
	s.Name = &v
	return s
}

type DeleteTableOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTableOutput) GoString() string {
	return s.String()
}

type DeleteTableVersionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the tables reside. If none is supplied,
	// the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The database in the catalog in which the table resides. For Hive compatibility,
	// this name is entirely lowercase.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The name of the table. For Hive compatibility, this name is entirely lowercase.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`

	// The ID of the table version to be deleted.
	//
	// VersionId is a required field
	VersionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTableVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTableVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTableVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTableVersionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}
	if s.VersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionId"))
	}
	if s.VersionId != nil && len(*s.VersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *DeleteTableVersionInput) SetCatalogId(v string) *DeleteTableVersionInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *DeleteTableVersionInput) SetDatabaseName(v string) *DeleteTableVersionInput {
	s.DatabaseName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *DeleteTableVersionInput) SetTableName(v string) *DeleteTableVersionInput {
	s.TableName = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DeleteTableVersionInput) SetVersionId(v string) *DeleteTableVersionInput {
	s.VersionId = &v
	return s
}

type DeleteTableVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTableVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTableVersionOutput) GoString() string {
	return s.String()
}

type DeleteTriggerInput struct {
	_ struct{} `type:"structure"`

	// The name of the trigger to delete.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTriggerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTriggerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTriggerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTriggerInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteTriggerInput) SetName(v string) *DeleteTriggerInput {
	s.Name = &v
	return s
}

type DeleteTriggerOutput struct {
	_ struct{} `type:"structure"`

	// The name of the trigger that was deleted.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteTriggerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTriggerOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *DeleteTriggerOutput) SetName(v string) *DeleteTriggerOutput {
	s.Name = &v
	return s
}

type DeleteUserDefinedFunctionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the function to be deleted is located. If
	// none is supplied, the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The name of the catalog database where the function is located.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The name of the function definition to be deleted.
	//
	// FunctionName is a required field
	FunctionName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserDefinedFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserDefinedFunctionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserDefinedFunctionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserDefinedFunctionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *DeleteUserDefinedFunctionInput) SetCatalogId(v string) *DeleteUserDefinedFunctionInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *DeleteUserDefinedFunctionInput) SetDatabaseName(v string) *DeleteUserDefinedFunctionInput {
	s.DatabaseName = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *DeleteUserDefinedFunctionInput) SetFunctionName(v string) *DeleteUserDefinedFunctionInput {
	s.FunctionName = &v
	return s
}

type DeleteUserDefinedFunctionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUserDefinedFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserDefinedFunctionOutput) GoString() string {
	return s.String()
}

// A development endpoint where a developer can remotely debug ETL scripts.
type DevEndpoint struct {
	_ struct{} `type:"structure"`

	// The AWS availability zone where this DevEndpoint is located.
	AvailabilityZone *string `type:"string"`

	// The point in time at which this DevEndpoint was created.
	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name of the DevEndpoint.
	EndpointName *string `type:"string"`

	// Path to one or more Java Jars in an S3 bucket that should be loaded in your
	// DevEndpoint.
	//
	// Please note that only pure Java/Scala libraries can currently be used on
	// a DevEndpoint.
	ExtraJarsS3Path *string `type:"string"`

	// Path(s) to one or more Python libraries in an S3 bucket that should be loaded
	// in your DevEndpoint. Multiple values must be complete paths separated by
	// a comma.
	//
	// Please note that only pure Python libraries can currently be used on a DevEndpoint.
	// Libraries that rely on C extensions, such as the pandas (http://pandas.pydata.org/)
	// Python data analysis library, are not yet supported.
	ExtraPythonLibsS3Path *string `type:"string"`

	// The reason for a current failure in this DevEndpoint.
	FailureReason *string `type:"string"`

	// The point in time at which this DevEndpoint was last modified.
	LastModifiedTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The status of the last update.
	LastUpdateStatus *string `type:"string"`

	// The number of AWS Glue Data Processing Units (DPUs) allocated to this DevEndpoint.
	NumberOfNodes *int64 `type:"integer"`

	// The private address used by this DevEndpoint.
	PrivateAddress *string `type:"string"`

	// The public VPC address used by this DevEndpoint.
	PublicAddress *string `type:"string"`

	// The public key to be used by this DevEndpoint for authentication.
	PublicKey *string `type:"string"`

	// The AWS ARN of the IAM role used in this DevEndpoint.
	RoleArn *string `type:"string"`

	// A list of security group identifiers used in this DevEndpoint.
	SecurityGroupIds []*string `type:"list"`

	// The current status of this DevEndpoint.
	Status *string `type:"string"`

	// The subnet ID for this DevEndpoint.
	SubnetId *string `type:"string"`

	// The ID of the virtual private cloud (VPC) used by this DevEndpoint.
	VpcId *string `type:"string"`

	// The YARN endpoint address used by this DevEndpoint.
	YarnEndpointAddress *string `type:"string"`

	// The Apache Zeppelin port for the remote Apache Spark interpreter.
	ZeppelinRemoteSparkInterpreterPort *int64 `type:"integer"`
}

// String returns the string representation
func (s DevEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DevEndpoint) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *DevEndpoint) SetAvailabilityZone(v string) *DevEndpoint {
	s.AvailabilityZone = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *DevEndpoint) SetCreatedTimestamp(v time.Time) *DevEndpoint {
	s.CreatedTimestamp = &v
	return s
}

// SetEndpointName sets the EndpointName field's value.
func (s *DevEndpoint) SetEndpointName(v string) *DevEndpoint {
	s.EndpointName = &v
	return s
}

// SetExtraJarsS3Path sets the ExtraJarsS3Path field's value.
func (s *DevEndpoint) SetExtraJarsS3Path(v string) *DevEndpoint {
	s.ExtraJarsS3Path = &v
	return s
}

// SetExtraPythonLibsS3Path sets the ExtraPythonLibsS3Path field's value.
func (s *DevEndpoint) SetExtraPythonLibsS3Path(v string) *DevEndpoint {
	s.ExtraPythonLibsS3Path = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DevEndpoint) SetFailureReason(v string) *DevEndpoint {
	s.FailureReason = &v
	return s
}

// SetLastModifiedTimestamp sets the LastModifiedTimestamp field's value.
func (s *DevEndpoint) SetLastModifiedTimestamp(v time.Time) *DevEndpoint {
	s.LastModifiedTimestamp = &v
	return s
}

// SetLastUpdateStatus sets the LastUpdateStatus field's value.
func (s *DevEndpoint) SetLastUpdateStatus(v string) *DevEndpoint {
	s.LastUpdateStatus = &v
	return s
}

// SetNumberOfNodes sets the NumberOfNodes field's value.
func (s *DevEndpoint) SetNumberOfNodes(v int64) *DevEndpoint {
	s.NumberOfNodes = &v
	return s
}

// SetPrivateAddress sets the PrivateAddress field's value.
func (s *DevEndpoint) SetPrivateAddress(v string) *DevEndpoint {
	s.PrivateAddress = &v
	return s
}

// SetPublicAddress sets the PublicAddress field's value.
func (s *DevEndpoint) SetPublicAddress(v string) *DevEndpoint {
	s.PublicAddress = &v
	return s
}

// SetPublicKey sets the PublicKey field's value.
func (s *DevEndpoint) SetPublicKey(v string) *DevEndpoint {
	s.PublicKey = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DevEndpoint) SetRoleArn(v string) *DevEndpoint {
	s.RoleArn = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *DevEndpoint) SetSecurityGroupIds(v []*string) *DevEndpoint {
	s.SecurityGroupIds = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DevEndpoint) SetStatus(v string) *DevEndpoint {
	s.Status = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *DevEndpoint) SetSubnetId(v string) *DevEndpoint {
	s.SubnetId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *DevEndpoint) SetVpcId(v string) *DevEndpoint {
	s.VpcId = &v
	return s
}

// SetYarnEndpointAddress sets the YarnEndpointAddress field's value.
func (s *DevEndpoint) SetYarnEndpointAddress(v string) *DevEndpoint {
	s.YarnEndpointAddress = &v
	return s
}

// SetZeppelinRemoteSparkInterpreterPort sets the ZeppelinRemoteSparkInterpreterPort field's value.
func (s *DevEndpoint) SetZeppelinRemoteSparkInterpreterPort(v int64) *DevEndpoint {
	s.ZeppelinRemoteSparkInterpreterPort = &v
	return s
}

// Custom libraries to be loaded into a DevEndpoint.
type DevEndpointCustomLibraries struct {
	_ struct{} `type:"structure"`

	// Path to one or more Java Jars in an S3 bucket that should be loaded in your
	// DevEndpoint.
	//
	// Please note that only pure Java/Scala libraries can currently be used on
	// a DevEndpoint.
	ExtraJarsS3Path *string `type:"string"`

	// Path(s) to one or more Python libraries in an S3 bucket that should be loaded
	// in your DevEndpoint. Multiple values must be complete paths separated by
	// a comma.
	//
	// Please note that only pure Python libraries can currently be used on a DevEndpoint.
	// Libraries that rely on C extensions, such as the pandas (http://pandas.pydata.org/)
	// Python data analysis library, are not yet supported.
	ExtraPythonLibsS3Path *string `type:"string"`
}

// String returns the string representation
func (s DevEndpointCustomLibraries) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DevEndpointCustomLibraries) GoString() string {
	return s.String()
}

// SetExtraJarsS3Path sets the ExtraJarsS3Path field's value.
func (s *DevEndpointCustomLibraries) SetExtraJarsS3Path(v string) *DevEndpointCustomLibraries {
	s.ExtraJarsS3Path = &v
	return s
}

// SetExtraPythonLibsS3Path sets the ExtraPythonLibsS3Path field's value.
func (s *DevEndpointCustomLibraries) SetExtraPythonLibsS3Path(v string) *DevEndpointCustomLibraries {
	s.ExtraPythonLibsS3Path = &v
	return s
}

// Contains details about an error.
type ErrorDetail struct {
	_ struct{} `type:"structure"`

	// The code associated with this error.
	ErrorCode *string `min:"1" type:"string"`

	// A message describing the error.
	ErrorMessage *string `type:"string"`
}

// String returns the string representation
func (s ErrorDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorDetail) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *ErrorDetail) SetErrorCode(v string) *ErrorDetail {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ErrorDetail) SetErrorMessage(v string) *ErrorDetail {
	s.ErrorMessage = &v
	return s
}

// An execution property of a job.
type ExecutionProperty struct {
	_ struct{} `type:"structure"`

	// The maximum number of concurrent runs allowed for a job. The default is 1.
	// An error is returned when this threshold is reached. The maximum value you
	// can specify is controlled by a service limit.
	MaxConcurrentRuns *int64 `type:"integer"`
}

// String returns the string representation
func (s ExecutionProperty) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecutionProperty) GoString() string {
	return s.String()
}

// SetMaxConcurrentRuns sets the MaxConcurrentRuns field's value.
func (s *ExecutionProperty) SetMaxConcurrentRuns(v int64) *ExecutionProperty {
	s.MaxConcurrentRuns = &v
	return s
}

type GetCatalogImportStatusInput struct {
	_ struct{} `type:"structure"`

	// The ID of the catalog to migrate. Currently, this should be the AWS account
	// ID.
	CatalogId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetCatalogImportStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCatalogImportStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCatalogImportStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCatalogImportStatusInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *GetCatalogImportStatusInput) SetCatalogId(v string) *GetCatalogImportStatusInput {
	s.CatalogId = &v
	return s
}

type GetCatalogImportStatusOutput struct {
	_ struct{} `type:"structure"`

	// The status of the specified catalog migration.
	ImportStatus *CatalogImportStatus `type:"structure"`
}

// String returns the string representation
func (s GetCatalogImportStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCatalogImportStatusOutput) GoString() string {
	return s.String()
}

// SetImportStatus sets the ImportStatus field's value.
func (s *GetCatalogImportStatusOutput) SetImportStatus(v *CatalogImportStatus) *GetCatalogImportStatusOutput {
	s.ImportStatus = v
	return s
}

type GetClassifierInput struct {
	_ struct{} `type:"structure"`

	// Name of the classifier to retrieve.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetClassifierInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetClassifierInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetClassifierInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetClassifierInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetClassifierInput) SetName(v string) *GetClassifierInput {
	s.Name = &v
	return s
}

type GetClassifierOutput struct {
	_ struct{} `type:"structure"`

	// The requested classifier.
	Classifier *Classifier `type:"structure"`
}

// String returns the string representation
func (s GetClassifierOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetClassifierOutput) GoString() string {
	return s.String()
}

// SetClassifier sets the Classifier field's value.
func (s *GetClassifierOutput) SetClassifier(v *Classifier) *GetClassifierOutput {
	s.Classifier = v
	return s
}

type GetClassifiersInput struct {
	_ struct{} `type:"structure"`

	// Size of the list to return (optional).
	MaxResults *int64 `min:"1" type:"integer"`

	// An optional continuation token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetClassifiersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetClassifiersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetClassifiersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetClassifiersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetClassifiersInput) SetMaxResults(v int64) *GetClassifiersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetClassifiersInput) SetNextToken(v string) *GetClassifiersInput {
	s.NextToken = &v
	return s
}

type GetClassifiersOutput struct {
	_ struct{} `type:"structure"`

	// The requested list of classifier objects.
	Classifiers []*Classifier `type:"list"`

	// A continuation token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetClassifiersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetClassifiersOutput) GoString() string {
	return s.String()
}

// SetClassifiers sets the Classifiers field's value.
func (s *GetClassifiersOutput) SetClassifiers(v []*Classifier) *GetClassifiersOutput {
	s.Classifiers = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetClassifiersOutput) SetNextToken(v string) *GetClassifiersOutput {
	s.NextToken = &v
	return s
}

type GetConnectionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog in which the connection resides. If none is supplied,
	// the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The name of the connection definition to retrieve.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConnectionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *GetConnectionInput) SetCatalogId(v string) *GetConnectionInput {
	s.CatalogId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetConnectionInput) SetName(v string) *GetConnectionInput {
	s.Name = &v
	return s
}

type GetConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The requested connection definition.
	Connection *Connection `type:"structure"`
}

// String returns the string representation
func (s GetConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConnectionOutput) GoString() string {
	return s.String()
}

// SetConnection sets the Connection field's value.
func (s *GetConnectionOutput) SetConnection(v *Connection) *GetConnectionOutput {
	s.Connection = v
	return s
}

// Filters the connection definitions returned by the GetConnections API.
type GetConnectionsFilter struct {
	_ struct{} `type:"structure"`

	// The type of connections to return. Currently, only JDBC is supported; SFTP
	// is not supported.
	ConnectionType *string `type:"string" enum:"ConnectionType"`

	// A criteria string that must match the criteria recorded in the connection
	// definition for that connection definition to be returned.
	MatchCriteria []*string `type:"list"`
}

// String returns the string representation
func (s GetConnectionsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConnectionsFilter) GoString() string {
	return s.String()
}

// SetConnectionType sets the ConnectionType field's value.
func (s *GetConnectionsFilter) SetConnectionType(v string) *GetConnectionsFilter {
	s.ConnectionType = &v
	return s
}

// SetMatchCriteria sets the MatchCriteria field's value.
func (s *GetConnectionsFilter) SetMatchCriteria(v []*string) *GetConnectionsFilter {
	s.MatchCriteria = v
	return s
}

type GetConnectionsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog in which the connections reside. If none is supplied,
	// the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// A filter that controls which connections will be returned.
	Filter *GetConnectionsFilter `type:"structure"`

	// The maximum number of connections to return in one response.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is a continuation call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConnectionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConnectionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConnectionsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *GetConnectionsInput) SetCatalogId(v string) *GetConnectionsInput {
	s.CatalogId = &v
	return s
}

// SetFilter sets the Filter field's value.
func (s *GetConnectionsInput) SetFilter(v *GetConnectionsFilter) *GetConnectionsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetConnectionsInput) SetMaxResults(v int64) *GetConnectionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetConnectionsInput) SetNextToken(v string) *GetConnectionsInput {
	s.NextToken = &v
	return s
}

type GetConnectionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of requested connection definitions.
	ConnectionList []*Connection `type:"list"`

	// A continuation token, if the list of connections returned does not include
	// the last of the filtered connections.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetConnectionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConnectionsOutput) GoString() string {
	return s.String()
}

// SetConnectionList sets the ConnectionList field's value.
func (s *GetConnectionsOutput) SetConnectionList(v []*Connection) *GetConnectionsOutput {
	s.ConnectionList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetConnectionsOutput) SetNextToken(v string) *GetConnectionsOutput {
	s.NextToken = &v
	return s
}

type GetCrawlerInput struct {
	_ struct{} `type:"structure"`

	// Name of the crawler to retrieve metadata for.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCrawlerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCrawlerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCrawlerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCrawlerInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetCrawlerInput) SetName(v string) *GetCrawlerInput {
	s.Name = &v
	return s
}

type GetCrawlerMetricsInput struct {
	_ struct{} `type:"structure"`

	// A list of the names of crawlers about which to retrieve metrics.
	CrawlerNameList []*string `type:"list"`

	// The maximum size of a list to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is a continuation call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetCrawlerMetricsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCrawlerMetricsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCrawlerMetricsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCrawlerMetricsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrawlerNameList sets the CrawlerNameList field's value.
func (s *GetCrawlerMetricsInput) SetCrawlerNameList(v []*string) *GetCrawlerMetricsInput {
	s.CrawlerNameList = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetCrawlerMetricsInput) SetMaxResults(v int64) *GetCrawlerMetricsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetCrawlerMetricsInput) SetNextToken(v string) *GetCrawlerMetricsInput {
	s.NextToken = &v
	return s
}

type GetCrawlerMetricsOutput struct {
	_ struct{} `type:"structure"`

	// A list of metrics for the specified crawler.
	CrawlerMetricsList []*CrawlerMetrics `type:"list"`

	// A continuation token, if the returned list does not contain the last metric
	// available.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetCrawlerMetricsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCrawlerMetricsOutput) GoString() string {
	return s.String()
}

// SetCrawlerMetricsList sets the CrawlerMetricsList field's value.
func (s *GetCrawlerMetricsOutput) SetCrawlerMetricsList(v []*CrawlerMetrics) *GetCrawlerMetricsOutput {
	s.CrawlerMetricsList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetCrawlerMetricsOutput) SetNextToken(v string) *GetCrawlerMetricsOutput {
	s.NextToken = &v
	return s
}

type GetCrawlerOutput struct {
	_ struct{} `type:"structure"`

	// The metadata for the specified crawler.
	Crawler *Crawler `type:"structure"`
}

// String returns the string representation
func (s GetCrawlerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCrawlerOutput) GoString() string {
	return s.String()
}

// SetCrawler sets the Crawler field's value.
func (s *GetCrawlerOutput) SetCrawler(v *Crawler) *GetCrawlerOutput {
	s.Crawler = v
	return s
}

type GetCrawlersInput struct {
	_ struct{} `type:"structure"`

	// The number of crawlers to return on each call.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is a continuation request.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetCrawlersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCrawlersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCrawlersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCrawlersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetCrawlersInput) SetMaxResults(v int64) *GetCrawlersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetCrawlersInput) SetNextToken(v string) *GetCrawlersInput {
	s.NextToken = &v
	return s
}

type GetCrawlersOutput struct {
	_ struct{} `type:"structure"`

	// A list of crawler metadata.
	Crawlers []*Crawler `type:"list"`

	// A continuation token, if the returned list has not reached the end of those
	// defined in this customer account.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetCrawlersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCrawlersOutput) GoString() string {
	return s.String()
}

// SetCrawlers sets the Crawlers field's value.
func (s *GetCrawlersOutput) SetCrawlers(v []*Crawler) *GetCrawlersOutput {
	s.Crawlers = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetCrawlersOutput) SetNextToken(v string) *GetCrawlersOutput {
	s.NextToken = &v
	return s
}

type GetDatabaseInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog in which the database resides. If none is supplied,
	// the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The name of the database to retrieve. For Hive compatibility, this should
	// be all lowercase.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDatabaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDatabaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDatabaseInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *GetDatabaseInput) SetCatalogId(v string) *GetDatabaseInput {
	s.CatalogId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetDatabaseInput) SetName(v string) *GetDatabaseInput {
	s.Name = &v
	return s
}

type GetDatabaseOutput struct {
	_ struct{} `type:"structure"`

	// The definition of the specified database in the catalog.
	Database *Database `type:"structure"`
}

// String returns the string representation
func (s GetDatabaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDatabaseOutput) GoString() string {
	return s.String()
}

// SetDatabase sets the Database field's value.
func (s *GetDatabaseOutput) SetDatabase(v *Database) *GetDatabaseOutput {
	s.Database = v
	return s
}

type GetDatabasesInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog from which to retrieve Databases. If none is supplied,
	// the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The maximum number of databases to return in one response.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is a continuation call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetDatabasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDatabasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDatabasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDatabasesInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *GetDatabasesInput) SetCatalogId(v string) *GetDatabasesInput {
	s.CatalogId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetDatabasesInput) SetMaxResults(v int64) *GetDatabasesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDatabasesInput) SetNextToken(v string) *GetDatabasesInput {
	s.NextToken = &v
	return s
}

type GetDatabasesOutput struct {
	_ struct{} `type:"structure"`

	// A list of Database objects from the specified catalog.
	//
	// DatabaseList is a required field
	DatabaseList []*Database `type:"list" required:"true"`

	// A continuation token for paginating the returned list of tokens, returned
	// if the current segment of the list is not the last.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetDatabasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDatabasesOutput) GoString() string {
	return s.String()
}

// SetDatabaseList sets the DatabaseList field's value.
func (s *GetDatabasesOutput) SetDatabaseList(v []*Database) *GetDatabasesOutput {
	s.DatabaseList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDatabasesOutput) SetNextToken(v string) *GetDatabasesOutput {
	s.NextToken = &v
	return s
}

type GetDataflowGraphInput struct {
	_ struct{} `type:"structure"`

	// The Python script to transform.
	PythonScript *string `type:"string"`
}

// String returns the string representation
func (s GetDataflowGraphInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDataflowGraphInput) GoString() string {
	return s.String()
}

// SetPythonScript sets the PythonScript field's value.
func (s *GetDataflowGraphInput) SetPythonScript(v string) *GetDataflowGraphInput {
	s.PythonScript = &v
	return s
}

type GetDataflowGraphOutput struct {
	_ struct{} `type:"structure"`

	// A list of the edges in the resulting DAG.
	DagEdges []*CodeGenEdge `type:"list"`

	// A list of the nodes in the resulting DAG.
	DagNodes []*CodeGenNode `type:"list"`
}

// String returns the string representation
func (s GetDataflowGraphOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDataflowGraphOutput) GoString() string {
	return s.String()
}

// SetDagEdges sets the DagEdges field's value.
func (s *GetDataflowGraphOutput) SetDagEdges(v []*CodeGenEdge) *GetDataflowGraphOutput {
	s.DagEdges = v
	return s
}

// SetDagNodes sets the DagNodes field's value.
func (s *GetDataflowGraphOutput) SetDagNodes(v []*CodeGenNode) *GetDataflowGraphOutput {
	s.DagNodes = v
	return s
}

type GetDevEndpointInput struct {
	_ struct{} `type:"structure"`

	// Name of the DevEndpoint for which to retrieve information.
	//
	// EndpointName is a required field
	EndpointName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetDevEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDevEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDevEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDevEndpointInput"}
	if s.EndpointName == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointName sets the EndpointName field's value.
func (s *GetDevEndpointInput) SetEndpointName(v string) *GetDevEndpointInput {
	s.EndpointName = &v
	return s
}

type GetDevEndpointOutput struct {
	_ struct{} `type:"structure"`

	// A DevEndpoint definition.
	DevEndpoint *DevEndpoint `type:"structure"`
}

// String returns the string representation
func (s GetDevEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDevEndpointOutput) GoString() string {
	return s.String()
}

// SetDevEndpoint sets the DevEndpoint field's value.
func (s *GetDevEndpointOutput) SetDevEndpoint(v *DevEndpoint) *GetDevEndpointOutput {
	s.DevEndpoint = v
	return s
}

type GetDevEndpointsInput struct {
	_ struct{} `type:"structure"`

	// The maximum size of information to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is a continuation call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetDevEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDevEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDevEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDevEndpointsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetDevEndpointsInput) SetMaxResults(v int64) *GetDevEndpointsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDevEndpointsInput) SetNextToken(v string) *GetDevEndpointsInput {
	s.NextToken = &v
	return s
}

type GetDevEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// A list of DevEndpoint definitions.
	DevEndpoints []*DevEndpoint `type:"list"`

	// A continuation token, if not all DevEndpoint definitions have yet been returned.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetDevEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDevEndpointsOutput) GoString() string {
	return s.String()
}

// SetDevEndpoints sets the DevEndpoints field's value.
func (s *GetDevEndpointsOutput) SetDevEndpoints(v []*DevEndpoint) *GetDevEndpointsOutput {
	s.DevEndpoints = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDevEndpointsOutput) SetNextToken(v string) *GetDevEndpointsOutput {
	s.NextToken = &v
	return s
}

type GetJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the job to retrieve.
	//
	// JobName is a required field
	JobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetJobInput"}
	if s.JobName == nil {
		invalidParams.Add(request.NewErrParamRequired("JobName"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *GetJobInput) SetJobName(v string) *GetJobInput {
	s.JobName = &v
	return s
}

type GetJobOutput struct {
	_ struct{} `type:"structure"`

	// The requested job definition.
	Job *Job `type:"structure"`
}

// String returns the string representation
func (s GetJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobOutput) GoString() string {
	return s.String()
}

// SetJob sets the Job field's value.
func (s *GetJobOutput) SetJob(v *Job) *GetJobOutput {
	s.Job = v
	return s
}

type GetJobRunInput struct {
	_ struct{} `type:"structure"`

	// Name of the job being run.
	//
	// JobName is a required field
	JobName *string `min:"1" type:"string" required:"true"`

	// True if a list of predecessor runs should be returned.
	PredecessorsIncluded *bool `type:"boolean"`

	// The ID of the job run.
	//
	// RunId is a required field
	RunId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetJobRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJobRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetJobRunInput"}
	if s.JobName == nil {
		invalidParams.Add(request.NewErrParamRequired("JobName"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.RunId == nil {
		invalidParams.Add(request.NewErrParamRequired("RunId"))
	}
	if s.RunId != nil && len(*s.RunId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RunId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *GetJobRunInput) SetJobName(v string) *GetJobRunInput {
	s.JobName = &v
	return s
}

// SetPredecessorsIncluded sets the PredecessorsIncluded field's value.
func (s *GetJobRunInput) SetPredecessorsIncluded(v bool) *GetJobRunInput {
	s.PredecessorsIncluded = &v
	return s
}

// SetRunId sets the RunId field's value.
func (s *GetJobRunInput) SetRunId(v string) *GetJobRunInput {
	s.RunId = &v
	return s
}

type GetJobRunOutput struct {
	_ struct{} `type:"structure"`

	// The requested job-run metadata.
	JobRun *JobRun `type:"structure"`
}

// String returns the string representation
func (s GetJobRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobRunOutput) GoString() string {
	return s.String()
}

// SetJobRun sets the JobRun field's value.
func (s *GetJobRunOutput) SetJobRun(v *JobRun) *GetJobRunOutput {
	s.JobRun = v
	return s
}

type GetJobRunsInput struct {
	_ struct{} `type:"structure"`

	// The name of the job for which to retrieve all job runs.
	//
	// JobName is a required field
	JobName *string `min:"1" type:"string" required:"true"`

	// The maximum size of the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is a continuation call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetJobRunsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobRunsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJobRunsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetJobRunsInput"}
	if s.JobName == nil {
		invalidParams.Add(request.NewErrParamRequired("JobName"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *GetJobRunsInput) SetJobName(v string) *GetJobRunsInput {
	s.JobName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetJobRunsInput) SetMaxResults(v int64) *GetJobRunsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetJobRunsInput) SetNextToken(v string) *GetJobRunsInput {
	s.NextToken = &v
	return s
}

type GetJobRunsOutput struct {
	_ struct{} `type:"structure"`

	// A list of job-run metatdata objects.
	JobRuns []*JobRun `type:"list"`

	// A continuation token, if not all reequested job runs have been returned.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetJobRunsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobRunsOutput) GoString() string {
	return s.String()
}

// SetJobRuns sets the JobRuns field's value.
func (s *GetJobRunsOutput) SetJobRuns(v []*JobRun) *GetJobRunsOutput {
	s.JobRuns = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetJobRunsOutput) SetNextToken(v string) *GetJobRunsOutput {
	s.NextToken = &v
	return s
}

type GetJobsInput struct {
	_ struct{} `type:"structure"`

	// The maximum size of the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is a continuation call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetJobsInput) SetMaxResults(v int64) *GetJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetJobsInput) SetNextToken(v string) *GetJobsInput {
	s.NextToken = &v
	return s
}

type GetJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list of jobs.
	Jobs []*Job `type:"list"`

	// A continuation token, if not all jobs have yet been returned.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobsOutput) GoString() string {
	return s.String()
}

// SetJobs sets the Jobs field's value.
func (s *GetJobsOutput) SetJobs(v []*Job) *GetJobsOutput {
	s.Jobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetJobsOutput) SetNextToken(v string) *GetJobsOutput {
	s.NextToken = &v
	return s
}

type GetMappingInput struct {
	_ struct{} `type:"structure"`

	// Parameters for the mapping.
	Location *Location `type:"structure"`

	// A list of target tables.
	Sinks []*CatalogEntry `type:"list"`

	// Specifies the source table.
	//
	// Source is a required field
	Source *CatalogEntry `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMappingInput"}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Location != nil {
		if err := s.Location.Validate(); err != nil {
			invalidParams.AddNested("Location", err.(request.ErrInvalidParams))
		}
	}
	if s.Sinks != nil {
		for i, v := range s.Sinks {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sinks", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Source != nil {
		if err := s.Source.Validate(); err != nil {
			invalidParams.AddNested("Source", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocation sets the Location field's value.
func (s *GetMappingInput) SetLocation(v *Location) *GetMappingInput {
	s.Location = v
	return s
}

// SetSinks sets the Sinks field's value.
func (s *GetMappingInput) SetSinks(v []*CatalogEntry) *GetMappingInput {
	s.Sinks = v
	return s
}

// SetSource sets the Source field's value.
func (s *GetMappingInput) SetSource(v *CatalogEntry) *GetMappingInput {
	s.Source = v
	return s
}

type GetMappingOutput struct {
	_ struct{} `type:"structure"`

	// A list of mappings to the specified targets.
	//
	// Mapping is a required field
	Mapping []*MappingEntry `type:"list" required:"true"`
}

// String returns the string representation
func (s GetMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMappingOutput) GoString() string {
	return s.String()
}

// SetMapping sets the Mapping field's value.
func (s *GetMappingOutput) SetMapping(v []*MappingEntry) *GetMappingOutput {
	s.Mapping = v
	return s
}

type GetPartitionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the partition in question resides. If none
	// is supplied, the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The name of the catalog database where the partition resides.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The values that define the partition.
	//
	// PartitionValues is a required field
	PartitionValues []*string `type:"list" required:"true"`

	// The name of the partition's table.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPartitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPartitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPartitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPartitionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.PartitionValues == nil {
		invalidParams.Add(request.NewErrParamRequired("PartitionValues"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *GetPartitionInput) SetCatalogId(v string) *GetPartitionInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *GetPartitionInput) SetDatabaseName(v string) *GetPartitionInput {
	s.DatabaseName = &v
	return s
}

// SetPartitionValues sets the PartitionValues field's value.
func (s *GetPartitionInput) SetPartitionValues(v []*string) *GetPartitionInput {
	s.PartitionValues = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *GetPartitionInput) SetTableName(v string) *GetPartitionInput {
	s.TableName = &v
	return s
}

type GetPartitionOutput struct {
	_ struct{} `type:"structure"`

	// The requested information, in the form of a Partition object.
	Partition *Partition `type:"structure"`
}

// String returns the string representation
func (s GetPartitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPartitionOutput) GoString() string {
	return s.String()
}

// SetPartition sets the Partition field's value.
func (s *GetPartitionOutput) SetPartition(v *Partition) *GetPartitionOutput {
	s.Partition = v
	return s
}

type GetPartitionsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the partitions in question reside. If none
	// is supplied, the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The name of the catalog database where the partitions reside.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// An expression filtering the partitions to be returned.
	Expression *string `type:"string"`

	// The maximum number of partitions to return in a single response.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is not the first call to retrieve these partitions.
	NextToken *string `type:"string"`

	// The segment of the table's partitions to scan in this request.
	Segment *Segment `type:"structure"`

	// The name of the partitions' table.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPartitionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPartitionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPartitionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPartitionsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}
	if s.Segment != nil {
		if err := s.Segment.Validate(); err != nil {
			invalidParams.AddNested("Segment", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *GetPartitionsInput) SetCatalogId(v string) *GetPartitionsInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *GetPartitionsInput) SetDatabaseName(v string) *GetPartitionsInput {
	s.DatabaseName = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *GetPartitionsInput) SetExpression(v string) *GetPartitionsInput {
	s.Expression = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetPartitionsInput) SetMaxResults(v int64) *GetPartitionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetPartitionsInput) SetNextToken(v string) *GetPartitionsInput {
	s.NextToken = &v
	return s
}

// SetSegment sets the Segment field's value.
func (s *GetPartitionsInput) SetSegment(v *Segment) *GetPartitionsInput {
	s.Segment = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *GetPartitionsInput) SetTableName(v string) *GetPartitionsInput {
	s.TableName = &v
	return s
}

type GetPartitionsOutput struct {
	_ struct{} `type:"structure"`

	// A continuation token, if the returned list of partitions does not does not
	// include the last one.
	NextToken *string `type:"string"`

	// A list of requested partitions.
	Partitions []*Partition `type:"list"`
}

// String returns the string representation
func (s GetPartitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPartitionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetPartitionsOutput) SetNextToken(v string) *GetPartitionsOutput {
	s.NextToken = &v
	return s
}

// SetPartitions sets the Partitions field's value.
func (s *GetPartitionsOutput) SetPartitions(v []*Partition) *GetPartitionsOutput {
	s.Partitions = v
	return s
}

type GetPlanInput struct {
	_ struct{} `type:"structure"`

	// The programming language of the code to perform the mapping.
	Language *string `type:"string" enum:"Language"`

	// Parameters for the mapping.
	Location *Location `type:"structure"`

	// The list of mappings from a source table to target tables.
	//
	// Mapping is a required field
	Mapping []*MappingEntry `type:"list" required:"true"`

	// The target tables.
	Sinks []*CatalogEntry `type:"list"`

	// The source table.
	//
	// Source is a required field
	Source *CatalogEntry `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetPlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPlanInput"}
	if s.Mapping == nil {
		invalidParams.Add(request.NewErrParamRequired("Mapping"))
	}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Location != nil {
		if err := s.Location.Validate(); err != nil {
			invalidParams.AddNested("Location", err.(request.ErrInvalidParams))
		}
	}
	if s.Sinks != nil {
		for i, v := range s.Sinks {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sinks", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Source != nil {
		if err := s.Source.Validate(); err != nil {
			invalidParams.AddNested("Source", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguage sets the Language field's value.
func (s *GetPlanInput) SetLanguage(v string) *GetPlanInput {
	s.Language = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *GetPlanInput) SetLocation(v *Location) *GetPlanInput {
	s.Location = v
	return s
}

// SetMapping sets the Mapping field's value.
func (s *GetPlanInput) SetMapping(v []*MappingEntry) *GetPlanInput {
	s.Mapping = v
	return s
}

// SetSinks sets the Sinks field's value.
func (s *GetPlanInput) SetSinks(v []*CatalogEntry) *GetPlanInput {
	s.Sinks = v
	return s
}

// SetSource sets the Source field's value.
func (s *GetPlanInput) SetSource(v *CatalogEntry) *GetPlanInput {
	s.Source = v
	return s
}

type GetPlanOutput struct {
	_ struct{} `type:"structure"`

	// A Python script to perform the mapping.
	PythonScript *string `type:"string"`

	// Scala code to perform the mapping.
	ScalaCode *string `type:"string"`
}

// String returns the string representation
func (s GetPlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPlanOutput) GoString() string {
	return s.String()
}

// SetPythonScript sets the PythonScript field's value.
func (s *GetPlanOutput) SetPythonScript(v string) *GetPlanOutput {
	s.PythonScript = &v
	return s
}

// SetScalaCode sets the ScalaCode field's value.
func (s *GetPlanOutput) SetScalaCode(v string) *GetPlanOutput {
	s.ScalaCode = &v
	return s
}

type GetTableInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the table resides. If none is supplied,
	// the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The name of the database in the catalog in which the table resides. For Hive
	// compatibility, this name is entirely lowercase.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The name of the table for which to retrieve the definition. For Hive compatibility,
	// this name is entirely lowercase.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTableInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *GetTableInput) SetCatalogId(v string) *GetTableInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *GetTableInput) SetDatabaseName(v string) *GetTableInput {
	s.DatabaseName = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetTableInput) SetName(v string) *GetTableInput {
	s.Name = &v
	return s
}

type GetTableOutput struct {
	_ struct{} `type:"structure"`

	// The Table object that defines the specified table.
	Table *Table `type:"structure"`
}

// String returns the string representation
func (s GetTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTableOutput) GoString() string {
	return s.String()
}

// SetTable sets the Table field's value.
func (s *GetTableOutput) SetTable(v *Table) *GetTableOutput {
	s.Table = v
	return s
}

type GetTableVersionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the tables reside. If none is supplied,
	// the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The database in the catalog in which the table resides. For Hive compatibility,
	// this name is entirely lowercase.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The name of the table. For Hive compatibility, this name is entirely lowercase.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`

	// The ID value of the table version to be retrieved.
	VersionId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetTableVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTableVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTableVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTableVersionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}
	if s.VersionId != nil && len(*s.VersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *GetTableVersionInput) SetCatalogId(v string) *GetTableVersionInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *GetTableVersionInput) SetDatabaseName(v string) *GetTableVersionInput {
	s.DatabaseName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *GetTableVersionInput) SetTableName(v string) *GetTableVersionInput {
	s.TableName = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetTableVersionInput) SetVersionId(v string) *GetTableVersionInput {
	s.VersionId = &v
	return s
}

type GetTableVersionOutput struct {
	_ struct{} `type:"structure"`

	// The requested table version.
	TableVersion *TableVersion `type:"structure"`
}

// String returns the string representation
func (s GetTableVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTableVersionOutput) GoString() string {
	return s.String()
}

// SetTableVersion sets the TableVersion field's value.
func (s *GetTableVersionOutput) SetTableVersion(v *TableVersion) *GetTableVersionOutput {
	s.TableVersion = v
	return s
}

type GetTableVersionsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the tables reside. If none is supplied,
	// the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The database in the catalog in which the table resides. For Hive compatibility,
	// this name is entirely lowercase.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The maximum number of table versions to return in one response.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is not the first call.
	NextToken *string `type:"string"`

	// The name of the table. For Hive compatibility, this name is entirely lowercase.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetTableVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTableVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTableVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTableVersionsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *GetTableVersionsInput) SetCatalogId(v string) *GetTableVersionsInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *GetTableVersionsInput) SetDatabaseName(v string) *GetTableVersionsInput {
	s.DatabaseName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetTableVersionsInput) SetMaxResults(v int64) *GetTableVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetTableVersionsInput) SetNextToken(v string) *GetTableVersionsInput {
	s.NextToken = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *GetTableVersionsInput) SetTableName(v string) *GetTableVersionsInput {
	s.TableName = &v
	return s
}

type GetTableVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A continuation token, if the list of available versions does not include
	// the last one.
	NextToken *string `type:"string"`

	// A list of strings identifying available versions of the specified table.
	TableVersions []*TableVersion `type:"list"`
}

// String returns the string representation
func (s GetTableVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTableVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetTableVersionsOutput) SetNextToken(v string) *GetTableVersionsOutput {
	s.NextToken = &v
	return s
}

// SetTableVersions sets the TableVersions field's value.
func (s *GetTableVersionsOutput) SetTableVersions(v []*TableVersion) *GetTableVersionsOutput {
	s.TableVersions = v
	return s
}

type GetTablesInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the tables reside. If none is supplied,
	// the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The database in the catalog whose tables to list. For Hive compatibility,
	// this name is entirely lowercase.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// A regular expression pattern. If present, only those tables whose names match
	// the pattern are returned.
	Expression *string `type:"string"`

	// The maximum number of tables to return in a single response.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, included if this is a continuation call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetTablesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTablesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTablesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTablesInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *GetTablesInput) SetCatalogId(v string) *GetTablesInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *GetTablesInput) SetDatabaseName(v string) *GetTablesInput {
	s.DatabaseName = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *GetTablesInput) SetExpression(v string) *GetTablesInput {
	s.Expression = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetTablesInput) SetMaxResults(v int64) *GetTablesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetTablesInput) SetNextToken(v string) *GetTablesInput {
	s.NextToken = &v
	return s
}

type GetTablesOutput struct {
	_ struct{} `type:"structure"`

	// A continuation token, present if the current list segment is not the last.
	NextToken *string `type:"string"`

	// A list of the requested Table objects.
	TableList []*Table `type:"list"`
}

// String returns the string representation
func (s GetTablesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTablesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetTablesOutput) SetNextToken(v string) *GetTablesOutput {
	s.NextToken = &v
	return s
}

// SetTableList sets the TableList field's value.
func (s *GetTablesOutput) SetTableList(v []*Table) *GetTablesOutput {
	s.TableList = v
	return s
}

type GetTriggerInput struct {
	_ struct{} `type:"structure"`

	// The name of the trigger to retrieve.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetTriggerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTriggerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTriggerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTriggerInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetTriggerInput) SetName(v string) *GetTriggerInput {
	s.Name = &v
	return s
}

type GetTriggerOutput struct {
	_ struct{} `type:"structure"`

	// The requested trigger definition.
	Trigger *Trigger `type:"structure"`
}

// String returns the string representation
func (s GetTriggerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTriggerOutput) GoString() string {
	return s.String()
}

// SetTrigger sets the Trigger field's value.
func (s *GetTriggerOutput) SetTrigger(v *Trigger) *GetTriggerOutput {
	s.Trigger = v
	return s
}

type GetTriggersInput struct {
	_ struct{} `type:"structure"`

	// The name of the job for which to retrieve triggers. The trigger that can
	// start this job will be returned, and if there is no such trigger, all triggers
	// will be returned.
	DependentJobName *string `min:"1" type:"string"`

	// The maximum size of the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is a continuation call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetTriggersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTriggersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTriggersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTriggersInput"}
	if s.DependentJobName != nil && len(*s.DependentJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DependentJobName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDependentJobName sets the DependentJobName field's value.
func (s *GetTriggersInput) SetDependentJobName(v string) *GetTriggersInput {
	s.DependentJobName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetTriggersInput) SetMaxResults(v int64) *GetTriggersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetTriggersInput) SetNextToken(v string) *GetTriggersInput {
	s.NextToken = &v
	return s
}

type GetTriggersOutput struct {
	_ struct{} `type:"structure"`

	// A continuation token, if not all the requested triggers have yet been returned.
	NextToken *string `type:"string"`

	// A list of triggers for the specified job.
	Triggers []*Trigger `type:"list"`
}

// String returns the string representation
func (s GetTriggersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTriggersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetTriggersOutput) SetNextToken(v string) *GetTriggersOutput {
	s.NextToken = &v
	return s
}

// SetTriggers sets the Triggers field's value.
func (s *GetTriggersOutput) SetTriggers(v []*Trigger) *GetTriggersOutput {
	s.Triggers = v
	return s
}

type GetUserDefinedFunctionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the function to be retrieved is located.
	// If none is supplied, the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The name of the catalog database where the function is located.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The name of the function.
	//
	// FunctionName is a required field
	FunctionName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetUserDefinedFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserDefinedFunctionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUserDefinedFunctionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUserDefinedFunctionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *GetUserDefinedFunctionInput) SetCatalogId(v string) *GetUserDefinedFunctionInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *GetUserDefinedFunctionInput) SetDatabaseName(v string) *GetUserDefinedFunctionInput {
	s.DatabaseName = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *GetUserDefinedFunctionInput) SetFunctionName(v string) *GetUserDefinedFunctionInput {
	s.FunctionName = &v
	return s
}

type GetUserDefinedFunctionOutput struct {
	_ struct{} `type:"structure"`

	// The requested function definition.
	UserDefinedFunction *UserDefinedFunction `type:"structure"`
}

// String returns the string representation
func (s GetUserDefinedFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserDefinedFunctionOutput) GoString() string {
	return s.String()
}

// SetUserDefinedFunction sets the UserDefinedFunction field's value.
func (s *GetUserDefinedFunctionOutput) SetUserDefinedFunction(v *UserDefinedFunction) *GetUserDefinedFunctionOutput {
	s.UserDefinedFunction = v
	return s
}

type GetUserDefinedFunctionsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the functions to be retrieved are located.
	// If none is supplied, the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The name of the catalog database where the functions are located.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The maximum number of functions to return in one response.
	MaxResults *int64 `min:"1" type:"integer"`

	// A continuation token, if this is a continuation call.
	NextToken *string `type:"string"`

	// An optional function-name pattern string that filters the function definitions
	// returned.
	//
	// Pattern is a required field
	Pattern *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetUserDefinedFunctionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserDefinedFunctionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUserDefinedFunctionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUserDefinedFunctionsInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Pattern == nil {
		invalidParams.Add(request.NewErrParamRequired("Pattern"))
	}
	if s.Pattern != nil && len(*s.Pattern) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Pattern", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *GetUserDefinedFunctionsInput) SetCatalogId(v string) *GetUserDefinedFunctionsInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *GetUserDefinedFunctionsInput) SetDatabaseName(v string) *GetUserDefinedFunctionsInput {
	s.DatabaseName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetUserDefinedFunctionsInput) SetMaxResults(v int64) *GetUserDefinedFunctionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetUserDefinedFunctionsInput) SetNextToken(v string) *GetUserDefinedFunctionsInput {
	s.NextToken = &v
	return s
}

// SetPattern sets the Pattern field's value.
func (s *GetUserDefinedFunctionsInput) SetPattern(v string) *GetUserDefinedFunctionsInput {
	s.Pattern = &v
	return s
}

type GetUserDefinedFunctionsOutput struct {
	_ struct{} `type:"structure"`

	// A continuation token, if the list of functions returned does not include
	// the last requested function.
	NextToken *string `type:"string"`

	// A list of requested function definitions.
	UserDefinedFunctions []*UserDefinedFunction `type:"list"`
}

// String returns the string representation
func (s GetUserDefinedFunctionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserDefinedFunctionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetUserDefinedFunctionsOutput) SetNextToken(v string) *GetUserDefinedFunctionsOutput {
	s.NextToken = &v
	return s
}

// SetUserDefinedFunctions sets the UserDefinedFunctions field's value.
func (s *GetUserDefinedFunctionsOutput) SetUserDefinedFunctions(v []*UserDefinedFunction) *GetUserDefinedFunctionsOutput {
	s.UserDefinedFunctions = v
	return s
}

// A classifier that uses grok patterns.
type GrokClassifier struct {
	_ struct{} `type:"structure"`

	// An identifier of the data format that the classifier matches, such as Twitter,
	// JSON, Omniture logs, and so on.
	//
	// Classification is a required field
	Classification *string `type:"string" required:"true"`

	// The time this classifier was registered.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Optional custom grok patterns defined by this classifier. For more information,
	// see custom patterns in Writing Custom Classifers (http://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html).
	CustomPatterns *string `type:"string"`

	// The grok pattern applied to a data store by this classifier. For more information,
	// see built-in patterns in Writing Custom Classifers (http://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html).
	//
	// GrokPattern is a required field
	GrokPattern *string `min:"1" type:"string" required:"true"`

	// The time this classifier was last updated.
	LastUpdated *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name of the classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The version of this classifier.
	Version *int64 `type:"long"`
}

// String returns the string representation
func (s GrokClassifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GrokClassifier) GoString() string {
	return s.String()
}

// SetClassification sets the Classification field's value.
func (s *GrokClassifier) SetClassification(v string) *GrokClassifier {
	s.Classification = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GrokClassifier) SetCreationTime(v time.Time) *GrokClassifier {
	s.CreationTime = &v
	return s
}

// SetCustomPatterns sets the CustomPatterns field's value.
func (s *GrokClassifier) SetCustomPatterns(v string) *GrokClassifier {
	s.CustomPatterns = &v
	return s
}

// SetGrokPattern sets the GrokPattern field's value.
func (s *GrokClassifier) SetGrokPattern(v string) *GrokClassifier {
	s.GrokPattern = &v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *GrokClassifier) SetLastUpdated(v time.Time) *GrokClassifier {
	s.LastUpdated = &v
	return s
}

// SetName sets the Name field's value.
func (s *GrokClassifier) SetName(v string) *GrokClassifier {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GrokClassifier) SetVersion(v int64) *GrokClassifier {
	s.Version = &v
	return s
}

type ImportCatalogToGlueInput struct {
	_ struct{} `type:"structure"`

	// The ID of the catalog to import. Currently, this should be the AWS account
	// ID.
	CatalogId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ImportCatalogToGlueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportCatalogToGlueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportCatalogToGlueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportCatalogToGlueInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *ImportCatalogToGlueInput) SetCatalogId(v string) *ImportCatalogToGlueInput {
	s.CatalogId = &v
	return s
}

type ImportCatalogToGlueOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ImportCatalogToGlueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportCatalogToGlueOutput) GoString() string {
	return s.String()
}

// Specifies a JDBC data store to crawl.
type JdbcTarget struct {
	_ struct{} `type:"structure"`

	// The name of the connection to use to connect to the JDBC target.
	ConnectionName *string `type:"string"`

	// A list of glob patterns used to exclude from the crawl. For more information,
	// see Catalog Tables with a Crawler (http://docs.aws.amazon.com/glue/latest/dg/add-crawler.html).
	Exclusions []*string `type:"list"`

	// The path of the JDBC target.
	Path *string `type:"string"`
}

// String returns the string representation
func (s JdbcTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JdbcTarget) GoString() string {
	return s.String()
}

// SetConnectionName sets the ConnectionName field's value.
func (s *JdbcTarget) SetConnectionName(v string) *JdbcTarget {
	s.ConnectionName = &v
	return s
}

// SetExclusions sets the Exclusions field's value.
func (s *JdbcTarget) SetExclusions(v []*string) *JdbcTarget {
	s.Exclusions = v
	return s
}

// SetPath sets the Path field's value.
func (s *JdbcTarget) SetPath(v string) *JdbcTarget {
	s.Path = &v
	return s
}

// Specifies a job.
type Job struct {
	_ struct{} `type:"structure"`

	// The number of AWS Glue data processing units (DPUs) allocated to this Job.
	// From 2 to 100 DPUs can be allocated; the default is 10. A DPU is a relative
	// measure of processing power that consists of 4 vCPUs of compute capacity
	// and 16 GB of memory. For more information, see the AWS Glue pricing page
	// (https://aws.amazon.com/glue/pricing/).
	AllocatedCapacity *int64 `type:"integer"`

	// The JobCommand that executes this job.
	Command *JobCommand `type:"structure"`

	// The connections used for this job.
	Connections *ConnectionsList `type:"structure"`

	// The time and date that this job specification was created.
	CreatedOn *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The default arguments for this job, specified as name-value pairs.
	//
	// You can specify arguments here that your own job-execution script consumes,
	// as well as arguments that AWS Glue itself consumes.
	//
	// For information about how to specify and consume your own Job arguments,
	// see the Calling AWS Glue APIs in Python (http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html)
	// topic in the developer guide.
	//
	// For information about the key-value pairs that AWS Glue consumes to set up
	// your job, see the Special Parameters Used by AWS Glue (http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-glue-arguments.html)
	// topic in the developer guide.
	DefaultArguments map[string]*string `type:"map"`

	// Description of this job.
	Description *string `type:"string"`

	// An ExecutionProperty specifying the maximum number of concurrent runs allowed
	// for this job.
	ExecutionProperty *ExecutionProperty `type:"structure"`

	// The last point in time when this job specification was modified.
	LastModifiedOn *time.Time `type:"timestamp" timestampFormat:"unix"`

	// This field is reserved for future use.
	LogUri *string `type:"string"`

	// The maximum number of times to retry this job if it fails.
	MaxRetries *int64 `type:"integer"`

	// The name you assign to this job.
	Name *string `min:"1" type:"string"`

	// The name of the IAM role associated with this job.
	Role *string `type:"string"`
}

// String returns the string representation
func (s Job) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Job) GoString() string {
	return s.String()
}

// SetAllocatedCapacity sets the AllocatedCapacity field's value.
func (s *Job) SetAllocatedCapacity(v int64) *Job {
	s.AllocatedCapacity = &v
	return s
}

// SetCommand sets the Command field's value.
func (s *Job) SetCommand(v *JobCommand) *Job {
	s.Command = v
	return s
}

// SetConnections sets the Connections field's value.
func (s *Job) SetConnections(v *ConnectionsList) *Job {
	s.Connections = v
	return s
}

// SetCreatedOn sets the CreatedOn field's value.
func (s *Job) SetCreatedOn(v time.Time) *Job {
	s.CreatedOn = &v
	return s
}

// SetDefaultArguments sets the DefaultArguments field's value.
func (s *Job) SetDefaultArguments(v map[string]*string) *Job {
	s.DefaultArguments = v
	return s
}

// SetDescription sets the Description field's value.
func (s *Job) SetDescription(v string) *Job {
	s.Description = &v
	return s
}

// SetExecutionProperty sets the ExecutionProperty field's value.
func (s *Job) SetExecutionProperty(v *ExecutionProperty) *Job {
	s.ExecutionProperty = v
	return s
}

// SetLastModifiedOn sets the LastModifiedOn field's value.
func (s *Job) SetLastModifiedOn(v time.Time) *Job {
	s.LastModifiedOn = &v
	return s
}

// SetLogUri sets the LogUri field's value.
func (s *Job) SetLogUri(v string) *Job {
	s.LogUri = &v
	return s
}

// SetMaxRetries sets the MaxRetries field's value.
func (s *Job) SetMaxRetries(v int64) *Job {
	s.MaxRetries = &v
	return s
}

// SetName sets the Name field's value.
func (s *Job) SetName(v string) *Job {
	s.Name = &v
	return s
}

// SetRole sets the Role field's value.
func (s *Job) SetRole(v string) *Job {
	s.Role = &v
	return s
}

// Defines a point which a job can resume processing.
type JobBookmarkEntry struct {
	_ struct{} `type:"structure"`

	// The attempt ID number.
	Attempt *int64 `type:"integer"`

	// The bookmark itself.
	JobBookmark *string `type:"string"`

	// Name of the job in question.
	JobName *string `type:"string"`

	// The run ID number.
	Run *int64 `type:"integer"`

	// Version of the job.
	Version *int64 `type:"integer"`
}

// String returns the string representation
func (s JobBookmarkEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobBookmarkEntry) GoString() string {
	return s.String()
}

// SetAttempt sets the Attempt field's value.
func (s *JobBookmarkEntry) SetAttempt(v int64) *JobBookmarkEntry {
	s.Attempt = &v
	return s
}

// SetJobBookmark sets the JobBookmark field's value.
func (s *JobBookmarkEntry) SetJobBookmark(v string) *JobBookmarkEntry {
	s.JobBookmark = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *JobBookmarkEntry) SetJobName(v string) *JobBookmarkEntry {
	s.JobName = &v
	return s
}

// SetRun sets the Run field's value.
func (s *JobBookmarkEntry) SetRun(v int64) *JobBookmarkEntry {
	s.Run = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *JobBookmarkEntry) SetVersion(v int64) *JobBookmarkEntry {
	s.Version = &v
	return s
}

// Specifies code that executes a job.
type JobCommand struct {
	_ struct{} `type:"structure"`

	// The name of the job command: this must be glueetl.
	Name *string `type:"string"`

	// Specifies the S3 path to a script that executes a job (required).
	ScriptLocation *string `type:"string"`
}

// String returns the string representation
func (s JobCommand) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobCommand) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *JobCommand) SetName(v string) *JobCommand {
	s.Name = &v
	return s
}

// SetScriptLocation sets the ScriptLocation field's value.
func (s *JobCommand) SetScriptLocation(v string) *JobCommand {
	s.ScriptLocation = &v
	return s
}

// Contains information about a job run.
type JobRun struct {
	_ struct{} `type:"structure"`

	// The number of AWS Glue data processing units (DPUs) allocated to this JobRun.
	// From 2 to 100 DPUs can be allocated; the default is 10. A DPU is a relative
	// measure of processing power that consists of 4 vCPUs of compute capacity
	// and 16 GB of memory. For more information, see the AWS Glue pricing page
	// (https://aws.amazon.com/glue/pricing/).
	AllocatedCapacity *int64 `type:"integer"`

	// The job arguments associated with this run. These override equivalent default
	// arguments set for the job.
	//
	// You can specify arguments here that your own job-execution script consumes,
	// as well as arguments that AWS Glue itself consumes.
	//
	// For information about how to specify and consume your own job arguments,
	// see the Calling AWS Glue APIs in Python (http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html)
	// topic in the developer guide.
	//
	// For information about the key-value pairs that AWS Glue consumes to set up
	// your job, see the Special Parameters Used by AWS Glue (http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-glue-arguments.html)
	// topic in the developer guide.
	Arguments map[string]*string `type:"map"`

	// The number of the attempt to run this job.
	Attempt *int64 `type:"integer"`

	// The date and time this job run completed.
	CompletedOn *time.Time `type:"timestamp" timestampFormat:"unix"`

	// An error message associated with this job run.
	ErrorMessage *string `type:"string"`

	// The ID of this job run.
	Id *string `min:"1" type:"string"`

	// The name of the job being run.
	JobName *string `min:"1" type:"string"`

	// The current state of the job run.
	JobRunState *string `type:"string" enum:"JobRunState"`

	// The last time this job run was modified.
	LastModifiedOn *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A list of predecessors to this job run.
	PredecessorRuns []*Predecessor `type:"list"`

	// The ID of the previous run of this job. For example, the JobRunId specified
	// in the StartJobRun action.
	PreviousRunId *string `min:"1" type:"string"`

	// The date and time at which this job run was started.
	StartedOn *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name of the trigger that started this job run.
	TriggerName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s JobRun) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobRun) GoString() string {
	return s.String()
}

// SetAllocatedCapacity sets the AllocatedCapacity field's value.
func (s *JobRun) SetAllocatedCapacity(v int64) *JobRun {
	s.AllocatedCapacity = &v
	return s
}

// SetArguments sets the Arguments field's value.
func (s *JobRun) SetArguments(v map[string]*string) *JobRun {
	s.Arguments = v
	return s
}

// SetAttempt sets the Attempt field's value.
func (s *JobRun) SetAttempt(v int64) *JobRun {
	s.Attempt = &v
	return s
}

// SetCompletedOn sets the CompletedOn field's value.
func (s *JobRun) SetCompletedOn(v time.Time) *JobRun {
	s.CompletedOn = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *JobRun) SetErrorMessage(v string) *JobRun {
	s.ErrorMessage = &v
	return s
}

// SetId sets the Id field's value.
func (s *JobRun) SetId(v string) *JobRun {
	s.Id = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *JobRun) SetJobName(v string) *JobRun {
	s.JobName = &v
	return s
}

// SetJobRunState sets the JobRunState field's value.
func (s *JobRun) SetJobRunState(v string) *JobRun {
	s.JobRunState = &v
	return s
}

// SetLastModifiedOn sets the LastModifiedOn field's value.
func (s *JobRun) SetLastModifiedOn(v time.Time) *JobRun {
	s.LastModifiedOn = &v
	return s
}

// SetPredecessorRuns sets the PredecessorRuns field's value.
func (s *JobRun) SetPredecessorRuns(v []*Predecessor) *JobRun {
	s.PredecessorRuns = v
	return s
}

// SetPreviousRunId sets the PreviousRunId field's value.
func (s *JobRun) SetPreviousRunId(v string) *JobRun {
	s.PreviousRunId = &v
	return s
}

// SetStartedOn sets the StartedOn field's value.
func (s *JobRun) SetStartedOn(v time.Time) *JobRun {
	s.StartedOn = &v
	return s
}

// SetTriggerName sets the TriggerName field's value.
func (s *JobRun) SetTriggerName(v string) *JobRun {
	s.TriggerName = &v
	return s
}

// Specifies information used to update an existing job. Note that the previous
// job definition will be completely overwritten by this information.
type JobUpdate struct {
	_ struct{} `type:"structure"`

	// The number of AWS Glue data processing units (DPUs) to allocate to this Job.
	// From 2 to 100 DPUs can be allocated; the default is 10. A DPU is a relative
	// measure of processing power that consists of 4 vCPUs of compute capacity
	// and 16 GB of memory. For more information, see the AWS Glue pricing page
	// (https://aws.amazon.com/glue/pricing/).
	AllocatedCapacity *int64 `type:"integer"`

	// The JobCommand that executes this job (required).
	Command *JobCommand `type:"structure"`

	// The connections used for this job.
	Connections *ConnectionsList `type:"structure"`

	// The default arguments for this job.
	//
	// You can specify arguments here that your own job-execution script consumes,
	// as well as arguments that AWS Glue itself consumes.
	//
	// For information about how to specify and consume your own Job arguments,
	// see the Calling AWS Glue APIs in Python (http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html)
	// topic in the developer guide.
	//
	// For information about the key-value pairs that AWS Glue consumes to set up
	// your job, see the Special Parameters Used by AWS Glue (http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-glue-arguments.html)
	// topic in the developer guide.
	DefaultArguments map[string]*string `type:"map"`

	// Description of the job.
	Description *string `type:"string"`

	// An ExecutionProperty specifying the maximum number of concurrent runs allowed
	// for this job.
	ExecutionProperty *ExecutionProperty `type:"structure"`

	// This field is reserved for future use.
	LogUri *string `type:"string"`

	// The maximum number of times to retry this job if it fails.
	MaxRetries *int64 `type:"integer"`

	// The name of the IAM role associated with this job (required).
	Role *string `type:"string"`
}

// String returns the string representation
func (s JobUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobUpdate) GoString() string {
	return s.String()
}

// SetAllocatedCapacity sets the AllocatedCapacity field's value.
func (s *JobUpdate) SetAllocatedCapacity(v int64) *JobUpdate {
	s.AllocatedCapacity = &v
	return s
}

// SetCommand sets the Command field's value.
func (s *JobUpdate) SetCommand(v *JobCommand) *JobUpdate {
	s.Command = v
	return s
}

// SetConnections sets the Connections field's value.
func (s *JobUpdate) SetConnections(v *ConnectionsList) *JobUpdate {
	s.Connections = v
	return s
}

// SetDefaultArguments sets the DefaultArguments field's value.
func (s *JobUpdate) SetDefaultArguments(v map[string]*string) *JobUpdate {
	s.DefaultArguments = v
	return s
}

// SetDescription sets the Description field's value.
func (s *JobUpdate) SetDescription(v string) *JobUpdate {
	s.Description = &v
	return s
}

// SetExecutionProperty sets the ExecutionProperty field's value.
func (s *JobUpdate) SetExecutionProperty(v *ExecutionProperty) *JobUpdate {
	s.ExecutionProperty = v
	return s
}

// SetLogUri sets the LogUri field's value.
func (s *JobUpdate) SetLogUri(v string) *JobUpdate {
	s.LogUri = &v
	return s
}

// SetMaxRetries sets the MaxRetries field's value.
func (s *JobUpdate) SetMaxRetries(v int64) *JobUpdate {
	s.MaxRetries = &v
	return s
}

// SetRole sets the Role field's value.
func (s *JobUpdate) SetRole(v string) *JobUpdate {
	s.Role = &v
	return s
}

// A classifier for JSON content.
type JsonClassifier struct {
	_ struct{} `type:"structure"`

	// The time this classifier was registered.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A JsonPath string defining the JSON data for the classifier to classify.
	// AWS Glue supports a subset of JsonPath, as described in Writing JsonPath
	// Custom Classifiers (https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json).
	//
	// JsonPath is a required field
	JsonPath *string `type:"string" required:"true"`

	// The time this classifier was last updated.
	LastUpdated *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name of the classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The version of this classifier.
	Version *int64 `type:"long"`
}

// String returns the string representation
func (s JsonClassifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JsonClassifier) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *JsonClassifier) SetCreationTime(v time.Time) *JsonClassifier {
	s.CreationTime = &v
	return s
}

// SetJsonPath sets the JsonPath field's value.
func (s *JsonClassifier) SetJsonPath(v string) *JsonClassifier {
	s.JsonPath = &v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *JsonClassifier) SetLastUpdated(v time.Time) *JsonClassifier {
	s.LastUpdated = &v
	return s
}

// SetName sets the Name field's value.
func (s *JsonClassifier) SetName(v string) *JsonClassifier {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *JsonClassifier) SetVersion(v int64) *JsonClassifier {
	s.Version = &v
	return s
}

// Status and error information about the most recent crawl.
type LastCrawlInfo struct {
	_ struct{} `type:"structure"`

	// If an error occurred, the error information about the last crawl.
	ErrorMessage *string `type:"string"`

	// The log group for the last crawl.
	LogGroup *string `min:"1" type:"string"`

	// The log stream for the last crawl.
	LogStream *string `min:"1" type:"string"`

	// The prefix for a message about this crawl.
	MessagePrefix *string `min:"1" type:"string"`

	// The time at which the crawl started.
	StartTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Status of the last crawl.
	Status *string `type:"string" enum:"LastCrawlStatus"`
}

// String returns the string representation
func (s LastCrawlInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LastCrawlInfo) GoString() string {
	return s.String()
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *LastCrawlInfo) SetErrorMessage(v string) *LastCrawlInfo {
	s.ErrorMessage = &v
	return s
}

// SetLogGroup sets the LogGroup field's value.
func (s *LastCrawlInfo) SetLogGroup(v string) *LastCrawlInfo {
	s.LogGroup = &v
	return s
}

// SetLogStream sets the LogStream field's value.
func (s *LastCrawlInfo) SetLogStream(v string) *LastCrawlInfo {
	s.LogStream = &v
	return s
}

// SetMessagePrefix sets the MessagePrefix field's value.
func (s *LastCrawlInfo) SetMessagePrefix(v string) *LastCrawlInfo {
	s.MessagePrefix = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *LastCrawlInfo) SetStartTime(v time.Time) *LastCrawlInfo {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *LastCrawlInfo) SetStatus(v string) *LastCrawlInfo {
	s.Status = &v
	return s
}

// The location of resources.
type Location struct {
	_ struct{} `type:"structure"`

	// A JDBC location.
	Jdbc []*CodeGenNodeArg `type:"list"`

	// An Amazon S3 location.
	S3 []*CodeGenNodeArg `type:"list"`
}

// String returns the string representation
func (s Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Location) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Location) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Location"}
	if s.Jdbc != nil {
		for i, v := range s.Jdbc {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Jdbc", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.S3 != nil {
		for i, v := range s.S3 {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "S3", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJdbc sets the Jdbc field's value.
func (s *Location) SetJdbc(v []*CodeGenNodeArg) *Location {
	s.Jdbc = v
	return s
}

// SetS3 sets the S3 field's value.
func (s *Location) SetS3(v []*CodeGenNodeArg) *Location {
	s.S3 = v
	return s
}

// Defines a mapping.
type MappingEntry struct {
	_ struct{} `type:"structure"`

	// The source path.
	SourcePath *string `type:"string"`

	// The name of the source table.
	SourceTable *string `type:"string"`

	// The source type.
	SourceType *string `type:"string"`

	// The target path.
	TargetPath *string `type:"string"`

	// The target table.
	TargetTable *string `type:"string"`

	// The target type.
	TargetType *string `type:"string"`
}

// String returns the string representation
func (s MappingEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MappingEntry) GoString() string {
	return s.String()
}

// SetSourcePath sets the SourcePath field's value.
func (s *MappingEntry) SetSourcePath(v string) *MappingEntry {
	s.SourcePath = &v
	return s
}

// SetSourceTable sets the SourceTable field's value.
func (s *MappingEntry) SetSourceTable(v string) *MappingEntry {
	s.SourceTable = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *MappingEntry) SetSourceType(v string) *MappingEntry {
	s.SourceType = &v
	return s
}

// SetTargetPath sets the TargetPath field's value.
func (s *MappingEntry) SetTargetPath(v string) *MappingEntry {
	s.TargetPath = &v
	return s
}

// SetTargetTable sets the TargetTable field's value.
func (s *MappingEntry) SetTargetTable(v string) *MappingEntry {
	s.TargetTable = &v
	return s
}

// SetTargetType sets the TargetType field's value.
func (s *MappingEntry) SetTargetType(v string) *MappingEntry {
	s.TargetType = &v
	return s
}

// Specifies the sort order of a sorted column.
type Order struct {
	_ struct{} `type:"structure"`

	// The name of the column.
	//
	// Column is a required field
	Column *string `min:"1" type:"string" required:"true"`

	// Indicates that the column is sorted in ascending order (== 1), or in descending
	// order (==0).
	//
	// SortOrder is a required field
	SortOrder *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s Order) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Order) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Order) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Order"}
	if s.Column == nil {
		invalidParams.Add(request.NewErrParamRequired("Column"))
	}
	if s.Column != nil && len(*s.Column) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Column", 1))
	}
	if s.SortOrder == nil {
		invalidParams.Add(request.NewErrParamRequired("SortOrder"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumn sets the Column field's value.
func (s *Order) SetColumn(v string) *Order {
	s.Column = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *Order) SetSortOrder(v int64) *Order {
	s.SortOrder = &v
	return s
}

// Represents a slice of table data.
type Partition struct {
	_ struct{} `type:"structure"`

	// The time at which the partition was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name of the catalog database where the table in question is located.
	DatabaseName *string `min:"1" type:"string"`

	// The last time at which the partition was accessed.
	LastAccessTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The last time at which column statistics were computed for this partition.
	LastAnalyzedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Partition parameters, in the form of a list of key-value pairs.
	Parameters map[string]*string `type:"map"`

	// Provides information about the physical location where the partition is stored.
	StorageDescriptor *StorageDescriptor `type:"structure"`

	// The name of the table in question.
	TableName *string `min:"1" type:"string"`

	// The values of the partition.
	Values []*string `type:"list"`
}

// String returns the string representation
func (s Partition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Partition) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *Partition) SetCreationTime(v time.Time) *Partition {
	s.CreationTime = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *Partition) SetDatabaseName(v string) *Partition {
	s.DatabaseName = &v
	return s
}

// SetLastAccessTime sets the LastAccessTime field's value.
func (s *Partition) SetLastAccessTime(v time.Time) *Partition {
	s.LastAccessTime = &v
	return s
}

// SetLastAnalyzedTime sets the LastAnalyzedTime field's value.
func (s *Partition) SetLastAnalyzedTime(v time.Time) *Partition {
	s.LastAnalyzedTime = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *Partition) SetParameters(v map[string]*string) *Partition {
	s.Parameters = v
	return s
}

// SetStorageDescriptor sets the StorageDescriptor field's value.
func (s *Partition) SetStorageDescriptor(v *StorageDescriptor) *Partition {
	s.StorageDescriptor = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *Partition) SetTableName(v string) *Partition {
	s.TableName = &v
	return s
}

// SetValues sets the Values field's value.
func (s *Partition) SetValues(v []*string) *Partition {
	s.Values = v
	return s
}

// Contains information about a partition error.
type PartitionError struct {
	_ struct{} `type:"structure"`

	// Details about the partition error.
	ErrorDetail *ErrorDetail `type:"structure"`

	// The values that define the partition.
	PartitionValues []*string `type:"list"`
}

// String returns the string representation
func (s PartitionError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PartitionError) GoString() string {
	return s.String()
}

// SetErrorDetail sets the ErrorDetail field's value.
func (s *PartitionError) SetErrorDetail(v *ErrorDetail) *PartitionError {
	s.ErrorDetail = v
	return s
}

// SetPartitionValues sets the PartitionValues field's value.
func (s *PartitionError) SetPartitionValues(v []*string) *PartitionError {
	s.PartitionValues = v
	return s
}

// The structure used to create and update a partion.
type PartitionInput struct {
	_ struct{} `type:"structure"`

	// The last time at which the partition was accessed.
	LastAccessTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The last time at which column statistics were computed for this partition.
	LastAnalyzedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Partition parameters, in the form of a list of key-value pairs.
	Parameters map[string]*string `type:"map"`

	// Provides information about the physical location where the partition is stored.
	StorageDescriptor *StorageDescriptor `type:"structure"`

	// The values of the partition.
	Values []*string `type:"list"`
}

// String returns the string representation
func (s PartitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PartitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PartitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PartitionInput"}
	if s.StorageDescriptor != nil {
		if err := s.StorageDescriptor.Validate(); err != nil {
			invalidParams.AddNested("StorageDescriptor", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLastAccessTime sets the LastAccessTime field's value.
func (s *PartitionInput) SetLastAccessTime(v time.Time) *PartitionInput {
	s.LastAccessTime = &v
	return s
}

// SetLastAnalyzedTime sets the LastAnalyzedTime field's value.
func (s *PartitionInput) SetLastAnalyzedTime(v time.Time) *PartitionInput {
	s.LastAnalyzedTime = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *PartitionInput) SetParameters(v map[string]*string) *PartitionInput {
	s.Parameters = v
	return s
}

// SetStorageDescriptor sets the StorageDescriptor field's value.
func (s *PartitionInput) SetStorageDescriptor(v *StorageDescriptor) *PartitionInput {
	s.StorageDescriptor = v
	return s
}

// SetValues sets the Values field's value.
func (s *PartitionInput) SetValues(v []*string) *PartitionInput {
	s.Values = v
	return s
}

// Contains a list of values defining partitions.
type PartitionValueList struct {
	_ struct{} `type:"structure"`

	// The list of values.
	//
	// Values is a required field
	Values []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s PartitionValueList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PartitionValueList) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PartitionValueList) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PartitionValueList"}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetValues sets the Values field's value.
func (s *PartitionValueList) SetValues(v []*string) *PartitionValueList {
	s.Values = v
	return s
}

// Specifies the physical requirements for a connection.
type PhysicalConnectionRequirements struct {
	_ struct{} `type:"structure"`

	// The connection's availability zone. This field is deprecated and has no effect.
	AvailabilityZone *string `min:"1" type:"string"`

	// The security group ID list used by the connection.
	SecurityGroupIdList []*string `type:"list"`

	// The subnet ID used by the connection.
	SubnetId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PhysicalConnectionRequirements) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PhysicalConnectionRequirements) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PhysicalConnectionRequirements) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PhysicalConnectionRequirements"}
	if s.AvailabilityZone != nil && len(*s.AvailabilityZone) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AvailabilityZone", 1))
	}
	if s.SubnetId != nil && len(*s.SubnetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *PhysicalConnectionRequirements) SetAvailabilityZone(v string) *PhysicalConnectionRequirements {
	s.AvailabilityZone = &v
	return s
}

// SetSecurityGroupIdList sets the SecurityGroupIdList field's value.
func (s *PhysicalConnectionRequirements) SetSecurityGroupIdList(v []*string) *PhysicalConnectionRequirements {
	s.SecurityGroupIdList = v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *PhysicalConnectionRequirements) SetSubnetId(v string) *PhysicalConnectionRequirements {
	s.SubnetId = &v
	return s
}

// A job run that was used in the predicate of a conditional trigger that triggered
// this job run.
type Predecessor struct {
	_ struct{} `type:"structure"`

	// The name of the predecessor job.
	JobName *string `min:"1" type:"string"`

	// The job-run ID of the predecessor job run.
	RunId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Predecessor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Predecessor) GoString() string {
	return s.String()
}

// SetJobName sets the JobName field's value.
func (s *Predecessor) SetJobName(v string) *Predecessor {
	s.JobName = &v
	return s
}

// SetRunId sets the RunId field's value.
func (s *Predecessor) SetRunId(v string) *Predecessor {
	s.RunId = &v
	return s
}

// Defines the predicate of the trigger, which determines when it fires.
type Predicate struct {
	_ struct{} `type:"structure"`

	// A list of the conditions that determine when the trigger will fire.
	Conditions []*Condition `type:"list"`

	// Currently "OR" is not supported.
	Logical *string `type:"string" enum:"Logical"`
}

// String returns the string representation
func (s Predicate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Predicate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Predicate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Predicate"}
	if s.Conditions != nil {
		for i, v := range s.Conditions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Conditions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConditions sets the Conditions field's value.
func (s *Predicate) SetConditions(v []*Condition) *Predicate {
	s.Conditions = v
	return s
}

// SetLogical sets the Logical field's value.
func (s *Predicate) SetLogical(v string) *Predicate {
	s.Logical = &v
	return s
}

type ResetJobBookmarkInput struct {
	_ struct{} `type:"structure"`

	// The name of the job in question.
	//
	// JobName is a required field
	JobName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ResetJobBookmarkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetJobBookmarkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetJobBookmarkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResetJobBookmarkInput"}
	if s.JobName == nil {
		invalidParams.Add(request.NewErrParamRequired("JobName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *ResetJobBookmarkInput) SetJobName(v string) *ResetJobBookmarkInput {
	s.JobName = &v
	return s
}

type ResetJobBookmarkOutput struct {
	_ struct{} `type:"structure"`

	// The reset bookmark entry.
	JobBookmarkEntry *JobBookmarkEntry `type:"structure"`
}

// String returns the string representation
func (s ResetJobBookmarkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetJobBookmarkOutput) GoString() string {
	return s.String()
}

// SetJobBookmarkEntry sets the JobBookmarkEntry field's value.
func (s *ResetJobBookmarkOutput) SetJobBookmarkEntry(v *JobBookmarkEntry) *ResetJobBookmarkOutput {
	s.JobBookmarkEntry = v
	return s
}

// URIs for function resources.
type ResourceUri struct {
	_ struct{} `type:"structure"`

	// The type of the resource.
	ResourceType *string `type:"string" enum:"ResourceType"`

	// The URI for accessing the resource.
	Uri *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ResourceUri) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceUri) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceUri) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourceUri"}
	if s.Uri != nil && len(*s.Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Uri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceType sets the ResourceType field's value.
func (s *ResourceUri) SetResourceType(v string) *ResourceUri {
	s.ResourceType = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *ResourceUri) SetUri(v string) *ResourceUri {
	s.Uri = &v
	return s
}

// Specifies a data store in Amazon S3.
type S3Target struct {
	_ struct{} `type:"structure"`

	// A list of glob patterns used to exclude from the crawl. For more information,
	// see Catalog Tables with a Crawler (http://docs.aws.amazon.com/glue/latest/dg/add-crawler.html).
	Exclusions []*string `type:"list"`

	// The path to the Amazon S3 target.
	Path *string `type:"string"`
}

// String returns the string representation
func (s S3Target) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Target) GoString() string {
	return s.String()
}

// SetExclusions sets the Exclusions field's value.
func (s *S3Target) SetExclusions(v []*string) *S3Target {
	s.Exclusions = v
	return s
}

// SetPath sets the Path field's value.
func (s *S3Target) SetPath(v string) *S3Target {
	s.Path = &v
	return s
}

// A scheduling object using a cron statement to schedule an event.
type Schedule struct {
	_ struct{} `type:"structure"`

	// A cron expression used to specify the schedule (see Time-Based Schedules
	// for Jobs and Crawlers (http://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html).
	// For example, to run something every day at 12:15 UTC, you would specify:
	// cron(15 12 * * ? *).
	ScheduleExpression *string `type:"string"`

	// The state of the schedule.
	State *string `type:"string" enum:"ScheduleState"`
}

// String returns the string representation
func (s Schedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Schedule) GoString() string {
	return s.String()
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *Schedule) SetScheduleExpression(v string) *Schedule {
	s.ScheduleExpression = &v
	return s
}

// SetState sets the State field's value.
func (s *Schedule) SetState(v string) *Schedule {
	s.State = &v
	return s
}

// Crawler policy for update and deletion behavior.
type SchemaChangePolicy struct {
	_ struct{} `type:"structure"`

	// The deletion behavior when the crawler finds a deleted object.
	DeleteBehavior *string `type:"string" enum:"DeleteBehavior"`

	// The update behavior when the crawler finds a changed schema.
	UpdateBehavior *string `type:"string" enum:"UpdateBehavior"`
}

// String returns the string representation
func (s SchemaChangePolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SchemaChangePolicy) GoString() string {
	return s.String()
}

// SetDeleteBehavior sets the DeleteBehavior field's value.
func (s *SchemaChangePolicy) SetDeleteBehavior(v string) *SchemaChangePolicy {
	s.DeleteBehavior = &v
	return s
}

// SetUpdateBehavior sets the UpdateBehavior field's value.
func (s *SchemaChangePolicy) SetUpdateBehavior(v string) *SchemaChangePolicy {
	s.UpdateBehavior = &v
	return s
}

// Defines a non-overlapping region of a table's partitions, allowing multiple
// requests to be executed in parallel.
type Segment struct {
	_ struct{} `type:"structure"`

	// The zero-based index number of the this segment. For example, if the total
	// number of segments is 4, SegmentNumber values will range from zero through
	// three.
	//
	// SegmentNumber is a required field
	SegmentNumber *int64 `type:"integer" required:"true"`

	// The total numer of segments.
	//
	// TotalSegments is a required field
	TotalSegments *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s Segment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Segment) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Segment) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Segment"}
	if s.SegmentNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("SegmentNumber"))
	}
	if s.TotalSegments == nil {
		invalidParams.Add(request.NewErrParamRequired("TotalSegments"))
	}
	if s.TotalSegments != nil && *s.TotalSegments < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TotalSegments", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSegmentNumber sets the SegmentNumber field's value.
func (s *Segment) SetSegmentNumber(v int64) *Segment {
	s.SegmentNumber = &v
	return s
}

// SetTotalSegments sets the TotalSegments field's value.
func (s *Segment) SetTotalSegments(v int64) *Segment {
	s.TotalSegments = &v
	return s
}

// Information about a serialization/deserialization program (SerDe) which serves
// as an extractor and loader.
type SerDeInfo struct {
	_ struct{} `type:"structure"`

	// Name of the SerDe.
	Name *string `min:"1" type:"string"`

	// A list of initialization parameters for the SerDe, in key-value form.
	Parameters map[string]*string `type:"map"`

	// Usually the class that implements the SerDe. An example is: org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe.
	SerializationLibrary *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SerDeInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SerDeInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SerDeInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SerDeInfo"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SerializationLibrary != nil && len(*s.SerializationLibrary) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SerializationLibrary", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *SerDeInfo) SetName(v string) *SerDeInfo {
	s.Name = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *SerDeInfo) SetParameters(v map[string]*string) *SerDeInfo {
	s.Parameters = v
	return s
}

// SetSerializationLibrary sets the SerializationLibrary field's value.
func (s *SerDeInfo) SetSerializationLibrary(v string) *SerDeInfo {
	s.SerializationLibrary = &v
	return s
}

// Specifies skewed values in a table. Skewed are ones that occur with very
// high frequency.
type SkewedInfo struct {
	_ struct{} `type:"structure"`

	// A list of names of columns that contain skewed values.
	SkewedColumnNames []*string `type:"list"`

	// A mapping of skewed values to the columns that contain them.
	SkewedColumnValueLocationMaps map[string]*string `type:"map"`

	// A list of values that appear so frequently as to be considered skewed.
	SkewedColumnValues []*string `type:"list"`
}

// String returns the string representation
func (s SkewedInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SkewedInfo) GoString() string {
	return s.String()
}

// SetSkewedColumnNames sets the SkewedColumnNames field's value.
func (s *SkewedInfo) SetSkewedColumnNames(v []*string) *SkewedInfo {
	s.SkewedColumnNames = v
	return s
}

// SetSkewedColumnValueLocationMaps sets the SkewedColumnValueLocationMaps field's value.
func (s *SkewedInfo) SetSkewedColumnValueLocationMaps(v map[string]*string) *SkewedInfo {
	s.SkewedColumnValueLocationMaps = v
	return s
}

// SetSkewedColumnValues sets the SkewedColumnValues field's value.
func (s *SkewedInfo) SetSkewedColumnValues(v []*string) *SkewedInfo {
	s.SkewedColumnValues = v
	return s
}

type StartCrawlerInput struct {
	_ struct{} `type:"structure"`

	// Name of the crawler to start.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartCrawlerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartCrawlerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartCrawlerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartCrawlerInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *StartCrawlerInput) SetName(v string) *StartCrawlerInput {
	s.Name = &v
	return s
}

type StartCrawlerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartCrawlerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartCrawlerOutput) GoString() string {
	return s.String()
}

type StartCrawlerScheduleInput struct {
	_ struct{} `type:"structure"`

	// Name of the crawler to schedule.
	//
	// CrawlerName is a required field
	CrawlerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartCrawlerScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartCrawlerScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartCrawlerScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartCrawlerScheduleInput"}
	if s.CrawlerName == nil {
		invalidParams.Add(request.NewErrParamRequired("CrawlerName"))
	}
	if s.CrawlerName != nil && len(*s.CrawlerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CrawlerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrawlerName sets the CrawlerName field's value.
func (s *StartCrawlerScheduleInput) SetCrawlerName(v string) *StartCrawlerScheduleInput {
	s.CrawlerName = &v
	return s
}

type StartCrawlerScheduleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartCrawlerScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartCrawlerScheduleOutput) GoString() string {
	return s.String()
}

type StartJobRunInput struct {
	_ struct{} `type:"structure"`

	// The number of AWS Glue data processing units (DPUs) to allocate to this JobRun.
	// From 2 to 100 DPUs can be allocated; the default is 10. A DPU is a relative
	// measure of processing power that consists of 4 vCPUs of compute capacity
	// and 16 GB of memory. For more information, see the AWS Glue pricing page
	// (https://aws.amazon.com/glue/pricing/).
	AllocatedCapacity *int64 `type:"integer"`

	// The job arguments specifically for this run. They override the equivalent
	// default arguments set for the job itself.
	//
	// You can specify arguments here that your own job-execution script consumes,
	// as well as arguments that AWS Glue itself consumes.
	//
	// For information about how to specify and consume your own Job arguments,
	// see the Calling AWS Glue APIs in Python (http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html)
	// topic in the developer guide.
	//
	// For information about the key-value pairs that AWS Glue consumes to set up
	// your job, see the Special Parameters Used by AWS Glue (http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-glue-arguments.html)
	// topic in the developer guide.
	Arguments map[string]*string `type:"map"`

	// The name of the job to start.
	//
	// JobName is a required field
	JobName *string `min:"1" type:"string" required:"true"`

	// The ID of a previous JobRun to retry.
	JobRunId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StartJobRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartJobRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartJobRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartJobRunInput"}
	if s.JobName == nil {
		invalidParams.Add(request.NewErrParamRequired("JobName"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.JobRunId != nil && len(*s.JobRunId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobRunId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllocatedCapacity sets the AllocatedCapacity field's value.
func (s *StartJobRunInput) SetAllocatedCapacity(v int64) *StartJobRunInput {
	s.AllocatedCapacity = &v
	return s
}

// SetArguments sets the Arguments field's value.
func (s *StartJobRunInput) SetArguments(v map[string]*string) *StartJobRunInput {
	s.Arguments = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartJobRunInput) SetJobName(v string) *StartJobRunInput {
	s.JobName = &v
	return s
}

// SetJobRunId sets the JobRunId field's value.
func (s *StartJobRunInput) SetJobRunId(v string) *StartJobRunInput {
	s.JobRunId = &v
	return s
}

type StartJobRunOutput struct {
	_ struct{} `type:"structure"`

	// The ID assigned to this job run.
	JobRunId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StartJobRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartJobRunOutput) GoString() string {
	return s.String()
}

// SetJobRunId sets the JobRunId field's value.
func (s *StartJobRunOutput) SetJobRunId(v string) *StartJobRunOutput {
	s.JobRunId = &v
	return s
}

type StartTriggerInput struct {
	_ struct{} `type:"structure"`

	// The name of the trigger to start.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartTriggerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartTriggerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartTriggerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartTriggerInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *StartTriggerInput) SetName(v string) *StartTriggerInput {
	s.Name = &v
	return s
}

type StartTriggerOutput struct {
	_ struct{} `type:"structure"`

	// The name of the trigger that was started.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StartTriggerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartTriggerOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *StartTriggerOutput) SetName(v string) *StartTriggerOutput {
	s.Name = &v
	return s
}

type StopCrawlerInput struct {
	_ struct{} `type:"structure"`

	// Name of the crawler to stop.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopCrawlerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopCrawlerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopCrawlerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopCrawlerInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *StopCrawlerInput) SetName(v string) *StopCrawlerInput {
	s.Name = &v
	return s
}

type StopCrawlerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopCrawlerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopCrawlerOutput) GoString() string {
	return s.String()
}

type StopCrawlerScheduleInput struct {
	_ struct{} `type:"structure"`

	// Name of the crawler whose schedule state to set.
	//
	// CrawlerName is a required field
	CrawlerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopCrawlerScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopCrawlerScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopCrawlerScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopCrawlerScheduleInput"}
	if s.CrawlerName == nil {
		invalidParams.Add(request.NewErrParamRequired("CrawlerName"))
	}
	if s.CrawlerName != nil && len(*s.CrawlerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CrawlerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrawlerName sets the CrawlerName field's value.
func (s *StopCrawlerScheduleInput) SetCrawlerName(v string) *StopCrawlerScheduleInput {
	s.CrawlerName = &v
	return s
}

type StopCrawlerScheduleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopCrawlerScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopCrawlerScheduleOutput) GoString() string {
	return s.String()
}

type StopTriggerInput struct {
	_ struct{} `type:"structure"`

	// The name of the trigger to stop.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopTriggerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopTriggerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopTriggerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopTriggerInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *StopTriggerInput) SetName(v string) *StopTriggerInput {
	s.Name = &v
	return s
}

type StopTriggerOutput struct {
	_ struct{} `type:"structure"`

	// The name of the trigger that was stopped.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StopTriggerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopTriggerOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *StopTriggerOutput) SetName(v string) *StopTriggerOutput {
	s.Name = &v
	return s
}

// Describes the physical storage of table data.
type StorageDescriptor struct {
	_ struct{} `type:"structure"`

	// A list of reducer grouping columns, clustering columns, and bucketing columns
	// in the table.
	BucketColumns []*string `type:"list"`

	// A list of the Columns in the table.
	Columns []*Column `type:"list"`

	// True if the data in the table is compressed, or False if not.
	Compressed *bool `type:"boolean"`

	// The input format: SequenceFileInputFormat (binary), or TextInputFormat, or
	// a custom format.
	InputFormat *string `type:"string"`

	// The physical location of the table. By default this takes the form of the
	// warehouse location, followed by the database location in the warehouse, followed
	// by the table name.
	Location *string `type:"string"`

	// Must be specified if the table contains any dimension columns.
	NumberOfBuckets *int64 `type:"integer"`

	// The output format: SequenceFileOutputFormat (binary), or IgnoreKeyTextOutputFormat,
	// or a custom format.
	OutputFormat *string `type:"string"`

	// User-supplied properties in key-value form.
	Parameters map[string]*string `type:"map"`

	// Serialization/deserialization (SerDe) information.
	SerdeInfo *SerDeInfo `type:"structure"`

	// Information about values that appear very frequently in a column (skewed
	// values).
	SkewedInfo *SkewedInfo `type:"structure"`

	// A list specifying the sort order of each bucket in the table.
	SortColumns []*Order `type:"list"`

	// True if the table data is stored in subdirectories, or False if not.
	StoredAsSubDirectories *bool `type:"boolean"`
}

// String returns the string representation
func (s StorageDescriptor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageDescriptor) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StorageDescriptor) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StorageDescriptor"}
	if s.Columns != nil {
		for i, v := range s.Columns {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Columns", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SerdeInfo != nil {
		if err := s.SerdeInfo.Validate(); err != nil {
			invalidParams.AddNested("SerdeInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.SortColumns != nil {
		for i, v := range s.SortColumns {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SortColumns", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketColumns sets the BucketColumns field's value.
func (s *StorageDescriptor) SetBucketColumns(v []*string) *StorageDescriptor {
	s.BucketColumns = v
	return s
}

// SetColumns sets the Columns field's value.
func (s *StorageDescriptor) SetColumns(v []*Column) *StorageDescriptor {
	s.Columns = v
	return s
}

// SetCompressed sets the Compressed field's value.
func (s *StorageDescriptor) SetCompressed(v bool) *StorageDescriptor {
	s.Compressed = &v
	return s
}

// SetInputFormat sets the InputFormat field's value.
func (s *StorageDescriptor) SetInputFormat(v string) *StorageDescriptor {
	s.InputFormat = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *StorageDescriptor) SetLocation(v string) *StorageDescriptor {
	s.Location = &v
	return s
}

// SetNumberOfBuckets sets the NumberOfBuckets field's value.
func (s *StorageDescriptor) SetNumberOfBuckets(v int64) *StorageDescriptor {
	s.NumberOfBuckets = &v
	return s
}

// SetOutputFormat sets the OutputFormat field's value.
func (s *StorageDescriptor) SetOutputFormat(v string) *StorageDescriptor {
	s.OutputFormat = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *StorageDescriptor) SetParameters(v map[string]*string) *StorageDescriptor {
	s.Parameters = v
	return s
}

// SetSerdeInfo sets the SerdeInfo field's value.
func (s *StorageDescriptor) SetSerdeInfo(v *SerDeInfo) *StorageDescriptor {
	s.SerdeInfo = v
	return s
}

// SetSkewedInfo sets the SkewedInfo field's value.
func (s *StorageDescriptor) SetSkewedInfo(v *SkewedInfo) *StorageDescriptor {
	s.SkewedInfo = v
	return s
}

// SetSortColumns sets the SortColumns field's value.
func (s *StorageDescriptor) SetSortColumns(v []*Order) *StorageDescriptor {
	s.SortColumns = v
	return s
}

// SetStoredAsSubDirectories sets the StoredAsSubDirectories field's value.
func (s *StorageDescriptor) SetStoredAsSubDirectories(v bool) *StorageDescriptor {
	s.StoredAsSubDirectories = &v
	return s
}

// Represents a collection of related data organized in columns and rows.
type Table struct {
	_ struct{} `type:"structure"`

	// Time when the table definition was created in the Data Catalog.
	CreateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Person or entity who created the table.
	CreatedBy *string `min:"1" type:"string"`

	// Name of the metadata database where the table metadata resides. For Hive
	// compatibility, this must be all lowercase.
	DatabaseName *string `min:"1" type:"string"`

	// Description of the table.
	Description *string `type:"string"`

	// Last time the table was accessed. This is usually taken from HDFS, and may
	// not be reliable.
	LastAccessTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Last time column statistics were computed for this table.
	LastAnalyzedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Name of the table. For Hive compatibility, this must be entirely lowercase.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Owner of the table.
	Owner *string `min:"1" type:"string"`

	// Properties associated with this table, as a list of key-value pairs.
	Parameters map[string]*string `type:"map"`

	// A list of columns by which the table is partitioned. Only primitive types
	// are supported as partition keys.
	PartitionKeys []*Column `type:"list"`

	// Retention time for this table.
	Retention *int64 `type:"integer"`

	// A storage descriptor containing information about the physical storage of
	// this table.
	StorageDescriptor *StorageDescriptor `type:"structure"`

	// The type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.).
	TableType *string `type:"string"`

	// Last time the table was updated.
	UpdateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// If the table is a view, the expanded text of the view; otherwise null.
	ViewExpandedText *string `type:"string"`

	// If the table is a view, the original text of the view; otherwise null.
	ViewOriginalText *string `type:"string"`
}

// String returns the string representation
func (s Table) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Table) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *Table) SetCreateTime(v time.Time) *Table {
	s.CreateTime = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *Table) SetCreatedBy(v string) *Table {
	s.CreatedBy = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *Table) SetDatabaseName(v string) *Table {
	s.DatabaseName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Table) SetDescription(v string) *Table {
	s.Description = &v
	return s
}

// SetLastAccessTime sets the LastAccessTime field's value.
func (s *Table) SetLastAccessTime(v time.Time) *Table {
	s.LastAccessTime = &v
	return s
}

// SetLastAnalyzedTime sets the LastAnalyzedTime field's value.
func (s *Table) SetLastAnalyzedTime(v time.Time) *Table {
	s.LastAnalyzedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Table) SetName(v string) *Table {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *Table) SetOwner(v string) *Table {
	s.Owner = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *Table) SetParameters(v map[string]*string) *Table {
	s.Parameters = v
	return s
}

// SetPartitionKeys sets the PartitionKeys field's value.
func (s *Table) SetPartitionKeys(v []*Column) *Table {
	s.PartitionKeys = v
	return s
}

// SetRetention sets the Retention field's value.
func (s *Table) SetRetention(v int64) *Table {
	s.Retention = &v
	return s
}

// SetStorageDescriptor sets the StorageDescriptor field's value.
func (s *Table) SetStorageDescriptor(v *StorageDescriptor) *Table {
	s.StorageDescriptor = v
	return s
}

// SetTableType sets the TableType field's value.
func (s *Table) SetTableType(v string) *Table {
	s.TableType = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *Table) SetUpdateTime(v time.Time) *Table {
	s.UpdateTime = &v
	return s
}

// SetViewExpandedText sets the ViewExpandedText field's value.
func (s *Table) SetViewExpandedText(v string) *Table {
	s.ViewExpandedText = &v
	return s
}

// SetViewOriginalText sets the ViewOriginalText field's value.
func (s *Table) SetViewOriginalText(v string) *Table {
	s.ViewOriginalText = &v
	return s
}

// An error record for table operations.
type TableError struct {
	_ struct{} `type:"structure"`

	// Detail about the error.
	ErrorDetail *ErrorDetail `type:"structure"`

	// Name of the table. For Hive compatibility, this must be entirely lowercase.
	TableName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s TableError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TableError) GoString() string {
	return s.String()
}

// SetErrorDetail sets the ErrorDetail field's value.
func (s *TableError) SetErrorDetail(v *ErrorDetail) *TableError {
	s.ErrorDetail = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *TableError) SetTableName(v string) *TableError {
	s.TableName = &v
	return s
}

// Structure used to create or update the table.
type TableInput struct {
	_ struct{} `type:"structure"`

	// Description of the table.
	Description *string `type:"string"`

	// Last time the table was accessed.
	LastAccessTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Last time column statistics were computed for this table.
	LastAnalyzedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Name of the table. For Hive compatibility, this is folded to lowercase when
	// it is stored.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Owner of the table.
	Owner *string `min:"1" type:"string"`

	// Properties associated with this table, as a list of key-value pairs.
	Parameters map[string]*string `type:"map"`

	// A list of columns by which the table is partitioned. Only primitive types
	// are supported as partition keys.
	PartitionKeys []*Column `type:"list"`

	// Retention time for this table.
	Retention *int64 `type:"integer"`

	// A storage descriptor containing information about the physical storage of
	// this table.
	StorageDescriptor *StorageDescriptor `type:"structure"`

	// The type of this table (EXTERNAL_TABLE, VIRTUAL_VIEW, etc.).
	TableType *string `type:"string"`

	// If the table is a view, the expanded text of the view; otherwise null.
	ViewExpandedText *string `type:"string"`

	// If the table is a view, the original text of the view; otherwise null.
	ViewOriginalText *string `type:"string"`
}

// String returns the string representation
func (s TableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TableInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Owner != nil && len(*s.Owner) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Owner", 1))
	}
	if s.PartitionKeys != nil {
		for i, v := range s.PartitionKeys {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PartitionKeys", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.StorageDescriptor != nil {
		if err := s.StorageDescriptor.Validate(); err != nil {
			invalidParams.AddNested("StorageDescriptor", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *TableInput) SetDescription(v string) *TableInput {
	s.Description = &v
	return s
}

// SetLastAccessTime sets the LastAccessTime field's value.
func (s *TableInput) SetLastAccessTime(v time.Time) *TableInput {
	s.LastAccessTime = &v
	return s
}

// SetLastAnalyzedTime sets the LastAnalyzedTime field's value.
func (s *TableInput) SetLastAnalyzedTime(v time.Time) *TableInput {
	s.LastAnalyzedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *TableInput) SetName(v string) *TableInput {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *TableInput) SetOwner(v string) *TableInput {
	s.Owner = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *TableInput) SetParameters(v map[string]*string) *TableInput {
	s.Parameters = v
	return s
}

// SetPartitionKeys sets the PartitionKeys field's value.
func (s *TableInput) SetPartitionKeys(v []*Column) *TableInput {
	s.PartitionKeys = v
	return s
}

// SetRetention sets the Retention field's value.
func (s *TableInput) SetRetention(v int64) *TableInput {
	s.Retention = &v
	return s
}

// SetStorageDescriptor sets the StorageDescriptor field's value.
func (s *TableInput) SetStorageDescriptor(v *StorageDescriptor) *TableInput {
	s.StorageDescriptor = v
	return s
}

// SetTableType sets the TableType field's value.
func (s *TableInput) SetTableType(v string) *TableInput {
	s.TableType = &v
	return s
}

// SetViewExpandedText sets the ViewExpandedText field's value.
func (s *TableInput) SetViewExpandedText(v string) *TableInput {
	s.ViewExpandedText = &v
	return s
}

// SetViewOriginalText sets the ViewOriginalText field's value.
func (s *TableInput) SetViewOriginalText(v string) *TableInput {
	s.ViewOriginalText = &v
	return s
}

// Specifies a version of a table.
type TableVersion struct {
	_ struct{} `type:"structure"`

	// The table in question
	Table *Table `type:"structure"`

	// The ID value that identifies this table version.
	VersionId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s TableVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TableVersion) GoString() string {
	return s.String()
}

// SetTable sets the Table field's value.
func (s *TableVersion) SetTable(v *Table) *TableVersion {
	s.Table = v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *TableVersion) SetVersionId(v string) *TableVersion {
	s.VersionId = &v
	return s
}

// An error record for table-version operations.
type TableVersionError struct {
	_ struct{} `type:"structure"`

	// Detail about the error.
	ErrorDetail *ErrorDetail `type:"structure"`

	// The name of the table in question.
	TableName *string `min:"1" type:"string"`

	// The ID value of the version in question.
	VersionId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s TableVersionError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TableVersionError) GoString() string {
	return s.String()
}

// SetErrorDetail sets the ErrorDetail field's value.
func (s *TableVersionError) SetErrorDetail(v *ErrorDetail) *TableVersionError {
	s.ErrorDetail = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *TableVersionError) SetTableName(v string) *TableVersionError {
	s.TableName = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *TableVersionError) SetVersionId(v string) *TableVersionError {
	s.VersionId = &v
	return s
}

// Information about a specific trigger.
type Trigger struct {
	_ struct{} `type:"structure"`

	// The actions initiated by this trigger.
	Actions []*Action `type:"list"`

	// A description of this trigger.
	Description *string `type:"string"`

	// Reserved for future use.
	Id *string `min:"1" type:"string"`

	// Name of the trigger.
	Name *string `min:"1" type:"string"`

	// The predicate of this trigger, which defines when it will fire.
	Predicate *Predicate `type:"structure"`

	// A cron expression used to specify the schedule (see Time-Based Schedules
	// for Jobs and Crawlers (http://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html).
	// For example, to run something every day at 12:15 UTC, you would specify:
	// cron(15 12 * * ? *).
	Schedule *string `type:"string"`

	// The current state of the trigger.
	State *string `type:"string" enum:"TriggerState"`

	// The type of trigger that this is.
	Type *string `type:"string" enum:"TriggerType"`
}

// String returns the string representation
func (s Trigger) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Trigger) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *Trigger) SetActions(v []*Action) *Trigger {
	s.Actions = v
	return s
}

// SetDescription sets the Description field's value.
func (s *Trigger) SetDescription(v string) *Trigger {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *Trigger) SetId(v string) *Trigger {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *Trigger) SetName(v string) *Trigger {
	s.Name = &v
	return s
}

// SetPredicate sets the Predicate field's value.
func (s *Trigger) SetPredicate(v *Predicate) *Trigger {
	s.Predicate = v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *Trigger) SetSchedule(v string) *Trigger {
	s.Schedule = &v
	return s
}

// SetState sets the State field's value.
func (s *Trigger) SetState(v string) *Trigger {
	s.State = &v
	return s
}

// SetType sets the Type field's value.
func (s *Trigger) SetType(v string) *Trigger {
	s.Type = &v
	return s
}

// A structure used to provide information used to update a trigger. This object
// will update the the previous trigger definition by overwriting it completely.
type TriggerUpdate struct {
	_ struct{} `type:"structure"`

	// The actions initiated by this trigger.
	Actions []*Action `type:"list"`

	// A description of this trigger.
	Description *string `type:"string"`

	// Reserved for future use.
	Name *string `min:"1" type:"string"`

	// The predicate of this trigger, which defines when it will fire.
	Predicate *Predicate `type:"structure"`

	// A cron expression used to specify the schedule (see Time-Based Schedules
	// for Jobs and Crawlers (http://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html).
	// For example, to run something every day at 12:15 UTC, you would specify:
	// cron(15 12 * * ? *).
	Schedule *string `type:"string"`
}

// String returns the string representation
func (s TriggerUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TriggerUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TriggerUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TriggerUpdate"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Predicate != nil {
		if err := s.Predicate.Validate(); err != nil {
			invalidParams.AddNested("Predicate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *TriggerUpdate) SetActions(v []*Action) *TriggerUpdate {
	s.Actions = v
	return s
}

// SetDescription sets the Description field's value.
func (s *TriggerUpdate) SetDescription(v string) *TriggerUpdate {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *TriggerUpdate) SetName(v string) *TriggerUpdate {
	s.Name = &v
	return s
}

// SetPredicate sets the Predicate field's value.
func (s *TriggerUpdate) SetPredicate(v *Predicate) *TriggerUpdate {
	s.Predicate = v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *TriggerUpdate) SetSchedule(v string) *TriggerUpdate {
	s.Schedule = &v
	return s
}

type UpdateClassifierInput struct {
	_ struct{} `type:"structure"`

	// A GrokClassifier object with updated fields.
	GrokClassifier *UpdateGrokClassifierRequest `type:"structure"`

	// A JsonClassifier object with updated fields.
	JsonClassifier *UpdateJsonClassifierRequest `type:"structure"`

	// An XMLClassifier object with updated fields.
	XMLClassifier *UpdateXMLClassifierRequest `type:"structure"`
}

// String returns the string representation
func (s UpdateClassifierInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateClassifierInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateClassifierInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateClassifierInput"}
	if s.GrokClassifier != nil {
		if err := s.GrokClassifier.Validate(); err != nil {
			invalidParams.AddNested("GrokClassifier", err.(request.ErrInvalidParams))
		}
	}
	if s.JsonClassifier != nil {
		if err := s.JsonClassifier.Validate(); err != nil {
			invalidParams.AddNested("JsonClassifier", err.(request.ErrInvalidParams))
		}
	}
	if s.XMLClassifier != nil {
		if err := s.XMLClassifier.Validate(); err != nil {
			invalidParams.AddNested("XMLClassifier", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGrokClassifier sets the GrokClassifier field's value.
func (s *UpdateClassifierInput) SetGrokClassifier(v *UpdateGrokClassifierRequest) *UpdateClassifierInput {
	s.GrokClassifier = v
	return s
}

// SetJsonClassifier sets the JsonClassifier field's value.
func (s *UpdateClassifierInput) SetJsonClassifier(v *UpdateJsonClassifierRequest) *UpdateClassifierInput {
	s.JsonClassifier = v
	return s
}

// SetXMLClassifier sets the XMLClassifier field's value.
func (s *UpdateClassifierInput) SetXMLClassifier(v *UpdateXMLClassifierRequest) *UpdateClassifierInput {
	s.XMLClassifier = v
	return s
}

type UpdateClassifierOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateClassifierOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateClassifierOutput) GoString() string {
	return s.String()
}

type UpdateConnectionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog in which the connection resides. If none is supplied,
	// the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// A ConnectionInput object that redefines the connection in question.
	//
	// ConnectionInput is a required field
	ConnectionInput *ConnectionInput `type:"structure" required:"true"`

	// The name of the connection definition to update.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConnectionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.ConnectionInput == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionInput"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ConnectionInput != nil {
		if err := s.ConnectionInput.Validate(); err != nil {
			invalidParams.AddNested("ConnectionInput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *UpdateConnectionInput) SetCatalogId(v string) *UpdateConnectionInput {
	s.CatalogId = &v
	return s
}

// SetConnectionInput sets the ConnectionInput field's value.
func (s *UpdateConnectionInput) SetConnectionInput(v *ConnectionInput) *UpdateConnectionInput {
	s.ConnectionInput = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateConnectionInput) SetName(v string) *UpdateConnectionInput {
	s.Name = &v
	return s
}

type UpdateConnectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateConnectionOutput) GoString() string {
	return s.String()
}

type UpdateCrawlerInput struct {
	_ struct{} `type:"structure"`

	// A list of custom classifiers that the user has registered. By default, all
	// classifiers are included in a crawl, but these custom classifiers always
	// override the default classifiers for a given classification.
	Classifiers []*string `type:"list"`

	// Crawler configuration information. This versioned JSON string allows users
	// to specify aspects of a Crawler's behavior.
	//
	// You can use this field to force partitions to inherit metadata such as classification,
	// input format, output format, serde information, and schema from their parent
	// table, rather than detect this information separately for each partition.
	// Use the following JSON string to specify that behavior:
	//
	// Example: '{ "Version": 1.0, "CrawlerOutput": { "Partitions": { "AddOrUpdateBehavior":
	// "InheritFromTable" } } }'
	Configuration *string `type:"string"`

	// The AWS Glue database where results are stored, such as: arn:aws:daylight:us-east-1::database/sometable/*.
	DatabaseName *string `type:"string"`

	// A description of the new crawler.
	Description *string `type:"string"`

	// Name of the new crawler.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The IAM role (or ARN of an IAM role) used by the new crawler to access customer
	// resources.
	Role *string `type:"string"`

	// A cron expression used to specify the schedule (see Time-Based Schedules
	// for Jobs and Crawlers (http://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html).
	// For example, to run something every day at 12:15 UTC, you would specify:
	// cron(15 12 * * ? *).
	Schedule *string `type:"string"`

	// Policy for the crawler's update and deletion behavior.
	SchemaChangePolicy *SchemaChangePolicy `type:"structure"`

	// The table prefix used for catalog tables that are created.
	TablePrefix *string `type:"string"`

	// A list of targets to crawl.
	Targets *CrawlerTargets `type:"structure"`
}

// String returns the string representation
func (s UpdateCrawlerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCrawlerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCrawlerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCrawlerInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClassifiers sets the Classifiers field's value.
func (s *UpdateCrawlerInput) SetClassifiers(v []*string) *UpdateCrawlerInput {
	s.Classifiers = v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *UpdateCrawlerInput) SetConfiguration(v string) *UpdateCrawlerInput {
	s.Configuration = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *UpdateCrawlerInput) SetDatabaseName(v string) *UpdateCrawlerInput {
	s.DatabaseName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateCrawlerInput) SetDescription(v string) *UpdateCrawlerInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateCrawlerInput) SetName(v string) *UpdateCrawlerInput {
	s.Name = &v
	return s
}

// SetRole sets the Role field's value.
func (s *UpdateCrawlerInput) SetRole(v string) *UpdateCrawlerInput {
	s.Role = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *UpdateCrawlerInput) SetSchedule(v string) *UpdateCrawlerInput {
	s.Schedule = &v
	return s
}

// SetSchemaChangePolicy sets the SchemaChangePolicy field's value.
func (s *UpdateCrawlerInput) SetSchemaChangePolicy(v *SchemaChangePolicy) *UpdateCrawlerInput {
	s.SchemaChangePolicy = v
	return s
}

// SetTablePrefix sets the TablePrefix field's value.
func (s *UpdateCrawlerInput) SetTablePrefix(v string) *UpdateCrawlerInput {
	s.TablePrefix = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *UpdateCrawlerInput) SetTargets(v *CrawlerTargets) *UpdateCrawlerInput {
	s.Targets = v
	return s
}

type UpdateCrawlerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateCrawlerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCrawlerOutput) GoString() string {
	return s.String()
}

type UpdateCrawlerScheduleInput struct {
	_ struct{} `type:"structure"`

	// Name of the crawler whose schedule to update.
	//
	// CrawlerName is a required field
	CrawlerName *string `min:"1" type:"string" required:"true"`

	// The updated cron expression used to specify the schedule (see Time-Based
	// Schedules for Jobs and Crawlers (http://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html).
	// For example, to run something every day at 12:15 UTC, you would specify:
	// cron(15 12 * * ? *).
	Schedule *string `type:"string"`
}

// String returns the string representation
func (s UpdateCrawlerScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCrawlerScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCrawlerScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCrawlerScheduleInput"}
	if s.CrawlerName == nil {
		invalidParams.Add(request.NewErrParamRequired("CrawlerName"))
	}
	if s.CrawlerName != nil && len(*s.CrawlerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CrawlerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrawlerName sets the CrawlerName field's value.
func (s *UpdateCrawlerScheduleInput) SetCrawlerName(v string) *UpdateCrawlerScheduleInput {
	s.CrawlerName = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *UpdateCrawlerScheduleInput) SetSchedule(v string) *UpdateCrawlerScheduleInput {
	s.Schedule = &v
	return s
}

type UpdateCrawlerScheduleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateCrawlerScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCrawlerScheduleOutput) GoString() string {
	return s.String()
}

type UpdateDatabaseInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog in which the metadata database resides. If none
	// is supplied, the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// A DatabaseInput object specifying the new definition of the metadata database
	// in the catalog.
	//
	// DatabaseInput is a required field
	DatabaseInput *DatabaseInput `type:"structure" required:"true"`

	// The name of the database to update in the catalog. For Hive compatibility,
	// this is folded to lowercase.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateDatabaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDatabaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDatabaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDatabaseInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseInput == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseInput"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.DatabaseInput != nil {
		if err := s.DatabaseInput.Validate(); err != nil {
			invalidParams.AddNested("DatabaseInput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *UpdateDatabaseInput) SetCatalogId(v string) *UpdateDatabaseInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseInput sets the DatabaseInput field's value.
func (s *UpdateDatabaseInput) SetDatabaseInput(v *DatabaseInput) *UpdateDatabaseInput {
	s.DatabaseInput = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateDatabaseInput) SetName(v string) *UpdateDatabaseInput {
	s.Name = &v
	return s
}

type UpdateDatabaseOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDatabaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDatabaseOutput) GoString() string {
	return s.String()
}

type UpdateDevEndpointInput struct {
	_ struct{} `type:"structure"`

	// Custom Python or Java libraries to be loaded in the DevEndpoint.
	CustomLibraries *DevEndpointCustomLibraries `type:"structure"`

	// The name of the DevEndpoint to be updated.
	//
	// EndpointName is a required field
	EndpointName *string `type:"string" required:"true"`

	// The public key for the DevEndpoint to use.
	PublicKey *string `type:"string"`

	// True if the list of custom libraries to be loaded in the development endpoint
	// needs to be updated, or False otherwise.
	UpdateEtlLibraries *bool `type:"boolean"`
}

// String returns the string representation
func (s UpdateDevEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDevEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDevEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDevEndpointInput"}
	if s.EndpointName == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomLibraries sets the CustomLibraries field's value.
func (s *UpdateDevEndpointInput) SetCustomLibraries(v *DevEndpointCustomLibraries) *UpdateDevEndpointInput {
	s.CustomLibraries = v
	return s
}

// SetEndpointName sets the EndpointName field's value.
func (s *UpdateDevEndpointInput) SetEndpointName(v string) *UpdateDevEndpointInput {
	s.EndpointName = &v
	return s
}

// SetPublicKey sets the PublicKey field's value.
func (s *UpdateDevEndpointInput) SetPublicKey(v string) *UpdateDevEndpointInput {
	s.PublicKey = &v
	return s
}

// SetUpdateEtlLibraries sets the UpdateEtlLibraries field's value.
func (s *UpdateDevEndpointInput) SetUpdateEtlLibraries(v bool) *UpdateDevEndpointInput {
	s.UpdateEtlLibraries = &v
	return s
}

type UpdateDevEndpointOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDevEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDevEndpointOutput) GoString() string {
	return s.String()
}

// Specifies a grok classifier to update when passed to UpdateClassifier.
type UpdateGrokClassifierRequest struct {
	_ struct{} `type:"structure"`

	// An identifier of the data format that the classifier matches, such as Twitter,
	// JSON, Omniture logs, Amazon CloudWatch Logs, and so on.
	Classification *string `type:"string"`

	// Optional custom grok patterns used by this classifier.
	CustomPatterns *string `type:"string"`

	// The grok pattern used by this classifier.
	GrokPattern *string `min:"1" type:"string"`

	// The name of the GrokClassifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateGrokClassifierRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGrokClassifierRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGrokClassifierRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGrokClassifierRequest"}
	if s.GrokPattern != nil && len(*s.GrokPattern) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GrokPattern", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClassification sets the Classification field's value.
func (s *UpdateGrokClassifierRequest) SetClassification(v string) *UpdateGrokClassifierRequest {
	s.Classification = &v
	return s
}

// SetCustomPatterns sets the CustomPatterns field's value.
func (s *UpdateGrokClassifierRequest) SetCustomPatterns(v string) *UpdateGrokClassifierRequest {
	s.CustomPatterns = &v
	return s
}

// SetGrokPattern sets the GrokPattern field's value.
func (s *UpdateGrokClassifierRequest) SetGrokPattern(v string) *UpdateGrokClassifierRequest {
	s.GrokPattern = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateGrokClassifierRequest) SetName(v string) *UpdateGrokClassifierRequest {
	s.Name = &v
	return s
}

type UpdateJobInput struct {
	_ struct{} `type:"structure"`

	// Name of the job definition to update.
	//
	// JobName is a required field
	JobName *string `min:"1" type:"string" required:"true"`

	// Specifies the values with which to update the job.
	//
	// JobUpdate is a required field
	JobUpdate *JobUpdate `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateJobInput"}
	if s.JobName == nil {
		invalidParams.Add(request.NewErrParamRequired("JobName"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.JobUpdate == nil {
		invalidParams.Add(request.NewErrParamRequired("JobUpdate"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *UpdateJobInput) SetJobName(v string) *UpdateJobInput {
	s.JobName = &v
	return s
}

// SetJobUpdate sets the JobUpdate field's value.
func (s *UpdateJobInput) SetJobUpdate(v *JobUpdate) *UpdateJobInput {
	s.JobUpdate = v
	return s
}

type UpdateJobOutput struct {
	_ struct{} `type:"structure"`

	// Returns the name of the updated job.
	JobName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateJobOutput) GoString() string {
	return s.String()
}

// SetJobName sets the JobName field's value.
func (s *UpdateJobOutput) SetJobName(v string) *UpdateJobOutput {
	s.JobName = &v
	return s
}

// Specifies a JSON classifier to be updated.
type UpdateJsonClassifierRequest struct {
	_ struct{} `type:"structure"`

	// A JsonPath string defining the JSON data for the classifier to classify.
	// AWS Glue supports a subset of JsonPath, as described in Writing JsonPath
	// Custom Classifiers (https://docs.aws.amazon.com/glue/latest/dg/custom-classifier.html#custom-classifier-json).
	JsonPath *string `type:"string"`

	// The name of the classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateJsonClassifierRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateJsonClassifierRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateJsonClassifierRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateJsonClassifierRequest"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJsonPath sets the JsonPath field's value.
func (s *UpdateJsonClassifierRequest) SetJsonPath(v string) *UpdateJsonClassifierRequest {
	s.JsonPath = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateJsonClassifierRequest) SetName(v string) *UpdateJsonClassifierRequest {
	s.Name = &v
	return s
}

type UpdatePartitionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the partition to be updated resides. If
	// none is supplied, the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The name of the catalog database in which the table in question resides.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The new partition object to which to update the partition.
	//
	// PartitionInput is a required field
	PartitionInput *PartitionInput `type:"structure" required:"true"`

	// A list of the values defining the partition.
	//
	// PartitionValueList is a required field
	PartitionValueList []*string `type:"list" required:"true"`

	// The name of the table where the partition to be updated is located.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdatePartitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePartitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePartitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePartitionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.PartitionInput == nil {
		invalidParams.Add(request.NewErrParamRequired("PartitionInput"))
	}
	if s.PartitionValueList == nil {
		invalidParams.Add(request.NewErrParamRequired("PartitionValueList"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}
	if s.PartitionInput != nil {
		if err := s.PartitionInput.Validate(); err != nil {
			invalidParams.AddNested("PartitionInput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *UpdatePartitionInput) SetCatalogId(v string) *UpdatePartitionInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *UpdatePartitionInput) SetDatabaseName(v string) *UpdatePartitionInput {
	s.DatabaseName = &v
	return s
}

// SetPartitionInput sets the PartitionInput field's value.
func (s *UpdatePartitionInput) SetPartitionInput(v *PartitionInput) *UpdatePartitionInput {
	s.PartitionInput = v
	return s
}

// SetPartitionValueList sets the PartitionValueList field's value.
func (s *UpdatePartitionInput) SetPartitionValueList(v []*string) *UpdatePartitionInput {
	s.PartitionValueList = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *UpdatePartitionInput) SetTableName(v string) *UpdatePartitionInput {
	s.TableName = &v
	return s
}

type UpdatePartitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdatePartitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePartitionOutput) GoString() string {
	return s.String()
}

type UpdateTableInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the table resides. If none is supplied,
	// the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The name of the catalog database in which the table resides. For Hive compatibility,
	// this name is entirely lowercase.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// By default, UpdateTable always creates an archived version of the table before
	// updating it. If skipArchive is set to true, however, UpdateTable does not
	// create the archived version.
	SkipArchive *bool `type:"boolean"`

	// An updated TableInput object to define the metadata table in the catalog.
	//
	// TableInput is a required field
	TableInput *TableInput `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTableInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.TableInput == nil {
		invalidParams.Add(request.NewErrParamRequired("TableInput"))
	}
	if s.TableInput != nil {
		if err := s.TableInput.Validate(); err != nil {
			invalidParams.AddNested("TableInput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *UpdateTableInput) SetCatalogId(v string) *UpdateTableInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *UpdateTableInput) SetDatabaseName(v string) *UpdateTableInput {
	s.DatabaseName = &v
	return s
}

// SetSkipArchive sets the SkipArchive field's value.
func (s *UpdateTableInput) SetSkipArchive(v bool) *UpdateTableInput {
	s.SkipArchive = &v
	return s
}

// SetTableInput sets the TableInput field's value.
func (s *UpdateTableInput) SetTableInput(v *TableInput) *UpdateTableInput {
	s.TableInput = v
	return s
}

type UpdateTableOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTableOutput) GoString() string {
	return s.String()
}

type UpdateTriggerInput struct {
	_ struct{} `type:"structure"`

	// The name of the trigger to update.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The new values with which to update the trigger.
	//
	// TriggerUpdate is a required field
	TriggerUpdate *TriggerUpdate `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateTriggerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTriggerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTriggerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTriggerInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.TriggerUpdate == nil {
		invalidParams.Add(request.NewErrParamRequired("TriggerUpdate"))
	}
	if s.TriggerUpdate != nil {
		if err := s.TriggerUpdate.Validate(); err != nil {
			invalidParams.AddNested("TriggerUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *UpdateTriggerInput) SetName(v string) *UpdateTriggerInput {
	s.Name = &v
	return s
}

// SetTriggerUpdate sets the TriggerUpdate field's value.
func (s *UpdateTriggerInput) SetTriggerUpdate(v *TriggerUpdate) *UpdateTriggerInput {
	s.TriggerUpdate = v
	return s
}

type UpdateTriggerOutput struct {
	_ struct{} `type:"structure"`

	// The resulting trigger definition.
	Trigger *Trigger `type:"structure"`
}

// String returns the string representation
func (s UpdateTriggerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTriggerOutput) GoString() string {
	return s.String()
}

// SetTrigger sets the Trigger field's value.
func (s *UpdateTriggerOutput) SetTrigger(v *Trigger) *UpdateTriggerOutput {
	s.Trigger = v
	return s
}

type UpdateUserDefinedFunctionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the function to be updated is located. If
	// none is supplied, the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The name of the catalog database where the function to be updated is located.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// A FunctionInput object that re-defines the function in the Data Catalog.
	//
	// FunctionInput is a required field
	FunctionInput *UserDefinedFunctionInput `type:"structure" required:"true"`

	// The name of the function.
	//
	// FunctionName is a required field
	FunctionName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserDefinedFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserDefinedFunctionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserDefinedFunctionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserDefinedFunctionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.FunctionInput == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionInput"))
	}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.FunctionInput != nil {
		if err := s.FunctionInput.Validate(); err != nil {
			invalidParams.AddNested("FunctionInput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *UpdateUserDefinedFunctionInput) SetCatalogId(v string) *UpdateUserDefinedFunctionInput {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *UpdateUserDefinedFunctionInput) SetDatabaseName(v string) *UpdateUserDefinedFunctionInput {
	s.DatabaseName = &v
	return s
}

// SetFunctionInput sets the FunctionInput field's value.
func (s *UpdateUserDefinedFunctionInput) SetFunctionInput(v *UserDefinedFunctionInput) *UpdateUserDefinedFunctionInput {
	s.FunctionInput = v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *UpdateUserDefinedFunctionInput) SetFunctionName(v string) *UpdateUserDefinedFunctionInput {
	s.FunctionName = &v
	return s
}

type UpdateUserDefinedFunctionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateUserDefinedFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserDefinedFunctionOutput) GoString() string {
	return s.String()
}

// Specifies an XML classifier to be updated.
type UpdateXMLClassifierRequest struct {
	_ struct{} `type:"structure"`

	// An identifier of the data format that the classifier matches.
	Classification *string `type:"string"`

	// The name of the classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The XML tag designating the element that contains each record in an XML document
	// being parsed. Note that this cannot identify a self-closing element (closed
	// by />). An empty row element that contains only attributes can be parsed
	// as long as it ends with a closing tag (for example, <row item_a="A" item_b="B"></row>
	// is okay, but <row item_a="A" item_b="B" /> is not).
	RowTag *string `type:"string"`
}

// String returns the string representation
func (s UpdateXMLClassifierRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateXMLClassifierRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateXMLClassifierRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateXMLClassifierRequest"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClassification sets the Classification field's value.
func (s *UpdateXMLClassifierRequest) SetClassification(v string) *UpdateXMLClassifierRequest {
	s.Classification = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateXMLClassifierRequest) SetName(v string) *UpdateXMLClassifierRequest {
	s.Name = &v
	return s
}

// SetRowTag sets the RowTag field's value.
func (s *UpdateXMLClassifierRequest) SetRowTag(v string) *UpdateXMLClassifierRequest {
	s.RowTag = &v
	return s
}

// Represents the equivalent of a Hive user-defined function (UDF) definition.
type UserDefinedFunction struct {
	_ struct{} `type:"structure"`

	// The Java class that contains the function code.
	ClassName *string `min:"1" type:"string"`

	// The time at which the function was created.
	CreateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name of the function.
	FunctionName *string `min:"1" type:"string"`

	// The owner of the function.
	OwnerName *string `min:"1" type:"string"`

	// The owner type.
	OwnerType *string `type:"string" enum:"PrincipalType"`

	// The resource URIs for the function.
	ResourceUris []*ResourceUri `type:"list"`
}

// String returns the string representation
func (s UserDefinedFunction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserDefinedFunction) GoString() string {
	return s.String()
}

// SetClassName sets the ClassName field's value.
func (s *UserDefinedFunction) SetClassName(v string) *UserDefinedFunction {
	s.ClassName = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *UserDefinedFunction) SetCreateTime(v time.Time) *UserDefinedFunction {
	s.CreateTime = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *UserDefinedFunction) SetFunctionName(v string) *UserDefinedFunction {
	s.FunctionName = &v
	return s
}

// SetOwnerName sets the OwnerName field's value.
func (s *UserDefinedFunction) SetOwnerName(v string) *UserDefinedFunction {
	s.OwnerName = &v
	return s
}

// SetOwnerType sets the OwnerType field's value.
func (s *UserDefinedFunction) SetOwnerType(v string) *UserDefinedFunction {
	s.OwnerType = &v
	return s
}

// SetResourceUris sets the ResourceUris field's value.
func (s *UserDefinedFunction) SetResourceUris(v []*ResourceUri) *UserDefinedFunction {
	s.ResourceUris = v
	return s
}

// A structure used to create or updata a user-defined function.
type UserDefinedFunctionInput struct {
	_ struct{} `type:"structure"`

	// The Java class that contains the function code.
	ClassName *string `min:"1" type:"string"`

	// The name of the function.
	FunctionName *string `min:"1" type:"string"`

	// The owner of the function.
	OwnerName *string `min:"1" type:"string"`

	// The owner type.
	OwnerType *string `type:"string" enum:"PrincipalType"`

	// The resource URIs for the function.
	ResourceUris []*ResourceUri `type:"list"`
}

// String returns the string representation
func (s UserDefinedFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserDefinedFunctionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserDefinedFunctionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UserDefinedFunctionInput"}
	if s.ClassName != nil && len(*s.ClassName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClassName", 1))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.OwnerName != nil && len(*s.OwnerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OwnerName", 1))
	}
	if s.ResourceUris != nil {
		for i, v := range s.ResourceUris {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceUris", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClassName sets the ClassName field's value.
func (s *UserDefinedFunctionInput) SetClassName(v string) *UserDefinedFunctionInput {
	s.ClassName = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *UserDefinedFunctionInput) SetFunctionName(v string) *UserDefinedFunctionInput {
	s.FunctionName = &v
	return s
}

// SetOwnerName sets the OwnerName field's value.
func (s *UserDefinedFunctionInput) SetOwnerName(v string) *UserDefinedFunctionInput {
	s.OwnerName = &v
	return s
}

// SetOwnerType sets the OwnerType field's value.
func (s *UserDefinedFunctionInput) SetOwnerType(v string) *UserDefinedFunctionInput {
	s.OwnerType = &v
	return s
}

// SetResourceUris sets the ResourceUris field's value.
func (s *UserDefinedFunctionInput) SetResourceUris(v []*ResourceUri) *UserDefinedFunctionInput {
	s.ResourceUris = v
	return s
}

// A classifier for XML content.
type XMLClassifier struct {
	_ struct{} `type:"structure"`

	// An identifier of the data format that the classifier matches.
	//
	// Classification is a required field
	Classification *string `type:"string" required:"true"`

	// The time this classifier was registered.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The time this classifier was last updated.
	LastUpdated *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name of the classifier.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The XML tag designating the element that contains each record in an XML document
	// being parsed. Note that this cannot identify a self-closing element (closed
	// by />). An empty row element that contains only attributes can be parsed
	// as long as it ends with a closing tag (for example, <row item_a="A" item_b="B"></row>
	// is okay, but <row item_a="A" item_b="B" /> is not).
	RowTag *string `type:"string"`

	// The version of this classifier.
	Version *int64 `type:"long"`
}

// String returns the string representation
func (s XMLClassifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s XMLClassifier) GoString() string {
	return s.String()
}

// SetClassification sets the Classification field's value.
func (s *XMLClassifier) SetClassification(v string) *XMLClassifier {
	s.Classification = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *XMLClassifier) SetCreationTime(v time.Time) *XMLClassifier {
	s.CreationTime = &v
	return s
}

// SetLastUpdated sets the LastUpdated field's value.
func (s *XMLClassifier) SetLastUpdated(v time.Time) *XMLClassifier {
	s.LastUpdated = &v
	return s
}

// SetName sets the Name field's value.
func (s *XMLClassifier) SetName(v string) *XMLClassifier {
	s.Name = &v
	return s
}

// SetRowTag sets the RowTag field's value.
func (s *XMLClassifier) SetRowTag(v string) *XMLClassifier {
	s.RowTag = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *XMLClassifier) SetVersion(v int64) *XMLClassifier {
	s.Version = &v
	return s
}

const (
	// ConnectionPropertyKeyHost is a ConnectionPropertyKey enum value
	ConnectionPropertyKeyHost = "HOST"

	// ConnectionPropertyKeyPort is a ConnectionPropertyKey enum value
	ConnectionPropertyKeyPort = "PORT"

	// ConnectionPropertyKeyUsername is a ConnectionPropertyKey enum value
	ConnectionPropertyKeyUsername = "USERNAME"

	// ConnectionPropertyKeyPassword is a ConnectionPropertyKey enum value
	ConnectionPropertyKeyPassword = "PASSWORD"

	// ConnectionPropertyKeyJdbcDriverJarUri is a ConnectionPropertyKey enum value
	ConnectionPropertyKeyJdbcDriverJarUri = "JDBC_DRIVER_JAR_URI"

	// ConnectionPropertyKeyJdbcDriverClassName is a ConnectionPropertyKey enum value
	ConnectionPropertyKeyJdbcDriverClassName = "JDBC_DRIVER_CLASS_NAME"

	// ConnectionPropertyKeyJdbcEngine is a ConnectionPropertyKey enum value
	ConnectionPropertyKeyJdbcEngine = "JDBC_ENGINE"

	// ConnectionPropertyKeyJdbcEngineVersion is a ConnectionPropertyKey enum value
	ConnectionPropertyKeyJdbcEngineVersion = "JDBC_ENGINE_VERSION"

	// ConnectionPropertyKeyConfigFiles is a ConnectionPropertyKey enum value
	ConnectionPropertyKeyConfigFiles = "CONFIG_FILES"

	// ConnectionPropertyKeyInstanceId is a ConnectionPropertyKey enum value
	ConnectionPropertyKeyInstanceId = "INSTANCE_ID"

	// ConnectionPropertyKeyJdbcConnectionUrl is a ConnectionPropertyKey enum value
	ConnectionPropertyKeyJdbcConnectionUrl = "JDBC_CONNECTION_URL"
)

const (
	// ConnectionTypeJdbc is a ConnectionType enum value
	ConnectionTypeJdbc = "JDBC"

	// ConnectionTypeSftp is a ConnectionType enum value
	ConnectionTypeSftp = "SFTP"
)

const (
	// CrawlerStateReady is a CrawlerState enum value
	CrawlerStateReady = "READY"

	// CrawlerStateRunning is a CrawlerState enum value
	CrawlerStateRunning = "RUNNING"

	// CrawlerStateStopping is a CrawlerState enum value
	CrawlerStateStopping = "STOPPING"
)

const (
	// DeleteBehaviorLog is a DeleteBehavior enum value
	DeleteBehaviorLog = "LOG"

	// DeleteBehaviorDeleteFromDatabase is a DeleteBehavior enum value
	DeleteBehaviorDeleteFromDatabase = "DELETE_FROM_DATABASE"

	// DeleteBehaviorDeprecateInDatabase is a DeleteBehavior enum value
	DeleteBehaviorDeprecateInDatabase = "DEPRECATE_IN_DATABASE"
)

const (
	// JobRunStateStarting is a JobRunState enum value
	JobRunStateStarting = "STARTING"

	// JobRunStateRunning is a JobRunState enum value
	JobRunStateRunning = "RUNNING"

	// JobRunStateStopping is a JobRunState enum value
	JobRunStateStopping = "STOPPING"

	// JobRunStateStopped is a JobRunState enum value
	JobRunStateStopped = "STOPPED"

	// JobRunStateSucceeded is a JobRunState enum value
	JobRunStateSucceeded = "SUCCEEDED"

	// JobRunStateFailed is a JobRunState enum value
	JobRunStateFailed = "FAILED"
)

const (
	// LanguagePython is a Language enum value
	LanguagePython = "PYTHON"

	// LanguageScala is a Language enum value
	LanguageScala = "SCALA"
)

const (
	// LastCrawlStatusSucceeded is a LastCrawlStatus enum value
	LastCrawlStatusSucceeded = "SUCCEEDED"

	// LastCrawlStatusCancelled is a LastCrawlStatus enum value
	LastCrawlStatusCancelled = "CANCELLED"

	// LastCrawlStatusFailed is a LastCrawlStatus enum value
	LastCrawlStatusFailed = "FAILED"
)

const (
	// LogicalAnd is a Logical enum value
	LogicalAnd = "AND"

	// LogicalAny is a Logical enum value
	LogicalAny = "ANY"
)

const (
	// LogicalOperatorEquals is a LogicalOperator enum value
	LogicalOperatorEquals = "EQUALS"
)

const (
	// PrincipalTypeUser is a PrincipalType enum value
	PrincipalTypeUser = "USER"

	// PrincipalTypeRole is a PrincipalType enum value
	PrincipalTypeRole = "ROLE"

	// PrincipalTypeGroup is a PrincipalType enum value
	PrincipalTypeGroup = "GROUP"
)

const (
	// ResourceTypeJar is a ResourceType enum value
	ResourceTypeJar = "JAR"

	// ResourceTypeFile is a ResourceType enum value
	ResourceTypeFile = "FILE"

	// ResourceTypeArchive is a ResourceType enum value
	ResourceTypeArchive = "ARCHIVE"
)

const (
	// ScheduleStateScheduled is a ScheduleState enum value
	ScheduleStateScheduled = "SCHEDULED"

	// ScheduleStateNotScheduled is a ScheduleState enum value
	ScheduleStateNotScheduled = "NOT_SCHEDULED"

	// ScheduleStateTransitioning is a ScheduleState enum value
	ScheduleStateTransitioning = "TRANSITIONING"
)

const (
	// TriggerStateCreating is a TriggerState enum value
	TriggerStateCreating = "CREATING"

	// TriggerStateCreated is a TriggerState enum value
	TriggerStateCreated = "CREATED"

	// TriggerStateActivating is a TriggerState enum value
	TriggerStateActivating = "ACTIVATING"

	// TriggerStateActivated is a TriggerState enum value
	TriggerStateActivated = "ACTIVATED"

	// TriggerStateDeactivating is a TriggerState enum value
	TriggerStateDeactivating = "DEACTIVATING"

	// TriggerStateDeactivated is a TriggerState enum value
	TriggerStateDeactivated = "DEACTIVATED"

	// TriggerStateDeleting is a TriggerState enum value
	TriggerStateDeleting = "DELETING"

	// TriggerStateUpdating is a TriggerState enum value
	TriggerStateUpdating = "UPDATING"
)

const (
	// TriggerTypeScheduled is a TriggerType enum value
	TriggerTypeScheduled = "SCHEDULED"

	// TriggerTypeConditional is a TriggerType enum value
	TriggerTypeConditional = "CONDITIONAL"

	// TriggerTypeOnDemand is a TriggerType enum value
	TriggerTypeOnDemand = "ON_DEMAND"
)

const (
	// UpdateBehaviorLog is a UpdateBehavior enum value
	UpdateBehaviorLog = "LOG"

	// UpdateBehaviorUpdateInDatabase is a UpdateBehavior enum value
	UpdateBehaviorUpdateInDatabase = "UPDATE_IN_DATABASE"
)
