BEGIN {
        prev_prev_lvl = "";
        prev_lvl = "";
        prev_htmli = "";
	first_prev = 1;
      }
{
  lvl = $0;
# print "LVL " lvl | "cat 1>&2";
  if (prev_lvl != "")
    {
      print_lvl(prev_lvl, prev_htmli, prev_prev_lvl, lvl);
    }

  htmli = "";
  line = "";

  while (getline line < ("../reports/" lvl "/=details.htmli"))
    {
# print "LINE " lvl | "cat 1>&2";
      gsub("@TARGET@", "new_window", line);
      gsub("@BROWSERREPOS@", browser, line);
      gsub("@REPORTS@", "../reports", line);
      gsub("@NOTESCOLOR@", note_color, line);
      gsub("@PATCHSET@", "../reports/" lvl, line);
      if (htmli == "")
        htmli = line;
      else
        htmli = htmli "\n" line;
    }
  close("../reports/" lvl "/=details.htmli");
  htmli = htmli "\n";

  prev_prev_lvl = prev_lvl;
  prev_lvl = lvl;
  prev_htmli = htmli;
}

END {
# print "END " | "cat 1>&2";

      print_lvl(prev_lvl, prev_htmli, prev_prev_lvl, "");
    }

function print_lvl(lvl, htmli, prev_lvl, next_lvl)
{
# print "PRINT LVL " lvl | "cat 1>&2";
  print "<tr>";
  print "<td>";

  if (prev_lvl == "")
    prev_link = "";
  else if (first_prev)
    {
      prev_link = "<a href=\"#top-of-page\"><small>prev</small></a>";
      first_prev = 0;
    }
  else
    prev_link = "<a href=\"#" prev_lvl "\"><small>prev</small></a>";

  if (next_lvl == "")
    next_link = "";
  else
    next_link = "<a href=\"#" next_lvl "\"><small>next</small></a>";

  nav_links = "<a name=\"" lvl "\"></a>" prev_link " " next_link;
  print "<p align=\"right\">" nav_links;

  patchset_link = "<a target=\"new_window\" href=\"../reports/" lvl "/=REPORT.html\"><small>patch set</small></a>";
  source_link = "<a target=\"new_window\" href=\"" library_root "/" version "--" lvl "\"><small>source</small></a>";

  changelog_link = "<a target=\"new_window\" href=\"../changelog.html#" lvl "\"><small><code>ChangeLog</code></small></a>";

  xtra_links = patchset_link " " source_link " " changelog_link;

  for (x in htmli_parts)
    delete htmli_parts[x];

  n_parts = split(htmli, htmli_parts, "@XTRALINKS@");
  for (x = 1; x <= n_parts; ++x)
    {
      printf("%s", htmli_parts[x]);
      if (x < n_parts)
        printf("%s", xtra_links);
    }
  print "</td>";
  print "</tr>";
}

# tag: Tom Lord Mon Jan 28 06:11:50 2002 (web/details.awk)
#
