# Arch Perl library, Copyright (C) 2004 Mikhael Goikhman, Enno Cramer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.006;
use strict;
use warnings;

package ArchWay::Util::Dialogs;

use Glib qw(TRUE FALSE);
use Gtk2;

sub create_dialog ($$;%) {
	my $self = shift;
	my ($title, %args) = @_;

	my @btns  = exists $args{buttons} ?
		@{$args{buttons}} : qw(gtk-ok ok gtk-cancel cancel);

	my $dlg = Gtk2::Dialog->new(
		$title, $self->isa('Gtk2::Window') ? $self : undef,
		$args{flags} || [ 'destroy-with-parent' ],
		@btns
	);

	return $dlg;
}

sub msg_dialog ($$$;%) {
	my $self = shift;
	my ($type, $msg, %args) = @_;

	my $markup = $args{title} ? "<b>$args{title}</b>\n" . $msg : $msg;

	my $dialog = Gtk2::MessageDialog->new_with_markup(
		$self->isa('Gtk2::Window') ? $self : undef,
		$args{flags} || [ qw(destroy-with-parent modal) ],
		$type,
		$args{buttons} || 'ok',
		$markup
	);

	my $answer = $dialog->run;

	$dialog->destroy;

	return $answer;
}

sub widget_dialog ($$$;%) {
	my $self = shift;
	my ($title, $widget, %args) = @_;

	$args{buttons} ||= [ qw(gtk-close close) ];

	my $dlg = $self->create_dialog($title, %args);

	$dlg->signal_connect('response' => sub {
		$dlg->destroy if $_[1] eq 'close';
	});

	my $scroll = ArchWay::Widget::FrameScroll->new($widget, undef, 1);
	$dlg->vbox->pack_start($scroll, TRUE, TRUE, 0);

	return $dlg;
}

sub confirm ($$;$) {
	my $self  = shift;
	my $msg   = shift; 
	my %flags = ( buttons => 'yes-no' );

	$flags{title} = shift
		if @_;

	my $answer = $self->msg_dialog(
		'question', $msg,
		%flags,
	);

	return $answer eq 'yes';
}

sub info ($$;$) {
	my $self  = shift;
	my $msg   = shift;
	my %flags = ( buttons => 'ok' );

	$flags{title} = shift
		if @_;

	my $answer = $self->msg_dialog(
		'info', $msg,
		%flags,
	);
}

sub alert ($$;$) {
	my $self  = shift;
	my $msg   = shift;
	my %flags = ( buttons => 'ok' );

	$flags{title} = shift
		if @_;

	my $answer = $self->msg_dialog(
		'warning', $msg,
		%flags,
	);
}

sub prompt_create_dir ($;$) {
	my $self  = shift;
	my $title = shift || 'Please enter a directory name';

	my $path;

	my $dialog = Gtk2::FileChooserDialog->new(
		$title, $self->isa('Gtk2::Window') ? $self : undef, 'create-folder',
		'gtk-cancel', 'cancel',
		'gtk-ok', 'accept',
	);

	$path = $dialog->get_filename
		if ($dialog->run eq 'accept');

	$dialog->destroy;

	return $path;
}

sub prompt_select_dir ($;$) {
	my $self  = shift;
	my $title = shift || 'Please choose a directory';

	my $path;

	my $dialog = Gtk2::FileChooserDialog->new(
		$title, $self->isa('Gtk2::Window') ? $self : undef, 'select-folder',
		'gtk-cancel', 'cancel',
		'gtk-open', 'accept',
	);

	$path = $dialog->get_filename
		if ($dialog->run eq 'accept');

	$dialog->destroy;

	return $path;
}

sub prompt_string ($$;%) {
	my $self   = shift;
	my $prompt = shift;
	my %args   = @_;

	my $response;
	
	my $icon = Gtk2::Image->new_from_stock('gtk-dialog-question', 'dialog');

	my $label = Gtk2::Label->new;
	$label->set_markup("<b>$prompt:</b>");
	$label->set_alignment(0.0, 1.0);

	my $widget = Gtk2::Entry->new;
	$widget->set_size_request(200, -1);
	$widget->set_text($args{default});

	my $vbox = Gtk2::VBox->new;
	$vbox->set_border_width(7);
	$vbox->pack_start($label, TRUE, TRUE, 0);
	$vbox->pack_start($widget, TRUE, TRUE, 0);

	my $hbox = Gtk2::HBox->new;
	$hbox->set_border_width(7);
	$hbox->pack_start($icon, TRUE, TRUE, 0);
	$hbox->pack_start($vbox, TRUE, TRUE, 0);

	my $dialog = $self->create_dialog(
		$args{title} || $prompt,
		flags => [ qw(destroy-with-parent no-separator) ],
	);
	$dialog->set(resizable => FALSE);
	$dialog->vbox->pack_start($hbox, TRUE, TRUE, 0);
	$dialog->show_all;

	$response = $widget->get_text
		if $dialog->run eq 'ok';

	$dialog->destroy;

	return $response;
}

1;

__END__
