# -*- coding: iso-8859-15 -*-
# generated by wxGlade HG on Tue May 19 21:48:13 2009

#
# ArcGui main window threads
#

"""
Implements the arcgui user interface threads.
"""

import os, sys, threading, types, wx, shutil

from datetime import datetime

try:
    import arc
except:
    print "ARC1 Python binding not found. Please check search paths."
    sys.exit(-1)

# New events defined by ARCGUI

EVT_PROGRESS_UPDATE_TYPE = wx.NewEventType()
EVT_PROGRESS_UPDATE = wx.PyEventBinder(EVT_PROGRESS_UPDATE_TYPE, 1)
EVT_LOG_UPDATE_TYPE = wx.NewEventType()
EVT_LOG_UPDATE = wx.PyEventBinder(EVT_LOG_UPDATE_TYPE, 1)
EVT_UPDATE_STATUS_DONE_TYPE = wx.NewEventType()
EVT_UPDATE_STATUS_DONE = wx.PyEventBinder(EVT_UPDATE_STATUS_DONE_TYPE, 1)
EVT_RETRIEVE_JOBS_DONE_TYPE = wx.NewEventType()
EVT_RETRIEVE_JOBS_DONE = wx.PyEventBinder(EVT_RETRIEVE_JOBS_DONE_TYPE, 1)
EVT_CLEAN_JOBS_DONE_TYPE = wx.NewEventType()
EVT_CLEAN_JOBS_DONE = wx.PyEventBinder(EVT_CLEAN_JOBS_DONE_TYPE, 1)
EVT_KILL_JOBS_DONE_TYPE = wx.NewEventType()
EVT_KILL_JOBS_DONE = wx.PyEventBinder(EVT_KILL_JOBS_DONE_TYPE, 1)
EVT_SUBMIT_JOB_DONE_TYPE = wx.NewEventType()
EVT_SUBMIT_JOB_DONE = wx.PyEventBinder(EVT_SUBMIT_JOB_DONE_TYPE, 1)

class UpdateProgressEvent(wx.PyCommandEvent):
    """
    Event sent by worker threads to update progress.
    """
    def __init__(self, etype, eid, info="update"):
        wx.PyCommandEvent.__init__(self, etype, eid)
        self.__info = info
        
    def getInfo(self):
        return self.__info
    
    info = property(getInfo)

class UpdateLogEvent(wx.PyCommandEvent):
    """
    Event sent by worker threads to update log.
    """
    def __init__(self, etype, eid, output="update"):
        wx.PyCommandEvent.__init__(self, etype, eid)
        self.__output = output
        
    def getOutput(self):
        return self.__output
    
    output = property(getOutput)

class UpdateStatusDoneEvent(wx.PyCommandEvent):
    """
    Event sent when the worker thread UpdateStatusThread has finished
    processing.
    """
    def __init__(self, etype, eid):
        wx.PyCommandEvent.__init__(self, etype, eid)

class RetrieveJobsDoneEvent(wx.PyCommandEvent):
    """
    Event sent when the worker thread RetrieveJobsThread has finished
    processing.
    """
    def __init__(self, etype, eid):
        wx.PyCommandEvent.__init__(self, etype, eid)
        
class CleanJobsDoneEvent(wx.PyCommandEvent):
    """
    Event sent when the worker thread CleanJobsThread has finished
    processing.
    """
    def __init__(self, etype, eid):
        wx.PyCommandEvent.__init__(self, etype, eid)
        
class KillJobsDoneEvent(wx.PyCommandEvent):
    """
    Event sent when the worker thread KillJobsThread has finished
    processing.
    """
    def __init__(self, etype, eid):
        wx.PyCommandEvent.__init__(self, etype, eid)
        
class SubmitJobDoneEvent(wx.PyCommandEvent):
    """
    Event sent when the worker thread SubmitJobThread has finished
    processing.
    """
    def __init__(self, etype, eid, resultList=[]):
        wx.PyCommandEvent.__init__(self, etype, eid)
        self.__resultList = resultList
        
    def getResultList(self):
        return self.__resultList
    
    resultList = property(getResultList)
            
class ArcGuiThread(threading.Thread):
    def __init__(self, parent, arcClient):
        """
        Base class for all ArcGui threads.
        """
        threading.Thread.__init__(self)
        self.__stopEvent = threading.Event()
        self.__parent = parent
        self.__logger = None
        self.__arcClient = arcClient
        self.__arcClient.updateProgress = self.doProgress
        self.__debugLevel = self.__arcClient.debugLevel
        
    def stop(self):
        """
        Set the stop event. To signal that the thread should stop.
        """
        if not self.__stopEvent.isSet():
            self.__stopEvent.set()
        
    def isStopped(self):
        """
        Return thread stopped status.
        """
        return self.__stopEvent.isSet()
        
    def logMsg(self, level, msg):
        """
        Log message to logger.
        """
        if self.__logger!=None:
            self.__logger.msg(level, msg)
        
    def logInfoMsg(self, msg):
        """
        Log informational message to logger.
        """
        if self.__logger!=None:
            self.logMsg(arc.INFO, msg)
    
    def logDebugMsg(self, msg):
        """
        Log debug message to logger.
        """
        if self.__logger!=None:
            self.logMsg(arc.DEBUG, msg)

    def logErrorMsg(self, msg):
        """
        Log error message to logger.
        """
        if self.__logger!=None:
            self.logMsg(arc.ERROR, msg)
        
    #def write(self, string):
    #    evt = UpdateLogEvent(EVT_LOG_UPDATE_TYPE, -1, string)
    #    wx.PostEvent(self.__parent, evt)

    def doProgress(self, message):
        """
        Send message (EVT_PROGRESS_UPDATE_TYPE) to
        parent window for updating progress messages.
        """
        evt = UpdateProgressEvent(EVT_PROGRESS_UPDATE_TYPE, -1, message)
        wx.PostEvent(self.__parent, evt)

    def getParent(self):
        """
        Return parent instance.
        """
        return self.__parent
    
    def getArcClient(self):
        """
        Return ArcClient instance.
        """
        return self.__arcClient
    
    def setDebugLevel(self, debugLevel):
        """
        Set debug level (deprecated).
        """
        self.__debugLevel = debugLevel
        
    def getDebugLevel(self):
        """
        Return debug level (deprecated).
        """
        return self.__debugLevel
    
    def setLogger(self, logger):
        """
        Set logger to be used by thread.
        """
        self.__logger = logger
        
    def getLogger(self):
        """
        Return assigned logger.
        """
        return self.__logger
    
    parent = property(getParent)
    arcClient = property(getArcClient)
    debugLevel = property(getDebugLevel, setDebugLevel)
    logger = property(getLogger, setLogger)

class UpdateStatusThread(ArcGuiThread):
    """
    Worker thread for updating job status.
    """
    def run(self):
        """
        Main thread method for getting job status information.
        """
        self.logInfoMsg("UpdateStatusThread Starting.")
        self.arcClient.updateStatus()
        evt = UpdateStatusDoneEvent(EVT_UPDATE_STATUS_DONE_TYPE, -1)
        wx.PostEvent(self.parent, evt)
        self.logInfoMsg("UpdateStatusThread Stopping.")
        
class RetrieveJobsThread(ArcGuiThread):
    """
    Worker thread for retrieving (downloading) jobs.
    """
    def __init__(self, parent, arcClient, jobIds, downloadDir, downloadHistoryFile):
        """
        Class constructor
        """
        ArcGuiThread.__init__(self, parent, arcClient)
        self.__jobIds = jobIds
        self.__downloadDir = downloadDir
        self.__removeJobDir = True
        self.__downloadHistoryFile = downloadHistoryFile
        
    def run(self):
        """
        Main thread method for retrieving jobs from the grid.
        """
        self.logInfoMsg("RetrieveJobsThread starting.")
        if type(self.__downloadDir) is types.StringType:
            self.logInfoMsg("Download to single dir.")
            self.arcClient.downloadDir = self.__downloadDir
            self.arcClient.get(self.__jobIds)
        elif type(self.__downloadDir) is types.ListType:
            self.logInfoMsg("Download to separate dirs.")
            for jobId, downloadDir in zip(self.__jobIds, self.__downloadDir):
                if self.isStopped():
                    break
                self.logInfoMsg("downloading %s to %s." % (jobId, downloadDir))
                self.arcClient.downloadDir = downloadDir
                self.arcClient.get([jobId])
                
                if self.__removeJobDir:
                    sessionId = jobId.split("/")[-1]
                    jobDir = os.path.join(self.arcClient.downloadDir, sessionId)
                    if os.path.isdir(jobDir):
                        print "Moving from ",jobDir,"to",self.arcClient.downloadDir
                        os.system("mv %s/* %s" % (jobDir, self.arcClient.downloadDir))
                        shutil.rmtree(jobDir)
                        if self.__downloadHistoryFile!="":
                            historyFile = open(self.__downloadHistoryFile, "a")
                            historyFile.write("%s;%s;%s\n" % (jobId, str(datetime.now()), self.arcClient.downloadDir))
                            historyFile.close()
                        #os.remove(jobDir)
                        #shutil.move(jobDir, self.arcClient.downloadDir)
                
        evt = RetrieveJobsDoneEvent(EVT_RETRIEVE_JOBS_DONE_TYPE, -1)
        wx.PostEvent(self.parent, evt)
        self.logInfoMsg("RetrieveJobsThread stopping.")
                
class CleanJobsThread(ArcGuiThread):
    """
    Worker thread for cleaning jobs.
    """
    def __init__(self, parent, arcClient, jobIds, force=False):
        """
        Class constructor
        """
        ArcGuiThread.__init__(self, parent, arcClient)
        self.__jobIds = jobIds
        self.__force = force
        
    def run(self):
        """
        Main thread method for cleaning a job(s)
        """
        self.logInfoMsg("CleanJobsThread starting.")
        self.arcClient.clean(self.__jobIds, force=self.__force)
        evt = CleanJobsDoneEvent(EVT_CLEAN_JOBS_DONE_TYPE, -1)
        wx.PostEvent(self.parent, evt)
        self.logInfoMsg("CleanJobsThread stopping.")
            
class KillJobsThread(ArcGuiThread):
    """
    Worker thread for killing jobs.
    """
    def __init__(self, parent, arcClient, jobIds, force=False):
        """
        Class constructor
        """
        ArcGuiThread.__init__(self, parent, arcClient)
        self.__jobIds = jobIds
        self.__force = force
        
    def run(self):
        """
        Main thread mehtod for killing jobs.
        """
        self.logInfoMsg("KillJobsThread starting.")
        self.arcClient.kill(self.__jobIds, force=self.__force)
        evt = KillJobsDoneEvent(EVT_KILL_JOBS_DONE_TYPE, -1)
        wx.PostEvent(self.parent, evt)
        self.logInfoMsg("KillJobsThread stopping.")
        
class SubmitJobThread(ArcGuiThread):
    """
    Worker thread for submitting a job.
    """
    def __init__(self, parent, arcClient, jobList):
        """
        Class constructor
        """
        ArcGuiThread.__init__(self, parent, arcClient)
        self.__jobList = jobList
        
    def run(self):
        """
        Main thread method for submitting a job.
        """
        self.logInfoMsg("SubmitJobThread starting.")
        self.arcClient.findTargets()
        #self.arcClient.filterTargets(self.__jobList[0])   
        resultList = self.arcClient.submitJobList(self.__jobList)
        evt = SubmitJobDoneEvent(EVT_SUBMIT_JOB_DONE_TYPE, -1, resultList)
        wx.PostEvent(self.parent, evt)
        self.logInfoMsg("SubmitJobThread stopping.")
        
