# -*- coding: iso-8859-15 -*-
# generated by wxGlade HG on Fri Aug 28 10:05:56 2009

import wx

# begin wxGlade: extracode
# end wxGlade

from wx.lib.dialogs import *

import os

from arcjobtool.ArcUtils import *
from arcjobtool.Tasks import *
from arcjobtool.plugins.Plugins import *
from arcjobtool.PlatformUtils import *

runScriptTemplate = """#!/bin/sh
python %s
"""

class NumpyTask(BaseTask):
    def __init__(self):
        BaseTask.__init__(self)
        
        self.description = "NumPy"

        # Task specific attributes
        
        self.__mainFile = ""      
        self.packages = []
        self.extraFiles = []
        
    def onCreateRunScript(self, taskName, taskId):
        """
        Abstract routine responsible for returning a
        run-script for the job.
        """
        return runScriptTemplate % (self.__mainFile)
        
    def onCreateJobDescription(self, taskName, taskId, taskDir):
        """
        Abstract routines responsible for returning a jobdescription for
        the job.
        """
        
        # Create a managed job description
        
        job = ManagedJobDescription();
        job.Application.Executable.Name = "run.sh"
        job.Identification.JobName = str(taskName)
        job.Resources.TotalWallTime = arc.ScalableTimeInt(self.cpuTime*60)
        #job.addArgument("run.sh")
        
        # Make sure we store the full paths of input files
        
        for inputFile in self.inputFiles.keys():
            url = self.inputFiles[inputFile]
            if url == "":
                fullPath = os.path.join(taskDir, inputFile)
                job.addInputFile(fullPath)
            else:
                job.addInputFile(inputFile, url)
        
        job.addRuntimeEnvironment("APPS/MATH/NUMPY",">=","1.0.0")
        job.Application.Output = "stdout.txt"
        job.Application.Error = "stderr.txt"
        job.addOutputFile("/", "")
              
        return job
    
    def onSaveConfig(self, config):
        config.add_section("numpyplugin")
        config.set("numpyplugin", "mainfile", self.mainFile)
    
    def onLoadConfig(self, config):
        try:
            self.mainFile = config.get("numpyplugin", "mainfile")
        except:
            pass
            
    def setMainFile(self, filename):
        self.__mainFile = filename
        
    def getMainFile(self):
        return self.__mainFile
        
    def addPackage(self, filename):
        pass
    
    def addExtraFile(self, filename):
        pass
    
    def removePackage(self, filename):
        pass
    
    def removeExtraFile(self, filename):
        pass
            
    mainFile = property(getMainFile, setMainFile)

class NumpyPlugin(PluginBase):
    def onInit(self):
        self.__task = NumpyTask()
 
    def onDestroy(self):
        pass
    
    def onEdit(self):
        dlg = NumpyPluginDialog(None, -1, "")
        dlg.task = self.__task
        dlg.ShowModal()
        dlg.Destroy()
        self.__task = dlg.task
    
    def onSave(self, workDir):
        (taskLocation, taskDirName) = os.path.split(workDir)
        self.__task.name = taskDirName.split(".")[0]
        self.__task.workDir = workDir
        self.__task.save()
    
    def onLoad(self, workDir):
        (taskLocation, taskDirName) = os.path.split(workDir)
        self.__task.name = taskDirName.split(".")[0]
        self.__task.workDir = workDir
        self.__task.load()
        
    def onClean(self):
        self.__task.clean()        
        
    def onSetup(self):
        self.__task.setup()
               
    def onGetId(self):
        return "NumpyPlugin"
    
    def onGetVersion(self):
        return (0,1,0)
        
    def onGetDescription(self):
        return "Numpy job definition plugin."
    
    def onGetShortName(self):
        return "Numpy job definition."
    
    def onNeedSave(self):
        return self.__task.dirty
    
    def onGetTask(self):
        return self.__task
        
    id = property(onGetId)
    version = property(onGetVersion)
    shortname = property(onGetShortName)
    description = property(onGetDescription)
    task = property(onGetTask)


class NumpyPluginDialog(wx.Dialog):
    def __init__(self, *args, **kwds):
        # begin wxGlade: NumpyPluginDialog.__init__
        kwds["style"] = wx.DEFAULT_DIALOG_STYLE|wx.RESIZE_BORDER|wx.THICK_FRAME
        wx.Dialog.__init__(self, *args, **kwds)
        self.notebook_1 = wx.Notebook(self, -1, style=0)
        self.generalPane = wx.Panel(self.notebook_1, -1)
        self.nameLabel = wx.StaticText(self.generalPane, -1, "Name", style=wx.ALIGN_RIGHT)
        self.jobNameText = wx.TextCtrl(self.generalPane, -1, "", style=wx.TE_READONLY)
        self.cputTimeLabel = wx.StaticText(self.generalPane, -1, "CPU Time (min)", style=wx.ALIGN_RIGHT)
        self.cpuTimeText = wx.TextCtrl(self.generalPane, -1, "")
        self.notifyLabel = wx.StaticText(self.generalPane, -1, "Notify (email)", style=wx.ALIGN_RIGHT)
        self.notifyText = wx.TextCtrl(self.generalPane, -1, "")
        self.notifyMemoryLabel = wx.StaticText(self.generalPane, -1, "Memory (MB)", style=wx.ALIGN_RIGHT)
        self.memoryText = wx.TextCtrl(self.generalPane, -1, "")
        self.inputFilePane = wx.Panel(self.notebook_1, -1)
        self.inputFilesLabel = wx.StaticText(self.inputFilePane, -1, "Input files")
        self.inputFileList = wx.ListBox(self.inputFilePane, -1, choices=[])
        self.addFileButton = wx.Button(self.inputFilePane, -1, "Add...")
        self.createFileButton = wx.Button(self.inputFilePane, -1, "Create...")
        self.removeFileButton = wx.Button(self.inputFilePane, -1, "Remove")
        self.clearFilesButton = wx.Button(self.inputFilePane, -1, "Clear")
        self.inputFileEditButton = wx.Button(self.inputFilePane, -1, "Edit...")
        self.mainFileLabel = wx.StaticText(self.inputFilePane, -1, "Main python file")
        self.mainFileChoice = wx.Choice(self.inputFilePane, -1, choices=[])
        self.parameterPane = wx.Panel(self.notebook_1, -1)
        self.parameterFilesLabel = wx.StaticText(self.parameterPane, -1, "Parameter substitution files")
        self.paramFilesList = wx.ListBox(self.parameterPane, -1, choices=[])
        self.AddParamFileButton = wx.Button(self.parameterPane, -1, "Add...")
        self.removeParamFileButton = wx.Button(self.parameterPane, -1, "Remove")
        self.clearParamFilesButton = wx.Button(self.parameterPane, -1, "Clear")
        self.paramFileEditButton = wx.Button(self.parameterPane, -1, "Edit...")
        self.static_line_1 = wx.StaticLine(self.parameterPane, -1)
        self.sweepSizeLabel = wx.StaticText(self.parameterPane, -1, "Sweep size", style=wx.ALIGN_RIGHT)
        self.sweepSizeSpinner = wx.SpinCtrl(self.parameterPane, -1, "0", min=1, max=1000)
        self.saveButton = wx.Button(self, -1, "Save")
        self.closeButton = wx.Button(self, -1, "Close")

        self.__set_properties()
        self.__do_layout()

        self.Bind(wx.EVT_BUTTON, self.onAddFile, self.addFileButton)
        self.Bind(wx.EVT_BUTTON, self.onCreateFile, self.createFileButton)
        self.Bind(wx.EVT_BUTTON, self.onRemoveFile, self.removeFileButton)
        self.Bind(wx.EVT_BUTTON, self.onClearFiles, self.clearFilesButton)
        self.Bind(wx.EVT_BUTTON, self.onEditInputFile, self.inputFileEditButton)
        self.Bind(wx.EVT_CHOICE, self.onSelectMainFile, self.mainFileChoice)
        self.Bind(wx.EVT_BUTTON, self.onAddParamFile, self.AddParamFileButton)
        self.Bind(wx.EVT_BUTTON, self.onRemoveParamFileButton, self.removeParamFileButton)
        self.Bind(wx.EVT_BUTTON, self.onClearParamFilesButton, self.clearParamFilesButton)
        self.Bind(wx.EVT_BUTTON, self.onEditParamFile, self.paramFileEditButton)
        self.Bind(wx.EVT_BUTTON, self.onSave, self.saveButton)
        self.Bind(wx.EVT_BUTTON, self.onClose, self.closeButton)
        # end wxGlade

    def __set_properties(self):
        # begin wxGlade: NumpyPluginDialog.__set_properties
        self.SetTitle("Numpy job definition")
        self.SetSize((410, 368))
        self.nameLabel.SetMinSize((120, -1))
        self.jobNameText.SetMinSize((-1, 27))
        self.cputTimeLabel.SetMinSize((120, -1))
        self.cpuTimeText.SetMinSize((-1, 27))
        self.notifyLabel.SetMinSize((120, -1))
        self.notifyText.SetMinSize((-1, 27))
        self.notifyMemoryLabel.SetMinSize((120, -1))
        self.memoryText.SetMinSize((-1, 27))
        self.sweepSizeLabel.SetMinSize((120, -1))
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: NumpyPluginDialog.__do_layout
        sizer_1 = wx.BoxSizer(wx.VERTICAL)
        sizer_2 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_11 = wx.BoxSizer(wx.VERTICAL)
        sizer_12 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_13 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_14 = wx.BoxSizer(wx.VERTICAL)
        sizer_9 = wx.BoxSizer(wx.VERTICAL)
        sizer_10 = wx.BoxSizer(wx.VERTICAL)
        sizer_8 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_9_copy = wx.BoxSizer(wx.VERTICAL)
        sizer_3 = wx.BoxSizer(wx.VERTICAL)
        sizer_7 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_6 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_5 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_4 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_4.Add(self.nameLabel, 0, wx.LEFT|wx.RIGHT|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 5)
        sizer_4.Add(self.jobNameText, 1, wx.RIGHT|wx.EXPAND, 4)
        sizer_3.Add(sizer_4, 0, wx.TOP|wx.EXPAND, 10)
        sizer_5.Add(self.cputTimeLabel, 0, wx.LEFT|wx.RIGHT|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 5)
        sizer_5.Add(self.cpuTimeText, 1, wx.RIGHT|wx.EXPAND|wx.ADJUST_MINSIZE, 4)
        sizer_3.Add(sizer_5, 0, wx.EXPAND, 0)
        sizer_6.Add(self.notifyLabel, 0, wx.LEFT|wx.RIGHT|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 5)
        sizer_6.Add(self.notifyText, 1, wx.RIGHT|wx.EXPAND|wx.ADJUST_MINSIZE, 4)
        sizer_3.Add(sizer_6, 0, wx.EXPAND, 0)
        sizer_7.Add(self.notifyMemoryLabel, 0, wx.LEFT|wx.RIGHT|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 5)
        sizer_7.Add(self.memoryText, 1, wx.RIGHT|wx.EXPAND|wx.ADJUST_MINSIZE, 5)
        sizer_3.Add(sizer_7, 0, wx.EXPAND, 0)
        self.generalPane.SetSizer(sizer_3)
        sizer_9.Add(self.inputFilesLabel, 0, wx.LEFT|wx.TOP|wx.ADJUST_MINSIZE, 4)
        sizer_8.Add(self.inputFileList, 1, wx.ALL|wx.EXPAND|wx.ADJUST_MINSIZE, 4)
        sizer_9_copy.Add(self.addFileButton, 0, wx.ADJUST_MINSIZE, 0)
        sizer_9_copy.Add(self.createFileButton, 0, wx.ADJUST_MINSIZE, 0)
        sizer_9_copy.Add(self.removeFileButton, 0, wx.ADJUST_MINSIZE, 0)
        sizer_9_copy.Add(self.clearFilesButton, 0, wx.ADJUST_MINSIZE, 0)
        sizer_9_copy.Add(self.inputFileEditButton, 0, wx.TOP|wx.ADJUST_MINSIZE, 7)
        sizer_8.Add(sizer_9_copy, 0, wx.ALL|wx.EXPAND, 4)
        sizer_9.Add(sizer_8, 1, wx.EXPAND, 0)
        sizer_10.Add(self.mainFileLabel, 0, wx.ADJUST_MINSIZE, 0)
        sizer_10.Add(self.mainFileChoice, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
        sizer_9.Add(sizer_10, 0, wx.ALL|wx.EXPAND, 4)
        self.inputFilePane.SetSizer(sizer_9)
        sizer_11.Add(self.parameterFilesLabel, 0, wx.LEFT|wx.TOP|wx.ADJUST_MINSIZE, 4)
        sizer_13.Add(self.paramFilesList, 1, wx.ALL|wx.EXPAND|wx.ADJUST_MINSIZE, 4)
        sizer_14.Add(self.AddParamFileButton, 0, wx.ADJUST_MINSIZE, 0)
        sizer_14.Add(self.removeParamFileButton, 0, wx.ADJUST_MINSIZE, 0)
        sizer_14.Add(self.clearParamFilesButton, 0, wx.ADJUST_MINSIZE, 0)
        sizer_14.Add(self.paramFileEditButton, 0, wx.TOP|wx.ADJUST_MINSIZE, 7)
        sizer_13.Add(sizer_14, 0, wx.ALL|wx.EXPAND, 4)
        sizer_11.Add(sizer_13, 1, wx.EXPAND, 0)
        sizer_11.Add(self.static_line_1, 0, wx.TOP|wx.EXPAND, 5)
        sizer_12.Add(self.sweepSizeLabel, 0, wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
        sizer_12.Add(self.sweepSizeSpinner, 0, wx.TOP|wx.ADJUST_MINSIZE, 2)
        sizer_11.Add(sizer_12, 0, wx.TOP|wx.BOTTOM|wx.EXPAND, 4)
        self.parameterPane.SetSizer(sizer_11)
        self.notebook_1.AddPage(self.generalPane, "General")
        self.notebook_1.AddPage(self.inputFilePane, "Input files")
        self.notebook_1.AddPage(self.parameterPane, "Parameters")
        sizer_1.Add(self.notebook_1, 1, wx.ALL|wx.EXPAND, 8)
        sizer_2.Add(self.saveButton, 0, wx.ADJUST_MINSIZE, 0)
        sizer_2.Add(self.closeButton, 0, wx.ADJUST_MINSIZE, 0)
        sizer_1.Add(sizer_2, 0, wx.LEFT|wx.RIGHT|wx.BOTTOM|wx.ALIGN_CENTER_HORIZONTAL, 4)
        self.SetSizer(sizer_1)
        self.Layout()
        # end wxGlade
        
    def __setupInputFiles(self):
        """
        Setup listbox for input files and choice box
        for selecting main file.
        """
        self.inputFileList.Clear()
        self.mainFileChoice.Clear()
        
        filenameDict = {}
        count = 0
        
        # Fill listbox and choice box
        
        if self.__task!=None:
            for inputFile in self.__task.inputFiles.keys():
                self.inputFileList.Append(inputFile)
                filenameDict[inputFile] = count
                if inputFile.find(".py")!=-1:
                    count = count + 1 
                    self.mainFileChoice.Append(inputFile)
                    
        # Select main file (if any) in the choice box
        
        if filenameDict.has_key(self.__task.mainFile):
            print "filenameDict has key", self.__task.mainFile
            print "Selection = ", filenameDict[self.__task.mainFile]
            self.mainFileChoice.SetSelection(filenameDict[self.__task.mainFile])
            
    def __setupSweepFiles(self):

        self.paramFilesList.Clear()
        
        # Fill listbox
        
        if self.__task!=None:
            for sweepFile in self.__task.sweepFiles.keys():
                print sweepFile     
                self.paramFilesList.Append(sweepFile)
                    

    def onSave(self, event): # wxGlade: NumpyPluginDialog.<event_handler>
        self.__task.cpuTime = int(self.cpuTimeText.GetValue())
        self.__task.notify = self.notifyText.GetValue()
        self.__task.memory = int(self.memoryText.GetValue())
        self.__task.sweepSize = int(self.sweepSizeSpinner.GetValue())
        self.__task.dirty = True
        self.Close()

    def onClose(self, event): # wxGlade: NumpyPluginDialog.<event_handler>
        self.__task.dirty = False
        self.Close()
        
    def setTask(self, task):
        self.__task = task
        
        self.jobNameText.SetValue(self.__task.name)
        self.cpuTimeText.SetValue(str(self.__task.cpuTime))
        self.notifyText.SetValue(self.__task.notify)
        self.memoryText.SetValue(str(self.__task.memory))
        self.sweepSizeSpinner.SetValue(int(self.__task.sweepSize))
        
        self.__setupInputFiles()
        self.__setupSweepFiles()
        
    def getTask(self):
        return self.__task
    
    def onAddFile(self, event): # wxGlade: NumpyPluginDialog.<event_handler>
        inputFilename = wx.FileSelector("Add input file", default_path=os.getcwd())
        if inputFilename != "":
            self.__task.addAndCopyInputFile(inputFilename)
            self.__setupInputFiles()

    def onRemoveFile(self, event): # wxGlade: NumpyPluginDialog.<event_handler>
        if self.inputFileList.GetStringSelection()!="":
            self.__task.removeInputFile(self.inputFileList.GetStringSelection())
            self.__setupInputFiles()

    def onClearFiles(self, event): # wxGlade: NumpyPluginDialog.<event_handler>
        self.__task.clearInputFiles()
        self.__setupInputFiles()

    task = property(getTask, setTask)

    def onSelectMainFile(self, event): # wxGlade: NumpyPluginDialog.<event_handler>
        mainFile = self.mainFileChoice.GetStringSelection()
        if mainFile != "":
            self.__task.mainFile = mainFile

    def onAddParamFile(self, event): # wxGlade: NumpyPluginDialog.<event_handler>
        result = singleChoiceDialog(self, "Add file for substitution", "Input files", self.__task.inputFiles)
        if result.accepted:
            self.__task.addSweepFile(result.selection)
            self.__setupSweepFiles()

    def onRemoveParamFileButton(self, event): # wxGlade: NumpyPluginDialog.<event_handler>
        if self.paramFilesList.GetStringSelection()!="":
            self.__task.removeSweepFile(self.paramFilesList.GetStringSelection())
            self.__setupSweepFiles()

    def onClearParamFilesButton(self, event): # wxGlade: NumpyPluginDialog.<event_handler>
        self.__task.clearSweepFiles()
        self.__setupSweepFiles()

    def onEditInputFile(self, event): # wxGlade: NumpyPluginDialog.<event_handler>
        if self.inputFileList.GetStringSelection()!="":
            fullPath = os.path.join(self.__task.workDir,self.inputFileList.GetStringSelection())
            editFile(fullPath)

    def onEditParamFile(self, event): # wxGlade: NumpyPluginDialog.<event_handler>
        if self.paramFilesList.GetStringSelection()!="":
            fullPath = os.path.join(self.__task.workDir,self.paramFilesList.GetStringSelection())
            editFile(fullPath)

    def onCreateFile(self, event): # wxGlade: NumpyPluginDialog.<event_handler>
        print "Event handler `onCreateFile' not implemented"
        event.Skip()

# end of class NumpyPluginDialog

if __name__ == "__main__":
    app = wx.PySimpleApp(0)
    wx.InitAllImageHandlers()
    mainDialog = NumpyPluginDialog(None, -1, "")
    app.SetTopWindow(mainDialog)
    mainDialog.Show()
    app.MainLoop()
