/*
    Copyright (C) 2004 Paul Davis

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: ardour_message.cc,v 1.4 2005/12/02 07:26:39 essej Exp $

*/

#include "ardour_message.h"
#include "i18n.h"

using namespace std;
using namespace Gtk;


ArdourMessage::ArdourMessage (Gtk::Window* parent, 
			      string name, string msg, 
			      bool grab_focus, bool auto_run, int button_state)
	: ArdourDialog (name),
	  ok_button (_("OK")),
	  cancel_button (_("Cancel")),
	  yes_button (_("Yes")),
	  no_button (_("No"))
{
	set_keyboard_input (true);

	label.set_text (msg);
	label.set_alignment (0.5, 0.5);
	label.set_name (X_("PrompterLabel"));
	
	ok_button.set_name ("EditorGTKButton");	
	ok_button.clicked.connect (bind (slot (*this, &ArdourDialog::stop), (int)OK_BUTTON));

	cancel_button.set_name ("EditorGTKButton");	
	cancel_button.clicked.connect (bind (slot (*this, &ArdourDialog::stop), (int)CANCEL_BUTTON));

	yes_button.set_name ("EditorGTKButton");	
	yes_button.clicked.connect (bind (slot (*this, &ArdourDialog::stop), (int)YES_BUTTON));

	no_button.set_name ("EditorGTKButton");	
	no_button.clicked.connect (bind (slot (*this, &ArdourDialog::stop), (int)NO_BUTTON));

	packer.set_spacing (10);
	packer.set_border_width (10);
	packer.pack_start (label);

	bpacker.set_spacing (6);
	bpacker.set_border_width (6);

	if (button_state & NO_BUTTON) {
		bpacker.pack_start (no_button);
	}
	if (button_state & CANCEL_BUTTON) {
		bpacker.pack_start (cancel_button);
	}
	if (button_state & YES_BUTTON) {
		bpacker.pack_start (yes_button);
	}
	if (button_state & OK_BUTTON) {
		bpacker.pack_start (ok_button);
	}

	packer.pack_start (bpacker);
	
	set_name (X_("Prompter"));
	set_position (GTK_WIN_POS_MOUSE);
	set_modal (true);
	add (packer);
	show_all ();
	
	realize();
	get_window().set_decorations (GdkWMDecoration (GDK_DECOR_BORDER|GDK_DECOR_RESIZEH));

	if (grab_focus) {
		ok_button.grab_focus ();
	}

	if (parent) {
		set_transient_for (*parent);
	}

	if (auto_run) {
		run ();
	}
}

ArdourMessage::~ArdourMessage()
{
}
