// -*- c++ -*-
//  Generated by gtkmmproc from ./../tree.gen_h -- DO NOT MODIFY!
#ifndef _GTKMM_TREE_H
#define _GTKMM_TREE_H

/* $Id: tree.h,v 1.2 2003/06/17 16:37:41 pbd Exp $ */

/* tree.h
 *
 * Copyright (C) 1998-1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk--/treeitem.h>
#include <gtk--/container.h>
#include <gtk/gtktree.h>

namespace Gtk {
class Tree;
class Tree_Class;
}
namespace Gtk { Gtk::Tree *wrap (GtkTree *o); }
namespace Gtk
{

namespace Tree_Helpers
{

  class ItemList
    {
      public:
        typedef TreeItem*                       value_type;
        typedef value_type &                       reference;
        typedef const value_type &                 const_reference;

        typedef G_List_Cpp_Iterator<GtkTreeItem,TreeItem>        iterator;
        typedef G_List_ConstIterator<iterator>     const_iterator;
        typedef G_List_ReverseIterator<iterator>   reverse_iterator;
        typedef G_List_ConstIterator<reverse_iterator>   const_reverse_iterator;

        typedef size_t                             difference_type;
        typedef size_t                             size_type;

      private:
        friend class Gtk::Tree;
        Gtk::Tree *parent_;
        explicit ItemList(Tree* parent): parent_(parent) {}

        GList*& glist() const;      // front of list

        iterator begin_() const;
        iterator end_() const;

      public:
        ~ItemList() {}

        inline iterator begin()
          {return begin_();}
        inline iterator end()
          {return end_();}

        inline const_iterator begin() const
          { return const_iterator(begin_()); }
        inline const_iterator end() const
          { return const_iterator(end_()); }

        inline reverse_iterator rbegin()
          { return reverse_iterator(end_()); }
        inline reverse_iterator rend()
          { return reverse_iterator(begin_()); }

        inline const_reverse_iterator rbegin() const
          { return const_reverse_iterator(reverse_iterator(end_())); }
        inline const_reverse_iterator rend() const
          { return const_reverse_iterator(reverse_iterator(begin_())); }

        size_type size(void) const;
        inline size_type max_size(void) { return size_type(-1); }
        inline bool empty(void) { return glist() == 0; }

        iterator insert(iterator position, TreeItem& e);
        template <class InputIterator>
        inline void insert(iterator position, InputIterator first, InputIterator last)
          { for (;first!=last;++first) position=insert(position,*first); }

        inline void push_front(TreeItem& e) { insert(begin(), e); }
        inline void push_back(TreeItem& e)  { insert(end(), e); }
        inline void pop_front()                  { erase(begin()); }
        inline void pop_back()                   { erase(--end()); }

        void clear();

        iterator erase(iterator);
        void erase(iterator start, iterator stop);
        void remove(const_reference);

        void remove(Widget& w);

     };

  class SelectionList
    {
      public:
        typedef TreeItem*                       value_type;
        typedef value_type &                       reference;
        typedef const value_type &                 const_reference;

        typedef G_List_Cpp_Iterator<GtkTreeItem,TreeItem>        iterator;
        typedef G_List_ConstIterator<iterator>     const_iterator;
        typedef G_List_ReverseIterator<iterator>   reverse_iterator;
        typedef G_List_ConstIterator<reverse_iterator>   const_reverse_iterator;

        typedef size_t                             difference_type;
        typedef size_t                             size_type;

      private:
        friend class Gtk::Tree;
        Gtk::Tree *parent_;
        explicit SelectionList(Tree* parent): parent_(parent) {}

        GList*& glist() const;      // front of list

        iterator begin_() const;
        iterator end_() const;

      public:
        ~SelectionList() {}

        inline iterator begin()
          {return begin_();}
        inline iterator end()
          {return end_();}

        inline const_iterator begin() const
          { return const_iterator(begin_()); }
        inline const_iterator end() const
          { return const_iterator(end_()); }

        inline reverse_iterator rbegin()
          { return reverse_iterator(end_()); }
        inline reverse_iterator rend()
          { return reverse_iterator(begin_()); }

        inline const_reverse_iterator rbegin() const
          { return const_reverse_iterator(reverse_iterator(end_())); }
        inline const_reverse_iterator rend() const
          { return const_reverse_iterator(reverse_iterator(begin_())); }

        size_type size(void) const;
        inline size_type max_size(void) { return size_type(-1); }
        inline bool empty(void) { return glist() == 0; }

     };

};

//: A treelist widget.
//- The {\class Gtk::Tree} widget is a container that shows users a list of items,
//- in a tree  complete with branches and leafnodes. Branches can be expanded
//- to show their child items, or collapsed to hide them.
class Tree : public Container {

public:
  typedef Tree          CppObjectType;
  typedef Tree_Class    CppClassType;
  typedef GtkTree           BaseObjectType;
  typedef GtkTreeClass      BaseClassType;

private:
  friend class Tree_Class;
  static CppClassType tree_class;

  Tree(const Tree&);
  Tree& operator=(const Tree&); // not implemented

protected:
  void   initialize_class();
  explicit Tree(GtkTree *castitem);

public:
  static GtkType get_type();
  GtkTree* gtkobj()             { return (GtkTree*)(gtkobject); }
  const GtkTree* gtkobj() const { return (GtkTree*)(gtkobject); }
  static bool isA(Object *checkcast);

  // Hook for proxies
  static const char* const signal_names[];

  virtual ~Tree();

private:

public:
  typedef Tree_Helpers::ItemList ItemList;
  typedef Tree_Helpers::SelectionList SelectionList;

  Tree();



  //: deprecated - use get_tree().push_back(w);

  void append(Gtk::TreeItem& widget);

  //: deprecated - use get_tree().push_front(w);

  void prepend(Gtk::TreeItem& widget);

  //: deprecated - use get_tree().insert(loc,w);

  void insert(Gtk::TreeItem& widget,gint position);

  //: deprecated - use get_tree().erase(start,end);

  void clear_items(gint start,gint end);

  //: select item by number.
  //- equivelent to get_tree()[itemnum]->select();

  void select_item(gint item);

  //: equivelent to get_tree()[itemnum]->unselect();

  void unselect_item(gint item);

  // removes a list of items from the tree.
  // (no STL equivelent) The iterator must
  // be to Gtk_TreeItem* and be forward iteratable.
  template <class iterator>
  void remove_items(iterator start,iterator stop);

  //: deprecated use get_tree().remove(w);

  void remove_item(Gtk::TreeItem& child);

  // get the index of a tree item.  (no STL equiv)

  gint child_position(Gtk::TreeItem& child) const;


  void set_selection_mode(GtkSelectionMode mode);


  void set_view_mode(GtkTreeViewMode mode);


  void set_view_lines(bool flag);

  // indicates there has been a change in the selection list.


  guint get_level() const;

  ItemList& tree()
    {return reinterpret_cast<ItemList&>(tree_self); }
  const ItemList& tree() const
    {return reinterpret_cast<const ItemList&>(tree_self); }

  SelectionList& selection()
    {return reinterpret_cast<SelectionList&>(tree_self); }
  const SelectionList& selection() const
    {return reinterpret_cast<const SelectionList&>(tree_self); }

public:

    class Proxy_select_child
      : public Gtk::EmitProxySignal1<void,GtkWidget*,CppObjectType,BaseObjectType,0,&gtk_tree_select_child>
      {
          typedef Gtk::EmitProxySignal1<void,GtkWidget*,CppObjectType,BaseObjectType,0,&gtk_tree_select_child> BaseType;
        public:
          void operator ()(Gtk::Widget&);
          void emit(Gtk::Widget&);
          Connection connect(const SigC::Slot1<void,Gtk::Widget&> &s);
      };
    class Proxy_unselect_child
      : public Gtk::EmitProxySignal1<void,GtkWidget*,CppObjectType,BaseObjectType,1,&gtk_tree_unselect_child>
      {
          typedef Gtk::EmitProxySignal1<void,GtkWidget*,CppObjectType,BaseObjectType,1,&gtk_tree_unselect_child> BaseType;
        public:
          void operator ()(Gtk::Widget&);
          void emit(Gtk::Widget&);
          Connection connect(const SigC::Slot1<void,Gtk::Widget&> &s);
      };
  union
    {
      CppObjectType * tree_self;
      Proxy_select_child select_child;
      Proxy_unselect_child unselect_child;
      Gtk::ProxySignal0<void,CppObjectType,BaseObjectType,2> selection_changed;
    };

protected:
  // impl functions
    virtual void select_child_impl(Gtk::Widget& p0);
    virtual void unselect_child_impl(Gtk::Widget& p0);
    virtual void selection_changed_impl();

};

template <class iterator>
void Tree::remove_items(iterator start, iterator stop)
  {
    GList* items=gtkmm_build_glist(start,stop);
    if (items) gtk_tree_remove_items(gtkobj(),items);
    g_list_free(items);
  }

}


//+ PROPERTIES(Gtk_Tree)
//. name: children
//. type: GList*
//. get:
//. set:
//. desc:

//. name: root_tree
//. type: GtkTree*
//. get:
//. set:
//. desc: owner of selection list

//. name: tree_owner
//. type: Gtk_Widget*
//. get:
//. set:
//. desc:

//. name: selection
//. type: GList*
//. get:
//. set:
//. desc:

//. name: level
//. type: guint
//. get:
//. set:
//. desc:

//. name: indent_value
//. type: guint
//. get:
//. set:
//. desc:

//. name: current_indent
//. type: guint
//. get:
//. set:
//. desc:

//. name: selection_mode
//. type: guint:2
//. get:
//. set:
//. desc:

//. name: view_mode
//. type: guint:1
//. get:
//. set:
//. desc:

//. name: view_line
//. type: guint:1
//. get:
//. set:
//. desc:

#endif
