
/*
 * Copyright (c) 2000-2001 QoSient, LLC
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * QOSIENT, LLC DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL QOSIENT, LLC BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

/*
 * Copyright (c) 1993, 1994 Carnegie Mellon University.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 */


#define argtimeval timeval

#if defined(HAVE_SOLARIS)
#include <strings.h>
#endif

#if defined(HAVE_SOLARIS)
#include <sys/byteorder.h>
#endif

#if defined(linux)
#include <endian.h>
#endif

#if defined(CYGWIN)
#define _LITTLE_ENDIAN
#else

#if (__FreeBSD__)
#if defined(BYTE_ORDER)
#define __BYTE_ORDER    BYTE_ORDER
#endif
#if defined(LITTLE_ENDIAN)
#define __LITTLE_ENDIAN LITTLE_ENDIAN
#endif
#if defined(BIG_ENDIAN)
#define __BIG_ENDIAN    BIG_ENDIAN
#endif
#endif

#if !defined(_LITTLE_ENDIAN) && !defined(_BIG_ENDIAN)
#if __BYTE_ORDER == __LITTLE_ENDIAN
#define _LITTLE_ENDIAN
#else
#define _BIG_ENDIAN
#endif
#endif
#endif


#if defined(__sgi) || defined(HAVE_SOLARIS) || defined(ultrix) || defined(__osf__) || defined(linux) || defined(bsdi) || defined(AIX) | defined(CYGWIN)

#define timelocal mktime

#include <os.h>

#if defined(__sgi)
#include <bstring.h>
#include <ulimit.h>

#if _MIPS_SZLONG == 64
#undef argtimeval
#define argtimeval irix5_timeval
#endif

#undef TCPSTATES
#endif

#if defined(linux)
#include <time.h>
#endif

#if defined(__sgi) || defined(bsdi)
struct ether_addr {
        u_char  ether_addr_octet[6];
};
#endif

#if defined(AIX)
#define _SUN
#include <sys/select.h>
#include <net/nh.h>
#endif
#endif

#define arg_uint8   u_char
#define arg_int8    char
#define arg_uint16  u_short
#define arg_int16   short

#if HOST_BITS_PER_INT == 32
#define arg_uint32  u_int
#define arg_int32   int
#else
#define arg_uint32  u_long
#define arg_int32   long
#endif

#ifndef ICMP_ROUTERADVERT
#define	ICMP_ROUTERADVERT	9	/* router advertisement */
#endif

#ifndef	ICMP_ROUTERSOLICIT
#define	ICMP_ROUTERSOLICIT	10	/* router solicitation */
#endif

#ifndef TCPOPT_WSCALE
#define	TCPOPT_WSCALE		3	/* window scale factor (rfc1072) */
#endif
#ifndef TCPOPT_SACKOK
#define	TCPOPT_SACKOK		4	/* selective ack ok (rfc1072) */
#endif
#ifndef TCPOPT_SACK
#define	TCPOPT_SACK		5	/* selective ack (rfc1072) */
#endif
#ifndef TCPOPT_ECHO
#define	TCPOPT_ECHO		6	/* echo (rfc1072) */
#endif
#ifndef TCPOPT_ECHOREPLY
#define	TCPOPT_ECHOREPLY	7	/* echo (rfc1072) */
#endif
#ifndef TCPOPT_TIMESTAMP
#define TCPOPT_TIMESTAMP	8	/* timestamps (rfc1323) */
#endif
#ifndef TCPOPT_CC
#define TCPOPT_CC		11	/* T/TCP CC options (rfc1644) */
#endif
#ifndef TCPOPT_CCNEW
#define TCPOPT_CCNEW		12	/* T/TCP CC options (rfc1644) */
#endif
#ifndef TCPOPT_CCECHO
#define TCPOPT_CCECHO		13	/* T/TCP CC options (rfc1644) */
#endif
