use ExtUtils::MakeMaker;

if( defined $ENV{ARGUSHOME} ) {
   $Home =  $ENV{ARGUSHOME};
} else {
    $Home =  $ENV{HOME};
}

WriteMakefile(
   NAME => "Argus",
   DISTNAME  => "Argus-perl",
   VERSION => "2.00",
   PREREQ_PM => {
       Net::SMTP => 1.0,
       Date::Manip => 1.0
       },
   PL_FILES => {
       'fix-script.PL' => ['watcher', 'slowscan','look_for']
       },
   PM => { 'ra.conf' => '$(INST_LIBDIR)/ra.conf',
	   'Argus.pm' => '$(INST_LIBDIR)/Argus.pm',
	   'Argus/Support.pm' => '$(INST_LIBDIR)/Argus/Support.pm',
	   'Argus/Archive.pm' => '$(INST_LIBDIR)/Argus/Archive.pm',
	   'Argus/SlowScan.pm' => '$(INST_LIBDIR)/Argus/SlowScan.pm',
	   'Argus/Watcher.pm' => '$(INST_LIBDIR)/Argus/Watcher.pm',
         }, 
   EXE_FILES => ['slowscan', 'watcher', 'look_for'],
   PREFIX =>  $Home,
   INSTALLSITELIB => "$Home/lib",
   INSTALLARCHLIB => $Home,
   INSTALLMAN1DIR => $Home,
   INSTALLMAN3DIR => $Home,
   ABSTRACT   => 'Scripts and modules to support Argus IP audit tool.',
   AUTHOR     => 'Russell Fulton <r.fulton@auckland.ac.nz>',
  'dist' => {COMPRESS=>'gzip',SUFFIX=>'gz'}
);
