/* $Id: ArkLoaderTGA.cpp,v 1.14 2003/03/13 23:35:55 zongo Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include <Ark/ArkImage.h>
#include <Ark/ArkLoader.h>

#include <stdio.h>


namespace Ark
{

   struct TGA_Header
   {
	 uchar idlen;
	 uchar cmtype;
	 uchar imgtype;
	 uchar cmspec[5];
	 ushort xorig, yorig;
	 ushort width, height;
	 uchar pixsize;
	 uchar imgdesc;
   };
   
   // FIXME never used, to be removed ?
#if 0
   static void
   TGA_SwapTopBottom (uchar *data, int nlines, int linesize)
   {
      static char line[1024];
      int mid = nlines/2;
      
      for (int i = 1; i < mid; i++)
      {
	 int end = nlines - i;
	 
	 memcpy (line, &data[i * linesize], linesize);
	 memcpy (&data[i * linesize], &data[end * linesize], linesize);
	 memcpy (&data[end * linesize], line, linesize);
      }
   }
#endif

// Reads in RGBA data for a 32bit image.  
   static void TGA_CvtRGBA (uchar *rgba, int size)
   {
      uchar temp;
      int i;
      
      // TGA is stored in BGRA, make it RGBA 
      for (i = 0; i < size; i += 4)
      {
	 temp = rgba[i];
	 rgba[i] = rgba[i + 2];
	 rgba[i + 2] = temp;
      }
   }
   
// Reads in RGB data for a 24bit image. 
   static void TGA_CvtRGB (uchar *rgb, int size)
   {
      uchar temp;
      int i;
      
      // TGA is stored in BGR, make it RGB 
      for (i = 0; i < size; i += 3)
      {
	 temp = rgb[i];
	 rgb[i] = rgb[i + 2];
	 rgb[i + 2] = temp;
      }
   }
   
   
   class LoaderTGA : public Loader
   {
	 /// Returns true if the file pointed to by \c name does really
	 /// contains a Targa image.
	 virtual bool CanLoad (ObjectType type, Stream &file,
			       const String &name, const String &args)
	 {
	    TGA_Header header;
	    
	    // Read in colormap info and image type, byte 0 ignored 
	    file.read ((char *)&header, sizeof (header));
	    if (header.cmtype != 0 || 
		(header.imgtype != 2 && header.imgtype != 3))
	    {
	       return false;
	    }
	    
	    return true;
	 }
	 
	 /// Load the file pointed to by \c name, and read a object in it.
	 /// It will update the progress every \c granularity percents.
	 virtual bool Load (Object *vis, Stream &file, const String &name, const String &args,
			    Cache *cache,
			    Progress *progress, int granularity)
	 {
	    if (vis == NULL || vis->Type() != V_IMAGE)
	       return false;
	    
	    const char *fname = name.c_str();
	    TGA_Header header;
	    
	    /* Read in colormap info and image type, byte 0 ignored */
	    file.read ((char *) &header, sizeof (header));
	    //file.Seek (SM_CUR, header.idlen);
	    file.seekg (header.idlen, std::ios::cur);

	    if (header.cmtype != 0 ||
		(header.imgtype != 2 && header.imgtype != 3))
	    {
	       Sys()->Warning("Bad header for \"%s\".", fname);
	       return false;
	    }
	    
	    /* Retrieve header informations */
	    const int width = header.width;
	    const int height = header.height;
	    Image::Format format = Image::NONE_0;
	    
	    const int depth = header.pixsize/8;
	    switch (depth)
	    {
	       case 4: format = Image::RGBA_8888; break;
	       case 3: format = Image::RGB_888; break;
	       case 1: format = Image::I_8; break;
	       default:
		  Sys()->Warning
		     ("Bad bit depth for \"%s\" (%d).", fname, header.pixsize);
		  return false;
	    }
	    
	    const int size = width * height * depth;
	    Image *img = (Image*) vis;
	    
	    if (!img->SetFormat (width, height, format, NULL)	||
		!file.read ((char *) img->m_Data, size)		)
	    {
	       delete img;
	       Sys()->Warning("Cannot read data for \"%s\".", fname);
	       return false;
	    }
	    
	    switch (depth)
	    {
	       case 4: TGA_CvtRGBA (img->m_Data, size); break;
	       case 3: TGA_CvtRGB (img->m_Data, size); break;
	    }
	    
	    //Ark::TGA_SwapTopBottom (img->m_Data, height, width * depth);
	    return true;
	 }
	 
	 /// Returns informations about the formats supported by this loader.
	 virtual String GetInformations()
	 {
	    return "Targa";
	 }
   };
   
   void ark_AddTgaLoader (Loaders *loaders)
   {
      loaders->Add (new LoaderTGA());
   }

/* namespace Ark */
}
