/*
 * Copyright (c) 1995, 1996, 1997, 1998, 1999, 2002 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifdef NNPFS_DEBUG
#include <nnpfs/nnpfs_locl.h>
#include <nnpfs/nnpfs_common.h>
#include <nnpfs/nnpfs_deb.h>

RCSID("$Id: nnpfs_common-osf.c,v 1.14 2002/12/19 10:30:15 lha Exp $");

static u_int nnpfs_allocs;
static u_int nnpfs_frees;

void *
nnpfs_alloc(u_int size, int type)
{
    nnpfs_allocs++;
    NNPFSDEB(XDEBMEM, ("nnpfs_alloc: nnpfs_allocs-nnpfs_frees %d\n", 
		     nnpfs_allocs - nnpfs_frees));
    return malloc(size, BUCKETINDEX(size), type, M_WAITOK);
}

void
nnpfs_free(void *ptr, u_int size, in type)
{
    nnpfs_frees++;
    free(ptr, type);
}
#endif

int
nnpfs_suser(struct proc *p)
{
    return suser (nnpfs_proc_to_cred(p), NULL);
}

const char *
nnpfs_devtoname_r (dev_t dev, char *buf, size_t sz)
{
    return "<unknown device>";
}
