/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
// net_udp.h

// Modified for Armagetron by Manuel Moos (manuel@moosnet.de)


#ifndef NET_ANET_H
#define NET_ANET_H

#include <stdlib.h>
#include <sys/types.h>

#ifndef WIN32
extern "C" {
#include <sys/socket.h>
}
#else
#include <windows.h>
#include <winsock.h>
#endif

#include <iostream.h>
#include "tConsole.h"

typedef  char int8;

#define NET_NAMELEN 100

typedef int Socket;

inline void Sys_Error(const char *x){
  con << x;
  exit(-1);
}

inline void Con_Printf(const char *x){
  con << x;
}

inline void Con_SafePrintf(const char *x){
  con << x;
}

inline void Con_DPrintf(const char *x){
  con << x;
}

// the Armagetron port 
extern  unsigned int net_hostport;

extern tString my_tcpip_address;
extern bool tcpipAvailable;
extern tString hostname;

Socket  ANET_Init (void);
void ANET_Shutdown (void);
void ANET_Listen (bool state);
Socket  ANET_OpenSocket (int port);
int  ANET_CloseSocket (Socket sock);
int  ANET_Connect (Socket sock, struct sockaddr *addr);
Socket  ANET_CheckNewConnections (void);
int  ANET_Read (Socket sock, int8 *buf, int len, struct sockaddr *addr);
int  ANET_Write (Socket sock, const int8 *buf, int len, struct sockaddr *addr);
//int  ANET_Broadcast (Socket sock, const char *buf, int len);
char *ANET_AddrToString (const struct sockaddr *addr);
int  ANET_StringToAddr (const char *string, struct sockaddr *addr);
int  ANET_GetSocketAddr (Socket sock, struct sockaddr *addr);
int  ANET_GetNameFromAddr (const struct sockaddr *addr, char *name);
int  ANET_GetAddrFromName (const char *name, struct sockaddr *addr);
int  ANET_AddrCompare (struct sockaddr *addr1, struct sockaddr *addr2);
int  ANET_GetSocketPort (struct sockaddr *addr);
int  ANET_SetSocketPort (struct sockaddr *addr, int port);

#endif
