# FindNET search and find the libnet library path
#
# The following variables are set:
# CMAKE_C_FLAGS - flags to add to the C compiler for build arpon
# CMAKE_INCLUDE - include path Cflag 
# CMAKE_LIBS    - library path Cflag
#
# Copyright 2010 <Giuseppe Marco Randazzo> zeld@freaknet.org
#
# Redistribution AND use is allowed according to the terms of the New
# BSD license.

find_path(LIBNET_INCLUDE_DIR ${libnet_h}  ${CMAKE_INCLUDE_PATH})

find_path(LIBNET_LIB_DIR ${libnet} ${CMAKE_LIBRARY_PATH})

find_library(LIBNET_LIBRARY NAMES ${libnet} PATH ${CMAKE_LIBRARY_PATH})

if(LIBNET_INCLUDE_DIR AND LIBNET_LIB_DIR AND LIBNET_LIBRARY )
  message(STATUS "Found Libnet.")

  if(NOT ${INCLUDE_DIR} MATCHES ${LIBNET_INCLUDE_DIR})
    set(INCLUDE_DIR "${INCLUDE_DIR} ${LIBNET_INCLUDE_DIR}")
    include_directories(${LIBNET_INCLUDE_DIR})
  endif(NOT ${INCLUDE_DIR} MATCHES ${LIBNET_INCLUDE_DIR})

  if(NOT ${LIB_DIR} MATCHES ${LIBNET_LIB_DIR})
    link_directories(${LIBNET_LIB_DIR})
    set(LIB_DIR "${LIB_DIR} ${LIBNET_LIB_DIR}")
  endif(NOT ${LIB_DIR} MATCHES ${LIBNET_LIB_DIR})

else(NOT LIBNET_INCLUDE_DIR OR NOT LIBNET_LIB_DIR OR NOT LIBNET_LIBRARY)
  message(FATAL_ERROR "Could not find libnet-1.1! Please Visit: http://libnet.sourceforge.net/ or see in the arpon 'INSTALL' file")
endif(LIBNET_INCLUDE_DIR AND LIBNET_LIB_DIR AND LIBNET_LIBRARY)
