#ifndef originh
#define originh

#include <glib.h>

#define ORIGIN_MAX 64

typedef struct {
  gboolean enabled[ORIGIN_MAX];
  guint16 instance[ORIGIN_MAX];
} Origin;

typedef struct {
  guint id;
  guint instance;
} OriginId;

// Registers an origin id and writes it to the given ptr
OriginId origin_register_id();

// Unregisters the origin id
void origin_unregister_id(OriginId id);

// Resets an origin struct
void origin_reset(Origin *o);

// Sets an origin-id in origin struct
void origin_set(Origin *o, OriginId id, gboolean b);

// Returns TRUE, when given origin-id ist set in origin struct
gboolean origin_is_set(Origin *o, OriginId id);

// Combines to origins a and b to a
void origin_merge(Origin *a, Origin *b);

#endif
