------------------------------------------------------------------------------
--                                                                          --
--                            GNATPP COMPONENTS                             --
--                                                                          --
--                      G N A T P P . C O M M E N T S                       --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                     Copyright (C) 2001-2005, AdaCore                     --
--                                                                          --
-- GNATPP is free software; you can redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNATPP is  distributed in the  hope that it will  be  useful, but --
-- WITHOUT ANY WARRANTY; without even the implied warranty of  MERCHANTABI- --
-- LITY or  FITNESS  FOR A  PARTICULAR  PURPOSE. See the GNU General Public --
-- License  for more details. You  should  have  received a copy of the GNU --
-- General Public License  distributed with GNAT; see file COPYING. If not, --
-- write  to  the Free  Software  Foundation,  59 Temple Place - Suite 330, --
-- Boston,                                                                  --
--                                                                          --
-- GNATPP is maintained by ACT Europe (http://www.act-europe.fr).           --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains routines for pretty-printing Ada comments

package GNATPP.Comments is

   procedure Get_Next_Ada_Lexem
     (Keep_Empty_Lines       : Boolean := False;
      Called_After_Ada_Token : Boolean := True);
   --  This procedure traverses the original source staring from the current
   --  position and moves Current_Line and Line_Pos ahead till the next lexem
   --  of the Ada part of the source is found (or till the end of the source is
   --  reached). It leaves Line_Pos pointing to the first character of this Ada
   --  lexem.
   --
   --  When passing comments, this procedure sends these comments into the
   --  output stream with proper formatting.
   --
   --  When passing empty lines, then, if Keep_Empty_Lines is set OFF, empty
   --  lines are skipped (unless these empty lines are in between comment
   --  lines). If Keep_Empty_Lines is set ON or if the empty lines are in
   --  between the comment lines, the sequence of several empty lines is
   --  replaced by one empty line. Empty lines contain no symbol at all (except
   --  the line break)
   --
   --  The parameter Called_After_Ada_Token (which is usually set True by
   --  default) is used to indicate a special situation when this procedure is
   --  called in the very beginning of the processing (before the first Ada
   --  token is processed, and therefore no end-of-line comments may be
   --  detected).

   function Non_Formattable_Comment return Boolean;
   --  Is supposed to be called when the string buffer contains the comment
   --  line. It checks if the layout of this line should not be changed
   --  when pretty-printing. As a side effect, it sets Word_End pointing to
   --  the last non-blank character of the comment

end GNATPP.Comments;
