------------------------------------------------------------------------------
--                                                                          --
--                 ASIS-for-GNAT IMPLEMENTATION COMPONENTS                  --
--                                                                          --
--                         A 4 G . E X P R _ S E M                          --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.9 $
--                                                                          --
--            Copyright (c) 1995-1999, Free Software Foundation, Inc.       --
--                                                                          --
-- ASIS-for-GNAT is free software; you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version. ASIS-for-GNAT is distributed  in the hope  that it will be use- --
-- ful, but WITHOUT ANY WARRANTY; without even the implied warranty of MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General  --
-- Public License for more details. You should have received a copy of the  --
-- GNU General Public License  distributed with ASIS-for-GNAT; see file     --
-- COPYING. If not, write to the Free Software Foundation,  59 Temple Place --
-- - Suite 330,  Boston, MA 02111-1307, USA.                                --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- ASIS-for-GNAT was originally developed  by the ASIS-for-GNAT team at the --
-- Software  Engineering  Laboratory  of  the Swiss  Federal  Institute  of --
-- Technology (LGL-EPFL) in Lausanne,  Switzerland, in cooperation with the --
-- Scientific  Research  Computer  Center of  Moscow State University (SRCC --
-- MSU), Russia,  with funding partially provided  by grants from the Swiss --
-- National  Science  Foundation  and  the  Swiss  Academy  of  Engineering --
-- Sciences.  ASIS-for-GNAT is now maintained by  Ada Core Technologies Inc --
-- (http://www.gnat.com).                                                   --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains routines needed for semantic queries from
--  the Asis.Expressions package

with Asis; use Asis;

package A4G.Expr_Sem is

   --  All the routines defined in this package do not check their
   --  arguments - a caller is responsible for the proper use of these
   --  routines

   function Expr_Type (Expression : Asis.Expression) return Asis.Declaration;
   --  using the fact, that Expression is of An_Expression kind and that
   --  the Etype field is set for its Node, this function finds the
   --  type declaration which should be returned as the result of
   --  Corresponding_Expression_Type (Expression)

   function Identifier_Name_Definition
     (Reference_I : Element)
      return        Asis.Defining_Name;

   function Character_Literal_Name_Definition
     (Reference_Ch : Element)
      return         Asis.Defining_Name;
   --  Each of these two functions provides an Element representing the
   --  defining occurrence for its argument, provided that the argument is
   --  of appropriate kind and all the necessary checks have already been
   --  done

   function Is_Reference
     (Name : Asis.Element;
      Ref  : Asis.Element)
      return Boolean;
   --  Provided that Name is of A_Defining_Name kind, this function checks is
   --  Ref is a reference to this name. It is an error to call this function
   --  for any Element which is not of A_Defining_Name as an actual for Name.
   --  Any Element is acceptable as an actual for Ref, and this function does
   --  not raise any exception in any case.
   --
   --  ??? Should we move this function into Asis.Extensions?

   function Needs_List (Reference : Asis.Element) return Boolean;
   --  Supposed to be applied to the argument of the
   --  Corresponding_Name_Definition_List query. Checks if Reference
   --  is ambiguous and refers to more than one entity.

   procedure Collect_Overloaded_Entities (Reference : Asis.Element);
   --  Supposed to be called for the argument of the
   --  Corresponding_Name_Definition_List query in case if Needs_List is
   --  True for it. Collects in the Element Table all the defining
   --  names referred by Reference.
   --  This procedure supoposes, that the Element Table is already initialized
   --  in the calling context

end A4G.Expr_Sem;
