/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.io.Serializable;
import java.util.HashMap;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public abstract class BuiltInSchemaFactory
implements Serializable {
    private static HashMap lookup = new HashMap();

    private static SimpleType makeSimpleType(String namespace, String lname, SimpleType baseType, int code) {
        try {
            AtomicType t = new AtomicType();
            t.setIsBuiltIn(true);
            t.setBaseType(baseType);
            t.setDerivationMethodName("restriction");
            t.setFingerprint(StandardNames.getFingerprint(namespace, lname));
            t.setLocalName(lname);
            t.setNamePool(NamePool.getDefaultNamePool());
            lookup.put(new Integer(t.getFingerprint()), t);
            return t;
        }
        catch (SchemaException err) {
            throw new AssertionError((Object)("No exception should be thrown here. " + err.getMessage()));
        }
    }

    private static SimpleType makeListType(String namespace, String lname, SimpleType itemType) {
        try {
            ListType t = new ListType(NamePool.getDefaultNamePool());
            t.setItemType(itemType);
            t.setBaseType(BuiltInSchemaFactory.getSchemaType(593));
            t.setDerivationMethodName("list");
            t.setFingerprint(StandardNames.getFingerprint(namespace, lname));
            t.setLocalName(lname);
            lookup.put(new Integer(t.getFingerprint()), t);
            return t;
        }
        catch (SchemaException err) {
            throw new AssertionError((Object)("No exception should be thrown here. " + err.getMessage()));
        }
    }

    public static SchemaType getSchemaType(int fingerprint) {
        return (SchemaType)lookup.get(new Integer(fingerprint));
    }

    static {
        String XS = "http://www.w3.org/2001/XMLSchema";
        String XDT = "http://www.w3.org/2003/11/xpath-datatypes";
        SimpleType anySimpleType = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "anySimpleType", null, 593);
        SimpleType anyAtomicType = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2003/11/xpath-datatypes", "anyAtomicType", anySimpleType, 643);
        SimpleType numeric = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2003/11/xpath-datatypes", "numeric", anyAtomicType, 646);
        SimpleType string = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "string", anyAtomicType, 513);
        SimpleType xsboolean = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "boolean", anyAtomicType, 514);
        SimpleType duration = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "duration", anyAtomicType, 518);
        SimpleType dateTime = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "dateTime", anyAtomicType, 519);
        SimpleType date = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "date", anyAtomicType, 521);
        SimpleType time = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "time", anyAtomicType, 520);
        SimpleType gYearMonth = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "gYearMonth", anyAtomicType, 522);
        SimpleType gMonth = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "gMonth", anyAtomicType, 526);
        SimpleType gMonthDay = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "gMonthDay", anyAtomicType, 524);
        SimpleType gYear = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "gYear", anyAtomicType, 523);
        SimpleType gDay = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "gDay", anyAtomicType, 525);
        SimpleType hexBinary = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "hexBinary", anyAtomicType, 527);
        SimpleType base64Binary = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "base64Binary", anyAtomicType, 528);
        SimpleType anyURI = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "anyURI", anyAtomicType, 529);
        SimpleType qName = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "QName", anyAtomicType, 530);
        SimpleType notation = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "NOTATION", anyAtomicType, 531);
        SimpleType untypedAtomic = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2003/11/xpath-datatypes", "untypedAtomic", anyAtomicType, 642);
        SimpleType decimal = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "decimal", numeric, 515);
        SimpleType xsfloat = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "float", numeric, 516);
        SimpleType xsdouble = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "double", numeric, 517);
        SimpleType xsinteger = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "integer", decimal, 532);
        SimpleType nonPositiveInteger = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "nonPositiveInteger", xsinteger, 533);
        SimpleType negativeInteger = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "negativeInteger", nonPositiveInteger, 534);
        SimpleType xslong = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "long", xsinteger, 535);
        SimpleType xsint = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "int", xslong, 536);
        SimpleType xsshort = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "short", xsint, 537);
        SimpleType xsbyte = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "byte", xsshort, 538);
        SimpleType nonNegativeInteger = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "nonNegativeInteger", xsinteger, 539);
        SimpleType positiveInteger = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "positiveInteger", nonNegativeInteger, 540);
        SimpleType unsignedLong = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "unsignedLong", nonNegativeInteger, 541);
        SimpleType unsignedInt = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "unsignedInt", unsignedLong, 542);
        SimpleType unsignedShort = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "unsignedShort", unsignedInt, 543);
        SimpleType unsignedByte = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "unsignedByte", unsignedShort, 544);
        SimpleType ymd = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2003/11/xpath-datatypes", "yearMonthDuration", duration, 644);
        SimpleType dtd = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2003/11/xpath-datatypes", "dayTimeDuration", duration, 645);
        SimpleType normalizedString = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "normalizedString", string, 553);
        SimpleType token = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "token", normalizedString, 554);
        SimpleType language = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "language", token, 555);
        SimpleType name = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "Name", token, 558);
        SimpleType nmtoken = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "NMTOKEN", token, 556);
        SimpleType ncname = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "NCName", name, 559);
        SimpleType id = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "ID", ncname, 560);
        SimpleType idref = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "IDREF", ncname, 561);
        SimpleType entity = BuiltInSchemaFactory.makeSimpleType("http://www.w3.org/2001/XMLSchema", "ENTITY", ncname, 563);
        BuiltInSchemaFactory.makeListType("http://www.w3.org/2001/XMLSchema", "NMTOKENS", nmtoken);
        BuiltInSchemaFactory.makeListType("http://www.w3.org/2001/XMLSchema", "IDREFS", nmtoken);
        BuiltInSchemaFactory.makeListType("http://www.w3.org/2001/XMLSchema", "ENTITIES", nmtoken);
        lookup.put(new Integer(592), AnyType.getInstance());
    }
}

