
#include "file_util.hh"

#include "file_data_util.hh"

namespace aspell {
  
  void fill_data_dir(const Config * config, string & dir1, string & dir2) {
    if (config->have("local-data-dir")) {
      dir1 = config->retrieve("local-data-dir");
      if (dir1[dir1.size()-1] != '/') dir1 += '/';
    } else {
      dir1 = config->retrieve("master-path");
      dir1.resize(dir1.rfind('/') + 1);
    }
    dir2 = config->retrieve("data-dir");
    if (dir2[dir2.size()-1] != '/') dir2 += '/';
  }
  
  void find_file(string & file,
		 const string & dir1, const string & dir2, 
		 const string & name, const char * extension)
  {
    file = dir1 + name + extension;
    if (file_exists(file)) return;
    file = dir2 + name + extension;
  }
  
}
