
#include <pspell/error.h>
#include <pspell/error_messages.hh>

#include "file_exceps.hh"
#include "app_string.hh"

namespace autil {

  CantReadFile::CantReadFile(const string & f)
    : FileException(f)
  {
    AppString s(&message);
    PspellErrorExtraInfo * dummy = 0;
    cant_read_file(number, dummy, s, f.c_str());
  }

  CantWriteFile::CantWriteFile(const string & f)
    : FileException(f)
  {
    AppString s(&message);
    PspellErrorExtraInfo * dummy = 0;
    cant_write_file(number, dummy, s, f.c_str());
  }

  BadFileFormat::BadFileFormat(const string & f, const string & w)
    : FileException(f)
  {
    AppString s(&message);
    PspellErrorExtraInfo * dummy = 0;
    bad_file_format(number, dummy, s, f.c_str(), w.c_str());
  }
  
}

