#################################################################################
#
# Makefile
#
# Makefile for the OpenH323 wrapper library and the ASTERISK channel
# driver module.
#
# Non-configurable makefile part.
#
# Copyright (c) 2002-2005 InAccess Networks
# Michalis Manousos <manousos@inaccessnetworks.com>
# Dimitris Economou <decon@inaccessnetworks.com>
#
# This file is part of "H.323 support for ASTERISK"
#
# "H.323 support for ASTERISK" is free software;
# you can redistribute it and/or modify it under the terms of the
# GNU General Public License as published by the Free Software Foundation;
# either version 2 of the License, or (at your option) any later version. 
#
# "H.323 support for ASTERISK" is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied warranty
# of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details. 
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
#
# $Id: rules.mak,v 1.2 2005/09/09 14:35:23 manousos Exp $
#
#################################################################################

# Export all variables to child processes
.EXPORT_ALL_VARIABLES:

#
# Definition of variables and toolchain
#
SHELL := /bin/sh
PROC = $(shell uname -m)
SUBDIRS = wrapper asterisk-driver
.PHONY: all build install clean subdirs_build subdir_install subdir_clean \
		rpm rpm_clean help $(SUBDIRS)
CC = gcc
CPP = g++
MAKE = make
INSTALL = install
TOUCH = touch
AR = ar
STRIP = strip
STRIPFLAGS = 
OH323WRAPINCLUDE = \
				 -I$(PWLIBDIR)/include \
				 -I$(OPENH323DIR)/include \
				 -I$(OPENH323DIR)/include/openh323 \
				 -I../asterisk-driver
ASTERISKINCLUDE = -I$(ASTERISKINCDIR) -I../wrapper

ifdef	NOTRACE
OH323BUILDTYPE = optnotrace
endif

# Set the C++ compiler flags (for wrapper compilation)
# and C compiler flags (for channel driver compilation)
CPPFLAGS = -Wall -felide-constructors -x c++ -Os
CFLAGS = -Wall
ifeq	($(OH323BUILDTYPE),optnotrace)
OPENH323USERFLAGS := NOTRACE=1
endif
ifeq	($(OH323BUILDTYPE),debug)
CPPFLAGS += -g
CFLAGS += -g
endif

ifdef	USE_OLD_CAPABILITIES_API
CPPFLAGS += -DUSE_OLD_CAPABILITIES_API=1
CFLAGS += -DUSE_OLD_CAPABILITIES_API=1
endif

ifneq	($(PROC),)
CFLAGS += -march=$(PROC)
endif

ifdef	HAS_OH323MODS
CPPFLAGS += -DHAS_OH323MODS
CFLAGS += -DHAS_OH323MODS
endif

ifdef DEBUG_THREADS
CFLAGS += -DDEBUG_THREADS
endif
ifdef DO_CRASH
CFLAGS += -DDO_CRASH
endif
ifdef DETECT_DEADLOCKS
CFLAGS += -DDETECT_DEADLOCKS
endif

#
# Rules
#
build: subdirs_build
 
strip: subdirs_strip
 
install: subdirs_build subdirs_install
 
clean: subdirs_clean rpm_clean

all: subdirs_build subdirs_strip subdirs_install

subdirs_build:
	for x in $(SUBDIRS); do $(MAKE) -C $$x build || exit 1 ; done
 
subdirs_strip:
	for x in $(SUBDIRS); do $(MAKE) -C $$x strip || exit 1 ; done
 
subdirs_install:
	for x in $(SUBDIRS); do $(MAKE) -C $$x install || exit 1 ; done

subdirs_clean:
	for x in $(SUBDIRS); do $(MAKE) -C $$x clean || exit 1 ; done

rpm:
	$(MAKE) -C rpm rpm

rpm_clean:
	$(MAKE) -C rpm rpm_clean

help:
	@echo "Available targets for 'asterisk-oh323' :"
	@echo "  make            Build the binaries (channel driver/wrapper library)"
	@echo "  make build      The same as a simple 'make'"
	@echo "  make strip      Strip the built binaries to save space"
	@echo "  make install    Install the built binaries"
	@echo "  make all        Build, strip and install the binaries"
	@echo "  make clean      Delete temporary, object and built binaries"

