/****************************************************************
**
** Attal : Lords of Doom
**
** sectionGeneral.cpp
** section with general info about theme
**
** Version : $Id: sectionGeneral.cpp,v 1.4 2004/08/07 12:04:09 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 02/06/2001
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "sectionGeneral.h"
 
// generic include files
// include files for QT
#include <qstring.h>
#include <qlabel.h>
#include <qlayout.h>
// application specific include files
#include "libCommon/dataTheme.h"
#include "libCommon/generalOptions.h"
#include "libCommon/log.h"

#include "libClient/gui.h"

extern QString IMAGE_PATH;
extern DataTheme DataTheme;

SectionGeneral::SectionGeneral( QWidget * parent, const char * name )
	: Section( parent, name )
{
	_vision = new AskCombo( tr( "Vision management: " ), this );
	_vision->insertItem( GeneralOptions::getVisionManagementName( GeneralOptions::VISION_ONCE ) );
	_vision->insertItem( GeneralOptions::getVisionManagementName( GeneralOptions::VISION_REAL ) );

	_nbUnit = new AskInt( tr( "Number of unit/lord" ), this );
	_nbUnit->setMinValue( 1 );
	_nbUnit->setMaxValue( 10 );

	_logo = new AskPixmap( false, IMAGE_PATH + QString( "misc/logo.png" ), tr( "Logo (200x180): " ), this );

	QVBoxLayout * layout = new QVBoxLayout( this );
	layout->setMargin( 5 );
	layout->setSpacing( 5 );
	layout->addWidget( _vision );
	layout->addWidget( _nbUnit );
	layout->addWidget( _logo );
	layout->addStretch( 1 );
	layout->activate();
	
	init();
}

void SectionGeneral::init()
{
	_vision->setCurrentItem( (uint)DataTheme.general.getVisionManagement() );
}

void SectionGeneral::save()
{
	DataTheme.general.setVisionManagement( ( GeneralOptions::VISION_MANAGEMENT )_vision->currentItem() );
	_logo->save();
	emit sig_changed();
}


