/****************************************************************
**
** Attal : Lords of Doom
**
** game.h
** Manages the whole game
**
** Version : $Id: game.h,v 1.71 2008/03/03 22:50:10 lusum Exp $
**
** Author(s) : Pascal Audoux - Sardi Carlo
**
** Date : 17/08/2000
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/


#ifndef GAME_H
#define GAME_H


// include files for QT
#include <QLabel>
#include <QPixmap>
#include <QWidget>

// application specific includes
#include "libClient/player.h"
#include "libCommon/genericCell.h"
#include "libClient/map.h"
#include "libClient/gameControl.h"
#include "libClient/graphicalGameData.h"
#include "libClient/mapView.h"
#include "libClient/widget.h"

#include "libCommon/attalSocket.h"
#include "libCommon/log.h"

class BaseInfo;
class Calendar;
class ChatWidget;
class DisplayLordTab;
class GameInfo;
class GenericBase;
class InfoStack;
class LordExchange;
class LordInfo;
class MiniMap;

class QHBoxLayout;
class QPixmap;
class QVBoxLayout;


/*              ------------------------------
 *                         Game
 *              ------------------------------ */


/** comment for the class */
class Game : public QWidget, public GraphicalGameData
{
	Q_OBJECT
public:
	/** Constructor */
	Game( QWidget * parent = 0, const char * name = 0 );
	
	/** Destructor : delete player and lord */
	~Game();
	
	/** Reinit */
	void reinit();

	/** Associate a socket to the Game (for exchange with the server) */
	void setSocket( AttalSocket * sock ) {
		_socket = sock;
	}

	/** Lord 'lord' enters in base 'base' */
	void enter( GenericLord * lord, GenericBase * base );

	/** Lord 'lord' enters in building 'build' */
	void enter( GenericLord * lord, GenericBuilding * building );

	/** Handle socket data */
	void handleSocket();

	/** Begin game with 'nb' players */
	void beginGame( int nb );

	/** End game */
	void endGame();
	
	/** Begin turn */
	void beginTurn();

	/** End turn */
	void endTurn();

	/** Player active is player 'num' */
	void playerActive( char num );

	/** Activate next lord */
	void nextLord();
	
	/** Activate next base */
	void nextBase();

	/** Return the player associated to the game */
	Player * getGamePlayer() { return _player; }

	/** Sets the name of the player */
	void setPlayerName( QString name );
	
	enum MapState {
		MS_NOTHING,
		MS_LORD,
		MS_BASE,
		MS_TECHNIC
	};
	
	enum QRCreature {
		QRFLEE,
		QRMERCENARY,
		QRJOIN
	};

	void setState( MapState state );

	MapState getState() { return _state; }

	void displayMiniMap( bool state );
	
	void displayFullScreen( bool state );
	
	ChatWidget * getChat() {return  (_chat) ? _chat : 0 ; }

	void updateOptions();
	
	void updateDispositionMode();
	
	void updateWindows();

	void setAdvancePeriod( int period );

	void restartTimer();
	
	void stopTimer();
	
signals:
	void sig_base( GenericBase * );

	void sig_fight( GenericLord * lord, CLASS_FIGHTER cla );

	void sig_statusMsg( const QString & );
	
	void sig_scenInfo( const QString & );
	
	void sig_Center( int , int );

	void sig_endGame();
	
	void sig_endTurn();
	
	void sig_beginTurn();

	void sig_exchange();

	void sig_result(bool);
		
	void sig_statusBar();
	
	void sig_newMessage( const QString & );

	void sig_baseReinit();
	
	void sig_lordReinit();
	
	void sig_cellChanged( int , int );
	
public slots:
	/** Slot for displaying lord */
	void slot_displayLord();

	/** Slot for displaying base */
	void slot_displayBase();

	void slot_lordSelected();
	
	void slot_baseSelected();

	/** */
	void slot_message( QString );

private slots:
	void slot_endTurn() { endTurn(); }
	void slot_mouseMoved( GenericCell *cell );
	void slot_mouseLeftPressed( GenericCell * cell );
	void slot_mouseRightPressed( GenericCell * cell );
	void slot_mouseReleased();

protected:
	void timerEvent(QTimerEvent *event);

private:
	void initWidgets();

	void updateAnimations();

	void handleClickNothing( GenericCell * cell );
	void handleClickLord( GenericCell * cell );
	void handleClickBase( GenericCell * cell );
	void handleClickTechnic( GenericCell * cell );

	/** Manage socket SO_MSG */
	void socketMsg();

	/** Manage socket SO_GAME */
	void socketGame();
	void socketGameLost();
	void socketGameWin();
	void socketGameInfo();
	void socketGameInfoTeam();
	void socketGameCalendar();

	/** Manage socket SO_TURN */
	void socketTurn();
	void socketTurnPlay();

	/** Manage socket SO_MVT */
	void socketMvt();

	/** Manage socket SO_MODIF */
	void socketModif();
	void socketModifCell();
	void socketModifLord();
	void socketModifBase();
	void socketModifBuilding();
	void socketModifArtefact();
	void socketModifPlayer();
	//void socketModifPlayerPopulation();
	void socketModifCreature();
	void socketModifMap();

	void socketModifEvent();
	void socketEventNew();
	void socketEventDel();

	void socketModifLordVisit();
	void socketModifLordNew();
	void socketModifLordUnit();
	void socketModifLordRemove();
	void socketModifLordCharac();
	void socketModifLordGarrison();
	void socketModifLordMachine();

	void socketModifBaseNew();
	void socketModifBaseOwner();
	void socketModifBaseName();
	void socketModifBaseBuilding();
	void socketModifBaseUnit();
	void socketModifBasePopulation();
	void socketModifBaseResources();
	void socketModifBaseProduction();
	
	void socketModifBuildingNew();
	void socketModifBuildingOwner();
	void socketModifBuildingResources();
		
	void socketModifCreatureNew();
	void socketModifCreatureUpdate();
	void socketModifCreatureRemove();
	void socketModifCreatureRess();

	/** Manage socket SO_CONNECT */
	void socketConnect();
	void socketConnectOk();
	void socketConnectId();
	void socketConnectName();

	/** Manage socket SO_EXCH */
	void socketExchange();
	void exchangeStart();
	void exchangeUnits();
	void exchangeArtefact();	
	void exchangeBaseUnits();

	void socketQR();
	void socketQRMsgNext();
	void socketQRMsgEnd();
	void socketQRLevel();
	void socketQRChest();
	void socketQRCreature(QRCreature state);

	void socketFight();
	void socketFightInit();
	void socketFightEnd();

	Player * _player;
	AttalSocket * _socket;
	GameControl * _control;
	GameInfo * _gameInfo;
	LordInfo * _lordInfo;
	BaseInfo * _baseInfo;
	AttalPopup  * _popup;
	DisplayLordTab * _dispLord;
	LordExchange * _lordExchange;
	MiniMap * _miniMap;
	MapView * _view;
	InfoStack * _stackInfo;
	ChatWidget * _chat;
	ScrollLord * _scrLord;
	ScrollBase * _scrBase;
	GenericCell * _currentCell;
	bool _isPlaying;
	QString _msg;
	QVBoxLayout * _layControlV1;
	QHBoxLayout * _layControlH1; 
	QHBoxLayout * _layH1;
	QVBoxLayout * _layout;
	bool _redraw;
	int _idTime, _period;

	MapState _state;
};


#endif // GAME_H


