.\" This manpage is copyright (C) 2000, 2001 Progeny Linux Systems, Inc.
.\" Author: Branden Robinson <branden@progeny.com>
.\"
.\" This is free software; you may redistribute it and/or modify
.\" it under the terms of the GNU General Public License as
.\" published by the Free Software Foundation; either version 2,
.\" or (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful, but
.\" WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with the Debian GNU/Linux system; if not, write to the Free
.\" Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
.\" 02111-1307 USA
.TH make-autoinst-initrd 1 "2001-07-09" "Debian GNU/Linux"
.SH NAME
make-autoinst-initrd \- create initial ramdisk for system autoinstaller
.SH SYNOPSIS
make-autoinst-initrd [--arch \fIarch\fP] \fIkernel_package\fP
.SH DESCRIPTION
.B make-autoinst-initrd
creates an initalization ramdisk for use by the operating system
autoinstaller.  It takes a single, mandatory argument: the kernel
package containing the kernel to be used for the initrd and floppy
boot environment.  If an autoinstall disk for another architecture is
needed, then the
.I --arch
argument can be given to specify the architecture.
.PP
The initialization ramdisk consists of a compressed ext2 filesystem, and is
left in the current directory as
.IR initrd.gz .
This file is typically placed (by
.B make-autoinst-disk (1))
on a floppy disk or other medium accessible by the bootloader used by the
autoinstaller.
.SH ENVIRONMENT
.TP
TMPDIR
Temporary directory under which a directory is created to be used for
construction of the ext2 filesystem.  If omitted, \fI/tmp\fP is used.
.SH AUTHOR
Jeff Licquia et al. for Progeny Linux Systems.
.SH SEE ALSO
.BR make-autoinst-disk (1),
.BR update-autoinst-disk (1)
