/*
   mulsi10.S - optimized 32-bit multiply by 10

   Contributors:
     Created by Reiner Patommel <rpatop@post4.tele.dk> based on
	 mul10.S by Marek Michalkiewicz <marekm@linux.org.pl>

   THIS SOFTWARE IS NOT COPYRIGHTED

   This source code is offered for use in the public domain.  You may
   use, modify or distribute it freely.

   This code is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY.  ALL WARRANTIES, EXPRESS OR IMPLIED ARE HEREBY
   DISCLAIMED.  This includes but is not limited to warranties of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "macros.inc"

#define r_hi_hi 		r25
#define r_hi_lo 		r24
#define r_lo_hi 		r23
#define r_lo_lo 		r22

#define r_tmp_hi_hi		r21
#define r_tmp_hi_lo		r20
#define r_tmp_lo_hi		r19
#define r_tmp_lo_lo		r18

/*
   r_hi_hi:r_hi_lo:r_lo_hi:r_lo_lo *= 10

 */

	.section .text
	.global _U(__mulsi_const_10)

_U(__mulsi_const_10):
	mov r_tmp_hi_hi, r_hi_hi
	mov r_tmp_hi_lo, r_hi_lo
	mov r_tmp_lo_hi, r_lo_hi
	mov r_tmp_lo_lo, r_lo_lo
	add r_lo_lo, r_lo_lo
	adc	r_lo_hi, r_lo_hi
	adc	r_hi_lo, r_hi_lo
	adc	r_hi_hi, r_hi_hi			; d *= 2
	add r_lo_lo, r_lo_lo
	adc	r_lo_hi, r_lo_hi
	adc	r_hi_lo, r_hi_lo
	adc	r_hi_hi, r_hi_hi			; d *= 4
	add r_lo_lo, r_tmp_lo_lo
	adc	r_lo_hi, r_tmp_lo_hi
	adc	r_hi_lo, r_tmp_hi_lo
	adc	r_hi_hi, r_tmp_hi_hi		; d *= 5
	add r_lo_lo, r_lo_lo
	adc	r_lo_hi, r_lo_hi
	adc	r_hi_lo, r_hi_lo
	adc	r_hi_hi, r_hi_hi			; d *= 10

	ret

