/*  -*- Mode: Asm -*-  */
/*
    divsf3.S is part of     FPlib V 0.3.0       ported to avr-as
    for copyright and details see readme.fplib

 *----------------------------------------------------------------------------------------
 *
 * divides two numbers R = A / B
 * stored in T by ___divsf3
 * A  rA3 : rA2:rA1:rA0
 * B  rB3 : rB2:rB1:rB0
 * R  rA3 : rA2:rA1:rA0
 */

#include "gasava.inc"
#include "fplib.inc"

          TEXT_SEG(fplib, __divsf3)
          FUNCTION(inverse)

GLOBAL(inverse)
     MOV     rB3,rA3
     MOV     rB2,rA2
     MOV     rB1,rA1
     MOV     rB0,rA0
     LDI     rA3,0x3F
     LDI     rA2,0x80
     CLR     rA1
     CLR     rA0           ; 1.0 / x
GLOBAL(__divsf3)
     RCALL   _U(__fp_split3)
     RCALL   _U(__divsf3x)
     RJMP    _U(__fp_merge)

          ENDFUNC


