
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef RP_USERNAME_TOKEN_H
#define RP_USERNAME_TOKEN_H

/** @defgroup rp_username_token
 * @ingroup rp_username_token
 * @{
 */

#include <rp_includes.h>
#include <rp_token.h>

#ifdef __cplusplus
extern "C"
{
#endif

    typedef enum
    {
        PASSWORD_PLAIN = 0,
        PASSWORD_HASH,
        PASSWORD_NONE /* no password will be provided in the user name token */
    } password_type_t;

    typedef struct rp_username_token_t rp_username_token_t;

    AXIS2_EXTERN rp_username_token_t *AXIS2_CALL
    rp_username_token_create(
        const axutil_env_t * env);

    AXIS2_EXTERN void AXIS2_CALL
    rp_username_token_free(
        rp_username_token_t * username_token,
        const axutil_env_t * env);

    AXIS2_EXTERN axis2_char_t *AXIS2_CALL
    rp_username_token_get_inclusion(
        rp_username_token_t * username_token,
        const axutil_env_t * env);

    AXIS2_EXTERN axis2_status_t AXIS2_CALL
    rp_username_token_set_inclusion(
        rp_username_token_t * username_token,
        const axutil_env_t * env,
        axis2_char_t * inclusion);

    AXIS2_EXTERN axis2_bool_t AXIS2_CALL
    rp_username_token_get_useUTprofile10(
        rp_username_token_t * username_token,
        const axutil_env_t * env);

    AXIS2_EXTERN axis2_status_t AXIS2_CALL
    rp_username_token_set_useUTprofile10(
        rp_username_token_t * username_token,
        const axutil_env_t * env,
        axis2_bool_t useUTprofile10);

    AXIS2_EXTERN axis2_bool_t AXIS2_CALL
    rp_username_token_get_useUTprofile11(
        rp_username_token_t * username_token,
        const axutil_env_t * env);

    AXIS2_EXTERN axis2_status_t AXIS2_CALL
    rp_username_token_set_useUTprofile11(
        rp_username_token_t * username_token,
        const axutil_env_t * env,
        axis2_bool_t useUTprofile11);

    AXIS2_EXTERN axis2_char_t *AXIS2_CALL
    rp_username_token_get_issuer(
        rp_username_token_t * username_token,
        const axutil_env_t * env);

    AXIS2_EXTERN axis2_status_t AXIS2_CALL
    rp_username_token_set_issuer(
        rp_username_token_t * username_token,
        const axutil_env_t * env,
        axis2_char_t * issuer);

    AXIS2_EXTERN derive_key_type_t AXIS2_CALL
    rp_username_token_get_derivedkey_type(
        rp_username_token_t * username_token,
        const axutil_env_t * env);

    AXIS2_EXTERN axis2_status_t AXIS2_CALL
    rp_username_token_set_derivedkey_type(
        rp_username_token_t * username_token,
        const axutil_env_t * env,
        derive_key_type_t derivedkey);

    AXIS2_EXTERN axis2_bool_t AXIS2_CALL
    rp_username_token_get_is_issuer_name(
        rp_username_token_t * username_token,
        const axutil_env_t * env);

    AXIS2_EXTERN axis2_status_t AXIS2_CALL
    rp_username_token_set_is_issuer_name(
        rp_username_token_t * username_token,
        const axutil_env_t * env,
        axis2_bool_t is_issuer_name);

    AXIS2_EXTERN axiom_node_t *AXIS2_CALL
    rp_username_token_get_claim(
        rp_username_token_t * username_token,
        const axutil_env_t * env);

    AXIS2_EXTERN axis2_status_t AXIS2_CALL
    rp_username_token_set_claim(
        rp_username_token_t * username_token,
        const axutil_env_t * env,
        axiom_node_t *claim);

    AXIS2_EXTERN axis2_status_t AXIS2_CALL
    rp_username_token_increment_ref(
        rp_username_token_t * username_token,
        const axutil_env_t * env);

#ifdef __cplusplus
}
#endif
#endif
