# Arch Perl library, Copyright (C) 2005 Mikhael Goikhman
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.005;
use strict;

package AXP::Command::triggers::move;
use base 'AXP::Command::triggers';

sub optusage {
	"[options] old_limit new_limit"
}

sub infoline {
	"change the limit of a trigger"
}

sub options {
	(
		skip => { sh => 's', desc => "skip the already existing revisions" },
		__PACKAGE__->quiet_option,
	)
}

sub helptext {
	my $prefix = $_[0]->{prefix};
	qq{
		Change the limit of an already existing trigger without having
		to re-register the trigger command.

		This command is handy if the development on a version is finished
		(i.e. released and optionally arch version is sealed) and a new
		version is opened.  In this case, it is usually desirable to
		delete this version from the watch-and-trigger list and transfer
		its action to a new version in one step.

		Example:
			$prefix arch\@ive.org/moz--dev--1 arch\@ive.org/moz--dev--2
	}
}

sub execute {
	my $self = shift;
	my %opt = %{$self->{options}};

	die "'move' requires 2 arguments: arch-name or number shown by 'list', and arch-name\n"
		if @ARGV != 2;
	my ($name1, $name2) = @ARGV;

	my $trigger1 = $self->get_trigger($name1);
	my $trigger2 = $self->get_trigger($name2, "new");

	rename($trigger1->{dir}, $trigger2->{dir});

	$self->{all_trigger_names} = undef;
	my $trigger = $self->load_trigger($name2, "new");
	$trigger->{state} = [];

	$self->skip_revisions($trigger) if $opt{skip};
	$self->save_trigger($trigger);

	print "* trigger $trigger->{name} is switched to $name2\n"
		unless $opt{quiet};
}

1;
