/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import nz.net.catalyst.Log;
import nz.net.catalyst.StringPair;
import nz.net.catalyst.Util;
import nz.net.catalyst.lucene.server.Application;
import nz.net.catalyst.lucene.server.Constants;
import nz.net.catalyst.lucene.server.ECommand;
import nz.net.catalyst.lucene.server.ESplit;
import nz.net.catalyst.lucene.server.EUseApp;
import nz.net.catalyst.lucene.server.FieldDef;
import nz.net.catalyst.lucene.server.FiniteReader;
import nz.net.catalyst.lucene.server.IPackage;
import nz.net.catalyst.lucene.server.RangeDef;
import nz.net.catalyst.lucene.server.TransmissionException;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class Transmission
implements IPackage,
Constants {
    private static final Long INVALID_CONTENT_LENGTH = new Long(Long.MIN_VALUE);
    private final ECommand command;
    private final List headers = new LinkedList();
    private final List headersView = Collections.unmodifiableList(this.headers);
    private String body = null;
    private Application application = null;
    private StringBuffer result = new StringBuffer();
    private boolean XML = false;

    public Transmission(ECommand command) {
        this.command = command;
    }

    public ECommand getCommand() {
        return this.command;
    }

    public static Transmission create(BufferedReader in) throws IOException {
        String line;
        boolean skipping = false;
        while ((line = in.readLine()) != null) {
            ECommand command = ECommand.getByName(line.trim());
            if (command != null) {
                Transmission result = new Transmission(command);
                result.read(in);
                return result;
            }
            if (skipping) continue;
            skipping = true;
            Log.error("Skipping crap starting with: \"" + line + '\"');
        }
        return null;
    }

    public void add(String header, String value) {
        this.headers.add(new StringPair(header.intern(), value));
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public Application getApplication() {
        return this.application;
    }

    public String get(String key) {
        return this.get(key, Constants.USE_APP);
    }

    public String get(String key, EUseApp useApp) {
        String[] result = this.get(key, useApp, Constants.NO_SPLIT);
        return result.length >= 1 ? result[0] : null;
    }

    public String[] get(String key, EUseApp useApp, ESplit split) {
        String value = null;
        ListIterator it = this.headers.listIterator(this.headers.size());
        while (it.hasPrevious()) {
            StringPair entry = (StringPair)it.previous();
            String entryKey = entry.getKeyString();
            if (!entryKey.equals(key)) continue;
            value = entry.getValueString();
            break;
        }
        if (value == null && useApp == Constants.USE_APP && this.application != null) {
            value = this.application.getProperty(key);
        }
        if (value == null) {
            return new String[0];
        }
        if (split == Constants.SPLIT) {
            return Util.split(value);
        }
        return new String[]{value};
    }

    public void setBody(String body) {
        this.body = body;
    }

    public List getHeadersView() {
        return this.headersView;
    }

    public List removeAll(String header) {
        ArrayList<String> result = new ArrayList<String>(this.headers.size());
        Iterator it = this.headers.iterator();
        while (it.hasNext()) {
            StringPair entry = (StringPair)it.next();
            if (!entry.getKeyString().equalsIgnoreCase(header)) continue;
            it.remove();
            result.add(entry.getValueString());
        }
        return result;
    }

    public void clear() {
        this.headers.clear();
    }

    public void write(PrintWriter out) {
        if (this.isXML()) {
            Document document = this.writeXML();
            OutputFormat of = OutputFormat.createPrettyPrint();
            try {
                XMLWriter writerSocket = new XMLWriter((Writer)out, of);
                writerSocket.write(document);
            }
            catch (Exception e) {
                Log.error("Error outputting xml.");
                Log.error(e.getMessage());
            }
            Log.debug("DOM4J Output:\n" + document.asXML());
        } else {
            out.println(this.command.getName());
            Log.debug("> " + this.command.getName());
            Iterator it = this.headers.iterator();
            while (it.hasNext()) {
                StringPair header = (StringPair)it.next();
                if (Log.willDebug()) {
                    Log.debug("> " + header.getKeyString() + ": " + header.getValueString());
                }
                out.print(Util.textEncode(header.getKeyString(), " :"));
                out.print(": ");
                out.println(Util.textEncode(header.getValueString()));
            }
            if (this.body != null) {
                if (Log.willDebug()) {
                    Log.debug("> Content-Length: " + this.body.length());
                }
                out.print("Content-Length");
                out.print(": ");
                out.println(this.body.length());
                out.println();
                out.write(this.body);
                if (Log.willDebug()) {
                    Log.debug("> <body>");
                }
            } else {
                out.println("END");
                if (Log.willDebug()) {
                    Log.debug("> END");
                }
            }
            out.flush();
        }
    }

    public void read(BufferedReader in) throws IOException {
        String line;
        boolean body = false;
        String bodyField = null;
        Long contentLength = null;
        long startTime = System.currentTimeMillis();
        while ((line = in.readLine()) != null) {
            if (Log.willDebug()) {
                Log.debug("< " + Util.clean(line));
            }
            if (line.length() == 0) {
                body = true;
                break;
            }
            if ((line = line.trim()).equalsIgnoreCase("END")) break;
            int separator = line.indexOf(58);
            if (separator == -1) {
                throw new TransmissionException("Missing ':' in header line: \"" + line + '\"');
            }
            String header = line.substring(0, separator).trim();
            if (header.length() == 0) {
                throw new TransmissionException("Blank header illegal in header line: \"" + line + '\"');
            }
            header = Util.textDecode(header);
            String value = Util.textDecode(line.substring(separator + 1).trim());
            if (Log.willDebug()) {
                Log.debug("==> header: \"" + Util.clean(header) + "\", Value: \"" + Util.clean(value) + "\"");
            }
            this.add(header, value);
            if (header.equalsIgnoreCase("Body")) {
                bodyField = value;
            }
            if (!header.equalsIgnoreCase("Content-Length")) continue;
            try {
                contentLength = new Long(value.trim());
            }
            catch (NumberFormatException e) {
                contentLength = INVALID_CONTENT_LENGTH;
            }
        }
        long beforeBody = System.currentTimeMillis();
        if (body) {
            int length;
            if (contentLength == INVALID_CONTENT_LENGTH) {
                Log.error("Invalid \"Content-Length\" header.  Rest of input swallowed.");
                contentLength = null;
            }
            if (contentLength == null) {
                Log.debug("reading body to EOF");
            } else {
                Log.debug("reading body for " + contentLength + " bytes");
            }
            Reader bodyReader = contentLength == null ? in : new FiniteReader(in, contentLength);
            char[] buffer = new char[65536];
            StringBuffer sb = new StringBuffer();
            while (-1 != (length = bodyReader.read(buffer))) {
                sb.append(buffer, 0, length);
            }
            if (bodyReader != in) {
                bodyReader.close();
            }
            String bodyText = sb.toString();
            if (bodyField == null) {
                if (Log.willDebug()) {
                    Log.debug("Ignoring body: " + Util.clean(bodyText));
                }
            } else {
                this.add(bodyField, bodyText);
                if (Log.willDebug()) {
                    Log.debug("==> header: \"" + Util.clean(bodyField) + "\", Value: \"" + Util.clean(bodyText));
                }
            }
        }
        long endTime = System.currentTimeMillis();
        Log.debug("Time to read " + this.command.getName() + ": " + (endTime - startTime) + " ms. Body took " + (endTime - beforeBody) + " ms");
    }

    public List getRanges() {
        LinkedList<RangeDef> ranges = new LinkedList<RangeDef>();
        RangeDef range = null;
        Iterator hdr = this.headers.iterator();
        while (hdr.hasNext()) {
            StringPair header = (StringPair)hdr.next();
            String key = header.getKeyString().trim();
            String value = header.getValueString().trim();
            if (key.equals("Range-Field")) {
                range = new RangeDef(value);
                ranges.add(range);
                continue;
            }
            if (range == null) continue;
            if (key.equals("Range-From")) {
                range.from = value;
                continue;
            }
            if (!key.equals("Range-To")) continue;
            range.to = value;
        }
        return ranges;
    }

    public List getFields() {
        LinkedList<FieldDef> fields = new LinkedList<FieldDef>();
        if (this.application != null) {
            fields.addAll(this.application.getAllFieldDefs());
        }
        FieldDef field = null;
        Iterator hdr = this.headers.iterator();
        while (hdr.hasNext()) {
            StringPair header = (StringPair)hdr.next();
            String key = header.getKeyString().trim();
            String value = header.getValueString().trim();
            if (key.equals("Field-Name")) {
                if (value.length() == 0) {
                    fields.clear();
                    continue;
                }
                field = new FieldDef(value);
                int position = fields.indexOf(field);
                if (position == -1) {
                    fields.add(field);
                    continue;
                }
                field = (FieldDef)fields.get(position);
                continue;
            }
            if (field == null) continue;
            if (key.equals("Field-Type")) {
                field.token = value.equalsIgnoreCase("Text");
                field.date = value.equalsIgnoreCase("Date");
                continue;
            }
            if (key.equals("Field-Indexed")) {
                field.index = value.equalsIgnoreCase("Yes");
                continue;
            }
            if (!key.equals("Field-Stored")) continue;
            field.store = value.equalsIgnoreCase("Yes");
        }
        return fields;
    }

    public String getSerial() {
        return this.get("Serial", Constants.NO_APP);
    }

    public void setSerial(String serial) {
        this.removeAll("Serial");
        if (serial != null) {
            this.add("Serial", serial);
        }
    }

    public boolean isXML() {
        return this.XML;
    }

    public void setXML(boolean isXML) {
        this.XML = isXML;
    }

    public String getResult() {
        return this.result.toString();
    }

    private Document writeXML() {
        Document document;
        block18: {
            Element root;
            block19: {
                Element root2;
                block20: {
                    String _error;
                    block16: {
                        Iterator it;
                        Element root3;
                        block17: {
                            String _error2;
                            document = DocumentHelper.createDocument();
                            if (!this.command.getName().equals("QUERY-RESPONSE")) break block16;
                            root3 = document.addElement("LuceneQueryResponse");
                            String _Serial = this.get("Serial");
                            if (_Serial != null) {
                                this.removeAll("Serial");
                                root3.addElement("Serial").addText(_Serial);
                            }
                            if ((_error2 = this.get("Error")) == null) break block17;
                            root3.addElement("Error").addCDATA(_error2);
                            break block18;
                        }
                        String _Count = this.get("Count");
                        if (_Count != null) {
                            this.removeAll("Count");
                            root3.addElement("Count").addText(_Count);
                        }
                        if (!(it = this.headers.iterator()).hasNext()) break block18;
                        Element results = root3.addElement("Results");
                        StringPair header = (StringPair)it.next();
                        block0: do {
                            Element result = null;
                            String key = header.getKeyString();
                            String value = header.getValueString();
                            do {
                                if (key.equalsIgnoreCase("I")) {
                                    result = results.addElement("Result");
                                    result.addAttribute("counter", value);
                                } else if (key.equalsIgnoreCase("RANK")) {
                                    result.addAttribute("rank", value);
                                } else {
                                    result.addElement("Field").addAttribute("name", key).addCDATA(value);
                                }
                                if (!it.hasNext()) continue block0;
                                header = (StringPair)it.next();
                                key = header.getKeyString();
                                value = header.getValueString();
                            } while (header != null && !key.equalsIgnoreCase("I"));
                        } while (it.hasNext());
                        break block18;
                    }
                    if (!this.command.getName().equals("INDEX-RESPONSE")) break block19;
                    root2 = document.addElement("LuceneIndexResponse");
                    String _Serial = this.get("Serial");
                    if (_Serial != null) {
                        this.removeAll("Serial");
                        root2.addElement("Serial").addCDATA(_Serial);
                    }
                    if ((_error = this.get("Error")) == null) break block20;
                    root2.addElement("Error").addCDATA(_error);
                    break block18;
                }
                Iterator it = this.headers.iterator();
                if (!it.hasNext()) break block18;
                do {
                    StringPair header = (StringPair)it.next();
                    String key = header.getKeyString();
                    String value = header.getValueString();
                    root2.addElement(key).addCDATA(value);
                } while (it.hasNext());
                break block18;
            }
            String name = this.command.getName();
            String element = null;
            if (name.equals("ERROR")) {
                element = "LuceneErrorResponse";
            }
            if (name.equals("UNINDEX-RESPONSE")) {
                element = "LuceneUnIndexResponse";
            }
            if (name.equals("COMMAND")) {
                element = "LuceneUtilityResponse";
            }
            if (element != null) {
                root = document.addElement(element);
            } else {
                root = document.addElement("LuceneResponse");
                root.addAttribute("type", this.command.getName());
            }
            Iterator it = this.headers.iterator();
            while (it.hasNext()) {
                StringPair header = (StringPair)it.next();
                root.addElement(header.getKeyString()).addCDATA(header.getValueString());
            }
        }
        return document;
    }
}

