/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.server;

import java.util.Iterator;
import nz.net.catalyst.Log;
import nz.net.catalyst.Util;
import nz.net.catalyst.lucene.server.ECommand;
import nz.net.catalyst.lucene.server.IPackage;
import nz.net.catalyst.lucene.server.Transmission;
import org.dom4j.Document;
import org.dom4j.Element;

public class XMLHelper
implements IPackage {
    private static final String ERROR = "Error";

    public Transmission getTransmission(Document doc) {
        Element root;
        long sessionStartTime = System.currentTimeMillis();
        Object line = null;
        Transmission transmission = null;
        ECommand command = null;
        Log.debug("Root element: " + doc.getRootElement().getName());
        if (doc.getRootElement().getName().equals("LuceneQueryRequest")) {
            command = ECommand.getByName("QUERY");
            transmission = new Transmission(command);
            root = doc.getRootElement();
            Iterator i = root.elementIterator();
            while (i.hasNext()) {
                Element header = (Element)i.next();
                String name = header.getQualifiedName();
                Log.debug("Element name:" + name + ":\t\tValue:" + Util.clean(header.getText()) + ":");
                if (name.equalsIgnoreCase("Sort")) {
                    transmission.add(name, header.getText());
                    transmission.add("Sort-Limit", header.valueOf("@limit"));
                    Log.debug("\t\tSort-Limit set to:" + header.valueOf("@limit") + ":");
                    continue;
                }
                if (name.equalsIgnoreCase("Offset")) {
                    transmission.add("First", header.getText());
                    continue;
                }
                if (name.equalsIgnoreCase("Range")) {
                    String r_field = header.valueOf("@field");
                    String r_to = header.valueOf("To");
                    String r_from = header.valueOf("From");
                    Log.debug("Range-Field:" + r_field + ": Range-From:" + r_from + ": Range-To:" + r_to + ":");
                    if (r_field.equals("")) {
                        Log.warn("Range specified without field.  Need to specify field in range query.");
                        return XMLHelper.error("Range specified without field.  Need to specify field in range query.");
                    }
                    transmission.add("Range-Field", r_field);
                    if (!r_from.equals("")) {
                        transmission.add("Range-From", r_from);
                    }
                    if (r_to.equals("")) continue;
                    transmission.add("Range-To", r_to);
                    continue;
                }
                if (name.equalsIgnoreCase("Fields")) {
                    this.getFieldDefinitions(doc, transmission, false);
                    continue;
                }
                if (name.equalsIgnoreCase("Query")) {
                    transmission.add(name, header.getText());
                    String defaultField = header.valueOf("@default-field");
                    if (defaultField.equals("")) continue;
                    transmission.add("Default-Field", defaultField);
                    Log.debug("\tDefault-Field: " + defaultField);
                    continue;
                }
                transmission.add(name, header.getText());
            }
        } else if (doc.getRootElement().getName().equals("LuceneIndexRequest")) {
            command = ECommand.getByName("INDEX");
            transmission = new Transmission(command);
            root = doc.getRootElement();
            Iterator i = root.elementIterator();
            while (i.hasNext()) {
                Element header = (Element)i.next();
                String name = header.getQualifiedName();
                Log.debug("Element name:" + name + ":\t\tValue:" + Util.clean(header.getText()) + ":");
                if (name.equalsIgnoreCase("Fields")) {
                    this.getFieldDefinitions(doc, transmission, true);
                    continue;
                }
                transmission.add(header.getQualifiedName(), header.getText());
            }
        } else if (doc.getRootElement().getName().equals("LuceneUnIndexRequest")) {
            command = ECommand.getByName("UNINDEX");
            transmission = new Transmission(command);
            root = doc.getRootElement();
            String name = "";
            Iterator i = root.elementIterator();
            while (i.hasNext()) {
                Element header = (Element)i.next();
                name = header.getQualifiedName();
                Log.debug("Element name:" + name + ":\t\tValue:" + header.getText() + ":");
                if (name.equalsIgnoreCase("Purge")) {
                    transmission.add(name, "true");
                    Log.debug("\t\t" + name + "->true");
                    continue;
                }
                transmission.add(name, header.getText());
            }
        } else if (doc.getRootElement().getName().equals("LuceneUtilityRequest")) {
            command = ECommand.getByName("CONTROL");
            transmission = new Transmission(command);
            root = doc.getRootElement();
            String name = "";
            Iterator i = root.elementIterator();
            while (i.hasNext()) {
                Element header = (Element)i.next();
                name = header.getQualifiedName();
                Log.debug("Element name:" + name + ":\t\tValue:" + header.getText() + ":");
                if (name.equalsIgnoreCase("Utility")) {
                    transmission.add("Sub-Command", header.getText());
                    Log.debug("\t\tSub-Command ->" + header.getText());
                    continue;
                }
                if (name.equalsIgnoreCase("Extra")) {
                    Log.debug("\t\tWe got extra info.");
                    continue;
                }
                transmission.add(name, header.getText());
            }
        } else {
            String commandString = doc.selectSingleNode("//LuceneRequest/@type").getText();
            command = ECommand.getByName(commandString.trim());
            transmission = new Transmission(command);
            Element root2 = doc.getRootElement();
            Iterator i = root2.elementIterator();
            while (i.hasNext()) {
                Element header = (Element)i.next();
                Log.debug("Element name:" + header.getQualifiedName() + ":\t\tValue:" + header.getText() + ":");
                transmission.add(header.getQualifiedName(), header.getText());
            }
        }
        long endTime = System.currentTimeMillis();
        Log.debug("Time to parse LuceneRequest type=" + command.getName() + ": " + (endTime - sessionStartTime) + " ms");
        if (transmission != null) {
            transmission.setXML(true);
        }
        return transmission;
    }

    static boolean isEndTag(String xml) {
        if ((xml = xml.trim()).endsWith("</LuceneIndexRequest>")) {
            return true;
        }
        if (xml.endsWith("</LuceneRequest>")) {
            return true;
        }
        if (xml.endsWith("</LuceneQueryRequest>")) {
            return true;
        }
        if (xml.endsWith("</LuceneUnIndexRequest>")) {
            return true;
        }
        return xml.endsWith("</LuceneUtilityRequest>");
    }

    static Transmission error(String message) {
        Transmission transmission = new Transmission(ECommand.ERROR);
        transmission.add(ERROR, message);
        transmission.setXML(true);
        return transmission;
    }

    private void getFieldDefinitions(Document doc, Transmission transmission, boolean getText) {
        Iterator i2 = doc.selectNodes("//Fields/Field").iterator();
        while (i2.hasNext()) {
            Element element = (Element)i2.next();
            if (element.valueOf("@name") != "") {
                transmission.add("Field-Name", element.valueOf("@name"));
                if (element.valueOf("@type") != "") {
                    transmission.add("Field-Type", element.valueOf("@type"));
                }
                if (element.valueOf("@indexed") != "") {
                    if (element.valueOf("@indexed").equalsIgnoreCase("true") || element.valueOf("@indexed").equalsIgnoreCase("yes")) {
                        transmission.add("Field-Indexed", "yes");
                    } else {
                        transmission.add("Field-Indexed", "no");
                    }
                }
                if (element.valueOf("@stored") != "") {
                    if (element.valueOf("@stored").equalsIgnoreCase("true") || element.valueOf("@stored").equalsIgnoreCase("yes")) {
                        transmission.add("Field-Stored", "yes");
                    } else {
                        transmission.add("Field-Stored", "no");
                    }
                }
                transmission.add(element.valueOf("@name"), element.getText());
            }
            Log.debug("\tField-Def: " + element.valueOf("@name") + ", " + element.valueOf("@type") + ", " + element.valueOf("@indexed") + ", " + element.valueOf("@stored") + " ->" + Util.clean(element.getText()));
        }
    }
}

