/** *********************************************************************
 * Copyright (C) 2003 Catalyst IT                                       *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to:                           *
 *   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    *
 *   Boston, MA  02111-1307  USA                                        *
 ************************************************************************/
 package nz.net.catalyst.lucene.testclient;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;

/**
 * This class contains basic scripts for testing the XML part of the
 * LuceneServer.
 * 
 * @author  hamish
 */
public class DemoQuery {
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) throws java.lang.Exception {
        long tStart = System.currentTimeMillis();
        long tOpenedConnection = 9999L;
        long tAfterExecuting   = 9999L;
        long tClosedConnection = 9999L;
        
        Socket echoSocket = null;
        PrintWriter out = null;
        BufferedReader in = null;

        try {
            echoSocket = new Socket("localhost", 22222);
            out = new PrintWriter(echoSocket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(
                                        echoSocket.getInputStream()));
        } catch (java.net.UnknownHostException e) {
            System.err.println("Unknown Host Exception. Cannot resolve host.");
            System.exit(1);
        } catch (java.io.IOException e) {
            System.err.println("Couldn't get I/O for the connection.");
			System.err.println("Is the LuceneServer running?  Run the runserver.bat in another cmd window.");
            System.exit(1);
        }

        tOpenedConnection = System.currentTimeMillis();

		String query = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n" +
				    	"<LuceneRequest type=\"QUERY\">\n" +
				    	" <Application>sos</Application>\n" +
				    	" <Query>\n" +
				    	"     Name:cat\n" +
				    	" </Query>\n" +
				    	" <Limit>3</Limit>\n" +
				    	"</LuceneRequest>\n";

		System.out.println("===================================================");        
		System.out.println("Query Request:");
		System.out.println("==============");        

        System.out.println(query);
    	System.out.println("===================================================");        
		System.out.println("Query Response:");
		System.out.println("===============");        
		//send command to server.
        out.println(query);
                        
        String serverOutput;
        java.io.BufferedReader br = new java.io.BufferedReader(in);
        while ( (serverOutput = br.readLine()) != null ) System.out.println("from server: " + serverOutput);
        
        if (serverOutput != null) System.out.println("from server: " + serverOutput);
       
        tAfterExecuting = System.currentTimeMillis();
        
		out.close();         //close up the open streams
        br.close();
		in.close();
		echoSocket.close();
        
        tClosedConnection = System.currentTimeMillis();
        
        System.out.println("================= Time Statistics =================");
        System.out.println(" Opening Connection: " + (tOpenedConnection - tStart));
        System.out.println(" Executing:          " + (tAfterExecuting - tOpenedConnection));
        System.out.println(" Closing Connection: " + (tClosedConnection - tAfterExecuting));
        System.out.println("===================================================");
        
    }
}