package nz.net.catalyst.lucene.testclient;

/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *    "Apache Lucene" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    "Apache Lucene", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

/**
 * This is adapted from the standard Lucene demo to use the Lucene
 * Server interface.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Date;

import nz.net.catalyst.Log;
import nz.net.catalyst.Main;
import nz.net.catalyst.lucene.server.Constants;
import nz.net.catalyst.lucene.server.ECommand;
import nz.net.catalyst.lucene.server.Server;
import nz.net.catalyst.lucene.server.Transmission;

public class Search extends Main
{
  private static final Search instance = new Search();
  private static final String PORT_PROPERTY = "LuceneServerPort";
  private static final String HOST_PROPERTY = "LuceneServerHost";
  private static final String APPLICATION_PROPERTY = "Application";

  private static int port;
  private static String host;
  private static String application;

  public static void main(String[] args)
  {
    Log.debug("In Search.main");

    instance.init(args);
  }

  public static void Start(String[] args) throws Exception
  {
    StringBuffer sb = new StringBuffer();
    for (int i = 0; i < args.length; ++i)
    {
      sb.append(' ');
      sb.append(args[i]);
    }
    Log.debug("Starting");
    port = Integer.getInteger(PORT_PROPERTY, Server.LISTENER_PORT).intValue();
    host = System.getProperty(HOST_PROPERTY, "localhost");
    application = System.getProperty(APPLICATION_PROPERTY, "test");

    Socket socket = new Socket(host, port);
    PrintWriter out = new PrintWriter(
      new BufferedWriter(
        new OutputStreamWriter(
          socket.getOutputStream(), "UTF-8"), 1048576), false);
    Date start = new Date();
    BufferedReader in = new BufferedReader(
      new InputStreamReader(socket.getInputStream(), "UTF-8"));

    searchDocs(out, in, sb.toString());
    socket.close();

    Date end = new Date();

    System.out.print(end.getTime() - start.getTime());
    Log.debug(" total milliseconds");
  }

  public static void searchDocs(PrintWriter out, BufferedReader in, String query)
    throws Exception
  {
    long beforeTransmission = System.currentTimeMillis();
    Transmission command = new Transmission(ECommand.QUERY);
    command.add(Constants.APPLICATION, application);
    command.add(Constants.DEFAULT_FIELD, "Text");
    // command.add(Constants.QUERY, query);
    command.add(Constants.BODY, Constants.QUERY);
    command.setBody(query);
    long beforeSending = System.currentTimeMillis();
    command.write(out);
    long beforeReceiving = System.currentTimeMillis();
    Transmission response = Transmission.create(in);
    long finished = System.currentTimeMillis();
    if (response == null)
    {
        System.err.println("Input closed while we were waiting for a response!");
    }
    else
    {
        response.write(new PrintWriter(System.out));
    }
    System.err.println("Creating transmission: " +
		       (beforeSending - beforeTransmission) + " ms");
    System.err.println("Sending command: " +
		       (beforeReceiving - beforeSending) + " ms");
    System.err.println("Response time: " +
		       (finished- beforeReceiving) + " ms");
  }
}
