#!/bin/sh
# Install a new Axyl website as demo website
# Paul Waite
#
# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
set -e

# Gotta have the power..
if [ $(id -u) != 0 ] ; then
  echo "You must be root to run this script."
  exit 1
fi

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# AXYL CONFIGURATION
# See if the config file is present - if so it will define
# our directories, and Axyl admin user..

CONF=/etc/axyl/axyl.conf
if [ -f $CONF ]; then
  . $CONF
fi

if [ -d ${AXYL_HOME}/install ] ; then
  cd ${AXYL_HOME}/install
  ./create-axyl-website.sh __axyl__demo__
fi
