
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bsesnet.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bsesnet.h>
#include <bse/bsemain.h>


#line 25 "bsesnet.proc"


/* --- supports-user-synths --- */
static void
supports_user_synths_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 27 "bsesnet.proc"
 {
#line 29 "bsesnet.proc"
  *(in_pspecs++) = bse_param_spec_object ("snet", "Synth Net", NULL,
				 BSE_TYPE_SNET, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_bool ("user_synth", "User Synth", NULL,
			  FALSE, SFI_PARAM_STANDARD);
#line 33 "bsesnet.proc"
}  }
static BseErrorType
#line 33 "bsesnet.proc"
supports_user_synths_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 36 "bsesnet.proc"
{
#line 37 "bsesnet.proc"
  
  BseSNet *snet = bse_value_get_object (in_values++);
  
#line 40 "bsesnet.proc"
  
  if (!BSE_IS_SNET (snet))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 44 "bsesnet.proc"
  
  sfi_value_set_bool (out_values++, BSE_SNET_USER_SYNTH (snet));
  
  return BSE_ERROR_NONE;
}

/* --- can-create-source --- */
static void
can_create_source_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 50 "bsesnet.proc"
 {
#line 52 "bsesnet.proc"
  *(in_pspecs++) = bse_param_spec_object ("snet", "Synth Net", NULL,
				 BSE_TYPE_SNET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("module_type", "Module Type", NULL,
			    "", SFI_PARAM_STANDARD);
  *(out_pspecs++) = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, 0,
				SFI_PARAM_STANDARD);
#line 59 "bsesnet.proc"
}  }
static BseErrorType
#line 59 "bsesnet.proc"
can_create_source_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 62 "bsesnet.proc"
{
#line 63 "bsesnet.proc"
  
  BseSNet *snet = bse_value_get_object (in_values++);
  const gchar *type_name = sfi_value_get_string (in_values++);
  GType type = g_type_from_name (type_name);
  BseErrorType error = BSE_ERROR_NONE;
  
#line 69 "bsesnet.proc"
  
  if (!BSE_IS_SNET (snet))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 73 "bsesnet.proc"
  
  if (!BSE_SNET_USER_SYNTH (snet) && !BSE_DBG_EXT)
    error = BSE_ERROR_NOT_OWNER;
  else if (!g_type_is_a (type, BSE_TYPE_SOURCE) ||
	   g_type_is_a (type, BSE_TYPE_CONTAINER))
    error = BSE_ERROR_SOURCE_TYPE_INVALID;
  
#line 80 "bsesnet.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- create-source --- */
static void
create_source_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 86 "bsesnet.proc"
 {
#line 88 "bsesnet.proc"
  *(in_pspecs++) = bse_param_spec_object ("snet", "Synth Net", NULL,
				 BSE_TYPE_SNET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("module_type", "Module Type", NULL,
			    "", SFI_PARAM_STANDARD);
  *(out_pspecs++) = bse_param_spec_object ("module", "New Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
#line 94 "bsesnet.proc"
}  }
static BseErrorType
#line 94 "bsesnet.proc"
create_source_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 97 "bsesnet.proc"
{
#line 98 "bsesnet.proc"
  
  BseContainer *container = bse_value_get_object (in_values++);
  const gchar *type_name  = sfi_value_get_string (in_values++);
  BseItem *child;
  BseUndoStack *ustack;
  BseErrorType error;

#line 105 "bsesnet.proc"
  
  if (!BSE_IS_SNET (container))
    return BSE_ERROR_PROC_PARAM_INVAL;
  if (bse_item_exec (container, "can-create-source", type_name, &error) != 0 ||
      error != 0)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 112 "bsesnet.proc"
  
  ustack = bse_item_undo_open (container, "create-source");
  child = bse_container_new_child (container, g_type_from_name (type_name), NULL);
  bse_item_push_undo_proc (container, "remove-source", child);
  bse_item_undo_close (ustack);

#line 118 "bsesnet.proc"
  
  bse_value_set_object (out_values++, child);
  
  return BSE_ERROR_NONE;
}

/* --- remove-source --- */
static void
remove_source_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 124 "bsesnet.proc"
 {
#line 126 "bsesnet.proc"
  *(in_pspecs++) = bse_param_spec_object ("snet", "Synth Net", NULL,
				 BSE_TYPE_SNET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, 0,
				SFI_PARAM_STANDARD);
#line 133 "bsesnet.proc"
}  }
static BseErrorType
#line 133 "bsesnet.proc"
remove_source_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 136 "bsesnet.proc"
{
#line 137 "bsesnet.proc"
  
  BseSNet *self      = bse_value_get_object (in_values++);
  BseItem *child     = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  BseUndoStack *ustack;

#line 143 "bsesnet.proc"
  
  if (!BSE_IS_SNET (self) || !BSE_IS_SOURCE (child) || child->parent != (BseItem*) self ||
      (!BSE_SNET_USER_SYNTH (self) && !BSE_DBG_EXT))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 148 "bsesnet.proc"
  
  ustack = bse_item_undo_open (self, "remove-child %s", bse_object_debug_name (child));
#line 150 "bsesnet.proc"
  
  bse_container_uncross_undoable (BSE_CONTAINER (self), child);
#line 152 "bsesnet.proc"
  
  bse_item_push_redo_proc (self, "remove-source", child);
#line 154 "bsesnet.proc"
  
  bse_container_remove_backedup (BSE_CONTAINER (self), child, ustack);
#line 156 "bsesnet.proc"
  
  bse_item_undo_close (ustack);
  
#line 159 "bsesnet.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_supports_user_synths__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check whether users may edit synthesis modules of this network";
  es->file = "/opt/src/beast/bse/bsesnet.proc";
  es->line = 28;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_supports_user_synths = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseSNet+supports-user-synths", 
    NULL,
    "/Methods/BseSNet/General/Supports User Synths",
    NULL,
    __enode_supports_user_synths__fill_strings,
  },
  0, supports_user_synths_setup, supports_user_synths_exec, 
};
static void
__enode_can_create_source__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check whether inserting a new module into a synthesis network is possible";
  es->file = "/opt/src/beast/bse/bsesnet.proc";
  es->line = 51;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_can_create_source = {
  { (BseExportNode*) &__enode_supports_user_synths, BSE_EXPORT_NODE_PROC,
    "BseSNet+can-create-source", 
    NULL,
    "/Methods/BseSNet/General/Can Create Source",
    NULL,
    __enode_can_create_source__fill_strings,
  },
  0, can_create_source_setup, can_create_source_exec, 
};
static void
__enode_create_source__fill_strings (BseExportStrings *es)
{
  es->blurb = "Insert a new module into a synthesis network";
  es->file = "/opt/src/beast/bse/bsesnet.proc";
  es->line = 87;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_create_source = {
  { (BseExportNode*) &__enode_can_create_source, BSE_EXPORT_NODE_PROC,
    "BseSNet+create-source", 
    NULL,
    "/Methods/BseSNet/General/Create Source",
    NULL,
    __enode_create_source__fill_strings,
  },
  0, create_source_setup, create_source_exec, 
};
static void
__enode_remove_source__fill_strings (BseExportStrings *es)
{
  es->blurb = "Remove an existing module from its synthesis network";
  es->file = "/opt/src/beast/bse/bsesnet.proc";
  es->line = 125;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_remove_source = {
  { (BseExportNode*) &__enode_create_source, BSE_EXPORT_NODE_PROC,
    "BseSNet+remove-source", 
    NULL,
    "/Methods/BseSNet/General/Remove Source",
    NULL,
    __enode_remove_source__fill_strings,
  },
  0, remove_source_setup, remove_source_exec, 
};
BseExportNode* bse__builtin_init_bsesnet_genprc_c (void);
BseExportNode* bse__builtin_init_bsesnet_genprc_c (void)
{
  return (BseExportNode*) &__enode_remove_source;
}

/*
 * Generated data ends here
 */
