# Copyright 2004,2005 Pierre Martineau <pmartino@users.sourceforge.net>
# This file is part of Bibus, a bibliographic database that can
# work together with OpenOffice.org to generate bibliographic indexes.
#
# Bibus is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Bibus is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Bibus; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA.
#
# generated by wxGlade 0.3.4 on Fri Apr  8 01:09:16 2005

import wx
import BIB

class Capture(wx.Dialog):
	def __init__(self, db, category, short, *args, **kwds):
		self.db = db			# connection to the database
		self.category = category	# edited category
		self.short = short		# current shortcuts list
		# begin wxGlade: Capture.__init__
		kwds["style"] = wx.DIALOG_MODAL|wx.CAPTION|wx.RESIZE_BORDER|wx.THICK_FRAME
		wx.Dialog.__init__(self, *args, **kwds)
		self.label_1 = wx.StaticText(self, -1, _("Capture from field"))
		self.choice_field = wx.Choice(self, -1, choices=[])
		self.checkbox_separator = wx.CheckBox(self, -1, _("Using separator"))
		self.combo_separator = wx.ComboBox(self, -1, choices=[], style=wx.CB_DROPDOWN)
		self.static_line_2 = wx.StaticLine(self, -1)
		self.button_cancel = wx.Button(self, wx.ID_CANCEL, _("Cancel"))
		self.button_ok = wx.Button(self, wx.ID_OK, _("OK"))

		self.__set_properties()
		self.__do_layout()
		# end wxGlade
		self.__set_evt()

	def __set_properties(self):
		# begin wxGlade: Capture.__set_properties
		self.SetTitle(_("Capture from database"))
		self.choice_field.SetSelection(0)
		self.combo_separator.SetSelection(-1)
		self.button_ok.SetDefault()
		# end wxGlade
		self.choice_field.AppendItems( [BIB.NAME_FIELD[field] for field in BIB.BIB_FIELDS[3:-1]] )
		if not self.choice_field.SetStringSelection(self.category.title()):
			self.choice_field.SetSelection(0)
		sep = [';',',',':','/','#']
		if BIB.SEP not in sep: sep.insert(0,BIB.SEP)
		for i in sep: self.combo_separator.Append(i)
		self.combo_separator.Disable()

	def __do_layout(self):
		# begin wxGlade: Capture.__do_layout
		sizer_6 = wx.BoxSizer(wx.VERTICAL)
		sizer_7 = wx.BoxSizer(wx.HORIZONTAL)
		grid_sizer_1 = wx.FlexGridSizer(2, 2, 5, 5)
		grid_sizer_1.Add(self.label_1, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		grid_sizer_1.Add(self.choice_field, 0, wx.EXPAND, 0)
		grid_sizer_1.Add(self.checkbox_separator, 0, 0, 0)
		grid_sizer_1.Add(self.combo_separator, 0, wx.EXPAND, 0)
		grid_sizer_1.AddGrowableCol(1)
		sizer_6.Add(grid_sizer_1, 0, wx.EXPAND, 0)
		sizer_6.Add(self.static_line_2, 0, wx.TOP|wx.BOTTOM|wx.EXPAND, 5)
		sizer_7.Add(self.button_cancel, 0, wx.ALL, 5)
		sizer_7.Add(self.button_ok, 0, wx.ALL, 5)
		sizer_6.Add(sizer_7, 0, wx.ALIGN_RIGHT, 0)
		self.SetAutoLayout(1)
		self.SetSizer(sizer_6)
		sizer_6.Fit(self)
		sizer_6.SetSizeHints(self)
		self.Layout()
		self.Centre()
		# end wxGlade

	def __set_evt(self):
		wx.EVT_BUTTON(self,wx.ID_OK, self.capture)
		wx.EVT_CHECKBOX(self,self.checkbox_separator.GetId(),lambda evt: self.combo_separator.Enable(evt.IsChecked()) )

	def capture(self,evt):
		field = BIB.FIELD_NAME[self.choice_field.GetStringSelection()]
		separator = self.combo_separator.GetValue()
		listfield = self.db.getAllRef(self.db.user,collist=(field,),order=field,how='ASC')
		if not self.checkbox_separator.IsChecked():
			for i,fieldname in listfield:
				fieldname = fieldname.strip()
				if fieldname and fieldname not in self.short: self.short.append(fieldname)
		else:
			for i,fieldnameL in listfield:
				for fieldname in fieldnameL.split(separator):
					fieldname = fieldname.strip()
					if fieldname and fieldname not in self.short: self.short.append(fieldname)
		self.GetParent().set_list_shortcuts()	# update Parent view
		self.Close()

# end of class Capture


class ShortcutEd(wx.Dialog):
	def __init__(self, category, short,db,*args, **kwds):
		self.category = category	# name of the edited category
		self.short = short[:]		# current shortcuts for the category. Make a copy.
		self.parentshort = short	# we keep a copy for updating it latter
		self.db = db				# connection to the database
		# begin wxGlade: ShortcutEd.__init__
		kwds["style"] = wx.DIALOG_MODAL|wx.CAPTION|wx.RESIZE_BORDER|wx.THICK_FRAME
		wx.Dialog.__init__(self, *args, **kwds)
		self.list_shortcuts = wx.ListCtrl(self, -1, style=wx.LC_REPORT|wx.LC_EDIT_LABELS|wx.LC_NO_HEADER|wx.LC_SINGLE_SEL|wx.SUNKEN_BORDER)
		self.button_new = wx.Button(self, -1, _("New"))
		self.button_remove = wx.Button(self, -1, _("Remove"))
		self.button_up = wx.Button(self, -1, _("Up"))
		self.button_down = wx.Button(self, -1, _("Down"))
		self.button_capture = wx.Button(self, -1, _("Capture ..."))
		self.button_asc = wx.Button(self, -1, _("Sort Ascending"))
		self.button_dsc = wx.Button(self, -1, _("Sort Descending"))
		self.static_line_1 = wx.StaticLine(self, -1)
		self.Cancel = wx.Button(self, wx.ID_CANCEL, _("Cancel"))
		self.OK = wx.Button(self, wx.ID_OK, _("OK"))

		self.__set_properties()
		self.__do_layout()
		# end wxGlade
		self.set_list_shortcuts()
		self.__set_evt()

	def __set_properties(self):
		# begin wxGlade: ShortcutEd.__set_properties
		self.SetTitle("dialog_3")
		self.SetSize((500, 400))
		self.OK.SetDefault()
		# end wxGlade
		self.SetTitle(self.category)

	def set_list_shortcuts(self):
		self.list_shortcuts.ClearAll()
		self.list_shortcuts.InsertColumn(0,'shortcuts')
		for index in xrange(len(self.short)):
			self.list_shortcuts.InsertStringItem(index,self.short[index])
		self.onSize()

	def __do_layout(self):
		# begin wxGlade: ShortcutEd.__do_layout
		sizer_1 = wx.BoxSizer(wx.VERTICAL)
		sizer_2 = wx.BoxSizer(wx.HORIZONTAL)
		sizer_3 = wx.BoxSizer(wx.HORIZONTAL)
		sizer_4 = wx.BoxSizer(wx.VERTICAL)
		sizer_3.Add(self.list_shortcuts, 1, wx.EXPAND, 0)
		sizer_4.Add(self.button_new, 0, wx.BOTTOM|wx.ALIGN_CENTER_HORIZONTAL, 2)
		sizer_4.Add(self.button_remove, 0, wx.BOTTOM|wx.ALIGN_CENTER_HORIZONTAL, 10)
		sizer_4.Add(self.button_up, 0, wx.BOTTOM|wx.ALIGN_CENTER_HORIZONTAL, 2)
		sizer_4.Add(self.button_down, 0, wx.BOTTOM|wx.ALIGN_CENTER_HORIZONTAL, 10)
		sizer_4.Add(self.button_capture, 0, wx.BOTTOM|wx.ALIGN_CENTER_HORIZONTAL, 10)
		sizer_4.Add(self.button_asc, 0, wx.BOTTOM|wx.ALIGN_CENTER_HORIZONTAL, 2)
		sizer_4.Add(self.button_dsc, 0, wx.ALIGN_CENTER_HORIZONTAL, 2)
		sizer_3.Add(sizer_4, 0, wx.ALIGN_CENTER_VERTICAL, 0)
		sizer_1.Add(sizer_3, 1, wx.EXPAND, 0)
		sizer_1.Add(self.static_line_1, 0, wx.EXPAND, 0)
		sizer_2.Add(self.Cancel, 0, wx.ALL, 5)
		sizer_2.Add(self.OK, 0, wx.ALL, 5)
		sizer_1.Add(sizer_2, 0, wx.ALIGN_RIGHT, 0)
		self.SetAutoLayout(1)
		self.SetSizer(sizer_1)
		self.Layout()
		self.Centre()
		# end wxGlade

	def __set_evt(self):
		wx.EVT_SIZE(self,self.onSize)
		wx.EVT_BUTTON(self, self.button_new.GetId(), self.onNew)
		wx.EVT_BUTTON(self, self.button_remove.GetId(), self.onRemove)
		wx.EVT_BUTTON(self, self.button_up.GetId(), self.onUp)
		wx.EVT_BUTTON(self, self.button_down.GetId(), self.onDown)
		wx.EVT_BUTTON(self, self.button_capture.GetId(), self.onCapture)
		wx.EVT_BUTTON(self, self.button_asc.GetId(), self.onAsc)
		wx.EVT_BUTTON(self, self.button_dsc.GetId(), self.onDsc)
		wx.EVT_BUTTON(self, wx.ID_OK, self.onOK)
		wx.EVT_LIST_END_LABEL_EDIT(self,self.list_shortcuts.GetId(),self.onRename)

	def onOK(self,evt):
		self.parentshort[:] = self.short	# we save the value
		self.EndModal(wx.ID_OK)

	def onSize(self,evt=None):
		self.Layout()
		self.list_shortcuts.SetColumnWidth(0,self.list_shortcuts.GetClientSizeTuple()[0])

	def onRename(self,evt):
		if evt.GetText() in self.short:
			evt.Veto()	# the new name must not be already present
		else:
			self.short[evt.GetIndex()] = evt.GetText()

	def __generateUnique(self):
		tmpname = BIB.SHORTCUT_DEFAULT
		i = 1
		while tmpname in self.short:
			tmpname = "%s%s%s" %(BIB.SHORTCUT_DEFAULT,BIB.SEP_DUP,repr(i))
			i=i+1
		return tmpname

	def onNew(self,evt):
		newshort = self.__generateUnique()
		self.list_shortcuts.Append( [newshort] )
		self.short.append(newshort)

	def onRemove(self,evt):
		index = self.list_shortcuts.GetFirstSelected()
		if index != -1:
			self.list_shortcuts.DeleteItem(index)
			del self.short[index]

	def onUp(self,evt):
		index = self.list_shortcuts.GetFirstSelected()
		if index >= 1:
			previous = self.list_shortcuts.GetItemText(index -1)
			self.list_shortcuts.SetItemText(index -1,self.list_shortcuts.GetItemText(index) )
			self.list_shortcuts.SetItemText(index , previous)
			self.list_shortcuts.Select(index - 1, True)
			self.short[index -1] = self.short[index]
			self.short[index] = previous

	def onDown(self,evt):
		index = self.list_shortcuts.GetFirstSelected()
		if index != -1 and index < self.list_shortcuts.GetItemCount() -1:
			nextitem = self.list_shortcuts.GetItemText(index +1)
			self.list_shortcuts.SetItemText(index +1, self.list_shortcuts.GetItemText(index) )
			self.list_shortcuts.SetItemText(index , nextitem)
			self.list_shortcuts.Select(index +1, True)
			self.short[index +1] = self.short[index]
			self.short[index] = nextitem

	def onAsc(self,evt):
		self.short.sort()
		self.set_list_shortcuts()

	def onDsc(self,evt):
		self.short.reverse()
		self.set_list_shortcuts()

	def onCapture(self,evt):
		cap = Capture(self.db,self.category,self.short,self,-1,'')
		if cap.ShowModal() == wx.ID_OK:
			pass	# nothing to do. It's done in Capture.capture
		cap.Destroy()
		#cap.Show()

# end of class ShortcutEd


