#include "tablespec.ih"

ostream &TableSpec::insert(ostream &ostr) const
{
    if (!d_nRows)
        return ostr;

    d_tableSupport.setParam(ostr, d_nRows, d_colWidth, 
                            d_widthType == EqualWidth ? d_maxWidth : 0);
    
    for (size_t row = 0; row < d_nRows; ++row)
    {
        d_tableSupport.hline(row);

        for (size_t col = 0; col < d_nColumns; ++col)
        {
            size_t colwidth = width(col);

            d_tableSupport.vline(col);
            ostr << setw(colwidth) << stringAt(row, col);
        }
        
        d_tableSupport.vline();
    }
    d_tableSupport.hline();

    return ostr;
}
