
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nickycopeland@hotmail.com> 1996,2010
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <stdlib.h>
#include "bristol.h"
#include "bristolmidi.h"

int rate = 100000;

static void
bngcylcle0(int mh, int client, int count)
{
	while (1)
	{
		if (bristolMidiSendMsg(mh, client, BRISTOL_EVENT_KEYON, 0, 60) < 0)
		{
			printf("send failed\n");
			exit(1);
		}

		if ((count -= 6) < 0)
			break;

		usleep(rate);
		bristolMidiSendMsg(mh, client, BRISTOL_EVENT_KEYOFF, 0, 60);
		usleep(rate * 9);
		bristolMidiSendMsg(mh, client, BRISTOL_EVENT_KEYON, 0, 63);
		usleep(rate);
		bristolMidiSendMsg(mh, client, BRISTOL_EVENT_KEYOFF, 0, 63);
		usleep(rate * 4);
		bristolMidiSendMsg(mh, client, BRISTOL_EVENT_KEYON, 0, 65);
		usleep(rate);
		bristolMidiSendMsg(mh, client, BRISTOL_EVENT_KEYOFF, 0, 65);
		usleep(rate * 4);
	}
}

static void
bngcylcle1(int mh, int client, int count)
{
	int i = 0;

	while (1)
	{
		if (bristolMidiSendMsg(mh, client, BRISTOL_EVENT_KEYON, 0, 48 + i) < 0)
		{
			printf("send failed\n");
			exit(1);
		}

		if (--count < 0)
			break;

		usleep(rate);

		bristolMidiSendMsg(mh, client, BRISTOL_EVENT_KEYOFF, 0, 48 + i);

		if (++i >= 24)
			i = 0;
	}
}

static void
bngcylcle2(int mh, int client, int count)
{
	int i = 0;
	/* Riders on the storm, well, its something to hear whilst SQA testing */
	int notes[8] = {0, 7, 3, 7, 0, 5, 9, 5};

	while (1)
	{
		if (bristolMidiSendMsg(mh, client, BRISTOL_EVENT_KEYON, 0,
			52 + notes[i]) < 0)
		{
			printf("send failed\n");
			exit(1);
		}

		if (--count < 0)
			break;

		usleep(rate * 4);

		bristolMidiSendMsg(mh, client, BRISTOL_EVENT_KEYOFF, 0,
			52 + notes[i]);

		if (++i >= 8)
			i = 0;
	}
}

int
main(int argc, char *argv[])
{
	int mh, client = 128, argCount = 1;
	int count = 0x7fffffff;
	int cycle = 2;

	char *device = "bristolng";

	if ((argc > 1) && ((strcmp(argv[argCount], "-help") == 0)
		|| (strcmp(argv[argCount], "--help") == 0)))
	{
		printf("%s: this is for bristol SQA testing, it only streams note events\n\
%s [-target <id = 128>] [-cycle <0-2>] [-count <n>] [-rate <ms>]\n",
		argv[0],
		argv[0]);
		exit(0);
	}

	while (argc > argCount) {
		if ((strcmp(argv[argCount], "-rate") == 0) && (argCount < argc))
		{
			if ((rate = atoi(argv[argCount + 1])) < 0)
				rate = 100;
			rate *= 1000;
			argCount++;
		}

		if ((strcmp(argv[argCount], "-target") == 0) && (argCount < argc))
		{
			if ((client = atoi(argv[argCount + 1])) < 0)
				client = 128;
			argCount++;
		}

		if ((strcmp(argv[argCount], "-count") == 0) && (argCount < argc))
		{
			if ((count = atoi(argv[argCount + 1])) < 0)
				count = 0x7fffffff;
			argCount++;
		}

		if ((strcmp(argv[argCount], "-cycle") == 0) && (argCount < argc))
		{
			cycle = atoi(argv[argCount + 1]);
			argCount++;
		}

		argCount++;
	}

	printf("Target %i, count %i, cycle %i\n", client, count, cycle);

	if ((mh = bristolMidiOpen(device, BRISTOL_CONN_SEQ|BRISTOL_WRONLY,
		-1, BRISTOL_REQ_ALL, NULL, NULL)) < 0)
	{
		printf("%s: could not open midi connection\n", argv[0]);
		exit(1);
	}

	if (count == 1)
	{
		if (bristolMidiSendMsg(mh, client, BRISTOL_EVENT_KEYON, 0, 60) < 0)
			exit(0);

		sleep(1);
		bristolMidiSendMsg(mh, client, BRISTOL_EVENT_KEYOFF, 0, 60);

		exit(0);
	}

	switch (cycle)
	{
		 default:
		 case 0:
			bngcylcle0(mh, client, count);
		 	break;
		 case 1:
			bngcylcle1(mh, client, count);
		 	break;
		 case 2:
			bngcylcle2(mh, client, count);
		 	break;
	}

	exit(0);
}

