
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nick.copeland@ntlworld.com> 1996,2002
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
//#define DUPLICATE
/*
 *  Taken from SLab audio output daemon routines.
 *  Copyright (c) by Nick Copeland <ncopeland@cie.tm> 1996,2001
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * We need to declare a duplexDev from the SLab routines, initialise this for
 * a set of audio parameters (sampleRate, driverType, resolution, etc), and
 * then call our audio open library, also from SLab. The benefits of this are
 * the need to only maintain one audio library for any new driver release 
 * across all the audio applications. It requires a bit of work here, but the
 * benefits far outway the extra work. It does require that I import a lot of
 * structures (ie, headers) from SLab.
 */

#include "bristol.h"
#include "bristolmidi.h"
#include "engine.h"

#ifdef TEST
#include <unistd.h>
#endif

#ifdef DUPLICATE
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

int dupfd = -1;
#endif

static duplexDev audioDev;

bristolAudioClose()
{
	audioClose(&audioDev);
}

bristolAudioOpen(char *device, int rate, int size, int flags)
{
	printf("bristolAudioOpen(%s, %i, %i, %x)\n", device, rate, size, flags);
	/*
	 * Take the audioDev, configure a full set of reasonable parameters as
	 * required by the libslabaudio, and call audioOpen with this device.
	 */
	audioDev.channels = 2;

	audioDev.writeSampleRate = rate;
	audioDev.devID = 0;
	if ((audioDev.preLoad = flags & 0x000f) == 0)
		audioDev.preLoad = 4;
	audioDev.fd2 = -1;
	audioDev.fragSize = size;
	audioDev.fragBuf = 0;
	audioDev.OSegmentSize = size;
#if ADLIB >= 0
	if ((flags & BRISTOL_OSS) == 0)
		audioDev.siflags |= AUDIO_ALSA;
#endif
	audioDev.cflags |= SLAB_SUBFRAGMENT;
	audioDev.cflags |= SLAB_AUDIODBG;

	sprintf(audioDev.devName, "%s", device);
	sprintf(audioDev.mixerName, "\0");

#ifdef TEST
	audioDev.fragBuf = (char *) bristolmalloc(audioDev.fragSize);
	return(audioDev.fragSize);
#endif
	audioDev.flags = 0x0d;

	if (audioOpen(&audioDev, 0, SLAB_ORDWR, audioDev.fragSize) < 0)
		return(-1);

	printf(
		"opened audio device with a fragment size of %i, buffer %x, fd %i/%i\n",
		audioDev.fragSize, audioDev.fragBuf, audioDev.fd, audioDev.fd2);

	return(audioDev.fragSize);
}

bristolAudioStart()
{
	setAudioStart2(&audioDev, 0);
}

bristolAudioWrite(register float *buf, register int count)
{
	register short *audioBuf;
	register int clipped = 0, result;

#ifdef DEBUG
	printf("bristolAudioWrite(%i), %i\n", count, audioDev.fragSize);
#endif

	/*
	 * Based on the assumption that we are always going to be working with
	 * floats, and the output device has a given format (assume 16 bit for now)
	 * then convert the buffer of data.
	 */
	audioBuf = (short *) audioDev.fragBuf;

	for (; count > 0; count-=8)
	{
		/*
		 * This is a conversion routine from the floats used by bristol, and 
		 * most of the code is for clipchecking.
		 */
		*(audioBuf++) = (short) (*buf > 32767?32767:*buf < -32767?-32767:*buf);
		if ((*buf > 32767) || (*buf < -32768)) clipped = 1;
		buf++;
		*(audioBuf++) = (short) (*buf > 32767?32767:*buf < -32767?-32767:*buf);
		buf++;
		*(audioBuf++) = (short) (*buf > 32767?32767:*buf < -32767?-32767:*buf);
		buf++;
		*(audioBuf++) = (short) (*buf > 32767?32767:*buf < -32767?-32767:*buf);
		if ((*buf > 32767) || (*buf < -32768)) clipped = 1;
		buf++;
		*(audioBuf++) = (short) (*buf > 32767?32767:*buf < -32767?-32767:*buf);
		buf++;
		*(audioBuf++) = (short) (*buf > 32767?32767:*buf < -32767?-32767:*buf);
		if ((*buf > 32767) || (*buf < -32768)) clipped = 1;
		buf++;
		*(audioBuf++) = (short) (*buf > 32767?32767:*buf < -32767?-32767:*buf);
		if ((*buf > 32767) || (*buf < -32768)) clipped = 1;
		buf++;
		*(audioBuf++) = (short) (*buf > 32767?32767:*buf < -32767?-32767:*buf);
		buf++;
	}

#ifdef TEST
	return(0);
#endif

	if ((result = audioWrite(&audioDev, audioDev.fragBuf, audioDev.fragSize))
		< 0)
	{
		printf("Write Failed: %i\n", result);
		/*
		 * We could get into a panic here. The device originally opened 
		 * correctly (otherwise we would assumably not be writing here. Lets
		 * just close and reopen the device, and see how things go.
		 *
		 * We should actually return a bad value, and continue, letting the
		 * calling party clear things up. This has been done.
		 */
		return(result);
	}
#ifdef DUPLICATE
	if (dupfd < 0)
	{
		dupfd = open("/tmp/bristol.raw", O_WRONLY|O_TRUNC|O_CREAT, 0640);
	}
	if (dupfd > 0)
	{
		register int i;
		register short accum = 0, *sbuf = (short *) audioDev.fragBuf;

		count = audioDev.fragSize / 2;

		for (; count > 0; count-=8)
		{
			accum = (accum + *sbuf++) / 2;
		}

		if (accum != 0)
			write(dupfd, audioDev.fragBuf, audioDev.fragSize);
	}
#endif
	if (clipped)
		printf("Clipping output\n");

	return(0);
}

bristolAudioRead(register float *buf, register int count)
{
	register short *audioBuf;
	register int clipped = 0;

#ifdef DEBUG
	printf("bristolAudioRead(%i), %i\n", count, audioDev.fragSize);
#endif
	/*
	 * Based on the assumption that we are always going to be working with
	 * floats, and the output device has a given format (assume 16 bit for now)
	 * then convert the buffer of data.
	 */
	audioBuf = (short *) audioDev.fragBuf;

#ifdef TEST
	{
		usleep(6000);
		return(0);
	}
#endif

	if (audioRead(&audioDev, audioDev.fragBuf, audioDev.fragSize) < 0)
	{
		printf("Read Failed: fs %i, %x\n", audioDev.fragSize, audioDev.fragBuf);
		return(-6);
	}

	/*
	 * Demultiplex left channel?
	 */
	for (; count > 0; count-=8)
	{
		/*
		 * Need to interleave the samples, since bristol is still mono:
		 */
		*buf++ = (float) *audioBuf++;
		*buf++ = (float) *audioBuf++;
		*buf++ = (float) *audioBuf++;
		*buf++ = (float) *audioBuf++;
		*buf++ = (float) *audioBuf++;
		*buf++ = (float) *audioBuf++;
		*buf++ = (float) *audioBuf++;
		*buf++ = (float) *audioBuf++;
	}
	return(0);
}

