
/*
 Copyright 2012, Kovid Goyal <kovid@kovidgoyal.net>
 Released under the GPLv3 License
*/


(function() {
  var BookIndexing, abstop, body_height,
    __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  body_height = function() {
    var db, dde;
    db = document.body;
    dde = document.documentElement;
    if ((db != null) && (dde != null)) {
      return Math.max(db.scrollHeight, dde.scrollHeight, db.offsetHeight, dde.offsetHeight, db.clientHeight, dde.clientHeight);
    }
    return 0;
  };

  abstop = function(elem) {
    var ans;
    ans = elem.offsetTop;
    while (elem.offsetParent) {
      elem = elem.offsetParent;
      ans += elem.offsetTop;
    }
    return ans;
  };

  BookIndexing = (function() {

    BookIndexing.name = 'BookIndexing';

    /*
        This class is a namespace to expose indexing functions via the
        window.book_indexing object. The most important functions are:
    
        anchor_positions(): Get the absolute (document co-ordinate system) position
        for elements with the specified id/name attributes.
    */


    function BookIndexing() {
      this.cache = {};
      this.body_height_at_last_check = null;
    }

    BookIndexing.prototype.cache_valid = function(anchors) {
      var a, p, _i, _len;
      for (_i = 0, _len = anchors.length; _i < _len; _i++) {
        a = anchors[_i];
        if (!Object.prototype.hasOwnProperty.call(this.cache, a)) {
          return false;
        }
      }
      for (p in this.cache) {
        if (Object.prototype.hasOwnProperty.call(this.cache, p) && __indexOf.call(anchors, p) < 0) {
          return false;
        }
      }
      return true;
    };

    BookIndexing.prototype.anchor_positions = function(anchors, use_cache) {
      var anchor, ans, elem, pos, result, _i, _len;
      if (use_cache == null) {
        use_cache = false;
      }
      if (use_cache && body_height() === this.body_height_at_last_check && this.cache_valid(anchors)) {
        return this.cache;
      }
      ans = {};
      for (_i = 0, _len = anchors.length; _i < _len; _i++) {
        anchor = anchors[_i];
        elem = document.getElementById(anchor);
        if (elem === null) {
          try {
            result = document.evaluate(".//*[local-name() = 'a' and @name='" + anchor + "']", document.body, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null);
            elem = result.singleNodeValue;
          } catch (error) {
            elem = null;
          }
        }
        if (elem === null) {
          pos = body_height() + 10000;
        } else {
          pos = abstop(elem);
        }
        ans[anchor] = pos;
      }
      this.cache = ans;
      this.body_height_at_last_check = body_height();
      return ans;
    };

    return BookIndexing;

  })();

  if (typeof window !== "undefined" && window !== null) {
    window.book_indexing = new BookIndexing();
  }

}).call(this);

