# ![Boost.Log](doc/logo.png)

Boost.Log, part of collection of the [Boost C++ Libraries](https://github.com/boostorg), provides tools for adding logging to libraries and applications.

### Directories

* **build** - Boost.Log build scripts
* **config** - Boost.Log build configuration code and scripts
* **doc** - QuickBook documentation sources
* **example** - Boost.Log examples
* **include** - Interface headers of Boost.Log
* **src** - Compilable source code of Boost.Log
* **test** - Boost.Log unit tests

### More information

* [Documentation](https://boost.org/libs/log)
* [Ask questions](https://stackoverflow.com/questions/ask?tags=c%2B%2B,boost,boost-log)
* [Report bugs](https://svn.boost.org/trac/boost/newticket?component=log;version=Boost%20Release%20Branch). Be sure to mention Boost version, platform and compiler you're using. A small compilable code sample to reproduce the problem is always good as well.
* Submit your patches as pull requests against **develop** branch. Note that by submitting patches you agree to license your modifications under the [Boost Software License, Version 1.0](https://www.boost.org/LICENSE_1_0.txt).
* Discussions about the library are held on the [Boost developers mailing list](https://www.boost.org/community/groups.html#main). Be sure to read the [discussion policy](https://www.boost.org/community/policy.html) before posting and add the `[log]` tag at the beginning of the subject line.

### Build status

Master: [![AppVeyor](https://ci.appveyor.com/api/projects/status/w7x67cnm82xihei5/branch/master?svg=true)](https://ci.appveyor.com/project/Lastique/log/branch/master) [![Travis CI](https://travis-ci.org/boostorg/log.svg?branch=master)](https://travis-ci.org/boostorg/log)
Develop: [![AppVeyor](https://ci.appveyor.com/api/projects/status/w7x67cnm82xihei5/branch/develop?svg=true)](https://ci.appveyor.com/project/Lastique/log/branch/develop) [![Travis CI](https://travis-ci.org/boostorg/log.svg?branch=develop)](https://travis-ci.org/boostorg/log)

### License

Distributed under the [Boost Software License, Version 1.0](https://www.boost.org/LICENSE_1_0.txt).
