// Copyright (c) 2002-2004  INRIA Sophia-Antipolis (France).
// All rights reserved.
//
// This file is part of CGAL (www.cgal.org); you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; either version 3 of the License,
// or (at your option) any later version.
//
// Licensees holding a valid commercial license may use this file in
// accordance with the commercial license agreement provided with the software.
//
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
// $URL: svn+ssh://scm.gforge.inria.fr/svn/cgal/branches/next/Qt_widget/src/CGALQt3/Qt_widget_xpm_icons.cpp $
// $Id: Qt_widget_xpm_icons.cpp 67093 2012-01-13 11:22:39Z lrineau $
// 
//
// Author(s)     : Radu Ursu <rursu@geometryfactory.com>

#include <CGAL/basic.h>



/* XPM */
const char *  alpha_shape_xpm[] = {
"32 32 3 1",
"       c None",
".      c #000080",
"+      c #09F971",
"                                ",
"                                ",
"                                ",
"          .............         ",
"         .+          ...        ",
"         . +        . + .       ",
"        .  +       . +  .       ",
"        .   +     .  +   .      ",
"        .   +    .   +    .     ",
"       .     +  .    +     .    ",
"       .      +.    +    ++.    ",
"      .       .++   +  ++ ..    ",
"      .     .... ++++++  . .    ",
"      .    . . .    .    . .    ",
"     .   ..  .  .   .   .  .    ",
"     .  .    .  .   .   .   .   ",
"     ...     .   .  .  .    .   ",
"    ..      .     . .  .    .   ",
"    .++     .     . . .     .   ",
"    .  ++++++      .. .     .   ",
"    .       .....  ..........   ",
"    .     .. .   ....+    .     ",
"    .    .    .      +   .      ",
"    .   .      .     +  .       ",
"    . ..        .   +  .        ",
"    ..           .  +  .        ",
"    .....         . + .         ",
"         ........  .+.          ",
"                 ....           ",
"                                ",
"                                ",
"                                "};


/* XPM */
const char *  alpha_shape_small_xpm[] = {
"16 16 3 1",
"       c None",
".      c #35E8D9",
"+      c #000000",
"    ........    ",
"   ..........   ",
"  .+++++......  ",
" ......+...++.. ",
".......+.+++....",
".......+++......",
"....+++++.......",
"....+...++......",
".........+......",
".........++.....",
"........+++++++.",
".......++.......",
" .....++....... ",
"  ...++++.....  ",
"   .....+++..   ",
"    ......+.    "};

/* XPM */
const char * arrow_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 3 1",
"  c black",
". c #808080",
"X c None",
/* pixels */
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXX XXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXX  XXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXX   XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXX    XXXXXXXXXXXXXXX",
"XXXXXXXXXXXXX     XXXXXXXXXXXXXX",
"XXXXXXXXXXXXX      XXXXXXXXXXXXX",
"XXXXXXXXXXXXX       XXXXXXXXXXXX",
"XXXXXXXXXXXXX    .XXXXXXXXXXXXXX",
"XXXXXXXXXXXXX  . .XXXXXXXXXXXXXX",
"XXXXXXXXXXXXX XX. XXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXX .XXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXX. XXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
};

/* XPM */
const char *  arrow_small_xpm[] = {
"16 16 2 1",
" 	c None",
".	c #000000",
"                ",
"                ",
"    .           ",
"    ..          ",
"    ...         ",
"    ....        ",
"    .....       ",
"    ......      ",
"    .......     ",
"    .. .        ",
"    .   .       ",
"    .   .       ",
"         .      ",
"         .      ",
"                ",
"                "};

/* XPM */
const char * back_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 6 1",
"  c opaque",
". c blue",
"X c cyan",
"o c magenta",
"O c #c0c0c0",
"+ c None",
/* pixels */
"++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++",
"++++              ++++++++++++++",
"++++ oooooooooooo ++++++++++++++",
"++++ oooooooooooo ++++++++++++++",
"++++ oooooooooooo ++++++++++++++",
"++++ oooooooooooo ++++++++++++++",
"++++ oooooooooooo ++++++++++++++",
"++++ oooooooooooo ++++++++++++++",
"++++ oooooooooooo ++++++++++++++",
"++++ oooooooooooo ++++++++++++++",
"++++ oooooooooooo ++++++++++++++",
"++++ oooooooooooo ++++++++++++++",
"++++ oooooooooooo ++++++++++++++",
"++++ oooooooooooo ++++++++++++++",
"++++ oooooooooooo ++++++++++++++",
"++++ oooooooooooo ++++++++++++++",
"++++ oooooooooooo ++++++++++++++",
"++++              +++++ ++++++++",
"++++++++++++++++++++++. ++++++++",
"+++++++++++++++++++++.O ++++++++",
"++++++++++++++++++++.OO ...... +",
"+++++++++++++++++++.OOOOOOOOOX +",
"+++++++++++++++++++ XXXXXXXXXX +",
"++++++++++++++++++++ XX        +",
"+++++++++++++++++++++ X ++++++++",
"++++++++++++++++++++++  ++++++++",
"+++++++++++++++++++++++ ++++++++",
"++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++"
};

/* XPM */
const char *  back_small_xpm[] = {
"16 16 2 1",
" 	c None",
".	c #000000",
"                ",
"                ",
"                ",
"        ...     ",
"       .   .    ",
"      .     .   ",
"     .      .   ",
"  .  .      .   ",
"  . .       .   ",
"  ... ..    .   ",
"  .....         ",
"  ....          ",
"  ...           ",
"  ..            ",
"  .             ",
"                "};

/* XPM */
const char * circle_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 3 1",
"  c opaque",
". c navy",
"X c None",
/* pixels */
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXX       XXXXXXXX",
"XXXXXXXXXXXXXXX           XXXXXX",
"XXXXXXXXXXXXXX   XXXXXXX   XXXXX",
"XXXXXXXXXXXXX   XXXXXXXXX   XXXX",
"XXXXXXXXXXXXX   XXXXXXXXX   XXXX",
"XXXXXXXXXXXX   XXXXXXXXXXX   XXX",
"XXXXXXXXXXXX   XXXXXXXXXXX   XXX",
"XXXXXXXXXXXX   XXXXXXXXXXX   XXX",
"XXXXXXXXXXXX   XXXXXXXXXXX   XXX",
"XXXXXXXXXXXX   XXXXXXXXXXX   XXX",
"XXXXXXXXXXXXX   XXXXXXXXX   XXXX",
"XXXXXXXXXXXXX   XXXXXXXXX   XXXX",
"XXXXXXXXXXXXXX   XXXXXXX   XXXXX",
"XXXXXXXXXXXXXXX           XXXXXX",
"XXXXXXXXXXXXXXXXX       XXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXX........XXXXXXXXXXXXXXXXXXX",
"XXXXXXX......XXXXXXXXXXXXXXXXXXX",
"XXXXXXX......XXXXXXXXXXXXXXXXXXX",
"XXXXXX.......XXXXXXXXXXXXXXXXXXX",
"XXXXX........XXXXXXXXXXXXXXXXXXX",
"XXXX.........XXXXXXXXXXXXXXXXXXX",
"XXX.......XX.XXXXXXXXXXXXXXXXXXX",
"XXX......XXX.XXXXXXXXXXXXXXXXXXX",
"XXX.....XXXXXXXXXXXXXXXXXXXXXXXX",
"XXX....XXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
};

/* XPM */
const char *  circle_small_xpm[] = {
"16 16 4 1",
" 	c None",
".	c #EDA1A1",
"+	c #000000",
"@	c #1F0670",
"    ........    ",
"   ..........   ",
"  .....+++++..  ",
" .....++...++.. ",
"......+.....+...",
"......+.....+...",
"......+.....+...",
"......++...++...",
".......+++++....",
"..@@@@@.........",
"...@@@@.........",
"...@@@@.........",
" .@@@@@........ ",
" @@@..@.......  ",
"@@@..........   ",
"@@  ........    "};

/* XPM */
const char * constrained_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 3 1",
"  c opaque",
". c red",
"X c None",
/* pixels */
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXX...........................XX",
"XXX...........................XX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXX.....................XXXXXXXX",
"XXX.....................XXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXX.............XXXXXXXXXXXXXXXX",
"XXX.............XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXX.....XXXXXXXXXXXXXXXXXXXXXXXX",
"XXX.....XXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXX.............XXXXXXXXXXXXXXXX",
"XXX.............XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXX.....................XXXXXXXX",
"XXX.....................XXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
};

/* XPM */
const char *  constrained_small_xpm[] = {
"16 16 4 1",
" 	c None",
".	c #35E8D9",
"+	c #F40C3A",
"@	c #000000",
"    ........    ",
"   ..........   ",
"  .....+++++..  ",
" ...++++..++@.. ",
"..++++...++..@..",
".+++.....++...@.",
".@.++...++....@.",
"..@.++..++..@@@.",
"..@..++++.@@..@.",
"...@..++@@...@..",
"...@...@....@...",
"....@..@...@....",
" ...@..@..@.... ",
"  ...@.@.@....  ",
"   ..@.@@....   ",
"    ..@@....    "};


/* XPM */
const char * focus_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 2 1",
"  c black",
". c None",
/* pixels */
"................................",
"................................",
"...............  ...............",
"...............  ...............",
"...............  ...............",
"...............  ...............",
"...........          ...........",
".........              .........",
"........    ........    ........",
".......   ............   .......",
"......   ..............   ......",
"......  ................  ......",
".....  ..................  .....",
".....  ........  ........  .....",
".....  ........  ........  .....",
"..     ......      ......     ..",
"..     ......      ......     ..",
".....  ........  ........  .....",
".....  ........  ........  .....",
".....  ..................  .....",
"......  ................  ......",
"......   ..............   ......",
".......   ............   .......",
"........    ........    ........",
".........              .........",
"...........          ...........",
"...............  ...............",
"...............  ...............",
"...............  ...............",
"...............  ...............",
"................................",
"................................"
};


/* XPM */
const char * focus1_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 2 1",
"  c black",
". c white",
/* pixels */
"          ............          ",
" ........ ............ ........ ",
" ........ ............ ........ ",
" ..      ..............      .. ",
" .. ........................ .. ",
" .. ........................ .. ",
" .. ........................ .. ",
" .. ........................ .. ",
" .. ........................ .. ",
"   ..........................   ",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
".............................   ",
"   ......................... .. ",
" .. ........................ .. ",
" .. ........................ .. ",
" .. ........................ .. ",
" .. ........................ .. ",
" ..      ..............      .. ",
" ........ ............ ........ ",
" ........ ............ ........ ",
"          ............          "
};

/* XPM */
const char * focus1_mask_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 2 1",
"  c black",
". c white",
/* pixels */
"          ............          ",
"          ............          ",
"          ............          ",
"         ..............         ",
"    ........................    ",
"    ........................    ",
"    ........................    ",
"    ........................    ",
"    ........................    ",
"   ..........................   ",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
".............................   ",
"   .........................    ",
"    ........................    ",
"    ........................    ",
"    ........................    ",
"    ........................    ",
"         ..............         ",
"          ............          ",
"          ............          ",
"          ............          "
};

/* XPM */
const char * focus2_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 2 1",
"  c black",
". c white",
/* pixels */
"................................",
"................................",
"................................",
"................................",
"....          ....          ....",
".... ........ .... ........ ....",
".... ........ .... ........ ....",
".... ..      ......      .. ....",
".... .. ................ .. ....",
".... .. ................ .. ....",
".... .. ................ .. ....",
".... .. ................ .. ....",
".... .. ................ .. ....",
"....   ..................   ....",
"................................",
"................................",
"................................",
"................................",
".........................   ....",
"....   ................. .. ....",
".... .. ................ .. ....",
".... .. ................ .. ....",
".... .. ................ .. ....",
".... .. ................ .. ....",
".... ..      ......      .. ....",
".... ........ .... ........ ....",
".... ........ .... ........ ....",
"....          ....          ....",
"................................",
"................................",
"................................",
"................................"
};

/* XPM */
const char * focus2_mask_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 2 1",
"  c black",
". c white",
/* pixels */
"................................",
"................................",
"................................",
"................................",
"....          ....          ....",
"....          ....          ....",
"....          ....          ....",
"....         ......         ....",
"....    ................    ....",
"....    ................    ....",
"....    ................    ....",
"....    ................    ....",
"....    ................    ....",
"....   ..................   ....",
"................................",
"................................",
"................................",
"................................",
".........................   ....",
"....   .................    ....",
"....    ................    ....",
"....    ................    ....",
"....    ................    ....",
"....    ................    ....",
"....         ......         ....",
"....          ....          ....",
"....          ....          ....",
"....          ....          ....",
"................................",
"................................",
"................................",
"................................"
};

/* XPM */
const char * focus3_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 2 1",
"  c black",
". c white",
/* pixels */
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"......                    ......",
"...... ........  ........ ......",
"...... ........  ........ ......",
"...... ..      ..      .. ......",
"...... .. ............ .. ......",
"...... .. ............ .. ......",
"...... .. .....  ..... .. ......",
"...... .. .....  ..... .. ......",
"...... .. .....  ..... .. ......",
"......   ...   ..   ...   ......",
"......   ...   ..   .. .. ......",
"...... .. .....  ..... .. ......",
"...... .. .....  ..... .. ......",
"...... .. .....  ..... .. ......",
"...... .. ............ .. ......",
"...... ..      ..      .. ......",
"...... ........  ........ ......",
"...... ........  ........ ......",
"......                    ......",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................"
};

/* XPM */
const char * focus3_mask_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 2 1",
"  c black",
". c white",
/* pixels */
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"......                    ......",
"......                    ......",
"......                    ......",
"......         ..         ......",
"......    ............    ......",
"......    ............    ......",
"......    .....  .....    ......",
"......    .....  .....    ......",
"......    .....  .....    ......",
"......   ...        ...   ......",
"......   ...        ..    ......",
"......    .....  .....    ......",
"......    .....  .....    ......",
"......    .....  .....    ......",
"......    ............    ......",
"......         ..         ......",
"......                    ......",
"......                    ......",
"......                    ......",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................"
};

/* XPM */
const char * forward_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 7 1",
"  c opaque",
". c blue",
"X c cyan",
"o c magenta",
"O c #c0c0c0",
"+ c white",
"@ c None",
/* pixels */
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@              @@@@",
"@@@@@@@@@@@@@@ oooooooooooo @@@@",
"@@@@@@@@@@@@@@ oooooooooooo @@@@",
"@@@@@@@@@@@@@@ oooooooooooo @@@@",
"@@@@@@@@@@@@@@ oooooooooooo @@@@",
"@@@@@@@@@@@@@@ oooooooooooo @@@@",
"@@@@@@@@@@@@@@ oooooooooooo @@@@",
"@@@@@@@@@@@@@@ oooooooooooo @@@@",
"@@@@@@@@@@@@@@ oooooooooooo @@@@",
"@@@@@@@@@@@@@@ oooooooooooo @@@@",
"@@@@@@@@@@@@@@ oooooooooooo @@@@",
"@@@@@@@@@@@@@@ oooooooooooo @@@@",
"@@@@@@@@@@@@@@ oooooooooooo @@@@",
"@@@@@@@@@@@@@@ oooooooooooo @@@@",
"@@@@@@@@@@@@@@ oooooooooooo @@@@",
"@@@@@@@@.@@@@@ oooooooooooo @@@@",
"@@@@@@@@. @@@@              @@@@",
"@@@@@@@@.X @@@@@@@@@@@@@@@@@@@@@",
"@........+X @@@@@@@@@@@@@@@@@@@@",
"@.++++++++OX @@@@@@@@@@@@@@@@@@@",
"@.XXXXXXXXX. @@@@@@@@@@@@@@@@@@@",
"@        X. @@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@ . @@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@  @@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@ @@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@"
};

/* XPM */
const char *  forward_small_xpm[] = {
"16 16 2 1",
" 	c None",
".	c #000000",
"                ",
"                ",
"                ",
"     ...        ",
"    .   .       ",
"   .     .      ",
"   .      .     ",
"   .      .  .  ",
"   .       . .  ",
"   .    .. ...  ",
"         .....  ",
"          ....  ",
"           ...  ",
"            ..  ",
"             .  ",
"                "};


/* XPM */
const char * greene_approx_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 3 1",
"  c black",
". c green",
"X c None",
/* pixels */
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXX                 XXXXXXXXXXXX",
"XXX                  XXXXXXXXXXX",
"XXX  ..............   XXXXXXXXXX",
"XXX  ............  .    XXXXXXXX",
"XXX  ..........  ....    XXXXXXX",
"XXX  ......... ........   XXXXXX",
"XXX  .......  ..........   XXXXX",
"XXX         .............  XXXXX",
"XXX         .............  XXXXX",
"XXXXXXXXXX  ............   XXXXX",
"XXXXXXXXXX  ...........   XXXXXX",
"XXXXXXXXXX               XXXXXXX",
"XXXXXXXXXX  ..........  XXXXXXXX",
"XXXXXXXXXX  .........   XXXXXXXX",
"XXXXXXXXXX  ......     XXXXXXXXX",
"XXXXXXXXXX  ..    ...   XXXXXXXX",
"XXXXXXXXX     ........    XXXXXX",
"XXXXXXX    ............    XXXXX",
"XXXXXX    ...............   XXXX",
"XXXXX   ..................   XXX",
"XXXX       ...............  XXXX",
"XXXX  .....      .........  XXXX",
"XXXX  ...........    ....   XXXX",
"XXXX  ...........      ..  XXXXX",
"XXXX  .........         .  XXXXX",
"XXXX              XXXX     XXXXX",
"XXXX            XXXXXXX    XXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXX XXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
};

/* XPM */
const char *  greene_approx_small_xpm[] = {
"16 16 4 1",
" 	c None",
".	c #35E8D9",
"+	c #000000",
"@	c #26F70E",
"    ........    ",
"   ++++++++..   ",
"  .+@@@@@@++..  ",
" ..+@@@@++@@+.. ",
"...+@@@+@@@@@+..",
"...++++@@@@@@+..",
"......++++++++..",
"......+@@@+.....",
"......++@@+.....",
"......+@+++.....",
".....+@@@@++....",
"....+@@@+++@+...",
" ..+@+++@@@@+.. ",
"  .++@@@@@@@+.  ",
"   .++++++++.   ",
"    ........    "};


/* XPM */
const char * hand_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 5 1",
"  c black",
". c #808080",
"X c #c0c0c0",
"o c white",
"O c None",
/* pixels */
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOO  OOOOOOOOOOOOOOO",
"OOOOOOOOOOO  O Xo   OOOOOOOOOOOO",
"OOOOOOOOOO oo  Xo Xo OOOOOOOOOOO",
"OOOOOOOOOO Xo  Xo Xo . OOOOOOOOO",
"OOOOOOOOOOO oo Xo Xo  X OOOOOOOO",
"OOOOOOOOOOO Xo Xo Xo Xo OOOOOOOO",
"OOOOOOOOO  X ooooooo Xo OOOOOOOO",
"OOOOOOOO oo  ooXXoXoooo OOOOOOOO",
"OOOOOOOO Xoo XooooooXo OOOOOOOOO",
"OOOOOOOOO XooXoooooooo OOOOOOOOO",
"OOOOOOOOOO ooooooooooo OOOOOOOOO",
"OOOOOOOOOO Xooooooooo OOOOOOOOOO",
"OOOOOOOOOOO Xoooooooo OOOOOOOOOO",
"OOOOOOOOOOOO Xoooooo OOOOOOOOOOO",
"OOOOOOOOOOOOO Oooooo OOOOOOOOOOO",
"OOOOOOOOOOOOO Oooooo OOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO"
};


/* XPM */
const char * handtool_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 3 1",
"  c black",
". c red",
"X c None",
/* pixels */
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XX  XXXXXXXXXXXXXXXXXXXXXX   XXX",
"XX     XXXXXXXXXXXXXXXX     XXXX",
"XXX  XXXXXXXXXXXXXXXXXXXX   XXXX",
"XXX X XXXXXXXXXXXXXXXXXX X XXXXX",
"XXXXXX XXXXXXXXXXXXXXX  XX XXXXX",
"XXXXXXX  XXXXXXXXXXXX XXXXXXXXXX",
"XXXXXXXXX XXXXXXXXX  XXXXXXXXXXX",
"XXXXXXXXXX XXXXXXX XXXXXXXXXXXXX",
"XXXXXXXXXXX X..X. XXXXXXXXXXXXXX",
"XXXXXXXXXXXX.... XXXXXXXXXXXXXXX",
"XXXXXXXXXXX.......XXXXXXXXXXXXXX",
"XXXXXXXXXXXX....XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXX.....XXXXXXXXXXXXXXX",
"XXXXXXXXXXX. .XX. XXXXXXXXXXXXXX",
"XXXXXXXXXXX XXXXXX XXXXXXXXXXXXX",
"XXXXXXXXXX XXXXXXXX XXXXXXXXXXXX",
"XXXXXXXXX XXXXXXXXXX XXXXXXXXXXX",
"XXXXXXXXX XXXXXXXXXX XXXXXXXXXXX",
"XXXXXXXX XXXXXXXXXXXX XXXXXXXXXX",
"XXXXXXX XXXXXXXXXXXXXX XXXXXXXXX",
"XXXXXX XXXXXXXXXXXXXXXX XXXXXXXX",
"XXXXXX XXXXXXXXXXXXXXXXX XX XXXX",
"XXXXX XXXXXXXXXXXXXXXXXXX   XXXX",
"XX X XXXXXXXXXXXXXXXXXX     XXXX",
"XX  XXXXXXXXXXXXXXXXXXXXX   XXXX",
"XX    XXXXXXXXXXXXXXXXXXXXXXXXXX",
"XX  XXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
};

/* XPM */
const char * holddown_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 4 1",
"  c black",
". c #c0c0c0",
"X c white",
"o c None",
/* pixels */
"oooooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooooo",
"ooooooooooooo       oooooooooooo",
"ooooooo ooo    .X .X  oooooooooo",
"oooooooo  o .X .X .X . ooo   ooo",
"oooooooooo o XXXXXXX .    oooooo",
"oooooooo     XX..X.XXX oo  ooooo",
"oooooo  oo X .XXXXXX.X oooo  ooo",
"oooooooooo XX.XXXXXXXX ooooooooo",
"oooooooooo XXXXXXXXXXX ooooooooo",
"oooooooooo .XXXXXXXXX oooooooooo",
"ooooooooooo .XXXXXXXX oooooooooo",
"oooooooooooo .XXXXXX ooooooooooo",
"ooooooooooooo oXXXXX ooooooooooo",
"ooooooooooooo oXXXXX ooooooooooo",
"oooooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooooo"
};

/* XPM */
const char *  iso_rectangle_small_xpm[] = {
"16 16 4 1",
"       c None",
".      c #EDA1A1",
"+      c #000000",
"@      c #1F0670",
"    ........    ",
"   ..........   ",
"  ............  ",
" ....++++++++.. ",
".....+......+...",
".....+......+...",
".....+......+...",
".....++++++++...",
"................",
"..@@@@@.........",
"...@@@@.........",
"...@@@@.........",
" .@@@@@........ ",
" @@@..@.......  ",
"@@@..........   ",
"@@  ........    "};

/* XPM */
const char *  iso_rectangle_xpm[] = {
"16 16 4 1",
"       c None",
".      c #EDA1A1",
"+      c #000000",
"@      c #1F0670",
"    ........    ",
"   ..........   ",
"  ............  ",
" ....++++++++.. ",
".....+......+...",
".....+......+...",
".....+......+...",
".....++++++++...",
"................",
"..@@@@@.........",
"...@@@@.........",
"...@@@@.........",
" .@@@@@........ ",
" @@@..@.......  ",
"@@@..........   ",
"@@  ........    "};

/* XPM */
const char * line_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 3 1",
"  c opaque",
". c navy",
"X c None",
/* pixels */
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXX XXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXX   XXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXX   XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXX   XXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXX   XXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXX   XXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXX   XXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXX   XXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXX   XXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXX   XXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXX   XXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXX   XXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXX   XXXXXX",
"XXXXX........XXXXXXXXXXX XXXXXXX",
"XXXXXXX......XXXXXXXXXXXXXXXXXXX",
"XXXXXXX......XXXXXXXXXXXXXXXXXXX",
"XXXXXX.......XXXXXXXXXXXXXXXXXXX",
"XXXXX........XXXXXXXXXXXXXXXXXXX",
"XXXX.........XXXXXXXXXXXXXXXXXXX",
"XXX.......XX.XXXXXXXXXXXXXXXXXXX",
"XXX......XXX.XXXXXXXXXXXXXXXXXXX",
"XXX.....XXXXXXXXXXXXXXXXXXXXXXXX",
"XXX....XXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
};

/* XPM */
const char *  line_small_xpm[] = {
"16 16 4 1",
" 	c None",
".	c #EDA1A1",
"+	c #000000",
"@	c #1F0670",
"    ........    ",
"   ..........   ",
"  ............  ",
" .....+........ ",
".......+........",
"........+.......",
".........+......",
"..........+.....",
"...........+....",
"..@@@@@.....+...",
"...@@@@.........",
"...@@@@.........",
" .@@@@@........ ",
" @@@..@.......  ",
"@@@..........   ",
"@@  ........    "};



/* XPM */
const char * min_parallelogram_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 5 1",
"  c black",
". c navy",
"X c cyan",
"o c #808080",
"O c None",
/* pixels */
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOXXXXXXXXXXXXXXXXXXOOOOOOOOOOOO",
"OOXooooooooooooooooXOOOOOOOOOOOO",
"OOOXoo..ooo..oooooooXOOOOOOOOOOO",
"OOOXoo..ooo..oooooooXOOOOOOOOOOO",
"OOOOXoooooooooooo..ooXOOOOOOOOOO",
"OOOOXooooo..ooooo..ooXOOOOOOOOOO",
"OOOOXooooo..ooooooooooXOOOOOOOOO",
"OOOOOXooooooooo..oooooXOOOOOOOOO",
"OOOOOXooo..oooo..oooooXOOOOOOOOO",
"OOOOOXooo..ooooooooooooXOOOOOOOO",
"OOOOOOXoooooooooooo..ooXOOOOOOOO",
"OOOOOOXoooooooooooo..oooXOOOOOOO",
"OOOOOOOXooooooooooooooooXOOOOOOO",
"OOOOOOOXo..oooooooooooooXOOOOOOO",
"OOOOOOOXo..ooooooooooooooXOOOOOO",
"OOOOOOOOXooooooooooooooooXOOOOOO",
"OOOOOOOOXoooooooooooooooooXOOOOO",
"OOOOOOOOOXoooooooooooo..ooXOOOOO",
"OOOOOOOOOXo..ooooooooo..oooXOOOO",
"OOOOOOOOOXo..ooooooooooooooXOOOO",
"OOOOOOOOOOXooooooooooooooooXOOOO",
"OOOOOOOOOOXoooooooooooooooooXOOO",
"OOOOOOOOOOXooo..oooo..ooooooXOOO",
"OOOOOOOOOOOXoo..oooo..oo..oooXOO",
"OOOOOOOOOOOXoooooooooooo..oooXOO",
"OOOOOOOOOOOOXoooooooooooooooooXO",
"OOOOOOOOOOOOXXXXXXXXXXXXXXXXXXXO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO"
};

/* XPM */
const char *  min_parallelogram_small_xpm[] = {
"16 16 3 1",
" 	c None",
".	c #35E8D9",
"+	c #000000",
"    ........    ",
"   ..........   ",
"  ............  ",
" .............. ",
"..++++++++++....",
"..+........+....",
"..+........+....",
"...+........+...",
"...+........+...",
"....+........+..",
"....+........+..",
".....++++++++++.",
" .............. ",
"  ............  ",
"   ..........   ",
"    ........    "};

/* XPM */
const char * min_rectangle_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 5 1",
"  c black",
". c navy",
"X c green",
"o c cyan",
"O c None",
/* pixels */
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OooooooooooooooooooooooooooooooO",
"Oo............................oO",
"Oo............................oO",
"Oo..XX...................XX...oO",
"Oo..XX...................XX...oO",
"Oo...........XX.....XX........oO",
"Oo...........XX.....XX........oO",
"Oo............................oO",
"Oo............................oO",
"Oo.......................XX...oO",
"Oo....XX.....XX..........XX...oO",
"Oo....XX.....XX.....XX........oO",
"Oo..................XX........oO",
"Oo............................oO",
"Oo............................oO",
"Oo.............XX.............oO",
"Oo.............XX.............oO",
"Oo.....XX.................XX..oO",
"Oo.....XX.................XX..oO",
"Oo............................oO",
"Oo............................oO",
"Oo............................oO",
"Oo..XX........................oO",
"Oo..XX.......XX..XX..XX...XX..oO",
"Oo...........XX..XX..XX...XX..oO",
"Oo............................oO",
"Oo............................oO",
"OooooooooooooooooooooooooooooooO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO"
};

/* XPM */
const char *  min_rectangle_small_xpm[] = {
"16 16 3 1",
" 	c None",
".	c #35E8D9",
"+	c #000000",
"    ........    ",
"   ..........   ",
"  ............  ",
" .............. ",
"................",
"...++++++++++...",
"...+........+...",
"...+........+...",
"...+........+...",
"...+........+...",
"...+........+...",
"...++++++++++...",
" .............. ",
"  ............  ",
"   ..........   ",
"    ........    "};

/* XPM */
const char * mouse_coord_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 2 1",
"  c black",
". c None",
/* pixels */
"................................",
"................................",
"................ ...............",
"................ ...............",
"................ ...............",
"................ ...............",
"................ ...............",
"................ ...............",
"................ ...............",
"................ ...............",
"................ ...............",
"................ ...............",
"................ ...............",
"................ ...............",
"................ ...............",
"................ ...............",
".............       ............",
"............. ..... ............",
"............. ..... ............",
".             .....            .",
"............. ..... ............",
".............       ............",
"................ ...............",
"................ ...............",
"................ ...............",
"................ ...............",
"................ ...............",
"................ ...............",
"................ ...............",
"................ ...............",
"................ ...............",
"................................"
};

/* XPM */
const char * movepoint_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 3 1",
"  c black",
". c red",
"X c None",
/* pixels */
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXX XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXX   XXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXX   XXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXX XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXX XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXX XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXX XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXX XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXX  XXXXXXX...XXXXXXXX  XXXXX",
"XXXX        XX...XX         XXXX",
"XXXXX  XXXXXXX...XXXXXXXX  XXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXX XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXX XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXX XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXX XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXX XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXX XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXX   XXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXX   XXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXX XXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
};

/* XPM */
const char *  movepoint_small_xpm[] = {
"16 16 3 1",
" 	c None",
".	c #EDA1A1",
"+	c #000000",
"    ...+....    ",
"   ....+.....   ",
"  .....+......  ",
" .............. ",
"................",
"................",
".......+........",
".......+........",
"+++..+++++...+++",
".......+........",
".......+........",
"................",
" .............. ",
"  .....+......  ",
"   ....+.....   ",
"    ...+....    "};

/* XPM */
const char * nearest_vertex_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 3 1",
"  c black",
". c red",
"X c None",
/* pixels */
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXX  XXXXXXXXXXXXXXX",
"XXXX               XXXXXXXXXXXXX",
"XXX                  XXXXXXXXXXX",
"XXX     XXXXXXX  X    XXXXXXXXXX",
"XXX         XXX  XXX    XXXXXXXX",
"XXX  XXX         XXXX     XXXXXX",
"XXX  XXXXXXX               XXXXX",
"XXX  XXXXXXXXX XX         XXXXXX",
"XXX  XXXXXXXX  XX  XXXXX  XXXXXX",
"XXX  XXXXXXX  XXXX  XXXX  XXXXXX",
"XXX  XXXXXXX XXXXXX XXXX  XXXXXX",
"XXX  XXXXXX  XXXXXX  XXX  XXXXXX",
"XXX  XXXXXX XXXXXXXX XXX  XXXXXX",
"XXX  XXXXX  XXXXXXXX  XX  XXXXXX",
"XXX  XXXXX XXXXXXXXXX XX  XXXXXX",
"XXX  XXXX  XXXXXXXXXX  X  XXXXXX",
"XXX  XXXX XXXXXXXXXXXX X  XXXXXX",
"XXX ...X  XXXXXXXXXXXX    XXXXXX",
"XXX..... XXXXXXXXXXXXXX   XXXXXX",
"XX.......XXXXXXXXXXXXXXX  XXXXXX",
"XX.......XXXXXXXXXXXXXXX  XXXXXX",
"XX.......                 XXXXXX",
"XXX.....                  XXXXXX",
"XXXX...XXXXXXXXXXXXXXXXXX XXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
};

/* XPM */
const char *  nearest_vertex_small_xpm[] = {
"16 16 4 1",
" 	c None",
".	c #35E8D9",
"+	c #E00BD2",
"@	c #000000",
"    ........    ",
"   ......+++.   ",
"  ......@+++..  ",
" ....@@@.+++@.. ",
"..@@@.....@..@..",
".@@......@....@.",
".@.@@....@....@.",
"..@..@..@...@@@.",
"..@...@.@.@@..@.",
"...@...@@@...@..",
"...@...@....@...",
"....@..@...@....",
" ...@..@..@.... ",
"  ...@.@.@....  ",
"   ..@.@@....   ",
"    ..@@....    "};

/* XPM */
const char * notool_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 3 1",
"  c black",
". c red",
"X c None",
/* pixels */
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXX..........XXXXXXXXXXX",
"XXXXXXXXXX............XXXXXXXXXX",
"XXXXXXXX................XXXXXXXX",
"XXXXXXX.....XXXXXXXX.....XXXXXXX",
"XXXXXXX....XXXXXXXX......XXXXXXX",
"XXXXXX....XXXXXXXX........XXXXXX",
"XXXXX....XXXXXXXX....XX....XXXXX",
"XXXXX...XXXXXXXX....XXXX...XXXXX",
"XXXXX...XXXXXXX....XXXXX...XXXXX",
"XXXXX...XXXXXX....XXXXXX...XXXXX",
"XXXXX...XXXXX....XXXXXXX...XXXXX",
"XXXXX...XXXX....XXXXXXXX...XXXXX",
"XXXXX...XXX....XXXXXXXXX...XXXXX",
"XXXXX...XX....XXXXXXXXXX...XXXXX",
"XXXXX........XXXXXXXXXX....XXXXX",
"XXXXXX......XXXXXXXXXX....XXXXXX",
"XXXXXXX....XXXXXXXXXX....XXXXXXX",
"XXXXXXX.....XXXXXXXX.....XXXXXXX",
"XXXXXXXX................XXXXXXXX",
"XXXXXXXXXX............XXXXXXXXXX",
"XXXXXXXXXXX..........XXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
};

/* XPM */
const char * notool_small_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 3 1",
"  c black",
". c red",
"X c None",
/* pixels */
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXX..........XXXXXXXXXXX",
"XXXXXXXXXX............XXXXXXXXXX",
"XXXXXXXX................XXXXXXXX",
"XXXXXXX.....XXXXXXXX.....XXXXXXX",
"XXXXXXX....XXXXXXXX......XXXXXXX",
"XXXXXX....XXXXXXXX........XXXXXX",
"XXXXX....XXXXXXXX....XX....XXXXX",
"XXXXX...XXXXXXXX....XXXX...XXXXX",
"XXXXX...XXXXXXX....XXXXX...XXXXX",
"XXXXX...XXXXXX....XXXXXX...XXXXX",
"XXXXX...XXXXX....XXXXXXX...XXXXX",
"XXXXX...XXXX....XXXXXXXX...XXXXX",
"XXXXX...XXX....XXXXXXXXX...XXXXX",
"XXXXX...XX....XXXXXXXXXX...XXXXX",
"XXXXX........XXXXXXXXXX....XXXXX",
"XXXXXX......XXXXXXXXXX....XXXXXX",
"XXXXXXX....XXXXXXXXXX....XXXXXXX",
"XXXXXXX.....XXXXXXXX.....XXXXXXX",
"XXXXXXXX................XXXXXXXX",
"XXXXXXXXXX............XXXXXXXXXX",
"XXXXXXXXXXX..........XXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
};



/* XPM */
const char * optimal_convex_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 3 1",
"  c black",
". c yellow",
"X c None",
/* pixels */
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXX                 XXXXXXXXXXXX",
"XXX                  XXXXXXXXXXX",
"XXX  ..............   XXXXXXXXXX",
"XXX  ............  .    XXXXXXXX",
"XXX  ..........  ....    XXXXXXX",
"XXX  ......... ........   XXXXXX",
"XXX  .......  ..........   XXXXX",
"XXX         .............  XXXXX",
"XXX         .............  XXXXX",
"XXXXXXXXXX  ............   XXXXX",
"XXXXXXXXXX  ...........   XXXXXX",
"XXXXXXXXXX               XXXXXXX",
"XXXXXXXXXX  ..........  XXXXXXXX",
"XXXXXXXXXX  .........   XXXXXXXX",
"XXXXXXXXXX  ......     XXXXXXXXX",
"XXXXXXXXXX  ..    ...   XXXXXXXX",
"XXXXXXXXX     ........    XXXXXX",
"XXXXXXX    ............    XXXXX",
"XXXXXX    ...............   XXXX",
"XXXXX   ..................   XXX",
"XXXX       ...............  XXXX",
"XXXX  .....      .........  XXXX",
"XXXX  ...........    ....   XXXX",
"XXXX  ...........      ..  XXXXX",
"XXXX  .........         .  XXXXX",
"XXXX              XXXX     XXXXX",
"XXXX            XXXXXXX    XXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXX XXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
};

/* XPM */
const char *  optimal_convex_small_xpm[] = {
"16 16 4 1",
" 	c None",
".	c #35E8D9",
"+	c #000000",
"@	c #F1F907",
"    ........    ",
"   ++++++++..   ",
"  .+@@@@@@++..  ",
" ..+@@@@++@@+.. ",
"...+@@@+@@@@@+..",
"...++++@@@@@@+..",
"......++++++++..",
"......+@@@+.....",
"......++@@+.....",
"......+@+++.....",
".....+@@@@++....",
"....+@@@+++@+...",
" ..+@+++@@@@+.. ",
"  .++@@@@@@@+.  ",
"   .++++++++.   ",
"    ........    "};


/* XPM */
const char * point_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 4 1",
"  c opaque",
". c navy",
"X c green",
"o c None",
/* pixels */
"oooooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooooo",
"ooooooooooooooooooooo  ooooooooo",
"ooooooooooooooooooooo  ooooooooo",
"ooooooooooooooooooooo  ooooooooo",
"ooooooooooooooooooooo  ooooooooo",
"ooooooooooooooooooooo  ooooooooo",
"oooooooooooooooo     XX     oooo",
"oooooooooooooooo     XX     oooo",
"ooooooooooooooooooooo  ooooooooo",
"ooooooooooooooooooooo  ooooooooo",
"ooooooooooooooooooooo  ooooooooo",
"ooooooooooooooooooooo  ooooooooo",
"ooooooooooooooooooooo  ooooooooo",
"oooooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooooo",
"ooooo........ooooooooooooooooooo",
"ooooooo......ooooooooooooooooooo",
"ooooooo......ooooooooooooooooooo",
"oooooo.......ooooooooooooooooooo",
"ooooo........ooooooooooooooooooo",
"oooo.........ooooooooooooooooooo",
"ooo.......oo.ooooooooooooooooooo",
"ooo......ooo.ooooooooooooooooooo",
"ooo.....oooooooooooooooooooooooo",
"ooo....ooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooooo"
};

/* XPM */
const char *  point_small_xpm[] = {
"16 16 4 1",
" 	c None",
".	c #EDA1A1",
"+	c #000000",
"@	c #1F0670",
"    ........    ",
"   ..........   ",
"  ............  ",
" .............. ",
".........+......",
".........+......",
".......+++++....",
".........+......",
".........+......",
"..@@@@@.........",
"...@@@@.........",
"...@@@@.........",
" .@@@@@........ ",
" @@@..@.......  ",
"@@@..........   ",
"@@  ........    "};

/* XPM */
const char * points_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 2 1",
"  c black",
". c None",
/* pixels */
"................................",
".  ......  ..................  .",
".  ......  ..................  .",
"................................",
"................................",
".......................  .......",
".......  ......  ......  .......",
".......  ......  ...............",
"................................",
"................................",
".........  .....................",
".........  ...............  ....",
"....  ..........  ........  ....",
"....  ..........  ..............",
"................................",
"........  ...........  .........",
"........  ...........  .........",
"................................",
"............................  ..",
".....  .........  ..........  ..",
".....  .........  ..............",
"................................",
"................................",
"..........  ....................",
"..........  ............  ......",
"....................  ..  ......",
"....................  ..........",
"................................",
"................................",
".  ............  ............  .",
".  ............  ............  .",
"................................"
};

/* XPM */
const char *  points_small_xpm[] = {
"16 16 3 1",
" 	c None",
".	c #35E8D9",
"+	c #000000",
"    ....+...    ",
"   ....+++...   ",
"  ......+.....  ",
" .............. ",
"...+.........+..",
"..+++.......+++.",
"...+....+....+..",
".......+++......",
"........+.......",
"............+...",
"..+........+++..",
".+++...+....+...",
" .+...+++...... ",
"  .....+......  ",
"   ..........   ",
"    ........    "};

/* XPM */
const char * polygon_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 4 1",
"  c opaque",
". c navy",
"X c #c0c0c0",
"o c None",
/* pixels */
"oooooooooooooooooooooooooooooooo",
"oooooo                        oo",
"oooooo XXXXXXXXXXXXXXXXXXXXXX oo",
"oooooo XXXXXXXXXXXXXXXXXXXXXX oo",
"oooooo XXXXXXXXXXXXXXXXXXXXXX oo",
"oooooo XXXXXXXXXXXXXXXXXXXXXX oo",
"oooooo XXXXXXXXXXXX           oo",
"oooooo XXXXXXXXXXXX oooooooooooo",
"oooooo XXXXXXXXXXXX oooooooooooo",
"oooooo         XXXX oooooooooooo",
"oooooooooooooo XXXX oooooooooooo",
"oooooooooooooo XXXX         oooo",
"oooooooooooooo XXXXXXXXXXXX oooo",
"oooooooooooooo XXXXXXXXXXXX oooo",
"oooooooooooooo XXXXXXXXXXXX oooo",
"oooooooooooooo XXXXXXXXXXXX oooo",
"oooooooooooooo      XXXXXXX oooo",
"ooooooooooooooooooo XXXXXXX oooo",
"ooooooooooooooooooo XXXXXXX oooo",
"ooooo........oooooo XXXXXXX oooo",
"ooooooo......oooooo XXXXXXX oooo",
"ooooooo......oooooo         oooo",
"oooooo.......ooooooooooooooooooo",
"ooooo........ooooooooooooooooooo",
"oooo.........ooooooooooooooooooo",
"ooo.......oo.ooooooooooooooooooo",
"ooo......ooo.ooooooooooooooooooo",
"ooo.....oooooooooooooooooooooooo",
"ooo....ooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooooo"
};

/* XPM */
const char *  polygon_small_xpm[] = {
"16 16 4 1",
" 	c None",
".	c #EDA1A1",
"+	c #000000",
"@	c #1F0670",
"    ........    ",
"   ..+++++++.   ",
"  ...+.....+..  ",
" ....+.....+++. ",
".....++++....+..",
"........+....+..",
"........+....+..",
"........+++..+..",
"..........+..+..",
"..@@@@@...+..+..",
"...@@@@...+..+..",
"...@@@@...++++..",
" .@@@@@........ ",
" @@@..@.......  ",
"@@@..........   ",
"@@  ........    "};

/* XPM */
const char * show_polygon_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 4 1",
"  c black",
". c navy",
"X c white",
"o c None",
/* pixels */
"oooooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooooo",
"ooo.................oooooooooooo",
"ooo.XXXXXXXXXXXXXXX..ooooooooooo",
"ooo.XooooooooooooooX..oooooooooo",
"ooo.XoooooooooooooooX...oooooooo",
"ooo.XooooooooooooooooX...ooooooo",
"ooo.XoooooooooooooooooXX..oooooo",
"ooo.XoooooooooooooooooooX..ooooo",
"ooo.XXXXXXXXoooooooooooooX.ooooo",
"ooo........XoooooooooooooX.ooooo",
"oooooooooo.XooooooooooooX..ooooo",
"oooooooooo.XoooooooooooX..oooooo",
"oooooooooo.XooooooooooX..ooooooo",
"oooooooooo.XooooooooooX.oooooooo",
"oooooooooo.XoooooooooX..oooooooo",
"oooooooooo.XooooooooX..ooooooooo",
"oooooooooo.XoooooooooX..oooooooo",
"ooooooooo..XooooooooooX...oooooo",
"ooooooo...XooooooooooooXX..ooooo",
"oooooo..XXoooooooooooooooX..oooo",
"ooooo..XooooooooooooooooooX..ooo",
"oooo..XoooooooooooooooooooX.oooo",
"oooo.XoooooooooooooooooooX..oooo",
"oooo.XoooooooooooooooooooX..oooo",
"oooo.XooooooooooXXXXXX.ooX.ooooo",
"oooo.Xooooooooo.X.....XXoX.ooooo",
"oooo.XXXXXXXXXXX..oooo..XX.ooooo",
"oooo............ooooooo....ooooo",
"ooooooooooooooooooooooooo.oooooo",
"oooooooooooooooooooooooooooooooo",
"oooooooooooooooooooooooooooooooo"
};

/* XPM */
const char *  show_polygon_small_xpm[] = {
"16 16 4 1",
" 	c None",
".	c #35E8D9",
"+	c #1709E2",
"@	c #FFFFFF",
"    ........    ",
"   ++++++++..   ",
"  .+@@@@@@++..  ",
" ..+@.....@@+.. ",
"...+@@@.....@+..",
"...++++@.@@@@+..",
"......+@.@++++..",
"......+@.@+.....",
"......+@.@+.....",
"......+@.@+.....",
".....+@..@++....",
"....+@...@@@+...",
" ..+@......@+.. ",
"  .++@@@@@@@+.  ",
"   .++++++++.   ",
"    ........    "};


/* XPM */
const char * triangulation_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 3 1",
"  c black",
". c navy",
"X c None",
/* pixels */
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXX.............XXXXXXXXX",
"XXXXXXXXX..XXXXXXXXXX...XXXXXXXX",
"XXXXXXXXX.X.XXXXXXXX.X.X.XXXXXXX",
"XXXXXXXX.XX.XXXXXXX.X.XX.XXXXXXX",
"XXXXXXXX.XXX.XXXXX.XX.XXX.XXXXXX",
"XXXXXXXX.XXX.XXXX.XXX.XXXX.XXXXX",
"XXXXXXX.XXXXX.XX.XXXX.XXXXX.XXXX",
"XXXXXXX.XXXXXX..XXXX.XXXX...XXXX",
"XXXXXX.XXXXXXX...XXX.XX..X..XXXX",
"XXXXXX.XXXXX....X......XX.X.XXXX",
"XXXXXX.XXXX.X.X.XXXX.XXXX.X.XXXX",
"XXXXX.XXX..XX.XX.XXX.XXX.XX.XXXX",
"XXXXX.XX.XXXX.XX.XXX.XXX.XXX.XXX",
"XXXXX...XXXXX.XXX.XX.XX.XXXX.XXX",
"XXXX..XXXXXX.XXXXX.X.XX.XXXX.XXX",
"XXXX...XXXXX.XXXXX.X.X.XXXXX.XXX",
"XXXX.XX......XXXXXX..X.XXXXX.XXX",
"XXXX.XXXXXXX.....XX..........XXX",
"XXXX.XXXXX..X.XXX.....XXXX.XXXXX",
"XXXX.XXXX.XXXX.XXXXXX.XXX.XXXXXX",
"XXXX.XXX.XXXXXX.XXXXX.XX.XXXXXXX",
"XXXX.X..XXXXXXXX.XXX.XX.XXXXXXXX",
"XXXX..XXXXXXXXXXX.XX.XX.XXXXXXXX",
"XXXX.....XXXXXXXXX.X.X.XXXXXXXXX",
"XXXXXXXXX........XX...XXXXXXXXXX",
"XXXXXXXXXXXXXXXXX....XXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
};

/* XPM */
const char *  triangulation_small_xpm[] = {
"16 16 3 1",
" 	c None",
".	c #35E8D9",
"+	c #000000",
"    ........    ",
"   ..........   ",
"  ......++++..  ",
" ....+++..+.+.. ",
"..+++.....+..+..",
".++......+....+.",
".+.++....+....+.",
"..+..+..+...+++.",
"..+...+.+.++..+.",
"...+...+++...+..",
"...+...+....+...",
"....+..+...+....",
" ...+..+..+.... ",
"  ...+.+.+....  ",
"   ..+.++....   ",
"    ..++....    "};

/* XPM */
const char * voronoi_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 3 1",
"  c black",
". c red",
"X c None",
/* pixels */
"XXXXXXXXXXXXXXXXXXXXXXXX.XXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXX.XXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXX.XXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXX.XXXXXXXXX",
"XXXXXXXXXXXXX  XXXXXXX.XXXXXXXXX",
"XXXXXXXXXXXX     XXXX.XXXXXXXXXX",
".XXXXXXXXXXX  X    X..XXXXXXXXXX",
"..XXXXXXXXX X XXX   .XXXXXXXXXXX",
"X..XXXXXXX  X XXXXX.. XXXXXXXXXX",
"XX..XXXXXX XX XXXX..X   XXXXXXXX",
"XXX...XXX XXX XXXX..XXX  XXXXXXX",
"XXXX...X  XXX XXX..XXXX XXXXXXXX",
"XXXXXX.. XXXX XXX..XXXX XXXXXXXX",
"XXXXXXX..XXXX XX..XXXX XXXXXXXXX",
"XXXXXX  ..........XXX XXXXXXXXXX",
"XXXXX  XX..........X  XXXXXXXXXX",
"XXXXX XXX..XX XXXX.. XXXXXXXXXXX",
"XXXX  XXX.XXX XXXXX...XXXXXXXXXX",
"XXXX  XX..XXX XXXX  ...XXXXXXXXX",
"XXXXX  ..XXXX XXX  XXX..XXXXXXXX",
"XXXXXX . XXXX XXX XXXXX..XXXXXXX",
"XXXXXX..  XXX XX  XXXXXX..XXXXXX",
"XXXXXX.XX   X X  XXXXXXXX..XXXXX",
"XXXXX.XXXX      XXXXXXXXXX..XXXX",
"XXXX..XXXXXX    XXXXXXXXXXX...XX",
"XXXX.XXXXXXXX  XXXXXXXXXXXXX...X",
"XXX.XXXXXXXXXXXXXXXXXXXXXXXXXX..",
"XX..XXXXXXXXXXXXXXXXXXXXXXXXXXX.",
"XX.XXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"X.XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"X.XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
".XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
};

/* XPM */
const char *  voronoi_small_xpm[] = {
"16 16 4 1",
" 	c None",
".	c #35E8D9",
"+	c #000000",
"@	c #E2364D",
"    ........    ",
"   ..........   ",
"  .....+++....  ",
" .@...+.+.+.@@. ",
"..@@..+.+..@@...",
"...@@+..+..@+...",
"....@@..+.@@.+..",
"....+@@.+@@..+..",
"....+.@@@@..+...",
"...+..@@@@@.+...",
"...+.@@.+.@@....",
"....@@..+..@@...",
" ..@@+..+.+.@@. ",
"  .@..+.+.+...  ",
"   ....+++...   ",
"    ....+...    "};

/* XPM */
const char * ymonotone_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 3 1",
"  c black",
". c red",
"X c None",
/* pixels */
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXX                 XXXXXXXXXXXX",
"XXX                  XXXXXXXXXXX",
"XXX  ..............   XXXXXXXXXX",
"XXX  ............  .    XXXXXXXX",
"XXX  ..........  ....    XXXXXXX",
"XXX  ......... ........   XXXXXX",
"XXX  .......  ..........   XXXXX",
"XXX         .............  XXXXX",
"XXX         .............  XXXXX",
"XXXXXXXXXX  ............   XXXXX",
"XXXXXXXXXX  ...........   XXXXXX",
"XXXXXXXXXX               XXXXXXX",
"XXXXXXXXXX  ..........  XXXXXXXX",
"XXXXXXXXXX  .........   XXXXXXXX",
"XXXXXXXXXX  ......     XXXXXXXXX",
"XXXXXXXXXX  ..    ...   XXXXXXXX",
"XXXXXXXXX     ........    XXXXXX",
"XXXXXXX    ............    XXXXX",
"XXXXXX    ...............   XXXX",
"XXXXX   ..................   XXX",
"XXXX       ...............  XXXX",
"XXXX  .....      .........  XXXX",
"XXXX  ...........    ....   XXXX",
"XXXX  ...........      ..  XXXXX",
"XXXX  .........         .  XXXXX",
"XXXX              XXXX     XXXXX",
"XXXX            XXXXXXX    XXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXX XXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
};

/* XPM */
const char *  ymonotone_small_xpm[] = {
"16 16 4 1",
" 	c None",
".	c #35E8D9",
"+	c #000000",
"@	c #F72B07",
"    ........    ",
"   ++++++++..   ",
"  .+@@@@@@++..  ",
" ..+@@@@++@@+.. ",
"...+@@@+@@@@@+..",
"...++++@@@@@@+..",
"......++++++++..",
"......+@@@+.....",
"......++@@+.....",
"......+@+++.....",
".....+@@@@++....",
"....+@@@+++@+...",
" ..+@+++@@@@+.. ",
"  .++@@@@@@@+.  ",
"   .++++++++.   ",
"    ........    "};


/* XPM */
const char * zoomin_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 5 1",
"  c black",
". c #808080",
"X c #c0c0c0",
"o c white",
"O c None",
/* pixels */
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOO       XXOOOOOOOOOOOOO",
"OOOOOOOX  OOOOOOX  XOOOOOOOOOOOO",
"OOOOOOX OOOOOOOOOOX XOOOOOOOOOOO",
"OOOOOX OOOOOOOOOOOOX XOOOOOOOOOO",
"OOOOX OOOOOOOOOOOOOOX XOOOOOOOOO",
"OOOO XOOOOOOO  OOOOOOX OOOOOOOOO",
"OOOO OOOOOOOO  OOOOOOO OOOOOOOOO",
"OOO .OOOOOOOO  OOOOOOOX OOOOOOOO",
"OOO OOOOOOOOO  OOOOOOOO OOOOOOOO",
"OOO OOOOO          OOOO OOOOOOOO",
"OO. OOOOO          OOOO OOOOOOOO",
"OO. OOOOOOOOO  OOOOOOOO OOOOOOOO",
"OO. OOOOOOOOO  OOOOOOOO OOOOOOOO",
"OOO. OOOOOOOO  OOOOOOOO OOOOOOOO",
"OOO. .OOOOOOO  OOOOOO.  OOOOOOOO",
"OOOO. OOOOOOOOOOOOOOO   OOOOOOOO",
"OOOO.. OOOOOOOOOOOOO  o  OOOOOOO",
"OOOOO.. OOOOOOOOOOO    o  OOOOOO",
"OOOOOO..  OOOOOOX       oX OOOOO",
"OOOOOOO...       X..   XXoX OOOO",
"OOOOOOOOO.......OO... XXXXoX OOO",
"OOOOOOOOOOOOOOOOOOO... XXXXoX OO",
"OOOOOOOOOOOOOOOOOOOO... XXXXo  O",
"OOOOOOOOOOOOOOOOOOOOO... XX    O",
"OOOOOOOOOOOOOOOOOOOOOO...     OO",
"OOOOOOOOOOOOOOOOOOOOOOO...   OOO",
"OOOOOOOOOOOOOOOOOOOOOOOO..OOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO"
};

/* XPM */
const char * zoomin_rect_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 6 1",
"  c black",
". c magenta",
"X c #808080",
"o c #c0c0c0",
"O c white",
"+ c None",
/* pixels */
"++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++",
"+++++++++       oo++++++++++++++",
"++++++o  ++++++o  o+++++++++++++",
"+++++o ++++++++++o o++++++++++++",
"++++o ++++++++++++o o+++++++++++",
"+++o ++++++++++++++o o++++++++++",
"+++ o+++++++++++++++o ++++++++++",
"+++ +++++++++++++++++ ++++++++++",
"++ X+++++++++++++++++o +++++++++",
"++                ++++ +++++++++",
"++  ............. ++++ +++++++++",
"+X  ............. ++++ +++++++++",
"+X  ............. ++++ +++++++++",
"+X  ............. ++++ +++++++++",
"++X ............. ++++ +++++++++",
"++X X............ ++X  +++++++++",
"+++X ............ ++   +++++++++",
"+++XX ........... +  O  ++++++++",
"+++ XX ..........     O  +++++++",
"+++ .XX  ......o       Oo ++++++",
"+++ ..XXX       oXX   ooOo +++++",
"+++ ....XXXXXXX..XXX ooooOo ++++",
"+++ ............. XXX ooooOo +++",
"+++ ............. +XXX ooooO  ++",
"+++ ............. ++XXX oo    ++",
"+++ ............. +++XXX     +++",
"+++               ++++XXX   ++++",
"+++++++++++++++++++++++XX+++++++",
"++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++",
"++++++++++++++++++++++++++++++++"
};

/* XPM */
const char * zoomout_xpm[] = {
/* columns rows colors chars-per-pixel */
"32 32 5 1",
"  c black",
". c #808080",
"X c #c0c0c0",
"o c white",
"O c None",
/* pixels */
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOO       XXOOOOOOOOOOOOO",
"OOOOOOOX  OOOOOOX  XOOOOOOOOOOOO",
"OOOOOOX OOOOOOOOOOX XOOOOOOOOOOO",
"OOOOOX OOOOOOOOOOOOX XOOOOOOOOOO",
"OOOOX OOOOOOOOOOOOOOX XOOOOOOOOO",
"OOOO XOOOOOOOOOOOOOOOX OOOOOOOOO",
"OOOO OOOOOOOOOOOOOOOOO OOOOOOOOO",
"OOO .OOOOOOOOOOOOOOOOOX OOOOOOOO",
"OOO OOOOOOOOOOOOOOOOOOO OOOOOOOO",
"OOO OOOOO         OOOOO OOOOOOOO",
"OO. OOOOO         OOOOO OOOOOOOO",
"OO. OOOOOOOOOOOOOOOOOOO OOOOOOOO",
"OO. OOOOOOOOOOOOOOOOOOO OOOOOOOO",
"OOO. OOOOOOOOOOOOOOOOOO OOOOOOOO",
"OOO. .OOOOOOOOOOOOOOO.  OOOOOOOO",
"OOOO. OOOOOOOOOOOOOOO   OOOOOOOO",
"OOOO.. OOOOOOOOOOOOO  o  OOOOOOO",
"OOOOO.. OOOOOOOOOOO    o  OOOOOO",
"OOOOOO..  OOOOOOX       oX OOOOO",
"OOOOOOO...       X..   XXoX OOOO",
"OOOOOOOOO.......OO... XXXXoX OOO",
"OOOOOOOOOOOOOOOOOOO... XXXXoX OO",
"OOOOOOOOOOOOOOOOOOOO... XXXXo  O",
"OOOOOOOOOOOOOOOOOOOOO... XX    O",
"OOOOOOOOOOOOOOOOOOOOOO...     OO",
"OOOOOOOOOOOOOOOOOOOOOOO...   OOO",
"OOOOOOOOOOOOOOOOOOOOOOOO..OOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO"
};

/* XPM */
const char * demoicon_xpm[] = {
/* columns rows colors chars-per-pixel */
"16 16 3 1",
" 	c None",
".	c #FFFF00",
"+	c #000000",
/* pixels */
"................",
"...++++...++++..",
"..+....+.+....+.",
"..+......+......",
"..+......+..+++.",
"..+......+....+.",
"..+....+.+....+.",
"...++++...++++..",
"................",
"...++++...+.....",
"..+....+..+.....",
"..+....+..+.....",
"..++++++..+.....",
"..+....+..+.....",
"..+....+..+++++.",
"................"};
