/* Generated from posixunix.scm by the CHICKEN compiler
   http://www.call-cc.org
   2016-05-28 13:48
   Version 4.11.0 (rev ce980c4)
   linux-unix-gnu-x86-64 [ 64bit manyargs ptables ]
   compiled 2016-05-28 on yves.more-magic.net (Linux)
   command line: posixunix.scm -optimize-level 2 -include-path . -include-path ./ -inline -ignore-repository -feature chicken-bootstrap -no-warnings -specialize -types ./types.db -explicit-use -no-trace -output-file posixunix.c
   unit: posix
*/

#include "chicken.h"


#include <signal.h>
#include <errno.h>

#include <sys/stat.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

#define C_curdir(buf)       (getcwd(C_c_string(buf), 1024) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)

static C_TLS struct stat C_statbuf;

#define C_stat_type         (C_statbuf.st_mode & S_IFMT)
#define C_stat(fn)          C_fix(stat((char *)C_data_pointer(fn), &C_statbuf))
#define C_fstat(f)          C_fix(fstat(C_unfix(f), &C_statbuf))

#ifndef S_IFSOCK
# define S_IFSOCK           0140000
#endif

#define cpy_tmvec_to_tmstc08(ptm, v) \
    ((ptm)->tm_sec = C_unfix(C_block_item((v), 0)), \
    (ptm)->tm_min = C_unfix(C_block_item((v), 1)), \
    (ptm)->tm_hour = C_unfix(C_block_item((v), 2)), \
    (ptm)->tm_mday = C_unfix(C_block_item((v), 3)), \
    (ptm)->tm_mon = C_unfix(C_block_item((v), 4)), \
    (ptm)->tm_year = C_unfix(C_block_item((v), 5)), \
    (ptm)->tm_wday = C_unfix(C_block_item((v), 6)), \
    (ptm)->tm_yday = C_unfix(C_block_item((v), 7)), \
    (ptm)->tm_isdst = (C_block_item((v), 8) != C_SCHEME_FALSE))

#define cpy_tmvec_to_tmstc9(ptm, v) \
    (((struct tm *)ptm)->tm_gmtoff = -C_unfix(C_block_item((v), 9)))

#define C_tm_set_08(v, tm)  cpy_tmvec_to_tmstc08( (tm), (v) )
#define C_tm_set_9(v, tm)   cpy_tmvec_to_tmstc9( (tm), (v) )

static struct tm *
C_tm_set( C_word v, void *tm )
{
  C_tm_set_08( v, (struct tm *)tm );
#if defined(C_GNU_ENV) && !defined(__CYGWIN__) && !defined(__uClinux__)
  C_tm_set_9( v, (struct tm *)tm );
#endif
  return tm;
}

#define TIME_STRING_MAXLENGTH 255
static char C_time_string [TIME_STRING_MAXLENGTH + 1];
#undef TIME_STRING_MAXLENGTH

#define C_strftime(v, f, tm) \
        (strftime(C_time_string, sizeof(C_time_string), C_c_string(f), C_tm_set((v), (tm))) ? C_time_string : NULL)
#define C_a_mktime(ptr, c, v, tm)  C_flonum(ptr, mktime(C_tm_set((v), C_data_pointer(tm))))
#define C_asctime(v, tm)    (asctime(C_tm_set((v), (tm))))

#define C_fdopen(a, n, fd, m) C_mpointer(a, fdopen(C_unfix(fd), C_c_string(m)))
#define C_C_fileno(p)       C_fix(fileno(C_port_file(p)))
#define C_dup(x)            C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)        C_fix(dup2(C_unfix(x), C_unfix(y)))

#define C_set_file_ptr(port, ptr)  (C_set_block_item(port, 0, (C_block_item(ptr, 0))), C_SCHEME_UNDEFINED)

#define C_opendir(x,h)      C_set_block_item(h, 0, (C_word) opendir(C_c_string(x)))
#define C_closedir(h)       (closedir((DIR *)C_block_item(h, 0)), C_SCHEME_UNDEFINED)
#define C_readdir(h,e)      C_set_block_item(e, 0, (C_word) readdir((DIR *)C_block_item(h, 0)))
#define C_foundfile(e,b,l)    (C_strlcpy(C_c_string(b), ((struct dirent *) C_block_item(e, 0))->d_name, l), C_fix(strlen(((struct dirent *) C_block_item(e, 0))->d_name)))

/* It is assumed that 'int' is-a 'long' */
#define C_ftell(p)          C_fix(ftell(C_port_file(p)))
#define C_fseek(p, n, w)    C_mk_nbool(fseek(C_port_file(p), C_num_to_int(n), C_unfix(w)))
#define C_lseek(fd, o, w)     C_fix(lseek(C_unfix(fd), C_unfix(o), C_unfix(w)))

#ifdef HAVE_SETENV
# define C_unsetenv(s)      (unsetenv((char *)C_data_pointer(s)), C_SCHEME_TRUE)
# define C_setenv(x, y)     C_fix(setenv((char *)C_data_pointer(x), (char *)C_data_pointer(y), 1))
#else
# if defined(_WIN32) && !defined(__CYGWIN__)
#  define C_unsetenv(s)      C_setenv(s, C_SCHEME_FALSE)
# else
#  define C_unsetenv(s)      C_fix(putenv((char *)C_data_pointer(s)))
# endif
static C_word C_fcall C_setenv(C_word x, C_word y) {
  char *sx = C_c_string(x),
       *sy = (y == C_SCHEME_FALSE ? "" : C_c_string(y));
  int n1 = C_strlen(sx), n2 = C_strlen(sy);
  int buf_len = n1 + n2 + 2;
  char *buf = (char *)C_malloc(buf_len);
  if(buf == NULL) return(C_fix(0));
  else {
    C_strlcpy(buf, sx, buf_len);
    C_strlcat(buf, "=", buf_len);
    C_strlcat(buf, sy, buf_len);
    return(C_fix(putenv(buf)));
  }
}
#endif

#ifndef S_IFLNK
#define S_IFLNK S_IFREG
#endif

#ifndef S_IFREG
#define S_IFREG S_IFREG
#endif

#ifndef S_IFDIR
#define S_IFDIR S_IFREG
#endif

#ifndef S_IFCHR
#define S_IFCHR S_IFREG
#endif

#ifndef S_IFBLK
#define S_IFBLK S_IFREG
#endif

#ifndef S_IFSOCK
#define S_IFSOCK S_IFREG
#endif

#ifndef S_IFIFO
#define S_IFIFO S_IFREG
#endif

static C_TLS int C_wait_status;

#include <sys/time.h>
#include <sys/wait.h>
#include <sys/utsname.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <dirent.h>
#include <pwd.h>
#include <utime.h>

#if defined(__sun) && defined(__SVR4)
# include <sys/tty.h>
# include <termios.h>
#endif

#ifdef HAVE_GRP_H
#include <grp.h>
#endif

#include <sys/mman.h>
#include <sys/poll.h>

#ifndef O_FSYNC
# define O_FSYNC O_SYNC
#endif

#ifndef PIPE_BUF
# ifdef __CYGWIN__
#  define PIPE_BUF       _POSIX_PIPE_BUF
# else
#  define PIPE_BUF 1024
# endif
#endif

#ifndef O_BINARY
# define O_BINARY        0
#endif
#ifndef O_TEXT
# define O_TEXT          0
#endif

#ifndef ARG_MAX
# define ARG_MAX 256
#endif

#ifndef MAP_FILE
# define MAP_FILE    0
#endif

#ifndef MAP_ANON
# define MAP_ANON    0
#endif

#if defined(HAVE_CRT_EXTERNS_H)
# include <crt_externs.h>
# define C_getenventry(i)       ((*_NSGetEnviron())[ i ])
#elif defined(C_MACOSX)
# define C_getenventry(i)       NULL
#else
extern char **environ;
# define C_getenventry(i)       (environ[ i ])
#endif

#ifndef ENV_MAX
# define ENV_MAX        1024
#endif

#ifndef FILENAME_MAX
# define FILENAME_MAX          1024
#endif

static C_TLS char *C_exec_args[ ARG_MAX ];
static C_TLS char *C_exec_env[ ENV_MAX ];
static C_TLS struct utsname C_utsname;
static C_TLS struct flock C_flock;
static C_TLS DIR *temphandle;
static C_TLS struct passwd *C_user;
#ifdef HAVE_GRP_H
static C_TLS struct group *C_group;
#else
static C_TLS struct {
  char *gr_name, gr_passwd;
  int gr_gid;
  char *gr_mem[ 1 ];
} C_group = { "", "", 0, { "" } };
#endif

/* Android doesn't provide pw_gecos in the passwd struct */
#ifdef __ANDROID__
# define C_PW_GECOS ("")
#else
# define C_PW_GECOS (C_user->pw_gecos)
#endif

static C_TLS int C_pipefds[ 2 ];
static C_TLS time_t C_secs;
static C_TLS struct timeval C_timeval;
static C_TLS char C_hostbuf[ 256 ];
static C_TLS struct stat C_statbuf;

#define C_mkdir(str)        C_fix(mkdir(C_c_string(str), S_IRWXU | S_IRWXG | S_IRWXO))
#define C_fchdir(fd)        C_fix(fchdir(C_unfix(fd)))
#define C_chdir(str)        C_fix(chdir(C_c_string(str)))
#define C_rmdir(str)        C_fix(rmdir(C_c_string(str)))

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)                        C_fix(pclose(C_port_file(p)))

#define C_fork              fork
#define C_waitpid(id, o)    C_fix(waitpid(C_unfix(id), &C_wait_status, C_unfix(o)))
#define C_getppid           getppid
#define C_kill(id, s)       C_fix(kill(C_unfix(id), C_unfix(s)))
#define C_getuid            getuid
#define C_getgid            getgid
#define C_geteuid           geteuid
#define C_getegid           getegid
#define C_chown(fn, u, g)   C_fix(chown(C_data_pointer(fn), C_unfix(u), C_unfix(g)))
#define C_chmod(fn, m)      C_fix(chmod(C_data_pointer(fn), C_unfix(m)))
#define C_setuid(id)        C_fix(setuid(C_unfix(id)))
#define C_setgid(id)        C_fix(setgid(C_unfix(id)))
#define C_seteuid(id)       C_fix(seteuid(C_unfix(id)))
#define C_setegid(id)       C_fix(setegid(C_unfix(id)))
#define C_setsid(dummy)     C_fix(setsid())
#define C_setpgid(x, y)     C_fix(setpgid(C_unfix(x), C_unfix(y)))
#define C_getpgid(x)        C_fix(getpgid(C_unfix(x)))
#define C_symlink(o, n)     C_fix(symlink(C_data_pointer(o), C_data_pointer(n)))
#define C_do_readlink(f, b)    C_fix(readlink(C_data_pointer(f), C_data_pointer(b), FILENAME_MAX))
#define C_getpwnam(n)       C_mk_bool((C_user = getpwnam((char *)C_data_pointer(n))) != NULL)
#define C_getpwuid(u)       C_mk_bool((C_user = getpwuid(C_unfix(u))) != NULL)
#if !defined(__ANDROID__) && defined(HAVE_GRP_H)
#define C_getgrnam(n)       C_mk_bool((C_group = getgrnam((char *)C_data_pointer(n))) != NULL)
#define C_getgrgid(u)       C_mk_bool((C_group = getgrgid(C_unfix(u))) != NULL)
#else
#define C_getgrnam(n)       C_SCHEME_FALSE
#define C_getgrgid(n)       C_SCHEME_FALSE
#endif
#define C_pipe(d)           C_fix(pipe(C_pipefds))
#define C_truncate(f, n)    C_fix(truncate((char *)C_data_pointer(f), C_num_to_int(n)))
#define C_ftruncate(f, n)   C_fix(ftruncate(C_unfix(f), C_num_to_int(n)))
#define C_uname             C_fix(uname(&C_utsname))
#define C_alarm             alarm
#define C_setvbuf(p, m, s)  C_fix(setvbuf(C_port_file(p), NULL, C_unfix(m), C_unfix(s)))
#define C_test_access(fn, m)     C_fix(access((char *)C_data_pointer(fn), C_unfix(m)))
#define C_close(fd)         C_fix(close(C_unfix(fd)))
#define C_sleep             sleep
#define C_umask(m)          C_fix(umask(C_unfix(m)))

#define C_lstat(fn)         C_fix(lstat((char *)C_data_pointer(fn), &C_statbuf))

static void C_fcall C_set_arg_string(char **where, int i, char *a, int len) {
  char *ptr;
  if(a != NULL) {
    ptr = (char *)C_malloc(len + 1);
    C_memcpy(ptr, a, len);
    ptr[ len ] = '\0';
    /* Can't barf() here, so the NUL byte check happens in Scheme */
  }
  else ptr = NULL;
  where[ i ] = ptr;
}

static void C_fcall C_free_arg_string(char **where) {
  while((*where) != NULL) C_free(*(where++));
}

#define C_set_exec_arg(i, a, len)	C_set_arg_string(C_exec_args, i, a, len)
#define C_free_exec_args()		C_free_arg_string(C_exec_args)
#define C_set_exec_env(i, a, len)	C_set_arg_string(C_exec_env, i, a, len)
#define C_free_exec_env()		C_free_arg_string(C_exec_env)

#define C_execvp(f)         C_fix(execvp(C_data_pointer(f), C_exec_args))
#define C_execve(f)         C_fix(execve(C_data_pointer(f), C_exec_args, C_exec_env))

#if defined(__FreeBSD__) || defined(C_MACOSX) || defined(__NetBSD__) || defined(__OpenBSD__) || defined(__sgi__) || defined(sgi) || defined(__DragonFly__) || defined(__SUNPRO_C)
static C_TLS int C_uw;
# define C_WIFEXITED(n)      (C_uw = C_unfix(n), C_mk_bool(WIFEXITED(C_uw)))
# define C_WIFSIGNALED(n)    (C_uw = C_unfix(n), C_mk_bool(WIFSIGNALED(C_uw)))
# define C_WIFSTOPPED(n)     (C_uw = C_unfix(n), C_mk_bool(WIFSTOPPED(C_uw)))
# define C_WEXITSTATUS(n)    (C_uw = C_unfix(n), C_fix(WEXITSTATUS(C_uw)))
# define C_WTERMSIG(n)       (C_uw = C_unfix(n), C_fix(WTERMSIG(C_uw)))
# define C_WSTOPSIG(n)       (C_uw = C_unfix(n), C_fix(WSTOPSIG(C_uw)))
#else
# define C_WIFEXITED(n)      C_mk_bool(WIFEXITED(C_unfix(n)))
# define C_WIFSIGNALED(n)    C_mk_bool(WIFSIGNALED(C_unfix(n)))
# define C_WIFSTOPPED(n)     C_mk_bool(WIFSTOPPED(C_unfix(n)))
# define C_WEXITSTATUS(n)    C_fix(WEXITSTATUS(C_unfix(n)))
# define C_WTERMSIG(n)       C_fix(WTERMSIG(C_unfix(n)))
# define C_WSTOPSIG(n)       C_fix(WSTOPSIG(C_unfix(n)))
#endif

#ifdef __CYGWIN__
# define C_mkfifo(fn, m)    C_fix(-1);
#else
# define C_mkfifo(fn, m)    C_fix(mkfifo((char *)C_data_pointer(fn), C_unfix(m)))
#endif

#define C_flock_setup(t, s, n) (C_flock.l_type = C_unfix(t), C_flock.l_start = C_num_to_int(s), C_flock.l_whence = SEEK_SET, C_flock.l_len = C_num_to_int(n), C_SCHEME_UNDEFINED)
#define C_flock_test(p)     (fcntl(fileno(C_port_file(p)), F_GETLK, &C_flock) >= 0 ? (C_flock.l_type == F_UNLCK ? C_fix(0) : C_fix(C_flock.l_pid)) : C_SCHEME_FALSE)
#define C_flock_lock(p)     C_fix(fcntl(fileno(C_port_file(p)), F_SETLK, &C_flock))
#define C_flock_lockw(p)    C_fix(fcntl(fileno(C_port_file(p)), F_SETLKW, &C_flock))

static C_TLS sigset_t C_sigset;
#define C_sigemptyset(d)    (sigemptyset(&C_sigset), C_SCHEME_UNDEFINED)
#define C_sigaddset(s)      (sigaddset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigdelset(s)      (sigdelset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigismember(s)    C_mk_bool(sigismember(&C_sigset, C_unfix(s)))
#define C_sigprocmask_set(d)        C_fix(sigprocmask(SIG_SETMASK, &C_sigset, NULL))
#define C_sigprocmask_block(d)      C_fix(sigprocmask(SIG_BLOCK, &C_sigset, NULL))
#define C_sigprocmask_unblock(d)    C_fix(sigprocmask(SIG_UNBLOCK, &C_sigset, NULL))
#define C_sigprocmask_get(d)        C_fix(sigprocmask(SIG_SETMASK, NULL, &C_sigset))

#define C_open(fn, fl, m)   C_fix(open(C_c_string(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_write(fd, b, n)   C_fix(write(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_mkstemp(t)        C_fix(mkstemp(C_c_string(t)))

#define C_ctime(n)          (C_secs = (n), ctime(&C_secs))

#if defined(__SVR4) || defined(C_MACOSX) || defined(__ANDROID__) || defined(_AIX)
/* Seen here: http://lists.samba.org/archive/samba-technical/2002-November/025571.html */

static time_t C_timegm(struct tm *t)
{
  time_t tl, tb;
  struct tm *tg;

  tl = mktime (t);
  if (tl == -1)
    {
      t->tm_hour--;
      tl = mktime (t);
      if (tl == -1)
        return -1; /* can't deal with output from strptime */
      tl += 3600;
    }
  tg = gmtime (&tl);
  tg->tm_isdst = 0;
  tb = mktime (tg);
  if (tb == -1)
    {
      tg->tm_hour--;
      tb = mktime (tg);
      if (tb == -1)
        return -1; /* can't deal with output from gmtime */
      tb += 3600;
    }
  return (tl - (tb - tl));
}
#else
#define C_timegm timegm
#endif

#define C_a_timegm(ptr, c, v, tm)  C_flonum(ptr, C_timegm(C_tm_set((v), C_data_pointer(tm))))

#ifdef __linux__
extern char *strptime(const char *s, const char *format, struct tm *tm);
extern pid_t getpgid(pid_t pid);
#endif

/* tm_get could be in posix-common, but it's only used in here */
#define cpy_tmstc08_to_tmvec(v, ptm) \
    (C_set_block_item((v), 0, C_fix(((struct tm *)ptm)->tm_sec)), \
    C_set_block_item((v), 1, C_fix((ptm)->tm_min)), \
    C_set_block_item((v), 2, C_fix((ptm)->tm_hour)), \
    C_set_block_item((v), 3, C_fix((ptm)->tm_mday)), \
    C_set_block_item((v), 4, C_fix((ptm)->tm_mon)), \
    C_set_block_item((v), 5, C_fix((ptm)->tm_year)), \
    C_set_block_item((v), 6, C_fix((ptm)->tm_wday)), \
    C_set_block_item((v), 7, C_fix((ptm)->tm_yday)), \
    C_set_block_item((v), 8, ((ptm)->tm_isdst ? C_SCHEME_TRUE : C_SCHEME_FALSE)))

#define cpy_tmstc9_to_tmvec(v, ptm) \
    (C_set_block_item((v), 9, C_fix(-(ptm)->tm_gmtoff)))

#define C_tm_get_08(v, tm)  cpy_tmstc08_to_tmvec( (v), (tm) )
#define C_tm_get_9(v, tm)   cpy_tmstc9_to_tmvec( (v), (tm) )

static C_word
C_tm_get( C_word v, void *tm )
{
  C_tm_get_08( v, (struct tm *)tm );
#if defined(C_GNU_ENV) && !defined(__CYGWIN__) && !defined(__uClinux__)
  C_tm_get_9( v, (struct tm *)tm );
#endif
  return v;
}

#define C_strptime(s, f, v, stm) \
        (strptime(C_c_string(s), C_c_string(f), ((struct tm *)(stm))) ? C_tm_get((v), (stm)) : C_SCHEME_FALSE)

static gid_t *C_groups = NULL;

#define C_get_gid(n)      C_fix(C_groups[ C_unfix(n) ])
#define C_set_gid(n, id)  (C_groups[ C_unfix(n) ] = C_unfix(id), C_SCHEME_UNDEFINED)
#define C_set_groups(n)   C_fix(setgroups(C_unfix(n), C_groups))

#if !defined(__ANDROID__) && defined(TIOCGWINSZ)
static int get_tty_size(int p, int *rows, int *cols)
{
 struct winsize tty_size;
 int r;

 memset(&tty_size, 0, sizeof tty_size);

 r = ioctl(p, TIOCGWINSZ, &tty_size);
 if (r == 0) {
    *rows = tty_size.ws_row;
    *cols = tty_size.ws_col;
 }
 return r;
}
#else
static int get_tty_size(int p, int *rows, int *cols)
{
 *rows = *cols = 0;
 return -1;
}
#endif

static int set_file_mtime(char *filename, C_word tm)
{
  struct utimbuf tb;

  tb.actime = tb.modtime = C_num_to_int(tm);
  return utime(filename, &tb);
}

static C_word C_i_fifo_p(C_word name) 
{
  struct stat buf;
  int res;

  res = stat(C_c_string(name), &buf);

  if(res != 0) {
#ifdef __CYGWIN__
    return C_SCHEME_FALSE;
#else
    if(errno == ENOENT) return C_fix(0);
    else return C_fix(res);
#endif
  }

  if((buf.st_mode & S_IFMT) == S_IFIFO) return C_SCHEME_TRUE;
  else return C_SCHEME_FALSE;
}


static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_scheduler_toplevel)
C_externimport void C_ccall C_scheduler_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(C_irregex_toplevel)
C_externimport void C_ccall C_irregex_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(C_extras_toplevel)
C_externimport void C_ccall C_extras_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(C_files_toplevel)
C_externimport void C_ccall C_files_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(C_ports_toplevel)
C_externimport void C_ccall C_ports_toplevel(C_word c,C_word *av) C_noret;

static C_TLS C_word lf[457];
static double C_possibly_force_alignment;
static C_char C_TLS li0[] C_aligned={C_lihdr(0,0,41),40,112,111,115,105,120,45,101,114,114,111,114,32,116,121,112,101,55,49,32,108,111,99,55,50,32,109,115,103,55,51,32,46,32,97,114,103,115,55,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li1[] C_aligned={C_lihdr(0,0,38),40,35,35,115,121,115,35,115,116,97,116,32,102,105,108,101,56,54,32,108,105,110,107,56,55,32,101,114,114,56,56,32,108,111,99,56,57,41,0,0};
static C_char C_TLS li2[] C_aligned={C_lihdr(0,0,28),40,102,105,108,101,45,115,116,97,116,32,102,49,48,50,32,46,32,116,109,112,49,48,49,49,48,51,41,0,0,0,0};
static C_char C_TLS li3[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,97,99,99,101,115,115,45,116,105,109,101,32,102,49,50,56,41,0};
static C_char C_TLS li4[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,99,104,97,110,103,101,45,116,105,109,101,32,102,49,51,49,41,0};
static C_char C_TLS li5[] C_aligned={C_lihdr(0,0,17),40,102,105,108,101,45,111,119,110,101,114,32,102,49,51,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li6[] C_aligned={C_lihdr(0,0,23),40,102,105,108,101,45,112,101,114,109,105,115,115,105,111,110,115,32,102,49,51,55,41,0};
static C_char C_TLS li7[] C_aligned={C_lihdr(0,0,16),40,102,105,108,101,45,115,105,122,101,32,102,49,52,48,41};
static C_char C_TLS li8[] C_aligned={C_lihdr(0,0,31),40,102,105,108,101,45,116,121,112,101,32,102,105,108,101,49,52,56,32,46,32,116,109,112,49,52,55,49,52,57,41,0};
static C_char C_TLS li9[] C_aligned={C_lihdr(0,0,23),40,114,101,103,117,108,97,114,45,102,105,108,101,63,32,102,105,108,101,49,54,55,41,0};
static C_char C_TLS li10[] C_aligned={C_lihdr(0,0,24),40,115,121,109,98,111,108,105,99,45,108,105,110,107,63,32,102,105,108,101,49,54,57,41};
static C_char C_TLS li11[] C_aligned={C_lihdr(0,0,23),40,98,108,111,99,107,45,100,101,118,105,99,101,63,32,102,105,108,101,49,55,49,41,0};
static C_char C_TLS li12[] C_aligned={C_lihdr(0,0,27),40,99,104,97,114,97,99,116,101,114,45,100,101,118,105,99,101,63,32,102,105,108,101,49,55,51,41,0,0,0,0,0};
static C_char C_TLS li13[] C_aligned={C_lihdr(0,0,16),40,102,95,50,57,52,51,32,102,105,108,101,49,55,53,41};
static C_char C_TLS li14[] C_aligned={C_lihdr(0,0,17),40,115,111,99,107,101,116,63,32,102,105,108,101,49,55,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li15[] C_aligned={C_lihdr(0,0,20),40,100,105,114,101,99,116,111,114,121,63,32,102,105,108,101,49,55,57,41,0,0,0,0};
static C_char C_TLS li16[] C_aligned={C_lihdr(0,0,47),40,115,101,116,45,102,105,108,101,45,112,111,115,105,116,105,111,110,33,32,112,111,114,116,49,56,52,32,112,111,115,49,56,53,32,46,32,119,104,101,110,99,101,49,56,54,41,0};
static C_char C_TLS li17[] C_aligned={C_lihdr(0,0,25),40,109,111,100,101,32,105,110,112,50,48,56,32,109,50,48,57,32,108,111,99,50,49,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li18[] C_aligned={C_lihdr(0,0,32),40,99,104,101,99,107,32,108,111,99,50,50,50,32,102,100,50,50,51,32,105,110,112,50,50,52,32,114,50,50,53,41};
static C_char C_TLS li19[] C_aligned={C_lihdr(0,0,31),40,111,112,101,110,45,105,110,112,117,116,45,102,105,108,101,42,32,102,100,50,50,56,32,46,32,109,50,50,57,41,0};
static C_char C_TLS li20[] C_aligned={C_lihdr(0,0,32),40,111,112,101,110,45,111,117,116,112,117,116,45,102,105,108,101,42,32,102,100,50,51,49,32,46,32,109,50,51,50,41};
static C_char C_TLS li21[] C_aligned={C_lihdr(0,0,22),40,112,111,114,116,45,62,102,105,108,101,110,111,32,112,111,114,116,50,51,56,41,0,0};
static C_char C_TLS li22[] C_aligned={C_lihdr(0,0,34),40,100,117,112,108,105,99,97,116,101,45,102,105,108,101,110,111,32,111,108,100,50,52,55,32,46,32,110,101,119,50,52,56,41,0,0,0,0,0,0};
static C_char C_TLS li23[] C_aligned={C_lihdr(0,0,31),40,99,117,114,114,101,110,116,45,100,105,114,101,99,116,111,114,121,32,46,32,116,109,112,50,53,57,50,54,48,41,0};
static C_char C_TLS li24[] C_aligned={C_lihdr(0,0,14),40,114,109,100,105,114,32,100,105,114,50,56,55,41,0,0};
static C_char C_TLS li25[] C_aligned={C_lihdr(0,0,11),40,103,50,57,51,32,102,51,48,50,41,0,0,0,0,0};
static C_char C_TLS li26[] C_aligned={C_lihdr(0,0,26),40,102,111,114,45,101,97,99,104,45,108,111,111,112,50,57,50,32,103,50,57,57,51,49,48,41,0,0,0,0,0,0};
static C_char C_TLS li27[] C_aligned={C_lihdr(0,0,38),40,100,101,108,101,116,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,50,55,57,32,46,32,116,109,112,50,55,56,50,56,48,41,0,0};
static C_char C_TLS li28[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,100,105,114,51,51,52,41,0,0,0};
static C_char C_TLS li29[] C_aligned={C_lihdr(0,0,7),40,97,51,51,55,52,41,0};
static C_char C_TLS li30[] C_aligned={C_lihdr(0,0,47),40,97,51,51,56,48,32,100,105,114,51,52,50,51,52,51,51,52,56,32,102,105,108,101,51,52,52,51,52,53,51,52,57,32,101,120,116,51,52,54,51,52,55,51,53,48,41,0};
static C_char C_TLS li31[] C_aligned={C_lihdr(0,0,38),40,99,114,101,97,116,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,51,50,51,32,46,32,116,109,112,51,50,50,51,50,52,41,0,0};
static C_char C_TLS li32[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li33[] C_aligned={C_lihdr(0,0,23),40,100,105,114,101,99,116,111,114,121,32,46,32,116,109,112,51,54,53,51,54,54,41,0};
static C_char C_TLS li34[] C_aligned={C_lihdr(0,0,7),40,97,51,53,56,49,41,0};
static C_char C_TLS li35[] C_aligned={C_lihdr(0,0,11),40,103,52,50,56,32,109,52,51,48,41,0,0,0,0,0};
static C_char C_TLS li36[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,102,110,115,52,50,49,41,0,0,0};
static C_char C_TLS li37[] C_aligned={C_lihdr(0,0,46),40,97,51,53,56,55,32,100,105,114,52,48,52,52,48,53,52,49,48,32,102,105,108,52,48,54,52,48,55,52,49,49,32,101,120,116,52,48,56,52,48,57,52,49,50,41,0,0};
static C_char C_TLS li38[] C_aligned={C_lihdr(0,0,20),40,99,111,110,99,45,108,111,111,112,32,112,97,116,104,115,52,48,50,41,0,0,0,0};
static C_char C_TLS li39[] C_aligned={C_lihdr(0,0,17),40,103,108,111,98,32,46,32,112,97,116,104,115,52,48,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li40[] C_aligned={C_lihdr(0,0,7),40,97,51,55,53,52,41,0};
static C_char C_TLS li41[] C_aligned={C_lihdr(0,0,7),40,97,51,55,53,57,41,0};
static C_char C_TLS li42[] C_aligned={C_lihdr(0,0,7),40,97,51,55,55,57,41,0};
static C_char C_TLS li43[] C_aligned={C_lihdr(0,0,24),40,108,111,111,112,32,100,105,114,52,53,55,32,102,115,52,53,56,32,114,52,53,57,41};
static C_char C_TLS li44[] C_aligned={C_lihdr(0,0,13),40,102,95,51,56,50,53,32,120,52,53,53,41,0,0,0};
static C_char C_TLS li45[] C_aligned={C_lihdr(0,0,15),40,102,95,51,56,52,49,32,46,32,95,52,53,50,41,0};
static C_char C_TLS li46[] C_aligned={C_lihdr(0,0,15),40,102,95,51,56,51,51,32,46,32,95,52,53,49,41,0};
static C_char C_TLS li47[] C_aligned={C_lihdr(0,0,7),40,97,51,56,55,48,41,0};
static C_char C_TLS li48[] C_aligned={C_lihdr(0,0,7),40,97,51,56,55,51,41,0};
static C_char C_TLS li49[] C_aligned={C_lihdr(0,0,7),40,97,51,56,55,54,41,0};
static C_char C_TLS li50[] C_aligned={C_lihdr(0,0,7),40,97,51,56,55,57,41,0};
static C_char C_TLS li51[] C_aligned={C_lihdr(0,0,18),40,102,95,51,56,56,53,32,120,52,57,53,32,121,52,57,54,41,0,0,0,0,0,0};
static C_char C_TLS li52[] C_aligned={C_lihdr(0,0,7),40,97,51,56,56,50,41,0};
static C_char C_TLS li53[] C_aligned={C_lihdr(0,0,15),40,102,95,51,56,57,51,32,46,32,95,52,57,51,41,0};
static C_char C_TLS li54[] C_aligned={C_lihdr(0,0,7),40,97,51,56,57,48,41,0};
static C_char C_TLS li55[] C_aligned={C_lihdr(0,0,31),40,102,105,110,100,45,102,105,108,101,115,32,100,105,114,52,57,48,32,46,32,116,109,112,52,56,57,52,57,49,41,0};
static C_char C_TLS li56[] C_aligned={C_lihdr(0,0,32),40,99,104,101,99,107,45,116,105,109,101,45,118,101,99,116,111,114,32,108,111,99,53,50,50,32,116,109,53,50,51,41};
static C_char C_TLS li57[] C_aligned={C_lihdr(0,0,33),40,115,101,99,111,110,100,115,45,62,108,111,99,97,108,45,116,105,109,101,32,46,32,116,109,112,53,51,48,53,51,49,41,0,0,0,0,0,0,0};
static C_char C_TLS li58[] C_aligned={C_lihdr(0,0,31),40,115,101,99,111,110,100,115,45,62,117,116,99,45,116,105,109,101,32,46,32,116,109,112,53,52,51,53,52,52,41,0};
static C_char C_TLS li59[] C_aligned={C_lihdr(0,0,29),40,115,101,99,111,110,100,115,45,62,115,116,114,105,110,103,32,46,32,116,109,112,53,54,50,53,54,51,41,0,0,0};
static C_char C_TLS li60[] C_aligned={C_lihdr(0,0,27),40,108,111,99,97,108,45,116,105,109,101,45,62,115,101,99,111,110,100,115,32,116,109,53,55,52,41,0,0,0,0,0};
static C_char C_TLS li61[] C_aligned={C_lihdr(0,0,32),40,116,105,109,101,45,62,115,116,114,105,110,103,32,116,109,54,48,55,32,46,32,116,109,112,54,48,54,54,48,56,41};
static C_char C_TLS li62[] C_aligned={C_lihdr(0,0,22),40,115,101,116,101,110,118,32,118,97,114,54,50,49,32,118,97,108,54,50,50,41,0,0};
static C_char C_TLS li63[] C_aligned={C_lihdr(0,0,17),40,117,110,115,101,116,101,110,118,32,118,97,114,54,50,55,41,0,0,0,0,0,0,0};
static C_char C_TLS li64[] C_aligned={C_lihdr(0,0,11),40,115,99,97,110,32,106,54,52,49,41,0,0,0,0,0};
static C_char C_TLS li65[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,105,54,51,56,41,0,0,0,0,0};
static C_char C_TLS li66[] C_aligned={C_lihdr(0,0,27),40,103,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,115,41,0,0,0,0,0};
static C_char C_TLS li67[] C_aligned={C_lihdr(0,0,36),40,115,101,116,45,115,105,103,110,97,108,45,104,97,110,100,108,101,114,33,32,115,105,103,54,52,53,32,112,114,111,99,54,52,54,41,0,0,0,0};
static C_char C_TLS li68[] C_aligned={C_lihdr(0,0,20),40,99,117,114,114,101,110,116,45,112,114,111,99,101,115,115,45,105,100,41,0,0,0,0};
static C_char C_TLS li69[] C_aligned={C_lihdr(0,0,7),40,97,52,50,54,53,41,0};
static C_char C_TLS li70[] C_aligned={C_lihdr(0,0,33),40,97,52,50,55,49,32,101,112,105,100,54,55,48,32,101,110,111,114,109,54,55,49,32,101,99,111,100,101,54,55,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li71[] C_aligned={C_lihdr(0,0,24),40,112,114,111,99,101,115,115,45,119,97,105,116,32,46,32,97,114,103,115,54,53,53,41};
static C_char C_TLS li72[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,102,105,108,101,45,110,111,110,98,108,111,99,107,105,110,103,33,32,102,100,55,50,52,55,50,55,41,0,0,0,0,0,0};
static C_char C_TLS li73[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,102,105,108,101,45,115,101,108,101,99,116,45,111,110,101,32,105,110,116,55,50,57,55,51,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li74[] C_aligned={C_lihdr(0,0,39),40,102,105,108,101,45,99,111,110,116,114,111,108,32,102,100,55,56,52,32,99,109,100,55,56,53,32,46,32,116,109,112,55,56,51,55,56,54,41,0};
static C_char C_TLS li75[] C_aligned={C_lihdr(0,0,42),40,102,105,108,101,45,111,112,101,110,32,102,105,108,101,110,97,109,101,55,57,55,32,102,108,97,103,115,55,57,56,32,46,32,109,111,100,101,55,57,57,41,0,0,0,0,0,0};
static C_char C_TLS li76[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li77[] C_aligned={C_lihdr(0,0,18),40,102,105,108,101,45,99,108,111,115,101,32,102,100,56,48,55,41,0,0,0,0,0,0};
static C_char C_TLS li78[] C_aligned={C_lihdr(0,0,37),40,102,105,108,101,45,114,101,97,100,32,102,100,56,49,54,32,115,105,122,101,56,49,55,32,46,32,98,117,102,102,101,114,56,49,56,41,0,0,0};
static C_char C_TLS li79[] C_aligned={C_lihdr(0,0,38),40,102,105,108,101,45,119,114,105,116,101,32,102,100,56,50,55,32,98,117,102,102,101,114,56,50,56,32,46,32,115,105,122,101,56,50,57,41,0,0};
static C_char C_TLS li80[] C_aligned={C_lihdr(0,0,26),40,102,105,108,101,45,109,107,115,116,101,109,112,32,116,101,109,112,108,97,116,101,56,51,56,41,0,0,0,0,0,0};
static C_char C_TLS li81[] C_aligned={C_lihdr(0,0,20),40,100,111,108,111,111,112,56,54,54,32,102,100,115,114,108,56,54,57,41,0,0,0,0};
static C_char C_TLS li82[] C_aligned={C_lihdr(0,0,20),40,100,111,108,111,111,112,56,56,52,32,102,100,115,119,108,56,56,55,41,0,0,0,0};
static C_char C_TLS li83[] C_aligned={C_lihdr(0,0,23),40,108,112,32,105,57,52,49,32,114,101,115,57,52,50,32,102,100,115,57,52,51,41,0};
static C_char C_TLS li84[] C_aligned={C_lihdr(0,0,23),40,108,112,32,105,57,50,50,32,114,101,115,57,50,51,32,102,100,115,57,50,52,41,0};
static C_char C_TLS li85[] C_aligned={C_lihdr(0,0,42),40,102,105,108,101,45,115,101,108,101,99,116,32,102,100,115,114,56,52,53,32,102,100,115,119,56,52,54,32,46,32,116,105,109,101,111,117,116,56,52,55,41,0,0,0,0,0,0};
static C_char C_TLS li86[] C_aligned={C_lihdr(0,0,26),40,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,57,54,55,41,0,0,0,0,0,0};
static C_char C_TLS li87[] C_aligned={C_lihdr(0,0,25),40,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,42,32,102,100,57,55,50,41,0,0,0,0,0,0,0};
static C_char C_TLS li88[] C_aligned={C_lihdr(0,0,33),40,99,104,101,99,107,32,108,111,99,57,56,48,32,99,109,100,57,56,49,32,105,110,112,57,56,50,32,114,57,56,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li89[] C_aligned={C_lihdr(0,0,31),40,111,112,101,110,45,105,110,112,117,116,45,112,105,112,101,32,99,109,100,57,56,54,32,46,32,109,57,56,55,41,0};
static C_char C_TLS li90[] C_aligned={C_lihdr(0,0,32),40,111,112,101,110,45,111,117,116,112,117,116,45,112,105,112,101,32,99,109,100,57,57,54,32,46,32,109,57,57,55,41};
static C_char C_TLS li91[] C_aligned={C_lihdr(0,0,27),40,99,108,111,115,101,45,105,110,112,117,116,45,112,105,112,101,32,112,111,114,116,49,48,48,54,41,0,0,0,0,0};
static C_char C_TLS li92[] C_aligned={C_lihdr(0,0,28),40,99,108,111,115,101,45,111,117,116,112,117,116,45,112,105,112,101,32,112,111,114,116,49,48,49,48,41,0,0,0,0};
static C_char C_TLS li93[] C_aligned={C_lihdr(0,0,7),40,97,53,49,52,56,41,0};
static C_char C_TLS li94[] C_aligned={C_lihdr(0,0,21),40,97,53,49,53,52,32,46,32,114,101,115,117,108,116,115,49,48,50,53,41,0,0,0};
static C_char C_TLS li95[] C_aligned={C_lihdr(0,0,50),40,99,97,108,108,45,119,105,116,104,45,105,110,112,117,116,45,112,105,112,101,32,99,109,100,49,48,50,49,32,112,114,111,99,49,48,50,50,32,46,32,109,111,100,101,49,48,50,51,41,0,0,0,0,0,0};
static C_char C_TLS li96[] C_aligned={C_lihdr(0,0,7),40,97,53,49,55,50,41,0};
static C_char C_TLS li97[] C_aligned={C_lihdr(0,0,21),40,97,53,49,55,56,32,46,32,114,101,115,117,108,116,115,49,48,51,50,41,0,0,0};
static C_char C_TLS li98[] C_aligned={C_lihdr(0,0,51),40,99,97,108,108,45,119,105,116,104,45,111,117,116,112,117,116,45,112,105,112,101,32,99,109,100,49,48,50,56,32,112,114,111,99,49,48,50,57,32,46,32,109,111,100,101,49,48,51,48,41,0,0,0,0,0};
static C_char C_TLS li99[] C_aligned={C_lihdr(0,0,7),40,97,53,49,57,54,41,0};
static C_char C_TLS li100[] C_aligned={C_lihdr(0,0,21),40,97,53,50,48,55,32,46,32,114,101,115,117,108,116,115,49,48,52,55,41,0,0,0};
static C_char C_TLS li101[] C_aligned={C_lihdr(0,0,7),40,97,53,50,48,49,41,0};
static C_char C_TLS li102[] C_aligned={C_lihdr(0,0,7),40,97,53,50,49,54,41,0};
static C_char C_TLS li103[] C_aligned={C_lihdr(0,0,51),40,119,105,116,104,45,105,110,112,117,116,45,102,114,111,109,45,112,105,112,101,32,99,109,100,49,48,51,53,32,116,104,117,110,107,49,48,51,54,32,46,32,109,111,100,101,49,48,51,55,41,0,0,0,0,0};
static C_char C_TLS li104[] C_aligned={C_lihdr(0,0,7),40,97,53,50,51,48,41,0};
static C_char C_TLS li105[] C_aligned={C_lihdr(0,0,21),40,97,53,50,52,49,32,46,32,114,101,115,117,108,116,115,49,48,54,52,41,0,0,0};
static C_char C_TLS li106[] C_aligned={C_lihdr(0,0,7),40,97,53,50,51,53,41,0};
static C_char C_TLS li107[] C_aligned={C_lihdr(0,0,7),40,97,53,50,53,48,41,0};
static C_char C_TLS li108[] C_aligned={C_lihdr(0,0,50),40,119,105,116,104,45,111,117,116,112,117,116,45,116,111,45,112,105,112,101,32,99,109,100,49,48,53,50,32,116,104,117,110,107,49,48,53,51,32,46,32,109,111,100,101,49,48,53,52,41,0,0,0,0,0,0};
static C_char C_TLS li109[] C_aligned={C_lihdr(0,0,13),40,99,114,101,97,116,101,45,112,105,112,101,41,0,0,0};
static C_char C_TLS li110[] C_aligned={C_lihdr(0,0,19),40,102,111,114,45,101,97,99,104,45,108,111,111,112,49,49,48,50,41,0,0,0,0,0};
static C_char C_TLS li111[] C_aligned={C_lihdr(0,0,27),40,115,101,116,45,115,105,103,110,97,108,45,109,97,115,107,33,32,115,105,103,115,49,48,57,57,41,0,0,0,0,0};
static C_char C_TLS li112[] C_aligned={C_lihdr(0,0,24),40,115,105,103,110,97,108,45,109,97,115,107,101,100,63,32,115,105,103,49,49,51,48,41};
static C_char C_TLS li113[] C_aligned={C_lihdr(0,0,22),40,115,105,103,110,97,108,45,109,97,115,107,33,32,115,105,103,49,49,51,52,41,0,0};
static C_char C_TLS li114[] C_aligned={C_lihdr(0,0,24),40,115,105,103,110,97,108,45,117,110,109,97,115,107,33,32,115,105,103,49,49,51,57,41};
static C_char C_TLS li115[] C_aligned={C_lihdr(0,0,20),40,115,121,115,116,101,109,45,105,110,102,111,114,109,97,116,105,111,110,41,0,0,0,0};
static C_char C_TLS li116[] C_aligned={C_lihdr(0,0,41),40,117,115,101,114,45,105,110,102,111,114,109,97,116,105,111,110,32,117,115,101,114,49,49,55,50,32,46,32,116,109,112,49,49,55,49,49,49,55,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li117[] C_aligned={C_lihdr(0,0,19),40,99,117,114,114,101,110,116,45,117,115,101,114,45,110,97,109,101,41,0,0,0,0,0};
static C_char C_TLS li118[] C_aligned={C_lihdr(0,0,29),40,99,117,114,114,101,110,116,45,101,102,102,101,99,116,105,118,101,45,117,115,101,114,45,110,97,109,101,41,0,0,0};
static C_char C_TLS li119[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,105,49,50,49,49,41,0,0,0,0};
static C_char C_TLS li120[] C_aligned={C_lihdr(0,0,43),40,103,114,111,117,112,45,105,110,102,111,114,109,97,116,105,111,110,32,103,114,111,117,112,49,49,57,56,32,46,32,116,109,112,49,49,57,55,49,49,57,57,41,0,0,0,0,0};
static C_char C_TLS li121[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,105,49,50,51,48,41,0,0,0,0};
static C_char C_TLS li122[] C_aligned={C_lihdr(0,0,12),40,103,101,116,45,103,114,111,117,112,115,41,0,0,0,0};
static C_char C_TLS li123[] C_aligned={C_lihdr(0,0,26),40,100,111,108,111,111,112,49,50,51,55,32,108,115,116,49,50,51,57,32,105,49,50,52,48,41,0,0,0,0,0,0};
static C_char C_TLS li124[] C_aligned={C_lihdr(0,0,22),40,115,101,116,45,103,114,111,117,112,115,33,32,108,115,116,48,49,50,51,54,41,0,0};
static C_char C_TLS li125[] C_aligned={C_lihdr(0,0,35),40,105,110,105,116,105,97,108,105,122,101,45,103,114,111,117,112,115,32,117,115,101,114,49,50,53,55,32,105,100,49,50,53,56,41,0,0,0,0,0};
static C_char C_TLS li126[] C_aligned={C_lihdr(0,0,34),40,99,104,97,110,103,101,45,102,105,108,101,45,109,111,100,101,32,102,110,97,109,101,49,51,48,50,32,109,49,51,48,51,41,0,0,0,0,0,0};
static C_char C_TLS li127[] C_aligned={C_lihdr(0,0,42),40,99,104,97,110,103,101,45,102,105,108,101,45,111,119,110,101,114,32,102,110,49,51,48,55,32,117,105,100,49,51,48,56,32,103,105,100,49,51,48,57,41,0,0,0,0,0,0};
static C_char C_TLS li128[] C_aligned={C_lihdr(0,0,36),40,99,104,101,99,107,32,102,105,108,101,110,97,109,101,49,51,49,52,32,97,99,99,49,51,49,53,32,108,111,99,49,51,49,54,41,0,0,0,0};
static C_char C_TLS li129[] C_aligned={C_lihdr(0,0,32),40,102,105,108,101,45,114,101,97,100,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,49,51,50,48,41};
static C_char C_TLS li130[] C_aligned={C_lihdr(0,0,33),40,102,105,108,101,45,119,114,105,116,101,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,49,51,50,49,41,0,0,0,0,0,0,0};
static C_char C_TLS li131[] C_aligned={C_lihdr(0,0,35),40,102,105,108,101,45,101,120,101,99,117,116,101,45,97,99,99,101,115,115,63,32,102,105,108,101,110,97,109,101,49,51,50,50,41,0,0,0,0,0};
static C_char C_TLS li132[] C_aligned={C_lihdr(0,0,16),40,99,114,101,97,116,101,45,115,101,115,115,105,111,110,41};
static C_char C_TLS li133[] C_aligned={C_lihdr(0,0,38),40,99,114,101,97,116,101,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,111,108,100,49,51,52,50,32,110,101,119,49,51,52,51,41,0,0};
static C_char C_TLS li134[] C_aligned={C_lihdr(0,0,49),40,35,35,115,121,115,35,114,101,97,100,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,102,110,97,109,101,49,51,52,56,32,108,111,99,97,116,105,111,110,49,51,52,57,41,0,0,0,0,0,0,0};
static C_char C_TLS li135[] C_aligned={C_lihdr(0,0,7),40,97,53,57,57,49,41,0};
static C_char C_TLS li136[] C_aligned={C_lihdr(0,0,32),40,108,111,111,112,32,99,111,109,112,111,110,101,110,116,115,49,51,54,56,32,114,101,115,117,108,116,49,51,54,57,41};
static C_char C_TLS li137[] C_aligned={C_lihdr(0,0,67),40,97,53,57,57,55,32,98,97,115,101,45,111,114,105,103,105,110,49,51,54,52,32,98,97,115,101,45,100,105,114,101,99,116,111,114,121,49,51,54,53,32,100,105,114,101,99,116,111,114,121,45,99,111,109,112,111,110,101,110,116,115,49,51,54,54,41,0,0,0,0,0};
static C_char C_TLS li138[] C_aligned={C_lihdr(0,0,44),40,114,101,97,100,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,102,110,97,109,101,49,51,53,55,32,46,32,116,109,112,49,51,53,54,49,51,53,56,41,0,0,0,0};
static C_char C_TLS li139[] C_aligned={C_lihdr(0,0,27),40,102,105,108,101,45,108,105,110,107,32,111,108,100,49,51,57,50,32,110,101,119,49,51,57,51,41,0,0,0,0,0};
static C_char C_TLS li140[] C_aligned={C_lihdr(0,0,8),40,114,101,97,100,121,63,41};
static C_char C_TLS li141[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li142[] C_aligned={C_lihdr(0,0,7),40,102,101,116,99,104,41,0};
static C_char C_TLS li143[] C_aligned={C_lihdr(0,0,7),40,97,54,50,57,51,41,0};
static C_char C_TLS li144[] C_aligned={C_lihdr(0,0,7),40,97,54,51,49,56,41,0};
static C_char C_TLS li145[] C_aligned={C_lihdr(0,0,7),40,97,54,51,51,48,41,0};
static C_char C_TLS li146[] C_aligned={C_lihdr(0,0,7),40,97,54,51,53,50,41,0};
static C_char C_TLS li147[] C_aligned={C_lihdr(0,0,28),40,108,111,111,112,32,110,49,52,55,50,32,109,49,52,55,51,32,115,116,97,114,116,49,52,55,52,41,0,0,0,0};
static C_char C_TLS li148[] C_aligned={C_lihdr(0,0,41),40,97,54,51,54,55,32,112,111,114,116,49,52,54,55,32,110,49,52,54,56,32,100,101,115,116,49,52,54,57,32,115,116,97,114,116,49,52,55,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li149[] C_aligned={C_lihdr(0,0,15),40,97,54,52,55,49,32,112,111,115,49,52,57,52,41,0};
static C_char C_TLS li150[] C_aligned={C_lihdr(0,0,7),40,97,54,52,54,49,41,0};
static C_char C_TLS li151[] C_aligned={C_lihdr(0,0,40),40,97,54,53,49,55,32,110,101,120,116,49,53,48,50,32,108,105,110,101,49,53,48,51,32,102,117,108,108,45,108,105,110,101,63,49,53,48,52,41};
static C_char C_TLS li152[] C_aligned={C_lihdr(0,0,23),40,97,54,52,52,51,32,112,49,52,56,56,32,108,105,109,105,116,49,52,56,57,41,0};
static C_char C_TLS li153[] C_aligned={C_lihdr(0,0,16),40,97,54,53,54,54,32,112,111,114,116,49,53,48,57,41};
static C_char C_TLS li154[] C_aligned={C_lihdr(0,0,62),40,35,35,115,121,115,35,99,117,115,116,111,109,45,105,110,112,117,116,45,112,111,114,116,32,108,111,99,49,52,48,50,32,110,97,109,49,52,48,51,32,102,100,49,52,48,52,32,46,32,116,109,112,49,52,48,49,49,52,48,53,41,0,0};
static C_char C_TLS li155[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char C_TLS li156[] C_aligned={C_lihdr(0,0,26),40,112,111,107,101,49,53,51,55,32,115,116,114,49,53,52,51,32,108,101,110,49,53,52,52,41,0,0,0,0,0,0};
static C_char C_TLS li157[] C_aligned={C_lihdr(0,0,15),40,97,54,55,52,50,32,115,116,114,49,53,56,49,41,0};
static C_char C_TLS li158[] C_aligned={C_lihdr(0,0,7),40,97,54,55,52,56,41,0};
static C_char C_TLS li159[] C_aligned={C_lihdr(0,0,7),40,97,54,55,55,48,41,0};
static C_char C_TLS li160[] C_aligned={C_lihdr(0,0,16),40,102,95,54,55,55,57,32,115,116,114,49,53,54,49,41};
static C_char C_TLS li161[] C_aligned={C_lihdr(0,0,32),40,108,111,111,112,32,114,101,109,49,53,54,54,32,115,116,97,114,116,49,53,54,55,32,108,101,110,49,53,54,56,41};
static C_char C_TLS li162[] C_aligned={C_lihdr(0,0,16),40,102,95,54,55,57,52,32,115,116,114,49,53,54,52,41};
static C_char C_TLS li163[] C_aligned={C_lihdr(0,0,63),40,35,35,115,121,115,35,99,117,115,116,111,109,45,111,117,116,112,117,116,45,112,111,114,116,32,108,111,99,49,53,50,49,32,110,97,109,49,53,50,50,32,102,100,49,53,50,51,32,46,32,116,109,112,49,53,50,48,49,53,50,52,41,0};
static C_char C_TLS li164[] C_aligned={C_lihdr(0,0,33),40,102,105,108,101,45,116,114,117,110,99,97,116,101,32,102,110,97,109,101,49,53,56,57,32,111,102,102,49,53,57,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li165[] C_aligned={C_lihdr(0,0,33),40,115,101,116,117,112,32,112,111,114,116,49,53,57,56,32,97,114,103,115,49,53,57,57,32,108,111,99,49,54,48,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li166[] C_aligned={C_lihdr(0,0,30),40,101,114,114,32,109,115,103,49,54,49,53,32,108,111,99,107,49,54,49,54,32,108,111,99,49,54,49,55,41,0,0};
static C_char C_TLS li167[] C_aligned={C_lihdr(0,0,31),40,102,105,108,101,45,108,111,99,107,32,112,111,114,116,49,54,49,56,32,46,32,97,114,103,115,49,54,49,57,41,0};
static C_char C_TLS li168[] C_aligned={C_lihdr(0,0,40),40,102,105,108,101,45,108,111,99,107,47,98,108,111,99,107,105,110,103,32,112,111,114,116,49,54,50,49,32,46,32,97,114,103,115,49,54,50,50,41};
static C_char C_TLS li169[] C_aligned={C_lihdr(0,0,36),40,102,105,108,101,45,116,101,115,116,45,108,111,99,107,32,112,111,114,116,49,54,50,52,32,46,32,97,114,103,115,49,54,50,53,41,0,0,0,0};
static C_char C_TLS li170[] C_aligned={C_lihdr(0,0,22),40,102,105,108,101,45,117,110,108,111,99,107,32,108,111,99,107,49,54,52,50,41,0,0};
static C_char C_TLS li171[] C_aligned={C_lihdr(0,0,34),40,99,114,101,97,116,101,45,102,105,102,111,32,102,110,97,109,101,49,54,52,54,32,46,32,109,111,100,101,49,54,52,55,41,0,0,0,0,0,0};
static C_char C_TLS li172[] C_aligned={C_lihdr(0,0,20),40,102,105,102,111,63,32,102,105,108,101,110,97,109,101,49,54,53,50,41,0,0,0,0};
static C_char C_TLS li173[] C_aligned={C_lihdr(0,0,72),40,109,97,112,45,102,105,108,101,45,116,111,45,109,101,109,111,114,121,32,97,100,100,114,49,54,56,56,32,108,101,110,49,54,56,57,32,112,114,111,116,49,54,57,48,32,102,108,97,103,49,54,57,49,32,102,100,49,54,57,50,32,46,32,111,102,102,49,54,57,51,41};
static C_char C_TLS li174[] C_aligned={C_lihdr(0,0,43),40,117,110,109,97,112,45,102,105,108,101,45,102,114,111,109,45,109,101,109,111,114,121,32,109,109,97,112,49,55,49,48,32,46,32,108,101,110,49,55,49,49,41,0,0,0,0,0};
static C_char C_TLS li175[] C_aligned={C_lihdr(0,0,37),40,109,101,109,111,114,121,45,109,97,112,112,101,100,45,102,105,108,101,45,112,111,105,110,116,101,114,32,109,109,97,112,49,55,49,53,41,0,0,0};
static C_char C_TLS li176[] C_aligned={C_lihdr(0,0,27),40,109,101,109,111,114,121,45,109,97,112,112,101,100,45,102,105,108,101,63,32,120,49,55,49,56,41,0,0,0,0,0};
static C_char C_TLS li177[] C_aligned={C_lihdr(0,0,36),40,115,116,114,105,110,103,45,62,116,105,109,101,32,116,105,109,49,55,52,48,32,46,32,116,109,112,49,55,51,57,49,55,52,49,41,0,0,0,0};
static C_char C_TLS li178[] C_aligned={C_lihdr(0,0,26),40,117,116,99,45,116,105,109,101,45,62,115,101,99,111,110,100,115,32,116,109,49,55,53,50,41,0,0,0,0,0,0};
static C_char C_TLS li179[] C_aligned={C_lihdr(0,0,29),40,108,111,99,97,108,45,116,105,109,101,122,111,110,101,45,97,98,98,114,101,118,105,97,116,105,111,110,41,0,0,0};
static C_char C_TLS li180[] C_aligned={C_lihdr(0,0,18),40,95,101,120,105,116,32,46,32,99,111,100,101,49,55,54,53,41,0,0,0,0,0,0};
static C_char C_TLS li181[] C_aligned={C_lihdr(0,0,24),40,115,101,116,45,97,108,97,114,109,33,32,105,110,116,49,55,54,55,49,55,55,48,41};
static C_char C_TLS li182[] C_aligned={C_lihdr(0,0,50),40,115,101,116,45,98,117,102,102,101,114,105,110,103,45,109,111,100,101,33,32,112,111,114,116,49,55,55,50,32,109,111,100,101,49,55,55,51,32,46,32,115,105,122,101,49,55,55,52,41,0,0,0,0,0,0};
static C_char C_TLS li183[] C_aligned={C_lihdr(0,0,25),40,116,101,114,109,105,110,97,108,45,112,111,114,116,63,32,112,111,114,116,49,55,56,54,41,0,0,0,0,0,0,0};
static C_char C_TLS li184[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,116,101,114,109,105,110,97,108,45,99,104,101,99,107,32,99,97,108,108,101,114,49,55,57,49,32,112,111,114,116,49,55,57,50,41,0,0,0,0,0,0};
static C_char C_TLS li185[] C_aligned={C_lihdr(0,0,24),40,116,101,114,109,105,110,97,108,45,110,97,109,101,32,112,111,114,116,49,56,48,50,41};
static C_char C_TLS li186[] C_aligned={C_lihdr(0,0,24),40,116,101,114,109,105,110,97,108,45,115,105,122,101,32,112,111,114,116,49,56,49,52,41};
static C_char C_TLS li187[] C_aligned={C_lihdr(0,0,15),40,103,101,116,45,104,111,115,116,45,110,97,109,101,41,0};
static C_char C_TLS li188[] C_aligned={C_lihdr(0,0,18),40,102,95,55,54,55,48,32,116,104,117,110,107,49,56,54,53,41,0,0,0,0,0,0};
static C_char C_TLS li189[] C_aligned={C_lihdr(0,0,7),40,97,55,54,54,49,41,0};
static C_char C_TLS li190[] C_aligned={C_lihdr(0,0,28),40,112,114,111,99,101,115,115,45,102,111,114,107,32,46,32,116,109,112,49,56,52,49,49,56,52,50,41,0,0,0,0};
static C_char C_TLS li191[] C_aligned={C_lihdr(0,0,49),40,115,101,116,97,114,103,32,105,110,116,49,56,55,53,49,56,56,49,32,99,45,115,116,114,105,110,103,49,56,55,54,49,56,56,50,32,105,110,116,49,56,55,55,49,56,56,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li192[] C_aligned={C_lihdr(0,0,49),40,115,101,116,101,110,118,32,105,110,116,49,56,56,55,49,56,57,51,32,99,45,115,116,114,105,110,103,49,56,56,56,49,56,57,52,32,105,110,116,49,56,56,57,49,56,57,53,41,0,0,0,0,0,0,0};
static C_char C_TLS li193[] C_aligned={C_lihdr(0,0,25),40,100,111,108,111,111,112,49,57,50,49,32,101,108,49,57,50,51,32,105,49,57,50,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li194[] C_aligned={C_lihdr(0,0,25),40,100,111,108,111,111,112,49,57,49,55,32,97,108,49,57,49,57,32,105,49,57,50,48,41,0,0,0,0,0,0,0};
static C_char C_TLS li195[] C_aligned={C_lihdr(0,0,44),40,112,114,111,99,101,115,115,45,101,120,101,99,117,116,101,32,102,105,108,101,110,97,109,101,49,57,48,52,32,46,32,116,109,112,49,57,48,51,49,57,48,53,41,0,0,0,0};
static C_char C_TLS li196[] C_aligned={C_lihdr(0,0,7),40,97,55,57,50,55,41,0};
static C_char C_TLS li197[] C_aligned={C_lihdr(0,0,39),40,35,35,115,121,115,35,112,114,111,99,101,115,115,45,119,97,105,116,32,112,105,100,49,57,52,52,32,110,111,104,97,110,103,49,57,52,53,41,0};
static C_char C_TLS li198[] C_aligned={C_lihdr(0,0,19),40,112,97,114,101,110,116,45,112,114,111,99,101,115,115,45,105,100,41,0,0,0,0,0};
static C_char C_TLS li199[] C_aligned={C_lihdr(0,0,19),40,115,108,101,101,112,32,105,110,116,49,57,53,55,49,57,54,48,41,0,0,0,0,0};
static C_char C_TLS li200[] C_aligned={C_lihdr(0,0,33),40,112,114,111,99,101,115,115,45,115,105,103,110,97,108,32,105,100,49,57,54,50,32,46,32,115,105,103,49,57,54,51,41,0,0,0,0,0,0,0};
static C_char C_TLS li201[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,115,104,101,108,108,45,99,111,109,109,97,110,100,41,0,0,0};
static C_char C_TLS li202[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,115,104,101,108,108,45,99,111,109,109,97,110,100,45,97,114,103,117,109,101,110,116,115,32,99,109,100,108,105,110,49,57,55,51,41,0,0,0,0,0,0};
static C_char C_TLS li203[] C_aligned={C_lihdr(0,0,30),40,112,114,111,99,101,115,115,45,114,117,110,32,102,49,57,55,53,32,46,32,97,114,103,115,49,57,55,54,41,0,0};
static C_char C_TLS li204[] C_aligned={C_lihdr(0,0,7),40,97,56,48,55,48,41,0};
static C_char C_TLS li205[] C_aligned={C_lihdr(0,0,29),40,97,56,48,55,54,32,95,50,48,48,48,32,102,108,103,50,48,48,49,32,99,111,100,50,48,48,50,41,0,0,0};
static C_char C_TLS li206[] C_aligned={C_lihdr(0,0,8),40,102,95,56,48,53,54,41};
static C_char C_TLS li207[] C_aligned={C_lihdr(0,0,68),40,109,97,107,101,45,111,110,45,99,108,111,115,101,32,108,111,99,49,57,57,51,32,112,105,100,49,57,57,52,32,99,108,115,118,101,99,49,57,57,53,32,105,100,120,49,57,57,54,32,105,100,120,97,49,57,57,55,32,105,100,120,98,49,57,57,56,41,0,0,0,0};
static C_char C_TLS li208[] C_aligned={C_lihdr(0,0,7),40,97,56,48,57,57,41,0};
static C_char C_TLS li209[] C_aligned={C_lihdr(0,0,19),40,97,56,49,48,53,32,105,50,48,48,55,32,111,50,48,48,56,41,0,0,0,0,0};
static C_char C_TLS li210[] C_aligned={C_lihdr(0,0,22),40,110,101,101,100,101,100,45,112,105,112,101,32,112,111,114,116,50,48,48,53,41,0,0};
static C_char C_TLS li211[] C_aligned={C_lihdr(0,0,34),40,99,111,110,110,101,99,116,45,112,97,114,101,110,116,32,112,105,112,101,50,48,49,48,32,112,111,114,116,50,48,49,49,41,0,0,0,0,0,0};
static C_char C_TLS li212[] C_aligned={C_lihdr(0,0,43),40,99,111,110,110,101,99,116,45,99,104,105,108,100,32,112,105,112,101,50,48,49,56,32,112,111,114,116,50,48,49,57,32,115,116,100,102,100,50,48,50,48,41,0,0,0,0,0};
static C_char C_TLS li213[] C_aligned={C_lihdr(0,0,14),40,115,119,97,112,112,101,100,45,101,110,100,115,41,0,0};
static C_char C_TLS li214[] C_aligned={C_lihdr(0,0,7),40,97,56,49,55,52,41,0};
static C_char C_TLS li215[] C_aligned={C_lihdr(0,0,67),40,115,112,97,119,110,32,99,109,100,50,48,51,49,32,97,114,103,115,50,48,51,50,32,101,110,118,50,48,51,51,32,115,116,100,111,117,116,102,50,48,51,52,32,115,116,100,105,110,102,50,48,51,53,32,115,116,100,101,114,114,102,50,48,51,54,41,0,0,0,0,0};
static C_char C_TLS li216[] C_aligned={C_lihdr(0,0,59),40,105,110,112,117,116,45,112,111,114,116,32,108,111,99,50,48,52,51,32,99,109,100,50,48,52,53,32,112,105,112,101,50,48,52,54,32,115,116,100,102,50,48,52,55,32,111,110,45,99,108,111,115,101,50,48,52,57,41,0,0,0,0,0};
static C_char C_TLS li217[] C_aligned={C_lihdr(0,0,60),40,111,117,116,112,117,116,45,112,111,114,116,32,108,111,99,50,48,53,49,32,99,109,100,50,48,53,51,32,112,105,112,101,50,48,53,52,32,115,116,100,102,50,48,53,53,32,111,110,45,99,108,111,115,101,50,48,53,55,41,0,0,0,0};
static C_char C_TLS li218[] C_aligned={C_lihdr(0,0,7),40,97,56,50,50,52,41,0};
static C_char C_TLS li219[] C_aligned={C_lihdr(0,0,50),40,97,56,50,51,48,32,105,110,112,105,112,101,50,48,54,54,32,111,117,116,112,105,112,101,50,48,54,55,32,101,114,114,112,105,112,101,50,48,54,56,32,112,105,100,50,48,54,57,41,0,0,0,0,0,0};
static C_char C_TLS li220[] C_aligned={C_lihdr(0,0,83),40,35,35,115,121,115,35,112,114,111,99,101,115,115,32,108,111,99,50,48,53,57,32,99,109,100,50,48,54,48,32,97,114,103,115,50,48,54,49,32,101,110,118,50,48,54,50,32,115,116,100,111,117,116,102,50,48,54,51,32,115,116,100,105,110,102,50,48,54,52,32,115,116,100,101,114,114,102,50,48,54,53,41,0,0,0,0,0};
static C_char C_TLS li221[] C_aligned={C_lihdr(0,0,7),40,103,50,48,56,53,41,0};
static C_char C_TLS li222[] C_aligned={C_lihdr(0,0,19),40,102,111,114,45,101,97,99,104,45,108,111,111,112,50,48,56,52,41,0,0,0,0,0};
static C_char C_TLS li223[] C_aligned={C_lihdr(0,0,19),40,99,104,107,115,116,114,108,115,116,32,108,115,116,50,48,56,49,41,0,0,0,0,0};
static C_char C_TLS li224[] C_aligned={C_lihdr(0,0,7),40,97,56,51,50,53,41,0};
static C_char C_TLS li225[] C_aligned={C_lihdr(0,0,58),40,37,112,114,111,99,101,115,115,32,108,111,99,50,48,55,52,32,101,114,114,63,50,48,55,53,32,99,109,100,50,48,55,54,32,97,114,103,115,50,48,55,55,32,101,110,118,50,48,55,56,32,107,50,48,55,57,41,0,0,0,0,0,0};
static C_char C_TLS li226[] C_aligned={C_lihdr(0,0,31),40,97,56,51,54,51,32,105,50,49,50,57,32,111,50,49,51,48,32,112,50,49,51,49,32,101,50,49,51,50,41,0};
static C_char C_TLS li227[] C_aligned={C_lihdr(0,0,31),40,112,114,111,99,101,115,115,32,99,109,100,50,49,49,55,32,46,32,116,109,112,50,49,49,54,50,49,49,56,41,0};
static C_char C_TLS li228[] C_aligned={C_lihdr(0,0,32),40,112,114,111,99,101,115,115,42,32,99,109,100,50,49,51,56,32,46,32,116,109,112,50,49,51,55,50,49,51,57,41};
static C_char C_TLS li229[] C_aligned={C_lihdr(0,0,29),40,115,101,116,45,114,111,111,116,45,100,105,114,101,99,116,111,114,121,33,32,100,105,114,50,49,53,57,41,0,0,0};
static C_char C_TLS li230[] C_aligned={C_lihdr(0,0,15),40,97,56,52,55,49,32,112,105,100,49,51,51,49,41,0};
static C_char C_TLS li231[] C_aligned={C_lihdr(0,0,24),40,97,56,52,56,57,32,112,105,100,49,51,51,54,32,112,103,105,100,49,51,51,55,41};
static C_char C_TLS li232[] C_aligned={C_lihdr(0,0,7),40,97,56,53,49,49,41,0};
static C_char C_TLS li233[] C_aligned={C_lihdr(0,0,14),40,97,56,53,49,52,32,105,100,49,49,54,52,41,0,0};
static C_char C_TLS li234[] C_aligned={C_lihdr(0,0,7),40,97,56,53,51,48,41,0};
static C_char C_TLS li235[] C_aligned={C_lihdr(0,0,14),40,97,56,53,51,51,32,105,100,49,49,53,57,41,0,0};
static C_char C_TLS li236[] C_aligned={C_lihdr(0,0,7),40,97,56,53,52,57,41,0};
static C_char C_TLS li237[] C_aligned={C_lihdr(0,0,14),40,97,56,53,53,50,32,105,100,49,49,53,52,41,0,0};
static C_char C_TLS li238[] C_aligned={C_lihdr(0,0,7),40,97,56,53,54,56,41,0};
static C_char C_TLS li239[] C_aligned={C_lihdr(0,0,14),40,97,56,53,55,49,32,105,100,49,49,52,57,41,0,0};
static C_char C_TLS li240[] C_aligned={C_lihdr(0,0,24),40,108,111,111,112,32,115,105,103,115,49,49,50,52,32,109,97,115,107,49,49,50,53,41};
static C_char C_TLS li241[] C_aligned={C_lihdr(0,0,7),40,97,56,53,56,55,41,0};
static C_char C_TLS li242[] C_aligned={C_lihdr(0,0,14),40,97,56,54,50,49,32,115,105,103,54,53,49,41,0,0};
static C_char C_TLS li243[] C_aligned={C_lihdr(0,0,19),40,97,56,54,51,48,32,46,32,116,109,112,53,48,54,53,48,55,41,0,0,0,0,0};
static C_char C_TLS li244[] C_aligned={C_lihdr(0,0,13),40,97,56,54,53,53,32,117,109,53,49,57,41,0,0,0};
static C_char C_TLS li245[] C_aligned={C_lihdr(0,0,15),40,97,56,54,54,49,32,112,111,114,116,49,57,54,41,0};
static C_char C_TLS li246[] C_aligned={C_lihdr(0,0,12),40,97,56,54,57,56,32,102,49,49,49,41,0,0,0,0};
static C_char C_TLS li247[] C_aligned={C_lihdr(0,0,17),40,97,56,55,48,52,32,102,49,49,51,32,116,49,49,52,41,0,0,0,0,0,0,0};
static C_char C_TLS li248[] C_aligned={C_lihdr(0,0,10),40,116,111,112,108,101,118,101,108,41,0,0,0,0,0,0};


/* from k8439 in set-root-directory! in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
C_regparm static C_word C_fcall stub2154(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
C_r=C_fix((C_word)chroot(t0));
return C_r;}

/* from k7956 */
C_regparm static C_word C_fcall stub1958(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_sleep(t0));
return C_r;}

/* from parent-process-id in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
C_regparm static C_word C_fcall stub1954(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getppid());
return C_r;}

/* from freeenv */
C_regparm static C_word C_fcall stub1897(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_env();
return C_r;}

/* from k7744 */
C_regparm static C_word C_fcall stub1890(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_env(t0,t1,t2);
return C_r;}

/* from freeargs */
C_regparm static C_word C_fcall stub1885(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_args();
return C_r;}

/* from k7721 */
C_regparm static C_word C_fcall stub1878(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_arg(t0,t1,t2);
return C_r;}

/* from k7634 */
C_regparm static C_word C_fcall stub1856(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
C_r=C_fix((C_word)C_fflush(t0));
return C_r;}

/* from fork */
C_regparm static C_word C_fcall stub1835(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_fork());
return C_r;}

#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub1828(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
if(gethostname(C_hostbuf, 256) == -1) C_return(NULL);else C_return(C_hostbuf);
C_ret:
#undef return

return C_r;}

/* from k7563 */
C_regparm static C_word C_fcall stub1809(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int *t1=(int *)C_c_pointer_nn(C_a1);
int *t2=(int *)C_c_pointer_nn(C_a2);
C_r=C_fix((C_word)get_tty_size(t0,t1,t2));
return C_r;}

/* from k7539 */
C_regparm static C_word C_fcall stub1798(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)ttyname(t0));
return C_r;}

/* from k7426 */
C_regparm static C_word C_fcall stub1768(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_alarm(t0));
return C_r;}

/* from k7406 */
C_regparm static C_word C_fcall stub1762(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub1756(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;

#if !defined(__CYGWIN__) && !defined(__SVR4) && !defined(__uClinux__) && !defined(__hpux__) && !defined(_AIX)
time_t clock = time(NULL);struct tm *ltm = C_localtime(&clock);char *z = ltm ? (char *)ltm->tm_zone : 0;
#else
char *z = (daylight ? tzname[1] : tzname[0]);
#endif
C_return(z);
C_ret:
#undef return

return C_r;}

/* from k7334 */
C_regparm static C_word C_fcall stub1726(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
C_word t2=(C_word )(C_a2);
void * t3=(void * )C_data_pointer_or_null(C_a3);
C_r=((C_word)C_strptime(t0,t1,t2,t3));
return C_r;}

/* from k7277 */
C_regparm static C_word C_fcall stub1704(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
C_r=C_fix((C_word)munmap(t0,t1));
return C_r;}

/* from k7217 */
C_regparm static C_word C_fcall stub1677(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
int t2=(int )C_unfix(C_a2);
int t3=(int )C_unfix(C_a3);
int t4=(int )C_unfix(C_a4);
int t5=(int )C_num_to_int(C_a5);
C_r=C_mpointer_or_false(&C_a,(void*)mmap(t0,t1,t2,t3,t4,t5));
return C_r;}

/* from k6081 in k6077 in file-link in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
C_regparm static C_word C_fcall stub1384(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
C_r=C_fix((C_word)link(t0,t1));
return C_r;}

/* from k5748 */
C_regparm static C_word C_fcall stub1251(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_fix((C_word)initgroups(t0,t1));
return C_r;}

#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub1221(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
if(C_groups != NULL) C_free(C_groups);C_groups = (gid_t *)C_malloc(sizeof(gid_t) * n);if(C_groups == NULL) C_return(0);else C_return(1);
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub1216(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
C_return(getgroups(n, C_groups));
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub1188(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
C_return(C_group->gr_mem[ i ]);
C_ret:
#undef return

return C_r;}

/* from a8511 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
C_regparm static C_word C_fcall stub1162(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getegid());
return C_r;}

/* from a8530 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
C_regparm static C_word C_fcall stub1157(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getgid());
return C_r;}

/* from a8549 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
C_regparm static C_word C_fcall stub1152(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_geteuid());
return C_r;}

/* from a8568 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
C_regparm static C_word C_fcall stub1147(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getuid());
return C_r;}

#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub952(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
void * p=(void * )C_data_pointer_or_null(C_a1);
struct pollfd *fds = p;C_return(fds[i].revents & (POLLOUT|POLLERR|POLLHUP|POLLNVAL));
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub933(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
void * p=(void * )C_data_pointer_or_null(C_a1);
struct pollfd *fds = p;C_return(fds[i].revents & (POLLIN|POLLERR|POLLHUP|POLLNVAL));
C_ret:
#undef return

return C_r;}

/* from k4620 */
C_regparm static C_word C_fcall stub908(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_data_pointer_or_null(C_a0);
int t1=(int )C_unfix(C_a1);
int t2=(int )C_unfix(C_a2);
C_r=C_fix((C_word)poll(t0,t1,t2));
return C_r;}

#define return(x) C_cblock C_r = (((C_word)(x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub893(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
int fd=(int )C_unfix(C_a1);
void * p=(void * )C_data_pointer_or_null(C_a2);
struct pollfd *fds = p;fds[i].fd = fd; fds[i].events = POLLOUT;
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (((C_word)(x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub875(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
int fd=(int )C_unfix(C_a1);
void * p=(void * )C_data_pointer_or_null(C_a2);
struct pollfd *fds = p;fds[i].fd = fd; fds[i].events = POLLIN;
C_ret:
#undef return

return C_r;}

/* from k4372 */
C_regparm static C_word C_fcall stub774(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
long t2=(long )C_num_to_long(C_a2);
C_r=C_fix((C_word)fcntl(t0,t1,t2));
return C_r;}

/* from k4321 */
C_regparm static C_word C_fcall stub730(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_check_fd_ready(t0));
return C_r;}

#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
C_regparm static C_word C_fcall stub725(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
int val = fcntl(fd, F_GETFL, 0);if(val == -1) C_return(0);C_return(fcntl(fd, F_SETFL, val | O_NONBLOCK) != -1);
C_ret:
#undef return

return C_r;}

/* from k4150 */
C_regparm static C_word C_fcall stub633(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from k4048 */
C_regparm static C_word C_fcall stub593(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
void * t2=(void * )C_data_pointer_or_null(C_a2);
C_r=C_mpointer(&C_a,(void*)C_strftime(t0,t1,t2));
return C_r;}

/* from k4035 */
C_regparm static C_word C_fcall stub583(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0,t1));
return C_r;}

/* from k3968 */
C_regparm static C_word C_fcall stub554(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_num_to_int(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

/* from k8713 in a8704 in k2682 in k2679 in k2676 in k2673 in k2670 */
C_regparm static C_word C_fcall stub120(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
C_word t1=(C_word )(C_a1);
C_r=C_fix((C_word)set_file_mtime(t0,t1));
return C_r;}

/* from k2693 */
C_regparm static C_word C_fcall stub67(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)strerror(t0));
return C_r;}

C_noret_decl(f_4823)
static void C_fcall f_4823(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5168)
static void C_ccall f_5168(C_word c,C_word *av) C_noret;
C_noret_decl(f_8699)
static void C_ccall f_8699(C_word c,C_word *av) C_noret;
C_noret_decl(f_5164)
static void C_ccall f_5164(C_word c,C_word *av) C_noret;
C_noret_decl(f_3700)
static void C_ccall f_3700(C_word c,C_word *av) C_noret;
C_noret_decl(f_3709)
static void C_ccall f_3709(C_word c,C_word *av) C_noret;
C_noret_decl(f_7828)
static void C_fcall f_7828(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5132)
static void C_ccall f_5132(C_word c,C_word *av) C_noret;
C_noret_decl(f_3753)
static void C_ccall f_3753(C_word c,C_word *av) C_noret;
C_noret_decl(f_3755)
static void C_ccall f_3755(C_word c,C_word *av) C_noret;
C_noret_decl(f_4236)
static void C_ccall f_4236(C_word c,C_word *av) C_noret;
C_noret_decl(f_4234)
static void C_ccall f_4234(C_word c,C_word *av) C_noret;
C_noret_decl(f_5149)
static void C_ccall f_5149(C_word c,C_word *av) C_noret;
C_noret_decl(f_5144)
static void C_ccall f_5144(C_word c,C_word *av) C_noret;
C_noret_decl(f_5140)
static void C_ccall f_5140(C_word c,C_word *av) C_noret;
C_noret_decl(f_7239)
static void C_ccall f_7239(C_word c,C_word *av) C_noret;
C_noret_decl(f_7847)
static void C_ccall f_7847(C_word c,C_word *av) C_noret;
C_noret_decl(f_7233)
static void C_ccall f_7233(C_word c,C_word *av) C_noret;
C_noret_decl(f_7230)
static void C_fcall f_7230(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7570)
static void C_ccall f_7570(C_word c,C_word *av) C_noret;
C_noret_decl(f_4878)
static C_word C_fcall f_4878(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_3775)
static void C_ccall f_3775(C_word c,C_word *av) C_noret;
C_noret_decl(f_3772)
static void C_ccall f_3772(C_word c,C_word *av) C_noret;
C_noret_decl(f_6518)
static void C_ccall f_6518(C_word c,C_word *av) C_noret;
C_noret_decl(f_7227)
static void C_ccall f_7227(C_word c,C_word *av) C_noret;
C_noret_decl(f_7223)
static void C_ccall f_7223(C_word c,C_word *av) C_noret;
C_noret_decl(f_7566)
static void C_ccall f_7566(C_word c,C_word *av) C_noret;
C_noret_decl(f_3743)
static void C_ccall f_3743(C_word c,C_word *av) C_noret;
C_noret_decl(f_6567)
static void C_ccall f_6567(C_word c,C_word *av) C_noret;
C_noret_decl(f_7252)
static void C_ccall f_7252(C_word c,C_word *av) C_noret;
C_noret_decl(f_8666)
static void C_ccall f_8666(C_word c,C_word *av) C_noret;
C_noret_decl(f_8669)
static void C_ccall f_8669(C_word c,C_word *av) C_noret;
C_noret_decl(f_3799)
static void C_ccall f_3799(C_word c,C_word *av) C_noret;
C_noret_decl(f_3790)
static void C_ccall f_3790(C_word c,C_word *av) C_noret;
C_noret_decl(f_6577)
static void C_ccall f_6577(C_word c,C_word *av) C_noret;
C_noret_decl(f_3793)
static void C_ccall f_3793(C_word c,C_word *av) C_noret;
C_noret_decl(f_8662)
static void C_ccall f_8662(C_word c,C_word *av) C_noret;
C_noret_decl(f_4080)
static void C_ccall f_4080(C_word c,C_word *av) C_noret;
C_noret_decl(f_4084)
static void C_ccall f_4084(C_word c,C_word *av) C_noret;
C_noret_decl(f_3760)
static void C_ccall f_3760(C_word c,C_word *av) C_noret;
C_noret_decl(f_4087)
static void C_ccall f_4087(C_word c,C_word *av) C_noret;
C_noret_decl(f_3768)
static void C_ccall f_3768(C_word c,C_word *av) C_noret;
C_noret_decl(f_3248)
static void C_ccall f_3248(C_word c,C_word *av) C_noret;
C_noret_decl(f_3249)
static void C_fcall f_3249(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7037)
static void C_ccall f_7037(C_word c,C_word *av) C_noret;
C_noret_decl(f_4070)
static void C_ccall f_4070(C_word c,C_word *av) C_noret;
C_noret_decl(f_3259)
static void C_ccall f_3259(C_word c,C_word *av) C_noret;
C_noret_decl(f_3225)
static void C_fcall f_3225(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3229)
static void C_ccall f_3229(C_word c,C_word *av) C_noret;
C_noret_decl(f_5573)
static void C_ccall f_5573(C_word c,C_word *av) C_noret;
C_noret_decl(f_4242)
static void C_ccall f_4242(C_word c,C_word *av) C_noret;
C_noret_decl(f_7057)
static void C_ccall f_7057(C_word c,C_word *av) C_noret;
C_noret_decl(f_7053)
static void C_ccall f_7053(C_word c,C_word *av) C_noret;
C_noret_decl(f_5583)
static void C_ccall f_5583(C_word c,C_word *av) C_noret;
C_noret_decl(f_7041)
static void C_ccall f_7041(C_word c,C_word *av) C_noret;
C_noret_decl(f_8631)
static void C_ccall f_8631(C_word c,C_word *av) C_noret;
C_noret_decl(f_3283)
static void C_ccall f_3283(C_word c,C_word *av) C_noret;
C_noret_decl(f_5569)
static void C_fcall f_5569(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7742)
static void C_ccall f_7742(C_word c,C_word *av) C_noret;
C_noret_decl(f_5070)
static void C_ccall f_5070(C_word c,C_word *av) C_noret;
C_noret_decl(f_5563)
static void C_ccall f_5563(C_word c,C_word *av) C_noret;
C_noret_decl(f_5567)
static void C_ccall f_5567(C_word c,C_word *av) C_noret;
C_noret_decl(f_4023)
static void C_ccall f_4023(C_word c,C_word *av) C_noret;
C_noret_decl(f_8656)
static void C_ccall f_8656(C_word c,C_word *av) C_noret;
C_noret_decl(f_5084)
static void C_ccall f_5084(C_word c,C_word *av) C_noret;
C_noret_decl(f_3268)
static void C_ccall f_3268(C_word c,C_word *av) C_noret;
C_noret_decl(f_3265)
static void C_ccall f_3265(C_word c,C_word *av) C_noret;
C_noret_decl(f_4013)
static void C_ccall f_4013(C_word c,C_word *av) C_noret;
C_noret_decl(f_4017)
static void C_ccall f_4017(C_word c,C_word *av) C_noret;
C_noret_decl(f_5091)
static void C_ccall f_5091(C_word c,C_word *av) C_noret;
C_noret_decl(f_3273)
static void C_fcall f_3273(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3375)
static void C_ccall f_3375(C_word c,C_word *av) C_noret;
C_noret_decl(f_4009)
static void C_ccall f_4009(C_word c,C_word *av) C_noret;
C_noret_decl(f_3373)
static void C_ccall f_3373(C_word c,C_word *av) C_noret;
C_noret_decl(f_5597)
static void C_ccall f_5597(C_word c,C_word *av) C_noret;
C_noret_decl(f_3381)
static void C_ccall f_3381(C_word c,C_word *av) C_noret;
C_noret_decl(f_6643)
static void C_ccall f_6643(C_word c,C_word *av) C_noret;
C_noret_decl(f_5508)
static void C_ccall f_5508(C_word c,C_word *av) C_noret;
C_noret_decl(f_8622)
static void C_ccall f_8622(C_word c,C_word *av) C_noret;
C_noret_decl(f_5500)
static void C_ccall f_5500(C_word c,C_word *av) C_noret;
C_noret_decl(f_3981)
static void C_ccall f_3981(C_word c,C_word *av) C_noret;
C_noret_decl(f_3201)
static void C_ccall f_3201(C_word c,C_word *av) C_noret;
C_noret_decl(f_6811)
static void C_fcall f_6811(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5539)
static void C_ccall f_5539(C_word c,C_word *av) C_noret;
C_noret_decl(f_3219)
static void C_ccall f_3219(C_word c,C_word *av) C_noret;
C_noret_decl(f_6821)
static void C_ccall f_6821(C_word c,C_word *av) C_noret;
C_noret_decl(f_5546)
static void C_fcall f_5546(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5015)
static void C_fcall f_5015(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5028)
static void C_ccall f_5028(C_word c,C_word *av) C_noret;
C_noret_decl(f_5514)
static void C_ccall f_5514(C_word c,C_word *av) C_noret;
C_noret_decl(f_5512)
static void C_ccall f_5512(C_word c,C_word *av) C_noret;
C_noret_decl(f_5526)
static void C_ccall f_5526(C_word c,C_word *av) C_noret;
C_noret_decl(f_5522)
static void C_ccall f_5522(C_word c,C_word *av) C_noret;
C_noret_decl(f_8594)
static void C_fcall f_8594(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_8569)
static void C_ccall f_8569(C_word c,C_word *av) C_noret;
C_noret_decl(f_8563)
static void C_ccall f_8563(C_word c,C_word *av) C_noret;
C_noret_decl(f_5559)
static void C_ccall f_5559(C_word c,C_word *av) C_noret;
C_noret_decl(f_8588)
static void C_ccall f_8588(C_word c,C_word *av) C_noret;
C_noret_decl(f_4762)
static void C_fcall f_4762(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_8582)
static void C_ccall f_8582(C_word c,C_word *av) C_noret;
C_noret_decl(f_4791)
static void C_fcall f_4791(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4732)
static void C_fcall f_4732(C_word t0,C_word t1) C_noret;
C_noret_decl(f_8572)
static void C_ccall f_8572(C_word c,C_word *av) C_noret;
C_noret_decl(f_8512)
static void C_ccall f_8512(C_word c,C_word *av) C_noret;
C_noret_decl(f_8515)
static void C_ccall f_8515(C_word c,C_word *av) C_noret;
C_noret_decl(f_4061)
static void C_ccall f_4061(C_word c,C_word *av) C_noret;
C_noret_decl(f_4054)
static void C_ccall f_4054(C_word c,C_word *av) C_noret;
C_noret_decl(f_7666)
static void C_ccall f_7666(C_word c,C_word *av) C_noret;
C_noret_decl(f_7662)
static void C_ccall f_7662(C_word c,C_word *av) C_noret;
C_noret_decl(f_8506)
static void C_ccall f_8506(C_word c,C_word *av) C_noret;
C_noret_decl(f_8553)
static void C_ccall f_8553(C_word c,C_word *av) C_noret;
C_noret_decl(f_8550)
static void C_ccall f_8550(C_word c,C_word *av) C_noret;
C_noret_decl(f_6793)
static void C_ccall f_6793(C_word c,C_word *av) C_noret;
C_noret_decl(f_6794)
static void C_ccall f_6794(C_word c,C_word *av) C_noret;
C_noret_decl(f_8525)
static void C_ccall f_8525(C_word c,C_word *av) C_noret;
C_noret_decl(f_6184)
static C_word C_fcall f_6184(C_word t0);
C_noret_decl(f_7670)
static void C_ccall f_7670(C_word c,C_word *av) C_noret;
C_noret_decl(f_6198)
static void C_ccall f_6198(C_word c,C_word *av) C_noret;
C_noret_decl(f_6192)
static void C_fcall f_6192(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7802)
static void C_ccall f_7802(C_word c,C_word *av) C_noret;
C_noret_decl(f_8544)
static void C_ccall f_8544(C_word c,C_word *av) C_noret;
C_noret_decl(f_5030)
static void C_ccall f_5030(C_word c,C_word *av) C_noret;
C_noret_decl(f_7617)
static void C_ccall f_7617(C_word c,C_word *av) C_noret;
C_noret_decl(f_7610)
static void C_ccall f_7610(C_word c,C_word *av) C_noret;
C_noret_decl(f_5044)
static void C_ccall f_5044(C_word c,C_word *av) C_noret;
C_noret_decl(f_6759)
static void C_ccall f_6759(C_word c,C_word *av) C_noret;
C_noret_decl(f_7648)
static void C_ccall f_7648(C_word c,C_word *av) C_noret;
C_noret_decl(f_5051)
static void C_ccall f_5051(C_word c,C_word *av) C_noret;
C_noret_decl(f_8534)
static void C_ccall f_8534(C_word c,C_word *av) C_noret;
C_noret_decl(f_8531)
static void C_ccall f_8531(C_word c,C_word *av) C_noret;
C_noret_decl(f_7546)
static void C_ccall f_7546(C_word c,C_word *av) C_noret;
C_noret_decl(f_7542)
static void C_ccall f_7542(C_word c,C_word *av) C_noret;
C_noret_decl(f_5061)
static void C_ccall f_5061(C_word c,C_word *av) C_noret;
C_noret_decl(f_6120)
static void C_ccall f_6120(C_word c,C_word *av) C_noret;
C_noret_decl(f_6743)
static void C_ccall f_6743(C_word c,C_word *av) C_noret;
C_noret_decl(f_6749)
static void C_ccall f_6749(C_word c,C_word *av) C_noret;
C_noret_decl(f_6741)
static void C_ccall f_6741(C_word c,C_word *av) C_noret;
C_noret_decl(f_2802)
static void C_ccall f_2802(C_word c,C_word *av) C_noret;
C_noret_decl(f_2804)
static void C_ccall f_2804(C_word c,C_word *av) C_noret;
C_noret_decl(f_2808)
static void C_ccall f_2808(C_word c,C_word *av) C_noret;
C_noret_decl(f_6722)
static void C_ccall f_6722(C_word c,C_word *av) C_noret;
C_noret_decl(f_2835)
static void C_ccall f_2835(C_word c,C_word *av) C_noret;
C_noret_decl(f_6288)
static void C_ccall f_6288(C_word c,C_word *av) C_noret;
C_noret_decl(f_6118)
static void C_ccall f_6118(C_word c,C_word *av) C_noret;
C_noret_decl(f_6771)
static void C_ccall f_6771(C_word c,C_word *av) C_noret;
C_noret_decl(f_6779)
static void C_ccall f_6779(C_word c,C_word *av) C_noret;
C_noret_decl(f_6292)
static void C_ccall f_6292(C_word c,C_word *av) C_noret;
C_noret_decl(f_6294)
static void C_ccall f_6294(C_word c,C_word *av) C_noret;
C_noret_decl(f_6298)
static void C_ccall f_6298(C_word c,C_word *av) C_noret;
C_noret_decl(f_4834)
static void C_ccall f_4834(C_word c,C_word *av) C_noret;
C_noret_decl(f_4836)
static C_word C_fcall f_4836(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_5260)
static void C_ccall f_5260(C_word c,C_word *av) C_noret;
C_noret_decl(f_5774)
static void C_ccall f_5774(C_word c,C_word *av) C_noret;
C_noret_decl(f_5781)
static void C_ccall f_5781(C_word c,C_word *av) C_noret;
C_noret_decl(f_4673)
static void C_fcall f_4673(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7493)
static void C_ccall f_7493(C_word c,C_word *av) C_noret;
C_noret_decl(f_7499)
static void C_ccall f_7499(C_word c,C_word *av) C_noret;
C_noret_decl(f_3880)
static void C_ccall f_3880(C_word c,C_word *av) C_noret;
C_noret_decl(f_3883)
static void C_ccall f_3883(C_word c,C_word *av) C_noret;
C_noret_decl(f_3885)
static void C_ccall f_3885(C_word c,C_word *av) C_noret;
C_noret_decl(f_5242)
static void C_ccall f_5242(C_word c,C_word *av) C_noret;
C_noret_decl(f_7377)
static void C_ccall f_7377(C_word c,C_word *av) C_noret;
C_noret_decl(f_5246)
static void C_ccall f_5246(C_word c,C_word *av) C_noret;
C_noret_decl(f_3898)
static void C_ccall f_3898(C_word c,C_word *av) C_noret;
C_noret_decl(f_3891)
static void C_ccall f_3891(C_word c,C_word *av) C_noret;
C_noret_decl(f_3893)
static void C_ccall f_3893(C_word c,C_word *av) C_noret;
C_noret_decl(f_7361)
static void C_ccall f_7361(C_word c,C_word *av) C_noret;
C_noret_decl(f_5251)
static void C_ccall f_5251(C_word c,C_word *av) C_noret;
C_noret_decl(f_7369)
static void C_ccall f_7369(C_word c,C_word *av) C_noret;
C_noret_decl(f_5256)
static void C_ccall f_5256(C_word c,C_word *av) C_noret;
C_noret_decl(f_3866)
static void C_ccall f_3866(C_word c,C_word *av) C_noret;
C_noret_decl(f_3863)
static void C_ccall f_3863(C_word c,C_word *av) C_noret;
C_noret_decl(f_3860)
static void C_ccall f_3860(C_word c,C_word *av) C_noret;
C_noret_decl(f_2810)
static void C_ccall f_2810(C_word c,C_word *av) C_noret;
C_noret_decl(f_2814)
static void C_ccall f_2814(C_word c,C_word *av) C_noret;
C_noret_decl(f_2816)
static void C_ccall f_2816(C_word c,C_word *av) C_noret;
C_noret_decl(f_3874)
static void C_ccall f_3874(C_word c,C_word *av) C_noret;
C_noret_decl(f_3871)
static void C_ccall f_3871(C_word c,C_word *av) C_noret;
C_noret_decl(f_3877)
static void C_ccall f_3877(C_word c,C_word *av) C_noret;
C_noret_decl(f_4666)
static void C_ccall f_4666(C_word c,C_word *av) C_noret;
C_noret_decl(f_4663)
static void C_ccall f_4663(C_word c,C_word *av) C_noret;
C_noret_decl(f_3780)
static void C_ccall f_3780(C_word c,C_word *av) C_noret;
C_noret_decl(f_6148)
static void C_ccall f_6148(C_word c,C_word *av) C_noret;
C_noret_decl(f_5202)
static void C_ccall f_5202(C_word c,C_word *av) C_noret;
C_noret_decl(f_5208)
static void C_ccall f_5208(C_word c,C_word *av) C_noret;
C_noret_decl(f_6159)
static void C_ccall f_6159(C_word c,C_word *av) C_noret;
C_noret_decl(f_6155)
static void C_fcall f_6155(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4562)
static void C_ccall f_4562(C_word c,C_word *av) C_noret;
C_noret_decl(f_6154)
static void C_ccall f_6154(C_word c,C_word *av) C_noret;
C_noret_decl(f_5708)
static void C_ccall f_5708(C_word c,C_word *av) C_noret;
C_noret_decl(f_5212)
static void C_ccall f_5212(C_word c,C_word *av) C_noret;
C_noret_decl(f_5217)
static void C_ccall f_5217(C_word c,C_word *av) C_noret;
C_noret_decl(f_5758)
static void C_ccall f_5758(C_word c,C_word *av) C_noret;
C_noret_decl(f_4591)
static void C_fcall f_4591(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4569)
static void C_ccall f_4569(C_word c,C_word *av) C_noret;
C_noret_decl(f_2696)
static void C_ccall f_2696(C_word c,C_word *av) C_noret;
C_noret_decl(f_2684)
static void C_ccall f_2684(C_word c,C_word *av) C_noret;
C_noret_decl(f_2681)
static void C_ccall f_2681(C_word c,C_word *av) C_noret;
C_noret_decl(f_7409)
static void C_ccall f_7409(C_word c,C_word *av) C_noret;
C_noret_decl(f_5746)
static void C_ccall f_5746(C_word c,C_word *av) C_noret;
C_noret_decl(f_2678)
static void C_ccall f_2678(C_word c,C_word *av) C_noret;
C_noret_decl(f_2675)
static void C_ccall f_2675(C_word c,C_word *av) C_noret;
C_noret_decl(f_2672)
static void C_ccall f_2672(C_word c,C_word *av) C_noret;
C_noret_decl(f_7391)
static void C_ccall f_7391(C_word c,C_word *av) C_noret;
C_noret_decl(f_7396)
static void C_ccall f_7396(C_word c,C_word *av) C_noret;
C_noret_decl(f_3622)
static void C_fcall f_3622(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7381)
static void C_ccall f_7381(C_word c,C_word *av) C_noret;
C_noret_decl(f_7385)
static void C_ccall f_7385(C_word c,C_word *av) C_noret;
C_noret_decl(f_8364)
static void C_ccall f_8364(C_word c,C_word *av) C_noret;
C_noret_decl(f_3601)
static void C_fcall f_3601(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5222)
static void C_ccall f_5222(C_word c,C_word *av) C_noret;
C_noret_decl(f_5226)
static void C_ccall f_5226(C_word c,C_word *av) C_noret;
C_noret_decl(f_3662)
static void C_ccall f_3662(C_word c,C_word *av) C_noret;
C_noret_decl(f_4581)
static void C_ccall f_4581(C_word c,C_word *av) C_noret;
C_noret_decl(f_5231)
static void C_ccall f_5231(C_word c,C_word *av) C_noret;
C_noret_decl(f_4703)
static void C_fcall f_4703(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5236)
static void C_ccall f_5236(C_word c,C_word *av) C_noret;
C_noret_decl(f_4599)
static void C_ccall f_4599(C_word c,C_word *av) C_noret;
C_noret_decl(f_8394)
static void C_ccall f_8394(C_word c,C_word *av) C_noret;
C_noret_decl(f_3630)
static void C_ccall f_3630(C_word c,C_word *av) C_noret;
C_noret_decl(f_3634)
static void C_ccall f_3634(C_word c,C_word *av) C_noret;
C_noret_decl(f_4585)
static void C_fcall f_4585(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4588)
static void C_fcall f_4588(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3642)
static void C_ccall f_3642(C_word c,C_word *av) C_noret;
C_noret_decl(f_8340)
static void C_ccall f_8340(C_word c,C_word *av) C_noret;
C_noret_decl(f_3618)
static void C_ccall f_3618(C_word c,C_word *av) C_noret;
C_noret_decl(f_4487)
static void C_ccall f_4487(C_word c,C_word *av) C_noret;
C_noret_decl(f_4484)
static void C_ccall f_4484(C_word c,C_word *av) C_noret;
C_noret_decl(f_4481)
static void C_ccall f_4481(C_word c,C_word *av) C_noret;
C_noret_decl(f_8344)
static void C_ccall f_8344(C_word c,C_word *av) C_noret;
C_noret_decl(f_8346)
static void C_ccall f_8346(C_word c,C_word *av) C_noret;
C_noret_decl(f_5470)
static void C_ccall f_5470(C_word c,C_word *av) C_noret;
C_noret_decl(f_5474)
static void C_ccall f_5474(C_word c,C_word *av) C_noret;
C_noret_decl(f_5478)
static void C_ccall f_5478(C_word c,C_word *av) C_noret;
C_noret_decl(f_4471)
static void C_ccall f_4471(C_word c,C_word *av) C_noret;
C_noret_decl(f_3082)
static void C_ccall f_3082(C_word c,C_word *av) C_noret;
C_noret_decl(f_3080)
static void C_ccall f_3080(C_word c,C_word *av) C_noret;
C_noret_decl(f_3096)
static void C_ccall f_3096(C_word c,C_word *av) C_noret;
C_noret_decl(f_3094)
static void C_ccall f_3094(C_word c,C_word *av) C_noret;
C_noret_decl(f_5492)
static void C_ccall f_5492(C_word c,C_word *av) C_noret;
C_noret_decl(f_3067)
static void C_fcall f_3067(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5466)
static void C_ccall f_5466(C_word c,C_word *av) C_noret;
C_noret_decl(f_8321)
static void C_ccall f_8321(C_word c,C_word *av) C_noret;
C_noret_decl(f_8466)
static void C_ccall f_8466(C_word c,C_word *av) C_noret;
C_noret_decl(f_7607)
static void C_ccall f_7607(C_word c,C_word *av) C_noret;
C_noret_decl(f_7603)
static void C_ccall f_7603(C_word c,C_word *av) C_noret;
C_noret_decl(f_8318)
static void C_ccall f_8318(C_word c,C_word *av) C_noret;
C_noret_decl(f_5482)
static void C_ccall f_5482(C_word c,C_word *av) C_noret;
C_noret_decl(f_8326)
static void C_ccall f_8326(C_word c,C_word *av) C_noret;
C_noret_decl(f_3025)
static void C_ccall f_3025(C_word c,C_word *av) C_noret;
C_noret_decl(f_6960)
static void C_fcall f_6960(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3030)
static void C_fcall f_3030(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3038)
static void C_ccall f_3038(C_word c,C_word *av) C_noret;
C_noret_decl(f_8490)
static void C_ccall f_8490(C_word c,C_word *av) C_noret;
C_noret_decl(C_posix_toplevel)
C_externexport void C_ccall C_posix_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(f_5411)
static void C_ccall f_5411(C_word c,C_word *av) C_noret;
C_noret_decl(f_6732)
static void C_fcall f_6732(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5415)
static void C_ccall f_5415(C_word c,C_word *av) C_noret;
C_noret_decl(f_6737)
static void C_ccall f_6737(C_word c,C_word *av) C_noret;
C_noret_decl(f_8449)
static void C_ccall f_8449(C_word c,C_word *av) C_noret;
C_noret_decl(f_5419)
static void C_ccall f_5419(C_word c,C_word *av) C_noret;
C_noret_decl(f_8441)
static void C_ccall f_8441(C_word c,C_word *av) C_noret;
C_noret_decl(f_6253)
static void C_ccall f_6253(C_word c,C_word *av) C_noret;
C_noret_decl(f_6250)
static void C_ccall f_6250(C_word c,C_word *av) C_noret;
C_noret_decl(f_6928)
static void C_ccall f_6928(C_word c,C_word *av) C_noret;
C_noret_decl(f_6921)
static void C_ccall f_6921(C_word c,C_word *av) C_noret;
C_noret_decl(f_6259)
static void C_ccall f_6259(C_word c,C_word *av) C_noret;
C_noret_decl(f_6220)
static void C_ccall f_6220(C_word c,C_word *av) C_noret;
C_noret_decl(f_5432)
static void C_ccall f_5432(C_word c,C_word *av) C_noret;
C_noret_decl(f_6939)
static void C_fcall f_6939(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5436)
static void C_ccall f_5436(C_word c,C_word *av) C_noret;
C_noret_decl(f_5403)
static void C_ccall f_5403(C_word c,C_word *av) C_noret;
C_noret_decl(f_8479)
static void C_ccall f_8479(C_word c,C_word *av) C_noret;
C_noret_decl(f_5407)
static void C_ccall f_5407(C_word c,C_word *av) C_noret;
C_noret_decl(f_8472)
static void C_ccall f_8472(C_word c,C_word *av) C_noret;
C_noret_decl(f_5453)
static void C_fcall f_5453(C_word t0,C_word t1) C_noret;
C_noret_decl(f_8485)
static void C_ccall f_8485(C_word c,C_word *av) C_noret;
C_noret_decl(f_6217)
static void C_ccall f_6217(C_word c,C_word *av) C_noret;
C_noret_decl(f_3501)
static void C_ccall f_3501(C_word c,C_word *av) C_noret;
C_noret_decl(f_5425)
static void C_ccall f_5425(C_word c,C_word *av) C_noret;
C_noret_decl(f_5444)
static void C_ccall f_5444(C_word c,C_word *av) C_noret;
C_noret_decl(f_5440)
static void C_ccall f_5440(C_word c,C_word *av) C_noret;
C_noret_decl(f_5446)
static void C_ccall f_5446(C_word c,C_word *av) C_noret;
C_noret_decl(f_7153)
static void C_ccall f_7153(C_word c,C_word *av) C_noret;
C_noret_decl(f_3561)
static void C_ccall f_3561(C_word c,C_word *av) C_noret;
C_noret_decl(f_3567)
static void C_fcall f_3567(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7994)
static void C_ccall f_7994(C_word c,C_word *av) C_noret;
C_noret_decl(f_7115)
static void C_fcall f_7115(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2771)
static void C_ccall f_2771(C_word c,C_word *av) C_noret;
C_noret_decl(f_6368)
static void C_ccall f_6368(C_word c,C_word *av) C_noret;
C_noret_decl(f_6492)
static void C_ccall f_6492(C_word c,C_word *av) C_noret;
C_noret_decl(f_2764)
static void C_ccall f_2764(C_word c,C_word *av) C_noret;
C_noret_decl(f_6376)
static void C_fcall f_6376(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6378)
static void C_fcall f_6378(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6462)
static void C_ccall f_6462(C_word c,C_word *av) C_noret;
C_noret_decl(f_7953)
static void C_ccall f_7953(C_word c,C_word *av) C_noret;
C_noret_decl(f_2792)
static void C_ccall f_2792(C_word c,C_word *av) C_noret;
C_noret_decl(f_2796)
static void C_ccall f_2796(C_word c,C_word *av) C_noret;
C_noret_decl(f_7950)
static void C_ccall f_7950(C_word c,C_word *av) C_noret;
C_noret_decl(f_2798)
static void C_ccall f_2798(C_word c,C_word *av) C_noret;
C_noret_decl(f_2790)
static void C_ccall f_2790(C_word c,C_word *av) C_noret;
C_noret_decl(f_7357)
static void C_ccall f_7357(C_word c,C_word *av) C_noret;
C_noret_decl(f_2784)
static void C_ccall f_2784(C_word c,C_word *av) C_noret;
C_noret_decl(f_7985)
static void C_ccall f_7985(C_word c,C_word *av) C_noret;
C_noret_decl(f_2786)
static void C_ccall f_2786(C_word c,C_word *av) C_noret;
C_noret_decl(f_7989)
static void C_ccall f_7989(C_word c,C_word *av) C_noret;
C_noret_decl(f_7108)
static void C_ccall f_7108(C_word c,C_word *av) C_noret;
C_noret_decl(f_7340)
static void C_ccall f_7340(C_word c,C_word *av) C_noret;
C_noret_decl(f_3465)
static void C_fcall f_3465(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7912)
static void C_ccall f_7912(C_word c,C_word *av) C_noret;
C_noret_decl(f_7437)
static void C_fcall f_7437(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7434)
static void C_ccall f_7434(C_word c,C_word *av) C_noret;
C_noret_decl(f_7430)
static void C_ccall f_7430(C_word c,C_word *av) C_noret;
C_noret_decl(f_4318)
static void C_ccall f_4318(C_word c,C_word *av) C_noret;
C_noret_decl(f_4311)
static void C_ccall f_4311(C_word c,C_word *av) C_noret;
C_noret_decl(f_7316)
static void C_ccall f_7316(C_word c,C_word *av) C_noret;
C_noret_decl(f_7423)
static void C_ccall f_7423(C_word c,C_word *av) C_noret;
C_noret_decl(f_3441)
static void C_ccall f_3441(C_word c,C_word *av) C_noret;
C_noret_decl(f_3444)
static void C_ccall f_3444(C_word c,C_word *av) C_noret;
C_noret_decl(f_3447)
static void C_ccall f_3447(C_word c,C_word *av) C_noret;
C_noret_decl(f_4556)
static void C_ccall f_4556(C_word c,C_word *av) C_noret;
C_noret_decl(f_3841)
static void C_ccall f_3841(C_word c,C_word *av) C_noret;
C_noret_decl(f_3451)
static void C_ccall f_3451(C_word c,C_word *av) C_noret;
C_noret_decl(f_3847)
static void C_ccall f_3847(C_word c,C_word *av) C_noret;
C_noret_decl(f_7964)
static void C_fcall f_7964(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7960)
static void C_ccall f_7960(C_word c,C_word *av) C_noret;
C_noret_decl(f_7449)
static void C_fcall f_7449(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4549)
static void C_ccall f_4549(C_word c,C_word *av) C_noret;
C_noret_decl(f_7440)
static void C_ccall f_7440(C_word c,C_word *av) C_noret;
C_noret_decl(f_3854)
static void C_ccall f_3854(C_word c,C_word *av) C_noret;
C_noret_decl(f_3851)
static void C_ccall f_3851(C_word c,C_word *av) C_noret;
C_noret_decl(f_3426)
static void C_ccall f_3426(C_word c,C_word *av) C_noret;
C_noret_decl(f_3422)
static void C_ccall f_3422(C_word c,C_word *av) C_noret;
C_noret_decl(f_3857)
static void C_ccall f_3857(C_word c,C_word *av) C_noret;
C_noret_decl(f_7325)
static void C_ccall f_7325(C_word c,C_word *av) C_noret;
C_noret_decl(f_3824)
static void C_ccall f_3824(C_word c,C_word *av) C_noret;
C_noret_decl(f_3825)
static void C_ccall f_3825(C_word c,C_word *av) C_noret;
C_noret_decl(f_6472)
static void C_ccall f_6472(C_word c,C_word *av) C_noret;
C_noret_decl(f_2961)
static void C_ccall f_2961(C_word c,C_word *av) C_noret;
C_noret_decl(f_2963)
static void C_ccall f_2963(C_word c,C_word *av) C_noret;
C_noret_decl(f_3833)
static void C_ccall f_3833(C_word c,C_word *av) C_noret;
C_noret_decl(f_3404)
static void C_ccall f_3404(C_word c,C_word *av) C_noret;
C_noret_decl(f_2913)
static void C_ccall f_2913(C_word c,C_word *av) C_noret;
C_noret_decl(f_2911)
static void C_ccall f_2911(C_word c,C_word *av) C_noret;
C_noret_decl(f_4512)
static void C_ccall f_4512(C_word c,C_word *av) C_noret;
C_noret_decl(f_4375)
static void C_ccall f_4375(C_word c,C_word *av) C_noret;
C_noret_decl(f_4519)
static void C_ccall f_4519(C_word c,C_word *av) C_noret;
C_noret_decl(f_3808)
static void C_ccall f_3808(C_word c,C_word *av) C_noret;
C_noret_decl(f_5957)
static void C_ccall f_5957(C_word c,C_word *av) C_noret;
C_noret_decl(f_5958)
static void C_ccall f_5958(C_word c,C_word *av) C_noret;
C_noret_decl(f_2903)
static void C_ccall f_2903(C_word c,C_word *av) C_noret;
C_noret_decl(f_3815)
static void C_ccall f_3815(C_word c,C_word *av) C_noret;
C_noret_decl(f_5953)
static void C_ccall f_5953(C_word c,C_word *av) C_noret;
C_noret_decl(f_2931)
static void C_ccall f_2931(C_word c,C_word *av) C_noret;
C_noret_decl(f_2933)
static void C_ccall f_2933(C_word c,C_word *av) C_noret;
C_noret_decl(f_5963)
static void C_ccall f_5963(C_word c,C_word *av) C_noret;
C_noret_decl(f_7145)
static void C_ccall f_7145(C_word c,C_word *av) C_noret;
C_noret_decl(f_8277)
static void C_fcall f_8277(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8275)
static void C_fcall f_8275(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_4528)
static void C_ccall f_4528(C_word c,C_word *av) C_noret;
C_noret_decl(f_4522)
static void C_fcall f_4522(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4171)
static void C_fcall f_4171(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2951)
static void C_ccall f_2951(C_word c,C_word *av) C_noret;
C_noret_decl(f_7132)
static void C_ccall f_7132(C_word c,C_word *av) C_noret;
C_noret_decl(f_2953)
static void C_ccall f_2953(C_word c,C_word *av) C_noret;
C_noret_decl(f_4189)
static void C_ccall f_4189(C_word c,C_word *av) C_noret;
C_noret_decl(f_8282)
static C_word C_fcall f_8282(C_word t0,C_word t1);
C_noret_decl(f_5998)
static void C_ccall f_5998(C_word c,C_word *av) C_noret;
C_noret_decl(f_2941)
static void C_ccall f_2941(C_word c,C_word *av) C_noret;
C_noret_decl(f_2943)
static void C_ccall f_2943(C_word c,C_word *av) C_noret;
C_noret_decl(f_8291)
static C_word C_fcall f_8291(C_word t0,C_word t1);
C_noret_decl(f_5992)
static void C_ccall f_5992(C_word c,C_word *av) C_noret;
C_noret_decl(f_2971)
static void C_ccall f_2971(C_word c,C_word *av) C_noret;
C_noret_decl(f_2976)
static void C_ccall f_2976(C_word c,C_word *av) C_noret;
C_noret_decl(f_4141)
static void C_ccall f_4141(C_word c,C_word *av) C_noret;
C_noret_decl(f_4197)
static void C_ccall f_4197(C_word c,C_word *av) C_noret;
C_noret_decl(f_4131)
static void C_ccall f_4131(C_word c,C_word *av) C_noret;
C_noret_decl(f_4133)
static void C_ccall f_4133(C_word c,C_word *av) C_noret;
C_noret_decl(f_6904)
static void C_ccall f_6904(C_word c,C_word *av) C_noret;
C_noret_decl(f_6914)
static void C_fcall f_6914(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7290)
static void C_fcall f_7290(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2921)
static void C_ccall f_2921(C_word c,C_word *av) C_noret;
C_noret_decl(f_2923)
static void C_ccall f_2923(C_word c,C_word *av) C_noret;
C_noret_decl(f_5949)
static void C_ccall f_5949(C_word c,C_word *av) C_noret;
C_noret_decl(f_4108)
static void C_ccall f_4108(C_word c,C_word *av) C_noret;
C_noret_decl(f_8208)
static void C_fcall f_8208(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_8201)
static void C_ccall f_8201(C_word c,C_word *av) C_noret;
C_noret_decl(f_3678)
static void C_fcall f_3678(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3675)
static void C_fcall f_3675(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5919)
static void C_ccall f_5919(C_word c,C_word *av) C_noret;
C_noret_decl(f_4127)
static void C_ccall f_4127(C_word c,C_word *av) C_noret;
C_noret_decl(f_8212)
static void C_ccall f_8212(C_word c,C_word *av) C_noret;
C_noret_decl(f_8219)
static void C_ccall f_8219(C_word c,C_word *av) C_noret;
C_noret_decl(f_3687)
static void C_fcall f_3687(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3685)
static void C_ccall f_3685(C_word c,C_word *av) C_noret;
C_noret_decl(f_5913)
static void C_ccall f_5913(C_word c,C_word *av) C_noret;
C_noret_decl(f_5926)
static void C_ccall f_5926(C_word c,C_word *av) C_noret;
C_noret_decl(f_5928)
static void C_ccall f_5928(C_word c,C_word *av) C_noret;
C_noret_decl(f_4116)
static void C_ccall f_4116(C_word c,C_word *av) C_noret;
C_noret_decl(f_8225)
static void C_ccall f_8225(C_word c,C_word *av) C_noret;
C_noret_decl(f_5649)
static void C_ccall f_5649(C_word c,C_word *av) C_noret;
C_noret_decl(f_5977)
static void C_ccall f_5977(C_word c,C_word *av) C_noret;
C_noret_decl(f_5659)
static void C_ccall f_5659(C_word c,C_word *av) C_noret;
C_noret_decl(f_8231)
static void C_ccall f_8231(C_word c,C_word *av) C_noret;
C_noret_decl(f_8242)
static void C_ccall f_8242(C_word c,C_word *av) C_noret;
C_noret_decl(f_8246)
static void C_ccall f_8246(C_word c,C_word *av) C_noret;
C_noret_decl(f_4425)
static void C_ccall f_4425(C_word c,C_word *av) C_noret;
C_noret_decl(f_4428)
static void C_ccall f_4428(C_word c,C_word *av) C_noret;
C_noret_decl(f_8258)
static void C_ccall f_8258(C_word c,C_word *av) C_noret;
C_noret_decl(f_8254)
static void C_ccall f_8254(C_word c,C_word *av) C_noret;
C_noret_decl(f_3305)
static void C_ccall f_3305(C_word c,C_word *av) C_noret;
C_noret_decl(f_5678)
static void C_ccall f_5678(C_word c,C_word *av) C_noret;
C_noret_decl(f_8250)
static void C_ccall f_8250(C_word c,C_word *av) C_noret;
C_noret_decl(f_4412)
static void C_fcall f_4412(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3315)
static void C_ccall f_3315(C_word c,C_word *av) C_noret;
C_noret_decl(f_8262)
static void C_ccall f_8262(C_word c,C_word *av) C_noret;
C_noret_decl(f_4408)
static void C_ccall f_4408(C_word c,C_word *av) C_noret;
C_noret_decl(f_3975)
static void C_ccall f_3975(C_word c,C_word *av) C_noret;
C_noret_decl(f_3971)
static void C_ccall f_3971(C_word c,C_word *av) C_noret;
C_noret_decl(f_3321)
static void C_ccall f_3321(C_word c,C_word *av) C_noret;
C_noret_decl(f_5619)
static void C_ccall f_5619(C_word c,C_word *av) C_noret;
C_noret_decl(f_7283)
static void C_ccall f_7283(C_word c,C_word *av) C_noret;
C_noret_decl(f_5623)
static void C_ccall f_5623(C_word c,C_word *av) C_noret;
C_noret_decl(f_3900)
static void C_fcall f_3900(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3331)
static void C_ccall f_3331(C_word c,C_word *av) C_noret;
C_noret_decl(f_3333)
static void C_fcall f_3333(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5629)
static void C_ccall f_5629(C_word c,C_word *av) C_noret;
C_noret_decl(f_5626)
static void C_ccall f_5626(C_word c,C_word *av) C_noret;
C_noret_decl(f_5634)
static void C_fcall f_5634(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3340)
static void C_fcall f_3340(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3343)
static void C_ccall f_3343(C_word c,C_word *av) C_noret;
C_noret_decl(f_3919)
static void C_ccall f_3919(C_word c,C_word *av) C_noret;
C_noret_decl(f_4219)
static void C_ccall f_4219(C_word c,C_word *av) C_noret;
C_noret_decl(f_3923)
static void C_ccall f_3923(C_word c,C_word *av) C_noret;
C_noret_decl(f_3359)
static void C_ccall f_3359(C_word c,C_word *av) C_noret;
C_noret_decl(f_4449)
static void C_ccall f_4449(C_word c,C_word *av) C_noret;
C_noret_decl(f_4440)
static void C_ccall f_4440(C_word c,C_word *av) C_noret;
C_noret_decl(f_4201)
static void C_ccall f_4201(C_word c,C_word *av) C_noret;
C_noret_decl(f_3366)
static void C_ccall f_3366(C_word c,C_word *av) C_noret;
C_noret_decl(f_5909)
static void C_ccall f_5909(C_word c,C_word *av) C_noret;
C_noret_decl(f_7796)
static void C_ccall f_7796(C_word c,C_word *av) C_noret;
C_noret_decl(f_7799)
static void C_ccall f_7799(C_word c,C_word *av) C_noret;
C_noret_decl(f_3944)
static void C_ccall f_3944(C_word c,C_word *av) C_noret;
C_noret_decl(f_3940)
static void C_ccall f_3940(C_word c,C_word *av) C_noret;
C_noret_decl(f_4272)
static void C_ccall f_4272(C_word c,C_word *av) C_noret;
C_noret_decl(f_5903)
static void C_ccall f_5903(C_word c,C_word *av) C_noret;
C_noret_decl(f_4163)
static void C_ccall f_4163(C_word c,C_word *av) C_noret;
C_noret_decl(f_4266)
static void C_ccall f_4266(C_word c,C_word *av) C_noret;
C_noret_decl(f_4153)
static void C_ccall f_4153(C_word c,C_word *av) C_noret;
C_noret_decl(f_5683)
static void C_ccall f_5683(C_word c,C_word *av) C_noret;
C_noret_decl(f_5687)
static void C_ccall f_5687(C_word c,C_word *av) C_noret;
C_noret_decl(f_5692)
static void C_fcall f_5692(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4159)
static void C_fcall f_4159(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7756)
static void C_ccall f_7756(C_word c,C_word *av) C_noret;
C_noret_decl(f_8179)
static void C_ccall f_8179(C_word c,C_word *av) C_noret;
C_noret_decl(f_8173)
static void C_ccall f_8173(C_word c,C_word *av) C_noret;
C_noret_decl(f_5392)
static void C_ccall f_5392(C_word c,C_word *av) C_noret;
C_noret_decl(f_8175)
static void C_ccall f_8175(C_word c,C_word *av) C_noret;
C_noret_decl(f_5396)
static void C_ccall f_5396(C_word c,C_word *av) C_noret;
C_noret_decl(f_5192)
static void C_ccall f_5192(C_word c,C_word *av) C_noret;
C_noret_decl(f_5197)
static void C_ccall f_5197(C_word c,C_word *av) C_noret;
C_noret_decl(f_5360)
static void C_ccall f_5360(C_word c,C_word *av) C_noret;
C_noret_decl(f_8185)
static void C_ccall f_8185(C_word c,C_word *av) C_noret;
C_noret_decl(f_6098)
static void C_ccall f_6098(C_word c,C_word *av) C_noret;
C_noret_decl(f_8182)
static void C_ccall f_8182(C_word c,C_word *av) C_noret;
C_noret_decl(f_7778)
static void C_ccall f_7778(C_word c,C_word *av) C_noret;
C_noret_decl(f_8197)
static void C_fcall f_8197(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_5376)
static void C_ccall f_5376(C_word c,C_word *av) C_noret;
C_noret_decl(f_5173)
static void C_ccall f_5173(C_word c,C_word *av) C_noret;
C_noret_decl(f_5179)
static void C_ccall f_5179(C_word c,C_word *av) C_noret;
C_noret_decl(f_6691)
static void C_ccall f_6691(C_word c,C_word *av) C_noret;
C_noret_decl(f_6079)
static void C_ccall f_6079(C_word c,C_word *av) C_noret;
C_noret_decl(f_7719)
static void C_ccall f_7719(C_word c,C_word *av) C_noret;
C_noret_decl(f_7710)
static void C_fcall f_7710(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5183)
static void C_ccall f_5183(C_word c,C_word *av) C_noret;
C_noret_decl(f_5188)
static void C_ccall f_5188(C_word c,C_word *av) C_noret;
C_noret_decl(f_7928)
static void C_ccall f_7928(C_word c,C_word *av) C_noret;
C_noret_decl(f_6666)
static void C_ccall f_6666(C_word c,C_word *av) C_noret;
C_noret_decl(f_7786)
static void C_fcall f_7786(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6665)
static void C_ccall f_6665(C_word c,C_word *av) C_noret;
C_noret_decl(f_7781)
static void C_ccall f_7781(C_word c,C_word *av) C_noret;
C_noret_decl(f_6083)
static void C_ccall f_6083(C_word c,C_word *av) C_noret;
C_noret_decl(f_6672)
static void C_ccall f_6672(C_word c,C_word *av) C_noret;
C_noret_decl(f_7733)
static void C_fcall f_7733(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3588)
static void C_ccall f_3588(C_word c,C_word *av) C_noret;
C_noret_decl(f_3582)
static void C_ccall f_3582(C_word c,C_word *av) C_noret;
C_noret_decl(f_5303)
static void C_ccall f_5303(C_word c,C_word *av) C_noret;
C_noret_decl(f_3599)
static void C_ccall f_3599(C_word c,C_word *av) C_noret;
C_noret_decl(f_3592)
static void C_ccall f_3592(C_word c,C_word *av) C_noret;
C_noret_decl(f_5117)
static void C_ccall f_5117(C_word c,C_word *av) C_noret;
C_noret_decl(f_5110)
static void C_ccall f_5110(C_word c,C_word *av) C_noret;
C_noret_decl(f_8106)
static void C_ccall f_8106(C_word c,C_word *av) C_noret;
C_noret_decl(f_8100)
static void C_ccall f_8100(C_word c,C_word *av) C_noret;
C_noret_decl(f_6018)
static void C_ccall f_6018(C_word c,C_word *av) C_noret;
C_noret_decl(f_5125)
static void C_ccall f_5125(C_word c,C_word *av) C_noret;
C_noret_decl(f_6341)
static void C_ccall f_6341(C_word c,C_word *av) C_noret;
C_noret_decl(f_8030)
static void C_ccall f_8030(C_word c,C_word *av) C_noret;
C_noret_decl(f_6024)
static void C_ccall f_6024(C_word c,C_word *av) C_noret;
C_noret_decl(f_8111)
static void C_fcall f_8111(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6357)
static void C_ccall f_6357(C_word c,C_word *av) C_noret;
C_noret_decl(f_6353)
static void C_ccall f_6353(C_word c,C_word *av) C_noret;
C_noret_decl(f_8004)
static void C_fcall f_8004(C_word t0,C_word t1) C_noret;
C_noret_decl(f_8000)
static void C_ccall f_8000(C_word c,C_word *av) C_noret;
C_noret_decl(f_3135)
static void C_ccall f_3135(C_word c,C_word *av) C_noret;
C_noret_decl(f_8007)
static void C_ccall f_8007(C_word c,C_word *av) C_noret;
C_noret_decl(f_6448)
static void C_ccall f_6448(C_word c,C_word *av) C_noret;
C_noret_decl(f_6444)
static void C_ccall f_6444(C_word c,C_word *av) C_noret;
C_noret_decl(f_8123)
static void C_fcall f_8123(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_8122)
static void C_ccall f_8122(C_word c,C_word *av) C_noret;
C_noret_decl(f_2739)
static void C_ccall f_2739(C_word c,C_word *av) C_noret;
C_noret_decl(f_8050)
static void C_ccall f_8050(C_word c,C_word *av) C_noret;
C_noret_decl(f_8054)
static void C_fcall f_8054(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_5101)
static void C_ccall f_5101(C_word c,C_word *av) C_noret;
C_noret_decl(f_5352)
static void C_ccall f_5352(C_word c,C_word *av) C_noret;
C_noret_decl(f_5354)
static void C_ccall f_5354(C_word c,C_word *av) C_noret;
C_noret_decl(f_6457)
static void C_fcall f_6457(C_word t0,C_word t1) C_noret;
C_noret_decl(f_8056)
static void C_ccall f_8056(C_word c,C_word *av) C_noret;
C_noret_decl(f_8134)
static void C_ccall f_8134(C_word c,C_word *av) C_noret;
C_noret_decl(f_8138)
static C_word C_fcall f_8138(C_word *a,C_word t0);
C_noret_decl(f_6006)
static void C_ccall f_6006(C_word c,C_word *av) C_noret;
C_noret_decl(f_6008)
static void C_fcall f_6008(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6331)
static void C_ccall f_6331(C_word c,C_word *av) C_noret;
C_noret_decl(f_8026)
static void C_ccall f_8026(C_word c,C_word *av) C_noret;
C_noret_decl(f_3152)
static void C_ccall f_3152(C_word c,C_word *av) C_noret;
C_noret_decl(f_3158)
static void C_ccall f_3158(C_word c,C_word *av) C_noret;
C_noret_decl(f_6426)
static void C_ccall f_6426(C_word c,C_word *av) C_noret;
C_noret_decl(f_2752)
static void C_ccall f_2752(C_word c,C_word *av) C_noret;
C_noret_decl(f_2759)
static void C_ccall f_2759(C_word c,C_word *av) C_noret;
C_noret_decl(f_8071)
static void C_ccall f_8071(C_word c,C_word *av) C_noret;
C_noret_decl(f_8159)
static void C_ccall f_8159(C_word c,C_word *av) C_noret;
C_noret_decl(f_8077)
static void C_ccall f_8077(C_word c,C_word *av) C_noret;
C_noret_decl(f_8705)
static void C_ccall f_8705(C_word c,C_word *av) C_noret;
C_noret_decl(f_8703)
static void C_ccall f_8703(C_word c,C_word *av) C_noret;
C_noret_decl(f_8156)
static void C_ccall f_8156(C_word c,C_word *av) C_noret;
C_noret_decl(f_5327)
static C_word C_fcall f_5327(C_word t0);
C_noret_decl(f_2743)
static void C_ccall f_2743(C_word c,C_word *av) C_noret;
C_noret_decl(f_8152)
static void C_fcall f_8152(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7) C_noret;
C_noret_decl(f_6319)
static void C_ccall f_6319(C_word c,C_word *av) C_noret;
C_noret_decl(f_8715)
static void C_ccall f_8715(C_word c,C_word *av) C_noret;
C_noret_decl(f_8162)
static void C_ccall f_8162(C_word c,C_word *av) C_noret;
C_noret_decl(f_8091)
static void C_fcall f_8091(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5869)
static void C_ccall f_5869(C_word c,C_word *av) C_noret;
C_noret_decl(f_3185)
static void C_ccall f_3185(C_word c,C_word *av) C_noret;
C_noret_decl(f_8725)
static void C_ccall f_8725(C_word c,C_word *av) C_noret;
C_noret_decl(f_4962)
static void C_ccall f_4962(C_word c,C_word *av) C_noret;
C_noret_decl(f_3198)
static void C_ccall f_3198(C_word c,C_word *av) C_noret;
C_noret_decl(f_2711)
static void C_ccall f_2711(C_word c,C_word *av) C_noret;
C_noret_decl(f_2714)
static void C_fcall f_2714(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_2718)
static void C_ccall f_2718(C_word c,C_word *av) C_noret;
C_noret_decl(f_3126)
static void C_ccall f_3126(C_word c,C_word *av) C_noret;
C_noret_decl(f_4969)
static void C_ccall f_4969(C_word c,C_word *av) C_noret;
C_noret_decl(f_4981)
static void C_ccall f_4981(C_word c,C_word *av) C_noret;
C_noret_decl(f_2700)
static void C_ccall f_2700(C_word c,C_word *av) C_noret;
C_noret_decl(f_2707)
static void C_ccall f_2707(C_word c,C_word *av) C_noret;
C_noret_decl(f_7591)
static void C_ccall f_7591(C_word c,C_word *av) C_noret;
C_noret_decl(f_7595)
static void C_ccall f_7595(C_word c,C_word *av) C_noret;
C_noret_decl(f_5891)
static void C_ccall f_5891(C_word c,C_word *av) C_noret;
C_noret_decl(f_5897)
static void C_ccall f_5897(C_word c,C_word *av) C_noret;
C_noret_decl(f_4972)
static void C_ccall f_4972(C_word c,C_word *av) C_noret;
C_noret_decl(f_7080)
static void C_ccall f_7080(C_word c,C_word *av) C_noret;
C_noret_decl(f_4988)
static void C_ccall f_4988(C_word c,C_word *av) C_noret;
C_noret_decl(f_7021)
static void C_ccall f_7021(C_word c,C_word *av) C_noret;
C_noret_decl(f_5845)
static void C_ccall f_5845(C_word c,C_word *av) C_noret;
C_noret_decl(f_5843)
static void C_ccall f_5843(C_word c,C_word *av) C_noret;
C_noret_decl(f_7025)
static void C_ccall f_7025(C_word c,C_word *av) C_noret;
C_noret_decl(f_3168)
static void C_ccall f_3168(C_word c,C_word *av) C_noret;
C_noret_decl(f_3165)
static void C_fcall f_3165(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3479)
static void C_ccall f_3479(C_word c,C_word *av) C_noret;
C_noret_decl(f_6039)
static void C_ccall f_6039(C_word c,C_word *av) C_noret;
C_noret_decl(f_6036)
static void C_ccall f_6036(C_word c,C_word *av) C_noret;
C_noret_decl(f_6033)
static void C_ccall f_6033(C_word c,C_word *av) C_noret;
C_noret_decl(f_3108)
static void C_ccall f_3108(C_word c,C_word *av) C_noret;
C_noret_decl(f_6045)
static void C_ccall f_6045(C_word c,C_word *av) C_noret;
C_noret_decl(f_5871)
static void C_fcall f_5871(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3110)
static void C_ccall f_3110(C_word c,C_word *av) C_noret;
C_noret_decl(f_5881)
static void C_ccall f_5881(C_word c,C_word *av) C_noret;
C_noret_decl(f_5889)
static void C_ccall f_5889(C_word c,C_word *av) C_noret;
C_noret_decl(f_7869)
static void C_ccall f_7869(C_word c,C_word *av) C_noret;
C_noret_decl(f_7511)
static void C_fcall f_7511(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2992)
static void C_ccall f_2992(C_word c,C_word *av) C_noret;
C_noret_decl(f_2998)
static void C_ccall f_2998(C_word c,C_word *av) C_noret;
C_noret_decl(f_7003)
static void C_fcall f_7003(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5822)
static void C_ccall f_5822(C_word c,C_word *av) C_noret;
C_noret_decl(f_8678)
static void C_ccall f_8678(C_word c,C_word *av) C_noret;
C_noret_decl(f_3491)
static void C_fcall f_3491(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2980)
static void C_fcall f_2980(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5159)
static void C_ccall f_5159(C_word c,C_word *av) C_noret;
C_noret_decl(f_5155)
static void C_ccall f_5155(C_word c,C_word *av) C_noret;
C_noret_decl(f_3731)
static void C_ccall f_3731(C_word c,C_word *av) C_noret;
C_noret_decl(f_3734)
static void C_ccall f_3734(C_word c,C_word *av) C_noret;

C_noret_decl(trf_4823)
static void C_ccall trf_4823(C_word c,C_word *av) C_noret;
static void C_ccall trf_4823(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_4823(t0,t1);}

C_noret_decl(trf_7828)
static void C_ccall trf_7828(C_word c,C_word *av) C_noret;
static void C_ccall trf_7828(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_7828(t0,t1,t2,t3);}

C_noret_decl(trf_7230)
static void C_ccall trf_7230(C_word c,C_word *av) C_noret;
static void C_ccall trf_7230(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_7230(t0,t1);}

C_noret_decl(trf_3249)
static void C_ccall trf_3249(C_word c,C_word *av) C_noret;
static void C_ccall trf_3249(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_3249(t0,t1,t2);}

C_noret_decl(trf_3225)
static void C_ccall trf_3225(C_word c,C_word *av) C_noret;
static void C_ccall trf_3225(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_3225(t0,t1);}

C_noret_decl(trf_5569)
static void C_ccall trf_5569(C_word c,C_word *av) C_noret;
static void C_ccall trf_5569(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_5569(t0,t1,t2);}

C_noret_decl(trf_3273)
static void C_ccall trf_3273(C_word c,C_word *av) C_noret;
static void C_ccall trf_3273(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_3273(t0,t1,t2);}

C_noret_decl(trf_6811)
static void C_ccall trf_6811(C_word c,C_word *av) C_noret;
static void C_ccall trf_6811(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_6811(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5546)
static void C_ccall trf_5546(C_word c,C_word *av) C_noret;
static void C_ccall trf_5546(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_5546(t0,t1);}

C_noret_decl(trf_5015)
static void C_ccall trf_5015(C_word c,C_word *av) C_noret;
static void C_ccall trf_5015(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_5015(t0,t1,t2,t3,t4);}

C_noret_decl(trf_8594)
static void C_ccall trf_8594(C_word c,C_word *av) C_noret;
static void C_ccall trf_8594(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_8594(t0,t1,t2,t3);}

C_noret_decl(trf_4762)
static void C_ccall trf_4762(C_word c,C_word *av) C_noret;
static void C_ccall trf_4762(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_4762(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4791)
static void C_ccall trf_4791(C_word c,C_word *av) C_noret;
static void C_ccall trf_4791(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_4791(t0,t1);}

C_noret_decl(trf_4732)
static void C_ccall trf_4732(C_word c,C_word *av) C_noret;
static void C_ccall trf_4732(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_4732(t0,t1);}

C_noret_decl(trf_6192)
static void C_ccall trf_6192(C_word c,C_word *av) C_noret;
static void C_ccall trf_6192(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_6192(t0,t1);}

C_noret_decl(trf_4673)
static void C_ccall trf_4673(C_word c,C_word *av) C_noret;
static void C_ccall trf_4673(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_4673(t0,t1);}

C_noret_decl(trf_6155)
static void C_ccall trf_6155(C_word c,C_word *av) C_noret;
static void C_ccall trf_6155(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_6155(t0,t1);}

C_noret_decl(trf_4591)
static void C_ccall trf_4591(C_word c,C_word *av) C_noret;
static void C_ccall trf_4591(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_4591(t0,t1);}

C_noret_decl(trf_3622)
static void C_ccall trf_3622(C_word c,C_word *av) C_noret;
static void C_ccall trf_3622(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_3622(t0,t1,t2);}

C_noret_decl(trf_3601)
static void C_ccall trf_3601(C_word c,C_word *av) C_noret;
static void C_ccall trf_3601(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_3601(t0,t1,t2);}

C_noret_decl(trf_4703)
static void C_ccall trf_4703(C_word c,C_word *av) C_noret;
static void C_ccall trf_4703(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_4703(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4585)
static void C_ccall trf_4585(C_word c,C_word *av) C_noret;
static void C_ccall trf_4585(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_4585(t0,t1);}

C_noret_decl(trf_4588)
static void C_ccall trf_4588(C_word c,C_word *av) C_noret;
static void C_ccall trf_4588(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_4588(t0,t1);}

C_noret_decl(trf_3067)
static void C_ccall trf_3067(C_word c,C_word *av) C_noret;
static void C_ccall trf_3067(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_3067(t0,t1,t2,t3,t4);}

C_noret_decl(trf_6960)
static void C_ccall trf_6960(C_word c,C_word *av) C_noret;
static void C_ccall trf_6960(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_6960(t0,t1);}

C_noret_decl(trf_3030)
static void C_ccall trf_3030(C_word c,C_word *av) C_noret;
static void C_ccall trf_3030(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_3030(t0,t1,t2,t3);}

C_noret_decl(trf_6732)
static void C_ccall trf_6732(C_word c,C_word *av) C_noret;
static void C_ccall trf_6732(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_6732(t0,t1);}

C_noret_decl(trf_6939)
static void C_ccall trf_6939(C_word c,C_word *av) C_noret;
static void C_ccall trf_6939(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_6939(t0,t1,t2,t3);}

C_noret_decl(trf_5453)
static void C_ccall trf_5453(C_word c,C_word *av) C_noret;
static void C_ccall trf_5453(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_5453(t0,t1);}

C_noret_decl(trf_3567)
static void C_ccall trf_3567(C_word c,C_word *av) C_noret;
static void C_ccall trf_3567(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_3567(t0,t1,t2);}

C_noret_decl(trf_7115)
static void C_ccall trf_7115(C_word c,C_word *av) C_noret;
static void C_ccall trf_7115(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_7115(t0,t1);}

C_noret_decl(trf_6376)
static void C_ccall trf_6376(C_word c,C_word *av) C_noret;
static void C_ccall trf_6376(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_6376(t0,t1);}

C_noret_decl(trf_6378)
static void C_ccall trf_6378(C_word c,C_word *av) C_noret;
static void C_ccall trf_6378(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_6378(t0,t1,t2,t3,t4);}

C_noret_decl(trf_3465)
static void C_ccall trf_3465(C_word c,C_word *av) C_noret;
static void C_ccall trf_3465(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_3465(t0,t1);}

C_noret_decl(trf_7437)
static void C_ccall trf_7437(C_word c,C_word *av) C_noret;
static void C_ccall trf_7437(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_7437(t0,t1);}

C_noret_decl(trf_7964)
static void C_ccall trf_7964(C_word c,C_word *av) C_noret;
static void C_ccall trf_7964(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_7964(t0,t1);}

C_noret_decl(trf_7449)
static void C_ccall trf_7449(C_word c,C_word *av) C_noret;
static void C_ccall trf_7449(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_7449(t0,t1);}

C_noret_decl(trf_8277)
static void C_ccall trf_8277(C_word c,C_word *av) C_noret;
static void C_ccall trf_8277(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_8277(t0,t1,t2);}

C_noret_decl(trf_8275)
static void C_ccall trf_8275(C_word c,C_word *av) C_noret;
static void C_ccall trf_8275(C_word c,C_word *av){
C_word t0=av[6];
C_word t1=av[5];
C_word t2=av[4];
C_word t3=av[3];
C_word t4=av[2];
C_word t5=av[1];
C_word t6=av[0];
f_8275(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_4522)
static void C_ccall trf_4522(C_word c,C_word *av) C_noret;
static void C_ccall trf_4522(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_4522(t0,t1);}

C_noret_decl(trf_4171)
static void C_ccall trf_4171(C_word c,C_word *av) C_noret;
static void C_ccall trf_4171(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_4171(t0,t1,t2);}

C_noret_decl(trf_6914)
static void C_ccall trf_6914(C_word c,C_word *av) C_noret;
static void C_ccall trf_6914(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_6914(t0,t1);}

C_noret_decl(trf_7290)
static void C_ccall trf_7290(C_word c,C_word *av) C_noret;
static void C_ccall trf_7290(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_7290(t0,t1);}

C_noret_decl(trf_8208)
static void C_ccall trf_8208(C_word c,C_word *av) C_noret;
static void C_ccall trf_8208(C_word c,C_word *av){
C_word t0=av[6];
C_word t1=av[5];
C_word t2=av[4];
C_word t3=av[3];
C_word t4=av[2];
C_word t5=av[1];
C_word t6=av[0];
f_8208(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_3678)
static void C_ccall trf_3678(C_word c,C_word *av) C_noret;
static void C_ccall trf_3678(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_3678(t0,t1);}

C_noret_decl(trf_3675)
static void C_ccall trf_3675(C_word c,C_word *av) C_noret;
static void C_ccall trf_3675(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_3675(t0,t1);}

C_noret_decl(trf_3687)
static void C_ccall trf_3687(C_word c,C_word *av) C_noret;
static void C_ccall trf_3687(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_3687(t0,t1,t2,t3,t4);}

C_noret_decl(trf_4412)
static void C_ccall trf_4412(C_word c,C_word *av) C_noret;
static void C_ccall trf_4412(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_4412(t0,t1);}

C_noret_decl(trf_3900)
static void C_ccall trf_3900(C_word c,C_word *av) C_noret;
static void C_ccall trf_3900(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_3900(t0,t1,t2);}

C_noret_decl(trf_3333)
static void C_ccall trf_3333(C_word c,C_word *av) C_noret;
static void C_ccall trf_3333(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_3333(t0,t1,t2);}

C_noret_decl(trf_5634)
static void C_ccall trf_5634(C_word c,C_word *av) C_noret;
static void C_ccall trf_5634(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_5634(t0,t1,t2);}

C_noret_decl(trf_3340)
static void C_ccall trf_3340(C_word c,C_word *av) C_noret;
static void C_ccall trf_3340(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_3340(t0,t1);}

C_noret_decl(trf_5692)
static void C_ccall trf_5692(C_word c,C_word *av) C_noret;
static void C_ccall trf_5692(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_5692(t0,t1,t2,t3);}

C_noret_decl(trf_4159)
static void C_ccall trf_4159(C_word c,C_word *av) C_noret;
static void C_ccall trf_4159(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_4159(t0,t1,t2);}

C_noret_decl(trf_8197)
static void C_ccall trf_8197(C_word c,C_word *av) C_noret;
static void C_ccall trf_8197(C_word c,C_word *av){
C_word t0=av[6];
C_word t1=av[5];
C_word t2=av[4];
C_word t3=av[3];
C_word t4=av[2];
C_word t5=av[1];
C_word t6=av[0];
f_8197(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_7710)
static void C_ccall trf_7710(C_word c,C_word *av) C_noret;
static void C_ccall trf_7710(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_7710(t0,t1,t2,t3);}

C_noret_decl(trf_7786)
static void C_ccall trf_7786(C_word c,C_word *av) C_noret;
static void C_ccall trf_7786(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_7786(t0,t1,t2,t3);}

C_noret_decl(trf_7733)
static void C_ccall trf_7733(C_word c,C_word *av) C_noret;
static void C_ccall trf_7733(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_7733(t0,t1,t2,t3);}

C_noret_decl(trf_8111)
static void C_ccall trf_8111(C_word c,C_word *av) C_noret;
static void C_ccall trf_8111(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_8111(t0,t1,t2);}

C_noret_decl(trf_8004)
static void C_ccall trf_8004(C_word c,C_word *av) C_noret;
static void C_ccall trf_8004(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_8004(t0,t1);}

C_noret_decl(trf_8123)
static void C_ccall trf_8123(C_word c,C_word *av) C_noret;
static void C_ccall trf_8123(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_8123(t0,t1,t2,t3);}

C_noret_decl(trf_8054)
static void C_ccall trf_8054(C_word c,C_word *av) C_noret;
static void C_ccall trf_8054(C_word c,C_word *av){
C_word t0=av[6];
C_word t1=av[5];
C_word t2=av[4];
C_word t3=av[3];
C_word t4=av[2];
C_word t5=av[1];
C_word t6=av[0];
f_8054(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_6457)
static void C_ccall trf_6457(C_word c,C_word *av) C_noret;
static void C_ccall trf_6457(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_6457(t0,t1);}

C_noret_decl(trf_6008)
static void C_ccall trf_6008(C_word c,C_word *av) C_noret;
static void C_ccall trf_6008(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_6008(t0,t1,t2,t3);}

C_noret_decl(trf_8152)
static void C_ccall trf_8152(C_word c,C_word *av) C_noret;
static void C_ccall trf_8152(C_word c,C_word *av){
C_word t0=av[7];
C_word t1=av[6];
C_word t2=av[5];
C_word t3=av[4];
C_word t4=av[3];
C_word t5=av[2];
C_word t6=av[1];
C_word t7=av[0];
f_8152(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(trf_8091)
static void C_ccall trf_8091(C_word c,C_word *av) C_noret;
static void C_ccall trf_8091(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_8091(t0,t1);}

C_noret_decl(trf_2714)
static void C_ccall trf_2714(C_word c,C_word *av) C_noret;
static void C_ccall trf_2714(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_2714(t0,t1,t2,t3,t4);}

C_noret_decl(trf_3165)
static void C_ccall trf_3165(C_word c,C_word *av) C_noret;
static void C_ccall trf_3165(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_3165(t0,t1);}

C_noret_decl(trf_5871)
static void C_ccall trf_5871(C_word c,C_word *av) C_noret;
static void C_ccall trf_5871(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_5871(t0,t1,t2,t3);}

C_noret_decl(trf_7511)
static void C_ccall trf_7511(C_word c,C_word *av) C_noret;
static void C_ccall trf_7511(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_7511(t0,t1,t2);}

C_noret_decl(trf_7003)
static void C_ccall trf_7003(C_word c,C_word *av) C_noret;
static void C_ccall trf_7003(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_7003(t0,t1,t2,t3);}

C_noret_decl(trf_3491)
static void C_ccall trf_3491(C_word c,C_word *av) C_noret;
static void C_ccall trf_3491(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_3491(t0,t1);}

C_noret_decl(trf_2980)
static void C_ccall trf_2980(C_word c,C_word *av) C_noret;
static void C_ccall trf_2980(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_2980(t0,t1);}

/* k4821 in k4597 in k4589 in k4586 in k4583 in file-select in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_4823(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(!C_demand(C_calculate_demand(15,0,6))){
C_save_and_reclaim_args((void *)trf_4823,2,t0,t1);}
a=C_alloc(15);
t2=(C_truep(((C_word*)t0)[2])?C_i_foreign_block_argumentp(((C_word*)t0)[2]):C_SCHEME_FALSE);
t3=C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
t4=C_i_foreign_fixnum_argumentp(t1);
t5=stub908(C_SCHEME_UNDEFINED,t2,t3,t4);
if(C_truep(C_fixnum_lessp(t5,C_fix(0)))){
/* posixunix.scm:592: posix-error */
t6=lf[0];{
C_word av2[7];
av2[0]=t6;
av2[1]=((C_word*)t0)[4];
av2[2]=lf[8];
av2[3]=lf[182];
av2[4]=lf[183];
av2[5]=((C_word*)t0)[5];
av2[6]=((C_word*)t0)[6];
f_2696(7,av2);}}
else{
t6=C_eqp(t5,C_fix(0));
if(C_truep(t6)){
t7=C_i_pairp(((C_word*)t0)[5]);
t8=(C_truep(t7)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
if(C_truep(C_i_pairp(((C_word*)t0)[6]))){
/* posixunix.scm:593: values */{
C_word av2[4];
av2[0]=0;
av2[1]=((C_word*)t0)[4];
av2[2]=t8;
av2[3]=C_SCHEME_END_OF_LIST;
C_values(4,av2);}}
else{
/* posixunix.scm:593: values */{
C_word av2[4];
av2[0]=0;
av2[1]=((C_word*)t0)[4];
av2[2]=t8;
av2[3]=C_SCHEME_FALSE;
C_values(4,av2);}}}
else{
t7=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4663,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[2],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
t8=C_SCHEME_UNDEFINED;
t9=(*a=C_VECTOR_TYPE|1,a[1]=t8,tmp=(C_word)a,a+=2,tmp);
t10=C_set_block_item(t9,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4762,a[2]=t9,a[3]=((C_word*)t0)[2],a[4]=((C_word)li84),tmp=(C_word)a,a+=5,tmp));
t11=((C_word*)t9)[1];
f_4762(t11,t7,C_fix(0),C_SCHEME_END_OF_LIST,((C_word*)t0)[9]);}}}

/* k5166 in call-with-output-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5168(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_5168,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5173,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word)li96),tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5179,a[2]=t2,a[3]=((C_word)li97),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:693: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[3];
av2[2]=t3;
av2[3]=t4;
C_call_with_values(4,av2);}}

/* a8698 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8699(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(3,c,5))){C_save_and_reclaim((void *)f_8699,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8703,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:253: ##sys#stat */
f_2714(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[17]);}

/* call-with-output-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5164(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +4,c,4))){
C_save_and_reclaim((void*)f_5164,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+4);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5168,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t5;
av2[2]=*((C_word*)lf[196]+1);
av2[3]=t2;
av2[4]=t4;
C_apply(5,av2);}}

/* k3698 in loop in k3683 in k3676 in k3673 in k3864 in k3861 in k3858 in k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3700(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(15,c,2))){C_save_and_reclaim((void *)f_3700,2,av);}
a=C_alloc(15);
t2=t1;
t3=C_slot(((C_word*)t0)[2],C_fix(1));
t4=t3;
t5=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_3709,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=t4,a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=t2,a[11]=((C_word*)t0)[10],a[12]=((C_word*)t0)[11],a[13]=((C_word*)t0)[12],a[14]=((C_word*)t0)[13],tmp=(C_word)a,a+=15,tmp);
/* posix-common.scm:536: directory? */
t6=*((C_word*)lf[37]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}

/* k3707 in k3698 in loop in k3683 in k3676 in k3673 in k3864 in k3861 in k3858 in k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3709(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(14,c,4))){C_save_and_reclaim((void *)f_3709,2,av);}
a=C_alloc(14);
if(C_truep(t1)){
if(C_truep((C_truep(C_i_equalp(((C_word*)t0)[2],lf[93]))?C_SCHEME_TRUE:(C_truep(C_i_equalp(((C_word*)t0)[2],lf[94]))?C_SCHEME_TRUE:C_SCHEME_FALSE)))){
/* posix-common.scm:537: loop */
t2=((C_word*)((C_word*)t0)[3])[1];
f_3687(t2,((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],((C_word*)t0)[7]);}
else{
t2=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_3799,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[7],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[12],a[12]=((C_word*)t0)[13],a[13]=((C_word*)t0)[14],tmp=(C_word)a,a+=14,tmp);
/* posix-common.scm:538: symbolic-link? */
t3=*((C_word*)lf[32]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[10];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}}
else{
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3808,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[10],a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
/* posix-common.scm:548: pproc */
t3=((C_word*)t0)[11];{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[10];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}}

/* doloop1921 in k7794 in doloop1917 in k7779 in k7776 in process-execute in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 in ... */
static void C_fcall f_7828(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(6,0,4))){
C_save_and_reclaim_args((void *)trf_7828,4,t0,t1,t2,t3);}
a=C_alloc(6);
if(C_truep(C_i_nullp(t2))){
/* posixunix.scm:1616: setenv */
f_7733(t1,t3,C_SCHEME_FALSE,C_fix(0));}
else{
t4=C_i_car(t2);
t5=C_i_check_string_2(t4,lf[414]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7847,a[2]=t2,a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t7=C_block_size(t4);
/* posixunix.scm:1619: setenv */
f_7733(t6,t3,t4,t7);}}

/* k5130 in close-output-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5132(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_5132,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k3751 in k3741 in k3797 in k3707 in k3698 in loop in k3683 in k3676 in k3673 in k3864 in k3861 in k3858 in k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in ... */
static void C_ccall f_3753(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_3753,2,av);}
/* posix-common.scm:541: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3687(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],t1);}

/* a3754 in k3741 in k3797 in k3707 in k3698 in loop in k3683 in k3676 in k3673 in k3864 in k3861 in k3858 in k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in ... */
static void C_ccall f_3755(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3755,2,av);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate2(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[4])[1]);
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* current-process-id in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4236(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_4236,2,av);}
t2=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_fudge(C_fix(33));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4234(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word *a;
if(!C_demand(C_calculate_demand(167,c,6))){C_save_and_reclaim((void *)f_4234,2,av);}
a=C_alloc(167);
t2=C_mutate2((C_word*)lf[123]+1 /* (set! signal-handler ...) */,t1);
t3=C_mutate2((C_word*)lf[124]+1 /* (set! current-process-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4236,a[2]=((C_word)li68),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate2((C_word*)lf[125]+1 /* (set! process-wait ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4242,a[2]=((C_word)li71),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate2((C_word*)lf[129]+1 /* (set! ##sys#file-nonblocking! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4311,a[2]=((C_word)li72),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate2((C_word*)lf[130]+1 /* (set! ##sys#file-select-one ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4318,a[2]=((C_word)li73),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate2((C_word*)lf[131]+1 /* (set! pipe/buf ...) */,C_fix((C_word)PIPE_BUF));
t8=C_mutate2((C_word*)lf[132]+1 /* (set! fcntl/dupfd ...) */,C_fix((C_word)F_DUPFD));
t9=C_mutate2((C_word*)lf[133]+1 /* (set! fcntl/getfd ...) */,C_fix((C_word)F_GETFD));
t10=C_mutate2((C_word*)lf[134]+1 /* (set! fcntl/setfd ...) */,C_fix((C_word)F_SETFD));
t11=C_mutate2((C_word*)lf[135]+1 /* (set! fcntl/getfl ...) */,C_fix((C_word)F_GETFL));
t12=C_mutate2((C_word*)lf[136]+1 /* (set! fcntl/setfl ...) */,C_fix((C_word)F_SETFL));
t13=C_mutate2((C_word*)lf[137]+1 /* (set! open/rdonly ...) */,C_fix((C_word)O_RDONLY));
t14=C_mutate2((C_word*)lf[138]+1 /* (set! open/wronly ...) */,C_fix((C_word)O_WRONLY));
t15=C_mutate2((C_word*)lf[139]+1 /* (set! open/rdwr ...) */,C_fix((C_word)O_RDWR));
t16=C_mutate2((C_word*)lf[140]+1 /* (set! open/read ...) */,C_fix((C_word)O_RDONLY));
t17=C_mutate2((C_word*)lf[141]+1 /* (set! open/write ...) */,C_fix((C_word)O_WRONLY));
t18=C_mutate2((C_word*)lf[142]+1 /* (set! open/creat ...) */,C_fix((C_word)O_CREAT));
t19=C_mutate2((C_word*)lf[143]+1 /* (set! open/append ...) */,C_fix((C_word)O_APPEND));
t20=C_mutate2((C_word*)lf[144]+1 /* (set! open/excl ...) */,C_fix((C_word)O_EXCL));
t21=C_mutate2((C_word*)lf[145]+1 /* (set! open/noctty ...) */,C_fix((C_word)O_NOCTTY));
t22=C_mutate2((C_word*)lf[146]+1 /* (set! open/nonblock ...) */,C_fix((C_word)O_NONBLOCK));
t23=C_mutate2((C_word*)lf[147]+1 /* (set! open/trunc ...) */,C_fix((C_word)O_TRUNC));
t24=C_mutate2((C_word*)lf[148]+1 /* (set! open/sync ...) */,C_fix((C_word)O_FSYNC));
t25=C_mutate2((C_word*)lf[149]+1 /* (set! open/fsync ...) */,C_fix((C_word)O_FSYNC));
t26=C_mutate2((C_word*)lf[150]+1 /* (set! open/binary ...) */,C_fix((C_word)O_BINARY));
t27=C_mutate2((C_word*)lf[151]+1 /* (set! open/text ...) */,C_fix((C_word)O_TEXT));
t28=C_mutate2((C_word*)lf[152]+1 /* (set! perm/irusr ...) */,C_fix((C_word)S_IRUSR));
t29=C_mutate2((C_word*)lf[153]+1 /* (set! perm/iwusr ...) */,C_fix((C_word)S_IWUSR));
t30=C_mutate2((C_word*)lf[154]+1 /* (set! perm/ixusr ...) */,C_fix((C_word)S_IXUSR));
t31=C_mutate2((C_word*)lf[155]+1 /* (set! perm/irgrp ...) */,C_fix((C_word)S_IRGRP));
t32=C_mutate2((C_word*)lf[156]+1 /* (set! perm/iwgrp ...) */,C_fix((C_word)S_IWGRP));
t33=C_mutate2((C_word*)lf[157]+1 /* (set! perm/ixgrp ...) */,C_fix((C_word)S_IXGRP));
t34=C_mutate2((C_word*)lf[158]+1 /* (set! perm/iroth ...) */,C_fix((C_word)S_IROTH));
t35=C_mutate2((C_word*)lf[159]+1 /* (set! perm/iwoth ...) */,C_fix((C_word)S_IWOTH));
t36=C_mutate2((C_word*)lf[160]+1 /* (set! perm/ixoth ...) */,C_fix((C_word)S_IXOTH));
t37=C_mutate2((C_word*)lf[161]+1 /* (set! perm/irwxu ...) */,C_fix((C_word)S_IRWXU));
t38=C_mutate2((C_word*)lf[162]+1 /* (set! perm/irwxg ...) */,C_fix((C_word)S_IRWXG));
t39=C_mutate2((C_word*)lf[163]+1 /* (set! perm/irwxo ...) */,C_fix((C_word)S_IRWXO));
t40=C_mutate2((C_word*)lf[164]+1 /* (set! perm/isvtx ...) */,C_fix((C_word)S_ISVTX));
t41=C_mutate2((C_word*)lf[165]+1 /* (set! perm/isuid ...) */,C_fix((C_word)S_ISUID));
t42=C_mutate2((C_word*)lf[166]+1 /* (set! perm/isgid ...) */,C_fix((C_word)S_ISGID));
t43=C_mutate2((C_word*)lf[167]+1 /* (set! file-control ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4375,a[2]=((C_word)li74),tmp=(C_word)a,a+=3,tmp));
t44=C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IRGRP),C_fix((C_word)S_IROTH));
t45=C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IRWXU),t44);
t46=t45;
t47=C_mutate2((C_word*)lf[169]+1 /* (set! file-open ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4408,a[2]=t46,a[3]=((C_word)li75),tmp=(C_word)a,a+=4,tmp));
t48=C_mutate2((C_word*)lf[171]+1 /* (set! file-close ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4440,a[2]=((C_word)li77),tmp=(C_word)a,a+=3,tmp));
t49=C_mutate2((C_word*)lf[174]+1 /* (set! file-read ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4471,a[2]=((C_word)li78),tmp=(C_word)a,a+=3,tmp));
t50=C_mutate2((C_word*)lf[177]+1 /* (set! file-write ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4512,a[2]=((C_word)li79),tmp=(C_word)a,a+=3,tmp));
t51=C_mutate2((C_word*)lf[180]+1 /* (set! file-mkstemp ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4549,a[2]=((C_word)li80),tmp=(C_word)a,a+=3,tmp));
t52=C_mutate2((C_word*)lf[182]+1 /* (set! file-select ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4581,a[2]=((C_word)li85),tmp=(C_word)a,a+=3,tmp));
t53=C_mutate2((C_word*)lf[69]+1 /* (set! change-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4962,a[2]=((C_word)li86),tmp=(C_word)a,a+=3,tmp));
t54=C_mutate2((C_word*)lf[188]+1 /* (set! change-directory* ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4981,a[2]=((C_word)li87),tmp=(C_word)a,a+=3,tmp));
t55=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5015,a[2]=((C_word)li88),tmp=(C_word)a,a+=3,tmp);
t56=C_mutate2((C_word*)lf[192]+1 /* (set! open-input-pipe ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5030,a[2]=t55,a[3]=((C_word)li89),tmp=(C_word)a,a+=4,tmp));
t57=C_mutate2((C_word*)lf[196]+1 /* (set! open-output-pipe ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5070,a[2]=t55,a[3]=((C_word)li90),tmp=(C_word)a,a+=4,tmp));
t58=C_mutate2((C_word*)lf[197]+1 /* (set! close-input-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5110,a[2]=((C_word)li91),tmp=(C_word)a,a+=3,tmp));
t59=C_mutate2((C_word*)lf[199]+1 /* (set! close-output-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5125,a[2]=((C_word)li92),tmp=(C_word)a,a+=3,tmp));
t60=C_mutate2((C_word*)lf[201]+1 /* (set! call-with-input-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5140,a[2]=((C_word)li95),tmp=(C_word)a,a+=3,tmp));
t61=C_mutate2((C_word*)lf[202]+1 /* (set! call-with-output-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5164,a[2]=((C_word)li98),tmp=(C_word)a,a+=3,tmp));
t62=C_mutate2((C_word*)lf[203]+1 /* (set! with-input-from-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5188,a[2]=((C_word)li103),tmp=(C_word)a,a+=3,tmp));
t63=C_mutate2((C_word*)lf[205]+1 /* (set! with-output-to-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5222,a[2]=((C_word)li108),tmp=(C_word)a,a+=3,tmp));
t64=C_mutate2((C_word*)lf[207]+1 /* (set! create-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5256,a[2]=((C_word)li109),tmp=(C_word)a,a+=3,tmp));
t65=C_mutate2((C_word*)lf[209]+1 /* (set! signal/term ...) */,C_fix((C_word)SIGTERM));
t66=C_mutate2((C_word*)lf[210]+1 /* (set! signal/kill ...) */,C_fix((C_word)SIGKILL));
t67=C_mutate2((C_word*)lf[211]+1 /* (set! signal/int ...) */,C_fix((C_word)SIGINT));
t68=C_mutate2((C_word*)lf[212]+1 /* (set! signal/hup ...) */,C_fix((C_word)SIGHUP));
t69=C_mutate2((C_word*)lf[213]+1 /* (set! signal/fpe ...) */,C_fix((C_word)SIGFPE));
t70=C_mutate2((C_word*)lf[214]+1 /* (set! signal/ill ...) */,C_fix((C_word)SIGILL));
t71=C_mutate2((C_word*)lf[215]+1 /* (set! signal/segv ...) */,C_fix((C_word)SIGSEGV));
t72=C_mutate2((C_word*)lf[216]+1 /* (set! signal/abrt ...) */,C_fix((C_word)SIGABRT));
t73=C_mutate2((C_word*)lf[217]+1 /* (set! signal/trap ...) */,C_fix((C_word)SIGTRAP));
t74=C_mutate2((C_word*)lf[218]+1 /* (set! signal/quit ...) */,C_fix((C_word)SIGQUIT));
t75=C_mutate2((C_word*)lf[219]+1 /* (set! signal/alrm ...) */,C_fix((C_word)SIGALRM));
t76=C_mutate2((C_word*)lf[220]+1 /* (set! signal/vtalrm ...) */,C_fix((C_word)SIGVTALRM));
t77=C_mutate2((C_word*)lf[221]+1 /* (set! signal/prof ...) */,C_fix((C_word)SIGPROF));
t78=C_mutate2((C_word*)lf[222]+1 /* (set! signal/io ...) */,C_fix((C_word)SIGIO));
t79=C_mutate2((C_word*)lf[223]+1 /* (set! signal/urg ...) */,C_fix((C_word)SIGURG));
t80=C_mutate2((C_word*)lf[224]+1 /* (set! signal/chld ...) */,C_fix((C_word)SIGCHLD));
t81=C_mutate2((C_word*)lf[225]+1 /* (set! signal/cont ...) */,C_fix((C_word)SIGCONT));
t82=C_mutate2((C_word*)lf[226]+1 /* (set! signal/stop ...) */,C_fix((C_word)SIGSTOP));
t83=C_mutate2((C_word*)lf[227]+1 /* (set! signal/tstp ...) */,C_fix((C_word)SIGTSTP));
t84=C_mutate2((C_word*)lf[228]+1 /* (set! signal/pipe ...) */,C_fix((C_word)SIGPIPE));
t85=C_mutate2((C_word*)lf[229]+1 /* (set! signal/xcpu ...) */,C_fix((C_word)SIGXCPU));
t86=C_mutate2((C_word*)lf[230]+1 /* (set! signal/xfsz ...) */,C_fix((C_word)SIGXFSZ));
t87=C_mutate2((C_word*)lf[231]+1 /* (set! signal/usr1 ...) */,C_fix((C_word)SIGUSR1));
t88=C_mutate2((C_word*)lf[232]+1 /* (set! signal/usr2 ...) */,C_fix((C_word)SIGUSR2));
t89=C_mutate2((C_word*)lf[233]+1 /* (set! signal/winch ...) */,C_fix((C_word)SIGWINCH));
t90=C_mutate2((C_word*)lf[234]+1 /* (set! signal/bus ...) */,C_fix((C_word)SIGBUS));
t91=C_set_block_item(lf[235] /* signal/break */,0,C_fix(0));
t92=C_a_i_list(&a,26,*((C_word*)lf[209]+1),*((C_word*)lf[210]+1),*((C_word*)lf[211]+1),*((C_word*)lf[212]+1),*((C_word*)lf[213]+1),*((C_word*)lf[214]+1),*((C_word*)lf[215]+1),*((C_word*)lf[216]+1),*((C_word*)lf[217]+1),*((C_word*)lf[218]+1),*((C_word*)lf[219]+1),*((C_word*)lf[220]+1),*((C_word*)lf[221]+1),*((C_word*)lf[222]+1),*((C_word*)lf[223]+1),*((C_word*)lf[224]+1),*((C_word*)lf[225]+1),*((C_word*)lf[226]+1),*((C_word*)lf[227]+1),*((C_word*)lf[228]+1),*((C_word*)lf[229]+1),*((C_word*)lf[230]+1),*((C_word*)lf[231]+1),*((C_word*)lf[232]+1),*((C_word*)lf[233]+1),*((C_word*)lf[234]+1));
t93=C_mutate2((C_word*)lf[236]+1 /* (set! signals-list ...) */,t92);
t94=C_mutate2((C_word*)lf[237]+1 /* (set! set-signal-mask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5303,a[2]=((C_word)li111),tmp=(C_word)a,a+=3,tmp));
t95=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5352,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t96=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8588,a[2]=((C_word)li241),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:805: getter-with-setter */
t97=*((C_word*)lf[437]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t97;
av2[1]=t95;
av2[2]=t96;
av2[3]=*((C_word*)lf[237]+1);
((C_proc)(void*)(*((C_word*)t97+1)))(4,av2);}}

/* a5148 in k5142 in call-with-input-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5149(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_5149,2,av);}
/* posixunix.scm:685: proc */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
((C_proc)C_fast_retrieve_proc(t2))(3,av2);}}

/* k5142 in call-with-input-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5144(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_5144,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5149,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word)li93),tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5155,a[2]=t2,a[3]=((C_word)li94),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:684: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[3];
av2[2]=t3;
av2[3]=t4;
C_call_with_values(4,av2);}}

/* call-with-input-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5140(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +4,c,4))){
C_save_and_reclaim((void*)f_5140,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+4);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5144,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t5;
av2[2]=*((C_word*)lf[192]+1);
av2[3]=t2;
av2[4]=t4;
C_apply(5,av2);}}

/* k7237 in k7231 in k7228 in k7225 in map-file-to-memory in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7239(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,1))){C_save_and_reclaim((void *)f_7239,2,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_a_i_record3(&a,3,lf[375],((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k7845 in doloop1921 in k7794 in doloop1917 in k7779 in k7776 in process-execute in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in ... */
static void C_ccall f_7847(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_7847,2,av);}
t2=((C_word*)t0)[2];
t3=C_u_i_cdr(t2);
t4=C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
t5=((C_word*)((C_word*)t0)[4])[1];
f_7828(t5,((C_word*)t0)[5],t3,t4);}

/* k7231 in k7228 in k7225 in map-file-to-memory in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7233(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a;
if(!C_demand(C_calculate_demand(21,c,2))){C_save_and_reclaim((void *)f_7233,2,av);}
a=C_alloc(21);
t2=((C_word*)t0)[2];
t3=((C_word*)t0)[3];
t4=((C_word*)t0)[4];
t5=((C_word*)t0)[5];
t6=C_a_i_bytevector(&a,1,C_fix(3));
t7=(C_truep(((C_word*)t0)[6])?C_i_foreign_pointer_argumentp(((C_word*)t0)[6]):C_SCHEME_FALSE);
t8=C_i_foreign_integer_argumentp(t2);
t9=C_i_foreign_fixnum_argumentp(t3);
t10=C_i_foreign_fixnum_argumentp(t4);
t11=C_i_foreign_fixnum_argumentp(t5);
t12=C_i_foreign_integer_argumentp(((C_word*)t0)[7]);
t13=stub1677(t6,t7,t8,t9,t10,t11,t12);
t14=t13;
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7239,a[2]=((C_word*)t0)[8],a[3]=t14,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t16=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_7252,a[2]=t15,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=t14,tmp=(C_word)a,a+=11,tmp);
/* posixunix.scm:1450: ##sys#pointer->address */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[377]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[377]+1);
av2[1]=t16;
av2[2]=t14;
tp(3,av2);}}

/* k7228 in k7225 in map-file-to-memory in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_7230(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(9,0,5))){
C_save_and_reclaim_args((void *)trf_7230,2,t0,t1);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_7233,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t2,a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
if(C_truep(C_blockp(((C_word*)t0)[6]))){
if(C_truep(C_specialp(((C_word*)t0)[6]))){
t4=t3;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
f_7233(2,av2);}}
else{
/* posixunix.scm:1448: ##sys#signal-hook */
t4=*((C_word*)lf[1]+1);{
C_word av2[6];
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[13];
av2[3]=lf[374];
av2[4]=lf[378];
av2[5]=((C_word*)t0)[6];
((C_proc)(void*)(*((C_word*)t4+1)))(6,av2);}}}
else{
/* posixunix.scm:1448: ##sys#signal-hook */
t4=*((C_word*)lf[1]+1);{
C_word av2[6];
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[13];
av2[3]=lf[374];
av2[4]=lf[378];
av2[5]=((C_word*)t0)[6];
((C_proc)(void*)(*((C_word*)t4+1)))(6,av2);}}}

/* k7568 in terminal-size in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7570(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(13,c,5))){C_save_and_reclaim((void *)f_7570,2,av);}
a=C_alloc(13);
t2=C_a_i_bytevector(&a,1,C_fix(1));
t3=C_a_i_bytevector(&a,1,C_fix(1));
t4=C_C_fileno(((C_word*)t0)[2]);
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_7591,a[2]=t4,a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=t3,a[6]=((C_word*)t0)[2],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:1557: ##sys#make-locative */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[405]+1));
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[405]+1);
av2[1]=t5;
av2[2]=t2;
av2[3]=C_fix(0);
av2[4]=C_SCHEME_FALSE;
av2[5]=lf[406];
tp(6,av2);}}

/* doloop866 in k4597 in k4589 in k4586 in k4583 in file-select in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static C_word C_fcall f_4878(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_nullp(t2))){
t3=C_SCHEME_UNDEFINED;
return(t3);}
else{
t3=C_i_car(t2);
t4=t1;
t5=C_i_foreign_fixnum_argumentp(t4);
t6=C_i_foreign_fixnum_argumentp(t3);
if(C_truep(((C_word*)t0)[2])){
t7=C_i_foreign_block_argumentp(((C_word*)t0)[2]);
t8=stub875(C_SCHEME_UNDEFINED,t5,t6,t7);
t9=C_fixnum_plus(t1,C_fix(1));
t10=t2;
t11=C_u_i_cdr(t10);
t13=t9;
t14=t11;
t1=t13;
t2=t14;
goto loop;}
else{
t7=stub875(C_SCHEME_UNDEFINED,t5,t6,C_SCHEME_FALSE);
t8=C_fixnum_plus(t1,C_fix(1));
t9=t2;
t10=C_u_i_cdr(t9);
t13=t8;
t14=t10;
t1=t13;
t2=t14;
goto loop;}}}

/* k3773 in k3766 in a3759 in k3741 in k3797 in k3707 in k3698 in loop in k3683 in k3676 in k3673 in k3864 in k3861 in k3858 in k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in ... */
static void C_ccall f_3775(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_3775,2,av);}
if(C_truep(t1)){
/* posix-common.scm:546: action */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
((C_proc)C_fast_retrieve_proc(t2))(4,av2);}}
else{
t2=((C_word*)t0)[5];
/* posix-common.scm:544: loop */
t3=((C_word*)((C_word*)t0)[6])[1];
f_3687(t3,((C_word*)t0)[7],((C_word*)t0)[4],((C_word*)t0)[8],t2);}}

/* k3770 in k3766 in a3759 in k3741 in k3797 in k3707 in k3698 in loop in k3683 in k3676 in k3673 in k3864 in k3861 in k3858 in k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in ... */
static void C_ccall f_3772(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_3772,2,av);}
/* posix-common.scm:544: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3687(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],t1);}

/* a6517 in k6455 in k6446 in a6443 in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in ... */
static void C_ccall f_6518(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_6518,5,av);}
if(C_truep(t4)){
t5=C_slot(((C_word*)t0)[2],C_fix(4));
t6=C_fixnum_plus(t5,C_fix(1));
t7=C_i_set_i_slot(((C_word*)t0)[2],C_fix(4),t6);
t8=C_i_set_i_slot(((C_word*)t0)[2],C_fix(5),C_fix(0));
t9=C_mutate2(((C_word *)((C_word*)t0)[3])+1,t2);
t10=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t10;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t10+1)))(2,av2);}}
else{
t5=C_slot(((C_word*)t0)[2],C_fix(5));
t6=C_block_size(t3);
t7=C_fixnum_plus(t5,t6);
t8=C_i_set_i_slot(((C_word*)t0)[2],C_fix(5),t7);
t9=C_mutate2(((C_word *)((C_word*)t0)[3])+1,t2);
t10=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t10;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t10+1)))(2,av2);}}}

/* k7225 in map-file-to-memory in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7227(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(8,c,2))){C_save_and_reclaim((void *)f_7227,2,av);}
a=C_alloc(8);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7230,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
if(C_truep(C_i_pairp(((C_word*)t0)[7]))){
t4=((C_word*)t0)[7];
t5=t3;
f_7230(t5,C_u_i_car(t4));}
else{
t4=t3;
f_7230(t4,C_fix(0));}}

/* map-file-to-memory in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7223(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6=av[6];
C_word t7;
C_word *a;
if(c<7) C_bad_min_argc_2(c,7,t0);
if(!C_demand(C_calculate_demand((c-7)*C_SIZEOF_PAIR +8,c,2))){
C_save_and_reclaim((void*)f_7223,c,av);}
a=C_alloc((c-7)*C_SIZEOF_PAIR+8);
t7=C_build_rest(&a,c,7,av);
C_word t8;
C_word t9;
C_word t10;
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7227,a[2]=t3,a[3]=t4,a[4]=t5,a[5]=t6,a[6]=t1,a[7]=t7,tmp=(C_word)a,a+=8,tmp);
t9=t2;
if(C_truep(t9)){
t10=t8;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t10;
av2[1]=t2;
f_7227(2,av2);}}
else{
/* posixunix.scm:1445: ##sys#null-pointer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[379]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[379]+1);
av2[1]=t8;
tp(2,av2);}}}

/* terminal-size in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7566(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_7566,3,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7570,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1552: ##sys#terminal-check */
f_7511(t3,lf[402],t2);}

/* k3741 in k3797 in k3707 in k3698 in loop in k3683 in k3676 in k3673 in k3864 in k3861 in k3858 in k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 in ... */
static void C_ccall f_3743(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(!C_demand(C_calculate_demand(31,c,4))){C_save_and_reclaim((void *)f_3743,2,av);}
a=C_alloc(31);
if(C_truep(t1)){
t2=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3753,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3755,a[2]=t6,a[3]=((C_word*)t0)[2],a[4]=t4,a[5]=((C_word)li40),tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3760,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[10],a[7]=((C_word*)t0)[11],a[8]=((C_word)li41),tmp=(C_word)a,a+=9,tmp);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3780,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t6,a[5]=((C_word)li42),tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:543: ##sys#dynamic-wind */
t11=*((C_word*)lf[95]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t11;
av2[1]=t7;
av2[2]=t8;
av2[3]=t9;
av2[4]=t10;
((C_proc)(void*)(*((C_word*)t11+1)))(5,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3790,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3793,a[2]=((C_word*)t0)[8],a[3]=t2,a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[6],tmp=(C_word)a,a+=10,tmp);
/* posix-common.scm:547: pproc */
t4=((C_word*)t0)[10];{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[7];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}}

/* a6566 in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6567(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(5,c,4))){C_save_and_reclaim((void *)f_6567,3,av);}
a=C_alloc(5);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t3=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=lf[343];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6577,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1273: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[70]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[70]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)((C_word*)t0)[2])[1];
av2[4]=((C_word*)((C_word*)t0)[3])[1];
tp(5,av2);}}}

/* k7250 in k7231 in k7228 in k7225 in map-file-to-memory in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7252(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,10))){C_save_and_reclaim((void *)f_7252,2,av);}
a=C_alloc(4);
t2=C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
/* posixunix.scm:1451: posix-error */
t3=lf[0];{
C_word *av2;
if(c >= 11) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(11);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[8];
av2[3]=lf[374];
av2[4]=lf[376];
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[4];
av2[7]=((C_word*)t0)[5];
av2[8]=((C_word*)t0)[6];
av2[9]=((C_word*)t0)[7];
av2[10]=((C_word*)t0)[8];
f_2696(11,av2);}}
else{
t3=((C_word*)t0)[9];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_a_i_record3(&a,3,lf[375],((C_word*)t0)[10],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k8664 in a8661 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8666(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,5))){C_save_and_reclaim((void *)f_8666,2,av);}
a=C_alloc(4);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8669,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_lessp(t2,C_fix(0)))){
/* posix-common.scm:340: posix-error */
t4=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[8];
av2[3]=lf[45];
av2[4]=lf[451];
av2[5]=((C_word*)t0)[3];
f_2696(6,av2);}}
else{
t4=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k8667 in k8664 in a8661 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8669(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_8669,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k3797 in k3707 in k3698 in loop in k3683 in k3676 in k3673 in k3864 in k3861 in k3858 in k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3799(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(16,c,2))){C_save_and_reclaim((void *)f_3799,2,av);}
a=C_alloc(16);
t2=(C_truep(t1)?C_i_not(((C_word*)t0)[2]):C_SCHEME_FALSE);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3731,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3734,a[2]=((C_word*)t0)[7],a[3]=t3,a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[6],tmp=(C_word)a,a+=10,tmp);
/* posix-common.scm:539: pproc */
t5=((C_word*)t0)[10];{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=((C_word*)t0)[8];
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_3743,a[2]=((C_word*)t0)[11],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[12],tmp=(C_word)a,a+=12,tmp);
/* posix-common.scm:540: lproc */
t4=((C_word*)t0)[13];{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[8];
((C_proc)C_fast_retrieve_proc(t4))(3,av2);}}}

/* k3788 in k3741 in k3797 in k3707 in k3698 in loop in k3683 in k3676 in k3673 in k3864 in k3861 in k3858 in k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in ... */
static void C_ccall f_3790(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_3790,2,av);}
/* posix-common.scm:547: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3687(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],t1);}

/* k6575 in a6566 in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6577(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_6577,2,av);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=((C_word*)t0)[4];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k3791 in k3741 in k3797 in k3707 in k3698 in loop in k3683 in k3676 in k3673 in k3864 in k3861 in k3858 in k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in ... */
static void C_ccall f_3793(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_3793,2,av);}
if(C_truep(t1)){
/* posix-common.scm:547: action */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
((C_proc)C_fast_retrieve_proc(t2))(4,av2);}}
else{
t2=((C_word*)t0)[5];
/* posix-common.scm:547: loop */
t3=((C_word*)((C_word*)t0)[6])[1];
f_3687(t3,((C_word*)t0)[7],((C_word*)t0)[8],((C_word*)t0)[9],t2);}}

/* a8661 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8662(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(8,c,2))){C_save_and_reclaim((void *)f_8662,3,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8666,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8678,a[2]=t2,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:331: port? */
t5=*((C_word*)lf[15]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}

/* k4078 in k4059 in time->string in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4080(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,3))){C_save_and_reclaim((void *)f_4080,2,av);}
a=C_alloc(5);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4084,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:617: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[72]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[72]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
av2[3]=C_make_character(0);
tp(4,av2);}}

/* k4082 in k4078 in k4059 in time->string in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4084(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,3))){C_save_and_reclaim((void *)f_4084,2,av);}
a=C_alloc(5);
t2=((C_word*)t0)[2];
t3=C_a_i_bytevector(&a,1,C_fix(3));
if(C_truep(t1)){
t4=C_i_foreign_block_argumentp(t1);
t5=stub593(t3,t2,((C_word*)t0)[3],t4);
/* posix-common.scm:610: ##sys#peek-c-string */
t6=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t6;
av2[1]=((C_word*)t0)[4];
av2[2]=t5;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}
else{
t4=stub593(t3,t2,((C_word*)t0)[3],C_SCHEME_FALSE);
/* posix-common.scm:610: ##sys#peek-c-string */
t5=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=((C_word*)t0)[4];
av2[2]=t4;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}}

/* a3759 in k3741 in k3797 in k3707 in k3698 in loop in k3683 in k3676 in k3673 in k3864 in k3861 in k3858 in k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in ... */
static void C_ccall f_3760(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(8,c,3))){C_save_and_reclaim((void *)f_3760,2,av);}
a=C_alloc(8);
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3768,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posix-common.scm:545: directory */
t3=*((C_word*)lf[26]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[7];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k4085 in k4059 in time->string in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4087(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_4087,2,av);}
if(C_truep(t1)){
t2=C_block_size(t1);
t3=C_fixnum_difference(t2,C_fix(1));
/* posix-common.scm:621: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[70]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[70]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=C_fix(0);
av2[4]=t3;
tp(5,av2);}}
else{
/* posix-common.scm:622: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[115];
av2[3]=lf[117];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}}

/* k3766 in a3759 in k3741 in k3797 in k3707 in k3698 in loop in k3683 in k3676 in k3673 in k3864 in k3861 in k3858 in k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in ... */
static void C_ccall f_3768(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(15,c,2))){C_save_and_reclaim((void *)f_3768,2,av);}
a=C_alloc(15);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3772,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3775,a[2]=((C_word*)t0)[5],a[3]=t3,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[2],a[7]=((C_word*)t0)[3],a[8]=t2,tmp=(C_word)a,a+=9,tmp);
/* posix-common.scm:546: pproc */
t5=((C_word*)t0)[7];{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}

/* k3246 in delete-directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3248(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(16,c,3))){C_save_and_reclaim((void *)f_3248,2,av);}
a=C_alloc(16);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3249,a[2]=((C_word*)t0)[2],a[3]=((C_word)li25),tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3268,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3273,a[2]=t5,a[3]=t2,a[4]=((C_word)li26),tmp=(C_word)a,a+=5,tmp));
t7=((C_word*)t5)[1];
f_3273(t7,t3,t1);}

/* g293 in k3246 in delete-directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_3249(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(5,0,2))){
C_save_and_reclaim_args((void *)trf_3249,3,t0,t1,t2);}
a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3259,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:440: symbolic-link? */
t4=*((C_word*)lf[32]+1);{
C_word av2[3];
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* file-lock/blocking in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7037(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +5,c,4))){
C_save_and_reclaim((void*)f_7037,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+5);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7041,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1375: setup */
f_6939(t4,t2,t3,lf[355]);}

/* k4068 in k4059 in time->string in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4070(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_4070,2,av);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
/* posix-common.scm:618: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[115];
av2[3]=lf[116];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}}

/* k3257 in g293 in k3246 in delete-directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3259(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,2))){C_save_and_reclaim((void *)f_3259,2,av);}
a=C_alloc(5);
if(C_truep(t1)){
t2=*((C_word*)lf[75]+1);
t3=*((C_word*)lf[75]+1);
/* posix-common.scm:439: g303 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[75]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[75]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
tp(3,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3265,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:441: directory? */
t3=*((C_word*)lf[37]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}}

/* rmdir in delete-directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_3225(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(4,0,2))){
C_save_and_reclaim_args((void *)trf_3225,2,t1,t2);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3229,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:429: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t3;
av2[2]=t2;
tp(3,av2);}}

/* k3227 in rmdir in delete-directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3229(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_3229,2,av);}
t2=C_rmdir(t1);
t3=C_eqp(C_fix(0),t2);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
/* posix-common.scm:431: posix-error */
t4=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[8];
av2[3]=lf[73];
av2[4]=lf[74];
av2[5]=((C_word*)t0)[3];
f_2696(6,av2);}}}

/* k5571 in loop in k5561 in k5557 in k5544 in group-information in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5573(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,2))){C_save_and_reclaim((void *)f_5573,2,av);}
a=C_alloc(4);
t2=t1;
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5583,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm:946: loop */
t5=((C_word*)((C_word*)t0)[4])[1];
f_5569(t5,t3,t4);}
else{
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* process-wait in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4242(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +9,c,5))){
C_save_and_reclaim((void*)f_4242,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+9);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
t3=C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_i_car(t2));
t5=C_i_nullp(t2);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:C_i_cdr(t2));
t7=C_i_nullp(t6);
t8=(C_truep(t7)?C_SCHEME_FALSE:C_i_car(t6));
t9=t8;
t10=C_i_nullp(t6);
t11=(C_truep(t10)?C_SCHEME_END_OF_LIST:C_i_cdr(t6));
t12=(C_truep(t4)?t4:C_fix(-1));
t13=t12;
t14=C_i_check_exact_2(t13,lf[125]);
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4266,a[2]=t13,a[3]=t9,a[4]=((C_word)li69),tmp=(C_word)a,a+=5,tmp);
t16=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4272,a[2]=t13,a[3]=((C_word)li70),tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:678: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t15;
av2[3]=t16;
C_call_with_values(4,av2);}}

/* k7055 in file-test-lock in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7057(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_7057,2,av);}
t2=C_flock_test(((C_word*)t0)[2]);
if(C_truep(t2)){
t3=((C_word*)t0)[3];
t4=C_eqp(t2,C_fix(0));
t5=t3;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=(C_truep(t4)?C_SCHEME_FALSE:t2);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
/* posixunix.scm:1383: err */
f_7003(((C_word*)t0)[3],lf[358],t1,lf[357]);}}

/* file-test-lock in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7053(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +5,c,4))){
C_save_and_reclaim((void*)f_7053,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+5);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7057,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1381: setup */
f_6939(t4,t2,t3,lf[357]);}

/* k5581 in k5571 in loop in k5561 in k5557 in k5544 in group-information in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5583(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,1))){C_save_and_reclaim((void *)f_5583,2,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k7039 in file-lock/blocking in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7041(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_7041,2,av);}
t2=C_flock_lockw(((C_word*)t0)[2]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1377: err */
f_7003(((C_word*)t0)[4],lf[356],t1,lf[355]);}
else{
t3=((C_word*)t0)[4];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* a8630 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8631(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +0,c,1))){
C_save_and_reclaim((void*)f_8631,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+0);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
t3=C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_i_car(t2));
t5=(C_truep(t4)?C_i_check_exact_2(t4,lf[102]):C_SCHEME_UNDEFINED);
if(C_truep(t4)){
t6=C_umask(t4);
if(C_truep(t4)){
t7=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_umask(t6);
t8=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t8;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}
else{
t6=C_umask(C_fix(0));
if(C_truep(t4)){
t7=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_umask(t6);
t8=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t8;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}}

/* k3281 in for-each-loop292 in k3246 in delete-directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3283(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_3283,2,av);}
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=((C_word*)((C_word*)t0)[3])[1];
f_3273(t3,((C_word*)t0)[4],t2);}

/* loop in k5561 in k5557 in k5544 in group-information in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_5569(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(10,0,3))){
C_save_and_reclaim_args((void *)trf_5569,3,t0,t1,t2);}
a=C_alloc(10);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5573,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
t7=stub1188(t5,t6);
/* posixunix.scm:929: ##sys#peek-c-string */
t8=*((C_word*)lf[4]+1);{
C_word av2[4];
av2[0]=t8;
av2[1]=t3;
av2[2]=t7;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}

/* k7740 in setenv in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7742(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_7742,2,av);}
t2=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=stub1890(C_SCHEME_UNDEFINED,((C_word*)t0)[4],t1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* open-output-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5070(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +10,c,3))){
C_save_and_reclaim((void*)f_5070,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+10);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
t4=C_i_check_string_2(t2,lf[196]);
t5=C_i_pairp(t3);
t6=(C_truep(t5)?C_slot(t3,C_fix(0)):lf[193]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5084,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t8=C_eqp(t6,lf[193]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5091,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:663: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t9;
av2[2]=t2;
av2[3]=lf[196];
tp(4,av2);}}
else{
t9=C_eqp(t6,lf[194]);
if(C_truep(t9)){
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5101,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:664: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t10;
av2[2]=t2;
av2[3]=lf[196];
tp(4,av2);}}
else{
/* posixunix.scm:637: ##sys#error */
t10=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t10;
av2[1]=t7;
av2[2]=lf[195];
av2[3]=t6;
((C_proc)(void*)(*((C_word*)t10+1)))(4,av2);}}}}

/* k5561 in k5557 in k5544 in group-information in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5563(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(12,c,3))){C_save_and_reclaim((void *)f_5563,2,av);}
a=C_alloc(12);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5567,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5569,a[2]=t5,a[3]=((C_word)li119),tmp=(C_word)a,a+=4,tmp));
t7=((C_word*)t5)[1];
f_5569(t7,t3,C_fix(0));}

/* k5565 in k5561 in k5557 in k5544 in group-information in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5567(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_5567,2,av);}
/* posixunix.scm:932: g1208 */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
av2[4]=C_fix((C_word)C_group->gr_gid);
av2[5]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k4021 in k4015 in k4011 in local-time->seconds in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4023(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_4023,2,av);}
if(C_truep(t1)){
/* posix-common.scm:605: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[111];
av2[3]=lf[112];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}
else{
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* a8655 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8656(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_8656,3,av);}
t3=C_i_check_exact_2(t2,lf[102]);
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_umask(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k5082 in open-output-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5084(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_5084,2,av);}
/* posixunix.scm:659: check */
f_5015(((C_word*)t0)[3],lf[196],((C_word*)t0)[4],C_SCHEME_FALSE,t1);}

/* k3266 in k3246 in delete-directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3268(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_3268,2,av);}
/* posix-common.scm:445: rmdir */
f_3225(((C_word*)t0)[3],((C_word*)t0)[4]);}

/* k3263 in k3257 in g293 in k3246 in delete-directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3265(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_3265,2,av);}
if(C_truep(t1)){
/* posix-common.scm:439: g303 */
f_3225(((C_word*)t0)[3],((C_word*)t0)[4]);}
else{
t2=*((C_word*)lf[75]+1);
t3=*((C_word*)lf[75]+1);
/* posix-common.scm:439: g303 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[75]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[75]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
tp(3,av2);}}}

/* k4011 in local-time->seconds in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4013(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_4013,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4017,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:603: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[72]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[72]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=C_make_character(0);
tp(4,av2);}}

/* k4015 in k4011 in local-time->seconds in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4017(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_4017,2,av);}
a=C_alloc(9);
t2=C_a_mktime(&a,2,((C_word*)t0)[2],t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4023,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:604: fp= */
t4=*((C_word*)lf[113]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[114];
av2[3]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k5089 in open-output-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5091(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(2,c,5))){C_save_and_reclaim((void *)f_5091,2,av);}
a=C_alloc(2);
t2=open_text_output_pipe(&a,1,t1);
/* posixunix.scm:659: check */
f_5015(((C_word*)t0)[3],lf[196],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* for-each-loop292 in k3246 in delete-directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_3273(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(5,0,2))){
C_save_and_reclaim_args((void *)trf_3273,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3283,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=C_slot(t2,C_fix(0));
/* posix-common.scm:434: g293 */
t5=((C_word*)t0)[3];
f_3249(t5,t3,t4);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* a3374 in k3319 in create-directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3375(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_3375,2,av);}
/* posix-common.scm:458: decompose-pathname */
t2=*((C_word*)lf[82]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* local-time->seconds in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4009(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(5,c,3))){C_save_and_reclaim((void *)f_4009,3,av);}
a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4013,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:602: check-time-vector */
f_3900(t3,lf[111],t2);}

/* k3371 in loop in k3329 in k3319 in create-directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3373(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3373,2,av);}
t2=((C_word*)t0)[2];
f_3340(t2,C_i_not(t1));}

/* k5595 in group-information in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5597(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_5597,2,av);}
t2=((C_word*)t0)[2];
f_5546(t2,C_getgrnam(t1));}

/* a3380 in k3319 in create-directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3381(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_3381,5,av);}
if(C_truep(t3)){
/* posix-common.scm:459: make-pathname */
t5=*((C_word*)lf[83]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(5,av2);}}
else{
t5=t2;
t6=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* ##sys#custom-output-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6643(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c<5) C_bad_min_argc_2(c,5,t0);
if(!C_demand(C_calculate_demand((c-5)*C_SIZEOF_PAIR +8,c,2))){
C_save_and_reclaim((void*)f_6643,c,av);}
a=C_alloc((c-5)*C_SIZEOF_PAIR+8);
t5=C_build_rest(&a,c,5,av);
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
t6=C_i_nullp(t5);
t7=(C_truep(t6)?C_SCHEME_FALSE:C_i_car(t5));
t8=C_i_nullp(t5);
t9=(C_truep(t8)?C_SCHEME_END_OF_LIST:C_i_cdr(t5));
t10=C_i_nullp(t9);
t11=(C_truep(t10)?C_fix(0):C_i_car(t9));
t12=t11;
t13=C_i_nullp(t9);
t14=(C_truep(t13)?C_SCHEME_END_OF_LIST:C_i_cdr(t9));
t15=C_i_nullp(t14);
t16=(C_truep(t15)?*((C_word*)lf[332]+1):C_i_car(t14));
t17=t16;
t18=C_i_nullp(t14);
t19=(C_truep(t18)?C_SCHEME_END_OF_LIST:C_i_cdr(t14));
t20=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6665,a[2]=t4,a[3]=t2,a[4]=t3,a[5]=t12,a[6]=t1,a[7]=t17,tmp=(C_word)a,a+=8,tmp);
if(C_truep(t7)){
/* posixunix.scm:1282: ##sys#file-nonblocking! */
t21=*((C_word*)lf[129]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t21;
av2[1]=t20;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t21+1)))(3,av2);}}
else{
t21=t20;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t21;
av2[1]=C_SCHEME_UNDEFINED;
f_6665(2,av2);}}}

/* k5506 in current-user-name in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5508(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_5508,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_i_car(t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* a8621 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8622(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_8622,3,av);}
t3=C_i_check_exact_2(t2,lf[123]);
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_slot(*((C_word*)lf[122]+1),t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* current-user-name in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5500(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(6,c,2))){C_save_and_reclaim((void *)f_5500,2,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5508,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5512,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:919: current-user-id */
t4=*((C_word*)lf[248]+1);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k3979 in k3973 in seconds->string in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3981(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_3981,2,av);}
if(C_truep(t1)){
t2=C_block_size(t1);
t3=C_fixnum_difference(t2,C_fix(1));
/* posix-common.scm:596: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[70]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[70]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=C_fix(0);
av2[4]=t3;
tp(5,av2);}}
else{
/* posix-common.scm:597: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[109];
av2[3]=lf[110];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}}

/* k3199 in k3196 in current-directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3201(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_3201,2,av);}
if(C_truep(((C_word*)t0)[2])){
/* posix-common.scm:421: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[70]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[70]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=C_fix(0);
av2[4]=((C_word*)t0)[2];
tp(5,av2);}}
else{
/* posix-common.scm:422: ##sys#signal-hook */
t2=*((C_word*)lf[1]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[8];
av2[3]=lf[68];
av2[4]=lf[71];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}}

/* loop */
static void C_fcall f_6811(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
loop:
if(!C_demand(C_calculate_demand(7,0,4))){
C_save_and_reclaim_args((void *)trf_6811,5,t0,t1,t2,t3,t4);}
a=C_alloc(7);
t5=C_eqp(C_fix(0),t2);
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6821,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=t4,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:1310: poke */
t7=((C_word*)((C_word*)t0)[5])[1];{
C_word av2[4];
av2[0]=t7;
av2[1]=t6;
av2[2]=((C_word*)t0)[6];
av2[3]=((C_word*)t0)[4];
((C_proc)C_fast_retrieve_proc(t7))(4,av2);}}
else{
if(C_truep(C_fixnum_lessp(t2,t4))){
t6=C_substring_copy(((C_word*)t0)[7],((C_word*)t0)[6],t3,t2,((C_word*)((C_word*)t0)[2])[1]);
t7=C_fixnum_difference(t4,t2);
/* posixunix.scm:1315: loop */
t10=t1;
t11=C_fix(0);
t12=t2;
t13=t7;
t1=t10;
t2=t11;
t3=t12;
t4=t13;
goto loop;}
else{
t6=C_substring_copy(((C_word*)t0)[7],((C_word*)t0)[6],t3,t4,((C_word*)((C_word*)t0)[2])[1]);
t7=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],t4);
t8=C_mutate2(((C_word *)((C_word*)t0)[2])+1,t7);
t9=t1;{
C_word av2[2];
av2[0]=t9;
av2[1]=t8;
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}}}

/* group-information in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5539(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +7,c,3))){
C_save_and_reclaim((void*)f_5539,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+7);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=t5;
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5546,a[2]=t6,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnump(t2))){
t8=t7;
f_5546(t8,C_getgrgid(t2));}
else{
t8=C_i_check_string_2(t2,lf[257]);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5597,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:937: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t9;
av2[2]=t2;
av2[3]=lf[257];
tp(4,av2);}}}

/* delete-directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3219(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +8,c,6))){
C_save_and_reclaim((void*)f_3219,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+8);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3225,a[2]=((C_word)li24),tmp=(C_word)a,a+=3,tmp);
t7=C_i_check_string_2(t2,lf[73]);
if(C_truep(t5)){
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3248,a[2]=t6,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:434: find-files */
t9=*((C_word*)lf[76]+1);{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t9;
av2[1]=t8;
av2[2]=t2;
av2[3]=lf[77];
av2[4]=C_SCHEME_TRUE;
av2[5]=lf[78];
av2[6]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t9+1)))(7,av2);}}
else{
/* posix-common.scm:446: rmdir */
f_3225(t1,t2);}}

/* k6819 in loop */
static void C_ccall f_6821(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_6821,2,av);}
t2=C_set_block_item(((C_word*)t0)[2],0,C_fix(0));
/* posixunix.scm:1312: loop */
t3=((C_word*)((C_word*)t0)[3])[1];
f_6811(t3,((C_word*)t0)[4],((C_word*)t0)[5],C_fix(0),((C_word*)t0)[6]);}

/* k5544 in group-information in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_5546(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(7,0,3))){
C_save_and_reclaim_args((void *)trf_5546,2,t0,t1);}
a=C_alloc(7);
if(C_truep(t1)){
t2=(C_truep(((C_word*)t0)[2])?*((C_word*)lf[253]+1):*((C_word*)lf[254]+1));
t3=t2;
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5559,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t5=*((C_word*)lf[246]+1);{
C_word av2[4];
av2[0]=t5;
av2[1]=t4;
av2[2]=C_mpointer(&a,(void*)C_group->gr_name);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}
else{
t2=((C_word*)t0)[3];{
C_word av2[2];
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* check in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_5015(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(4,0,5))){
C_save_and_reclaim_args((void *)trf_5015,5,t1,t2,t3,t4,t5);}
a=C_alloc(4);
if(C_truep(C_null_pointerp(t5))){
/* posixunix.scm:640: posix-error */
t6=lf[0];{
C_word av2[6];
av2[0]=t6;
av2[1]=t1;
av2[2]=lf[8];
av2[3]=t2;
av2[4]=lf[190];
av2[5]=t3;
f_2696(6,av2);}}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5028,a[2]=t5,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:641: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[57]+1));
C_word av2[6];
av2[0]=*((C_word*)lf[57]+1);
av2[1]=t6;
av2[2]=t4;
av2[3]=*((C_word*)lf[58]+1);
av2[4]=lf[191];
av2[5]=lf[43];
tp(6,av2);}}}

/* k5026 in check in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5028(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_5028,2,av);}
t2=C_set_file_ptr(t1,((C_word*)t0)[2]);
t3=t1;
t4=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* current-effective-user-name in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5514(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(6,c,2))){C_save_and_reclaim((void *)f_5514,2,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5522,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5526,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:922: current-effective-user-id */
t4=*((C_word*)lf[249]+1);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k5510 in current-user-name in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5512(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_5512,2,av);}
/* posixunix.scm:919: user-information */
t2=*((C_word*)lf[252]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* k5524 in current-effective-user-name in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5526(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_5526,2,av);}
/* posixunix.scm:922: user-information */
t2=*((C_word*)lf[252]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* k5520 in current-effective-user-name in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5522(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_5522,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_i_car(t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* loop in a8587 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_8594(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
loop:
if(!C_demand(C_calculate_demand(3,0,3))){
C_save_and_reclaim_args((void *)trf_8594,4,t0,t1,t2,t3);}
a=C_alloc(3);
if(C_truep(C_i_nullp(t2))){
t4=t3;
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t4=C_i_car(t2);
t5=t2;
t6=C_u_i_cdr(t5);
if(C_truep(C_sigismember(t4))){
t7=C_a_i_cons(&a,2,t4,t3);
/* posixunix.scm:812: loop */
t9=t1;
t10=t6;
t11=t7;
t1=t9;
t2=t10;
t3=t11;
goto loop;}
else{
t7=t3;
/* posixunix.scm:812: loop */
t9=t1;
t10=t6;
t11=t7;
t1=t9;
t2=t10;
t3=t11;
goto loop;}}}

/* a8568 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8569(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_8569,2,av);}
t2=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=stub1147(C_SCHEME_UNDEFINED);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k8561 in a8552 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8563(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_8563,2,av);}
/* posixunix.scm:871: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[445];
av2[3]=lf[446];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* k5557 in k5544 in group-information in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5559(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(8,c,3))){C_save_and_reclaim((void *)f_5559,2,av);}
a=C_alloc(8);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5563,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t4=*((C_word*)lf[246]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=C_mpointer(&a,(void*)C_group->gr_passwd);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* a8587 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8588(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(6,c,4))){C_save_and_reclaim((void *)f_8588,2,av);}
a=C_alloc(6);
t2=C_sigprocmask_get(C_fix(0));
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8594,a[2]=t4,a[3]=((C_word)li240),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_8594(t6,t1,*((C_word*)lf[236]+1),C_SCHEME_END_OF_LIST);}

/* lp in k4821 in k4597 in k4589 in k4586 in k4583 in file-select in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_4762(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(!C_demand(C_calculate_demand(7,0,2))){
C_save_and_reclaim_args((void *)trf_4762,5,t0,t1,t2,t3,t4);}
a=C_alloc(7);
if(C_truep(C_i_nullp(t4))){
/* posixunix.scm:596: ##sys#fast-reverse */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[184]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[184]+1);
av2[1]=t1;
av2[2]=t3;
tp(3,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4791,a[2]=t2,a[3]=t4,a[4]=t3,a[5]=((C_word*)t0)[2],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
t6=t2;
t7=C_i_foreign_fixnum_argumentp(t6);
if(C_truep(((C_word*)t0)[3])){
t8=C_i_foreign_block_argumentp(((C_word*)t0)[3]);
t9=t5;
f_4791(t9,stub933(C_SCHEME_UNDEFINED,t7,t8));}
else{
t8=t5;
f_4791(t8,stub933(C_SCHEME_UNDEFINED,t7,C_SCHEME_FALSE));}}}

/* k8580 in a8571 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8582(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_8582,2,av);}
/* posixunix.scm:862: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[442];
av2[3]=lf[448];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* k4789 in lp in k4821 in k4597 in k4589 in k4586 in k4583 in file-select in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_4791(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(3,0,4))){
C_save_and_reclaim_args((void *)trf_4791,2,t0,t1);}
a=C_alloc(3);
if(C_truep(t1)){
t2=C_fixnum_plus(((C_word*)t0)[2],C_fix(1));
t3=C_i_car(((C_word*)t0)[3]);
t4=C_a_i_cons(&a,2,t3,((C_word*)t0)[4]);
t5=((C_word*)t0)[3];
t6=C_u_i_cdr(t5);
/* posixunix.scm:601: lp */
t7=((C_word*)((C_word*)t0)[5])[1];
f_4762(t7,((C_word*)t0)[6],t2,t4,t6);}
else{
t2=C_fixnum_plus(((C_word*)t0)[2],C_fix(1));
t3=C_i_cdr(((C_word*)t0)[3]);
/* posixunix.scm:602: lp */
t4=((C_word*)((C_word*)t0)[5])[1];
f_4762(t4,((C_word*)t0)[6],t2,((C_word*)t0)[4],t3);}}

/* k4730 in lp in k4661 in k4821 in k4597 in k4589 in k4586 in k4583 in file-select in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_4732(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(3,0,4))){
C_save_and_reclaim_args((void *)trf_4732,2,t0,t1);}
a=C_alloc(3);
if(C_truep(t1)){
t2=C_fixnum_plus(((C_word*)t0)[2],C_fix(1));
t3=C_i_car(((C_word*)t0)[3]);
t4=C_a_i_cons(&a,2,t3,((C_word*)t0)[4]);
t5=((C_word*)t0)[3];
t6=C_u_i_cdr(t5);
/* posixunix.scm:609: lp */
t7=((C_word*)((C_word*)t0)[5])[1];
f_4703(t7,((C_word*)t0)[6],t2,t4,t6);}
else{
t2=C_fixnum_plus(((C_word*)t0)[2],C_fix(1));
t3=C_i_cdr(((C_word*)t0)[3]);
/* posixunix.scm:610: lp */
t4=((C_word*)((C_word*)t0)[5])[1];
f_4703(t4,((C_word*)t0)[6],t2,((C_word*)t0)[4],t3);}}

/* a8571 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8572(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(4,c,2))){C_save_and_reclaim((void *)f_8572,3,av);}
a=C_alloc(4);
t3=C_setuid(t2);
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8582,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:861: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[5]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[5]+1);
av2[1]=t4;
tp(2,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* a8511 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8512(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_8512,2,av);}
t2=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=stub1162(C_SCHEME_UNDEFINED);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* a8514 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8515(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(4,c,2))){C_save_and_reclaim((void *)f_8515,3,av);}
a=C_alloc(4);
t3=C_setegid(t2);
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8525,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:889: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[5]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[5]+1);
av2[1]=t4;
tp(2,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k4059 in time->string in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4061(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_4061,2,av);}
a=C_alloc(9);
if(C_truep(((C_word*)t0)[2])){
t2=C_i_check_string_2(((C_word*)t0)[2],lf[115]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4070,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4080,a[2]=((C_word*)t0)[4],a[3]=t3,a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:617: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t4;
av2[2]=((C_word*)t0)[2];
av2[3]=lf[115];
tp(4,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4087,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4108,a[2]=((C_word*)t0)[4],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:619: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[72]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[72]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[5];
av2[3]=C_make_character(0);
tp(4,av2);}}}

/* time->string in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4054(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +6,c,3))){
C_save_and_reclaim((void*)f_4054,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+6);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=t5;
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4061,a[2]=t6,a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[2],tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:613: check-time-vector */
f_3900(t7,lf[115],t2);}

/* k7664 in a7661 in k7646 in process-fork in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7666(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_7666,2,av);}
/* posixunix.scm:1591: exit */
t2=*((C_word*)lf[411]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=C_fix(0);
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* a7661 in k7646 in process-fork in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7662(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(3,c,2))){C_save_and_reclaim((void *)f_7662,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7666,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1590: thunk */
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
((C_proc)C_fast_retrieve_proc(t3))(2,av2);}}

/* k8504 in a8489 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8506(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_8506,2,av);}
/* posixunix.scm:1093: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[435];
av2[3]=lf[436];
av2[4]=((C_word*)t0)[3];
av2[5]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* a8552 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8553(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(4,c,2))){C_save_and_reclaim((void *)f_8553,3,av);}
a=C_alloc(4);
t3=C_seteuid(t2);
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8563,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:870: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[5]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[5]+1);
av2[1]=t4;
tp(2,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* a8549 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8550(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_8550,2,av);}
t2=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=stub1152(C_SCHEME_UNDEFINED);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k6791 in k6663 in custom-output-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6793(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_6793,2,av);}
a=C_alloc(9);
t2=t1;
t3=C_fix(0);
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=((C_word*)t0)[2];
f_6732(t5,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6794,a[2]=((C_word*)t0)[3],a[3]=t4,a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word)li162),tmp=(C_word)a,a+=7,tmp));}

/* f_6794 in k6791 in k6663 in custom-output-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6794(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(11,c,5))){C_save_and_reclaim((void *)f_6794,3,av);}
a=C_alloc(11);
if(C_truep(t2)){
t3=C_fixnum_difference(((C_word*)t0)[2],((C_word*)((C_word*)t0)[3])[1]);
t4=C_block_size(t2);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6811,a[2]=((C_word*)t0)[3],a[3]=t6,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t2,a[8]=((C_word)li161),tmp=(C_word)a,a+=9,tmp));
t8=((C_word*)t6)[1];
f_6811(t8,t1,t3,C_fix(0),t4);}
else{
if(C_truep(C_fixnum_lessp(C_fix(0),((C_word*)((C_word*)t0)[3])[1]))){
/* posixunix.scm:1320: poke */
t3=((C_word*)((C_word*)t0)[4])[1];{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=((C_word*)t0)[5];
av2[3]=((C_word*)((C_word*)t0)[3])[1];
((C_proc)C_fast_retrieve_proc(t3))(4,av2);}}
else{
t3=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}}

/* k8523 in a8514 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8525(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_8525,2,av);}
/* posixunix.scm:890: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[439];
av2[3]=lf[440];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* peek in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static C_word C_fcall f_6184(C_word t0){
C_word tmp;
C_word t1;
C_word t2;
C_stack_overflow_check;{}
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
return(C_SCHEME_END_OF_FILE);}
else{
t1=C_subchar(((C_word*)t0)[4],((C_word*)((C_word*)t0)[2])[1]);
return(t1);}}

/* f_7670 in k7646 in process-fork in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7670(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_7670,3,av);}
/* posixunix.scm:1588: thunk */
t3=t2;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t1;
((C_proc)C_fast_retrieve_proc(t3))(2,av2);}}

/* loop in fetch in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6198(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(11,c,6))){C_save_and_reclaim((void *)f_6198,2,av);}
a=C_alloc(11);
t2=C_read(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
t3=C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=C_fix((C_word)errno);
t5=C_i_eqvp(t4,C_fix((C_word)EWOULDBLOCK));
t6=(C_truep(t5)?t5:C_i_eqvp(t4,C_fix((C_word)EAGAIN)));
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6217,a[2]=((C_word*)t0)[5],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1179: ##sys#thread-block-for-i/o! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[335]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[335]+1);
av2[1]=t7;
av2[2]=*((C_word*)lf[336]+1);
av2[3]=((C_word*)t0)[2];
av2[4]=lf[337];
tp(5,av2);}}
else{
if(C_truep(C_i_eqvp(t4,C_fix((C_word)EINTR)))){
/* posixunix.scm:1183: ##sys#dispatch-interrupt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[172]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[172]+1);
av2[1]=t1;
av2[2]=((C_word*)((C_word*)t0)[5])[1];
tp(3,av2);}}
else{
/* posixunix.scm:1184: posix-error */
t7=lf[0];{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t7;
av2[1]=t1;
av2[2]=lf[8];
av2[3]=((C_word*)t0)[6];
av2[4]=lf[338];
av2[5]=((C_word*)t0)[2];
av2[6]=((C_word*)t0)[7];
f_2696(7,av2);}}}}
else{
t4=(C_truep(((C_word*)t0)[8])?C_eqp(t2,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_6250,a[2]=((C_word*)t0)[5],a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[6],a[10]=((C_word*)t0)[7],tmp=(C_word)a,a+=11,tmp);
/* posixunix.scm:1188: more? */
t6=((C_word*)t0)[8];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t6;
av2[1]=t5;
((C_proc)C_fast_retrieve_proc(t6))(2,av2);}}
else{
t5=C_mutate2(((C_word *)((C_word*)t0)[9])+1,t2);
t6=C_set_block_item(((C_word*)t0)[10],0,C_fix(0));
t7=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}}

/* fetch in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_6192(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(14,0,2))){
C_save_and_reclaim_args((void *)trf_6192,2,t0,t1);}
a=C_alloc(14);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_6198,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t3,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word)li141),tmp=(C_word)a,a+=12,tmp));
t5=((C_word*)t3)[1];{
C_word av2[2];
av2[0]=t5;
av2[1]=t1;
f_6198(2,av2);}}

/* k7800 in k7797 in k7794 in doloop1917 in k7779 in k7776 in process-execute in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in ... */
static void C_ccall f_7802(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_7802,2,av);}
t2=(C_truep(((C_word*)t0)[2])?C_execve(t1):C_execvp(t1));
t3=C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=stub1885(C_SCHEME_UNDEFINED);
t5=stub1897(C_SCHEME_UNDEFINED);
/* posixunix.scm:1627: posix-error */
t6=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t6;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[127];
av2[3]=lf[414];
av2[4]=lf[415];
av2[5]=((C_word*)t0)[4];
f_2696(6,av2);}}
else{
t4=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k8542 in a8533 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8544(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_8544,2,av);}
/* posixunix.scm:881: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[442];
av2[3]=lf[443];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* open-input-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5030(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +10,c,3))){
C_save_and_reclaim((void*)f_5030,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+10);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
t4=C_i_check_string_2(t2,lf[192]);
t5=C_i_pairp(t3);
t6=(C_truep(t5)?C_slot(t3,C_fix(0)):lf[193]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5044,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t8=C_eqp(t6,lf[193]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5051,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:652: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t9;
av2[2]=t2;
av2[3]=lf[192];
tp(4,av2);}}
else{
t9=C_eqp(t6,lf[194]);
if(C_truep(t9)){
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5061,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:653: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t10;
av2[2]=t2;
av2[3]=lf[192];
tp(4,av2);}}
else{
/* posixunix.scm:637: ##sys#error */
t10=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t10;
av2[1]=t7;
av2[2]=lf[195];
av2[3]=t6;
((C_proc)(void*)(*((C_word*)t10+1)))(4,av2);}}}}

/* process-fork in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7617(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +6,c,4))){
C_save_and_reclaim((void*)f_7617,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+6);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
t3=C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_i_car(t2));
t5=t4;
t6=C_i_nullp(t2);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t2));
t8=C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_FALSE:C_i_car(t7));
t10=t9;
t11=C_i_nullp(t7);
t12=(C_truep(t11)?C_SCHEME_END_OF_LIST:C_i_cdr(t7));
t13=stub1856(C_SCHEME_UNDEFINED,C_SCHEME_FALSE);
t14=stub1835(C_SCHEME_UNDEFINED);
t15=t14;
t16=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7648,a[2]=t5,a[3]=t15,a[4]=t10,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t17=C_eqp(C_fix(-1),t15);
if(C_truep(t17)){
/* posixunix.scm:1584: posix-error */
t18=lf[0];{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t18;
av2[1]=t16;
av2[2]=lf[127];
av2[3]=lf[409];
av2[4]=lf[412];
f_2696(5,av2);}}
else{
t18=t16;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t18;
av2[1]=C_SCHEME_UNDEFINED;
f_7648(2,av2);}}}

/* k7608 in k7605 in get-host-name in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7610(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_7610,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k5042 in open-input-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5044(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_5044,2,av);}
/* posixunix.scm:648: check */
f_5015(((C_word*)t0)[3],lf[192],((C_word*)t0)[4],C_SCHEME_TRUE,t1);}

/* k6757 in a6748 in k6730 in k6663 in custom-output-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6759(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_6759,2,av);}
/* posixunix.scm:1329: on-close */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)C_fast_retrieve_proc(t2))(2,av2);}}

/* k7646 in process-fork in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7648(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(7,c,3))){C_save_and_reclaim((void *)f_7648,2,av);}
a=C_alloc(7);
t2=(C_truep(((C_word*)t0)[2])?C_eqp(((C_word*)t0)[3],C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t2)){
t3=(C_truep(((C_word*)t0)[4])?*((C_word*)lf[410]+1):(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7670,a[2]=((C_word)li188),tmp=(C_word)a,a+=3,tmp));
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7662,a[2]=((C_word*)t0)[2],a[3]=((C_word)li189),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1585: g1863 */
t5=t3;{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t5;
av2[1]=((C_word*)t0)[5];
av2[2]=t4;
((C_proc)C_fast_retrieve_proc(t5))(3,av2);}}
else{
t3=((C_word*)t0)[5];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k5049 in open-input-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5051(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(2,c,5))){C_save_and_reclaim((void *)f_5051,2,av);}
a=C_alloc(2);
t2=open_text_input_pipe(&a,1,t1);
/* posixunix.scm:648: check */
f_5015(((C_word*)t0)[3],lf[192],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* a8533 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8534(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(4,c,2))){C_save_and_reclaim((void *)f_8534,3,av);}
a=C_alloc(4);
t3=C_setgid(t2);
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8544,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:880: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[5]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[5]+1);
av2[1]=t4;
tp(2,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* a8530 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8531(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_8531,2,av);}
t2=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=stub1157(C_SCHEME_UNDEFINED);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k7544 in terminal-name in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7546(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,3))){C_save_and_reclaim((void *)f_7546,2,av);}
a=C_alloc(5);
t2=C_C_fileno(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];
t4=C_a_i_bytevector(&a,1,C_fix(3));
t5=C_i_foreign_fixnum_argumentp(t2);
t6=stub1798(t4,t5);
/* posixunix.scm:1542: ##sys#peek-nonnull-c-string */
t7=*((C_word*)lf[246]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=t6;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* terminal-name in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7542(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_7542,3,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7546,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1544: ##sys#terminal-check */
f_7511(t3,lf[401],t2);}

/* k5059 in open-input-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5061(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(2,c,5))){C_save_and_reclaim((void *)f_5061,2,av);}
a=C_alloc(2);
t2=open_binary_input_pipe(&a,1,t1);
/* posixunix.scm:648: check */
f_5015(((C_word*)t0)[3],lf[192],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* ##sys#custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6120(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c<5) C_bad_min_argc_2(c,5,t0);
if(!C_demand(C_calculate_demand((c-5)*C_SIZEOF_PAIR +9,c,2))){
C_save_and_reclaim((void*)f_6120,c,av);}
a=C_alloc((c-5)*C_SIZEOF_PAIR+9);
t5=C_build_rest(&a,c,5,av);
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
t6=C_i_nullp(t5);
t7=(C_truep(t6)?C_SCHEME_FALSE:C_i_car(t5));
t8=C_i_nullp(t5);
t9=(C_truep(t8)?C_SCHEME_END_OF_LIST:C_i_cdr(t5));
t10=C_i_nullp(t9);
t11=(C_truep(t10)?C_fix(1):C_i_car(t9));
t12=t11;
t13=C_i_nullp(t9);
t14=(C_truep(t13)?C_SCHEME_END_OF_LIST:C_i_cdr(t9));
t15=C_i_nullp(t14);
t16=(C_truep(t15)?*((C_word*)lf[332]+1):C_i_car(t14));
t17=t16;
t18=C_i_nullp(t14);
t19=(C_truep(t18)?C_SCHEME_END_OF_LIST:C_i_cdr(t14));
t20=C_i_nullp(t19);
t21=(C_truep(t20)?C_SCHEME_FALSE:C_i_car(t19));
t22=t21;
t23=C_i_nullp(t19);
t24=(C_truep(t23)?C_SCHEME_END_OF_LIST:C_i_cdr(t19));
t25=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6148,a[2]=t12,a[3]=t2,a[4]=t4,a[5]=t3,a[6]=t22,a[7]=t1,a[8]=t17,tmp=(C_word)a,a+=9,tmp);
if(C_truep(t7)){
/* posixunix.scm:1153: ##sys#file-nonblocking! */
t26=*((C_word*)lf[129]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t26;
av2[1]=t25;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t26+1)))(3,av2);}}
else{
t26=t25;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t26;
av2[1]=C_SCHEME_UNDEFINED;
f_6148(2,av2);}}}

/* a6742 in k6730 in k6663 in custom-output-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6743(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_6743,3,av);}
/* posixunix.scm:1324: store */
t3=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
((C_proc)C_fast_retrieve_proc(t3))(3,av2);}}

/* a6748 in k6730 in k6663 in custom-output-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6749(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(4,c,6))){C_save_and_reclaim((void *)f_6749,2,av);}
a=C_alloc(4);
if(C_truep(C_slot(((C_word*)((C_word*)t0)[2])[1],C_fix(8)))){
t2=C_SCHEME_UNDEFINED;
t3=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6759,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=C_close(((C_word*)t0)[4]);
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
/* posixunix.scm:1328: posix-error */
t4=lf[0];{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t4;
av2[1]=t2;
av2[2]=lf[8];
av2[3]=((C_word*)t0)[5];
av2[4]=lf[347];
av2[5]=((C_word*)t0)[4];
av2[6]=((C_word*)t0)[6];
f_2696(7,av2);}}
else{
/* posixunix.scm:1329: on-close */
t4=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t1;
((C_proc)C_fast_retrieve_proc(t4))(2,av2);}}}}

/* k6739 in k6735 in k6730 in k6663 in custom-output-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6741(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_6741,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)((C_word*)t0)[3])[1];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k2800 in file-owner in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2802(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2802,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* file-permissions in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2804(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(3,c,5))){C_save_and_reclaim((void *)f_2804,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2808,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:267: ##sys#stat */
f_2714(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[21]);}

/* k2806 in file-permissions in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2808(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2808,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k6720 in loop in poke1537 in k6663 in custom-output-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6722(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6722,2,av);}
t2=C_fixnum_difference(((C_word*)t0)[2],((C_word*)t0)[3]);
/* posixunix.scm:1297: poke */
t3=((C_word*)((C_word*)t0)[4])[1];{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[5];
av2[2]=t1;
av2[3]=t2;
((C_proc)C_fast_retrieve_proc(t3))(4,av2);}}

/* k2833 in file-type in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2835(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2835,2,av);}
if(C_truep(t1)){
t2=C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_stat_type);
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFREG)))){
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=lf[24];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFLNK)))){
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=lf[25];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFDIR)))){
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=lf[26];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFCHR)))){
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=lf[27];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFBLK)))){
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=lf[28];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFIFO)))){
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=lf[29];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_i_eqvp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFSOCK));
t4=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=(C_truep(t3)?lf[30]:lf[24]);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}}}}}}
else{
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k6286 in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6288(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_6288,2,av);}
a=C_alloc(4);
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6292,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1277: set-port-name! */
t4=*((C_word*)lf[340]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)((C_word*)t0)[2])[1];
av2[3]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k6116 in file-link in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6118(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,6))){C_save_and_reclaim((void *)f_6118,2,av);}
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm:1148: posix-error */
t2=lf[0];{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[8];
av2[3]=lf[329];
av2[4]=lf[330];
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[4];
f_2696(7,av2);}}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* a6770 in k6730 in k6663 in custom-output-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6771(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_6771,2,av);}
/* posixunix.scm:1331: store */
t2=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=C_SCHEME_FALSE;
((C_proc)C_fast_retrieve_proc(t2))(3,av2);}}

/* f_6779 in k6663 in custom-output-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6779(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6779,3,av);}
if(C_truep(t2)){
t3=C_block_size(t2);
/* posixunix.scm:1303: poke */
t4=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
((C_proc)C_fast_retrieve_proc(t4))(4,av2);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k6290 in k6286 in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6292(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_6292,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)((C_word*)t0)[3])[1];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* a6293 in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6294(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(5,c,2))){C_save_and_reclaim((void *)f_6294,2,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6298,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[3])[1],((C_word*)((C_word*)t0)[4])[1]))){
/* posixunix.scm:1207: fetch */
t3=((C_word*)t0)[5];
f_6192(t3,t2);}
else{
t3=t2;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_6298(2,av2);}}}

/* k6296 in a6293 in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6298(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_6298,2,av);}
t2=f_6184(((C_word*)t0)[2]);
if(C_truep(C_eofp(t2))){
t3=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_fixnum_plus(((C_word*)((C_word*)t0)[4])[1],C_fix(1));
t4=C_mutate2(((C_word *)((C_word*)t0)[4])+1,t3);
t5=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k4832 in k4597 in k4589 in k4586 in k4583 in file-select in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4834(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,1))){C_save_and_reclaim((void *)f_4834,2,av);}
a=C_alloc(4);
t2=C_a_i_times(&a,2,t1,C_fix(1000));
t3=((C_word*)t0)[2];
f_4823(t3,C_i_inexact_to_exact(t2));}

/* doloop884 in k4597 in k4589 in k4586 in k4583 in file-select in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static C_word C_fcall f_4836(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_nullp(t2))){
t3=C_SCHEME_UNDEFINED;
return(t3);}
else{
t3=C_i_car(t2);
t4=t1;
t5=C_i_foreign_fixnum_argumentp(t4);
t6=C_i_foreign_fixnum_argumentp(t3);
if(C_truep(((C_word*)t0)[2])){
t7=C_i_foreign_block_argumentp(((C_word*)t0)[2]);
t8=stub893(C_SCHEME_UNDEFINED,t5,t6,t7);
t9=C_fixnum_plus(t1,C_fix(1));
t10=t2;
t11=C_u_i_cdr(t10);
t13=t9;
t14=t11;
t1=t13;
t2=t14;
goto loop;}
else{
t7=stub893(C_SCHEME_UNDEFINED,t5,t6,C_SCHEME_FALSE);
t8=C_fixnum_plus(t1,C_fix(1));
t9=t2;
t10=C_u_i_cdr(t9);
t13=t8;
t14=t10;
t1=t13;
t2=t14;
goto loop;}}}

/* k5258 in create-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5260(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_5260,2,av);}
/* posixunix.scm:723: values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=C_fix((C_word)C_pipefds[ 0 ]);
av2[3]=C_fix((C_word)C_pipefds[ 1 ]);
C_values(4,av2);}}

/* k5772 in k5779 in initialize-groups in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5774(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_5774,2,av);}
/* posixunix.scm:995: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[265];
av2[3]=lf[266];
av2[4]=((C_word*)t0)[3];
av2[5]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k5779 in initialize-groups in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5781(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,2))){C_save_and_reclaim((void *)f_5781,2,av);}
a=C_alloc(5);
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5774,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:994: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[5]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[5]+1);
av2[1]=t2;
tp(2,av2);}}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k4671 in k4664 in k4661 in k4821 in k4597 in k4589 in k4586 in k4583 in file-select in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_4673(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,0,3))){
C_save_and_reclaim_args((void *)trf_4673,2,t0,t1);}
if(C_truep(((C_word*)t0)[2])){
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
if(C_truep(C_i_memq(((C_word*)t0)[2],((C_word*)t0)[3]))){
t2=((C_word*)t0)[2];
/* posixunix.scm:611: values */{
C_word av2[4];
av2[0]=0;
av2[1]=((C_word*)t0)[4];
av2[2]=t1;
av2[3]=t2;
C_values(4,av2);}}
else{
/* posixunix.scm:611: values */{
C_word av2[4];
av2[0]=0;
av2[1]=((C_word*)t0)[4];
av2[2]=t1;
av2[3]=C_SCHEME_FALSE;
C_values(4,av2);}}}
else{
/* posixunix.scm:611: values */{
C_word av2[4];
av2[0]=0;
av2[1]=((C_word*)t0)[4];
av2[2]=t1;
av2[3]=((C_word*)t0)[3];
C_values(4,av2);}}}
else{
/* posixunix.scm:611: values */{
C_word av2[4];
av2[0]=0;
av2[1]=((C_word*)t0)[4];
av2[2]=t1;
av2[3]=C_SCHEME_FALSE;
C_values(4,av2);}}}

/* terminal-port? in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7493(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_7493,3,av);}
a=C_alloc(4);
t3=t2;
t4=C_i_check_port_2(t3,C_fix(0),C_SCHEME_TRUE,lf[398]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7499,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1532: ##sys#peek-unsigned-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[65]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[65]+1);
av2[1]=t5;
av2[2]=t2;
av2[3]=C_fix(0);
tp(4,av2);}}

/* k7497 in terminal-port? in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7499(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_7499,2,av);}
t2=C_eqp(C_fix(0),t1);
if(C_truep(t2)){
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_tty_portp(((C_word*)t0)[3]);
t4=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* a3879 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3880(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3880,2,av);}
t2=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* a3882 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3883(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(3,c,4))){C_save_and_reclaim((void *)f_3883,2,av);}
a=C_alloc(3);
t2=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3885,a[2]=((C_word)li51),tmp=(C_word)a,a+=3,tmp);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* f_3885 in a3882 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3885(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand(3,c,1))){C_save_and_reclaim((void *)f_3885,4,av);}
a=C_alloc(3);
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_a_i_cons(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* a5241 in a5235 in k5224 in with-output-to-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5242(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2))){
C_save_and_reclaim((void*)f_5242,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5246,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:713: close-output-pipe */
t4=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* utc-time->seconds in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7377(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(5,c,3))){C_save_and_reclaim((void *)f_7377,3,av);}
a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7381,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1482: check-time-vector */
f_3900(t3,lf[386],t2);}

/* k5244 in a5241 in a5235 in k5224 in with-output-to-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5246(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_5246,2,av);}{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
C_apply_values(3,av2);}}

/* k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3898(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a;
if(!C_demand(C_calculate_demand(38,c,4))){C_save_and_reclaim((void *)f_3898,2,av);}
a=C_alloc(38);
t2=C_mutate2((C_word*)lf[102]+1 /* (set! file-creation-mode ...) */,t1);
t3=C_mutate2(&lf[103] /* (set! check-time-vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3900,a[2]=((C_word)li56),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate2((C_word*)lf[105]+1 /* (set! seconds->local-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3919,a[2]=((C_word)li57),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate2((C_word*)lf[108]+1 /* (set! seconds->utc-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3940,a[2]=((C_word)li58),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate2((C_word*)lf[109]+1 /* (set! seconds->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3971,a[2]=((C_word)li59),tmp=(C_word)a,a+=3,tmp));
t7=C_fix((C_word)sizeof(struct tm));
t8=C_mutate2((C_word*)lf[111]+1 /* (set! local-time->seconds ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4009,a[2]=t7,a[3]=((C_word)li60),tmp=(C_word)a,a+=4,tmp));
t9=C_fix((C_word)sizeof(struct tm));
t10=C_mutate2((C_word*)lf[115]+1 /* (set! time->string ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4054,a[2]=t9,a[3]=((C_word)li61),tmp=(C_word)a,a+=4,tmp));
t11=C_mutate2((C_word*)lf[118]+1 /* (set! setenv ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4116,a[2]=((C_word)li62),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate2((C_word*)lf[119]+1 /* (set! unsetenv ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4133,a[2]=((C_word)li63),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate2((C_word*)lf[120]+1 /* (set! get-environment-variables ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4153,a[2]=((C_word)li66),tmp=(C_word)a,a+=3,tmp));
t14=C_mutate2((C_word*)lf[121]+1 /* (set! set-signal-handler! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4219,a[2]=((C_word)li67),tmp=(C_word)a,a+=3,tmp));
t15=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4234,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t16=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8622,a[2]=((C_word)li242),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:662: getter-with-setter */
t17=*((C_word*)lf[437]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t17;
av2[1]=t15;
av2[2]=t16;
av2[3]=*((C_word*)lf[121]+1);
((C_proc)(void*)(*((C_word*)t17+1)))(4,av2);}}

/* a3890 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3891(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(3,c,2))){C_save_and_reclaim((void *)f_3891,2,av);}
a=C_alloc(3);
t2=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3893,a[2]=((C_word)li53),tmp=(C_word)a,a+=3,tmp);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* f_3893 in a3890 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3893(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3893,2,av);}
t2=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_SCHEME_TRUE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k7359 in k7355 in string->time in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7361(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(17,c,3))){C_save_and_reclaim((void *)f_7361,2,av);}
a=C_alloc(17);
t2=t1;
t3=C_a_i_vector(&a,10,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE);
t4=t3;
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7369,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1477: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[72]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[72]+1);
av2[1]=t5;
av2[2]=((C_word*)t0)[4];
av2[3]=C_make_character(0);
tp(4,av2);}}

/* a5250 in k5224 in with-output-to-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5251(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_5251,2,av);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[206]+1));
t3=C_mutate2((C_word*)lf[206]+1 /* (set! ##sys#standard-output ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k7367 in k7359 in k7355 in string->time in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7369(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_7369,2,av);}
t2=((C_word*)t0)[2];
if(C_truep(t1)){
t3=C_i_foreign_block_argumentp(t1);
t4=t2;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=stub1726(C_SCHEME_UNDEFINED,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=t2;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=stub1726(C_SCHEME_UNDEFINED,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* create-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5256(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(3,c,4))){C_save_and_reclaim((void *)f_5256,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5260,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=C_pipe(C_SCHEME_FALSE);
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
/* posixunix.scm:722: posix-error */
t4=lf[0];{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t2;
av2[2]=lf[8];
av2[3]=lf[207];
av2[4]=lf[208];
f_2696(5,av2);}}
else{
/* posixunix.scm:723: values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_fix((C_word)C_pipefds[ 0 ]);
av2[3]=C_fix((C_word)C_pipefds[ 1 ]);
C_values(4,av2);}}}

/* k3864 in k3861 in k3858 in k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3866(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a;
if(!C_demand(C_calculate_demand(17,c,2))){C_save_and_reclaim((void *)f_3866,2,av);}
a=C_alloc(17);
t2=((C_word*)t0)[2];
t3=((C_word*)t0)[3];
t4=((C_word*)t0)[4];
t5=((C_word*)t0)[5];
t6=((C_word*)t0)[6];
t7=((C_word*)t0)[7];
t8=t1;
t9=((C_word*)t0)[8];
t10=C_i_check_string_2(t3,lf[76]);
t11=C_fix(0);
t12=(*a=C_VECTOR_TYPE|1,a[1]=t11,tmp=(C_word)a,a+=2,tmp);
t13=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3675,a[2]=t8,a[3]=t5,a[4]=t12,a[5]=t9,a[6]=t2,a[7]=t3,a[8]=t6,a[9]=t4,tmp=(C_word)a,a+=10,tmp);
if(C_truep(t7)){
if(C_truep(C_fixnump(t7))){
t14=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3841,a[2]=t12,a[3]=t7,a[4]=((C_word)li45),tmp=(C_word)a,a+=5,tmp);
t15=t13;
f_3675(t15,t14);}
else{
t14=t13;
f_3675(t14,t7);}}
else{
t14=t13;
f_3675(t14,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3833,a[2]=((C_word)li46),tmp=(C_word)a,a+=3,tmp));}}

/* k3861 in k3858 in k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3863(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(12,c,4))){C_save_and_reclaim((void *)f_3863,2,av);}
a=C_alloc(12);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3866,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=t2,tmp=(C_word)a,a+=9,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3871,a[2]=((C_word)li47),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:551: ##sys#get-keyword */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[97]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[97]+1);
av2[1]=t3;
av2[2]=lf[78];
av2[3]=((C_word*)t0)[8];
av2[4]=t4;
tp(5,av2);}}

/* k3858 in k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3860(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(12,c,4))){C_save_and_reclaim((void *)f_3860,2,av);}
a=C_alloc(12);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3863,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t2,a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3874,a[2]=((C_word)li48),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:551: ##sys#get-keyword */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[97]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[97]+1);
av2[1]=t3;
av2[2]=lf[77];
av2[3]=((C_word*)t0)[7];
av2[4]=t4;
tp(5,av2);}}

/* file-size in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2810(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(3,c,5))){C_save_and_reclaim((void *)f_2810,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2814,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:268: ##sys#stat */
f_2714(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[22]);}

/* k2812 in file-size in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2814(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,1))){C_save_and_reclaim((void *)f_2814,2,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_a_double_to_num(&a,C_statbuf.st_size);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* file-type in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2816(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +3,c,5))){
C_save_and_reclaim((void*)f_2816,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+3);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t8=C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_TRUE:C_i_car(t7));
t10=C_i_nullp(t7);
t11=(C_truep(t10)?C_SCHEME_END_OF_LIST:C_i_cdr(t7));
t12=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2835,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:271: ##sys#stat */
f_2714(t12,t2,t5,t9,lf[23]);}

/* a3873 in k3858 in k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3874(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3874,2,av);}
t2=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* a3870 in k3861 in k3858 in k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3871(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3871,2,av);}
t2=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* a3876 in k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3877(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3877,2,av);}
t2=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k4664 in k4661 in k4821 in k4597 in k4589 in k4586 in k4583 in file-select in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4666(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,2))){C_save_and_reclaim((void *)f_4666,2,av);}
a=C_alloc(5);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4673,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[4])){
if(C_truep(C_fixnump(((C_word*)t0)[4]))){
t4=C_i_memq(((C_word*)t0)[4],((C_word*)t0)[5]);
t5=t3;
f_4673(t5,(C_truep(t4)?((C_word*)t0)[4]:C_SCHEME_FALSE));}
else{
t4=t3;
f_4673(t4,((C_word*)t0)[5]);}}
else{
t4=t3;
f_4673(t4,C_SCHEME_FALSE);}}

/* k4661 in k4821 in k4597 in k4589 in k4586 in k4583 in file-select in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4663(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(13,c,5))){C_save_and_reclaim((void *)f_4663,2,av);}
a=C_alloc(13);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4666,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4703,a[2]=t5,a[3]=((C_word*)t0)[5],a[4]=((C_word)li83),tmp=(C_word)a,a+=5,tmp));
t7=((C_word*)t5)[1];
f_4703(t7,t3,((C_word*)t0)[6],C_SCHEME_END_OF_LIST,((C_word*)t0)[7]);}

/* a3779 in k3741 in k3797 in k3707 in k3698 in loop in k3683 in k3676 in k3673 in k3864 in k3861 in k3858 in k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in ... */
static void C_ccall f_3780(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3780,2,av);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate2(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[4])[1]);
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6148(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,2))){C_save_and_reclaim((void *)f_6148,2,av);}
a=C_alloc(9);
t2=C_fixnump(((C_word*)t0)[2]);
t3=(C_truep(t2)?((C_word*)t0)[2]:C_block_size(((C_word*)t0)[2]));
t4=t3;
t5=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6154,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t4,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
/* posixunix.scm:1155: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[72]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[72]+1);
av2[1]=t5;
av2[2]=((C_word*)t0)[2];
tp(3,av2);}}
else{
t6=t5;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t6;
av2[1]=((C_word*)t0)[2];
f_6154(2,av2);}}}

/* a5201 in k5190 in with-input-from-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5202(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_5202,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5208,a[2]=((C_word*)t0)[2],a[3]=((C_word)li100),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:703: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
av2[3]=t2;
C_call_with_values(4,av2);}}

/* a5207 in a5201 in k5190 in with-input-from-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5208(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2))){
C_save_and_reclaim((void*)f_5208,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5212,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:705: close-input-pipe */
t4=*((C_word*)lf[197]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k6157 in ready? in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6159(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,6))){C_save_and_reclaim((void *)f_6159,2,av);}
t2=C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
t3=C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
t4=(C_truep(t3)?t3:C_eqp(C_fix((C_word)errno),C_fix((C_word)EAGAIN)));
if(C_truep(t4)){
t5=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
/* posixunix.scm:1165: posix-error */
t5=lf[0];{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t5;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[8];
av2[3]=((C_word*)t0)[3];
av2[4]=lf[333];
av2[5]=((C_word*)t0)[4];
av2[6]=((C_word*)t0)[5];
f_2696(7,av2);}}}
else{
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_eqp(C_fix(1),t1);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* ready? in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_6155(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(6,0,2))){
C_save_and_reclaim_args((void *)trf_6155,2,t0,t1);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6159,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1160: ##sys#file-select-one */
t3=*((C_word*)lf[130]+1);{
C_word av2[3];
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k4560 in k4554 in file-mkstemp in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4562(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,4))){C_save_and_reclaim((void *)f_4562,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4569,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_fixnum_difference(((C_word*)t0)[4],C_fix(1));
/* posixunix.scm:556: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[70]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[70]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[5];
av2[3]=C_fix(0);
av2[4]=t3;
tp(5,av2);}}

/* k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6154(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word *a;
if(!C_demand(C_calculate_demand(81,c,8))){C_save_and_reclaim((void *)f_6154,2,av);}
a=C_alloc(81);
t2=t1;
t3=C_fix(0);
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_fix(0);
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6155,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word)li140),tmp=(C_word)a,a+=6,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6184,a[2]=t6,a[3]=t4,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t9=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_6192,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[2],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[6],a[8]=t4,a[9]=t6,a[10]=((C_word)li142),tmp=(C_word)a,a+=11,tmp);
t10=C_SCHEME_UNDEFINED;
t11=(*a=C_VECTOR_TYPE|1,a[1]=t10,tmp=(C_word)a,a+=2,tmp);
t12=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6288,a[2]=t11,a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t13=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6294,a[2]=t8,a[3]=t6,a[4]=t4,a[5]=t9,a[6]=((C_word)li143),tmp=(C_word)a,a+=7,tmp);
t14=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6319,a[2]=t6,a[3]=t4,a[4]=t7,a[5]=((C_word)li144),tmp=(C_word)a,a+=6,tmp);
t15=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6331,a[2]=t11,a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[2],a[6]=((C_word*)t0)[4],a[7]=((C_word)li145),tmp=(C_word)a,a+=8,tmp);
t16=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6353,a[2]=t8,a[3]=t6,a[4]=t4,a[5]=t9,a[6]=((C_word)li146),tmp=(C_word)a,a+=7,tmp);
t17=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6368,a[2]=t6,a[3]=t4,a[4]=t2,a[5]=t9,a[6]=((C_word)li148),tmp=(C_word)a,a+=7,tmp);
t18=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6444,a[2]=t6,a[3]=t4,a[4]=t2,a[5]=t9,a[6]=((C_word)li152),tmp=(C_word)a,a+=7,tmp);
t19=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6567,a[2]=t6,a[3]=t4,a[4]=t2,a[5]=((C_word)li153),tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1204: make-input-port */
t20=*((C_word*)lf[344]+1);{
C_word *av2;
if(c >= 9) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(9);
}
av2[0]=t20;
av2[1]=t12;
av2[2]=t13;
av2[3]=t14;
av2[4]=t15;
av2[5]=t16;
av2[6]=t17;
av2[7]=t18;
av2[8]=t19;
((C_proc)(void*)(*((C_word*)t20+1)))(9,av2);}}

/* k5706 in doloop1237 in k5685 in set-groups! in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5708(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_5708,2,av);}
/* posixunix.scm:983: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[262];
av2[3]=lf[263];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* k5210 in a5207 in a5201 in k5190 in with-input-from-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5212(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_5212,2,av);}{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
C_apply_values(3,av2);}}

/* a5216 in k5190 in with-input-from-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5217(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_5217,2,av);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[204]+1));
t3=C_mutate2((C_word*)lf[204]+1 /* (set! ##sys#standard-input ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* initialize-groups in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5758(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand(9,c,2))){C_save_and_reclaim((void *)f_5758,4,av);}
a=C_alloc(9);
t4=C_i_check_string_2(t2,lf[265]);
t5=C_i_check_exact_2(t3,lf[265]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5781,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=t6;
t8=t2;
t9=t3;
t10=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5746,a[2]=t9,a[3]=t7,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t8)){
t11=C_i_foreign_string_argumentp(t8);
/* posixunix.scm:989: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t10;
av2[2]=t11;
tp(3,av2);}}
else{
t11=C_i_foreign_fixnum_argumentp(t9);
t12=t7;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t12;
av2[1]=stub1251(C_SCHEME_UNDEFINED,C_SCHEME_FALSE,t11);
((C_proc)(void*)(*((C_word*)t12+1)))(2,av2);}}}

/* k4589 in k4586 in k4583 in file-select in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_4591(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(!C_demand(C_calculate_demand(10,0,2))){
C_save_and_reclaim_args((void *)trf_4591,2,t0,t1);}
a=C_alloc(10);
t2=t1;
t3=C_u_i_length(((C_word*)t0)[2]);
t4=C_u_i_length(t2);
t5=C_fixnum_plus(t3,t4);
t6=t5;
t7=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4599,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=t3,a[5]=t2,a[6]=t6,a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[6],tmp=(C_word)a,a+=10,tmp);
t8=C_fix((C_word)sizeof(struct pollfd));
t9=C_fixnum_times(t6,t8);
/* posixunix.scm:574: ##sys#make-blob */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[186]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[186]+1);
av2[1]=t7;
av2[2]=t9;
tp(3,av2);}}

/* k4567 in k4560 in k4554 in file-mkstemp in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4569(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_4569,2,av);}
/* posixunix.scm:556: values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
C_values(4,av2);}}

/* posix-error in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2696(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c<5) C_bad_min_argc_2(c,5,t0);
if(!C_demand(C_calculate_demand((c-5)*C_SIZEOF_PAIR +7,c,2))){
C_save_and_reclaim((void*)f_2696,c,av);}
a=C_alloc((c-5)*C_SIZEOF_PAIR+7);
t5=C_build_rest(&a,c,5,av);
C_word t6;
C_word t7;
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2700,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t5,a[6]=t4,tmp=(C_word)a,a+=7,tmp);
/* posix-common.scm:183: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[5]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[5]+1);
av2[1]=t6;
tp(2,av2);}}

/* k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2684(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(!C_demand(C_calculate_demand(18,c,6))){C_save_and_reclaim((void *)f_2684,2,av);}
a=C_alloc(18);
t2=C_mutate2(&lf[0] /* (set! posix-error ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2696,a[2]=((C_word)li0),tmp=(C_word)a,a+=3,tmp));
t3=C_mutate2((C_word*)lf[6]+1 /* (set! ##sys#posix-error ...) */,lf[0]);
t4=C_mutate2(&lf[7] /* (set! ##sys#stat ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2714,a[2]=((C_word)li1),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate2((C_word*)lf[16]+1 /* (set! file-stat ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2764,a[2]=((C_word)li2),tmp=(C_word)a,a+=3,tmp));
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2784,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8699,a[2]=((C_word)li246),tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8705,a[2]=((C_word)li247),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:251: getter-with-setter */
t9=*((C_word*)lf[437]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t9;
av2[1]=t6;
av2[2]=t7;
av2[3]=t8;
av2[4]=lf[456];
((C_proc)(void*)(*((C_word*)t9+1)))(5,av2);}}

/* k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2681(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,2))){C_save_and_reclaim((void *)f_2681,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2684,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=C_SCHEME_UNDEFINED;
av2[1]=t2;
C_ports_toplevel(2,av2);}}

/* _exit in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7409(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +0,c,1))){
C_save_and_reclaim((void*)f_7409,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+0);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
if(C_truep(C_i_pairp(t2))){
t3=t2;
t4=C_u_i_car(t3);
t5=t1;
t6=C_i_foreign_fixnum_argumentp(t4);
t7=t5;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t7;
av2[1]=stub1762(C_SCHEME_UNDEFINED,t6);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t3=t1;
t4=C_i_foreign_fixnum_argumentp(C_fix(0));
t5=t3;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=stub1762(C_SCHEME_UNDEFINED,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k5744 in initialize-groups in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5746(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_5746,2,av);}
t2=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=stub1251(C_SCHEME_UNDEFINED,t1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k2676 in k2673 in k2670 */
static void C_ccall f_2678(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,2))){C_save_and_reclaim((void *)f_2678,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2681,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=C_SCHEME_UNDEFINED;
av2[1]=t2;
C_files_toplevel(2,av2);}}

/* k2673 in k2670 */
static void C_ccall f_2675(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,2))){C_save_and_reclaim((void *)f_2675,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2678,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=C_SCHEME_UNDEFINED;
av2[1]=t2;
C_extras_toplevel(2,av2);}}

/* k2670 */
static void C_ccall f_2672(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,2))){C_save_and_reclaim((void *)f_2672,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2675,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=C_SCHEME_UNDEFINED;
av2[1]=t2;
C_irregex_toplevel(2,av2);}}

/* k7389 in k7383 in k7379 in utc-time->seconds in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7391(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_7391,2,av);}
if(C_truep(t1)){
/* posixunix.scm:1485: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[386];
av2[3]=lf[387];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}
else{
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* local-timezone-abbreviation in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7396(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(5,c,3))){C_save_and_reclaim((void *)f_7396,2,av);}
a=C_alloc(5);
t2=C_a_i_bytevector(&a,1,C_fix(3));
t3=stub1756(t2);
/* posixunix.scm:1489: ##sys#peek-c-string */
t4=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t1;
av2[2]=t3;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* g428 in k3616 in loop in k3597 in k3590 in a3587 in conc-loop in glob in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_3622(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(9,0,2))){
C_save_and_reclaim_args((void *)trf_3622,3,t0,t1,t2);}
a=C_alloc(9);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3630,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3642,a[2]=t3,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:509: irregex-match-substring */
t5=*((C_word*)lf[88]+1);{
C_word av2[3];
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}

/* k7379 in utc-time->seconds in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7381(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_7381,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7385,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1483: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[72]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[72]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=C_make_character(0);
tp(4,av2);}}

/* k7383 in k7379 in utc-time->seconds in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7385(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_7385,2,av);}
a=C_alloc(9);
t2=C_a_timegm(&a,2,((C_word*)t0)[2],t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7391,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1484: fp= */
t4=*((C_word*)lf[113]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[114];
av2[3]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* a8363 in process in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8364(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_8364,6,av);}
/* posixunix.scm:1795: values */{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=t4;
C_values(5,av2);}}

/* loop in k3597 in k3590 in a3587 in conc-loop in glob in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_3601(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(6,0,3))){
C_save_and_reclaim_args((void *)trf_3601,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_i_nullp(t2))){
t3=C_i_cdr(((C_word*)t0)[2]);
/* posix-common.scm:505: conc-loop */
t4=((C_word*)((C_word*)t0)[3])[1];
f_3567(t4,t1,t3);}
else{
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3618,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t4=C_i_car(t2);
/* posix-common.scm:506: irregex-match */
t5=*((C_word*)lf[89]+1);{
C_word av2[4];
av2[0]=t5;
av2[1]=t3;
av2[2]=((C_word*)t0)[6];
av2[3]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}}

/* with-output-to-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5222(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +4,c,4))){
C_save_and_reclaim((void*)f_5222,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+4);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5226,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t5;
av2[2]=*((C_word*)lf[196]+1);
av2[3]=t2;
av2[4]=t4;
C_apply(5,av2);}}

/* k5224 in with-output-to-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5226(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(!C_demand(C_calculate_demand(19,c,4))){C_save_and_reclaim((void *)f_5226,2,av);}
a=C_alloc(19);
t2=t1;
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5231,a[2]=t6,a[3]=t4,a[4]=((C_word)li104),tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5236,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li106),tmp=(C_word)a,a+=5,tmp);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5251,a[2]=t4,a[3]=t6,a[4]=((C_word)li107),tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:708: ##sys#dynamic-wind */
t10=*((C_word*)lf[95]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t10;
av2[1]=((C_word*)t0)[3];
av2[2]=t7;
av2[3]=t8;
av2[4]=t9;
((C_proc)(void*)(*((C_word*)t10+1)))(5,av2);}}

/* k3660 in a3587 in conc-loop in glob in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3662(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_3662,2,av);}
/* posix-common.scm:503: ##sys#glob->regexp */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[91]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[91]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
tp(3,av2);}}

/* file-select in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4581(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +5,c,2))){
C_save_and_reclaim((void*)f_4581,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+5);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4585,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(t4))){
t6=t4;
t7=t5;
f_4585(t7,C_u_i_car(t6));}
else{
t6=t5;
f_4585(t6,C_SCHEME_FALSE);}}

/* a5230 in k5224 in with-output-to-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5231(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_5231,2,av);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[206]+1));
t3=C_mutate2((C_word*)lf[206]+1 /* (set! ##sys#standard-output ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* lp in k4661 in k4821 in k4597 in k4589 in k4586 in k4583 in file-select in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_4703(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(!C_demand(C_calculate_demand(7,0,2))){
C_save_and_reclaim_args((void *)trf_4703,5,t0,t1,t2,t3,t4);}
a=C_alloc(7);
if(C_truep(C_i_nullp(t4))){
/* posixunix.scm:604: ##sys#fast-reverse */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[184]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[184]+1);
av2[1]=t1;
av2[2]=t3;
tp(3,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4732,a[2]=t2,a[3]=t4,a[4]=t3,a[5]=((C_word*)t0)[2],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
t6=t2;
t7=C_i_foreign_fixnum_argumentp(t6);
if(C_truep(((C_word*)t0)[3])){
t8=C_i_foreign_block_argumentp(((C_word*)t0)[3]);
t9=t5;
f_4732(t9,stub952(C_SCHEME_UNDEFINED,t7,t8));}
else{
t8=t5;
f_4732(t8,stub952(C_SCHEME_UNDEFINED,t7,C_SCHEME_FALSE));}}}

/* a5235 in k5224 in with-output-to-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5236(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_5236,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5242,a[2]=((C_word*)t0)[2],a[3]=((C_word)li105),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:711: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
av2[3]=t2;
C_call_with_values(4,av2);}}

/* k4597 in k4589 in k4586 in k4583 in file-select in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4599(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(!C_demand(C_calculate_demand(21,c,3))){C_save_and_reclaim((void *)f_4599,2,av);}
a=C_alloc(21);
t2=t1;
t3=(C_truep(((C_word*)t0)[2])?C_i_check_number(((C_word*)t0)[2]):C_SCHEME_UNDEFINED);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4878,a[2]=t2,a[3]=((C_word)li81),tmp=(C_word)a,a+=4,tmp);
t5=f_4878(t4,C_fix(0),((C_word*)t0)[3]);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4836,a[2]=t2,a[3]=((C_word)li82),tmp=(C_word)a,a+=4,tmp);
t7=f_4836(t6,((C_word*)t0)[4],((C_word*)t0)[5]);
t8=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4823,a[2]=t2,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[3],tmp=(C_word)a,a+=10,tmp);
if(C_truep(((C_word*)t0)[2])){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4834,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:590: max */
t10=*((C_word*)lf[185]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t10;
av2[1]=t9;
av2[2]=C_fix(0);
av2[3]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t10+1)))(4,av2);}}
else{
t9=t8;
f_4823(t9,C_fix(-1));}}

/* process* in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8394(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,7))){
C_save_and_reclaim((void*)f_8394,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t8=C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_FALSE:C_i_car(t7));
if(C_truep(C_i_nullp(t7))){
/* posixunix.scm:1798: %process */
f_8275(t1,lf[430],C_SCHEME_TRUE,t2,t5,t9,*((C_word*)lf[431]+1));}
else{
t10=C_i_cdr(t7);
/* posixunix.scm:1798: %process */
f_8275(t1,lf[430],C_SCHEME_TRUE,t2,t5,t9,*((C_word*)lf[431]+1));}}

/* k3628 in g428 in k3616 in loop in k3597 in k3590 in a3587 in conc-loop in glob in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3630(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,2))){C_save_and_reclaim((void *)f_3630,2,av);}
a=C_alloc(4);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3634,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=C_i_cdr(((C_word*)t0)[3]);
/* posix-common.scm:510: loop */
t5=((C_word*)((C_word*)t0)[4])[1];
f_3601(t5,t3,t4);}

/* k3632 in k3628 in g428 in k3616 in loop in k3597 in k3590 in a3587 in conc-loop in glob in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3634(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,1))){C_save_and_reclaim((void *)f_3634,2,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k4583 in file-select in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_4585(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(9,0,2))){
C_save_and_reclaim_args((void *)trf_4585,2,t0,t1);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4588,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=((C_word*)t0)[3];
if(C_truep(t4)){
if(C_truep(C_fixnump(((C_word*)t0)[3]))){
t5=t3;
f_4588(t5,C_a_i_list1(&a,1,((C_word*)t0)[3]));}
else{
t5=C_i_check_list_2(((C_word*)t0)[3],lf[182]);
t6=((C_word*)t0)[3];
t7=t3;
f_4588(t7,t6);}}
else{
t5=t3;
f_4588(t5,C_SCHEME_END_OF_LIST);}}

/* k4586 in k4583 in file-select in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_4588(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(10,0,2))){
C_save_and_reclaim_args((void *)trf_4588,2,t0,t1);}
a=C_alloc(10);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4591,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t4=((C_word*)t0)[5];
if(C_truep(t4)){
if(C_truep(C_fixnump(((C_word*)t0)[5]))){
t5=t3;
f_4591(t5,C_a_i_list1(&a,1,((C_word*)t0)[5]));}
else{
t5=C_i_check_list_2(((C_word*)t0)[5],lf[182]);
t6=((C_word*)t0)[5];
t7=t3;
f_4591(t7,t6);}}
else{
t5=t3;
f_4591(t5,C_SCHEME_END_OF_LIST);}}

/* k3640 in g428 in k3616 in loop in k3597 in k3590 in a3587 in conc-loop in glob in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3642(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_3642,2,av);}
/* posix-common.scm:509: make-pathname */
t2=*((C_word*)lf[83]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k8338 in %process in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8340(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,2))){C_save_and_reclaim((void *)f_8340,2,av);}
a=C_alloc(4);
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8344,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1786: ##sys#shell-command */
t4=*((C_word*)lf[420]+1);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k3616 in loop in k3597 in k3590 in a3587 in conc-loop in glob in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3618(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,3))){C_save_and_reclaim((void *)f_3618,2,av);}
a=C_alloc(6);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3622,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word)li35),tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:501: g428 */
t3=t2;
f_3622(t3,((C_word*)t0)[5],t1);}
else{
t2=((C_word*)t0)[2];
t3=C_u_i_cdr(t2);
/* posix-common.scm:511: loop */
t4=((C_word*)((C_word*)t0)[3])[1];
f_3601(t4,((C_word*)t0)[5],t3);}}

/* k4485 in k4482 in k4479 in file-read in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4487(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,1))){C_save_and_reclaim((void *)f_4487,2,av);}
a=C_alloc(6);
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_a_i_list2(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k4482 in k4479 in file-read in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4484(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(11,c,6))){C_save_and_reclaim((void *)f_4484,2,av);}
a=C_alloc(11);
t2=C_read(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4487,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm:533: posix-error */
t5=lf[0];{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t5;
av2[1]=t3;
av2[2]=lf[8];
av2[3]=lf[174];
av2[4]=lf[175];
av2[5]=((C_word*)t0)[2];
av2[6]=((C_word*)t0)[4];
f_2696(7,av2);}}
else{
t5=((C_word*)t0)[5];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=C_a_i_list2(&a,2,((C_word*)t0)[3],t2);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k4479 in file-read in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4481(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,5))){C_save_and_reclaim((void *)f_4481,2,av);}
a=C_alloc(6);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4484,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_blockp(t2))){
if(C_truep(C_byteblockp(t2))){
t4=t3;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
f_4484(2,av2);}}
else{
/* posixunix.scm:530: ##sys#signal-hook */
t4=*((C_word*)lf[1]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[13];
av2[3]=lf[174];
av2[4]=lf[176];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(6,av2);}}}
else{
/* posixunix.scm:530: ##sys#signal-hook */
t4=*((C_word*)lf[1]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[13];
av2[3]=lf[174];
av2[4]=lf[176];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(6,av2);}}}

/* k8342 in k8338 in %process in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8344(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_8344,2,av);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,t1);
t3=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
f_8318(2,av2);}}

/* process in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8346(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +3,c,7))){
C_save_and_reclaim((void*)f_8346,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+3);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t8=C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_FALSE:C_i_car(t7));
t10=C_i_nullp(t7);
t11=(C_truep(t10)?C_SCHEME_END_OF_LIST:C_i_cdr(t7));
t12=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8364,a[2]=((C_word)li226),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1793: %process */
f_8275(t1,lf[429],C_SCHEME_FALSE,t2,t5,t9,t12);}

/* k5468 in k5464 in k5451 in user-information in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5470(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_5470,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5474,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-nonnull-c-string */
t4=*((C_word*)lf[246]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=C_mpointer(&a,(void*)C_PW_GECOS);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k5472 in k5468 in k5464 in k5451 in user-information in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5474(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(10,c,3))){C_save_and_reclaim((void *)f_5474,2,av);}
a=C_alloc(10);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5478,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,tmp=(C_word)a,a+=7,tmp);
/* ##sys#peek-c-string */
t4=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=C_mpointer(&a,(void*)C_user->pw_dir);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k5476 in k5472 in k5468 in k5464 in k5451 in user-information in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5478(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(11,c,3))){C_save_and_reclaim((void *)f_5478,2,av);}
a=C_alloc(11);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5482,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t2,tmp=(C_word)a,a+=8,tmp);
/* ##sys#peek-c-string */
t4=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=C_mpointer(&a,(void*)C_user->pw_shell);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* file-read in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4471(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +5,c,3))){
C_save_and_reclaim((void*)f_4471,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+5);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t5=C_i_check_exact_2(t2,lf[174]);
t6=C_i_check_exact_2(t3,lf[174]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4481,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(t4))){
t8=t4;
t9=t7;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t9;
av2[1]=C_u_i_car(t8);
f_4481(2,av2);}}
else{
t8=t3;
/* ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[72]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[72]+1);
av2[1]=t7;
av2[2]=t8;
av2[3]=C_make_character(32);
tp(4,av2);}}}

/* open-input-file* in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3082(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +5,c,4))){
C_save_and_reclaim((void*)f_3082,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+5);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
t4=C_i_check_exact_2(t2,lf[60]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3094,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:376: mode */
f_3030(t5,C_SCHEME_TRUE,t3,lf[60]);}

/* k3078 in check in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3080(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3080,2,av);}
t2=C_set_file_ptr(t1,((C_word*)t0)[2]);
t3=t1;
t4=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* open-output-file* in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3096(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +5,c,4))){
C_save_and_reclaim((void*)f_3096,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+5);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
t4=C_i_check_exact_2(t2,lf[61]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3108,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:380: mode */
f_3030(t5,C_SCHEME_FALSE,t3,lf[61]);}

/* k3092 in open-input-file* in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3094(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(2,c,5))){C_save_and_reclaim((void *)f_3094,2,av);}
a=C_alloc(2);
t2=C_fdopen(&a,2,((C_word*)t0)[2],t1);
/* posix-common.scm:376: check */
f_3067(((C_word*)t0)[4],lf[60],((C_word*)t0)[2],C_SCHEME_TRUE,t2);}

/* k5490 in user-information in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5492(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_5492,2,av);}
t2=((C_word*)t0)[2];
f_5453(t2,C_getpwnam(t1));}

/* check in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_3067(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(4,0,5))){
C_save_and_reclaim_args((void *)trf_3067,5,t1,t2,t3,t4,t5);}
a=C_alloc(4);
if(C_truep(C_null_pointerp(t5))){
/* posix-common.scm:369: posix-error */
t6=lf[0];{
C_word av2[6];
av2[0]=t6;
av2[1]=t1;
av2[2]=lf[8];
av2[3]=t2;
av2[4]=lf[56];
av2[5]=t3;
f_2696(6,av2);}}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3080,a[2]=t5,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:370: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[57]+1));
C_word av2[6];
av2[0]=*((C_word*)lf[57]+1);
av2[1]=t6;
av2[2]=t4;
av2[3]=*((C_word*)lf[58]+1);
av2[4]=lf[59];
av2[5]=lf[43];
tp(6,av2);}}}

/* k5464 in k5451 in user-information in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5466(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(8,c,3))){C_save_and_reclaim((void *)f_5466,2,av);}
a=C_alloc(8);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5470,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t4=*((C_word*)lf[246]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=C_mpointer(&a,(void*)C_user->pw_passwd);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k8319 in k8316 in %process in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8321(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(8,c,3))){C_save_and_reclaim((void *)f_8321,2,av);}
a=C_alloc(8);
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_8326,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word)li224),tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1788: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[7];
av2[2]=t2;
av2[3]=((C_word*)t0)[8];
C_call_with_values(4,av2);}}

/* k8464 in set-root-directory! in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8466(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_8466,2,av);}
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm:1810: posix-error */
t2=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[8];
av2[3]=lf[432];
av2[4]=lf[433];
av2[5]=((C_word*)t0)[3];
f_2696(6,av2);}}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k7605 in get-host-name in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7607(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,4))){C_save_and_reclaim((void *)f_7607,2,av);}
a=C_alloc(4);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7610,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t2)){
t4=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
/* posixunix.scm:1571: posix-error */
t4=lf[0];{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[403];
av2[3]=lf[407];
av2[4]=lf[408];
f_2696(5,av2);}}}

/* get-host-name in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7603(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(8,c,3))){C_save_and_reclaim((void *)f_7603,2,av);}
a=C_alloc(8);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7607,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=C_a_i_bytevector(&a,1,C_fix(3));
t4=stub1828(t3);
/* posixunix.scm:1565: ##sys#peek-c-string */
t5=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t2;
av2[2]=t4;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k8316 in %process in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8318(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,2))){C_save_and_reclaim((void *)f_8318,2,av);}
a=C_alloc(9);
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_8321,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
if(C_truep(((C_word*)t0)[5])){
/* posixunix.scm:1787: chkstrlst */
t3=((C_word*)t0)[9];
f_8277(t3,t2,((C_word*)t0)[5]);}
else{
t3=t2;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_8321(2,av2);}}}

/* k5480 in k5476 in k5472 in k5468 in k5464 in k5451 in user-information in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5482(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,8))){C_save_and_reclaim((void *)f_5482,2,av);}
/* posixunix.scm:902: g1182 */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 9) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(9);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
av2[4]=C_fix((C_word)C_user->pw_uid);
av2[5]=C_fix((C_word)C_user->pw_gid);
av2[6]=((C_word*)t0)[6];
av2[7]=((C_word*)t0)[7];
av2[8]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(9,av2);}}

/* a8325 in k8319 in k8316 in %process in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8326(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,8))){C_save_and_reclaim((void *)f_8326,2,av);}
/* posixunix.scm:1789: ##sys#process */
t2=*((C_word*)lf[428]+1);{
C_word *av2;
if(c >= 9) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(9);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
av2[3]=((C_word*)((C_word*)t0)[3])[1];
av2[4]=((C_word*)((C_word*)t0)[4])[1];
av2[5]=((C_word*)t0)[5];
av2[6]=C_SCHEME_TRUE;
av2[7]=C_SCHEME_TRUE;
av2[8]=((C_word*)t0)[6];
((C_proc)(void*)(*((C_word*)t2+1)))(9,av2);}}

/* k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3025(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word *a;
if(!C_demand(C_calculate_demand(53,c,6))){C_save_and_reclaim((void *)f_3025,2,av);}
a=C_alloc(53);
t2=C_mutate2((C_word*)lf[45]+1 /* (set! file-position ...) */,t1);
t3=C_mutate2((C_word*)lf[46]+1 /* (set! fileno/stdin ...) */,C_fix((C_word)STDIN_FILENO));
t4=C_mutate2((C_word*)lf[47]+1 /* (set! fileno/stdout ...) */,C_fix((C_word)STDOUT_FILENO));
t5=C_mutate2((C_word*)lf[48]+1 /* (set! fileno/stderr ...) */,C_fix((C_word)STDERR_FILENO));
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_SCHEME_UNDEFINED;
t9=(*a=C_VECTOR_TYPE|1,a[1]=t8,tmp=(C_word)a,a+=2,tmp);
t10=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3030,a[2]=((C_word)li17),tmp=(C_word)a,a+=3,tmp));
t11=C_set_block_item(t9,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3067,a[2]=((C_word)li18),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate2((C_word*)lf[60]+1 /* (set! open-input-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3082,a[2]=t9,a[3]=t7,a[4]=((C_word)li19),tmp=(C_word)a,a+=5,tmp));
t13=C_mutate2((C_word*)lf[61]+1 /* (set! open-output-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3096,a[2]=t9,a[3]=t7,a[4]=((C_word)li20),tmp=(C_word)a,a+=5,tmp));
t14=C_mutate2((C_word*)lf[10]+1 /* (set! port->fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3110,a[2]=((C_word)li21),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate2((C_word*)lf[66]+1 /* (set! duplicate-fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3158,a[2]=((C_word)li22),tmp=(C_word)a,a+=3,tmp));
t16=C_mutate2((C_word*)lf[68]+1 /* (set! current-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3185,a[2]=((C_word)li23),tmp=(C_word)a,a+=3,tmp));
t17=C_mutate2((C_word*)lf[73]+1 /* (set! delete-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3219,a[2]=((C_word)li27),tmp=(C_word)a,a+=3,tmp));
t18=C_mutate2((C_word*)lf[79]+1 /* (set! create-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3305,a[2]=((C_word)li31),tmp=(C_word)a,a+=3,tmp));
t19=C_mutate2((C_word*)lf[26]+1 /* (set! directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3422,a[2]=((C_word)li33),tmp=(C_word)a,a+=3,tmp));
t20=C_mutate2((C_word*)lf[87]+1 /* (set! glob ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3561,a[2]=((C_word)li39),tmp=(C_word)a,a+=3,tmp));
t21=C_mutate2((C_word*)lf[76]+1 /* (set! find-files ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3847,a[2]=((C_word)li55),tmp=(C_word)a,a+=3,tmp));
t22=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3898,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t23=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8631,a[2]=((C_word)li243),tmp=(C_word)a,a+=3,tmp);
t24=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8656,a[2]=((C_word)li244),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:563: getter-with-setter */
t25=*((C_word*)lf[437]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t25;
av2[1]=t22;
av2[2]=t23;
av2[3]=t24;
av2[4]=lf[450];
((C_proc)(void*)(*((C_word*)t25+1)))(5,av2);}}

/* k6958 in setup in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_6960(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(5,0,1))){
C_save_and_reclaim_args((void *)trf_6960,2,t0,t1);}
a=C_alloc(5);
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=(C_truep(t2)?C_fix((C_word)F_RDLCK):C_fix((C_word)F_WRLCK));
t4=C_flock_setup(t3,((C_word*)t0)[3],((C_word*)((C_word*)t0)[4])[1]);
t5=((C_word*)t0)[5];{
C_word av2[2];
av2[0]=t5;
av2[1]=C_a_i_record4(&a,4,lf[352],((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)((C_word*)t0)[4])[1]);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* mode in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_3030(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(!C_demand(C_calculate_demand(4,0,3))){
C_save_and_reclaim_args((void *)trf_3030,4,t1,t2,t3,t4);}
a=C_alloc(4);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3038,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t6=t3;
t7=C_u_i_car(t6);
t8=C_eqp(t7,lf[49]);
if(C_truep(t8)){
t9=t2;
if(C_truep(t9)){
/* posix-common.scm:362: ##sys#error */
t10=*((C_word*)lf[50]+1);{
C_word av2[4];
av2[0]=t10;
av2[1]=t5;
av2[2]=lf[51];
av2[3]=t7;
((C_proc)(void*)(*((C_word*)t10+1)))(4,av2);}}
else{
/* posix-common.scm:358: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t1;
av2[2]=lf[52];
av2[3]=t4;
tp(4,av2);}}}
else{
/* posix-common.scm:363: ##sys#error */
t9=*((C_word*)lf[50]+1);{
C_word av2[4];
av2[0]=t9;
av2[1]=t5;
av2[2]=lf[53];
av2[3]=t7;
((C_proc)(void*)(*((C_word*)t9+1)))(4,av2);}}}
else{
if(C_truep(t2)){
/* posix-common.scm:358: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t1;
av2[2]=lf[54];
av2[3]=t4;
tp(4,av2);}}
else{
/* posix-common.scm:358: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t1;
av2[2]=lf[55];
av2[3]=t4;
tp(4,av2);}}}}

/* k3036 in mode in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3038(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_3038,2,av);}
/* posix-common.scm:358: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=((C_word*)t0)[3];
tp(4,av2);}}

/* a8489 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8490(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand(5,c,2))){C_save_and_reclaim((void *)f_8490,4,av);}
a=C_alloc(5);
t4=C_i_check_exact_2(t2,lf[435]);
t5=C_i_check_exact_2(t3,lf[435]);
t6=C_setpgid(t2,t3);
if(C_truep(C_fixnum_lessp(t6,C_fix(0)))){
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8506,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1092: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[5]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[5]+1);
av2[1]=t7;
tp(2,av2);}}
else{
t7=C_SCHEME_UNDEFINED;
t8=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}

/* toplevel */
static C_TLS int toplevel_initialized=0;

void C_ccall C_posix_toplevel(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(toplevel_initialized) {C_kontinue(t1,C_SCHEME_UNDEFINED);}
else C_toplevel_entry(C_text("posix_toplevel"));
C_check_nursery_minimum(C_calculate_demand(3,c,2));
if(!C_demand(C_calculate_demand(3,c,2))){
C_save_and_reclaim((void*)C_posix_toplevel,c,av);}
toplevel_initialized=1;
if(!C_demand_2(2356)){
C_save(t1);
C_rereclaim2(2356*sizeof(C_word),1);
t1=C_restore;}
a=C_alloc(3);
C_initialize_lf(lf,457);
lf[1]=C_h_intern(&lf[1],15,"\003syssignal-hook");
lf[2]=C_h_intern(&lf[2],13,"string-append");
lf[3]=C_decode_literal(C_heaptop,"\376B\000\000\003 - ");
lf[4]=C_h_intern(&lf[4],17,"\003syspeek-c-string");
lf[5]=C_h_intern(&lf[5],16,"\003sysupdate-errno");
lf[6]=C_h_intern(&lf[6],15,"\003sysposix-error");
lf[8]=C_h_intern(&lf[8],11,"\000file-error");
lf[9]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot access file");
lf[10]=C_h_intern(&lf[10],12,"port->fileno");
lf[11]=C_h_intern(&lf[11],17,"\003sysmake-c-string");
lf[12]=C_h_intern(&lf[12],27,"\003sysplatform-fixup-pathname");
lf[13]=C_h_intern(&lf[13],11,"\000type-error");
lf[14]=C_decode_literal(C_heaptop,"\376B\000\000\052bad argument type - not a fixnum or string");
lf[15]=C_h_intern(&lf[15],5,"port\077");
lf[16]=C_h_intern(&lf[16],9,"file-stat");
lf[17]=C_h_intern(&lf[17],22,"file-modification-time");
lf[18]=C_h_intern(&lf[18],16,"file-access-time");
lf[19]=C_h_intern(&lf[19],16,"file-change-time");
lf[20]=C_h_intern(&lf[20],10,"file-owner");
lf[21]=C_h_intern(&lf[21],16,"file-permissions");
lf[22]=C_h_intern(&lf[22],9,"file-size");
lf[23]=C_h_intern(&lf[23],9,"file-type");
lf[24]=C_h_intern(&lf[24],12,"regular-file");
lf[25]=C_h_intern(&lf[25],13,"symbolic-link");
lf[26]=C_h_intern(&lf[26],9,"directory");
lf[27]=C_h_intern(&lf[27],16,"character-device");
lf[28]=C_h_intern(&lf[28],12,"block-device");
lf[29]=C_h_intern(&lf[29],4,"fifo");
lf[30]=C_h_intern(&lf[30],6,"socket");
lf[31]=C_h_intern(&lf[31],13,"regular-file\077");
lf[32]=C_h_intern(&lf[32],14,"symbolic-link\077");
lf[33]=C_h_intern(&lf[33],13,"block-device\077");
lf[34]=C_h_intern(&lf[34],17,"character-device\077");
lf[35]=C_h_intern(&lf[35],5,"fifo\077");
lf[36]=C_h_intern(&lf[36],7,"socket\077");
lf[37]=C_h_intern(&lf[37],10,"directory\077");
lf[38]=C_h_intern(&lf[38],8,"seek/set");
lf[39]=C_h_intern(&lf[39],8,"seek/end");
lf[40]=C_h_intern(&lf[40],8,"seek/cur");
lf[41]=C_h_intern(&lf[41],18,"set-file-position!");
lf[42]=C_decode_literal(C_heaptop,"\376B\000\000\030cannot set file position");
lf[43]=C_h_intern(&lf[43],6,"stream");
lf[44]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[45]=C_h_intern(&lf[45],13,"file-position");
lf[46]=C_h_intern(&lf[46],12,"fileno/stdin");
lf[47]=C_h_intern(&lf[47],13,"fileno/stdout");
lf[48]=C_h_intern(&lf[48],13,"fileno/stderr");
lf[49]=C_h_intern(&lf[49],7,"\000append");
lf[50]=C_h_intern(&lf[50],9,"\003syserror");
lf[51]=C_decode_literal(C_heaptop,"\376B\000\000\033invalid mode for input file");
lf[52]=C_decode_literal(C_heaptop,"\376B\000\000\001a");
lf[53]=C_decode_literal(C_heaptop,"\376B\000\000\025invalid mode argument");
lf[54]=C_decode_literal(C_heaptop,"\376B\000\000\001r");
lf[55]=C_decode_literal(C_heaptop,"\376B\000\000\001w");
lf[56]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[57]=C_h_intern(&lf[57],13,"\003sysmake-port");
lf[58]=C_h_intern(&lf[58],21,"\003sysstream-port-class");
lf[59]=C_decode_literal(C_heaptop,"\376B\000\000\010(fdport)");
lf[60]=C_h_intern(&lf[60],16,"open-input-file\052");
lf[61]=C_h_intern(&lf[61],17,"open-output-file\052");
lf[62]=C_h_intern(&lf[62],13,"\003sysport-data");
lf[63]=C_decode_literal(C_heaptop,"\376B\000\000\031port has no attached file");
lf[64]=C_decode_literal(C_heaptop,"\376B\000\000%cannot access file-descriptor of port");
lf[65]=C_h_intern(&lf[65],25,"\003syspeek-unsigned-integer");
lf[66]=C_h_intern(&lf[66],16,"duplicate-fileno");
lf[67]=C_decode_literal(C_heaptop,"\376B\000\000 cannot duplicate file-descriptor");
lf[68]=C_h_intern(&lf[68],17,"current-directory");
lf[69]=C_h_intern(&lf[69],16,"change-directory");
lf[70]=C_h_intern(&lf[70],13,"\003syssubstring");
lf[71]=C_decode_literal(C_heaptop,"\376B\000\000!cannot retrieve current directory");
lf[72]=C_h_intern(&lf[72],15,"\003sysmake-string");
lf[73]=C_h_intern(&lf[73],16,"delete-directory");
lf[74]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot delete directory");
lf[75]=C_h_intern(&lf[75],11,"delete-file");
lf[76]=C_h_intern(&lf[76],10,"find-files");
lf[77]=C_h_intern(&lf[77],9,"\000dotfiles");
lf[78]=C_h_intern(&lf[78],16,"\000follow-symlinks");
lf[79]=C_h_intern(&lf[79],16,"create-directory");
lf[80]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot create directory");
lf[81]=C_h_intern(&lf[81],18,"pathname-directory");
lf[82]=C_h_intern(&lf[82],18,"decompose-pathname");
lf[83]=C_h_intern(&lf[83],13,"make-pathname");
lf[84]=C_h_intern(&lf[84],12,"file-exists\077");
lf[85]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot open directory");
lf[86]=C_h_intern(&lf[86],16,"\003sysmake-pointer");
lf[87]=C_h_intern(&lf[87],4,"glob");
lf[88]=C_h_intern(&lf[88],23,"irregex-match-substring");
lf[89]=C_h_intern(&lf[89],13,"irregex-match");
lf[90]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[91]=C_h_intern(&lf[91],16,"\003sysglob->regexp");
lf[92]=C_decode_literal(C_heaptop,"\376B\000\000\001\052");
lf[93]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[94]=C_decode_literal(C_heaptop,"\376B\000\000\002..");
lf[95]=C_h_intern(&lf[95],16,"\003sysdynamic-wind");
lf[96]=C_h_intern(&lf[96],7,"irregex");
lf[97]=C_h_intern(&lf[97],15,"\003sysget-keyword");
lf[98]=C_h_intern(&lf[98],6,"\000limit");
lf[99]=C_h_intern(&lf[99],5,"\000seed");
lf[100]=C_h_intern(&lf[100],7,"\000action");
lf[101]=C_h_intern(&lf[101],5,"\000test");
lf[102]=C_h_intern(&lf[102],18,"file-creation-mode");
lf[104]=C_decode_literal(C_heaptop,"\376B\000\000\025time vector too short");
lf[105]=C_h_intern(&lf[105],19,"seconds->local-time");
lf[106]=C_h_intern(&lf[106],18,"\003sysdecode-seconds");
lf[107]=C_h_intern(&lf[107],15,"current-seconds");
lf[108]=C_h_intern(&lf[108],17,"seconds->utc-time");
lf[109]=C_h_intern(&lf[109],15,"seconds->string");
lf[110]=C_decode_literal(C_heaptop,"\376B\000\000 cannot convert seconds to string");
lf[111]=C_h_intern(&lf[111],19,"local-time->seconds");
lf[112]=C_decode_literal(C_heaptop,"\376B\000\000%cannot convert time vector to seconds");
lf[113]=C_h_intern(&lf[113],3,"fp=");
lf[114]=C_decode_literal(C_heaptop,"\376U-1.0\000");
lf[115]=C_h_intern(&lf[115],12,"time->string");
lf[116]=C_decode_literal(C_heaptop,"\376B\000\000 time formatting overflows buffer");
lf[117]=C_decode_literal(C_heaptop,"\376B\000\000$cannot convert time vector to string");
lf[118]=C_h_intern(&lf[118],6,"setenv");
lf[119]=C_h_intern(&lf[119],8,"unsetenv");
lf[120]=C_h_intern(&lf[120],25,"get-environment-variables");
lf[121]=C_h_intern(&lf[121],19,"set-signal-handler!");
lf[122]=C_h_intern(&lf[122],17,"\003syssignal-vector");
lf[123]=C_h_intern(&lf[123],14,"signal-handler");
lf[124]=C_h_intern(&lf[124],18,"current-process-id");
lf[125]=C_h_intern(&lf[125],12,"process-wait");
lf[126]=C_h_intern(&lf[126],16,"\003sysprocess-wait");
lf[127]=C_h_intern(&lf[127],14,"\000process-error");
lf[128]=C_decode_literal(C_heaptop,"\376B\000\000 waiting for child process failed");
lf[129]=C_h_intern(&lf[129],21,"\003sysfile-nonblocking!");
lf[130]=C_h_intern(&lf[130],19,"\003sysfile-select-one");
lf[131]=C_h_intern(&lf[131],8,"pipe/buf");
lf[132]=C_h_intern(&lf[132],11,"fcntl/dupfd");
lf[133]=C_h_intern(&lf[133],11,"fcntl/getfd");
lf[134]=C_h_intern(&lf[134],11,"fcntl/setfd");
lf[135]=C_h_intern(&lf[135],11,"fcntl/getfl");
lf[136]=C_h_intern(&lf[136],11,"fcntl/setfl");
lf[137]=C_h_intern(&lf[137],11,"open/rdonly");
lf[138]=C_h_intern(&lf[138],11,"open/wronly");
lf[139]=C_h_intern(&lf[139],9,"open/rdwr");
lf[140]=C_h_intern(&lf[140],9,"open/read");
lf[141]=C_h_intern(&lf[141],10,"open/write");
lf[142]=C_h_intern(&lf[142],10,"open/creat");
lf[143]=C_h_intern(&lf[143],11,"open/append");
lf[144]=C_h_intern(&lf[144],9,"open/excl");
lf[145]=C_h_intern(&lf[145],11,"open/noctty");
lf[146]=C_h_intern(&lf[146],13,"open/nonblock");
lf[147]=C_h_intern(&lf[147],10,"open/trunc");
lf[148]=C_h_intern(&lf[148],9,"open/sync");
lf[149]=C_h_intern(&lf[149],10,"open/fsync");
lf[150]=C_h_intern(&lf[150],11,"open/binary");
lf[151]=C_h_intern(&lf[151],9,"open/text");
lf[152]=C_h_intern(&lf[152],10,"perm/irusr");
lf[153]=C_h_intern(&lf[153],10,"perm/iwusr");
lf[154]=C_h_intern(&lf[154],10,"perm/ixusr");
lf[155]=C_h_intern(&lf[155],10,"perm/irgrp");
lf[156]=C_h_intern(&lf[156],10,"perm/iwgrp");
lf[157]=C_h_intern(&lf[157],10,"perm/ixgrp");
lf[158]=C_h_intern(&lf[158],10,"perm/iroth");
lf[159]=C_h_intern(&lf[159],10,"perm/iwoth");
lf[160]=C_h_intern(&lf[160],10,"perm/ixoth");
lf[161]=C_h_intern(&lf[161],10,"perm/irwxu");
lf[162]=C_h_intern(&lf[162],10,"perm/irwxg");
lf[163]=C_h_intern(&lf[163],10,"perm/irwxo");
lf[164]=C_h_intern(&lf[164],10,"perm/isvtx");
lf[165]=C_h_intern(&lf[165],10,"perm/isuid");
lf[166]=C_h_intern(&lf[166],10,"perm/isgid");
lf[167]=C_h_intern(&lf[167],12,"file-control");
lf[168]=C_decode_literal(C_heaptop,"\376B\000\000\023cannot control file");
lf[169]=C_h_intern(&lf[169],9,"file-open");
lf[170]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[171]=C_h_intern(&lf[171],10,"file-close");
lf[172]=C_h_intern(&lf[172],22,"\003sysdispatch-interrupt");
lf[173]=C_decode_literal(C_heaptop,"\376B\000\000\021cannot close file");
lf[174]=C_h_intern(&lf[174],9,"file-read");
lf[175]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot read from file");
lf[176]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[177]=C_h_intern(&lf[177],10,"file-write");
lf[178]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot write to file");
lf[179]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[180]=C_h_intern(&lf[180],12,"file-mkstemp");
lf[181]=C_decode_literal(C_heaptop,"\376B\000\000\034cannot create temporary file");
lf[182]=C_h_intern(&lf[182],11,"file-select");
lf[183]=C_decode_literal(C_heaptop,"\376B\000\000\006failed");
lf[184]=C_h_intern(&lf[184],16,"\003sysfast-reverse");
lf[185]=C_h_intern(&lf[185],3,"max");
lf[186]=C_h_intern(&lf[186],13,"\003sysmake-blob");
lf[187]=C_decode_literal(C_heaptop,"\376B\000\000\037cannot change current directory");
lf[188]=C_h_intern(&lf[188],17,"change-directory\052");
lf[189]=C_decode_literal(C_heaptop,"\376B\000\000\037cannot change current directory");
lf[190]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open pipe");
lf[191]=C_decode_literal(C_heaptop,"\376B\000\000\006(pipe)");
lf[192]=C_h_intern(&lf[192],15,"open-input-pipe");
lf[193]=C_h_intern(&lf[193],5,"\000text");
lf[194]=C_h_intern(&lf[194],7,"\000binary");
lf[195]=C_decode_literal(C_heaptop,"\376B\000\000#illegal input/output mode specifier");
lf[196]=C_h_intern(&lf[196],16,"open-output-pipe");
lf[197]=C_h_intern(&lf[197],16,"close-input-pipe");
lf[198]=C_decode_literal(C_heaptop,"\376B\000\000\030error while closing pipe");
lf[199]=C_h_intern(&lf[199],17,"close-output-pipe");
lf[200]=C_decode_literal(C_heaptop,"\376B\000\000\030error while closing pipe");
lf[201]=C_h_intern(&lf[201],20,"call-with-input-pipe");
lf[202]=C_h_intern(&lf[202],21,"call-with-output-pipe");
lf[203]=C_h_intern(&lf[203],20,"with-input-from-pipe");
lf[204]=C_h_intern(&lf[204],18,"\003sysstandard-input");
lf[205]=C_h_intern(&lf[205],19,"with-output-to-pipe");
lf[206]=C_h_intern(&lf[206],19,"\003sysstandard-output");
lf[207]=C_h_intern(&lf[207],11,"create-pipe");
lf[208]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot create pipe");
lf[209]=C_h_intern(&lf[209],11,"signal/term");
lf[210]=C_h_intern(&lf[210],11,"signal/kill");
lf[211]=C_h_intern(&lf[211],10,"signal/int");
lf[212]=C_h_intern(&lf[212],10,"signal/hup");
lf[213]=C_h_intern(&lf[213],10,"signal/fpe");
lf[214]=C_h_intern(&lf[214],10,"signal/ill");
lf[215]=C_h_intern(&lf[215],11,"signal/segv");
lf[216]=C_h_intern(&lf[216],11,"signal/abrt");
lf[217]=C_h_intern(&lf[217],11,"signal/trap");
lf[218]=C_h_intern(&lf[218],11,"signal/quit");
lf[219]=C_h_intern(&lf[219],11,"signal/alrm");
lf[220]=C_h_intern(&lf[220],13,"signal/vtalrm");
lf[221]=C_h_intern(&lf[221],11,"signal/prof");
lf[222]=C_h_intern(&lf[222],9,"signal/io");
lf[223]=C_h_intern(&lf[223],10,"signal/urg");
lf[224]=C_h_intern(&lf[224],11,"signal/chld");
lf[225]=C_h_intern(&lf[225],11,"signal/cont");
lf[226]=C_h_intern(&lf[226],11,"signal/stop");
lf[227]=C_h_intern(&lf[227],11,"signal/tstp");
lf[228]=C_h_intern(&lf[228],11,"signal/pipe");
lf[229]=C_h_intern(&lf[229],11,"signal/xcpu");
lf[230]=C_h_intern(&lf[230],11,"signal/xfsz");
lf[231]=C_h_intern(&lf[231],11,"signal/usr1");
lf[232]=C_h_intern(&lf[232],11,"signal/usr2");
lf[233]=C_h_intern(&lf[233],12,"signal/winch");
lf[234]=C_h_intern(&lf[234],10,"signal/bus");
lf[235]=C_h_intern(&lf[235],12,"signal/break");
lf[236]=C_h_intern(&lf[236],12,"signals-list");
lf[237]=C_h_intern(&lf[237],16,"set-signal-mask!");
lf[238]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot set signal mask");
lf[239]=C_h_intern(&lf[239],11,"signal-mask");
lf[240]=C_h_intern(&lf[240],14,"signal-masked\077");
lf[241]=C_h_intern(&lf[241],12,"signal-mask!");
lf[242]=C_decode_literal(C_heaptop,"\376B\000\000\023cannot block signal");
lf[243]=C_h_intern(&lf[243],14,"signal-unmask!");
lf[244]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot unblock signal");
lf[245]=C_h_intern(&lf[245],18,"system-information");
lf[246]=C_h_intern(&lf[246],25,"\003syspeek-nonnull-c-string");
lf[247]=C_decode_literal(C_heaptop,"\376B\000\000\042cannot retrieve system information");
lf[248]=C_h_intern(&lf[248],15,"current-user-id");
lf[249]=C_h_intern(&lf[249],25,"current-effective-user-id");
lf[250]=C_h_intern(&lf[250],16,"current-group-id");
lf[251]=C_h_intern(&lf[251],26,"current-effective-group-id");
lf[252]=C_h_intern(&lf[252],16,"user-information");
lf[253]=C_h_intern(&lf[253],6,"vector");
lf[254]=C_h_intern(&lf[254],4,"list");
lf[255]=C_h_intern(&lf[255],17,"current-user-name");
lf[256]=C_h_intern(&lf[256],27,"current-effective-user-name");
lf[257]=C_h_intern(&lf[257],17,"group-information");
lf[258]=C_h_intern(&lf[258],10,"get-groups");
lf[259]=C_decode_literal(C_heaptop,"\376B\000\000\047cannot retrieve supplementary group ids");
lf[260]=C_decode_literal(C_heaptop,"\376B\000\000\015out of memory");
lf[261]=C_decode_literal(C_heaptop,"\376B\000\000\047cannot retrieve supplementary group ids");
lf[262]=C_h_intern(&lf[262],11,"set-groups!");
lf[263]=C_decode_literal(C_heaptop,"\376B\000\000\042cannot set supplementary group ids");
lf[264]=C_decode_literal(C_heaptop,"\376B\000\000\015out of memory");
lf[265]=C_h_intern(&lf[265],17,"initialize-groups");
lf[266]=C_decode_literal(C_heaptop,"\376B\000\000)cannot initialize supplementary group ids");
lf[267]=C_h_intern(&lf[267],10,"errno/perm");
lf[268]=C_h_intern(&lf[268],11,"errno/noent");
lf[269]=C_h_intern(&lf[269],10,"errno/srch");
lf[270]=C_h_intern(&lf[270],10,"errno/intr");
lf[271]=C_h_intern(&lf[271],8,"errno/io");
lf[272]=C_h_intern(&lf[272],12,"errno/noexec");
lf[273]=C_h_intern(&lf[273],10,"errno/badf");
lf[274]=C_h_intern(&lf[274],11,"errno/child");
lf[275]=C_h_intern(&lf[275],11,"errno/nomem");
lf[276]=C_h_intern(&lf[276],11,"errno/acces");
lf[277]=C_h_intern(&lf[277],11,"errno/fault");
lf[278]=C_h_intern(&lf[278],10,"errno/busy");
lf[279]=C_h_intern(&lf[279],12,"errno/notdir");
lf[280]=C_h_intern(&lf[280],11,"errno/isdir");
lf[281]=C_h_intern(&lf[281],11,"errno/inval");
lf[282]=C_h_intern(&lf[282],11,"errno/mfile");
lf[283]=C_h_intern(&lf[283],11,"errno/nospc");
lf[284]=C_h_intern(&lf[284],11,"errno/spipe");
lf[285]=C_h_intern(&lf[285],10,"errno/pipe");
lf[286]=C_h_intern(&lf[286],11,"errno/again");
lf[287]=C_h_intern(&lf[287],10,"errno/rofs");
lf[288]=C_h_intern(&lf[288],11,"errno/exist");
lf[289]=C_h_intern(&lf[289],16,"errno/wouldblock");
lf[290]=C_h_intern(&lf[290],10,"errno/2big");
lf[291]=C_h_intern(&lf[291],12,"errno/deadlk");
lf[292]=C_h_intern(&lf[292],9,"errno/dom");
lf[293]=C_h_intern(&lf[293],10,"errno/fbig");
lf[294]=C_h_intern(&lf[294],11,"errno/ilseq");
lf[295]=C_h_intern(&lf[295],11,"errno/mlink");
lf[296]=C_h_intern(&lf[296],17,"errno/nametoolong");
lf[297]=C_h_intern(&lf[297],11,"errno/nfile");
lf[298]=C_h_intern(&lf[298],11,"errno/nodev");
lf[299]=C_h_intern(&lf[299],11,"errno/nolck");
lf[300]=C_h_intern(&lf[300],11,"errno/nosys");
lf[301]=C_h_intern(&lf[301],14,"errno/notempty");
lf[302]=C_h_intern(&lf[302],11,"errno/notty");
lf[303]=C_h_intern(&lf[303],10,"errno/nxio");
lf[304]=C_h_intern(&lf[304],11,"errno/range");
lf[305]=C_h_intern(&lf[305],10,"errno/xdev");
lf[306]=C_h_intern(&lf[306],16,"change-file-mode");
lf[307]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot change file mode");
lf[308]=C_h_intern(&lf[308],17,"change-file-owner");
lf[309]=C_decode_literal(C_heaptop,"\376B\000\000\030cannot change file owner");
lf[310]=C_h_intern(&lf[310],17,"file-read-access\077");
lf[311]=C_h_intern(&lf[311],18,"file-write-access\077");
lf[312]=C_h_intern(&lf[312],20,"file-execute-access\077");
lf[313]=C_h_intern(&lf[313],14,"create-session");
lf[314]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot create session");
lf[315]=C_h_intern(&lf[315],16,"process-group-id");
lf[316]=C_h_intern(&lf[316],20,"create-symbolic-link");
lf[317]=C_h_intern(&lf[317],18,"create-symbol-link");
lf[318]=C_decode_literal(C_heaptop,"\376B\000\000\033cannot create symbolic link");
lf[319]=C_h_intern(&lf[319],22,"\003sysread-symbolic-link");
lf[320]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot read symbolic link");
lf[321]=C_h_intern(&lf[321],9,"substring");
lf[322]=C_h_intern(&lf[322],18,"read-symbolic-link");
lf[323]=C_h_intern(&lf[323],19,"decompose-directory");
lf[324]=C_h_intern(&lf[324],18,"absolute-pathname\077");
lf[325]=C_decode_literal(C_heaptop,"\376B\000\000Icould not canonicalize path with symbolic links, component does not exist");
lf[326]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[327]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[328]=C_h_intern(&lf[328],9,"file-link");
lf[329]=C_h_intern(&lf[329],9,"hard-link");
lf[330]=C_decode_literal(C_heaptop,"\376B\000\000\032could not create hard link");
lf[331]=C_h_intern(&lf[331],21,"\003syscustom-input-port");
lf[332]=C_h_intern(&lf[332],4,"void");
lf[333]=C_decode_literal(C_heaptop,"\376B\000\000\015cannot select");
lf[334]=C_h_intern(&lf[334],17,"\003systhread-yield!");
lf[335]=C_h_intern(&lf[335],25,"\003systhread-block-for-i/o!");
lf[336]=C_h_intern(&lf[336],18,"\003syscurrent-thread");
lf[337]=C_h_intern(&lf[337],6,"\000input");
lf[338]=C_decode_literal(C_heaptop,"\376B\000\000\013cannot read");
lf[339]=C_decode_literal(C_heaptop,"\376B\000\000\013cannot read");
lf[340]=C_h_intern(&lf[340],14,"set-port-name!");
lf[341]=C_decode_literal(C_heaptop,"\376B\000\000\014cannot close");
lf[342]=C_h_intern(&lf[342],20,"\003sysscan-buffer-line");
lf[343]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[344]=C_h_intern(&lf[344],15,"make-input-port");
lf[345]=C_h_intern(&lf[345],22,"\003syscustom-output-port");
lf[346]=C_decode_literal(C_heaptop,"\376B\000\000\014cannot write");
lf[347]=C_decode_literal(C_heaptop,"\376B\000\000\014cannot close");
lf[348]=C_h_intern(&lf[348],16,"make-output-port");
lf[349]=C_h_intern(&lf[349],13,"file-truncate");
lf[350]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot truncate file");
lf[351]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[352]=C_h_intern(&lf[352],4,"lock");
lf[353]=C_h_intern(&lf[353],9,"file-lock");
lf[354]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot lock file");
lf[355]=C_h_intern(&lf[355],18,"file-lock/blocking");
lf[356]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot lock file");
lf[357]=C_h_intern(&lf[357],14,"file-test-lock");
lf[358]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot unlock file");
lf[359]=C_h_intern(&lf[359],11,"file-unlock");
lf[360]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot unlock file");
lf[361]=C_h_intern(&lf[361],11,"create-fifo");
lf[362]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot create FIFO");
lf[363]=C_decode_literal(C_heaptop,"\376B\000\000\023file does not exist");
lf[364]=C_decode_literal(C_heaptop,"\376B\000\000(system error while trying to access file");
lf[365]=C_h_intern(&lf[365],9,"prot/read");
lf[366]=C_h_intern(&lf[366],10,"prot/write");
lf[367]=C_h_intern(&lf[367],9,"prot/exec");
lf[368]=C_h_intern(&lf[368],9,"prot/none");
lf[369]=C_h_intern(&lf[369],9,"map/fixed");
lf[370]=C_h_intern(&lf[370],10,"map/shared");
lf[371]=C_h_intern(&lf[371],11,"map/private");
lf[372]=C_h_intern(&lf[372],13,"map/anonymous");
lf[373]=C_h_intern(&lf[373],8,"map/file");
lf[374]=C_h_intern(&lf[374],18,"map-file-to-memory");
lf[375]=C_h_intern(&lf[375],4,"mmap");
lf[376]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot map file to memory");
lf[377]=C_h_intern(&lf[377],20,"\003syspointer->address");
lf[378]=C_decode_literal(C_heaptop,"\376B\000\000)bad argument type - not a foreign pointer");
lf[379]=C_h_intern(&lf[379],16,"\003sysnull-pointer");
lf[380]=C_h_intern(&lf[380],22,"unmap-file-from-memory");
lf[381]=C_decode_literal(C_heaptop,"\376B\000\000\035cannot unmap file from memory");
lf[382]=C_h_intern(&lf[382],26,"memory-mapped-file-pointer");
lf[383]=C_h_intern(&lf[383],19,"memory-mapped-file\077");
lf[384]=C_h_intern(&lf[384],12,"string->time");
lf[385]=C_decode_literal(C_heaptop,"\376B\000\000\027%a %b %e %H:%M:%S %Z %Y");
lf[386]=C_h_intern(&lf[386],17,"utc-time->seconds");
lf[387]=C_decode_literal(C_heaptop,"\376B\000\000%cannot convert time vector to seconds");
lf[388]=C_h_intern(&lf[388],27,"local-timezone-abbreviation");
lf[389]=C_h_intern(&lf[389],5,"_exit");
lf[390]=C_h_intern(&lf[390],10,"set-alarm!");
lf[391]=C_h_intern(&lf[391],19,"set-buffering-mode!");
lf[392]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot set buffering mode");
lf[393]=C_h_intern(&lf[393],5,"\000full");
lf[394]=C_h_intern(&lf[394],5,"\000line");
lf[395]=C_h_intern(&lf[395],5,"\000none");
lf[396]=C_decode_literal(C_heaptop,"\376B\000\000\026invalid buffering-mode");
lf[397]=C_h_intern(&lf[397],14,"\003syscheck-port");
lf[398]=C_h_intern(&lf[398],14,"terminal-port\077");
lf[400]=C_decode_literal(C_heaptop,"\376B\000\000#port is not connected to a terminal");
lf[401]=C_h_intern(&lf[401],13,"terminal-name");
lf[402]=C_h_intern(&lf[402],13,"terminal-size");
lf[403]=C_h_intern(&lf[403],6,"\000error");
lf[404]=C_decode_literal(C_heaptop,"\376B\000\000\036Unable to get size of terminal");
lf[405]=C_h_intern(&lf[405],17,"\003sysmake-locative");
lf[406]=C_h_intern(&lf[406],8,"location");
lf[407]=C_h_intern(&lf[407],13,"get-host-name");
lf[408]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot retrieve host-name");
lf[409]=C_h_intern(&lf[409],12,"process-fork");
lf[410]=C_h_intern(&lf[410],22,"\003syskill-other-threads");
lf[411]=C_h_intern(&lf[411],4,"exit");
lf[412]=C_decode_literal(C_heaptop,"\376B\000\000\033cannot create child process");
lf[413]=C_h_intern(&lf[413],24,"pathname-strip-directory");
lf[414]=C_h_intern(&lf[414],15,"process-execute");
lf[415]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot execute process");
lf[416]=C_h_intern(&lf[416],17,"parent-process-id");
lf[417]=C_h_intern(&lf[417],5,"sleep");
lf[418]=C_h_intern(&lf[418],14,"process-signal");
lf[419]=C_decode_literal(C_heaptop,"\376B\000\000 could not send signal to process");
lf[420]=C_h_intern(&lf[420],17,"\003sysshell-command");
lf[421]=C_decode_literal(C_heaptop,"\376B\000\000\007/bin/sh");
lf[422]=C_h_intern(&lf[422],24,"get-environment-variable");
lf[423]=C_decode_literal(C_heaptop,"\376B\000\000\005SHELL");
lf[424]=C_h_intern(&lf[424],27,"\003sysshell-command-arguments");
lf[425]=C_decode_literal(C_heaptop,"\376B\000\000\002-c");
lf[426]=C_h_intern(&lf[426],11,"process-run");
lf[427]=C_decode_literal(C_heaptop,"\376B\000\000\025abnormal process exit");
lf[428]=C_h_intern(&lf[428],11,"\003sysprocess");
lf[429]=C_h_intern(&lf[429],7,"process");
lf[430]=C_h_intern(&lf[430],8,"process\052");
lf[431]=C_h_intern(&lf[431],6,"values");
lf[432]=C_h_intern(&lf[432],19,"set-root-directory!");
lf[433]=C_decode_literal(C_heaptop,"\376B\000\000\037unable to change root directory");
lf[434]=C_decode_literal(C_heaptop,"\376B\000\000 cannot retrieve process group ID");
lf[435]=C_h_intern(&lf[435],21,"set-process-group-id!");
lf[436]=C_decode_literal(C_heaptop,"\376B\000\000\033cannot set process group ID");
lf[437]=C_h_intern(&lf[437],18,"getter-with-setter");
lf[438]=C_decode_literal(C_heaptop,"\376B\000\000\026(process-group-id pid)");
lf[439]=C_h_intern(&lf[439],26,"effective-group-id!-setter");
lf[440]=C_decode_literal(C_heaptop,"\376B\000\000\035cannot set effective group ID");
lf[441]=C_decode_literal(C_heaptop,"\376B\000\000\034(current-effective-group-id)");
lf[442]=C_h_intern(&lf[442],12,"set-user-id!");
lf[443]=C_decode_literal(C_heaptop,"\376B\000\000\023cannot set group ID");
lf[444]=C_decode_literal(C_heaptop,"\376B\000\000\022(current-group-id)");
lf[445]=C_h_intern(&lf[445],25,"effective-user-id!-setter");
lf[446]=C_decode_literal(C_heaptop,"\376B\000\000\034cannot set effective user ID");
lf[447]=C_decode_literal(C_heaptop,"\376B\000\000\033(current-effective-used-id)");
lf[448]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot set user ID");
lf[449]=C_decode_literal(C_heaptop,"\376B\000\000\021(current-user-id)");
lf[450]=C_decode_literal(C_heaptop,"\376B\000\000\031(file-creation-mode mode)");
lf[451]=C_decode_literal(C_heaptop,"\376B\000\000%cannot retrieve file position of port");
lf[452]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[453]=C_decode_literal(C_heaptop,"\376B\000\000\024(file-position port)");
lf[454]=C_h_intern(&lf[454],26,"set-file-modification-time");
lf[455]=C_decode_literal(C_heaptop,"\376B\000\000!cannot set file modification-time");
lf[456]=C_decode_literal(C_heaptop,"\376B\000\000\032(file-modification-time f)");
C_register_lf2(lf,457,create_ptable());{}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2672,a[2]=t1,tmp=(C_word)a,a+=3,tmp);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=C_SCHEME_UNDEFINED;
av2[1]=t2;
C_scheduler_toplevel(2,av2);}}

/* k5409 in k5405 in k5401 in k5394 in system-information in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5411(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_5411,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5415,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-nonnull-c-string */
t4=*((C_word*)lf[246]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=C_mpointer(&a,(void*)C_utsname.version);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k6730 in k6663 in custom-output-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_6732(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(!C_demand(C_calculate_demand(23,0,4))){
C_save_and_reclaim_args((void *)trf_6732,2,t0,t1);}
a=C_alloc(23);
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,((C_word*)t0)[3]);
t3=C_mutate2(((C_word *)((C_word*)t0)[4])+1,t1);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6737,a[2]=t5,a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6743,a[2]=((C_word*)t0)[4],a[3]=((C_word)li157),tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6749,a[2]=t5,a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[6],a[7]=((C_word)li158),tmp=(C_word)a,a+=8,tmp);
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6771,a[2]=((C_word*)t0)[4],a[3]=((C_word)li159),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1322: make-output-port */
t10=*((C_word*)lf[348]+1);{
C_word av2[5];
av2[0]=t10;
av2[1]=t6;
av2[2]=t7;
av2[3]=t8;
av2[4]=t9;
((C_proc)(void*)(*((C_word*)t10+1)))(5,av2);}}

/* k5413 in k5409 in k5405 in k5401 in k5394 in system-information in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5415(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(10,c,3))){C_save_and_reclaim((void *)f_5415,2,av);}
a=C_alloc(10);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5419,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,tmp=(C_word)a,a+=7,tmp);
/* ##sys#peek-nonnull-c-string */
t4=*((C_word*)lf[246]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=C_mpointer(&a,(void*)C_utsname.machine);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k6735 in k6730 in k6663 in custom-output-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6737(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_6737,2,av);}
a=C_alloc(4);
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6741,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1332: set-port-name! */
t4=*((C_word*)lf[340]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)((C_word*)t0)[2])[1];
av2[3]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* set-root-directory! in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8449(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(7,c,2))){C_save_and_reclaim((void *)f_8449,3,av);}
a=C_alloc(7);
t3=C_i_check_string_2(t2,lf[432]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8466,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=t4;
t6=t2;
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8441,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
if(C_truep(t6)){
t8=C_i_foreign_string_argumentp(t6);
/* posixunix.scm:1806: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t7;
av2[2]=t8;
tp(3,av2);}}
else{
t8=t5;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t8;
av2[1]=stub2154(C_SCHEME_UNDEFINED,C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}

/* k5417 in k5413 in k5409 in k5405 in k5401 in k5394 in system-information in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5419(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(15,c,1))){C_save_and_reclaim((void *)f_5419,2,av);}
a=C_alloc(15);
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_a_i_list5(&a,5,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k8439 in set-root-directory! in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8441(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_8441,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=stub2154(C_SCHEME_UNDEFINED,t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k6251 in k6248 in loop in fetch in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in ... */
static void C_ccall f_6253(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_6253,2,av);}
/* posixunix.scm:1191: loop */
t2=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
f_6198(2,av2);}}

/* k6248 in loop in fetch in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 in ... */
static void C_ccall f_6250(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(!C_demand(C_calculate_demand(8,c,6))){C_save_and_reclaim((void *)f_6250,2,av);}
a=C_alloc(8);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6253,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1190: ##sys#thread-yield! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[334]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[334]+1);
av2[1]=t2;
tp(2,av2);}}
else{
t2=C_read(((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6]);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6259,a[2]=((C_word*)t0)[7],a[3]=t3,a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t5=C_eqp(((C_word*)t3)[1],C_fix(-1));
if(C_truep(t5)){
t6=C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
t7=(C_truep(t6)?t6:C_eqp(C_fix((C_word)errno),C_fix((C_word)EAGAIN)));
if(C_truep(t7)){
t8=C_set_block_item(t3,0,C_fix(0));
t9=C_mutate2(((C_word *)((C_word*)t0)[7])+1,((C_word*)t3)[1]);
t10=C_set_block_item(((C_word*)t0)[8],0,C_fix(0));
t11=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t11;
av2[1]=t10;
((C_proc)(void*)(*((C_word*)t11+1)))(2,av2);}}
else{
/* posixunix.scm:1197: posix-error */
t8=lf[0];{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t8;
av2[1]=t4;
av2[2]=lf[8];
av2[3]=((C_word*)t0)[9];
av2[4]=lf[339];
av2[5]=((C_word*)t0)[4];
av2[6]=((C_word*)t0)[10];
f_2696(7,av2);}}}
else{
t6=C_mutate2(((C_word *)((C_word*)t0)[7])+1,((C_word*)t3)[1]);
t7=C_set_block_item(((C_word*)t0)[8],0,C_fix(0));
t8=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}}

/* k6926 in file-truncate in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6928(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_6928,2,av);}
t2=C_truncate(t1,((C_word*)t0)[2]);
t3=((C_word*)t0)[3];
f_6914(t3,C_fixnum_lessp(t2,C_fix(0)));}

/* k6919 in file-truncate in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6921(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_6921,2,av);}
t2=((C_word*)t0)[2];
f_6914(t2,C_fixnum_lessp(t1,C_fix(0)));}

/* k6257 in k6248 in loop in fetch in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in ... */
static void C_ccall f_6259(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_6259,2,av);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_set_block_item(((C_word*)t0)[4],0,C_fix(0));
t4=((C_word*)t0)[5];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k6218 in k6215 in loop in fetch in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in ... */
static void C_ccall f_6220(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_6220,2,av);}
/* posixunix.scm:1181: loop */
t2=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
f_6198(2,av2);}}

/* k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5432(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,4))){C_save_and_reclaim((void *)f_5432,2,av);}
a=C_alloc(9);
t2=C_mutate2((C_word*)lf[248]+1 /* (set! current-user-id ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5436,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8550,a[2]=((C_word)li236),tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8553,a[2]=((C_word)li237),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:866: getter-with-setter */
t6=*((C_word*)lf[437]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t6;
av2[1]=t3;
av2[2]=t4;
av2[3]=t5;
av2[4]=lf[447];
((C_proc)(void*)(*((C_word*)t6+1)))(5,av2);}}

/* setup in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_6939(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word *a;
if(!C_demand(C_calculate_demand(8,0,2))){
C_save_and_reclaim_args((void *)trf_6939,4,t1,t2,t3,t4);}
a=C_alloc(8);
t5=C_i_nullp(t3);
t6=(C_truep(t5)?C_fix(0):C_i_car(t3));
t7=t6;
t8=C_i_nullp(t3);
t9=(C_truep(t8)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t10=C_i_nullp(t9);
t11=(C_truep(t10)?C_SCHEME_TRUE:C_i_car(t9));
t12=t11;
t13=(*a=C_VECTOR_TYPE|1,a[1]=t12,tmp=(C_word)a,a+=2,tmp);
t14=C_i_nullp(t9);
t15=(C_truep(t14)?C_SCHEME_END_OF_LIST:C_i_cdr(t9));
t16=t2;
t17=t4;
t18=C_i_check_port_2(t16,C_fix(0),C_SCHEME_TRUE,t17);
t19=C_i_check_number_2(t7,t4);
t20=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6960,a[2]=t2,a[3]=t7,a[4]=t13,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t21=C_eqp(C_SCHEME_TRUE,((C_word*)t13)[1]);
if(C_truep(t21)){
t22=C_set_block_item(t13,0,C_fix(0));
t23=t20;
f_6960(t23,t22);}
else{
t22=t20;
f_6960(t22,C_i_check_number_2(((C_word*)t13)[1],t4));}}

/* k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5436(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,4))){C_save_and_reclaim((void *)f_5436,2,av);}
a=C_alloc(9);
t2=C_mutate2((C_word*)lf[249]+1 /* (set! current-effective-user-id ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5440,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8531,a[2]=((C_word)li234),tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8534,a[2]=((C_word)li235),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:876: getter-with-setter */
t6=*((C_word*)lf[437]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t6;
av2[1]=t3;
av2[2]=t4;
av2[3]=t5;
av2[4]=lf[444];
((C_proc)(void*)(*((C_word*)t6+1)))(5,av2);}}

/* k5401 in k5394 in system-information in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5403(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(7,c,3))){C_save_and_reclaim((void *)f_5403,2,av);}
a=C_alloc(7);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5407,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t4=*((C_word*)lf[246]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=C_mpointer(&a,(void*)C_utsname.nodename);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k8477 in a8471 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8479(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_8479,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k5405 in k5401 in k5394 in system-information in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5407(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(8,c,3))){C_save_and_reclaim((void *)f_5407,2,av);}
a=C_alloc(8);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5411,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t4=*((C_word*)lf[246]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=C_mpointer(&a,(void*)C_utsname.release);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* a8471 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8472(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(8,c,2))){C_save_and_reclaim((void *)f_8472,3,av);}
a=C_alloc(8);
t3=C_i_check_exact_2(t2,lf[315]);
t4=C_getpgid(t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8479,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t4,C_fix(0)))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8485,a[2]=t5,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1085: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[5]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[5]+1);
av2[1]=t6;
tp(2,av2);}}
else{
t6=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t6;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k5451 in user-information in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_5453(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(7,0,3))){
C_save_and_reclaim_args((void *)trf_5453,2,t0,t1);}
a=C_alloc(7);
if(C_truep(t1)){
t2=(C_truep(((C_word*)t0)[2])?*((C_word*)lf[253]+1):*((C_word*)lf[254]+1));
t3=t2;
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5466,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t5=*((C_word*)lf[246]+1);{
C_word av2[4];
av2[0]=t5;
av2[1]=t4;
av2[2]=C_mpointer(&a,(void*)C_user->pw_name);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}
else{
t2=((C_word*)t0)[3];{
C_word av2[2];
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k8483 in a8471 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8485(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_8485,2,av);}
/* posixunix.scm:1086: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[315];
av2[3]=lf[434];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* k6215 in loop in fetch in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 in ... */
static void C_ccall f_6217(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,2))){C_save_and_reclaim((void *)f_6217,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6220,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1180: ##sys#thread-yield! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[334]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[334]+1);
av2[1]=t2;
tp(2,av2);}}

/* k3499 in k3489 in k3477 in loop in k3449 in k3445 in k3442 in k3439 in k3424 in directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3501(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,1))){C_save_and_reclaim((void *)f_3501,2,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k5423 in system-information in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5425(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_5425,2,av);}
/* posixunix.scm:849: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[245];
av2[3]=lf[247];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5444(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word *a;
if(!C_demand(C_calculate_demand(54,c,5))){C_save_and_reclaim((void *)f_5444,2,av);}
a=C_alloc(54);
t2=C_mutate2((C_word*)lf[251]+1 /* (set! current-effective-group-id ...) */,t1);
t3=C_mutate2((C_word*)lf[252]+1 /* (set! user-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5446,a[2]=((C_word)li116),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate2((C_word*)lf[255]+1 /* (set! current-user-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5500,a[2]=((C_word)li117),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate2((C_word*)lf[256]+1 /* (set! current-effective-user-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5514,a[2]=((C_word)li118),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate2((C_word*)lf[257]+1 /* (set! group-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5539,a[2]=((C_word)li120),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate2((C_word*)lf[258]+1 /* (set! get-groups ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5619,a[2]=((C_word)li122),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate2((C_word*)lf[262]+1 /* (set! set-groups! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5683,a[2]=((C_word)li124),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate2((C_word*)lf[265]+1 /* (set! initialize-groups ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5758,a[2]=((C_word)li125),tmp=(C_word)a,a+=3,tmp));
t10=C_mutate2((C_word*)lf[267]+1 /* (set! errno/perm ...) */,C_fix((C_word)EPERM));
t11=C_mutate2((C_word*)lf[268]+1 /* (set! errno/noent ...) */,C_fix((C_word)ENOENT));
t12=C_mutate2((C_word*)lf[269]+1 /* (set! errno/srch ...) */,C_fix((C_word)ESRCH));
t13=C_mutate2((C_word*)lf[270]+1 /* (set! errno/intr ...) */,C_fix((C_word)EINTR));
t14=C_mutate2((C_word*)lf[271]+1 /* (set! errno/io ...) */,C_fix((C_word)EIO));
t15=C_mutate2((C_word*)lf[272]+1 /* (set! errno/noexec ...) */,C_fix((C_word)ENOEXEC));
t16=C_mutate2((C_word*)lf[273]+1 /* (set! errno/badf ...) */,C_fix((C_word)EBADF));
t17=C_mutate2((C_word*)lf[274]+1 /* (set! errno/child ...) */,C_fix((C_word)ECHILD));
t18=C_mutate2((C_word*)lf[275]+1 /* (set! errno/nomem ...) */,C_fix((C_word)ENOMEM));
t19=C_mutate2((C_word*)lf[276]+1 /* (set! errno/acces ...) */,C_fix((C_word)EACCES));
t20=C_mutate2((C_word*)lf[277]+1 /* (set! errno/fault ...) */,C_fix((C_word)EFAULT));
t21=C_mutate2((C_word*)lf[278]+1 /* (set! errno/busy ...) */,C_fix((C_word)EBUSY));
t22=C_mutate2((C_word*)lf[279]+1 /* (set! errno/notdir ...) */,C_fix((C_word)ENOTDIR));
t23=C_mutate2((C_word*)lf[280]+1 /* (set! errno/isdir ...) */,C_fix((C_word)EISDIR));
t24=C_mutate2((C_word*)lf[281]+1 /* (set! errno/inval ...) */,C_fix((C_word)EINVAL));
t25=C_mutate2((C_word*)lf[282]+1 /* (set! errno/mfile ...) */,C_fix((C_word)EMFILE));
t26=C_mutate2((C_word*)lf[283]+1 /* (set! errno/nospc ...) */,C_fix((C_word)ENOSPC));
t27=C_mutate2((C_word*)lf[284]+1 /* (set! errno/spipe ...) */,C_fix((C_word)ESPIPE));
t28=C_mutate2((C_word*)lf[285]+1 /* (set! errno/pipe ...) */,C_fix((C_word)EPIPE));
t29=C_mutate2((C_word*)lf[286]+1 /* (set! errno/again ...) */,C_fix((C_word)EAGAIN));
t30=C_mutate2((C_word*)lf[287]+1 /* (set! errno/rofs ...) */,C_fix((C_word)EROFS));
t31=C_mutate2((C_word*)lf[288]+1 /* (set! errno/exist ...) */,C_fix((C_word)EEXIST));
t32=C_mutate2((C_word*)lf[289]+1 /* (set! errno/wouldblock ...) */,C_fix((C_word)EWOULDBLOCK));
t33=C_set_block_item(lf[290] /* errno/2big */,0,C_fix(0));
t34=C_set_block_item(lf[291] /* errno/deadlk */,0,C_fix(0));
t35=C_set_block_item(lf[292] /* errno/dom */,0,C_fix(0));
t36=C_set_block_item(lf[293] /* errno/fbig */,0,C_fix(0));
t37=C_set_block_item(lf[294] /* errno/ilseq */,0,C_fix(0));
t38=C_set_block_item(lf[295] /* errno/mlink */,0,C_fix(0));
t39=C_set_block_item(lf[296] /* errno/nametoolong */,0,C_fix(0));
t40=C_set_block_item(lf[297] /* errno/nfile */,0,C_fix(0));
t41=C_set_block_item(lf[298] /* errno/nodev */,0,C_fix(0));
t42=C_set_block_item(lf[299] /* errno/nolck */,0,C_fix(0));
t43=C_set_block_item(lf[300] /* errno/nosys */,0,C_fix(0));
t44=C_set_block_item(lf[301] /* errno/notempty */,0,C_fix(0));
t45=C_set_block_item(lf[302] /* errno/notty */,0,C_fix(0));
t46=C_set_block_item(lf[303] /* errno/nxio */,0,C_fix(0));
t47=C_set_block_item(lf[304] /* errno/range */,0,C_fix(0));
t48=C_set_block_item(lf[305] /* errno/xdev */,0,C_fix(0));
t49=C_mutate2((C_word*)lf[306]+1 /* (set! change-file-mode ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5822,a[2]=((C_word)li126),tmp=(C_word)a,a+=3,tmp));
t50=C_mutate2((C_word*)lf[308]+1 /* (set! change-file-owner ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5845,a[2]=((C_word)li127),tmp=(C_word)a,a+=3,tmp));
t51=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5871,a[2]=((C_word)li128),tmp=(C_word)a,a+=3,tmp);
t52=C_mutate2((C_word*)lf[310]+1 /* (set! file-read-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5891,a[2]=t51,a[3]=((C_word)li129),tmp=(C_word)a,a+=4,tmp));
t53=C_mutate2((C_word*)lf[311]+1 /* (set! file-write-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5897,a[2]=t51,a[3]=((C_word)li130),tmp=(C_word)a,a+=4,tmp));
t54=C_mutate2((C_word*)lf[312]+1 /* (set! file-execute-access? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5903,a[2]=t51,a[3]=((C_word)li131),tmp=(C_word)a,a+=4,tmp));
t55=C_mutate2((C_word*)lf[313]+1 /* (set! create-session ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5909,a[2]=((C_word)li132),tmp=(C_word)a,a+=3,tmp));
t56=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5926,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t57=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8472,a[2]=((C_word)li230),tmp=(C_word)a,a+=3,tmp);
t58=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8490,a[2]=((C_word)li231),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1080: getter-with-setter */
t59=*((C_word*)lf[437]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t59;
av2[1]=t56;
av2[2]=t57;
av2[3]=t58;
av2[4]=lf[438];
((C_proc)(void*)(*((C_word*)t59+1)))(5,av2);}}

/* k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5440(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,4))){C_save_and_reclaim((void *)f_5440,2,av);}
a=C_alloc(9);
t2=C_mutate2((C_word*)lf[250]+1 /* (set! current-group-id ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5444,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8512,a[2]=((C_word)li232),tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8515,a[2]=((C_word)li233),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:885: getter-with-setter */
t6=*((C_word*)lf[437]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t6;
av2[1]=t3;
av2[2]=t4;
av2[3]=t5;
av2[4]=lf[441];
((C_proc)(void*)(*((C_word*)t6+1)))(5,av2);}}

/* user-information in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5446(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +7,c,3))){
C_save_and_reclaim((void*)f_5446,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+7);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=t5;
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5453,a[2]=t6,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnump(t2))){
t8=t7;
f_5453(t8,C_getpwuid(t2));}
else{
t8=C_i_check_string_2(t2,lf[252]);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5492,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:907: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t9;
av2[2]=t2;
av2[3]=lf[252];
tp(4,av2);}}}

/* k7151 in fifo? in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7153(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_7153,2,av);}
t2=C_i_fifo_p(t1);
switch(t2){
case C_SCHEME_TRUE:
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_SCHEME_TRUE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}
case C_SCHEME_FALSE:
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}
case C_fix(0):
/* posixunix.scm:1411: ##sys#signal-hook */
t3=*((C_word*)lf[1]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[8];
av2[3]=lf[35];
av2[4]=lf[363];
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}
default:
/* posixunix.scm:1413: posix-error */
t3=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[8];
av2[3]=lf[35];
av2[4]=lf[364];
av2[5]=((C_word*)t0)[3];
f_2696(6,av2);}}}

/* glob in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3561(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +6,c,3))){
C_save_and_reclaim((void*)f_3561,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+6);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3567,a[2]=t4,a[3]=((C_word)li38),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_3567(t6,t1,t2);}

/* conc-loop in glob in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_3567(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(9,0,5))){
C_save_and_reclaim_args((void *)trf_3567,3,t0,t1,t2);}
a=C_alloc(9);
if(C_truep(C_i_nullp(t2))){
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_i_car(t2);
t4=t3;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3582,a[2]=t4,a[3]=((C_word)li34),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3588,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li37),tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:501: ##sys#call-with-values */{
C_word av2[4];
av2[0]=0;
av2[1]=t1;
av2[2]=t5;
av2[3]=t6;
C_call_with_values(4,av2);}}}

/* ##sys#shell-command-arguments in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7994(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(6,c,1))){C_save_and_reclaim((void *)f_7994,3,av);}
a=C_alloc(6);
t3=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_a_i_list2(&a,2,lf[425],t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k7113 in create-fifo in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_7115(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(5,0,3))){
C_save_and_reclaim_args((void *)trf_7115,2,t0,t1);}
a=C_alloc(5);
t2=t1;
t3=C_i_check_exact_2(t2,lf[361]);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7132,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1400: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t4;
av2[2]=((C_word*)t0)[3];
av2[3]=lf[361];
tp(4,av2);}}

/* k2769 in file-stat in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2771(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(30,c,1))){C_save_and_reclaim((void *)f_2771,2,av);}
a=C_alloc(30);
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_a_i_vector(&a,13,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_ino),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_nlink),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_gid),C_a_double_to_num(&a,C_statbuf.st_size),C_flonum(&a,C_statbuf.st_atime),C_flonum(&a,C_statbuf.st_ctime),C_flonum(&a,C_statbuf.st_mtime),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_dev),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_rdev),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_blksize),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_blocks));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* a6367 in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6368(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(!C_demand(C_calculate_demand(9,c,2))){C_save_and_reclaim((void *)f_6368,6,av);}
a=C_alloc(9);
t6=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6376,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t4,a[6]=((C_word*)t0)[5],a[7]=t1,a[8]=t5,tmp=(C_word)a,a+=9,tmp);
if(C_truep(t3)){
t7=t6;
f_6376(t7,t3);}
else{
t7=C_block_size(t4);
t8=t6;
f_6376(t8,C_fixnum_difference(t7,t5));}}

/* k6490 in a6471 in a6461 in k6455 in k6446 in a6443 in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in ... */
static void C_ccall f_6492(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_6492,2,av);}
if(C_truep(C_fixnum_lessp(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t2=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[4])[1]);
t3=C_i_fixnum_min(((C_word*)((C_word*)t0)[3])[1],t2);
/* posixunix.scm:1257: values */{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=((C_word*)t0)[5];
av2[2]=((C_word*)t0)[6];
av2[3]=((C_word*)((C_word*)t0)[2])[1];
av2[4]=t3;
C_values(5,av2);}}
else{
/* posixunix.scm:1260: values */{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=((C_word*)t0)[5];
av2[2]=C_SCHEME_FALSE;
av2[3]=((C_word*)((C_word*)t0)[2])[1];
av2[4]=C_SCHEME_FALSE;
C_values(5,av2);}}}

/* file-stat in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2764(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +3,c,5))){
C_save_and_reclaim((void*)f_2764,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+3);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2771,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:243: ##sys#stat */
f_2714(t6,t2,t5,C_SCHEME_TRUE,lf[16]);}

/* k6374 in a6367 in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_6376(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(11,0,5))){
C_save_and_reclaim_args((void *)trf_6376,2,t0,t1);}
a=C_alloc(11);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6378,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t3,a[7]=((C_word*)t0)[6],a[8]=((C_word)li147),tmp=(C_word)a,a+=9,tmp));
t5=((C_word*)t3)[1];
f_6378(t5,((C_word*)t0)[7],t1,C_fix(0),((C_word*)t0)[8]);}

/* loop in k6374 in a6367 in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 in ... */
static void C_fcall f_6378(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word *a;
loop:
if(!C_demand(C_calculate_demand(8,0,4))){
C_save_and_reclaim_args((void *)trf_6378,5,t0,t1,t2,t3,t4);}
a=C_alloc(8);
t5=C_eqp(C_fix(0),t2);
if(C_truep(t5)){
t6=t3;
t7=t1;{
C_word av2[2];
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
if(C_truep(C_fixnum_lessp(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t6=C_fixnum_difference(((C_word*)((C_word*)t0)[3])[1],((C_word*)((C_word*)t0)[2])[1]);
t7=C_fixnum_lessp(t2,t6);
t8=(C_truep(t7)?t2:t6);
t9=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],t8);
t10=C_substring_copy(((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)((C_word*)t0)[2])[1],t9,t4);
t11=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],t8);
t12=C_mutate2(((C_word *)((C_word*)t0)[2])+1,t11);
t13=C_fixnum_difference(t2,t8);
t14=C_fixnum_plus(t3,t8);
t15=C_fixnum_plus(t4,t8);
/* posixunix.scm:1232: loop */
t17=t1;
t18=t13;
t19=t14;
t20=t15;
t1=t17;
t2=t18;
t3=t19;
t4=t20;
goto loop;}
else{
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6426,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=t1,a[5]=((C_word*)t0)[6],a[6]=t2,a[7]=t4,tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1234: fetch */
t7=((C_word*)t0)[7];
f_6192(t7,t6);}}}

/* a6461 in k6455 in k6446 in a6443 in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in ... */
static void C_ccall f_6462(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(8,c,5))){C_save_and_reclaim((void *)f_6462,2,av);}
a=C_alloc(8);
t2=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]);
t3=C_i_fixnum_min(((C_word*)((C_word*)t0)[4])[1],t2);
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6472,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word)li149),tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1245: ##sys#scan-buffer-line */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[342]+1));
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[342]+1);
av2[1]=t1;
av2[2]=((C_word*)t0)[5];
av2[3]=t3;
av2[4]=((C_word*)((C_word*)t0)[2])[1];
av2[5]=t4;
tp(6,av2);}}

/* sleep in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7953(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_7953,3,av);}
t3=C_i_foreign_fixnum_argumentp(t2);
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=stub1958(C_SCHEME_UNDEFINED,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* file-change-time in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2792(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(3,c,5))){C_save_and_reclaim((void *)f_2792,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2796,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:265: ##sys#stat */
f_2714(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[19]);}

/* k2794 in file-change-time in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2796(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,1))){C_save_and_reclaim((void *)f_2796,2,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_flonum(&a,C_statbuf.st_ctime);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* parent-process-id in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7950(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_7950,2,av);}
t2=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=stub1954(C_SCHEME_UNDEFINED);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* file-owner in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2798(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(3,c,5))){C_save_and_reclaim((void *)f_2798,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2802,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:266: ##sys#stat */
f_2714(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[20]);}

/* k2788 in file-access-time in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2790(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,1))){C_save_and_reclaim((void *)f_2790,2,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_flonum(&a,C_statbuf.st_atime);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k7355 in string->time in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7357(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,2))){C_save_and_reclaim((void *)f_7357,2,av);}
a=C_alloc(5);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7361,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1477: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
tp(3,av2);}}

/* k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2784(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word *a;
if(!C_demand(C_calculate_demand(48,c,4))){C_save_and_reclaim((void *)f_2784,2,av);}
a=C_alloc(48);
t2=C_mutate2((C_word*)lf[17]+1 /* (set! file-modification-time ...) */,t1);
t3=C_mutate2((C_word*)lf[18]+1 /* (set! file-access-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2786,a[2]=((C_word)li3),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate2((C_word*)lf[19]+1 /* (set! file-change-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2792,a[2]=((C_word)li4),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate2((C_word*)lf[20]+1 /* (set! file-owner ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2798,a[2]=((C_word)li5),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate2((C_word*)lf[21]+1 /* (set! file-permissions ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2804,a[2]=((C_word)li6),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate2((C_word*)lf[22]+1 /* (set! file-size ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2810,a[2]=((C_word)li7),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate2((C_word*)lf[23]+1 /* (set! file-type ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2816,a[2]=((C_word)li8),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate2((C_word*)lf[31]+1 /* (set! regular-file? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2903,a[2]=((C_word)li9),tmp=(C_word)a,a+=3,tmp));
t10=C_mutate2((C_word*)lf[32]+1 /* (set! symbolic-link? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2913,a[2]=((C_word)li10),tmp=(C_word)a,a+=3,tmp));
t11=C_mutate2((C_word*)lf[33]+1 /* (set! block-device? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2923,a[2]=((C_word)li11),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate2((C_word*)lf[34]+1 /* (set! character-device? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2933,a[2]=((C_word)li12),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate2((C_word*)lf[35]+1 /* (set! fifo? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2943,a[2]=((C_word)li13),tmp=(C_word)a,a+=3,tmp));
t14=C_mutate2((C_word*)lf[36]+1 /* (set! socket? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2953,a[2]=((C_word)li14),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate2((C_word*)lf[37]+1 /* (set! directory? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2963,a[2]=((C_word)li15),tmp=(C_word)a,a+=3,tmp));
t16=C_mutate2((C_word*)lf[38]+1 /* (set! seek/set ...) */,C_fix((C_word)SEEK_SET));
t17=C_mutate2((C_word*)lf[39]+1 /* (set! seek/end ...) */,C_fix((C_word)SEEK_END));
t18=C_mutate2((C_word*)lf[40]+1 /* (set! seek/cur ...) */,C_fix((C_word)SEEK_CUR));
t19=C_mutate2((C_word*)lf[41]+1 /* (set! set-file-position! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2976,a[2]=((C_word)li16),tmp=(C_word)a,a+=3,tmp));
t20=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3025,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t21=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8662,a[2]=((C_word)li245),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:329: getter-with-setter */
t22=*((C_word*)lf[437]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t22;
av2[1]=t20;
av2[2]=t21;
av2[3]=*((C_word*)lf[41]+1);
av2[4]=lf[453];
((C_proc)(void*)(*((C_word*)t22+1)))(5,av2);}}

/* ##sys#shell-command in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7985(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(3,c,2))){C_save_and_reclaim((void *)f_7985,2,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7989,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1662: get-environment-variable */
t3=*((C_word*)lf[422]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[423];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* file-access-time in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2786(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(3,c,5))){C_save_and_reclaim((void *)f_2786,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2790,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:264: ##sys#stat */
f_2714(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[18]);}

/* k7987 in shell-command in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7989(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_7989,2,av);}
if(C_truep(t1)){
t2=t1;
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=lf[421];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* create-fifo in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7108(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +4,c,2))){
C_save_and_reclaim((void*)f_7108,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+4);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
t4=C_i_check_string_2(t2,lf[361]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7115,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t6=t3;
t7=t5;
f_7115(t7,C_u_i_car(t6));}
else{
t6=C_fixnum_or(C_fix((C_word)S_IRWXG),C_fix((C_word)S_IRWXO));
t7=t5;
f_7115(t7,C_fixnum_or(C_fix((C_word)S_IRWXU),t6));}}

/* string->time in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7340(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +5,c,3))){
C_save_and_reclaim((void*)f_7340,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+5);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?lf[385]:C_i_car(t3));
t6=t5;
t7=C_i_check_string_2(t2,lf[384]);
t8=C_i_check_string_2(t6,lf[384]);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7357,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t6,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1477: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t9;
av2[2]=t2;
av2[3]=lf[384];
tp(4,av2);}}

/* loop in k3449 in k3445 in k3442 in k3439 in k3424 in directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_3465(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(6,0,4))){
C_save_and_reclaim_args((void *)trf_3465,2,t0,t1);}
a=C_alloc(6);
t2=C_readdir(((C_word*)t0)[2],((C_word*)t0)[3]);
if(C_truep(C_null_pointerp(((C_word*)t0)[3]))){
t3=C_closedir(((C_word*)t0)[2]);
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=C_block_size(((C_word*)t0)[4]);
t4=C_foundfile(((C_word*)t0)[3],((C_word*)t0)[4],t3);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3479,a[2]=t4,a[3]=((C_word*)t0)[5],a[4]=t1,a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:484: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[70]+1));
C_word av2[5];
av2[0]=*((C_word*)lf[70]+1);
av2[1]=t5;
av2[2]=((C_word*)t0)[4];
av2[3]=C_fix(0);
av2[4]=t4;
tp(5,av2);}}}

/* ##sys#process-wait in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7912(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand(5,c,4))){C_save_and_reclaim((void *)f_7912,4,av);}
a=C_alloc(5);
t4=(C_truep(t3)?C_fix((C_word)WNOHANG):C_fix(0));
t5=C_waitpid(t2,t4);
t6=C_WIFEXITED(C_fix((C_word)C_wait_status));
t7=C_eqp(t5,C_fix(-1));
t8=(C_truep(t7)?C_eqp(C_fix((C_word)errno),C_fix((C_word)EINTR)):C_SCHEME_FALSE);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7928,a[2]=t2,a[3]=t3,a[4]=((C_word)li196),tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1639: ##sys#dispatch-interrupt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[172]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[172]+1);
av2[1]=t1;
av2[2]=t9;
tp(3,av2);}}
else{
if(C_truep(t6)){
t9=C_WEXITSTATUS(C_fix((C_word)C_wait_status));
/* posixunix.scm:1641: values */{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t5;
av2[3]=t6;
av2[4]=t9;
C_values(5,av2);}}
else{
if(C_truep(C_WIFSIGNALED(C_fix((C_word)C_wait_status)))){
t9=C_WTERMSIG(C_fix((C_word)C_wait_status));
/* posixunix.scm:1641: values */{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t5;
av2[3]=t6;
av2[4]=t9;
C_values(5,av2);}}
else{
t9=C_WSTOPSIG(C_fix((C_word)C_wait_status));
/* posixunix.scm:1641: values */{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t5;
av2[3]=t6;
av2[4]=t9;
C_values(5,av2);}}}}}

/* k7435 in k7432 in set-buffering-mode! in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_7437(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(5,0,5))){
C_save_and_reclaim_args((void *)trf_7437,2,t0,t1);}
a=C_alloc(5);
t2=t1;
t3=((C_word*)t0)[2];
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7440,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t5=C_eqp(t3,lf[393]);
if(C_truep(t5)){
t6=t4;{
C_word av2[2];
av2[0]=t6;
av2[1]=C_fix((C_word)_IOFBF);
f_7440(2,av2);}}
else{
t6=C_eqp(t3,lf[394]);
if(C_truep(t6)){
t7=C_fix((C_word)_IOLBF);
t8=t4;{
C_word av2[2];
av2[0]=t8;
av2[1]=t7;
f_7440(2,av2);}}
else{
t7=C_eqp(t3,lf[395]);
if(C_truep(t7)){
t8=t4;{
C_word av2[2];
av2[0]=t8;
av2[1]=C_fix((C_word)_IONBF);
f_7440(2,av2);}}
else{
/* posixunix.scm:1522: ##sys#error */
t8=*((C_word*)lf[50]+1);{
C_word av2[6];
av2[0]=t8;
av2[1]=t4;
av2[2]=lf[391];
av2[3]=lf[396];
av2[4]=((C_word*)t0)[2];
av2[5]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t8+1)))(6,av2);}}}}}

/* k7432 in set-buffering-mode! in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7434(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,2))){C_save_and_reclaim((void *)f_7434,2,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7437,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(((C_word*)t0)[5]))){
t3=((C_word*)t0)[5];
t4=t2;
f_7437(t4,C_u_i_car(t3));}
else{
t3=t2;
f_7437(t3,C_fix((C_word)BUFSIZ));}}

/* set-buffering-mode! in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7430(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +6,c,3))){
C_save_and_reclaim((void*)f_7430,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+6);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7434,a[2]=t3,a[3]=t1,a[4]=t2,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1516: ##sys#check-port */
t6=*((C_word*)lf[397]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
av2[3]=lf[391];
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}

/* ##sys#file-select-one in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4318(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_4318,3,av);}
t3=C_i_foreign_fixnum_argumentp(t2);
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=stub730(C_SCHEME_UNDEFINED,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* ##sys#file-nonblocking! in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4311(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_4311,3,av);}
t3=C_i_foreign_fixnum_argumentp(t2);
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=stub725(C_SCHEME_UNDEFINED,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* memory-mapped-file-pointer in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7316(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_7316,3,av);}
t3=C_i_check_structure_2(t2,lf[375],lf[382]);
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_slot(t2,C_fix(1));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* set-alarm! in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7423(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_7423,3,av);}
t3=C_i_foreign_fixnum_argumentp(t2);
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=stub1768(C_SCHEME_UNDEFINED,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k3439 in k3424 in directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3441(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,2))){C_save_and_reclaim((void *)f_3441,2,av);}
a=C_alloc(6);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3444,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:470: ##sys#make-pointer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[86]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[86]+1);
av2[1]=t3;
tp(2,av2);}}

/* k3442 in k3439 in k3424 in directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3444(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(7,c,2))){C_save_and_reclaim((void *)f_3444,2,av);}
a=C_alloc(7);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3447,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* posix-common.scm:471: ##sys#make-pointer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[86]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[86]+1);
av2[1]=t3;
tp(2,av2);}}

/* k3445 in k3442 in k3439 in k3424 in directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3447(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(8,c,3))){C_save_and_reclaim((void *)f_3447,2,av);}
a=C_alloc(8);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3451,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posix-common.scm:474: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
av2[3]=lf[26];
tp(4,av2);}}

/* k4554 in file-mkstemp in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4556(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,5))){C_save_and_reclaim((void *)f_4556,2,av);}
a=C_alloc(6);
t2=t1;
t3=C_mkstemp(t2);
t4=C_block_size(t2);
t5=t4;
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4562,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=t5,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t7=C_eqp(C_fix(-1),t3);
if(C_truep(t7)){
/* posixunix.scm:555: posix-error */
t8=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t8;
av2[1]=t6;
av2[2]=lf[8];
av2[3]=lf[180];
av2[4]=lf[181];
av2[5]=((C_word*)t0)[3];
f_2696(6,av2);}}
else{
t8=t6;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t8;
av2[1]=C_SCHEME_UNDEFINED;
f_4562(2,av2);}}}

/* f_3841 in k3864 in k3861 in k3858 in k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3841(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3841,2,av);}
t2=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_fixnum_lessp(((C_word*)((C_word*)t0)[2])[1],((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k3449 in k3445 in k3442 in k3439 in k3424 in directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3451(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(10,c,5))){C_save_and_reclaim((void *)f_3451,2,av);}
a=C_alloc(10);
t2=C_opendir(t1,((C_word*)t0)[2]);
if(C_truep(C_null_pointerp(((C_word*)t0)[2]))){
/* posix-common.scm:476: posix-error */
t3=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[8];
av2[3]=lf[26];
av2[4]=lf[85];
av2[5]=((C_word*)t0)[4];
f_2696(6,av2);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3465,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t4,a[6]=((C_word*)t0)[7],a[7]=((C_word)li32),tmp=(C_word)a,a+=8,tmp));
t6=((C_word*)t4)[1];
f_3465(t6,((C_word*)t0)[3]);}}

/* find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3847(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +8,c,4))){
C_save_and_reclaim((void*)f_3847,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+8);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3851,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3891,a[2]=((C_word)li54),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:551: ##sys#get-keyword */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[97]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[97]+1);
av2[1]=t4;
av2[2]=lf[101];
av2[3]=t3;
av2[4]=t5;
tp(5,av2);}}

/* k7962 in process-signal in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_7964(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(0,0,6))){
C_save_and_reclaim_args((void *)trf_7964,2,t0,t1);}
t2=C_i_check_exact_2(((C_word*)t0)[2],lf[418]);
t3=C_i_check_exact_2(t1,lf[418]);
t4=C_kill(((C_word*)t0)[2],t1);
t5=C_eqp(t4,C_fix(-1));
if(C_truep(t5)){
/* posixunix.scm:1659: posix-error */
t6=lf[0];{
C_word av2[7];
av2[0]=t6;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[127];
av2[3]=lf[418];
av2[4]=lf[419];
av2[5]=((C_word*)t0)[2];
av2[6]=t1;
f_2696(7,av2);}}
else{
t6=C_SCHEME_UNDEFINED;
t7=((C_word*)t0)[3];{
C_word av2[2];
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* process-signal in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7960(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +4,c,2))){
C_save_and_reclaim((void*)f_7960,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+4);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7964,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t5=t3;
t6=t4;
f_7964(t6,C_u_i_car(t5));}
else{
t5=t4;
f_7964(t5,C_fix((C_word)SIGTERM));}}

/* k7447 in k7438 in k7435 in k7432 in set-buffering-mode! in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_7449(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,0,6))){
C_save_and_reclaim_args((void *)trf_7449,2,t0,t1);}
if(C_truep(t1)){
/* posixunix.scm:1528: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word av2[7];
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[391];
av2[3]=lf[392];
av2[4]=((C_word*)t0)[3];
av2[5]=((C_word*)t0)[4];
av2[6]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t2+1)))(7,av2);}}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* file-mkstemp in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4549(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_4549,3,av);}
a=C_alloc(4);
t3=C_i_check_string_2(t2,lf[180]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4556,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:551: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[180];
tp(4,av2);}}

/* k7438 in k7435 in k7432 in set-buffering-mode! in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7440(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,2))){C_save_and_reclaim((void *)f_7440,2,av);}
a=C_alloc(6);
t2=t1;
t3=C_i_check_exact_2(((C_word*)t0)[2],lf[391]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7449,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t2,a[5]=((C_word*)t0)[2],tmp=(C_word)a,a+=6,tmp);
t5=C_slot(((C_word*)t0)[4],C_fix(7));
t6=C_eqp(lf[43],t5);
if(C_truep(t6)){
t7=C_setvbuf(((C_word*)t0)[4],t2,((C_word*)t0)[2]);
t8=t4;
f_7449(t8,C_fixnum_lessp(t7,C_fix(0)));}
else{
t7=t4;
f_7449(t7,C_SCHEME_TRUE);}}

/* k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3854(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(10,c,4))){C_save_and_reclaim((void *)f_3854,2,av);}
a=C_alloc(10);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3857,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3880,a[2]=((C_word)li50),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:551: ##sys#get-keyword */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[97]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[97]+1);
av2[1]=t3;
av2[2]=lf[99];
av2[3]=((C_word*)t0)[5];
av2[4]=t4;
tp(5,av2);}}

/* k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3851(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,4))){C_save_and_reclaim((void *)f_3851,2,av);}
a=C_alloc(9);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3854,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3883,a[2]=((C_word)li52),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:551: ##sys#get-keyword */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[97]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[97]+1);
av2[1]=t3;
av2[2]=lf[100];
av2[3]=((C_word*)t0)[4];
av2[4]=t4;
tp(5,av2);}}

/* k3424 in directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3426(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,3))){C_save_and_reclaim((void *)f_3426,2,av);}
a=C_alloc(5);
t2=t1;
t3=C_i_nullp(((C_word*)t0)[2]);
t4=(C_truep(t3)?C_SCHEME_END_OF_LIST:C_i_cdr(((C_word*)t0)[2]));
t5=C_i_nullp(t4);
t6=(C_truep(t5)?C_SCHEME_FALSE:C_i_car(t4));
t7=t6;
t8=C_i_nullp(t4);
t9=(C_truep(t8)?C_SCHEME_END_OF_LIST:C_i_cdr(t4));
t10=C_i_check_string_2(t2,lf[26]);
t11=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3441,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=t7,tmp=(C_word)a,a+=5,tmp);
/* ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[72]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[72]+1);
av2[1]=t11;
av2[2]=C_fix(256);
av2[3]=C_make_character(32);
tp(4,av2);}}

/* directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3422(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2))){
C_save_and_reclaim((void*)f_3422,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
t3=t2;
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3426,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
/* posix-common.scm:467: current-directory */
t5=*((C_word*)lf[68]+1);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t5=t4;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=C_i_car(t3);
f_3426(2,av2);}}}

/* k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3857(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(11,c,4))){C_save_and_reclaim((void *)f_3857,2,av);}
a=C_alloc(11);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3860,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3877,a[2]=((C_word)li49),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:551: ##sys#get-keyword */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[97]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[97]+1);
av2[1]=t3;
av2[2]=lf[98];
av2[3]=((C_word*)t0)[6];
av2[4]=t4;
tp(5,av2);}}

/* memory-mapped-file? in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7325(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_7325,3,av);}
t3=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_i_structurep(t2,lf[375]);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k3822 in k3673 in k3864 in k3861 in k3858 in k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3824(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_3824,2,av);}
a=C_alloc(4);
t2=t1;
t3=((C_word*)t0)[2];
f_3678(t3,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3825,a[2]=t2,a[3]=((C_word)li44),tmp=(C_word)a,a+=4,tmp));}

/* f_3825 in k3822 in k3673 in k3864 in k3861 in k3858 in k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3825(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_3825,3,av);}
/* posix-common.scm:527: irregex-match */
t3=*((C_word*)lf[89]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
av2[3]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* a6471 in a6461 in k6455 in k6446 in a6443 in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in ... */
static void C_ccall f_6472(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(7,c,4))){C_save_and_reclaim((void *)f_6472,3,av);}
a=C_alloc(7);
t3=C_fixnum_difference(t2,((C_word*)((C_word*)t0)[2])[1]);
if(C_truep(C_fixnum_greater_or_equal_p(t3,((C_word*)((C_word*)t0)[3])[1]))){
/* posixunix.scm:1252: values */{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_SCHEME_FALSE;
av2[3]=t2;
av2[4]=C_SCHEME_FALSE;
C_values(5,av2);}}
else{
t4=C_fixnum_difference(((C_word*)((C_word*)t0)[3])[1],t3);
t5=C_mutate2(((C_word *)((C_word*)t0)[3])+1,t4);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6492,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[3],a[5]=t1,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:1255: fetch */
t7=((C_word*)t0)[6];
f_6192(t7,t6);}}

/* k2959 in socket? in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2961(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2961,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_eqp(lf[30],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* directory? in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2963(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(3,c,4))){C_save_and_reclaim((void *)f_2963,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2971,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:301: file-type */
t4=*((C_word*)lf[23]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
av2[4]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* f_3833 in k3864 in k3861 in k3858 in k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3833(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3833,2,av);}
t2=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_SCHEME_TRUE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k3402 in k3319 in create-directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3404(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_3404,2,av);}
t2=C_mkdir(t1);
t3=C_eqp(C_fix(0),t2);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
/* posix-common.scm:450: posix-error */
t4=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[8];
av2[3]=lf[79];
av2[4]=lf[80];
av2[5]=((C_word*)t0)[3];
f_2696(6,av2);}}}

/* symbolic-link? in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2913(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(3,c,4))){C_save_and_reclaim((void *)f_2913,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2921,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:286: file-type */
t4=*((C_word*)lf[23]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=C_SCHEME_TRUE;
av2[4]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* k2909 in regular-file? in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2911(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2911,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_eqp(lf[24],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* file-write in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4512(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +6,c,5))){
C_save_and_reclaim((void*)f_4512,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+6);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
t5=C_i_check_exact_2(t2,lf[177]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4519,a[2]=t2,a[3]=t3,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_blockp(t3))){
if(C_truep(C_byteblockp(t3))){
t7=t6;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t7;
av2[1]=C_SCHEME_UNDEFINED;
f_4519(2,av2);}}
else{
/* posixunix.scm:540: ##sys#signal-hook */
t7=*((C_word*)lf[1]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t7;
av2[1]=t6;
av2[2]=lf[13];
av2[3]=lf[177];
av2[4]=lf[179];
av2[5]=t3;
((C_proc)(void*)(*((C_word*)t7+1)))(6,av2);}}}
else{
/* posixunix.scm:540: ##sys#signal-hook */
t7=*((C_word*)lf[1]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t7;
av2[1]=t6;
av2[2]=lf[13];
av2[3]=lf[177];
av2[4]=lf[179];
av2[5]=t3;
((C_proc)(void*)(*((C_word*)t7+1)))(6,av2);}}}

/* file-control in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4375(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +0,c,6))){
C_save_and_reclaim((void*)f_4375,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+0);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
t5=C_i_nullp(t4);
t6=(C_truep(t5)?C_fix(0):C_i_car(t4));
t7=C_i_check_exact_2(t2,lf[167]);
t8=C_i_check_exact_2(t3,lf[167]);
t9=t2;
t10=t3;
t11=C_i_foreign_fixnum_argumentp(t9);
t12=C_i_foreign_fixnum_argumentp(t10);
t13=C_i_foreign_integer_argumentp(t6);
t14=stub774(C_SCHEME_UNDEFINED,t11,t12,t13);
t15=C_eqp(t14,C_fix(-1));
if(C_truep(t15)){
/* posixunix.scm:499: posix-error */
t16=lf[0];{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t16;
av2[1]=t1;
av2[2]=lf[8];
av2[3]=lf[167];
av2[4]=lf[168];
av2[5]=t2;
av2[6]=t3;
f_2696(7,av2);}}
else{
t16=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t16;
av2[1]=t14;
((C_proc)(void*)(*((C_word*)t16+1)))(2,av2);}}}

/* k4517 in file-write in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4519(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,2))){C_save_and_reclaim((void *)f_4519,2,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4522,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(((C_word*)t0)[5]))){
t3=((C_word*)t0)[5];
t4=t2;
f_4522(t4,C_u_i_car(t3));}
else{
t3=t2;
f_4522(t3,C_block_size(((C_word*)t0)[3]));}}

/* k3806 in k3707 in k3698 in loop in k3683 in k3676 in k3673 in k3864 in k3861 in k3858 in k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3808(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,4))){C_save_and_reclaim((void *)f_3808,2,av);}
a=C_alloc(6);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3815,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:548: action */
t3=((C_word*)t0)[6];{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[7];
av2[3]=((C_word*)t0)[8];
((C_proc)C_fast_retrieve_proc(t3))(4,av2);}}
else{
/* posix-common.scm:549: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3687(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[8]);}}

/* k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5957(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word *a;
if(!C_demand(C_calculate_demand(186,c,9))){C_save_and_reclaim((void *)f_5957,2,av);}
a=C_alloc(186);
t2=t1;
t3=C_mutate2((C_word*)lf[319]+1 /* (set! ##sys#read-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5958,a[2]=t2,a[3]=((C_word)li134),tmp=(C_word)a,a+=4,tmp));
t4=C_mutate2((C_word*)lf[322]+1 /* (set! read-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5977,a[2]=((C_word)li138),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate2((C_word*)lf[328]+1 /* (set! file-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6098,a[2]=((C_word)li139),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate2((C_word*)lf[331]+1 /* (set! ##sys#custom-input-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6120,a[2]=((C_word)li154),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate2((C_word*)lf[345]+1 /* (set! ##sys#custom-output-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6643,a[2]=((C_word)li163),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate2((C_word*)lf[349]+1 /* (set! file-truncate ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6904,a[2]=((C_word)li164),tmp=(C_word)a,a+=3,tmp));
t9=C_SCHEME_UNDEFINED;
t10=(*a=C_VECTOR_TYPE|1,a[1]=t9,tmp=(C_word)a,a+=2,tmp);
t11=C_SCHEME_UNDEFINED;
t12=(*a=C_VECTOR_TYPE|1,a[1]=t11,tmp=(C_word)a,a+=2,tmp);
t13=C_set_block_item(t10,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6939,a[2]=((C_word)li165),tmp=(C_word)a,a+=3,tmp));
t14=C_set_block_item(t12,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7003,a[2]=((C_word)li166),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate2((C_word*)lf[353]+1 /* (set! file-lock ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7021,a[2]=t12,a[3]=t10,a[4]=((C_word)li167),tmp=(C_word)a,a+=5,tmp));
t16=C_mutate2((C_word*)lf[355]+1 /* (set! file-lock/blocking ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7037,a[2]=t12,a[3]=t10,a[4]=((C_word)li168),tmp=(C_word)a,a+=5,tmp));
t17=C_mutate2((C_word*)lf[357]+1 /* (set! file-test-lock ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7053,a[2]=t12,a[3]=t10,a[4]=((C_word)li169),tmp=(C_word)a,a+=5,tmp));
t18=C_mutate2((C_word*)lf[359]+1 /* (set! file-unlock ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7080,a[2]=((C_word)li170),tmp=(C_word)a,a+=3,tmp));
t19=C_mutate2((C_word*)lf[361]+1 /* (set! create-fifo ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7108,a[2]=((C_word)li171),tmp=(C_word)a,a+=3,tmp));
t20=C_mutate2((C_word*)lf[35]+1 /* (set! fifo? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7145,a[2]=((C_word)li172),tmp=(C_word)a,a+=3,tmp));
t21=C_mutate2((C_word*)lf[365]+1 /* (set! prot/read ...) */,C_fix((C_word)PROT_READ));
t22=C_mutate2((C_word*)lf[366]+1 /* (set! prot/write ...) */,C_fix((C_word)PROT_WRITE));
t23=C_mutate2((C_word*)lf[367]+1 /* (set! prot/exec ...) */,C_fix((C_word)PROT_EXEC));
t24=C_mutate2((C_word*)lf[368]+1 /* (set! prot/none ...) */,C_fix((C_word)PROT_NONE));
t25=C_mutate2((C_word*)lf[369]+1 /* (set! map/fixed ...) */,C_fix((C_word)MAP_FIXED));
t26=C_mutate2((C_word*)lf[370]+1 /* (set! map/shared ...) */,C_fix((C_word)MAP_SHARED));
t27=C_mutate2((C_word*)lf[371]+1 /* (set! map/private ...) */,C_fix((C_word)MAP_PRIVATE));
t28=C_mutate2((C_word*)lf[372]+1 /* (set! map/anonymous ...) */,C_fix((C_word)MAP_ANON));
t29=C_mutate2((C_word*)lf[373]+1 /* (set! map/file ...) */,C_fix((C_word)MAP_FILE));
t30=C_mutate2((C_word*)lf[374]+1 /* (set! map-file-to-memory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7223,a[2]=((C_word)li173),tmp=(C_word)a,a+=3,tmp));
t31=C_mutate2((C_word*)lf[380]+1 /* (set! unmap-file-from-memory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7283,a[2]=((C_word)li174),tmp=(C_word)a,a+=3,tmp));
t32=C_mutate2((C_word*)lf[382]+1 /* (set! memory-mapped-file-pointer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7316,a[2]=((C_word)li175),tmp=(C_word)a,a+=3,tmp));
t33=C_mutate2((C_word*)lf[383]+1 /* (set! memory-mapped-file? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7325,a[2]=((C_word)li176),tmp=(C_word)a,a+=3,tmp));
t34=C_fix((C_word)sizeof(struct tm));
t35=C_mutate2((C_word*)lf[384]+1 /* (set! string->time ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7340,a[2]=t34,a[3]=((C_word)li177),tmp=(C_word)a,a+=4,tmp));
t36=C_fix((C_word)sizeof(struct tm));
t37=C_mutate2((C_word*)lf[386]+1 /* (set! utc-time->seconds ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7377,a[2]=t36,a[3]=((C_word)li178),tmp=(C_word)a,a+=4,tmp));
t38=C_mutate2((C_word*)lf[388]+1 /* (set! local-timezone-abbreviation ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7396,a[2]=((C_word)li179),tmp=(C_word)a,a+=3,tmp));
t39=C_mutate2((C_word*)lf[389]+1 /* (set! _exit ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7409,a[2]=((C_word)li180),tmp=(C_word)a,a+=3,tmp));
t40=C_mutate2((C_word*)lf[390]+1 /* (set! set-alarm! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7423,a[2]=((C_word)li181),tmp=(C_word)a,a+=3,tmp));
t41=C_mutate2((C_word*)lf[391]+1 /* (set! set-buffering-mode! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7430,a[2]=((C_word)li182),tmp=(C_word)a,a+=3,tmp));
t42=C_mutate2((C_word*)lf[398]+1 /* (set! terminal-port? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7493,a[2]=((C_word)li183),tmp=(C_word)a,a+=3,tmp));
t43=C_mutate2(&lf[399] /* (set! ##sys#terminal-check ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7511,a[2]=((C_word)li184),tmp=(C_word)a,a+=3,tmp));
t44=C_mutate2((C_word*)lf[401]+1 /* (set! terminal-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7542,a[2]=((C_word)li185),tmp=(C_word)a,a+=3,tmp));
t45=C_mutate2((C_word*)lf[402]+1 /* (set! terminal-size ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7566,a[2]=((C_word)li186),tmp=(C_word)a,a+=3,tmp));
t46=C_mutate2((C_word*)lf[407]+1 /* (set! get-host-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7603,a[2]=((C_word)li187),tmp=(C_word)a,a+=3,tmp));
t47=C_mutate2((C_word*)lf[409]+1 /* (set! process-fork ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7617,a[2]=((C_word)li190),tmp=(C_word)a,a+=3,tmp));
t48=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7710,a[2]=((C_word)li191),tmp=(C_word)a,a+=3,tmp);
t49=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7733,a[2]=((C_word)li192),tmp=(C_word)a,a+=3,tmp);
t50=*((C_word*)lf[413]+1);
t51=C_mutate2((C_word*)lf[414]+1 /* (set! process-execute ...) */,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7756,a[2]=t49,a[3]=t48,a[4]=t50,a[5]=((C_word)li195),tmp=(C_word)a,a+=6,tmp));
t52=C_mutate2((C_word*)lf[126]+1 /* (set! ##sys#process-wait ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7912,a[2]=((C_word)li197),tmp=(C_word)a,a+=3,tmp));
t53=C_mutate2((C_word*)lf[416]+1 /* (set! parent-process-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7950,a[2]=((C_word)li198),tmp=(C_word)a,a+=3,tmp));
t54=C_mutate2((C_word*)lf[417]+1 /* (set! sleep ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7953,a[2]=((C_word)li199),tmp=(C_word)a,a+=3,tmp));
t55=C_mutate2((C_word*)lf[418]+1 /* (set! process-signal ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7960,a[2]=((C_word)li200),tmp=(C_word)a,a+=3,tmp));
t56=C_mutate2((C_word*)lf[420]+1 /* (set! ##sys#shell-command ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7985,a[2]=((C_word)li201),tmp=(C_word)a,a+=3,tmp));
t57=C_mutate2((C_word*)lf[424]+1 /* (set! ##sys#shell-command-arguments ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7994,a[2]=((C_word)li202),tmp=(C_word)a,a+=3,tmp));
t58=C_mutate2((C_word*)lf[426]+1 /* (set! process-run ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8000,a[2]=((C_word)li203),tmp=(C_word)a,a+=3,tmp));
t59=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8054,a[2]=((C_word)li207),tmp=(C_word)a,a+=3,tmp);
t60=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8091,a[2]=((C_word)li210),tmp=(C_word)a,a+=3,tmp);
t61=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8111,a[2]=((C_word)li211),tmp=(C_word)a,a+=3,tmp);
t62=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8123,a[2]=((C_word)li212),tmp=(C_word)a,a+=3,tmp);
t63=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8138,a[2]=((C_word)li213),tmp=(C_word)a,a+=3,tmp);
t64=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8152,a[2]=t63,a[3]=t62,a[4]=t60,a[5]=((C_word)li215),tmp=(C_word)a,a+=6,tmp);
t65=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8197,a[2]=t61,a[3]=((C_word)li216),tmp=(C_word)a,a+=4,tmp);
t66=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8208,a[2]=t61,a[3]=((C_word)li217),tmp=(C_word)a,a+=4,tmp);
t67=C_mutate2((C_word*)lf[428]+1 /* (set! ##sys#process ...) */,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_8219,a[2]=t64,a[3]=t65,a[4]=t59,a[5]=t66,a[6]=((C_word)li220),tmp=(C_word)a,a+=7,tmp));
t68=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8275,a[2]=((C_word)li225),tmp=(C_word)a,a+=3,tmp);
t69=C_mutate2((C_word*)lf[429]+1 /* (set! process ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8346,a[2]=t68,a[3]=((C_word)li227),tmp=(C_word)a,a+=4,tmp));
t70=C_mutate2((C_word*)lf[430]+1 /* (set! process* ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8394,a[2]=t68,a[3]=((C_word)li228),tmp=(C_word)a,a+=4,tmp));
t71=C_mutate2((C_word*)lf[432]+1 /* (set! set-root-directory! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8449,a[2]=((C_word)li229),tmp=(C_word)a,a+=3,tmp));
t72=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t72;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t72+1)))(2,av2);}}

/* ##sys#read-symbolic-link in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5958(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand(6,c,3))){C_save_and_reclaim((void *)f_5958,4,av);}
a=C_alloc(6);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5963,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t3,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1117: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=t3;
tp(4,av2);}}

/* regular-file? in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2903(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(3,c,4))){C_save_and_reclaim((void *)f_2903,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2911,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:283: file-type */
t4=*((C_word*)lf[23]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
av2[4]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* k3813 in k3806 in k3707 in k3698 in loop in k3683 in k3676 in k3673 in k3864 in k3861 in k3858 in k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 in ... */
static void C_ccall f_3815(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_3815,2,av);}
/* posix-common.scm:548: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3687(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],t1);}

/* k5951 in k5947 in create-symbolic-link in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5953(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,6))){C_save_and_reclaim((void *)f_5953,2,av);}
t2=C_symlink(((C_word*)t0)[2],t1);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1108: posix-error */
t3=lf[0];{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[8];
av2[3]=lf[317];
av2[4]=lf[318];
av2[5]=((C_word*)t0)[4];
av2[6]=((C_word*)t0)[5];
f_2696(7,av2);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k2929 in block-device? in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2931(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2931,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_eqp(lf[28],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* character-device? in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2933(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(3,c,4))){C_save_and_reclaim((void *)f_2933,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2941,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:292: file-type */
t4=*((C_word*)lf[23]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
av2[4]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* k5961 in read-symbolic-link in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5963(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_5963,2,av);}
t2=C_do_readlink(t1,((C_word*)t0)[2]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1119: posix-error */
t3=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[8];
av2[3]=((C_word*)t0)[4];
av2[4]=lf[320];
av2[5]=((C_word*)t0)[5];
f_2696(6,av2);}}
else{
/* posixunix.scm:1120: substring */
t3=*((C_word*)lf[321]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[2];
av2[3]=C_fix(0);
av2[4]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}}

/* fifo? in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7145(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_7145,3,av);}
a=C_alloc(4);
t3=C_i_check_string_2(t2,lf[35]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7153,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1408: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[35];
tp(4,av2);}}

/* chkstrlst in %process in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_8277(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(8,0,2))){
C_save_and_reclaim_args((void *)trf_8277,3,t0,t1,t2);}
a=C_alloc(8);
t3=C_i_check_list_2(t2,((C_word*)t0)[2]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8282,a[2]=((C_word*)t0)[2],a[3]=((C_word)li221),tmp=(C_word)a,a+=4,tmp);
t5=t2;
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8291,a[2]=t4,a[3]=((C_word)li222),tmp=(C_word)a,a+=4,tmp);
t7=t1;{
C_word av2[2];
av2[0]=t7;
av2[1]=f_8291(t6,t5);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* %process in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_8275(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
if(!C_demand(C_calculate_demand(23,0,3))){
C_save_and_reclaim_args((void *)trf_8275,7,t1,t2,t3,t4,t5,t6,t7);}
a=C_alloc(23);
t8=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t9=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t10=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8277,a[2]=t2,a[3]=((C_word)li223),tmp=(C_word)a,a+=4,tmp);
t11=C_i_check_string_2(((C_word*)t8)[1],t2);
t12=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_8318,a[2]=t2,a[3]=t8,a[4]=t9,a[5]=t6,a[6]=t3,a[7]=t1,a[8]=t7,a[9]=t10,tmp=(C_word)a,a+=10,tmp);
if(C_truep(((C_word*)t9)[1])){
/* posixunix.scm:1783: chkstrlst */
t13=t10;
f_8277(t13,t12,((C_word*)t9)[1]);}
else{
t13=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8340,a[2]=t9,a[3]=t8,a[4]=t12,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1785: ##sys#shell-command-arguments */
t14=*((C_word*)lf[424]+1);{
C_word av2[3];
av2[0]=t14;
av2[1]=t13;
av2[2]=((C_word*)t8)[1];
((C_proc)(void*)(*((C_word*)t14+1)))(3,av2);}}}

/* k4526 in k4520 in k4517 in file-write in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4528(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_4528,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k4520 in k4517 in file-write in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_4522(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(4,0,6))){
C_save_and_reclaim_args((void *)trf_4522,2,t0,t1);}
a=C_alloc(4);
t2=C_i_check_exact_2(t1,lf[177]);
t3=C_write(((C_word*)t0)[2],((C_word*)t0)[3],t1);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4528,a[2]=((C_word*)t0)[4],a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=C_eqp(C_fix(-1),t3);
if(C_truep(t5)){
/* posixunix.scm:545: posix-error */
t6=lf[0];{
C_word av2[7];
av2[0]=t6;
av2[1]=t4;
av2[2]=lf[8];
av2[3]=lf[177];
av2[4]=lf[178];
av2[5]=((C_word*)t0)[2];
av2[6]=t1;
f_2696(7,av2);}}
else{
t6=((C_word*)t0)[4];{
C_word av2[2];
av2[0]=t6;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* scan in k4161 in loop in get-environment-variables in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_4171(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
loop:
if(!C_demand(C_calculate_demand(7,0,4))){
C_save_and_reclaim_args((void *)trf_4171,3,t0,t1,t2);}
a=C_alloc(7);
t3=C_subchar(((C_word*)t0)[2],t2);
if(C_truep(C_i_char_equalp(C_make_character(61),t3))){
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4197,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[2],tmp=(C_word)a,a+=7,tmp);
/* posix-common.scm:647: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[70]+1));
C_word av2[5];
av2[0]=*((C_word*)lf[70]+1);
av2[1]=t4;
av2[2]=((C_word*)t0)[2];
av2[3]=C_fix(0);
av2[4]=t2;
tp(5,av2);}}
else{
t4=C_fixnum_plus(t2,C_fix(1));
/* posix-common.scm:650: scan */
t6=t1;
t7=t4;
t1=t6;
t2=t7;
goto loop;}}

/* k2949 */
static void C_ccall f_2951(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2951,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_eqp(lf[29],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k7130 in k7113 in create-fifo in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7132(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,6))){C_save_and_reclaim((void *)f_7132,2,av);}
t2=C_mkfifo(t1,((C_word*)t0)[2]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1401: posix-error */
t3=lf[0];{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[8];
av2[3]=lf[361];
av2[4]=lf[362];
av2[5]=((C_word*)t0)[4];
av2[6]=((C_word*)t0)[2];
f_2696(7,av2);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* socket? in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2953(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(3,c,4))){C_save_and_reclaim((void *)f_2953,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2961,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:298: file-type */
t4=*((C_word*)lf[23]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
av2[4]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* k4187 in k4199 in k4195 in scan in k4161 in loop in get-environment-variables in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4189(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,1))){C_save_and_reclaim((void *)f_4189,2,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* g2085 in chkstrlst in %process in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static C_word C_fcall f_8282(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_stack_overflow_check;{}
return(C_i_check_string_2(t1,((C_word*)t0)[2]));}

/* a5997 in read-symbolic-link in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5998(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_5998,5,av);}
a=C_alloc(4);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6006,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
t6=(C_truep(t2)?t2:lf[326]);
if(C_truep(t3)){
/* posixunix.scm:1127: string-append */
t7=*((C_word*)lf[2]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t5;
av2[2]=t6;
av2[3]=t3;
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}
else{
/* posixunix.scm:1127: string-append */
t7=*((C_word*)lf[2]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t5;
av2[2]=t6;
av2[3]=lf[327];
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}}

/* k2939 in character-device? in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2941(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2941,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_eqp(lf[27],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* f_2943 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2943(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(3,c,4))){C_save_and_reclaim((void *)f_2943,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2951,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:295: file-type */
t4=*((C_word*)lf[23]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
av2[4]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* for-each-loop2084 in chkstrlst in %process in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static C_word C_fcall f_8291(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_pairp(t1))){
t2=C_slot(t1,C_fix(0));
t3=f_8282(((C_word*)t0)[2],t2);
t4=C_slot(t1,C_fix(1));
t6=t4;
t1=t6;
goto loop;}
else{
t2=C_SCHEME_UNDEFINED;
return(t2);}}

/* a5991 in read-symbolic-link in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5992(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_5992,2,av);}
/* posixunix.scm:1125: decompose-directory */
t2=*((C_word*)lf[323]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* k2969 in directory? in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2971(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2971,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_eqp(lf[26],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* set-file-position! in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2976(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +5,c,2))){
C_save_and_reclaim((void*)f_2976,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+5);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2980,a[2]=t3,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(t4))){
t6=t4;
t7=t5;
f_2980(t7,C_u_i_car(t6));}
else{
t6=t5;
f_2980(t6,C_fix((C_word)SEEK_SET));}}

/* k4139 in unsetenv in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4141(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_4141,2,av);}
t2=C_unsetenv(t1);
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k4195 in scan in k4161 in loop in get-environment-variables in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4197(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,4))){C_save_and_reclaim((void *)f_4197,2,av);}
a=C_alloc(6);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4201,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=C_fixnum_plus(((C_word*)t0)[5],C_fix(1));
t5=C_block_size(((C_word*)t0)[6]);
/* posix-common.scm:648: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[70]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[70]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[6];
av2[3]=t4;
av2[4]=t5;
tp(5,av2);}}

/* k4129 in k4125 in setenv in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4131(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_4131,2,av);}
t2=C_setenv(((C_word*)t0)[2],t1);
t3=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* unsetenv in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4133(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(3,c,3))){C_save_and_reclaim((void *)f_4133,3,av);}
a=C_alloc(3);
t3=C_i_check_string_2(t2,lf[119]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4141,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:636: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[119];
tp(4,av2);}}

/* file-truncate in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6904(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand(12,c,4))){C_save_and_reclaim((void *)f_6904,4,av);}
a=C_alloc(12);
t4=C_i_check_number_2(t3,lf[349]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6914,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6921,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_stringp(t2))){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6928,a[2]=t3,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1341: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t7;
av2[2]=t2;
av2[3]=lf[349];
tp(4,av2);}}
else{
if(C_truep(C_fixnump(t2))){
t7=C_ftruncate(t2,t3);
t8=t5;
f_6914(t8,C_fixnum_lessp(t7,C_fix(0)));}
else{
/* posixunix.scm:1343: ##sys#error */
t7=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t7;
av2[1]=t6;
av2[2]=lf[349];
av2[3]=lf[351];
av2[4]=t2;
((C_proc)(void*)(*((C_word*)t7+1)))(5,av2);}}}}

/* k6912 in file-truncate in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_6914(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,0,6))){
C_save_and_reclaim_args((void *)trf_6914,2,t0,t1);}
if(C_truep(t1)){
/* posixunix.scm:1345: posix-error */
t2=lf[0];{
C_word av2[7];
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[8];
av2[3]=lf[349];
av2[4]=lf[350];
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[4];
f_2696(7,av2);}}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k7288 in unmap-file-from-memory in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_7290(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(0,0,6))){
C_save_and_reclaim_args((void *)trf_7290,2,t0,t1);}
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=(C_truep(t2)?C_i_foreign_pointer_argumentp(t2):C_SCHEME_FALSE);
t4=C_i_foreign_integer_argumentp(t1);
t5=stub1704(C_SCHEME_UNDEFINED,t3,t4);
t6=C_eqp(C_fix(0),t5);
if(C_truep(t6)){
t7=C_SCHEME_UNDEFINED;
t8=((C_word*)t0)[3];{
C_word av2[2];
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
/* posixunix.scm:1460: posix-error */
t7=lf[0];{
C_word av2[7];
av2[0]=t7;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[8];
av2[3]=lf[380];
av2[4]=lf[381];
av2[5]=((C_word*)t0)[2];
av2[6]=t1;
f_2696(7,av2);}}}

/* k2919 in symbolic-link? in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2921(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2921,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_eqp(lf[25],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* block-device? in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2923(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(3,c,4))){C_save_and_reclaim((void *)f_2923,3,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2931,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:289: file-type */
t4=*((C_word*)lf[23]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
av2[4]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* k5947 in create-symbolic-link in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5949(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,3))){C_save_and_reclaim((void *)f_5949,2,av);}
a=C_alloc(6);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5953,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1106: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
av2[3]=lf[316];
tp(4,av2);}}

/* k4106 in k4059 in time->string in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4108(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,3))){C_save_and_reclaim((void *)f_4108,2,av);}
a=C_alloc(5);
t2=((C_word*)t0)[2];
t3=C_a_i_bytevector(&a,1,C_fix(3));
if(C_truep(t1)){
t4=C_i_foreign_block_argumentp(t1);
t5=stub583(t3,t2,t4);
/* posix-common.scm:609: ##sys#peek-c-string */
t6=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t6;
av2[1]=((C_word*)t0)[3];
av2[2]=t5;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}
else{
t4=stub583(t3,t2,C_SCHEME_FALSE);
/* posix-common.scm:609: ##sys#peek-c-string */
t5=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=((C_word*)t0)[3];
av2[2]=t4;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}}

/* output-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_8208(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(6,0,3))){
C_save_and_reclaim_args((void *)trf_8208,7,t0,t1,t2,t3,t4,t5,t6);}
a=C_alloc(6);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8212,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t6,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1752: connect-parent */
f_8111(t7,t4,t5);}

/* k8199 in input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8201(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,7))){C_save_and_reclaim((void *)f_8201,2,av);}
if(C_truep(t1)){
/* posixunix.scm:1749: ##sys#custom-input-port */
t2=*((C_word*)lf[331]+1);{
C_word *av2;
if(c >= 8) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(8);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
av2[4]=t1;
av2[5]=C_SCHEME_TRUE;
av2[6]=C_fix(256);
av2[7]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t2+1)))(8,av2);}}
else{
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k3676 in k3673 in k3864 in k3861 in k3858 in k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_3678(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(11,0,3))){
C_save_and_reclaim_args((void *)trf_3678,2,t0,t1);}
a=C_alloc(11);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_3685,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
/* posix-common.scm:529: directory */
t4=*((C_word*)lf[26]+1);{
C_word av2[4];
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[8];
av2[3]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k3673 in k3864 in k3861 in k3858 in k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_3675(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(13,0,2))){
C_save_and_reclaim_args((void *)trf_3675,2,t0,t1);}
a=C_alloc(13);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3678,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],tmp=(C_word)a,a+=10,tmp);
if(C_truep(C_i_closurep(((C_word*)t0)[9]))){
t4=t3;
f_3678(t4,((C_word*)t0)[9]);}
else{
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3824,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:526: irregex */
t5=*((C_word*)lf[96]+1);{
C_word av2[3];
av2[0]=t5;
av2[1]=t4;
av2[2]=((C_word*)t0)[9];
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}}

/* k5917 in create-session in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5919(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_5919,2,av);}
/* posixunix.scm:1076: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[313];
av2[3]=lf[314];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k4125 in setenv in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4127(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_4127,2,av);}
a=C_alloc(4);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4131,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:631: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[3];
av2[3]=lf[118];
tp(4,av2);}}

/* k8210 in output-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8212(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,7))){C_save_and_reclaim((void *)f_8212,2,av);}
if(C_truep(t1)){
/* posixunix.scm:1753: ##sys#custom-output-port */
t2=*((C_word*)lf[345]+1);{
C_word *av2;
if(c >= 8) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(8);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
av2[4]=t1;
av2[5]=C_SCHEME_TRUE;
av2[6]=C_fix(0);
av2[7]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t2+1)))(8,av2);}}
else{
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* ##sys#process in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8219(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6=av[6];
C_word t7=av[7];
C_word t8=av[8];
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(c!=9) C_bad_argc_2(c,9,t0);
if(!C_demand(C_calculate_demand(21,c,6))){C_save_and_reclaim((void *)f_8219,9,av);}
a=C_alloc(21);
t9=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_8225,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=t4,a[5]=t5,a[6]=t6,a[7]=t7,a[8]=t8,a[9]=((C_word)li218),tmp=(C_word)a,a+=10,tmp);
t10=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_8231,a[2]=t7,a[3]=t6,a[4]=t8,a[5]=((C_word*)t0)[3],a[6]=t2,a[7]=t3,a[8]=((C_word*)t0)[4],a[9]=((C_word*)t0)[5],a[10]=((C_word)li219),tmp=(C_word)a,a+=11,tmp);
/* posixunix.scm:1696: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t9;
av2[3]=t10;
C_call_with_values(4,av2);}}

/* loop in k3683 in k3676 in k3673 in k3864 in k3861 in k3858 in k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_3687(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(14,0,3))){
C_save_and_reclaim_args((void *)trf_3687,5,t0,t1,t2,t3,t4);}
a=C_alloc(14);
if(C_truep(C_i_nullp(t3))){
t5=t4;
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t5=C_slot(t3,C_fix(0));
t6=t5;
t7=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_3700,a[2]=t3,a[3]=t6,a[4]=((C_word*)t0)[2],a[5]=t1,a[6]=t2,a[7]=t4,a[8]=((C_word*)t0)[3],a[9]=((C_word*)t0)[4],a[10]=((C_word*)t0)[5],a[11]=((C_word*)t0)[6],a[12]=((C_word*)t0)[7],a[13]=((C_word*)t0)[8],tmp=(C_word)a,a+=14,tmp);
/* posix-common.scm:534: make-pathname */
t8=*((C_word*)lf[83]+1);{
C_word av2[4];
av2[0]=t8;
av2[1]=t7;
av2[2]=t2;
av2[3]=t6;
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}}

/* k3683 in k3676 in k3673 in k3864 in k3861 in k3858 in k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3685(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(12,c,5))){C_save_and_reclaim((void *)f_3685,2,av);}
a=C_alloc(12);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3687,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word)li43),tmp=(C_word)a,a+=10,tmp));
t5=((C_word*)t3)[1];
f_3687(t5,((C_word*)t0)[8],((C_word*)t0)[9],t1,((C_word*)t0)[10]);}

/* k5911 in create-session in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5913(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_5913,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5926(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,4))){C_save_and_reclaim((void *)f_5926,2,av);}
a=C_alloc(6);
t2=C_mutate2((C_word*)lf[315]+1 /* (set! process-group-id ...) */,t1);
t3=C_mutate2((C_word*)lf[316]+1 /* (set! create-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5928,a[2]=((C_word)li133),tmp=(C_word)a,a+=3,tmp));
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5957,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t5=C_fixnum_plus(C_fix((C_word)FILENAME_MAX),C_fix(1));
/* ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[72]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[72]+1);
av2[1]=t4;
av2[2]=t5;
av2[3]=C_make_character(32);
tp(4,av2);}}

/* create-symbolic-link in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5928(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand(5,c,3))){C_save_and_reclaim((void *)f_5928,4,av);}
a=C_alloc(5);
t4=C_i_check_string_2(t2,lf[316]);
t5=C_i_check_string_2(t3,lf[316]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5949,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1105: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t6;
av2[2]=t2;
av2[3]=lf[316];
tp(4,av2);}}

/* setenv in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4116(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_4116,4,av);}
a=C_alloc(4);
t4=C_i_check_string_2(t2,lf[118]);
t5=C_i_check_string_2(t3,lf[118]);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4127,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:631: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t6;
av2[2]=t2;
av2[3]=lf[118];
tp(4,av2);}}

/* a8224 in process in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8225(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,7))){C_save_and_reclaim((void *)f_8225,2,av);}
/* posixunix.scm:1756: spawn */
t2=((C_word*)t0)[2];
f_8152(t2,t1,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],((C_word*)t0)[7],((C_word*)t0)[8]);}

/* k5647 in loop in k5627 in k5624 in k5621 in get-groups in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5649(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(3,c,1))){C_save_and_reclaim((void *)f_5649,2,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* read-symbolic-link in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5977(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +7,c,5))){
C_save_and_reclaim((void*)f_5977,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+7);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=C_i_check_string_2(t2,lf[322]);
if(C_truep(t5)){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5992,a[2]=t2,a[3]=((C_word)li135),tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5998,a[2]=((C_word)li137),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1125: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t7;
av2[3]=t8;
C_call_with_values(4,av2);}}
else{
/* posixunix.scm:1140: ##sys#read-symbolic-link */
t7=*((C_word*)lf[319]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[322];
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}}

/* k5657 in k5624 in k5621 in get-groups in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5659(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_5659,2,av);}
/* posixunix.scm:969: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[258];
av2[3]=lf[259];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* a8230 in process in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8231(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(!C_demand(C_calculate_demand(26,c,7))){C_save_and_reclaim((void *)f_8231,6,av);}
a=C_alloc(26);
t6=C_i_not(((C_word*)t0)[2]);
t7=C_i_not(((C_word*)t0)[3]);
t8=C_i_not(((C_word*)t0)[4]);
t9=C_a_i_vector3(&a,3,t6,t7,t8);
t10=t9;
t11=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_8242,a[2]=t1,a[3]=t5,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=t4,a[8]=((C_word*)t0)[4],a[9]=((C_word*)t0)[8],a[10]=t10,a[11]=((C_word*)t0)[9],a[12]=t3,a[13]=((C_word*)t0)[3],tmp=(C_word)a,a+=14,tmp);
t12=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_8262,a[2]=((C_word*)t0)[5],a[3]=t11,a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=t2,a[7]=((C_word*)t0)[2],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1763: make-on-close */
f_8054(t12,((C_word*)t0)[6],t5,t10,C_fix(0),C_fix(1),C_fix(2));}

/* k8240 in a8230 in process in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8242(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(20,c,7))){C_save_and_reclaim((void *)f_8242,2,av);}
a=C_alloc(20);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_8246,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[10],tmp=(C_word)a,a+=12,tmp);
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_8258,a[2]=((C_word*)t0)[11],a[3]=t3,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[12],a[7]=((C_word*)t0)[13],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1765: make-on-close */
f_8054(t4,((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[10],C_fix(1),C_fix(0),C_fix(2));}

/* k8244 in k8240 in a8230 in process in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8246(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(14,c,7))){C_save_and_reclaim((void *)f_8246,2,av);}
a=C_alloc(14);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8250,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_8254,a[2]=((C_word*)t0)[5],a[3]=t3,a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1768: make-on-close */
f_8054(t4,((C_word*)t0)[6],((C_word*)t0)[4],((C_word*)t0)[11],C_fix(2),C_fix(0),C_fix(1));}

/* k4423 in k4410 in file-open in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4425(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,7))){C_save_and_reclaim((void *)f_4425,2,av);}
a=C_alloc(4);
t2=C_open(t1,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4428,a[2]=((C_word*)t0)[4],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm:511: posix-error */
t5=lf[0];{
C_word *av2;
if(c >= 8) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(8);
}
av2[0]=t5;
av2[1]=t3;
av2[2]=lf[8];
av2[3]=lf[169];
av2[4]=lf[170];
av2[5]=((C_word*)t0)[5];
av2[6]=((C_word*)t0)[2];
av2[7]=((C_word*)t0)[3];
f_2696(8,av2);}}
else{
t5=((C_word*)t0)[4];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k4426 in k4423 in k4410 in file-open in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4428(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_4428,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k8256 in k8240 in a8230 in process in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8258(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,6))){C_save_and_reclaim((void *)f_8258,2,av);}
/* posixunix.scm:1764: output-port */
t2=((C_word*)t0)[2];
f_8208(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],((C_word*)t0)[7],t1);}

/* k8252 in k8244 in k8240 in a8230 in process in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8254(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,6))){C_save_and_reclaim((void *)f_8254,2,av);}
/* posixunix.scm:1767: input-port */
t2=((C_word*)t0)[2];
f_8197(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],((C_word*)t0)[7],t1);}

/* create-directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3305(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +10,c,2))){
C_save_and_reclaim((void*)f_3305,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+10);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_i_car(t3));
t6=t5;
t7=C_i_check_string_2(t2,lf[79]);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3315,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t9=C_block_size(t2);
t10=C_eqp(C_fix(0),t9);
t11=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3321,a[2]=t1,a[3]=t2,a[4]=t6,a[5]=t8,tmp=(C_word)a,a+=6,tmp);
if(C_truep(t10)){
t12=t11;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t12;
av2[1]=t10;
f_3321(2,av2);}}
else{
/* posix-common.scm:456: file-exists? */
t12=*((C_word*)lf[84]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t12;
av2[1]=t11;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t12+1)))(3,av2);}}}

/* k5676 in get-groups in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5678(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_5678,2,av);}
/* posixunix.scm:964: ##sys#error */
t2=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[258];
av2[3]=lf[261];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k8248 in k8244 in k8240 in a8230 in process in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8250(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_8250,2,av);}
/* posixunix.scm:1761: values */{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
av2[4]=((C_word*)t0)[5];
av2[5]=t1;
C_values(6,av2);}}

/* k4410 in file-open in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_4412(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(6,0,3))){
C_save_and_reclaim_args((void *)trf_4412,2,t0,t1);}
a=C_alloc(6);
t2=t1;
t3=C_i_check_string_2(((C_word*)t0)[2],lf[169]);
t4=C_i_check_exact_2(((C_word*)t0)[3],lf[169]);
t5=C_i_check_exact_2(t2,lf[169]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4425,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[2],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:509: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t6;
av2[2]=((C_word*)t0)[2];
av2[3]=lf[169];
tp(4,av2);}}

/* k3313 in create-directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3315(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3315,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k8260 in a8230 in process in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8262(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,6))){C_save_and_reclaim((void *)f_8262,2,av);}
/* posixunix.scm:1762: input-port */
t2=((C_word*)t0)[2];
f_8197(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],((C_word*)t0)[7],t1);}

/* file-open in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4408(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +5,c,2))){
C_save_and_reclaim((void*)f_4408,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+5);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4412,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_pairp(t4))){
t6=t4;
t7=t5;
f_4412(t7,C_u_i_car(t6));}
else{
t6=t5;
f_4412(t6,((C_word*)t0)[2]);}}

/* k3973 in seconds->string in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3975(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_3975,2,av);}
a=C_alloc(9);
t2=t1;
t3=C_i_check_number_2(t2,lf[109]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3981,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_integer_argumentp(t2);
t7=stub554(t5,t6);
/* posix-common.scm:591: ##sys#peek-c-string */
t8=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t8;
av2[1]=t4;
av2[2]=t7;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}

/* seconds->string in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3971(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +3,c,2))){
C_save_and_reclaim((void*)f_3971,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+3);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3975,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
/* posix-common.scm:592: current-seconds */
t4=*((C_word*)lf[107]+1);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=t3;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_i_car(t2);
f_3975(2,av2);}}}

/* k3319 in create-directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3321(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(10,c,5))){C_save_and_reclaim((void *)f_3321,2,av);}
a=C_alloc(10);
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
if(C_truep(((C_word*)t0)[4])){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3331,a[2]=((C_word*)t0)[5],tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3375,a[2]=((C_word*)t0)[3],a[3]=((C_word)li29),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3381,a[2]=((C_word)li30),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:458: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t2;
av2[2]=t3;
av2[3]=t4;
C_call_with_values(4,av2);}}
else{
t2=((C_word*)t0)[5];
t3=((C_word*)t0)[3];
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3404,a[2]=t2,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:449: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t4;
av2[2]=t3;
av2[3]=lf[79];
tp(4,av2);}}}}

/* get-groups in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5619(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(7,c,2))){C_save_and_reclaim((void *)f_5619,2,av);}
a=C_alloc(7);
t2=C_fix((C_word)getgroups(0, C_groups));
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5623,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5678,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:963: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[5]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[5]+1);
av2[1]=t4;
tp(2,av2);}}
else{
t4=t3;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
f_5623(2,av2);}}}

/* unmap-file-from-memory in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7283(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +4,c,2))){
C_save_and_reclaim((void*)f_7283,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+4);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
t4=C_i_check_structure_2(t2,lf[375],lf[380]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7290,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t6=t3;
t7=t5;
f_7290(t7,C_u_i_car(t6));}
else{
t6=t5;
f_7290(t6,C_slot(t2,C_fix(2)));}}

/* k5621 in get-groups in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5623(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_5623,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5626,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
if(C_truep(stub1221(C_SCHEME_UNDEFINED,t3))){
t4=t2;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
f_5626(2,av2);}}
else{
/* posixunix.scm:966: ##sys#error */
t4=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t2;
av2[2]=lf[258];
av2[3]=lf[260];
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}}

/* check-time-vector in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_3900(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(0,0,4))){
C_save_and_reclaim_args((void *)trf_3900,3,t1,t2,t3);}
t4=C_i_check_vector_2(t3,t2);
t5=C_block_size(t3);
if(C_truep(C_fixnum_lessp(t5,C_fix(10)))){
/* posix-common.scm:580: ##sys#error */
t6=*((C_word*)lf[50]+1);{
C_word av2[5];
av2[0]=t6;
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[104];
av2[4]=t3;
((C_proc)(void*)(*((C_word*)t6+1)))(5,av2);}}
else{
t6=C_SCHEME_UNDEFINED;
t7=t1;{
C_word av2[2];
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* k3329 in k3319 in create-directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3331(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,3))){C_save_and_reclaim((void *)f_3331,2,av);}
a=C_alloc(6);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3333,a[2]=t3,a[3]=((C_word)li28),tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_3333(t5,((C_word*)t0)[2],t1);}

/* loop in k3329 in k3319 in create-directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_3333(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(8,0,2))){
C_save_and_reclaim_args((void *)trf_3333,3,t0,t1,t2);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3340,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
if(C_truep(t2)){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3373,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:460: directory? */
t5=*((C_word*)lf[37]+1);{
C_word av2[3];
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}
else{
t4=t3;
f_3340(t4,C_SCHEME_FALSE);}}

/* k5627 in k5624 in k5621 in get-groups in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5629(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(7,c,3))){C_save_and_reclaim((void *)f_5629,2,av);}
a=C_alloc(7);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5634,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word)li121),tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_5634(t5,((C_word*)t0)[3],C_fix(0));}

/* k5624 in k5621 in get-groups in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5626(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(7,c,2))){C_save_and_reclaim((void *)f_5626,2,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5629,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t4=stub1216(C_SCHEME_UNDEFINED,t3);
if(C_truep(C_fixnum_lessp(t4,C_fix(0)))){
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5659,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:968: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[5]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[5]+1);
av2[1]=t5;
tp(2,av2);}}
else{
t5=t2;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=C_SCHEME_UNDEFINED;
f_5629(2,av2);}}}

/* loop in k5627 in k5624 in k5621 in get-groups in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_5634(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
if(!C_demand(C_calculate_demand(4,0,2))){
C_save_and_reclaim_args((void *)trf_5634,3,t0,t1,t2);}
a=C_alloc(4);
if(C_truep(C_fixnum_greater_or_equal_p(t2,((C_word*)t0)[2]))){
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_get_gid(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5649,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=C_fixnum_plus(t2,C_fix(1));
/* posixunix.scm:973: loop */
t7=t4;
t8=t5;
t1=t7;
t2=t8;
goto loop;}}

/* k3338 in loop in k3329 in k3319 in create-directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_3340(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(8,0,2))){
C_save_and_reclaim_args((void *)trf_3340,2,t0,t1);}
a=C_alloc(8);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3343,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3366,a[2]=((C_word*)t0)[4],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:461: pathname-directory */
t4=*((C_word*)lf[81]+1);{
C_word av2[3];
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k3341 in k3338 in loop in k3329 in k3319 in create-directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3343(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_3343,2,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];
t3=((C_word*)t0)[3];
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3359,a[2]=t2,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:449: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t4;
av2[2]=t3;
av2[3]=lf[79];
tp(4,av2);}}

/* seconds->local-time in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3919(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +3,c,3))){
C_save_and_reclaim((void*)f_3919,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+3);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3923,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
/* posix-common.scm:582: current-seconds */
t4=*((C_word*)lf[107]+1);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_i_car(t2);
t5=C_i_check_number_2(t4,lf[105]);
/* posix-common.scm:584: ##sys#decode-seconds */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[106]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[106]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=C_SCHEME_FALSE;
tp(4,av2);}}}

/* set-signal-handler! in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4219(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_4219,4,av);}
t4=C_i_check_exact_2(t2,lf[121]);
if(C_truep(t3)){
t5=t2;
t6=C_establish_signal_handler(t2,t5);
t7=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t7;
av2[1]=C_i_vector_set(*((C_word*)lf[122]+1),t2,t3);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t5=C_establish_signal_handler(t2,C_SCHEME_FALSE);
t6=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t6;
av2[1]=C_i_vector_set(*((C_word*)lf[122]+1),t2,t3);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k3921 in seconds->local-time in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3923(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_3923,2,av);}
t2=C_i_check_number_2(t1,lf[105]);
/* posix-common.scm:584: ##sys#decode-seconds */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[106]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[106]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=C_SCHEME_FALSE;
tp(4,av2);}}

/* k3357 in k3341 in k3338 in loop in k3329 in k3319 in create-directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3359(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_3359,2,av);}
t2=C_mkdir(t1);
t3=C_eqp(C_fix(0),t2);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
/* posix-common.scm:450: posix-error */
t4=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[8];
av2[3]=lf[79];
av2[4]=lf[80];
av2[5]=((C_word*)t0)[3];
f_2696(6,av2);}}}

/* loop in file-close in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4449(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_4449,2,av);}
t2=C_close(((C_word*)t0)[2]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
t3=C_fix((C_word)errno);
if(C_truep(C_i_eqvp(t3,C_fix((C_word)EINTR)))){
/* posixunix.scm:520: ##sys#dispatch-interrupt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[172]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[172]+1);
av2[1]=t1;
av2[2]=((C_word*)((C_word*)t0)[3])[1];
tp(3,av2);}}
else{
/* posixunix.scm:522: posix-error */
t4=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=t1;
av2[2]=lf[8];
av2[3]=lf[171];
av2[4]=lf[173];
av2[5]=((C_word*)t0)[2];
f_2696(6,av2);}}}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* file-close in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4440(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(7,c,2))){C_save_and_reclaim((void *)f_4440,3,av);}
a=C_alloc(7);
t3=C_i_check_exact_2(t2,lf[171]);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4449,a[2]=t2,a[3]=t5,a[4]=((C_word)li76),tmp=(C_word)a,a+=5,tmp));
t7=((C_word*)t5)[1];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t7;
av2[1]=t1;
f_4449(2,av2);}}

/* k4199 in k4195 in scan in k4161 in loop in get-environment-variables in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4201(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(7,c,2))){C_save_and_reclaim((void *)f_4201,2,av);}
a=C_alloc(7);
t2=C_a_i_cons(&a,2,((C_word*)t0)[2],t1);
t3=t2;
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4189,a[2]=((C_word*)t0)[3],a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=C_fixnum_plus(((C_word*)t0)[4],C_fix(1));
/* posix-common.scm:649: loop */
t6=((C_word*)((C_word*)t0)[5])[1];
f_4159(t6,t4,t5);}

/* k3364 in k3338 in loop in k3329 in k3319 in create-directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3366(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_3366,2,av);}
/* posix-common.scm:461: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3333(t2,((C_word*)t0)[3],t1);}

/* create-session in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5909(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(7,c,2))){C_save_and_reclaim((void *)f_5909,2,av);}
a=C_alloc(7);
t2=C_setsid(C_SCHEME_FALSE);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5913,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5919,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1075: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[5]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[5]+1);
av2[1]=t4;
tp(2,av2);}}
else{
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k7794 in doloop1917 in k7779 in k7776 in process-execute in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7796(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(12,c,4))){C_save_and_reclaim((void *)f_7796,2,av);}
a=C_alloc(12);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7799,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[2])){
t3=C_i_check_list_2(((C_word*)t0)[2],lf[414]);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7828,a[2]=((C_word*)t0)[5],a[3]=t5,a[4]=((C_word)li193),tmp=(C_word)a,a+=5,tmp));
t7=((C_word*)t5)[1];
f_7828(t7,t2,((C_word*)t0)[2],C_fix(0));}
else{
t3=t2;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_7799(2,av2);}}}

/* k7797 in k7794 in doloop1917 in k7779 in k7776 in process-execute in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 in ... */
static void C_ccall f_7799(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,3))){C_save_and_reclaim((void *)f_7799,2,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7802,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1620: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=lf[414];
tp(4,av2);}}

/* k3942 in seconds->utc-time in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3944(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_3944,2,av);}
t2=C_i_check_number_2(t1,lf[108]);
/* posix-common.scm:588: ##sys#decode-seconds */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[106]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[106]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=C_SCHEME_TRUE;
tp(4,av2);}}

/* seconds->utc-time in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3940(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +3,c,3))){
C_save_and_reclaim((void*)f_3940,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+3);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3944,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_nullp(t2))){
/* posix-common.scm:586: current-seconds */
t4=*((C_word*)lf[107]+1);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_i_car(t2);
t5=C_i_check_number_2(t4,lf[108]);
/* posix-common.scm:588: ##sys#decode-seconds */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[106]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[106]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=C_SCHEME_TRUE;
tp(4,av2);}}}

/* a4271 in process-wait in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4272(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_4272,5,av);}
t5=C_eqp(t2,C_fix(-1));
if(C_truep(t5)){
/* posix-common.scm:680: posix-error */
t6=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t6;
av2[1]=t1;
av2[2]=lf[127];
av2[3]=lf[125];
av2[4]=lf[128];
av2[5]=((C_word*)t0)[2];
f_2696(6,av2);}}
else{
/* posix-common.scm:681: values */{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=t4;
C_values(5,av2);}}}

/* file-execute-access? in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5903(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_5903,3,av);}
/* posixunix.scm:1070: check */
f_5871(t1,t2,C_fix((C_word)X_OK),lf[312]);}

/* k4161 in loop in get-environment-variables in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4163(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,3))){C_save_and_reclaim((void *)f_4163,2,av);}
a=C_alloc(9);
t2=t1;
if(C_truep(t2)){
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4171,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t4,a[6]=((C_word)li64),tmp=(C_word)a,a+=7,tmp));
t6=((C_word*)t4)[1];
f_4171(t6,((C_word*)t0)[4],C_fix(0));}
else{
t3=((C_word*)t0)[4];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* a4265 in process-wait in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4266(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_4266,2,av);}
/* posix-common.scm:678: ##sys#process-wait */
t2=*((C_word*)lf[126]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
av2[3]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* get-environment-variables in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4153(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(6,c,3))){C_save_and_reclaim((void *)f_4153,2,av);}
a=C_alloc(6);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4159,a[2]=t3,a[3]=((C_word)li65),tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_4159(t5,t1,C_fix(0));}

/* set-groups! in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5683(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_5683,3,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5687,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=C_i_length(t2);
t5=C_i_foreign_fixnum_argumentp(t4);
if(C_truep(stub1221(C_SCHEME_UNDEFINED,t5))){
t6=t3;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t6;
av2[1]=C_SCHEME_UNDEFINED;
f_5687(2,av2);}}
else{
/* posixunix.scm:977: ##sys#error */
t6=*((C_word*)lf[50]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t6;
av2[1]=t3;
av2[2]=lf[262];
av2[3]=lf[264];
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}}

/* k5685 in set-groups! in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5687(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(7,c,4))){C_save_and_reclaim((void *)f_5687,2,av);}
a=C_alloc(7);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5692,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word)li123),tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_5692(t5,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(0));}

/* doloop1237 in k5685 in set-groups! in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_5692(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
loop:
if(!C_demand(C_calculate_demand(4,0,3))){
C_save_and_reclaim_args((void *)trf_5692,4,t0,t1,t2,t3);}
a=C_alloc(4);
if(C_truep(C_i_nullp(t2))){
t4=C_set_groups(t3);
if(C_truep(C_fixnum_lessp(t4,C_fix(0)))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5708,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:982: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[5]+1));
C_word av2[2];
av2[0]=*((C_word*)lf[5]+1);
av2[1]=t5;
tp(2,av2);}}
else{
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}
else{
t4=C_slot(t2,C_fix(0));
t5=C_i_check_exact_2(t4,lf[262]);
t6=C_set_gid(t3,t4);
t7=C_slot(t2,C_fix(1));
t8=C_fixnum_plus(t3,C_fix(1));
t10=t1;
t11=t7;
t12=t8;
t1=t10;
t2=t11;
t3=t12;
goto loop;}}

/* loop in get-environment-variables in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_4159(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(10,0,3))){
C_save_and_reclaim_args((void *)trf_4159,3,t0,t1,t2);}
a=C_alloc(10);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4163,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
t7=stub633(t5,t6);
/* posix-common.scm:640: ##sys#peek-c-string */
t8=*((C_word*)lf[4]+1);{
C_word av2[4];
av2[0]=t8;
av2[1]=t3;
av2[2]=t7;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}

/* process-execute in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7756(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +8,c,2))){
C_save_and_reclaim((void*)f_7756,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+8);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
t4=C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_END_OF_LIST:C_i_car(t3));
t6=t5;
t7=C_i_nullp(t3);
t8=(C_truep(t7)?C_SCHEME_END_OF_LIST:C_i_cdr(t3));
t9=C_i_nullp(t8);
t10=(C_truep(t9)?C_SCHEME_FALSE:C_i_car(t8));
t11=t10;
t12=C_i_nullp(t8);
t13=(C_truep(t12)?C_SCHEME_END_OF_LIST:C_i_cdr(t8));
t14=C_i_check_string_2(t2,lf[414]);
t15=C_i_check_list_2(t6,lf[414]);
t16=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7778,a[2]=t11,a[3]=t2,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=t1,a[7]=t6,tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1606: pathname-strip-directory */
t17=((C_word*)t0)[4];{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t17;
av2[1]=t16;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t17+1)))(3,av2);}}

/* k8177 in a8174 in k8160 in k8157 in k8154 in spawn in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 in ... */
static void C_ccall f_8179(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(13,c,4))){C_save_and_reclaim((void *)f_8179,2,av);}
a=C_alloc(13);
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_8182,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],tmp=(C_word)a,a+=10,tmp);
t3=f_8138(C_a_i(&a,3),((C_word*)t0)[10]);
/* posixunix.scm:1743: connect-child */
f_8123(t2,t3,((C_word*)t0)[11],*((C_word*)lf[47]+1));}

/* k8171 in k8160 in k8157 in k8154 in spawn in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8173(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_8173,2,av);}
/* posixunix.scm:1738: values */{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
av2[4]=((C_word*)t0)[5];
av2[5]=t1;
C_values(6,av2);}}

/* system-information in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5392(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(6,c,2))){C_save_and_reclaim((void *)f_5392,2,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5396,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_fixnum_lessp(C_fix((C_word)C_uname),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5425,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:848: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[5]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[5]+1);
av2[1]=t3;
tp(2,av2);}}
else{
t3=t2;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_5396(2,av2);}}}

/* a8174 in k8160 in k8157 in k8154 in spawn in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8175(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(12,c,4))){C_save_and_reclaim((void *)f_8175,2,av);}
a=C_alloc(12);
t2=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_8179,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[10],tmp=(C_word)a,a+=12,tmp);
/* posixunix.scm:1742: connect-child */
f_8123(t2,((C_word*)t0)[11],((C_word*)t0)[12],*((C_word*)lf[46]+1));}

/* k5394 in system-information in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5396(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,3))){C_save_and_reclaim((void *)f_5396,2,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5403,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[246]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=C_mpointer(&a,(void*)C_utsname.sysname);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k5190 in with-input-from-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5192(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(!C_demand(C_calculate_demand(19,c,4))){C_save_and_reclaim((void *)f_5192,2,av);}
a=C_alloc(19);
t2=t1;
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5197,a[2]=t6,a[3]=t4,a[4]=((C_word)li99),tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5202,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li101),tmp=(C_word)a,a+=5,tmp);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5217,a[2]=t4,a[3]=t6,a[4]=((C_word)li102),tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:700: ##sys#dynamic-wind */
t10=*((C_word*)lf[95]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t10;
av2[1]=((C_word*)t0)[3];
av2[2]=t7;
av2[3]=t8;
av2[4]=t9;
((C_proc)(void*)(*((C_word*)t10+1)))(5,av2);}}

/* a5196 in k5190 in with-input-from-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5197(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_5197,2,av);}
t2=C_mutate2(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[204]+1));
t3=C_mutate2((C_word*)lf[204]+1 /* (set! ##sys#standard-input ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* signal-mask! in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5360(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_5360,3,av);}
t3=C_i_check_exact_2(t2,lf[241]);
t4=C_sigemptyset(C_fix(0));
t5=C_sigaddset(t2);
t6=C_sigprocmask_block(C_fix(0));
if(C_truep(C_fixnum_lessp(t6,C_fix(0)))){
/* posixunix.scm:826: posix-error */
t7=lf[0];{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t7;
av2[1]=t1;
av2[2]=lf[127];
av2[3]=lf[241];
av2[4]=lf[242];
f_2696(5,av2);}}
else{
t7=C_SCHEME_UNDEFINED;
t8=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}

/* k8183 in k8180 in k8177 in a8174 in k8160 in k8157 in k8154 in spawn in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in ... */
static void C_ccall f_8185(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_8185,2,av);}
/* posixunix.scm:1745: process-execute */
t2=*((C_word*)lf[414]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
av2[4]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* file-link in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6098(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand(9,c,2))){C_save_and_reclaim((void *)f_6098,4,av);}
a=C_alloc(9);
t4=C_i_check_string_2(t2,lf[328]);
t5=C_i_check_string_2(t3,lf[328]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6118,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=t6;
t8=t2;
t9=t3;
t10=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6079,a[2]=t7,a[3]=t9,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t8)){
t11=C_i_foreign_string_argumentp(t8);
/* posixunix.scm:1143: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t10;
av2[2]=t11;
tp(3,av2);}}
else{
t11=t10;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t11;
av2[1]=C_SCHEME_FALSE;
f_6079(2,av2);}}}

/* k8180 in k8177 in a8174 in k8160 in k8157 in k8154 in spawn in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in ... */
static void C_ccall f_8182(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(9,c,4))){C_save_and_reclaim((void *)f_8182,2,av);}
a=C_alloc(9);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8185,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=f_8138(C_a_i(&a,3),((C_word*)t0)[7]);
/* posixunix.scm:1744: connect-child */
f_8123(t2,t3,((C_word*)t0)[9],*((C_word*)lf[48]+1));}

/* k7776 in process-execute in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7778(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(8,c,4))){C_save_and_reclaim((void *)f_7778,2,av);}
a=C_alloc(8);
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7781,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
t3=C_block_size(t1);
/* posixunix.scm:1607: setarg */
f_7710(t2,C_fix(0),t1,t3);}

/* input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_8197(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(6,0,3))){
C_save_and_reclaim_args((void *)trf_8197,7,t0,t1,t2,t3,t4,t5,t6);}
a=C_alloc(6);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8201,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t6,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1748: connect-parent */
f_8111(t7,t4,t5);}

/* signal-unmask! in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5376(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_5376,3,av);}
t3=C_i_check_exact_2(t2,lf[243]);
t4=C_sigemptyset(C_fix(0));
t5=C_sigaddset(t2);
t6=C_sigprocmask_unblock(C_fix(0));
if(C_truep(C_fixnum_lessp(t6,C_fix(0)))){
/* posixunix.scm:833: posix-error */
t7=lf[0];{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t7;
av2[1]=t1;
av2[2]=lf[127];
av2[3]=lf[243];
av2[4]=lf[244];
f_2696(5,av2);}}
else{
t7=C_SCHEME_UNDEFINED;
t8=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}

/* a5172 in k5166 in call-with-output-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5173(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_5173,2,av);}
/* posixunix.scm:694: proc */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
((C_proc)C_fast_retrieve_proc(t2))(3,av2);}}

/* a5178 in k5166 in call-with-output-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5179(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2))){
C_save_and_reclaim((void*)f_5179,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5183,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:696: close-output-pipe */
t4=*((C_word*)lf[199]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k6689 in loop in poke1537 in k6663 in custom-output-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6691(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6691,2,av);}
/* posixunix.scm:1291: poke */
t2=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
((C_proc)C_fast_retrieve_proc(t2))(4,av2);}}

/* k6077 in file-link in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6079(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,2))){C_save_and_reclaim((void *)f_6079,2,av);}
a=C_alloc(4);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6083,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[3])){
t4=C_i_foreign_string_argumentp(((C_word*)t0)[3]);
/* posixunix.scm:1143: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t3;
av2[2]=t4;
tp(3,av2);}}
else{
t4=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=stub1384(C_SCHEME_UNDEFINED,t2,C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k7717 in setarg in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7719(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_7719,2,av);}
t2=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=stub1878(C_SCHEME_UNDEFINED,((C_word*)t0)[4],t1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* setarg in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_7710(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(!C_demand(C_calculate_demand(5,0,2))){
C_save_and_reclaim_args((void *)trf_7710,4,t1,t2,t3,t4);}
a=C_alloc(5);
t5=C_i_foreign_fixnum_argumentp(t2);
t6=t5;
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7719,a[2]=t4,a[3]=t1,a[4]=t6,tmp=(C_word)a,a+=5,tmp);
if(C_truep(t3)){
t8=C_i_foreign_string_argumentp(t3);
/* posixunix.scm:1598: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t7;
av2[2]=t8;
tp(3,av2);}}
else{
t8=C_i_foreign_fixnum_argumentp(t4);
t9=t1;{
C_word av2[2];
av2[0]=t9;
av2[1]=stub1878(C_SCHEME_UNDEFINED,t6,C_SCHEME_FALSE,t8);
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}}

/* k5181 in a5178 in k5166 in call-with-output-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5183(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_5183,2,av);}{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
C_apply_values(3,av2);}}

/* with-input-from-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5188(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +4,c,4))){
C_save_and_reclaim((void*)f_5188,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+4);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5192,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t5;
av2[2]=*((C_word*)lf[192]+1);
av2[3]=t2;
av2[4]=t4;
C_apply(5,av2);}}

/* a7927 in process-wait in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7928(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_7928,2,av);}
/* posixunix.scm:1640: ##sys#process-wait */
t2=*((C_word*)lf[126]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
av2[3]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* poke1537 in k6663 in custom-output-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6666(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand(12,c,2))){C_save_and_reclaim((void *)f_6666,4,av);}
a=C_alloc(12);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_6672,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t3,a[5]=((C_word*)t0)[3],a[6]=t5,a[7]=((C_word*)t0)[4],a[8]=((C_word*)t0)[5],a[9]=((C_word)li155),tmp=(C_word)a,a+=10,tmp));
t7=((C_word*)t5)[1];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t7;
av2[1]=t1;
f_6672(2,av2);}}

/* doloop1917 in k7779 in k7776 in process-execute in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_7786(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(6,0,4))){
C_save_and_reclaim_args((void *)trf_7786,4,t0,t1,t2,t3);}
a=C_alloc(6);
if(C_truep(C_i_nullp(t2))){
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7796,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1611: setarg */
f_7710(t4,t3,C_SCHEME_FALSE,C_fix(0));}
else{
t4=C_i_car(t2);
t5=C_i_check_string_2(t4,lf[414]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7869,a[2]=t2,a[3]=t3,a[4]=((C_word*)t0)[6],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t7=C_block_size(t4);
/* posixunix.scm:1630: setarg */
f_7710(t6,t3,t4,t7);}}

/* k6663 in custom-output-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6665(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
if(!C_demand(C_calculate_demand(26,c,4))){C_save_and_reclaim((void *)f_6665,2,av);}
a=C_alloc(26);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6666,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word)li156),tmp=(C_word)a,a+=7,tmp);
t7=C_fixnump(((C_word*)t0)[5]);
t8=(C_truep(t7)?((C_word*)t0)[5]:C_block_size(((C_word*)t0)[5]));
t9=t8;
t10=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_6732,a[2]=t3,a[3]=t6,a[4]=t5,a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[2],a[9]=((C_word*)t0)[3],tmp=(C_word)a,a+=10,tmp);
t11=C_eqp(C_fix(0),t9);
if(C_truep(t11)){
t12=t10;
f_6732(t12,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6779,a[2]=t3,a[3]=((C_word)li160),tmp=(C_word)a,a+=4,tmp));}
else{
t12=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6793,a[2]=t10,a[3]=t9,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_fixnump(((C_word*)t0)[5]))){
/* posixunix.scm:1304: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[72]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[72]+1);
av2[1]=t12;
av2[2]=((C_word*)t0)[5];
tp(3,av2);}}
else{
t13=t12;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t13;
av2[1]=((C_word*)t0)[5];
f_6793(2,av2);}}}}

/* k7779 in k7776 in process-execute in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7781(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(10,c,4))){C_save_and_reclaim((void *)f_7781,2,av);}
a=C_alloc(10);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7786,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t3,a[7]=((C_word)li194),tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f_7786(t5,((C_word*)t0)[6],((C_word*)t0)[7],C_fix(1));}

/* k6081 in k6077 in file-link in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6083(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_6083,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=stub1384(C_SCHEME_UNDEFINED,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* loop in poke1537 in k6663 in custom-output-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6672(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(6,c,6))){C_save_and_reclaim((void *)f_6672,2,av);}
a=C_alloc(6);
t2=C_write(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
t3=C_eqp(C_fix(-1),t2);
if(C_truep(t3)){
t4=C_fix((C_word)errno);
t5=C_i_eqvp(t4,C_fix((C_word)EWOULDBLOCK));
t6=(C_truep(t5)?t5:C_i_eqvp(t4,C_fix((C_word)EAGAIN)));
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6691,a[2]=((C_word*)t0)[5],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1290: ##sys#thread-yield! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[334]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[334]+1);
av2[1]=t7;
tp(2,av2);}}
else{
if(C_truep(C_i_eqvp(t4,C_fix((C_word)EINTR)))){
/* posixunix.scm:1293: ##sys#dispatch-interrupt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[172]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[172]+1);
av2[1]=t1;
av2[2]=((C_word*)((C_word*)t0)[6])[1];
tp(3,av2);}}
else{
/* posixunix.scm:1295: posix-error */
t7=lf[0];{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t7;
av2[1]=t1;
av2[2]=((C_word*)t0)[7];
av2[3]=lf[8];
av2[4]=lf[346];
av2[5]=((C_word*)t0)[2];
av2[6]=((C_word*)t0)[8];
f_2696(7,av2);}}}}
else{
if(C_truep(C_fixnum_lessp(t2,((C_word*)t0)[4]))){
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6722,a[2]=((C_word*)t0)[4],a[3]=t2,a[4]=((C_word*)t0)[5],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1297: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[70]+1));
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[70]+1);
av2[1]=t4;
av2[2]=((C_word*)t0)[3];
av2[3]=t2;
av2[4]=((C_word*)t0)[4];
tp(5,av2);}}
else{
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}}

/* setenv in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_7733(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(!C_demand(C_calculate_demand(5,0,2))){
C_save_and_reclaim_args((void *)trf_7733,4,t1,t2,t3,t4);}
a=C_alloc(5);
t5=C_i_foreign_fixnum_argumentp(t2);
t6=t5;
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7742,a[2]=t4,a[3]=t1,a[4]=t6,tmp=(C_word)a,a+=5,tmp);
if(C_truep(t3)){
t8=C_i_foreign_string_argumentp(t3);
/* posixunix.scm:1600: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t7;
av2[2]=t8;
tp(3,av2);}}
else{
t8=C_i_foreign_fixnum_argumentp(t4);
t9=t1;{
C_word av2[2];
av2[0]=t9;
av2[1]=stub1890(C_SCHEME_UNDEFINED,t6,C_SCHEME_FALSE,t8);
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}}

/* a3587 in conc-loop in glob in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3588(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_demand(C_calculate_demand(9,c,4))){C_save_and_reclaim((void *)f_3588,5,av);}
a=C_alloc(9);
t5=t2;
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3592,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t5,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3662,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
if(C_truep(t3)){
t8=t3;
/* posix-common.scm:503: make-pathname */
t9=*((C_word*)lf[83]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t9;
av2[1]=t7;
av2[2]=C_SCHEME_FALSE;
av2[3]=t8;
av2[4]=t4;
((C_proc)(void*)(*((C_word*)t9+1)))(5,av2);}}
else{
/* posix-common.scm:503: make-pathname */
t8=*((C_word*)lf[83]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t8;
av2[1]=t7;
av2[2]=C_SCHEME_FALSE;
av2[3]=lf[92];
av2[4]=t4;
((C_proc)(void*)(*((C_word*)t8+1)))(5,av2);}}}

/* a3581 in conc-loop in glob in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3582(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_3582,2,av);}
/* posix-common.scm:502: decompose-pathname */
t2=*((C_word*)lf[82]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* set-signal-mask! in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5303(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(3,c,4))){C_save_and_reclaim((void *)f_5303,3,av);}
a=C_alloc(3);
t3=C_i_check_list_2(t2,lf[237]);
t4=C_sigemptyset(C_fix(0));
t5=t2;
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5327,a[2]=((C_word)li110),tmp=(C_word)a,a+=3,tmp);
t7=f_5327(t5);
t8=C_sigprocmask_set(C_fix(0));
if(C_truep(C_fixnum_lessp(t8,C_fix(0)))){
/* posixunix.scm:802: posix-error */
t9=lf[0];{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t9;
av2[1]=t1;
av2[2]=lf[127];
av2[3]=lf[237];
av2[4]=lf[238];
f_2696(5,av2);}}
else{
t9=C_SCHEME_UNDEFINED;
t10=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t10;
av2[1]=t9;
((C_proc)(void*)(*((C_word*)t10+1)))(2,av2);}}}

/* k3597 in k3590 in a3587 in conc-loop in glob in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3599(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(10,c,3))){C_save_and_reclaim((void *)f_3599,2,av);}
a=C_alloc(10);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3601,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word)li36),tmp=(C_word)a,a+=8,tmp));
t5=((C_word*)t3)[1];
f_3601(t5,((C_word*)t0)[6],t1);}

/* k3590 in a3587 in conc-loop in glob in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3592(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(7,c,3))){C_save_and_reclaim((void *)f_3592,2,av);}
a=C_alloc(7);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3599,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t0)[4])){
/* posix-common.scm:504: directory */
t4=*((C_word*)lf[26]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
av2[3]=C_SCHEME_TRUE;
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}
else{
/* posix-common.scm:504: directory */
t4=*((C_word*)lf[26]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[90];
av2[3]=C_SCHEME_TRUE;
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}}

/* k5115 in close-input-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5117(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_5117,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* close-input-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5110(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(4,c,5))){C_save_and_reclaim((void *)f_5110,3,av);}
a=C_alloc(4);
t3=t2;
t4=C_i_check_port_2(t3,C_SCHEME_TRUE,C_SCHEME_TRUE,lf[197]);
t5=close_pipe(t2);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5117,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t7=C_eqp(C_fix(-1),t5);
if(C_truep(t7)){
/* posixunix.scm:671: posix-error */
t8=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t8;
av2[1]=t6;
av2[2]=lf[8];
av2[3]=lf[197];
av2[4]=lf[198];
av2[5]=t2;
f_2696(6,av2);}}
else{
t8=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t8;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}

/* a8105 in needed-pipe in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8106(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand(3,c,1))){C_save_and_reclaim((void *)f_8106,4,av);}
a=C_alloc(3);
t4=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_a_i_cons(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* a8099 in needed-pipe in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8100(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_8100,2,av);}
/* posixunix.scm:1715: create-pipe */
t2=*((C_word*)lf[207]+1);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k6016 in loop in k6004 in a5997 in read-symbolic-link in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6018(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(7,c,2))){C_save_and_reclaim((void *)f_6018,2,av);}
a=C_alloc(7);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6024,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:1131: file-exists? */
t4=*((C_word*)lf[84]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* close-output-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5125(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(4,c,5))){C_save_and_reclaim((void *)f_5125,3,av);}
a=C_alloc(4);
t3=t2;
t4=C_i_check_port_2(t3,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[199]);
t5=close_pipe(t2);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5132,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t7=C_eqp(C_fix(-1),t5);
if(C_truep(t7)){
/* posixunix.scm:678: posix-error */
t8=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t8;
av2[1]=t6;
av2[2]=lf[8];
av2[3]=lf[199];
av2[4]=lf[200];
av2[5]=t2;
f_2696(6,av2);}}
else{
t8=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t8;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}

/* k6339 in a6330 in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6341(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_6341,2,av);}
/* posixunix.scm:1219: on-close */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)C_fast_retrieve_proc(t2))(2,av2);}}

/* k8028 in k8024 in k8005 in k8002 in process-run in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8030(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_8030,2,av);}
/* posixunix.scm:1674: process-execute */
t2=*((C_word*)lf[414]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k6022 in k6016 in loop in k6004 in a5997 in read-symbolic-link in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 in ... */
static void C_ccall f_6024(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(13,c,5))){C_save_and_reclaim((void *)f_6024,2,av);}
a=C_alloc(13);
if(C_truep(t1)){
t2=((C_word*)t0)[2];
t3=C_u_i_cdr(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6033,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6036,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t3,a[5]=t4,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1133: symbolic-link? */
t6=*((C_word*)lf[32]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[6];
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}
else{
/* posixunix.scm:1139: ##sys#signal-hook */
t2=*((C_word*)lf[1]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[4];
av2[2]=lf[8];
av2[3]=lf[322];
av2[4]=lf[325];
av2[5]=((C_word*)t0)[6];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}}

/* connect-parent in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_8111(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(!C_demand(C_calculate_demand(4,0,2))){
C_save_and_reclaim_args((void *)trf_8111,3,t1,t2,t3);}
a=C_alloc(4);
if(C_truep(t3)){
t4=C_i_car(t2);
t5=t4;
t6=t2;
t7=C_u_i_cdr(t6);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8122,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1720: file-close */
t9=*((C_word*)lf[171]+1);{
C_word av2[3];
av2[0]=t9;
av2[1]=t8;
av2[2]=t7;
((C_proc)(void*)(*((C_word*)t9+1)))(3,av2);}}
else{
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k6355 in a6352 in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6357(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_6357,2,av);}
/* posixunix.scm:1223: peek */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=f_6184(((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* a6352 in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6353(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(4,c,2))){C_save_and_reclaim((void *)f_6353,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6357,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[3])[1],((C_word*)((C_word*)t0)[4])[1]))){
/* posixunix.scm:1222: fetch */
t3=((C_word*)t0)[5];
f_6192(t3,t2);}
else{
/* posixunix.scm:1223: peek */
t3=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=f_6184(((C_word*)t0)[2]);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k8002 in process-run in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_8004(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(5,0,2))){
C_save_and_reclaim_args((void *)trf_8004,2,t0,t1);}
a=C_alloc(5);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8007,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1670: process-fork */
t4=*((C_word*)lf[409]+1);{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* process-run in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8000(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +4,c,2))){
C_save_and_reclaim((void*)f_8000,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+4);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8004,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_pairp(t3))){
t5=t3;
t6=t4;
f_8004(t6,C_u_i_car(t5));}
else{
t5=t4;
f_8004(t5,C_SCHEME_FALSE);}}

/* k3133 in k3150 in port->fileno in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3135(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3135,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k8005 in k8002 in process-run in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8007(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_8007,2,av);}
a=C_alloc(4);
t2=C_eqp(C_fix(0),t1);
if(C_truep(t2)){
if(C_truep(((C_word*)t0)[2])){
/* posixunix.scm:1672: process-execute */
t3=*((C_word*)lf[414]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8026,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1674: ##sys#shell-command */
t4=*((C_word*)lf[420]+1);{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}
else{
t3=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k6446 in a6443 in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6448(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(8,c,2))){C_save_and_reclaim((void *)f_6448,2,av);}
a=C_alloc(8);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t2=((C_word*)t0)[4];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_SCHEME_END_OF_FILE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
t2=((C_word*)t0)[5];
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6457,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[4],tmp=(C_word)a,a+=8,tmp);
if(C_truep(t2)){
t4=t3;
f_6457(t4,t2);}
else{
t4=C_fudge(C_fix(21));
t5=t3;
f_6457(t5,C_fixnum_difference(t4,((C_word*)((C_word*)t0)[2])[1]));}}}

/* a6443 in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6444(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand(9,c,2))){C_save_and_reclaim((void *)f_6444,4,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6448,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=t3,a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=t2,tmp=(C_word)a,a+=9,tmp);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
/* posixunix.scm:1240: fetch */
t5=((C_word*)t0)[5];
f_6192(t5,t4);}
else{
t5=t4;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=C_SCHEME_UNDEFINED;
f_6448(2,av2);}}}

/* connect-child in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_8123(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(!C_demand(C_calculate_demand(5,0,2))){
C_save_and_reclaim_args((void *)trf_8123,4,t1,t2,t3,t4);}
a=C_alloc(5);
if(C_truep(t3)){
t5=C_i_car(t2);
t6=t5;
t7=t2;
t8=C_u_i_cdr(t7);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8134,a[2]=t1,a[3]=t6,a[4]=t4,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1726: file-close */
t10=*((C_word*)lf[171]+1);{
C_word av2[3];
av2[0]=t10;
av2[1]=t9;
av2[2]=t8;
((C_proc)(void*)(*((C_word*)t10+1)))(3,av2);}}
else{
t5=C_SCHEME_UNDEFINED;
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k8120 in connect-parent in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8122(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_8122,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k2737 in stat in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2739(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(8,c,5))){C_save_and_reclaim((void *)f_2739,2,av);}
a=C_alloc(8);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2743,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:224: port->fileno */
t3=*((C_word*)lf[10]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
if(C_truep(C_i_stringp(((C_word*)t0)[3]))){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2752,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2759,a[2]=t2,a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:227: ##sys#platform-fixup-pathname */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[12]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[12]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[3];
tp(3,av2);}}
else{
/* posix-common.scm:234: ##sys#signal-hook */
t2=*((C_word*)lf[1]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[13];
av2[3]=((C_word*)t0)[5];
av2[4]=lf[14];
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}}}

/* k8048 in k8132 in connect-child in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8050(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_8050,2,av);}
/* posixunix.scm:1701: file-close */
t2=*((C_word*)lf[171]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* make-on-close in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_8054(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(9,0,2))){
C_save_and_reclaim_args((void *)trf_8054,7,t1,t2,t3,t4,t5,t6,t7);}
a=C_alloc(9);
t8=t1;{
C_word av2[2];
av2[0]=t8;
av2[1]=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_8056,a[2]=t4,a[3]=t5,a[4]=t6,a[5]=t7,a[6]=t3,a[7]=t2,a[8]=((C_word)li206),tmp=(C_word)a,a+=9,tmp);
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}

/* k5099 in open-output-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5101(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(2,c,5))){C_save_and_reclaim((void *)f_5101,2,av);}
a=C_alloc(2);
t2=open_binary_output_pipe(&a,1,t1);
/* posixunix.scm:659: check */
f_5015(((C_word*)t0)[3],lf[196],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5352(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(!C_demand(C_calculate_demand(21,c,4))){C_save_and_reclaim((void *)f_5352,2,av);}
a=C_alloc(21);
t2=C_mutate2((C_word*)lf[239]+1 /* (set! signal-mask ...) */,t1);
t3=C_mutate2((C_word*)lf[240]+1 /* (set! signal-masked? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5354,a[2]=((C_word)li112),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate2((C_word*)lf[241]+1 /* (set! signal-mask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5360,a[2]=((C_word)li113),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate2((C_word*)lf[243]+1 /* (set! signal-unmask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5376,a[2]=((C_word)li114),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate2((C_word*)lf[245]+1 /* (set! system-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5392,a[2]=((C_word)li115),tmp=(C_word)a,a+=3,tmp));
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5432,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8569,a[2]=((C_word)li238),tmp=(C_word)a,a+=3,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8572,a[2]=((C_word)li239),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:857: getter-with-setter */
t10=*((C_word*)lf[437]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t10;
av2[1]=t7;
av2[2]=t8;
av2[3]=t9;
av2[4]=lf[449];
((C_proc)(void*)(*((C_word*)t10+1)))(5,av2);}}

/* signal-masked? in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5354(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_5354,3,av);}
t3=C_i_check_exact_2(t2,lf[240]);
t4=C_sigprocmask_get(C_fix(0));
t5=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=C_sigismember(t2);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* k6455 in k6446 in a6443 in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 in ... */
static void C_fcall f_6457(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(15,0,5))){
C_save_and_reclaim_args((void *)trf_6457,2,t0,t1);}
a=C_alloc(15);
t2=t1;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6462,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word)li150),tmp=(C_word)a,a+=8,tmp);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6518,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[2],a[4]=((C_word)li151),tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1243: ##sys#call-with-values */{
C_word av2[4];
av2[0]=0;
av2[1]=((C_word*)t0)[7];
av2[2]=t4;
av2[3]=t5;
C_call_with_values(4,av2);}}

/* f_8056 in make-on-close in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8056(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(9,c,5))){C_save_and_reclaim((void *)f_8056,2,av);}
a=C_alloc(9);
t2=C_i_vector_set(((C_word*)t0)[2],((C_word*)t0)[3],C_SCHEME_TRUE);
t3=C_i_vector_ref(((C_word*)t0)[2],((C_word*)t0)[4]);
t4=(C_truep(t3)?C_i_vector_ref(((C_word*)t0)[2],((C_word*)t0)[5]):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8071,a[2]=((C_word*)t0)[6],a[3]=((C_word)li204),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8077,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[6],a[4]=((C_word)li205),tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1708: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t5;
av2[3]=t6;
C_call_with_values(4,av2);}}
else{
t5=C_SCHEME_UNDEFINED;
t6=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k8132 in connect-child in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8134(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_8134,2,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];
t3=((C_word*)t0)[3];
t4=((C_word*)t0)[4];
t5=C_eqp(t4,t3);
if(C_truep(t5)){
t6=C_SCHEME_UNDEFINED;
t7=t2;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8050,a[2]=t2,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1700: duplicate-fileno */
t7=*((C_word*)lf[66]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t6;
av2[2]=t3;
av2[3]=t4;
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}}

/* swapped-ends in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static C_word C_fcall f_8138(C_word *a,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_stack_overflow_check;{}
if(C_truep(t1)){
t2=C_i_cdr(t1);
t3=t1;
t4=C_u_i_car(t3);
return(C_a_i_cons(&a,2,t2,t4));}
else{
return(C_SCHEME_FALSE);}}

/* k6004 in a5997 in read-symbolic-link in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6006(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(6,c,4))){C_save_and_reclaim((void *)f_6006,2,av);}
a=C_alloc(6);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6008,a[2]=t3,a[3]=((C_word)li136),tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_6008(t5,((C_word*)t0)[2],((C_word*)t0)[3],t1);}

/* loop in k6004 in a5997 in read-symbolic-link in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_6008(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(6,0,3))){
C_save_and_reclaim_args((void *)trf_6008,4,t0,t1,t2,t3);}
a=C_alloc(6);
if(C_truep(C_i_nullp(t2))){
t4=t3;
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6018,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t5=C_i_car(t2);
/* posixunix.scm:1130: make-pathname */
t6=*((C_word*)lf[83]+1);{
C_word av2[4];
av2[0]=t6;
av2[1]=t4;
av2[2]=t3;
av2[3]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}}

/* a6330 in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6331(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(4,c,6))){C_save_and_reclaim((void *)f_6331,2,av);}
a=C_alloc(4);
if(C_truep(C_slot(((C_word*)((C_word*)t0)[2])[1],C_fix(8)))){
t2=C_SCHEME_UNDEFINED;
t3=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6341,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=C_close(((C_word*)t0)[4]);
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){
/* posixunix.scm:1218: posix-error */
t4=lf[0];{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t4;
av2[1]=t2;
av2[2]=lf[8];
av2[3]=((C_word*)t0)[5];
av2[4]=lf[341];
av2[5]=((C_word*)t0)[4];
av2[6]=((C_word*)t0)[6];
f_2696(7,av2);}}
else{
/* posixunix.scm:1219: on-close */
t4=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t1;
((C_proc)C_fast_retrieve_proc(t4))(2,av2);}}}}

/* k8024 in k8005 in k8002 in process-run in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8026(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,2))){C_save_and_reclaim((void *)f_8026,2,av);}
a=C_alloc(4);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8030,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1674: ##sys#shell-command-arguments */
t4=*((C_word*)lf[424]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k3150 in port->fileno in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3152(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,5))){C_save_and_reclaim((void *)f_3152,2,av);}
a=C_alloc(4);
if(C_truep(C_i_zerop(t1))){
/* posix-common.scm:396: posix-error */
t2=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[13];
av2[3]=lf[10];
av2[4]=lf[63];
av2[5]=((C_word*)t0)[3];
f_2696(6,av2);}}
else{
t2=C_C_fileno(((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3135,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posix-common.scm:394: posix-error */
t4=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[8];
av2[3]=lf[10];
av2[4]=lf[64];
av2[5]=((C_word*)t0)[3];
f_2696(6,av2);}}
else{
t4=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}}

/* duplicate-fileno in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3158(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +4,c,2))){
C_save_and_reclaim((void*)f_3158,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+4);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
t4=C_i_check_exact_2(t2,*((C_word*)lf[66]+1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3165,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_nullp(t3))){
t6=t5;
f_3165(t6,C_dup(t2));}
else{
t6=C_i_car(t3);
t7=C_i_check_exact_2(t6,lf[66]);
t8=t5;
f_3165(t8,C_dup2(t2,t6));}}

/* k6424 in loop in k6374 in a6367 in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in ... */
static void C_ccall f_6426(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_6426,2,av);}
t2=C_eqp(C_fix(0),((C_word*)((C_word*)t0)[2])[1]);
if(C_truep(t2)){
t3=((C_word*)t0)[3];
t4=((C_word*)t0)[4];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
/* posixunix.scm:1237: loop */
t3=((C_word*)((C_word*)t0)[5])[1];
f_6378(t3,((C_word*)t0)[4],((C_word*)t0)[6],((C_word*)t0)[3],((C_word*)t0)[7]);}}

/* k2750 in k2737 in stat in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2752(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2752,2,av);}
if(C_truep(((C_word*)t0)[2])){
t2=C_lstat(t1);
t3=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
f_2718(2,av2);}}
else{
t2=C_stat(t1);
t3=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
f_2718(2,av2);}}}

/* k2757 in k2737 in stat in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2759(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_2759,2,av);}
/* posix-common.scm:226: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=((C_word*)t0)[3];
tp(4,av2);}}

/* a8070 */
static void C_ccall f_8071(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_8071,2,av);}
/* posixunix.scm:1708: ##sys#process-wait */
t2=*((C_word*)lf[126]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
av2[3]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k8157 in k8154 in spawn in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8159(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(13,c,2))){C_save_and_reclaim((void *)f_8159,2,av);}
a=C_alloc(13);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_8162,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[10],a[12]=((C_word*)t0)[11],tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm:1737: needed-pipe */
f_8091(t3,((C_word*)t0)[9]);}

/* a8076 */
static void C_ccall f_8077(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_demand(C_calculate_demand(0,c,6))){C_save_and_reclaim((void *)f_8077,5,av);}
if(C_truep(t3)){
t5=C_SCHEME_UNDEFINED;
t6=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
/* posixunix.scm:1710: ##sys#signal-hook */
t5=*((C_word*)lf[1]+1);{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=lf[127];
av2[3]=((C_word*)t0)[2];
av2[4]=lf[427];
av2[5]=((C_word*)t0)[3];
av2[6]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(7,av2);}}}

/* a8704 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8705(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand(9,c,2))){C_save_and_reclaim((void *)f_8705,4,av);}
a=C_alloc(9);
t4=C_i_check_number_2(t3,lf[454]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8725,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t6=t5;
t7=t2;
t8=t3;
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8715,a[2]=t6,a[3]=t8,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t7)){
t10=C_i_foreign_string_argumentp(t7);
/* posix-common.scm:256: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t9;
av2[2]=t10;
tp(3,av2);}}
else{
t10=t6;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t10;
av2[1]=stub120(C_SCHEME_UNDEFINED,C_SCHEME_FALSE,t8);
((C_proc)(void*)(*((C_word*)t10+1)))(2,av2);}}}

/* k8701 in a8698 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8703(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,1))){C_save_and_reclaim((void *)f_8703,2,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_flonum(&a,C_statbuf.st_mtime);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k8154 in spawn in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8156(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(13,c,2))){C_save_and_reclaim((void *)f_8156,2,av);}
a=C_alloc(13);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_8159,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[10],a[12]=((C_word*)t0)[11],tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm:1736: needed-pipe */
f_8091(t3,((C_word*)t0)[9]);}

/* for-each-loop1102 in set-signal-mask! in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static C_word C_fcall f_5327(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_pairp(t1))){
t2=C_slot(t1,C_fix(0));
t3=C_i_check_exact_2(t2,lf[237]);
t4=C_sigaddset(t2);
t5=C_slot(t1,C_fix(1));
t7=t5;
t1=t7;
goto loop;}
else{
t2=C_SCHEME_UNDEFINED;
return(t2);}}

/* k2741 in k2737 in stat in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2743(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_2743,2,av);}
t2=C_fstat(t1);
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
f_2718(2,av2);}}

/* spawn in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_8152(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word *a;
if(!C_demand(C_calculate_demand(12,0,2))){
C_save_and_reclaim_args((void *)trf_8152,8,t0,t1,t2,t3,t4,t5,t6,t7);}
a=C_alloc(12);
t8=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_8156,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,a[5]=t3,a[6]=t4,a[7]=((C_word*)t0)[3],a[8]=t7,a[9]=t5,a[10]=t6,a[11]=((C_word*)t0)[4],tmp=(C_word)a,a+=12,tmp);
/* posixunix.scm:1735: needed-pipe */
f_8091(t8,t6);}

/* a6318 in k6152 in k6146 in custom-input-port in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_6319(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_6319,2,av);}
t2=C_fixnum_lessp(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t2)){
t3=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* posixunix.scm:1213: ready? */
t3=((C_word*)t0)[4];
f_6155(t3,t1);}}

/* k8713 in a8704 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8715(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_8715,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=stub120(C_SCHEME_UNDEFINED,t1,((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k8160 in k8157 in k8154 in spawn in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8162(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(23,c,2))){C_save_and_reclaim((void *)f_8162,2,av);}
a=C_alloc(23);
t2=t1;
t3=f_8138(C_a_i(&a,3),((C_word*)t0)[3]);
t4=t3;
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_8173,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=t4,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_8175,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[2],a[6]=t2,a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[5],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[3],a[12]=((C_word*)t0)[12],a[13]=((C_word)li214),tmp=(C_word)a,a+=14,tmp);
/* posixunix.scm:1740: process-fork */
t7=*((C_word*)lf[409]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t7;
av2[1]=t5;
av2[2]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}

/* needed-pipe in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_8091(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(6,0,4))){
C_save_and_reclaim_args((void *)trf_8091,2,t1,t2);}
a=C_alloc(6);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8100,a[2]=((C_word)li208),tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8106,a[2]=((C_word)li209),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1713: ##sys#call-with-values */{
C_word av2[4];
av2[0]=0;
av2[1]=t1;
av2[2]=t3;
av2[3]=t4;
C_call_with_values(4,av2);}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k5867 in change-file-owner in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5869(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,7))){C_save_and_reclaim((void *)f_5869,2,av);}
t2=C_chown(t1,((C_word*)t0)[2],((C_word*)t0)[3]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1056: posix-error */
t3=lf[0];{
C_word *av2;
if(c >= 8) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(8);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[4];
av2[2]=lf[8];
av2[3]=lf[308];
av2[4]=lf[309];
av2[5]=((C_word*)t0)[5];
av2[6]=((C_word*)t0)[2];
av2[7]=((C_word*)t0)[3];
f_2696(8,av2);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[4];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* current-directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3185(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +3,c,3))){
C_save_and_reclaim((void*)f_3185,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+3);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
t3=C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_i_car(t2));
if(C_truep(t4)){
/* posix-common.scm:415: change-directory */
t5=*((C_word*)lf[69]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3198,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[72]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[72]+1);
av2[1]=t5;
av2[2]=C_fix(1024);
av2[3]=C_make_character(32);
tp(4,av2);}}}

/* k8723 in a8704 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8725(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,6))){C_save_and_reclaim((void *)f_8725,2,av);}
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
/* posix-common.scm:259: posix-error */
t2=lf[0];{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[8];
av2[3]=lf[454];
av2[4]=lf[455];
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[4];
f_2696(7,av2);}}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* change-directory in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4962(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_4962,3,av);}
a=C_alloc(4);
t3=C_i_check_string_2(t2,lf[69]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4969,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:621: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[69];
tp(4,av2);}}

/* k3196 in current-directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3198(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,2))){C_save_and_reclaim((void *)f_3198,2,av);}
a=C_alloc(5);
t2=t1;
t3=C_curdir(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3201,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:419: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[5]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[5]+1);
av2[1]=t4;
tp(2,av2);}}

/* k2709 in k2698 in posix-error in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2711(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_2711,2,av);}
/* posix-common.scm:184: string-append */
t2=*((C_word*)lf[2]+1);{
C_word *av2;
if(c >= 5) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=lf[3];
av2[4]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* ##sys#stat in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_2714(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(12,0,2))){
C_save_and_reclaim_args((void *)trf_2714,5,t1,t2,t3,t4,t5);}
a=C_alloc(12);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2718,a[2]=t4,a[3]=t1,a[4]=t5,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_fixnump(t2))){
t7=t6;{
C_word av2[2];
av2[0]=t7;
av2[1]=C_fstat(t2);
f_2718(2,av2);}}
else{
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2739,a[2]=t6,a[3]=t2,a[4]=t3,a[5]=t5,tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:224: port? */
t8=*((C_word*)lf[15]+1);{
C_word av2[3];
av2[0]=t8;
av2[1]=t7;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t8+1)))(3,av2);}}}

/* k2716 in stat in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2718(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_2718,2,av);}
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
if(C_truep(((C_word*)t0)[2])){
/* posix-common.scm:238: posix-error */
t2=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[8];
av2[3]=((C_word*)t0)[4];
av2[4]=lf[9];
av2[5]=((C_word*)t0)[5];
f_2696(6,av2);}}
else{
t2=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}
else{
t2=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_SCHEME_TRUE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k3124 in port->fileno in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3126(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3126,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=C_slot(t1,C_fix(0));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k4967 in change-directory in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4969(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,5))){C_save_and_reclaim((void *)f_4969,2,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4972,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_chdir(t1);
t4=C_eqp(C_fix(0),t3);
if(C_truep(t4)){
t5=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
/* posixunix.scm:623: posix-error */
t5=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t2;
av2[2]=lf[8];
av2[3]=lf[69];
av2[4]=lf[187];
av2[5]=((C_word*)t0)[3];
f_2696(6,av2);}}}

/* change-directory* in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4981(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(4,c,5))){C_save_and_reclaim((void *)f_4981,3,av);}
a=C_alloc(4);
t3=C_i_check_exact_2(t2,lf[188]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4988,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=C_fchdir(t2);
t6=C_eqp(C_fix(0),t5);
if(C_truep(t6)){
t7=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t7;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
/* posixunix.scm:629: posix-error */
t7=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t7;
av2[1]=t4;
av2[2]=lf[8];
av2[3]=lf[188];
av2[4]=lf[189];
av2[5]=t2;
f_2696(6,av2);}}}

/* k2698 in posix-error in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2700(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(15,c,3))){C_save_and_reclaim((void *)f_2700,2,av);}
a=C_alloc(15);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2707,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2711,a[2]=t2,a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
t4=C_a_i_bytevector(&a,1,C_fix(3));
t5=C_i_foreign_fixnum_argumentp(t1);
t6=stub67(t4,t5);
/* posix-common.scm:180: ##sys#peek-c-string */
t7=*((C_word*)lf[4]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=t6;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k2705 in k2698 in posix-error in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2707(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,6))){C_save_and_reclaim((void *)f_2707,2,av);}{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=*((C_word*)lf[1]+1);
av2[3]=((C_word*)t0)[3];
av2[4]=((C_word*)t0)[4];
av2[5]=t1;
av2[6]=((C_word*)t0)[5];
C_apply(7,av2);}}

/* k7589 in k7568 in terminal-size in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7591(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(8,c,5))){C_save_and_reclaim((void *)f_7591,2,av);}
a=C_alloc(8);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7595,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1558: ##sys#make-locative */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[405]+1));
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[405]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[5];
av2[3]=C_fix(0);
av2[4]=C_SCHEME_FALSE;
av2[5]=lf[406];
tp(6,av2);}}

/* k7593 in k7589 in k7568 in terminal-size in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7595(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_7595,2,av);}
t2=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t3=C_i_foreign_pointer_argumentp(((C_word*)t0)[3]);
t4=C_i_foreign_pointer_argumentp(t1);
t5=stub1809(C_SCHEME_UNDEFINED,t2,t3,t4);
t6=C_eqp(C_fix(0),t5);
if(C_truep(t6)){
/* posixunix.scm:1559: values */{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[4];
av2[2]=C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[5])));
av2[3]=C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[6])));
C_values(4,av2);}}
else{
/* posixunix.scm:1560: posix-error */
t7=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t7;
av2[1]=((C_word*)t0)[4];
av2[2]=lf[403];
av2[3]=lf[402];
av2[4]=lf[404];
av2[5]=((C_word*)t0)[7];
f_2696(6,av2);}}}

/* file-read-access? in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5891(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_5891,3,av);}
/* posixunix.scm:1068: check */
f_5871(t1,t2,C_fix((C_word)R_OK),lf[310]);}

/* file-write-access? in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5897(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_5897,3,av);}
/* posixunix.scm:1069: check */
f_5871(t1,t2,C_fix((C_word)W_OK),lf[311]);}

/* k4970 in k4967 in change-directory in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4972(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_4972,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* file-unlock in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7080(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_7080,3,av);}
t3=C_i_check_structure_2(t2,lf[352],lf[359]);
t4=C_slot(t2,C_fix(2));
t5=C_slot(t2,C_fix(3));
t6=C_flock_setup(C_fix((C_word)F_UNLCK),t4,t5);
t7=C_slot(t2,C_fix(1));
t8=C_flock_lock(t7);
if(C_truep(C_fixnum_lessp(t8,C_fix(0)))){
/* posixunix.scm:1390: posix-error */
t9=lf[0];{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t9;
av2[1]=t1;
av2[2]=lf[8];
av2[3]=lf[359];
av2[4]=lf[360];
av2[5]=t2;
f_2696(6,av2);}}
else{
t9=C_SCHEME_UNDEFINED;
t10=t1;{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t10;
av2[1]=t9;
((C_proc)(void*)(*((C_word*)t10+1)))(2,av2);}}}

/* k4986 in change-directory* in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_4988(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_4988,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* file-lock in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7021(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +5,c,4))){
C_save_and_reclaim((void*)f_7021,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+5);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7025,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1369: setup */
f_6939(t4,t2,t3,lf[353]);}

/* change-file-owner in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5845(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_demand(C_calculate_demand(6,c,3))){C_save_and_reclaim((void *)f_5845,5,av);}
a=C_alloc(6);
t5=C_i_check_string_2(t2,lf[308]);
t6=C_i_check_exact_2(t3,lf[308]);
t7=C_i_check_exact_2(t4,lf[308]);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5869,a[2]=t3,a[3]=t4,a[4]=t1,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1055: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t8;
av2[2]=t2;
av2[3]=lf[308];
tp(4,av2);}}

/* k5841 in change-file-mode in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5843(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,6))){C_save_and_reclaim((void *)f_5843,2,av);}
t2=C_chmod(t1,((C_word*)t0)[2]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1048: posix-error */
t3=lf[0];{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[8];
av2[3]=lf[306];
av2[4]=lf[307];
av2[5]=((C_word*)t0)[4];
av2[6]=((C_word*)t0)[2];
f_2696(7,av2);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k7023 in file-lock in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7025(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_7025,2,av);}
t2=C_flock_lock(((C_word*)t0)[2]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:1371: err */
f_7003(((C_word*)t0)[4],lf[354],t1,lf[353]);}
else{
t3=((C_word*)t0)[4];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k3166 in k3163 in duplicate-fileno in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3168(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_3168,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k3163 in duplicate-fileno in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_3165(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(4,0,5))){
C_save_and_reclaim_args((void *)trf_3165,2,t0,t1);}
a=C_alloc(4);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3168,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posix-common.scm:407: posix-error */
t4=lf[0];{
C_word av2[6];
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[8];
av2[3]=lf[66];
av2[4]=lf[67];
av2[5]=((C_word*)t0)[3];
f_2696(6,av2);}}
else{
t4=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k3477 in loop in k3449 in k3445 in k3442 in k3439 in k3424 in directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3479(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(!C_demand(C_calculate_demand(5,c,2))){C_save_and_reclaim((void *)f_3479,2,av);}
a=C_alloc(5);
t2=t1;
t3=C_i_string_ref(t2,C_fix(0));
t4=C_fixnum_greaterp(((C_word*)t0)[2],C_fix(1));
t5=(C_truep(t4)?C_i_string_ref(t2,C_fix(1)):C_SCHEME_FALSE);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3491,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t7=C_eqp(C_make_character(46),t3);
if(C_truep(t7)){
t8=C_i_not(t5);
if(C_truep(t8)){
t9=t6;
f_3491(t9,t8);}
else{
t9=C_eqp(C_make_character(46),t5);
if(C_truep(t9)){
t10=C_eqp(C_fix(2),((C_word*)t0)[2]);
t11=t6;
f_3491(t11,(C_truep(t10)?t10:C_i_not(((C_word*)t0)[5])));}
else{
t10=t6;
f_3491(t10,C_i_not(((C_word*)t0)[5]));}}}
else{
t8=t6;
f_3491(t8,C_SCHEME_FALSE);}}

/* k6037 in k6034 in k6022 in k6016 in loop in k6004 in a5997 in read-symbolic-link in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in ... */
static void C_ccall f_6039(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_demand(C_calculate_demand(8,c,2))){C_save_and_reclaim((void *)f_6039,2,av);}
a=C_alloc(8);
t2=t1;
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6045,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:1135: absolute-pathname? */
t4=*((C_word*)lf[324]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k6034 in k6022 in k6016 in loop in k6004 in a5997 in read-symbolic-link in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in ... */
static void C_ccall f_6036(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(7,c,3))){C_save_and_reclaim((void *)f_6036,2,av);}
a=C_alloc(7);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6039,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:1134: ##sys#read-symbolic-link */
t3=*((C_word*)lf[319]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[7];
av2[3]=lf[322];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}
else{
/* posixunix.scm:1132: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_6008(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[7]);}}

/* k6031 in k6022 in k6016 in loop in k6004 in a5997 in read-symbolic-link in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in ... */
static void C_ccall f_6033(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6033,2,av);}
/* posixunix.scm:1132: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_6008(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k3106 in open-output-file* in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3108(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(2,c,5))){C_save_and_reclaim((void *)f_3108,2,av);}
a=C_alloc(2);
t2=C_fdopen(&a,2,((C_word*)t0)[2],t1);
/* posix-common.scm:380: check */
f_3067(((C_word*)t0)[4],lf[61],((C_word*)t0)[2],C_SCHEME_FALSE,t2);}

/* k6043 in k6037 in k6034 in k6022 in k6016 in loop in k6004 in a5997 in read-symbolic-link in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in ... */
static void C_ccall f_6045(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_6045,2,av);}
if(C_truep(t1)){
/* posixunix.scm:1132: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_6008(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}
else{
/* posixunix.scm:1137: make-pathname */
t2=*((C_word*)lf[83]+1);{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[6];
av2[2]=((C_word*)t0)[7];
av2[3]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}}

/* check in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_5871(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(4,0,3))){
C_save_and_reclaim_args((void *)trf_5871,4,t1,t2,t3,t4);}
a=C_alloc(4);
t5=C_i_check_string_2(t2,t4);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5889,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1065: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t6;
av2[2]=t2;
av2[3]=t4;
tp(4,av2);}}

/* port->fileno in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_3110(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_demand(C_calculate_demand(4,c,3))){C_save_and_reclaim((void *)f_3110,3,av);}
a=C_alloc(4);
t3=t2;
t4=C_i_check_port_2(t3,C_fix(0),C_SCHEME_TRUE,lf[10]);
t5=C_slot(t2,C_fix(7));
t6=C_eqp(lf[30],t5);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3126,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:390: ##sys#port-data */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[62]+1));
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[62]+1);
av2[1]=t7;
av2[2]=t2;
tp(3,av2);}}
else{
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3152,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:391: ##sys#peek-unsigned-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[65]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[65]+1);
av2[1]=t7;
av2[2]=t2;
av2[3]=C_fix(0);
tp(4,av2);}}}

/* k5879 in k5887 in check in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5881(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,1))){C_save_and_reclaim((void *)f_5881,2,av);}
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k5887 in check in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5889(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_demand(C_calculate_demand(4,c,2))){C_save_and_reclaim((void *)f_5889,2,av);}
a=C_alloc(4);
t2=C_test_access(t1,((C_word*)t0)[2]);
t3=C_eqp(C_fix(0),t2);
t4=t3;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5881,a[2]=((C_word*)t0)[3],a[3]=t4,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t4)){
t6=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t6;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
/* posixunix.scm:1066: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[5]+1));
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=*((C_word*)lf[5]+1);
av2[1]=t5;
tp(2,av2);}}}

/* k7867 in doloop1917 in k7779 in k7776 in process-execute in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_7869(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,3))){C_save_and_reclaim((void *)f_7869,2,av);}
t2=((C_word*)t0)[2];
t3=C_u_i_cdr(t2);
t4=C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
t5=((C_word*)((C_word*)t0)[4])[1];
f_7786(t5,((C_word*)t0)[5],t3,t4);}

/* ##sys#terminal-check in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_7511(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(!C_demand(C_calculate_demand(0,0,4))){
C_save_and_reclaim_args((void *)trf_7511,3,t1,t2,t3);}
t4=t3;
t5=t2;
t6=C_i_check_port_2(t4,C_fix(0),C_SCHEME_TRUE,t5);
t7=C_slot(t3,C_fix(7));
t8=C_eqp(lf[43],t7);
t9=(C_truep(t8)?C_tty_portp(t3):C_SCHEME_FALSE);
if(C_truep(t9)){
t10=C_SCHEME_UNDEFINED;
t11=t1;{
C_word av2[2];
av2[0]=t11;
av2[1]=t10;
((C_proc)(void*)(*((C_word*)t11+1)))(2,av2);}}
else{
/* posixunix.scm:1539: ##sys#error */
t10=*((C_word*)lf[50]+1);{
C_word av2[5];
av2[0]=t10;
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[400];
av2[4]=t3;
((C_proc)(void*)(*((C_word*)t10+1)))(5,av2);}}}

/* k2990 in k2978 in set-file-position! in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2992(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,6))){C_save_and_reclaim((void *)f_2992,2,av);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* posix-common.scm:326: posix-error */
t2=lf[0];{
C_word *av2;
if(c >= 7) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(7);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[8];
av2[3]=lf[41];
av2[4]=lf[42];
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[4];
f_2696(7,av2);}}}

/* k2996 in k2978 in set-file-position! in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_2998(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_2998,2,av);}
if(C_truep(t1)){
t2=C_slot(((C_word*)t0)[2],C_fix(7));
t3=C_eqp(t2,lf[43]);
if(C_truep(t3)){
t4=C_fseek(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
t5=((C_word*)t0)[5];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=t4;
f_2992(2,av2);}}
else{
t4=((C_word*)t0)[5];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
f_2992(2,av2);}}}
else{
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
t2=C_lseek(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
t3=((C_word*)t0)[5];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
f_2992(2,av2);}}
else{
/* posix-common.scm:325: ##sys#signal-hook */
t2=*((C_word*)lf[1]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[5];
av2[2]=lf[13];
av2[3]=lf[41];
av2[4]=lf[44];
av2[5]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}}}

/* err in k5955 in k5924 in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_7003(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_demand(C_calculate_demand(0,0,7))){
C_save_and_reclaim_args((void *)trf_7003,4,t1,t2,t3,t4);}
t5=C_slot(t3,C_fix(1));
t6=C_slot(t3,C_fix(2));
t7=C_slot(t3,C_fix(3));
/* posixunix.scm:1366: posix-error */
t8=lf[0];{
C_word av2[8];
av2[0]=t8;
av2[1]=t1;
av2[2]=lf[8];
av2[3]=t4;
av2[4]=t2;
av2[5]=t5;
av2[6]=t6;
av2[7]=t7;
f_2696(8,av2);}}

/* change-file-mode in k5442 in k5438 in k5434 in k5430 in k5350 in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5822(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_demand(C_calculate_demand(5,c,3))){C_save_and_reclaim((void *)f_5822,4,av);}
a=C_alloc(5);
t4=C_i_check_string_2(t2,lf[306]);
t5=C_i_check_exact_2(t3,lf[306]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5843,a[2]=t3,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1047: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t6;
av2[2]=t2;
av2[3]=lf[306];
tp(4,av2);}}

/* k8676 in a8661 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_8678(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,5))){C_save_and_reclaim((void *)f_8678,2,av);}
if(C_truep(t1)){
t2=C_slot(((C_word*)t0)[2],C_fix(7));
t3=C_eqp(t2,lf[43]);
if(C_truep(t3)){
t4=C_ftell(((C_word*)t0)[2]);
t5=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t5;
av2[1]=t4;
f_8666(2,av2);}}
else{
t4=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t4;
av2[1]=C_fix(-1);
f_8666(2,av2);}}}
else{
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
t2=C_lseek(((C_word*)t0)[2],C_fix(0),C_fix((C_word)SEEK_CUR));
t3=((C_word*)t0)[3];{
C_word *av2;
if(c >= 2) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(2);
}
av2[0]=t3;
av2[1]=t2;
f_8666(2,av2);}}
else{
/* posix-common.scm:338: ##sys#signal-hook */
t2=*((C_word*)lf[1]+1);{
C_word *av2;
if(c >= 6) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[13];
av2[3]=lf[45];
av2[4]=lf[452];
av2[5]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}}}

/* k3489 in k3477 in loop in k3449 in k3445 in k3442 in k3439 in k3424 in directory in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_3491(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(4,0,2))){
C_save_and_reclaim_args((void *)trf_3491,2,t0,t1);}
a=C_alloc(4);
if(C_truep(t1)){
/* posix-common.scm:491: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3465(t2,((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3501,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:492: loop */
t3=((C_word*)((C_word*)t0)[2])[1];
f_3465(t3,t2);}}

/* k2978 in set-file-position! in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_fcall f_2980(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_demand(C_calculate_demand(11,0,2))){
C_save_and_reclaim_args((void *)trf_2980,2,t0,t1);}
a=C_alloc(11);
t2=t1;
t3=C_i_check_exact_2(((C_word*)t0)[2],lf[41]);
t4=C_i_check_exact_2(t2,lf[41]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2992,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2998,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=t2,a[5]=t5,tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:319: port? */
t7=*((C_word*)lf[15]+1);{
C_word av2[3];
av2[0]=t7;
av2[1]=t6;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}

/* k5157 in a5154 in k5142 in call-with-input-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5159(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,2))){C_save_and_reclaim((void *)f_5159,2,av);}{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
C_apply_values(3,av2);}}

/* a5154 in k5142 in call-with-input-pipe in k4232 in k3896 in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 */
static void C_ccall f_5155(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2))){
C_save_and_reclaim((void*)f_5155,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5159,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:687: close-input-pipe */
t4=*((C_word*)lf[197]+1);{
C_word *av2;
if(c >= 3) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k3729 in k3797 in k3707 in k3698 in loop in k3683 in k3676 in k3673 in k3864 in k3861 in k3858 in k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 in ... */
static void C_ccall f_3731(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_3731,2,av);}
/* posix-common.scm:539: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_3687(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],t1);}

/* k3732 in k3797 in k3707 in k3698 in loop in k3683 in k3676 in k3673 in k3864 in k3861 in k3858 in k3855 in k3852 in k3849 in find-files in k3023 in k2782 in k2682 in k2679 in k2676 in k2673 in k2670 in ... */
static void C_ccall f_3734(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(!C_demand(C_calculate_demand(0,c,4))){C_save_and_reclaim((void *)f_3734,2,av);}
if(C_truep(t1)){
/* posix-common.scm:539: action */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 4) {
  av2=av; /* Re-use our own argvector */
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
((C_proc)C_fast_retrieve_proc(t2))(4,av2);}}
else{
t2=((C_word*)t0)[5];
/* posix-common.scm:539: loop */
t3=((C_word*)((C_word*)t0)[6])[1];
f_3687(t3,((C_word*)t0)[7],((C_word*)t0)[8],((C_word*)t0)[9],t2);}}

#ifdef C_ENABLE_PTABLES
static C_PTABLE_ENTRY ptable[591] = {
{"f_4823:posixunix_2escm",(void*)f_4823},
{"f_5168:posixunix_2escm",(void*)f_5168},
{"f_8699:posixunix_2escm",(void*)f_8699},
{"f_5164:posixunix_2escm",(void*)f_5164},
{"f_3700:posixunix_2escm",(void*)f_3700},
{"f_3709:posixunix_2escm",(void*)f_3709},
{"f_7828:posixunix_2escm",(void*)f_7828},
{"f_5132:posixunix_2escm",(void*)f_5132},
{"f_3753:posixunix_2escm",(void*)f_3753},
{"f_3755:posixunix_2escm",(void*)f_3755},
{"f_4236:posixunix_2escm",(void*)f_4236},
{"f_4234:posixunix_2escm",(void*)f_4234},
{"f_5149:posixunix_2escm",(void*)f_5149},
{"f_5144:posixunix_2escm",(void*)f_5144},
{"f_5140:posixunix_2escm",(void*)f_5140},
{"f_7239:posixunix_2escm",(void*)f_7239},
{"f_7847:posixunix_2escm",(void*)f_7847},
{"f_7233:posixunix_2escm",(void*)f_7233},
{"f_7230:posixunix_2escm",(void*)f_7230},
{"f_7570:posixunix_2escm",(void*)f_7570},
{"f_4878:posixunix_2escm",(void*)f_4878},
{"f_3775:posixunix_2escm",(void*)f_3775},
{"f_3772:posixunix_2escm",(void*)f_3772},
{"f_6518:posixunix_2escm",(void*)f_6518},
{"f_7227:posixunix_2escm",(void*)f_7227},
{"f_7223:posixunix_2escm",(void*)f_7223},
{"f_7566:posixunix_2escm",(void*)f_7566},
{"f_3743:posixunix_2escm",(void*)f_3743},
{"f_6567:posixunix_2escm",(void*)f_6567},
{"f_7252:posixunix_2escm",(void*)f_7252},
{"f_8666:posixunix_2escm",(void*)f_8666},
{"f_8669:posixunix_2escm",(void*)f_8669},
{"f_3799:posixunix_2escm",(void*)f_3799},
{"f_3790:posixunix_2escm",(void*)f_3790},
{"f_6577:posixunix_2escm",(void*)f_6577},
{"f_3793:posixunix_2escm",(void*)f_3793},
{"f_8662:posixunix_2escm",(void*)f_8662},
{"f_4080:posixunix_2escm",(void*)f_4080},
{"f_4084:posixunix_2escm",(void*)f_4084},
{"f_3760:posixunix_2escm",(void*)f_3760},
{"f_4087:posixunix_2escm",(void*)f_4087},
{"f_3768:posixunix_2escm",(void*)f_3768},
{"f_3248:posixunix_2escm",(void*)f_3248},
{"f_3249:posixunix_2escm",(void*)f_3249},
{"f_7037:posixunix_2escm",(void*)f_7037},
{"f_4070:posixunix_2escm",(void*)f_4070},
{"f_3259:posixunix_2escm",(void*)f_3259},
{"f_3225:posixunix_2escm",(void*)f_3225},
{"f_3229:posixunix_2escm",(void*)f_3229},
{"f_5573:posixunix_2escm",(void*)f_5573},
{"f_4242:posixunix_2escm",(void*)f_4242},
{"f_7057:posixunix_2escm",(void*)f_7057},
{"f_7053:posixunix_2escm",(void*)f_7053},
{"f_5583:posixunix_2escm",(void*)f_5583},
{"f_7041:posixunix_2escm",(void*)f_7041},
{"f_8631:posixunix_2escm",(void*)f_8631},
{"f_3283:posixunix_2escm",(void*)f_3283},
{"f_5569:posixunix_2escm",(void*)f_5569},
{"f_7742:posixunix_2escm",(void*)f_7742},
{"f_5070:posixunix_2escm",(void*)f_5070},
{"f_5563:posixunix_2escm",(void*)f_5563},
{"f_5567:posixunix_2escm",(void*)f_5567},
{"f_4023:posixunix_2escm",(void*)f_4023},
{"f_8656:posixunix_2escm",(void*)f_8656},
{"f_5084:posixunix_2escm",(void*)f_5084},
{"f_3268:posixunix_2escm",(void*)f_3268},
{"f_3265:posixunix_2escm",(void*)f_3265},
{"f_4013:posixunix_2escm",(void*)f_4013},
{"f_4017:posixunix_2escm",(void*)f_4017},
{"f_5091:posixunix_2escm",(void*)f_5091},
{"f_3273:posixunix_2escm",(void*)f_3273},
{"f_3375:posixunix_2escm",(void*)f_3375},
{"f_4009:posixunix_2escm",(void*)f_4009},
{"f_3373:posixunix_2escm",(void*)f_3373},
{"f_5597:posixunix_2escm",(void*)f_5597},
{"f_3381:posixunix_2escm",(void*)f_3381},
{"f_6643:posixunix_2escm",(void*)f_6643},
{"f_5508:posixunix_2escm",(void*)f_5508},
{"f_8622:posixunix_2escm",(void*)f_8622},
{"f_5500:posixunix_2escm",(void*)f_5500},
{"f_3981:posixunix_2escm",(void*)f_3981},
{"f_3201:posixunix_2escm",(void*)f_3201},
{"f_6811:posixunix_2escm",(void*)f_6811},
{"f_5539:posixunix_2escm",(void*)f_5539},
{"f_3219:posixunix_2escm",(void*)f_3219},
{"f_6821:posixunix_2escm",(void*)f_6821},
{"f_5546:posixunix_2escm",(void*)f_5546},
{"f_5015:posixunix_2escm",(void*)f_5015},
{"f_5028:posixunix_2escm",(void*)f_5028},
{"f_5514:posixunix_2escm",(void*)f_5514},
{"f_5512:posixunix_2escm",(void*)f_5512},
{"f_5526:posixunix_2escm",(void*)f_5526},
{"f_5522:posixunix_2escm",(void*)f_5522},
{"f_8594:posixunix_2escm",(void*)f_8594},
{"f_8569:posixunix_2escm",(void*)f_8569},
{"f_8563:posixunix_2escm",(void*)f_8563},
{"f_5559:posixunix_2escm",(void*)f_5559},
{"f_8588:posixunix_2escm",(void*)f_8588},
{"f_4762:posixunix_2escm",(void*)f_4762},
{"f_8582:posixunix_2escm",(void*)f_8582},
{"f_4791:posixunix_2escm",(void*)f_4791},
{"f_4732:posixunix_2escm",(void*)f_4732},
{"f_8572:posixunix_2escm",(void*)f_8572},
{"f_8512:posixunix_2escm",(void*)f_8512},
{"f_8515:posixunix_2escm",(void*)f_8515},
{"f_4061:posixunix_2escm",(void*)f_4061},
{"f_4054:posixunix_2escm",(void*)f_4054},
{"f_7666:posixunix_2escm",(void*)f_7666},
{"f_7662:posixunix_2escm",(void*)f_7662},
{"f_8506:posixunix_2escm",(void*)f_8506},
{"f_8553:posixunix_2escm",(void*)f_8553},
{"f_8550:posixunix_2escm",(void*)f_8550},
{"f_6793:posixunix_2escm",(void*)f_6793},
{"f_6794:posixunix_2escm",(void*)f_6794},
{"f_8525:posixunix_2escm",(void*)f_8525},
{"f_6184:posixunix_2escm",(void*)f_6184},
{"f_7670:posixunix_2escm",(void*)f_7670},
{"f_6198:posixunix_2escm",(void*)f_6198},
{"f_6192:posixunix_2escm",(void*)f_6192},
{"f_7802:posixunix_2escm",(void*)f_7802},
{"f_8544:posixunix_2escm",(void*)f_8544},
{"f_5030:posixunix_2escm",(void*)f_5030},
{"f_7617:posixunix_2escm",(void*)f_7617},
{"f_7610:posixunix_2escm",(void*)f_7610},
{"f_5044:posixunix_2escm",(void*)f_5044},
{"f_6759:posixunix_2escm",(void*)f_6759},
{"f_7648:posixunix_2escm",(void*)f_7648},
{"f_5051:posixunix_2escm",(void*)f_5051},
{"f_8534:posixunix_2escm",(void*)f_8534},
{"f_8531:posixunix_2escm",(void*)f_8531},
{"f_7546:posixunix_2escm",(void*)f_7546},
{"f_7542:posixunix_2escm",(void*)f_7542},
{"f_5061:posixunix_2escm",(void*)f_5061},
{"f_6120:posixunix_2escm",(void*)f_6120},
{"f_6743:posixunix_2escm",(void*)f_6743},
{"f_6749:posixunix_2escm",(void*)f_6749},
{"f_6741:posixunix_2escm",(void*)f_6741},
{"f_2802:posixunix_2escm",(void*)f_2802},
{"f_2804:posixunix_2escm",(void*)f_2804},
{"f_2808:posixunix_2escm",(void*)f_2808},
{"f_6722:posixunix_2escm",(void*)f_6722},
{"f_2835:posixunix_2escm",(void*)f_2835},
{"f_6288:posixunix_2escm",(void*)f_6288},
{"f_6118:posixunix_2escm",(void*)f_6118},
{"f_6771:posixunix_2escm",(void*)f_6771},
{"f_6779:posixunix_2escm",(void*)f_6779},
{"f_6292:posixunix_2escm",(void*)f_6292},
{"f_6294:posixunix_2escm",(void*)f_6294},
{"f_6298:posixunix_2escm",(void*)f_6298},
{"f_4834:posixunix_2escm",(void*)f_4834},
{"f_4836:posixunix_2escm",(void*)f_4836},
{"f_5260:posixunix_2escm",(void*)f_5260},
{"f_5774:posixunix_2escm",(void*)f_5774},
{"f_5781:posixunix_2escm",(void*)f_5781},
{"f_4673:posixunix_2escm",(void*)f_4673},
{"f_7493:posixunix_2escm",(void*)f_7493},
{"f_7499:posixunix_2escm",(void*)f_7499},
{"f_3880:posixunix_2escm",(void*)f_3880},
{"f_3883:posixunix_2escm",(void*)f_3883},
{"f_3885:posixunix_2escm",(void*)f_3885},
{"f_5242:posixunix_2escm",(void*)f_5242},
{"f_7377:posixunix_2escm",(void*)f_7377},
{"f_5246:posixunix_2escm",(void*)f_5246},
{"f_3898:posixunix_2escm",(void*)f_3898},
{"f_3891:posixunix_2escm",(void*)f_3891},
{"f_3893:posixunix_2escm",(void*)f_3893},
{"f_7361:posixunix_2escm",(void*)f_7361},
{"f_5251:posixunix_2escm",(void*)f_5251},
{"f_7369:posixunix_2escm",(void*)f_7369},
{"f_5256:posixunix_2escm",(void*)f_5256},
{"f_3866:posixunix_2escm",(void*)f_3866},
{"f_3863:posixunix_2escm",(void*)f_3863},
{"f_3860:posixunix_2escm",(void*)f_3860},
{"f_2810:posixunix_2escm",(void*)f_2810},
{"f_2814:posixunix_2escm",(void*)f_2814},
{"f_2816:posixunix_2escm",(void*)f_2816},
{"f_3874:posixunix_2escm",(void*)f_3874},
{"f_3871:posixunix_2escm",(void*)f_3871},
{"f_3877:posixunix_2escm",(void*)f_3877},
{"f_4666:posixunix_2escm",(void*)f_4666},
{"f_4663:posixunix_2escm",(void*)f_4663},
{"f_3780:posixunix_2escm",(void*)f_3780},
{"f_6148:posixunix_2escm",(void*)f_6148},
{"f_5202:posixunix_2escm",(void*)f_5202},
{"f_5208:posixunix_2escm",(void*)f_5208},
{"f_6159:posixunix_2escm",(void*)f_6159},
{"f_6155:posixunix_2escm",(void*)f_6155},
{"f_4562:posixunix_2escm",(void*)f_4562},
{"f_6154:posixunix_2escm",(void*)f_6154},
{"f_5708:posixunix_2escm",(void*)f_5708},
{"f_5212:posixunix_2escm",(void*)f_5212},
{"f_5217:posixunix_2escm",(void*)f_5217},
{"f_5758:posixunix_2escm",(void*)f_5758},
{"f_4591:posixunix_2escm",(void*)f_4591},
{"f_4569:posixunix_2escm",(void*)f_4569},
{"f_2696:posixunix_2escm",(void*)f_2696},
{"f_2684:posixunix_2escm",(void*)f_2684},
{"f_2681:posixunix_2escm",(void*)f_2681},
{"f_7409:posixunix_2escm",(void*)f_7409},
{"f_5746:posixunix_2escm",(void*)f_5746},
{"f_2678:posixunix_2escm",(void*)f_2678},
{"f_2675:posixunix_2escm",(void*)f_2675},
{"f_2672:posixunix_2escm",(void*)f_2672},
{"f_7391:posixunix_2escm",(void*)f_7391},
{"f_7396:posixunix_2escm",(void*)f_7396},
{"f_3622:posixunix_2escm",(void*)f_3622},
{"f_7381:posixunix_2escm",(void*)f_7381},
{"f_7385:posixunix_2escm",(void*)f_7385},
{"f_8364:posixunix_2escm",(void*)f_8364},
{"f_3601:posixunix_2escm",(void*)f_3601},
{"f_5222:posixunix_2escm",(void*)f_5222},
{"f_5226:posixunix_2escm",(void*)f_5226},
{"f_3662:posixunix_2escm",(void*)f_3662},
{"f_4581:posixunix_2escm",(void*)f_4581},
{"f_5231:posixunix_2escm",(void*)f_5231},
{"f_4703:posixunix_2escm",(void*)f_4703},
{"f_5236:posixunix_2escm",(void*)f_5236},
{"f_4599:posixunix_2escm",(void*)f_4599},
{"f_8394:posixunix_2escm",(void*)f_8394},
{"f_3630:posixunix_2escm",(void*)f_3630},
{"f_3634:posixunix_2escm",(void*)f_3634},
{"f_4585:posixunix_2escm",(void*)f_4585},
{"f_4588:posixunix_2escm",(void*)f_4588},
{"f_3642:posixunix_2escm",(void*)f_3642},
{"f_8340:posixunix_2escm",(void*)f_8340},
{"f_3618:posixunix_2escm",(void*)f_3618},
{"f_4487:posixunix_2escm",(void*)f_4487},
{"f_4484:posixunix_2escm",(void*)f_4484},
{"f_4481:posixunix_2escm",(void*)f_4481},
{"f_8344:posixunix_2escm",(void*)f_8344},
{"f_8346:posixunix_2escm",(void*)f_8346},
{"f_5470:posixunix_2escm",(void*)f_5470},
{"f_5474:posixunix_2escm",(void*)f_5474},
{"f_5478:posixunix_2escm",(void*)f_5478},
{"f_4471:posixunix_2escm",(void*)f_4471},
{"f_3082:posixunix_2escm",(void*)f_3082},
{"f_3080:posixunix_2escm",(void*)f_3080},
{"f_3096:posixunix_2escm",(void*)f_3096},
{"f_3094:posixunix_2escm",(void*)f_3094},
{"f_5492:posixunix_2escm",(void*)f_5492},
{"f_3067:posixunix_2escm",(void*)f_3067},
{"f_5466:posixunix_2escm",(void*)f_5466},
{"f_8321:posixunix_2escm",(void*)f_8321},
{"f_8466:posixunix_2escm",(void*)f_8466},
{"f_7607:posixunix_2escm",(void*)f_7607},
{"f_7603:posixunix_2escm",(void*)f_7603},
{"f_8318:posixunix_2escm",(void*)f_8318},
{"f_5482:posixunix_2escm",(void*)f_5482},
{"f_8326:posixunix_2escm",(void*)f_8326},
{"f_3025:posixunix_2escm",(void*)f_3025},
{"f_6960:posixunix_2escm",(void*)f_6960},
{"f_3030:posixunix_2escm",(void*)f_3030},
{"f_3038:posixunix_2escm",(void*)f_3038},
{"f_8490:posixunix_2escm",(void*)f_8490},
{"toplevel:posixunix_2escm",(void*)C_posix_toplevel},
{"f_5411:posixunix_2escm",(void*)f_5411},
{"f_6732:posixunix_2escm",(void*)f_6732},
{"f_5415:posixunix_2escm",(void*)f_5415},
{"f_6737:posixunix_2escm",(void*)f_6737},
{"f_8449:posixunix_2escm",(void*)f_8449},
{"f_5419:posixunix_2escm",(void*)f_5419},
{"f_8441:posixunix_2escm",(void*)f_8441},
{"f_6253:posixunix_2escm",(void*)f_6253},
{"f_6250:posixunix_2escm",(void*)f_6250},
{"f_6928:posixunix_2escm",(void*)f_6928},
{"f_6921:posixunix_2escm",(void*)f_6921},
{"f_6259:posixunix_2escm",(void*)f_6259},
{"f_6220:posixunix_2escm",(void*)f_6220},
{"f_5432:posixunix_2escm",(void*)f_5432},
{"f_6939:posixunix_2escm",(void*)f_6939},
{"f_5436:posixunix_2escm",(void*)f_5436},
{"f_5403:posixunix_2escm",(void*)f_5403},
{"f_8479:posixunix_2escm",(void*)f_8479},
{"f_5407:posixunix_2escm",(void*)f_5407},
{"f_8472:posixunix_2escm",(void*)f_8472},
{"f_5453:posixunix_2escm",(void*)f_5453},
{"f_8485:posixunix_2escm",(void*)f_8485},
{"f_6217:posixunix_2escm",(void*)f_6217},
{"f_3501:posixunix_2escm",(void*)f_3501},
{"f_5425:posixunix_2escm",(void*)f_5425},
{"f_5444:posixunix_2escm",(void*)f_5444},
{"f_5440:posixunix_2escm",(void*)f_5440},
{"f_5446:posixunix_2escm",(void*)f_5446},
{"f_7153:posixunix_2escm",(void*)f_7153},
{"f_3561:posixunix_2escm",(void*)f_3561},
{"f_3567:posixunix_2escm",(void*)f_3567},
{"f_7994:posixunix_2escm",(void*)f_7994},
{"f_7115:posixunix_2escm",(void*)f_7115},
{"f_2771:posixunix_2escm",(void*)f_2771},
{"f_6368:posixunix_2escm",(void*)f_6368},
{"f_6492:posixunix_2escm",(void*)f_6492},
{"f_2764:posixunix_2escm",(void*)f_2764},
{"f_6376:posixunix_2escm",(void*)f_6376},
{"f_6378:posixunix_2escm",(void*)f_6378},
{"f_6462:posixunix_2escm",(void*)f_6462},
{"f_7953:posixunix_2escm",(void*)f_7953},
{"f_2792:posixunix_2escm",(void*)f_2792},
{"f_2796:posixunix_2escm",(void*)f_2796},
{"f_7950:posixunix_2escm",(void*)f_7950},
{"f_2798:posixunix_2escm",(void*)f_2798},
{"f_2790:posixunix_2escm",(void*)f_2790},
{"f_7357:posixunix_2escm",(void*)f_7357},
{"f_2784:posixunix_2escm",(void*)f_2784},
{"f_7985:posixunix_2escm",(void*)f_7985},
{"f_2786:posixunix_2escm",(void*)f_2786},
{"f_7989:posixunix_2escm",(void*)f_7989},
{"f_7108:posixunix_2escm",(void*)f_7108},
{"f_7340:posixunix_2escm",(void*)f_7340},
{"f_3465:posixunix_2escm",(void*)f_3465},
{"f_7912:posixunix_2escm",(void*)f_7912},
{"f_7437:posixunix_2escm",(void*)f_7437},
{"f_7434:posixunix_2escm",(void*)f_7434},
{"f_7430:posixunix_2escm",(void*)f_7430},
{"f_4318:posixunix_2escm",(void*)f_4318},
{"f_4311:posixunix_2escm",(void*)f_4311},
{"f_7316:posixunix_2escm",(void*)f_7316},
{"f_7423:posixunix_2escm",(void*)f_7423},
{"f_3441:posixunix_2escm",(void*)f_3441},
{"f_3444:posixunix_2escm",(void*)f_3444},
{"f_3447:posixunix_2escm",(void*)f_3447},
{"f_4556:posixunix_2escm",(void*)f_4556},
{"f_3841:posixunix_2escm",(void*)f_3841},
{"f_3451:posixunix_2escm",(void*)f_3451},
{"f_3847:posixunix_2escm",(void*)f_3847},
{"f_7964:posixunix_2escm",(void*)f_7964},
{"f_7960:posixunix_2escm",(void*)f_7960},
{"f_7449:posixunix_2escm",(void*)f_7449},
{"f_4549:posixunix_2escm",(void*)f_4549},
{"f_7440:posixunix_2escm",(void*)f_7440},
{"f_3854:posixunix_2escm",(void*)f_3854},
{"f_3851:posixunix_2escm",(void*)f_3851},
{"f_3426:posixunix_2escm",(void*)f_3426},
{"f_3422:posixunix_2escm",(void*)f_3422},
{"f_3857:posixunix_2escm",(void*)f_3857},
{"f_7325:posixunix_2escm",(void*)f_7325},
{"f_3824:posixunix_2escm",(void*)f_3824},
{"f_3825:posixunix_2escm",(void*)f_3825},
{"f_6472:posixunix_2escm",(void*)f_6472},
{"f_2961:posixunix_2escm",(void*)f_2961},
{"f_2963:posixunix_2escm",(void*)f_2963},
{"f_3833:posixunix_2escm",(void*)f_3833},
{"f_3404:posixunix_2escm",(void*)f_3404},
{"f_2913:posixunix_2escm",(void*)f_2913},
{"f_2911:posixunix_2escm",(void*)f_2911},
{"f_4512:posixunix_2escm",(void*)f_4512},
{"f_4375:posixunix_2escm",(void*)f_4375},
{"f_4519:posixunix_2escm",(void*)f_4519},
{"f_3808:posixunix_2escm",(void*)f_3808},
{"f_5957:posixunix_2escm",(void*)f_5957},
{"f_5958:posixunix_2escm",(void*)f_5958},
{"f_2903:posixunix_2escm",(void*)f_2903},
{"f_3815:posixunix_2escm",(void*)f_3815},
{"f_5953:posixunix_2escm",(void*)f_5953},
{"f_2931:posixunix_2escm",(void*)f_2931},
{"f_2933:posixunix_2escm",(void*)f_2933},
{"f_5963:posixunix_2escm",(void*)f_5963},
{"f_7145:posixunix_2escm",(void*)f_7145},
{"f_8277:posixunix_2escm",(void*)f_8277},
{"f_8275:posixunix_2escm",(void*)f_8275},
{"f_4528:posixunix_2escm",(void*)f_4528},
{"f_4522:posixunix_2escm",(void*)f_4522},
{"f_4171:posixunix_2escm",(void*)f_4171},
{"f_2951:posixunix_2escm",(void*)f_2951},
{"f_7132:posixunix_2escm",(void*)f_7132},
{"f_2953:posixunix_2escm",(void*)f_2953},
{"f_4189:posixunix_2escm",(void*)f_4189},
{"f_8282:posixunix_2escm",(void*)f_8282},
{"f_5998:posixunix_2escm",(void*)f_5998},
{"f_2941:posixunix_2escm",(void*)f_2941},
{"f_2943:posixunix_2escm",(void*)f_2943},
{"f_8291:posixunix_2escm",(void*)f_8291},
{"f_5992:posixunix_2escm",(void*)f_5992},
{"f_2971:posixunix_2escm",(void*)f_2971},
{"f_2976:posixunix_2escm",(void*)f_2976},
{"f_4141:posixunix_2escm",(void*)f_4141},
{"f_4197:posixunix_2escm",(void*)f_4197},
{"f_4131:posixunix_2escm",(void*)f_4131},
{"f_4133:posixunix_2escm",(void*)f_4133},
{"f_6904:posixunix_2escm",(void*)f_6904},
{"f_6914:posixunix_2escm",(void*)f_6914},
{"f_7290:posixunix_2escm",(void*)f_7290},
{"f_2921:posixunix_2escm",(void*)f_2921},
{"f_2923:posixunix_2escm",(void*)f_2923},
{"f_5949:posixunix_2escm",(void*)f_5949},
{"f_4108:posixunix_2escm",(void*)f_4108},
{"f_8208:posixunix_2escm",(void*)f_8208},
{"f_8201:posixunix_2escm",(void*)f_8201},
{"f_3678:posixunix_2escm",(void*)f_3678},
{"f_3675:posixunix_2escm",(void*)f_3675},
{"f_5919:posixunix_2escm",(void*)f_5919},
{"f_4127:posixunix_2escm",(void*)f_4127},
{"f_8212:posixunix_2escm",(void*)f_8212},
{"f_8219:posixunix_2escm",(void*)f_8219},
{"f_3687:posixunix_2escm",(void*)f_3687},
{"f_3685:posixunix_2escm",(void*)f_3685},
{"f_5913:posixunix_2escm",(void*)f_5913},
{"f_5926:posixunix_2escm",(void*)f_5926},
{"f_5928:posixunix_2escm",(void*)f_5928},
{"f_4116:posixunix_2escm",(void*)f_4116},
{"f_8225:posixunix_2escm",(void*)f_8225},
{"f_5649:posixunix_2escm",(void*)f_5649},
{"f_5977:posixunix_2escm",(void*)f_5977},
{"f_5659:posixunix_2escm",(void*)f_5659},
{"f_8231:posixunix_2escm",(void*)f_8231},
{"f_8242:posixunix_2escm",(void*)f_8242},
{"f_8246:posixunix_2escm",(void*)f_8246},
{"f_4425:posixunix_2escm",(void*)f_4425},
{"f_4428:posixunix_2escm",(void*)f_4428},
{"f_8258:posixunix_2escm",(void*)f_8258},
{"f_8254:posixunix_2escm",(void*)f_8254},
{"f_3305:posixunix_2escm",(void*)f_3305},
{"f_5678:posixunix_2escm",(void*)f_5678},
{"f_8250:posixunix_2escm",(void*)f_8250},
{"f_4412:posixunix_2escm",(void*)f_4412},
{"f_3315:posixunix_2escm",(void*)f_3315},
{"f_8262:posixunix_2escm",(void*)f_8262},
{"f_4408:posixunix_2escm",(void*)f_4408},
{"f_3975:posixunix_2escm",(void*)f_3975},
{"f_3971:posixunix_2escm",(void*)f_3971},
{"f_3321:posixunix_2escm",(void*)f_3321},
{"f_5619:posixunix_2escm",(void*)f_5619},
{"f_7283:posixunix_2escm",(void*)f_7283},
{"f_5623:posixunix_2escm",(void*)f_5623},
{"f_3900:posixunix_2escm",(void*)f_3900},
{"f_3331:posixunix_2escm",(void*)f_3331},
{"f_3333:posixunix_2escm",(void*)f_3333},
{"f_5629:posixunix_2escm",(void*)f_5629},
{"f_5626:posixunix_2escm",(void*)f_5626},
{"f_5634:posixunix_2escm",(void*)f_5634},
{"f_3340:posixunix_2escm",(void*)f_3340},
{"f_3343:posixunix_2escm",(void*)f_3343},
{"f_3919:posixunix_2escm",(void*)f_3919},
{"f_4219:posixunix_2escm",(void*)f_4219},
{"f_3923:posixunix_2escm",(void*)f_3923},
{"f_3359:posixunix_2escm",(void*)f_3359},
{"f_4449:posixunix_2escm",(void*)f_4449},
{"f_4440:posixunix_2escm",(void*)f_4440},
{"f_4201:posixunix_2escm",(void*)f_4201},
{"f_3366:posixunix_2escm",(void*)f_3366},
{"f_5909:posixunix_2escm",(void*)f_5909},
{"f_7796:posixunix_2escm",(void*)f_7796},
{"f_7799:posixunix_2escm",(void*)f_7799},
{"f_3944:posixunix_2escm",(void*)f_3944},
{"f_3940:posixunix_2escm",(void*)f_3940},
{"f_4272:posixunix_2escm",(void*)f_4272},
{"f_5903:posixunix_2escm",(void*)f_5903},
{"f_4163:posixunix_2escm",(void*)f_4163},
{"f_4266:posixunix_2escm",(void*)f_4266},
{"f_4153:posixunix_2escm",(void*)f_4153},
{"f_5683:posixunix_2escm",(void*)f_5683},
{"f_5687:posixunix_2escm",(void*)f_5687},
{"f_5692:posixunix_2escm",(void*)f_5692},
{"f_4159:posixunix_2escm",(void*)f_4159},
{"f_7756:posixunix_2escm",(void*)f_7756},
{"f_8179:posixunix_2escm",(void*)f_8179},
{"f_8173:posixunix_2escm",(void*)f_8173},
{"f_5392:posixunix_2escm",(void*)f_5392},
{"f_8175:posixunix_2escm",(void*)f_8175},
{"f_5396:posixunix_2escm",(void*)f_5396},
{"f_5192:posixunix_2escm",(void*)f_5192},
{"f_5197:posixunix_2escm",(void*)f_5197},
{"f_5360:posixunix_2escm",(void*)f_5360},
{"f_8185:posixunix_2escm",(void*)f_8185},
{"f_6098:posixunix_2escm",(void*)f_6098},
{"f_8182:posixunix_2escm",(void*)f_8182},
{"f_7778:posixunix_2escm",(void*)f_7778},
{"f_8197:posixunix_2escm",(void*)f_8197},
{"f_5376:posixunix_2escm",(void*)f_5376},
{"f_5173:posixunix_2escm",(void*)f_5173},
{"f_5179:posixunix_2escm",(void*)f_5179},
{"f_6691:posixunix_2escm",(void*)f_6691},
{"f_6079:posixunix_2escm",(void*)f_6079},
{"f_7719:posixunix_2escm",(void*)f_7719},
{"f_7710:posixunix_2escm",(void*)f_7710},
{"f_5183:posixunix_2escm",(void*)f_5183},
{"f_5188:posixunix_2escm",(void*)f_5188},
{"f_7928:posixunix_2escm",(void*)f_7928},
{"f_6666:posixunix_2escm",(void*)f_6666},
{"f_7786:posixunix_2escm",(void*)f_7786},
{"f_6665:posixunix_2escm",(void*)f_6665},
{"f_7781:posixunix_2escm",(void*)f_7781},
{"f_6083:posixunix_2escm",(void*)f_6083},
{"f_6672:posixunix_2escm",(void*)f_6672},
{"f_7733:posixunix_2escm",(void*)f_7733},
{"f_3588:posixunix_2escm",(void*)f_3588},
{"f_3582:posixunix_2escm",(void*)f_3582},
{"f_5303:posixunix_2escm",(void*)f_5303},
{"f_3599:posixunix_2escm",(void*)f_3599},
{"f_3592:posixunix_2escm",(void*)f_3592},
{"f_5117:posixunix_2escm",(void*)f_5117},
{"f_5110:posixunix_2escm",(void*)f_5110},
{"f_8106:posixunix_2escm",(void*)f_8106},
{"f_8100:posixunix_2escm",(void*)f_8100},
{"f_6018:posixunix_2escm",(void*)f_6018},
{"f_5125:posixunix_2escm",(void*)f_5125},
{"f_6341:posixunix_2escm",(void*)f_6341},
{"f_8030:posixunix_2escm",(void*)f_8030},
{"f_6024:posixunix_2escm",(void*)f_6024},
{"f_8111:posixunix_2escm",(void*)f_8111},
{"f_6357:posixunix_2escm",(void*)f_6357},
{"f_6353:posixunix_2escm",(void*)f_6353},
{"f_8004:posixunix_2escm",(void*)f_8004},
{"f_8000:posixunix_2escm",(void*)f_8000},
{"f_3135:posixunix_2escm",(void*)f_3135},
{"f_8007:posixunix_2escm",(void*)f_8007},
{"f_6448:posixunix_2escm",(void*)f_6448},
{"f_6444:posixunix_2escm",(void*)f_6444},
{"f_8123:posixunix_2escm",(void*)f_8123},
{"f_8122:posixunix_2escm",(void*)f_8122},
{"f_2739:posixunix_2escm",(void*)f_2739},
{"f_8050:posixunix_2escm",(void*)f_8050},
{"f_8054:posixunix_2escm",(void*)f_8054},
{"f_5101:posixunix_2escm",(void*)f_5101},
{"f_5352:posixunix_2escm",(void*)f_5352},
{"f_5354:posixunix_2escm",(void*)f_5354},
{"f_6457:posixunix_2escm",(void*)f_6457},
{"f_8056:posixunix_2escm",(void*)f_8056},
{"f_8134:posixunix_2escm",(void*)f_8134},
{"f_8138:posixunix_2escm",(void*)f_8138},
{"f_6006:posixunix_2escm",(void*)f_6006},
{"f_6008:posixunix_2escm",(void*)f_6008},
{"f_6331:posixunix_2escm",(void*)f_6331},
{"f_8026:posixunix_2escm",(void*)f_8026},
{"f_3152:posixunix_2escm",(void*)f_3152},
{"f_3158:posixunix_2escm",(void*)f_3158},
{"f_6426:posixunix_2escm",(void*)f_6426},
{"f_2752:posixunix_2escm",(void*)f_2752},
{"f_2759:posixunix_2escm",(void*)f_2759},
{"f_8071:posixunix_2escm",(void*)f_8071},
{"f_8159:posixunix_2escm",(void*)f_8159},
{"f_8077:posixunix_2escm",(void*)f_8077},
{"f_8705:posixunix_2escm",(void*)f_8705},
{"f_8703:posixunix_2escm",(void*)f_8703},
{"f_8156:posixunix_2escm",(void*)f_8156},
{"f_5327:posixunix_2escm",(void*)f_5327},
{"f_2743:posixunix_2escm",(void*)f_2743},
{"f_8152:posixunix_2escm",(void*)f_8152},
{"f_6319:posixunix_2escm",(void*)f_6319},
{"f_8715:posixunix_2escm",(void*)f_8715},
{"f_8162:posixunix_2escm",(void*)f_8162},
{"f_8091:posixunix_2escm",(void*)f_8091},
{"f_5869:posixunix_2escm",(void*)f_5869},
{"f_3185:posixunix_2escm",(void*)f_3185},
{"f_8725:posixunix_2escm",(void*)f_8725},
{"f_4962:posixunix_2escm",(void*)f_4962},
{"f_3198:posixunix_2escm",(void*)f_3198},
{"f_2711:posixunix_2escm",(void*)f_2711},
{"f_2714:posixunix_2escm",(void*)f_2714},
{"f_2718:posixunix_2escm",(void*)f_2718},
{"f_3126:posixunix_2escm",(void*)f_3126},
{"f_4969:posixunix_2escm",(void*)f_4969},
{"f_4981:posixunix_2escm",(void*)f_4981},
{"f_2700:posixunix_2escm",(void*)f_2700},
{"f_2707:posixunix_2escm",(void*)f_2707},
{"f_7591:posixunix_2escm",(void*)f_7591},
{"f_7595:posixunix_2escm",(void*)f_7595},
{"f_5891:posixunix_2escm",(void*)f_5891},
{"f_5897:posixunix_2escm",(void*)f_5897},
{"f_4972:posixunix_2escm",(void*)f_4972},
{"f_7080:posixunix_2escm",(void*)f_7080},
{"f_4988:posixunix_2escm",(void*)f_4988},
{"f_7021:posixunix_2escm",(void*)f_7021},
{"f_5845:posixunix_2escm",(void*)f_5845},
{"f_5843:posixunix_2escm",(void*)f_5843},
{"f_7025:posixunix_2escm",(void*)f_7025},
{"f_3168:posixunix_2escm",(void*)f_3168},
{"f_3165:posixunix_2escm",(void*)f_3165},
{"f_3479:posixunix_2escm",(void*)f_3479},
{"f_6039:posixunix_2escm",(void*)f_6039},
{"f_6036:posixunix_2escm",(void*)f_6036},
{"f_6033:posixunix_2escm",(void*)f_6033},
{"f_3108:posixunix_2escm",(void*)f_3108},
{"f_6045:posixunix_2escm",(void*)f_6045},
{"f_5871:posixunix_2escm",(void*)f_5871},
{"f_3110:posixunix_2escm",(void*)f_3110},
{"f_5881:posixunix_2escm",(void*)f_5881},
{"f_5889:posixunix_2escm",(void*)f_5889},
{"f_7869:posixunix_2escm",(void*)f_7869},
{"f_7511:posixunix_2escm",(void*)f_7511},
{"f_2992:posixunix_2escm",(void*)f_2992},
{"f_2998:posixunix_2escm",(void*)f_2998},
{"f_7003:posixunix_2escm",(void*)f_7003},
{"f_5822:posixunix_2escm",(void*)f_5822},
{"f_8678:posixunix_2escm",(void*)f_8678},
{"f_3491:posixunix_2escm",(void*)f_3491},
{"f_2980:posixunix_2escm",(void*)f_2980},
{"f_5159:posixunix_2escm",(void*)f_5159},
{"f_5155:posixunix_2escm",(void*)f_5155},
{"f_3731:posixunix_2escm",(void*)f_3731},
{"f_3734:posixunix_2escm",(void*)f_3734},
{NULL,NULL}};
#endif

static C_PTABLE_ENTRY *create_ptable(void){
#ifdef C_ENABLE_PTABLES
return ptable;
#else
return NULL;
#endif
}

/*
S|applied compiler syntax:
S|  for-each		3
o|eliminated procedure checks: 276 
o|specializations:
o|  1 (zero? fixnum)
o|  1 (##sys#check-output-port * * *)
o|  1 (##sys#check-input-port * * *)
o|  2 (##sys#length list)
o|  11 (cdr pair)
o|  1 (string-ref string fixnum)
o|  1 (string-length string)
o|  3 (##sys#check-list (or pair list) *)
o|  4 (make-string fixnum)
o|  4 (##sys#check-open-port * *)
o|  11 (eqv? * (not float))
o|  14 (car pair)
(o e)|safe calls: 860 
o|dropping redundant toplevel assignment: process 
o|dropping redundant toplevel assignment: process* 
o|safe globals: (file-stat ##sys#stat ##sys#posix-error posix-error) 
o|Removed `not' forms: 9 
o|contracted procedure: "(posix-common.scm:184) strerror64" 
o|inlining procedure: k2719 
o|inlining procedure: k2719 
o|inlining procedure: k2734 
o|inlining procedure: k2734 
o|inlining procedure: k2753 
o|inlining procedure: k2753 
o|inlining procedure: k2830 
o|inlining procedure: k2842 
o|inlining procedure: k2842 
o|inlining procedure: k2854 
o|inlining procedure: k2854 
o|inlining procedure: k2866 
o|inlining procedure: k2866 
o|inlining procedure: k2830 
o|inlining procedure: k2987 
o|inlining procedure: k2987 
o|inlining procedure: k2999 
o|inlining procedure: k2999 
o|inlining procedure: k3009 
o|inlining procedure: k3009 
o|inlining procedure: k3036 
o|contracted procedure: k3052 
o|inlining procedure: k3049 
o|inlining procedure: k3049 
o|substituted constant variable: a3062 
o|inlining procedure: k3036 
o|inlining procedure: k3069 
o|inlining procedure: k3069 
o|substituted constant variable: a3113 
o|inlining procedure: k3114 
o|inlining procedure: k3114 
o|contracted procedure: k3130 
o|inlining procedure: k3133 
o|inlining procedure: k3133 
o|inlining procedure: k3166 
o|inlining procedure: k3166 
o|inlining procedure: k3190 
o|inlining procedure: k3190 
o|substituted constant variable: a3211 
o|inlining procedure: k3230 
o|inlining procedure: k3230 
o|inlining procedure: k3251 
o|propagated global variable: r32528777 delete-file 
o|inlining procedure: k3251 
o|inlining procedure: k3243 
o|inlining procedure: k3275 
o|inlining procedure: k3275 
o|inlining procedure: k3243 
o|inlining procedure: k3313 
o|inlining procedure: k3313 
o|inlining procedure: k3335 
o|contracted procedure: "(posix-common.scm:462) g336337" 
o|inlining procedure: k3346 
o|inlining procedure: k3346 
o|inlining procedure: k3335 
o|inlining procedure: k3383 
o|inlining procedure: k3383 
o|contracted procedure: "(posix-common.scm:463) g354355" 
o|inlining procedure: k3391 
o|inlining procedure: k3391 
o|inlining procedure: k3452 
o|inlining procedure: k3452 
o|inlining procedure: k3467 
o|inlining procedure: k3467 
o|inlining procedure: k3508 
o|inlining procedure: k3508 
o|substituted constant variable: a3530 
o|substituted constant variable: a3532 
o|inlining procedure: k3569 
o|inlining procedure: k3569 
o|inlining procedure: k3603 
o|inlining procedure: k3603 
o|inlining procedure: k3656 
o|inlining procedure: k3656 
o|inlining procedure: k3664 
o|inlining procedure: k3664 
o|contracted procedure: "(posix-common.scm:557) find-files" 
o|inlining procedure: k3689 
o|inlining procedure: k3689 
o|inlining procedure: k3710 
o|inlining procedure: k3710 
o|inlining procedure: k3729 
o|inlining procedure: k3729 
o|inlining procedure: k3738 
o|inlining procedure: k3770 
o|inlining procedure: k3770 
o|inlining procedure: k3738 
o|inlining procedure: k3788 
o|inlining procedure: k3788 
o|inlining procedure: k3803 
o|inlining procedure: k3803 
o|contracted procedure: k3830 
o|inlining procedure: k3835 
o|inlining procedure: k3835 
o|inlining procedure: k3905 
o|inlining procedure: k3905 
o|inlining procedure: k3982 
o|inlining procedure: k3982 
o|contracted procedure: "(posix-common.scm:594) ctime552" 
o|inlining procedure: k4018 
o|inlining procedure: k4018 
o|inlining procedure: k4062 
o|contracted procedure: "(posix-common.scm:617) strftime579" 
o|inlining procedure: k4048 
o|inlining procedure: k4048 
o|inlining procedure: k4062 
o|contracted procedure: "(posix-common.scm:619) asctime578" 
o|inlining procedure: k4035 
o|inlining procedure: k4035 
o|inlining procedure: k4164 
o|inlining procedure: k4173 
o|inlining procedure: k4173 
o|inlining procedure: k4164 
o|contracted procedure: "(posix-common.scm:643) get631" 
o|inlining procedure: k4274 
o|inlining procedure: k4274 
o|inlining procedure: k4389 
o|inlining procedure: k4389 
o|contracted procedure: "(posixunix.scm:497) fcntl770" 
o|inlining procedure: k4426 
o|inlining procedure: k4426 
o|inlining procedure: k4451 
o|inlining procedure: k4451 
o|inlining procedure: k4485 
o|inlining procedure: k4485 
o|inlining procedure: k4526 
o|inlining procedure: k4526 
o|inlining procedure: k4629 
o|inlining procedure: k4629 
o|inlining procedure: k4652 
o|inlining procedure: k4652 
o|inlining procedure: k4675 
o|inlining procedure: k4684 
o|inlining procedure: k4684 
o|inlining procedure: k4675 
o|inlining procedure: k4690 
o|inlining procedure: k4690 
o|inlining procedure: k4705 
o|inlining procedure: k4705 
o|contracted procedure: "(posixunix.scm:603) g948949" 
o|inlining procedure: k4724 
o|inlining procedure: k4724 
o|inlining procedure: k4764 
o|inlining procedure: k4764 
o|contracted procedure: "(posixunix.scm:595) g929930" 
o|inlining procedure: k4783 
o|inlining procedure: k4783 
o|contracted procedure: "(posixunix.scm:589) g903904" 
o|inlining procedure: k4838 
o|inlining procedure: k4838 
o|contracted procedure: "(posixunix.scm:583) g888889" 
o|inlining procedure: k4855 
o|inlining procedure: k4855 
o|inlining procedure: k4880 
o|inlining procedure: k4880 
o|contracted procedure: "(posixunix.scm:577) g870871" 
o|inlining procedure: k4897 
o|inlining procedure: k4897 
o|contracted procedure: k4927 
o|inlining procedure: k4930 
o|inlining procedure: k4930 
o|contracted procedure: k4942 
o|inlining procedure: k4945 
o|inlining procedure: k4945 
o|inlining procedure: k4970 
o|inlining procedure: k4970 
o|inlining procedure: k4986 
o|inlining procedure: k4986 
o|inlining procedure: k4999 
o|inlining procedure: k4999 
o|inlining procedure: k5017 
o|inlining procedure: k5017 
o|inlining procedure: k5042 
o|inlining procedure: k5042 
o|inlining procedure: "(posixunix.scm:654) badmode976" 
o|substituted constant variable: a5066 
o|substituted constant variable: a5068 
o|inlining procedure: k5082 
o|inlining procedure: k5082 
o|inlining procedure: "(posixunix.scm:665) badmode976" 
o|substituted constant variable: a5106 
o|substituted constant variable: a5108 
o|substituted constant variable: a5113 
o|substituted constant variable: a5114 
o|inlining procedure: k5115 
o|inlining procedure: k5115 
o|substituted constant variable: a5128 
o|substituted constant variable: a5129 
o|inlining procedure: k5130 
o|inlining procedure: k5130 
o|inlining procedure: k5258 
o|inlining procedure: k5258 
o|inlining procedure: k5316 
o|inlining procedure: k5316 
o|inlining procedure: k5329 
o|contracted procedure: "(posixunix.scm:796) g11031110" 
o|inlining procedure: k5329 
o|inlining procedure: k5365 
o|inlining procedure: k5365 
o|inlining procedure: k5381 
o|inlining procedure: k5381 
o|inlining procedure: k5454 
o|inlining procedure: k5454 
o|inlining procedure: k5547 
o|inlining procedure: k5574 
o|inlining procedure: k5574 
o|contracted procedure: "(posixunix.scm:944) group-member" 
o|inlining procedure: k5547 
o|inlining procedure: k5636 
o|inlining procedure: k5636 
o|contracted procedure: "(posixunix.scm:967) _get-groups" 
o|inlining procedure: "(posixunix.scm:965) _ensure-groups" 
o|inlining procedure: k5694 
o|inlining procedure: k5694 
o|inlining procedure: "(posixunix.scm:976) _ensure-groups" 
o|inlining procedure: k5766 
o|inlining procedure: k5766 
o|contracted procedure: "(posixunix.scm:993) init1248" 
o|inlining procedure: k5830 
o|inlining procedure: k5830 
o|inlining procedure: k5856 
o|inlining procedure: k5856 
o|inlining procedure: k5879 
o|inlining procedure: k5879 
o|inlining procedure: k5911 
o|inlining procedure: k5911 
o|inlining procedure: k5936 
o|inlining procedure: k5936 
o|inlining procedure: k5964 
o|inlining procedure: k5964 
o|inlining procedure: k5985 
o|inlining procedure: k6010 
o|inlining procedure: k6010 
o|inlining procedure: k6031 
o|inlining procedure: k6031 
o|inlining procedure: k6061 
o|inlining procedure: k6061 
o|inlining procedure: k5985 
o|inlining procedure: k6106 
o|inlining procedure: k6106 
o|contracted procedure: "(posixunix.scm:1147) link1381" 
o|inlining procedure: k6081 
o|inlining procedure: k6081 
o|inlining procedure: k6160 
o|inlining procedure: k6160 
o|inlining procedure: k6186 
o|inlining procedure: k6186 
o|inlining procedure: k6200 
o|inlining procedure: k6224 
o|inlining procedure: k6224 
o|inlining procedure: k6200 
o|inlining procedure: k6245 
o|inlining procedure: k6245 
o|inlining procedure: k6265 
o|inlining procedure: k6265 
o|inlining procedure: k6302 
o|inlining procedure: k6302 
o|inlining procedure: k6324 
o|inlining procedure: k6324 
o|inlining procedure: k6333 
o|inlining procedure: k6333 
o|inlining procedure: k6355 
o|inlining procedure: k6355 
o|inlining procedure: k6380 
o|inlining procedure: k6380 
o|inlining procedure: k6427 
o|inlining procedure: k6427 
o|inlining procedure: k6449 
o|inlining procedure: k6449 
o|inlining procedure: k6477 
o|inlining procedure: k6477 
o|inlining procedure: k6520 
o|inlining procedure: k6520 
o|inlining procedure: k6569 
o|inlining procedure: k6569 
o|inlining procedure: k6674 
o|inlining procedure: k6695 
o|inlining procedure: k6695 
o|inlining procedure: k6674 
o|inlining procedure: k6751 
o|inlining procedure: k6751 
o|inlining procedure: k6781 
o|inlining procedure: k6781 
o|inlining procedure: k6796 
o|inlining procedure: k6813 
o|inlining procedure: k6813 
o|inlining procedure: k6796 
o|inlining procedure: k6909 
o|inlining procedure: k6909 
o|inlining procedure: k6919 
o|inlining procedure: k6919 
o|inlining procedure: k7026 
o|inlining procedure: k7026 
o|inlining procedure: k7042 
o|inlining procedure: k7042 
o|inlining procedure: k7058 
o|contracted procedure: "(posixunix.scm:1380) g16331634" 
o|contracted procedure: k7066 
o|inlining procedure: k7063 
o|inlining procedure: k7063 
o|inlining procedure: k7058 
o|inlining procedure: k7093 
o|inlining procedure: k7093 
o|inlining procedure: k7119 
o|inlining procedure: k7119 
o|inlining procedure: k7154 
o|inlining procedure: k7154 
o|inlining procedure: k7166 
o|inlining procedure: k7166 
o|substituted constant variable: a7179 
o|substituted constant variable: a7181 
o|substituted constant variable: a7183 
o|contracted procedure: "(posixunix.scm:1449) mmap1670" 
o|contracted procedure: k7263 
o|inlining procedure: k7291 
o|inlining procedure: k7291 
o|contracted procedure: "(posixunix.scm:1459) munmap1701" 
o|contracted procedure: "(posixunix.scm:1477) strptime1720" 
o|inlining procedure: k7334 
o|inlining procedure: k7334 
o|inlining procedure: k7386 
o|inlining procedure: k7386 
o|contracted procedure: "(posixunix.scm:1505) ex01760" 
o|inlining procedure: k7444 
o|inlining procedure: k7444 
o|inlining procedure: k7454 
o|inlining procedure: k7454 
o|inlining procedure: k7467 
o|inlining procedure: k7467 
o|substituted constant variable: a7483 
o|substituted constant variable: a7485 
o|substituted constant variable: a7487 
o|substituted constant variable: a7496 
o|contracted procedure: k7503 
o|inlining procedure: k7500 
o|inlining procedure: k7500 
o|inlining procedure: k7515 
o|inlining procedure: k7515 
o|contracted procedure: "(posixunix.scm:1545) ttyname1796" 
o|inlining procedure: k7571 
o|inlining procedure: k7571 
o|contracted procedure: "(posixunix.scm:1556) ttysize1805" 
o|inlining procedure: k7608 
o|inlining procedure: k7608 
o|contracted procedure: "(posixunix.scm:1569) getit1827" 
o|inlining procedure: k7649 
o|inlining procedure: k7649 
o|contracted procedure: "(posixunix.scm:1582) fork1834" 
o|contracted procedure: "(posixunix.scm:1578) g18531854" 
o|inlining procedure: k7634 
o|inlining procedure: k7634 
o|inlining procedure: k7788 
o|contracted procedure: "(posixunix.scm:1626) freeenv1873" 
o|contracted procedure: "(posixunix.scm:1625) freeargs1871" 
o|inlining procedure: k7830 
o|inlining procedure: k7830 
o|inlining procedure: k7788 
o|inlining procedure: k7918 
o|inlining procedure: k7918 
o|inlining procedure: k7937 
o|inlining procedure: k7937 
o|inlining procedure: k7971 
o|inlining procedure: k7971 
o|inlining procedure: k7990 
o|inlining procedure: k7990 
o|contracted procedure: k8011 
o|inlining procedure: k8008 
o|inlining procedure: k8008 
o|inlining procedure: k8061 
o|inlining procedure: k8079 
o|inlining procedure: k8079 
o|inlining procedure: k8061 
o|removed unused formal parameters: (loc2004) 
o|inlining procedure: k8093 
o|inlining procedure: k8093 
o|removed unused formal parameters: (loc2009 fd2012) 
o|inlining procedure: k8113 
o|inlining procedure: k8113 
o|inlining procedure: k8125 
o|contracted procedure: "(posixunix.scm:1727) replace-fd1984" 
o|inlining procedure: k8042 
o|inlining procedure: k8042 
o|inlining procedure: k8125 
o|inlining procedure: k8140 
o|inlining procedure: k8140 
o|removed unused parameter to known procedure: loc2004 "(posixunix.scm:1737) needed-pipe1990" 
o|removed unused parameter to known procedure: loc2004 "(posixunix.scm:1736) needed-pipe1990" 
o|removed unused parameter to known procedure: loc2004 "(posixunix.scm:1735) needed-pipe1990" 
o|removed unused formal parameters: (pid2044) 
o|inlining procedure: k8202 
o|inlining procedure: k8202 
o|removed unused parameter to known procedure: loc2009 "(posixunix.scm:1748) connect-parent1991" 
o|removed unused parameter to known procedure: fd2012 "(posixunix.scm:1748) connect-parent1991" 
o|removed unused formal parameters: (pid2052) 
o|inlining procedure: k8213 
o|inlining procedure: k8213 
o|removed unused parameter to known procedure: loc2009 "(posixunix.scm:1752) connect-parent1991" 
o|removed unused parameter to known procedure: fd2012 "(posixunix.scm:1752) connect-parent1991" 
o|removed unused parameter to known procedure: pid2044 "(posixunix.scm:1767) input-port2025" 
o|removed unused parameter to known procedure: pid2052 "(posixunix.scm:1764) output-port2026" 
o|removed unused parameter to known procedure: pid2044 "(posixunix.scm:1762) input-port2025" 
o|inlining procedure: k8293 
o|inlining procedure: k8293 
o|inlining procedure: k8454 
o|inlining procedure: k8454 
o|contracted procedure: "(posixunix.scm:1809) chroot2152" 
o|inlining procedure: k8439 
o|inlining procedure: k8439 
o|inlining procedure: k8477 
o|inlining procedure: k8477 
o|inlining procedure: k8498 
o|inlining procedure: k8498 
o|inlining procedure: k8517 
o|inlining procedure: k8517 
o|inlining procedure: k8536 
o|inlining procedure: k8536 
o|inlining procedure: k8555 
o|inlining procedure: k8555 
o|inlining procedure: k8574 
o|inlining procedure: k8574 
o|inlining procedure: k8596 
o|inlining procedure: k8596 
o|inlining procedure: k8611 
o|inlining procedure: k8611 
o|inlining procedure: k8643 
o|inlining procedure: k8643 
o|inlining procedure: k8667 
o|inlining procedure: k8667 
o|inlining procedure: k8679 
o|inlining procedure: k8679 
o|inlining procedure: k8689 
o|inlining procedure: k8689 
o|inlining procedure: k8726 
o|inlining procedure: k8726 
o|contracted procedure: "(posix-common.scm:256) g116117" 
o|inlining procedure: k8713 
o|inlining procedure: k8713 
o|replaced variables: 897 
o|removed binding forms: 567 
o|substituted constant variable: r27208736 
o|substituted constant variable: r28438742 
o|substituted constant variable: r28558744 
o|substituted constant variable: r28678746 
o|substituted constant variable: r28318748 
o|substituted constant variable: r30008752 
o|inlining procedure: k3036 
o|substituted constant variable: r30508758 
o|inlining procedure: k3036 
o|inlining procedure: k3036 
o|propagated global variable: g3033048778 delete-file 
o|inlining procedure: k3251 
o|inlining procedure: k3251 
o|propagated global variable: r32529252 delete-file 
o|propagated global variable: r32529252 delete-file 
o|converted assignments to bindings: (rmdir286) 
o|substituted constant variable: loc338 
o|substituted constant variable: loc338 
o|substituted constant variable: loc356 
o|substituted constant variable: loc356 
o|substituted constant variable: r34688805 
o|substituted constant variable: r35708809 
o|substituted constant variable: r36578815 
o|substituted constant variable: r36578815 
o|substituted constant variable: r36658819 
o|substituted constant variable: r36658819 
o|substituted constant variable: loc444 
o|substituted constant variable: r40498853 
o|substituted constant variable: r40498853 
o|substituted constant variable: r40368860 
o|substituted constant variable: r40368860 
o|substituted constant variable: r41658866 
o|substituted constant variable: r46538893 
o|substituted constant variable: r46538893 
o|substituted constant variable: r46538895 
o|substituted constant variable: r46538895 
o|inlining procedure: k4675 
o|inlining procedure: k4675 
o|substituted constant variable: r46858900 
o|inlining procedure: k4675 
o|substituted constant variable: r46768901 
o|substituted constant variable: r46768901 
o|substituted constant variable: r47258909 
o|substituted constant variable: r47258909 
o|substituted constant variable: r47848915 
o|substituted constant variable: r47848915 
o|substituted constant variable: r48568921 
o|substituted constant variable: r48568921 
o|substituted constant variable: r48988927 
o|substituted constant variable: r48988927 
o|substituted constant variable: r50008942 
o|removed side-effect free assignment to unused variable: badmode976 
o|inlining procedure: k5042 
o|inlining procedure: k5082 
o|substituted constant variable: r54558990 
o|substituted constant variable: r55758993 
o|substituted constant variable: r55488994 
o|removed side-effect free assignment to unused variable: _ensure-groups 
o|substituted constant variable: r56378995 
o|inlining procedure: k6031 
o|substituted constant variable: r60629038 
o|substituted constant variable: r60629038 
o|substituted constant variable: r60829045 
o|substituted constant variable: r60829045 
o|substituted constant variable: r61879049 
o|inlining procedure: k6257 
o|inlining procedure: k6257 
o|inlining procedure: k6339 
o|substituted constant variable: r64509081 
o|substituted constant variable: r65709093 
o|inlining procedure: k6757 
o|inlining procedure: k6919 
o|substituted constant variable: r70649118 
o|substituted constant variable: r71559125 
o|inlining procedure: k7237 
o|substituted constant variable: r73359133 
o|substituted constant variable: r73359133 
o|substituted constant variable: r74559141 
o|substituted constant variable: r74559141 
o|folded constant expression: (fx< (quote -1) (quote 0)) 
o|substituted constant variable: r75019145 
o|substituted constant variable: c-pointer18551859 
o|substituted constant variable: c-pointer18551859 
o|substituted constant variable: r76359159 
o|substituted constant variable: r76359159 
o|inlining procedure: k7937 
o|inlining procedure: k7937 
o|substituted constant variable: r79919174 
o|substituted constant variable: r80949182 
o|substituted constant variable: r81149184 
o|substituted constant variable: r81419190 
o|removed unused formal parameters: (stdfd2048) 
o|substituted constant variable: r82039192 
o|removed unused formal parameters: (stdfd2056) 
o|substituted constant variable: r82149194 
o|removed unused parameter to known procedure: stdfd2048 "(posixunix.scm:1767) input-port2025" 
o|removed unused parameter to known procedure: stdfd2056 "(posixunix.scm:1764) output-port2026" 
o|removed unused parameter to known procedure: stdfd2048 "(posixunix.scm:1762) input-port2025" 
o|substituted constant variable: r84409201 
o|substituted constant variable: r84409201 
o|converted assignments to bindings: (check1313) 
o|substituted constant variable: r86809232 
o|substituted constant variable: r87149239 
o|substituted constant variable: r87149239 
o|simplifications: ((let . 2)) 
o|replaced variables: 62 
o|removed binding forms: 935 
o|removed conditional forms: 1 
o|inlining procedure: k3511 
o|inlining procedure: k4225 
o|inlining procedure: k4225 
o|inlining procedure: k4497 
o|inlining procedure: k4497 
o|inlining procedure: k4542 
o|inlining procedure: k4542 
o|substituted constant variable: r46769294 
o|inlining procedure: k7253 
o|inlining procedure: k7253 
o|inlining procedure: k7815 
o|removed unused formal parameters: (loc2017) 
o|removed unused parameter to known procedure: loc2017 "(posixunix.scm:1744) connect-child1992" 
o|removed unused parameter to known procedure: loc2017 "(posixunix.scm:1743) connect-child1992" 
o|removed unused parameter to known procedure: loc2017 "(posixunix.scm:1742) connect-child1992" 
o|inlining procedure: k8405 
o|replaced variables: 27 
o|removed binding forms: 174 
o|substituted constant variable: r30379241 
o|substituted constant variable: r30379243 
o|substituted constant variable: r30379245 
o|substituted constant variable: r35129393 
o|substituted constant variable: r35129393 
o|substituted constant variable: r42269408 
o|substituted constant variable: r44989413 
o|substituted constant variable: r45439415 
o|substituted constant variable: r72549443 
o|contracted procedure: k7643 
o|contracted procedure: k7812 
o|removed unused formal parameters: (loc2030) 
o|removed unused parameter to known procedure: loc2030 "(posixunix.scm:1756) spawn2024" 
o|inlining procedure: k8640 
o|inlining procedure: k8640 
o|simplifications: ((let . 3)) 
o|replaced variables: 3 
o|removed binding forms: 30 
o|removed conditional forms: 4 
o|inlining procedure: k7415 
o|inlining procedure: k7415 
o|substituted constant variable: r86419509 
o|replaced variables: 1 
o|removed binding forms: 12 
o|substituted constant variable: r74169561 
o|contracted procedure: k7640 
o|removed binding forms: 4 
o|removed binding forms: 1 
o|simplifications: ((if . 88) (##core#call . 671)) 
o|  call simplifications:
o|    <
o|    bitwise-ior	2
o|    vector-ref	2
o|    make-vector
o|    ##sys#structure?
o|    ##sys#foreign-pointer-argument	4
o|    fxior	2
o|    ##sys#check-structure	3
o|    ##sys#make-structure	3
o|    ##sys#setislot	3
o|    fxmin	2
o|    eof-object?
o|    ##sys#foreign-string-argument	7
o|    length
o|    fx>=	8
o|    ##sys#check-list	6
o|    fx*
o|    *
o|    inexact->exact
o|    memq	2
o|    list	7
o|    values	20
o|    ##sys#fudge	2
o|    vector-set!	3
o|    char=?
o|    ##sys#foreign-block-argument	8
o|    ##sys#foreign-integer-argument	5
o|    fx-	12
o|    ##sys#check-number	8
o|    ##sys#check-vector
o|    procedure?
o|    member
o|    fx+	27
o|    string-ref
o|    fx>
o|    cons	12
o|    ##sys#size	17
o|    ##sys#call-with-values	13
o|    not	8
o|    ##sys#check-string	34
o|    fx=	30
o|    zero?
o|    ##sys#null-pointer?	4
o|    pair?	19
o|    ##sys#check-exact	37
o|    ##sys#slot	32
o|    eq?	40
o|    cdr	28
o|    ##sys#eqv?	14
o|    null?	73
o|    car	52
o|    vector	2
o|    fixnum?	15
o|    string?	2
o|    fx<	47
o|    ##sys#foreign-fixnum-argument	32
o|    apply	9
o|contracted procedure: k2693 
o|contracted procedure: k2722 
o|contracted procedure: k2731 
o|contracted procedure: k2747 
o|contracted procedure: k2775 
o|contracted procedure: k2766 
o|contracted procedure: k2896 
o|contracted procedure: k2818 
o|contracted procedure: k2890 
o|contracted procedure: k2821 
o|contracted procedure: k2884 
o|contracted procedure: k2824 
o|contracted procedure: k2878 
o|contracted procedure: k2827 
o|contracted procedure: k2839 
o|contracted procedure: k2845 
o|contracted procedure: k2851 
o|contracted procedure: k2857 
o|contracted procedure: k2863 
o|contracted procedure: k2869 
o|contracted procedure: k2875 
o|contracted procedure: k2981 
o|contracted procedure: k2984 
o|contracted procedure: k3006 
o|contracted procedure: k3002 
o|contracted procedure: k3012 
o|contracted procedure: k3018 
o|contracted procedure: k3039 
o|contracted procedure: k3046 
o|contracted procedure: k3072 
o|contracted procedure: k3084 
o|contracted procedure: k3098 
o|contracted procedure: k3154 
o|contracted procedure: k3117 
o|contracted procedure: k3146 
o|contracted procedure: k3136 
o|contracted procedure: k3160 
o|contracted procedure: k3169 
o|contracted procedure: k3175 
o|contracted procedure: k3178 
o|contracted procedure: k3181 
o|contracted procedure: k3212 
o|contracted procedure: k3187 
o|contracted procedure: k3298 
o|contracted procedure: k3221 
o|contracted procedure: k3233 
o|contracted procedure: k3240 
o|contracted procedure: k3278 
o|contracted procedure: k3288 
o|contracted procedure: k3292 
o|contracted procedure: k3415 
o|contracted procedure: k3307 
o|contracted procedure: k3310 
o|contracted procedure: k3412 
o|contracted procedure: k3316 
o|contracted procedure: k3349 
o|contracted procedure: k3394 
o|contracted procedure: k3545 
o|contracted procedure: k3427 
o|contracted procedure: k3539 
o|contracted procedure: k3430 
o|contracted procedure: k3533 
o|contracted procedure: k3433 
o|contracted procedure: k3436 
o|contracted procedure: k3455 
o|contracted procedure: k3470 
o|contracted procedure: k3474 
o|contracted procedure: k3480 
o|contracted procedure: k3526 
o|contracted procedure: k3483 
o|contracted procedure: k3502 
o|contracted procedure: k3505 
o|contracted procedure: k3520 
o|contracted procedure: k3511 
o|contracted procedure: k3551 
o|contracted procedure: k3572 
o|contracted procedure: k3575 
o|contracted procedure: k3606 
o|contracted procedure: k3613 
o|contracted procedure: k3636 
o|contracted procedure: k3652 
o|contracted procedure: k3670 
o|contracted procedure: k3692 
o|contracted procedure: k3695 
o|contracted procedure: k3701 
o|contracted procedure: k3713 
o|contracted procedure: k3722 
o|contracted procedure: k3748 
o|contracted procedure: k3819 
o|contracted procedure: k3838 
o|contracted procedure: k3902 
o|contracted procedure: k3915 
o|contracted procedure: k3908 
o|contracted procedure: k3924 
o|contracted procedure: k3930 
o|contracted procedure: k3945 
o|contracted procedure: k3951 
o|contracted procedure: k3976 
o|contracted procedure: k3993 
o|contracted procedure: k3989 
o|contracted procedure: k3968 
o|contracted procedure: k3999 
o|contracted procedure: k4109 
o|contracted procedure: k4056 
o|contracted procedure: k4065 
o|contracted procedure: k4048 
o|contracted procedure: k4099 
o|contracted procedure: k4095 
o|contracted procedure: k4035 
o|contracted procedure: k4118 
o|contracted procedure: k4121 
o|contracted procedure: k4135 
o|contracted procedure: k4176 
o|contracted procedure: k4183 
o|contracted procedure: k4191 
o|contracted procedure: k4203 
o|contracted procedure: k4207 
o|contracted procedure: k4214 
o|contracted procedure: k4150 
o|contracted procedure: k4221 
o|contracted procedure: k4304 
o|contracted procedure: k4244 
o|contracted procedure: k4298 
o|contracted procedure: k4247 
o|contracted procedure: k4292 
o|contracted procedure: k4250 
o|contracted procedure: k4286 
o|contracted procedure: k4253 
o|contracted procedure: k4256 
o|contracted procedure: k4259 
o|contracted procedure: k4277 
o|contracted procedure: k4314 
o|contracted procedure: k4321 
o|contracted procedure: k4398 
o|contracted procedure: k4377 
o|contracted procedure: k4380 
o|contracted procedure: k4383 
o|contracted procedure: k4392 
o|contracted procedure: k4364 
o|contracted procedure: k4368 
o|contracted procedure: k4372 
o|contracted procedure: k8618 
o|contracted procedure: k4405 
o|contracted procedure: k4413 
o|contracted procedure: k4416 
o|contracted procedure: k4419 
o|contracted procedure: k4429 
o|contracted procedure: k4435 
o|contracted procedure: k4442 
o|contracted procedure: k4454 
o|contracted procedure: k4460 
o|contracted procedure: k4473 
o|contracted procedure: k4476 
o|contracted procedure: k4491 
o|contracted procedure: k4503 
o|contracted procedure: k4514 
o|contracted procedure: k4523 
o|contracted procedure: k4529 
o|contracted procedure: k4535 
o|contracted procedure: k4551 
o|contracted procedure: k4557 
o|contracted procedure: k4571 
o|contracted procedure: k4574 
o|contracted procedure: k4594 
o|contracted procedure: k4600 
o|contracted procedure: k4632 
o|contracted procedure: k4641 
o|contracted procedure: k4658 
o|contracted procedure: k4648 
o|contracted procedure: k4655 
o|contracted procedure: k4681 
o|contracted procedure: k4687 
o|contracted procedure: k4693 
o|contracted procedure: k4699 
o|contracted procedure: k4708 
o|contracted procedure: k4737 
o|contracted procedure: k4747 
o|contracted procedure: k4741 
o|contracted procedure: k4754 
o|contracted procedure: k4758 
o|contracted procedure: k4720 
o|contracted procedure: k4724 
o|contracted procedure: k4767 
o|contracted procedure: k4796 
o|contracted procedure: k4806 
o|contracted procedure: k4800 
o|contracted procedure: k4813 
o|contracted procedure: k4817 
o|contracted procedure: k4779 
o|contracted procedure: k4783 
o|contracted procedure: k4612 
o|contracted procedure: k4616 
o|contracted procedure: k4620 
o|contracted procedure: k4828 
o|contracted procedure: k4841 
o|contracted procedure: k4868 
o|contracted procedure: k4874 
o|contracted procedure: k4847 
o|contracted procedure: k4851 
o|contracted procedure: k4855 
o|contracted procedure: k4883 
o|contracted procedure: k4910 
o|contracted procedure: k4916 
o|contracted procedure: k4889 
o|contracted procedure: k4893 
o|contracted procedure: k4897 
o|contracted procedure: k4923 
o|contracted procedure: k4933 
o|contracted procedure: k4939 
o|contracted procedure: k4948 
o|contracted procedure: k4954 
o|contracted procedure: k4957 
o|contracted procedure: k4964 
o|contracted procedure: k4973 
o|contracted procedure: k4983 
o|contracted procedure: k4989 
o|contracted procedure: k5002 
o|contracted procedure: k5020 
o|contracted procedure: k5032 
o|contracted procedure: k5045 
o|contracted procedure: k5055 
o|contracted procedure: k5072 
o|contracted procedure: k5085 
o|contracted procedure: k5095 
o|contracted procedure: k5118 
o|contracted procedure: k5133 
o|contracted procedure: k5264 
o|contracted procedure: k5299 
o|contracted procedure: k5305 
o|contracted procedure: k5319 
o|contracted procedure: k5332 
o|contracted procedure: k5342 
o|contracted procedure: k5346 
o|contracted procedure: k5310 
o|contracted procedure: k5356 
o|contracted procedure: k5362 
o|contracted procedure: k5368 
o|contracted procedure: k5378 
o|contracted procedure: k5384 
o|contracted procedure: k5420 
o|contracted procedure: k5493 
o|contracted procedure: k5448 
o|contracted procedure: k5457 
o|contracted procedure: k5483 
o|contracted procedure: k5486 
o|contracted procedure: k5598 
o|contracted procedure: k5541 
o|contracted procedure: k5550 
o|contracted procedure: k5585 
o|contracted procedure: k5535 
o|contracted procedure: k5588 
o|contracted procedure: k5591 
o|contracted procedure: k5639 
o|contracted procedure: k5651 
o|contracted procedure: k5654 
o|contracted procedure: k5608 
o|contracted procedure: k56159002 
o|contracted procedure: k5673 
o|contracted procedure: k5697 
o|contracted procedure: k5703 
o|contracted procedure: k5713 
o|contracted procedure: k5716 
o|contracted procedure: k5723 
o|contracted procedure: k5727 
o|contracted procedure: k5737 
o|contracted procedure: k56159010 
o|contracted procedure: k5760 
o|contracted procedure: k5763 
o|contracted procedure: k5769 
o|contracted procedure: k5748 
o|contracted procedure: k5755 
o|contracted procedure: k5824 
o|contracted procedure: k5827 
o|contracted procedure: k5833 
o|contracted procedure: k5847 
o|contracted procedure: k5850 
o|contracted procedure: k5853 
o|contracted procedure: k5859 
o|contracted procedure: k5873 
o|contracted procedure: k5876 
o|contracted procedure: k5914 
o|contracted procedure: k5930 
o|contracted procedure: k5933 
o|contracted procedure: k5939 
o|contracted procedure: k5967 
o|contracted procedure: k6067 
o|contracted procedure: k5979 
o|contracted procedure: k5982 
o|contracted procedure: k6013 
o|contracted procedure: k6053 
o|contracted procedure: k6057 
o|contracted procedure: k6100 
o|contracted procedure: k6103 
o|contracted procedure: k6109 
o|contracted procedure: k6088 
o|contracted procedure: k6095 
o|contracted procedure: k6636 
o|contracted procedure: k6122 
o|contracted procedure: k6630 
o|contracted procedure: k6125 
o|contracted procedure: k6624 
o|contracted procedure: k6128 
o|contracted procedure: k6618 
o|contracted procedure: k6131 
o|contracted procedure: k6612 
o|contracted procedure: k6134 
o|contracted procedure: k6606 
o|contracted procedure: k6137 
o|contracted procedure: k6600 
o|contracted procedure: k6140 
o|contracted procedure: k6594 
o|contracted procedure: k6143 
o|contracted procedure: k6585 
o|contracted procedure: k6149 
o|contracted procedure: k6163 
o|contracted procedure: k6169 
o|contracted procedure: k6172 
o|contracted procedure: k6189 
o|contracted procedure: k6203 
o|contracted procedure: k6209 
o|contracted procedure: k6212 
o|contracted procedure: k6227 
o|contracted procedure: k6242 
o|contracted procedure: k6262 
o|contracted procedure: k6268 
o|contracted procedure: k6271 
o|contracted procedure: k6305 
o|contracted procedure: k6309 
o|contracted procedure: k6312 
o|contracted procedure: k6321 
o|contracted procedure: k6336 
o|contracted procedure: k6345 
o|contracted procedure: k6361 
o|contracted procedure: k6383 
o|contracted procedure: k6389 
o|contracted procedure: k6392 
o|contracted procedure: k6421 
o|contracted procedure: k6395 
o|contracted procedure: k6399 
o|contracted procedure: k6403 
o|contracted procedure: k6410 
o|contracted procedure: k6414 
o|contracted procedure: k6418 
o|contracted procedure: k6430 
o|contracted procedure: k6440 
o|contracted procedure: k6452 
o|contracted procedure: k6514 
o|contracted procedure: k6468 
o|contracted procedure: k6474 
o|contracted procedure: k6480 
o|contracted procedure: k6487 
o|contracted procedure: k6496 
o|contracted procedure: k6507 
o|contracted procedure: k6503 
o|contracted procedure: k6535 
o|contracted procedure: k6531 
o|contracted procedure: k6524 
o|inlining procedure: k6520 
o|contracted procedure: k6546 
o|contracted procedure: k6550 
o|contracted procedure: k6542 
o|inlining procedure: k6520 
o|contracted procedure: k6557 
o|contracted procedure: k6560 
o|contracted procedure: k6572 
o|contracted procedure: k6579 
o|contracted procedure: k6897 
o|contracted procedure: k6645 
o|contracted procedure: k6891 
o|contracted procedure: k6648 
o|contracted procedure: k6885 
o|contracted procedure: k6651 
o|contracted procedure: k6879 
o|contracted procedure: k6654 
o|contracted procedure: k6873 
o|contracted procedure: k6657 
o|contracted procedure: k6867 
o|contracted procedure: k6660 
o|contracted procedure: k6677 
o|contracted procedure: k6683 
o|contracted procedure: k6686 
o|contracted procedure: k6698 
o|contracted procedure: k6713 
o|contracted procedure: k6724 
o|contracted procedure: k6858 
o|contracted procedure: k6727 
o|contracted procedure: k6754 
o|contracted procedure: k6763 
o|contracted procedure: k6776 
o|contracted procedure: k6788 
o|contracted procedure: k6803 
o|contracted procedure: k6807 
o|contracted procedure: k6816 
o|contracted procedure: k6829 
o|contracted procedure: k6836 
o|contracted procedure: k6840 
o|contracted procedure: k6846 
o|contracted procedure: k6852 
o|contracted procedure: k6906 
o|contracted procedure: k6922 
o|contracted procedure: k6932 
o|contracted procedure: k6996 
o|contracted procedure: k6941 
o|contracted procedure: k6990 
o|contracted procedure: k6944 
o|contracted procedure: k6984 
o|contracted procedure: k6947 
o|contracted procedure: k6978 
o|contracted procedure: k6950 
o|contracted procedure: k6955 
o|contracted procedure: k6968 
o|contracted procedure: k6962 
o|contracted procedure: k6971 
o|contracted procedure: k7009 
o|contracted procedure: k7013 
o|contracted procedure: k7017 
o|contracted procedure: k7029 
o|contracted procedure: k7045 
o|contracted procedure: k7070 
o|contracted procedure: k7082 
o|contracted procedure: k7086 
o|contracted procedure: k7090 
o|contracted procedure: k7104 
o|contracted procedure: k7096 
o|contracted procedure: k7110 
o|contracted procedure: k7116 
o|contracted procedure: k7122 
o|contracted procedure: k7133 
o|contracted procedure: k7141 
o|contracted procedure: k7147 
o|contracted procedure: k7157 
o|contracted procedure: k7163 
o|contracted procedure: k7169 
o|contracted procedure: k7243 
o|contracted procedure: k7197 
o|contracted procedure: k7201 
o|contracted procedure: k7205 
o|contracted procedure: k7209 
o|contracted procedure: k7213 
o|contracted procedure: k7217 
o|contracted procedure: k7259 
o|contracted procedure: k7285 
o|contracted procedure: k7294 
o|contracted procedure: k7305 
o|contracted procedure: k7273 
o|contracted procedure: k7277 
o|contracted procedure: k7308 
o|contracted procedure: k7318 
o|contracted procedure: k7370 
o|contracted procedure: k7342 
o|contracted procedure: k7345 
o|contracted procedure: k7348 
o|contracted procedure: k7363 
o|substituted constant variable: g9774 
o|substituted constant variable: g9774 
o|substituted constant variable: g9774 
o|substituted constant variable: g9774 
o|substituted constant variable: g9774 
o|substituted constant variable: g9774 
o|substituted constant variable: g9774 
o|substituted constant variable: g9774 
o|substituted constant variable: g9774 
o|substituted constant variable: g9774 
o|contracted procedure: k7334 
o|contracted procedure: k7418 
o|contracted procedure: k74069560 
o|contracted procedure: k74069565 
o|contracted procedure: k7426 
o|contracted procedure: k7441 
o|contracted procedure: k7461 
o|contracted procedure: k7457 
o|contracted procedure: k7464 
o|contracted procedure: k7470 
o|contracted procedure: k7476 
o|contracted procedure: k7488 
o|contracted procedure: k7507 
o|contracted procedure: k7528 
o|contracted procedure: k7524 
o|contracted procedure: k7518 
o|contracted procedure: k7539 
o|contracted procedure: k7574 
o|contracted procedure: k7555 
o|contracted procedure: k7559 
o|contracted procedure: k7563 
o|contracted procedure: k7703 
o|contracted procedure: k7619 
o|contracted procedure: k7697 
o|contracted procedure: k7622 
o|contracted procedure: k7691 
o|contracted procedure: k7625 
o|contracted procedure: k7685 
o|contracted procedure: k7628 
o|contracted procedure: k7652 
o|contracted procedure: k7655 
o|contracted procedure: k7679 
o|contracted procedure: k7713 
o|contracted procedure: k7721 
o|contracted procedure: k7728 
o|contracted procedure: k7736 
o|contracted procedure: k7744 
o|contracted procedure: k7751 
o|contracted procedure: k7905 
o|contracted procedure: k7758 
o|contracted procedure: k7899 
o|contracted procedure: k7761 
o|contracted procedure: k7893 
o|contracted procedure: k7764 
o|contracted procedure: k7887 
o|contracted procedure: k7767 
o|contracted procedure: k7770 
o|contracted procedure: k7773 
o|contracted procedure: k7791 
o|contracted procedure: k7803 
o|contracted procedure: k7809 
o|contracted procedure: k7821 
o|contracted procedure: k7833 
o|contracted procedure: k7839 
o|contracted procedure: k7842 
o|contracted procedure: k7854 
o|contracted procedure: k7858 
o|contracted procedure: k7861 
o|contracted procedure: k7864 
o|contracted procedure: k7876 
o|contracted procedure: k7880 
o|contracted procedure: k7884 
o|contracted procedure: k7915 
o|contracted procedure: k7943 
o|contracted procedure: k7921 
o|contracted procedure: k7956 
o|contracted procedure: k7965 
o|contracted procedure: k7968 
o|contracted procedure: k7974 
o|contracted procedure: k7980 
o|contracted procedure: k8032 
o|contracted procedure: k8035 
o|contracted procedure: k8058 
o|contracted procedure: k8085 
o|contracted procedure: k8064 
o|contracted procedure: k8116 
o|contracted procedure: k8128 
o|contracted procedure: k8045 
o|contracted procedure: k8147 
o|contracted procedure: k8264 
o|contracted procedure: k8268 
o|contracted procedure: k8272 
o|contracted procedure: k8233 
o|contracted procedure: k8279 
o|contracted procedure: k8296 
o|contracted procedure: k8306 
o|contracted procedure: k8310 
o|contracted procedure: k8313 
o|contracted procedure: k8387 
o|contracted procedure: k8348 
o|contracted procedure: k8381 
o|contracted procedure: k8351 
o|contracted procedure: k8375 
o|contracted procedure: k8354 
o|contracted procedure: k8369 
o|contracted procedure: k8357 
o|contracted procedure: k8429 
o|contracted procedure: k8396 
o|contracted procedure: k8423 
o|contracted procedure: k8399 
o|contracted procedure: k8417 
o|contracted procedure: k8402 
o|contracted procedure: k8411 
o|contracted procedure: k8405 
o|contracted procedure: k8451 
o|contracted procedure: k8457 
o|contracted procedure: k8446 
o|contracted procedure: k8468 
o|contracted procedure: k8474 
o|contracted procedure: k8480 
o|contracted procedure: k8492 
o|contracted procedure: k8495 
o|contracted procedure: k8501 
o|contracted procedure: k8520 
o|contracted procedure: k8539 
o|contracted procedure: k8558 
o|contracted procedure: k8577 
o|contracted procedure: k8599 
o|contracted procedure: k8602 
o|contracted procedure: k8611 
o|contracted procedure: k8624 
o|contracted procedure: k8649 
o|contracted procedure: k8633 
o|contracted procedure: k8636 
o|contracted procedure: k8658 
o|contracted procedure: k8670 
o|contracted procedure: k8686 
o|contracted procedure: k8682 
o|contracted procedure: k8692 
o|contracted procedure: k8707 
o|contracted procedure: k8729 
o|contracted procedure: k8720 
o|simplifications: ((if . 1) (let . 122)) 
o|removed binding forms: 583 
o|inlining procedure: k3921 
o|inlining procedure: k3942 
o|inlining procedure: "(posixunix.scm:647) mode975" 
o|inlining procedure: "(posixunix.scm:658) mode975" 
o|inlining procedure: k5744 
o|inlining procedure: k7717 
o|inlining procedure: k7740 
o|replaced variables: 313 
o|removed binding forms: 2 
o|inlining procedure: k4861 
o|inlining procedure: k4861 
o|inlining procedure: k4903 
o|inlining procedure: k4903 
o|removed side-effect free assignment to unused variable: mode975 
o|inlining procedure: k5335 
o|inlining procedure: k5667 
o|inlining procedure: k5730 
o|substituted constant variable: r57459886 
o|substituted constant variable: r57459886 
o|substituted constant variable: r77189899 
o|substituted constant variable: r77189899 
o|substituted constant variable: r77419902 
o|substituted constant variable: r77419902 
o|replaced variables: 10 
o|removed binding forms: 159 
o|contracted procedure: k4386 
o|contracted procedure: k4626 
o|contracted procedure: k5664 
o|contracted procedure: k7234 
o|contracted procedure: k7301 
o|contracted procedure: k7584 
o|converted assignments to bindings: (check977) 
o|simplifications: ((let . 3)) 
o|removed binding forms: 25 
o|contracted procedure: k5035 
o|contracted procedure: k5075 
o|replaced variables: 2 
o|removed binding forms: 2 
o|removed binding forms: 1 
o|direct leaf routine/allocation: doloop884885 0 
o|direct leaf routine/allocation: doloop866867 0 
o|direct leaf routine/allocation: for-each-loop11021114 0 
o|direct leaf routine/allocation: peek1425 0 
o|direct leaf routine/allocation: swapped-ends2027 3 
o|direct leaf routine/allocation: g20852092 0 
o|contracted procedure: k4603 
o|contracted procedure: k4606 
o|converted assignments to bindings: (doloop884885) 
o|converted assignments to bindings: (doloop866867) 
o|contracted procedure: k5313 
o|converted assignments to bindings: (for-each-loop11021114) 
o|contracted procedure: "(posixunix.scm:1208) k6299" 
o|contracted procedure: "(posixunix.scm:1739) k8167" 
o|contracted procedure: "(posixunix.scm:1744) k8190" 
o|contracted procedure: "(posixunix.scm:1743) k8194" 
o|contracted procedure: "(posixunix.scm:1780) k8299" 
o|simplifications: ((let . 3)) 
o|removed binding forms: 8 
o|direct leaf routine/allocation: for-each-loop20842102 0 
o|converted assignments to bindings: (for-each-loop20842102) 
o|simplifications: ((let . 1)) 
o|customizable procedures: (loop1123 %process2073 chkstrlst2080 output-port2026 make-on-close1989 input-port2025 spawn2024 connect-parent1991 needed-pipe1990 connect-child1992 k8002 k7962 doloop19171918 setarg1870 doloop19211922 setenv1872 ##sys#terminal-check k7435 k7447 k7288 k7228 k7113 setup1596 err1597 k6958 k6912 loop1565 k6730 k6455 k6374 loop1471 ready?1424 fetch1426 loop1367 check1313 doloop12371238 loop1229 k5544 loop1210 k5451 check977 k4583 k4586 k4589 k4821 k4789 lp921 k4730 lp940 k4671 k4520 k4410 scan640 loop637 check-time-vector k3673 k3676 loop456 g428429 loop420 conc-loop401 k3489 loop380 k3338 loop333 g293300 for-each-loop292309 rmdir286 k3163 mode206 check207 k2978 ##sys#stat) 
o|calls to known targets: 285 
o|unused rest argument: _452 f_3841 
o|unused rest argument: _451 f_3833 
o|unused rest argument: _493 f_3893 
o|identified direct recursive calls: f_4171 1 
o|identified direct recursive calls: f_4878 2 
o|identified direct recursive calls: f_4836 2 
o|identified direct recursive calls: f_5327 1 
o|identified direct recursive calls: f_5634 1 
o|identified direct recursive calls: f_5692 1 
o|identified direct recursive calls: f_6378 1 
o|identified direct recursive calls: f_6811 1 
o|identified direct recursive calls: f_8291 1 
o|identified direct recursive calls: f_8594 2 
o|fast box initializations: 26 
o|fast global references: 67 
o|fast global assignments: 4 
o|dropping unused closure argument: f_3225 
o|dropping unused closure argument: f_5015 
o|dropping unused closure argument: f_3067 
o|dropping unused closure argument: f_3030 
o|dropping unused closure argument: f_6939 
o|dropping unused closure argument: f_8275 
o|dropping unused closure argument: f_3900 
o|dropping unused closure argument: f_7710 
o|dropping unused closure argument: f_7733 
o|dropping unused closure argument: f_8111 
o|dropping unused closure argument: f_8123 
o|dropping unused closure argument: f_8054 
o|dropping unused closure argument: f_8138 
o|dropping unused closure argument: f_5327 
o|dropping unused closure argument: f_8091 
o|dropping unused closure argument: f_2714 
o|dropping unused closure argument: f_5871 
o|dropping unused closure argument: f_7511 
o|dropping unused closure argument: f_7003 
*/
/* end of file */
