/* bender-tags: editor,unit */
/* bender-ckeditor-plugins: menu */

bender.editor = {
	config : {
		allowedContent: true
	}
};

bender.test( {
	getMenuMockup: function() {
		var editor = this.editor,
			menu = {
				_: {},
				id: 'cke_32',
				editor: editor,
				items: [],
				onHide: function() {}
			};

		return menu;
	},

	getMenuItemMockup: function( customDefinition ) {
		var editor = this.editor,
			definition = customDefinition || {};

		return new CKEDITOR.menuItem( editor, 'foo', definition );
	},

	// Tests menuItems rener function.
	// @param {String} expectedRole Expected role attribute value.
	// @param {Object} definition
	// @param {Function} callback Receives ouptut string as a first parameter. It should contain assertions.
	_testMenuItemRender: function( expectedRole, definition, callback ) {
		var menu = this.getMenuMockup(),
			index = 0,
			output = [],
			outputHtml;

		definition = definition || {};
		callback = callback || function( html ) {};

		var mock = this.getMenuItemMockup( definition );

		// Calling render.
		CKEDITOR.menuItem.prototype.render.call( mock, menu, index, output );

		outputHtml = output.join( '' );

		assert.areNotEqual( -1, outputHtml.search( 'role="' + expectedRole + '"' ), '[role="' + expectedRole + '"] attribute not found in html generated by CKEDITOR.menuItem.proto.render()' );

		callback.call( this, outputHtml );

		return outputHtml;
	},

	// Asserts that given string contains aria-checked attribute.
	// @param {Boolean} expectedValue
	// @param {String} html Tested html code.
	_assertAriaChecked: function( expectedValue, html ) {
		var expectedSubstring = 'aria-checked="' + ( expectedValue ? 'true' : 'false' ) + '"',
			assertMessage = '"' + expectedSubstring + '" substring has not been found';

		assert.areNotEqual( -1 , String( html ).search( expectedSubstring ), assertMessage );
	},

	'test default role' : function() {
		this._testMenuItemRender( 'menuitem', {} );
	},

	'test default menuitem state ON' : function() {
		// Ensures that menuitem does not get aria-checked attr, since it would
		// violate specs.
		this._testMenuItemRender( 'menuitem', {}, function( html ) {
			assert.areEqual( -1, html.search( 'aria-checked' ), 'aria-checked attribute should not be present in output html' );
		} );
	},

	'test menuitemcheckbox role' : function() {
		var definition = {
				role: 'menuitemcheckbox'
			};

		this._testMenuItemRender( 'menuitemcheckbox', definition );
	},

	'test menuitemcheckbox sate OFF' : function() {
		var definition = {
				role: 'menuitemcheckbox',
				state: CKEDITOR.TRISTATE_ON
			};

		this._testMenuItemRender( 'menuitemcheckbox', definition, function( html ) {
			this._assertAriaChecked( true, html );
		} );
	},

	'test menuitemcheckbox state ON' : function() {
		var definition = {
				role: 'menuitemcheckbox',
				state: CKEDITOR.TRISTATE_OFF
			};

		this._testMenuItemRender( 'menuitemcheckbox', definition, function( html ) {
			this._assertAriaChecked( false, html );
		} );
	},

	'test menuitemcheckbox undefined state' : function() {
		var definition = {
				role: 'menuitemcheckbox'
			};

		this._testMenuItemRender( 'menuitemcheckbox', definition, function( html ) {
			this._assertAriaChecked( false, html );
		} );
	},

	'test menuitemradio role' : function() {
		var definition = {
				role: 'menuitemradio'
			};
		this._testMenuItemRender( 'menuitemradio', definition );
	},

	'test menuitemradio state ON' : function() {
		var definition = {
				role: 'menuitemradio',
				state: CKEDITOR.TRISTATE_ON
			};

		this._testMenuItemRender( 'menuitemradio', definition, function( html ) {
			this._assertAriaChecked( true, html );
		} );
	}

} );