// Copyright 2014 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Created by postproc-cld2 4.0 on 2014-10-16 15:47:49
// From command line:
//  --nearby_probs=2.8 --extra_entries=be-Cyrl bh-Deva bs-Latn hr-Latn 
//  sr-Latn gl-Latn es-Latn id-Latn ms-Latn sv-Latn  --cld2 --cc 
//  --just_read_raw --quad --standard --minchars=2 --mincount=2 
//  --max_items_per_langscript=6000 --flatmap --rr_alloc --freq_alloc 
//  --boostcloseweakerpercent=00 --indirectbits=16 --thresh=224 --v25 
//  --kentries=160 --tablename=QuadChrome1015_16 --remap=xxx-Latn=>ut-Latn 
//  tw-Latn=>ak-Latn nd-Latn=>nr-Latn blu-Latn=>hmn-Latn nn-Latn=>no-Latn  
//  --include=af-Latn ar-Arab be-Cyrl bg-Cyrl bs-Latn ca-Latn cs-Latn 
//  cy-Latn   da-Latn de-Latn el-Grek en-Latn es-Latn et-Latn fa-Arab 
//  fi-Latn fr-Latn   ga-Latn gd-Latn hi-Deva hr-Latn hu-Latn id-Latn 
//  is-Latn it-Latn iw-Hebr   ja-Hani ko-Hani lg-Latn lt-Latn lv-Latn 
//  mk-Cyrl ms-Latn nl-Latn no-Latn   pl-Latn pt-Latn ro-Latn ro-Cyrl 
//  ru-Cyrl rw-Latn sh-Cyrl sh-Latn sk-Latn sl-Latn sr-Cyrl   sv-Latn 
//  sw-Latn th-Thai tl-Latn tr-Latn uk-Cyrl vi-Latn yi-Hebr   zh-Hani zh-TW 
//  zhT-Hani   sq-Latn az-Latn eu-Latn bn-Beng gl-Latn ht-Latn mt-Latn 
//  sr-Latn ur-Arab   bh-Deva mr-Deva ne-Deva lg-Latn rw-Latn gd-Latn   
//  ut-Latn ut-Deva   ceb-Latn blu-Latn hmn-Latn jw-Latn   kk-Cyrl ku-Latn 
//  ky-Cyrl mg-Latn ny-Latn st-Latn su-Latn tg-Cyrl uz-Latn uz-Cyrl  
//  --ko_english --force_to_lang_soft --nosoft_cram2 --nomsidlevel 
//  --shapeflatprob --langpriorpercent=10 --skipnuc --noshapeforcetop 
//  --noshapeeventop --noshapesteep2 --langcounts --writebin 
//  --list_items=120 --max_langs_per_item=3 
//  /hdb1/cld2/probs/p90_raw_quadgrams_2014b.utf8 
// 
// CLD2_pslangs
// 
// See compact_lang_det.cc for usage
// 
#include "cld2tablesummary.h"
namespace CLD2 {

// For this build date, looking up 'qpdbmrmxyzptlkuuddlrlrbas' gives TURKISH
static const uint32 kQuadChrome1015_16BuildDate = 20141016;    // yyyymmdd


// Of 416959 offered items into 163840 table entries:
// 163775 filled (39%), 576 merged (0%), 252608 dropped (60%)

// Nil-grams: 19 languages
//     GREEK MALAYALAM TELUGU TAMIL GUJARATI THAI KANNADA PUNJABI 
//     GEORGIAN SINHALESE ARMENIAN LAOTHIAN KHMER DHIVEHI CHEROKEE 
//     SYRIAC LIMBU ORIYA INUKTITUT 

// Uni-grams: 4 languages
//     Japanese Korean Chinese ChineseT 

// Words/Quads: 71 languages in range ENGLISH..NYANJA:
//     ENGLISH DANISH DUTCH FINNISH FRENCH GERMAN HEBREW ITALIAN 
//     NORWEGIAN POLISH PORTUGUESE RUSSIAN SPANISH SWEDISH CZECH 
//     ICELANDIC LATVIAN LITHUANIAN ROMANIAN HUNGARIAN ESTONIAN 
//     BULGARIAN CROATIAN SERBIAN IRISH GALICIAN TAGALOG TURKISH 
//     UKRAINIAN HINDI MACEDONIAN BENGALI INDONESIAN MALAY WELSH 
//     NEPALI ALBANIAN BELARUSIAN JAVANESE URDU BIHARI ARABIC CATALAN 
//     BASQUE SCOTS_GAELIC SWAHILI SLOVENIAN MARATHI MALTESE 
//     VIETNAMESE SLOVAK SUNDANESE UZBEK AZERBAIJANI PERSIAN BOSNIAN 
//     SESOTHO KYRGYZ YIDDISH KURDISH MONGOLIAN AFRIKAANS KAZAKH 
//     TAJIK HAITIAN_CREOLE KINYARWANDA MALAGASY GANDA CEBUANO HMONG 
//     NYANJA 

// TopLanguage  TokenCount
//  ENGLISH 2058
//  DANISH 2090
//  DUTCH 2076
//  FINNISH 2062
//  FRENCH 2065
//  GERMAN 2064
//  HEBREW 2077
//  ITALIAN 2034
//  NORWEGIAN 2098
//  POLISH 2100
//  PORTUGUESE 2092
//  RUSSIAN 2018
//  SPANISH 2992
//  SWEDISH 3105
//  CZECH 4232
//  ICELANDIC 2068
//  LATVIAN 2038
//  LITHUANIAN 2066
//  ROMANIAN 4038
//  HUNGARIAN 2064
//  ESTONIAN 2068
//  BULGARIAN 2016
//  CROATIAN 3219
//  SERBIAN 4955
//  IRISH 2091
//  GALICIAN 2962
//  TAGALOG 2013
//  TURKISH 2082
//  UKRAINIAN 2005
//  HINDI 4056
//  MACEDONIAN 1990
//  BENGALI 2119
//  INDONESIAN 3551
//  MALAY 2660
//  WELSH 2061
//  NEPALI 2040
//  ALBANIAN 2110
//  BELARUSIAN 2978
//  JAVANESE 2087
//  URDU 2096
//  BIHARI 3394
//  ARABIC 2029
//  CATALAN 2111
//  BASQUE 2095
//  SCOTS_GAELIC 2124
//  SWAHILI 2098
//  SLOVENIAN 2086
//  MARATHI 2004
//  MALTESE 2096
//  VIETNAMESE 2096
//  SLOVAK 2080
//  SUNDANESE 2048
//  UZBEK 4070
//  AZERBAIJANI 2086
//  PERSIAN 2062
//  BOSNIAN 2712
//  SESOTHO 2078
//  KYRGYZ 1997
//  YIDDISH 2009
//  KURDISH 2109
//  MONGOLIAN 13
//  AFRIKAANS 2070
//  KAZAKH 2025
//  TAJIK 1993
//  HAITIAN_CREOLE 2091
//  KINYARWANDA 2087
//  MALAGASY 2091
//  GANDA 2118
//  CEBUANO 1932
//  HMONG 1906
//  NYANJA 2045



// Recognized language-script combinations [74]:
static const char* const kQuadChrome1015_16RecognizedLangScripts = 
  "af-Latn ar-Arab az-Latn be-Cyrl bg-Cyrl bh-Deva bn-Beng bs-Latn "
  "ca-Latn ceb-Latn cs-Latn cy-Latn da-Latn de-Latn en-Latn es-Latn "
  "et-Latn eu-Latn fa-Arab fi-Latn fr-Latn ga-Latn gd-Latn gl-Latn "
  "hi-Deva hmn-Latn hr-Latn ht-Latn hu-Latn id-Latn is-Latn it-Latn "
  "iw-Hebr jw-Latn kk-Cyrl ku-Latn ky-Cyrl lg-Latn lt-Latn lv-Latn "
  "mg-Latn mk-Cyrl mn-Latn mr-Deva ms-Latn mt-Latn ne-Deva nl-Latn "
  "no-Latn ny-Latn pl-Latn pt-Latn ro-Cyrl ro-Latn ru-Cyrl rw-Latn "
  "sk-Latn sl-Latn sq-Latn sr-Cyrl sr-Latn st-Latn su-Latn sv-Latn "
  "sw-Latn tg-Cyrl tl-Latn tr-Latn uk-Cyrl ur-Arab uz-Cyrl uz-Latn "
  "vi-Latn yi-Hebr ";

static const uint32 kQuadChrome1015_16Size = 32768;    // Bucket count
static const uint32 kQuadChrome1015_16KeyMask = 0xffff8000;    // Mask hash key

static const IndirectProbBucket4 kQuadChrome1015_16[kQuadChrome1015_16Size] = {
  // hash_indirect[4], tokens[4] in UTF-8
   {{0xe9da0002,0xe2970003,0x31260004,0x7c2e0005}},	// [000] вка_, аат_, идаг, ssbr, 
   {{0x20078006,0xbddb0007,0x23bf0008,0x63bb8009}},	//   _kuni_, stèr, täjä_, hiun, 
   {{0xddc4000a,0x6563800b,0x52e2800c,0x02e2800d}},	//   _križ, denh, _पर्स, _पर्न, 
   {{0x6443800e,0x4916000f,0x63bb8010,0x20078011}},	//   duni, _प्रो_, jiun, _muni_, 
   {{0x20078012,0x3ea08013,0xdb810014,0x27ed8015}},	//   _luni_, áit_, _эҳти, _dhen_, 
   {{0x65638016,0x64438017,0x6fdd0018,0xef1f0019}},	//   genh, funi, léct, tjük_, 
   {{0x6443801a,0x3ea0801b,0x2451801c,0x9486801d}},	//   guni, šit_, _cơm_, рылд, 
   {{0x63bb801e,0xef1f0019,0x63a9801f,0xf7438020}},	//   giun, rjük_, ghen, _месо, 
   {{0x36678021,0x65638022,0xa3ab0023,0x2fc68024}},	//   _като_, benh, कोट_, mnog_, 
   {{0x2fc68025,0x20078026,0x645e0008,0x63a98027}},	//   lnog_, _buni_, _oppi, ahen, 
   {{0x2b9c0028,0x75288029,0x1ddf802a,0x6aad002b}},	//   _tích_, _iedz, _पीटत, zzaf, 
   {{0x63a9802c,0x63bb802d,0x4ea7002e,0x2252002f}},	//   chen, ciun, арга, ktyk_, 
   {{0x69dc0030,0x645e0031,0x6b828032,0x75288033}},	//   _okre, _appi, _inog, _kedz, 
   {{0x75288034,0x2b988035,0x20078036,0x6e240037}},	//   _jedz, _vécu_, _funi_, _dwib, 
   {{0x75288038,0x89378039,0xddc40024,0x212c8015}},	//   _medz, _כרגע_, _friž, madh_, 
   {{0x248d003a,0x2fc6803b,0x212c803c,0xf699003d}},	//   ćem_, jnog_, ladh_, _منبع_, 
   {{0x6b82803a,0x2fc68025,0x7afd803e,0xafb8003f}},	// [010] _mnog, dnog_, žstv, _خطوط_, 
   {{0x212c803c,0x63bb8040,0x20078041,0x64438042}},	//   nadh_, ziun, _yuni_, yuni, 
   {{0x6b828043,0x65638044,0x27ed8045,0x69d70046}},	//   _onog, venh, _phen_, roxe, 
   {{0x69dc0047,0x212c8048,0xc7c48049,0xa804004a}},	//   _ekre, hadh_, осчи, ізіл, 
   {{0x6e67804b,0x44310019,0xa2ea004c,0x75288034}},	//   ртеж, lsz_, _бурҷ_, _bedz, 
   {{0x27ed804d,0x9474004e,0x26df804f,0xdb1d0050}},	//   _when_, _ادیا, _vyuo_, _eksô, 
   {{0x65638051,0x63bb8012,0x2fc68024,0x27ed8052}},	//   renh, tiun, bnog_, _then_, 
   {{0x2fc68053,0x65638054,0x7e6d0055,0xa3ab0056}},	//   cnog_, senh, _osap, कोच_, 
   {{0xe9d98057,0x63a98058,0x64438059,0xe299805a}},	//   лки_, rhen, suni, уап_, 
   {{0x63a9805b,0x212c803c,0x63bb805c,0x2007805d}},	//   shen, gadh_, siun, _puni_, 
   {{0x63a9805e,0xa3d7005f,0x66160060,0x8d748061}},	//   phen, ाका_, _styk, _باقا, 
   {{0x66018062,0x44310063,0x291e8064,0x6fdd0065}},	//   _hilk, dsz_, abta_, xéct, 
   {{0x66018066,0xeab38067,0x7e6d0068,0x212c8069}},	//   _kilk, _بعض_, _csap, badh_, 
   {{0x2fc6806a,0x212c806b,0x6729806c,0xb21b006d}},	//   znog_, cadh_, _leej, _kræf, 
   {{0x64a3006e,0x1015806f,0x66018070,0xfce60071}},	//   пара, _ابتد, _milk, сово, 
   {{0x69dc0072,0xee3f003e,0x260a8073,0x67298074}},	//   _skre, brý_, ादमी_, _neej, 
   {{0x2fc6803b,0x3a3f8065,0x0aea0075,0x28a58076}},	// [020] vnog_, nrup_, удай_, खनवि, 
   {{0xa5bb0077,0x44258078,0x46db8079,0x31710036}},	//   ssór, _owl_, _बड़ह, _cazz_, 
   {{0x2fc6803b,0xaad8007a,0x75288029,0x7e7b807b}},	//   tnog_, _भुरक, _redz, _arup, 
   {{0xbb860013,0x43860013,0xfdb0800f,0xa3e7800f}},	//   _الحي, _الحق, जफ्फ, _मील_, 
   {{0x2fc68025,0x6601807c,0x65948008,0x7e56807d}},	//   rnog_, _bilk, жалу, стец, 
   {{0x69dc007e,0x3a3f806d,0xdb16007f,0x8e570080}},	//   _ukre, drup_, ábær, מינג_, 
   {{0x2fc6805d,0x38608081,0x66018082,0xe6448083}},	//   pnog_, _ćiro_, _dilk, ğlığ, 
   {{0x52148084,0xe6448085,0x53988086,0x79838087}},	//   одит, şlığ, рвия_, _annw, 
   {{0x22400088,0x212c8089,0x6fc8008a,0x6601808b}},	//   nrik_, tadh_, rıcl, _filk, 
   {{0x388e808c,0x2009808d,0xf96a808e,0x44310034}},	//   ləri_, _čair_, урий_, ysz_, 
   {{0x212c803c,0x2240008f,0x67298090,0x3bd68091}},	//   radh_, hrik_, _yeej, _людс, 
   {{0x66018092,0xbb1b0093,0x212c8094,0x22400095}},	//   _zilk, _anîn, sadh_, krik_, 
   {{0x4ad8007a,0x212c8096,0xeabf0097,0x44310098}},	//   _भुलव, padh_, _ceùl_, wsz_, 
   {{0x22400099,0x44310019,0x6d4a809a,0xa2c5809b}},	//   drik_, tsz_, ngfa, ापर्, 
   {{0x79950066,0xe8d98028,0x200a009c,0x5ba7009d}},	//   _rozw, _đủ_, _nubi_, браз, 
   {{0x7ae2809e,0x67d4009f,0x224000a0,0xdb0d007f}},	//   _kyot, _нощу, frik_, gnað, 
   {{0x799500a1,0x44310019,0xddc280a2,0x7e6d00a3}},	// [030] _pozw, ssz_, dvož, _usap, 
   {{0x69da80a4,0x672f0066,0x69c880a5,0x644100a6}},	//   note, lacj, nnde, àlis, 
   {{0xe71980a7,0x439500a8,0x388e808a,0x644100a9}},	//   ليات_, _данс, fəri_, álid, 
   {{0x644700aa,0xe00b80ab,0x672f0034,0x8afd80ac}},	//   muji, _संसद_, nacj, deřn, 
   {{0x660180ad,0x69da80ae,0x63ad00af,0x7e7b808a}},	//   _pilk, kote, mhan, _qrup, 
   {{0x63ad00b0,0x69da80b1,0xcfcf00b2,0xd6580039}},	//   lhan, jote, রতিন, ציות_, 
   {{0x660180b3,0x645500b4,0x672f0066,0x200a0053}},	//   _vilk, ntzi, kacj, _gubi_, 
   {{0x36d580b5,0x0c8780b6,0xeb9980b7,0x69c880b8}},	//   _добр, _қызм, рии_, ende, 
   {{0x660180b9,0xbfa880ba,0x7e7b80bb,0x394e80bc}},	//   _tilk, _утре_, _urup, _bcfs_, 
   {{0x644700bd,0xfeb880be,0x3b1f80bf,0xb21b00c0}},	//   kuji, _طاقت_, sbuq_, _træf, 
   {{0xa3e900c1,0x63ad00c2,0xe2a8807b,0xfbd900c3}},	//   यता_, khan, لاین_, भकाम, 
   {{0xaa5980c4,0x69c880c5,0x998680a1,0x14d680c6}},	//   _виду_, ande, _ktoś_, _וועל_, 
   {{0x63ad00c7,0x69da80c8,0xc8e600c9,0xddc400ca}},	//   dhan, bote, _कर्म_, _asiš, 
   {{0x98a580cb,0x7bc980cc,0xa0a580cd,0x853c80ce}},	//   _миле, lneu, _малд, _alėj, 
   {{0x09c400cf,0x63ad00d0,0x8b9600d1,0x3b9600b0}},	//   ্তমা, fhan, орач, ојат, 
   {{0x63ad00d2,0x7bc980d3,0xeb9a0004,0x2fcd80d4}},	//   ghan, nneu, шиб_, _njeg_, 
   {{0xa3bb00d5,0x200a00d6,0x7c2900d7,0xf11a00d8}},	// [040] _अगर_, _subi_, ćera, لغات_, 
   {{0x224000d9,0xed5a00a6,0x0f2280da,0x2b4f80db}},	//   rrik_, _тоо_, मर्स_, _lcgc_, 
   {{0x106a00dc,0xc8ca00dd,0x321900de,0x13a800df}},	//   рией_, جوان_, _etsy_, _هندی_, 
   {{0x63ad00e0,0x68e380e1,0xa3ae001b,0x2d8580e2}},	//   chan, _mynd, _कति_, _anle_, 
   {{0xa3d700e3,0x63a400e4,0x27e000e5,0x69da80e6}},	//   ाकर_, mkin, _mkin_, yote, 
   {{0x672f0066,0x200a00e7,0x63a400e8,0x644100e9}},	//   zacj, _tubi_, lkin, šlie, 
   {{0x69da80ea,0x07a680eb,0x8fa680ec,0x7ae280ed}},	//   vote, _давн, _даве, _syot, 
   {{0x63a400ee,0x7bc980ef,0xd32680f0,0x81e780b2}},	//   nkin, gneu, цьки, _মূল_, 
   {{0x298a80f1,0x63a400f2,0xdcfe00f3,0xb21b00f4}},	//   асно_, ikin, _kopē, _græd, 
   {{0x69c880f5,0x7ae2804f,0x2a6200f6,0x27e680f7}},	//   unde, _vyot, _mpkb_, llon_, 
   {{0x2004808c,0x201880f8,0xdb060019,0x672f00a1}},	//   _kimi_, ëri_, _elké, tacj, 
   {{0x290780f9,0x63a400fa,0x27e680fb,0x69da80fc}},	//   _egna_, jkin, nlon_, sote, 
   {{0x200480fd,0x672f0066,0xd25080fe,0x69da80ff}},	//   _mimi_, racj, _أنت_, pote, 
   {{0x7bc08100,0x27e68101,0x1dbc8102,0x20048103}},	//   limu, hlon_, ्चित, _limi_, 
   {{0x63ad0104,0x27e6803a,0x63a40105,0x26108106}},	//   than, klon_, fkin, _lào_, 
   {{0x20048107,0x2a620108,0x64550109,0x5215010a}},	//   _nimi_, _bpkb_, rtzi, здат, 
   {{0x2610810b,0xe810810c,0xdb0b810d,0x1dbc810e}},	// [050] _nào_, _ठंडा_, _umgå, ्चात, 
   {{0x63ad010f,0x7bc08110,0xddc280a1,0x200480f6}},	//   shan, himu, rtoś, _aimi_, 
   {{0x672d0111,0x660d0112,0x63a40113,0x7bc08114}},	//   _keaj, _huak, bkin, kimu, 
   {{0x63a40039,0xf0938115,0x26108106,0x7bc08116}},	//   ckin, ונע_, _bào_, jimu, 
   {{0xa3e4010c,0x7bc08117,0xa77c00c6,0x660500bf}},	//   _पीट_, dimu, יראפ, _kihk, 
   {{0x98a5802d,0x5a340118,0x99640119,0x7bc9811a}},	//   nală_, _інст, _отсл, wneu, 
   {{0x22490109,0xdd8e80fe,0x2004811b,0x27e6811c}},	//   luak_, اوى_, _fimi_, blon_, 
   {{0xd90e011d,0xdb02811e,0x7bc0811f,0x7bc98120}},	//   _لیے_, _eloí, gimu, uneu, 
   {{0x76428035,0xdce38121,0x22490122,0x35b58123}},	//   croy, menč, nuak_, _ебар, 
   {{0x63a40124,0x2004805d,0xae44803d,0xd6c68125}},	//   zkin, _zimi_, _آپلو, _عملی, 
   {{0x63a40126,0x7bc08127,0x660d0128,0x6e298129}},	//   ykin, bimu, _auak, _hweb, 
   {{0xf772012a,0x6d41012b,0x22490122,0x6e29812c}},	//   راج_, ólan, kuak_, _kweb, 
   {{0xa3ca812d,0xa3c1012e,0x290780f6,0x2610812f}},	//   ोवर_, ्चन_, _tgna_, _xào_, 
   {{0xdd92007b,0x427a8130,0x67228024,0x7c290131}},	//   روز_, _לאנג, zboj, ćern, 
   {{0x2a6d8132,0x27e68133,0x63a40134,0x69c18135}},	//   lweb_, ylon_, tkin, mile, 
   {{0x69c18136,0x6f098137,0xdce38138,0x5f760139}},	//   lile, _ngec, jenč, _رابر, 
   {{0xeb97013a,0xc64a0013,0x69c18089,0x6e29813b}},	// [060] чит_, _اجعل_, oile, _nweb, 
   {{0x63a4013c,0xb6bb0052,0x867b0130,0x69c1813d}},	//   skin, _לצפי, _פריו, nile, 
   {{0x63a4013e,0x036a013f,0x661b8140,0xddc98121}},	//   pkin, _линк_, _atuk, _brež, 
   {{0x69c18141,0xb21b0142,0x22490143,0x2d9a0039}},	//   hile, _dræb, buak_, _hope_, 
   {{0x69c18144,0x672280f3,0x7bc08116,0x2d9a0145}},	//   kile, rboj, vimu, _kope_, 
   {{0x6d4e0146,0x26108147,0x6d5c0148,0x76428149}},	//   ngba, _vào_, nfra, rroy, 
   {{0x69c1814a,0x27e6814b,0xdce3811b,0x2d9a0027}},	//   dile, plon_, benč, _mope_, 
   {{0x69de014c,0x7e6400d7,0x65ab008a,0x7642814d}},	//   lope, _opip, _müha, proy, 
   {{0xadc38028,0x7bc0814e,0xe944803d,0x9d46814f}},	//   _quản, rimu, وردی, _неад, 
   {{0x7bc08150,0x69c18151,0x6d4e00fa,0x69de0152}},	//   simu, gile, jgba, nope, 
   {{0x7bc08153,0x672d0154,0xe8df0106,0x7ae60155}},	//   pimu, _peaj, _trục_, _lykt, 
   {{0x37ab0156,0xeb978157,0xd36f8158,0x660d00f6}},	//   стон_, _них_, _مهم_, _puak, 
   {{0x69c18159,0x6d5c015a,0x644a8024,0x69de015b}},	//   bile, ffra, lufi, kope, 
   {{0x72eb815c,0x69c1815d,0xe944807b,0xf9c4815e}},	//   _פֿאַ, cile, _آرشی, _تحصی, 
   {{0xd5c8810b,0x6458815f,0x98a58123,0x7c290131}},	//   yền_, ntvi, rală_, ćero, 
   {{0x22490124,0x660d0160,0x6d4e0161,0xc1788162}},	//   tuak_, _tuak, agba, ldė_, 
   {{0xb9990163,0xdce38164,0xe2f80165,0x98a58166}},	// [070] овах_, venč, зеті_, pală_, 
   {{0x5c07009f,0x22490109,0xc1788116,0x64438167}},	//   _няма, ruak_, ndė_, yrni, 
   {{0xddc98168,0x3ea60029,0x661b8169,0x22490122}},	//   _prež, _ļoti_, _stuk, suak_, 
   {{0x69c1816a,0x6443816b,0x6577016c,0x2d9a016d}},	//   zile, vrni, _haxh, _zope_, 
   {{0x69c1816e,0xee3880f0,0x7bdf016f,0xddc9808d}},	//   yile, зні_, moqu, _vrež, 
   {{0x7bdf00a9,0x050100b2,0xddd60170,0x64438171}},	//   loqu, ্রীর_, _kryš, trni, 
   {{0x64588172,0x6577016c,0x33f58173,0x64438174}},	//   gtvi, _maxh, мчис, urni, 
   {{0x09b7809b,0x22158175,0x7bcd0176,0x64c5011b}},	//   ेच्य, мфор, nnau, _ičić, 
   {{0x69c18177,0x6d5c011a,0x661b8178,0x42548179}},	//   tile, yfra, _utuk, нтэт, 
   {{0xa2e38004,0x7bcd017a,0x10a5817b,0x23c3817c}},	//   моқд, hnau, дион, _bèjè_, 
   {{0x5455817d,0x69c1817e,0xf746017f,0xe3c20180}},	//   _цвет, rile, мено, lmış_, 
   {{0x69c18181,0xd24e8182,0x7c3a0183,0xe2918184}},	//   sile, دنی_, štrk, _لذت_, 
   {{0x65b00185,0xe3c20186,0x69c18187,0xd1758188}},	//   _lähe, nmış_, pile, _жыйы, 
   {{0xe9d8805a,0x90c58189,0x7ae6018a,0x65ab0079}},	//   _екі_, _обле, _rykt, _püha, 
   {{0xfce3018b,0x6d5c018c,0x1d07018d,0x7bdf018e}},	//   воро, rfra, дери_, foqu, 
   {{0x8ffa003d,0x320f80db,0x6441018f,0x764b8190}},	//   _برتر_, _kugy_, ália, kugy, 
   {{0xd5b20019,0x7c24811b,0x2fc00191,0x32078192}},	// [080] _لفظ_, ćiri, _imig_, _kiny_, 
   {{0xb1430193,0x10a60103,0x32078194,0xa0a60195}},	//   кнул, мизн, _jiny_, мазд, 
   {{0xeb9a0196,0x69de0197,0xb21b006d,0x8b260198}},	//   _дин_, rope, _præc, _одне, 
   {{0xfaa60004,0x46ea80ba,0x201c00f3,0xddc98199}},	//   _жамо, оден_, īvi_, _ereż, 
   {{0x69de019a,0x65b0019b,0xfe6f819c,0x05d20034}},	//   pope, _tähd, لدو_, _सदाब, 
   {{0x6458819d,0x443a019e,0x644a819f,0x32078050}},	//   ttvi, _kvp_, tufi, _niny_, 
   {{0x910301a0,0xd90d01a1,0x2f568103,0x443a00ca}},	//   _апре, _ایم_, _отас, _jvp_, 
   {{0xda08810b,0x28bd01a2,0x645881a3,0x02a681a4}},	//   _hỏi_, ्परि, rtvi, дром, 
   {{0x200e81a5,0x961880b2,0x6aa401a6,0x6f090170}},	//   _sufi_, _ডটকম_, nyif, žeck, 
   {{0x6e2281a7,0xb5aa80d8,0x443800bf,0x67d201a8}},	//   mpob, _بارك_, ksr_, vāja, 
   {{0x26ee81a9,0xda088106,0xa3ae01aa,0x65ab01ab}},	//   _जरुर_, _mỏi_, कसा_, _bühn, 
   {{0xdce501ac,0x67d200f3,0x64a381ad,0x733681ae}},	//   _pohľ, tāja, _шаха, _آرائ, 
   {{0xa3e781af,0x799c01b0,0x7bdf01b1,0x442c81b2}},	//   _मीट_, _oorw, voqu, _hwd_, 
   {{0x58d481b3,0x29070116,0xdb0b81b4,0x3a2981b5}},	//   _полт, žnai_, _algè, _çapa_, 
   {{0x7bdf00b0,0x9f588149,0x7c38800b,0x657701b6}},	//   toqu, _juró_, nsvr, _vaxh, 
   {{0x26ee81b7,0x628281b8,0x67d200f3,0x53de809b}},	//   _जरूर_, _kroo, pāja, मविश, 
   {{0x7bcd01b9,0x799c01ba,0x050100b2,0xddc981bb}},	// [090] rnau, _borw, ্রের_, _preż, 
   {{0x51f801bc,0x5c7501bd,0x2a6680f6,0xd13101be}},	//   дную_, _злот, _mpob_, اما_, 
   {{0x753501bf,0x533501c0,0x200901c1,0x9f9c81c2}},	//   mazz, _пент, _kiai_, tíð_, 
   {{0x753501c3,0x65b001c4,0x6e2d01c5,0xa63581c6}},	//   lazz, _vähe, _kwab, енді, 
   {{0x59de81c7,0x628281c8,0x6e2d00db,0x317801c9}},	//   नकार, _nroo, _jwab, _farz_, 
   {{0x753501bb,0x65b00073,0x5067004a,0x6e2d01ca}},	//   nazz, _tähe, _отба, _mwab, 
   {{0x69c501cb,0x7659811a,0x6e2d012c,0x628281cc}},	//   mihe, stwy, _lwab, _aroo, 
   {{0x6f0d01cd,0x9f5881ce,0x6aca81cf,0x753500bf}},	//   _ngac, _duró_, ापूर, hazz, 
   {{0x753501d0,0xb4bc01d1,0x67f601d2,0x995880ac}},	//   kazz, _अध्_, náje, láři_, 
   {{0xf9918013,0x628280d0,0x6b9d01d3,0x7c3a0183}},	//   ابة_, _droo, _losg, štri, 
   {{0xa3c101d4,0x2011004f,0xfc3080fe,0x39588015}},	//   ्चा_, _juzi_, _نحن_, òrsa_, 
   {{0x7ddb0093,0x6e2d01d5,0x69c501d6,0x201101d7}},	//   mîsy, _bwab, hihe, _muzi_, 
   {{0xee3701d8,0x628281d9,0xa68301da,0x6b8b81db}},	//   ння_, _groo, гляд, _ingg, 
   {{0xceb281dc,0x753501dd,0x7c2201de,0x236d81df}},	//   נים_, gazz, _čorb, leej_, 
   {{0x77a601e0,0xdb0b80ef,0x3074804a,0x6b9d01e1}},	//   _lóxi, _algé, _ауыс, _bosg, 
   {{0xddcd01e2,0x63a981e3,0x2009001c,0xeb9701e4}},	//   _graž, nken, _giai_, нис_, 
   {{0x6b6301e5,0xe8df801c,0x6b8b80e5,0x799c01e6}},	// [0a0] ыкта, _khỏi_, _mngg, _porw, 
   {{0x61e181e7,0x63a981e8,0x753501e9,0x236d81ea}},	//   noll, hken, cazz, heej_, 
   {{0x63a981eb,0x65c1005a,0x03a601ec,0x799c01ed}},	//   kken, _тұра, _зино, _vorw, 
   {{0x61e181ee,0x201100d7,0x645c01ef,0x63a981f0}},	//   holl, _duzi_, mtri, jken, 
   {{0x61e181f1,0x644e01f2,0x63a98142,0x99800116}},	//   koll, lubi, dken, usių_, 
   {{0x6b8b81f3,0xdd9080fe,0x63a981f4,0xda08812f}},	//   _angg, شوب_, eken, _tỏi_, 
   {{0x186701f5,0x316c81ac,0x644e01f6,0x201101f7}},	//   _пари_, vedz_, nubi, _guzi_, 
   {{0x63a981f8,0x2a6680db,0x67d201a8,0x7c38800b}},	//   gken, _ppob_, dājo, rsvr, 
   {{0x645c01f9,0x644e004f,0xdd8f81fa,0x6d4101fb}},	//   htri, hubi, _گول_, ólak, 
   {{0x6b8b81fc,0x644e01fd,0xbddb01fe,0x6e2d00bb}},	//   _engg, kubi, trèm, _rwab, 
   {{0xa3d001ff,0x75350200,0x2d8c8201,0xd8f880f0}},	//   वचा_, vazz, _inde_, ьної_, 
   {{0x645a8202,0x63a98203,0xe7cf00b2,0x657a8204}},	//   _iqti, cken, রত্য, _hath, 
   {{0x657a8205,0x2d9e8206,0xb5fb0207,0x75350208}},	//   _kath, _kote_, ntág, tazz, 
   {{0x61e18209,0xd12f807b,0xb21b0142,0x2d9e816c}},	//   coll, _همه_, _bræn, _jote_, 
   {{0xddcd020a,0x753501d0,0xa4d400f0,0x6b9d020b}},	//   _traž, razz, горі, _posg, 
   {{0x657a820c,0x6e2d020d,0x3ea6820e,0xd378020f}},	//   _lath, _twab, kyot_, нчу_, 
   {{0x245a8210,0x2d8c8211,0x75350212,0x2131017c}},	// [0b0] hëm_, _onde_, pazz, _pezh_, 
   {{0xdb0d00fe,0x2d9e8213,0x3eb30214,0x20110215}},	//   mhaí, _note_, ıntı_, _puzi_, 
   {{0xb21b0216,0x644e0217,0x69c50218,0x645c0219}},	//   _græn, cubi, rihe, ctri, 
   {{0x44210069,0x201c021a,0x61fe021b,0x67f601d2}},	//   _ith_, ívia_, ampl, páje, 
   {{0x2d9e821c,0xe618805a,0xc3c2021d,0x3ea6821e}},	//   _bote_, еді_, _төрл, gyot_, 
   {{0x7bc2821f,0xb6a28004,0xbea28220,0x3ea28004}},	//   _amou, ришл, рашк, ришг, 
   {{0x61e18221,0xeb998222,0xabd58223,0x657a8224}},	//   voll, дий_, кциј, _dath, 
   {{0x2d8c8225,0x77a60226,0xc1788116,0x3b858004}},	//   _ende_, _tóxi, klės_, тлиг, 
   {{0x645c0227,0x61e18228,0xb33b01b2,0x853c8162}},	//   ztri, toll, _koçb, _plėt, 
   {{0x645c01ef,0x926480fe,0x67d38229,0x236d822a}},	//   ytri, اديم, _роғу, seej_, 
   {{0xb604000d,0x645c022b,0x200c022c,0x6b8b80e5}},	//   ntář, xtri, _édit_, _tngg, 
   {{0x2d9e822d,0x6b8b822e,0x2249022f,0x61e18230}},	//   _zote_, _ungg, krak_, soll, 
   {{0x2d9e822d,0x61e18231,0x657a8232,0x44210233}},	//   _yote_, poll, _yath, _ath_, 
   {{0x645c0234,0xa5bb0235,0x61458236,0x644e0237}},	//   ttri, spón, _река, tubi, 
   {{0xb024810b,0x44210238,0xfce60071,0x22490109}},	//   _trườ, _cth_, тово, erak_, 
   {{0x1e860239,0xf41380b2,0x764f023a,0x2c7c81d2}},	//   _алим, _সবার_, bucy, ládá_, 
   {{0xc332804d,0x6d41803b,0x2619023b,0x644e023c}},	// [0c0] יון_, _odla, _यूपी_, subi, 
   {{0xb21b0022,0xe9d7023d,0x3f8d823e,0xa92480e9}},	//   _træn, вку_, _aneu_, peľň, 
   {{0x657a823f,0x2d9e8240,0x505a0241,0x7e698242}},	//   _rath, _rote_, ьшая_, _apep, 
   {{0x6d418243,0xdce88038,0x2d9e8244,0x22490245}},	//   _adla, _podľ, _sote_, brak_, 
   {{0x2d9e8246,0xa3c10056,0x69c38247,0xeb970248}},	//   _pote_, ्चर_, _omne, _рия_, 
   {{0x245a8210,0x2fc68116,0x44210108,0x7c3a0249}},	//   tëm_, siog_, _yth_, štru, 
   {{0x9f42024a,0x6da3824b,0x6aca824c,0x629d810d}},	//   rokê_, рија, ाप्र, äson, 
   {{0x2d9e822d,0x69c3824d,0x6286024e,0x657a8232}},	//   _wote_, _amne, _krko, _wath, 
   {{0xc606824f,0xa6658250,0xcb678251,0xe737804a}},	//   _азай, _مطلو, тање_, _шет_, 
   {{0x2d8c8012,0x657a80fe,0x601e80f3,0x62860252}},	//   _unde_, _uath, _līme, _mrko, 
   {{0x7f590253,0x31370039,0x1ab4804a,0x22490254}},	//   нанс_, כנים_, _әбля, zrak_, 
   {{0x69c38255,0x1fa70256,0xdb0d00fe,0x67f881d2}},	//   _emne, трог, thaí, bíje, 
   {{0xecdb000f,0xdddb8257,0xa2c20258,0x629601df}},	//   _मुजफ, _hruš, _रेल्, jxyo, 
   {{0xdddb8259,0x765d025a,0xdbd181c2,0x764f0191}},	//   _kruš, rtsy, lýðs, rucy, 
   {{0xd5b8025b,0xd37b025c,0xb4ad025d,0xa3d680c9}},	//   тся_, мча_, कने_, _सदा_, 
   {{0x62860131,0x644a80d8,0x7d080063,0x9cd7825e}},	//   _brko, irfi, _sérü, דולה_, 
   {{0x27e9025f,0x395800bc,0x62848162,0x443c808d}},	// [0d0] _ikan_, _bcrs_, _šioj, hsv_, 
   {{0x224900b4,0x69c88260,0x645a00a6,0x23b180e9}},	//   rrak_, nide, àtic, _mája_, 
   {{0x290700f9,0x69c88097,0x62860261,0x981400d8}},	//   äna_, iide, _erko, لبنا, 
   {{0x63b60262,0x22490263,0x69c88264,0x75220265}},	//   chyn, prak_, hide, _đozi, 
   {{0x69c88266,0x25090267,0x3f8181d2,0x75ed8268}},	//   kide, _ترکی_, ěhu_, lúzi, 
   {{0x24858108,0x2b590269,0x6d55026a,0xf483803d}},	//   _prlm_, _hcsc_, ngza, لاعی, 
   {{0x61e5026b,0x69c8826c,0x25a101d2,0xe894026d}},	//   mohl, dide, _mohl_, _карь, 
   {{0x63ad026e,0xb5fb026f,0xdb098077,0xfe73803d}},	//   nkan, ntáb, nheç, _پدر_, 
   {{0x443e8270,0x1a658267,0x7e69804f,0x36d5802d}},	//   _evt_, ایتی_, _upep, _соар, 
   {{0x27e90271,0x69c88272,0x63ad0058,0x6d418142}},	//   _akan_, gide, hkan, _udla, 
   {{0xcea90273,0x8fa60274,0xcb558275,0x27e900e5}},	//   _צי_, гане, _مناظ, _bkan_, 
   {{0x61e50276,0x63ad0277,0x69c88278,0x26198279}},	//   hohl, jkan, aide, _kèo_, 
   {{0x69c880b4,0xe1ee827a,0x200d809f,0xdddb827b}},	//   bide, _гг_, _miei_, _zruš, 
   {{0x7bc9827c,0x27e90004,0x63ad027d,0x237d827e}},	//   lieu, _ekan_, ekan, _hawj_, 
   {{0x63ad027f,0x98ac8166,0xbb460280,0x225f8281}},	//   fkan, radă_, левк, ltuk_, 
   {{0x7bc98282,0xc0528052,0x63ad0283,0x62860284}},	//   nieu, _הזה_, gkan, _prko, 
   {{0x225f8285,0xe1fa0286,0x63b60287,0x6abb81ed}},	// [0e0] ntuk_, ега_, rhyn, nzuf, 
   {{0x237d822a,0x7bc98288,0x6e240214,0x63ad0289}},	//   _lawj_, hieu, _itib, akan, 
   {{0x64a6028a,0x11d70013,0x63ad00e5,0x7bc9828b}},	//   _сана, دولة_, bkan, kieu, 
   {{0x69c8828c,0x63ad028d,0xee3a828e,0x237d827e}},	//   zide, ckan, енд_, _nawj_, 
   {{0x56948166,0xdddb806a,0x443e8172,0x7bc9828f}},	//   ралт, _sruš, _svt_, dieu, 
   {{0x443e8290,0xdddb8291,0x2816003d,0x644a808d}},	//   _pvt_, _pruš, _موسس, trfi, 
   {{0x657e0292,0xb5fb0268,0xa0a30293,0x66160294}},	//   _maph, ltác, _лард, _luyk, 
   {{0x657e0295,0x7bc98296,0x7f44016c,0x69c88297}},	//   _laph, gieu, _ndiq, wide, 
   {{0x69c88298,0xb5fb0299,0x237d81df,0x6e24029a}},	//   tide, ntác, _dawj_, _ntib, 
   {{0x657e029b,0xd6cf8275,0x27e6829c,0x104a829d}},	//   _naph, _عقل_, loon_, нями_, 
   {{0x0c26829e,0xdddb829f,0x6e2402a0,0x6b9b82a1}},	//   _смен, _uruš, _atib, bjug, 
   {{0x27e682a2,0x7bc980ef,0x7a868019,0x644101a8}},	//   noon_, cieu, _مشتم, šlik, 
   {{0xb8eb82a3,0x199482a4,0x63ad02a5,0x657e02a6}},	//   _रे_, _валя, vkan, _baph, 
   {{0x2d9c80f8,0x27e682a7,0x63a28079,0x7bc602a8}},	//   njve_, hoon_, _hoon, _amku, 
   {{0x63a282a9,0xf36702aa,0x63ad02ab,0x27e682ac}},	//   _koon, лтан, tkan, koon_, 
   {{0x764b82ad,0x25a102ae,0x63a282af,0x67f600e9}},	//   yrgy, _wohl_, _joon, pája, 
   {{0x6d5a82b0,0x27e682b1,0x65ab0079,0x38c90019}},	// [0f0] _octa, doon_, _lühi, ھائی_, 
   {{0x63a282b2,0x2618810c,0x2bc602b3,0x60d380f3}},	//   _loon, _पढ़ी_, रोबा, ņemš, 
   {{0x44ce808c,0x63ad02b4,0x27e682b5,0xb5fb02b6}},	//   _nə_, pkan, foon_, ptáb, 
   {{0x63a282b7,0x27e682b8,0xbddb00ef,0x657e02b9}},	//   _noon, goon_, ssèd, _zaph, 
   {{0xd9f6807a,0xb5fb02ba,0xed5982bb,0x6b9b8269}},	//   ुगात_, ctác, вол_, vjug, 
   {{0xdcfa82bc,0xdca582bd,0x9f4202be,0x3a2900f6}},	//   _altı, иали, roké_, mpap_, 
   {{0x63a282bf,0x290502c0,0x9f42026b,0x9f6b81e2}},	//   _boon, _àla_, soké_, _праз_, 
   {{0x44ce82c1,0xc24582c2,0xdfd582c3,0x225f8063}},	//   _də_, аник, _тобы, ttuk_, 
   {{0x63a281cc,0x7bc982c4,0x6d4502c5,0x7e6d013b}},	//   _doon, rieu, _odha, _npap, 
   {{0xb5fd803a,0x7bc982c6,0x6d4500df,0xe81980da}},	//   _opši, sieu, _ndha, _नंदा_, 
   {{0x7e6d02c7,0xe8f682c8,0x225f82c9,0x7c220269}},	//   _apap, иль_, stuk_, _čoro, 
   {{0x6d4502ca,0x8e8602cb,0x63a282cc,0xd70602cd}},	//   _adha, агме, _goon, изни, 
   {{0x7c2502ce,0x69c702cf,0x4425808d,0x2bb880fe}},	//   _athr, _omje, _htl_, _حالة_, 
   {{0x63a282d0,0x657e0027,0x44ce82d1,0x291f02d2}},	//   _zoon, _qaph, _yə_, _şuan_, 
   {{0x63a282d3,0x4174803d,0xab5d81bb,0x88838019}},	//   _yoon, _دانس, viżj, _ایجن, 
   {{0x032602d4,0xc32602d5,0x442582d6,0x657e02d7}},	//   рдан, рмак, _mtl_, _waph, 
   {{0x6a8302d8,0x61fc0064,0x3f9202b1,0x657e02d9}},	// [100] олта, _phrl, _inyu_, _taph, 
   {{0x27e682da,0xd94602db,0x2a6002dc,0x628402dd}},	//   woon_, режи, rtib_, rvio, 
   {{0x7e7b82de,0xe73a82df,0x27e682e0,0x67f601ac}},	//   _asup, вее_, toon_, nájo, 
   {{0x4ea68004,0x068682e1,0xd62a82e2,0x7e7b8027}},	//   ирла, иген, воде_, _bsup, 
   {{0x27e682e3,0x644182e4,0xfe7282e5,0xdce18116}},	//   roon_, _avli, تدا_, _kalė, 
   {{0xbebb0210,0x27e682e6,0x224002e7,0x798181df}},	//   mbët, soon_, msik_, jdlw, 
   {{0x442582e8,0x63a282e9,0x7e7b82ea,0x224002eb}},	//   _ctl_, _poon, _esup, lsik_, 
   {{0x44ce82ec,0xafe382ed,0x7bd602ee,0x67f880e9}},	//   _və_, _досл, nnyu, bíja, 
   {{0x201802ef,0x753c00a1,0x64418083,0xe57a82f0}},	//   _huri_, karz, _evli, _иза_, 
   {{0x1daa82f1,0x201802f2,0x63a282f3,0x65ab02f4}},	//   _कवित, _kuri_, _woon, _tühi, 
   {{0x201802f5,0x63a282f6,0x9f4201b2,0x753c00a1}},	//   _juri_, _toon, rokî_, darz, 
   {{0x201802f7,0xc4778052,0x224002f8,0x65b002ae}},	//   _muri_, _כתבו_, ksik_, _wähl, 
   {{0x95cb00ba,0x539b82f9,0x6d4502fa,0x442582fb}},	//   вува_, _שידו, _pdha, _ztl_, 
   {{0x6d5882fc,0xdb0d02fd,0x6703009b,0x753c02fe}},	//   ngva, lhaç, रेषक_, garz, 
   {{0x201802ff,0xb21b0142,0x94a8024f,0x44250300}},	//   _nuri_, _træk, атта_, ël_, 
   {{0x69c70301,0x47350302,0x5b150303,0xf77f02fd}},	//   _smje, _унис, смат, moço_, 
   {{0x7e628043,0x2fc90304,0x7c2d8305,0x6d41007f}},	// [110] jtop, _imag_, ćari, ólas, 
   {{0xdce181e2,0x2018029a,0x673d0306,0x6d450307}},	//   _galė, _buri_, lasj, _udha, 
   {{0x20180308,0x4dda0309,0x6703030a,0x224002ef}},	//   _curi_, _תחתו, रेरक_, asik_, 
   {{0x9f05830b,0x4425830c,0x6455030d,0x61e8803e}},	//   موضو, _rtl_, muzi, hodl, 
   {{0x7bcd0116,0xd244030e,0x2d810079,0x2018030f}},	//   miau, _мэри, _kahe_, _euri_, 
   {{0x69c70310,0x2d830311,0x7bcd01e2,0x51870312}},	//   _umje, ndje_, liau, _тума, 
   {{0xf7738313,0x673d0314,0x64550315,0x2d810316}},	//   _وار_, kasj, nuzi, _mahe_, 
   {{0x86b3805a,0x224d8317,0x7e7b8318,0x7bcd0116}},	//   _мәлі, trek_, _tsup, niau, 
   {{0x20180319,0xa3af0073,0x6455031a,0x27ed831b}},	//   _zuri_, _कवन_, huzi, _iken_, 
   {{0x5275831c,0x224d8124,0x6455031d,0x3f80031e}},	//   _ҳуку, rrek_, kuzi, _saiu_, 
   {{0xe73a031f,0x600a0320,0x7bcd0321,0x32190322}},	//   лен_, лном_, kiau, _lusy_, 
   {{0x64550323,0x25a58324,0x43948325,0x753c00a1}},	//   duzi, _holl_, _махс, warz, 
   {{0xa9698326,0x21698327,0x25a58172,0xe9698328}},	//   _била_, _били_, _koll_, _балл_, 
   {{0x2d830301,0x64a60329,0x2fc90166,0x4126832a}},	//   gdje_, бага, _emag_, _лошо_, 
   {{0x27ed832b,0xa34a009f,0x68138166,0x7e62832c}},	//   _oken_, лзва_, _pădu, ztop, 
   {{0xb4e8032d,0x7bcd0116,0x3f920108,0x2018032e}},	//   _बडी_, giau, _unyu_, _ruri_, 
   {{0xe297032f,0xb1460330,0x17570039,0x20180331}},	// [120] бат_, йнал, _הספר_, _suri_, 
   {{0x645c8332,0x20180333,0x64550334,0x22400335}},	//   _årig, _puri_, buzi, rsik_, 
   {{0x6c860013,0x27ff8336,0x63bb8337,0x64550338}},	//   _الجم, _bhun_, khun, cuzi, 
   {{0x44440339,0x27ff833a,0xb5fb033b,0x7bcd033c}},	//   _iv_, _chun_, ntán, ciau, 
   {{0x63bb833d,0x4444033e,0x2018033f,0x95ca8340}},	//   dhun, _hv_, _wuri_, лука_, 
   {{0x6b840341,0x20180342,0x27ed8343,0x3f808344}},	//   ldig, _turi_, _eken_, žiu_, 
   {{0x7e628345,0x31cd80cf,0x4444007b,0x628b8346}},	//   stop, রকাশ, _jv_, _argo, 
   {{0x63bb8347,0x2d830348,0xdce380ac,0x7e628349}},	//   ghun, zdje_, leně, ptop, 
   {{0x4444034a,0x67d2034a,0xa5bb00fe,0xd13080fe}},	//   _lv_, nāju, spói, ومة_, 
   {{0x4444034b,0x361b8039,0x2fc9034c,0x1543834d}},	//   _ov_, _עובד, _smag_, _неум, 
   {{0xd90d803d,0x673d00f0,0x2d830269,0x7644034e}},	//   نیه_, tasj, vdje_, _aviy, 
   {{0x63bb834f,0x753a80fa,0xf8b30039,0x20000350}},	//   chun, _hetz, פשר_, _chii_, 
   {{0x44440351,0x6b840352,0x673d00f0,0xa3e58353}},	//   _av_, ddig, rasj, पकर_, 
   {{0x753a8354,0x64550355,0xb21b0142,0x44440356}},	//   _jetz, tuzi, _kræv, _bv_, 
   {{0x7bcd0357,0x63a60358,0x2d830359,0x19ab004a}},	//   tiau, _bokn, rdje_, қтап_, 
   {{0x4444035a,0x753a835b,0x6455035c,0x5c07035d}},	//   _dv_, _letz, ruzi, сяга, 
   {{0x4444035e,0x6d48835f,0x7bcd01e2,0x6e360360}},	// [130] _ev_, _odda, riau, _gwyb, 
   {{0x753a82ae,0x213e8304,0x6b828361,0x44440362}},	//   _netz, nath_, _laog, _fv_, 
   {{0xddc4003b,0x6aad0363,0x27ff8106,0x25a58364}},	//   _upiš, syaf, _phun_, _roll_, 
   {{0x25a5835b,0x64c38365,0x6d488366,0x6b828367}},	//   _soll_, _वेगळ, _adda, _naog, 
   {{0xb5fd8368,0x25a58369,0x9599836a,0x2c618034}},	//   _opšt, _poll_, итку_, wód_, 
   {{0x44440124,0x7afd036b,0x2bb1836c,0x7dc90265}},	//   _yv_, _izst, जस्थ, džsk, 
   {{0x65b0036d,0x63bb836e,0x25a581ed,0x27ff836f}},	//   _sähk, thun, _voll_, _thun_, 
   {{0xb2258370,0x2c6180a1,0x0a498103,0x6d488371}},	//   омил, ród_, азий_, _edda, 
   {{0x60250116,0xb21b00c0,0x7d998372,0x25a58373}},	//   _dėme, _usæd, _квас_, _toll_, 
   {{0x63bb8004,0x81c98374,0x628b8375,0x6e298376}},	//   shun, ргов_, _vrgo, _iteb, 
   {{0xc9520377,0x6b840378,0xa3e90379,0x63bb837a}},	//   ומי_, ydig, मका_, phun, 
   {{0x628b837b,0xe3b381be,0x661b836d,0x6443837c}},	//   _trgo, _عرض_, _kuuk, msni, 
   {{0x6145837d,0xd945837e,0x63a6037f,0x69cf8380}},	//   _дела, _дели, _rokn, éces, 
   {{0x67d200f3,0xb5fb0381,0x6d410382,0x63a60383}},	//   vāju, stán, ólap, _sokn, 
   {{0x8fa60003,0xdb1d0172,0x64438384,0x63a60385}},	//   _маке, _omsä, nsni, _pokn, 
   {{0x44440386,0x67d20029,0x6b840387,0x333f80ef}},	//   _vv_, tāju, udig, naux_, 
   {{0x9f5f8028,0x65b00388,0x49ca0389,0x7983838a}},	// [140] _thuê_, _lähi, алан_, _kanw, 
   {{0xb5fb038b,0x4444038c,0x6b84038d,0xa7fd038e}},	//   ntál, _tv_, sdig, ntın, 
   {{0xef1a838f,0xdce18029,0x79838390,0xdb06016c}},	//   аме_, _dalī, _manw, _kokë, 
   {{0xf1bf0068,0x6d5c0391,0x753a8392,0xbddb0393}},	//   _után_, lgra, _setz, nsèn, 
   {{0x25e6807a,0x3e640394,0x2b400395,0x644100e9}},	//   टवली_, nöt_, maic_, šlit, 
   {{0x27388028,0x67228396,0x6b828015,0xc7b98063}},	//   ẩn_, scoj, _saog, _elő_, 
   {{0xe73a8397,0x263680a1,0x6d5c0398,0x6e298399}},	//   _веб_, sło_, igra, _eteb, 
   {{0x66e6839a,0xdee6839b,0x0b8a839c,0x938a839c}},	//   _доба, _доби, рски_, рска_, 
   {{0x439280b6,0x7983839d,0xed5a839e,0x386d039f}},	//   зақс, _banw, _воз_, _ćeri_, 
   {{0x6d488142,0x6d5c03a0,0x3f84804f,0x23b88035}},	//   _udda, jgra, _hamu_, _déja_, 
   {{0x3f8483a1,0x213e83a2,0xd7fb03a3,0x6d5c03a4}},	//   _kamu_, rath_, иум_, dgra, 
   {{0xa2cb8365,0x3f8483a5,0x333f80ef,0x442e83a6}},	//   _तेव्, _jamu_, caux_, mpf_, 
   {{0xdefb03a7,0x798383a8,0x22948086,0x645883a9}},	//   рын_, _fanw, _хиля, luvi, 
   {{0x69ca83aa,0x6d5c03ab,0x3f8483ac,0x291803ad}},	//   _umfe, ggra, _lamu_, _ngra_, 
   {{0x5ba703ae,0xe0d480c6,0x602181a8,0x645883af}},	//   ораз, _מײַ_, _tēma, nuvi, 
   {{0xdeb300b6,0x6d5c0013,0xdce180f3,0xdb0f033b}},	//   _жұмы, agra, _salī, _alcá, 
   {{0x1ddb81ff,0xdce18029,0x2bbc007a,0x201c82f4}},	// [150] _बदलत, _palī, _ईतरा, _huvi_, 
   {{0x69da83b0,0x6443837c,0x645883b1,0x7afd81c2}},	//   nnte, ysni, kuvi, ýsti, 
   {{0x65ab02ae,0x6e2983b2,0xb5fb03b3,0xe71980d8}},	//   _führ, _steb, ntám, ميات_, 
   {{0xd47a0273,0xa3af03b4,0x8699805a,0x2cac010d}},	//   _פארל, _कवि_, йкес_, ädde_, 
   {{0x333f82c0,0x7afd00f3,0x3f8483b5,0xa5f983b6}},	//   vaux_, _uzst, _damu_, беду_, 
   {{0x644383b7,0x201c83b8,0xdb0403b9,0xa7fd008a}},	//   tsni, _ouvi_, chiñ, xtın, 
   {{0x333f80ef,0x9f3583ba,0x21ef01ed,0x3f8483bb}},	//   taux_, _неві, bühr_, _famu_, 
   {{0x69da83bc,0xeb9983bd,0x644383be,0x3a3903bf}},	//   ente, сии_, rsni, _kwsp_, 
   {{0x76b98004,0x644383c0,0x6d5c03c1,0x798382fa}},	//   _улар_, ssni, ygra, _panw, 
   {{0x644381e2,0x69da83c2,0x65b00079,0x5d5480a6}},	//   psni, gnte, _tähi, _окут, 
   {{0xb5fb03c3,0x7c2d83c4,0x6d5c0284,0x798383c5}},	//   rtál, ćars, vgra, _vanw, 
   {{0xb5fb03c6,0x2d8583c7,0xbebb016c,0x201c8065}},	//   stál, _hale_, rcën, _duvi_, 
   {{0x2d8583c8,0xa2cb03c9,0xcaea03ca,0x19958086}},	//   _kale_, _सेल्, _झुंड_, _надя, 
   {{0xda1f010c,0x6d5c03cb,0x64a603cc,0x2d8783cd}},	//   _बढ़त_, ugra, пага, ndne_, 
   {{0x9f9203ce,0x64a603cf,0xdb06016c,0x224683d0}},	//   lší_, чава, _tokë, _zvok_, 
   {{0x422603d1,0xa7fd03d2,0x225203d3,0x65618128}},	//   здав, ntıl, tryk_, _lclh, 
   {{0x27e003d4,0x6e4600fe,0x9f9203d5,0x6d5c03d6}},	// [160] _ijin_, _عندم, nší_, pgra, 
   {{0x2b4003d7,0xb46603d8,0x2d8582a6,0x2fdf83d9}},	//   saic_, _екол, _nale_, _ajug_, 
   {{0xe1ff00b0,0x106a03da,0x764603db,0x9d1b00c6}},	//   _após_, сией_, lsky, _לויט, 
   {{0x205503dc,0xdc9b03dd,0x3f8683de,0xdb0603df}},	//   ьтур, _היטל, udou_, _loké, 
   {{0x9f9203e0,0x764603e1,0x3f8683e2,0x69da83e3}},	//   jší_, nsky, rdou_, ynte, 
   {{0x645883e4,0x63b603e5,0xa6db007f,0x2d8583e6}},	//   tuvi, lkyn, naða, _cale_, 
   {{0x80d080cf,0x69ce03e7,0x3f8483e8,0x38c28120}},	//   _সুন্, _imbe, _tamu_, _méré_, 
   {{0x69dd83e9,0x645883ea,0xb21b00c0,0x27e000ca}},	//   ésen, ruvi, _græs, _njin_, 
   {{0x2d8583eb,0x6b8603ec,0x201c83ed,0xc98682f0}},	//   _fale_, _makg, _suvi_, пуни, 
   {{0x764603ee,0x69da83ef,0x7d070035,0xdb0603df}},	//   dsky, unte, néré, _coké, 
   {{0x69ce00e5,0x261583f0,0x69da83f1,0xf9930309}},	//   _mmbe, _फूटी_, rnte, גרת_, 
   {{0x09b903f2,0x6028801b,0x78fb03f3,0x2d8583f4}},	//   _इत्य, _něme, מפיו, _zale_, 
   {{0x69ce03f5,0x443a03f6,0x38c283d9,0x9f4b0217}},	//   _ombe, _awp_, _béré_, nocé_, 
   {{0x7afd83f7,0x2d8583f8,0x9f420170,0x38c282ef}},	//   üste, _xale_, roká_, _céré_, 
   {{0x7d0703f9,0x9f42026b,0x6b8603fa,0x628f00ca}},	//   déré, soká_, _bakg, _srco, 
   {{0x27e003fb,0x63a400f8,0xa3bc03fc,0x087783f3}},	//   _gjin_, gjin, _अतः_, _זעהט_, 
   {{0x31bb824a,0x52150325,0xdcf200f3,0x6b8603fd}},	// [170] _hêza_, ддат, īgāk, _dakg, 
   {{0x6e2d03fe,0xceb200c6,0xbba983ff,0x7d070400}},	//   _itab, _סיי_, _छक्क, géré, 
   {{0xb21b0142,0xd7fb8014,0x2d858401,0x75fb0093}},	//   _præs, буд_, _rale_, nîzm, 
   {{0x69ce0402,0xff5f024a,0x64550284,0x2d858403}},	//   _embe, ngî_, mrzi, _sale_, 
   {{0xd2468068,0x7d070404,0x64488405,0x442c8406}},	//   _جن_, béré, _avdi, _atd_, 
   {{0xcb120052,0x442c80bc,0x645501f0,0x9f920407}},	//   _שלך_, _btd_, orzi, vší_, 
   {{0xac09827a,0x62828408,0x2d878409,0x7dc2040a}},	//   онка_, _asoo, rdne_, _fôsf, 
   {{0x2d85822d,0x9f92001b,0x395e80f3,0x2fdf840b}},	//   _wale_, tší_, egts_, _ujug_, 
   {{0xfe70840c,0x2a69040d,0x6e2d040e,0x6448840f}},	//   _مدل_, ntab_, _ntab, _evdi, 
   {{0x9f920410,0x3ce880a1,0xab5b01ab,0x27f20411}},	//   rší_, _चुके_, _flüg, _skyn_, 
   {{0xd37180fe,0xdddb805d,0x6e2d0412,0x3cf0826b}},	//   _لها_, _kruž, _atab, čové_, 
   {{0x65b00413,0x9f920414,0x2a690103,0x7bc08415}},	//   _läht, pší_, ktab_, chmu, 
   {{0xb8f48416,0xa6db01c2,0x443a0417,0xee370418}},	//   _से_, taða, _swp_, мня_, 
   {{0x79870066,0x76460419,0x65b0041a,0x273c0028}},	//   _najw, rsky, _näht, ận_, 
   {{0xdddb8025,0x6e2d041b,0x7646041c,0x69c1841d}},	//   _oruž, _etab, ssky, mhle, 
   {{0x6d43841e,0xeb97041f,0x6b898420,0x6f1b8421}},	//   hana, мис_, ndeg, _nguc, 
   {{0xdb0b8422,0x59e1824c,0x63ab8423,0x63a680f9}},	// [180] _algú, _पदार, _mogn, ökni, 
   {{0x6d438424,0x63ab8425,0x63b60426,0x63a40427}},	//   jana, _logn, skyn, sjin, 
   {{0x657c0428,0x628b010d,0x7bc78162,0x76498429}},	//   merh, ågor, _įjun, _avey, 
   {{0x645c042a,0xdd8f842b,0xe29a042c,0x657c042d}},	//   muri, یون_, _дам_, lerh, 
   {{0xdddb842e,0x6d43842f,0x4cd300b2,0x79888324}},	//   _druž, fana, _দুপু, yddw, 
   {{0x69ce0430,0x657c02ae,0x442c83bf,0x63ab8097}},	//   _umbe, nerh, _ptd_, _aogn, 
   {{0x645c0431,0x7649817c,0x442c8432,0x69c18433}},	//   nuri, _evey, _qtd_, dhle, 
   {{0x63ab8434,0xdddb8435,0x6d438009,0x31bb8093}},	//   _cogn, _gruž, aana, _rêza_, 
   {{0x6d438436,0x657c0437,0x645c0438,0xe7bd8439}},	//   bana, kerh, huri, ्फरप, 
   {{0x645c0438,0x66e4805a,0x442c80db,0x657c0149}},	//   kuri, _жоға, _ttd_, jerh, 
   {{0x39570052,0x6e208210,0x7988843a,0x63ab843b}},	//   ושים_, _humb, rddw, _fogn, 
   {{0x6e20843c,0x628281c8,0xe29a81e2,0x26c681df}},	//   _kumb, _tsoo, _мае_, ozoo_, 
   {{0x6e20843d,0xdce881e2,0xdde2043e,0x26c68149}},	//   _jumb, _padė, _šušk, nzoo_, 
   {{0xceb38273,0xe0cf842b,0x645c043f,0x69c18440}},	//   דיש_, ازی_, furi, chle, 
   {{0x67d50441,0x6e208442,0xb5fb00fe,0xdb060019}},	//   _поку, _lumb, ntái, _elkü, 
   {{0x6d438443,0x2a690444,0x2cac010d,0x7c22008d}},	//   zana, ttab_, ädda_, _čort, 
   {{0x6e208445,0x657c0446,0x6e2d0447,0x65950448}},	// [190] _numb, berh, _utab, _запу, 
   {{0x6d4382d1,0x645c0449,0x765d044a,0x4905801b}},	//   xana, buri, musy, हेको_, 
   {{0xdddb8131,0x6d43844b,0x2a690073,0x765d044c}},	//   _pruž, vana, stab_, lusy, 
   {{0x6d43844d,0x2a69044e,0x442103d9,0x93c90019}},	//   wana, ptab_, _iuh_, _راجہ_, 
   {{0xcb360052,0x65b0044f,0x6e208450,0x6d438451}},	//   _ראשי_, _täht, _cumb, tana, 
   {{0x63ab8452,0xa2bf0453,0x9f4d8304,0x65948454}},	//   _sogn, लैण्, _cheò_, качу, 
   {{0x6d438455,0xc8640456,0x44210033,0x22490457}},	//   rana, _итти, _juh_, lsak_, 
   {{0x6d438458,0x65b002ae,0x6e208459,0x26c6822a}},	//   sana, _jähr, _fumb, bzoo_, 
   {{0x6d43845a,0x645c845b,0x6b89845c,0x6e20845d}},	//   pana, _årin, rdeg, _gumb, 
   {{0x6d43845e,0x645c045f,0x9f4d8097,0x6b898460}},	//   qana, yuri, _gheò_, sdeg, 
   {{0x657c0461,0xe8f98462,0x6d4180f3,0x67248463}},	//   verh, яло_, _iela, žije, 
   {{0xf0920464,0x657c0465,0x22490466,0x645c0467}},	//   אנט_, werh, ksak_, vuri, 
   {{0x6d418468,0x657c0469,0x3e6980e9,0x97c6004a}},	//   _kela, terh, nút_, _үйле, 
   {{0x6d41846a,0x92c1846b,0x9aa4846c,0xdd92046d}},	//   _jela, ığın, _جمهو, دوس_, 
   {{0x6d41846e,0xfce3046f,0x66030470,0xddcd0123}},	//   _mela, горо, упра, _spaţ, 
   {{0x6d418471,0xa2d4807a,0x645c0472,0x765d0473}},	//   _lela, _बेड्, ruri, busy, 
   {{0x44210474,0xf41280c6,0x22490475,0x02060476}},	// [1a0] _euh_, רפן_, gsak_, езан, 
   {{0x6d418477,0x645c0478,0xe889801c,0xe1f70479}},	//   _nela, puri, _kẻ_, егу_, 
   {{0x6e20847a,0x4421024a,0x65b001ed,0xdddb8034}},	//   _sumb, _guh_, _fähr, _druż, 
   {{0xfaa6047b,0xa2cb047c,0xfe46847d,0xe666847e}},	//   _замо, _सेक्, ендо, етко, 
   {{0xe889801c,0x7bd6047f,0x98ac008a,0x394580f3}},	//   _lẻ_, miyu, ğlıq_, kals_, 
   {{0xe5a38480,0x6d4182ab,0x7bd60481,0x6da38482}},	//   личи, _cela, liyu, лича, 
   {{0x6d418483,0x8d1a8068,0x26c681df,0x7c218097}},	//   _dela, _ہزار_, szoo_, _culr, 
   {{0x6e208484,0xb5fb00fe,0x6d4182f4,0x8aa68485}},	//   _tumb, rtái, _eela, ерод, 
   {{0x6d418486,0xb5fb0013,0xdee38487,0x6aa4011e}},	//   _fela, stái, _боти, nxif, 
   {{0x64a68488,0xb5ca8068,0x39458489,0x7afd808a}},	//   _паза, _عوام_, gals_, üsta, 
   {{0x815700c6,0x3f89048a,0xb985804a,0xdb12007f}},	//   עסטע_, _paau_, ттық, _ágæt, 
   {{0xfa888147,0x6d41848b,0x765d048c,0xb5fb048d}},	//   _từ_, _zela, tusy, ntáv, 
   {{0x6d4180f6,0x42db00b2,0x7d27810d,0x4421048e}},	//   _yela, _দর্শ, _årså, _suh_, 
   {{0x3945848f,0x6d4182a5,0x9f4b001b,0x661a8490}},	//   cals_, _xela, mocí_, _jitk, 
   {{0x317e80d4,0x62860491,0xb3a48492,0x661a8493}},	//   metz_, _asko, _खचाख, _mitk, 
   {{0x7bc40494,0x7bdf0495,0x22490496,0xdcf8808d}},	//   ghiu, unqu, tsak_, jevč, 
   {{0x66d38068,0x443e82fa,0x9f4b0396,0x672d0497}},	// [1b0] _műkö, _lwt_, nocí_, _ifaj, 
   {{0x661a8498,0x44210499,0x65b002ae,0x628600db}},	//   _nitk, _tuh_, _währ, _dsko, 
   {{0x6286049a,0x6d47049b,0x20090028,0x2249049c}},	//   _esko, maja, _khai_, ssak_, 
   {{0x6d41849d,0x6d47049e,0x200901df,0x7bc4049f}},	//   _sela, laja, _jhai_, chiu, 
   {{0x439404a0,0x661a84a1,0x6b9d04a2,0xdb0b80f8}},	//   _саяс, _bitk, _insg, _vogë, 
   {{0x6d4704a3,0xb90700cf,0xdce88029,0x6b8d04a4}},	//   naja, _পর_, _gadī, ldag, 
   {{0x63af029f,0xab5b02ae,0x80d080b2,0x644a84a5}},	//   _kocn, _glüc, _সুস্, gsfi, 
   {{0x6d4184a6,0x69d701e0,0xe8898028,0x6d4704a7}},	//   _wela, lixe, _rẻ_, haja, 
   {{0x6d418271,0x394584a8,0xe8898028,0x63af04a9}},	//   _tela, tals_, _sẻ_, _mocn, 
   {{0x6d4704aa,0x27fd843a,0x798a843a,0x93bc84ab}},	//   jaja, llwn_, _cafw, _stăt, 
   {{0x394584ac,0x6d4704ad,0x2fc001ea,0xb90280f0}},	//   rals_, daja, _plig_, изьк, 
   {{0x394584ae,0xe8898028,0x200904af,0x6b8d04b0}},	//   sals_, _vẻ_, _chai_, jdag, 
   {{0x63a98310,0x6b8d03b7,0x93b68052,0xddcd04b1}},	//   mjen, ddag, _שלנו_, _spaš, 
   {{0xceb2804d,0x6d4704b2,0x63bb84b3,0x1d0a0188}},	//   סים_, gaja, lkun, деги_, 
   {{0xdce880f3,0x69d7011e,0x443e04b4,0xddc280f3}},	//   _radī, dixe, èt_, ntoš, 
   {{0x63a984b5,0x2eb604b6,0x6b8d04b7,0x63bb84b8}},	//   njen, _асос, gdag, nkun, 
   {{0x6b8b84b9,0x6d4704ba,0x39510269,0x4b2300f0}},	// [1c0] _magg, baja, _bdzs_, рмув, 
   {{0x6d470025,0x63a984bb,0x142604bc,0xb65b0080}},	//   caja, hjen, _идом, _קדיש, 
   {{0x63bb84bd,0xdce88029,0x63a984be,0x661a84bf}},	//   kkun, _vadī, kjen, _ritk, 
   {{0x6b8b84c0,0x7053007b,0x7bd600e5,0x2a6d84c1}},	//   _nagg, شنها, qiyu, kteb_, 
   {{0x63a984c2,0x628604c3,0x661a836d,0x443e84c4}},	//   djen, _usko, _pitk, _swt_, 
   {{0xb5fb04c5,0x69c504c6,0x8d6384c7,0xd49a84c8}},	//   stáv, chhe, авље, дри_, 
   {{0xa0a304c9,0x18a304ca,0x6b8b84cb,0xcbe684cc}},	//   _кард, _карм, _bagg, кции, 
   {{0x63a984cd,0xc0e304ce,0x63bb84cf,0x09da8076}},	//   gjen, _тоск, gkun, यच्य, 
   {{0xd00f8013,0xfbd30052,0x20090324,0x6b8b84d0}},	//   _ذلك_, יתה_, _rhai_, _dagg, 
   {{0xa3f5800d,0x661a8387,0x6b8d04d1,0xb4d2009b}},	//   ější_, _uitk, zdag, _वधू_, 
   {{0x2d9e84d2,0x6d4704d3,0x63a98208,0xd1388116}},	//   _inte_, vaja, bjen, rbą_, 
   {{0x2d8c84d4,0x317e81ed,0x6b8b84d5,0x63bb82ae}},	//   _hade_, setz_, _gagg, ckun, 
   {{0x6d4704d6,0x2d8c84d7,0x6e2404d8,0xc9aa84d9}},	//   taja, _kade_, _cuib, _овде_, 
   {{0xea778039,0xa4d500f0,0x9f4f8400,0x63af01f7}},	//   _סגור_, гогі, rogé_, _socn, 
   {{0x7f9504da,0x6d4704db,0x63af0053,0xc7c704dc}},	//   _байх, raja, _pocn, _аспи, 
   {{0x6d4704dd,0x5f7704de,0x2d8c84df,0x2009004f}},	//   saja, _شاعر, _lade_, _uhai_, 
   {{0x2d9e84e0,0x6d4704e1,0x63af0259,0x2fc680df}},	// [1d0] _onte_, paja, _vocn, dhog_, 
   {{0x63bb80b4,0x6b8d03b7,0x7e6d04e2,0x68fc04e3}},	//   zkun, sdag, _iqap, _byrd, 
   {{0x442704e4,0x3eb904e5,0xc9538115,0x69d704e6}},	//   _în_, lyst_, שמע_, rixe, 
   {{0x2d9e84e7,0xb4c100a1,0x76598324,0x2fc682b1}},	//   _ante_, ्छी_, trwy, ghog_, 
   {{0x6d4504e8,0x6b8b84e9,0x4ea78086,0xe78484ea}},	//   _keha, _ragg, ържа, рухо, 
   {{0xa93404eb,0xf2d20052,0x1d0984ec,0xfce584ed}},	//   _верш, _פעם_, нели_, лоло, 
   {{0x6d4504ee,0x63a984ef,0x6b8b84f0,0x7afd04f1}},	//   _meha, tjen, _pagg, _hyst, 
   {{0x2d9e84f2,0x6d4503ec,0xddc284f3,0x7afd04f4}},	//   _ente_, _leha, rtoš, _kyst, 
   {{0x63a984f5,0xee8484f6,0x7bc2800d,0x5ba4804a}},	//   rjen, _выхо, _dlou, рлығ, 
   {{0x63bb84f7,0xdcbb8021,0x2d8c8246,0x6d4504f8}},	//   skun, _още_, _gade_, _neha, 
   {{0x2dd880fe,0xf74604f9,0x046784fa,0x7afd04fb}},	//   _شبكة_, лено, _штам, _lyst, 
   {{0xdb0f0077,0xc43a84fc,0x7ae48284,0x44258123}},	//   _você, _נתני, _žite, _iul_, 
   {{0x442584fd,0x6d4504fe,0x7afd04ff,0x69d50500}},	//   _hul_, _beha, _nyst, _omze, 
   {{0x88c58501,0x44258502,0x2bcf8503,0x7bc2806a}},	//   _متعل, _kul_, तोरा, _zlou, 
   {{0x41b6005a,0x79818504,0x224d8505,0x6d450506}},	//   қсат, melw, lsek_, _deha, 
   {{0x7afd0507,0x2d8c0508,0x798182a6,0x44258073}},	//   _byst, žde_, lelw, _mul_, 
   {{0x7afd011a,0xdcfc026b,0x314404bc,0x44258509}},	// [1e0] _cyst, merč, идаҳ, _lul_, 
   {{0x6d45050a,0x7afd050b,0x798183a8,0x4425850c}},	//   _geha, _dyst, nelw, _oul_, 
   {{0xdb06003e,0x2d8c850d,0xdce38116,0xb5fb050e}},	//   _doká, _rade_, menė, rtát, 
   {{0xb5fb050f,0x6d450124,0x224d8214,0x03a60510}},	//   gráf, _zeha, ksek_, _симо, 
   {{0xdef780a6,0x798183ec,0x644180e5,0x7f3b00c6}},	//   лыш_, kelw, _awli, גענו, 
   {{0x7bc2801b,0x65948511,0x44258512,0xd5b1801c}},	//   _slou, раку, _bul_, _có_, 
   {{0x44258513,0x5b268514,0x2d8c8214,0x7bc28515}},	//   _cul_, льпа, _vade_, _plou, 
   {{0xb5fb0516,0x44258013,0x3f8204b1,0xaa548517}},	//   ntár, _dul_, jeku_, авиш, 
   {{0x2d8c8518,0x64418519,0x7981851a,0xbebb016c}},	//   _tade_, _ewli, felw, ncët, 
   {{0xc05a851b,0x602180f3,0x4425851c,0x7981811a}},	//   нім_, _lēmu, _ful_, gelw, 
   {{0x4425851d,0x6d4a851e,0x2918851f,0x798e0520}},	//   _gul_, mafa, ära_, _mabw, 
   {{0x6d450521,0x6d4a8522,0x644e0523,0xa6db007f}},	//   _seha, lafa, dsbi, laði, 
   {{0x6d450524,0x79818525,0x645c0122,0x44258526}},	//   _peha, belw, erri, _zul_, 
   {{0xbb1b02c0,0xa934825c,0x6d4a8527,0xa6db01c2}},	//   _maît, _текш, nafa, naði, 
   {{0x9f35005a,0x442581e0,0x6d450528,0xd5b804eb}},	//   _кейі, _xul_, _veha, уся_, 
   {{0xc4c48529,0x6d4a852a,0x7afd0008,0xa3cf052b}},	//   _ہے_, hafa, _pyst, वों_, 
   {{0x6d4a852c,0x6d45052d,0x645c02fe,0x1dc40188}},	// [1f0] kafa, _teha, arri, рөөн, 
   {{0x7afd052e,0x645a052f,0x98be802d,0xb5fb0063}},	//   _vyst, átic, cată_, rtás, 
   {{0x7afd0066,0x2d83029a,0xb5fb0530,0x798e0531}},	//   _wyst, meje_, tráf, _dabw, 
   {{0x31e18532,0x645a0533,0x2d830534,0x7afd0535}},	//   _पद्ध, štic, leje_, _tyst, 
   {{0x44258536,0x3ea58537,0xb6a58538,0x6d4a8539}},	//   _sul_, рилг, рилл, fafa, 
   {{0x4425853a,0x2d83053b,0xf483804e,0x6d4a81d7}},	//   _pul_, neje_, ماعی, gafa, 
   {{0x63ad0116,0xa7fd0083,0x4425853c,0xa2d9053d}},	//   ojan, ntıs, _qul_, _नेत्, 
   {{0xeb9984bc,0x442582b5,0x98be8123,0xddc4053e}},	//   тии_, _vul_, zată_, _spiż, 
   {{0x69da853f,0x6b8f0540,0x6d4a8541,0x6e948542}},	//   fite, _macg, bafa, _литу, 
   {{0x2d830543,0x44258544,0x27e90545,0x69c88094}},	//   jeje_, _tul_, _ajan_, ghde, 
   {{0xe73a0546,0x2d830547,0x66ca8019,0x63ad0548}},	//   кен_, deje_, _töké, kjan, 
   {{0xc6000549,0xb5fb054a,0x224d854b,0x63ad012c}},	//   ोग्य_, hrád, psek_, jjan, 
   {{0x63ad054c,0x98be8123,0x2bc9054d,0x8e76054e}},	//   djan, tată_, रसना, шунч, 
   {{0x3f82054f,0x6cc60550,0x69c88551,0x644e0552}},	//   seku_, айга, chde, tsbi, 
   {{0x98be802d,0x645c0553,0xdd0e02d2,0x39478554}},	//   rată_, urri, _dışa, _iens_, 
   {{0xc0528039,0x7bc980ef,0xdb0b8555,0x63ad0556}},	//   _וזה_, nheu, _logí, gjan, 
   {{0xeab70188,0x6d4a8557,0x661e0558,0xe1fa0103}},	// [200] айт_, yafa, _tipk, вга_, 
   {{0x39478559,0x6d4a855a,0xb5fb055b,0xdebb055c}},	//   _jens_, xafa, stár, _סמיל, 
   {{0xdca60004,0x64a6055d,0xa3af00da,0x63ad055e}},	//   _тани, _тана, _कवच_, bjan, 
   {{0x69da855f,0x6d4a8010,0x764400bb,0x6e930139}},	//   zite, wafa, _kwiy, _الیا, 
   {{0xb8fd0560,0xe8e28561,0x23a98562,0x2a7d81df}},	//   _ते_, _पश्च, कानद, _npwb_, 
   {{0x44440563,0x394780a6,0xb8660019,0x6b840564}},	//   _kw_, _nens_, _پاسو, leig, 
   {{0x92e280cf,0x8bc68004,0x292700e9,0x03c68565}},	//   _ধরে_, исид, ávať_, исим, 
   {{0x44440566,0x69da8567,0x0fc100b2,0x6b840568}},	//   _mw_, wite, _উদ্ধ, neig, 
   {{0x444402ee,0x27e68009,0x39478569,0x6d4a8129}},	//   _lw_, mnon_, _bens_, pafa, 
   {{0x444402ee,0x63ad056a,0x4973856b,0x2259856c}},	//   _ow_, zjan, ольс, áska_, 
   {{0x628b856d,0x19a7824f,0x58d880f0,0x3947856e}},	//   _esgo, ртып_, удня_, _dens_, 
   {{0x394782da,0x27e6856f,0x6d488109,0x7bc98570}},	//   _eens_, nnon_, _heda, cheu, 
   {{0x44440571,0x6d488572,0x63a28573,0x5f940574}},	//   _aw_, _keda, _inon, цият, 
   {{0x6d488025,0x44440575,0x7bc60576,0x39478577}},	//   _jeda, _bw_, _alku, _gens_, 
   {{0x6d488578,0x2d830579,0xf77f057a,0x63ad057b}},	//   _meda, reje_, ança_, tjan, 
   {{0x7c288025,0x6d48857c,0x4444057d,0x628b8360}},	//   _mudr, _leda, _dw_, _ysgo, 
   {{0x4444057e,0x7179057f,0x7c288580,0x29050581}},	// [210] _ew_, лбар_, _ludr, _šla_, 
   {{0x6f098066,0x394704e0,0x39478065,0x394c8582}},	//   _rzec, úns_, _xens_, nads_, 
   {{0x44440583,0x63ad0584,0x63a28585,0x6b8401a8}},	//   _gw_, pjan, _onon, beig, 
   {{0x27e68586,0x201400a6,0xdc9a03f3,0x7d080587}},	//   gnon_, _èxit_, _עירל, üdse, 
   {{0x7c288588,0x69d88589,0x4444058a,0xed59858b}},	//   _audr, _omve, _zw_, гол_, 
   {{0x63a2858c,0x44440360,0x27e6858d,0x5f0a058e}},	//   _anon, _yw_, anon_, _सरस्_, 
   {{0x4444058f,0x6d488590,0xa6db012b,0x97a78591}},	//   _xw_, _deda, maðu, _крал, 
   {{0x39478592,0x69c70593,0x23690594,0x1dd98595}},	//   _sens_, _hlje, ngaj_, _भगवत, 
   {{0xe1f98596,0x6d488597,0x248c8598,0xe7308019}},	//   лги_, _feda, _esdm_, _آصف_, 
   {{0xa2e58599,0x6b84035b,0x6d48859a,0xa6db007f}},	//   _қолд, zeig, _geda, naðu, 
   {{0xa3e8059b,0x69c702cf,0x7c28859c,0x7dc200e9}},	//   _बदल_, _mlje, _gudr, _dôsl, 
   {{0x4444059d,0x6e21859e,0x39478387,0x7dc201ac}},	//   _rw_, _hilb, _wens_, _pôso, 
   {{0x34b2059f,0x69c705a0,0xa7fd02d2,0x6fc600d8}},	//   ीन्द, _olje, ttır, _cóca, 
   {{0x444405a1,0x6e2985a2,0x6e2185a3,0x28b980fe}},	//   _pw_, _mueb, _jilb, _مطبخ_, 
   {{0x4444027e,0x6b560014,0x6b8405a4,0xdb0b82fd}},	//   _qw_, йтах, teig, _fogã, 
   {{0xf1bf001c,0x69c705a5,0x444405a6,0x69c1800b}},	//   _quán_, _alje, _vw_, lkle, 
   {{0x69c705a7,0xa7fd0214,0xfaa305a8,0x6e2982b1}},	// [220] _blje, ptır, пато, _nueb, 
   {{0x444405a9,0x01d70013,0x69c185aa,0x2007859e}},	//   _tw_, موقع_, nkle, înin_, 
   {{0x444405ab,0x3f9205ac,0x6d4e05ad,0x291c05ae}},	//   _uw_, _kayu_, maba, äva_, 
   {{0x6d4e05af,0x4fea805a,0x7c2882ef,0x7bc605b0}},	//   laba, ымен_, _rudr, _ulku, 
   {{0x6e218124,0xa3ab85b1,0x7f49808b,0x2b4005b2}},	//   _bilb, खान_, _deeq, mbic_, 
   {{0x6d4e05b3,0x225f85b4,0x3f9205b5,0xe1e785b6}},	//   naba, druk_, _layu_, _رس_, 
   {{0x2bbf05b7,0x6d4885b8,0xb5fb026b,0x6e2185b9}},	//   _एकमा, _veda, duál, _dilb, 
   {{0x69de05ba,0x6d4e05bb,0x9b6a85bc,0x6d4885bd}},	//   lipe, haba, ушка_, _weda, 
   {{0x6d4e05be,0x6d4885bf,0x7dcb0085,0x394c85c0}},	//   kaba, _teda, _hüse, tads_, 
   {{0x8c0000b2,0x69de05c1,0x6d48847f,0x9f420170}},	//   ্দিন_, nipe, _ueda, roký_, 
   {{0x64a385c2,0x672d85c3,0x3f920497,0x9f420170}},	//   _нафа, žaje, _bayu_, soký_, 
   {{0x442205c4,0xaad9810c,0x69de05c5,0x225f85c6}},	//   _nik_, _बेवक, hipe, bruk_, 
   {{0x69de05c7,0x3f9202fa,0x394a05c8,0x2bbf05c9}},	//   kipe, _dayu_, _oebs_, _एकबा, 
   {{0x6d4e05ca,0xf1bf05cb,0x44220172,0x30a685cc}},	//   gaba, _cuál_, _aik_, _грив, 
   {{0x645a05cd,0x69de05ce,0x61fa8004,0xc05a85cf}},	//   štin, dipe, motl, _сіл_, 
   {{0x69c70301,0x442205d0,0x61fa8004,0xeda585d1}},	//   _slje, _cik_, lotl, _गच्छ, 
   {{0x6d4e05d2,0x442205d3,0x69c70053,0x2a6005d4}},	// [230] baba, _dik_, _plje, grib_, 
   {{0x7c22811e,0x6f0d05d5,0x442205d6,0x7f4f02fb}},	//   _lior, _izac, _eik_, lacq, 
   {{0x44220022,0x2fc905d7,0x66038507,0x6d4105d8}},	//   _fik_, _klag_, vlnk, ılad, 
   {{0x1da705d9,0x6e2985da,0xdb0b8013,0x44220142}},	//   खावत, _pueb, _logá, _gik_, 
   {{0x7bdf05db,0x7bcd05dc,0x61fa85dd,0x7ae485de}},	//   miqu, mhau, kotl, _žitn, 
   {{0x7bdf05df,0x628f05e0,0xb5fb05e1,0x442205e2}},	//   liqu, _isco, xuál, _zik_, 
   {{0xddcc01e2,0x224680f6,0x442200f6,0x7c2285e3}},	//   _žiūr, _awok_, _yik_, _bior, 
   {{0x23c905d9,0x7bdf05e4,0xa91c8038,0x6d4e05e5}},	//   रसिद, niqu, teľn, zaba, 
   {{0x6e2185e6,0xb5fb05e7,0x7c2285e8,0x3e72802d}},	//   _tilb, tuál, _dior, cât_, 
   {{0x80be00cf,0x8d77842b,0xe9d985e9,0x3f9205ea}},	//   ্পর্, _دارا, рко_, _sayu_, 
   {{0x2d8785eb,0x7c22809f,0x3f9205ec,0x2fc905ed}},	//   mene_, _fior, _payu_, _blag_, 
   {{0x7c228021,0xdd0e85ee,0x6d4e05ef,0x2d8785f0}},	//   _gior, lışm, waba, lene_, 
   {{0x6d4e05f1,0x7bdf05f2,0x442205f3,0x7bcd05f4}},	//   taba, diqu, _rik_, dhau, 
   {{0x442205f5,0x2d8785f6,0xdb0f0065,0xdd0e83d2}},	//   _sik_, nene_, _cocí, nışm, 
   {{0x6d4e05f7,0x7bdf05f8,0x628f009f,0x629d05f9}},	//   raba, fiqu, _asco, _arso, 
   {{0x7bdf05fa,0xb5fb05fb,0x2d8785fc,0x3f86811e}},	//   giqu, trác, hene_, xeou_, 
   {{0xe9da05fd,0x6d4e05fe,0x2d8785ff,0xb5fb00e9}},	// [240] ака_, paba, kene_, urác, 
   {{0x27ff8600,0x6d4e0601,0xe16600fe,0xdb0b8065}},	//   _akun_, qaba, تدري, _xogá, 
   {{0x44220602,0x2d87836a,0x628f0603,0x30860604}},	//   _tik_, dene_, _esco, تلاف, 
   {{0xeb9a0605,0x7bdf0606,0xb5fb026b,0x394a0607}},	//   _тим_, ciqu, prác, _webs_, 
   {{0x2a6000e5,0x7c228608,0xfe6f8609,0x61fa8103}},	//   qrib_, _rior, ندو_, yotl, 
   {{0x69de0210,0x2d87860a,0x443a060b,0x7c228015}},	//   qipe, gene_, _ktp_, _sior, 
   {{0x69dc00fe,0x7c22860c,0x6fc6011e,0x50b5060d}},	//   _imre, _pior, _nóco, _есту, 
   {{0x78a1060e,0xa3ba80fe,0x27ed816c,0xe3bf0149}},	//   _álva, شاعر_, _gjen_, _tiñe_, 
   {{0xa91c8038,0xf41302f9,0x69dc02fa,0x7c228166}},	//   teľo, ופה_, _kmre, _vior, 
   {{0x2fc9060f,0x7a450610,0x2006816c,0x61e881ed}},	//   _slag_, lîtî, lloi_, undl, 
   {{0x09b7830b,0xeb070611,0x28f88612,0x2fc9058f}},	//   تطيع_, _शर्त_, сень_, _plag_, 
   {{0x9325807b,0x4ea70613,0x32058039,0x7bdf0614}},	//   _فرهن, орга, ally_, xiqu, 
   {{0x645a005d,0x442c8615,0x69dc0616,0xf98f80dd}},	//   štil, _hud_, _omre, ربی_, 
   {{0x442c805d,0x63a60617,0x72e980c6,0x61fa83ad}},	//   _kud_, _ankn, _פֿײַ, qotl, 
   {{0x7bdf0618,0x69ca80db,0x442c8166,0x7bcd0619}},	//   tiqu, _ilfe, _jud_, thau, 
   {{0x5a35061a,0x7988861b,0x3a39061c,0xd6db061d}},	//   знат, ledw, _ptsp_, _вто_, 
   {{0x7bdf03e9,0x442c861e,0x7bcd061f,0x2d930620}},	// [250] riqu, _lud_, rhau, _taxe_, 
   {{0x7bdf0577,0x7bcd0621,0x442c8622,0x798882d7}},	//   siqu, shau, _oud_, nedw, 
   {{0x2d878623,0x6e2d022a,0xf8ca8624,0x20ca8625}},	//   vene_, _huab, ानिय, ानिध, 
   {{0x6d5a8626,0x2d878627,0x7e62839d,0x6e2d0628}},	//   _adta, wene_, frop, _kuab, 
   {{0xf7708629,0x27ed80f8,0x2d87836a,0xd6db839b}},	//   ضان_, _vjen_, tene_, јте_, 
   {{0x442c862a,0xb2ba0309,0x6e2d062b,0xa2ba0309}},	//   _bud_, _המשר, _muab, _המשט, 
   {{0x2d87862c,0xd838062d,0x27ff81d0,0x7d1c81c2}},	//   rene_, _мэт_, _tkun_, _úrsl, 
   {{0x5ba9862e,0x442c862f,0x2d878630,0x69ca8631}},	//   ским_, _dud_, sene_, _alfe, 
   {{0xe9d98632,0x2d878633,0x79950191,0x6448808b}},	//   йки_, pene_, _kazw, _ewdi, 
   {{0x6ca78634,0x442c80fe,0x69c50635,0x2ba981cf}},	//   _мреж, _fud_, nkhe, काहा, 
   {{0x6d438636,0x442c8088,0x98a58637,0x79950531}},	//   mbna, _gud_, чине, _mazw, 
   {{0x69ca8638,0xe29f007f,0x7649812c,0x7f5b808b}},	//   _elfe, _orð_, _kwey, _jduq, 
   {{0xb9028639,0xfaa5863a,0x7bcb863b,0x629800f3}},	//   _ने_, _хало, _ilgu, āvok, 
   {{0xceb2804d,0x69c5063c,0x79950066,0x645a005d}},	//   עים_, jkhe, _nazw, štim, 
   {{0x61e1863d,0x64a3063e,0x6455063f,0x76498640}},	//   mill, нара, gszi, _lwey, 
   {{0x61e18641,0x67298642,0x3cde8073,0x69dc0643}},	//   lill, _ngej, _कइसे_, _smre, 
   {{0x61e18644,0x443a00db,0x2737001c,0x37e180b2}},	// [260] oill, _wtp_, _ủng_, যকার, 
   {{0x443a0645,0x3ea001f3,0x7e628103,0x6d410646}},	//   _ttp_, _irit_, vrop, ılac, 
   {{0x7e62837f,0x6e3b8647,0x55bb0309,0x2ec48648}},	//   wrop, _atub, _המיו, वन्त, 
   {{0x442c8649,0x2d98064a,0x7988864b,0x2d8a064c}},	//   _rud_, ldre_, zedw, lebe_, 
   {{0xdfcf864d,0xc61580cf,0xdd94864e,0x2a69027e}},	//   دين_, াদনা_, далы, cuab_, 
   {{0x7bcb8555,0x2d98064f,0xb5fb0650,0x61e18651}},	//   _algu, ndre_, hrán, jill, 
   {{0xf7468652,0x200683e9,0x62828653,0xb4c6800d}},	//   _нево, ploi_, _spoo, उने_, 
   {{0x7dcb0654,0x9f5900ef,0x2d8a0655,0x61e18656}},	//   _müsa, posé_, hebe_, eill, 
   {{0x63b98657,0x798882b9,0xfa8a8103,0x61e18658}},	//   _down, tedw, ёсий_, fill, 
   {{0xe3bf0659,0x442c865a,0xed57865b,0x6d5a806d}},	//   _miña_, _tud_, _ноу_, _udta, 
   {{0xe3bf0659,0xb5fb065c,0x442c865d,0xdcf500f3}},	//   _liña_, frán, _uud_, rdzī, 
   {{0x61fe0047,0x61e1865e,0x7988865f,0x22400660}},	//   hopl, aill, sedw, kpik_, 
   {{0xdefb03a7,0x71a68661,0x61fe0662,0xe3bf05a2}},	//   сын_, _надз, kopl, _niña_, 
   {{0x61e18663,0x64550068,0x217684bc,0x99768664}},	//   cill, tszi, _худр, _худш, 
   {{0x3ea0017c,0x48dc009b,0xb5fb03d5,0xe97b8039}},	//   _erit_, _गेलो_, brán, _הנוש, 
   {{0xcf2700fe,0x3ea0006d,0x2d980665,0x6e2d0666}},	//   _عربي, _frit_, adre_, _tuab, 
   {{0x44268667,0x7c260668,0x61eb8019,0x2d8a0669}},	// [270] _mio_, _dikr, _állí, bebe_, 
   {{0x2d8a03b8,0x4426866a,0x61fe0105,0xeb9f066b}},	//   cebe_, _lio_, gopl, _skød_, 
   {{0x7c26066c,0x69c5066d,0xc05b004a,0x25d800c6}},	//   _fikr, rkhe, сіз_, _מוזן_, 
   {{0x61e1866e,0x4426866f,0xb8d50353,0xe29f01c2}},	//   zill, _nio_, _जप_, _eyða_, 
   {{0x6ff580a1,0xcb9a0039,0x63b98670,0xf8a98671}},	//   jące, _וסרט, _rown, _छप्प, 
   {{0xd1268013,0x06f4803d,0x6b898672,0x3ea28103}},	//   _لم_, رسنج, weeg, тишг, 
   {{0x44268025,0x2ba98673,0x6b898674,0xdb060401}},	//   _bio_, काला, teeg, _ankè, 
   {{0x2fc68053,0x5f948675,0x44268676,0x3f8b0677}},	//   ckog_, _пист, _cio_, jecu_, 
   {{0x44268678,0x6b898679,0x8d87867a,0x60188008}},	//   _dio_, reeg, _нужд, _хотя_, 
   {{0x61e180ef,0x63b982fa,0x26c20162,0x5555803d}},	//   uill, _wown, vyko_, _آپار, 
   {{0x61e1867b,0x7dd00008,0x442683b8,0xb5fb067c}},	//   rill, _jäse, _fio_, trán, 
   {{0x61e1867d,0x4426867e,0xdee6067f,0x66e60680}},	//   sill, _gio_, доми, дома, 
   {{0x7dd00172,0xb5fb060e,0x6fc60065,0xab0b803d}},	//   _läse, rrán, _hóck, _اتاق_, 
   {{0xb21b0681,0x2611010c,0x7c260682,0x61e18103}},	//   _spæn, _दीदी_, _sikr, qill, 
   {{0x2d9801b4,0x3e76006d,0x3b960077,0x2d8a0683}},	//   rdre_, sæt_, мјат, rebe_, 
   {{0x6ff6030b,0x3ea00684,0xea01001c,0xe3bf0685}},	//   _تستط, _trit_, _đạp_, _piña_, 
   {{0x61fe0686,0x2bbf0687,0x3b07009f,0x7c260688}},	// [280] topl, _एकरा, дето_, _vikr, 
   {{0x3cde8689,0xe3bf060e,0xc98600d8,0x2fcd8166}},	//   _कइले_, _viña_, بشري, _aleg_, 
   {{0x61fe068a,0x8cb503ff,0x7c2601e2,0x2fc6868b}},	//   ropl, _उपयो, _tikr, tkog_, 
   {{0xe3bf0659,0x672d868c,0x4f0a868d,0x2fcd868e}},	//   _tiña_, žajn, онен_, _cleg_, 
   {{0x442680b0,0xa91c80e9,0xa248003d,0xdb0f016f}},	//   _rio_, teľk, _ریال_, _tocá, 
   {{0x2fc68284,0x44268010,0x3f8b0183,0xe5a3868f}},	//   skog_, _sio_, zecu_, кичи, 
   {{0xd49781bc,0xe12304bc,0x9f4201b2,0x6da38690}},	//   дры_, _амри, rikê_, тија, 
   {{0x27e000ed,0xcfaa8691,0xf2c68692,0xc17880ce}},	//   _nmin_, _باسم_, дсон, ynės_, 
   {{0x8cb50693,0x44268694,0x29078695,0xb5fb016f}},	//   _उपभो, _vio_, _ayna_, rtáz, 
   {{0x27e00696,0x290781b0,0xe29f807f,0xb5fb0697}},	//   _amin_, _byna_, æða_, stáz, 
   {{0x44268698,0xf1bf001c,0x3f8b0269,0xd36f8699}},	//   _tio_, _quái_, tecu_, _ич_, 
   {{0x443e8068,0x72c6869a,0x2907811a,0x6286069b}},	//   _itt_, _обез, _dyna_, _opko, 
   {{0x441b8273,0xa3ab810c,0xff04069c,0x3f8b0183}},	//   _וואס, खार_, вярн, recu_, 
   {{0x3495069d,0x443e80db,0x27e0069e,0x7dcf80c0}},	//   нагр, _ktt_, _emin_, _tøse, 
   {{0xe4e400f0,0xc1788162,0x628600f3,0xc04f804a}},	//   вітн, snės_, _apko, _ші_, 
   {{0x69ce069f,0xcbcd00b2,0xddc9801b,0x7dd006a0}},	//   _albe, রচ্ছ, _dveř, _räse, 
   {{0x6feb0066,0x521506a1,0xbbbf0379,0x6b8286a2}},	// [290] jęci, едат, _एकीक, _mbog, 
   {{0x443e86a3,0x2fcd86a4,0x645886a5,0x26000076}},	//   _ott_, _sleg_, ksvi, ळवणी_, 
   {{0x3cde8365,0x443e86a6,0x6d4706a7,0x2b05801b}},	//   _केले_, _ntt_, mbja, _हुनु_, 
   {{0x6d5506a8,0x764d06a9,0x69ce06aa,0x645886ab}},	//   laza, _kway, _elbe, dsvi, 
   {{0x443e809a,0xb90605b1,0x6fc600fe,0x733a00c6}},	//   _att_, _बे_, _dóch, _מערס, 
   {{0x6b8286ac,0x6d5506ad,0x9f4200f8,0x764d06ae}},	//   _abog, naza, tikë_, _mway, 
   {{0x26c9803b,0x645886af,0x63bd007f,0x443e86b0}},	//   šao_, gsvi, _kosn, _ctt_, 
   {{0x672d06b1,0xe3bf04e0,0x6d5506b2,0x6aa2811a}},	//   _ngaj, _miño_, haza, _brof, 
   {{0x443e86b3,0xba2586b4,0xb5fb0019,0x601605e1}},	//   _ett_, ндик, trál, náme, 
   {{0xf1b180fe,0x672d06b5,0x320101cb,0x6aa286b6}},	//   اءة_, _agaj, nohy_, _drof, 
   {{0x764d06b7,0xe3bf06b8,0x6d5506b9,0x9f4206ba}},	//   _away, _niño_, daza, liké_, 
   {{0x649a8052,0x63bd06bb,0x64438523,0xb21b06bc}},	//   _מסעד, _nosn, mpni, _spæl, 
   {{0x0aeb807b,0xe1ee809f,0x34c805c9,0x6d5506bd}},	//   _براي_, _бг_, रन्द, faza, 
   {{0x7bcf0574,0x7bc986be,0x200b0215,0x764d034e}},	//   _alcu, lkeu, alci_, _dway, 
   {{0xafe606bf,0xb042801c,0xdb8606c0,0x63bd06c1}},	//   _покл, _trưở, нгви, _bosn, 
   {{0x6b9b86c2,0x7bc9822c,0x7ae486c3,0x63bd0096}},	//   ndug, nkeu, _žiti, _cosn, 
   {{0x6d5506c4,0xada606c5,0x61e504e2,0x7bc9819b}},	// [2a0] baza, _запл, fihl, ikeu, 
   {{0x7bc9822c,0xdb0d012b,0x200206c6,0x7bcf0149}},	//   hkeu, rkað, loki_, _elcu, 
   {{0x7bc986c7,0x7dcb06c8,0xb5fb0170,0x717300fe}},	//   kkeu, _müsl, kráj, اهما, 
   {{0x2d9a03ec,0x48c300b2,0x601606c9,0x2ca5006d}},	//   _hape_, ্পূর, lámb, ælde_, 
   {{0x2d9a06ca,0x7bc986cb,0x4906802a,0xfeb7803d}},	//   _kape_, dkeu, _सुनो_, فاوت_, 
   {{0x63ab86cc,0x645886cd,0xab5b01ed,0x200206ce}},	//   _angn, tsvi, _flüs, hoki_, 
   {{0x65738093,0x20020122,0x2d9a06cf,0xa3ab8587}},	//   _şehî, koki_, _mape_, खां_, 
   {{0x645883b7,0x6b9b84c0,0x7bc98385,0x8cb182f4}},	//   rsvi, gdug, gkeu, _अपरो, 
   {{0x6d5506d0,0x60e00116,0x645886d1,0x200206d2}},	//   yaza, žymė, ssvi, doki_, 
   {{0x27e686d3,0x7d0886a4,0x2d9a06d4,0x6b8d0122}},	//   lion_, _tyds, _nape_, zeag, 
   {{0xc05786d5,0x764d06d6,0x5fc486d7,0xdddb85c3}},	//   нія_, _sway, _वकाल, _upuš, 
   {{0x6b8286d8,0x2d8e86d9,0x27e686da,0x6d5506db}},	//   _ubog, lefe_, nion_, waza, 
   {{0xcf938273,0xf8b78188,0x6d5506dc,0x63bd06dd}},	//   נטש_, дөө_, taza, _rosn, 
   {{0x7d0306de,0xbbc902f1,0x2bc906df,0x764d06e0}},	//   _ønsk, रस्क, रस्थ, _vway, 
   {{0x6d5506e1,0x26ec8689,0x63bd06e2,0x5ff5009f}},	//   raza, जपुर_, _posn, _изку, 
   {{0xe3bf04e0,0x9f420093,0x6d5a06e3,0x27e686e4}},	//   _viño_, likî_, ótar, jion_, 
   {{0x27e686e5,0x6b8d06e6,0x6d5506e7,0x320106e8}},	// [2b0] dion_, reag, paza, tohy_, 
   {{0x601606e9,0x8cb180a1,0x63bd00db,0x6b8d06ea}},	//   ráme, _अपलो, _wosn, seag, 
   {{0x320100de,0xc95380c6,0x6f0986eb,0x6fc602fd}},	//   rohy_, רמע_, _syec, _sóci, 
   {{0x61e500e5,0x27e686ec,0x60c50008,0x75fb01b2}},	//   sihl, gion_, ryhm, vîzy, 
   {{0xee3886ed,0xa3b486ee,0x7e7d06ef,0xd35604fc}},	//   ені_, ञान_, ntsp, _שישי_, 
   {{0x442b06f0,0xd5bb86f1,0x7bc981f0,0x1d0986f2}},	//   _hic_, ясе_, wkeu, мели_, 
   {{0x7bc9822c,0x645a06f3,0x27e6811a,0x02c986f4}},	//   tkeu, štiv, bion_, िन्न, 
   {{0x27e686f5,0x25ac8065,0x443306f6,0x644386f7}},	//   cion_, _endl_, _mux_, rpni, 
   {{0x7bc986f8,0x7dd000f9,0x443306f9,0x2a6901df}},	//   rkeu, _läsa, _lux_, nrab_, 
   {{0x7bc9822c,0x644386fa,0x3f8f807f,0xddc28116}},	//   skeu, ppni, legu_, puoš, 
   {{0x66038204,0xa3c306fb,0x442b06fc,0x7bc9822c}},	//   monk, ्सा_, _oic_, pkeu, 
   {{0x442b06fd,0xb4bf807a,0xf77206fe,0x2d9a06ff}},	//   _nic_, ुनी_, جاد_, _sape_, 
   {{0x44330700,0x20020701,0x3e7b8702,0x3f9b008b}},	//   _aux_, roki_, nêt_, _daqu_, 
   {{0x00858703,0xc5f5005a,0x6603852a,0x442b0704}},	//   _алко, лғы_, nonk, _aic_, 
   {{0xa5070705,0xdce18214,0xd6270706,0x60188707}},	//   вера_, _kalı, торе_, líme, 
   {{0x27e682c0,0x3f8f8708,0x442b0709,0x6603870a}},	//   xion_, jegu_, _cic_, honk, 
   {{0x442b070b,0x443302c0,0x3ae8007b,0x2ebd870c}},	// [2c0] _dic_, _eux_, ربری_, ्नोत, 
   {{0xb143070d,0x261683f0,0xdcfc00f3,0x7c2b870e}},	//   инул, _पीढी_, ndrī, _ligr, 
   {{0x27e6870f,0xe0d200fe,0xd6a90267,0x27f7015e}},	//   tion_, جزء_, _قدیم_, _سفید_, 
   {{0x7c2b8710,0x46ea81e5,0x2d858039,0xa3a90353}},	//   _nigr, мден_, _able_, _गोप_, 
   {{0x27e68711,0xa3ab823b,0x64418712,0xc32000b2}},	//   rion_, खाई_, _atli, _ফ্রি_, 
   {{0x27e68713,0x61430714,0xd9430715,0x442b0123}},	//   sion_, _вера, _вери, _zic_, 
   {{0xdce183d2,0x09e30716,0x2d8e8717,0x27e68718}},	//   _balı, _торн, refe_, pion_, 
   {{0x44200719,0x7bd6071a,0xb5fb071b,0xd9ca871c}},	//   nmi_, nhyu, nuár, िस्ट, 
   {{0x7c2b871d,0x6441871e,0x6603871f,0x877b80c6}},	//   _digr, _etli, bonk, _קאמי, 
   {{0x79a68720,0xf1a68721,0x2fc00064,0xdb1d068e}},	//   трие, трин, _aoig_, _dosè, 
   {{0x7bd60722,0x799c0723,0x44200724,0x4ce080b2}},	//   khyu, _marw, kmi_, _পুরু, 
   {{0x6d588725,0x7e7d0726,0x44200727,0x9f4b0728}},	//   lava, ttsp, jmi_, vocó_, 
   {{0xb5fb0068,0x290280a1,0x44200729,0xf40800b2}},	//   nság, łka_, dmi_, লগার_, 
   {{0x6d58872a,0x442b00f8,0xdd11026b,0x4420072b}},	//   nava, _sic_, _výži, emi_, 
   {{0x61e8872c,0x2fd2072d,0xf41480c6,0x645c010d}},	//   midl, _flyg_, ָפּ_, gsri, 
   {{0x6d58872e,0xdce1872f,0xa7750223,0xef67009f}},	//   hava, _xalı, _слич, _ръко, 
   {{0x799c0730,0x2009068e,0x6d588731,0x2b490105}},	// [2d0] _barw, _ikai_, kava, rbac_, 
   {{0x6d58829f,0x44200732,0x3e7b8733,0x799c0734}},	//   java, ami_, vêt_, _carw, 
   {{0x2d9100bb,0x48c300b2,0x3c388019,0xd2468139}},	//   meze_, ্প্র, _név_, _گن_, 
   {{0x2d910735,0x66038736,0x44200737,0x926b0123}},	//   leze_, wonk, cmi_, _орга_, 
   {{0x645a003b,0x35a8023b,0xd2468068,0x799c043a}},	//   štit, _छोड़, _دن_, _farw, 
   {{0xa3c30365,0x6d588738,0x65750739,0x3e7b873a}},	//   ्सव_, gava, ngzh, rêt_, 
   {{0x6603873b,0xdb0b80ef,0x6b9d0128,0x7c2b873c}},	//   ronk, _ingé, _kasg, _pigr, 
   {{0x7c3e803e,0x7bcd073d,0x6603873e,0x1fa4873f}},	//   ípra, nkau, sonk, _круг, 
   {{0x56948537,0x6603807e,0x2d910740,0x2fc00741}},	//   _катт, ponk, keze_, _roig_, 
   {{0x44200742,0x3c3880ef,0x3cde85c9,0xe5738743}},	//   zmi_, _fév_, _केके_, _خطر_, 
   {{0x44200744,0x7bcd036d,0x80ad8562,0x6f0d0745}},	//   ymi_, kkau, टमें, _ayac, 
   {{0x52758746,0x366a0747,0xeb9f006d,0x7bcd01df}},	//   _буку, намо_, _skøn_, jkau, 
   {{0x760a024a,0xeaae8748,0x6f0d00bb,0x44200749}},	//   _nêzî, _уй_, _cyac, vmi_, 
   {{0x63bb874a,0x2d91029a,0x645c074b,0xfce6074c}},	//   ljun, geze_, tsri, гого, 
   {{0x07a604bc,0x4420074d,0x6b9d074e,0x8fa6074f}},	//   _байн, tmi_, _basg, _байе, 
   {{0x63bb8750,0x6d588751,0xeb970752,0x7bcd0753}},	//   njun, zava, лис_, gkau, 
   {{0xc3328377,0xdcfa80f3,0x6d588754,0x799c0497}},	// [2e0] מון_, _patī, yava, _parw, 
   {{0xd05a005a,0x64410207,0xddd481ac,0x7bd6029a}},	//   ерді_, ílic, _ťažk, shyu, 
   {{0x6d588755,0x63bb81c2,0x2a7f82f4,0x8fa68756}},	//   vava, kjun, htub_, лаже, 
   {{0x44440757,0x61e8826b,0xb4c20758,0x799c0759}},	//   _it_, zidl, ्नी_, _warw, 
   {{0x6d58875a,0x4444075b,0x320580de,0xa3c3075c}},	//   tava, _ht_, koly_, ्सर_, 
   {{0xd49a875d,0x27030106,0xb5fb075e,0x7dd00033}},	//   ери_, ổng_, trái, _mäso, 
   {{0x6d58875f,0x44440760,0x61e8827b,0x395a039d}},	//   rava, _jt_, vidl, maps_, 
   {{0x7dc6812b,0x2d910761,0x6f090034,0xb5fb00d8}},	//   _aðst, zeze_, żeci, rrái, 
   {{0x44440762,0xb4c2000d,0x6d5e84e0,0x9fb8826b}},	//   _lt_, ्नु_, ópas, nčí_, 
   {{0x44440763,0xafe48103,0xc27b03f3,0x765d0764}},	//   _ot_, _соғл, עריי, vssy, 
   {{0x2d910524,0x28f88765,0x20090766,0x63bb8767}},	//   veze_, тень_, _pkai_, bjun, 
   {{0x09c1009b,0x2d910768,0x61e88769,0x2006876a}},	//   _शक्य, weze_, sidl, nooi_, 
   {{0x4444004d,0x61e8876b,0xa91c81ac,0x3205852a}},	//   _at_, pidl, teľs, boly_, 
   {{0x7dcb0073,0x2327876c,0x0cb680cf,0xb5fb003e}},	//   _küsi, _сочи_, জনীত, hráv, 
   {{0x2d91076d,0x6b84076e,0x6b9d076f,0xd13f80a1}},	//   reze_, ffig, _pasg, łącz_, 
   {{0x672d8770,0x44440771,0x2d910772,0x261a002a}},	//   žaji, _dt_, seze_, _मीठी_, 
   {{0x44440773,0xf96b0774,0x99550775,0x7bcd0776}},	// [2f0] _et_, ерей_, икац, rkau, 
   {{0x7bcd0777,0x2d9e8778,0x44440309,0x6b9d0779}},	//   skau, _nate_, _ft_, _wasg, 
   {{0x6b9d0015,0x4735877a,0x3e7f0610,0x3ea90507}},	//   _tasg, анес, lît_, _hrat_, 
   {{0xb4d100ab,0x3ea9077b,0x6607008d,0x200686a4}},	//   वनी_, _krat_, lojk, gooi_, 
   {{0x2d9e877c,0x40840325,0x2918077d,0x248c80f6}},	//   _bate_, _қурб, _ezra_, _apdm_, 
   {{0xd6580052,0x2249077e,0xada5877f,0x2d9e802d}},	//   ניות_, mpak_, ракл, _cate_, 
   {{0xeb998780,0x2d9e8781,0x23d58782,0xabd5839b}},	//   вий_, _date_, ицир, ициј, 
   {{0xea01010b,0xb5fb01e0,0x3ff980c6,0x3ea903df}},	//   _đẹp_, nsáb, _ספּע, _orat_, 
   {{0x59a6802a,0x22490783,0xd7f88784,0xe3b68785}},	//   _कोहर, npak_, _сур_, рбы_, 
   {{0x09e58741,0x3a2e83b9,0x644502b9,0x49c9804c}},	//   роон, _cifp_, _othi, тлон_, 
   {{0x7dd000f9,0x6ce480f0,0x7c9586fe,0xf9920039}},	//   _säso, _ліце, _خلاص, חרי_, 
   {{0x22490786,0xf1d98673,0x7c2f0064,0x2d218076}},	//   kpak_, योजन, _nicr, मधील_, 
   {{0xa3b90787,0x2d9e8788,0x6ff200f3,0x64450789}},	//   चान_, _yate_, nāci, _athi, 
   {{0x3ea900db,0x7bc281df,0x98a5878a,0x9fb881d2}},	//   _drat_, _zoou, _вике, včí_, 
   {{0xb4c2078b,0x3ea90111,0xa50a078c,0x69c3878d}},	//   ्ने_, _erat_, тева_, _ione, 
   {{0xa3a9010c,0x6ff200f3,0x2d9e027b,0x442f878e}},	//   _गोद_, kāci, žte_, _jig_, 
   {{0x442f878f,0x44440790,0x60188791,0xe61a0792}},	// [300] _mig_, _wt_, jíma, _иди_, 
   {{0x44440793,0x442f8794,0xbbd28795,0xe9d70796}},	//   _tt_, _lig_, _तत्क, аку_, 
   {{0x44440797,0x673b0798,0x69c38799,0xd91000dd}},	//   _ut_, žuje, _mone, سیر_, 
   {{0x42ea05c2,0xc60e83ca,0xddc28029,0x6d41879a}},	//   _аммо_, ित्य_, droš, _afla, 
   {{0x7c24079b,0x7ae9068c,0xeb970086,0x2d85075d}},	//   mmir, _žetv, _тия_, òleg_, 
   {{0x6d5c079c,0x0466879d,0x2b4d8702,0x69c380bb}},	//   nara, атим, ebec_, _none, 
   {{0x442f879e,0x601d02c0,0xb5fb026b,0x2bdd009b}},	//   _big_, léme, práv, नोका, 
   {{0xa3b905d9,0x0b8a813f,0x442f879f,0x2d9e839d}},	//   चाय_, тски_, _cig_, _wate_, 
   {{0x442f87a0,0x2a6d87a1,0x3c3c07a2,0x601d07a3}},	//   _dig_, greb_, _lív_, néme, 
   {{0x6d5c03d4,0x4e7b8052,0x64430035,0x31c687a4}},	//   jara, _באמצ, _énig, рсив, 
   {{0x6607003a,0x69c387a5,0xb4c203ce,0x313707a6}},	//   vojk, _done, ्नो_, ינים_, 
   {{0x6d5707a7,0x41a6807a,0x0aea87a8,0x3ea907a9}},	//   _sexa, _कोरस, _идей_, _prat_, 
   {{0xdefb03a7,0x6d5c07aa,0x644500bc,0x7c24068c}},	//   тын_, fara, _sthi, dmir, 
   {{0x6d5c07ab,0x442f87ac,0x7c2f0324,0x3ea907ad}},	//   gara, _zig_, _sicr, _vrat_, 
   {{0xe4a407ae,0x6d5707af,0x6ff20029,0xb4d107b0}},	//   орто, _vexa, zāci, वने_, 
   {{0x5334004a,0x7c2407b1,0x83350086,0x3ea907b2}},	//   жетт, gmir, снах, _trat_, 
   {{0x6d5c07b3,0x8d8707b4,0x69d5001b,0xba5500d8}},	// [310] bara, _кунд, _plze, صناع, 
   {{0xe29f812b,0xc1788116,0xa8a707b5,0x6ff201a8}},	//   æði_, ngė_, ирек, vāci, 
   {{0xd1380574,0x224902fa,0x439507b6,0x395807b7}},	//   рху_, spak_, _ланс, _ders_, 
   {{0x395807b8,0x224687b9,0x6ff200f3,0x6018807f}},	//   _eers_, _otok_, tāci, tíma, 
   {{0xbea587ba,0x6d4181ed,0x9f420170,0x60160019}},	//   салк, _pfla, niká_, zámo, 
   {{0x442f87bb,0xb5fb07bc,0x6ff20029,0x629d07bd}},	//   _sig_, crát, rāci, _isso, 
   {{0x27e907be,0xe3b180fe,0x69c387bf,0x224687c0}},	//   _oman_, كرة_, _rone, _atok_, 
   {{0x6d5c07c1,0x69c387c2,0x27e907c3,0x442f822a}},	//   zara, _sone, _nman_, _qig_, 
   {{0x69c387c4,0x36d487c5,0xdcfe01a8,0x2b4d87c6}},	//   _pone, _дотр, _papī, rbec_, 
   {{0xdef887c7,0x27e907c8,0x25a107c9,0x6d5c07ca}},	//   _тыс_, _aman_, _nahl_, xara, 
   {{0x2ed0007a,0x442f87cb,0x1bf90611,0xc7a607cc}},	//   हन्त, _tig_, ्काल_, бинк, 
   {{0x6d5c07cd,0xcdc90052,0x601607ce,0x69c387cf}},	//   wara, _אך_, rámo, _wone, 
   {{0x6d5c07d0,0x7bdb87d1,0x69c387d2,0x539a8039}},	//   tara, mhuu, _tone, _תינו, 
   {{0x69da87d3,0x27e90124,0x32b880d8,0x601603b9}},	//   chte, _eman_, _خدمة_, pámo, 
   {{0x629d07d4,0x04460223,0xb5fb0170,0x25a104fb}},	//   _asso, себн, vrát, _dahl_, 
   {{0xe29a07d5,0x9f82007f,0x2b5907d6,0x7dd007d7}},	//   лаб_, _góð_, _cesc_, _käsk, 
   {{0x2b40039f,0xaaa78587,0xe1fa03ad,0x0936075e}},	// [320] rcic_, कटिक, гга_, مراج, 
   {{0x2a6007d8,0x6d5c07d9,0x2d878269,0x601d07da}},	//   rsib_, qara, jfne_, réme, 
   {{0xfbd207db,0x395807dc,0x629d07dd,0x6f1b860e}},	//   _فتح_, _vers_, _esso, _azuc, 
   {{0xc88507de,0x442407df,0x25a107e0,0x201f87e1}},	//   daşı_, _òm_, _zahl_, _chui_, 
   {{0xe5c687e2,0x7bdb868e,0x6da68103,0x248c01bb}},	//   йско, dhuu, йида, ħdmu_, 
   {{0x443a07e3,0x6284010d,0xd17502c3,0xe19607e4}},	//   _kup_, mtio, _мысы, _урмэ, 
   {{0x224687e5,0x62840008,0x7bc607e6,0x29c98065}},	//   _stok_, ltio, _koku, _lúas_, 
   {{0xd00a87e7,0x443a006a,0x6b9607e8,0xb33b031b}},	//   _себе_, _mup_, neyg, _kaça, 
   {{0x7ae907e9,0x63a407ea,0x628407eb,0x7bc607ec}},	//   _þett, idin, ntio, _moku, 
   {{0x7bc607ed,0x27e907ee,0x984a809f,0xb33b07ef}},	//   _loku, _sman_, ляма_, _maça, 
   {{0x7dcb07f0,0xe45287f1,0x8b66803d,0xb5fb07f2}},	//   _xüsu, _رضا_, _هاشم, krár, 
   {{0x628407f3,0x69da8210,0x7bc607f4,0x6d5a87f5}},	//   ktio, shte, _noku, _heta, 
   {{0x6d5a87f6,0x63a407f7,0x7f5d0065,0xb4d107f8}},	//   _keta, ddin, rasq, वन्_, 
   {{0x2707810b,0x29c98659,0xd6d800f0,0x7c3a87f9}},	//   ống_, _dúas_, стю_, _kutr, 
   {{0xdce887fa,0x6d5a87fb,0x395e87fc,0x7bc607fd}},	//   _kadı, _meta, mats_, _boku, 
   {{0x395e87fe,0x6d5a87ff,0x27e90800,0x63a280de}},	//   lats_, _leta, _uman_, _jaon, 
   {{0x63a28801,0x200b0802,0xb33b0803,0x39410035}},	// [330] _maon, moci_, _caça, tchs_, 
   {{0x7c3a8804,0x2ba905d9,0x6d5a8805,0x395e8188}},	//   _outr, _चोरा, _neta, nats_, 
   {{0xceeb807b,0x443a0806,0x62840807,0xb5fb0065}},	//   گران_, _gup_, atio, brár, 
   {{0x61c58808,0xb33b0809,0xdea1803d,0x395e880a}},	//   _लक्ष, _faça, ویزی, hats_, 
   {{0x7c3a8700,0x6284080b,0x6d5a880c,0x25ed8365}},	//   _autr, ctio, _beta, _अगदी_, 
   {{0x6d5a880d,0x7bc602d7,0xdcf88116,0x395e875d}},	//   _ceta, _zoku, nevė, jats_, 
   {{0x7bc6080e,0x395e880f,0x63a28810,0x7c3a8123}},	//   _yoku, dats_, _baon, _cutr, 
   {{0x69d88811,0x69c70812,0x7c3a8813,0x6d5a855a}},	//   _alve, _hoje, _dutr, _eeta, 
   {{0x69c7003b,0x6d5a8814,0xe9d98815,0x64488816}},	//   _koje, _feta, ики_, _etdi, 
   {{0x7dcb035b,0x29c984e0,0x395e8817,0x7dd00172}},	//   _müss, _rúas_, gats_, _väsk, 
   {{0x29c98818,0x69c70819,0x63a4081a,0x62840122}},	//   _súas_, _moje, ydin, ztio, 
   {{0x6d4502b5,0x69d8881b,0x6d5a881c,0x443a081d}},	//   _afha, _elve, _zeta, _rup_, 
   {{0xa2948118,0x395e881e,0xd9fb009b,0x6d5a881f}},	//   _наці, bats_, ्वात_, _yeta, 
   {{0x7dd00413,0x395e8820,0x6d5a8821,0x224d8822}},	//   _käsi, cats_, _xeta, mpek_, 
   {{0x7bc60823,0x63a28824,0x7dcb0825,0x8c430826}},	//   _poku, _yaon, _rüst, десе, 
   {{0xb06880dd,0x63a40827,0x29c984e0,0x7dcb0079}},	//   _اصول_, udin, _túas_, _süst, 
   {{0x63a40828,0x98a583d2,0xb33b0829,0x7dcb02f4}},	// [340] rdin, malı_, _qaça, _püst, 
   {{0x7bc602d7,0x69c7082a,0x3ea006e0,0xe69302e5}},	//   _woku, _coje, _isit_, _کلید, 
   {{0x69c7082b,0x6284082c,0xdbd18214,0x5faf009b}},	//   _doje, stio, _güçl, _जोडल, 
   {{0x2d98082d,0x6d5a882e,0x6284082f,0x510c8273}},	//   lere_, _seta, ptio, נהאַ, 
   {{0xd5ba8008,0x4e968830,0x63a28831,0x52750832}},	//   иск_, تشار, _raon, _нуру, 
   {{0x2d980833,0x7c3a83d4,0x3ead80a6,0x7e6280bf}},	//   nere_, _putr, _dret_, rsop, 
   {{0x395e8834,0xaff58068,0x98a58646,0xa0670835}},	//   vats_, _کہنا_, kalı_, _мара_, 
   {{0x2d980836,0xdce88816,0x32668837,0x6d5a8838}},	//   here_, _qadı, отов, _weta, 
   {{0x6d5a8839,0x395e81e5,0x2d98083a,0xdb1d0019}},	//   _teta, tats_, kere_, _kosá, 
   {{0x2d98083b,0xddc280a1,0x670e083c,0x63a2883d}},	//   jere_, społ, _सड़क_, _waon, 
   {{0x2d98083e,0x395e883f,0x63a28840,0xeb9a8841}},	//   dere_, rats_, _taon, _вие_, 
   {{0x395e8842,0xf8ad8843,0xb09b0309,0x7a2900ce}},	//   sats_, اکو_, ביטר, _užtv, 
   {{0x2d980844,0x200b0845,0x395e8846,0x37070847}},	//   fere_, roci_, pats_, ючов, 
   {{0x2d980848,0xddcf0166,0x61ea8166,0x69d88849}},	//   gere_, ducţ, _umfl, _ulve, 
   {{0xfbd30013,0xa1778052,0x69c7084a,0xc05a804a}},	//   وتر_, _ועוד_, _roje, _тіл_, 
   {{0x4422084b,0x69c7084c,0xb5fb084d,0x98a5884e}},	//   _chk_, _soje, rráq, calı_, 
   {{0x2d98084f,0x69c70850,0xe1f30851,0x3a750852}},	// [350] bere_, _poje, وسط_, ялар, 
   {{0x2d980853,0x44220073,0xdddb8854,0x3f990855}},	//   cere_, _ehk_, _spuž, lesu_, 
   {{0xe7f7807a,0x69c7026b,0x76498856,0x2d810097}},	//   ंचला_, _voje, _stey, _iche_, 
   {{0x3ead8857,0x320c8858,0x69c700a1,0x4c9a04fc}},	//   _pret_, hody_, _woje, _פברו, 
   {{0x44290859,0xb3ba0039,0x320c885a,0x00000000}},	//   mma_, _המרכ, kody_, --, 
   {{0x4429085b,0x7c22885c,0x270a010b,0x27ef885d}},	//   lma_, _ahor, ờng_, sign_, 
   {{0x98a58085,0xc5f40080,0x7c22885e,0x5064085f}},	//   yalı_, ודס_, _bhor, _отта, 
   {{0x3cfc0130,0x44290860,0x3f99068b,0x2d980861}},	//   ילונ, nma_, jesu_, zere_, 
   {{0x6aa48862,0x7c228863,0x27ed8864,0xe7af00a1}},	//   _šifr, _dhor, _imen_, _जोधप, 
   {{0xe9d9813f,0x4ea48004,0x395c82ef,0xba2280a6}},	//   ско_, _ўрта, _cevs_, ндык, 
   {{0x2d980865,0x44290866,0x7c228013,0x224d8867}},	//   vere_, kma_, _fhor, spek_, 
   {{0x7c228868,0x2d980869,0x4429086a,0x2fc90065}},	//   _ghor, were_, jma_, _coag_, 
   {{0x4429086b,0x98a583d2,0x25a5886c,0x98ab8214}},	//   dma_, ralı_, _kall_, ılık_, 
   {{0x4429086d,0x7c228170,0x7ddd868e,0x7dd00341}},	//   ema_, _zhor, _hèsb, _läsv, 
   {{0x2d98086e,0x7c29886f,0x27ed8870,0x98a586c8}},	//   rere_, omer, _omen_, palı_, 
   {{0x2d980871,0x44290872,0x4a460873,0x7c298874}},	//   sere_, gma_, знав, nmer, 
   {{0x2d980875,0x6d410876,0xe9da0877,0x236000e5}},	// [360] pere_, ılar, бка_, raij_, 
   {{0x44290878,0xb33b02c0,0x7c298879,0xdb04087a}},	//   ama_, _faço, hmer, ndié, 
   {{0x6d5e00f3,0x7c29887b,0x6376887c,0x6d3b0309}},	//   _iepa, kmer, nünü, _לתינ, 
   {{0xb4b800c9,0x7c29887d,0x7bdf087e,0xf1ba812f}},	//   चमी_, jmer, chqu, _nhơn_, 
   {{0x6d5e087f,0xa3b90880,0xb4e4802a,0xa7fd02d2}},	//   _kepa, चार_, _पेड़_, ksın, 
   {{0x6d5e0881,0x7c228039,0x25a58882,0x63a60883}},	//   _jepa, _shor, _call_, _hakn, 
   {{0x25a58574,0x7c228884,0x63a60885,0x320c8410}},	//   _dall_, _phor, _kakn, vody_, 
   {{0x6d5e0886,0x7bd60887,0x8fa38162,0x7c298888}},	//   _lepa, nkyu, _пасе, gmer, 
   {{0x7ae40889,0x63a6088a,0x320c888b,0xdb040035}},	//   nzit, _makn, tody_, udiè, 
   {{0x64a6888c,0x20030025,0xdca6888d,0x67208301}},	//   _наза, čkim_, _нази, _izmj, 
   {{0x4429088e,0x7c29888f,0xa319075c,0x660e0507}},	//   yma_, bmer, _दर्ज_, dobk, 
   {{0x44290890,0x7c228891,0x2d810892,0x443e8429}},	//   xma_, _uhor, _sche_, _iut_, 
   {{0x6d5e0622,0xe80d80c1,0xb80d86d7,0x7c3e00ef}},	//   _bepa, िकता_, िकतम_, _aupr, 
   {{0x6d5e025f,0x443e8893,0x44290894,0x1a9b80c6}},	//   _cepa, _kut_, wma_, _לידע, 
   {{0x44290260,0x7c3e002d,0xdcf881a8,0xa3b90895}},	//   tma_, _cupr, devī, चाल_, 
   {{0x44290896,0x443e8897,0x69ca8898,0x63a600bf}},	//   uma_, _mut_, _hofe, _cakn, 
   {{0x5a3500ba,0x601d0899,0x443e889a,0x6d5e089b}},	// [370] днат, lémo, _lut_, _fepa, 
   {{0x443e804d,0x6d5e089c,0x7c29889d,0x799a889e}},	//   _out_, _gepa, zmer, netw, 
   {{0x7c29843a,0x69ca8129,0xf8dc8587,0x442902d2}},	//   ymer, _mofe, मनिय, pma_, 
   {{0xc10400a7,0x6d48889f,0x6016011e,0xa7fd02d2}},	//   روني, _afda, támi, zsın, 
   {{0xf77088a0,0x6da58004,0x35a580a6,0x443e88a1}},	//   طان_, дила, далг, _aut_, 
   {{0x443e804d,0x601608a2,0x6b8288a3,0xf65088a4}},	//   _but_, rámi, _acog, ائن_, 
   {{0x63a602c7,0x25a58741,0xdca2809f,0x27ed82fa}},	//   _yakn, _vall_, ващи, _tmen_, 
   {{0x7dd008a5,0x443e8124,0x601d08a6,0x25a588a7}},	//   _häst, _dut_, démo, _wall_, 
   {{0x91e588a8,0x69ca82a6,0x200f88a9,0x644988aa}},	//   допе, _bofe, mogi_, _žlič, 
   {{0x7c2988ab,0x39e9836a,0x443e88ac,0x69ca88ad}},	//   smer, ідно_, _fut_, _cofe, 
   {{0x656388ae,0x7bdd02bc,0xdd1c826b,0x7dd00172}},	//   manh, _olsu, _záži, _mäst, 
   {{0x7dd008af,0x637683d2,0x5ec600b2,0x200f88b0}},	//   _läst, rünü, _লেগে, nogi_, 
   {{0x6d5e08b1,0x7bcb88b2,0x7c3e08b3,0x69ca84e2}},	//   _pepa, _iogu, _supr, _fofe, 
   {{0x518784bc,0x7dd008b4,0x63a988b5,0x63a608b6}},	//   _худа, _näst, lden, _sakn, 
   {{0xa3b9007a,0x660e0858,0x7bcb8073,0x601d03b9}},	//   चां_, robk, _kogu, cémo, 
   {{0x63a988b7,0x673b88b8,0x7ae40122,0x656388b9}},	//   nden, _nguj, tzit, hanh, 
   {{0x7bcb803b,0x7dd008b4,0x6d5e08ba,0x628988bb}},	// [380] _mogu, _bäst, _tepa, nteo, 
   {{0x673b81ce,0x7bcb88bc,0x6b9b80fa,0x63a9819b}},	//   _aguj, _logu, heug, hden, 
   {{0x0c2603ad,0xdb0f075d,0xd91000df,0x59c408bd}},	//   _омон, _encà, ایز_, लॉगर, 
   {{0xef1a88be,0x63a988bf,0x7bcb88c0,0x200f88c1}},	//   оме_, jden, _nogu, gogi_, 
   {{0x443e8324,0x7dd00172,0xd765803d,0x601888c2}},	//   _sut_, _fäst, رنوی, ními, 
   {{0x7dd008c3,0x63a988c4,0x443e86c1,0x6b8281e9}},	//   _gäst, eden, _put_, _scog, 
   {{0x7dd008c5,0x78450116,0x443e88c6,0xb4bc054d}},	//   _häss, _tėva, _qut_, _आपो_, 
   {{0x69ca88c7,0x7dcf88c8,0xd7648019,0x7bcb88c9}},	//   _sofe, _søst, _سنئی, _cogu, 
   {{0x291808ca,0xa80283d2,0x7bcb88cb,0x5a348086}},	//   _hyra_, ğıda, _dogu, ннит, 
   {{0x7abb0039,0x7dd008cc,0x601d08cd,0x63a988ce}},	//   קציו, _mäss, témo, aden, 
   {{0x2d9c8210,0x7dd002ae,0xc05788cf,0x443e8079}},	//   meve_, _läss, мія_, _uut_, 
   {{0x2d9c88d0,0x6aa288d1,0x601d08d2,0x29180578}},	//   leve_, _tsof, rémo, _myra_, 
   {{0x628988d3,0x442688d4,0x7dd008d5,0xa2fd085a}},	//   cteo, _iho_, _näss, _एशेज_, 
   {{0x2d9c88d6,0x7bcb88d7,0x7dd480a6,0x764088d8}},	//   neve_, _zogu, _bàsi, _mumy, 
   {{0x442688d9,0xe8ff81b2,0xa0a3804a,0x200f88da}},	//   _kho_, şûr_, _ашыл, yogi_, 
   {{0x7bcb81e0,0x439408db,0x6aad88dc,0x2ba908dd}},	//   _xogu, касс, _šafi, _चोखा, 
   {{0x2d9c88de,0xa3d68439,0x65638347,0x4e0e8034}},	// [390] keve_, _हवन_, yanh, ाकाई_, 
   {{0x2d9c88df,0x6b9b82ae,0x442688e0,0xdbd68079}},	//   jeve_, zeug, _lho_, _hääl, 
   {{0x7dd000f9,0x442688e1,0xdb0b80f9,0x2d9c88e2}},	//   _väst, _oho_, _ingå, deve_, 
   {{0x656380bf,0xdb0f03b9,0x442688e3,0xddcd0170}},	//   wanh, _encá, _nho_, _staň, 
   {{0x20030025,0x7c2d009a,0x7dd0036d,0x656388e4}},	//   čkih_, mmar, _täst, tanh, 
   {{0x442688e5,0x44390052,0x291800f9,0x0ea880f0}},	//   _aho_, _his_, _fyra_, ькій_, 
   {{0x443908e6,0x7bcb88e7,0x44268048,0x656388e8}},	//   _kis_, _pogu, _bho_, ranh, 
   {{0x442688e9,0x7c2d08ea,0x443908eb,0x7e7d08ec}},	//   _cho_, nmar, _jis_, kusp, 
   {{0x443908ed,0x66f388bd,0x656388ee,0x2a6908ef}},	//   _mis_, _अधिक_, panh, nsab_, 
   {{0x443908f0,0x600808f1,0x628988f2,0x60e988f3}},	//   _lis_, zımd, rteo, змом_, 
   {{0x628988f4,0x7c2d08f5,0x7bcb88f6,0xdb06016c}},	//   steo, kmar, _togu, _pakë, 
   {{0xf77208f7,0x44390048,0x64418012,0x7c2d02a5}},	//   داد_, _nis_, _iuli, jmar, 
   {{0x442d88f8,0x81d588f9,0x644188fa,0x213c80f6}},	//   mme_, _подх, _huli, _fgvh_, 
   {{0x7c2608fb,0x44390649,0x64a608fc,0x3f8401bb}},	//   _shkr, _ais_, нага, żmu_, 
   {{0x65618003,0x443908fd,0xb8f480cf,0xfce608fe}},	//   _melh, _bis_, _সে_, хово, 
   {{0x442d817e,0x644188ff,0x7c2d0900,0xf0628086}},	//   nme_, _muli, gmar, _скъп, 
   {{0x291e0025,0xe9da0901,0x44390902,0x42260903}},	// [3a0] _šta_, пка_, _dis_, едав, 
   {{0x442d8904,0x44390905,0x7c2d0906,0xdb06001b}},	//   hme_, _eis_, amar, _jaké, 
   {{0x44390907,0x64418908,0x442d8909,0x2fdf83df}},	//   _fis_, _nuli, kme_, _blug_, 
   {{0x442d890a,0x7dd0036d,0x3f82090b,0xe853003d}},	//   jme_, _täss, ngku_, انند, 
   {{0x2d9c8210,0x4426890c,0x442d890d,0x245e001b}},	//   teve_, _rho_, dme_, lům_, 
   {{0x4439090e,0x6441890f,0x442d8910,0x442683ad}},	//   _zis_, _buli, eme_, _sho_, 
   {{0x2d9c8911,0xd49784f6,0x27e00912,0xdcfc00f3}},	//   reve_, еры_, _olin_, derī, 
   {{0x4439006c,0x442681ea,0x69ce0124,0x2d9c8913}},	//   _xis_, _qho_, _hobe, seve_, 
   {{0x65618068,0x69ce0914,0x7c398324,0xc98682bb}},	//   _felh, _kobe, _diwr, нуни, 
   {{0x44268052,0x27e00915,0xef1f0916,0x442d8917}},	//   _who_, _alin_, ngüe_, ame_, 
   {{0x64418918,0xdbd6836d,0x33d6836a,0x442d8919}},	//   _guli, _pääl, _підт, bme_, 
   {{0x7e7d04bb,0xa2e6891a,0x442d891b,0x04db8039}},	//   tusp, _поед, cme_, _מקבל, 
   {{0x4439091c,0x0cc906ee,0x6441891d,0xa3d58073}},	//   _ris_, रह्म, _zuli, _सकत_, 
   {{0x443901ea,0x7afd891e,0x6441891f,0x27e00920}},	//   _sis_, úste, _yuli, _elin_, 
   {{0x44390921,0x7e7d0922,0x64418923,0xdbd68008}},	//   _pis_, susp, _xuli, _tääl, 
   {{0x4439006c,0x75d80083,0xa40105a2,0x69c8810d}},	//   _qis_, _ağzı, ্ষ্য_, ljde, 
   {{0x44390924,0x69ce0925,0x98ac83d2,0x2ec2004a}},	// [3b0] _vis_, _bobe, madı_, _көрм, 
   {{0x4439040c,0x69da8926,0x98ac8646,0x22420050}},	//   _wis_, nkte, ladı_, _dukk_, 
   {{0xd3668927,0x69ce0928,0xb5f2004a,0x2a690531}},	//   _په_, _dobe, _түрі, ssab_, 
   {{0x44390929,0x7e6d092a,0x442d892b,0x6e3a8097}},	//   _uis_, _kvap, xme_, _aitb, 
   {{0xe7e2892c,0x2fcd80d0,0x3ea587b4,0x6e3a892d}},	//   _खतरा_, _voeg_, тилг, _bitb, 
   {{0x69ce092e,0x2004808d,0x7d1a892f,0x442d8399}},	//   _gobe, _ejmi_, _byts, wme_, 
   {{0x442d8930,0x65618931,0x301b80fe,0xdb060932}},	//   tme_, _velh, _فترة_, _raké, 
   {{0x7bcf0012,0xeb998933,0x64418934,0x224200db}},	//   _jocu, фии_, _vuli, _yukk_, 
   {{0x1309836a,0x628d0935,0x9f4200f8,0x12298103}},	//   ьний_, ntao, shkë_, моий_, 
   {{0x7bcf0012,0xb6358936,0x63ad0937,0xb14583ad}},	//   _locu, _شفاع, hdan, ънол, 
   {{0xf8e10938,0x63ad0939,0x442d893a,0x6441893b}},	//   पनिय, kdan, pme_, _uuli, 
   {{0x13a7803d,0x7981811a,0x6e3a893c,0x39408166}},	//   _سنتی_, sglw, _zitb, _şist_, 
   {{0x63ad093d,0x69c4093e,0x21e401ed,0x3f8c00a1}},	//   ddan, रामी, _höhe_, ędu_, 
   {{0x7ae98068,0x7e6d0131,0x69da893f,0x827680c6}},	//   mzet, _dvap, ckte, _יענע_, 
   {{0xa806009f,0xc5630940,0x0d220188,0x8c460741}},	//   _изкл, ркск, рүнү, тебе, 
   {{0x63ad0941,0x63ab8942,0x27e00943,0xeb970944}},	//   gdan, _jagn, _ulin_, кис_, 
   {{0x69ce0945,0x7bcf0946,0xf6260947,0x7ae98948}},	// [3c0] _pobe, _docu, _идио, nzet, 
   {{0xdb0d01c2,0x63ab8949,0x69ce02a6,0x867b0309}},	//   rjað, _lagn, _qobe, _קריו, 
   {{0xa50a094a,0x3d168365,0x8fa6894b,0x1d0a094c}},	//   _цена_, _पुढे_, каже, _цени_, 
   {{0x4444094d,0x69ce094e,0x63ab894f,0x78b50269}},	//   _iu_, _wobe, _nagn, _drzv, 
   {{0x44440950,0x69ce02a6,0xe7f380a1,0xe7378951}},	//   _hu_, _tobe, _आगरा_, вец_, 
   {{0x44440952,0x7ae98953,0x7764011e,0x249a00bf}},	//   _ku_, dzet, _leix, _kppm_, 
   {{0x44440954,0x63ab809f,0x6f098955,0x629986e0}},	//   _ju_, _bagn, _exec, _apwo, 
   {{0x44440956,0x3d168365,0xb5fb00fe,0x63ab8957}},	//   _mu_, _पुणे_, rsái, _cagn, 
   {{0x44440958,0x249a00db,0xdb02811e,0x7ae98063}},	//   _lu_, _lppm_, _taoí, gzet, 
   {{0x44440959,0xbda587db,0xdb1d0339,0x6e3a8387}},	//   _ou_, _محمو, _posú, _uitb, 
   {{0x4444095a,0x601d095b,0x63ad095c,0x717b0115}},	//   _nu_, lémi, ydan, וניס, 
   {{0x63ab895d,0xb4c0807a,0x7ec900f8,0xb5fb0077}},	//   _gagn, ुही_, _nëpë, nsáv, 
   {{0x4444095e,0x7764095f,0xd25080fe,0x051f00b2}},	//   _au_, _deix, _انت_, _দলের_, 
   {{0x44440960,0x6aa40961,0x63ab8962,0xceb38309}},	//   _bu_, dwif, _zagn, ביש_, 
   {{0x44440963,0xa3d68964,0x77640965,0x657a00fe}},	//   _cu_, _हवा_, _feix, ótha, 
   {{0x249a00bf,0x600802d2,0x6aa402d9,0x6b840966}},	//   _dppm_, rımc, fwif, ggig, 
   {{0x44440967,0x27e68968,0x6280839d,0x24180193}},	// [3d0] _eu_, dhon_, numo, тоты_, 
   {{0x44440969,0xa2940163,0x601d096a,0x628d02fb}},	//   _fu_, рафі, démi, rtao, 
   {{0x4444096b,0xf1ba810b,0x94d5096c,0x6280896d}},	//   _gu_, _chơi_, _сонц, humo, 
   {{0xf093896e,0x6565096f,0x63a08970,0x62808971}},	//   ינע_, _hehh, jemn, kumo, 
   {{0x44440972,0x63ab8973,0xe9470974,0x628080f3}},	//   _zu_, _ragn, _ахбо, jumo, 
   {{0xee38836a,0x7ae98975,0x8d54809f,0x63ab8976}},	//   вні_, vzet, атъч, _sagn, 
   {{0x44440977,0x63ab8978,0xef678325,0x64450079}},	//   _xu_, _pagn, _аъзо, _juhi, 
   {{0x64450979,0x27e6897a,0x7ae9897b,0x3f89022a}},	//   _muhi, chon_, tzet, _ncau_, 
   {{0x7ae9803a,0x63ab897c,0x23c580da,0x7764097d}},	//   uzet, _vagn, वाबद, _reix, 
   {{0x7985097e,0x7764097f,0x7ae98980,0x7bdb8981}},	//   nghw, _seix, rzet, skuu, 
   {{0x54558982,0x63ab8983,0x6d418984,0x7ae98019}},	//   _свет, _tagn, _igla, szet, 
   {{0x44440985,0xdce38986,0x7c3d0519,0x656502ef}},	//   _ru_, nanč, _nisr, _aehh, 
   {{0xddc9824a,0x644502f4,0xe2998987,0xe7370988}},	//   _xweş, _auhi, _чал_, лею_, 
   {{0x44440989,0x6445098a,0x20020269,0x66150122}},	//   _pu_, _buhi, snki_, gozk, 
   {{0x44440700,0xfce3098b,0x7764098c,0x656500db}},	//   _qu_, боро, _teix, _dehh, 
   {{0x4444098d,0xdce38116,0xfaa6098e,0xdb0081b2}},	//   _vu_, janč, лабо, demê, 
   {{0x6d41898f,0xfe7200dd,0x03260990,0xdb06044e}},	// [3e0] _ogla, _ادب_, удан, _ankò, 
   {{0x44440991,0x6d41846c,0x63a08992,0xf1ba812f}},	//   _tu_, _ngla, zemn, _phơi_, 
   {{0x81bc8029,0x27e68993,0x6445029a,0xcb6a0994}},	//   slēg, thon_, _guhi, _пане_, 
   {{0x21a30325,0x2a6d8995,0x4f0a804a,0x6d418996}},	//   _қисм, kseb_, ннен_, _agla, 
   {{0x44200997,0x6d5c0998,0xcc3b00c6,0x44320999}},	//   mli_, obra, _רעכט, mmy_, 
   {{0x4432099a,0x6143099b,0x601d099c,0xe9df00fe}},	//   lmy_, _гера, rémi, _dtús_, 
   {{0xe0c7899d,0x4420099e,0x7189099f,0x4432040a}},	//   _از_, oli_, _шарҳ_, omy_, 
   {{0x442009a0,0x02a689a1,0xb27489a2,0xc2748223}},	//   nli_, гром, алиш, алиј, 
   {{0x060a89a3,0xaf0689a4,0xe20b00a1,0x248e839d}},	//   _знак_, _спал, łóż_, stfm_, 
   {{0x442009a5,0x2a978013,0x63a089a6,0x628089a7}},	//   hli_, ائية_, semn, rumo, 
   {{0x438680dd,0x683e8116,0x628089a8,0x02170039}},	//   _ملاق, _būda, sumo, רחים_, 
   {{0x273a8186,0x644509a9,0x3f8686e0,0x9f59016c}},	//   _günü_, _ruhi, ngou_, misë_, 
   {{0xeab28501,0x644509aa,0x9f59016c,0x98b80519}},	//   _دعا_, _suhi, lisë_, _ferħ_, 
   {{0x2fc009ab,0x442009ac,0x44320034,0xa8a689ad}},	//   _enig_, eli_, emy_, _брик, 
   {{0x442009ae,0x9f5900f8,0xfaff00f8,0xa2ac89af}},	//   fli_, nisë_, _ndër_, जिक्, 
   {{0x442009b0,0x61fa89b1,0x81bc80f3,0xdb0f011e}},	//   gli_, litl, slēd, _incú, 
   {{0x6d5c009f,0xdce381f7,0x3ea909b2,0xe51b83ca}},	// [3f0] bbra, vanč, _usat_, _पुनि_, 
   {{0x442009b3,0x6d5c0097,0x61fa89b4,0x9f59016c}},	//   ali_, cbra, nitl, kisë_, 
   {{0xa3d58073,0x442009b5,0xdce389b6,0xdb04016f}},	//   _सकल_, bli_, tanč, rdiá, 
   {{0xb4c30365,0x442009b7,0x673b0533,0x9f5909b8}},	//   ्ही_, cli_, žuju, disë_, 
   {{0xd90f09b9,0x8d6589ba,0xdce389bb,0x61fa89bc}},	//   _کیا_, авле, ranč, kitl, 
   {{0x3f75810b,0x7dd48741,0x443d89bd,0xaaa80086}},	//   ều_, _bàsq, _siw_, _съюз_, 
   {{0x5ed380cf,0x463c09be,0x7aed0495,0x244a89bf}},	//   _দেশে, געגע, lzat, _cùm_, 
   {{0x7bcd09c0,0x0b4589c1,0x22468128,0x6d5c09c2}},	//   njau, шнин, _buok_, zbra, 
   {{0x7aed09c3,0x63af0540,0x11e589c4,0x4a4589c5}},	//   nzat, _macn, ижим, јнов, 
   {{0x6d41803b,0xe9d989c6,0x4375807b,0x442009c7}},	//   _ugla, тко_, _چهار, zli_, 
   {{0xf1b20464,0xe5c489c8,0x442009c9,0x23c589ca}},	//   קסט_, _усто, yli_, वादद, 
   {{0x229589cb,0x6d5c09cc,0x5b158086,0x629d076a}},	//   _видя, wbra, _кмет, _opso, 
   {{0x442009cd,0x228f0019,0x6d5c09ce,0x61fa89cf}},	//   vli_, jük_, tbra, bitl, 
   {{0x2d8789d0,0x200900bf,0xeaf88139,0x7aed0232}},	//   ngne_, _ejai_, _حرمت_, dzat, 
   {{0x442009d1,0x64a609d2,0x629d003b,0x6d5c09d3}},	//   tli_, шава, _apso, rbra, 
   {{0x35c7800f,0xdb0400b0,0x864609d4,0xac0709d5}},	//   लाड़, ndiç, _книж, анса_, 
  
   {{0x442009d6,0xade589d7,0x443209d8,0x896609d9}},	// [400] rli_, कसान_, rmy_, икаж, 
   {{0x442009da,0xe29709db,0xd5a409dc,0x63af00fe}},	//   sli_, раф_, _الدی, _eacn, 
   {{0x18a609dd,0x161f09de,0xb5fb09df,0x10a609e0}},	//   раем, _मीटर_, rsát, риен, 
   {{0x7bdf09e1,0x442009e2,0x244a8015,0x039609e3}},	//   ckqu, qli_, _rùm_, _троя, 
   {{0xe5c689e4,0x63a409e5,0x3f8689e6,0xdce189e7}},	//   иско, mein, rgou_, _delč, 
   {{0xd49a89e8,0x5d7a0273,0x672981a8,0x63af09e9}},	//   ври_, דאַק, _dzej, _zacn, 
   {{0x53e689ea,0xcbe689eb,0xdb060050,0x672989ec}},	//   ициа, иции, _hakà, _ezej, 
   {{0x9f5908fb,0xdb008068,0x63a409ed,0x7afb0284}},	//   risë_, lemé, nein, _žuti, 
   {{0x9f5900f8,0x75e201ac,0xee3a89ee,0x6fb389ef}},	//   sisë_, _rôzn, _ана_, _بمقا, 
   {{0x63a4035b,0xe61f00ef,0x9f5909f0,0x3e328019}},	//   hein, ntôt_, pisë_, _بہتر, 
   {{0x7aed09f1,0x9f5909f2,0x63a409f3,0x228f0281}},	//   zzat, lisé_, kein, zük_, 
   {{0x228f0876,0x656889f4,0x61fa89f5,0x66188170}},	//   yük_, _hedh, sitl, lovk, 
   {{0x61fa85e0,0x644889f6,0xf1c909f7,0x34df09f8}},	//   pitl, _hudi, रामन, नन्द, 
   {{0x644889f9,0x6568847f,0x249e89fa,0x7e6409fb}},	//   _kudi, _jedh, _kptm_, _dwip, 
   {{0x403509fc,0x63a409fd,0x31578039,0xb4c309fe}},	//   _лекс, fein, _דיון_, ्हे_, 
   {{0x81e880cf,0x644889ff,0x2cba0a00,0x7aed0a01}},	//   _যদি_, _mudi, _drpd_, tzat, 
   {{0x6e95030b,0x7bcd036d,0x4df8810c,0x5e9500fe}},	// [410] _الخا, rjau, ्चाई_, _الخط, 
   {{0x7bcd0a02,0x20190a03,0x228f0a04,0xa8028a05}},	//   sjau, losi_, rük_, şıla, 
   {{0x63af0a06,0xea008028,0x6618826b,0x6d450128}},	//   _tacn, _giấy_, dovk, _igha, 
   {{0x64570109,0x63a400ef,0xdce70a07,0x5f7480fe}},	//   _itxi, cein, najč, قاهر, 
   {{0xef1f0a08,0x2bc5809b,0xa3bc002a,0x656880df}},	//   zgün_, वासा, _आफत_, _bedh, 
   {{0x51840a09,0xc9840a0a,0x75eb0085,0xa1840153}},	//   _муса, _муси, _düzg, _мысл, 
   {{0x20190a0b,0x2d878a0c,0xddc98123,0x6d450a0d}},	//   kosi_, rgne_, _aveţ, _mgha, 
   {{0xd7748a0e,0x6e45803d,0x3ff980c6,0x316781e9}},	//   _واقع, _هنرم, _עפּע, _senz_, 
   {{0x6568822d,0x20190a0f,0x69d50a10,0x316c8a11}},	//   _fedh, dosi_, _koze, fadz_, 
   {{0x6568807b,0x6d450324,0x3ead83b8,0x69d50a12}},	//   _gedh, _ngha, _iset_, _joze, 
   {{0x2733810b,0xd175805a,0x645701ea,0x7e640a13}},	//   _ảnh_, _ғылы, _ntxi, _swip, 
   {{0x6d450a14,0xdb060a15,0x0cb38353,0xfaff06a4}},	//   _agha, _laká, ंटीम, _reën_, 
   {{0xe9ce8a16,0x64570109,0x05c30034,0x6d45008b}},	//   _ек_, _atxi, शांब, _bgha, 
   {{0xc5f28273,0x9f590008,0x63a4011a,0x64488a17}},	//   ִדן_, ensä_, wein, _yudi, 
   {{0x76418a18,0xdcf70816,0xed570a19,0x64488a1a}},	//   _mily, _baxı, сос_, _xudi, 
   {{0x6b898a1b,0x6a860a1c,0x6618826b,0x77698a1d}},	//   ngeg, йлба, zovk, _neex, 
   {{0x63a40a1e,0xb5fb03b8,0x69d50a1f,0x6b630188}},	// [420] rein, rsár, _boze, якта, 
   {{0xb5fb0a20,0x05aa04f6,0xdb0081b2,0x45860a21}},	//   ssár, _свой_, kemî, _угов, 
   {{0x65688a22,0x3ead8a23,0x656e047f,0x442f8a24}},	//   _redh, _aset_, mabh, _ohg_, 
   {{0x645c0a25,0x656880df,0x64488a26,0x76498149}},	//   mpri, _sedh, _rudi, _buey, 
   {{0x64488284,0x6b898a27,0x69c38008,0xc5f8804a}},	//   _sudi, dgeg, _onne, аға_, 
   {{0x2d9187fa,0x644888cd,0x7c240a28,0x9f5902c0}},	//   _özel_, _pudi, llir, risé_, 
   {{0x27040a29,0xdcf70816,0x645c0a2a,0xd46784c7}},	//   रपुर_, _yaxı, npri, бије_, 
   {{0x69c38a2b,0xdb06003e,0x656e0a2c,0x6568807b}},	//   _anne, _zaká, habh, _wedh, 
   {{0x6ff58066,0x75eb0214,0xed5a8a2d,0x316c88ba}},	//   jący, _yüzd, _боз_, tadz_, 
   {{0xc05a80b6,0x321a0a2e,0x7641811a,0x69c38149}},	//   лім_, nopy_, _gily, _cnne, 
   {{0x64488a2f,0x645c0662,0x20190a30,0x656e0064}},	//   _uudi, jpri, tosi_, dabh, 
   {{0x69c38a31,0xa3cc075c,0x61fe0214,0x442f813b}},	//   _enne, लाफ_, hipl, _ghg_, 
   {{0x2d980a32,0xdefb004a,0x442480bf,0xdce181a8}},	//   ffre_, уын_, mlm_, _ielā, 
   {{0x6d480024,0xddcd00a1,0x15eb00f0,0x10f98019}},	//   ždan, _stał, уємо_, ابیں_, 
   {{0x69d50a33,0x7c24008b,0x645c0a34,0x3ea0017c}},	//   _roze, flir, gpri, _epit_, 
   {{0x68e10079,0xdb0f0217,0x9b590a35,0x69d50610}},	//   _üldi, _hacé, риат_, _soze, 
   {{0x69d50a36,0x27e90a37,0xdd9100fe,0x645c0a38}},	// [430] _poze, _ilan_, _قوة_, apri, 
   {{0x4424810d,0xdb00824a,0xdb09811e,0x672d0a39}},	//   hlm_, yemî, ndeá, _izaj, 
   {{0x463c0273,0x7c240a3a,0x69d50a3b,0x637f0097}},	//   _געזע, blir, _voze, _cànà, 
   {{0x75eb07fa,0x76418a3c,0xdb0980d8,0x2b468106}},	//   _düze, _sily, hdeá, _ngoc_, 
   {{0xdd26859e,0x442480e5,0x9a840a3d,0xdb2300df}},	//   _pêşk, dlm_, _нурл, _روسی, 
   {{0x27180028,0x442f8a3e,0x27fd811a,0x321a0a3f}},	//   ọng_, _shg_, siwn_, copy_, 
   {{0x27e90a40,0x75eb017e,0x64428a41,0x2bc58a42}},	//   _olan_, _güze, _bioi, वाला, 
   {{0xa9f385d9,0x8c428a43,0x5f9484e4,0xa3cc009b}},	//   ेच्छ_, меще, _нист, लाय_, 
   {{0xdd3a8012,0xb9e98004,0x22430a44,0x6b898a45}},	//   tăţi, имиз_, _kijk_, rgeg, 
   {{0xe1f98a46,0x6b898a47,0x11398a48,0x645c0a49}},	//   рго_, sgeg, ияны_, ypri, 
   {{0xe5c48a4a,0x600a0a4b,0x27e906e0,0x3ea00a4c}},	//   _эсто, ином_, _blan_, _spit_, 
   {{0xd9a60a4d,0x64428086,0x7a300172,0xdb1d016f}},	//   _ऑस्ट, _gioi, mäte, _ansí, 
   {{0xdb0f0a4e,0x8db607c5,0x11d58a4f,0x51f58a50}},	//   _facé, осві, _мікр, _وستر, 
   {{0x645c0a51,0xcb368039,0x27e90a52,0xacea0a53}},	//   tpri, _ואני_, _elan_, амга_, 
   {{0x9d430a54,0x656e085e,0x236001f0,0xdb0b816f}},	//   дерд, rabh, tbij_, _magí, 
   {{0x27e90a55,0x656e0a56,0xa6ca0a57,0x645c0a58}},	//   _glan_, sabh, _نوبل_, rpri, 
   {{0xe1fa0a59,0x2360063c,0x3ea00a5a,0x53368273}},	// [440] ага_, rbij_, _upit_, ַנען_, 
   {{0x244e0a5b,0xf6530039,0x645c0a5c,0x201f8645}},	//   _tým_, _קצת_, ppri, _akui_, 
   {{0x61fe0a5d,0x321a08a1,0xeb9a0123,0x0d230188}},	//   ripl, ropy_, _кин_, _жүрү, 
   {{0xdb040a5e,0x7a30019b,0xc7268a5f,0xb09a83f3}},	//   idiú, däte, одей, ייער, 
   {{0xee3a84c9,0x7bc60a60,0xddc98a61,0x2d588a62}},	//   анд_, _inku, _sveš, биль_, 
   {{0xddc9801b,0x62490a63,0x8cb88a64,0x78af019b}},	//   _kteř, _džod, ्मलो, äivä, 
   {{0xc0c900b0,0x9cca8a65,0x37e680f0,0xafe68123}},	//   _луѓе_, рыла_, _довг, _довл, 
   {{0xd00a8a66,0x68e30255,0x39478a67,0x7dd0019b}},	//   _тебе_, ønde, _agns_, _väsy, 
   {{0x77628a68,0x661c0a69,0xc1a68a6a,0xdb0f03d9}},	//   mbox, kork, ојни, _pacé, 
   {{0x661c0a6b,0x68e901d2,0x77628a6c,0x2be10034}},	//   jork, _ředi, lbox, _नवभा, 
   {{0x27e9021f,0xf2df001c,0x7bc60a6d,0xc9530039}},	//   _plan_, _ngân_, _onku, ומת_, 
   {{0x645a8a6e,0x68318a6f,0x77628a70,0x67240191}},	//   _itti, rådg, nbox, _byij, 
   {{0xf7738039,0x661c0a71,0x67ed024a,0x99d381fa}},	//   וקר_, fork, _nûje, ستیا, 
   {{0xdcfa8214,0x2d9e8265,0x661c0a72,0x27e90a73}},	//   _hatı, _jbte_, gork, _wlan_, 
   {{0xdcfa87fa,0x224b0a74,0xdb6b0a75,0x224300fa}},	//   _katı, _suck_, ирал_, _rijk_, 
   {{0x69d88a76,0x27e90a77,0x3eb00008,0xe2f9004a}},	//   _hove, _ulan_, ältä_, бебі_, 
   {{0x161a8a78,0x2aab0a79,0x672d0a7a,0x69d88a7b}},	// [450] धवार_, штво_, _uzaj, _kove, 
   {{0x69d88a7c,0x645a8a7d,0x7bc602ee,0x661c0a7e}},	//   _jove, _otti, _enku, cork, 
   {{0xb4b50a7f,0x69d88039,0x90990a80,0xa89902c3}},	//   _эйнш, _move, свет_, скеу_, 
   {{0x2bb68a81,0x6d488a82,0x224300fa,0x59c9001b}},	//   _अफगा, _agda, _wijk_, राहर, 
   {{0x645a8a83,0xf1bc807a,0x68e3006d,0x9e6480f0}},	//   _atti, ्ञान, øndb, двід, 
   {{0x76450108,0x764d0a84,0x7a3001ed,0xb5fb0065}},	//   _jihy, _muay, täte, lpáb, 
   {{0x459c0273,0x5ed380b2,0xdcfa8083,0x69cd0076}},	//   יסגע, _দেখে, _batı, साठी, 
   {{0xd7f889b2,0x6e958008,0xf7738a85,0x7a300a86}},	//   _дуу_, _нибу, _زار_, räte, 
   {{0x81ae0a87,0x69d8863c,0x645a8a88,0xa3cc0964}},	//   কার_, _bove, _etti, लात_, 
   {{0x69d88a89,0x99158994,0x78548019,0x2cbe8199}},	//   _cove, зьмі, ڈیوز_, _frtd_, 
   {{0x69d88a8a,0x6d5500a1,0x6c4980fe,0xc6178a8b}},	//   _dove, dcza, _الصف_, दकीय_, 
   {{0x201d8034,0x3ebf8a8c,0x69ce8a8d,0xdb040a5e}},	//   nowi_, _krut_, öber, rdiú, 
   {{0x63a98a8e,0xdce881d2,0xa3b48079,0x7ddd8a8f}},	//   meen, _oddě, _छोट_, _fèst, 
   {{0xed570a90,0x63a98a91,0x69d88a92,0x2ca98034}},	//   зор_, leen, _gove, ładu_, 
   {{0xdcfa86c8,0x8af0008a,0xdce701a8,0xdb0f0149}},	//   _yatı, hbət, tajā, _oncó, 
   {{0x24518a93,0x69c70a94,0x69d88a95,0x661c008d}},	//   _mám_, _anje, _zove, sork, 
   {{0x20020a96,0x661c0a97,0x764d0a98,0x765b8a99}},	// [460] miki_, pork, _guay, _ntuy, 
   {{0x69d88659,0x42230077,0x14bd8a9a,0x63a9819b}},	//   _xove, едув, ्माण, heen, 
   {{0x24518a9b,0x81ae00cf,0x63a98a9c,0x62960a9d}},	//   _nám_, কাল_, keen, styo, 
   {{0x7bc60192,0x26c00524,0x63a981f0,0x62490a9e}},	//   _unku, _krio_, jeen, _džob, 
   {{0x1dc78a9f,0x63a98aa0,0xdee380a8,0xdb06010d}},	//   लांत, deen, ноци, _bakå, 
   {{0xdcfa82bc,0x68e18aa1,0xf1d0801c,0xdb0f03b9}},	//   _satı, kyld, _mạch_, _encó, 
   {{0x2451801c,0x645800ef,0xa0a30a09,0x24778123}},	//   _cám_, _évid, _пард, găm_, 
   {{0x75eb0816,0x63a98aa2,0x24518aa3,0xa6d380b2}},	//   _müza, geen, _dám_, _দেওয়, 
   {{0x64460aa4,0x36678aa5,0x20020aa6,0x5a348aa7}},	//   _miki, _нато_, diki_, мнит, 
   {{0x6831837c,0x68e18142,0x62840162,0x7c668aa8}},	//   råde, fyld, irio, _فاصل, 
   {{0x20020aa9,0x80df80cf,0x63a98aaa,0x9b46803d}},	//   fiki_, _ফেব্, been, _فناو, 
   {{0x64460aab,0x683f0116,0xf1d0801c,0x764500db}},	//   _niki, _kūdi, _bạch_, _sihy, 
   {{0x9f4d8172,0x7e698610,0x7c22829a,0x69d88aac}},	//   _umeå_, _xwep, _ikor, _tove, 
   {{0x64460120,0x4a7b8130,0x55580aad,0x62840aae}},	//   _aiki, _פרוב, заря_, drio, 
   {{0x64460aaf,0x2c5580f3,0x20020ab0,0x321e86a8}},	//   _biki, _kāda_, biki_, moty_, 
   {{0x64460ab1,0x683f0029,0x671e000f,0x69c702cf}},	//   _ciki, _līdz, _युवक_, _snje, 
   {{0x64460aaf,0x44220142,0xe80200a1,0xf1d08106}},	// [470] _diki, _dkk_, _लगता_, _gạch_, 
   {{0xda0c8ab2,0x2fc9022a,0x8af0008a,0x20b08ab3}},	//   िचित_, _hnag_, vbət, _जनाध, 
   {{0x62840422,0x64460ab4,0xdb0b8068,0x63a98ab5}},	//   ario, _fiki, _magá, yeen, 
   {{0xdb0f05cb,0x64460ab6,0x3ebf8ab7,0x321e8ab8}},	//   _hací, _giki, _prut_, hoty_, 
   {{0x44290ab9,0x2451826b,0x4ea781e2,0x321e8aba}},	//   mla_, _sám_, яржа, koty_, 
   {{0x44290abb,0x7c228abc,0x20020abd,0x64460abe}},	//   lla_, _akor, ziki_, _ziki, 
   {{0x58840abf,0x44290ac0,0x63a98ac1,0xdb0f016f}},	//   _пыта, ola_, teen, _mací, 
   {{0x24518791,0x69dc88af,0x44290ac2,0x7a300ac3}},	//   _vám_, ören, nla_, mäta, 
   {{0x44290ac4,0x3ebf8ac5,0x63a98ac6,0x765b80bb}},	//   ila_, _urut_, reen, _utuy, 
   {{0x44290ac7,0x1306836d,0x81bc80f3,0x7c228ac8}},	//   hla_, ьный_, blēm, _ekor, 
   {{0x20020ac9,0x66038aca,0xf1d0801c,0xdb06024a}},	//   tiki_, mink, _sạch_, _bakû, 
   {{0xad1a896e,0x44290acb,0x9f4b06c9,0x2fc90acc}},	//   _ווער, jla_, dicó_, _cnag_, 
   {{0x44290acd,0x7c29817e,0x20020ace,0x62898acf}},	//   dla_, mler, riki_, queo, 
   {{0x66038ad0,0x64a60ad1,0x64460ad2,0xc3328039}},	//   nink, мага, _siki, _סוג_, 
   {{0xe6430ad3,0x27ed8ad4,0x44220083,0x80160ad5}},	//   терп, _olen_, _pkk_, _офиц, 
   {{0x7c2987fa,0xdb008ad6,0x26c00ad7,0x2d840ad8}},	//   nler, lemá, _trio_, şme_, 
   {{0xe2970ad9,0x41c901ff,0xec09810b,0x66038ada}},	// [480] мат_, रांस, yến_, kink, 
   {{0x64460adb,0xceb4008c,0x66038adc,0x27ed868c}},	//   _wiki, _isə_, jink, _alen_, 
   {{0x44290add,0x64460ade,0x7c298adf,0x66038ae0}},	//   bla_, _tiki, kler, dink, 
   {{0x62840ae1,0x44290ae2,0xe8d680c6,0xbf9b012f}},	//   prio, cla_, ווער_, hiên, 
   {{0x27e68ae3,0x7c29872c,0x22478ae4,0x44200ae5}},	//   rkon_, dler, _oink_, moi_, 
   {{0x44200ae6,0x0086075d,0x27e68ae7,0xa3cc00a1}},	//   loi_, _олго, skon_, लाव_, 
   {{0x7c298ae8,0xdcfe0214,0xbf9b03b8,0x69dc06a8}},	//   fler, _kapı, diên, _iore, 
   {{0x69dc0ae9,0xfbdf010b,0x7c298aea,0x44200aeb}},	//   _hore, _liên_, gler, noi_, 
   {{0xc9868aec,0x34ab0aed,0xdb0b8aee,0x6aa880da}},	//   муни, _चन्द, _pagá, कबेर, 
   {{0x44290aef,0x7c298af0,0x645e0284,0x7e628af1}},	//   zla_, aler, _otpi, mpop, 
   {{0x69dc0af2,0x442902bc,0x7c29864a,0x224787b8}},	//   _more, yla_, bler, _dink_, 
   {{0xca48810b,0x7c2280bb,0x4420016c,0x44290af3}},	//   _lời_, _ukor, joi_, xla_, 
   {{0x8c438af4,0x44290af5,0xe81f800c,0x3f850180}},	//   _реце, vla_, यकता_, ğlu_, 
   {{0xbf9b03b8,0x69dc0af6,0x44290af7,0x9f4b0217}},	//   ciên, _nore, wla_, ticó_, 
   {{0x62868af8,0x44290af9,0xdb0f05cb,0x76488afa}},	//   škod, tla_, _vací, _midy, 
   {{0x44200afb,0x44290afc,0xdb0d03b8,0x69dc0050}},	//   goi_, ula_, ndaç, _aore, 
   {{0x66038afd,0x63a28afe,0x5a350aff,0xdce700a1}},	// [490] yink, _mbon, енат, dają, 
   {{0x69dc0b00,0x44290b01,0x7c2987fa,0xddc4068b}},	//   _core, sla_, zler, _zviž, 
   {{0x66038b02,0x69dc0b03,0x27ed86e0,0x7c298214}},	//   vink, _dore, _plen_, yler, 
   {{0x6d5a8b04,0xdd0d00a1,0x66038b05,0x3f158b06}},	//   _afta, półp, wink, ндес, 
   {{0x69dc0b07,0x660381e2,0x36698b08,0x63ad0b09}},	//   _fore, tink, чало_, mean, 
   {{0x63ad003c,0x69dc0b0a,0xed598b0b,0x69dc8172}},	//   lean, _gore, чок_, örel, 
   {{0xdcfe017e,0x7c29817e,0xa3e38079,0x7c2080db}},	//   _yapı, tler, _नकद_, fomr, 
   {{0x66038b0c,0x63ad0b0d,0x7f85803f,0x69dc0b0e}},	//   sink, nean, _سلطن, _zore, 
   {{0x69c403ca,0x7c29817e,0x3d0605d9,0xdb008b0f}},	//   राची, rler, _हेने_, temá, 
   {{0x63ad0b10,0x7c298b11,0xe1ff00a1,0xdb1d0172}},	//   hean, sler, _swój_, _insä, 
   {{0x7c298214,0xbf9b0077,0x31710b12,0xbc6880fe}},	//   pler, riên, _mezz_, _يمكن_, 
   {{0x44200b13,0x6e250b14,0x7bdd0b15,0x60dc810d}},	//   xoi_, _akhb, _nosu, ärma, 
   {{0x7bcb8b16,0x63ad0b17,0x63bb8b18,0x44200b19}},	//   _ingu, dean, mdun, voi_, 
   {{0x63bb8b1a,0xf1d0801c,0x40958b1b,0x6575016c}},	//   ldun, _hạnh_, _зрит, gazh, 
   {{0xdca30b1c,0xfbdf010b,0x44200b1d,0x32058b1e}},	//   лари, _viên_, toi_, mily_, 
   {{0x63bb88ba,0xc4d28273,0x7bdd0123,0xca488106}},	//   ndun, נגן_, _cosu, _rời_, 
   {{0x69dc003a,0x629b8abf,0xfbdf0028,0x44200b1f}},	// [4a0] _pore, ntuo, _tiên_, roi_, 
   {{0xf1d08028,0x81e180b2,0x44200b20,0x31160b21}},	//   _lạnh_, নোর_, soi_, нфес, 
   {{0x69dc0b22,0x63ad0b23,0x4420002d,0xdcfe08f1}},	//   _vore, bean, poi_, _tapı, 
   {{0x63ad0b24,0xca488106,0x76488128,0x629b8162}},	//   cean, _vời_, _sidy, ktuo, 
   {{0x69dc0b25,0x3f9a80a1,0x63bb8b26,0xdce70034}},	//   _tore, ępu_, ddun, rają, 
   {{0x7bcb8b27,0xb90600cf,0x7e628b28,0x629b8128}},	//   _angu, _বই_, rpop, dtuo, 
   {{0x3f6a8b29,0x7bcb80db,0x987e801b,0x7bdd0b2a}},	//   _ниво_, _bngu, _péče_, _yosu, 
   {{0xa2c403ca,0xf1d0801c,0x76488b2b,0x32668b2c}},	//   रिप्, _cạnh_, _widy, нтов, 
   {{0xa3e80611,0x63b98b2d,0x7c2084fb,0x32058170}},	//   _भवन_, _dawn, romr, fily_, 
   {{0x7bcb8b2e,0x7c208088,0xa2b18b2f,0x20068122}},	//   _engu, somr, _अनर्, lioi_, 
   {{0x2bb88b30,0x681580a1,0xdb1d010d,0x63b98b31}},	//   _आसपा, ląda, _inså, _fawn, 
   {{0xc02e810b,0x63a28b32,0x9cd78039,0x20d580ce}},	//   _điều_, _ubon, _רואה_, džią_, 
   {{0x91e68b33,0x09e68b34,0x2d8507bc,0x32058b35}},	//   _поде, _подн, óleo_, bily_, 
   {{0xa2c40b36,0x92f283d2,0x7bdd0b37,0x69ca8b38}},	//   रिन्, ığım, _sosu, _unfe, 
   {{0x63ad0b39,0xe57180c6,0xf4840326,0xa25b02fd}},	//   tean, יַן_, лутн, _crôn, 
   {{0x657500f8,0xb5fd80bc,0x68360065,0xdb0080c0}},	//   sazh, _itše, táde, remæ, 
   {{0x63ad0b3a,0x96350826,0x62490a6b,0x75eb0083}},	// [4b0] rean, _иниц, _džon, _yüzl, 
   {{0x63ad0b3b,0x99990162,0x3ea9068e,0xafdb00c0}},	//   sean, _rusų_, _ipat_, smød, 
   {{0x4426803b,0x63ad0b3c,0xa7758b3d,0x78ba01ac}},	//   _oko_, pean, влеч, _štvr, 
   {{0x660705ab,0x44268b3e,0xe50001a2,0xdb1d010d}},	//   lijk, _nko_, ोपरि_, _anså, 
   {{0x7c2d09a0,0x44390b3f,0x23690123,0x212b8106}},	//   mlar, _ihs_, mbaj_, ́ch_, 
   {{0x44268b40,0x7c2d0b41,0xeb9f036a,0xdee28b42}},	//   _ako_, llar, _gjør_, роши, 
   {{0x1fa78b43,0x32058b44,0x34bd8b45,0x4439028b}},	//   _праг, vily_, ्मेद, _khs_, 
   {{0x7c2d0b46,0x3ea90385,0xdb008008,0x629b8b47}},	//   nlar, _opat_, kemä, ttuo, 
   {{0x66070a44,0x63bb8b48,0x7c2d0122,0x44268b49}},	//   kijk, rdun, ilar, _dko_, 
   {{0x3d1a0066,0x44268b4a,0x7c2d0b4b,0x7d79807b}},	//   _मुझे_, _eko_, hlar, _آمار_, 
   {{0x7c2d0b4c,0x32058b4d,0x629b8b4e,0x23e780f0}},	//   klar, rily_, stuo, _підв, 
   {{0x6e238b4f,0x7c2d0b50,0x7bcb8b51,0xdee60103}},	//   lonb, jlar, _ungu, воми, 
   {{0x443f8b52,0x7c2d0b53,0x442d8b54,0x26c4001b}},	//   mmu_, dlar, mle_, ímo_, 
   {{0x644b8b55,0xb5fb016f,0x2fdf811e,0x3ea90b56}},	//   _higi, spán, _loug_, _dpat_, 
   {{0x442d8b57,0x44390b58,0xed570b59,0x7c2d0b5a}},	//   ole_, _bhs_, тос_, flar, 
   {{0x2d810b5b,0x7c2d0b5c,0x443f8b5d,0xb7bc80cf}},	//   _edhe_, glar, nmu_, _অক্ট, 
   {{0x442d8069,0x443f8b5e,0xdb0f00fe,0x6e238b5f}},	// [4c0] ile_, imu_, _pacá, konb, 
   {{0x644b8b60,0xf1aa007b,0x442d8b61,0x443f8b62}},	//   _ligi, باره_, hle_, hmu_, 
   {{0x7c2d0b63,0x443f8b64,0x27e00095,0x442d8b65}},	//   blar, kmu_, _koin_, kle_, 
   {{0x443f8b66,0x27e00b67,0x442d8b68,0x4f0a804a}},	//   jmu_, _join_, jle_, мнен_, 
   {{0x442d800d,0x443f8b69,0x9696809f,0x6e238b6a}},	//   dle_, dmu_, треш, fonb, 
   {{0x442680b9,0x7c2408a6,0x443f8b6b,0x27e000ef}},	//   _sko_, loir, emu_, _loin_, 
   {{0x644b8b6c,0x69ce0b6d,0x443902fa,0xeb9f00f0}},	//   _bigi, _inbe, _yhs_, _kjøp_, 
   {{0x68e30b6e,0x27e0036d,0xeb978b6f,0x644b8b70}},	//   ände, _noin_, вић_, _cigi, 
   {{0x644b8b71,0x2d968b72,0xea00801c,0xf7438b73}},	//   _digi, _арес, _nhảy_, _вето, 
   {{0x442d8b74,0x7c2d0b75,0x644b8b76,0xdb0401e0}},	//   ale_, zlar, _eigi, ndiñ, 
   {{0x442d8b77,0x44268b78,0x7c2d0b79,0xf9930039}},	//   ble_, _tko_, ylar, ברת_, 
   {{0x4426859d,0x442d8b7a,0x644b8b7b,0x6a868b7c}},	//   _uko_, cle_, _gigi, _алда, 
   {{0xa3cc0b7d,0x7c240659,0x69ce0b7e,0x7c2d0b7f}},	//   लाई_, doir, _onbe, vlar, 
   {{0x82778273,0x644b8b80,0xe91885cf,0x27e0065e}},	//   _יעדע_, _zigi, _полі_, _eoin_, 
   {{0x7c2d0b81,0x66070a44,0x2bc409af,0x2d580b82}},	//   tlar, rijk, _लोहा, тись_, 
   {{0x69ce0b83,0xe7870b84,0xe41400f0,0x0a6b09d9}},	//   _anbe, _руко, адсь, држи_, 
   {{0x7c2d0b85,0x6b828010,0x3b540b86,0x6440819b}},	// [4d0] rlar, _mdog, ркур, immi, 
   {{0x7c2d09d6,0x44248b87,0x2fcd8b88,0x35b50b89}},	//   slar, hom_, _sneg_, _сбор, 
   {{0x442d8b8a,0x21a4036a,0x7c2d0b50,0x6836027b}},	//   yle_, риєм, plar, láda, 
   {{0x7c2d0b8b,0x44248b8c,0xb8db0b8d,0xe679805a}},	//   qlar, jom_, _अन_, ейді_, 
   {{0x442d83b7,0x6e238b8e,0xdd0180d7,0xc1788162}},	//   vle_, tonb, _čuđe, nkės_, 
   {{0x68388b8f,0x68e8810d,0xdb0601d2,0x69d80019}},	//   víde, kydd, _jaký, övet, 
   {{0x442d8b90,0x443f8b91,0x18b80008,0x58d40b92}},	//   tle_, tmu_, _игры_, _корт, 
   {{0x4424803b,0xeb998b93,0x442d8b94,0x5f458b95}},	//   gom_, хии_, ule_, _منزل, 
   {{0x442d8b96,0x63bd0b97,0x644b8b98,0x0a498b99}},	//   rle_, _masn, _vigi, нзий_, 
   {{0x442d8b9a,0x443f8b9b,0xe0d98b9c,0x62898b9d}},	//   sle_, smu_, ево_, rreo, 
   {{0x442d8b9e,0x7794007b,0x27e00076,0x443f847a}},	//   ple_, لیغا, _poin_, pmu_, 
   {{0x44248b9f,0xf6490115,0x63bd01b2,0x69da827e}},	//   com_, _זצ_, _nasn, ajte, 
   {{0xa9a58ba0,0x21a58103,0x7c2400ef,0x27e0019b}},	//   _билд, _билм, voir, _voin_, 
   {{0x7bcf0ba1,0x68e8811a,0x645c8432,0xdb040ba2}},	//   _ancu, bydd, _éric, leiç, 
   {{0x7c2402c0,0x0c7901bc,0x7ae98ba3,0x18a58ba4}},	//   toir, ксты_, lyet, _сайм, 
   {{0x63bd0ba5,0x6d5c0ba6,0x62490ba7,0xf0928309}},	//   _casn, scra, _džom, _הנה_, 
   {{0x7ae98ba8,0x43750ba9,0xdb19847f,0x7c240baa}},	// [4e0] nyet, руст, _bawé, roir, 
   {{0x7bcf0bab,0x3c3a816c,0x764b0035,0x7c240bac}},	//   _encu, mëve_, _égyp, soir, 
   {{0xfaa3031c,0x98a68bad,0x2fd7007b,0xdb040bae}},	//   _қаро, čiće_, _شوید_, rdiñ, 
   {{0x7880003e,0x27e0812b,0x61e08baf,0x63bd0bb0}},	//   _návš, ðin_, _पक्ष, _gasn, 
   {{0x4a750bb1,0x44248bb2,0x5f068bb3,0x7e2a8bb4}},	//   _выст, vom_, ызда, ніка_, 
   {{0x63a40bb5,0x69ce02ae,0xa3cc0bb6,0x44248347}},	//   lfin, _unbe, लाक_, wom_, 
   {{0xa1160bb7,0x98be83d2,0xdb0402fd,0xa3cf8a64}},	//   _صورت, yatı_, feiç, शां_, 
   {{0xd90d007b,0x64408269,0x20048238,0x3c3a80f8}},	//   _تیم_, ummi, _ummi_, këve_, 
   {{0x68e88360,0x81bc8029,0x3c3a816c,0xef178103}},	//   wydd, klēt, jëve_, _бмт_, 
   {{0x44248bb8,0x49748bb9,0x50668a1c,0x683881d2}},	//   som_, шлос, лтма, bídc, 
   {{0x44248bba,0xea008028,0x48150bbb,0xbc668bbc}},	//   pom_, _chạy_, имос, _свек, 
   {{0x68e88bbd,0x59d2801b,0x63a40105,0x7ae98640}},	//   rydd, ताहर, jfin, byet, 
   {{0x6b7b8115,0x63bd0533,0x5eb880b2,0x62490bbe}},	//   _טראנ, _rasn, _আপডে, _džoj, 
   {{0xdb070019,0x63bd00f3,0x7e7d0bbf,0x65950077}},	//   ámít, _sasn, rssp, јаву, 
   {{0x63bd0bc0,0x40350bc1,0x765603d9,0x81da05a2}},	//   _pasn, _кекс, _euyy, ়সা_, 
   {{0x59d28bc2,0xa3cc0bc3,0x75eb0214,0x683603c3}},	//   तावर, लाग_, _müzi, ládn, 
   {{0x2ba68bc4,0x200b0bc5,0x49750bc6,0xa29505cf}},	// [4f0] क्या, mici_, илас, разі, 
   {{0xdd91040c,0xddc98bc7,0xa5c5004a,0xd91b0bc8}},	//   _بود_, _svež, _төме, нье_, 
   {{0x7afb82fb,0xfaf98162,0x155a0309,0x87e78b73}},	//   zzut, lbūt_, _בכתב, люде, 
   {{0x200b029f,0xa2950612,0xff5f01b2,0x7bcf0bc9}},	//   nici_, _камі, ncî_, _uncu, 
   {{0x442b0269,0x7c3a0035,0xb5fd8162,0xdb1d09b8}},	//   _ikc_, ître, _atša, _masë, 
   {{0x7bc78029,0x644f05cb,0x48770bca,0x645702fe}},	//   ējum, _hici, _مدرس, _kuxi, 
   {{0xdb1d006d,0x2c5581a8,0x200b02d2,0x3c3a89b8}},	//   _ansø, _kādi_, kici_, zëve_, 
   {{0xca858a1c,0x7afb8bcb,0xdb19824a,0x73e58b1b}},	//   агий, tzut, _dawî, роиз, 
   {{0x200b0bcc,0x22158bcd,0x645702fa,0x5fab80da}},	//   dici_, ифор, _luxi, _टॉयल, 
   {{0x644f0bce,0x7ae98bcf,0x9f5902fb,0x7a30019b}},	//   _lici, ryet, misù_, vätk, 
   {{0x7ae98bd0,0x200b0bd1,0x387e807b,0x98a58bd2}},	//   syet, fici_, gstr_, шине, 
   {{0x644f0bd3,0x3c3a80f8,0x76438bd4,0x200b0bd5}},	//   _nici, tëve_, lmny, gici_, 
   {{0xaa678bd6,0x32638019,0x32678236,0x9736077a}},	//   _стек, _انتہ, _стев, рэнч, 
   {{0x3c3a8210,0xd9458bd7,0x61458537,0x644f0029}},	//   rëve_, _кели, _кела, _aici, 
   {{0x442b0265,0x443d806c,0x764380db,0x61e38bd8}},	//   _bkc_, _khw_, imny, _ionl, 
   {{0x3ead803b,0x644f0bd9,0x200b0215,0x4aa98bda}},	//   _opet_, _cici, cici_, _कहाव, 
   {{0x63a40bdb,0x26c904e0,0x02060bdc,0x395600b0}},	// [500] rfin, _grao_, азан, ањет, 
   {{0x69c18bdd,0xe1f70bde,0x64570bdf,0xada60103}},	//   ndle, агу_, _fuxi, _таол, 
   {{0x03a60be0,0x60268be1,0x63a40be2,0x69c1843a}},	//   _кино, аджа, pfin, idle, 
   {{0xb8ce023b,0x443d8324,0xb8fe0056,0x8fa686a1}},	//   _कह_, _nhw_, _तप_, раде, 
   {{0x2fc00188,0xfe4684bc,0xddd6026b,0x660a8363}},	//   _maig_, андо, _zvyš, tifk, 
   {{0x44320be3,0x2d980be4,0x200b001b,0x2fc00be5}},	//   lly_, ngre_, zici_, _laig_, 
   {{0x443d80e5,0xeb0e81a2,0xa2c40034,0x200b0a05}},	//   _bhw_, ाप्त_, रिव्, yici_, 
   {{0x8aa68be6,0x25a98131,0xe8d70039,0x317801ed}},	//   арод, đala_, _דולר_, _herz_, 
   {{0x44320be7,0x657c02a5,0x61e38be8,0x78af0533}},	//   ily_, karh, _bonl, čivš, 
   {{0x2c0b8a0e,0xc05a8be9,0x44320bea,0x61e38beb}},	//   _یعنی_, кім_, hly_, _conl, 
   {{0x245c026b,0x61e38bec,0x3a370039,0x6577016c}},	//   _ním_, _donl, שרים_, _rexh, 
   {{0x2fc001df,0x2a7f8bed,0xcb6a82f0,0xfaa68bee}},	//   _caig_, bsub_, _раде_, _вадо, 
   {{0x200b0bef,0x67010bf0,0x2fc00bf1,0x645701e0}},	//   rici_, _लेखक_, _daig_, _suxi, 
   {{0x644f0bf2,0xfaf98bf3,0x2b928068,0x442b0bf4}},	//   _sici, rbūt_, _ایکس, _skc_, 
   {{0x6ab68938,0x52b68bf5,0xe78704ec,0x644f0bf6}},	//   _अनुर, _अनुस, _купо, _pici, 
   {{0x628d0bf7,0x3b550bf8,0x26c9001c,0xd0f78309}},	//   trao, скар, _trao_, _כמות_, 
   {{0xa3a88bf9,0x657c0bfa,0xd2510743,0xa2c405d1}},	// [510] ख्य_, barh, سنا_, रिष्, 
   {{0xf9930743,0x2ba6800c,0x44320bfb,0x6838801b}},	//   تبر_, क्ता, aly_, vída, 
   {{0x3ead8bfc,0xdb1d0bfd,0x44320bfe,0x644f0bff}},	//   _spet_, _masé, bly_, _tici, 
   {{0x442b0c00,0xa2c40c01,0x3f990c02,0x1ab6802a}},	//   _ukc_, रिश्, ngsu_, _अनूठ, 
   {{0x44290c03,0x683d02c0,0x6fd8009b,0x7a3d80ef}},	//   moa_, céde, यातू, lète, 
   {{0x44290c04,0x76438a11,0xe299804c,0x9f448093}},	//   loa_, umny, ҳаи_, _komê_, 
   {{0x22590c05,0xfc3f0028,0xa3cc009b,0x7aed0c06}},	//   _husk_, _khí_, लाच_, lyat, 
   {{0x5f948c07,0x24898c08,0x2a7f8c09,0xe3b98c0a}},	//   _мист, čam_, tsub_, уби_, 
   {{0x8d878c0b,0xfc3f00fe,0x320c80de,0x62808c0c}},	//   _نشان, _mhí_, fidy_, gsmo, 
   {{0x44290c0d,0x673b8c0e,0x7a300c0f,0x20090c10}},	//   hoa_, _izuj, täti, _amai_, 
   {{0x44290c11,0x7aed00db,0x69c18c12,0xdb1d02ef}},	//   koa_, hyat, rdle, _dasé, 
   {{0x44290c13,0xc5e90080,0xfc3f0106,0xfbdf012f}},	//   joa_, _אד_, _nhí_, _kiêu_, 
   {{0x2fc000a6,0x44290c14,0xdb098c15,0xf3ff00b2}},	//   _vaig_, doa_, rdeó, ্কার_, 
   {{0x61fa8c16,0xfc3f06b8,0x7aed0c17,0x69dc8c18}},	//   chtl, _ahí_, dyat, öret, 
   {{0x4095830b,0xfc3f030b,0x2fc0022a,0x44290c19}},	//   _العر, _bhí_, _taig_, foa_, 
   {{0x3ce500f9,0x44290c1a,0xfc3f0028,0x7ff60267}},	//   älva_, goa_, _chí_, _دستا, 
   {{0x44320052,0x68e30617,0xbb430c1b,0x7764008b}},	// [520] rly_, ändn, зетк, _ifix, 
   {{0xc3328052,0x245c000d,0x44320c1c,0x200e00a1}},	//   לון_, _tím_, sly_, ślić_, 
   {{0x44320c1d,0xef6582bc,0x2c5580f3,0x44290c1e}},	//   ply_, ğını_, _kādu_, boa_, 
   {{0xd49a8c1f,0xef658085,0xea00801c,0x7c298c20}},	//   ҳри_, şını_, _thầy_, joer, 
   {{0x317802a1,0x63b60c21,0x661a80db,0x673b8034}},	//   _terz_, meyn, _pjtk, _czuj, 
   {{0x99d60275,0x21f600fe,0x63b60c22,0xd49a8c23}},	//   _اتحا, _اكسس, leyn, гри_, 
   {{0xec098028,0x320c81cb,0x62960c24,0x758987c5}},	//   yết_, vidy_, luyo, рсів_, 
   {{0x8fa38c25,0x7bc40c26,0xc7a38c27,0x62808c28}},	//   _насе, ndiu, _ниск, tsmo, 
   {{0x6aa40c29,0x62960214,0x200900f6,0x6d430170}},	//   ntif, nuyo, _rmai_, _únav, 
   {{0x660e0c2a,0x44290109,0x60ca82fa,0x62808c2b}},	//   jibk, zoa_, _prfm, rsmo, 
   {{0xdb1d0093,0x7c298c2c,0x201903b8,0xe1ff011e}},	//   _nasî, boer, ério_, _otón_, 
   {{0x6aa405b5,0x7aed0816,0xf5378039,0x313704fc}},	//   ktif, yyat, _פנאי_, מנים_, 
   {{0x657a80df,0x7336803d,0xf1c800da,0x63b602d1}},	//   _keth, _ارائ, रयान, deyn, 
   {{0x329b8c2d,0xe1ff011e,0x7764011e,0xe7cf8c2e}},	//   _עבוד, _atón_, _efix, _सोनप, 
   {{0x44290c2f,0xf1a9807b,0xfc3f0028,0xfbab0c30}},	//   toa_, _خانه_, _phí_, лтай_, 
   {{0x645a8c31,0x657a8c32,0x317e81ed,0xdb1602a5}},	//   _muti, _leth, latz_, meyê, 
   {{0x44290c33,0x645a8c34,0x62960c35,0x8af7808a}},	// [530] roa_, _luti, guyo, _çəti, 
   {{0x44290c36,0x645a82c0,0xf77f0c37,0xa3a883ff}},	//   soa_, _outi, laç_, ख्त_, 
   {{0xe8e00147,0x2bc40c38,0xfbdf012f,0x317880a1}},	//   ười_, _लोका, _siêu_, órzy_, 
   {{0x2d9e8c39,0x317e8c3a,0x657a82ad,0x47358c3b}},	//   _acte_, hatz_, _aeth, онес, 
   {{0x539a0052,0x657a8c3c,0x7c2982b5,0x6aa40c3d}},	//   _דירו, _beth, voer, ctif, 
   {{0x645a8c3e,0x25a98131,0x63ab80bf,0xdc3c81a8}},	//   _buti, đalo_, _sbgn, kšēj, 
   {{0x69d50c3f,0x645a8c40,0xe78782d4,0x8ccc0bda}},	//   _inze, _cuti, _гузо, हियो, 
   {{0xfbdf0028,0xdb1601b2,0xea898c41,0x7bc28035}},	//   _tiêu_, deyê, абил_, _caou, 
   {{0xe1f98c42,0x7bc28c43,0x6fdd009b,0x657a8c44}},	//   иги_, _daou, यानं, _feth, 
   {{0x69c50c45,0x26cd8c46,0x88858775,0x200f8c47}},	//   ndhe, _ireo_, олож, ligi_, 
   {{0xf9920c2d,0x69c50048,0x645a8c48,0x7a300008}},	//   ורי_, idhe, _guti, mätt, 
   {{0x7a300c49,0x200f8c4a,0x26cd8c4b,0x777b80ef}},	//   lätt, nigi_, _kreo_, _jeux, 
   {{0xe9d98c4c,0x3f89011a,0x9f44816c,0x69d50c4d}},	//   _вкл_, _ddau_, _romë_, _onze, 
   {{0x2019054b,0x317e8c4e,0xdce8801b,0xf3f10106}},	//   ansi_, catz_, _nedě, ện_, 
   {{0x2c5580f3,0x7bc28c4f,0x69c50c50,0x68e301ab}},	//   _tādu_, _yaou, ddhe, ändl, 
   {{0x69c38c51,0x69d50c52,0x62960c53,0x6b9b8c54}},	//   _hane, _anze, tuyo, ngug, 
   {{0xb4b683ce,0xfaa30c55,0x69c38c56,0xe29a0c57}},	// [540] _छन्_, мато, _kane, раз_, 
   {{0x69c38c58,0xea00810b,0x63b6008a,0x62960c59}},	//   _jane, _thấy_, seyn, ruyo, 
   {{0x02b68b30,0xd91009dc,0x657a8c5a,0x69c38c5b}},	//   _अन्न, ریر_, _reth, _mane, 
   {{0xe29a0c5c,0x69c38124,0x657a8c5d,0xd7dd009b}},	//   _кам_, _lane, _seth, यायच, 
   {{0xaa4600b6,0x26cd8c5e,0x645a8c5f,0x777b80ef}},	//   _мемл, _creo_, _suti, _deux, 
   {{0x69c38c60,0x62860c61,0x7c3601c2,0x63a98c62}},	//   _nane, _ivko, llyr, efen, 
   {{0x63a98c63,0x5fca0c64,0xb5fb0c65,0x26cd8050}},	//   ffen, ियाल, mpát, _ereo_, 
   {{0x7a3480a6,0x69c38c66,0x657a81f0,0x26cd8065}},	//   màti, _aane, _weth, _freo_, 
   {{0x62840c67,0x69c38c68,0x2fc684b4,0x38698c69}},	//   nsio, _bane, mdog_, _čara_, 
   {{0x094a8aff,0x914a8c6a,0x645a8c6b,0x3ebb84fc}},	//   ични_, ична_, _tuti, _דצמב, 
   {{0x69c38c6c,0x645a836d,0x61e302ae,0x4254803d}},	//   _dane, _uuti, önli, _کنتر, 
   {{0x62840c6d,0x2fc68c6e,0x317e81ed,0xdb16024a}},	//   ksio, ndog_, satz_, reyê, 
   {{0x3ea68c6f,0x69c38c70,0x0aba8604,0x7a2f872c}},	//   ntot_, _fane, _خطاب_, tøtt, 
   {{0x69c38c71,0x81f88c72,0x62840c73,0x2ba68c74}},	//   _gane, _دفتر_, dsio, क्रा, 
   {{0xd37b0c75,0x271c8028,0x09ac80b2,0xf77f0741}},	//   ича_, ỉnh_, _কোথা, paç_, 
   {{0x248d0c76,0x683f00f3,0x6b808c77,0xdb198149}},	//   čem_, _lūdz, namg, _hawá, 
   {{0x2bbd8c78,0x69c38c79,0x34b78c7a,0x27e90c7b}},	// [550] ्यता, _yane, _आन्द, _ioan_, 
   {{0x69c38c7c,0x27e90c7d,0x78a5012b,0xdb008432}},	//   _xane, _hoan_, tthv, lemó, 
   {{0x26cd829f,0x69c50c7e,0x7e698c7f,0x2fc48027}},	//   _sreo_, rdhe, _step, _bamg_, 
   {{0x76418c80,0x69c509b8,0x9ed98656,0x27e90c81}},	//   _shly, sdhe, ймет_, _joan_, 
   {{0x2bc4007a,0x200f8c82,0x7c2d0c83,0x7bda0039}},	//   _लोटा, rigi_, moar, _הקרו, 
   {{0x7c2d0c84,0x26cd8123,0xdd918c85,0x1dcb0532}},	//   loar, _vreo_, روع_, ायित, 
   {{0x7a300c86,0x64428336,0x69c38c87,0x6ab9008a}},	//   rätt, _bhoi, _rane, şafı, 
   {{0x7a300c86,0x69c38c88,0x57b48c89,0x64428c8a}},	//   sätt, _sane, _обст, _choi, 
   {{0xd5bb8c8b,0x64428c8c,0x63a98c8d,0x3ebf82fa}},	//   _все_, _dhoi, rfen, _usut_, 
   {{0x7c2d0c8e,0xdb0d0c8f,0x63a98c90,0x13068656}},	//   hoar, ndañ, sfen, яный_, 
   {{0xf992096e,0x69c38079,0x64428649,0x7c2d0124}},	//   ערט_, _vane, _fhoi, koar, 
   {{0xb4d78c91,0x69c38c92,0xa3bb8c93,0x64428c94}},	//   ामी_, _wane, _خاطر_, _ghoi, 
   {{0x7c2d0c95,0x27e90c96,0x64498c97,0xeaae8c98}},	//   doar, _doan_, mmei, _яй_, 
   {{0x442d8504,0x64498c99,0x2c5580f3,0xfce60c9a}},	//   loe_, lmei, _tāds_, пого, 
   {{0x2eb88439,0x33f60c9b,0x1fb60c9c,0x8cce8034}},	//   _इन्त, пчас, _еспр, थियो, 
   {{0x62840c9d,0x442d8c9e,0x64498c9f,0x1e860ca0}},	//   tsio, noe_, nmei, _елим, 
   {{0x2bad8365,0x9f448ca1,0x62840116,0x26c00ca2}},	// [560] झ्या, _tomé_, usio, _usio_, 
   {{0x3f820ca3,0x442d8ca4,0x2bb8825d,0xff5f01b2}},	//   laku_, hoe_, _आस्थ, ndîn_, 
   {{0x62840ca5,0x23bd83f2,0xfbbd824c,0x442d8ca6}},	//   ssio, ्याद, ्याम, koe_, 
   {{0x3f820ca7,0x61fe0ca8,0x442d82a6,0x657e039d}},	//   naku_, shpl, joe_, _heph, 
   {{0x5fdd009b,0x78828019,0xb5fb0ca9,0x442d8caa}},	//   यातल, _kívá, mpár, doe_, 
   {{0x7bc60cab,0xe5348cac,0x3ea68cad,0x67360008}},	//   _haku, мель, rtot_, _myyj, 
   {{0x7bc60cae,0x4bc48a1c,0x64428caf,0x657e0504}},	//   _kaku, дөлг, _phoi, _meph, 
   {{0x4f95855a,0x293700c6,0x442d82a6,0x7bc60cb0}},	//   _оруу, _זאלן_, goe_, _jaku, 
   {{0x3f820cb1,0x27e9040a,0xdb0d01c2,0x200789b8}},	//   daku_, _roan_, ndað, ënie_, 
   {{0x7bc60cb2,0xeaaf8830,0x3958872c,0x7c2d0cb3}},	//   _laku, اعي_, ørs_, zoar, 
   {{0x64428cb4,0x5f950cb5,0x6e2e0cb6,0x3f820cb7}},	//   _thoi, минт, dobb, faku_, 
   {{0x1ae68cb8,0x3f820cb9,0x04db8039,0x442d8027}},	//   _ноем, gaku_, _לקבל, coe_, 
   {{0xa3c00cba,0x7c2d0cbb,0x27e90cbc,0x79818cbd}},	//   ंजन_, voar, _voan_, balw, 
   {{0x91e38cbe,0x09e38cbf,0x611484d9,0x657e0cc0}},	//   _поче, _почн, _одлу, _ceph, 
   {{0x7c2d0cc1,0x7bc60cc2,0x69c88324,0x69a18c2e}},	//   toar, _baku, mdde, _खाती, 
   {{0x7bc60cc3,0x645e0cc4,0x03c40cc5,0x2c0d009b}},	//   _caku, _dupi, нсум, _सगळं_, 
   {{0x4a550cc6,0x7c2d0109,0x683d0cc7,0x7bc60cc8}},	// [570] дкас, roar, lédo, _daku, 
   {{0x7c2d0cc9,0x6838800d,0xa2bf8cca,0x69c88ccb}},	//   soar, bídk, _वनस्, ndde, 
   {{0x7bc60ccc,0x2d830ccd,0x63a28cce,0x7c2d0ccf}},	//   _faku, maje_, _ocon, poar, 
   {{0x2d9c08b4,0x27e987e9,0x65688645,0x2d830cd0}},	//   _över_, ðan_, _afdh, laje_, 
   {{0x6fa50cd1,0x69d880d0,0x62490cd2,0x63ad0cd3}},	//   _कानू, _onve, _džor, mfan, 
   {{0x7bc60cd4,0x2d830cd5,0x63ad0cd6,0x68360cd7}},	//   _zaku, naje_, lfan, rádi, 
   {{0xb4d78056,0x645800ef,0x63ad0cd8,0x3f82068e}},	//   ामे_, _évit, ofan, yaku_, 
   {{0xeb998cd9,0x69d88cda,0x2bda8cdb,0x63ad02ae}},	//   ции_, _anve, भाषा, nfan, 
   {{0x69c70cdc,0x64498cdd,0x79818cde,0x26cb8cdf}},	//   _kaje, rmei, talw, _éco_, 
   {{0x63a28ce0,0x442d83ec,0x08898ce1,0x64498ce2}},	//   _econ, soe_, обой_, smei, 
   {{0x39458ce3,0x3f820ce4,0x7e6d0ce5,0x657e0ce6}},	//   ьног, taku_, _atap, _reph, 
   {{0x657e03ec,0x645e0ce7,0xe73a0ce8,0x69c70ce9}},	//   _seph, _rupi, жем_, _laje, 
   {{0x3f820cea,0xe9a58ceb,0x63bb8cec,0xa9a58ced}},	//   raku_, _жалп, meun, _жилд, 
   {{0x7bc60cee,0x2bbd8808,0x69c70cef,0x63bb8cf0}},	//   _saku, ्यवा, _naje, leun, 
   {{0xed570cf1,0x7bc60cf2,0xdca30cf3,0x62868170}},	//   дор_, _paku, кари, ákov, 
   {{0x7bc98cf4,0x04430cf5,0x63bb8385,0xaac900da}},	//   ndeu, весн, neun, रिंक, 
   {{0x69c70cf6,0xc1ea0cf7,0x7bc60cf8,0xf4128039}},	// [580] _baje, одаж_, _vaku, דפן_, 
   {{0x7bc60cf9,0x7c290025,0x69c70cfa,0x63bb8385}},	//   _waku, čera, _caje, heun, 
   {{0x106a0cfb,0xb4d7854d,0x63bb8385,0x7640001b}},	//   цией_, ामो_, keun, ůmys, 
   {{0x63bb8cfc,0x680b085a,0x00000000,0x00000000}},	//   jeun, wędz, --, --, 
   {{0xa3e18758,0x69c88cfd,0x63bb8385,0x6d418766}},	//   दान_, ydde, deun, _azla, 
   {{0x6b840caf,0x69c70cfe,0x63a28cff,0xb80605a2}},	//   laig, _gaje, _scon, োকিত_, 
   {{0xdb0b812b,0xd8390131,0x7bc98d00,0x644a0d01}},	//   _sagð, luče_, fdeu, _èfis, 
   {{0x69c70025,0x6b840d02,0x2d830d03,0xd9430d04}},	//   _zaje, naig, zaje_, _реси, 
   {{0x83fc8c0e,0x752d8646,0x4a548d05,0x27e68ced}},	//   _nuđe, ğaza, нкис, mjon_, 
   {{0x27e68d06,0x765f02b4,0x6b840d07,0x24f68d08}},	//   ljon_, _ruqy, haig, _очер, 
   {{0xdb1d026b,0x2d830d09,0x69c8811a,0x63bb8385}},	//   _masá, vaje_, rdde, beun, 
   {{0x7e608d0a,0x68e30d0b,0xb8e680a1,0x27e68d0c}},	//   _kump, ändi, _उन_, njon_, 
   {{0x6b840d0d,0x19948d0e,0xd8390998,0x3f8002ef}},	//   daig, _заля, juče_, _deiu_, 
   {{0xc1c803ce,0x7c2d8081,0x7e608d0f,0x69d88d10}},	//   रयोग, čare, _mump, _unve, 
   {{0x2d830d11,0x7e608d12,0x69c70d13,0x63ad007f}},	//   raje_, _lump, _raje, tfan, 
   {{0x2d830d14,0xeac88028,0x25a98284,0x69c70d15}},	//   saje_, _kỹ_, đali_, _saje, 
   {{0x69c70d16,0x44ce877a,0x7e608d17,0x63ad0d18}},	// [590] _paje, _lę_, _nump, rfan, 
   {{0xeac88028,0x2fc90d19,0x7c228d1a,0x63ad0d1b}},	//   _mỹ_, _haag_, _ljor, sfan, 
   {{0x6b840116,0x61e78172,0x69c70d1c,0x63ad0d1d}},	//   baig, öjli, _vaje, pfan, 
   {{0x69c70d1e,0x66150d1f,0xd8390269,0x6b840d20}},	//   _waje, lizk, buče_, caig, 
   {{0x7e608d21,0xb4d78d22,0xdb1d0d23,0x644d0d24}},	//   _cump, ाम्_, _ansö, mmai, 
   {{0x7c228d25,0x2fc903c5,0x7a2b02ae,0x63bb8385}},	//   _ajor, _laag_, hütz, weun, 
   {{0x271b0d26,0x63bb8d27,0x97a78d28,0xdce380f3}},	//   नपुर_, teun, _орал, manī, 
   {{0x44ce8d29,0x6aa981a3,0xee3f00e9,0x2d810d2a}},	//   _dę_, ttef, dtým_, _lehe_, 
   {{0xc6a48d2b,0x63bb8d2c,0x4ea48d2d,0x7bc98d2e}},	//   _архи, reun, _арха, rdeu, 
   {{0xddc4003a,0xb5fd8d2f,0xdb040d30,0x89a98418}},	//   _otiš, _buše, nfiá, чков_, 
   {{0x83fc803a,0x07a60118,0xf1b200c6,0x6d418d31}},	//   _suđe, нанн, נסט_, _uzla, 
   {{0x7c228d32,0x2fc9022a,0xb5fd8d33,0x60da0063}},	//   _gjor, _caag_, _duše, _átme, 
   {{0x79850766,0x2fc90d34,0x2d810d35,0xdce18162}},	//   kahw, _daag_, _behe_, _pelė, 
   {{0x6a178068,0xd8390024,0x3ea28172,0x27ff811a}},	//   _تبصر, vuče_, _åkte_, _llun_, 
   {{0x62868d36,0xb5fd8533,0x6b840d37,0x7c29043e}},	//   škot, _guše, taig, čern, 
   {{0x27ed8d38,0x8b950d39,0x83fc80d7,0x7c3b820e}},	//   _noen_, круч, _tuđe, nlur, 
   {{0x64598d3a,0xdb1d0d3b,0x4a460d3c,0x49960166}},	// [5a0] _miwi, _pasá, енав, ешет, 
   {{0xe7ac01c7,0x27ff8d3d,0x644d0d3e,0x6b840094}},	//   ट्रप, _alun_, amai, saig, 
   {{0x7e6083d9,0x644d0d3f,0x7d7b0039,0xdb1d0019}},	//   _sump, bmai, _מניו, _vasá, 
   {{0x4ea68d40,0x644d0497,0xc6a68d41,0x64598d42}},	//   ерка, cmai, ерки, _niwi, 
   {{0x27ed81d9,0x44200d43,0x44320d44,0x61f3072c}},	//   _doen_, mni_, moy_, ådlø, 
   {{0x27e68d38,0x443202b7,0xf2df0106,0xf48700df}},	//   sjon_, loy_, _ngây_, _تایی, 
   {{0x44200d45,0xd9430d46,0x69dc0d47,0x8cd30b45}},	//   oni_, _бери, _inre, डियो, 
   {{0x44200d48,0x44320d49,0x2bba8013,0x44ce877a}},	//   nni_, noy_, ساعة_, _vę_, 
   {{0x7ae404e0,0xe7e40d4a,0x64598d4b,0x61ee0d4c}},	//   nxit, गाना_, _diwi, _kobl, 
   {{0xb5fd8524,0x44200d4d,0xfce68d4e,0x44320d4f}},	//   _puše, hni_, _позо, hoy_, 
   {{0x44200d50,0x44320318,0x7a2b02ae,0x61ee097d}},	//   kni_, koy_, tütz, _mobl, 
   {{0x2d8101ed,0x6d5e013b,0x44320d51,0x7c3b8d52}},	//   _sehe_, _agpa, joy_, clur, 
   {{0xd6d80d53,0x44320d54,0x69dc0d55,0xddc40533}},	//   нтр_, doy_, _onre, _stiš, 
   {{0x44200d56,0x3913805a,0x2ee10d57,0x6b828786}},	//   eni_, _өмір, _पपीत, _heog, 
   {{0x4420012b,0x2fc901df,0xa4d80d58,0x443201cb}},	//   fni_, _taag_, ндру_, foy_, 
   {{0x69dc0d59,0x44200d5a,0x493b8039,0x44320d5b}},	//   _anre, gni_, _מגוו, goy_, 
   {{0x69ca8d5c,0x5a3500ba,0x61ee0bbd,0x23690d5d}},	// [5b0] _kafe, внат, _bobl, rcaj_, 
   {{0x44200d5e,0x27ed8d5f,0x61fa8d60,0x6b828d61}},	//   ani_, _soen_, nktl, _leog, 
   {{0x44200d62,0x61ee0d63,0x69ca82a6,0x25de0d64}},	//   bni_, _dobl, _mafe, खारी_, 
   {{0x44200043,0x69dc0577,0x69ca8d65,0x87e48d66}},	//   cni_, _enre, _lafe, люче, 
   {{0x539a0c2d,0x6abc89ca,0xf770846d,0xe5a58d67}},	//   _קישו, ्टोर, صان_, вили, 
   {{0x0c74007b,0x44d101e2,0xdce88029,0x61ee0d68}},	//   _جدید, _ką_, _nedē, _gobl, 
   {{0x6b828d69,0x27ed8a44,0xdb04007f,0x44d10d6a}},	//   _beog, _toen_, leið, _ją_, 
   {{0xa1580d6b,0x7bcd0d6c,0xbbbd8d6d,0x19580d6e}},	//   _часу_, ndau, ्येक, _часы_, 
   {{0x24808025,0x7c3a00ef,0x69ca8d6f,0x7c3b810d}},	//   ćima_, îtri, _bafe, rlur, 
   {{0x44200d70,0x62898d71,0x64598ce9,0x33f183b9}},	//   zni_, rseo, _wiwi, _páxs_, 
   {{0x2d878d72,0xd7dd0560,0x7bdd0d73,0xbf9b02a5}},	//   mane_, यांच, _onsu, rhên, 
   {{0x5b158d74,0x6b828d75,0x2d878d76,0xdb0401c2}},	//   _имет, _geog, lane_, keið, 
   {{0x6d450d77,0x44320d78,0x76488008,0x25de0d79}},	//   _azha, voy_, _yhdy, खाली_, 
   {{0x44200d7a,0xa7fd0816,0x7bcb8d7b,0x2d878578}},	//   wni_, qqın, _hagu, nane_, 
   {{0x6e3c0d7c,0x44320d7d,0x59a6807a,0x7bcb8d7e}},	//   rlrb, toy_, _खातर, _kagu, 
   {{0x6b8284e0,0x44200d7f,0x3e660d80,0x61ee0d81}},	//   _xeog, uni_, _tôt_, _sobl, 
   {{0x44200d82,0x44320d83,0x61ee0d84,0x2d8785fc}},	// [5c0] rni_, roy_, _pobl, kane_, 
   {{0x7bcb80b4,0x2d878d85,0xfe9b04fc,0x7ae6810d}},	//   _lagu, jane_, _קיימ, äkti, 
   {{0x2d878d86,0x7e640008,0x44320347,0x83fc8d87}},	//   dane_, _huip, poy_, _luđa, 
   {{0xdb0401fb,0x7bcb8d88,0x44200d89,0x59e0000d}},	//   beið, _nagu, qni_, नाहर, 
   {{0xa2c1000f,0x2d8781ef,0xdd948d8a,0x779180dd}},	//   रौद्, fane_, галы, صیلا, 
   {{0x63a40d8b,0x2d878d8c,0x61ee00d7,0x683882fd}},	//   lgin, gane_, _uobl, vídu, 
   {{0x7bcb8d8d,0x6abc82f1,0xf483804a,0x69ca8d8e}},	//   _bagu, ्ट्र, ауын, _rafe, 
   {{0x63a40d8f,0x25ad0d90,0x83fc8bbe,0x69ca8d91}},	//   ngin, đeli_, _buđa, _safe, 
   {{0x5a348d92,0x2d878d93,0xf4130c2d,0x67ff00f8}},	//   лнит, bane_, יפה_, _bëjn, 
   {{0x683d0d94,0x2d878d95,0x3f848c4e,0x32058309}},	//   médi, cane_, _hemu_, ghly_, 
   {{0x3b0900e5,0x683882fd,0x7bcb8d96,0xa99b00c6}},	//   zzaq_, sídu, _fagu, וביר, 
   {{0x3f848d97,0xc05801e2,0x7bcb8d98,0x63a401f0}},	//   _jemu_, кія_, _gagu, jgin, 
   {{0x44d10d99,0x8a068d9a,0x3f848269,0x69ca8387}},	//   _są_, _изде, _memu_, _tafe, 
   {{0x7bc08d9b,0x27318028,0xb5fd843e,0xdb0401c2}},	//   lemu, ỡng_, _kuša, veið, 
   {{0x442688fb,0xdfd500b6,0xdeb2005a,0x6d5c81ac}},	//   _kjo_, _бойы, _құры, _úrad, 
   {{0x7bc08d9c,0x6aad0d9d,0x2ba689fe,0x63a40d9e}},	//   nemu, ttaf, क्चा, ggin, 
   {{0x2d878d9f,0x20190da0,0x36d50da1,0xab840762}},	// [5d0] yane_, misi_, _сопр, руск, 
   {{0x44d10da2,0xdb04007f,0x2d878da3,0x7bc08da4}},	//   _tą_, reið, xane_, hemu, 
   {{0x44268da5,0x7bc08da6,0x67d583b8,0xa37b0da7}},	//   _ojo_, kemu, ложу, _anõe, 
   {{0x2d878da8,0xf8b3896e,0x3f84861e,0x20190da9}},	//   wane_, ישע_, _cemu_, nisi_, 
   {{0x4b7a0c2d,0x539a0052,0xc2e40daa,0x2d878dab}},	//   _ראשו, _אירו, _кўри, tane_, 
   {{0xd1268dac,0x442688fb,0xa2b880c3,0x20190dad}},	//   _هم_, _ajo_, ्बन्, hisi_, 
   {{0x2d878dae,0x645d0daf,0x37ab804a,0x2baa06f4}},	//   rane_, _kisi, _отан_, ङ्का, 
   {{0x7bc08db0,0xbb458db1,0x645d0db2,0x2bda809b}},	//   gemu, лейк, _jisi, भागा, 
   {{0x20190db3,0x2d878db4,0xe3b68db5,0x4426834e}},	//   disi_, pane_, убы_, _djo_, 
   {{0xf99180fe,0x442680bb,0x6e350524,0x7bcb8c79}},	//   حبة_, _ejo_, jozb, _wagu, 
   {{0x7bcb8db6,0x20190db7,0x63a40db8,0x7c29007e}},	//   _tagu, fisi_, ygin, čerj, 
   {{0x2d858db9,0xc50c83f3,0xbb1b0166,0x7bcb8c4e}},	//   _hele_, _קלאָ, _reîn, _uagu, 
   {{0x443f8dba,0x2d858dbb,0xd24e803d,0xa3e70dbc}},	//   mlu_, _kele_, تنی_, पान_, 
   {{0x443f8dbd,0xdca60dbe,0x2d858dbf,0x645d0dc0}},	//   llu_, лаги, _jele_, _aisi, 
   {{0x69c18dc1,0x2d858dc2,0x20190dc3,0x5e5680c6}},	//   mele, _mele_, bisi_, טישע_, 
   {{0x69c18dc4,0x2d858598,0x66188524,0xeb9f072c}},	//   lele, _lele_, zivk, _smør_, 
   {{0xe2970dc5,0x645d0dc6,0x9e5a0dc7,0x443f8dc8}},	// [5e0] лат_, _disi, _проф_, ilu_, 
   {{0x645d0dc9,0x69c183c7,0x44390dca,0x3f848dcb}},	//   _eisi, nele, _eks_, _semu_, 
   {{0x443f8dcc,0x34aa0dcd,0x27e0068c,0x5a1680c6}},	//   klu_, _явно_, _knin_, נקען_, 
   {{0x69c18dce,0x2bab0dcf,0x2d8a0dd0,0x645d0dd1}},	//   hele, _छाया, labe_, _gisi, 
   {{0x69c18dd2,0xa3d783ca,0x443f8dd3,0x60060dd4}},	//   kele, ायन_, dlu_, _góme, 
   {{0x2d858cc1,0x69c18dd5,0xb5fd8131,0x7c240123}},	//   _cele_, jele, _puša, lnir, 
   {{0x3f848dd6,0x69c18dd7,0x7bc08dd8,0x2d858dd9}},	//   _temu_, dele, temu, _dele_, 
   {{0x69ce0dda,0x683d0ddb,0x68e30a6f,0x7c240ddc}},	//   _habe, pédi, ånde, nnir, 
   {{0x69ce0ddd,0x69c18dde,0x6b8603ec,0x2d8a0ddf}},	//   _kabe, fele, _mekg, kabe_, 
   {{0x69c187d2,0x7bc08de0,0x6b8601ba,0x2d858d00}},	//   gele, semu, _lekg, _gele_, 
   {{0x69ce0de1,0x443f8de2,0x7bc080e5,0x03148de3}},	//   _mabe, blu_, pemu, _तेरह_, 
   {{0x31570464,0x2d858053,0x7c240024,0x443f8de4}},	//   טיין_, _zele_, jnir, clu_, 
   {{0x69c18de5,0xa3e18808,0x20190de6,0xcaf68158}},	//   bele, दार_, risi_, _حساب, 
   {{0x20190de7,0x645d0481,0xd2508de8,0x2fcd005d}},	//   sisi_, _sisi, _بنت_, žeg_, 
   {{0x44390de9,0x6e350dea,0xab5d8208,0xe4e40deb}},	//   _pks_, rozb, reże, бітн, 
   {{0xfbdf010b,0x33750dec,0x69a70073,0x6b8600bf}},	//   _thêm_, ргар, _चाही, _cekg, 
   {{0x65950ded,0x52150dee,0x3f8b0645,0x2d8a0def}},	// [5f0] _капу, адат, macu_, babe_, 
   {{0x69ce052f,0x94750267,0x443f8df0,0xd99901ae}},	//   _cabe, _نگرا, zlu_, ئنات_, 
   {{0x69ce0df1,0x2d858206,0x443f8df2,0x44390df3}},	//   _dabe, _rele_, ylu_, _tks_, 
   {{0x2d858df4,0x69c18df5,0x8d74003d,0x3f8b0df6}},	//   _sele_, zele, _پایا, nacu_, 
   {{0x2d8581ba,0xdee58df7,0x69c18df8,0x66e58df9}},	//   _pele_, роли, yele, рола, 
   {{0x69c18dfa,0x2bda8dfb,0x69ce0dfc,0x7c958dfd}},	//   xele, _मोबा, _gabe, ариц, 
   {{0x62828dfe,0x2d858dff,0x7e718e00,0x6b860093}},	//   _awoo, _vele_, _žepč, _yekg, 
   {{0xd6f7007a,0x629b8e01,0x3f8b0e02,0x67ff016c}},	//   ुनाथ_, truo, jacu_, _bëjm, 
   {{0x69c18e03,0x443f8e04,0x4919009b,0x80048e05}},	//   tele, rlu_, _येतो_, _учре, 
   {{0x7c878e06,0x443f81fb,0x2ba78365,0xd24e80a7}},	//   _буде, slu_, _गावा, وني_, 
   {{0x443f8e07,0xd9458e08,0x61458e09,0x69c18e0a}},	//   plu_, рени, рена, rele, 
   {{0xdcfe01a8,0x79870027,0x660502ef,0x7bcf0e0b}},	//   _nepā, _lejw, _alhk, _nacu, 
   {{0x91e58e0c,0x248600e9,0x2d8a0e0d,0x09e58e0e}},	//   _воле, _ňom_, tabe_, _волн, 
   {{0x44d58e0f,0xee370e10,0x7a3002ae,0x21668537}},	//   _kā_, иня_, sätz, _киши_, 
   {{0x2d8a0e11,0x18a58e12,0x69ce0e13,0x44d580f3}},	//   rabe_, _тайм, _rabe, _jā_, 
   {{0x3ced8d99,0x44d58e14,0x2d8a0e15,0x8b260e16}},	//   _अपने_, _mā_, sabe_, адбе, 
   {{0xfaa60e17,0x69ce0e18,0xcb0000a1,0x25db82f4}},	// [600] разо, _pabe, लैंड_, _गोभी_, 
   {{0xb21b0c05,0x69ce0208,0x2d960e19,0x7bcf0e1a}},	//   _svær, _qabe, _трис, _eacu, 
   {{0x44d58e1b,0xfce60e1c,0x61fe0e1d,0x44c78019}},	//   _nā_, _тоно, rkpl, _nő_, 
   {{0x69ce0e1e,0x7bcf0e1f,0xb5fd8533,0xfaa60e20}},	//   _wabe, _gacu, _bušo, _камо, 
   {{0xdfcf80fe,0x683d00ef,0x7bc40166,0x41a68353}},	//   بين_, cédu, meiu, _खालस, 
   {{0xa61380f0,0x2888004e,0x2735012f,0xd0b302d1}},	//   оміч, _مصری_, ụng_, hşət, 
   {{0x291e00f9,0x6da38e21,0x7f498e22,0xb21b006d}},	//   _äta_, ција, _ezeq, _tvær, 
   {{0x661c0a97,0x8fa381e5,0x07a38e23,0x6d488507}},	//   hirk, _масе, _масн, _vzda, 
   {{0xe5a68e24,0x15f80a9a,0xb5fd8269,0x3f8b0524}},	//   _визи, ुसार_, _kušl, vacu_, 
   {{0x44c78019,0x99668e25,0x38600097,0x7cdc8166}},	//   _fő_, штил, _aiir_, _pără, 
   {{0x661c0e26,0x7e760e27,0x88590123,0x6aa401f0}},	//   dirk, _atyp, лиос_, huif, 
   {{0xa3d78056,0x24f581e5,0x290c8e28,0xeb978e29}},	//   ायण_, _учур, rzda_, _виц_, 
   {{0xc7b38052,0x69a701b7,0xf8b78a1c,0x661c0645}},	//   חבר_, _चाली, гөө_, firk, 
   {{0x2723801c,0x661c0e2a,0x186684c7,0x2bda8073}},	//   ằng_, girk, _књиг, _मोता, 
   {{0x40948e2b,0xedf489ca,0xe65400f0,0x7bcf0e2c}},	//   _البر, _अवैध_, івсь, _pacu, 
   {{0x3ced0024,0x539800f0,0x41a68e2d,0x672d01df}},	//   ćev_, ився_, _खाँस, _txaj, 
   {{0x99670e2e,0x7bcf0e2f,0x661c0e30,0x21670e31}},	// [610] ател, _vacu, birk, атег, 
   {{0x661c0e32,0x683d0e33,0x3d178079,0x2aaf02d1}},	//   cirk, rédu, _भइले_, rüb_, 
   {{0x7bcf0e34,0x35f8003d,0x92e700b2,0x61f8010d}},	//   _tacu, _خريد_, বনে_, övla, 
   {{0x44d58e1b,0x7bc40166,0x4e9580d8,0xf7f480df}},	//   _rā_, ceiu, مشتر, يسند, 
   {{0xa3ea8e35,0x6b8d0e36,0xd6d980a1,0x645a0e37}},	//   मान_, maag, _była_, ïtie, 
   {{0xee38836a,0x44d58e1b,0x6b8d0e38,0x80af80b2}},	//   ані_, _pā_, laag, য়িত্, 
   {{0x10a404bc,0x69c50e39,0x93fb009b,0x70940e3a}},	//   _миён, mehe, _एकाच_, _марф, 
   {{0x6b8d0e3b,0x69c50e3c,0x53c98320,0x44d58e14}},	//   naag, lehe, угим_, _vā_, 
   {{0xb5fb011e,0x6006033b,0x65958166,0xe5c78002}},	//   bpáx, _nóma, _газу, _всео, 
   {{0x44d5834a,0xa2058e3d,0x7ae984e0,0x69c50e3e}},	//   _tā_, спод, rxet, nehe, 
   {{0x3f890e3f,0x661c0e40,0x6b8d0e41,0x629d8170}},	//   _beau_, virk, kaag, ásob, 
   {{0x69c50e42,0x76438e43,0x7e69804f,0x661c01ed}},	//   hehe, llny, _kuep, wirk, 
   {{0x69c50e44,0x7e618008,0x6b8d0e45,0xaac6010c}},	//   kehe, _kilp, daag, _रैंक, 
   {{0x63a98e46,0x998580fe,0x3f9e0214,0x600601c2}},	//   lgen, _الثو, ştu_, _dóma, 
   {{0x61e38e47,0xeb9a0e48,0x63a98e49,0x764382fa}},	//   _innl, лив_, ogen, ilny, 
   {{0x644f0e4a,0x6b8d0dfe,0x78a504c2,0x60dc83cd}},	//   _chci, gaag, duhv, ærme, 
   {{0x38b18e4b,0x661c0e4c,0x63b60324,0x63a98e4d}},	// [620] lár_, pirk, rfyn, igen, 
   {{0xe3b2040c,0x69c50e4e,0xb5fd8269,0x443d81ab}},	//   _کرد_, gehe, _bušm, _lkw_, 
   {{0xa3d78e4f,0x395c0172,0x6d418e50,0x26cd81ce}},	//   ाया_, ävs_, _nyla, _aseo_, 
   {{0x20020008,0xddc281bb,0x7e618097,0xb5fd8708}},	//   nkki_, spoż, _ailp, _dušm, 
   {{0xadec0d26,0xa3e1823b,0x6d418e51,0x69c50e52}},	//   ञापन_, दाई_, _ayla, behe, 
   {{0x44d803ce,0x64440e53,0x63a98e54,0x6d418e55}},	//   _kč_, llii, egen, _byla, 
   {{0x38b18e56,0xdd998e57,0x63a98e58,0x7c290170}},	//   jár_, рші_, fgen, červ, 
   {{0x68158066,0x6d418324,0x63a98e59,0x83fc805d}},	//   ządz, _dyla, ggen, _tuđm, 
   {{0x44d806e0,0xaf068e5a,0xa3e00353,0x645c82fb}},	//   _lč_, _упал, _दफन_, _èrim, 
   {{0x60060e5b,0xd9cf00b2,0x98b88077,0xddcd0a63}},	//   _róma, রাথম, алот_, _otaš, 
   {{0x3f8900ef,0xeb9a8e5c,0x2cbe8041,0x26c0016f}},	//   _peau_, _бие_, _uptd_, _apio_, 
   {{0xfaa681e2,0x82a68e5d,0x3a3a072d,0x394281a8}},	//   _гадо, _гадж, hopp_, āks_, 
   {{0xab5d80a1,0xa3e70e5e,0x69c50e5f,0x3ea68e60}},	//   leżn, पास_, yehe, nuot_, 
   {{0x86270e61,0xddcd00a1,0x6b8d0e62,0x6e2480d8}},	//   сьме, _uważ, waag, éibh, 
   {{0x61f50e63,0x321e8e64,0x6b8d02ee,0x9f448741}},	//   _rozl, mity_, taag, _comú_, 
   {{0x321e8e65,0x69c50e66,0x93790e67,0x27e4813b}},	//   lity_, wehe, рбат_, _nnmn_, 
   {{0x6b8d0e68,0x7a3d8e69,0x69c502ae,0xfaff016c}},	// [630] raag, mètr, tehe, _afër_, 
   {{0x321e8e6a,0xddab0e6b,0x44d80246,0x32070e6c}},	//   nity_, _стил_, _fč_, óny_, 
   {{0x094b03d1,0x201d8e6d,0x6b8d0e6e,0x69c50e6f}},	//   учаи_, tiwi_, paag, rehe, 
   {{0x69c5035b,0xb8f10e70,0x64440064,0x7e618e71}},	//   sehe, _वन_, clii, _silp, 
   {{0x8d658e72,0x44290e73,0x38b18e74,0x7e698e75}},	//   овле, mna_, zár_, _quep, 
   {{0x443b0e76,0xdc998e77,0x2009011a,0x201d804f}},	//   loq_, атиш_, _llai_, siwi_, 
   {{0xd7aa0e78,0xcc868e79,0x63a98e7a,0xb5fd80d7}},	//   _कालच, обще_, tgen, _hušk, 
   {{0x5fd90e7b,0xdb0d0e7c,0x66838068,0x443b03ad}},	//   _बोलल, leañ, _فیصل, noq_, 
   {{0x44290e7d,0xab298e7e,0x23298e7f,0x7e618e80}},	//   ina_, ропа_, ропи_, _tilp, 
   {{0xb5fd803a,0x44290e81,0x63a98461,0x38b18e82}},	//   _mušk, hna_, sgen, tár_, 
   {{0x29038268,0x44290e83,0x6d418103,0xd7ea0e84}},	//   ája_, kna_, _uyla, амне_, 
   {{0xa3ea86f4,0x3ea0882b,0xb4d5812e,0x2ca78e85}},	//   माण_, šite_, िटी_, mund_, 
   {{0x7c3b8e86,0x2ca78e87,0x20020008,0x38b18e88}},	//   mour, lund_, rkki_, sár_, 
   {{0x44290e89,0x27388028,0x321e8e8a,0x44d80e8b}},	//   ena_, ứng_, city_, _pč_, 
   {{0xed5a0e8c,0x44290e8d,0x7c298e8e,0xdbc7007f}},	//   ров_, fna_, oner, töðu, 
   {{0x44290e8f,0x683601ac,0xb5fd88dc,0xf1ac0d4a}},	//   gna_, hádz, _bušk, _चाहन, 
   {{0xa3ea809b,0xdb118035,0x2ca784fb,0x6b8b8e90}},	// [640] मात_, éfèr, hund_, _megg, 
   {{0x44290e91,0x6b8b8e92,0xb5fd839f,0x44d80e93}},	//   ana_, _legg, _dušk, _tč_, 
   {{0x44290e94,0xd6d98066,0x63af036d,0x7c3b86e0}},	//   bna_, _było_, ännö, kour, 
   {{0x7c3b83e9,0x8c460e95,0x321e8e96,0x2ca786ce}},	//   jour, _феме, zity_, dund_, 
   {{0x44200e97,0xa3e7025d,0x7c3b8e98,0x2d8e8e99}},	//   mii_, पार_, dour, tafe_, 
   {{0xd49a8e9a,0x44200e9b,0x2ba80e9c,0xa6e3007f}},	//   ари_, lii_, गलवा, æðis, 
   {{0x6b8b84ef,0x25a087fa,0x1db2075c,0x798a8e9d}},	//   _begg, ğil_, _जानत, _refw, 
   {{0x44200e9e,0x2d9a0027,0xa0670123,0x25a082d2}},	//   nii_, _ldpe_, _фата_, şil_, 
   {{0x24898a5a,0x9c8780e9,0x6ab60034,0x6b8b8e9f}},	//   ćama_, _počú, ntyf, _degg, 
   {{0x44290ea0,0x44200ea1,0xdb198246,0x2ca78ea2}},	//   zna_, hii_, _pawò, bund_, 
   {{0xa3b5807a,0x44290ea3,0x6006060e,0xd8390024}},	//   _चॉक_, yna_, _cómo, luči_, 
   {{0x44290ea4,0xf1ae854d,0x7c298269,0x2d8c8ea5}},	//   xna_, ज्जन, cner, _hede_, 
   {{0x44200ea6,0x44290ea7,0x77640574,0x6e3c0ea8}},	//   dii_, vna_, държ, forb, 
   {{0x6b8b8a44,0x44290ea9,0x2d8c8eaa,0x6006011e}},	//   _zegg, wna_, _jede_, _fómo, 
   {{0x69c88eab,0xa3e7005f,0x48c500cf,0x44200eac}},	//   mede, पाल_, _এপ্র, fii_, 
   {{0x44290ead,0x44200eae,0x69c88eaf,0x3a750004}},	//   una_, gii_, lede, злар, 
   {{0x442908b6,0x443b0eb0,0xf96b0b99,0xd8390121}},	// [650] rna_, roq_, арей_, juči_, 
   {{0x44290eb1,0x7c2d80d7,0x69c88eb2,0xdb1182c0}},	//   sna_, čari, nede, éfér, 
   {{0x44200eb3,0x44290eb4,0x2d910eb5,0x683601ac}},	//   bii_, pna_, maze_, vádz, 
   {{0x2d910131,0x44200eb6,0x69c88eb7,0x98b38053}},	//   laze_, cii_, hede, žeći_, 
   {{0x6b8b8eb8,0x63ad0eb9,0x2d8c8eba,0x3f8f8ebb}},	//   _regg, mgan, _bede_, ragu_, 
   {{0x69c88ebc,0x63ad0ebd,0xe61880f0,0x2ca78ebe}},	//   jede, lgan, оді_, tund_, 
   {{0xa3d78503,0x69c88ebf,0x7c3b8ec0,0x2d8c897e}},	//   ायल_, dede, tour, _dede_, 
   {{0xb5fd8770,0x25db8ec1,0x2ca78ec2,0x13e98ec3}},	//   _muši, _गोरी_, rund_, смий_, 
   {{0x2ca78ec4,0x2d8c8ec5,0x6b8b8362,0x7c3b8123}},	//   sund_, _fede_, _vegg, rour, 
   {{0x44200012,0xddc4003a,0x2d8c8ec6,0x6b8b8ec7}},	//   zii_, _stiž, _gede_, _wegg, 
   {{0x6d450ec8,0xb5fd8ec9,0x63ad0eca,0x61f88ecb}},	//   _nyha, _nuši, kgan, _dovl, 
   {{0xdd8f8019,0x6e3c01ab,0x63ad0294,0x9c828ecc}},	//   _سوچ_, worb, jgan, áčen, 
   {{0x63bb86de,0x44200ecd,0xa2e58bc1,0x63ad0ece}},	//   mfun, vii_, _холд, dgan, 
   {{0x9c828ecf,0x2d8c0ed0,0x63bb8ed1,0x600d01b2}},	//   ščen, úde_, lfun, _rûme, 
   {{0x44200ed2,0xe166807b,0xa5070ed3,0xd9428ed4}},	//   tii_, _عضوی, пера_, _пеши, 
   {{0xc4d2896e,0xbc630ed5,0x61e70ed6,0x68fc8c18}},	//   עגן_, евск, _anjl, ärde, 
   {{0x44200ed7,0x7e6d0ed8,0x2fc002b7,0xaabd81a2}},	// [660] rii_, _guap, _ibig_, ्बिक, 
   {{0xa3e28ed9,0x44200eda,0x4a430edb,0x2d910edc}},	//   _फोन_, sii_, енув, caze_, 
   {{0x44200edd,0x38b50e87,0x2d8c8ede,0xdb1d0edf}},	//   pii_, går_, _rede_, _basó, 
   {{0xdb1d0ee0,0x83fc829f,0xde6d001c,0x35b203f0}},	//   _obsè, _tuđi, _hươn, _जाड़, 
   {{0x69d50003,0xf8a88bf5,0x6b840ee1,0x66fe0562}},	//   _faze, _कम्प, mbig, ॉनिक_, 
   {{0xd8390ee2,0x69d50ee3,0x6b840ee4,0x7c3b0e02}},	//   ruči_, _gaze, lbig, čure, 
   {{0x2d8c8ee5,0xdb0f02c0,0xe81d002a,0x63bb8ee6}},	//   _vede_, _accè, _पगला_, ffun, 
   {{0x8aa68ee7,0xde6d001c,0x69c88ee8,0x6b840ee9}},	//   прод, _lươn, wede, nbig, 
   {{0x62960eea,0x69c88eeb,0xada689b2,0xa3e18eec}},	//   nsyo, tede, _наал, दाज_, 
   {{0x63ad0eed,0xdb0d03b8,0xde6d0106,0x8afb0eee}},	//   zgan, sfaç, _nươn, צהיי, 
   {{0x6aa40eef,0x7e6d0b14,0x63ad0ef0,0xb4c80034}},	//   hrif, _suap, ygan, ोटो_, 
   {{0x6aa40ef1,0xe45a8ef2,0x62960ef3,0x4c168267}},	//   krif, _уже_, ksyo, _عباس, 
   {{0xf2068021,0x78a8806d,0x6442840a,0x7e6d0294}},	//   _няко, sudv, _ikoi, _quap, 
   {{0xa2db0ef4,0xfaa5805a,0x7afd8ef5,0x6aa4036a}},	//   निस्, _ішін, äste, drif, 
   {{0x63ad0ef6,0xde6d0028,0x69d50ef7,0x19bb8039}},	//   tgan, _dươn, _raze, _המוב, 
   {{0x6aa40324,0x6b840318,0x9c7c8131,0x2d9106c4}},	//   frif, gbig, _grče, saze_, 
   {{0x6aa40ef8,0x95cb076c,0x2ee00ef9,0xb03803dd}},	// [670] grif, _луна_, _grif_, _מנהג_, 
   {{0x38b50c3e,0xde6d001c,0x20c80efa,0xb0c8054d}},	//   tår_, _gươn, रबंध, रबंग, 
   {{0x7e7b8b66,0x6b840172,0x7fd58efb,0x29070efc}},	//   _stup, bbig, ділі, ána_, 
   {{0x2c718efd,0x29070208,0x69d5004f,0x6aa40efe}},	//   _rád_, ġna_, _waze, brif, 
   {{0xdb1d0606,0x38b50bfa,0x7c2d0eff,0x7c3f072f}},	//   _obsé, sår_, mnar, moqr, 
   {{0x6da58f00,0xde6d001c,0x64428050,0x2c718170}},	//   фика, _xươn, _akoi, _pád_, 
   {{0x2489805d,0x442f80e5,0xed568077,0x27e9034e}},	//   ćamo_, _pjg_, мош_, _onan_, 
   {{0x7c2d0f01,0xdb0f0f02,0x67d482d4,0x1b1e80b2}},	//   nnar, _accé, _посу, _পড়ে_, 
   {{0x63bb8f03,0x7c2d0f04,0xa7fd02d1,0x7bc98f05}},	//   rfun, inar, yqır, reeu, 
   {{0x27e90347,0x3eab0f06,0xb5fd8f07,0x64428122}},	//   _anan_, duct_, _aušv, _ekoi, 
   {{0x63bb8f08,0x07a60f09,0x7c2d007f,0x200d800b}},	//   pfun, манн, knar, _klei_, 
   {{0x2ee00324,0x81b580b2,0xe3b080d8,0xde6d0106}},	//   _prif_, _চোখ_, _مره_, _sươn, 
   {{0xa3ea8f0a,0x7c2d0bfc,0xe28e8f0b,0x443f8f0c}},	//   मार_, dnar, _ша_, mou_, 
   {{0x64498f0d,0x200d80a6,0x27e9034e,0x7c2d0f0e}},	//   llei, _llei_, _enan_, enar, 
   {{0x442d8021,0xe1f08f0f,0x3eb9063c,0x9d430f10}},	//   one_, _حسن_, atst_, верд, 
   {{0x443f8f11,0x7c2d0f12,0x64498ec4,0x9c7c8f13}},	//   nou_, gnar, nlei, _urče, 
   {{0x442d8f14,0xe1fa0f15,0xde6d0028,0x6b840f16}},	// [680] ine_, ога_, _tươn, rbig, 
   {{0x6aa40f17,0x443f8f18,0x6b8408c6,0x2b8c0028}},	//   rrif, hou_, sbig, ếc_, 
   {{0x443f8f19,0x442d8578,0x851c810c,0x64498f1a}},	//   kou_, kne_, _भेंट_, klei, 
   {{0x442d8f1b,0xa2db0611,0x798e00d0,0x443f8f1c}},	//   jne_, निश्, _webw, jou_, 
   {{0x442d8033,0x443f8f1d,0xee3a8f1e,0x7c240640}},	//   dne_, dou_, онд_, miir, 
   {{0xa2db0f1f,0x64498461,0x6e23812f,0xb81405a2}},	//   निर्, elei, ginb, াচিত_, 
   {{0x443f8f20,0xa3ea8f21,0x3e74010d,0x1dc00f22}},	//   fou_, माल_, _lät_, श्यत, 
   {{0x442d8f23,0xe73a8daa,0x443f8ed0,0x68e30142}},	//   gne_, _деб_, gou_, ænde, 
   {{0x61fc0f24,0x6e238f25,0x3e74010d,0x3f868f26}},	//   _korl, binb, _nät_, mbou_, 
   {{0x442d8f27,0x4efb8309,0x64498656,0x3f868f28}},	//   ane_, _והמו, alei, lbou_, 
   {{0x443f8f29,0x85068f2a,0x442d8f2b,0x25eb8f2c}},	//   bou_, _توان, bne_, चारी_, 
   {{0x443f8f2d,0x3f868f2e,0x62808f2f,0x60320f30}},	//   cou_, nbou_, ppmo, tāma, 
   {{0x61fc00d0,0x64408f31,0x2bdf00da,0x7c2d024a}},	//   _oorl, momi, _पोषा, vnar, 
   {{0x8a038086,0x61fc0f32,0x603201a8,0x600d0610}},	//   _изче, _norl, rāma, _dûma, 
   {{0x92bb0a87,0x443f001c,0x69d880de,0x7c240f33}},	//   _আছে_, _ưu_, _iave, fiir, 
   {{0x27e90f34,0x38b88f35,0xfc300f36,0x69da8f37}},	//   _unan_, mér_, لحق_, ldte, 
   {{0xa3b68611,0x69d88f38,0x61fc0f39,0x9f6482a5}},	// [690] _जान_, _kave, _borl, ştên_, 
   {{0x443f8f3a,0x442d8f3b,0x69da8f3c,0x64408f3d}},	//   zou_, zne_, ndte, homi, 
   {{0x442d8f3e,0x64408f3f,0x69d88f40,0xe7e40076}},	//   yne_, komi, _mave, गाचा_, 
   {{0x44248053,0x27e98f41,0x69d88255,0x443f8569}},	//   jim_, ñan_, _lave, xou_, 
   {{0x442d8f42,0x443f8f43,0x9f4087e9,0x61fc0f44}},	//   vne_, vou_, ðið_, _forl, 
   {{0x7bc2804d,0x442d8066,0x7cd3808a,0x61fc0f45}},	//   _abou, wne_, _hərə, _gorl, 
   {{0x443f8f46,0x442d8f42,0x60060013,0x44248f47}},	//   tou_, tne_, _fómh, fim_, 
   {{0x442d8012,0x200d8123,0x61ea8f48,0x64408f49}},	//   une_, _ulei_, _anfl, gomi, 
   {{0x442d8f4a,0x64498362,0x63a68f4b,0x0e358f4c}},	//   rne_, rlei, ókna, _знаю, 
   {{0x443f83b9,0x442d8f4d,0xe1f18013,0x9c828f4e}},	//   sou_, sne_, اسة_, ščan, 
   {{0xd8260af4,0x60260d74,0x38690f4f,0x69d88f50}},	//   едни, една, _biar_, _dave, 
   {{0x64408f51,0x7ae28f52,0xa3b68f53,0x61ea8f54}},	//   comi, _frot, _जाय_, _enfl, 
   {{0x7ae28f55,0x7bcd0f56,0x7c240f57,0x69d88f58}},	//   _grot, deau, viir, _fave, 
   {{0x69d88f59,0xa3d78f5a,0x38b88f5b,0xb5fd85a7}},	//   _gave, ायक_, bér_, _gušt, 
   {{0x7bd98f5c,0x7c240f5d,0x1b1d00b2,0xd00a0f5e}},	//   _kawu, tiir, _ভুলে_, _неке_, 
   {{0x69d88f5f,0xe73a0008,0x7bcd068e,0xb60201d2}},	//   _zave, _ней_, geau, _žádo, 
   {{0x7c240f60,0xf41280c6,0x60060f61,0x7cd3808a}},	// [6a0] riir, אפן_, _nómi, _dərə, 
   {{0xe9d70f62,0x7c3b0f63,0x68e38f64,0x5fc1001b}},	//   нку_, čura, _krnd, ष्ठल, 
   {{0xa3ea038f,0x7c240f65,0x44248f66,0x61fc01ed}},	//   _една_, piir, yim_, _vorl, 
   {{0x44248f67,0x61fc0052,0xfbae8693,0x7cd382d1}},	//   xim_, _worl, _टाइम, _gərə, 
   {{0xa3b685d9,0x64408004,0x6006060e,0x64460004}},	//   _जाब_, vomi, _cómi, _ikki, 
   {{0x44248f68,0xf2d30080,0x7ae2816c,0x7cd382d1}},	//   wim_, _געש_, _rrot, _zərə, 
   {{0x8fa681e2,0x7c2f00fe,0x39e70f69,0x9c7c8770}},	//   _паве, _áirí, _ядро_, _brča, 
   {{0x6d488f6a,0xb5fd8f6b,0xd9430f6c,0x961d0f5a}},	//   _vyda, _sušt, _сеси, _नष्ट_, 
   {{0x44248f6d,0xb5fd803b,0x64408f6e,0x69d88f6f}},	//   rim_, _pušt, romi, _pave, 
   {{0x38690b10,0x64408f70,0x38b88f71,0x7afd8f72}},	//   _siar_, somi, tér_, ästa, 
   {{0x7ae28f73,0x0b8a825b,0x64a38f74,0x290a8019}},	//   _wrot, _если_, _баха, ába_, 
   {{0x7ae28f75,0x2c750f76,0x68e38885,0x929d8034}},	//   _trot, _råd_, _drnd, syła, 
   {{0x7bcd0f77,0x38b88f78,0x7ae28f79,0x386900db}},	//   veau, sér_, _urot, _viar_, 
   {{0x61ea817c,0x8cd78f7a,0x44220f7b,0x290581d2}},	//   _unfl, _मनमो, _amk_, byla_, 
   {{0x248d003a,0x7bcd0f7c,0x7bd98f7d,0xf8a48f7e}},	//   ćemo_, teau, _yawu, _खटिय, 
   {{0x59c600da,0x6b9602b1,0x60c700db,0x21030033}},	//   _रॉबर, gayg, _rpjm, nčiť_, 
   {{0x6b848073,0x2bc2809b,0xfbc28f7f,0x7bcd0f80}},	// [6b0] _õigu, व्या, व्यम, reau, 
   {{0x7bcd0f81,0xa2a70f82,0x2bcf0034,0x21030033}},	//   seau, _चिठ्, हजहा, hčiť_, 
   {{0x7cd3808c,0x5f958f83,0x6b9604da,0x7c228f84}},	//   _tərə, виет, bayg, _omor, 
   {{0xfbab0008,0x9f49068e,0x629d8063,0x3869810d}},	//   _этой_, _anaé_, ások, öar_, 
   {{0x62830025,0x644d0f85,0x79a70a6a,0x6aad02fb}},	//   ćnos, mlai, _прве, quaf, 
   {{0x9c7c8024,0x2ab98246,0x62500079,0x644d0f86}},	//   _srča, vèb_, näol, llai, 
   {{0xda3401bc,0x644d0f87,0xdce180a1,0x9c7c8a63}},	//   _серы, olai, _oglą, _prča, 
   {{0x644d0f88,0x8ca286d7,0x69c380db,0x0ae98103}},	//   nlai, _गिरो, _sbne, ддий_, 
   {{0x9f34804a,0x65c3804a,0x7bdb8f89,0x69c10f8a}},	//   _беті, _бұла, rduu, र्थी, 
   {{0x2fcf80f0,0x644d0caf,0x7bd98f8b,0x7c228f8c}},	//   legg_, hlai, _wawu, _emor, 
   {{0x76438f8d,0x9c7c805d,0x644d0f8e,0x7bd98f8f}},	//   mony, _trča, klai, _tawu, 
   {{0x76438f90,0x645a0162,0x9c7c8f91,0x27ff817c}},	//   lony, įtik, _krčn, _joun_, 
   {{0xa3b68f92,0x27ff8f93,0x9aa48f94,0xe9ce8f95}},	//   _जात_, _moun_, _ممنو, _кк_, 
   {{0x44220363,0xed5a0f96,0x56930103,0x7c228f97}},	//   _smk_, дог_, раёт, _zmor, 
   {{0x442200db,0xdcfc00f3,0x27ed8f98,0x629b8162}},	//   _pmk_, varē, _onen_, lsuo, 
   {{0x644d0f99,0x7ae9005d,0x76438232,0x6b898f9a}},	//   glai, _šeta, hony, nbeg, 
   {{0xee3a0f9b,0xab270327,0xe9da0f9c,0x76438f9d}},	// [6c0] _они_, вота_, мка_, kony, 
   {{0x644d0f9e,0x69c18f9f,0x5ac70974,0x6b898fa0}},	//   alai, nfle, ълум_, hbeg, 
   {{0x2d980fa1,0x76438fa2,0x644d0fa3,0x44220fa4}},	//   mare_, dony, blai, _tmk_, 
   {{0x2d980fa5,0x644d0fa6,0x629b8162,0x6aa987c5}},	//   lare_, clai, ksuo, kref, 
   {{0x76438fa7,0x44320fa8,0x37dc05a2,0x2a6a02d1}},	//   fony, mny_, ধাপর, _tibb_, 
   {{0xa2a70fa9,0x4432099a,0x2d980faa,0x7c228fab}},	//   _चित्, lny_, nare_, _smor, 
   {{0x44320fac,0x61ee010d,0x69dc0fad,0xb5fc81bb}},	//   ony_, _inbl, _iare, _jiġi, 
   {{0x44320fae,0x64598faf,0x69dc0fb0,0x2d980fb1}},	//   nny_, _chwi, _hare, hare_, 
   {{0x69dc0fb2,0x2d980fb3,0x518682d4,0x76438fb4}},	//   _kare, kare_, куна, bony, 
   {{0x69dc0fb5,0x2d980fb6,0x2bae809b,0x2a6a8063}},	//   _jare, jare_, _टाका, öbb_, 
   {{0x25db807a,0x2d9808b6,0x27ff8246,0x26c90183}},	//   _गोटी_, dare_, _youn_, _spao_, 
   {{0x27ed0818,0x44320fb7,0x2d930fb8,0x032685e9}},	//   ñen_, jny_, _sexe_, _иден, 
   {{0x44320fb9,0x34cb09ca,0xa2c4805a,0x2d9802fb}},	//   dny_, ाब्द, _сәйк, fare_, 
   {{0x69dc0fba,0xb8828fbb,0x2d98009a,0xc0aa842b}},	//   _nare, üíst, gare_, _قابل_, 
   {{0x6d400fbc,0xdd940fbd,0x5a350fbe,0x20d38c85}},	//   şman, расы, ҳнат, _نتيج, 
   {{0x76438fbf,0xec340fc0,0x44320fc1,0x6115004a}},	//   zony, ансь, gny_, ңдау, 
   {{0x2d980fc2,0x644d0fc3,0x81d580cf,0x26c9068b}},	// [6d0] bare_, rlai, হার_, _upao_, 
   {{0x2d980fc4,0x44320fc5,0x69dc0fc6,0x61ee00db}},	//   care_, any_, _care, _cnbl, 
   {{0x69dc0fc7,0x99670fc8,0x26080066,0xada58974}},	//   _dare, ттал, _सकती_, ҳалл, 
   {{0x63a28fc9,0x3f990fca,0xac1900f0,0xa283003d}},	//   _ndon, nasu_, _чому_, _نیرو, 
   {{0x44290fcb,0x501c0fcc,0xf7708743,0xe5a58537}},	//   mia_, וואו, زان_, гили, 
   {{0x44290fcd,0x69dc0fce,0x627280a1,0xdce8808a}},	//   lia_, _gare, _młod, _addı, 
   {{0x7bdd0fcf,0x6b898770,0x25a983d2,0x5e5800c6}},	//   _kasu, tbeg, ğal_, דיגע_, 
   {{0x44290fd0,0x2d980012,0x6aa98fd1,0xa3ea800f}},	//   nia_, zare_, tref, माग_, 
   {{0x7bdd0fd2,0x2d980fd3,0x76438fd4,0x69dc01d7}},	//   _masu, yare_, pony, _yare, 
   {{0x44290fd5,0x386d8fd6,0x6aa98fd7,0x61138816}},	//   hia_, _hier_, rref, lələ, 
   {{0x44290fd8,0x2d980fd9,0x44320066,0xbef3807a}},	//   kia_, vare_, yny_, _आपुन_, 
   {{0x7bdd0fda,0x44290c2f,0x98160158,0x6aa98fdb}},	//   _nasu, jia_, ابدا, pref, 
   {{0x2d980fdc,0xfaa58fdd,0x4432003e,0x7ae9005d}},	//   tare_, _сало, vny_, _šetn, 
   {{0x443200a1,0x3e798246,0x6113808a,0x98e580fe}},	//   wny_, _mèt_, hələ, _مكتو, 
   {{0x2d980faa,0x61138816,0x44e38fde,0x3f990fdf}},	//   rare_, kələ, _jı_, basu_, 
   {{0x44290fe0,0x69dc0fe1,0x2d980fe2,0x44e387fa}},	//   gia_, _sare, sare_, _mı_, 
   {{0x79950246,0x4432099a,0x2d980fe3,0x3e7986e0}},	// [6e0] _bezw, rny_, pare_, _nèt_, 
   {{0x7c298fe4,0x44290fe5,0x44320fe6,0x613a0fe7}},	//   hier, aia_, sny_, нчер_, 
   {{0x69dc0fe8,0x386d8fe9,0x6113808a,0x7c298fea}},	//   _vare, _bier_, fələ, kier, 
   {{0xe73a836d,0x765a80f8,0xb8dc03b4,0x3e798246}},	//   нее_, _shty, _आम_, _bèt_, 
   {{0x69dc0feb,0xadf08fec,0x539b0039,0x386d8fed}},	//   _tare, चालन_, _איכו, _dier_, 
   {{0x61460fee,0x38bc0fef,0x44e38ff0,0x386d8ff1}},	//   _бега, pír_, _bı_, _eier_, 
   {{0x7c298ff2,0x386d8ff3,0xa3bb0ff4,0x44e3808a}},	//   fier, _fier_, _घाम_, _cı_, 
   {{0x7c298ff5,0x3e798206,0x61138816,0x33748ff6}},	//   gier, _fèt_, cələ, шгир, 
   {{0x66018ff7,0x52148ff8,0xe7378ff9,0x7ae40dd9}},	//   _folk, идит, _бет_, nvit, 
   {{0x44290ffa,0xddcd0ffb,0x66018ffc,0xa3b68073}},	//   zia_, _staž, _golk, _जाव_, 
   {{0x7c298ffd,0x7c260ffe,0x41c60693,0x7f4d00e5}},	//   bier, _omkr, र्यस, _syaq, 
   {{0x7c298fff,0x44291000,0xaae69001,0x386d010d}},	//   cier, xia_, _مستو, öer_, 
   {{0x7bdd1002,0x44269003,0x6d4003d2,0x95cb1004}},	//   _rasu, _imo_, şmal, нува_, 
   {{0x442681c8,0x44291005,0x7bdd1006,0x2731801c}},	//   _hmo_, wia_, _sasu, ạng_, 
   {{0x44291007,0x317b8115,0x3ea01008,0x7cca8816}},	//   tia_, _ארומ, _evit_, _hərb, 
   {{0xb4c50073,0x799a9009,0x3a380050,0x600601c2}},	//   _एही_, latw, _ajrp_, _dóms, 
   {{0x59c603ff,0xaed50103,0xafdb03cd,0x7bdf100a}},	// [6f0] र्भर, _топш, sløs, rdqu, 
   {{0x4429100b,0x7c29900c,0x386d836a,0x7bdd100d}},	//   sia_, zier, _sier_, _wasu, 
   {{0x7bdd0073,0x60138646,0x3e7986e0,0x6113808a}},	//   _tasu, _açma, _sèt_, tələ, 
   {{0xb4fa07a6,0x20da8081,0x2ee903bf,0x4773804a}},	//   _ספרי, mšić_, _kraf_, сқау, 
   {{0x6b8d100e,0x386d850a,0x7c29900f,0x539a0039}},	//   mbag, _vier_, vier, _בירו, 
   {{0x6b8d1010,0x7c298066,0x61138816,0x69c70593}},	//   lbag, wier, sələ, _ubje, 
   {{0x66018461,0x7c299011,0x44391012,0x2019040a}},	//   _volk, tier, _kjs_, khsi_, 
   {{0x3e798206,0x66019013,0x6113808a,0x6b8d1014}},	//   _tèt_, _wolk, qələ, nbag, 
   {{0x7c299015,0x2bc7009b,0xa3b69016,0x21f587c5}},	//   rier, ऱ्या, _जार_, аїнс, 
   {{0x7c299017,0x20da8131,0x42259018,0x5ec880b2}},	//   sier, kšić_, рдов, লিশে, 
   {{0x63b600ce,0x2bc2809b,0x3ea01019,0x5bb9901a}},	//   ygyn, व्हा, _svit_, _алея_, 
   {{0x4426901b,0xa4fa80c6,0x6aad101c,0x50460166}},	//   _gmo_, _בלעט, kraf, ремб, 
   {{0x1f5601bc,0x636b83d2,0x799a901d,0x41c6101e}},	//   ртнё, _dönü, batw, र्डस, 
   {{0x91fc834a,0x81ab00cf,0x6289901f,0x2fdf806c}},	//   rmāc, ক্ত_, mpeo, _laug_, 
   {{0x3b961020,0xe94681a1,0xdca30103,0x8b960cc5}},	//   ијат, _پروی, жаси, ирач, 
   {{0x3ea08131,0xf814007b,0xb3860166,0xafdb072c}},	//   šiti_, _دستگ, рлал, slør, 
   {{0xd4671021,0xb2261022,0xada61023,0xa3d686d7}},	// [700] рите_, амал, _капл, ाजत_, 
   {{0x7ae41024,0x27e01025,0x260602fd,0x6b9b9026}},	//   rvit, _hain_, _vôos_, haug, 
   {{0x27e005b5,0x2fdf9027,0xdb0d0170,0x6b9b9028}},	//   _kain_, _baug_, čkác, kaug, 
   {{0x2fdf806c,0xbc7b0039,0xebe61029,0xe3b2102a}},	//   _caug_, _שנכת, _томп, _برد_, 
   {{0x2fdf81e2,0x27e0102b,0xa3bb102c,0x6b9b902d}},	//   _daug_, _main_, _घात_, daug, 
   {{0x27e0102e,0x7ae480fe,0x7aeb006d,0x44d8034e}},	//   _lain_, _áiti, ægte, _kō_, 
   {{0xd49780cd,0xa0a302d4,0x10a3102f,0x18a31030}},	//   ары_, _мард, _мирн, _марм, 
   {{0xa6869031,0xeca79032,0x27e01033,0xa3c91034}},	//   _влад, _गिरफ, _nain_, ल्प_, 
   {{0x9c7c861c,0xf1c60b30,0x41c60b36,0x7cca82d1}},	//   _krčk, र्थन, र्थस, _qərb, 
   {{0x1db2009b,0x2fdf81c8,0x64a69035,0x3878016c}},	//   _जागत, _zaug_, _важа, _kurr_, 
   {{0x27e01036,0x44d8034e,0x2d9c80f8,0xe3ba8591}},	//   _bain_, _nō_, mave_, _абе_, 
   {{0xf1c6000d,0x2d9c9037,0x7c3b0c61,0x62860131}},	//   र्तन, lave_, čurk, _otko, 
   {{0x27e01038,0x799a8ca2,0xc98683ad,0xeafa81fa}},	//   _dain_, patw, _куйи, _جرات_, 
   {{0x2d9c9039,0xa3b6903a,0xa3c9001b,0x6aad02fb}},	//   nave_, _जाँ_, ल्न_, vraf, 
   {{0x69ca81df,0x4439103b,0xf8da80c9,0x6286103c}},	//   _ibfe, _pjs_, _बनिय, _atko, 
   {{0x2004903d,0x6aad103e,0x79988610,0x25ad103f}},	//   _nomi_, traf, _hevw, şel_, 
   {{0x6b8d1040,0x9c7c9041,0x81e000cf,0x2fdf81ea}},	// [710] rbag, _brčk, থান_, _raug_, 
   {{0xd9991001,0x98da878b,0xf8da80a1,0x80da8b45}},	//   انات_, _बनाए, _बनाय, _बनाइ, 
   {{0x50678004,0x2fdf827e,0x29070166,0x2d9c9042}},	//   атда, _paug_, âna_, dave_, 
   {{0x6aad002d,0x2ef59043,0x2fdf806c,0x6289839d}},	//   praf, йзер, _qaug_, ypeo, 
   {{0x20049044,0x7c2d1045,0xdee59046,0x6d5a9047}},	//   _domi_, miar, соли, _azta, 
   {{0x9c7c803a,0x929d80a1,0x2d9c9048,0x41c600c9}},	//   _grčk, syłk, gave_, र्दस, 
   {{0x387800bc,0x2fdf81c8,0x20049049,0x6b9b904a}},	//   _gurr_, _taug_, _fomi_, taug, 
   {{0xf77f8180,0x2d828019,0xf5380039,0xa95407c5}},	//   _üç_, _őket_, ינוי_, _єкті, 
   {{0xa3c9104b,0x3f15904c,0x6d5a8109,0x6b9b904d}},	//   ल्य_, _удас, _ezta, raug, 
   {{0x6b9b81e2,0xe1f9904e,0x752800a1,0x27e0104f}},	//   saug, уго_, ździ, _sain_, 
   {{0x7c2d0109,0xd24e803d,0x20049050,0x7c361051}},	//   kiar, رچه_, _yomi_, ynyr, 
   {{0xa3c91052,0x60061053,0x96ba1054,0x9f0600d8}},	//   ल्म_, _cómp, лугу_, موجو, 
   {{0x27e0036d,0x91e5838f,0x201e01e2,0xdce382bc}},	//   _vain_, _голе, ėti_, manı, 
   {{0x442d9055,0xdce38186,0x26c21056,0x44d8017c}},	//   lie_, lanı, rtko_, _pō_, 
   {{0x26c20066,0xf004005a,0x27e01057,0x94791058}},	//   stko_, _дүни, _tain_, исту_, 
   {{0x442d9059,0x2d9c905a,0x7c2d105b,0xdce383d2}},	//   nie_, zave_, giar, nanı, 
   {{0x38a3846b,0x63a6905c,0xb344008a,0x7c360162}},	// [720] lır_, ókni, _keçə, rnyr, 
   {{0x81ab00cf,0x442d905d,0x9c828bfc,0xc30180b2}},	//   ক্স_, hie_, ščin, এনপি_, 
   {{0x442d905e,0x999a896e,0x38a38186,0xdce38085}},	//   kie_, רבעט, nır_, kanı, 
   {{0x442d905f,0x68fc810d,0x2d9a1060,0xa3b682f4}},	//   jie_, ärdi, _hepe_, _जाइ_, 
   {{0x442d9061,0x2d9c9062,0x3ea21063,0x9c7c80d4}},	//   die_, tave_, nskt_, _trčk, 
   {{0x6b828086,0x6e2e0208,0x38a382d2,0x27e09064}},	//   _sfog, nibb, kır_, žin_, 
   {{0x2d9c9065,0xdcfc00f3,0x557700c6,0x7aeb9066}},	//   rave_, darī, זעצן_, _argt, 
   {{0x442d9067,0x38a39068,0x2d9c9069,0x6d5a801b}},	//   gie_, dır_, save_, _vzta, 
   {{0xa3bb01b7,0x38668172,0x34d40056,0x2d9c906a}},	//   _घास_, mmor_, दबुद, pave_, 
   {{0x7c2d106b,0x442d906c,0x3860106d,0x38a382d2}},	//   ziar, aie_, _ahir_, fır_, 
   {{0x442d906e,0x1958906f,0x2bca836a,0x66050a2f}},	//   bie_, раны_, _було_, _rohk, 
   {{0x442d9070,0x28a99071,0x39570039,0x38601072}},	//   cie_, _किरि, משים_, _chir_, 
   {{0x7c2d1073,0x291e9074,0x799e1075,0x6e2e0036}},	//   viar, szta_, kapw, fibb, 
   {{0xdb0d03b8,0x2d9a1076,0xe84c01d2,0x6e2e0399}},	//   lgaç, _cepe_, ětší, gibb, 
   {{0x7c2d1077,0x2d9a097e,0xe65400f0,0x38600c8c}},	//   tiar, _depe_, ївсь, _fhir_, 
   {{0x388101e2,0xc9588004,0x9f3502c3,0x69c88a91}},	//   _nėra_, _йўқ_, _мейі, lfde, 
   {{0x7c2d0124,0x99991078,0xa3b68689,0x24580008}},	// [730] riar, икат_, _जाई_, сать_, 
   {{0x442d9079,0x6fb5042b,0x7c2d107a,0xdce38a08}},	//   zie_, _امکا, siar, zanı, 
   {{0xdce3907b,0xa25b0038,0x442d834e,0x9f52044e}},	//   yanı, _spôs, yie_, _anyè_, 
   {{0x9f55847d,0x9c7c907c,0x28ba03ca,0x6449811e}},	//   овеч, _grči, _उमरि, xoei, 
   {{0x442d907d,0x38a38085,0xdce388f1,0x81ab00b2}},	//   vie_, zır_, vanı, ক্ষ_, 
   {{0x442d907e,0x7aed805d,0xd9fd0611,0x38a3907f}},	//   wie_, _šato, _उचित_, yır_, 
   {{0x442d9080,0xdce387de,0xed599081,0x69d71082}},	//   tie_, tanı, шок_, mexe, 
   {{0x7cca8816,0x52a99083,0xd7f8855a,0x3ea206a0}},	//   _qəra, авим_, _луу_, yskt_, 
   {{0x28e1007a,0x2d8300a1,0xdce38085,0x442b1084}},	//   फिकि, kcje_, ranı, _mmc_, 
   {{0x442d9085,0x38601086,0x38a385ee,0x88c98008}},	//   sie_, _shir_, tır_, алов_, 
   {{0x442d9087,0xdce3838e,0x61e50015,0x64499088}},	//   pie_, panı, idhl, poei, 
   {{0xa3b69089,0xb901908a,0xa2b28365,0x38a38085}},	//   _जाए_, _नई_, _आमच्, rır_, 
   {{0xf77207db,0x2d9a108b,0x38a38214,0xe299908c}},	//   باد_, _pepe_, sır_, _тал_, 
   {{0x63bb908d,0x5fdc108e,0x7ae98232,0x3ea2108f}},	//   lgun, _बसवल, mvet, rskt_, 
   {{0xc5f28039,0x7c3a1090,0x201d8531,0x69d71091}},	//   ודם_, étro, khwi_, dexe, 
   {{0x3ead1092,0x26df8a63,0x69de9093,0x6e2e1094}},	//   šeta_, _osuo_, _óper, sibb, 
   {{0x61e39095,0xa2061096,0x9c7c8183,0x81dc80b2}},	// [740] _kanl, опад, _isče, ডার_, 
   {{0xe1f71097,0x63bb9098,0xe24600d8,0x7ae99099}},	//   огу_, hgun, آخري, ivet, 
   {{0x6026909a,0x3207840a,0x9c7c8998,0xe0da109b}},	//   оджа, _mony_, _trči, рве_, 
   {{0xb8f20d99,0x9c7c803e,0x2eed909c,0x46ea909d}},	//   _वह_, _urči, _bref_, иден_, 
   {{0xfe468188,0x38668bfa,0x0aa3004a,0xe666909e}},	//   ондо, rmor_, _оңтү, отко, 
   {{0x6ce589d7,0x0caa909f,0xb0a98562,0x7ae98172}},	//   किंग_, атии_, _किंग, dvet, 
   {{0x90c310a0,0xa3d6802a,0x7bc990a1,0x9f4501d2}},	//   _обре, ाजल_, ffeu, ělé_, 
   {{0x799c10a2,0x61e380d0,0x87b984bc,0x2fc001c8}},	//   _herw, _aanl, _гуфт_, _ncig_, 
   {{0xada681e5,0x8af78816,0x6d4190a3,0x61e390a4}},	//   _маал, _şərh, _exla, _banl, 
   {{0x61e390a5,0x32188066,0x7ae48265,0x799c0027}},	//   _canl, óry_, _šits, _jerw, 
   {{0x63bb8109,0x320790a6,0x799c06a4,0xb97b04fc}},	//   bgun, _dony_, _merw, יניי, 
   {{0x68e30142,0x27e690a7,0x69ca10a8,0x81c205a2}},	//   ændi, ndon_, स्ती, ্যি_, 
   {{0xb90183ce,0x26c690a9,0x09e6828e,0x73368019}},	//   _नै_, ntoo_, _модн, _برائ, 
   {{0xd344807b,0x63a090aa,0x645a01b2,0x61e3811a}},	//   _ویژه_, lamn, îtin, _ganl, 
   {{0x81c200cf,0x70c90079,0x80c90034,0x27e68128}},	//   ্যা_, _रहेल, _रहें, kdon_, 
   {{0x27e4809a,0x320790ab,0xe3ac80b2,0xb86710ac}},	//   _namn_, _zony_, ক্রব, _باتو, 
   {{0xd7630c0b,0x799c10ad,0xa3cc8b30,0x0dcb0004}},	// [750] _تنظی, _berw, श्य_, _куни_, 
   {{0x3eb910ae,0xaaac10af,0x63a090b0,0x51f80994}},	//   must_, _चिरक, hamn, оную_, 
   {{0x21270147,0x799c10b1,0x69d710b2,0x3eb90079}},	//   ành_, _derw, rexe, lust_, 
   {{0x69d710b3,0x69ce10b4,0x60c5043a,0x6b8402fb}},	//   sexe, _ebbe, rthm, ccig, 
   {{0xd6db90b5,0x799c10b6,0x51870014,0x69d710b7}},	//   рте_, _ferw, _мува, pexe, 
   {{0xc27a0039,0x95cb90b8,0x62728034,0x7ae982d2}},	//   _לרשי, руда_, _słon, vvet, 
   {{0x1c0f0a29,0x91fc80f3,0x63bb90b9,0x6b9d04da}},	//   _सवाल_, rmāl, tgun, _kesg, 
   {{0xd7c9803d,0x61e390ba,0x709504bc,0x3eb90079}},	//   _دوره_, _sanl, _маҳф, kust_, 
   {{0x63bb90bb,0x9f34805a,0x61e390bc,0xeab180d8}},	//   rgun, _жеті, _panl, رعة_, 
   {{0x2ea806d7,0x660890bd,0x3eb910ae,0xa92590be}},	//   _कटौत, _godk, dust_, здол, 
   {{0x7ae990bf,0x61e390c0,0xf1b200c6,0xa3bb8139}},	//   svet, _vanl, עסט_, _ناشر_, 
   {{0x63a090c1,0xb4e78562,0x22808246,0x54378139}},	//   camn, यटी_, _fòk_, _برطر, 
   {{0xa3e610c2,0xe73710c3,0xe80390c4,0x61e38004}},	//   _योग_, зея_, _रचना_, _tanl, 
   {{0xa3c910c5,0x321e90c6,0x3e6086e0,0x59c290c7}},	//   ल्स_, chty_, pòte_, _शायर, 
   {{0xed5a10c8,0x1828003d,0x7aef10c9,0x27e690ca}},	//   сов_, _وقتی_, _arct, ydon_, 
   {{0x799c0d99,0xdb0081b2,0x7c3b90cb,0x6b9d10cc}},	//   _serw, damê, nnur, _cesg, 
   {{0x0b4310cd,0x799c10ce,0x3cdd8066,0x934310cf}},	// [760] ентн, _perw, _कैसे_, енте, 
   {{0x6aa40058,0x6b8410d0,0x09e310d1,0xe47607e4}},	//   rsif, scig, ноун, _нумэ, 
   {{0x799c10d2,0x63a090d3,0x6b9d0065,0xa806011e}},	//   _verw, yamn, _fesg, _gañá, 
   {{0x628110d4,0xdcf500a1,0x799c10d5,0x798510d6}},	//   _člov, jczę, _werw, achw, 
   {{0x799c10d7,0x44320daa,0x660890d8,0x27e690d9}},	//   _terw, miy_, _podk, rdon_, 
   {{0xe3c40a1c,0xd49a90da,0x44320004,0x26c68008}},	//   _эрүү, бри_, liy_, rtoo_, 
   {{0xdb00824a,0x39a68013,0x628b843a,0xa3c90353}},	//   camê, hísí_, _atgo, ल्व_, 
   {{0xafe390db,0x44320004,0x442010dc,0x320a10a6}},	//   _посл, niy_, nhi_, _hoby_, 
   {{0x442010dd,0x27f7800d,0x2bce009b,0xa0678994}},	//   ihi_, šení_, ह्या, _хата_, 
   {{0x59cf009b,0xe8e00106,0x3eb90079,0x7de580fe}},	//   स्पर, _nhịp_, vust_, _يسلم, 
   {{0x442010de,0x69bd8f5a,0x69c10f8a,0x3eb900fa}},	//   khi_, _शारी, र्टी, wust_, 
   {{0x442010df,0x3eb90073,0x29028284,0x44320103}},	//   jhi_, tust_, ćka_, jiy_, 
   {{0x442010e0,0x2d9e8210,0x44320004,0x6b9d10e1}},	//   dhi_, _kete_, diy_, _resg, 
   {{0x99ce00cf,0x2d9e90e2,0x2b09801b,0x6b9d016f}},	//   রযুক, _jete_, िहरु_, _sesg, 
   {{0x2d9e8206,0x61f88387,0x44320103,0x3eb90079}},	//   _mete_, _invl, fiy_, sust_, 
   {{0x69da90e3,0x3eb910e4,0x442010e5,0x5c7410e6}},	//   lete, pust_, ghi_, елст, 
   {{0x3eb910e7,0x3a750103,0x78ba90e8,0x644d10e9}},	// [770] qust_, длар, lutv, roai, 
   {{0x4420068e,0x2d9e83ec,0xdce70214,0x216710ea}},	//   ahi_, _nete_, sajı, птег, 
   {{0x02d983ce,0x77610816,0x443210eb,0x798510ec}},	//   _भन्न, əlxa, biy_, rchw, 
   {{0x442010ed,0x69da90ee,0x798502ae,0x98c5829f}},	//   chi_, hete, schw, žući_, 
   {{0xa2a700d5,0x69da90ef,0x2d9e8109,0x601f00f8}},	//   _चिट्, kete, _bete_, _këmb, 
   {{0x2d9e8053,0x69da90f0,0x7bcd10f1,0x7aed10f2}},	//   _cete_, jete, lfau, mvat, 
   {{0x2d9e90f3,0xd0d40574,0x20f08934,0xe81e002a}},	//   _dete_, _поръ, nđić_, _पतला_, 
   {{0x3ea9025b,0xfcaa096e,0xdb1b90f4,0x61e70063}},	//   _ovat_, קיפּ, lgué, _hajl, 
   {{0x2d9e90f5,0x61e7008d,0x7aed10f6,0x81e000b2}},	//   _fete_, _kajl, nvat, থার_, 
   {{0xb33b07fa,0x8c4782a5,0xdb1b90f7,0x442000f8}},	//   _geçe, _bişî, ngué, zhi_, 
   {{0x7aed029f,0x61e710f8,0x442010f9,0x186a10fa}},	//   hvat, _majl, yhi_, жани_, 
   {{0x442010fb,0x7aed00d7,0x61e701df,0xe4d48019}},	//   xhi_, kvat, _lajl, _ستمب, 
   {{0x44320daa,0x442010fc,0x7aed0c0e,0x764e10fd}},	//   viy_, vhi_, jvat, toby, 
   {{0x61e710fe,0x7a200019,0x59cf0f21,0xf1cf10ff}},	//   _najl, _köte, स्मर, स्मन, 
   {{0xafe60004,0x320a02fb,0x42528019,0x764e1100}},	//   _жойл, _roby_, _جنور, roby, 
   {{0x7a200172,0x68fc9101,0xc1728039,0x44200111}},	//   _möte, årde, _בחו_, uhi_, 
   {{0xfaa31102,0x44320004,0x442f9103,0x798901b2}},	// [780] като, riy_, _mmg_, _şewa, 
   {{0x44201104,0xee37005a,0x44320daa,0xe9d71105}},	//   shi_, _оны_, siy_, мку_, 
   {{0xb4661106,0x2d9e9107,0x442004e2,0x25e71108}},	//   _окол, _rete_, phi_, _छोटी_, 
   {{0x69da9109,0x9f40110a,0xb33b0214,0x6a860004}},	//   zete, _unió_, _seçe, _олма, 
   {{0x61e7110b,0xa3c880a1,0xc7a384d9,0x63a4110c}},	//   _fajl, _लॉग_, тичк, main, 
   {{0x3f9f910d,0x3f8690f4,0x7a20010d,0xd04c808a}},	//   _eeuu_, scou_, _böte, _əhəm, 
   {{0x2d9e80f8,0x69da910e,0x28dd910f,0xf8d2102c}},	//   _vete_, vete, _फैलि, _सहिय, 
   {{0x63a41110,0x22841111,0x2d9e9112,0xdb009113}},	//   nain, _kök_, _wete_, lamé, 
   {{0x2d9e9114,0x42748004,0x69c38a1c,0xe4570309}},	//   _tete_, нгис, _bcne, ויקט_, 
   {{0x61e88d7c,0xf8d21115,0x63a41116,0xdb150035}},	//   uddl, _सहाय, hain, ébéc, 
   {{0xd130830b,0x63a41117,0x29189118,0x69da9119}},	//   امج_, kain, ára_, rete, 
   {{0xe8df0028,0x7aed026b,0x63a4111a,0x7ae2911b}},	//   _cuộc_, yvat, jain, _tsot, 
   {{0x63a4111c,0xd6d980a1,0x6b96111d,0x78ba911e}},	//   dain, _były_, dbyg, sutv, 
   {{0x7aed0103,0x69da911f,0x2ef20a91,0x7afd9120}},	//   vvat, qete, _dryf_, åste, 
   {{0x1bd5009f,0x61e70265,0xdb009121,0x2edb9115}},	//   новя, _rajl, damé, _यन्त, 
   {{0x63a40069,0x69ca8baf,0x50670004,0x61e70259}},	//   gain, त्री, _ўтка, _sajl, 
   {{0xeabc80b2,0x61e7027e,0x2bd08076,0x2ef21122}},	// [790] _অনুম, _pajl, थ्या, _gryf_, 
   {{0x6d451123,0x27e91124,0xdb009125,0x22841126}},	//   _txha, _haan_, ramè, _dök_, 
   {{0x588401bc,0x7aed0388,0xd13100fe,0xdb1b9127}},	//   выча, svat, دما_, rgué, 
   {{0x20191128,0x3cf49129,0x27e90079,0xa2950116}},	//   nksi_, ्मने_, _jaan_, _памі, 
   {{0x61e7112a,0x27e9112b,0x0f35804e,0x2019019b}},	//   _tajl, _maan_, رکرد, iksi_, 
   {{0x780c009b,0x27e9112c,0x68e3006d,0x6442819b}},	//   _हक्क_, _laan_, ænds, _ajoi, 
   {{0x1958112d,0xf41f010d,0x25a1112e,0x3f9f82ef}},	//   _жары_, _klä_, _mehl_, _teuu_, 
   {{0x7cca808a,0x3eb28162,0x2d878a5e,0x5ba982f0}},	//   _mərh, šyta_, scne_, чким_, 
   {{0x7c3a0077,0x9f9d007f,0x316300ca,0xef548086}},	//   étri, væði_, _hzjz_, _акть, 
   {{0x63a4112f,0x569484bc,0xfdf38439,0x20190008}},	//   zain, _рафт, _आफिस_, eksi_, 
   {{0x6e350053,0x27e91130,0x09e185a2,0x200d8a91}},	//   dizb, _baan_, বালা, _koei_, 
   {{0xcdc90052,0x80a080a1,0x59cf1131,0x2b408998}},	//   _לך_, _खबरे, स्तर, _žice_, 
   {{0xef171132,0x63a41133,0x27e91134,0xcc3a80c6}},	//   емя_, vain, _daan_, _צענט, 
   {{0x63a40824,0xfce61135,0x645b9136,0x91e2804c}},	//   wain, ного, llui, _боше, 
   {{0x228408b4,0xa3cc9137,0xa50a0e08,0x63a41138}},	//   _sök_, श्व_, чева_, tain, 
   {{0x443f9139,0x27e901d9,0x6b898058,0x7dd386c8}},	//   nnu_, _gaan_, nceg, lısı, 
   {{0x34dc913a,0x443f913b,0x41b6113c,0x6b96113d}},	// [7a0] _मन्द, inu_, есет, rbyg, 
   {{0x63a4113e,0x6b96113f,0x80c900b2,0x8e970309}},	//   sain, sbyg, রবন্, _רדיו_, 
   {{0x2d981140,0x63a41141,0xf1c29142,0x69c80214}},	//   mbre_, pain, _शासन, _ödem, 
   {{0xa2b21143,0x443f886a,0x7afb0c0e,0xcfb205a2}},	//   ेंद्, jnu_, _šute, ট্রন, 
   {{0x443f9144,0x7cca808a,0xc8798a05,0x68e3066b}},	//   dnu_, _tərk, _diş_, ændr, 
   {{0x443f9145,0x69c19146,0x6aa99147,0x45d49148}},	//   enu_, jgle, dsef, токс, 
   {{0x69c18524,0x443f9149,0x69de0ca2,0x5fc6009b}},	//   dgle, fnu_, mepe, _वाढल, 
   {{0x59c28895,0x66e6914a,0x6b7b00c6,0x25fe809b}},	//   _शाहर, _поба, ּרינ, लाही_, 
   {{0xdcea914b,0xe7d583d2,0x6aa9914c,0x27e902b1}},	//   rafı, lığı, gsef, _raan_, 
   {{0x27e9114d,0x69c1914e,0x443f8123,0x9fd000b2}},	//   _saan_, ggle, anu_, িযোগ, 
   {{0x7c24114f,0x443f886a,0x27e91150,0x395880c0}},	//   khir, bnu_, _paan_, ærs_, 
   {{0x645b9151,0x351b8039,0x2d980149,0x7cca82d1}},	//   clui, _מובנ, ebre_, _nəri, 
   {{0x27e9036d,0x69de1152,0x7cca808a,0x81ab05a2}},	//   _vaan_, kepe, _sərh, ক্ট_, 
   {{0xa3cc83ca,0x27e91153,0x4992804e,0xb33b01b2}},	//   श्र_, _waan_, _حیدر, _neça, 
   {{0x644102c0,0x63a28883,0x5334004a,0x69de1154}},	//   élio, _keon, ңест, depe, 
   {{0xe7d582bc,0x63a29155,0x61ea9156,0xb4e11157}},	//   dığı, _jeon, _hafl, _धनी_, 
   {{0xf1a48bc3,0x7cca808a,0x61ea905c,0x63a29158}},	// [7b0] _खजान, _dəri, _kafl, _meon, 
   {{0x63a29159,0xbbdd915a,0x443f915b,0x69de115c}},	//   _leon, _मस्क, znu_, gepe, 
   {{0x443f915d,0x7c24115e,0x47bc85a2,0xb21b0764}},	//   ynu_, bhir, োজনী, _stæs, 
   {{0x7c24115f,0x61ea9160,0x443f02fe,0x6e959161}},	//   chir, _lafl, _ñu_, виду, 
   {{0x443f803b,0xdee59078,0x44248013,0xb4e10056}},	//   vnu_, толи, dhm_, _धनु_, 
   {{0x27e9803a,0xe6189162,0x69de1163,0xed599164}},	//   žan_, нді_, cepe, мол_, 
   {{0x443f8131,0x6d5a8034,0x7e7a868e,0x645b9165}},	//   tnu_, _cyta, _ditp, tlui, 
   {{0x2ef58d74,0x201f802d,0x7bdf0432,0x6aa99166}},	//   _избр, _ului_, nequ, tsef, 
   {{0x6b898081,0x63a29167,0x645b9168,0x045680fe}},	//   rceg, _deon, rlui, خلية_, 
   {{0x443f829f,0x645b9169,0x6aa9916a,0xd24e80a7}},	//   snu_, slui, rsef, يني_, 
   {{0xd9458286,0x69c1916b,0xf1c60895,0x6aa9916c}},	//   тени, rgle, र्टन, ssef, 
   {{0xe73a116d,0x68fc810d,0x69c1916e,0xdb1b833b}},	//   дем_, årda, sgle, lguí, 
   {{0x69c70301,0x26160079,0x3869116f,0xf1d1855a}},	//   _ocje, _नकदी_, _dhar_, _көнө, 
   {{0xdb1b8226,0xdd92003f,0x628003de,0x61ea9170}},	//   nguí, شور_, _émoi, _gafl, 
   {{0xed571171,0xada31172,0x7c241173,0x63a2897e}},	//   вор_, расл, thir, _yeon, 
   {{0x1c431174,0x38691175,0x63a283b9,0x60d69176}},	//   ансм, _ghar_, _xeon, _יוצא_, 
   {{0xb33b0077,0x6a831177,0xeab10068,0xe2831178}},	// [7c0] _peça, илта, یعے_, илти, 
   {{0x7c241179,0xb21b117a,0xceb9000d,0x68f5026b}},	//   shir, _stær, áře_, _brzd, 
   {{0x291c0f43,0xb33b00f8,0x7c2403ec,0x69de117b}},	//   áva_, _veça, phir, repe, 
   {{0x69de117c,0x6e21917d,0x7bc60269,0xf1c6117e}},	//   sepe, _allb, _ucku, र्जन, 
   {{0x4422117f,0x63a28269,0xc5f8804a,0xdfcf80fe}},	//   _ilk_, _reon, нға_, تين_, 
   {{0x6d5a8066,0x93f60816,0x4a750008,0x63a29180}},	//   _pyta, _şəhə, _быст, _seon, 
   {{0x63a29181,0xa3c9000c,0x98a31182,0x3ead8214}},	//   _peon, ल्क_, _висе, _evet_, 
   {{0x61ea8324,0x7bc41183,0xa78580fe,0x6d5a9184}},	//   _safl, ngiu, _مشكو, _vyta, 
   {{0x7c23002d,0xdee38e20,0x59cf000c,0x7ae40199}},	//   _înre, _коти, स्वर, nwit, 
   {{0x610a808a,0x7e7a9185,0x386908c6,0x63a28149}},	//   səlm, _uitp, _shar_, _weon, 
   {{0x859b82f9,0x9f4e026b,0x3ea01186,0x850688f7}},	//   _חשבו, čným_, _awit_, _جوان, 
   {{0xc9530052,0x28c48562,0x7ae41187,0xe7b482f4}},	//   ימת_, लंबि, kwit, ुलिप, 
   {{0xd5c98079,0x05c98ab2,0x61ea9188,0x81d482fd}},	//   _रामज, _रामब, _tafl, _болх, 
   {{0xb8f480fe,0x6e940008,0x7c229189,0x7ae402d7}},	//   _مكتب, риру, _hlor, dwit, 
   {{0x62728066,0x38690094,0x7bdf118a,0x03c70ad0}},	//   _słow, _thar_, tequ, ксам, 
   {{0xd10f83ca,0x7bc4009f,0x41c6054d,0xe3c9811e}},	//   ाहरण_, ggiu, र्घस, mañá_, 
   {{0x2458036d,0xdb1d06e4,0x0cbf83ca,0x41cf9129}},	// [7d0] тать_, _absò, _एम्म, त्वस, 
   {{0x7c22918b,0x7bdf07d6,0x200b0524,0x442202b5}},	//   _llor, sequ, ljci_, _elk_, 
   {{0x3ead918c,0x0cbd80cf,0xe01e810c,0x7c22918d}},	//   _svet_, _আন্ত, पसंद_, _olor, 
   {{0xa2c30562,0x7655118e,0x787a801b,0xc86482bb}},	//   िंद्, lozy, _důvo, атчи, 
   {{0xa3cc00da,0x539a0039,0x3c3a80f3,0x03d61176}},	//   _शॉट_, _רישו, hīvs_, _גורם_, 
   {{0x7c22918f,0x69c71190,0x51871191,0x65c59192}},	//   _alor, _ucje, _шума, убка, 
   {{0x6aad0bec,0xb4b100a1,0x7c229193,0xed569194}},	//   lsaf, _ऑटो_, _blor, лош_, 
   {{0x20f30a5a,0x6b8d1195,0x30da00c6,0x2fc901df}},	//   _ići_, ncag, _אַמע, _ncag_, 
   {{0x2bd51196,0x32111197,0x65959198,0x0a398193}},	//   ड्या, _kozy_, _базу, ечны_, 
   {{0x2d810028,0x20f31199,0x7c22919a,0xb33b119b}},	//   _nghe_, _kći_, _elor, _leço, 
   {{0xe4cb919c,0x07a6036a,0x69c50089,0x1acf00b2}},	//   _زبان_, ланн, ighe, রিয়া, 
   {{0x30da00c6,0x27ed919d,0x764380db,0xf3f080d8}},	//   ײַטע, _jaen_, lnny, _وأن_, 
   {{0x25a5919e,0x27ed919f,0x63a991a0,0x9f8a8079}},	//   _kell_, _maen_, maen, _tööd_, 
   {{0x27ed91a1,0x2aba8039,0x7c2291a2,0x63a991a3}},	//   _laen_, _נמצא, _zlor, laen, 
   {{0x61e191a4,0x27ff907b,0x03e680cf,0xdcee0a08}},	//   mell, _onun_, কারী_, tabı, 
   {{0x61e191a5,0x6b8d03d9,0xf1cf91a6,0x63a991a7}},	//   lell, gcag, त्रन, naen, 
   {{0xe1fa11a8,0xab6611a9,0x200000e5,0x764380e5}},	// [7e0] нга_, увал, _inii_, knny, 
   {{0x55e611aa,0x25a58574,0xdcee0a08,0x787a801b}},	//   _сооб, _nell_, sabı, _půvo, 
   {{0x7ae411ab,0x61e18086,0x610a808a,0x60c191ac}},	//   swit, iell, vəlk, nulm, 
   {{0x61e191ad,0x6b8d11ae,0xe29a11af,0x27ed91b0}},	//   hell, ccag, _пам_, _caen_, 
   {{0x61e191b1,0xdd928267,0x7e7e11b2,0xdb0091b3}},	//   kell, موش_, _kipp, tamí, 
   {{0x69d391b4,0x7e7e0208,0xc1e701a1,0x61e191b5}},	//   _बॉली, _jipp, _مکمل_, jell, 
   {{0x61e191b6,0x25a591b7,0x21670ba0,0x628611b8}},	//   dell, _dell_, _бири_, _huko, 
   {{0x61ee04ba,0x628611b9,0xe4f709ca,0x7643825f}},	//   _habl, _kuko, ुमति_, anny, 
   {{0x61ee11ba,0x61e191bb,0x7c2280f8,0x574691bc}},	//   _kabl, fell, _vlor, _снаб, 
   {{0x628611bd,0x61e191be,0x61ee0802,0xddc891bf}},	//   _muko, gell, _jabl, _hidž, 
   {{0x5bc68743,0x64440008,0x63a9820e,0x61ee0103}},	//   _مقال, knii, baen, _mabl, 
   {{0x0eeb0008,0x26c211c0,0x2fc68347,0x61ee11c1}},	//   ньги_, fuko_, ngog_, _labl, 
   {{0xcc578115,0x9f4201b2,0xe2968077,0xb33b0035}},	//   _גבאי_, lekê_, _среќ, _reço, 
   {{0x27ed11c2,0x61e191c3,0x7e7e02fb,0x63a602fe}},	//   žen_, cell, _cipp, _aekn, 
   {{0xf9938039,0x9f4201b2,0x69ca8149,0x55590086}},	//   _פרק_, nekê_, _icfe, тавя_, 
   {{0x68260818,0x628611c4,0x60df8068,0x644411c5}},	//   _póde, _buko, őzmé, gnii, 
   {{0x5a3511c6,0x92590003,0x765a91c7,0x764391c8}},	// [7f0] анат, ваат_, _okty, ynny, 
   {{0x61ee11c9,0x27ed81e0,0x321e80a1,0x45d5075d}},	//   _cabl, _saen_, nkty_, _тоос, 
   {{0xa3d507a8,0xa3e5810c,0x69c511ca,0x6aad11cb}},	//   _конч, _फसल_, rghe, ssaf, 
   {{0x61e191cc,0x765a91cd,0x63a611ce,0x627280a1}},	//   zell, _akty, _gekn, _złot, 
   {{0x69d891cf,0x61ee11d0,0xddc881e2,0x6286059d}},	//   _obve, _fabl, _didž, _guko, 
   {{0x442911d1,0xf77091d2,0x443b11d3,0x61e18c3d}},	//   lha_, سان_, liq_, xell, 
   {{0x628611d4,0x20f3005d,0x6b9b808b,0x25a591d5}},	//   _zuko, _ući_, tbug, _vell_, 
   {{0x44290804,0x61e191d6,0x25a58052,0x628611d7}},	//   nha_, well, _well_, _yuko, 
   {{0x61e191d8,0x62800035,0xcb1200c6,0x25a58039}},	//   tell, _émot, ַלט_, _tell_, 
   {{0x63a991d9,0x443b0103,0x60c18646,0x6abb91da}},	//   saen, hiq_, tulm, rruf, 
   {{0x5d8491db,0x64560191,0xc5fa80c6,0x442911dc}},	//   _المل, yoyi, _שפעט, kha_, 
   {{0x61e191dd,0x4375869a,0x26c200b4,0x60c18180}},	//   sell, _култ, tuko_, rulm, 
   {{0x442911de,0x60c191df,0xfaa591e0,0x8c1a8039}},	//   dha_, sulm, _тало, _שוני, 
   {{0x7c2991e1,0x26c211e2,0x387f8a00,0x6da311e3}},	//   lher, ruko_, _liur_, жира, 
   {{0x64a611e4,0xed5a11e5,0xe816807a,0x26c211e6}},	//   раба, тов_, _थकला_, suko_, 
   {{0x442911e7,0x6286005d,0x200011e8,0x6d5e0410}},	//   gha_, _puko, _unii_, _vypa, 
  
   {{0x7e7e11e9,0xdee60004,0x627280a1,0x6d5e00a1}},	// [800] _tipp, _топи, _głos, _wypa, 
   {{0x6286003b,0x9f420610,0xb33b0214,0x442911ea}},	//   _vuko, yekê_, _geçm, aha_, 
   {{0x442911eb,0xe3ba11ec,0x55bb0039,0xff5f01b2}},	//   bha_, _ибн_, _במיו, ngîn_, 
   {{0x442911ed,0x386d82c0,0x628611ee,0x8f84804a}},	//   cha_, _cher_, _tuko, сқал, 
   {{0x442011ef,0x66f491f0,0x628600ed,0x386d8064}},	//   mki_, сплу, _uuko, _dher_, 
   {{0x409611f1,0x61ee0097,0xfaa311f2,0x386d82ae}},	//   _врат, _uabl, _фаро, _eher_, 
   {{0xdb0087a2,0x2907010d,0xcd068da7,0x614311f3}},	//   damá, änat_, рчли, _дера, 
   {{0x20e80085,0x9f420093,0x7c2991f4,0x6aa28246}},	//   _işi_, rekê_, gher, _pwof, 
   {{0xf5ea8591,0x787f00f3,0x798901b2,0x5a348086}},	//   _имал_, _būvn, _şewi, йнит, 
   {{0x442011f5,0x7a248097,0x443b11d3,0xd4d681e2}},	//   hki_, _bòta, ziq_, _відэ, 
   {{0x442011f6,0x6e3c11f7,0xfa888106,0x443b11f8}},	//   kki_, dirb, _dừa_, yiq_, 
   {{0x7c2991f9,0xdb5a91fa,0xb33b0a08,0x442911fb}},	//   cher, _июл_, _seçm, xha_, 
   {{0x229491fc,0x442691fd,0x442011fe,0x09e180cf}},	//   _التس, _ilo_, dki_, বাজা, 
   {{0x442011ff,0x44290519,0x4426806c,0xaadb83dd}},	//   eki_, wha_, _hlo_, _סחור, 
   {{0x44269200,0xda05000f,0x2ba704d9,0x627280a1}},	//   _klo_, रासत_, ијав, _włos, 
   {{0xe97b8039,0xf21c810c,0x5bb80008,0x717b8039}},	//   _בנוש, _पकड़_, ился_, _בנוס, 
   {{0x443b1201,0x44291202,0xb06602f4,0x32d0812f}},	// [810] riq_, rha_, svää, này_, 
   {{0x44291203,0x44201204,0x44269205,0x4185004a}},	//   sha_, aki_, _llo_, стағ, 
   {{0x44201206,0xda781207,0x44269208,0x4f580267}},	//   bki_, рят_, _olo_, _مجید_, 
   {{0xa3ce023b,0xe8df010b,0xd126811d,0x0596003d}},	//   _राय_, _quốc_, _ہم_, _پایگ, 
   {{0x63ad1209,0xd9f8920a,0x161b009b,0x443905a6}},	//   maan, ्ञात_, _नकार_, _ims_, 
   {{0x6da28077,0xe5a2920b,0x7c29920c,0xcb12025e}},	//   пиша, пиши, wher, _צלם_, 
   {{0xa3ce120d,0x4426807e,0x61e50504,0x2907120e}},	//   _राम_, _blo_, mehl, ånad_, 
   {{0x63ad0ab5,0x4369920f,0x44269210,0x1be99211}},	//   naan, лайн_, _clo_, удии_, 
   {{0x7c3b9212,0x7c299213,0x44268246,0x44390578}},	//   riur, rher, _dlo_, _mms_, 
   {{0x44201214,0x7c299215,0x44269216,0x63ad1217}},	//   zki_, sher, _elo_, haan, 
   {{0x7c299218,0x63ad1219,0xfa888028,0x60c5121a}},	//   pher, kaan, _vừa_, nuhm, 
   {{0x4426921b,0x5c75921c,0xdee6121d,0xdb00921e}},	//   _glo_, _улет, боми, samá, 
   {{0x63ad121f,0x4420082b,0xceb283f3,0x28c90353}},	//   daan, vki_, ּיל_, ांडि, 
   {{0x44200066,0xe29c80c6,0x21698103,0x7d1c09b8}},	//   wki_, _ישׂר, _йили_, tyrs, 
   {{0x44201220,0x82349221,0x1d19036a,0x63ad02ee}},	//   tki_, _برنا, ають_, faan, 
   {{0x63ad1222,0x7bc9822c,0x61b7809b,0x3eb28116}},	//   gaan, ngeu, _आयुष, šyti_, 
   {{0x44201223,0xe9da1224,0xd4671225,0x61e501ed}},	// [820] rki_, лка_, сите_, fehl, 
   {{0x645d1226,0x7afd819b,0x7dea0656,0xdb0d01fb}},	//   _eksi, ästy, _смог_, rgað, 
   {{0x63ad1227,0xf77f03b8,0x5a3a80c6,0x44201228}},	//   baan, meça_, נגעה, pki_, 
   {{0x7ae99229,0x63ad122a,0xa9670495,0xf77f0da7}},	//   kwet, caan, щиха_, leça_, 
   {{0x29070172,0x628f922b,0x92f600f0,0x69c8922c}},	//   änar_, ícol, _учні, ygde, 
   {{0x4426922d,0x60c50645,0xd042008a,0xe4a6922e}},	//   _slo_, buhm, rtlə, брио, 
   {{0x645d036d,0x2619922f,0xd4978116,0xd042008a}},	//   _yksi, _बकरी_, бры_, stlə, 
   {{0x7bc98385,0x290505c3,0x1e868470,0x786a9230}},	//   ggeu, _šlag_, _глам, býva, 
   {{0x59cf1231,0x27e69232,0x09ac80b2,0x6a70010d}},	//   स्कर, meon_, _খাবা, räff, 
   {{0xb33b0816,0x98a787fa,0x6d4003d2,0x23ad0162}},	//   _seçk, _aynı_, şmay, mųjų_, 
   {{0x63ad1233,0x69dc1234,0x44269235,0x69ce017c}},	//   yaan, _mbre, _tlo_, _mcbe, 
   {{0x438680fe,0x44269236,0xbb8680fe,0x2d9100a1}},	//   _الإق, _ulo_, _الإي, wcze_, 
   {{0x69dc1237,0xf1a81115,0x23ad0162,0x29188587}},	//   _obre, गरान, nųjų_, ärab_, 
   {{0x63ad1238,0x7afd806d,0x44f88106,0x41c71239}},	//   waan, æste, _kĩ_, _लाइस, 
   {{0x63ad123a,0x786a8407,0x2d910034,0xb425885a}},	//   taan, zýva, rcze_, łżeń, 
   {{0x682604e0,0x25bf123b,0x9f420093,0xa3cc923c}},	//   _tóda, şul_, mekî_, श्च_, 
   {{0x7b67123d,0xb33b008c,0x63ad123e,0x9f4201b2}},	// [830] стве, _keçi, raan, lekî_, 
   {{0x63ad0640,0x9c7c8105,0x69dc0097,0x23ad00ce}},	//   saan, _isču, _cbre, dųjų_, 
   {{0x9f4201b2,0x63ad123f,0x9f52024a,0x6826026b}},	//   nekî_, paan, _nayê_, _módn, 
   {{0x7c671240,0x160700da,0x60c500e5,0x69dc1241}},	//   _داخل, शावर_, ruhm, _ebre, 
   {{0x7c2d1242,0xa3ce075c,0x60c51243,0x9f421244}},	//   mhar, _रात_, suhm, hekî_, 
   {{0xae038b30,0x7c2d1245,0x69d80ef4,0x2c4c81d2}},	//   लाइन_, lhar, न्दी, věda_, 
   {{0xac099246,0x24098175,0xafdb006d,0xdb0602ef}},	//   инка_, инки_, rnøj, _reké, 
   {{0x7afd0259,0x7c2d1247,0x601f0210,0xa4b80039}},	//   _krst, nhar, _fëmi, צלחה_, 
   {{0xc7b98019,0x7bc980ef,0x20f78166,0x7afb061c}},	//   _idő_, rgeu, _săi_, _šutj, 
   {{0x39459248,0x1ddb09af,0xdcf51249,0x89a9924a}},	//   жног, म्मत, hazı, шков_, 
   {{0x21698daa,0x7c2d124b,0x7bcf124c,0x7ae9924d}},	//   рини_, khar, _occu, swet, 
   {{0xe8df8028,0x7c2d0027,0x7ae982d7,0xe8e00279}},	//   hiệm_, jhar, pwet, _chộp_, 
   {{0x7c2d124e,0x442d806b,0x6d41124f,0xc7d68309}},	//   dhar, mhe_, úlan, חורי_, 
   {{0x443f9250,0xb33b07fa,0x442d8077,0x7bcf1251}},	//   liu_, _geçi, lhe_, _accu, 
   {{0xf77f1252,0x27e6871a,0x7afd1253,0x628380ed}},	//   reça_, yeon_, _arst, _iino, 
   {{0x443f9254,0x64499255,0x442d8077,0x628b9256}},	//   niu_, nnei, nhe_, _kugo, 
   {{0xda0509d7,0x63ab8019,0x64499257,0x987b03f3}},	// [840] रांत_, _megn, inei, _דאקט, 
   {{0x63ab9258,0x64499259,0x628b925a,0x6283925b}},	//   _legn, hnei, _mugo, _jino, 
   {{0x7afd125c,0x7c2d125d,0x442d8232,0x443f8116}},	//   _erst, bhar, khe_, kiu_, 
   {{0x81e70a87,0x3076925e,0x68260019,0x7c2d125f}},	//   ভাগ_, цузс, _módo, char, 
   {{0x442d9260,0x443f9261,0x44f88028,0x7c241262}},	//   dhe_, diu_, _sĩ_, mkir, 
   {{0x9f420093,0x7c241263,0xdb0601b2,0xdcba809f}},	//   yekî_, lkir, _yekî, ащи_, 
   {{0x25ba1264,0x7a2001ed,0x291c02f4,0x443f9265}},	//   _mdpl_, _nöti, ävad_, fiu_, 
   {{0x09b48a87,0x442d9266,0xb33b107b,0x443f9267}},	//   জ্ঞা, ghe_, _seçi, giu_, 
   {{0x62839268,0x63ab9269,0x2d96926a,0x628b80ca}},	//   _bino, _degn, _дрес, _cugo, 
   {{0x3866926b,0x628b803b,0x7c24024a,0x291e8116}},	//   llor_, _dugo, hkir, tyta_, 
   {{0xf9930052,0x7c24126c,0x1958926d,0x443f926e}},	//   ורת_, kkir, саны_, biu_, 
   {{0x443f926f,0x9f42024a,0x63ab9270,0x291e9271}},	//   ciu_, rekî_, _gegn, ryta_, 
   {{0xe1ef9272,0x62839273,0xc7b38052,0x38668123}},	//   رسی_, _fino, ובר_, ilor_, 
   {{0x765c1274,0x7c2d1275,0x62839276,0x63ab8050}},	//   gory, whar, _gino, _zegn, 
   {{0x7c2d1277,0x61e88bfa,0xfe6e0184,0x7c241278}},	//   thar, medl, دگي_, fkir, 
   {{0x69da8a70,0x62839279,0xdb0080e9,0x38668ba7}},	//   lfte, _zino, pamä, jlor_, 
   {{0x7c2d127a,0x8d87127b,0xdceb03d2,0xf77f03b8}},	// [850] rhar, _мунд, ınız, meço_, 
   {{0x7c2d127c,0x61e88324,0x6440927d,0x443f927e}},	//   shar, nedl, himi, ziu_, 
   {{0x6440927f,0x7c2d1280,0x32180050,0xf8b1004e}},	//   kimi, phar, _dory_, عکس_, 
   {{0xdce50028,0x443f9281,0x64409282,0x25ac8065}},	//   _nghĩ, xiu_, jimi, _aedl_, 
   {{0x3ea59283,0x63ab9284,0x66059285,0x443f9286}},	//   чилг, _regn, зпла, viu_, 
   {{0x63ab8574,0x61e89287,0x628b9288,0xee3887c5}},	//   _segn, jedl, _rugo, оні_, 
   {{0x442d9289,0x443f928a,0x6440928b,0x628b928c}},	//   the_, tiu_, fimi, _sugo, 
   {{0x7bcd128d,0x61f5128e,0x6440928f,0x3f891290}},	//   ngau, _hazl, gimi, _ngau_, 
   {{0x443f9291,0x63ab812b,0x62839292,0x442d84c3}},	//   riu_, _vegn, _pino, rhe_, 
   {{0x442d9293,0x443f9294,0x7c241295,0x61f51296}},	//   she_, siu_, zkir, _jazl, 
   {{0x442d9297,0x61f51298,0x63ab9299,0x6440929a}},	//   phe_, _mazl, _tegn, bimi, 
   {{0x6440929b,0x7aed129c,0x628b929d,0x7c2d826b}},	//   cimi, kwat, _tugo, ďars, 
   {{0x765c129e,0x6283929f,0x7c2402a5,0x249a03bf}},	//   tory, _tino, vkir, _stpm_, 
   {{0x682604e0,0xa3ce000f,0x7aed12a0,0x3ea906e0}},	//   _tódo, _राह_, dwat, _dwat_, 
   {{0x7c2412a1,0x32078034,0x7afb92a2,0x38600ced}},	//   tkir, _inny_, lvut, _tkir_, 
   {{0x5fc60365,0xc4830aff,0x765c12a3,0x04460418}},	//   _वाटल, елск, sory, чебн, 
   {{0x7c2412a4,0x6e4612a5,0x6fa20693,0x7aed12a6}},	// [860] rkir, _неиз, _क्यू, gwat, 
   {{0x7c2412a7,0x17570052,0x644092a8,0x2fdf8128}},	//   skir, _מספר_, zimi, _abug_, 
   {{0x644092a9,0x2eff8645,0xae1b00c6,0x7aed09fb}},	//   yimi, _aruf_, _הויכ, awat, 
   {{0x442b12aa,0x4424001c,0x7aed12ab,0x68e38050}},	//   _glc_, _ôm_, bwat, _mpnd, 
   {{0x61f507fa,0x644092ac,0x321812ad,0x386692ae}},	//   _fazl, vimi, _tory_, rlor_, 
   {{0xe2970014,0x63a412af,0x97c3804a,0x442480f6}},	//   _хар_, lbin, _үйре, wkm_, 
   {{0xf8e0007a,0x8fa692b0,0x443d92b1,0x61e892b2}},	//   _नहिय, _наве, _bmw_, vedl, 
   {{0x63a412b3,0x7afb01de,0x18a60a09,0x60c892b4}},	//   nbin, _šuti, _маҳм, vudm, 
   {{0x63a412b5,0x61f512b6,0x298a87c5,0x06e405a2}},	//   ibin, _yazl, йсно_, মিডি, 
   {{0x644092b7,0x27e012b8,0x80c092b9,0x3f808116}},	//   simi, _abin_, _विदे, žius_, 
   {{0xdca392ba,0x64a392bb,0x66088142,0x859b8039}},	//   _захи, _заха, _indk, _השבו, 
   {{0x7aed0066,0x35d2810c,0x61e892bc,0x644092bd}},	//   ywat, _साड़, sedl, qimi, 
   {{0x7ae2803a,0x63a40025,0xf77f0077,0x442b047f}},	//   _upot, dbin, reço_, _rlc_, 
   {{0x661a836d,0x4b7b8309,0xa7fb12be,0xe3b090ac}},	//   _jotk, _האדו, doñe, _سرچ_, 
   {{0x7a2d8422,0x601f00f8,0x1c20810c,0x61db82f9}},	//   _fútb, _sëmu, _बवाल_, _הקוד, 
   {{0x63a412bf,0x7aed12c0,0xd2510019,0x442b02fb}},	//   gbin, twat, ھنا_, _qlc_, 
   {{0xa3de8b30,0x35d281d1,0x20090766,0xd7670068}},	// [870] द्य_, _साढ़, _inai_, _ڈاکٹ, 
   {{0x24868013,0x91fc8029,0x7c8707e4,0x661a807f}},	//   _liom_, klām, _нуме, _notk, 
   {{0x21270028,0x7aed0504,0xb33b0035,0x26cb12c1}},	//   ánh_, swat, _reçu, luco_, 
   {{0xa2bd92c2,0x2eff80bf,0x35d303ca,0x9f520093}},	//   _शिल्, _pruf_, _ताड़, _mayî_, 
   {{0xa7fb0818,0xd6db92c3,0x26d900de,0x236681df}},	//   coñe, сте_, ntso_, _nyoj_, 
   {{0x2f238029,0x443d80db,0x992b12c4,0x629d12c5}},	//   _rīgā_, _smw_, _люба_, _itso, 
   {{0x644d12c6,0x3cf78034,0x80db832d,0xb33b09b8}},	//   onai, ंटें_, _बहें, _veçu, 
   {{0x628712c7,0x13b100b2,0x628f12c8,0x9f448036}},	//   _hijo, _ছাড়, _kuco, _lamù_, 
   {{0x661a92c9,0xdd9584a0,0x65958bb3,0xb33b0214}},	//   _fotk, _жазы, _жазу, _geçt, 
   {{0x644d0089,0x7afb8079,0x26cb12ca,0x200912cb}},	//   hnai, rvut, duco_, _anai_, 
   {{0x764392cc,0xdb0b8019,0xd90f803d,0x628712cd}},	//   miny, _megé, ایع_, _mijo, 
   {{0xa3ae8a78,0x59dd12ce,0xeb0d12cf,0x628712d0}},	//   करण_, न्तर, _सपूत_, _lijo, 
   {{0x629d01c8,0x7a2012d1,0xd0928816,0x09ac80b2}},	//   _ntso, _kött, _müəy, _খারা, 
   {{0xfce600f0,0x569312d2,0xdb2680df,0x628712d3}},	//   мого, таёт, _توهی, _nijo, 
   {{0x2101005d,0x91fc80f3,0x7a2012d4,0x63a412d5}},	//   nčić_, klāj, _mött, tbin, 
   {{0x764392d6,0x628f12d7,0x644d12d8,0x601f016c}},	//   hiny, _buco, gnai, _dëms, 
   {{0x764392d9,0x4b7a8273,0xcb6712da,0x628712db}},	// [880] kiny, ַטעג, дате_, _bijo, 
   {{0x644d12dc,0x764392dd,0x21010265,0xb5ca00df}},	//   anai, jiny, kčić_, _بودم_, 
   {{0x764392de,0x628712df,0x21010533,0x644d12e0}},	//   diny, _dijo, jčić_, bnai, 
   {{0xa7fb04e0,0x28c592e1,0x3b0a12e2,0x50c58f82}},	//   poñe, _विनि, _демо_, _विनष, 
   {{0x764392e3,0x628712e4,0x987b03f3,0x628f0192}},	//   finy, _fijo, קאנט, _guco, 
   {{0xd49a92e5,0x59dd12e6,0x628712e7,0x9d450019}},	//   ори_, न्दर, _gijo, _آئین, 
   {{0xa967019b,0x7a200341,0x216712e8,0x00000000}},	//   _жира_, _dött, _жири_, --, 
   {{0x443212e9,0xa803809f,0xb7fb801b,0x628702fe}},	//   nhy_, _изсл, _एफएम_, _zijo, 
   {{0x984600f3,0x7a200172,0x764392ea,0x998c808d}},	//   _dēļ_, _fött, biny, ridž_, 
   {{0x7a2012eb,0x764392ec,0x210100ca,0x20090036}},	//   _gött, ciny, bčić_, _snai_, 
   {{0xa3c0059b,0xa3ce009b,0x24868064,0x2d8c8a63}},	//   ीला_, रला_, _tiom_, _igde_, 
   {{0x3e640068,0x53468b1b,0x699e800d,0x26cb12ed}},	//   zött_, _охла, _ख्री, tuco_, 
   {{0xa77412ee,0x2ba480c3,0xdef810ea,0x443212ef}},	//   ключ, _ग्या, мыр_, dhy_, 
   {{0x68fc92f0,0x26d90109,0xb8f480b2,0x764e12f1}},	//   årds, rtso_, _হন_, gnby, 
   {{0xdd940a54,0x236d0269,0x63af068c,0x628f12f2}},	//   тасы, _šej_, _pecn, _suco, 
   {{0x764392f3,0x628712f4,0x44320531,0x61f892f5}},	//   ziny, _sijo, ghy_, _havl, 
   {{0xf48412f6,0x61f892f7,0x764392f8,0x3a7512f9}},	// [890] турн, _kavl, yiny, елар, 
   {{0x61f88025,0x644d12fa,0x443201cb,0x61fa92fb}},	//   _javl, snai, ahy_, ndtl, 
   {{0xa3ae8073,0x64dd92fc,0x628712fd,0x7a2008c5}},	//   करा_, _महेश, _vijo, _rött, 
   {{0x44320d86,0x2c27036a,0x2101029f,0x628f0a63}},	//   chy_, _цьог, včić_, _tuco, 
   {{0x764392fe,0x28c58bf5,0x628712ff,0xceeb803d}},	//   tiny, _विभि, _tijo, تران_, 
   {{0x44291300,0xf770842b,0xe618805a,0x321c8170}},	//   lka_, جام_, мді_, _novy_, 
   {{0x76439301,0x44291302,0x78761303,0x7a24875d}},	//   riny, oka_, láve, _gòti, 
   {{0xa3d70de3,0x76439304,0x2101068b,0xc7c48166}},	//   _साफ_, siny, rčić_, _асфи, 
   {{0x44291305,0xa3de9306,0x76439307,0x61f89308}},	//   ika_, द्ध_, piny, _bavl, 
   {{0x80c08baf,0xe9d99309,0x3eb907c5,0xa2c20353}},	//   _विशे, чко_, dsst_, _लिस्, 
   {{0x6846130a,0x4429130b,0x61f88daa,0x186a130c}},	//   енна, kka_, _davl, зани_, 
   {{0x44290284,0x44f18ad0,0xdb0601ac,0xb4fa8309}},	//   jka_, _iš_, _leká, _מפעי, 
   {{0xc2c88275,0xbbbd809b,0x93278f94,0xd12e930d}},	//   _قبول_, ोलीक, _تران, لمی_, 
   {{0x4429130e,0x7876130f,0x22a901b2,0xf65200fe}},	//   eka_, dáve, zîkî_, ائح_, 
   {{0xdb041310,0x1d071311,0x7c299312,0xb4ad8073}},	//   mbié, нери_, oker, _कबो_, 
   {{0x44291313,0x1ddf809b,0x44f18170,0x3c2e0033}},	//   gka_, प्तत, _mš_, _býva_, 
   {{0x7c2982b5,0x28c580a1,0x32d986e4,0x44f190f1}},	// [8a0] iker, _विडि, nèy_, _lš_, 
   {{0x44291314,0xe1f71315,0x4a431316,0x5efe854d}},	//   aka_, нгу_, гнув, लिस्_, 
   {{0x7c298db9,0x4c861317,0xd8269318,0x44321319}},	//   kker, _плов, нджи, phy_, 
   {{0x4429131a,0x7c29931b,0x6f04131c,0xbe8a84c7}},	//   cka_, jker, _kric, пске_, 
   {{0x6826052f,0xdcfc0816,0x5fd1807a,0x44f181e2}},	//   _códi, marı, _हारल, _aš_, 
   {{0xdcfc1068,0x80db00b2,0xceb303dd,0x7c29931d}},	//   ları, ণিজ্, ריג_, eker, 
   {{0x3da5836a,0xa3d70503,0x0fe28188,0x442f931e}},	//   тріб, _साम_, _бөлү, _blg_, 
   {{0x6f040012,0x61f8931f,0x7c299320,0xdcfc1321}},	//   _oric, _savl, gker, narı, 
   {{0x44f18265,0x645a01b2,0x53349322,0xa3ce01d2}},	//   _eš_, îtiy, тепт, _राई_, 
   {{0x44291323,0x2d8c0407,0xdb0f0a1c,0x7c299324}},	//   zka_, ždej_, _decè, aker, 
   {{0x44290066,0x40351325,0xdcfc0214,0x6f041326}},	//   yka_, венс, karı, _aric, 
   {{0x63b602ef,0x2fc080fe,0x7c299327,0x44290122}},	//   jayn, óigh_, cker, xka_, 
   {{0x63b60128,0x61f89328,0x6d480530,0x44f18170}},	//   dayn, _tavl, údan, _zš_, 
   {{0x442900a1,0x6f040172,0x78761329,0xbe88132a}},	//   wka_, _dric, váve, ессе_, 
   {{0xf1b38052,0xcfb005a2,0x2d85132b,0xd12f87c5}},	//   _עסק_, _কারন, äle_, _сх_, 
   {{0x4429132c,0xd6db1317,0x6f04132d,0x63b6132e}},	//   uka_, _ето_, _fric, gayn, 
   {{0x6c54132f,0x78ba9330,0xf9c70bbb,0xa3d705b1}},	// [8b0] укту, lstv, ещен, _साठ_, 
   {{0x78761331,0x7c299332,0x51f80153,0x2296006d}},	//   ráve, zker, нную_, _dæk_, 
   {{0x78ba86f4,0xe802807a,0x7fd5909a,0x628a9333}},	//   nstv, _रोहा_, вілі, _mifo, 
   {{0x64481334,0x3ead8318,0x69d500a1,0x764706e0}},	//   édit, _pwet_, _wcze, lijy, 
   {{0x141a09be,0xe8df001c,0xdb0b806d,0x799c011a}},	//   _חורב, _thỏa_, _udgø, _ffrw, 
   {{0xb5c28612,0xf77400c6,0x442f8065,0x69d500a1}},	//   айшл, נקס_, _slg_, _ucze, 
   {{0x442f9335,0x7c299336,0xf402002d,0x9165003d}},	//   _plg_, tker, _faţă_, _شهره, 
   {{0x13099248,0x5fd8922f,0xd13880a1,0x44f18507}},	//   дний_, _डायल, dzą_, _vš_, 
   {{0x628a8172,0x56958086,0x95d99337,0x3ed980d8}},	//   _bifo, _разт, _одат_, _زواج_, 
   {{0x7c299338,0xdcfc0085,0x32d986e0,0x63b60b81}},	//   sker, zarı, rèy_, zayn, 
   {{0xa2bd8a9a,0x07a61339,0x442f933a,0x2dd880fe}},	//   _शिक्, канн, _tlg_, _سبلة_, 
   {{0x6f04133b,0xdcfc008a,0x442f933c,0x3ea0133d}},	//   _pric, xarı, _ulg_, _ptit_, 
   {{0xfc46826b,0x539a82f9,0x7c2e8610,0x628a81cb}},	//   ších_, _חינו, _îbra, _fifo, 
   {{0xceb28757,0x63b6017c,0x7e63933e,0x2c4c801b}},	//   שים_, wayn, nonp, vědi_, 
   {{0xdcfc107f,0xd1388034,0x78ba933f,0x63b604da}},	//   tarı, czą_, cstv, tayn, 
   {{0x2ae58611,0x51848163,0x21888273,0x18a28014}},	//   _कहाँ_, _суча, _אָפּ, _таъм, 
   {{0xd4671340,0x787880b0,0xe1fa0537,0x63b61341}},	// [8c0] тите_, níve, мга_, rayn, 
   {{0xa3d70d99,0x22960142,0xdcfc0214,0x7d089342}},	//   _साथ_, _væk_, sarı, _jérô, 
   {{0xd7fa9343,0x63a99344,0x64a61345,0x28c90503}},	//   дул_, kben, _шана, ांगि, 
   {{0x63a99190,0x26cf804f,0xc9528309,0xd91a80c6}},	//   jben, fugo_, סמא_, וועל, 
   {{0x63a9882b,0x78ba826b,0xdb160093,0xfaa61346}},	//   dben, zstv, zayê, _јаго, 
   {{0x71a304bc,0x63a99347,0xdb160093,0x787881d2}},	//   _варз, eben, yayê, díve, 
   {{0x628a9348,0xd9461349,0x3243134a,0xdb0f134b}},	//   _rifo, _реви, _терг, _recé, 
   {{0x61fc134c,0xdfd280fe,0xd706829e,0x7a2d8019}},	//   _harl, _خير_, _изби, _búto, 
   {{0x61fc134d,0xa3e4001b,0x97ea808a,0xa686804a}},	//   _karl, प्य_, ışdı, _алад, 
   {{0x682607bc,0x78ba915b,0x61fe134e,0x61fc134f}},	//   _módu, tstv, ndpl, _jarl, 
   {{0x3ea69350,0xc4c59351,0x1be21352,0x02de02f4}},	//   lpot_, _متنو, खभाल_, नझुन, 
   {{0xa3ce1353,0x23ba8a57,0xa3d7103a,0xdb1601b2}},	//   _राग_, _آداب_, _साध_, rayê, 
   {{0x6f029354,0xd13880a1,0x68261355,0x628a9356}},	//   nvoc, szą_, _nódu, _tifo, 
   {{0x78ba8a06,0x6f029357,0xa4d50deb,0x67200341}},	//   pstv, ivoc, логі, ämja, 
   {{0xfa778052,0xa3ce1358,0x69c812b6,0x97320063}},	//   _שעות_, _राख_, _ödey, لکیا, 
   {{0x7876026b,0x3c318170,0x54541359,0xdb0f04ab}},	//   rávc, _káva_, авст, _decî, 
   {{0x2d9e8e80,0x61fc10e3,0x337500cb,0x06d785a2}},	// [8d0] _ofte_, _barl, угар, _দৈনি, 
   {{0x61fc135a,0x63a99199,0x394b003d,0xdb00935b}},	//   _carl, zben, وشاپ_, lamó, 
   {{0x61fc135c,0xdb0b80b2,0x787603c3,0x27ef83cd}},	//   _darl, _regí, láva, tegn_, 
   {{0xdb0b8068,0xdb06135d,0x61fc0039,0x28c58587}},	//   _segí, _bekä, _earl, _विसि, 
   {{0x6d5a8816,0x7876135e,0x7c2d135f,0x787882fd}},	//   _axta, náva, mkar, xíve, 
   {{0xd77480fe,0x26cf9360,0x787882fd,0x7bc29361}},	//   جامع, rugo_, víve, _adou, 
   {{0xeb999362,0xd4699363,0x7e639364,0xa898004c}},	//   ний_, нике_, ronp, _аксу_, 
   {{0x200d8012,0x7876038b,0x78789365,0xdb0b82fd}},	//   _unei_, káva, tíve, _negã, 
   {{0xc7b28039,0x7c2d1366,0x05d30258,0x17558162}},	//   _לבן_, ikar, _तांब, _свая, 
   {{0x78760a93,0x96f89367,0x63a99368,0xd2438103}},	//   dáva, _جعفر_, sben, рмоқ, 
   {{0x7c2d1369,0x2ba4936a,0x787882fd,0x9f4e001b}},	//   kkar, _ग्वा, síve, čním_, 
   {{0x1ddf8379,0xddd5001b,0x2c098034,0xdb0a0170}},	//   प्रत, mozř, वाओं_, šnéh, 
   {{0x91e5936b,0x28c58bf9,0x09e58aff,0x6e21936c}},	//   _боле, _विवि, _болн, _kolb, 
   {{0x442d936d,0xdd921001,0x3869136e,0xaf7683f3}},	//   lke_, صور_, _ekar_, טערס_, 
   {{0x442d936f,0x7c361370,0x6e21868b,0xed571371}},	//   oke_, thyr, _molb, гор_, 
   {{0x7c2d1372,0x04431373,0x8c431374,0x61fc1375}},	//   gkar, бесн, бесе, _sarl, 
   {{0x9b9300fe,0x442d9376,0x24801377,0x7c361378}},	// [8e0] إلكت, ike_, rmim_, rhyr, 
   {{0xf1a9040c,0xe9d70003,0x05d29379,0x3b83137a}},	//   نامه_, лку_, _साइब, слуг, 
   {{0x442d937b,0x3ebf8012,0x61fe137c,0x7c2d02d1}},	//   kke_, _avut_, rdpl, bkar, 
   {{0x442d937d,0x7c2d137e,0x6aad81d0,0x68fc806d}},	//   jke_, ckar, _ħafn, ærdi, 
   {{0x6e21937f,0x61fc1380,0xc7d70039,0x442d9381}},	//   _bolb, _tarl, רוני_, dke_, 
   {{0x442d8b7e,0x6e219382,0xccfa84c7,0x44221383}},	//   eke_, _colb, ећи_, _hok_, 
   {{0x6aa29384,0x44221385,0xf8c5825d,0xe807000d}},	//   _stof, _kok_, _विषय, षयमा_, 
   {{0x25f080a1,0x7bd61386,0x442d8385,0x628e1387}},	//   _इसकी_, ngyu, gke_, _hibo, 
   {{0xa6ca8a0e,0x5a348cb8,0xa3d705b7,0x29079388}},	//   _سوال_, инит, _सास_, _arna_, 
   {{0xa3e40ed9,0xa2d501ff,0x2ba480da,0xd6cf9001}},	//   प्त_, यंत्, _ग्रा, _رقم_, 
   {{0x8d939389,0x4422138a,0x2907803a,0x1be68daa}},	//   _المش, _ook_, _crna_, _бўлг, 
   {{0x628e138b,0x44220060,0x764a938c,0x557780c6}},	//   _libo, _nok_, lify, _געבן_, 
   {{0xa3ce09d7,0x09cc00cf,0x7c2d138d,0x80c0938e}},	//   _राज_, র্যা, vkar, _विके, 
   {{0xe80b800f,0x7c22938f,0x7c2d1390,0x78761391}},	//   _सोना_, _hoor, wkar, ráva, 
   {{0x16d19392,0x7c2d1393,0x44221394,0x78761395}},	//   _सम्ब, tkar, _bok_, sáva, 
   {{0x09cc00cf,0x44220214,0x26de0123,0x78761396}},	//   র্মা, _cok_, ător_, páva, 
   {{0x44220025,0x7c229397,0x628e1398,0x5b151399}},	// [8f0] _dok_, _moor, _bibo, шмат, 
   {{0x7c2d00b4,0x442d939a,0x628e139b,0x64460265}},	//   skar, zke_, _cibo, _emki, 
   {{0x645a139c,0x4422139d,0x628e139e,0x764a939f}},	//   étic, _fok_, _dibo, dify, 
   {{0x7c2293a0,0xe8d784fc,0x6e218f76,0x72d513a1}},	//   _noor, רואר_, _solb, _комф, 
   {{0x6e2193a2,0x44c101e2,0x644993a3,0x27e913a4}},	//   _polb, lė_, viei, _mban_, 
   {{0x09cc0a87,0x80aa8a87,0x7d08829f,0xa3e78c64}},	//   র্বা, _কিন্, _brds, म्न_, 
   {{0x44c101e2,0x442d93a5,0x442213a6,0xa3dc13a7}},	//   nė_, tke_, _yok_, _ठाम_, 
   {{0x63ad13a8,0x442d93a9,0x9c25804c,0x6a6b01ab}},	//   nban, uke_, рдид, rüfu, 
   {{0x29078131,0x78a493aa,0x63ad13ab,0xeab6801d}},	//   _srna_, _čiva, iban, айы_, 
   {{0x442d93ac,0x44c101e2,0x4a4593ad,0x27e900bf}},	//   ske_, kė_, рнов, _aban_, 
   {{0x69dd0938,0x7c228a2f,0xc32380cf,0x8e848013}},	//   _पानी, _foor, _বেশি_, _الله, 
   {{0x7bc78116,0xdb0f03b8,0xd71c80b2,0x44c10116}},	//   ėjus, _mecâ, _দেয়া_, dė_, 
   {{0x92b78013,0xf77208f7,0x290780e5,0x63bb93ae}},	//   _إحصا, تاد_, _wrna_, maun, 
   {{0x442213af,0x63bb93b0,0xbb3a93b1,0xed5a04c7}},	//   _sok_, laun, _בעני, вог_, 
   {{0x628e13b2,0x614282d4,0x44220385,0xdb0f060e}},	//   _ribo, _меша, _pok_, _decí, 
   {{0x63ad13b3,0x63bb93b4,0x6f0993b5,0x628e13b6}},	//   gban, naun, _orec, _sibo, 
   {{0xe9da0ba0,0xeb9713b7,0x386680fa,0x6aa493b8}},	// [900] кка_, риу_, voor_, _çift, 
   {{0x63bb93b9,0x63ad13ba,0x7af6011a,0x787881d2}},	//   haun, aban, rwyt, díva, 
   {{0xe0da13bb,0xf1dd83ff,0x41dd8f1f,0xeaf285b7}},	//   тве_, _मानन, _मानस, _अन्त_, 
   {{0x35dc0689,0x6f0993bc,0xa3e7800d,0xdb0f002d}},	//   _बाड़, _brec, म्म_, _decâ, 
   {{0x27ff93bd,0x6f098422,0x628e13be,0xe7e80365}},	//   _daun_, _crec, _tibo, ट्या_, 
   {{0x69dd007a,0x7c2293bf,0x6f0993c0,0x7d008019}},	//   _पायी, _soor, _drec, járá, 
   {{0x01bb8a87,0x764a93c1,0x7c2293c2,0x386693c3}},	//   ংলাদ, rify, _poor, poor_, 
   {{0x645613c4,0x6f0993c5,0x27ff93c6,0x69d8809b}},	//   nnyi, _frec, _gaun_, _माही, 
   {{0x7c2293c7,0xd37793c8,0x27e902fa,0xadba80d8}},	//   _voor, ичь_, _rban_, _لهذا_, 
   {{0x7c229169,0x9d4693c9,0x27e693ca,0x5a3493cb}},	//   _woor, _кезд, lfon_, снот, 
   {{0xa3d703b4,0x78760a93,0xdca393cc,0x7bc613cd}},	//   _साल_, rávn, _дахи, _odku, 
   {{0x4ea70004,0x44c10116,0x63ad13ce,0x3e7b8035}},	//   ирга, vė_, xban, rête_, 
   {{0xdb0f011e,0x63a293cf,0x200501d2,0x63ad06a0}},	//   _pecí, _ifon, ěli_, vban, 
   {{0x20050066,0x44c101e2,0xa3e410c5,0x7a32006d}},	//   śli_, tė_, प्स_, _sætn, 
   {{0x9c470c98,0x3a7b83f3,0x9f4f868e,0x7e67068e}},	//   ахал, _שטוד, regé_, rojp, 
   {{0x8f4713a1,0x7055003d,0x27e90e3b,0x1dd3010c}},	//   _вход, _دنبا, _uban_, _ताकत, 
   {{0x290a01e2,0xfb870b99,0x63ad13d0,0xaa7b00e9}},	// [910] _arba_, рывн, rban, _opýt, 
   {{0xe7e80066,0x39a713d1,0x44c10116,0x63bb8a1f}},	//   ट्ठा_, ршав, pė_, zaun, 
   {{0x261413d2,0x6f09803a,0x27ff8b00,0x925813d3}},	//   दारी_, _srec, _paun_, шафт_, 
   {{0xdd1c01d2,0x765a816c,0xe3b813d4,0x785201a8}},	//   _nářa, _ajty, _ключ_, tāvi, 
   {{0xd6db93d5,0x290a13d6,0x8c1a0039,0x7cec0019}},	//   тте_, _erba_, _עושי, _törö, 
   {{0x644d13d7,0x63a293d8,0x14b801a1,0xed5982bb}},	//   liai, _afon, _حدیث_, лол_, 
   {{0x27ff93d9,0x6f09811a,0x44f88028,0x63bb93da}},	//   _taun_, _wrec, _cũ_, taun, 
   {{0x6f098012,0x229b82a5,0x644d13db,0xed580039}},	//   _trec, _pêk_, niai, יבור_, 
   {{0x86988d74,0x63bb93dc,0x386d93dd,0x6f098123}},	//   _вкус_, raun, _iker_, _urec, 
   {{0x6ce7836a,0x629b82c0,0xe4e7836a,0xe8f993de}},	//   _віде, rquo, _відн, гло_, 
   {{0xa3d713d2,0x92d780cf,0x26198a29,0x9f5e000d}},	//   सला_, াবে_, पाठी_, ětí_, 
   {{0x660193df,0x9b9580fe,0xaac70f21,0x62850a67}},	//   _halk, _الإت, _लिंक, hmho, 
   {{0x69c713e0,0xbb858013,0x7c3b93e1,0x645613e2}},	//   _odje, _الشي, mhur, vnyi, 
   {{0x69c70210,0x6da313e3,0x66018008,0xa8790a1c}},	//   _ndje, зира, _jalk, лөөт_, 
   {{0x44e193e4,0x64a613e5,0x2d8c010d,0x2ba6801b}},	//   nó_, саба, äde_, síců_, 
   {{0x64a613e6,0x69dc13e7,0x644d13e8,0x629993e9}},	//   _қама, _scre, giai, _kuwo, 
   {{0x290a003a,0xa3df810c,0xd3b90ad0,0x63b9811a}},	// [920] _srba_, _तान_, русі_, _mewn, 
   {{0xbf9b0077,0x26c213ea,0xdb0f09b2,0xa3e786ce}},	//   ndên, msko_, _decà, म्त_, 
   {{0x31ba8273,0x44e193eb,0x93f9809b,0x787d0019}},	//   רזענ, jó_, ्याच_, séve, 
   {{0x387f8b3a,0x44e193ec,0xe73a836d,0x644d13ed}},	//   _chur_, dó_, лее_, ciai, 
   {{0x26c20f42,0x4432003e,0x7c3b93ee,0x2f1893ef}},	//   nsko_, mky_, dhur, роль_, 
   {{0x443203e0,0x409613f0,0x63a293f1,0x509604c7}},	//   lky_, _грат, _sfon, _грађ, 
   {{0x44e193f2,0x1619000f,0xdc1180b2,0x96c48034}},	//   gó_, दातर_, িউনস_, _रिकॉ, 
   {{0x443213f3,0x44f88028,0x629993f4,0x69c713f5}},	//   nky_, _vũ_, _buwo, _zdje, 
   {{0x8c1b004d,0x26c213ea,0x823893f6,0x9b6a8ce1}},	//   רופי, jsko_, изис_, ышка_, 
   {{0x41dd8365,0x8afb00c6,0x11d880fe,0x660193f7}},	//   _माणस, נהיי, جودة_, _galk, 
   {{0x04968013,0x44e185cb,0xdb0f02ba,0xdfd10a2c}},	//   _الصح, có_, _mecá, ويد_, 
   {{0x4432026b,0xdb0b8172,0x442013f8,0x6e250214}},	//   jky_, _begä, jji_, _sohb, 
   {{0x44320a93,0x442013f9,0x447b8273,0x7c6580fe}},	//   dky_, dji_, _ענדע, _بالل, 
   {{0x442683ec,0x7ae40497,0x44200116,0x63b980a1}},	//   _hoo_, dtit, eji_, _zewn, 
   {{0x7c2613fa,0x94a8064e,0x90a693fb,0x644d13fc}},	//   _bokr, йтта_, _احتم, tiai, 
   {{0x442000f8,0xb4e9078b,0x63b981b2,0x7c2613fd}},	//   gji_, _यही_, _xewn, _cokr, 
   {{0x2fc91101,0x644d13fe,0x44e18068,0x78788038}},	// [930] _idag_, riai, zó_, tívn, 
   {{0x442693ff,0x442000fd,0x386d8332,0x44e186c9}},	//   _loo_, aji_, _sker_, yó_, 
   {{0x43951400,0x4432003e,0xda781401,0x7d081402}},	//   _манс, bky_, сят_, ådst, 
   {{0x44200d99,0x44321403,0x44269404,0x44e19405}},	//   cji_, cky_, _noo_, vó_, 
   {{0x443903e9,0x66018912,0x9f0580fe,0xe610804e}},	//   _ils_, _palk, توشو, کشن_, 
   {{0x44e1811d,0xd1268158,0x44268027,0x6aad0050}},	//   tó_, _قم_, _aoo_, mpaf, 
   {{0x63b98066,0x44269406,0xe3b18013,0xfe70807b}},	//   _pewn, _boo_, ورة_, رده_, 
   {{0x44e19407,0xf42982bb,0x386d80f0,0x66019408}},	//   ró_, роил_, _uker_, _walk, 
   {{0x44e19409,0xe816809b,0xb4d601d1,0x27ed940a}},	//   só_, णारा_, _सम्_, _iben_, 
   {{0x7c3b940b,0x4432003e,0x4420140c,0x44e193eb}},	//   shur, zky_, zji_, pó_, 
   {{0x3ea9002d,0x9d55940d,0x6f0d140e,0x261d120a}},	//   _atat_, _بنات, _arac, मानी_, 
   {{0x186a140f,0xa41405a2,0x44c581a8,0x69da8f89}},	//   рами_, _সত্য_, mē_, agte, 
   {{0x44321410,0x28c5825d,0x44c580f3,0x7c261411}},	//   vky_, _विकि, lē_, _rokr, 
   {{0x44391412,0x7ae41413,0x5bb2002a,0x64a380ca}},	//   _als_, vtit, जर्व, _gđic, 
   {{0x44321414,0x44269415,0x27ed835b,0x8c0100cf}},	//   tky_, _yoo_, _oben_, _একজন_, 
   {{0xd5dc023b,0x6a7002ae,0xe3bf03b9,0x442681df}},	//   _बावज, häft, _poña_, _xoo_, 
   {{0x44201416,0x4432003e,0x42261417,0xb22609c8}},	// [940] rji_, rky_, одав, омал, 
   {{0x44391418,0x44320a93,0x442000a1,0x6aa480fe}},	//   _els_, sky_, sji_, _éife, 
   {{0x7ae41419,0x10a6141a,0x4432003e,0x644b837c}},	//   stit, циен, pky_, _omgi, 
   {{0xa2a2000f,0x7876026b,0x23e10964,0x4f0a80a6}},	//   _कंप्, dávk, _फायद, инен_, 
   {{0x69da806d,0xa25b00e9,0xdb0f0149,0xaac7001b}},	//   ygte, _kvôl, _tecá, _लिएक, 
   {{0x2d4e0122,0x4426941b,0x61460004,0xa3e7941c}},	//   _eнee_, _soo_, _дега, म्स_, 
   {{0xd497941d,0x4426941e,0x672f00a1,0xd5b9941f}},	//   оры_, _poo_, zycj, ссі_, 
   {{0x3cfe8265,0x442682fa,0x7a2d9420,0x68e3075d}},	//   _vstv_, _qoo_, _mútu, ànde, 
   {{0x63a41421,0x44269422,0x69da12b6,0x6a748a1c}},	//   icin, _voo_, _ötes, làfi, 
   {{0x81d280cf,0xcdc582c3,0x200490a3,0x298a9423}},	//   হ্ন_, _науқ, _hami_, исно_, 
   {{0x20049424,0x63a41425,0x4a7b0273,0xc27b00c6}},	//   _kami_, kcin, שריב, שריי, 
   {{0x6f0d1426,0x63a400d7,0x20049427,0x20069428}},	//   _prac, jcin, _jami_, ndoi_, 
   {{0x61ee1429,0x7bc0942a,0x78ad942b,0xa3e38353}},	//   _obbl, mamu, _čave, _पॉट_, 
   {{0x7bc0942c,0x2004942d,0x63a400f3,0xdef801e2}},	//   lamu, _lami_, ecin, цыю_, 
   {{0xdd940ceb,0x6594142e,0x63a40269,0x6ce407c5}},	//   дары, дару, fcin, міте, 
   {{0x320d0180,0x6f0d142f,0x20049430,0x7bc09431}},	//   _şey_, _trac, _nami_, namu, 
   {{0x6f0d1432,0x44c581a8,0x5a351433,0x97ea8a05}},	// [950] _urac, zē_, пнат, ışlı, 
   {{0x7bc09434,0x290e8a63,0xdb19817c,0x78a31435}},	//   hamu, _krfa_, _dewè, ínvo, 
   {{0x7bc09436,0x31c409ba,0x26d91437,0x20049438}},	//   kamu, ьств, luso_, _bami_, 
   {{0xdb1f016c,0xae190034,0x20049439,0x7bc0943a}},	//   naqë, दावन_, _cami_, jamu, 
   {{0xdefb836d,0x81e700cf,0x63bd0029,0x7bc08232}},	//   рые_, _মোঃ_, _iesn, damu, 
   {{0x46d3007a,0xe5a584bc,0xafdb00f0,0x9e348a4f}},	//   _तिनह, чики, rnøy, мечч, 
   {{0x6605143b,0x2004943c,0x1958143d,0x6a70143e}},	//   _mahk, _fami_, _дары_, räft, 
   {{0x6605143f,0x629d1440,0x44399441,0x7bc08232}},	//   _lahk, _kuso, ós_, gamu, 
   {{0xf7498013,0x768b0066,0x6e288142,0x629d1442}},	//   _الذي_, _używ, _fodb, _juso, 
   {{0x2bab8f5a,0x3637807b,0x629d1443,0x63bd1444}},	//   _ट्रा, _بررس, _muso, _lesn, 
   {{0x21698004,0x2004847f,0x60c5016c,0x7bc09445}},	//   сини_, _yami_, nshm, bamu, 
   {{0xa3d712fc,0x24890269,0x26d91446,0x7bc09447}},	//   _साग_, jmam_, fuso_, camu, 
   {{0x66051448,0x20040038,0xdb0b8019,0x78760170}},	//   _bahk, ľmi_, _legú, návi, 
   {{0x443f9449,0x8b058066,0x3d08144a,0x6295144b}},	//   lhu_, _częś, हिले_, _nizo, 
   {{0x69c1944c,0xe3bf0e7c,0x60c500f8,0xc6928039}},	//   male, _coño_, jshm, תאם_, 
   {{0x205500b6,0x69c1944d,0x629d144e,0x26d9144f}},	//   _отыр, lale, _buso, buso_, 
   {{0x63a41450,0x6b631451,0x62950019,0x49ca021d}},	// [960] rcin, екта, _bizo, йлан_, 
   {{0x69c19452,0xdb1d02a5,0x7bc09453,0x63a41454}},	//   nale, _kesê, zamu, scin, 
   {{0x6d438024,0x443f9455,0x20049456,0x7bcb80d7}},	//   jzna, khu_, _pami_, _odgu, 
   {{0x69c19457,0x38a18013,0xfc3200fe,0xdb0400fa}},	//   hale, _mór_, _أحد_, ncië, 
   {{0xfbd30052,0x7bc08073,0x629d029a,0x20049458}},	//   _אתר_, vamu, _guso, _vami_, 
   {{0x69c19459,0xe8df0028,0x7c2400d7,0x62950109}},	//   jale, _giữa_, ljir, _gizo, 
   {{0x69c1945a,0x7bc0945b,0x2ee6945c,0xb5098076}},	//   dale, tamu, stof_, विषय_, 
   {{0x7c240861,0x629d03bf,0xb0d1009b,0xf8c5824c}},	//   njir, _yuso, _हितग, _विजय, 
   {{0x7bc0945d,0x69c188b5,0xdb060063,0x2a6c8764}},	//   ramu, fale, _nekü, todb_, 
   {{0x7bc0945e,0x443f945f,0x69de0385,0x7f3b8039}},	//   samu, ahu_, ngpe, _העמו, 
   {{0x7bc09460,0x64958a63,0xf1dd9461,0x26d902b9}},	//   pamu, _išin, _मारन, wuso_, 
   {{0x315709be,0x66051462,0x7d7b80c6,0x39570039}},	//   ליין_, _sahk, _פראג, לשים_, 
   {{0x69c19463,0x63bd1464,0xe3bf01e0,0xee87019b}},	//   bale, _resn, _soño_, зыво, 
   {{0x69c19465,0x38a1812b,0xe3bf0065,0xd25090ac}},	//   cale, _fór_, _poño_, _جنت_, 
   {{0xa1579466,0x776401e0,0x26d91467,0x7876026b}},	//   _нашу_, _exix, suso_, závi, 
   {{0x26d91468,0x31c6801b,0x629d1469,0xab5d80a1}},	//   puso_, bízí_, _puso, saże, 
   {{0xdb0b8c5e,0x60da80e5,0xdb0400ef,0x2489146a}},	// [970] _segú, lutm, nciè, rmam_, 
   {{0x60c500f8,0x4ad4944a,0x61fa946b,0xddc381ac}},	//   tshm, _दिनव, netl, konš, 
   {{0x6ca4146c,0x63bd146d,0x787d0035,0x7c38033b}},	//   _пряж, _tesn, névo, ñará, 
   {{0x69c1946e,0x60c500f8,0x61fa946f,0x629d0371}},	//   zale, rshm, hetl, _tuso, 
   {{0x26199470,0x61fa9471,0xe80e113a,0x644080fe}},	//   पाली_, ketl, ियता_, dhmi, 
   {{0xf7708743,0x61fa8301,0x442b001c,0x78760170}},	//   دام_, jetl, _hoc_, rávi, 
   {{0x443f9472,0xc2120039,0x7a3b01b2,0x60c51473}},	//   thu_, _בהם_, _gîta, qshm, 
   {{0xc9520052,0x442b1474,0x7bdf1475,0xdb1d016c}},	//   _סמן_, _joc_, ngqu, _nesë, 
   {{0xe82101ff,0x69c19476,0x442b1477,0xa3e50625}},	//   याना_, tale, _moc_, _नान_, 
   {{0x442b0012,0x38a19478,0x443f9479,0xa3df947a}},	//   _loc_, _pór_, shu_, _ताव_, 
   {{0x443f947b,0xa2cf8c74,0xd945947c,0x26c9040a}},	//   phu_, _दिव्, фени, _avao_, 
   {{0x69c1947d,0xcdc90052,0x442b147e,0x6440947f}},	//   sale, _כך_, _noc_, chmi, 
   {{0xa3d70ec1,0xdb060246,0x43749480,0xdb0401f0}},	//   _साज_, _lekò, _пушт, rcië, 
   {{0x69c1872f,0x7ae99481,0xf1ba0106,0x29111482}},	//   qale, mtet, ươi_, _orza_, 
   {{0x6a7d80a6,0x1d070c6a,0xfce31483,0x443d8160}},	//   lèfo, мери_, коро, _klw_, 
   {{0x998381e2,0x320780de,0x26c40019,0xdb1d1484}},	//   ųjų_, _hany_, ámos_, _kesè, 
   {{0x7ae99485,0x7c240b00,0x7c2b8128,0x1a061486}},	// [980] ntet, rjir, _mogr, мпам, 
   {{0x7c2b8422,0x29111487,0x6f041488,0x7ae99489}},	//   _logr, _brza_, _isic, itet, 
   {{0x361b0273,0xeb9a0ad5,0x442b148a,0x26c90053}},	//   _וויד, _мин_, _foc_, _zvao_, 
   {{0xdfcf8013,0x320780de,0x3ea0148b,0x61fa948c}},	//   ليم_, _lany_, _kuit_, zetl, 
   {{0x61fa948d,0xbefa8267,0xbea3948e,0x7ae98019}},	//   yetl, تراض_, вачк, jtet, 
   {{0x768b0d99,0x28db03ff,0x2d9a80f0,0x0caa948f}},	//   _użyt, मूहि, øpe_, отии_, 
   {{0xa3e51490,0x61fa9491,0x5e570273,0xe821000d}},	//   _नाम_, vetl, ויסע_, यामा_, 
   {{0x7bc41492,0x32078050,0x09c6809b,0x442b075d}},	//   naiu, _aany_, लण्य, _xoc_, 
   {{0xae1e83f2,0xa3df9493,0x68e100f9,0x3ea002c0}},	//   पादन_, _तार_, _äldr, _nuit_, 
   {{0x64409494,0x1e839495,0x2fc00a1c,0xa68382c3}},	//   shmi, _алум, _aeig_, _алуд, 
   {{0x61fa9496,0xae220de3,0x443d8da7,0x32079497}},	//   retl, मानन_, _flw_, _dany_, 
   {{0x68e100f9,0x61fa9498,0xf9930039,0x66089499}},	//   _ålde, setl, כרת_, _hadk, 
   {{0x5b36846d,0x32079155,0x69ce01ac,0x61fa82a6}},	//   _تعار, _fany_, _odbe, petl, 
   {{0x3ea0149a,0x6b82807e,0x2e260050,0x3207817c}},	//   _duit_, _izog, _kôfy_, _gany_, 
   {{0xd308810b,0x2bd00073,0x442b00a6,0x2486827e}},	//   _hệ_, तृभा, _poc_, _khom_, 
   {{0x3207852a,0x7a3f80ef,0x69ce149b,0x3ea0149c}},	//   _zany_, _vête, _adbe, _fuit_, 
   {{0x442b149d,0x661a8d55,0xf62b004a,0x7d1c81fb}},	// [990] _voc_, _ontk, _діни_, _ársf, 
   {{0x7a3f8035,0x2009149e,0x2486808b,0x6b8282a8}},	//   _tête, _haai_, _lhom_, _mzog, 
   {{0x7ae9949f,0xd308801c,0x629880de,0xa3df94a0}},	//   ztet, _lệ_, _mivo, _ताल_, 
   {{0xa2cf94a1,0x7ae994a2,0xec350273,0x644800a6}},	//   _दिल्, ytet, _נאָר_, èdit, 
   {{0x660894a3,0x2ee900bf,0x7c2b83df,0x6b828a39}},	//   _badk, _jqaf_, _rogr, _nzog, 
   {{0x629894a4,0xa3cd0353,0x200906a4,0x7c2b94a5}},	//   _nivo, रणव_, _laai_, _sogr, 
   {{0x660894a6,0x6d470208,0x320794a7,0x69c514a8}},	//   _dadk, nzja, _rany_, mahe, 
   {{0x9b0594a9,0xcd980c2d,0x69c514aa,0x248694ab}},	//   езид, ודות_, lahe, _chom_, 
   {{0xed5881ac,0xfe0f14ac,0x629894ad,0x443d82fd}},	//   _veľa_, ायास_, _bivo, _vlw_, 
   {{0x7ae994ae,0x69c514af,0x44e881b2,0x660894b0}},	//   rtet, nahe, bû_, _gadk, 
   {{0x7ae994b1,0x09d500cf,0x61e1012b,0xd00a14b2}},	//   stet, স্থা, _öllu, пене_, 
   {{0x7a32012b,0x7878826b,0x764380e5,0x23608170}},	//   _hætt, tívi, lhny, _žije_, 
   {{0x32078573,0x69c514b3,0x200901b0,0x765514b4}},	//   _tany_, kahe, _daai_, fizy, 
   {{0xceb294b5,0x09d50a87,0xfc3f0659,0x63a994b6}},	//   רים_, স্তা, _alí_, lcen, 
   {{0x75f38085,0xa80606c8,0x69c514b7,0x7a32007f}},	//   mızı, _alış, dahe, _mætt, 
   {{0x98a701d2,0x3ea009cc,0x52aa0086,0x2af382f4}},	//   šně_, _tuit_, звам_, _अहाँ_, 
   {{0x969614b8,0x1e9614b9,0xfd658028,0xfc3f00fe}},	// [9a0] _прош, _прор, _chuẩ, _dlí_, 
   {{0x75f386c8,0xa3dc14ba,0x69c514bb,0xe814002a}},	//   nızı, _ठाक_, gahe, _तोता_, 
   {{0xa3df94bc,0x78ab802d,0x261d00c9,0x660894bd}},	//   तला_, _învă, मारी_, _radk, 
   {{0xe29a14be,0x41e2009b,0xa06794bf,0x63a994c0}},	//   _нам_, _पावस, наха_, jcen, 
   {{0xe73794c1,0x645614c2,0x69c514c3,0x26dd93fd}},	//   нец_, miyi, bahe, guwo_, 
   {{0x645614c4,0x63a994c5,0x20e0009b,0x69ce006d}},	//   liyi, ecen, खंदळ_, _udbe, 
   {{0x629894c6,0x2486806c,0x649581f7,0x320a0050}},	//   _rivo, _phom_, _išij, _iaby_, 
   {{0xdb0f011e,0x764394c7,0xdb1d0093,0x44e8824a}},	//   _recú, ahny, _mesî, rû_, 
   {{0xeaaf803d,0x81e700b2,0xa01b007f,0x6d4701bb}},	//   یعی_, _মোট_, llög, zzja, 
   {{0xc3330039,0xd3088028,0x63a994c8,0x5a34832a}},	//   טוח_, _vệ_, acen, тнот, 
   {{0xa3e881b7,0x765514c9,0xab5d80a1,0x63a994ca}},	//   _बाप_, vizy, raża, bcen, 
   {{0xfaa694cb,0x23669123,0x80d314cc,0x9cd782f9}},	//   _задо, _txoj_, _डिसे, _טובה_, 
   {{0x6444013b,0x64560816,0x69c514cd,0xe66714ce}},	//   dhii, diyi, yahe, етво, 
   {{0x61fe14cf,0x320a01b0,0x614680ef,0x200906a4}},	//   jepl, _naby_, _célé, _waai_, 
   {{0xe8211089,0x5fd0809b,0x69c514d0,0xbd6814d1}},	//   यादा_, हणाल, vahe, ерте_, 
   {{0x60de0a00,0x9f520e7c,0x765506e0,0x6aa282b9}},	//   dupm, _cayó_, sizy, _kuof, 
   {{0xc29914d2,0x69c514d3,0x3a750103,0x4395004c}},	// [9b0] дках_, tahe, влар, таас, 
   {{0x996714d4,0xddc714d5,0x6467026b,0xbbeb003d}},	//   нтел, bojš, _špič, _کردم_, 
   {{0x69c514d6,0x7a3214d7,0x659504d9,0xe61f801c}},	//   rahe, _rætt, _јану, _đô_, 
   {{0x7a320681,0x44cc800d,0x69c514d8,0x644414d9}},	//   _sætt, dě_, sahe, chii, 
   {{0xd90f011d,0x320a14da,0x764380e5,0x69c50504}},	//   _گیا_, _faby_, thny, pahe, 
   {{0xee3894db,0x7aed0019,0x20098116,0x657a94dc}},	//   нні_, mtat, žai_, _byth, 
   {{0x25e90a29,0xd90f011d,0x44290116,0x78ad811b}},	//   _जानी_, _دیا_, oja_, _čavo, 
   {{0xeb9994dd,0x764380db,0x7aed02fb,0x6d5814de}},	//   мий_, shny, otat, _žvak, 
   {{0xe7db14df,0x248d94e0,0x7a3200c0,0x48648086}},	//   _भाजप, rmem_, _tætt, _сърб, 
   {{0x442914e1,0x63a994e2,0x7aed14e3,0x6aa2839d}},	//   hja_, scen, itat, _duof, 
   {{0x442914e4,0x186a02d4,0x7aed016c,0x63a98a6c}},	//   kja_, дани_, htat, pcen, 
   {{0x2d8587fa,0x442914e5,0x614694e6,0xb6a603ad}},	//   _izle_, jja_, _sélé, кимл, 
   {{0xe28e94e7,0x442914e8,0x7c2994e9,0xf092896e}},	//   _ва_, dja_, mjer, ינט_, 
   {{0xc0a8840c,0xda11007a,0x7c298615,0x7c3b94ea}},	//   بایل_, _डोलत_, ljer, lkur, 
   {{0x442f90f1,0x1fb614eb,0xed5a004b,0x7aed14ec}},	//   _kog_, _испр, фов_, etat, 
   {{0x442914ed,0x442f94ee,0x69c394ef,0xe8df0106}},	//   gja_, _jog_, _hene, _nhựa_, 
   {{0x614683e9,0x442f822a,0x69c394f0,0x7aed02b7}},	// [9c0] _télé, _mog_, _kene, gtat, 
   {{0x69c394f1,0x644414f2,0x4a4314f3,0x442914f4}},	//   _jene, shii, анув, aja_, 
   {{0x442914f5,0x7c3b94f6,0x442f8387,0x2dd900c6}},	//   bja_, kkur, _oog_, _אַרב, 
   {{0x44290d99,0x442f94f7,0x44cc800d,0xdefa81e5}},	//   cja_, _nog_, vě_, дык_, 
   {{0x7aed14f8,0xb86594f9,0xab5d80a1,0xdee394fa}},	//   ctat, دالو, ważn, иоци, 
   {{0x09cc00cf,0x649580d7,0x44cc801b,0x98a70123}},	//   র্জা, _ušij, tě_, ână_, 
   {{0x442f94fb,0x7769811e,0xe976003d,0x409694fc}},	//   _bog_, _exex, _شهرد, _арат, 
   {{0x442f81c8,0xdb0b8077,0x629c14fd,0x7c2994fe}},	//   _cog_, _negó, _hiro, gjer, 
   {{0x629c14ff,0xbea6809f,0x3f848284,0x657a8324}},	//   _kiro, _разк, _uzmu_, _wyth, 
   {{0x69c39500,0x44291501,0x629c1502,0x65691503}},	//   _cene, zja_, _jiro, şehi, 
   {{0x629c1504,0x69c39505,0x7aed1506,0xd48f9507}},	//   _miro, _dene, ztat, _вр_, 
   {{0x320a8791,0x76588010,0xc1730039,0xe53780c6}},	//   žby_, livy, יחת_, _שטאט_, 
   {{0x44291508,0x69c39509,0xada2807f,0x2fc480bf}},	//   vja_, _fene, _þúsu, _memg_, 
   {{0x442f81ea,0x7c2f150a,0x6f16150b,0x629c150c}},	//   _zog_, _socr, _dryc, _niro, 
   {{0x442f950d,0x69c8950e,0x16df8bf5,0xa3d50103}},	//   _yog_, made, _नम्ब, ловч, 
   {{0x030e150f,0x7aed1510,0x3d080365,0x69c39511}},	//   सिंह_, ttat, हिजे_, _zene, 
   {{0x629c1512,0x7aed0123,0x368b099f,0x5b150188}},	// [9d0] _biro, utat, _осон_, ымат, 
   {{0x44291513,0x7aed1514,0x69c888b6,0xa3e50365}},	//   sja_, rtat, nade, _नाव_, 
   {{0x7aed1515,0x629c1516,0x44291517,0xdb0b80a6}},	//   stat, _diro, pja_, _segü, 
   {{0x44290210,0x629c0029,0x7aed1518,0x69c89519}},	//   qja_, _eiro, ptat, hade, 
   {{0x442f951a,0x7c298310,0x629c02a5,0x4421801c}},	//   _rog_, vjer, _firo, _đh_, 
   {{0x629c151b,0x6442836d,0x442f8103,0x6d580116}},	//   _giro, _aloi, _sog_, _žvai, 
   {{0x69c8939c,0x7c299190,0x442f951c,0x6442951d}},	//   dade, tjer, _pog_, _bloi, 
   {{0x63ad151e,0x69c3951f,0x13099520,0x64429521}},	//   ncan, _sene, ений_, _cloi, 
   {{0x69c39522,0xa06980b6,0x7c299523,0x628a8013}},	//   _pene, _жаңа_, rjer, _bhfo, 
   {{0x69c89524,0x42259525,0x64429526,0x6f099527}},	//   gade, удов, _eloi, _isec, 
   {{0xa2cf8758,0x56948229,0xe4e487c5,0x7c3b8e14}},	//   _दिक्, _тафт, _вічн, pkur, 
   {{0x38a8824a,0x64429528,0xb8cb9529,0x5fab81d2}},	//   _dûr_, _gloi, _कं_, _छलफल, 
   {{0x63bb847a,0xa3e880d5,0x69c3952a,0x69c8952b}},	//   mbun, _बात_, _tene, bade, 
   {{0xa2d8830a,0xf1e2000d,0x63bb952c,0xfce6152d}},	//   _मित्, _पाइन, lbun, лого, 
   {{0xa3e503c9,0xdb1d01d2,0x29078105,0x9d43152e}},	//   _नाश_, _desí, _usna_, берд, 
   {{0x6f16152f,0x6f0981de,0x6e3c1530,0x60da0172}},	//   _tryc, _osec, skrb, _åtmi, 
   {{0x629c1531,0x63bb82ae,0x3b86055a,0x320101cb}},	// [9e0] _piro, ibun, улаг, fehy_, 
   {{0x200208b1,0x7bc99532,0x63ad1533,0x09d580b2}},	//   leki_, haeu, acan, ত্রা, 
   {{0x25e91529,0x291e0ba7,0xa494003d,0x645a1534}},	//   _जाती_, _štab_, _نیست, étis, 
   {{0x63ad009f,0x69c89535,0x629c1536,0x61e50336}},	//   ccan, zade, _wiro, aghl, 
   {{0x69c89537,0x68e19538,0x2ca58097,0xa2cf8c74}},	//   yade, huld, _auld_, _दिग्, 
   {{0x24800210,0xd252015e,0x69c89539,0x6442865e}},	//   llim_, _طنز_, xade, _sloi, 
   {{0xa3e8953a,0x69c8953b,0x7bc6153c,0x6f098338}},	//   _बाद_, vade, _keku, _esec, 
   {{0x2002153d,0x63bb953e,0x68e1953f,0x76589540}},	//   jeki_, gbun, duld, sivy, 
   {{0x38558574,0x6edb92e1,0x38a880ef,0xdb041541}},	//   _търс, _नियु, _sûr_, mbió, 
   {{0x7bc61542,0x2ca58142,0xdd8f9543,0x64a69544}},	//   _leku, _fuld_, _کوم_, _бажа, 
   {{0x63ad008c,0xe8210560,0x2ca59545,0x6e9380fe}},	//   ycan, याला_, _guld_, _اللا, 
   {{0x27e68e3b,0x7bc61546,0x6485875e,0x71f78068}},	//   ngon_, _neku, lóin, پریس_, 
   {{0xd90e807b,0x63ad029f,0xb8cb8587,0xdef8021d}},	//   زیک_, vcan, _कू_, лыр_, 
   {{0xdd20800d,0x539b8130,0x29180c9f,0x25e894ac}},	//   _může, _ניגו, _orra_, च्ची_, 
   {{0x68e183b8,0xdb1d0065,0x63a283ec,0xdd950162}},	//   culd, _vesí, _kgon, равы, 
   {{0x20020214,0x63ad0149,0xf1e2001b,0x93b510d1}},	//   ceki_, ucan, _पाउन, рбац, 
   {{0x29180019,0x28da800d,0x325513d1,0x63a29547}},	// [9f0] _arra_, _भिडि, авар, _mgon, 
   {{0x200d80f6,0x61e501df,0xc0cb02c3,0x320e840a}},	//   _saei_, ughl, еуде_, _jafy_, 
   {{0x63a29548,0x320e852a,0x32011549,0x78ad8183}},	//   _ogon, _mafy_, rehy_, _čavk, 
   {{0x63a2954a,0x7bc6154b,0x27e68ddd,0x64b181a8}},	//   _ngon, _geku, ggon_, _jāie, 
   {{0x260a009b,0x2918154c,0x61f883d0,0x65c58103}},	//   ायची_, _erra_, _obvl, абла, 
   {{0xe618805a,0xed5986b4,0x63a2954d,0x20020b14}},	//   лді_, кол_, _agon, zeki_, 
   {{0xce380039,0x51840162,0x7bc6008a,0x29050495}},	//   ראות_, _гута, _yeku, _èla_, 
   {{0x201f8012,0x68e1954e,0x3dc5954f,0x7afd0128}},	//   _unui_, vuld, _welw_, _kpst, 
   {{0x42c68741,0x63bb89e5,0x7bc99550,0x28c282f4}},	//   агын_, rbun, raeu, वीसि, 
   {{0x69c71551,0x38691552,0xdb041553,0x63a28109}},	//   _jeje, _ajar_, nciá, _egon, 
   {{0x21699554,0xa9699555,0x60261556,0x7c2d1557}},	//   тини_, тина_, адна, kjar, 
   {{0x7afd1558,0x7a3b02a5,0x69c71559,0x20560ff8}},	//   _opst, _dîti, _leje, ртор, 
   {{0x387e8700,0x81dd00cf,0x2002155a,0x442d955b}},	//   _être_, থ্য_, reki_, mje_, 
   {{0x443f8f2c,0x6449955c,0x69c7001b,0x6603955d}},	//   lku_, lhei, _neje, nenk, 
   {{0x7afd0029,0x776d011e,0x442d8116,0xdd920061}},	//   _apst, _exax, oje_, زور_, 
   {{0x6449955e,0x6603955f,0x44f1801c,0xfce60a09}},	//   nhei, henk, _mơ_, лоҳо, 
   {{0x64a4005a,0x69c70068,0x645a02c0,0x207b00c6}},	// [a00] раға, _beje, étiq, _באקא, 
   {{0xba231560,0x41b60004,0x601b036d,0x442d9561}},	//   одук, рсат, _tämä, hje_, 
   {{0x443f9562,0x442d8af6,0x7bc61563,0x69c71564}},	//   kku_, kje_, _teku, _deje, 
   {{0x1ae61565,0x443f803a,0x644980fa,0xf09300c6}},	//   _комм, jku_, jhei, ַנג_, 
   {{0x27e69566,0x442d9567,0x443f89d8,0xc5f8805a}},	//   rgon_, dje_, dku_, лға_, 
   {{0x443f8029,0x44221568,0x66039569,0x442d80a1}},	//   eku_, _hnk_, genk, eje_, 
   {{0x44f1810b,0x7ae4156a,0xb4e40562,0x644980fe}},	//   _cơ_, luit, _नमो_, fhei, 
   {{0x442d956b,0x6449956c,0x6281956d,0x10a3156e}},	//   gje_, ghei, ello, _фитн, 
   {{0x326689e4,0xd5c6156f,0x765c1570,0x23388008}},	//   итов, वराज, kiry, уппы_, 
   {{0x442d9571,0x443f9572,0x7c2d1573,0x44221574}},	//   aje_, aku_, zjar, _lnk_, 
   {{0x85068f2a,0x443f8507,0x442d8bfc,0x64498540}},	//   _خوان, bku_, bje_, bhei, 
   {{0x64499575,0x442d8d99,0x38669576,0x443f8802}},	//   chei, cje_, nnor_, cku_, 
   {{0x7c228122,0xfe221577,0x95cb1004,0x7c2d1578}},	//   _inor, मांस_, кува_, vjar, 
   {{0x7ae41579,0x6446157a,0xdbf880cf,0x30a6957b}},	//   duit, _alki, _অফিস_, _крив, 
   {{0x69c7157c,0x0ed30076,0x44f1812f,0xb0f8957d}},	//   _reje, _तिकड, _xơ_, _сейф_, 
   {{0xe5178611,0x69c7157e,0x3869157f,0x66039580}},	//   थिति_, _seje, _ujar_, zenk, 
   {{0x7ae41581,0x7c2d1582,0xdb1982ae,0xf1a7130c}},	// [a10] guit, rjar, _gewä, арен, 
   {{0xe4e71583,0x443f827b,0xdb1d0207,0x442d9584}},	//   _кімн, zku_, _cesá, zje_, 
   {{0x442d9585,0x69c71586,0x644981b0,0x3ea900f6}},	//   yje_, _veje, yhei, _huat_, 
   {{0x3ea9046a,0x7ae41587,0x386681e9,0x6603812c}},	//   _kuat_, buit, gnor_, wenk, 
   {{0x66039588,0x443f9589,0x44f18028,0x442d958a}},	//   tenk, vku_, _sơ_, vje_, 
   {{0xc3320273,0x3ea9102e,0x64a5804c,0xdca584bc}},	//   _צום_, _muat_, бака, баки, 
   {{0x442d958b,0x3ea9158c,0x6449958d,0x58d4158e}},	//   tje_, _luat_, thei, _морт, 
   {{0xa2d881aa,0x442d81e2,0x6603958f,0x443f9590}},	//   _मिश्, uje_, senk, uku_, 
   {{0x64499591,0xa3e8908a,0xa3e50056,0x66038ae0}},	//   rhei, _बार_, _नाई_, penk, 
   {{0x442d9592,0x64499593,0xa2d89594,0x4a459595}},	//   sje_, shei, _मिर्, снов, 
   {{0x2fc90b10,0x442d9596,0x8467809f,0x3f861597}},	//   _beag_, pje_, _къде, _šou_, 
   {{0x3ea91598,0x64409599,0x442d816c,0x6f1b959a}},	//   _buat_, ckmi, qje_, _kruc, 
   {{0x02a78d39,0x683f00f8,0x44d300a1,0xac7480fe}},	//   _трем, _mëdh, eć_, _بالش, 
   {{0x6d4e01ab,0xa3e501a2,0x7c22959b,0x7ae4159c}},	//   tzba, _नाउ_, _znor, vuit, 
   {{0x3205959d,0x50b58482,0x25e912b9,0xf1ca026b}},	//   mely_, _услу, _जारी_, ntáž_, 
   {{0x7ae4159e,0x47c6159f,0xb603827b,0x68e50128}},	//   tuit, _убив, _hráč, duhd, 
   {{0x232715a0,0xab2715a1,0xe1fa0c42,0x44d30034}},	// [a20] боти_, бота_, лга_, ać_, 
   {{0x78a908dc,0xac08004a,0x3ea101f7,0x78a095a2}},	//   _čevr, ынға_, _giht_, _simv, 
   {{0x0ce295a3,0xa3e8812e,0x7ae415a4,0xd17901e2}},	//   _মন্ত, _बाल_, suit, асці_, 
   {{0xa2d8800c,0xdd2c8116,0x320595a5,0x442215a6}},	//   _मिल्, _nėšt, hely_, _unk_, 
   {{0x320595a7,0x386695a8,0xa2a20562,0x78bb1146}},	//   kely_, rnor_, _कंट्, _čuve, 
   {{0x6f1b82ae,0x320581cb,0xdb1d00c0,0x787d15a9}},	//   _druc, jely_, _besæ, névr, 
   {{0xd132046d,0xa3cc00da,0xa7fb03b9,0x61e301fb}},	//   _عمر_, _रजा_, liñe, ónle, 
   {{0xf06395aa,0x6f1b95ab,0xe8e0001c,0xa2b495ac}},	//   _експ, _fruc, _chụp_, обич, 
   {{0x25e915ad,0x6440807f,0x6611819b,0x2fc90036}},	//   _जाली_, rkmi, ökkä, _reag_, 
   {{0xd90e8f2a,0x64408079,0xa92a82c3,0x683f09b8}},	//   فیت_, skmi, гіме_, _zëdh, 
   {{0x2012153c,0x5d868013,0x5316815e,0x28f887c5}},	//   _bayi_, _الال, _گذار, шень_, 
   {{0x96eb0162,0x7c2295ae,0x9f9915af,0x3ea9068e}},	//   льга_, _unor, ивну_, _puat_, 
   {{0x3ea915b0,0x2127012f,0x3c388035,0x320595b1}},	//   _quat_, ̣nh_, _févr_, bely_, 
   {{0x6d1401ff,0x1bf895b2,0xe6671507,0x25a512fb}},	//   डिंग_, ्जवल_, стмо, øll_, 
   {{0x321100a1,0x64a38183,0x64958027,0x20120e0b}},	//   _razy_, _uđit, _tšit, _fayi_, 
   {{0x0ca815b3,0x321106a8,0x6f0d15b4,0x69ca95b5}},	//   стри_, _sazy_, _tsac, _hefe, 
   {{0x6f0d0531,0x69ca95b6,0xe7cc8034,0xdefb0c30}},	// [a30] _usac, _kefe, ारनप, _сый_, 
   {{0xa3e5150f,0x6b8295b7,0x27ed95b8,0x69ca95b9}},	//   _नाक_, _myog, _scen_, _jefe, 
   {{0x201202d7,0x69ca84e2,0x6607008d,0x6e250050}},	//   _yayi_, _mefe, mejk, _inhb, 
   {{0xac1915ba,0x69ca95bb,0x764882ef,0x321115bc}},	//   _тому_, _lefe, _aldy, _wazy_, 
   {{0x644d15bd,0x69ca80d0,0xd6db8e25,0xd7f884bc}},	//   mhai, _oefe, уте_, сух_, 
   {{0xf7708c93,0x644d15be,0x5bb38c2e,0x69ca95bf}},	//   ران_, lhai, ीर्व, _nefe, 
   {{0xb0660008,0x91fc80f3,0x320595c0,0xc2121176}},	//   ntää, rnāl, vely_, _קהל_, 
   {{0x69d895c1,0x62850208,0x995415c2,0x69ca82d7}},	//   _adve, llho, _эксц, _aefe, 
   {{0x52a6925e,0x32058e8a,0x69ca95c3,0x290e811e}},	//   овым_, tely_, _befe, _asfa_, 
   {{0xe8f995c4,0x6b82813b,0xf1a580a6,0x5f1d15c5}},	//   ало_, _dyog, өрүн, मिन्_, 
   {{0x386d8ecf,0x69d80077,0x69ca95c6,0x644d15c7}},	//   _kjer_, óvei, _defe, khai, 
   {{0xdb1d036d,0x7643872c,0x645980bb,0xa3e5010e}},	//   _kesä, lkny, _umwi, _नाग_, 
   {{0xe9ce95c8,0x644d15c9,0x7bcb80f3,0x764380db}},	//   _ок_, dhai, _iegu, okny, 
   {{0x764395ca,0x69ca95cb,0xd94595cc,0xe7e60808}},	//   nkny, _gefe, _мели, _काका_, 
   {{0x2d8c037c,0x7bcb8839,0x35a300a6,0x6da315cd}},	//   åde_, _kegu, дарг, дира, 
   {{0x644d15bd,0x628515ce,0xed5a0229,0x7bcb95cf}},	//   ghai, elho, гоҳ_, _jegu, 
   {{0xe7ff8b45,0x764380e5,0xd042008a,0x764b0162}},	// [a40] ोजना_, kkny, xslə, _įgyv, 
   {{0x7bcb95d0,0xa7fb04e0,0x69c195d1,0x25fb8bf5}},	//   _legu, riñe, nble, ल्मी_, 
   {{0x644d15bd,0x03a615d2,0x60c7027e,0x69c195d3}},	//   bhai, _мино, _cwjm, ible, 
   {{0x644d1521,0xef1a95d4,0x6edb83ff,0xa7fb0065}},	//   chai, име_, _निशु, piñe, 
   {{0x7c2615d5,0x2f1895d6,0x386d847f,0x63b40034}},	//   _inkr, соль_, _djer_, ągną, 
   {{0x386d8142,0x6aa395d7,0x78a407d7,0x217615d8}},	//   _ejer_, _ninf, _liiv, _дубр, 
   {{0x69ca95d9,0x3af406a0,0xbc4a95da,0x344a95db}},	//   _refe, läp_, ичие_, ичин_, 
   {{0x4432052a,0x64440008,0x69ca95dc,0x69c195dd}},	//   njy_, nkii, _sefe, eble, 
   {{0x7e7c15de,0x9e6695df,0x1666809f,0x213e811a}},	//   korp, _двад, _двам, wyth_, 
   {{0x7af601e2,0x764395e0,0x645f03ad,0x518683ad}},	//   ityt, ckny, ziqi, жума, 
   {{0x7c2615e1,0x6e3715e2,0x3a3800bf,0x644d15e3}},	//   _onkr, _roxb, _morp_, yhai, 
   {{0x69ba83ff,0x6aa395e4,0x644d01c8,0xfaa695e5}},	//   _श्री, _einf, xhai, _дадо, 
   {{0xdefb15e6,0x442695e7,0x09d500b2,0x69ca8504}},	//   шын_, _ino_, স্টা, _tefe, 
   {{0x442695e8,0x3f850029,0x7c2615e9,0x2057004a}},	//   _hno_, ālu_, _ankr, стүр, 
   {{0x644d15ea,0x349515eb,0x660715ec,0x7bcb95ed}},	//   thai, завр, rejk, _yegu, 
   {{0xe0198560,0x68e895ee,0x442680db,0x8cdc1352}},	//   _नोंद_, mudd, _jno_, _फिरो, 
   {{0xa3e895ef,0x62850504,0xb0660008,0x442695f0}},	// [a50] _बाई_, tlho, stää, _mno_, 
   {{0x6595013f,0x7c260bfc,0x09e300b2,0x387f95f1}},	//   _напу, _enkr, ন্না, _skur_, 
   {{0xdb098013,0x3a380387,0x68e895f2,0xceb981d2}},	//   iceá, _dorp_, nudd, _stř_, 
   {{0x26c915f3,0x44268371,0x645f03ad,0x3a380064}},	//   _kwao_, _nno_, qiqi, _eorp_, 
   {{0x7bcb95f4,0x645d15f5,0x68e895f6,0xd24715f7}},	//   _regu, _imsi, hudd, _дэви, 
   {{0x442695f8,0x44391284,0x68e895f9,0x2cac95fa}},	//   _ano_, _hos_, kudd, _budd_, 
   {{0x443915fb,0x7bcb95fc,0x044595fd,0x764395fe}},	//   _kos_, _pegu, зейн, rkny, 
   {{0x443915ff,0x387f822c,0x6aa39600,0xffe4855a}},	//   _jos_, _ukur_, _sinf, _оюун, 
   {{0x44391601,0x9f4f8e7c,0x7bcb9602,0xab659603}},	//   _mos_, regó_, _vegu, явил, 
   {{0x44391604,0x44269605,0x7e55803f,0x78a4019b}},	//   _los_, _eno_, _عناص, _siiv, 
   {{0x2cac9606,0x7bcb9607,0x3ead9608,0x69c19609}},	//   _gudd_, _tegu, _huet_, rble, 
   {{0x44d7802d,0x6aa3960a,0xe8df001c,0xbbaa1529}},	//   mă_, _winf, _chứa_, _कलेक, 
   {{0x7d1e0a06,0x644b960b,0x44d7802d,0x2fcd81df}},	//   _srps, _ilgi, lă_, _meeg_, 
   {{0x2fcd960c,0x4439160d,0x68e8960e,0x629d801b}},	//   _leeg_, _aos_, budd, ůsob, 
   {{0x44d78012,0x7ae9960f,0x4426811a,0x78a41610}},	//   nă_, luet, _yno_, _tiiv, 
   {{0x44260422,0x2fcd9123,0x5baa1611,0x44391612}},	//   ño_, _neeg_, скам_, _cos_, 
   {{0x44391613,0x78bb003a,0xe9da1224,0xdcf49527}},	// [a60] _dos_, _čuva, йка_, _đačk, 
   {{0xa7fb04e0,0x7c399614,0x3af40341,0x64441615}},	//   miña, _lowr, räp_, skii, 
   {{0xe8210365,0xe8fa136b,0x7af61616,0xa3e50f82}},	//   याचा_, сле_, styt, _नाच_, 
   {{0xa3ea800c,0xfaa605c2,0x1bea80a1,0x44391617}},	//   _टाइप_, _намо, _टाइल_, _gos_, 
   {{0x9cf880b2,0x7bc41618,0x2fcd9619,0xdfcf80a7}},	//   _আছেন_, mbiu, _deeg_, ايه_, 
   {{0x443901c8,0x644b8162,0x412a161a,0xb146161b}},	//   _zos_, _algi, _лого_, _енгл, 
   {{0xe7ed0365,0x4439027e,0x69dc00f0,0x44d78123}},	//   _झाला_, _yos_, _idre, gă_, 
   {{0xb6038029,0x69ce161c,0x68e302ba,0x4439161d}},	//   ēšan, _hebe, ánde, _xos_, 
   {{0x69ce03a1,0x7ae9961e,0x66e3961f,0xdee39620}},	//   _kebe, guet, _пота, _поти, 
   {{0x64aa800d,0x69ce0708,0x78ad9621,0x2eb585cf}},	//   _přid, _jebe, _čavr, _ісус, 
   {{0x44d78012,0x6e288142,0x69ce1622,0x7ae402ae}},	//   că_, _indb, _mebe, hrit, 
   {{0x44269623,0x69ce1624,0x7c39817c,0x5f1381cc}},	//   _uno_, _lebe, _gowr, _धनम्_, 
   {{0x69dc0025,0x44391625,0x68e89626,0x7ae98685}},	//   _odre, _ros_, sudd, cuet, 
   {{0x8cb109d7,0x69ce1627,0x6266846c,0xbeed1628}},	//   _आंदो, _nebe, _عاشق, _जमीन_, 
   {{0x92e900cf,0x44391629,0x7ae40079,0x6fcc809b}},	//   _মনে_, _pos_, erit, ारां, 
   {{0x69dc162a,0x7ae4162b,0x69ce0122,0x765e162c}},	//   _adre, frit, _aebe, _empy, 
   {{0x4439162d,0x69ce162e,0x44d78012,0xe3b007db}},	// [a70] _vos_, _bebe, ză_, ارف_, 
   {{0x4439162f,0x35b50004,0x19ab1630,0x200b1631}},	//   _wos_, _юбор, стап_, leci_, 
   {{0x69ce1632,0x44391633,0x39471634,0x7ae402fb}},	//   _debe, _tos_, áns_, arit, 
   {{0x44d78123,0x4add8de3,0x2fcd822a,0x9cd60309}},	//   vă_, _मिलव, _qeeg_, _קורה_, 
   {{0x3ea58079,0x2489013b,0x2fc0833b,0x66171635}},	//   _pilt_, mlam_, ñiga_, _kaxk, 
   {{0x69ce1636,0x44d78012,0x19590188,0x1dbf14a0}},	//   _gebe, tă_, _дагы_, ्रित, 
   {{0x7bcf05b5,0x661708c6,0x78a2826b,0x7c3980a1}},	//   _kecu, _maxk, ňova, _powr, 
   {{0x44d78012,0x3ea5863c,0x200b1287,0x27ff9637}},	//   ră_, _wilt_, jeci_, _ubun_, 
   {{0x44d7802d,0x7bcf1638,0x4add809b,0x1dbf009b}},	//   să_, _mecu, _मिळव, ्रात, 
   {{0xe0d99639,0x69ce02d1,0x3945963a,0x2d8580a1}},	//   ово_, _xebe, дног, _tyle_, 
   {{0x69c50c9f,0x7ae401ac,0xafe60103,0x7ae9963b}},	//   ibhe, zrit, монл, suet, 
   {{0x25c601cf,0x7bcf0123,0xa7fb0065,0x7ae4019b}},	//   वर्ण, _necu, tiña, yrit, 
   {{0x6d43963c,0xba558086,0x998300ce,0x38040ff6}},	//   lyna, _откъ, _kojų_, _ҷойҳ, 
   {{0xc87902bc,0xa7fb04e0,0x09e300b2,0xdb218217}},	//   duğu_, riña, ন্তা, _ñuño, 
   {{0xbea3163d,0x7bcf163e,0x98720170,0xa7fb03b9}},	//   тарк, _becu, láč_, siña, 
   {{0x69ce163f,0xd9f01640,0xd7ff002d,0x7e638269}},	//   _sebe, _चाहत_, şări_, hinp, 
   {{0x78ae1641,0x64bc0024,0x78bc0269,0x7bcf1642}},	// [a80] _subv, _očig, _strv, _decu, 
   {{0x7ae41643,0x24891644,0x1cba003f,0xe8df001c}},	//   rrit, alam_, _واجب_, _chữa_, 
   {{0xfbc61645,0xdb1d01e0,0x7bcf1127,0x26189646}},	//   _обно, _xesú, _fecu, _योगी_, 
   {{0xab2a1647,0x31368273,0x24891648,0x66e69649}},	//   _дома_, ונעם_, clam_, дода, 
   {{0x69ce164a,0x09e300b2,0x394601a8,0xe737964b}},	//   _tebe, ন্ধা, ņos_, мец_, 
   {{0xdd9493c9,0x69dc164c,0xdcba964d,0x69ce01ab}},	//   налы, _udre, ощи_, _uebe, 
   {{0x0ee08365,0x32180050,0x2df980df,0x693500ac}},	//   _निवड, _iary_, سبوک_, _přeš, 
   {{0x25de0d6d,0x5b14964e,0xdb1d0530,0x64aa801b}},	//   कृती_, емит, _resú, _přib, 
   {{0x41e68d6b,0xa3c10079,0xc5e600b2,0x25fb964f}},	//   міна, ुरत_, খ্যা_, ल्ही_, 
   {{0xd2509650,0x38601651,0xd6269652,0x6d439653}},	//   اند_, _amir_, _تعري, byna, 
   {{0x6d439654,0xc87f01ab,0xa01b019b,0x32180309}},	//   cyna, toß_, llöi, _mary_, 
   {{0xa3e8800d,0xc32a80fe,0xb9068b36,0x7b669655}},	//   _बाट_, _وكان_, _पि_, _отле, 
   {{0xa2d8810c,0xd78b00fe,0x7bcf1656,0x200b1657}},	//   _मिट्, تخدم_, _recu, reci_, 
   {{0x200b0025,0x3eb985cb,0x7bcf1658,0x32181659}},	//   seci_, _éste_, _secu, _nary_, 
   {{0x38b701d0,0x6d550036,0x2489165a,0x320c965b}},	//   _oħra_, uzza, tlam_, medy_, 
   {{0xd498165c,0xa7fb04e0,0xfc150d29,0x32180050}},	//   дру_, miño, эмбэ, _aary_, 
   {{0x7bcf00f3,0x3218165d,0x6d4380a1,0x2fc6806d}},	// [a90] _vecu, _bary_, zyna, dbog_, 
   {{0x3218165e,0x2489165f,0xae0082f4,0x43940db1}},	//   _cary_, slam_, ल्मन_, таус, 
   {{0xa3c38baf,0x1bd51660,0x24890214,0x69c512dc}},	//   ्रम_, _поня, plam_, rbhe, 
   {{0x61fe0f89,0x2fc69661,0x64bc0097,0x77999662}},	//   afpl, gbog_, _dčid, пкер_, 
   {{0xe456015c,0xdb028028,0xdee58c1f,0xa3e89016}},	//   _נישט_, _ngoà, холи, _बाज_, 
   {{0x2451827b,0x7aed1663,0x46e082f4,0x645a01a8}},	//   _máme_, muat, _निरह, ītie, 
   {{0x7aed0c29,0xc9841664,0x7c3d092f,0x7e639665}},	//   luat, _аути, _kosr, rinp, 
   {{0xe7f9800d,0xdb1d0b83,0xa1941666,0x321801cb}},	//   _एउटा_, _besø, _расч, _zary_, 
   {{0x442b13fd,0x6d439667,0x2ef4809f,0x25a9803d}},	//   _mnc_, syna, _изтр, _فضای_, 
   {{0x442b0128,0x291e0162,0xd2438103,0x78a98050}},	//   _lnc_, _štai_, тмоқ, _hiev, 
   {{0x7aed1668,0xf8660a4b,0xa3c11669,0x09c885a2}},	//   huat, евно, ुरा_, _শাখা, 
   {{0x7aed0a97,0x66e6166a,0x9ac4837f,0x717982c3}},	//   kuat, нома, _boċċ, жбүр_, 
   {{0xe8018365,0x7aed166b,0x7c2b966c,0x644981ab}},	//   ळ्या_, juat, _ingr, mkei, 
   {{0x443d8052,0x442b166d,0x78a9966e,0x95860ff9}},	//   _how_, _anc_, _liev, елге, 
   {{0xa7fb0659,0x443d966f,0xda020a42,0x26d91670}},	//   ciño, _kow_, र्फत_, asso_, 
   {{0x7aed022d,0x78a99671,0x3218052a,0x64499672}},	//   fuat, _niev, _sary_, nkei, 
   {{0x3b070574,0x27e01673,0x7afb9674,0xae008ec1}},	// [aa0] нето_, _idin_, ntut, ल्डन_, 
   {{0x9b9300fe,0x443d8039,0x98d39461,0xb77b0309}},	//   الكت, _low_, _दबाए, _מאפש, 
   {{0x26c01287,0x64498576,0x61fe0172,0x7c2b9675}},	//   _htio_, kkei, rfpl, _ongr, 
   {{0x67241676,0x443d8052,0xdfcf8013,0x7aed046a}},	//   _krij, _now_, ميم_, buat, 
   {{0x62819677,0x78a99678,0x91fc80f3,0x7bd61679}},	//   kolo, _diev, onāt, mayu, 
   {{0x25fb9089,0x7c2b967a,0x6281967b,0x7bd6167c}},	//   ल्ली_, _angr, jolo, layu, 
   {{0xa3e4075c,0x291e022c,0xafe6967d,0x7c3d0766}},	//   _नया_, _éta_, _повл, _yosr, 
   {{0x98a3967e,0x6449835b,0xd497967f,0x78a99680}},	//   _бисе, gkei, нры_, _giev, 
   {{0x0edc01d1,0x62819681,0x7afb9134,0xdb1981ed}},	//   _बिगड, folo, gtut, _gewü, 
   {{0x62819682,0xef178116,0x1f639683,0x27e01684}},	//   golo, _яму_, _скум, _adin_, 
   {{0x320c9685,0x69468105,0xa3b3801b,0x7afb963b}},	//   redy_, _očeš, जुङ_, atut, 
   {{0x44fa88fb,0x67241686,0x661a8269,0xa7fb060e}},	//   më_, _brij, _hatk, riño, 
   {{0x62819687,0xff041688,0x44fa80f8,0x67241689}},	//   bolo, лярн, lë_, _crij, 
   {{0x661a836d,0x672403fd,0x27e0168a,0x442b0495}},	//   _jatk, _drij, _edin_, _snc_, 
   {{0x44fa88fb,0x661a968b,0x25a500f9,0x7c3d082b}},	//   në_, _matk, äll_, _posr, 
   {{0x6d588bfc,0x27e00269,0x6724168c,0x7aed168d}},	//   izva, _gdin_, _frij, tuat, 
   {{0xc6a7168e,0x6724168f,0x44fa80f8,0x6aaa9690}},	// [ab0] _прои, _grij, hë_, _kiff, 
   {{0x78a98029,0xda781691,0x44fa80f8,0x6aaa81bb}},	//   _siev, нях_, kë_, _jiff, 
   {{0xdd911692,0x78a98029,0x7aed025f,0x44fa8210}},	//   _خود_, _piev, suat, jë_, 
   {{0x62819693,0x644f1694,0x648580fe,0x7aed1695}},	//   zolo, _ulci, hóir, puat, 
   {{0x661a8265,0xdb070008,0x44fa81b0,0xa2cd1696}},	//   _batk, ämäs, eë_, दीश्, 
   {{0x443d80f6,0x62819697,0x99d40158,0xa50980b0}},	//   _sow_, xolo, _متفا, дека_, 
   {{0xa1940004,0x92a60066,0x62819698,0x648580fe}},	//   _барч, _dołą, volo, dóir, 
   {{0x7afb809f,0x588781e5,0x38668123,0x62988103}},	//   ttut, _чыга, cior_, _ahvo, 
   {{0xe29982d4,0x64499699,0xdd918068,0x661a816c}},	//   маи_, rkei, دوں_, _fatk, 
   {{0x7afb969a,0x69d704e0,0x6449969b,0x200f969c}},	//   rtut, naxe, skei, legi_, 
   {{0x7afb969d,0x6aaa882c,0x67240301,0x201b00bf}},	//   stut, _diff, _srij, _baqi_, 
   {{0x6724169e,0x20040a93,0xd5648661,0xa3d28f21}},	//   _prij, ými_, _ступ, वरण_, 
   {{0x6281969f,0x6aaa80de,0x6e3e0a63,0xddd8807e}},	//   polo, _fiff, _popb, lovš, 
   {{0x672416a0,0x248d96a1,0x63bb809f,0xfce616a2}},	//   _vrij, llem_, lcun, кого, 
   {{0x6b8b96a3,0x7ae996a4,0x7bd616a5,0xe81d16a6}},	//   _hygg, lret, tayu, _बोका_, 
   {{0xc9528052,0x63bb96a7,0x27e016a8,0x15ee0034}},	//   _כמו_, ncun, _udin_, _जाकर_, 
   {{0x64a3063e,0x6e3e16a9,0xcb6716aa,0x93430720}},	// [ac0] рата, _topb, вате_, анте, 
   {{0x7bd604c0,0x7ae98065,0xbea616ab,0x6b8b937c}},	//   sayu, iret, _шапк, _mygg, 
   {{0x661a8008,0xfe370039,0xa3c38758,0x249f96ac}},	//   _ratk, _סרטי_, ्रा_, kmum_, 
   {{0x694696ad,0x628700bf,0xddd88249,0x44fa816c}},	//   _učeš, _ekjo, dovš, vë_, 
   {{0x248d96ae,0x69d7011e,0x92a600a1,0x69ca01c2}},	//   dlem_, baxe, _połą, ðfes, 
   {{0x44fa88fb,0x7ae9864a,0x68e8811a,0x629d96af}},	//   të_, dret, yrdd, ïsol, 
   {{0x81d780b2,0x3866810d,0x7ae996b0,0x661a96b1}},	//   িলা_, pior_, eret, _vatk, 
   {{0x44fa88fb,0x6aaa96b2,0x439496b3,0xe4e383ff}},	//   rë_, _siff, лайс, _गिरि_, 
   {{0x44fa88fb,0x661a8645,0x6d4700a1,0x648580fe}},	//   së_, _tatk, zyja, tóir, 
   {{0x91fc8029,0x5ea68bb7,0x3eb985cb,0x60c496b4}},	//   ciāl, _شمال, _ésta_, _čimb, 
   {{0x672296b5,0x248d96b6,0x648580fe,0x38648050}},	//   lvoj, blem_, róir, _kmmr_, 
   {{0xdb0416b7,0x7ae996b8,0x4bda81a1,0x648580d8}},	//   nció, bret, _آباد_, sóir, 
   {{0x7336846d,0xf09f075d,0x7ae996b9,0xdb04033b}},	//   _جرائ, rmà_, cret, ició, 
   {{0x52d78039,0x201b00e5,0xceb383dd,0x200f96ba}},	//   _יודע_, _waqi_, ייש_, zegi_, 
   {{0x984f00a1,0x3eac872c,0xc7c70223,0x201b02fd}},	//   jęć_, _midt_, _испи, _taqi_, 
   {{0x3eac8022,0x57f516bb,0x6287037c,0x5c741106}},	//   _lidt_, _спит, _skjo, алст, 
   {{0xb27516bc,0x2d8c96bd,0x3a7516be,0x667200df}},	// [ad0] глаш, _lyde_, глар, شگیر, 
   {{0x6722803b,0x68e302ba,0x7aef80a6,0x99d514f9}},	//   dvoj, ándo, àcti, اقات, 
   {{0x200f96bf,0x69d7137f,0xa3d2807a,0xf1a716c0}},	//   tegi_, raxe, वरा_, тран, 
   {{0x25ff0625,0x69d701e0,0x69ca007f,0xa01b16c1}},	//   श्री_, saxe, ðfer, mlös, 
   {{0x291816c2,0x7c2f16c3,0x200f96c4,0x64aa801b}},	//   _esra_, _incr, regi_, _přin, 
   {{0xe29a810b,0xdb040422,0x6b8b8c3e,0x644d036d}},	//   _như_, ació, _rygg, lkai, 
   {{0x91fc8029,0x628516c5,0xa8a78188,0x58d416c6}},	//   riāl, moho, _арак, _вост, 
   {{0xdb0416c7,0x628516c8,0xc1720039,0x69d516c9}},	//   cció, loho, _החל_, _heze, 
   {{0x69d516ca,0x248d96cb,0x6f098770,0x569580a6}},	//   _keze, rlem_, _upec, _баат, 
   {{0x7ae996cc,0xe8c996cd,0x3f7a8273,0x69d516ce}},	//   rret, нгол_, _אָבע, _jeze, 
   {{0x10a600cb,0x644d0008,0x69d516cf,0x2ba483f0}},	//   лион, kkai, _meze, खेबा, 
   {{0xcea9096e,0x69d50a44,0x7ae98578,0xf99204fc}},	//   _זי_, _leze, pret, מרי_, 
   {{0x442f899d,0xe28e96d0,0x643a8309,0xdb1d016f}},	//   _ing_, _га_, _רעננ, _mesó, 
   {{0x442f82ef,0xa01b01ed,0x7c2f16d1,0x644d00ce}},	//   _hng_, flös, _ancr, ekai, 
   {{0xa5071023,0xed5a16d2,0x1d0716d3,0x2d8c0142}},	//   лера_, хов_, лери_, æde_, 
   {{0x644d16d4,0x78ad16d5,0x442f96d6,0xfe7f075d}},	//   gkai, _giav, _jng_, duïu_, 
   {{0x69d516d7,0x33d5005a,0x28d794a0,0xdd9602c3}},	// [ae0] _beze, ріст, _भौति, таңы, 
   {{0x6456059d,0x442f96d8,0x62851526,0xa9a60a53}},	//   shyi, _lng_, goho, гизд, 
   {{0x442f96d9,0x69d516da,0x4fea96db,0x00e616dc}},	//   _ong_, _deze, емен_, ужен, 
   {{0x64930829,0xd7f796dd,0x442f89ec,0xf3f984ab}},	//   nçil, гуш_, _nng_, biţi_, 
   {{0xdb040c5e,0x442016de,0xbe8a96df,0x628516e0}},	//   rció, mdi_, нске_, boho, 
   {{0x442f96e1,0x442016e2,0x69d516e3,0x20d1839f}},	//   _ang_, ldi_, _geze, kši_, 
   {{0xdb040422,0x442f8659,0x20d18ecf,0x78b5029f}},	//   pció, _bng_, jši_, _guzv, 
   {{0x332696e4,0x661e0116,0x8fa696e5,0x26c696e6}},	//   _prox_, _lapk, _бабе, ppoo_, 
   {{0x76418068,0x5887005a,0x442f96e7,0x3254802d}},	//   _foly, ғына, _dng_, ивир, 
   {{0x442f96e8,0x76418324,0x442016e9,0x78a296ea}},	//   _eng_, _goly, hdi_, lmov, 
   {{0xd48f96eb,0x199496ec,0xa19496ed,0x2d8c00a1}},	//   _гр_, раня, ранч, żdej_, 
   {{0x4d7b8fcc,0x442016ee,0x78a296ef,0xd0e5800c}},	//   _ארבע, jdi_, nmov, _किरण_, 
   {{0xa2b00611,0xead496f0,0x442016f1,0xe29a8028}},	//   _अंग्, _толь, ddi_, _thư_, 
   {{0x442016f2,0x98bc001b,0x2bd294ac,0x644296f3}},	//   edi_, ávě_, सरवा, _hooi, 
   {{0x69da96f4,0x442f8360,0x644d036d,0x78a28bfc}},	//   mate, _yng_, tkai, kmov, 
   {{0x69da96f5,0x78a285c3,0x241816f6,0xa01b16f7}},	//   late, jmov, лосы_, rlös, 
   {{0x644d16f8,0x644282da,0x90980c93,0xa01b135d}},	// [af0] rkai, _mooi, _حضور_, slös, 
   {{0x644d16f9,0x629c0c8a,0x442016fa,0x7d1a96fb}},	//   skai, _chro, adi_, _osts, 
   {{0x2127010b,0x69d516fc,0x44200103,0x628516fd}},	//   ính_, _veze, bdi_, roho, 
   {{0x69da8573,0x64429169,0x628516fe,0x69d516ff}},	//   hate, _nooi, soho, _weze, 
   {{0x62850883,0x7bda13b1,0xf6e79700,0xfe7f075d}},	//   poho, _בקרו, уцен, buït_, 
   {{0xf6259701,0x20d71702,0x7aed1703,0x3ea58103}},	//   рдко, _مترج, mrat, шилг, 
   {{0xe3b1830b,0x69da9704,0xa3b91108,0x76419705}},	//   يرة_, date, _चला_, _voly, 
   {{0x20d1803a,0x6ee780dd,0x1309836a,0x7aed1706}},	//   vši_, _مسئل, вний_, orat, 
   {{0x7c3b9707,0x92020056,0x69da9708,0x64429709}},	//   rjur, र्वज_, fate, _dooi, 
   {{0x2480803a,0x4420170a,0x7aed170b,0x2127970c}},	//   čima_, zdi_, irat, _prnh_, 
   {{0x44200b7f,0x2901170d,0x64930a08,0xdddc0259}},	//   ydi_, ntha_, tçil, jorš, 
   {{0x186a0157,0x6729970e,0x20d19464,0xff260103}},	//   тами_, _krej, rši_, аммо, 
   {{0x69da970f,0x442001bb,0x6c8480d8,0xe3ae9710}},	//   bate, vdi_, _النم, _фб_, 
   {{0x69da8039,0xfed780b2,0xa9a583ad,0x21a583ad}},	//   cate, _সমাধ, _килд, _килм, 
   {{0xada61711,0xdb1207e9,0x44201712,0x2876027a}},	//   равл, _ágús, tdi_, _выпр, 
   {{0x44201713,0x67299714,0x7aed1715,0x2b099716}},	//   udi_, _orej, frat, _वहाँ_, 
   {{0x44201717,0x5baa1718,0x62661719,0xfe7f0741}},	// [b00] rdi_, ткам_, аваа, tuït_, 
   {{0x2bb8007a,0x09e6171a,0x91e600c4,0x22430269}},	//   _अलवा, рожн, роже, _cojk_, 
   {{0x2cf4971b,0x290100fe,0x78a2971c,0x7aed0086}},	//   _इमेल_, gtha_, tmov, arat, 
   {{0x6729971d,0x69da971e,0x769b0093,0x4420171f}},	//   _brej, zate, rîye, qdi_, 
   {{0x2bd301ff,0x629c0052,0x78a2826b,0x69da9720}},	//   तररा, _thro, rmov, yate, 
   {{0x672988fb,0x69da9721,0xa11600df,0x29011722}},	//   _drej, xate, _پورت, btha_, 
   {{0x69da9723,0x250881a1,0x75cb805a,0xafdb072c}},	//   vate, ارتی_, ттің_, ljøe, 
   {{0x672995f1,0x6d4a9724,0x249d9725,0x91688279}},	//   _frej, ryfa, _chwm_, _lực_, 
   {{0x67299726,0x69da9727,0xa2b3819b,0xd1ca9728}},	//   _grej, tate, обыч, кунд_, 
   {{0x38ba9729,0x1663972a,0x3254972b,0x6f028294}},	//   _për_, _двум, свор, mtoc, 
   {{0x7aed03ad,0xa3d6083c,0x6f0d172c,0x672980e9}},	//   zrat, हरा_, _spac, _zrej, 
   {{0x69da972d,0x64bc008d,0xe193855a,0x7aed0ced}},	//   sate, _pčin, өлөө, yrat, 
   {{0x53a6972e,0x98be80ce,0xfe7f09b2,0x00000000}},	//   _тадб, dytą_, duïr_, --, 
   {{0x7aed07c4,0x9f4002ae,0x2d840214,0x7ae2972f}},	//   vrat, _weiß_, ğmen_, _ivot, 
   {{0x25fb95ad,0x7aed037f,0x8c6701ad,0x2492011a}},	//   ल्टी_, wrat, атад, flym_, 
   {{0x69d89730,0x7aed1731,0x200900bf,0x6f029732}},	//   _heve, trat, _ubai_, ktoc, 
   {{0x7bcd1733,0x6f0d1734,0x64aa801b,0x69d89735}},	// [b10] rbau, _upac, _přij, _keve, 
   {{0x6288811a,0x35f50a4b,0xe9ab07f1,0xab841736}},	//   nodo, _упор, ندان_, цуск, 
   {{0x15b9805a,0xdfd180fe,0x69d88741,0x386900db}},	//   қылы_, كيا_, _meve, _kmar_, 
   {{0x69d89737,0x67299738,0x62889739,0x7aed173a}},	//   _leve, _prej, hodo, prat, 
   {{0x53350273,0x2901173b,0xdefb819b,0x48dd8079}},	//   _האָב_, stha_, тые_, _कौनो_, 
   {{0x9e648d38,0xb607973c,0x69d8973d,0xddc3802d}},	//   овід, рядк, _neve, dinţ, 
   {{0xd469973e,0x7ae2973f,0x62889740,0x9d45804a}},	//   лике_, _avot, dodo, сейд, 
   {{0x66151741,0x67299742,0xdd2801a8,0x24891743}},	//   hezk, _trej, nēša, noam_, 
   {{0x69d89744,0x67298bfc,0x9f440a08,0x6288811a}},	//   _beve, _urej, ümü_, fodo, 
   {{0x2fdd822a,0x69d89745,0x24891659,0xe73a0ff6}},	//   lawg_, _ceve, hoam_, ҳем_, 
   {{0x69d89746,0xf5958013,0x8d958013,0x66150124}},	//   _deve, _الاج, _الاش, dezk, 
   {{0x20561747,0xa856039b,0x3d0180a1,0x6e219748}},	//   стор, стој, mów_, _halb, 
   {{0x6e219749,0x6288974a,0x41a7009b,0x8b6880f0}},	//   _kalb, bodo, केतस, _київ_, 
   {{0x69d882da,0x65c3174b,0xb6cc838e,0x66150122}},	//   _geve, збра, _şükü, gezk, 
   {{0x6e21824a,0x3d018066,0x7bd9974c,0xc69283dd}},	//   _malb, nów_, _kewu, פאל_, 
   {{0x645b974d,0x69d8974e,0x78a38d55,0x6f02974f}},	//   nhui, _zeve, ïnvl, ytoc, 
   {{0x7bd98058,0x04431750,0x03a30ded,0x3aba80c6}},	// [b20] _mewu, четн, зито, ָמענ, 
   {{0x3d018d99,0x64bc1041,0x64a4004a,0x443f8079}},	//   ków_, _učio, саға, hju_, 
   {{0x499a1747,0x24891751,0x645b9752,0x3d018034}},	//   утая_, boam_, khui, jów_, 
   {{0x7bd99753,0x3d0180a1,0x6e218142,0x6f029754}},	//   _newu, dów_, _aalb, ttoc, 
   {{0x443f9755,0x43751177,0xf3ff80b2,0x645b9756}},	//   dju_, _дурт, ্যার_, dhui, 
   {{0x4422047a,0x7c241757,0x64460103,0x443f9758}},	//   _hak_, ldir, _hoki, eju_, 
   {{0x442209bb,0x644601e2,0x7bd99759,0x62888b8c}},	//   _kak_, _koki, _bewu, vodo, 
   {{0x44221392,0x7c24175a,0x69de175b,0x6446175c}},	//   _jak_, ndir, lape, _joki, 
   {{0x4422175d,0x35fa846d,0x6e218c9f,0x64460116}},	//   _mak_, _مراد_, _falb, _moki, 
   {{0xc333004d,0x69d88210,0x69de175e,0x6e21975f}},	//   פות_, _qeve, nape, _galb, 
   {{0x443f9760,0x3d0180a1,0x78b88103,0xa3b90073}},	//   bju_, ców_, _quvv, _चलल_, 
   {{0x44221761,0x443f8215,0x645b9762,0x69de1763}},	//   _nak_, cju_, chui, hape, 
   {{0x7645003e,0x62889764,0x69d89765,0x69de009a}},	//   _pohy, podo, _teve, kape, 
   {{0x3dd900cf,0x7aef86c9,0xdce500e9,0x7c229766}},	//   _তাহল, ácte, _vzhľ, _haor, 
   {{0x69de1767,0x64aa800d,0xe57300fe,0x64461768}},	//   dape, _přih, سطس_, _boki, 
   {{0xfe770188,0x7c241769,0x60c781d2,0x66150122}},	//   рүү_, gdir, íjme, sezk, 
   {{0x7c22976a,0x6446176b,0x4422176c,0x27e903ad}},	// [b30] _maor, _doki, _dak_, _idan_, 
   {{0x443f8208,0x7b7400fe,0x69de176d,0x765c176e}},	//   zju_, أطفا, gape, chry, 
   {{0x7c24176f,0xbebd9770,0x672d03d5,0x104b9771}},	//   bdir, _trūk, _hraj, ляди_, 
   {{0x44221772,0x64bc005d,0x6e219773,0x19a81774}},	//   _gak_, _očij, _salb, ступ_, 
   {{0xe7399775,0x443f9776,0x69de1777,0x3d018034}},	//   рел_, vju_, bape, wów_, 
   {{0xdb1d08b4,0x3d018066,0x6e219778,0xc3320115}},	//   _besö, tów_, _qalb, _קום_, 
   {{0x443f9779,0x4422177a,0xed59977b,0xf53280b0}},	//   tju_, _yak_, рой_, дејќ, 
   {{0x3d018066,0x7bdf177c,0x7c22977d,0x09e1809b}},	//   rów_, naqu, _caor, पण्य, 
   {{0x443f977e,0x3d018066,0x6e21977f,0x645b83c5}},	//   rju_, sów_, _talb, rhui, 
   {{0xe9d9861a,0x27e91780,0xda6580f0,0x443f9781}},	//   шко_, _adan_, івни, sju_, 
   {{0x69c19782,0x26c90573,0x443f9783,0xd9459784}},	//   rcle, _atao_, pju_, цени, 
   {{0x672d1785,0x69de1786,0x1faa1787,0x60cd8265}},	//   _braj, zape, икни_, _čamd, 
   {{0x44221788,0xeb8e9789,0x7bdf178a,0xb69b178b}},	//   _rak_, _ци_, daqu, rtân, 
   {{0x44220a8f,0x8aa7978c,0x672d178d,0xb69b178b}},	//   _sak_, _уред, _draj, stân, 
   {{0x4422178e,0xa3bd8365,0x6446178f,0x69de1790}},	//   _pak_, _आला_, _poki, vape, 
   {{0x69de1791,0x7c22811e,0xdb1d0432,0x7c240036}},	//   wape, _xaor, _lesõ, udir, 
   {{0x69de1792,0x7c241793,0x20050816,0xf41282f9}},	// [b40] tape, rdir, əli_, ופן_, 
   {{0x22478a91,0x7c241794,0x44221795,0x49960690}},	//   _jonk_, sdir, _wak_, ошет, 
   {{0x69de1796,0x64461797,0x8c461798,0xdd0f0214}},	//   rape, _toki, _дене, mışt, 
   {{0xdd0f0214,0x7c241799,0x9f480106,0x9f59010d}},	//   lışt, qdir, _điêu_, resö_, 
   {{0x9eaa8bdc,0xcfbc00b2,0x4ea6979a,0x245c0063}},	//   авда_, _অজান, орка, _címe_, 
   {{0xe297179b,0x412a179c,0x7c228094,0x7ae4179d}},	//   _мая_, _кого_, _saor, msit, 
   {{0x9103168e,0xf9878f94,0xd90d01a1,0x7ae400fe}},	//   _опре, _آب_, _میل_, lsit, 
   {{0x7bc4179e,0x7ae4179f,0x9c7c86e4,0x2fc48da7}},	//   nciu, osit, _evčn, _ufmg_, 
   {{0x69dc17a0,0x6fd0810c,0x7ae417a1,0x224797a2}},	//   _kere, _ड्यू, nsit, _bonk_, 
   {{0x69dc17a3,0xda4a85fd,0x442482fa,0x245180d8}},	//   _jere, рчил_, sdm_, _lámh_, 
   {{0x69dc049d,0x26c9029f,0x224797a4,0x7c2280de}},	//   _mere, _stao_, _donk_, _taor, 
   {{0x69dc17a5,0x672d17a6,0x7ae417a7,0xe0cf87f1}},	//   _lere, _praj, ksit, کزی_, 
   {{0x764880db,0x69dc00bc,0x290597a8,0x674701e2}},	//   _kody, _oere, atla_, цэнз, 
   {{0x248980e9,0x7648844e,0x672d17a9,0xe60e97aa}},	//   čame_, _jody, _vraj, едi_, 
   {{0x7bdf00ef,0x764897ab,0xec6b17ac,0x7ae417ad}},	//   taqu, _mody, арак_, esit, 
   {{0x672d17ae,0xd6db036d,0x69dc0086,0x27e917af}},	//   _traj, _кто_, _aere, _udan_, 
   {{0x201917b0,0x7ae400ed,0xb60680e9,0x06cf85a2}},	// [b50] mesi_, gsit, _kráľ, _রিভি, 
   {{0x201917b1,0x661897b2,0x69dc1658,0x7bc401e9}},	//   lesi_, jevk, _cere, aciu, 
   {{0x69dc0060,0x30158ff9,0xc0158008,0x7bdf17b3}},	//   _dere, здер, змещ, paqu, 
   {{0x765a97b4,0x78bc17b5,0x7ae417b6,0xb17b80c6}},	//   _alty, _durv, bsit, סטאר, 
   {{0x69dc17b7,0x27e0807f,0x7bdd02fe,0xf77090ac}},	//   _fere, ðina_, _iesu, پان_, 
   {{0x69dc17b8,0x7bdd17b9,0x518717ba,0x2ca902f4}},	//   _gere, _hesu, _дуба, lmad_, 
   {{0xdfd597bb,0x7bdd17bc,0x69c517bd,0xdb1b81e0}},	//   _новы, _kesu, mche, rcuí, 
   {{0x69c517be,0x7bdd17bf,0x0b458004,0x69dc17c0}},	//   lche, _jesu, знин, _zere, 
   {{0x2bdc007a,0x7bdd17c1,0x69dc17c2,0x76d580fe}},	//   बरता, _mesu, _yere, _رياض, 
   {{0x69dc17c3,0x7bdd17c4,0x69c517c5,0x09af00b2}},	//   _xere, _lesu, nche, _চ্যা, 
   {{0x69c517c6,0x201917c7,0xbd6b97c8,0x2c0c0056}},	//   iche, fesi_, _трае_, ड्डू_, 
   {{0x2458838b,0x7bdd01e2,0x315600c6,0x69c517c9}},	//   _téma_, _nesu, פירן_, hche, 
   {{0x245197ca,0x64aa81d2,0x224783df,0x290597cb}},	//   _námi_, _přiv, _tonk_, stla_, 
   {{0xfe79801b,0x68e70854,0x6e2517cc,0x69c517cd}},	//   _svůj_, _ovjd, _cahb, jche, 
   {{0x61e1836d,0x386d97ce,0xdca60286,0x7bdd17cf}},	//   mall, _omer_, зави, _besu, 
   {{0x7ae417d0,0x201917d1,0x61e197d2,0x248d81b0}},	//   tsit, cesi_, lall, noem_, 
   {{0x69dc17d3,0x7bdd006d,0x7bc40019,0x2d9e026b}},	// [b60] _pere, _desu, rciu, ťte_, 
   {{0x7bc4009f,0xed5a0a1c,0xba2317d4,0x69dc17d5}},	//   sciu, _гоо_, ндук, _qere, 
   {{0x7ae417d6,0x76488116,0xda020f21,0x7bc417d7}},	//   ssit, _rody, र्गत_, pciu, 
   {{0x61e197d8,0x69dc17d9,0x7bdd17da,0x7ae417db}},	//   hall, _were, _gesu, psit, 
   {{0x61e197dc,0x387f8172,0xddcf801b,0x69c517dd}},	//   kall, _djur_, _řeše, bche, 
   {{0x69c5009f,0x78bc0388,0x61e197de,0x7bdd09ec}},	//   cche, _turv, jall, _zesu, 
   {{0x20c1810b,0x7bdd01c1,0xfaa317df,0x201917e0}},	//   _nói_, _yesu, _чаро, yesi_, 
   {{0x321a00a1,0x9e668267,0x644400db,0x7bdd03b9}},	//   lepy_, _کارن, njii, _xesu, 
   {{0x66188038,0x61e197e1,0x67209287,0x55c4804a}},	//   pevk, fall, _usmj, _жазғ, 
   {{0x61e197e2,0x201917e3,0x7aef97e4,0xe3bf17e5}},	//   gall, wesi_, ácta, _maña_, 
   {{0x201917e6,0x60cd829f,0x6e250004,0x69c3007e}},	//   tesi_, _čamc, _rahb, žneg, 
   {{0x78a417e7,0x7c2617e8,0x7ac6805a,0xe3a78019}},	//   _chiv, _nakr, _еске, _کشمی, 
   {{0x61e197e9,0x2bd295ad,0x201917ea,0xd8380741}},	//   ball, _ध्या, resi_, чээ_, 
   {{0x442697eb,0x7bdd03a1,0x61e197ec,0x80d200b2}},	//   _hao_, _sesu, call, _হিন্, 
   {{0x4426803b,0xe1968a1c,0x7c2617ed,0x20c1801c}},	//   _kao_, _эрдэ, _bakr, _gói_, 
   {{0x7c2617ee,0x6e2500bf,0x44269659,0x958400a1}},	//   _cakr, _wahb, _jao_, _łącz, 
   {{0xd6d78a87,0x442697ef,0x69c517f0,0xe3bf06c9}},	// [b70] _সম্প, _mao_, tche, _caña_, 
   {{0x442697f1,0x27e0812b,0x69c517f2,0x645f17f3}},	//   _lao_, ðinn_, uche, shqi, 
   {{0x69c50713,0x7bdd17f4,0x291906fe,0x44268027}},	//   rche, _tesu, تقاد_, _oao_, 
   {{0x69c517f5,0x442697f6,0xd75980fe,0x779997f7}},	//   sche, _nao_, يلات_, окер_, 
   {{0x442917f8,0x443917f9,0x69c517fa,0x61e197fb}},	//   mda_, _ins_, pche, yall, 
   {{0x443917fc,0x7c2604a9,0xef188bb4,0x5fce832d}},	//   _hns_, _zakr, ямі_, हुबल, 
   {{0x442697fd,0x442917fe,0xc1051652,0x7c3a0a5e}},	//   _bao_, oda_, _توزي, _úcrá, 
   {{0x4426810b,0x61e197ff,0xf53800c6,0xcac98008}},	//   _cao_, wall, לטור_, огие_, 
   {{0x61e1857b,0x56958188,0xdb0982d2,0x89f58c98}},	//   tall, _жаат, _önüm, мянц, 
   {{0x44291800,0x81bc81a8,0x2fdf8120,0x7ea01801}},	//   hda_, ldēj, _heug_, köpa, 
   {{0x44391802,0x26cd82f0,0x44291803,0x27e200e5}},	//   _ons_, _hteo_, kda_, takn_, 
   {{0x44291804,0xd36e807b,0x2fdf86a4,0x66e61805}},	//   jda_, اهی_, _jeug_, мома, 
   {{0x44291806,0x61e19807,0xbebd80f3,0x61fe0172}},	//   dda_, pall, _grūt, ygpl, 
   {{0x44391808,0x6da60daa,0x44269809,0x4429180a}},	//   _ans_, дига, _zao_, eda_, 
   {{0xe969980b,0x4426822d,0x7afb84bb,0x27e200e5}},	//   _файл_, _yao_, luut, pakn_, 
   {{0x4429180c,0x26cd8259,0x5ed380b2,0x44268106}},	//   gda_, _oteo_, _সিনে, _xao_, 
   {{0x644b980d,0xeb97180e,0x7c29980f,0xb22609d5}},	// [b80] _mogi, дит_, ider, ммал, 
   {{0x44391810,0x44291811,0x44261812,0x645d1813}},	//   _ens_, ada_, žo_, _elsi, 
   {{0x661c1814,0x27e0035b,0x7c261815,0x7c299816}},	//   merk, _kein_, _takr, kder, 
   {{0x7c299817,0x44290829,0x7afb9818,0x9f4201b2}},	//   jder, cda_, kuut, vakê_, 
   {{0x27e0035b,0x44268028,0x2fdf8c9f,0xdd8f00df}},	//   _mein_, _rao_, _deug_, _موی_, 
   {{0x44269819,0x27ed981a,0x7c29981b,0x27e00324}},	//   _sao_, _eden_, eder, _lein_, 
   {{0xda0e8106,0x2ee680bf,0x90c3077a,0xa3aa01d2}},	//   _bỏng_, ssof_, _абсе, गेर_, 
   {{0xe9a3181c,0x6724181d,0x644b981e,0x27e0116b}},	//   _расп, _osij, _cogi, _nein_, 
   {{0x4426981f,0x1dcf9820,0x60cd8284,0xd7039821}},	//   _vao_, _स्वत, _čama, _изти, 
   {{0x44291822,0x4426822d,0x2489805d,0xdb2280a1}},	//   zda_, _wao_, čama_, _źród, 
   {{0x44269823,0x09f70052,0x44291824,0xd48f9825}},	//   _tao_, ומים_, yda_, _ар_, 
   {{0x44291826,0xdbd604bb,0x26c00495,0x2745016c}},	//   xda_, _jääd, _buio_, _nënë_, 
   {{0x27e002ae,0xfe730158,0x44391827,0x26c0011e}},	//   _dein_, ندس_, _rns_, _cuio_, 
   {{0x44391828,0x661c1829,0x4429182a,0x65950994}},	//   _sns_, gerk, wda_, еагу, 
   {{0x4429182b,0x27e0182c,0x4439182d,0xdd9401e2}},	//   tda_, _fein_, _pns_, вары, 
   {{0xd5b8182e,0xaa7b026b,0x7af6016c,0x4429182f}},	//   ься_, _zvýh, fryt, uda_, 
   {{0x5a351830,0x6e3a83c5,0xa3aa009b,0xf0940039}},	// [b90] ннат, _ontb, गेल_, _בנק_, 
   {{0x767406f1,0x6e289831,0x27e00124,0x3b09008b}},	//   _альф, _nadb, _zein_, rtaq_, 
   {{0x2907024a,0x7c299832,0x66050103,0x80e080b2}},	//   îna_, yder, _ichk, পূর্, 
   {{0x44391833,0x44291834,0x245c012b,0x7af61835}},	//   _uns_, qda_, _tíma_, bryt, 
   {{0x6e289836,0x2294010d,0x6d550063,0x7c299837}},	//   _badb, täkt_, lyza, vder, 
   {{0xe5a59838,0xceb880a1,0x603e8123,0x6da59839}},	//   нили, _cię_, _pămâ, нила, 
   {{0x63a2983a,0xdc3a82d2,0x2ca68064,0x629a942b}},	//   _azon, _açıs, _bhod_, dlto, 
   {{0x0325983b,0x27ed8022,0x69ca983c,0x61e5183d}},	//   един, _uden_, _affe, lahl, 
   {{0x7c29983e,0x27e0183f,0xe61082e5,0x661c1840}},	//   rder, _rein_, _چشم_, yerk, 
   {{0x27e01841,0x7c2990b7,0x63a29842,0x39459843}},	//   _sein_, sder, _dzon, еног, 
   {{0x661c08b6,0x7afb9844,0x9f420dcb,0x644b8399}},	//   verk, suut, maké_, _togi, 
   {{0xed56896e,0x661c1845,0xe7308068,0x61e50504}},	//   _אבער_, werk, _حصہ_, hahl, 
   {{0x661c1846,0x443e001c,0x3a2786e0,0x61e51847}},	//   terk, _đt_, _tanp_, kahl, 
   {{0xe3bf1848,0x64bc1849,0x7ae9984a,0x2cb90064}},	//   _baño_, _očit, mset, _aisd_, 
   {{0x4096069a,0x61e50111,0xa97980c6,0x7ae9984b}},	//   _прит, dahl, _מאַכ, lset, 
   {{0x7bc9984c,0x46ea0574,0x661c184d,0xe3bf06c9}},	//   nceu, _един_, serk, _daño_, 
   {{0x9f42040c,0x7ae9984e,0x2745016c,0x3860184f}},	// [ba0] kaké_, nset, _vënë_, _ilir_, 
   {{0x2cad9850,0x7ae99851,0x9f42026b,0x99858019}},	//   hmed_, iset, jaké_, lelő_, 
   {{0x7ae992eb,0xf77f0432,0x50ba0061,0x6e289852}},	//   hset, maça_, سداد_, _radb, 
   {{0xceb88639,0x27e09853,0xe3a7846d,0x62951854}},	//   _się_, úin_, _مر_, _ekzo, 
   {{0xe8051855,0x2cad8079,0x7ae99856,0x81d685a2}},	//   ष्टा_, dmed_, jset, িণত_, 
   {{0x7ae99857,0xf77f075d,0x9c7c80ca,0xae040076}},	//   dset, naça_, _ivči, श्चन_, 
   {{0xf6530115,0x6e28807e,0xa9a30a53,0x7ae99858}},	//   רצו_, _vadb, _бирд, eset, 
   {{0x7ae99859,0x25a081d2,0xf483804a,0x2bd3001b}},	//   fset, řilo_, луын, धुपा, 
   {{0x6e28985a,0x087780c6,0x3f8188f1,0x7ae9985b}},	//   _tadb, _נעמט_, şhur_, gset, 
   {{0x27e6985c,0xdb2380d8,0x3860185d,0x3eba185e}},	//   laon_, órái, _alir_, _nipt_, 
   {{0x3860185f,0xd5a48503,0x88bc801b,0x67d51860}},	//   _blir_, _ओरिज, jvět, кону, 
   {{0x248005c3,0x61e502ae,0x27e69861,0xa3b103f2}},	//   jnim_, zahl, naon_, टेड_, 
   {{0x24800025,0x64bc1862,0xe7841863,0x3ce30076}},	//   dnim_, _očis, гуро, टीने_, 
   {{0xbb3b8464,0x09e380b2,0x27e69864,0xfc3f0106}},	//   _מעדי, _মাথা, haon_, _chín_, 
   {{0x321e9865,0xceb380c6,0x27e68bed,0x89339866}},	//   mety_, טיש_, kaon_, _معيا, 
   {{0x61e51867,0x321e89d8,0x6d5500a1,0xa3cb0a64}},	//   wahl, lety_, ryza, रुं_, 
   {{0x200c0816,0x9f420093,0x29180036,0xf77f0da7}},	// [bb0] ədi_, lakî_, _apra_, baça_, 
   {{0x321e9868,0x7afd80a6,0x1959064e,0x24801869}},	//   nety_, àsti, мазы_, anim_, 
   {{0xa3e0903a,0xdfd180fe,0x61e5186a,0xf7730019}},	//   थरा_, ليا_, rahl, _جاں_, 
   {{0x24800053,0x1b1780b2,0x61e500f6,0x291800db}},	//   cnim_, তিতে_, sahl, _dpra_, 
   {{0xd9ad986b,0x321e826b,0x7c2d186c,0x58b880d8}},	//   _घण्ट, kety_, mdar, رامج_, 
   {{0x7c2d186d,0x7ae9986e,0x442b186f,0xe7369870}},	//   ldar, vset, _hac_, теш_, 
   {{0x64aa800d,0x64bc1871,0x51841872,0xc9840675}},	//   _přip, _učit, _бута, _бути, 
   {{0x24898845,0x7ae99873,0x63a21874,0xf1941875}},	//   čamo_, tset, żone, _сись, 
   {{0x4aa99876,0x644f1877,0x1c429878,0x56e1804a}},	//   мкин_, _moci, рным, _тұлғ, 
   {{0xa77480f1,0x7ae99879,0x24800043,0x5ba4805a}},	//   _случ, rset, znim_, ылығ, 
   {{0x7c2d187a,0x320b80a1,0x442b09b2,0x2169987b}},	//   kdar, ęcy_, _oac_, фини_, 
   {{0x442b011a,0x7c2d187c,0x7ae9987d,0x2056187e}},	//   _nac_, jdar, pset, ттор, 
   {{0x7c2d187f,0x442d8dc1,0xf8b28273,0x7c2b82ef}},	//   ddar, mde_, ישט_, _iagr, 
   {{0xf1b10561,0x23690034,0xa3d40076,0x99858063}},	//   जधान, dzaj_, सुन_, selő_, 
   {{0xfc3f011e,0x1d071880,0x442b1881,0x7c2b9882}},	//   _chío_, кери_, _bac_, _kagr, 
   {{0x644f0422,0x7c2d020e,0x442b1883,0xc48300cb}},	//   _coci, gdar, _cac_, алск, 
   {{0x7c2b9884,0xa3e31885,0xc0530039,0x628193fd}},	// [bc0] _magr, _नजर_, _כזה_, onlo, 
   {{0x2480029f,0x442d836d,0x7c2b9886,0x442b1887}},	//   snim_, hde_, _lagr, _eac_, 
   {{0x442b0012,0x442d9888,0x27e69889,0x7c2d188a}},	//   _fac_, kde_, taon_, bdar, 
   {{0x442d988b,0x38608013,0x321e90ab,0xd00f8f36}},	//   jde_, óir_, zety_, قلم_, 
   {{0x442d988c,0xe1e78f2a,0x4420188d,0x27e6988e}},	//   dde_, _پس_, mei_, raon_, 
   {{0x4420188f,0x442d9890,0x290c982b,0x765c1891}},	//   lei_, ede_, ytda_, nkry, 
   {{0x61430daa,0x442d9169,0xa80687ae,0x321e81cb}},	//   _кера, fde_, _извл, vety_, 
   {{0x9f4201b2,0x40959892,0xb8b4804a,0x6abb011e}},	//   vakî_, _брут, _сөзі, _éufr, 
   {{0x68e10142,0x321e90ab,0xd7078123,0x7c2b9893}},	//   _ældr, tety_, _инте_, _dagr, 
   {{0x386680b0,0x442d9894,0x7c2b9895,0x7c2d1896}},	//   lhor_, ade_, _eagr, zdar, 
   {{0x44201897,0x26c49898,0xdd1f81ac,0x5ec780b2}},	//   kei_, _humo_, píšt, রীদে, 
   {{0xf9930052,0x386683b8,0x321e9899,0x68e317f4}},	//   ירת_, nhor_, sety_, ândi, 
   {{0x4420189a,0x6d588116,0x260980da,0x321e89d8}},	//   dei_, lyva, _सामी_, pety_, 
   {{0x7c2b989b,0xdce50038,0x27e4802d,0x61e3989c}},	//   _zagr, _vyhľ, _lemn_, _genl, 
   {{0x644f0ab8,0x241901bc,0x7c2d189d,0xac19189e}},	//   _poci, новы_, tdar, нову_, 
   {{0xfbd30f2a,0x69ce0a44,0x7c2d189f,0x442018a0}},	//   شتر_, _afbe, udar, gei_, 
   {{0x386698a1,0x644f18a2,0x6a1502c3,0x78a9840a}},	// [bd0] dhor_, _voci, лмау, _rhev, 
   {{0x442d98a3,0xf09f00a6,0x78a998a4,0x7c2d18a5}},	//   zde_, llà_, _shev, sdar, 
   {{0xf770099d,0x442018a6,0x2127010b,0x6d5d8816}},	//   _های_, bei_, ình_, _əsas, 
   {{0x61e898a7,0xcfde80cf,0x24868a5a,0x442018a8}},	//   hadl, _ডাউন, _njom_, cei_, 
   {{0x442d98a9,0xd9e3802a,0x7c2b8120,0x61e898aa}},	//   vde_, _ग़लत_, _ragr, kadl, 
   {{0x442d98ab,0x7aed18ac,0x6abc008b,0x660598ad}},	//   wde_, msat, _girf, упка, 
   {{0x7c2b98ae,0x2609809b,0x61e898af,0x442d98b0}},	//   _pagr, _साठी_, dadl, tde_, 
   {{0x62818657,0x61e398b1,0x0c2598b2,0x290118b3}},	//   wnlo, _senl, умин, muha_, 
   {{0x442d98b4,0x7aed125c,0x786606b8,0x645b98b5}},	//   rde_, nsat, _jóve, rkui, 
   {{0x442d939c,0xb7bd802d,0x78660077,0x645b98b6}},	//   sde_, _naţi, _móve, skui, 
   {{0x37e618b7,0x61e398b8,0x42c88741,0x7c2b98b9}},	//   лонг, _venl, нгөн_, _tagr, 
   {{0x44e181e2,0xbf9b0077,0x442018ba,0xe43c01d2}},	//   mų_, rgên, xei_, _příč, 
   {{0x442018bb,0x44e18116,0x7866007f,0x27e094d7}},	//   vei_, lų_, _nóve, ðini_, 
   {{0x249f98bc,0x290118bd,0xa9a58004,0x38ca807b}},	//   llum_, kuha_, _йилд, بایی_, 
   {{0x44e181e2,0x765c18be,0x7cd180f3,0x4256004a}},	//   nų_, rkry, _dārg, қтат, 
   {{0x9f4482a5,0x765c07b8,0x78660e75,0xa3e6810c}},	//   _demê_, skry, _bóve, _बड़ा_, 
   {{0xfc3f003e,0x7aed18bf,0xcb6718c0,0x64a318c1}},	// [be0] _dní_, gsat, гате_, сата, 
   {{0x442018c2,0x44e181e2,0xfeba0275,0x6b9d0324}},	//   sei_, kų_, _ثابت_, _dysg, 
   {{0x44e181e2,0x629e18c3,0x442018c4,0x7aed18c5}},	//   jų_, rlpo, pei_, asat, 
   {{0x8c461225,0x7afb98c6,0x44e18116,0x044618c7}},	//   _семе, krut, dų_, _семн, 
   {{0x09e800b2,0x7e788ba7,0xe3b2015e,0x6b9d02ad}},	//   _পাঠা, tivp, _درد_, _gysg, 
   {{0x2ca018c8,0x290118c9,0x6d588162,0xb5e205a2}},	//   llid_, buha_, tyva, _বাঁচ, 
   {{0x2cc981ac,0x61e898ca,0x44e18116,0xa3cb18cb}},	//   _ľudí_, vadl, gų_, रुक_, 
   {{0x7afb98cc,0x260981c7,0x545498cd,0x7bdb8bed}},	//   frut, _साथी_, рвит, gbuu, 
   {{0x68f5803e,0x307598ce,0x41e688cf,0x61e898cf}},	//   ázdn, _турс, ліна, tadl, 
   {{0x471b80c6,0x391498d0,0xdbd10079,0x37e105a2}},	//   _אומג, амор, _süüd, _ভাইর, 
   {{0x3de215a3,0x26098e78,0x69da91e9,0x249f98d1}},	//   _বাংল, _साती_, rbte, blum_, 
   {{0x7aed14d7,0xfc3f001c,0x7afb98d2,0x3ebe98d3}},	//   ysat, _phím_, brut, _hitt_, 
   {{0x543b8273,0x61e898d4,0x7afb98d5,0xf77f03b8}},	//   _רעדא, padl, crut, raço_, 
   {{0x26e5000f,0xcf938309,0x6d498034,0x6a6001c2}},	//   _कबीर_, מטר_, ślał, _söfn, 
   {{0x3ebe98d6,0xf77f0077,0x9f528610,0x6d4a06b0}},	//   _mitt_, paço_, ûyê_, _àfal, 
   {{0x3ebe8d38,0x248d18d7,0x7aed18d8,0x2ca002f4}},	//   _litt_, čemo_, tsat, glid_, 
   {{0x3a7518d9,0xb275025c,0x78ad18da,0x998c0bbe}},	// [bf0] алар, алаш, _ihav, _ćoše_, 
   {{0x7aef8422,0x7aed0dc1,0x7ed40013,0x5ed380cf}},	//   ácti, rsat, _ازيا, _সিলে, 
   {{0x7aed18db,0x6675807b,0xf1a70a65,0xc98418dc}},	//   ssat, یدتر, уран, буци, 
   {{0x290118dd,0x2c27036a,0x7aed18de,0x2ca018df}},	//   ruha_, _сьог, psat, clid_, 
   {{0xb81718e0,0xe81701b7,0xf74598e1,0x260098e2}},	//   ध्यम_, ध्या_, рело, _राखी_, 
   {{0x62830257,0x44e181e2,0x09df00b2,0x7bc2817c}},	//   čnos, tų_, _ঢাকা, _agou, 
   {{0x3ebe98e3,0xd6580052,0x58d41647,0x30a79495}},	//   _ditt_, ריות_, _гост, _брав, 
   {{0xeb9998e4,0x99840013,0x7afb98e5,0x44e18116}},	//   кий_, _الفو, trut, rų_, 
   {{0x6f1b8024,0x76b98188,0xc86498e6,0x09e800b2}},	//   _upuc, _алар_, _утри, _পাতা, 
   {{0x628518e7,0x7cd18029,0x7afb98e8,0x7c2f0a16}},	//   nnho, _pārd, rrut, _lacr, 
   {{0xa06a18e9,0x61e718ea,0x888608f9,0x684618eb}},	//   вана_, _mejl, илож, анна, 
   {{0xb4c19108,0xfa2580cf,0x7cd18029,0x78ad18ec}},	//   ंदी_, বাইল_, _vārd, _chav, 
   {{0xe9ce98ed,0x2ca018ee,0x1ae582c3,0x7ae298ef}},	//   _мк_, vlid_, _толм, _gwot, 
   {{0x442f98f0,0x61e7000d,0x3ebe0a15,0x2ca0124e}},	//   _hag_, _nejl, ött_, wlid_, 
   {{0xfce60370,0x442f98f1,0xc62800b2,0x7d0398f2}},	//   робо, _kag_, মালা_, nuns, 
   {{0x442f84d2,0xbc630af4,0xa3ac8964,0x26c418f3}},	//   _jag_, овск, _गरम_, ímos_, 
  
   {{0xa3b1009b,0xe29a03b8,0x91fc80f3,0x6e2398f4}},	// [c00] टेल_, ваа_, bkād, kenb, 
   {{0xe9d700c4,0x442f98f5,0x7ea00172,0x4a4318f6}},	//   ику_, _lag_, köpi, онув, 
   {{0x3f9f98f7,0x61e70142,0x7d03868c,0x6e2398f8}},	//   _ayuu_, _dejl, juns, denb, 
   {{0x442f98f9,0x3ebe88b6,0x60c70854,0x7e7c00bf}},	//   _nag_, _sitt_, _dujm, lirp, 
   {{0x7c240804,0x61e718fa,0x6e2398fb,0x2d9e98fc}},	//   meir, _fejl, fenb, _syte_, 
   {{0x7c2418fd,0xb4c198fe,0x6e2398ff,0x7c2f0131}},	//   leir, ंदू_, genb, _zacr, 
   {{0x394700f9,0x3ebe9900,0xafe68116,0xddc880a1}},	//   änst_, _vitt_, _вобл, _podł, 
   {{0x7c24160d,0x442f9901,0x7ae28246,0x44321902}},	//   neir, _cag_, _pwot, ndy_, 
   {{0x15e6000f,0x27e0807f,0xd5b18106,0x6e239903}},	//   करार_, ðinu_, _máy_, benb, 
   {{0x60c09904,0x78ad1905,0x80ca8964,0x7d1e036a}},	//   _himm, _shav, _संदे, _opps, 
   {{0x4432003e,0x3a370052,0xd57580f0,0x51869906}},	//   kdy_, ברים_, _луць, рупа, 
   {{0x442f9907,0x78a28103,0x7c240bdf,0x69c39908}},	//   _gag_, nlov, jeir, _egne, 
   {{0x7c241909,0x4424990a,0x7ad486fe,0x629c190b}},	//   deir, mem_, _اقتص, _okro, 
   {{0xa2c3802a,0x442f990c,0x60c0990d,0x78a2990e}},	//   रदर्, _zag_, _limm, hlov, 
   {{0x5887190f,0x7c240324,0xd49b1910,0x78a29911}},	//   _выпа, feir, вра_, klov, 
   {{0x44249912,0x6130011d,0x78a28d69,0x7c241913}},	//   nem_, zólá, jlov, geir, 
   {{0x78a2826b,0x44249914,0x644d1915,0xa3b10034}},	// [c10] dlov, iem_, rjai, टें_, 
   {{0x44249916,0x62851917,0xa3cb1918,0x6e239919}},	//   hem_, unho, रुज_, xenb, 
   {{0x61e70142,0x7c24191a,0x6113001b,0x6285191b}},	//   _vejl, beir, dělá, rnho, 
   {{0x7c24191c,0x27e9191d,0x9ef580d8,0x6e238294}},	//   ceir, _jean_, مستش, wenb, 
   {{0x2b470d29,0x442f991e,0x6e23991f,0x53340008}},	//   _тэнг, _rag_, tenb, _деят, 
   {{0x6442830b,0x442f9920,0x672d004f,0x7d039921}},	//   _anoi, _sag_, _msaj, tuns, 
   {{0xe2999922,0x442f9923,0x78a29924,0x60c0807f}},	//   ған_, _pag_, blov, _fimm, 
   {{0x44249925,0xf8b984a0,0x7cd180f3,0x213e00fe}},	//   gem_, _сөз_, _pārb, _átha_, 
   {{0x442f9926,0x9f44859e,0x6e239927,0x7d039928}},	//   _vag_, _hemî_, penb, suns, 
   {{0x44321929,0x442f992a,0x60c0992b,0x7d03807b}},	//   zdy_, _wag_, _zimm, puns, 
   {{0x236d8066,0x442f992c,0x4424992d,0x29130122}},	//   szej_, _tag_, bem_, ntxa_, 
   {{0x4424992e,0x7c24191c,0x442f858f,0x245c01c2}},	//   cem_, xeir, _uag_, _tími_, 
   {{0x7c240569,0x4374992f,0x6d410523,0x44320170}},	//   veir, _мушт, ålan, vdy_, 
   {{0xda0305d9,0x6d5c1930,0x1d0a1931,0xa3bd1932}},	//   _लागत_, tyra, леги_, ेखन_, 
   {{0x7c241933,0x78a29934,0x98a780ac,0x33f61935}},	//   teir, ylov, íně_, йчас, 
   {{0x27e91936,0x29059937,0xeb9a1938,0x3fe609d9}},	//   _gean_, mula_, гиб_, _ужив, 
   {{0x29059939,0x7c24193a,0x387d811a,0x64aa81d2}},	// [c20] lula_, reir, diwr_, _přiz, 
   {{0x7c24193b,0x09e800b2,0x0f370309,0x200d84ab}},	//   seir, _পাহা, _פריט_, _acei_, 
   {{0x7d1e193c,0xe8fa193d,0x27e900bf,0x7c2403e2}},	//   _upps, уле_, _yean_, peir, 
   {{0x4424993e,0x673b8cfa,0x3a25993f,0x60c083ad}},	//   xem_, _bruj, help_, _qimm, 
   {{0x44249940,0x78a29144,0x29059941,0x60c09942}},	//   vem_, rlov, hula_, _vimm, 
   {{0x78a29943,0x29059944,0x412a0d38,0xa4d88bb9}},	//   slov, kula_, _його_, адку_, 
   {{0x60c09945,0x2609871c,0x7bc60128,0x29059946}},	//   _timm, _सारी_, _kgku, jula_, 
   {{0x29059947,0xbf4d81d2,0xafdb12fb,0xcefd92b6}},	//   dula_, _šířk, hjør, üğün_, 
   {{0xe737836d,0x5334924a,0x9f5e02a5,0x673b9948}},	//   _лет_, цепт, ştê_, _gruj, 
   {{0x44249949,0x3d190d99,0x6f060f2c,0x2905994a}},	//   sem_, _पहले_, dukc, fula_, 
   {{0x2905994b,0x6e93994c,0x442488a1,0x3a370039}},	//   gula_, _علما, pem_, זרים_, 
   {{0x6ca68267,0xc867194d,0x5edd05a2,0xc9530309}},	//   _اصطل, стои, _বিবে, למת_, 
   {{0xa3bc994e,0x27e9194f,0xdef80c30,0x26c10347}},	//   _आणि_, _vean_, йыр_, _piho_, 
   {{0x290582ee,0x63a29950,0xafdb00f0,0x161b9855}},	//   bula_, _iyon, gjør, प्पर_, 
   {{0x29059951,0x865b89be,0x280401d2,0xdd3a0166}},	//   cula_, נדלי, ásné_, văţa, 
   {{0xd5d901d1,0x81c000b2,0x213f0269,0x985d0034}},	//   _ब्रज, ীরা_, _čuh_, _błąd_, 
   {{0x32551952,0x672d004f,0x62889953,0x26099954}},	// [c30] овар, _usaj, ondo, _साली_, 
   {{0x62889955,0x80db80b2,0x98bf0162,0xf8c98279}},	//   nndo, _ভিত্, tytė_, _mẩn_, 
   {{0x38691956,0x63a29957,0x9f5282a5,0x62889958}},	//   _klar_, _lyon, ûyî_, indo, 
   {{0x629a8c3f,0xf77080dd,0x6e271959,0x27e9995a}},	//   hoto, کام_, lejb, úan_, 
   {{0x629a995b,0xddc5836a,0x2905995c,0x2489195d}},	//   koto, обли, zula_, mnam_, 
   {{0xe618805a,0xdce88180,0x3869195e,0x673b8a63}},	//   йді_, _aydı, _llar_, _vruj, 
   {{0xe80a00d5,0x38690816,0x69c7036a,0x2489195f}},	//   _वाला_, _olar_, _igje, onam_, 
   {{0x06d880b2,0x63a28ca7,0x290582d7,0xe4599960}},	//   _সিরি, _byon, vula_, ржи_, 
   {{0x629a9961,0x29059962,0x24891963,0xf8c98106}},	//   foto, wula_, inam_, _cẩn_, 
   {{0x29058afc,0x629a9964,0x63a286e4,0x38691965}},	//   tula_, goto, _dyon, _alar_, 
   {{0x60260241,0xd8261966,0x38691967,0x63a28640}},	//   одна, одни, _blar_, _eyon, 
   {{0x38691968,0xe73a1969,0x6288996a,0x7645043a}},	//   _clar_, аем_, ando, _anhy, 
   {{0x629a996b,0x2905996c,0x63a28371,0xe1ee95eb}},	//   boto, sula_, _gyon, _ог_, 
   {{0x2905996d,0x61ea996e,0x629a996f,0x24891970}},	//   pula_, _gefl, coto, enam_, 
   {{0xed570188,0x8c7a0086,0xdd920a85,0x2c670587}},	//   оор_, ащат_, ذور_, _sõda_, 
   {{0x60c91523,0x69c700f8,0x69d501f0,0x04431971}},	//   _čemp, _agje, _afze, месн, 
   {{0xd4671972,0x161b00da,0xc8890de8,0x02ed002a}},	// [c40] ците_, _पॉवर_, _دخول_, _चौदह_, 
   {{0xae0e8b30,0x386903ad,0xafdb056e,0x78a61973}},	//   _साधन_, _zlar_, ljøp, llkv, 
   {{0x4fc69974,0x38cb00dd,0x7cf080d8,0xc7c69975}},	//   осла, لانی_, _mórá, осли, 
   {{0x69da1976,0x629a9977,0x09aa0076,0x1b2085a2}},	//   _प्री, zoto, _करीय, বিতে_, 
   {{0x41c9800c,0x64461978,0x3ced0024,0x629a8010}},	//   रशास, _inki, ćeve_, yoto, 
   {{0x72c3036d,0x4733836a,0x6b849092,0xa3dc8076}},	//   _обяз, ьніс, _žigo, तुन_, 
   {{0x629a9979,0x26120079,0x7866011e,0x68ed8034}},	//   voto, _तानी_, _nóvo, _ładn, 
   {{0x69c70210,0x7c36197a,0x629a997b,0x6ab2997c}},	//   _zgje, ndyr, woto, ँग्र, 
   {{0x3ce9803a,0x629a82b7,0x3e6b8764,0x38690ced}},	//   ćava_, toto, _søte_, _rlar_, 
   {{0x248910d4,0xd25a80cb,0x7afd997d,0x6f02997e}},	//   znam_, рци_, ásta, mroc, 
   {{0x2bac8439,0x62888615,0x6446019b,0x4035197f}},	//   _चरवा, rndo, _onki, пенс, 
   {{0x0b469980,0x7ea0010d,0x6f029981,0x6a6489b2}},	//   _мнен, köps, oroc, _tòfo, 
   {{0x63a28128,0x628f8429,0x06cc85a2,0xdfa70a5e}},	//   _uyon, écoc, রীরি, تحدي, 
   {{0x64461982,0x5edd00b2,0x628e0269,0x22580109}},	//   _anki, _বিদে, _njbo, _nork_, 
   {{0xd7fb1983,0x64c51984,0xa6e98279,0x55580123}},	//   _куп_, वदेश, _giươ, оаря_, 
   {{0x38690004,0xd14b004e,0x60c40009,0x6f029985}},	//   _ular_, یشان_, _giim, kroc, 
   {{0x24891986,0x3f8c008a,0x27ef9987,0x22581988}},	// [c50] rnam_, şdur_, vagn_, _bork_, 
   {{0xe80d85d9,0x9388109a,0x0b8800f0,0xe8170353}},	//   _हाहा_, іста_, істи_, ध्रा_, 
   {{0x7ea4875d,0x9c7c817c,0x248009ec,0x00000000}},	//   còpi, _pwčl, biim_, --, 
   {{0xb8f31989,0x3495198a,0x00c8005a,0xc95380c6}},	//   _हं_, _хамр, ілік_, ומע_, 
   {{0x4429198b,0x6f02998c,0x872780d8,0xddc1998d}},	//   mea_, groc, تعام, _bolş, 
   {{0x4429198e,0x27ef92fb,0xb90105a2,0xd629998f}},	//   lea_, sagn_, _দি_, соке_, 
   {{0x308588f7,0x22499990,0x3b0900bf,0x2fc9013b}},	//   _فلسف, _đak_, luaq_, _ogag_, 
   {{0x44291991,0x6f029992,0x2fc90009,0x68ed8034}},	//   nea_, broc, _ngag_, _łado, 
   {{0x4ea7839b,0x22581993,0xa3bd001b,0xeda8001b}},	//   _држа, _york_, ेखि_, _गर्छ, 
   {{0x28cf81b7,0x44291994,0x27ed83c5,0xcb1213b1}},	//   _संदि, hea_, _heen_, עלי_, 
   {{0x44291995,0xd9459996,0xa0a61997,0x60c41998}},	//   kea_, чени, занд, _piim, 
   {{0x26c5822d,0xc4d28039,0x44291999,0xa3bd03c9}},	//   _hilo_, _נגד_, jea_, ेखा_, 
   {{0x4429199a,0x60c4199b,0xeb8e999c,0x7c29999d}},	//   dea_, _viim, _чи_, meer, 
   {{0xc4c60013,0xd35684fc,0x27ed999e,0xbb3a82f9}},	//   كترو, _מיני_, _leen_, _לעני, 
   {{0xceb28052,0xc1aa00a1,0x4429199f,0x55c5004a}},	//   גים_, _करेग, fea_, дарғ, 
   {{0x7c2999a0,0x442919a1,0x6f0299a2,0x628199a3}},	//   neer, gea_, yroc, lilo, 
   {{0xe1fa025c,0x20120a39,0x26c599a4,0x2d850429}},	// [c60] йга_, _icyi_, _oilo_, ûler_, 
   {{0x62818012,0x7c2999a5,0x69de8079,0x442900bc}},	//   nilo, heer, _õpet, aea_, 
   {{0x35a619a6,0x2366003a,0x27ed8052,0x7c298f5d}},	//   _ханг, šoj_, _been_, keer, 
   {{0x69c3892c,0x225819a7,0x628199a8,0x442919a9}},	//   _रणनी, _work_, hilo, cea_, 
   {{0xbea68163,0x628199aa,0x225819ab,0x7c2999ac}},	//   падк, kilo, _tork_, deer, 
   {{0x6b8907e9,0x98ac8a08,0x26c580ca,0x672401cb}},	//   _þega, ılır_, _cilo_, _mpij, 
   {{0x7c2999ad,0x628199ae,0x26c599af,0x645999b0}},	//   feer, dilo, _dilo_, _bowi, 
   {{0x27ed99b1,0x7c2999ad,0x67240265,0xae0e99b2}},	//   _geen_, geer, _opij, _सावन_, 
   {{0x645980a1,0x61ee19b3,0x26c599b4,0x386699b5}},	//   _dowi, _kebl, _filo_, mkor_, 
   {{0x442919b6,0x628199b7,0x25a599b8,0x58d48418}},	//   zea_, gilo, _fyll_, моот, 
   {{0x7c298ca7,0x764899b9,0x61ee00a1,0x67240a63}},	//   beer, _indy, _mebl, _apij, 
   {{0xa3e6800f,0x7c298a44,0x27ed01e0,0x629e19ba}},	//   _बजट_, ceer, úen_, hopo, 
   {{0xb8d399bb,0x9f5e02a5,0x6a60012b,0x629e19bc}},	//   _जी_, ştî_, _höfu, kopo, 
   {{0xcad78052,0x62818123,0x61ee0162,0x20f80269}},	//   _צוות_, cilo, _nebl, kči_, 
   {{0x442919bd,0x765a99be,0x20f819bf,0x629e0d33}},	//   tea_, _moty, jči_, dopo, 
   {{0xa3d4000d,0xc7c719c0,0x4fc715c2,0x81e900b2}},	//   सँग_, _эски, _эска, _যাই_, 
   {{0x442919c1,0xe7e30d99,0x261a0365,0x245819c2}},	// [c70] rea_, _क्या_, म्ही_, чать_, 
   {{0x7c2999c3,0x629e19c4,0x32d2801c,0x61fc0128}},	//   zeer, gopo, _mây_, _cdrl, 
   {{0x442919c5,0x80a40f2a,0x30158008,0x26c58128}},	//   pea_, _زمین, ддер, _rilo_, 
   {{0x2c09007b,0x442903ad,0x7c29893c,0x5ee185a2}},	//   _بعدی_, qea_, xeer, _নিবে, 
   {{0x7c2982f6,0x2ca919c6,0x61ee19c7,0xcc5613b1}},	//   veer, mlad_, _febl, _חברי_, 
   {{0x2ca919c8,0x645999c9,0x7c2999ca,0x61ee10d2}},	//   llad_, _sowi, weer, _gebl, 
   {{0x64598d99,0x765a99cb,0x7c2999cc,0x27ed99cd}},	//   _powi, _doty, teer, _teen_, 
   {{0x386680f9,0x61e490f3,0x32d2801c,0xccf8801b}},	//   ckor_, _đila, _bây_, _dvě_, 
   {{0x7c2999ce,0x06e200cf,0x628199cf,0x32d28028}},	//   reer, _বিভি, tilo, _cây_, 
   {{0x7c2999d0,0xe8f999d1,0x32d2801c,0x2ca919d2}},	//   seer, оло_, _dây_, hlad_, 
   {{0x62818cc1,0x2ca919d3,0x356b99d4,0xa6dd00cf}},	//   rilo, klad_, _уран_, _বিষয়, 
   {{0x200f99d5,0x628199d6,0x06e200b2,0x1de619d7}},	//   nggi_, silo, _বিবি, कर्ष_, 
   {{0x28cf80c3,0x32d28028,0x2ca919d8,0x62798170}},	//   _संवि, _gây_, dlad_, dňov, 
   {{0x5edd00cf,0x248d99d9,0x7cd50116,0x753c01d2}},	//   _বিশে, lnem_, _sąra, tvrz, 
   {{0x64a619da,0xddd88533,0x248d99db,0x6da319dc}},	//   дава, nivš, onem_, вира, 
   {{0x248d99dd,0x161f0bf5,0x4e1f03b4,0x2ca919de}},	//   nnem_, म्बर_, म्बई_, glad_, 
   {{0xa5a48611,0x3ced006a,0x32d28028,0xf1fa19df}},	// [c80] _चुनौ, ćeva_, _xây_, قعات_, 
   {{0x9f44803e,0x7cd180f3,0x1e83099b,0x386d8a1c}},	//   _nemá_, _pārl, _альм, _aler_, 
   {{0x629e19e0,0x85bb0068,0x2ca919e1,0x20f80f64}},	//   ropo, _واپس_, blad_, uči_, 
   {{0x20d38028,0x7bcb803d,0x248d99e2,0x9f4b01d2}},	//   _mãi_, _nggu, jnem_, zací_, 
   {{0x629e19e3,0x248d96ee,0x6d4199e4,0x20d38106}},	//   popo, dnem_, _arla, _lãi_, 
   {{0x386699e5,0xa3bd0562,0x7bcb99e6,0x6d4180e5}},	//   skor_, ेखर_, _aggu, _brla, 
   {{0x386d99e7,0x9f4b03e0,0xceb30273,0xa06a90e6}},	//   _fler_, vací_, דיג_, _дава_, 
   {{0x38b58e87,0x29180b62,0x7d0a81ed,0x60cd8269}},	//   gård_, _iqra_, rufs, _čamp, 
   {{0x6d4199e8,0x27e699e9,0xc5f400b2,0xd62680fe}},	//   _erla, mbon_, _জানা_, _يعطي, 
   {{0x20d38106,0x78a419ea,0x27e68122,0x518699eb}},	//   _bãi_, _akiv, lbon_, дума, 
   {{0x248d99ec,0xddd88215,0x9f4b03d5,0x20d38106}},	//   bnem_, civš, rací_, _cãi_, 
   {{0x32d28028,0x27e699ed,0xfe0e8439,0x20d38279}},	//   _tây_, nbon_, _साँस_, _dãi_, 
   {{0x80ca8808,0x2ca919ee,0x7c228103,0x290599ef}},	//   _संके, vlad_, _ibor, arla_, 
   {{0x2ca902ad,0x20050646,0x19948116,0x6456022a}},	//   wlad_, şli_, _паля, ejyi, 
   {{0x44fa81a8,0xda6599f0,0x62798170,0x4422163b}},	//   nī_, _ثاني, tňov, _bbk_, 
   {{0x8af0008c,0x290c99f1,0x2ca0013b,0xa3b580c9}},	//   yyət, muda_, goid_, छेक_, 
   {{0xfe0e903a,0x442200ca,0x290c99f2,0x7b18019b}},	// [c90] _सांस_, _dbk_, luda_, мотр_, 
   {{0xd5a4811d,0x248d99f3,0xe3b000d8,0x62798507}},	//   _نہ_, znem_, شرق_, sňov, 
   {{0x7c2299f4,0x6279826b,0x38b219f5,0x7cd181a8}},	//   _obor, pňov, lára_, _pārm, 
   {{0xddd88131,0x5f9599f6,0x5f008079,0x442209fb}},	//   vivš, ниет, _रिश्_, _gbk_, 
   {{0xf62599f7,0x248d8bfc,0x7c2d19f8,0x38b58172}},	//   едло, vnem_, mear, vård_, 
   {{0x443919f9,0xddd88131,0x7c2d19fa,0x290c99fb}},	//   _has_, tivš, lear, kuda_, 
   {{0x443919fc,0xe5a299fd,0x248d8bfc,0x6da29544}},	//   _kas_, лиши, tnem_, лиша, 
   {{0x7c2d19fe,0x645d19ff,0x62851a00,0x44391a01}},	//   near, _josi, liho, _jas_, 
   {{0x4439022a,0x645d1a02,0x248d9a03,0x9985801b}},	//   _mas_, _mosi, rnem_, telů_, 
   {{0x44391a04,0x7c2d0094,0x78a40e87,0x62851a05}},	//   _las_, hear, _skiv, niho, 
   {{0x290c9a06,0x6d419a07,0x60c99a08,0x44390a6c}},	//   guda_, _urla, _kiem, _oas_, 
   {{0x60c98116,0x7aeb81df,0x6a6d80e9,0x9b598c30}},	//   _jiem, _twgt, _dúfa, _ниет_, 
   {{0xe28e9a09,0x60c985da,0x442d9a0a,0x7c2d1a0b}},	//   _ба_, _miem, mee_, dear, 
   {{0x442d9a0c,0x786605da,0x60c99a0d,0x44221a0e}},	//   lee_, _móvi, _liem, _sbk_, 
   {{0x44391a0f,0x6fa0150f,0x645d1a10,0x26179379}},	//   _bas_, _गुरू, _bosi, _नानी_, 
   {{0x44391a11,0x7c3b9a12,0x442d9a13,0x60c99a14}},	//   _cas_, ndur, nee_, _niem, 
   {{0x44391a15,0x645d1a16,0x644b80e5,0x7c398324}},	// [ca0] _das_, _dosi, _mngi, _mawr, 
   {{0x442d9a17,0x27ff9663,0x6aa18324,0xae0e80a1}},	//   hee_, _adun_, nolf, _साइन_, 
   {{0x26d2022d,0x44391a18,0x442d9a19,0x7c2d1a1a}},	//   _huyo_, _fas_, kee_, bear, 
   {{0x60c99a1b,0x7c2d1a1c,0x7866011e,0x61e30a08}},	//   _ciem, cear, _bóvi, ınla, 
   {{0x765e1a1d,0xe818000f,0x3a380116,0x9f348efb}},	//   _kopy, _थाना_, _tarp_, телі, 
   {{0x44201a1e,0x7ae41a1f,0x645d1a20,0x6e2e1a21}},	//   lfi_, mpit, _zosi, nebb, 
   {{0x44391a22,0x442d842d,0x7ae41a23,0x645d1a24}},	//   _yas_, fee_, lpit, _yosi, 
   {{0x50b589b2,0x8fa69a25,0x4439006c,0x442d87b8}},	//   _асуу, _забе, _xas_, gee_, 
   {{0x7ae41a26,0x7c3982a1,0xddcf81d2,0x442002ad}},	//   npit, _dawr, řešn, ifi_, 
   {{0x60c99a27,0x44201a28,0x290c9a29,0x644b9a2a}},	//   _ziem, hfi_, tuda_, _engi, 
   {{0xd48f9a2b,0xa1949a2c,0x27f2017c,0x06d885a2}},	//   _бр_, танч, _beyn_, _সিটি, 
   {{0x290c9a2d,0x7ae41a2e,0x7c229a2f,0x442d9a30}},	//   ruda_, kpit, _ubor, cee_, 
   {{0x69dc0422,0x645d1a31,0xc6f808cf,0x26d205cb}},	//   _ofre, _rosi, ннях_, _cuyo_, 
   {{0x62850149,0x2b40084c,0xb90685a2,0x6e2e0063}},	//   xiho, dvic_, _পি_, gebb, 
   {{0x44391a32,0xa8a712e8,0x44201a33,0x7c2d1a34}},	//   _pas_, _прик, ffi_, tear, 
   {{0x69dc1a35,0xa01b010d,0x44391a36,0x7f440a1c}},	//   _afre, rnös, _qas_, _friq, 
   {{0xe4ed023b,0x7c2d1a37,0x60c99a38,0x645d0103}},	// [cb0] _जबकि_, rear, _riem, _vosi, 
   {{0x44391a39,0x60c99a3a,0x7c2d1a3b,0x442d9a3c}},	//   _was_, _siem, sear, zee_, 
   {{0x44391a3d,0x60c99a3e,0x645d036d,0x9f52024a}},	//   _tas_, _piem, _tosi, _neyê_, 
   {{0x44391123,0x442d858f,0x62851a3f,0xdddc0116}},	//   _uas_, xee_, siho, mirš, 
   {{0xd3669a40,0xab870974,0x6f1d1a41,0xb8d8010c}},	//   _ئه_, _чунк, ntsc, _घी_, 
   {{0x442d9a42,0x6d4a00fe,0x6f1d01ab,0x60c99a43}},	//   wee_, _áfac, itsc, _wiem, 
   {{0x60c99a44,0x442d9a45,0x6e3a8324,0x78a28269}},	//   _tiem, tee_, _datb, boov, 
   {{0xdd8e8013,0x20d70083,0x6e3a813b,0x6f049a46}},	//   توى_, _içi_, _eatb, šica, 
   {{0x2ba70611,0x36d5836a,0x442d8052,0x5f948103}},	//   _कुमा, _розр, ree_, _битт, 
   {{0x6f0f1a47,0x39459a48,0x442d9a49,0xcb1400c6}},	//   ducc, вног, see_, אלץ_, 
   {{0xd00a1a4a,0x26d21a4b,0x44201a4c,0x35558275}},	//   мене_, _suyo_, yfi_, _جناز, 
   {{0xcc14807b,0x8d848741,0x6e2e0640,0x7bcf00bc}},	//   _مذهب, _сууд, webb, _ngcu, 
   {{0xa3a8809b,0x6e2e1a4d,0x69c39115,0x547a8309}},	//   _खुप_, tebb, _रणवी, _קטנו, 
   {{0x2cad8052,0xdee31a4e,0x6d4500e5,0x66e31a4f}},	//   lled_, рори, _brha, рора, 
   {{0xe5a61a50,0x7afd1a51,0x6da614b9,0x6e2e0574}},	//   тиви, _avst, тива, rebb, 
   {{0x64be0795,0xb4ac009b,0x26d21a52,0x7f441a53}},	//   ्देश, गते_, _tuyo_, _triq, 
   {{0x44201a54,0x7d0e1a55,0x6d4502ae,0x6b631a56}},	// [cc0] rfi_, subs, _erha, акта, 
   {{0x2cad801b,0x2cbf9a57,0x63ab813b,0x7ae41a58}},	//   hled_, hmud_, _mygn, rpit, 
   {{0x2ba7007a,0xa3ea1a59,0x6e3c9a5a,0x7ae41a5b}},	//   _कुठा, _одна_, _órbi, spit, 
   {{0x66e69a5c,0xdee68bdc,0x248202fa,0xe7869a5d}},	//   вода, води, _umkm_, куло, 
   {{0x44fe01e2,0x2cad843a,0x6e3a847f,0x62838033}},	//   lį_, dled_, _patb, _omno, 
   {{0xdd9490ea,0x24921a5e,0x2cad8519,0xb7d280b2}},	//   лалы, lnym_, eled_, ারেট, 
   {{0x44fe01e2,0xda18807a,0x660101fb,0x6e3a9a5f}},	//   nį_, _दाबत_, ólki, _vatb, 
   {{0x24921a60,0x386002c0,0x63ab8c05,0x62839502}},	//   nnym_, _noir_, _bygn, _amno, 
   {{0x7afb9a61,0xa7a79a62,0x6e3a9a63,0xaec680a6}},	//   gsut, _акта_, _tatb, _абал, 
   {{0x63ab8172,0x44fe0162,0x38601a64,0xf8ca0279}},	//   _dygn, kį_, _aoir_, _mẩu_, 
   {{0xd6e200cf,0x26179a65,0x2cad8039,0x38600064}},	//   _বিষয, _नाती_, bled_, _boir_, 
   {{0x2cad9a66,0x3860065e,0xb4ac009b,0xdddc0162}},	//   cled_, _coir_, गतो_, virš, 
   {{0xf8bf02c0,0x24920e4a,0x7f429a67,0x44269a68}},	//   rmé_, dnym_, nvoq, _ibo_, 
   {{0x6f1d1a69,0x6f0f1a6a,0x2c750142,0xb7e30a9a}},	//   rtsc, rucc, _måde_, _क्रम_, 
   {{0x26cc9a6b,0x7cd180f3,0x2bc51a6c,0x6f1d1a6d}},	//   _mido_, _pāri, लेना, stsc, 
   {{0x4815013f,0x91f282f4,0x38601a6e,0xd4981a6f}},	//   _смис, _आजुओ_, _goir_, вру_, 
   {{0x201e008c,0x09bd117e,0x44269a70,0x26cc81ce}},	// [cd0] əti_, ्ख्य, _mbo_, _oido_, 
   {{0x62889a71,0x7afd852f,0x7ae28010,0x99671a72}},	//   nido, ásti, _mtot, ктел, 
   {{0xdfd18013,0x60cd1a73,0x7ac41a74,0x67299a75}},	//   ميا_, _kiam, рсте, _spej, 
   {{0x2c750f76,0x245881ac,0x9f52017c,0x60cd1a76}},	//   _både_, _témy_, _beyè_, _jiam, 
   {{0x60cd1a77,0x26cc8265,0xb8fa07b0,0x160e809b}},	//   _miam, _bido_, _डू_, _साखर_, 
   {{0x9f44824a,0x44269a78,0x7c3d1a79,0xa3e58c2e}},	//   _hemû_, _abo_, _hasr, बुन_, 
   {{0x6288852f,0x261b0689,0xc2120039,0x6ed506d7}},	//   dido, _बानी_, _להם_, _यूसु, 
   {{0x39499a7a,0x60cd1a7b,0x7afb9a7c,0x24891a7d}},	//   _čas_, _niam, tsut, niam_, 
   {{0x89f585cf,0x291e8e05,0x26cc9a7e,0x9f34804a}},	//   лянц, etta_, _fido_, _кеті, 
   {{0x62889a7f,0x38601a80,0x7afb9a81,0x7ead80e9}},	//   gido, _soir_, rsut, kúpi, 
   {{0x7afb9a82,0xe73c07fa,0x78bb81df,0x60cd017c}},	//   ssut, _küçü, _khuv, _biam, 
   {{0x66e61a83,0x7c3d1a84,0x60cd1a85,0xdee61a86}},	//   лома, _nasr, _ciam, ломи, 
   {{0x38600700,0x24891a87,0x7e619a88,0x60cd1a89}},	//   _voir_, diam_, _kolp, _diam, 
   {{0x6288939c,0x443f9a8a,0x26cc811e,0x62838284}},	//   cido, ldu_, _xido_, _umno, 
   {{0x443d9a8b,0x443f8116,0x60cd1a8c,0xff1400b2}},	//   _kaw_, odu_, _fiam, িবেশ_, 
   {{0x60cd1a8d,0x38b90019,0x7c3d0064,0x44fe0116}},	//   _giam, tére_, _casr, rį_, 
   {{0x4bd9182e,0x3a260004,0x42261a8e,0x443d811a}},	// [ce0] ться_, лмаг, лдав, _maw_, 
   {{0xe7471a8f,0x78a61a90,0x443d8039,0x44fe0162}},	//   ções_, lokv, _law_, pį_, 
   {{0x09061a91,0x9f520206,0x38b90019,0x26cc9a92}},	//   упен, _seyè_, sére_, _rido_, 
   {{0x26cc9a93,0x3860812b,0x443d843a,0x78bb8569}},	//   _sido_, ðir_, _naw_, _chuv, 
   {{0x443f9a94,0x26cc9a95,0x7e619a96,0x43671a97}},	//   ddu_, _pido_, _bolp, _баян_, 
   {{0x0f370052,0x628883b9,0x443f9a98,0x7e619a99}},	//   טרנט_, xido, edu_, _colp, 
   {{0xe29704bc,0x60d50685,0x443d9a9a,0xad268604}},	//   _сар_, _guzm, _baw_, ارتو, 
   {{0xdd0401e2,0x443d9a9b,0x44321a9c,0x7c241a9d}},	//   ūrėt, _caw_, ney_, nfir, 
   {{0x443d9a9e,0xb2749a9f,0x3a749aa0,0xf7439aa1}},	//   _daw_, илиш, илир, _лето, 
   {{0x60cd1aa2,0x59b80503,0x7e619151,0xc3330052}},	//   _siam, _अरार, _golp, צות_, 
   {{0x7c241aa3,0xc27b00c6,0x291e8008,0x443f82a1}},	//   kfir, גריי, utta_, bdu_, 
   {{0xf5378052,0x7cd18029,0x443202ef,0x60cd0766}},	//   _תנאי_, _pārv, jey_, _qiam, 
   {{0x24891aa4,0x442480bf,0x248683ad,0x27e00199}},	//   viam_, mfm_, _imom_, _dfin_, 
   {{0xbb3b8273,0x248900a1,0x7ead80e9,0x35a9802a}},	//   _רעגי, wiam_, túpi, _चुड़, 
   {{0x24891aa5,0x60cd006c,0x61fa9aa6,0x7c241aa7}},	//   tiam_, _tiam, matl, ffir, 
   {{0x61fa9aa8,0x443d81df,0xfe7701e5,0x6d489aa9}},	//   latl, _xaw_, түү_, _mrda, 
   {{0x24891aaa,0x3b551aab,0x99900284,0x50b8006f}},	// [cf0] riam_, шкар, _čaša_, _حدود_, 
   {{0x7cd18029,0x61fa9aac,0x443f9aad,0xbbd186d7}},	//   _kārt, natl, zdu_, _हल्क, 
   {{0x39471aae,0x443f9aaf,0x628f8035,0x660101c2}},	//   íns_, ydu_, écoi, ólku, 
   {{0x2617994e,0x61fa9ab0,0x644f02fb,0x60c29ab1}},	//   _नाही_, hatl, _unci, gmom, 
   {{0x6d489ab2,0xe7399ab3,0x61fa8b7f,0x443f9ab4}},	//   _arda, тел_, katl, vdu_, 
   {{0xa509904c,0x8d658cd9,0x26dc00c6,0x6d4897a2}},	//   века_, ивле, עקומ, _brda, 
   {{0xed599ab5,0x443d8e9d,0x61fa9ab6,0x7e619ab7}},	//   той_, _paw_, datl, _volp, 
   {{0x443f9ab8,0x6498864e,0x3e741ab9,0xc60680b2}},	//   udu_, лтыр_, _mäta_, ল্লা_, 
   {{0xa3a8823b,0x443f9aba,0xfc3f07e9,0x290c85cb}},	//   _खुद_, rdu_, _maí_, erda_, 
   {{0xc6a79abb,0x64409abc,0x61fa9abd,0x2bd18625}},	//   _срби, admi, gatl, _हलका, 
   {{0x443208c6,0x3ea79abe,0x443d9abf,0xf99180fe}},	//   yey_, mont_, _taw_, تبة_, 
   {{0x18a61ac0,0x443f8519,0x92a60034,0xf7461ac1}},	//   рамм, qdu_, _załą, аемо, 
   {{0x61fa9799,0xa3d91ac2,0x290c9ac3,0xbca49ac4}},	//   batl, ाशन_, arda_, _امني, 
   {{0x44321ac5,0x4b7a8273,0x7ae99ac6,0x200c008a}},	//   wey_, _באנו, mpet, şdi_, 
   {{0x44321ac7,0x44f38123,0x8d631ac8,0x37e600a6}},	//   tey_, nţ_, овре, _койг, 
   {{0xb05b1ac9,0x673b8c0e,0xd91a8eee,0x26121aca}},	//   lmän, _osuj, _סופל, _ताकी_, 
   {{0x7c241acb,0x7ae99acc,0x6a861acd,0x3ea79ace}},	// [d00] rfir, npet, алаа, kont_, 
   {{0x23271acf,0xab271ad0,0x14b8009b,0x7bdf01e9}},	//   рофи_, рофа_, _आठवण, acqu, 
   {{0xd00f1ad1,0x7f498396,0x3320037f,0x261b0079}},	//   _علی_, _areq, stix_, _बाती_, 
   {{0x03a600f0,0x8c461ad2,0x04461ad3,0x09d2801b}},	//   _вимо, _теме, _темн, _सल्य, 
   {{0x61fa97f8,0x27e985da,0x6d488131,0xbb4300f0}},	//   yatl, ñana_, _srda, _деяк, 
   {{0x29130065,0xa01b019b,0xbb4303b8,0xa3e20587}},	//   buxa_, riöi, _ќерк, नुर_, 
   {{0xd49a8020,0x61fa9ad4,0x44249ad5,0x26179669}},	//   кри_, vatl, tfm_, _नारी_, 
   {{0xa0678e19,0x61fa8129,0x7f499ad6,0x18679ad7}},	//   _каса_, watl, _freq, _каси_, 
   {{0x61fa9ad8,0xa0679ad9,0x7f4980f8,0xc1788116}},	//   tatl, _тата_, _greq, ybės_, 
   {{0xaa668ded,0x7cd180f3,0x09ca00b2,0x67229ada}},	//   ртик, _pārt, _ল্যা, mtoj, 
   {{0xfce38c89,0x61fa9adb,0xd2578e71,0x6d489adc}},	//   _дохо, ratl, рцы_, _urda, 
   {{0x67228116,0x7cd181a8,0x61fa9add,0x4432812f}},	//   otoj, _vārt, satl, _úy_, 
   {{0x672296b5,0x628001e2,0xab839ade,0xb7141207}},	//   ntoj, _įmon, _мушк, одящ, 
   {{0xea00010b,0xf8b80741,0x61fa9adf,0xfc3f0432}},	//   _đến_, лөө_, qatl, _saí_, 
   {{0xb2bb8052,0xa5f806bf,0xbd681ae0,0x28d01932}},	//   _שמור, ресу_, арте_, _संचि, 
   {{0x2c7500f9,0x67229ae1,0x63af1ae2,0xdb0f016f}},	//   _båda_, ktoj, _pycn, _azcá, 
   {{0x3a750004,0x4aba8079,0xaaba810c,0x6722816c}},	// [d10] блар, _उठाव, _उठाक, jtoj, 
   {{0x4395004c,0x2913011e,0x6d430105,0x19590c98}},	//   _ҳамс, tuxa_, _šnau, лазы_, 
   {{0x2ba7000d,0xc5f20039,0xdd911ae3,0x61f89ae4}},	//   _कुरा, _מדי_, _روح_, _mevl, 
   {{0x2019151e,0x31578273,0x272086e0,0x6722816c}},	//   ngsi_, ייבן_, fòn_, ftoj, 
   {{0xf7459ae5,0xb4b300da,0xc8d0009b,0x27209ae6}},	//   село, टती_, _संघट, gòn_, 
   {{0x2ca90657,0x78a2803e,0xbb3a00c6,0x14b5009b}},	//   load_, čova, _געשי, ंतवण, 
   {{0xfbdb007a,0x3ea782c0,0x442b1ae7,0x28f81a59}},	//   _भलाम, ront_, _kbc_, _весь_, 
   {{0x1ee78267,0x7ae985c3,0x2901004f,0x4adb1ae8}},	//   _نوری_, tpet, msha_, _बढाव, 
   {{0x7cd18029,0x442b1ae9,0x3ea79aea,0x4aa99aeb}},	//   _pārs, _mbc_, pont_, лкин_, 
   {{0xfc3f800d,0xeb978004,0x38bc80fe,0x408782bb}},	//   ží_, лиқ_, ríre_, _суҳб, 
   {{0x61f89aec,0x186a1aed,0x7ae99aee,0xa06a1aef}},	//   _devl, гани_, spet, гана_, 
   {{0xf9920039,0x29011af0,0xb05b1af1,0x7ae99af2}},	//   לרי_, isha_, smän, ppet, 
   {{0x248d834a,0x3b098dc7,0x76419af3,0x7205803d}},	//   miem_, _село_, _kaly, _هوشم, 
   {{0x78ad00d7,0x248d80f3,0x61f8876a,0xb05b019b}},	//   _ekav, liem_, _gevl, lmäl, 
   {{0x442b0064,0xceb29af4,0x76419af5,0xd5b21af6}},	//   _bbc_, פיל_, _maly, سفر_, 
   {{0x248d9af7,0x672281e2,0xb05b0172,0x6d4a011e}},	//   niem_, ytoj, nmäl, _áfam, 
   {{0xe3ba1af8,0xe29a0432,0x045700fe,0xf1bf81d2}},	// [d20] уба_, гаа_, حلقة_, řád_, 
   {{0x6f040ee2,0xa9a60188,0x6f048407,0x248d9af9}},	//   _ivic, бизд, šick, hiem_, 
   {{0xfe370052,0x248d9afa,0xab270103,0x64a60162}},	//   _פרטי_, kiem_, _қора_, _гана, 
   {{0x248d834a,0x91fc80f3,0x17fa80fe,0x6f041afb}},	//   jiem_, nkār, اراة_, _kvic, 
   {{0x248d8029,0x76419afc,0x501b0c2d,0xb4c400a1}},	//   diem_, _baly, רונו, एगी_, 
   {{0x67229afd,0x1ae31afe,0xbea39aff,0xa3ab832d}},	//   rtoj, _хорм, пачк, _गड़_, 
   {{0x67228850,0x764181e2,0x261b1b00,0x394a0a1c}},	//   stoj, _daly, _बासी_, _urbs_, 
   {{0x248d9b01,0x64440ca7,0x7c361b02,0x6722816c}},	//   giem_, ndii, neyr, ptoj, 
   {{0xa3a89885,0x7cd181a8,0x76418050,0x645a0093}},	//   _खुश_, _pārr, _faly, êtiy, 
   {{0x9e658013,0xc3330039,0x76419b03,0x0665803d}},	//   _والن, לוח_, _galy, _والپ, 
   {{0xd011019c,0x6f029b04,0xa3a8854d,0x201900bc}},	//   ولد_, lsoc, _खुर_, tgsi_, 
   {{0xc19b0273,0x248d9b05,0x13b005a2,0x2db783f3}},	//   רשטי, ciem_, চেয়, _פלאן_, 
   {{0x61f89b06,0x61fe1b07,0x6444012c,0x5f941b08}},	//   _tevl, kapl, ddii, зият, 
   {{0x6f040265,0x64429b09,0x69dc9b0a,0x539b8309}},	//   _dvic, _haoi, žreb, _גידו, 
   {{0xe5c40086,0x90e69b0b,0x7c3601c2,0x61fe1b0c}},	//   зсто, _استن, feyr, dapl, 
   {{0x38b902c0,0xb4b3009b,0x644402b1,0x629c09b8}},	//   méro_, टते_, gdii, _ajro, 
   {{0x64429b0d,0x9b951b0e,0x5eb800b2,0xd9f91b0f}},	// [d30] _maoi, циац, _ইংরে, инац_, 
   {{0x7f4d1b10,0x61fe1b11,0x29011b12,0x51f81747}},	//   _iraq, gapl, tsha_, йную_, 
   {{0x6f04016c,0x200900bf,0x442b1b13,0xb05b019b}},	//   _zvic, _kdai_, _tbc_, ymäl, 
   {{0x6d400029,0x76419b14,0xdd00800d,0xdb0f1b15}},	//   āmat, _saly, štěn, _lycé, 
   {{0x3ced029f,0x248d9b16,0xa3a8810c,0x76418116}},	//   ćevu_, viem_, _खुल_, _paly, 
   {{0xf1c88bf5,0x9f590093,0x999e8068,0x248d8034}},	//   रधान, yasî_, hető_, wiem_, 
   {{0x248d8029,0x6cc59b17,0x9f40007f,0x76419b18}},	//   tiem_, ойка, _leið_, _valy, 
   {{0x13099b19,0x4429011a,0x64428336,0x26d30bdf}},	//   аний_, nfa_, _caoi, _lixo_, 
   {{0x6442803c,0x290a8068,0x248d9b16,0x76419b1a}},	//   _daoi, ában_, riem_, _taly, 
   {{0x248d8029,0x090580f0,0x2009004f,0x38bc8507}},	//   siem_, опон, _adai_, míra_, 
   {{0xdd9b8157,0x644410a3,0x6442806b,0x6f040f64}},	//   _сша_, ydii, _faoi, _svic, 
   {{0x43758e25,0xc5e90c2d,0x290b9b1b,0x64428c94}},	//   _мулт, _יד_, čca_, _gaoi, 
   {{0xe28e9b1c,0x99980284,0x44290324,0xdd1e81ac}},	//   _жа_, _marš_, dfa_, _víťa, 
   {{0x7c298ec4,0xacea0103,0x3e708064,0xa3e58587}},	//   lfer, имга_, _càth_, बुर_, 
   {{0x26d304e0,0x7aed0885,0x61fe0214,0xa3c18562}},	//   _dixo_, epat, vapl, ंधक_, 
   {{0x74161b1d,0x26d30bdf,0x13ea1b1e,0x6f0480e9}},	//   تورا, _eixo_, рмай_, šici, 
   {{0xe1fa1b1f,0x26d31b20,0x7aed10dc,0x7c36007f}},	// [d40] ига_, _fixo_, gpat, reyr, 
   {{0x44291b21,0x41b618ed,0xf221802a,0x63b687c5}},	//   afa_, осет, _माफ़_, _øyne, 
   {{0xda218e78,0x649780f3,0x27241b22,0x05a98d64}},	//   _मानत_, rģij, lön_, _चुलब, 
   {{0x5ee180cf,0x7c2980fa,0x61fe02d2,0x6f0282b9}},	//   _নিজে, jfer, sapl, tsoc, 
   {{0xee3a87e4,0xaf369b23,0xa6ca9b24,0xd00f819c}},	//   инд_, ترات, алда_, ئله_, 
   {{0x64428094,0x999e8019,0x6f029b04,0x7c2981ab}},	//   _saoi, zető_, rsoc, efer, 
   {{0x7c299b25,0x27241b26,0x7cd180f3,0x69231b27}},	//   ffer, hön_, _pārp, _омра, 
   {{0x61fc1b28,0x2c788908,0x61e910f1,0x9cca80ce}},	//   _herl, _béda_, _đeli, шыла_, 
   {{0x60dc1b29,0x7a3f8116,0x27241b2a,0x61fc1b2b}},	//   _hurm, kštė, jön_, _kerl, 
   {{0x60dc1b2c,0x026a80f0,0x61fc09da,0x5ee185a2}},	//   _kurm, рший_, _jerl, _নিচে, 
   {{0x44291b2d,0x3a3713b1,0x6442885e,0x8cd60102}},	//   yfa_, חרים_, _taoi, _मंगो, 
   {{0xab2a9b2e,0x26dc05c3,0x7c29811e,0x67240519}},	//   _вода_, _čvor_, cfer, _bqij, 
   {{0xd90e8a0e,0xa09b80c6,0xe29a84c7,0x7d1c937c}},	//   ریک_, שיכט, _кад_, _årsb, 
   {{0x29070019,0x25e601d2,0x63a282fe,0x61fc009a}},	//   ának_, जुली_, _ixon, _nerl, 
   {{0x7e689b2f,0x44291b30,0x60dc1b31,0xb05b0656}},	//   _modp, tfa_, _nurm, nmäk, 
   {{0xe598005a,0xd5b80e61,0xa01b1b32,0xe57180c6}},	//   ікті_, юся_, riös, ײַל_, 
   {{0x61fc1b33,0x44291b34,0xb2751b35,0x6d5a1b36}},	// [d50] _berl, rfa_, плаш, ätar, 
   {{0x44291b37,0x4eac80b2,0x656e0063,0x68e301e0}},	//   sfa_, গগুল, ínhá, índo, 
   {{0x60dc1b38,0x05a98562,0x38690a3e,0x442900bb}},	//   _curm, _चुंब, _koar_, pfa_, 
   {{0x7aed1b39,0x61fc0387,0x60dc1b3a,0x442902a1}},	//   ppat, _eerl, _durm, qfa_, 
   {{0x66c01900,0x61fc1b3b,0x76451b3c,0xdb078646}},	//   söke, _ferl, _kahy, ümüz, 
   {{0x0e64804a,0x61fc1b3d,0x3e79817c,0x9f5d847f}},	//   мкін, _gerl, _bèta_, nawé_, 
   {{0xc6940273,0x7c2982ae,0xf3ff03b8,0x61e500fe}},	//   ואס_, tfer, _joão_, mchl, 
   {{0x3201052a,0x629a9b3e,0x61e5043a,0xab659b3f}},	//   lahy_, ento, lchl, звил, 
   {{0x61fc1b40,0x5f94836a,0xa3ce010e,0x80d49855}},	//   _yerl, _житт, षेप_, _बूटे, 
   {{0x3201052a,0x61e51b41,0x764503df,0x628000ce}},	//   nahy_, nchl, _nahy, _įmok, 
   {{0x27e084e1,0x850580dd,0xa922877a,0x91fc80f3}},	//   žine_, _روشن, ндэл, rkāp, 
   {{0x7e688f6a,0x201d9b42,0x27240008,0x8fa61b43}},	//   _zodp, ngwi_, tön_, заме, 
   {{0x38690012,0xacaa811d,0xc31980cf,0x31b80549}},	//   _doar_, _اپنے_, _তৈরি_, _अर्ध, 
   {{0x27241b44,0x76451b45,0x9f5d8ce9,0x2b4f8269}},	//   rön_, _cahy, gawé_, _irgc_, 
   {{0x491283ce,0x320101cb,0xbea3014f,0xb6a308c6}},	//   _थियो_, dahy_, харк, хирл, 
   {{0x61fc1b46,0x442f8081,0x6d4180e5,0x3869068e}},	//   _serl, _jbg_, _msla, _goar_, 
   {{0x61fc1b47,0xd4671225,0x60dc1b48,0x20021b49}},	// [d60] _perl, чите_, _surm, maki_, 
   {{0x20021b4a,0x6d419589,0x320101cb,0x60dc1b4b}},	//   laki_, _osla, gahy_, _purm, 
   {{0xceb31b4c,0x61fc050a,0x29059b4d,0xd5b00068}},	//   _איז_, _verl, nsla_, _شہر_, 
   {{0x64a604bc,0x38cb842b,0xc6048562,0xdca604bc}},	//   _хама, مانی_, रण्य_, _хами, 
   {{0x61fc1b4e,0xe81f0073,0x6d419b4f,0x60dc1b50}},	//   _terl, _भासा_, _asla, _wurm, 
   {{0x60dc1b51,0x442f9b52,0x29078183,0xd6d980f0}},	//   _turm, _abg_, _ovna_, іті_, 
   {{0xdb078a93,0x628e1b53,0x20020883,0xe9a31b54}},	//   _člán, _imbo, kaki_, _зарп, 
   {{0x64461b55,0x20021b56,0x2cad83c5,0x399b0039}},	//   _jaki, jaki_, goed_, _הילד, 
   {{0x200207fa,0x6b841b57,0x64461b58,0x98a38123}},	//   daki_, nzig, _maki, _чите, 
   {{0x64461b59,0x2a6a1b5a,0xb05b036d,0x27e69b5b}},	//   _laki, _jobb_, mmäi, lcon_, 
   {{0x2bb90561,0xa6e98028,0x2497807b,0xbbb9150f}},	//   _आर्थ, _chươ, _کنند_, _आर्क, 
   {{0x64461b5c,0x442f8341,0x20021b5d,0x63a20034}},	//   _naki, _gbg_, gaki_, żony, 
   {{0x6b840a44,0x60c400f8,0x628e1b5e,0x2480016c}},	//   jzig, _dhim, _ombo, dhim_, 
   {{0x291a1b5f,0x2c7181d2,0x64461b60,0x44220a6c}},	//   kupa_, _rádi_, _aaki, _ack_, 
   {{0x64461b61,0x20021b62,0x7647006d,0xa2c00b45}},	//   _baki, baki_, rdjy, वतन्, 
   {{0x628e0c46,0x64461b63,0x30a401e2,0x9f5d81b2}},	//   _ambo, _caki, _прыв, dawî_, 
   {{0x64461b64,0x3f9e0214,0x4e1c801b,0x32011b65}},	// [d70] _daki, ştur_, नलाई_, tahy_, 
   {{0x291a1b66,0x6d4101c2,0x78af1b67,0x8c3d9b68}},	//   fupa_, ælas, locv, roşi, 
   {{0x7c229b69,0x29071b6a,0x2509003d,0x4422006d}},	//   _ocor, éna_, _برخی_, _fck_, 
   {{0x61e5035b,0x386987e9,0xdfd180fe,0x32011865}},	//   schl, ðar_, نيا_, sahy_, 
   {{0x7c2d1b6b,0x64978166,0x36699b6c,0x2cad8f89}},	//   mfar, nţie, жало_, voed_, 
   {{0x55c3805a,0x442f9b6d,0x443b00bf,0xed599b6e}},	//   налғ, _sbg_, leq_, жок_, 
   {{0xa9341b6f,0x2002033f,0x291a1b70,0xdd918019}},	//   _перш, yaki_, cupa_, کوں_, 
   {{0xe81f1b71,0x7c2d1b72,0x14bf0cca,0x50678004}},	//   _भाषा_, nfar, ्षिण, _этга, 
   {{0x200d9b73,0x20021b74,0x1c429b75,0xddd4808d}},	//   _idei_, vaki_, тным, čaši, 
   {{0x60c41b76,0xa6e98028,0x20021b77,0x27ff82ef}},	//   _shim, _phươ, waki_, _heun_, 
   {{0x19c59b78,0x20021b79,0xa0a6028a,0x389600f3}},	//   ьбом, taki_, данд, kārt_, 
   {{0x66039b7a,0x1620023b,0x60d61b7b,0x7d1c8255}},	//   lank, _बाहर_, _qiym, _årsa, 
   {{0xeaae9b7c,0x64461b7d,0xb9048ab2,0x2002084c}},	//   _ай_, _raki, _भू_, raki_, 
   {{0x64461b7e,0x442d835b,0xa6e9810b,0x7c3b9b7f}},	//   _saki, lfe_, _thươ, leur, 
   {{0xceb281dc,0x20021b80,0x6d580183,0x60c41b81}},	//   דים_, paki_, _švab, _thim, 
   {{0x64499b82,0x6b840bcb,0x442d9b83,0x7c2d1b84}},	//   ndei, tzig, nfe_, gfar, 
   {{0x64461b85,0x232702d4,0x64978123,0x3e7402f4}},	// [d80] _vaki, моти_, cţie, _läti_, 
   {{0x644600fd,0x24801b86,0xfbc30325,0x200d80bf}},	//   _waki, shim_, тбуо, _adei_, 
   {{0x64461b87,0x66039b88,0x7c3b9b89,0x6f098217}},	//   _taki, dank, keur, _avec, 
   {{0x291a1b8a,0x7d1c1b8b,0x22479b8c,0x7c2d1b8d}},	//   rupa_, murs, _lank_, cfar, 
   {{0x9c7c84b1,0x7c3b9b8e,0x073a940d,0xc6f788cf}},	//   _juče, deur, تساب_, дніх_, 
   {{0x44201b8f,0x628e1b90,0x26c59086,0x66039b91}},	//   lgi_, _umbo, _chlo_, gank, 
   {{0x442d9b92,0x69dc0569,0x7c3b9b93,0xe81f0587}},	//   ffe_, _igre, feur, _भाला_, 
   {{0x3ae400f9,0x6e3c1b94,0x27ff9b95,0x6d338a09}},	//   _köp_, herb, _geun_, теъф, 
   {{0x44201b96,0xcf469b97,0x22479b98,0x7ae20a5e}},	//   igi_, _юнай, _bank_, íoth, 
   {{0x660397a2,0x64499422,0x22478e0b,0x38668341}},	//   cank, adei, _cank_, ljor_, 
   {{0x7c3b9b99,0x22479b9a,0x765a9b9b,0x021704fc}},	//   beur, _dank_, _inty, וחים_, 
   {{0x7d1c1b9c,0xb4d805c9,0x7c3b9b9d,0x1c1d0f2c}},	//   durs, ादो_, ceur, _फाइल_, 
   {{0x69dc1b9e,0x3f869b9f,0x6e3c1ba0,0x22478a63}},	//   _ogre, nzou_, ferb, _fank_, 
   {{0xf98f9ad1,0x62819ba1,0x64830073,0x69dc1ba2}},	//   ابی_, chlo, _kõig, _ngre, 
   {{0x76489ba3,0xf1aa803d,0x7d1c1ba4,0xc3488106}},	//   _mady, _باشه_, gurs, _hổ_, 
   {{0x44201ba5,0x261b15ef,0x66039ba6,0x69dc1ba7}},	//   ggi_, _बाकी_, zank, _agre, 
   {{0x3ec71ba8,0x66c000f9,0x66038889,0x439404d9}},	// [d90] _особ, söka, yank, ватс, 
   {{0x27ff81b0,0x76489ba9,0x68fc011a,0x7a381baa}},	//   _seun_, _nady, _bwrd, мпур_, 
   {{0x6f1d0065,0x30159bab,0x332901bb,0x48159bac}},	//   lusc, едер, stax_, емес, 
   {{0x6d451bad,0x66039bae,0x765a9baf,0x8c3d8123}},	//   _isha, wank, _anty, noşt, 
   {{0xa3b6092c,0xb4bd00a1,0x76489bb0,0xc3488106}},	//   _चुप_, ेगी_, _bady, _nổ_, 
   {{0x68fc043a,0x171c03f3,0x64598097,0x00000000}},	//   _fwrd, קווע, _snwi, --, 
   {{0x7ce787fa,0x7c3b9bb1,0x7bc29bb2,0x3f86811e}},	//   _bıra, teur, _azou, azou_, 
   {{0x93459bb3,0x6603837a,0xc348801c,0x61ea9bb4}},	//   ение, sank, _bổ_, _affl, 
   {{0xc3488028,0x442d9bb5,0x6f098259,0x7c3b9bb6}},	//   _cổ_, rfe_, _uvec, reur, 
   {{0x7c3b9bb7,0x272982ba,0x44201bb8,0x66038fde}},	//   seur, mún_, zgi_, qank, 
   {{0x8bd980b6,0xa3b601d1,0x02db09fe,0x7c3b8404}},	//   _емес_, _चुन_, बदुन, peur, 
   {{0x386d8217,0x6e3c1bb9,0x62818004,0x66019bba}},	//   _joer_, werb, shlo, _helk, 
   {{0x66019bbb,0x6d451bbc,0x44201bbd,0xda0f009b}},	//   _kelk, _asha, vgi_, ाणात_, 
   {{0x7d1c14d7,0x9c7c99ff,0x386d86a4,0xb4d81bbe}},	//   turs, _vuče, _loer_, ाद्_, 
   {{0x387f82bc,0x6da31bbf,0x66019bc0,0x7afd177f}},	//   _olur_, гира, _melk, _awst, 
   {{0x69c3803a,0x249f812b,0x6e3c1bc1,0x04431bc2}},	//   _izne, nnum_, serb, лесн, 
   {{0x6d451bc3,0xc3488106,0x249f81c2,0x22161bc4}},	// [da0] _esha, _xổ_, inum_, ефер, 
   {{0x6d4500f8,0x387f9bc5,0x32059bc6,0x44201bc7}},	//   _fsha, _alur_, naly_, sgi_, 
   {{0x76489bc8,0x387f9bc9,0x386d9bca,0x7cd180f3}},	//   _rady, _blur_, _boer_, _dārz, 
   {{0xd7068782,0x5f069bcb,0x7648820e,0xfbc78275}},	//   езди, езда, _sady, _مت_, 
   {{0x08e68a87,0x27298422,0x61368068,0x66019bcc}},	//   _কিছু_, gún_, _külö, _belk, 
   {{0x66018a93,0xdd948ceb,0x7ce782bc,0x3f868065}},	//   _celk, калы, _sıra, rzou_, 
   {{0xc348801c,0x44fe001b,0x2ca01bcd,0xfaa31bce}},	//   _sổ_, nů_, onid_, _саро, 
   {{0x249f807f,0x54549bcf,0x26da1bd0,0xf8ca0106}},	//   gnum_, твит, _lipo_, _tẩy_, 
   {{0xb05b0172,0xc7a39bd1,0x66019bd2,0x764880ed}},	//   lläg, _битк, _felk, _tady, 
   {{0xdee39bd3,0xd90e8c0b,0x2c7c0530,0x3205840a}},	//   _софи, میت_, _oído_, galy_, 
   {{0x2d878d99,0xb05b00f9,0x44fe001b,0x2b9100e9}},	//   czne_, nläg, jů_, môcť_, 
   {{0xc3488028,0x44fe001b,0x6fd68a08,0xbebb016c}},	//   _tổ_, dů_, _gücü, ntëv, 
   {{0x44269bd4,0xb05b01ed,0xfebb00d8,0x98741bd5}},	//   _ico_, hläg, كاست_, уляц, 
   {{0x66c00172,0x6f1d1bd6,0xa01b01ab,0xe667004c}},	//   sökn, rusc, chön, хтмо, 
   {{0x555813b7,0xb6060269,0x26da1bd7,0xac951bd8}},	//   наря_, dušč, _dipo_, вавш, 
   {{0xdcb80574,0x6f1d1642,0xb05b0341,0xf9698764}},	//   ещу_, pusc, dläg, _юрій_, 
   {{0x64978123,0x61fb0269,0x386d800b,0x4814019b}},	// [db0] nţia, _đulb, _roer_, _смыс, 
   {{0x979c004d,0x6d451123,0x64830073,0x7ae28008}},	//   _משחק, _tsha, _sõid, _muot, 
   {{0x291e81de,0x3b0902a1,0x6d451bd9,0xf1a71647}},	//   nuta_, ssaq_, _usha, хран, 
   {{0x442681ea,0x6f0d0183,0x66018008,0x2054804a}},	//   _nco_, _kvac, _selk, лтір, 
   {{0x54541bda,0x7ae281e2,0xf7458b3d,0x291e832e}},	//   _свят, _nuot, тело, huta_, 
   {{0x291e9bdb,0x66071bdc,0x27299bdd,0x644d1bde}},	//   kuta_, najk, rún_, ldai, 
   {{0x4c6984da,0x66019bdf,0xd65802f9,0x32059be0}},	//   дийн_, _velk, תיות_, valy_, 
   {{0x66019be1,0x6f0d0524,0x291e9be2,0x3e7407b2}},	//   _welk, _ovac, duta_, _hätt_, 
   {{0x7ae280b2,0x249f807f,0x32059be3,0x5ba9829d}},	//   _cuot, rnum_, taly_, ьким_, 
   {{0x291e9be4,0x644d0015,0xc3320039,0x7ae28162}},	//   futa_, hdai, סוי_, _duot, 
   {{0x3205965d,0x60c99be5,0xb05b1be6,0x645d1be7}},	//   raly_, _khem, kläd, _onsi, 
   {{0xc5f5005a,0x3e7400f9,0xdee61be8,0x26da1be9}},	//   ңғы_, _lätt_, коми, _sipo_, 
   {{0x26da1bea,0x443f9539,0x6ec58b45,0x80cb80b2}},	//   _pipo_, meu_, ितपु, িদপ্, 
   {{0x6da61beb,0x443f9bec,0x644b9bed,0x09e28cc5}},	//   вига, leu_, _hagi, _кошн, 
   {{0xceb28fcc,0x291e802d,0x644b9bee,0x6f0d1bef}},	//   ייך_, cuta_, _kagi, _evac, 
   {{0x443f9bf0,0x64a30692,0x44fe001b,0x7f8600fe}},	//   neu_, ааса, rů_, _للبن, 
   {{0x644b9bf1,0x68e39bf2,0x44fe001b,0x443f9bf3}},	// [dc0] _magi, _hund, sů_, ieu_, 
   {{0x644b9bf4,0x644d1b0d,0x443f9bf5,0xaa7b01c2}},	//   _lagi, adai, heu_, _stýr, 
   {{0x44e70106,0x443f83df,0x9c7c8bbe,0x68e38da7}},	//   _gõ_, keu_, _luča, _jund, 
   {{0x644b9bf6,0x60db9bf7,0x63a4807f,0xb05b1bf8}},	//   _nagi, _cium, _þing, rläg, 
   {{0x443f9bf9,0x68e39bfa,0x16160bc4,0x60db9bfb}},	//   deu_, _lund, _तयार_, _dium, 
   {{0x7bc60ecf,0x7ae28e79,0x7c241bfc,0xca76167f}},	//   _izku, _ruot, lgir, _румы, 
   {{0x644b9bfd,0x92de80cf,0xc5d580cf,0x60db8086}},	//   _bagi, _তবে_, _স্বপ, _fium, 
   {{0x7c241bfe,0x291e9bff,0x38c88f2a,0x443f80a6}},	//   ngir, vuta_, _سازی_, geu_, 
   {{0x7ae29c00,0xb05b1c01,0x39478a63,0xdee682bb}},	//   _quot, kmär, _asns_, _рози, 
   {{0x7ae29c02,0x291e80b4,0x68e38b41,0x3a279c03}},	//   _vuot, tuta_, _bund, _ccnp_, 
   {{0x20048210,0x443f9c04,0x68e39c05,0x7c240093}},	//   _kemi_, beu_, _cund, kgir, 
   {{0x7ae2825b,0x443f9c06,0x291e9c07,0x200480f8}},	//   _tuot, ceu_, ruta_, _jemi_, 
   {{0xda34925e,0x6b898066,0x291e9c08,0x68e3828b}},	//   _белы, czeg, suta_, _eund, 
   {{0x64409c09,0x27e000b4,0xd9548275,0x68e38ee3}},	//   lemi, _egin_, _منتخ, _fund, 
   {{0x3e7408b4,0x660700d7,0xdd94075d,0x644b9c0a}},	//   _rätt_, rajk, аары, _yagi, 
   {{0x64409c0b,0x3e7408b4,0x7c241c0c,0x44e7001c}},	//   nemi, _sätt_, ggir, _võ_, 
   {{0x4ea71c0d,0xe3741c0e,0x644d1c0f,0x5a351c10}},	// [dd0] _арна, алты, rdai, лнат, 
   {{0x60c99c11,0x443f9c12,0xf8bf1c13,0x64409c14}},	//   _shem, zeu_, llé_, hemi, 
   {{0x39151c15,0x60db9c16,0x7bc60122,0x6b899c17}},	//   умер, _pium, _ezku, zzeg, 
   {{0x2bae1379,0x443f875d,0x33200741,0x645d1c18}},	//   _झुका, xeu_, buix_, _unsi, 
   {{0x644b9c19,0x443f9c1a,0x20049c1b,0x60db804f}},	//   _ragi, veu_, _demi_, _vium, 
   {{0x644b9c1c,0x9c7c805d,0xe5a59c1d,0x6da59c1e}},	//   _sagi, _ruča, лили, лила, 
   {{0x644b9c1f,0x443f9c20,0x60c99c21,0x66051c22}},	//   _pagi, teu_, _them, _mehk, 
   {{0x64409c23,0x68e38d75,0x69c713ea,0x332d8208}},	//   gemi, _rund, _izje, ttex_, 
   {{0x68e39c24,0x443f9c25,0x1fb88a48,0x2cb900db}},	//   _sund, reu_, _алты_, _mksd_, 
   {{0x68e39c26,0x443f9c27,0x2bc695e6,0x7c241c28}},	//   _pund, seu_, ылып_, zgir, 
   {{0x644b9c29,0xab5b0068,0xe4e7836a,0x6b899c2a}},	//   _tagi, _szül, _різн, szeg, 
   {{0x9b458275,0xa3559367,0x68e389b4,0x672d037f}},	//   _منصو, _مختص, _vund, _bqaj, 
   {{0x9cd68039,0xbebb00f8,0xed5704bc,0x68e39c2b}},	//   _עונה_, jtës, қот_, _wund, 
   {{0x68e39c2c,0xdee31c2d,0x78a29c2e,0x539a83dd}},	//   _tund, сори, znov, _אינו, 
   {{0x78a29c2f,0x9c7c8533,0x64978123,0x7c241c30}},	//   ynov, _mučn, nţio, tgir, 
   {{0xb05b0079,0x212109fb,0xdd8f00d8,0x672d0199}},	//   smär, duhh_, سوق_, _fqaj, 
   {{0x7c24024a,0x7413007b,0xb05b0172,0x78a29c31}},	// [de0] rgir, صولا, pmär, vnov, 
   {{0xdee68fbe,0x7c241c32,0xddb61652,0x64409c33}},	//   ҳоди, sgir, _محجب, zemi, 
   {{0x64409c34,0x7a7a80c6,0x7f49833b,0x7c2409b2}},	//   yemi, ערעס, _aseq, pgir, 
   {{0xe3a7807b,0xd70a8bb3,0xdee68826,0x64408093}},	//   _هر_, енде_, годи, xemi, 
   {{0xb8eb05b1,0x78a29c35,0x2bba00fe,0x9c7c8121}},	//   _री_, rnov, _ساحة_, _bučn, 
   {{0x91e31c36,0x09e30675,0x7d1c9c37,0x52751c38}},	//   _горе, _горн, _årsk, _кусу, 
   {{0x644087fa,0xafdb072c,0x20f30269,0x3a2a0265}},	//   temi, ndør, _aćif_, _icbp_, 
   {{0x64978123,0x78a28170,0x5b149c39,0x3ae9812f}},	//   sţin, čovs, амит, _búp_, 
   {{0x6d580e02,0xb5fc808b,0x3ae9812f,0x543b03f3}},	//   _šval, _anġe, _cúp_, געפא, 
   {{0x7ae61c3a,0xfce69c3b,0x86c680d8,0x67228162}},	//   _mukt, _божо, _صيان, muoj, 
   {{0x27e98bfc,0x64409c3c,0x3cf800e9,0x64978123}},	//   žane_, pemi, jprv_, cţio, 
   {{0xf99304fc,0x64978123,0x81d600b2,0x1fdf0353}},	//   מרת_, nţil, _সভা_, नखेड, 
   {{0x67228116,0x44ea9c3d,0xf4878068,0x26de9c3e}},	//   nuoj, _hù_, _حالی, _kito_, 
   {{0x81d49c3f,0xc7b382f9,0x660a8645,0xe45f010d}},	//   _колх, מבר_, nafk, _snö_, 
   {{0x629a9c40,0x7ae61c41,0x6ca71c42,0xf8bf1c43}},	//   mito, _aukt, граж, plé_, 
   {{0x7ae61c44,0x26de9c45,0x1f750a43,0x660501f0}},	//   _bukt, _lito_, _влия, _wehk, 
   {{0x4bc5075d,0x3a3813c6,0x26de8569,0x3a2a008d}},	// [df0] рөнг, _bbrp_, _oito_, _bcbp_, 
   {{0x44ea83e9,0x1959125e,0x26de9950,0x7ae61c46}},	//   _où_, казы_, _nito_, _dukt, 
   {{0x60cd1c47,0x9c7c9c48,0x81b680b2,0xbebb09b8}},	//   _kham, _ručn, চের_, stës, 
   {{0xb4fa0273,0x89340013,0xa565803d,0x629a9c49}},	//   _שפרי, إعلا, یگان, hito, 
   {{0xde059c4a,0x629a9c4b,0x24891c4c,0xe75887c5}},	//   апли, kito, mham_, лиці_, 
   {{0x644f1c4d,0x629a9c4e,0x87048008,0x24891c4f}},	//   _haci, jito, сяце, lham_, 
   {{0x26de82b7,0x644f1c50,0x44ea9c51,0x6f1d01ed}},	//   _dito_, _kaci, _cù_, hrsc, 
   {{0x644f1c52,0xaf34919c,0x24891c53,0x44ea8028}},	//   _jaci, _گرفت, nham_, _dù_, 
   {{0x644f1c54,0x200b003a,0x9c7c9c55,0x6b8d1c56}},	//   _maci, daci_, _tučn, nzag, 
   {{0x644f1c57,0x65959c58,0x68e700f8,0x26de8579}},	//   _laci, _казу, _kujd, _gito_, 
   {{0xf8661c59,0x76439c5a,0x44391c5b,0x3da79c5c}},	//   авно, meny, _obs_, _сраб, 
   {{0x76439c5d,0x44391c5e,0x60cd1c5f,0x442b1c60}},	//   leny, _nbs_, _cham, _ncc_, 
   {{0x60cd1c61,0x24891c62,0x6b8d0183,0xdee61c63}},	//   _dham, dham_, jzag, роги, 
   {{0x78a985a7,0x44391c64,0x96200034,0x76438371}},	//   _ljev, _abs_, बलेट_, neny, 
   {{0x200b0053,0x75239c65,0xf4961c66,0x78bb8ca7}},	//   baci_, nunz, араю, _okuv, 
   {{0x3d0880d5,0x44391c67,0x76439c68,0x24891c69}},	//   _सबसे_, _cbs_, heny, gham_, 
   {{0x44390122,0x644f1c6a,0x02060286,0x76439c6b}},	// [e00] _dbs_, _daci, изан, keny, 
   {{0xe1f700c4,0x442b009f,0x752380bb,0x61e380f6}},	//   игу_, _ecc_, kunz, _jgnl, 
   {{0x2bb8010c,0x26de8318,0x764399e0,0x644f1c6c}},	//   _आडवा, _rito_, deny, _faci, 
   {{0x26de8574,0x62888210,0x629a9c6d,0x60cd1c6e}},	//   _sito_, zhdo, zito, _xham, 
   {{0x78a98301,0x26de9c6f,0x629a9c70,0x87039c71}},	//   _djev, _pito_, yito, ояще, 
   {{0x75239c72,0x629a9c73,0x76439c74,0x67228116}},	//   funz, xito, geny, ruoj, 
   {{0x6d581c75,0x629a9c76,0x321880a1,0x443902fa}},	//   _švaj, vito, órym_, _ybs_, 
   {{0xc0e31c77,0x7c3607a2,0x26de804f,0x644f03b9}},	//   _фотк, nfyr, _wito_, _xaci, 
   {{0x8aa69c78,0x629a9c79,0x26de9c7a,0x76439c7b}},	//   ирод, tito, _tito_, beny, 
   {{0x32078fb9,0xab5b0068,0xc3330c2d,0x200b0108}},	//   _ceny_, _szük, קות_, waci_, 
   {{0x2d968ded,0xa3d8007a,0x60cd1c7c,0x68e09757}},	//   _трас, ाधड_, _pham, _kimd, 
   {{0x629a9c7d,0x859b8309,0x5faa8076,0x6f0401d7}},	//   sito, _בשבו, _कशाल, _bwic, 
   {{0xc7c71c7e,0x4fc70d29,0xfaa6804c,0x32079c7f}},	//   рсни, рсна, _кадо, _feny_, 
   {{0x60c283ec,0x200b0bbe,0x6f1d1c80,0x6d5a8f97}},	//   hlom, saci_, rrsc, _krta, 
   {{0xa3ea8560,0x241901bc,0x705904da,0x60cd1c81}},	//   _मला_, ловы_, _байр_, _tham, 
   {{0x6d5a805d,0x320c90c6,0x60cd0e1f,0x3d18103a}},	//   _mrta, lady_, _uham, _फिरे_, 
   {{0x644f1c82,0x22840172,0x2486827e,0xa3ca809b}},	// [e10] _vaci, _söka_, _mlom_, ळेच_, 
   {{0x6d5a82bc,0x78a99287,0x78bb942b,0x6286816c}},	//   _orta, _sjev, _skuv, ëkoh, 
   {{0x78a984b1,0xbebb00f8,0x99671c83,0x27e482fa}},	//   _pjev, rrëd, штал, _bgmn_, 
   {{0x320c852a,0x76439c84,0x60c29c85,0x442b1c86}},	//   hady_, weny, glom, _ucc_, 
   {{0x44291c87,0x320c9c88,0x6d5a8dc1,0xfd4c8106}},	//   mga_, kady_, _arta, _thiể, 
   {{0x44291c89,0x75239c8a,0x6d5a80e5,0x528500fe}},	//   lga_, tunz, _brta, _السك, 
   {{0x6d5a805d,0x76439c8b,0x44291c8c,0x518419a6}},	//   _crta, reny, oga_, _дута, 
   {{0x44291c8d,0x76439c8e,0x68e08116,0x78bb80bb}},	//   nga_, seny, _gimd, _ukuv, 
   {{0x291e85cb,0x6d5a9c8f,0x75239c90,0x6d5c9c91}},	//   erta_, _erta, sunz, _áran, 
   {{0xf67480fe,0x6d5a8269,0x44290103,0x752380bb}},	//   _والخ, _frta, hga_, punz, 
   {{0xd9459c92,0xb4e60787,0x44290504,0xd00a1c93}},	//   щени, _पढे_, kga_, лене_, 
   {{0x3eb802ae,0xb7bd802d,0x44291c94,0x20090166}},	//   wort_, _acţi, jga_, _ceai_, 
   {{0xd12e8f2a,0x32078573,0x42d580f0,0x44290103}},	//   ومی_, _teny_, _ліку, dga_, 
   {{0x201e1c95,0x44291c96,0x20090097,0x24869c97}},	//   şti_, ega_, _eeai_, _zlom_, 
   {{0xe8f59c98,0x291e8284,0x66e60a09,0x22459c99}},	//   _استخ, crta_, роҳа, melk_, 
   {{0x44291c9a,0x27e087ad,0xb05b1c9b,0xdb23807f}},	//   gga_, žini_, llän, _þróu, 
   {{0xf8b31c9c,0x3eb81c9d,0x24801c9e,0x7c361c9f}},	// [e20] _משה_, port_, rkim_, rfyr, 
   {{0x03a60974,0x34d380a1,0xb05b16c1,0xa96a1ca0}},	//   _ҳимо, दगुद, nlän, лиза_, 
   {{0x6608807e,0x44290103,0x7afb80db,0xc6930039}},	//   _redk, bga_, hput, _מאז_, 
   {{0x53a61ca1,0x660e0103,0x0aea00d8,0x7c299ca2}},	//   _гамб, labk, _مرسي_, jger, 
   {{0x60c28160,0x68fb1ca3,0xb05b0341,0x8c46808a}},	//   rlom, _čude, klän, qişə, 
   {{0x44ee010b,0xfd650028,0xacf89ca4,0x6d5a80db}},	//   _ký_, _nguồ, анку_, _prta, 
   {{0x9986030b,0x27e9803b,0xb05b0172,0x320c80de}},	//   _الأو, žana_, dlän, vady_, 
   {{0x7c299ca5,0x629e1ca6,0x6d5a9ca7,0xa2f49ca8}},	//   gger, lipo, _vrta, опич, 
   {{0x44ee010b,0xeaf7807b,0x320c852a,0xc445803d}},	//   _lý_, یریت_, tady_, زیون_, 
   {{0x44291ca9,0x27328123,0x39149caa,0x33770039}},	//   zga_, mân_, омор, צעים_, 
   {{0x44291cab,0x27329cac,0x6d5a9cad,0x44ee007f}},	//   yga_, lân_, _urta, _ný_, 
   {{0x320c9cae,0x629e1caf,0x9c7c811b,0x629d8035}},	//   sady_, hipo, _mučk, ésor, 
   {{0x629e1cb0,0x320c9cb1,0x44291cb2,0x9c7c882b}},	//   kipo, pady_, vga_, _lučk, 
   {{0x44291cb3,0x62819cb4,0x249900bf,0xacf91cb5}},	//   wga_, cklo, _smsm_, ингу_, 
   {{0x40351cb6,0x44290004,0x787f00f8,0x629e1cb7}},	//   _дейс, tga_, _lëvi, dipo, 
   {{0x44291cb8,0xce33007b,0xa0a400b0,0xcd0280a1}},	//   uga_, _کودک, _најд, mość_, 
   {{0x44291cb9,0x660e1cba,0x320a1cbb,0x3a751cbc}},	// [e30] rga_, babk, _beby_, олар, 
   {{0x9e071cbd,0x2eb40079,0x7c299cbe,0x5b7b80c6}},	//   _учил, ंकृत, zger, ארמא, 
   {{0xcd0280a1,0x320a068e,0x9c7c8533,0x44290457}},	//   ność_, _deby_, _vučj, pga_, 
   {{0x50c9010e,0xf8c90bf5,0x657a152c,0xed8800a6}},	//   रतिष, रतिय, äthe, _ысык_, 
   {{0x7c29824a,0x320a00db,0x2ca91cbf,0x7aed03ad}},	//   vger, _feby_, mnad_, qqat, 
   {{0x45199cc0,0xcd0280a1,0xee3880f0,0x9c7c80ca}},	//   ация_, kość_, йні_, _fučk, 
   {{0x20c9009b,0x7bc29cc1,0x8c478610,0x64830587}},	//   रताध, _ayou, _noşî, _lõim, 
   {{0xa2b90a42,0x2ca90079,0x23608265,0x7c29875d}},	//   ्तव्, nnad_, _šija_, uger, 
   {{0x2d8c161e,0xb05b152c,0x200f9cc2,0xf09f075d}},	//   údez_, tlän, magi_, dià_, 
   {{0x200f9cc3,0x7afb9cc4,0x7c299cc5,0x78ad07d7}},	//   lagi_, rput, sger, _ajav, 
   {{0xe046098b,0x68461cc6,0xb05b1cc7,0x62819cc8}},	//   онни, онна, rlän, rklo, 
   {{0x660e1cc9,0x6d419cca,0x61fc8a08,0x200f8079}},	//   wabk, _ipla, ırla, nagi_, 
   {{0x61c6024c,0x3b099ccb,0xc1c6024c,0x78ad0e02}},	//   _वर्ष, _тело_, _वर्ग, _djav, 
   {{0x200f9950,0x96ba06bf,0x7c2f1ccc,0x3f8c0034}},	//   hagi_, руму_, _accr, ądu_, 
   {{0xa50a0b29,0x649a1ccd,0x7ae380ed,0x200f9cce}},	//   реба_, атар_, _iint, kagi_, 
   {{0x90c31ccf,0x9c7c8533,0x660e1cd0,0x248d9cd1}},	//   _обще, _ručk, sabk, nhem_, 
   {{0x200f9cd2,0x7ae39cd3,0xab2a1cd4,0x8c3d8816}},	// [e40] dagi_, _kint, роза_, mişd, 
   {{0x7ae38208,0x6d419cd5,0x9c7c9cd6,0x21a604ab}},	//   _jint, _opla, _pučk, оизм, 
   {{0x6d41806c,0x4fea9cd7,0xdb06010d,0x249f9cd8}},	//   _npla, амен_, _nykö, kium_, 
   {{0x7ae39cd9,0x629e1cda,0x69c38324,0x442f83b9}},	//   _lint, sipo, _myne, _ncg_, 
   {{0xa2cb06df,0x7ae39cdb,0x052680b2,0x249f9cdc}},	//   _तीव्, _oint, _মনের_, dium_, 
   {{0x7ae39cdd,0x0576846d,0x63a481e2,0xddc18bfc}},	//   _nint, قاعد, _žino, _dolž, 
   {{0xa2b900c3,0x200f982d,0x443d9cde,0x442f8399}},	//   ्तर्, bagi_, _bbw_, _bcg_, 
   {{0x69ce1cdf,0x6d5c9ce0,0x68e40e53,0x7aeb9ce1}},	//   _izbe, _áram, _niid, _bugt, 
   {{0x0a6a8daa,0xcd0280a1,0x3ea69ce2,0xc4d30039}},	//   арни_, wość_, _диаг, וגה_, 
   {{0x7ae384c4,0x539b0c2d,0x34a7092c,0xd90e87f1}},	//   _cint, ייפו, _गद्द, نیت_, 
   {{0x7ae39ce3,0x9c7c843e,0x2b4200bf,0xe3af8184}},	//   _dint, _luči, _lpkc_, فری_, 
   {{0x7ae39ce4,0x248d9ce5,0x57f41ce6,0x27e0805d}},	//   _eint, chem_, мпют, žinu_, 
   {{0x98b38533,0x68e41ce7,0x629c1ce8,0x2ca009ec}},	//   žeća_, _diid, _omro, diid_, 
   {{0x64830689,0x7d1c9ce9,0x6d5e00db,0x7ae39cea}},	//   _võim, _årss, _brpa, _gint, 
   {{0x2d85027b,0x66cd81ac,0x29119ceb,0xb05b1cec}},	//   ále_, núka, ázat_, lläm, 
   {{0xd7fb0574,0x7ae39ced,0x51848a09,0xbca500d8}},	//   _тук_, _zint, _муқа, أمري, 
   {{0x2d850284,0x5334005a,0x7de7005a,0x6d5e02b1}},	// [e50] šle_, метт, _мінд, _erpa, 
   {{0xe7f9007a,0x64830073,0x249f9cee,0xa3e70de3}},	//   ंडवा_, _kõik, zium_, _पलक_, 
   {{0x984b9b24,0x7583004e,0xdcef01a8,0x2ca91cef}},	//   ияда_, _غیرم, ēdēt, pnad_, 
   {{0x92ab00cf,0x27e900e5,0xa2cb0b30,0x66c0010d}},	//   খতে_, _jgan_, _तीर्, sökt, 
   {{0x69ce1cf0,0x64830079,0xae1f12b9,0x200f9cf1}},	//   _ezbe, _lõik, _बयान_, ragi_, 
   {{0x27e90daa,0xe7e3150f,0x200f9cf2,0x442f9cf3}},	//   _lgan_, _गणना_, sagi_, _scg_, 
   {{0x7ae39cf4,0x442f811e,0x8c3d9341,0x200f812c}},	//   _rint, _pcg_, yişd, pagi_, 
   {{0x67228025,0x27e91cf5,0x69c38034,0x8c3d82d2}},	//   broj, _ngan_, _ryne, kişe, 
   {{0x69c386de,0x248d9cf6,0xed57804a,0x68e41998}},	//   _syne, rhem_, соқ_, _riid, 
   {{0x27e90365,0x62850232,0x248d80f8,0x68e41cf7}},	//   _agan_, nkho, shem_, _siid, 
   {{0x63ad9cf8,0x7c2d1cf9,0x648e8097,0x62851cfa}},	//   _žand, kgar, _bùid, ikho, 
   {{0x2eb60dcf,0x628a8019,0xdb0f01b4,0x7aeb9cfb}},	//   ृत्त, _elfo, _excé, _tugt, 
   {{0xe28e8aff,0x44f180b0,0x6d5e17fc,0x68e4041a}},	//   _за_, _há_, _srpa, _viid, 
   {{0x442d856e,0x7c2d1cfc,0x7c3b9cfd,0x332900db}},	//   lge_, egar, lfur, duax_, 
   {{0x44f19cfe,0x2ca002fe,0xf4840184,0x68e41cff}},	//   _já_, tiid_, واری, _tiid, 
   {{0x7c2d1d00,0x7c3b9d01,0x768f87c5,0xb5fc8519}},	//   ggar, nfur, _høyd, _anġl, 
   {{0x44f19d02,0x442d9d03,0x20d200fe,0x2ca002f4}},	// [e60] _lá_, ige_, ráid_, riid_, 
   {{0x9c7c90f3,0x7c2d0c9f,0x394302fa,0x20d200d8}},	//   _vuči, agar, _bpjs_, sáid_, 
   {{0x44f19d04,0xd7fa8974,0x66c00172,0x867b0039}},	//   _ná_, бул_, söks, _הריו, 
   {{0x9c7c8269,0xc8799d05,0x6aa181ed,0xd12f1d06}},	//   _tuči, _coş_, hilf, طمه_, 
   {{0xd00f9c98,0x27e08008,0x442d8039,0x6d5c1d07}},	//   اله_, äin_, dge_, lvra, 
   {{0x628508b4,0xa96a1d08,0x44f19d09,0x67229d0a}},	//   ckho, _лига_, _bá_, rroj, 
   {{0x44f19d0b,0x61430ad0,0x7c3b9d0c,0x6d5c1d0d}},	//   _cá_, _пера, ffur, nvra, 
   {{0x44f19d0e,0x442d9d0f,0xd00f8691,0x61fb0bbe}},	//   _dá_, gge_, _ملف_, _đuli, 
   {{0x3d088bda,0x7690019b,0x27e903ad,0x6aa187a2}},	//   _सबके_, _käyd, _rgan_, filf, 
   {{0x7c2d1d10,0xaabe1d11,0x44f19d12,0x442d9d13}},	//   zgar, ्तिक, _fá_, age_, 
   {{0x44f18013,0xe8e0001c,0x7c2d1d14,0x6f0981ed}},	//   _gá_, _ngồi_, ygar, _zwec, 
   {{0xab2a97bb,0xd90e803d,0x64830079,0xc87982d1}},	//   _года_, پیک_, _võik, _xoş_, 
   {{0x2bdb800f,0xaabe1d15,0x7ce78214,0x4df083ff}},	//   मेदा, ्ताक, _fırs, _चलाई_, 
   {{0x68fc00f3,0x1df81747,0x2ee501ab,0xddc500ac}},	//   _otrd, зеры_, ölf_, _zahř, 
   {{0x291c0068,0xd23b8039,0x27e90004,0xdb1d01d2}},	//   ával_, _הגול, _tgan_, _vysí, 
   {{0x7c2d1d16,0x5d54014f,0xd13880ce,0xb4fb8eee}},	//   ugar, экст, mtą_, מפלי, 
   {{0x7c2d1d17,0x64978166,0x768f80f0,0x386900d8}},	// [e70] rgar, cţiu, _høye, _inar_, 
   {{0x09e080cf,0x7c2d1d18,0xedf88c64,0x442d9d19}},	//   _ম্যা, sgar, ुरोध_, zge_, 
   {{0xc5fb1108,0xd1388116,0x69f2004a,0x62851d1a}},	//   ्रीय_, ntą_, түст, rkho, 
   {{0x44f19d1b,0x9c7c88dc,0x6d450129,0x78a282fb}},	//   _rá_, _kuču, _ipha, giov, 
   {{0x291804c7,0x2d8301e2,0xb8f4002a,0x44f1807f}},	//   _evra_, lyje_, _सी_, _sá_, 
   {{0xd1388116,0x44f19d1c,0x320e8050,0x61ea868e}},	//   ktą_, _pá_, _nefy_, _ngfl, 
   {{0x442d81e5,0x2d830116,0x386919a4,0xe6109ac4}},	//   tge_, nyje_, _onar_, اشه_, 
   {{0x44f19d1d,0x29011d1e,0xdbf1801b,0x442d9d1f}},	//   _vá_, mpha_, přík, uge_, 
   {{0x6aa19d20,0x7c3b9d21,0x26c78170,0x44f1812f}},	//   tilf, rfur, plno_, _wá_, 
   {{0x44f19389,0x66020d69,0x38691d22,0x6d451d23}},	//   _tá_, _đoko, _anar_, _opha, 
   {{0x386900e5,0x6fd9809b,0x6d45027e,0xbebb09b8}},	//   _bnar_, बेरं, _npha, trën, 
   {{0xc689096e,0xbe2500b2,0x67248183,0x7fd6004a}},	//   _דא_, ম্মদ_, šije, дігі, 
   {{0x6d451d24,0x2cad9d25,0x320e86a8,0x38b90507}},	//   _apha, mned_, _fefy_, néry_, 
   {{0x2cbf9d26,0xdce38162,0xcb128309,0xdd920184}},	//   loud_, tynė, _ילד_, پور_, 
   {{0x7afd1d27,0x66e31d28,0xed571d29,0xe810800d}},	//   _atst, тора, мор_, ारमा_, 
   {{0x69da0077,0x2cad9d2a,0x78a28065,0x68431164}},	//   _útei, nned_, xiov, _анъа, 
   {{0x60c41d2b,0x7ae71d2c,0x2cad9d2d,0x03a31c7e}},	// [e80] _ikim, _bijt, ined_, вито, 
   {{0x2cbf8622,0x7bc61d2e,0xab5b0019,0x02190116}},	//   houd_, _vyku, _gyüm, зіць_, 
   {{0xceb30273,0xbebb016c,0x63a9007f,0x994a1d2f}},	//   _ביז_, ytëz, _þenn, تلال_, 
   {{0x672b9d30,0x7aef04ab,0xcb6a1d31,0x601a9d32}},	//   fugj, _fuct, _даме_, іцер_, 
   {{0x7e7a803b,0x78a29d33,0x76900008,0x7bc602d2}},	//   _potp, riov, _täyd, _uyku, 
   {{0xd1389d34,0xa9261d35,0x68ee0ced,0x6b840e0b}},	//   ytą_, _одгл, _tubd, myig, 
   {{0x98a69bc4,0x320e9659,0x10a69d36,0x68fc084c}},	//   _живе, _refy_, _живн, _utrd, 
   {{0x2cad9d37,0x22581d38,0x628e00e9,0x3d1103ca}},	//   gned_, _hark_, _hlbo, _तबसे_, 
   {{0x6b841d39,0xb05b0341,0x628e1d3a,0x320e840a}},	//   nyig, släk, _klbo, _pefy_, 
   {{0x6f0285cb,0x60c41d3b,0x38691d3c,0x32549d3d}},	//   mpoc, _akim, _snar_, хвор, 
   {{0x29189d3e,0x22580039,0x60f88091,0x6f02811e}},	//   éra_, _mark_, яння_, lpoc, 
   {{0xd1389d3f,0x60d60324,0x2d8300ce,0x3af29d40}},	//   rtą_, _chym, vyje_, _tâp_, 
   {{0xd1388da2,0x27ed1943,0x7d1a8050,0x320e840a}},	//   stą_, ženo_, _hvts, _tefy_, 
   {{0x60c41d41,0x2bd5120a,0x2d830116,0x3b5380f0}},	//   _ekim, _दरबा, tyje_, _шкір, 
   {{0x7aef81ac,0x7aef1d42,0x68fb13ea,0x6d581d43}},	//   íctv, _suct, _čudo, _švar, 
   {{0x628e1d44,0x961480b2,0x2d830116,0x2bdb80c3}},	//   _albo, সলিম_, ryje_, मेवा, 
   {{0x3f4f0208,0x628e0170,0x7ebf01d2,0x3ea3093c}},	// [e90] _użu_, _blbo, tápě, pijt_, 
   {{0x2d830162,0xdddc00d7,0x6f0d00bb,0x2fc9013b}},	//   pyje_, skrš, _iwac, _iyag_, 
   {{0x22581d45,0x66151b64,0x7ec58610,0xb05b0656}},	//   _dark_, mazk, _lîpî, eläi, 
   {{0x38698422,0x8c3d9d46,0xc87982bc,0x6f0d1d47}},	//   ñar_, kişa, _kişi_, _kwac, 
   {{0x59d40e78,0x7afd06b3,0x36699d48,0xfc3f0063}},	//   _थरथर, _utst, зало_, _amíg_, 
   {{0x8d559d49,0x644283de,0xed599246,0xaa450008}},	//   етич, _aboi, зок_, ävää_, 
   {{0xa2c282f4,0xaabe1d4a,0x20e88083,0xd01b9ca1}},	//   रकन्, ्तरक, _işin_, _мфа_, 
   {{0x44f51d4b,0xa3ba8bda,0x24891d4c,0xa2b918cb}},	//   _må_, _आँख_, nkam_, ्तक्, 
   {{0x27ed9d4d,0x44f5072c,0x2cbf9d4e,0x2cad8039}},	//   _igen_, _lå_, roud_, rned_, 
   {{0xe1f88188,0x24890103,0x2cbf9d4f,0x644d1d50}},	//   үгө_, hkam_, soud_, heai, 
   {{0x44f50d38,0x68e98066,0xa9699d51,0x21699d52}},	//   _nå_, _kied, чина_, чини_, 
   {{0xf1b203dd,0x20560229,0x2280834e,0x6f0d01d7}},	//   רסט_, хтор, _bòks_, _bwac, 
   {{0xeb8e894c,0x68e99d53,0x66150766,0x6f0d09ec}},	//   _си_, _mied, fazk, _cwac, 
   {{0x52398273,0x443f9d54,0x68e99d55,0x66150124}},	//   _זײַנ, lfu_, _lied, gazk, 
   {{0x49bb840c,0xfaff0210,0x04461d56,0x9d430ceb}},	//   _باشد_, _atë_, невн, лерд, 
   {{0x44f51d57,0x68e99d58,0x63a48116,0x60c40010}},	//   _då_, _nied, _žini, _ukim, 
   {{0x6d4107fa,0x645995f3,0x22581d59,0x443f804f}},	// [ea0] çlar, _mawi, _park_, ifu_, 
   {{0x44f50088,0x78a61d5a,0x27ed85b5,0x77641d5b}},	//   _få_, likv, _agen_, _irix, 
   {{0x44f50088,0x68e99d5c,0xe5a61d5d,0x35a60dbe}},	//   _gå_, _bied, _чини, _чанг, 
   {{0x7e7e0523,0x645980a1,0x78a61d5e,0xb5fc8519}},	//   _hopp, _nawi, nikv, _inġi, 
   {{0x7e7e0437,0xde588612,0x1754819b,0x17c8804c}},	//   _kopp, далі_, твля, фҳаи_, 
   {{0x27ed9d5f,0x443f9d60,0x7e7e1d61,0x64598786}},	//   _egen_, efu_, _jopp, _aawi, 
   {{0x80d100cf,0x52be1d62,0x7e7e0552,0x64830079}},	//   _সংস্, ्तीस, _mopp, _võiv, 
   {{0x77640659,0xd49787a8,0x6f029d63,0x4432052a}},	//   _orix, ерь_, ppoc, ngy_, 
   {{0x64599d64,0x82a69d65,0x61f309b8,0x645d8050}},	//   _dawi, ешне, _çelë, ôsia, 
   {{0x2d96904e,0x68e980f3,0x60c28079,0x443f9d66}},	//   _прес, _zied, loom, afu_, 
   {{0x6f1b8053,0xddc88770,0x39478bd4,0xe89501e2}},	//   _zvuc, _hodž, _cpns_, вань, 
   {{0x64599d67,0x765a80bf,0xddc88183,0x27ed04f4}},	//   _gawi, _haty, _kodž, øen_, 
   {{0x44f50c3e,0x765a9d68,0x66150109,0x77641d69}},	//   _så_, _katy, tazk, _crix, 
   {{0x44f50088,0x36d51d6a,0x64598066,0xa6e78106}},	//   _på_, тогр, _zawi, _nhữ, 
   {{0xb81081ff,0x66150d1f,0x7e7e1d6b,0x765a9d6c}},	//   ाराम_, razk, _dopp, _maty, 
   {{0x3913809f,0x776410b2,0x3f869d6d,0x765a9d6e}},	//   _смър, _frix, kyou_, _laty, 
   {{0x68e99d6f,0xeeb90004,0x43941892,0x7764011e}},	// [eb0] _ried, _олиш_, гатс, _grix, 
   {{0x6d488022,0x765a9d70,0x68e99d71,0x66d2007f}},	//   _opda, _naty, _sied, lækn, 
   {{0x68e99d72,0x673d1413,0x7aea9d73,0x39470741}},	//   _pied, ltsj, _mift, ïns_, 
   {{0x20d2030b,0x26c5826b,0xe0df06e0,0x7e7e02fb}},	//   háin_, _sklo_, nmò_, _zopp, 
   {{0x64599d74,0x23d50f82,0x68e99d75,0x765a9d76}},	//   _rawi, _दरिद, _vied, _baty, 
   {{0x68e99d77,0x6459840c,0x7aea9d78,0x945d80a1}},	//   _wied, _sawi, _nift, końc, 
   {{0x68e9836d,0x64599d79,0xd6580039,0x8cb59d7a}},	//   _tied, _pawi, גיות_, ксич, 
   {{0x2d51800d,0x67249d7b,0x0b458103,0x27ed806d}},	//   _vše_, šija, внин, _ugen_, 
   {{0xe29995e6,0x645b9d7c,0xa0a5804a,0x443f9d7d}},	//   дап_, rdui, _заңд, rfu_, 
   {{0x273b859e,0x64598010,0x09e500b2,0x443f9d7e}},	//   mên_, _wawi, _প্যা, sfu_, 
   {{0x273b859e,0x81c98a87,0x20120f93,0xe9d989ba}},	//   lên_, লেন_, _peyi_, ько_, 
   {{0x387f83e9,0x7e0a007a,0x3ea79d7f,0x64830073}},	//   _jour_, वर्ग_, lint_, _mõis, 
   {{0x273b8aaf,0xa4d4836a,0x2d879d80,0x80d100b2}},	//   nên_, _соці, lyne_, _সংশ্, 
   {{0x9f9e0077,0x3ea79d81,0x60c29d82,0x78a61d83}},	//   _ação_, nint_, zoom, sikv, 
   {{0x69ca8360,0x273b82a5,0xada309b2,0x764e1d84}},	//   _gyfe, hên_, аарл, reby, 
   {{0x273b859e,0x29059d85,0x09b000b2,0x764e1d86}},	//   kên_, mpla_, _করলা, seby, 
   {{0x7e7e137c,0xf4128273,0x753c0066,0x273b824a}},	// [ec0] _topp, יפן_, strz, jên_, 
   {{0x273b824a,0x64830079,0xddc89d87,0x386d83cd}},	//   dên_, _sõit, _rodž, _aner_, 
   {{0xfbc7807b,0x3ea79d88,0xa2b31d89,0x60c2932b}},	//   _چت_, dint_, _आदर्, toom, 
   {{0x273b824a,0xfbc78830,0x2eca8bf0,0x387f80ef}},	//   fên_, _نت_, ित्त, _cour_, 
   {{0x765a8116,0x69d50019,0x64830073,0xb8f90c2e}},	//   _paty, _ezze, _võit, _ठी_, 
   {{0x3ea79d8a,0x6f0207fa,0x649580fe,0x60c29d8b}},	//   gint_, _çocu, _láid, soom, 
   {{0x64b38123,0xfaa31d8c,0xc60b80b2,0x387f9d8d}},	//   răin, _таро, _রাখা_, _four_, 
   {{0x273b824a,0xb4cc809b,0x7aea9d8e,0x69ca843a}},	//   bên_, ळते_, _sift, _ryfe, 
   {{0xee3a936b,0x8c3d8a08,0x44221d8f,0x20d200d8}},	//   _она_, mişl, _mdk_, táin_, 
   {{0x63a90116,0x3ea79d90,0x7c2900f3,0x7afd9d91}},	//   _ženk, cint_, _ķerm, ísta, 
   {{0x387f8757,0x63ad812b,0x6d489d92,0x20d200d8}},	//   _your_, _þann, _upda, ráin_, 
   {{0x387f1d93,0x20d20013,0x63a481e2,0x386d04e0}},	//   ður_, sáin_, _žinu, ñer_, 
   {{0x26c31d94,0x7aea8208,0x7c228103,0x66d2006d}},	//   tojo_, _tift, _idor, rækn, 
   {{0x44f89d95,0x39580265,0x6d5c80d8,0x6fe901a8}},	//   _ké_, _osrs_, _áras, _rīcī, 
   {{0x273b82a5,0x44f89d96,0x39580269,0x44220a7e}},	//   zên_, _jé_, _nsrs_, _bdk_, 
   {{0x273b9d97,0x44f8830b,0x65650265,0x80d105a2}},	//   yên_, _mé_, _vrhh, _সূর্, 
   {{0x20191d98,0x44f89d99,0x1af41d9a,0x273b824a}},	// [ed0] masi_, _lé_, иптя, xên_, 
   {{0x273b859e,0x20d20013,0x7e5500f0,0x68ed01cb}},	//   vên_, háil_, _своє, _hiad, 
   {{0x387f9d9b,0x6618826b,0x68ed1d9c,0x3ea79d9d}},	//   _pour_, davk, _kiad, vint_, 
   {{0x273b82a5,0x64830079,0x66020e02,0xdb1d019b}},	//   tên_, _võis, _đoki, _pysä, 
   {{0xfeb80283,0x9cd60fcc,0x20d200fe,0x3ea79d9e}},	//   _سایت_, _תורה_, dáil_, tint_, 
   {{0x273b8aaf,0x0ccb8f5a,0x44f89d9f,0xaec48612}},	//   rên_, ात्म, _bé_, абіл, 
   {{0x20191cb9,0x273b82a5,0x44f88013,0x8883807b}},	//   kasi_, sên_, _cé_, _پیشن, 
   {{0x2366803a,0x20d20013,0x44f89da0,0x2ca90324}},	//   _broj_, gáil_, _dé_, niad_, 
   {{0x645d1da1,0x66189146,0x44391da2,0x60c98504}},	//   _masi, bavk, _mcs_, _ikem, 
   {{0x2019002d,0x44f89da3,0x44390399,0x2fcd868e}},	//   easi_, _fé_, _lcs_, _iyeg_, 
   {{0x20191da4,0xa29f8073,0x44f88385,0x68ed0c9f}},	//   fasi_, गोष्, _gé_, _biad, 
   {{0x645d1da5,0x20191da6,0x68f51da7,0x20d200fe}},	//   _nasi, gasi_, _muzd, cáil_, 
   {{0x32459da8,0x7bcb87fa,0x68ed1da9,0x2ca90360}},	//   _белг, _uygu, _diad, diad_, 
   {{0xed5a0b6f,0xb4be1daa,0x248d801b,0x29059dab}},	//   ног_, ेत्_, lkem_, ppla_, 
   {{0x20191dac,0x442209b8,0x68ed1dad,0x2ca90324}},	//   basi_, _pdk_, _fiad, fiad_, 
   {{0x6abe0f8a,0x68ed1dae,0x2ca90324,0xa3ea1daf}},	//   ्त्र, _giad, giad_, едба_, 
   {{0xab661db0,0x2fcd822a,0x6b899db1,0xb05b010d}},	// [ee0] ывал, _nyeg_, nyeg, rlät, 
   {{0x248d8073,0x68ed1db2,0x60c98e49,0x60db9db3}},	//   hkem_, _ziad, _akem, _ahum, 
   {{0x645d1db4,0x44221db5,0x60db9db6,0xb05b01ed}},	//   _fasi, _tdk_, _bhum, plät, 
   {{0x60db9db7,0x645d1db8,0x44f89db9,0xb05b1dba}},	//   _chum, _gasi, _ré_, llär, 
   {{0x44f89dbb,0x43751dbc,0x60db807b,0x8c3d8646}},	//   _sé_, _курт, _dhum, rişl, 
   {{0x44f89dbd,0x4ab8000c,0x645d1dbe,0x20191dbf}},	//   _pé_, _आदिव, _zasi, zasi_, 
   {{0x20191dc0,0x645d030d,0x20d20013,0xc8798093}},	//   yasi_, _yasi, táil_, _pişt_, 
   {{0x6f040081,0x44f8801c,0x60db80bf,0x645d1dc1}},	//   _otic, _vé_, _ghum, _xasi, 
   {{0x2019047a,0x36368275,0xe80a8365,0x20d20013}},	//   vasi_, _مراس, _ह्या_, ráil_, 
   {{0x44f89dc2,0x20191dc3,0xfaff016c,0x20d200fe}},	//   _té_, wasi_, _orën_, sáil_, 
   {{0x68ed1dc4,0xc87982a5,0x6f040745,0x32638162}},	//   _piad, _tişt_, _atic, стыв, 
   {{0x6d5a9dc5,0x68e29dc6,0xeb9a9c39,0x6f040036}},	//   _ista, nmod, _пие_, _btic, 
   {{0xb4c0823b,0xb4c28365,0x2ca68142,0x86271023}},	//   ंकी_, ृती_, _imod_, льве, 
   {{0x68ed1dc7,0x645d1dc8,0x256387fa,0x2ca90670}},	//   _wiad, _sasi, _yıl_, wiad_, 
   {{0x645d1dc9,0x68ed1dca,0x20191637,0x6f040bc5}},	//   _pasi, _tiad, pasi_, _etic, 
   {{0x69d89dcb,0x645d1dcc,0x24581a59,0x752801ac}},	//   _izve, _qasi, лась_, ádza, 
   {{0x645d1dcd,0x2ca91dce,0x68f51dcf,0x291e9dd0}},	// [ef0] _vasi, riad_, _suzd, lsta_, 
   {{0x60db8b5b,0x645d022d,0x60c99dd1,0x273f02a5}},	//   _shum, _wasi, _skem, mîn_, 
   {{0x645d1dd2,0x273f024a,0x41551dd3,0x6d5a9dd4}},	//   _tasi, lîn_, рвес, _nsta, 
   {{0x291e91b6,0x765e00a1,0x3cfb8034,0x69ce00c0}},	//   ista_, _zapy, _लंबे_, _dybe, 
   {{0x273f02a5,0x8335096e,0x65689dd5,0x6d5a9dd6}},	//   nîn_, _דאָס_, _ardh, _asta, 
   {{0x291e9dd7,0x7aee01ed,0x83fd8019,0xab6601a8}},	//   ksta_, _gibt, zdőd, _daļē, 
   {{0x273f02a5,0x248d842e,0xd61880d8,0x291c01d2}},	//   hîn_, tkem_, اتها_, ávat_, 
   {{0x0325930c,0xac8581e5,0x273f01b2,0x8b259dd8}},	//   адин, ргил, kîn_, адие, 
   {{0x291e9dd9,0x6d5a8ce0,0x273f024a,0xeb998188}},	//   esta_, _esta, jîn_, тип_, 
   {{0xea899dda,0x273f0610,0x7aa59ddb,0x78ab872c}},	//   тбол_, dîn_, риоз, ligv, 
   {{0xe8070560,0xd9459ddc,0xe0da1ddd,0x291e9dde}},	//   _व्हा_, шени, кво_, gsta_, 
   {{0xc796055a,0x6e250015,0x26c79ddf,0x290381a8}},	//   аргы, _adhb, lono_, īja_, 
   {{0xe28e9de0,0x291e9de1,0xb8fc9de2,0x7fd6005a}},	//   _да_, asta_, _ती_, ріні, 
   {{0x91e59de3,0x6d5a811a,0x26c7826e,0x539a8039}},	//   _коле, _ysta, nono_, _בינו, 
   {{0xb05b0a6c,0x26c78495,0x44161337,0x5fd80076}},	//   rlär, iono_, ифат, _ठरवल, 
   {{0x26c79de4,0x7786009f,0xdd8f0f36,0x273f024a}},	//   hono_, _влиз, ذوق_, bîn_, 
   {{0xd3871de5,0x6f0416ad,0x26c79de6,0x23e00439}},	// [f00] айте_, _utic, kono_, पेंद, 
   {{0x26c78116,0x2b401de7,0xa01b1de8,0x64440166}},	//   jono_, rtic_, sköt, sfii, 
   {{0x2b401de9,0xd83a877a,0xf67b0273,0x867b0039}},	//   stic_, вэл_, _סאטמ, _סרטו, 
   {{0x69ce003e,0x50468623,0xa01b1dea,0x38601deb}},	//   _vybe, редб, lkör, _jair_, 
   {{0x26c79dec,0xdfcf8013,0x44fc1ded,0xbebb00f8}},	//   fono_, ويم_, _hí_, rrëv, 
   {{0x62839dee,0x661c1def,0x68e28615,0x3860003d}},	//   _nono, nark, smod, _lair_, 
   {{0xb87b000d,0x44fc001b,0xa01b010d,0x273f01b2}},	//   dmín, _jí_, ljöe, zîn_, 
   {{0x44fc1df0,0x273f02a5,0x661c0124,0x3218052a}},	//   _mí_, yîn_, hark, _hery_, 
   {{0x62839df1,0xf749803d,0xa2c2809b,0xb7fd0439}},	//   _bono, _مجله_, रकल्, _एलबम_, 
   {{0x62839df2,0x273f024a,0x26c79df3,0x661c1df4}},	//   _cono, vîn_, cono_, jark, 
   {{0x6d5a9df5,0x44fc1df6,0x62839df7,0xd48f9df8}},	//   _usta, _ní_, _dono, _др_, 
   {{0x291e9df9,0x38601dfa,0x273f01b2,0xdcee0116}},	//   rsta_, _cair_, tîn_, mybė, 
   {{0x44fc1dfb,0x44269dfc,0x38601dfd,0x62839dfe}},	//   _aí_, _ido_, _dair_, _fono, 
   {{0x44fc1dff,0x273f059e,0x661c1e00,0x3f428106}},	//   _bí_, rîn_, gark, _mưu_, 
   {{0x3f428028,0x44269e01,0x273f01b2,0x88d600b2}},	//   _lưu_, _kdo_, sîn_, _সংরক, 
   {{0x301502fd,0x316d1e02,0x26c79e03,0xd4981e04}},	//   _удир, _čez_, zono_, ару_, 
   {{0x60cd1e05,0x26c79e06,0x273f01b2,0x24581e07}},	// [f10] _ikam, yono_, qîn_, шать_, 
   {{0x99671e08,0xdcee0162,0x3b0902d1,0x661c1e09}},	//   ител, kybė, rpaq_, cark, 
   {{0xd3668283,0x161a8066,0x26c7809f,0xd5b81e0a}},	//   _که_, _नज़र_, vono_, _вся_, 
   {{0x776984e0,0x40359e0b,0xa3cc81a2,0x4426804f}},	//   _prex, седс, _शुभ_, _ndo_, 
   {{0x26c79e0c,0x753501bb,0x60cd1e0d,0x32181e0e}},	//   tono_, luzz, _mkam, _fery_, 
   {{0xc9871e0f,0x44269e10,0xee3880f0,0x51871e11}},	//   _куби, _ado_, ині_, _куба, 
   {{0x09e50a87,0x31e500cf,0x99850013,0x01e500cf}},	//   _প্রা, _প্রশ, _الزو, _প্রদ, 
   {{0x69ca9e12,0xa8a48163,0x442680f8,0x26c79e13}},	//   _सुधी, _друк, _cdo_, sono_, 
   {{0x6b8d1e14,0x26c79e15,0x661c1e16,0x201d9e17}},	//   nyag, pono_, yark, mawi_, 
   {{0x60cd1e18,0x442680b4,0x81c280cf,0x38601e19}},	//   _akam, _edo_, ্ধন_, _sair_, 
   {{0xb87b026b,0x62839e1a,0x69ca8453,0xec15803d}},	//   rmín, _vono, _सुदी, _هواد, 
   {{0x656e830b,0x201d840c,0x62839e1b,0x661c1e1c}},	//   _ábha, nawi_, _wono, wark, 
   {{0x2d8a8354,0x44fc1e1d,0x232982d4,0x6283852a}},	//   _über_, _sí_, _соли_, _tono, 
   {{0x629a9e1e,0x201d837a,0xa6ca1e1f,0xb05b010d}},	//   chto, hawi_, улга_, släp, 
   {{0x7e61859e,0x7c960f70,0x201d9e20,0x753c81ed}},	//   _malp, брац, kawi_, _ärzt, 
   {{0x661c1e21,0x3860003c,0x201d9e22,0x44fc1e23}},	//   sark, _uair_, jawi_, _ví_, 
   {{0xd4671207,0xb2261e24,0x201d9e25,0xc9f600fe}},	// [f20] щите_, ймал, dawi_, مساع, 
   {{0xe8108549,0x44fc1e26,0x753501bb,0x2bac0076}},	//   ार्थ_, _tí_, buzz, _घेणा, 
   {{0x81c98a87,0x32181e27,0x3f42801c,0x75351e28}},	//   লের_, _very_, _sưu_, cuzz, 
   {{0xa01b0172,0x443d9e29,0x7f4282fb,0xdcee0162}},	//   nköp, _ncw_, ttoq, vybė, 
   {{0x200210f1,0x321801cb,0x64560a05,0x6d438106}},	//   icki_, _tery_, meyi, etna, 
   {{0xa01b036d,0x2480005d,0x7e619e2a,0xdcee0116}},	//   hköp, ljim_, _calp, tybė, 
   {{0x201d9e2b,0x7f4281bb,0x2cad9e2c,0x25e39e2d}},	//   bawi_, stoq, fied_, टेली_, 
   {{0x69dc082b,0x64561e2e,0x44269e2f,0x26ca04e2}},	//   _izre, neyi, _qdo_, hobo_, 
   {{0x6d698029,0x4426858f,0x57fb8115,0x26ca1e30}},	//   _īpaš, _vdo_, _תלמו, kobo_, 
   {{0x60cd1e31,0x6d5e1e32,0x321881ac,0xe810801b}},	//   _skam, _ospa, úry_, ारका_, 
   {{0x2cad8b7e,0x44269e33,0x67240e02,0x7d0a8bbc}},	//   bied_, _tdo_, _avij, _снег_, 
   {{0x55778273,0x661a8388,0x629a9e34,0x8c3d808a}},	//   _לעבן_, _hetk, shto, yişi, 
   {{0x6724003b,0x6d5181de,0x29079e35,0x24800524}},	//   _cvij, čkaš, _etna_, djim_, 
   {{0x67240301,0x69dc0183,0x19948e61,0x2486827e}},	//   _dvij, _ozre, _маля, _hoom_, 
   {{0x248681ea,0x59cf8b30,0x321e9e36,0xdd941e37}},	//   _koom_, _सुपर, maty_, пары, 
   {{0x75351348,0x8c3d87fa,0x60cd1e38,0x6b8d1e39}},	//   ruzz, tişi, _ukam, tyag, 
   {{0x6d5e1e3a,0xfbd30158,0x69dc00f6,0x26ca1e3b}},	// [f30] _espa, ستر_, _azre, bobo_, 
   {{0x63a9098f,0x661a9e3c,0x201d9e3d,0x26ca016f}},	//   _žens, _netk, wawi_, cobo_, 
   {{0x67241287,0x2bd50de3,0x201d9e3e,0x6f160034}},	//   _zvij, _दरका, tawi_, _zwyc, 
   {{0x2ec186df,0x2486827e,0x6e289e3f,0x4fd58175}},	//   शक्त, _noom_, _addb, ожет, 
   {{0xf1cf810c,0x643a00c6,0x201b00db,0x212102fa}},	//   _सुनन, _דערנ, _meqi_, sshh_, 
   {{0x3eae8e87,0x661a80d7,0x6d439e40,0x171c00c6}},	//   gift_, _cetk, ttna, נווע, 
   {{0x7e619e41,0x78bb872d,0xdc9983ad,0x7d020033}},	//   _valp, _tjuv, итиш_, _čosk, 
   {{0x6298872c,0xcc89804a,0x6d439e42,0x672281df}},	//   _alvo, рбие_, rtna, bsoj, 
   {{0x6287003b,0x6d439e43,0x7e619e44,0x6a7f81b2}},	//   _kojo, stna, _talp, _kêfx, 
   {{0xa9259e45,0x62871e46,0x248010f1,0x6f099e47}},	//   одол, _jojo, zjim_, _itec, 
   {{0x67240310,0x3f8f8360,0x2d678024,0x2486806c}},	//   _svij, lygu_, _uđe_, _foom_, 
   {{0xa91100da,0x649c8a5e,0x62871e48,0x26ca0192}},	//   डीएफ_, _réig, _lojo, wobo_, 
   {{0x661a8b50,0x321e9e49,0x776d02fb,0x2d851e4a}},	//   _yetk, baty_, _crax, älen_, 
   {{0x21699e4b,0x66db0610,0xa9699e4c,0x64499e4d}},	//   _вики_, tîka, _вика_, lfei, 
   {{0x649c830b,0x71a5899f,0x26ca1e4e,0x249902fa}},	//   _féid, _файз, robo_, _blsm_, 
   {{0x7c3b9e4f,0x24869e50,0x66db01b2,0x26ca1e06}},	//   ngur, _xoom_, rîka, sobo_, 
   {{0x67240310,0x62871e51,0x776d1e52,0x52aa0488}},	// [f40] _uvij, _bojo, _grax, авам_, 
   {{0x62871e53,0x649c80fe,0x64560083,0x1ae31e54}},	//   _cojo, _téig, seyi, доум, 
   {{0x661a9e55,0x6f0982fb,0xa01b010d,0x62871e56}},	//   _retk, _atec, ljöa, _dojo, 
   {{0x661a9e57,0x50ca00a1,0x20ca001b,0x6722819b}},	//   _setk, रविष, रविध, tsoj, 
   {{0x44201e58,0x661a84e1,0x7c3b8149,0x24868039}},	//   mai_, _petk, dgur, _room_, 
   {{0x2a630265,0x24869e59,0x6b8b010d,0xe29a1e5a}},	//   _gajb_, _soom_, ägge, _таг_, 
   {{0xd49a8dec,0x24869e5b,0x661a9e5c,0x4127004c}},	//   ири_, _poom_, _vetk, _моро_, 
   {{0x44201e5d,0x7c3b9e5e,0xb1988106,0x734a8123}},	//   nai_, ggur, _ngưỡ, ачов_, 
   {{0x61ef808a,0x649c80d8,0x68fc1e5f,0x1fd180b2}},	//   əklə, _réid, _hurd, ়েবস, 
   {{0x68fc1e60,0x38669e61,0xfa8a9e62,0x7c3b9e63}},	//   _kurd, ldor_, рсий_, agur, 
   {{0x44201e64,0x69ca950f,0xe45a836a,0x2486827e}},	//   kai_, _सुशी, _вже_, _toom_, 
   {{0x44201e65,0x38669e66,0x68fc1e67,0x776d1e68}},	//   jai_, ndor_, _murd, _prax, 
   {{0x44201e69,0x69ca8671,0xe66712a5,0x610180f3}},	//   dai_, _सुरी, отво, _vēla, 
   {{0x81c980b2,0x2455001c,0x7658804f,0x809f0034}},	//   লেই_, _ấm_, nevy, खोजे, 
   {{0xbd681e6a,0x62871e6b,0x44201e6c,0x00950166}},	//   орте_, _rojo, fai_, _никэ, 
   {{0x44201e6d,0x776d0659,0x7c209e6e,0x90c40223}},	//   gai_, _trax, namr, _обје, 
   {{0x62871e6f,0x8c3d8214,0x1eab00fe,0x7bc10034}},	// [f50] _pojo, mişt, _نادي_, _ślub, 
   {{0x8c3d9e70,0x320b1e71,0x7afd9e72,0x628704e2}},	//   lişt, рхан_, ísti, _qojo, 
   {{0x44201e73,0x6f099e74,0x7c209e75,0xad27003d}},	//   bai_, _stec, kamr, _برخو, 
   {{0xe8f81e76,0x8c3d9e77,0x649580fe,0x68fc1e78}},	//   ілі_, nişt, _cáil, _durd, 
   {{0xb902007a,0xb4d7009b,0xcb4400b0,0x62871e79}},	//   _नी_, िती_, _охри, _tojo, 
   {{0x81cd00cf,0x7afd1e7a,0x8c3d81b2,0x9662804a}},	//   শেষ_, _iust, hişt, екше, 
   {{0xceb40273,0x6d471e7b,0x855780dd,0x649580fe}},	//   ויס_, ntja, تیار_, _fáil, 
   {{0x7af50109,0x81c285a2,0x3b8583ad,0x442b1e7c}},	//   _hizt, ্ধা_, злиг, _jdc_, 
   {{0xbf159367,0x64499e7d,0x7c3b9e7e,0xe3b180fe}},	//   _رواب, rfei, rgur, عرب_, 
   {{0x7afd1e7f,0x78ad1453,0x64499e80,0x7c3b9e81}},	//   _must, _amav, sfei, sgur, 
   {{0x81cd00cf,0x44201e82,0x68fc04e0,0x88ca1e83}},	//   শের_, yai_, _xurd, йлов_, 
   {{0xa3ac0689,0x7c208a63,0x44201e84,0x29e18432}},	//   _कइल_, camr, xai_, _açaí_, 
   {{0x44200712,0x7afd01e2,0xb4c9809b,0xf77200d8}},	//   vai_, _nust, ोती_, راح_, 
   {{0x442017bc,0x442b1e85,0x59cf802a,0x78ad09ec}},	//   wai_, _adc_, _सुथर, _emav, 
   {{0x44201e86,0x7c960163,0x649580fe,0x442b02fb}},	//   tai_, прац, _láim, _bdc_, 
   {{0x2be29379,0x7afd1e87,0x249f80b0,0xa3e28079}},	//   _परमा, _bust, nhum_, _धरम_, 
   {{0x7af51e88,0x44201e89,0x59cf807a,0x7afd1e8a}},	// [f60] _bizt, rai_, _सुतर, _cust, 
   {{0x7c2080f6,0x2bce9e8b,0x5cf60166,0x7afd1e8c}},	//   zamr, _हँसा, _няму, _dust, 
   {{0x68e40b14,0xa3ac122f,0x442b1e8d,0x2be29e8e}},	//   _khid, _केर_, _fdc_, _परभा, 
   {{0x7afd1e8f,0x20d21e90,0x68fc056e,0x69d51e91}},	//   _fust, máis_, _vurd, _dyze, 
   {{0x7afd1e92,0x68fc0354,0x6726036a,0x672d8131}},	//   _gust, _wurd, nskj, šajn, 
   {{0x425503d1,0x68fc1e93,0x63a40232,0x35d49be8}},	//   _отст, _turd, mzin, молё, 
   {{0x7afd1e94,0x321c9e95,0x63a41e96,0x649580d8}},	//   _zust, _revy_, lzin, _táil, 
   {{0x2ca00786,0x7de70019,0xf7469e97,0x5ba68994}},	//   nhid_, lésé, _небо, зроз, 
   {{0x7afd0659,0x8ac88daa,0x8fa39e98,0x7ae38129}},	//   _xust, оқда_, _зате, _bhnt, 
   {{0x63a41e99,0x3a749e9a,0xa3d28103,0xcb130309}},	//   izin, флор, моқч, עלת_, 
   {{0xa3cc807a,0xade89628,0xfbc400b2,0x68e40c9f}},	//   _शुर_, टेशन_, ্ধিত, _bhid, 
   {{0x290a834a,0x68e40889,0x64a38162,0x7bc30166}},	//   ība_, _chid, _паха, şnui, 
   {{0x68e41e9b,0x442b1e9c,0x63a400fa,0x8c3d9e9d}},	//   _dhid, _rdc_, jzin, rişt, 
   {{0x63a41e9e,0x442b1e9f,0x6d471ea0,0x7cc18029}},	//   dzin, _sdc_, ttja, mēra, 
   {{0xd49b1ea1,0x71f78158,0x78ad026b,0x27e00124}},	//   бра_, _عروس_, _tmav, _ezin_, 
   {{0xb4d70e78,0xe45f012b,0x6d471ea2,0x628a9ea3}},	//   िते_, _mjög_, rtja, _hofo, 
   {{0x6d4704bd,0xc62280b2,0xa3e71ea4,0x20090217}},	// [f70] stja, _নানা_, यें_, _ifai_, 
   {{0xbd020149,0x6d471ea5,0x26ce8050,0x8f9c0309}},	//   ñéca, ptja, jofo_, _ליחי, 
   {{0xb5fc8208,0x78bd1ea6,0x628a9ea7,0x442b006d}},	//   _paġn, onsv, _mofo, _tdc_, 
   {{0x442b1ea8,0xddde16ad,0x69d501ac,0x2ca01ea9}},	//   _udc_, _uopš, _vyze, chid_, 
   {{0x644d1eaa,0xf745947c,0x5f9487c5,0x26ce9eab}},	//   mfai, фело, ницт, fofo_, 
   {{0x628a9eac,0x20d200fe,0x64428065,0x644d1ead}},	//   _nofo, náir_, _acoi, lfai, 
   {{0x236d0885,0x249f9725,0x24e99eae,0x7d1a9725}},	//   _šejh_, thum_, омки_, _cwts, 
   {{0x644d1eaf,0x9f6500e9,0x649580fe,0xfd5e801c}},	//   nfai, _štýl_, _táim, _huyề, 
   {{0x7690025b,0xf77f86b5,0x628a9eb0,0x6f0d00bb}},	//   _käyt, _çç_, _bofo, _ntac, 
   {{0x68e41eb1,0xd048008a,0x20d20217,0x6f1b8e0b}},	//   _shid, əməy, yáis_, _iwuc, 
   {{0x63a4009f,0x661e1eb2,0x6e239eb3,0x249f83d9}},	//   zzin, _repk, manb, phum_, 
   {{0x644280fe,0x7de70019,0xe2f9804a,0xf4858139}},	//   _gcoi, zésé, _деді_, _تائی, 
   {{0x644d00fe,0xe3ae89dd,0x628a9eb4,0x10a31eb5}},	//   dfai, _рб_, _fofo, тиян, 
   {{0x7690036d,0x7afd91b3,0x12fa8039,0x672600f0}},	//   _näyt, ístu, _והסב, rskj, 
   {{0x2ca00015,0x9d43024f,0x644d1eb6,0x443f9eb7}},	//   thid_, керд, ffai, ogu_, 
   {{0x443f9eb8,0x63a41eb9,0x2ca000e5,0x672981ce}},	//   ngu_, tzin, uhid_, _ovej, 
   {{0xc61d00cf,0x7de70019,0x6e239eba,0xaec61e54}},	// [f80] _তারা_, tésé, kanb, _обил, 
   {{0x248b00bf,0x2ca01ebb,0xed5a1ebc,0x77640dbb}},	//   _eocm_, shid_, _доо_, _isix, 
   {{0x443f8b14,0x81d600b2,0x64a6001d,0xc5fa02f4}},	//   kgu_, াইভ_, _жана, ंशीय_, 
   {{0x765c1ebd,0x38ab0034,0x644d00d8,0xa3c91ebe}},	//   lery, _górę_, cfai, _लुक_, 
   {{0x7c240f99,0x201f9cf5,0x2b490aee,0x67298a63}},	//   mair, _deui_, ctac_, _cvej, 
   {{0x7c241ebf,0x64428013,0x443f9ec0,0x2458801c}},	//   lair, _scoi, egu_, _ẩm_, 
   {{0x26ce81cb,0xa01b007f,0x3d12009b,0x645b9ec1}},	//   rofo_, fjöl, धीचे_, feui, 
   {{0x7c241ec2,0x628a82ae,0x66df8093,0x77640065}},	//   nair, _sofo, rêka, _osix, 
   {{0x9ce8811d,0xd00f8743,0x648e8304,0x63ad9ec3}},	//   _ہوئے_, _خلق_, _bùir, _žanr, 
   {{0x7c241ec4,0x765c1ec5,0x628a837f,0xee379ec6}},	//   hair, jery, _qofo, _ону_, 
   {{0x3a3707a6,0x7c241ec7,0x60cf0123,0xe873003d}},	//   ורים_, kair, tocm, نندگ, 
   {{0x78a29ec8,0x6f00804f,0x628a82d9,0x645b9ec9}},	//   nhov, _kumc, _wofo, ceui, 
   {{0x7c241eca,0xe2868daa,0xb90582f1,0x23e2964f}},	//   dair, _олди, _बी_, _परिद, 
   {{0x44249ecb,0xb4d70056,0x768f836a,0x765c0c20}},	//   lam_, ित्_, _høyr, gery, 
   {{0x776404e0,0x20c70c27,0xa2cb86d7,0x3ce6806c}},	//   _esix, _осиг, सकर्, _khov_, 
   {{0x44249ecc,0x64409ecd,0x7c240caf,0xa3e293d2}},	//   nam_, ngmi, gair, _धरा_, 
   {{0x3a750daa,0xf8bf0f6a,0x644d1ece,0x69d880fa}},	// [f90] нлар, mné_, rfai, _hyve, 
   {{0x386901d9,0xf8bf03e0,0xfd5e8028,0x5a341ecf}},	//   _haar_, lné_, _quyề, кнут, 
   {{0x44249ed0,0x67298533,0x443f9ed1,0x6e239ed2}},	//   kam_, _svej, ygu_, vanb, 
   {{0xf8bf1ed3,0x386913c7,0x7c241ed4,0x656500bf}},	//   nné_, _jaar_, cair, _ishh, 
   {{0x38691ed5,0x6e239ed6,0x7690036d,0xe0d880f0}},	//   _maar_, tanb, _täyt, єві_, 
   {{0x81c980b2,0x45199ed7,0xa01b0063,0x6d4a9ed8}},	//   লেট_, пция_, gköz, ftfa, 
   {{0x6e239ed9,0xf8bf1eda,0x44249edb,0x645b9edc}},	//   ranb, kné_, fam_, teui, 
   {{0x38691edd,0x78a28791,0x6ac79ede,0xf8bf027b}},	//   _naar_, chov, रक्र, jné_, 
   {{0xf8bf0a93,0x610180f3,0x254e808a,0x26d11edf}},	//   dné_, _vēlm, _həll_, kozo_, 
   {{0x443f8324,0x961e001b,0x236d806d,0xf1bf8033}},	//   sgu_, _बजेट_, rvej_, ášok_, 
   {{0xe9d9809f,0xae748068,0x236d806d,0xf99180d8}},	//   яко_, _جھنڈ, svej_, ابخ_, 
   {{0x6e219ee0,0x3ce681df,0xf8bf00ef,0x7cc180f3}},	//   _helb, _ghov_, gné_, mēro, 
   {{0x386901d9,0x442f9ee1,0x9f4c0a08,0x7c2400f3}},	//   _daar_, _idg_, _ölüm_, vair, 
   {{0x78a2826b,0x2cbf8079,0xade40587,0xaa4583ad}},	//   zhov, lnud_, _गरदन_, _чекл, 
   {{0x7c241ee2,0x69d88ad0,0xf8bf1ee3,0xc6928115}},	//   tair, _gyve, bné_, נאל_, 
   {{0x38690e45,0xf8bf026b,0x23ce800d,0x765c1ee4}},	//   _gaar_, cné_, _हुँद, sery, 
   {{0x7c241ee5,0x765c1ee6,0xfa360936,0x26d11ee7}},	// [fa0] rair, pery, فراد, bozo_, 
   {{0x7c241ee8,0x2be293d2,0x05660480,0x4a43164e}},	//   sair, _परसा, _звон, лнув, 
   {{0x442f9862,0xf29683f3,0x6f009ee9,0x7d0180c0}},	//   _odg_, עכער_, _sumc, _nuls, 
   {{0xafdb0c05,0x76900008,0x64a61eea,0x38a201ac}},	//   mfør, _täys, _чама, _fóre_, 
   {{0xa01b0019,0x2cbf8079,0x78a29eeb,0x7645011a}},	//   tköz, dnud_, rhov, _ychy, 
   {{0x44249eec,0x7d019eed,0x78a29eee,0xf8bf0410}},	//   wam_, _buls, shov, zné_, 
   {{0xb7bd802d,0xa0a680f0,0x78a28172,0x6e218bfa}},	//   _reţe, _завд, phov, _delb, 
   {{0x6d4a8e87,0x3ce6950d,0x442f8606,0xb4ca85b1}},	//   rtfa, _qhov_, _cdg_, लके_, 
   {{0xf8bf0f43,0xe73791f1,0x64408073,0x7af881df}},	//   vné_, _пет_, rgmi, _pivt, 
   {{0xc3331eef,0x44248308,0x628e1ef0,0x6e219ef1}},	//   נות_, sam_, _jobo, _gelb, 
   {{0xf8bf0a93,0x38691591,0x7afd826b,0x3ce681ea}},	//   tné_, _paar_, ístr, _thov_, 
   {{0x26f909d7,0x44221ef2,0xdd8f8182,0x44249ef3}},	//   ंद्र_, _nek_, _دوم_, qam_, 
   {{0xf8bf1ef4,0x6108801b,0x7af89ef5,0x386906a4}},	//   rné_, _děla, _tivt, _vaar_, 
   {{0x386901d9,0xf8bf003e,0x7c2280fe,0x623493b7}},	//   _waar_, sné_, _heor, _реку, 
   {{0xf8bf003e,0x44221ef6,0xf1d0012e,0x7c2280db}},	//   pné_, _bek_, _तुलन, _keor, 
   {{0x44221ef7,0x11db8052,0x629a9ef8,0x7c2280db}},	//   _cek_, _מחוב, lkto, _jeor, 
   {{0x628e1ef9,0x213e9efa,0x533410ea,0x2a7c893c}},	// [fb0] _bobo, luth_, летт, _knvb_, 
   {{0xd0198964,0x44221efb,0x629a9efc,0x628e1efd}},	//   दर्भ_, _eek_, nkto, _cobo, 
   {{0x628e1efe,0x4422044e,0x649c8035,0xdeb2004a}},	//   _dobo, _fek_, _réin, _тұры, 
   {{0x6e21835b,0xb4ca83ce,0x4c950cf5,0x7cc180f3}},	//   _selb, लको_, _римс, vēro, 
   {{0x6e219dca,0x4f08805a,0x7d019eff,0x36698b59}},	//   _pelb, енін_, _suls, дало_, 
   {{0x628e1f00,0xed599081,0x24891f01,0x442f9f02}},	//   _gobo, док_, ljam_, _sdg_, 
   {{0x4422059e,0x6abf078b,0x2cbf8079,0xa158056b}},	//   _yek_, ्वीर, tnud_, _пару_, 
   {{0x24891f03,0x628e1f04,0x629a9f05,0x6e219f06}},	//   njam_, _zobo, ekto, _welb, 
   {{0x7c229f07,0x2ef59081,0x03229f08,0x29030fa4}},	//   _deor, _азар, адын, _huja_, 
   {{0x3da79309,0x29031f09,0xb87b01d2,0x60d60341}},	//   _преб, _kuja_, hlíd, _skym, 
   {{0xa0a604bc,0x10a600f0,0x98a61639,0x7c228064}},	//   ванд, винн, вине, _feor, 
   {{0x92c380cf,0x61fa1f0a,0x2efa0269,0xf3ff0106}},	//   ্ষে_, _útle, _sipf_, _ngã_, 
   {{0xeb8e9700,0x4422022c,0x62659f0b,0x672d0269}},	//   _ти_, _rek_, _авла, _cvaj, 
   {{0x764383a1,0x44221f0c,0xa7fb04e0,0x66e61f0d}},	//   ngny, _sek_, xeñe, тога, 
   {{0xceb29af4,0x2a6a0363,0x44221f0e,0x7c2280db}},	//   בים_, _rabb_, _pek_, _yeor, 
   {{0xafdb0255,0x7c2283b9,0x39580191,0x6fb600d8}},	//   rfør, _xeor, _rprs_, _لمعا, 
   {{0x63a99f0f,0xb87b1f10,0xe8d71f11,0x44221f12}},	// [fc0] nzen, rmít, _בוקר_, _vek_, 
   {{0x44221f13,0x68e99f14,0x63a981f0,0x27ff868e}},	//   _wek_, _ahed, izen, _agun_, 
   {{0x44221f15,0x6cc61f16,0x68e98097,0x35a61f17}},	//   _tek_, _айна, _bhed, _ранг, 
   {{0x68fb9f18,0x7794803d,0xb87b03b9,0x649c80d8}},	//   _ciud, هیزا, lmír, _céil, 
   {{0x68e381b2,0xdfd280fe,0x63a981f0,0x649c80d8}},	//   înda, جيش_, jzen, _déil, 
   {{0x63a99f19,0x7c229598,0x27ff80b4,0x5f939f1a}},	//   dzen, _seor, _egun_, ришт, 
   {{0xd9e605d9,0x68469f1b,0x649c80fe,0x7c229f1c}},	//   _करित_, _инва, _féil, _peor, 
   {{0x61e307fa,0x68fb809f,0x64441f1d,0x68e99f1e}},	//   ünle, _giud, ngii, _ghed, 
   {{0x69dc0172,0x69ca903a,0x7afc1f1f,0x60c29f20}},	//   _hyre, _सुजी, _kirt, mnom, 
   {{0x7afc02a1,0xbbe283ff,0x60c29f21,0x5be29071}},	//   _jirt, _परीक, lnom, _परीव, 
   {{0xe6be15ad,0x672d0116,0x5d869f22,0x2d9809b8}},	//   ोवैज, _svaj, _جلال, jyre_, 
   {{0x6f0400fe,0x60c29f23,0x213e8069,0x6d5a8214}},	//   _buic, nnom, ruth_, _ipta, 
   {{0x63a98d99,0x7afc0c8c,0xb4be9b00,0x59b2801b}},	//   czen, _oirt, ँची_, ुपहर, 
   {{0x3eb801b2,0x60c28ced,0x6f041f24,0x7ce59f25}},	//   girt_, hnom, _duic, móra, 
   {{0x5c071f26,0xddda801b,0xa5040103,0x69dc0072}},	//   вяза, _patř, иятл, _nyre, 
   {{0x7afc0013,0x3eb80089,0x6444013b,0x672d80f3}},	//   _airt, airt_, ggii, šaji, 
   {{0x649c80fe,0x24891f27,0xb87b1f28,0x29031f29}},	// [fd0] _réil, rjam_, smís, _suja_, 
   {{0x22470068,0x6d5a9f2a,0x29031f2b,0x6abf0c2e}},	//   ünk_, _opta, _puja_, ्वेर, 
   {{0xa3e7007a,0x68e99f2c,0xdd951662,0xa2ba0dcf}},	//   येज_, _phed, _саны, ्वज्, 
   {{0x69dc1f2d,0xf8d180cf,0x60c29f2e,0x7afc1f2f}},	//   _dyre, িষ্ঠ, gnom, _eirt, 
   {{0x44291f30,0xc43a0052,0x6d5a8e4c,0xab841f31}},	//   maa_, _אתרי, _apta, _курк, 
   {{0xf7708604,0x4429036d,0x64958013,0x4aa71f32}},	//   غان_, laa_, _láit, _गतिव, 
   {{0x68e99f33,0x20d91f34,0x200981e0,0xb87b02fd}},	//   _thed, néis_, ñais_, ilíb, 
   {{0x44291f35,0x200500a1,0x63a99f36,0x7d051f37}},	//   naa_, ślij_, tzen, _muhs, 
   {{0xddc183ce,0x63838103,0x7b75819c,0x63a99f38}},	//   _dalš, рҳла, اطبا, uzen, 
   {{0x63a99f39,0x44291f3a,0x45459f3b,0x42c689b2}},	//   rzen, haa_, _منطق, лгын_, 
   {{0x44291f3c,0x63a99f3d,0x26c30bfc,0x2b4d9f3e}},	//   kaa_, szen, dnjo_, stec_, 
   {{0xe73a1f3f,0x44291f40,0x20d91f41,0x3da491f0}},	//   нем_, jaa_, déis_, _труб, 
   {{0x44291f42,0xca759f43,0xb8cc1f44,0x6f040039}},	//   daa_, _буйы, _गत_, _quic, 
   {{0x2d9800f8,0x25ef0365,0x66e3809b,0x386d86a4}},	//   tyre_, _आणखी_, गतिक_, _laer_, 
   {{0xada318d9,0x518784c9,0x09be00cf,0x44291f45}},	//   барл, _шуда, _অর্থ, faa_, 
   {{0x38a21f46,0x44291f47,0x7afc1f48,0xb87b1f49}},	//   _fóra_, gaa_, _sirt, smír, 
   {{0x2d9e1f4a,0x7afc1f4b,0x09be171b,0x38a200a1}},	// [fe0] šte_, _pirt, ्थ्य, _góra_, 
   {{0x7c29811a,0x0e661f4c,0x649c80fe,0x20d91f4d}},	//   haer, _скон, _réim, béis_, 
   {{0x44291f4e,0x20d90e7c,0x7c298109,0x7afc1f4f}},	//   baa_, céis_, kaer, _virt, 
   {{0x7afc1f50,0x4fa69f51,0x386d9f52,0x00da8f36}},	//   _wirt, лиев, _caer_, ربات_, 
   {{0x7afc1f53,0xbbe2801b,0x386d9893,0x8f848103}},	//   _tirt, _परेक, _daer_, шқал, 
   {{0x356a8188,0x7afc00d8,0x20d900d8,0x387f82ef}},	//   ерин_, _uirt, néir_, _enur_, 
   {{0xf9879f54,0x2aa40068,0x64958013,0x7c2613fd}},	//   _اب_, _több_, _náis, _kekr, 
   {{0xa01b1f55,0x386d82ad,0x7c299f56,0x83349f57}},	//   ljöv, _gaer_, gaer, аних, 
   {{0x40938067,0x649580fe,0x5c3703f3,0x00000000}},	//   _القر, _ráit, ארפן_, --, 
   {{0x41549031,0x78a41f58,0x59b81f59,0x629e1f5a}},	//   авос, _aliv, _आधार, nkpo, 
   {{0x78a41f5b,0x44291f5c,0x7c29813b,0x6e250214}},	//   _bliv, yaa_, baer, _rehb, 
   {{0x7c26003b,0x93e68004,0xe3bf0530,0x629d816c}},	//   _nekr, _йўлл, _leña_, ësor, 
   {{0x44291f5d,0xe29a81e2,0x44268050,0xe0df02fb}},	//   vaa_, _пад_, _ieo_, rlò_, 
   {{0x20d91f5e,0x386d1f5f,0x44291f60,0x44269f61}},	//   téis_, žer_, waa_, _heo_, 
   {{0x44291f62,0x44269f63,0x78a4008b,0x254e82d1}},	//   taa_, _keo_, _fliv, _bəli_, 
   {{0x4426829f,0x649580fe,0x6e25008b,0x20d91f64}},	//   _jeo_, _háir, _wehb, réis_, 
   {{0x44290008,0x7c261f65,0x20d91f66,0xbbe281a2}},	// [ff0] raa_, _dekr, séis_, _परोक, 
   {{0x44269f67,0x27e900b4,0x7ce5812b,0x44291f68}},	//   _leo_, _izan_, jórn, saa_, 
   {{0x68ed1f69,0x44291f6a,0x649580d8,0x7c260199}},	//   _khad, paa_, _máir, _fekr, 
   {{0x44268048,0x7c2600d0,0x046713cb,0xb4c0800d}},	//   _neo_, _gekr, _стом, ूको_, 
   {{0xd366899d,0xddd70816,0x68ed1f6b,0x2ca900fe}},	//   _به_, _yaxş, _mhad, mhad_, 
   {{0x1eea80dd,0x9a871f6c,0xca49003d,0x68ed068e}},	//   نونی_, _сумл, _جلسه_, _lhad, 
   {{0x44269f6d,0x63ad1f6e,0x41e4109a,0x1ddb00da}},	//   _beo_, lzan, _гіта, _मुमत, 
   {{0x27e917e0,0x63ad1f6f,0x61fa01fb,0x68ed1f70}},	//   _ozan_, ozan, _útla, _nhad, 
   {{0x63ad1f71,0x44269f72,0xbf1587db,0xd05d008a}},	//   nzan, _deo_, _ضواب, _üzər, 
   {{0xdfd88574,0x60c98a76,0xa7fb01e0,0x68ed004f}},	//   _със_, _hjem, xeña, _ahad, 
   {{0x00861f73,0x78a40a5a,0x27e91f74,0x44269f75}},	//   ално, _pliv, _azan_, _feo_, 
   {{0x7e639f76,0x672d8043,0xac198661,0x44269f77}},	//   lenp, šaju, _роду_, _geo_, 
   {{0x6d439f78,0x81bd80cf,0x68ed033f,0x63ad068c}},	//   luna, _আরও_, _dhad, jzan, 
   {{0x63ad1f79,0xe2968071,0xbb3a8039,0x8f9a83f3}},	//   dzan, _ваш_, _יעני, דישי, 
   {{0x6d439f7a,0x60db9f7b,0x69c6824a,0x68ed0094}},	//   nuna, _okum, şker, _fhad, 
   {{0x60c993e0,0xa7fb0422,0x68ed1f7c,0x44269f7d}},	//   _njem, seña, _ghad, _xeo_, 
  
   {{0xd4671340,0x3b071f7e,0x6d438e3b,0xe3bf1f7f}},	// [1000] шите_, ието_, huna, _peña_, 
   {{0x29079f80,0x60db9f81,0x3ce01f82,0x248d83cd}},	//   _kuna_, _akum, sliv_, hjem_, 
   {{0x26d81f83,0x29079f84,0x6d439f85,0x249f81c2}},	//   moro_, _juna_, juna, kkum_, 
   {{0x3ea59f86,0x29079f87,0x26d81f88,0x6d439f89}},	//   _allt_, _muna_, loro_, duna, 
   {{0x29079f8a,0x44269f8b,0xe3bf04e0,0x63ad00a1}},	//   _luna_, _reo_, _teña_, czan, 
   {{0x44269f8c,0x8d76842b,0x60c985da,0x26d81f8d}},	//   _seo_, لاعا, _ejem, noro_, 
   {{0x6d439f8e,0x29079f8f,0x44269f90,0x7d78803d}},	//   guna, _nuna_, _peo_, امبر_, 
   {{0x26d8029a,0xd7668068,0x442684e2,0x60c99f91}},	//   horo_, _پارٹ, _qeo_, _gjem, 
   {{0x44269f92,0x64958013,0x29079abc,0xb5fc81bb}},	//   _veo_, _páir, _auna_, _raġu, 
   {{0x29079f93,0x781f0e5e,0x6d5e1f94,0x3a27811e}},	//   _buna_, पर्क_, _oppa, _cenp_, 
   {{0x44268573,0x63ad1f95,0x29079f96,0x26d81f97}},	//   _teo_, zzan, _cuna_, doro_, 
   {{0x57a70103,0xd83f83d5,0x644b8128,0x7ae19f98}},	//   ашга, _účtu_, _gcgi, allt, 
   {{0x64958013,0x6d5e1f99,0x61050116,0x27e000db}},	//   _táir, _appa, _vėli, _cyin_, 
   {{0x68e28504,0x26d81f9a,0x7d088cb7,0xd065008a}},	//   hlod, goro_, _kuds, _əsər, 
   {{0x29079a28,0x6e289f9b,0x68ed1f9c,0x3cf3009b}},	//   _guna_, _medb, _thad, ंगले_, 
   {{0x1b1980cf,0x63ad1f9d,0x7d089c69,0x7cc180f3}},	//   _দিতে_, tzan, _muds, tēri, 
   {{0x2ca91f9e,0x6d439f9f,0x26d800bb,0x78bd1fa0}},	// [1010] rhad_, zuna, boro_, misv, 
   {{0x63ad1fa1,0x26d81fa2,0x60c99689,0x29079fa3}},	//   rzan, coro_, _sjem, _yuna_, 
   {{0xceb2015c,0x2f0b8022,0x83fd8019,0x249f9fa4}},	//   _זיי_, _søg_, ndőr, ykum_, 
   {{0x6d438371,0x78bd1fa5,0x68e29fa6,0xa49b055a}},	//   vuna, nisv, glod, _diòc, 
   {{0x1fb993c9,0x95e90068,0x3f678a48,0x7e639fa7}},	//   ылды_, _جبکہ_, ртеб, tenp, 
   {{0x7c2d00c5,0x6d439fa8,0x7d089fa9,0x6da583ad}},	//   laar, tuna, _buds, йила, 
   {{0x365c0039,0x2ca681a3,0x60c9861c,0x248d807e}},	//   דכונ, _blod_, _tjem, tjem_, 
   {{0x7c2d1faa,0x60db9fab,0x60c99fac,0x29079fad}},	//   naar, _ukum, _ujem, _runa_, 
   {{0x6d439fae,0xf7738f2a,0x248d9faf,0x29079fb0}},	//   suna, _باز_, rjem_, _suna_, 
   {{0x6d439fb1,0x249f9fb2,0x29000079,0x26d80103}},	//   puna, skum_, _siia_, xoro_, 
   {{0xf769004d,0x26d80574,0x7c2d19ac,0x6f0986c9}},	//   _רק_, voro_, kaar, _huec, 
   {{0x7c2d1fb3,0x64599fb4,0x29078105,0x6f1602fe}},	//   jaar, _ubwi, _vuna_, _ptyc, 
   {{0x527385c2,0x7fd6005a,0x442d9fb5,0x6f0981ce}},	//   _ҳуқу, сіні, mae_, _juec, 
   {{0x442d9fb6,0x64499fb7,0x6f098149,0xc7d68080}},	//   lae_, lgei, _muec, מורי_, 
   {{0x29079fb8,0x0d990a54,0x776d03b9,0xf1cf8673}},	//   _uuna_, атты_, _esax, _सुचन, 
   {{0x7c2d1fb9,0x26d81fba,0x64499fbb,0xdd8f1fbc}},	//   gaar, soro_, ngei, روق_, 
   {{0x09b500cf,0x62950103,0x2ca000f6,0x442d811e}},	// [1020] _জুলা, _bozo, rkid_, iae_, 
   {{0x442d9fbd,0xe3a78068,0x2ca01fbe,0x2a6580bc}},	//   hae_, _ہر_, skid_, nelb_, 
   {{0x7c2d1fbf,0x442d9fc0,0x9e7b00c6,0xed459543}},	//   baar, kae_, _ענטפ, _تھ_, 
   {{0x6c861fc1,0x6e2e1fc2,0x777b9fc3,0x7ce58530}},	//   _الحم, labb, _brux, fórm, 
   {{0x4420101d,0x3ebc8c3e,0x7d08803b,0xdee69fc4}},	//   mbi_, tivt_, _suds, боди, 
   {{0xcd290a0e,0x569384bc,0x6e2e1fc5,0x6f099fc6}},	//   _حسین_, зашт, nabb, _duec, 
   {{0x7d088645,0x61431fc7,0x649580d8,0x2b401fc8}},	//   _quds, _нера, _páip, lric_, 
   {{0x5b148ded,0x62839fc9,0x44201fca,0x6e2e1fcb}},	//   омит, _anno, nbi_, habb, 
   {{0xdc9b0273,0x213e8324,0x78a28170,0x657a811a}},	//   טיקל, wrth_, mkov, _wrth, 
   {{0x290a1a78,0x78a29fcc,0x44201fcd,0xd91a9688}},	//   _kuba_, lkov, hbi_, льм_, 
   {{0xd48f9fce,0x290a0073,0x442d82b7,0x867b8039}},	//   _ер_, _juba_, bae_, _תרבו, 
   {{0xdee684c9,0x44200105,0x7d1c0170,0x2ca68128}},	//   _тоҷи, jbi_, dprs, _ulod_, 
   {{0x7c2d1fcf,0x4420082b,0x2bd8122f,0x43949fd0}},	//   vaar, dbi_, _भुला, _фалс, 
   {{0x442d12b2,0x29181fd1,0x7c2d1be1,0xae140625}},	//   _že_, _otra_, waar, तुलन_, 
   {{0x3abb804d,0x7c2d1fd2,0x6ca702ed,0x8af00816}},	//   _תמונ, taar, браж, ktəb, 
   {{0x44201fd3,0x94191e08,0x7d0280de,0xd4981fd4}},	//   gbi_, ржат_, _jios, бру_, 
   {{0x61150816,0x7c2d1fd5,0x78a2826b,0x29181fd6}},	// [1030] _işlə, raar, dkov, _atra_, 
   {{0x7c2d1fd7,0x7d02806b,0x62950103,0xf8bf0035}},	//   saar, _lios, _qozo, lié_, 
   {{0x290a1fd8,0xe3bf04e0,0x6f09961e,0x7c2d1fd9}},	//   _cuba_, _teño_, _suec, paar, 
   {{0x6d471fda,0xec6b0a43,0x92691fdb,0x290a1981}},	//   muja, _срок_, ырға_, _duba_, 
   {{0x7c208d7c,0x6d5500b4,0x44391fdc,0x6f099fdd}},	//   dbmr, ltza, _ids_, _quec, 
   {{0x442d9fde,0x442b1fdf,0x29071613,0x44391fe0}},	//   wae_, _hec_, ínas_, _hds_, 
   {{0x6d5500b4,0x442b1fe1,0x6d47007e,0x290a1fe2}},	//   ntza, _kec_, nuja, _guba_, 
   {{0xdfd59fe3,0x6e2e1fe4,0x78a28802,0x6d550109}},	//   _добы, zabb, ckov, itza, 
   {{0x442d9fe5,0x6d471fe6,0x7d029fe7,0x442b1fe8}},	//   rae_, huja, _dios, _mec_, 
   {{0xadf9000f,0x442b1fe9,0x27ed8109,0x44201fea}},	//   ंधान_, _lec_, _izen_, zbi_, 
   {{0xa88a1feb,0xf8bf02c0,0xf86604f9,0x44391fec}},	//   айна_, fié_, овно, _ods_, 
   {{0x25d6896e,0x442b1fed,0x44391fee,0x6d4701ac}},	//   _ווען_, _nec_, _nds_, duja, 
   {{0x2cad8142,0x78a99fef,0x6e2e1ff0,0x60cd1ff1}},	//   mhed_, _mlev, tabb, _djam, 
   {{0x78a99ff2,0x05db010c,0x78a2826b,0x442000db}},	//   _llev, _मुहब, zkov, wbi_, 
   {{0x78a98413,0xde03036a,0x6e2e1ff3,0x44201ff4}},	//   _olev, дпри, rabb, tbi_, 
   {{0x03260574,0x44201ff5,0x2cad806d,0x290a1ff6}},	//   ждан, ubi_, nhed_, _ruba_, 
   {{0x78a29ff7,0x290a1ff8,0x3eba18c5,0x7c2b9ff9}},	// [1040] vkov, _suba_, _tmpt_, _megr, 
   {{0x645d008b,0x644f0495,0xa01b010d,0x61e381c2}},	//   _ebsi, _ecci, ljöp, _kynl, 
   {{0x78a29589,0x78a98022,0x38669ffa,0x2d780284}},	//   tkov, _blev, teor_, _uče_, 
   {{0xddc898d4,0x290a00bb,0x803703f3,0x442b0c21}},	//   _nadš, _vuba_, ַנצע_, _gec_, 
   {{0x78a29589,0xf8b30052,0x7d0280d8,0xbe8a9ffb}},	//   rkov, ושא_, _rios, иске_, 
   {{0x7d029ffc,0x290a1ffd,0x877b0115,0x7b09131f}},	//   _sios, _tuba_, יאני, _džud, 
   {{0x7c2b9ffe,0x98a69fff,0x78a2a000,0x27eda001}},	//   _begr, _диве, pkov, _ezen_, 
   {{0xf74684bc,0x61ee0131,0x442b2002,0x3207840a}},	//   _мебо, _izbl, _xec_, _agny_, 
   {{0x7cc18029,0xccf302f9,0x320d0a08,0x7c2ba003}},	//   vērt, וכה_, _şeyi_, _degr, 
   {{0x23620766,0x7d02a004,0x29048c4e,0x60cd2005}},	//   _mpkj_, _wios, _hima_, _sjam, 
   {{0x61e38360,0xc27b0115,0x291880f8,0xf8bf00ef}},	//   _cynl, בריי, ëra_, tié_, 
   {{0x7c2b9759,0xb87b00fe,0x2904a006,0xbb869652}},	//   _gegr, rlío, _jima_, _ولاي, 
   {{0x2486a007,0x29189523,0x29049eb2,0x81d600b2}},	//   _inom_, ūra_, _mima_, াইট_, 
   {{0x26dc8284,0x6d472008,0x442b2009,0x6f1d200a}},	//   novo_, tuja, _sec_, rpsc, 
   {{0xdcbb200b,0x442b200c,0xf8bf200d,0x61e3811a}},	//   аща_, _pec_, pié_, _gynl, 
   {{0x5b15187e,0x2904a00e,0x6298a00f,0x6d550124}},	//   змат, _nima_, _hovo, rtza, 
   {{0x62989d2e,0x442b2010,0x2486805d,0x63a0a011}},	// [1050] _kovo, _vec_, _mnom_, nymn, 
   {{0x78a9800d,0x291e80db,0x78bb808d,0x7cd38166}},	//   _slev, opta_, _smuv, măre, 
   {{0x24868053,0x2904a012,0x89d900fe,0x26dca013}},	//   _onom_, _bima_, حوار_, dovo_, 
   {{0xf771830b,0x29049106,0x644f0086,0x44392014}},	//   فات_, _cima_, _ucci, _uds_, 
   {{0x8e85a015,0x7c22060e,0xddc88407,0x7c2ba016}},	//   згле, ñore, _radš, _regr, 
   {{0xa137007b,0xd6dba017,0x3135065b,0x7ce5a018}},	//   _ورزش, ште_, _негр, móri, 
   {{0x6f0d0094,0x78a98269,0x2cada019,0x6287201a}},	//   _luac, _tlev, thed_, _injo, 
   {{0x7cc180f3,0x78bb80bb,0x78a9a01b,0x29048036}},	//   vērs, _umuv, _ulev, _gima_, 
   {{0x6f0d0013,0x2cad8142,0x649c80fe,0x61e3837c}},	//   _nuac, rhed_, _réit, _synl, 
   {{0xd2a98008,0x2cad8052,0x649ca01c,0x6298a01d}},	//   ское_, shed_, _béis, _covo, 
   {{0x6298a01e,0xa969a01f,0x2169a020,0x2b490149}},	//   _dovo, щина_, щини_, huac_, 
   {{0x20090065,0x6729a021,0x6f0d085e,0x92cb80b2}},	//   _cgai_, _kwej, _buac, লতে_, 
   {{0x61fe803e,0x291e8123,0x7ea21b15,0x2d85137c}},	//   _úpln, apta_, _hôpi, ålen_, 
   {{0x6d43a022,0x6f0d03bf,0xe3b08267,0x59bd0492}},	//   orna, _duac, _جرم_, ्पार, 
   {{0x98a62023,0xb7bd8123,0xf3f98123,0xa5d6002a}},	//   _нике, _deţi, deţi_, _मुखौ, 
   {{0x649c80fe,0x62872024,0x6ab4002a,0x5f762025}},	//   _héir, _anjo, ंफ्र, _فاخر, 
   {{0x7ce5a026,0x6b632027,0x7cd38166,0x69c30065}},	// [1060] góri, нкта, căre, únen, 
   {{0x6d410013,0x644d0094,0xe2972028,0x969610f3}},	//   álac, agai, пау_, _хриш, 
   {{0xfe9b00c6,0x386001bb,0x8066a029,0x6f1b82ef}},	//   _היימ, _kbir_, звеж, _atuc, 
   {{0x649c8013,0x6287202a,0x2f10875d,0xe7f3001b}},	//   _léir, _enjo, _pàg_, _घरमा_, 
   {{0x4432202b,0x7c24202c,0x66e6a02d,0x8fa38c98}},	//   may_, mbir, пода, наце, 
   {{0x7f42a02e,0x7c24039d,0x4432202f,0x291e96fd}},	//   rroq, lbir, lay_, ypta_, 
   {{0x29048024,0xacf881e2,0x62988183,0x490b801b}},	//   _tima_, онку_, _rovo, _ठूलो_, 
   {{0x44322030,0x26dc8259,0x7c242031,0x649c9a6e}},	//   nay_, sovo_, nbir, _réis, 
   {{0x6298a032,0x7d062033,0x33200e87,0xe646a034}},	//   _povo, _miks, npix_, _неап, 
   {{0x44322035,0x2cfa0625,0x7d062036,0x60c2a037}},	//   hay_, ्दुल_, _liks, liom, 
   {{0x05db059b,0x44320ef3,0x80b083ff,0xb7bd8123}},	//   _मुंब, kay_, ंसपे, _reţi, 
   {{0x48ab1ecf,0x44322038,0x7d062039,0x6298a03a}},	//   стом_, jay_, _niks, _wovo, 
   {{0x7c24203b,0x44320052,0x6298a03c,0xdfdb0086}},	//   dbir, day_, _tovo, сън_, 
   {{0xd24f80a7,0x7c2409ec,0x291e922c,0xdb230019}},	//   _منه_, ebir, ppta_, ہوری, 
   {{0x44321502,0xc986a03d,0xda5b93b1,0x6d4aa03e}},	//   fay_, _хули, _הכול, nufa, 
   {{0x4432203f,0x7ce580b0,0xb4d7023b,0x7c242040}},	//   gay_, tóri, ाके_, gbir, 
   {{0x2d8c2041,0x3a750004,0x7d062042,0xf3f9802d}},	// [1070] äder_, млар, _diks, teţi_, 
   {{0x78ad0a93,0x290ea043,0x644d2044,0x6d4aa045}},	//   _hlav, _kufa_, sgai, kufa, 
   {{0x443204b7,0x7c242046,0xa90705b6,0x7ce582fd}},	//   bay_, bbir, سبان, sóri, 
   {{0x26c32047,0xd138109a,0x6d4aa048,0x44322049}},	//   lijo_, яху_, dufa, cay_, 
   {{0x3b640021,0x7eaf80f0,0xb4e918cb,0x78ad008d}},	//   _първ, _løpe, यती_, _mlav, 
   {{0x78ad204a,0x6d43829f,0x26c30bfc,0x62870208}},	//   _llav, trna, nijo_, _unjo, 
   {{0x672480f3,0x2d57204b,0x78ad204c,0x6d4aa048}},	//   ģija, nçe_, _olav, gufa, 
   {{0xc9520039,0x60c28064,0xdb008733,0x8af00829}},	//   _שמן_, ciom, lymè, ntən, 
   {{0x1ee781a1,0x2d570214,0x81df00b2,0x8f55803d}},	//   _فوری_, hçe_, দেশ_, _زناش, 
   {{0x4432204d,0xb4e9204e,0x2d5702d2,0x26c3204f}},	//   zay_, यतु_, kçe_, jijo_, 
   {{0x81df15a3,0x44322050,0x26c32051,0x78ad2052}},	//   দের_, yay_, dijo_, _blav, 
   {{0xcea91b4c,0x44320fde,0xb4d703ce,0x78ad0018}},	//   _די_, xay_, ाको_, _clav, 
   {{0x610c07fa,0x44320206,0x7d062053,0x26c3007e}},	//   _işle, vay_, _riks, fijo_, 
   {{0x44322054,0x60c280a1,0x78ad2055,0x7d062056}},	//   way_, ziom, _elav, _siks, 
   {{0x44322057,0x9985840c,0xfce62058,0x7d06007b}},	//   tay_, _آلبو, дово, _piks, 
   {{0x442fa059,0x1ad580b2,0x3ce9205a,0x61fa01c2}},	//   _jeg_, _হওয়া, glav_, _útli, 
   {{0x442fa05b,0xa8570052,0x7c24205c,0x4432205d}},	// [1080] _meg_, _חיפה_, rbir, ray_, 
   {{0x4432041e,0x26c30ecf,0xa9a60103,0x7c24205e}},	//   say_, cijo_, мизд, sbir, 
   {{0x44320b7b,0xa96a046d,0x7d06205f,0xd91000df}},	//   pay_, تمام_, _tiks, ایر_, 
   {{0x442f86e0,0x443202dc,0x53ad83ff,0x4fea8982}},	//   _neg_, qay_, टनाश, омен_, 
   {{0xd7f7a060,0x3eac813b,0x69d52061,0x7ae88060}},	//   муш_, _pldt_, _exze, yldt, 
   {{0xd2521367,0x442f8073,0x6d58a062,0x60c2a063}},	//   _جنس_, _aeg_, ttva, siom, 
   {{0x442fa064,0xafdb0f4a,0x443d808b,0x213817a2}},	//   _beg_, ngør, _bdw_, _uvrh_, 
   {{0x63a406b5,0x442f806c,0x26c3007e,0x6d58a065}},	//   oyin, _ceg_, zijo_, rtva, 
   {{0x63a42066,0x442fa067,0x7ae384e2,0x0a6aa068}},	//   nyin, _deg_, _bknt, орни_, 
   {{0x395801df,0x629c2069,0x3b0780ef,0x610c12b6}},	//   _kqrs_, _joro, _cinq_, _eşle, 
   {{0x629c206a,0x67228029,0x6da6846c,0x26c30bfc}},	//   _moro, lpoj, _تمام, vijo_, 
   {{0x629c206b,0xa9c380f0,0x3f86206c,0x3cfa0034}},	//   _loro, тськ, _šoua_, ्दों_, 
   {{0xceeb1d1b,0x26c3016b,0xe81e0034,0x5f94206d}},	//   قرآن_, tijo_, पड़ा_, вият, 
   {{0x63a4206e,0x629c206f,0x442f80fa,0xb4d709f7}},	//   dyin, _noro, _zeg_, ाक्_, 
   {{0x26c30bfc,0x6f08a070,0x26cea071,0x9d180b59}},	//   rijo_, _midc, info_, дост_, 
   {{0xb4e91954,0x6b82a072,0x9f5500f0,0x26c3007e}},	//   यते_, _krog, _звич, sijo_, 
   {{0x629c2073,0x7ce580fe,0x7c220530,0x26c3007e}},	// [1090] _boro, mórt, ñora, pijo_, 
   {{0x27e90318,0xddc38166,0x2d570d7c,0x672d02a8}},	//   _iyan_, nenţ, pçe_, _iwaj, 
   {{0x610c0a08,0x7c2f0ad8,0x629c2074,0x2a782075}},	//   _oğlu, _tecr, _doro, _darb_, 
   {{0x2cb20324,0x38a22076,0x628a8128,0x672d2077}},	//   chyd_, _fóru_, _lnfo, _kwaj, 
   {{0x442fa078,0x629c2079,0x63b60066,0xb8d7810c}},	//   _reg_, _foro, czyn, _छत_, 
   {{0x442f8d38,0xd3560052,0x629c207a,0x99670b73}},	//   _seg_, _אישי_, _goro, _отбл, 
   {{0x26c981de,0xddc3802d,0x201280d8,0x672d0399}},	//   đao_, denţ, íniú_, _lwaj, 
   {{0xeb9990da,0x628aa07b,0xf1b200c6,0x91c202c3}},	//   зии_, _anfo, _עסן_, _сәул, 
   {{0x27e90786,0x68f6011a,0x6b82a07c,0x442fa07d}},	//   _nyan_, _rhyd, _crog, _veg_, 
   {{0x442f859a,0x629c008b,0xddc38123,0x291101d7}},	//   _weg_, _xoro, genţ, _kuza_, 
   {{0x442fa07e,0x27e9207f,0x6b82996a,0xa6db007f}},	//   _teg_, _ayan_, _erog, nuðu, 
   {{0x6b82a080,0x2d9880a6,0x8cc1032d,0xb4e910af}},	//   _frog, _àrea_, रोमो, यतो_, 
   {{0xc00000cf,0x1b1980cf,0xe3aea081,0x7ba780fe}},	//   ূর্ণ_, _দিকে_, _сб_, _تصام, 
   {{0x539a8464,0x2f1400f9,0x27e9020e,0xafdb00c0}},	//   _מינו, _väg_, _dyan_, tgør, 
   {{0x629c2082,0x2174804a,0x98a781d2,0x200d82fe}},	//   _roro, _ауыр, éně_, _ogei_, 
   {{0xfce602d4,0x68e4006a,0x629c2083,0xfce30a63}},	//   хобо, _ukid, _soro, госо, 
   {{0xbb432084,0xcb672085,0xd8d700c6,0x60c62086}},	// [10a0] летк, нате_, _רופט_, mikm, 
   {{0x63b600a1,0xddc1808b,0x629c2087,0x996e82d1}},	//   rzyn, _balż, _qoro, nəş_, 
   {{0xc879a088,0x64a62089,0xdca616c0,0x629c208a}},	//   _baş_, _зана, _зани, _voro, 
   {{0x60c6025f,0x2ca90172,0x7ae1a08b,0x6d4e208c}},	//   nikm, ckad_, holt, muba, 
   {{0x7ae1a08d,0x6d4e208e,0xb05b208f,0x7c362090}},	//   kolt, luba, onär, mayr, 
   {{0x26cea091,0x7cd38123,0x7e7c0265,0x1fdf80b2}},	//   unfo_, văra, ndrp, _বৃহস, 
   {{0x2366868c,0x29110533,0xddc38123,0x3ab302c3}},	//   _spoj_, _guza_, venţ, _сәтт, 
   {{0x91e32092,0x6d5c2093,0x6722819b,0x3947011e}},	//   _сосе, itra, ppoj, ánse_, 
   {{0x2909039d,0x6d4e13b3,0xddc38123,0x29112094}},	//   _riaa_, huba, tenţ, _zuza_, 
   {{0x6d4e2095,0x8af0008a,0x66e9824a,0x394c8741}},	//   kuba, xtəl, rêkê, tuds_, 
   {{0x0c268612,0xe3af8f2a,0x6d5c0524,0xc87983d2}},	//   _змен, لری_, jtra, _yaş_, 
   {{0xeb9a81f5,0xe61f8028,0x01370039,0x6d5c2096}},	//   _ние_, _đôi_, ערכת_, dtra, 
   {{0x7ae18f4b,0xb4bea097,0x28c006d7,0xdefb0008}},	//   bolt, ुची_, शोधि, зыв_, 
   {{0x7ae1a098,0x6d5c2099,0x38a200fe,0xbb1b01b2}},	//   colt, ftra, _sórt_, _brîn, 
   {{0x6d5c209a,0x6d4e209b,0x45d41aef,0x6e35209c}},	//   gtra, guba, горс, razb, 
   {{0xdef80208,0x8af0008a,0x7e7a80db,0x27e9209d}},	//   ċċa_, stəl, _latp, _tyan_, 
   {{0x68e2a09e,0x2911005d,0x6d5c209f,0x2ca920a0}},	// [10b0] dood, _suza_, atra, rkad_, 
   {{0x7e7a805d,0x644800f3,0x6d4e20a1,0x2ca920a2}},	//   _natp, _ēdie, buba, skad_, 
   {{0xc98420a3,0x7c3620a4,0xc879824a,0x6720868e}},	//   луци, bayr, _paş_, _atmj, 
   {{0xc5f207a6,0x90e780df,0x7ae18063,0x2ea98bc2}},	//   _כדי_, رسان, zolt, कस्त, 
   {{0x442920a5,0x4c9a04fc,0xef188efb,0xd4c220a6}},	//   mba_, _חברו, емі_, _төрк, 
   {{0x442920a7,0xdee584bc,0x7bdc86c8,0x8fa2a0a8}},	//   lba_, ъоли, ğrul, раше, 
   {{0x442920a9,0x691780f3,0xc87982d2,0x68e28c20}},	//   oba_, _aģen, _taş_, bood, 
   {{0x442920aa,0xfebb807b,0x4c8596dc,0xc48583ad}},	//   nba_, _کارت_, тлив, тлик, 
   {{0xe803000d,0x442920ab,0xa3de810c,0x6d4e20ac}},	//   रेमा_, iba_, _दुआ_, zuba, 
   {{0x442920ad,0x6d4e20ae,0x2b4d855a,0xd7f397aa}},	//   hba_, yuba, ruec_, _азғы, 
   {{0x26c7a0af,0x61ea8360,0x60c620b0,0x44290019}},	//   mino_, _cyfl, tikm, kba_, 
   {{0x442920b1,0x7ae1a0b2,0xf4858068,0x6d5c20b3}},	//   jba_, solt, _جائی, vtra, 
   {{0x442920b4,0x7fd6005a,0x2d858215,0x98bf20b5}},	//   dba_, тіні, _hrle_, nutę_, 
   {{0xaa458002,0x6d5c20b6,0x442920b7,0x26c7a0b8}},	//   _рекл, ttra, eba_, nino_, 
   {{0xed5720b9,0x61ea8324,0x7d0b8128,0x65c320ba}},	//   кор_, _gyfl, _kigs, абра, 
   {{0x6d4e20bb,0x7d0ba0bc,0x26c7a0bd,0xf74a00fe}},	//   ruba, _jigs, hino_, _قلبي_, 
   {{0x26c7a0be,0x6d4e20bf,0x7c29a0c0,0x387d843a}},	// [10c0] kino_, suba, iber, ddwr_, 
   {{0x442920c1,0x7c29a0c2,0x96fa00fe,0x26c7a0c3}},	//   aba_, hber, _تعبر_, jino_, 
   {{0x442920c4,0xf8c6186b,0xa3de800d,0x644b20c5}},	//   bba_, _लगाय, _दुई_, ógic, 
   {{0x64a620c6,0x7e7aa0c7,0x44291813,0xd308812f}},	//   _рама, _satp, cba_, _hệt_, 
   {{0xdfcf830b,0x7c29a0c8,0xddc3a0c9,0xd348003d}},	//   ييم_, dber, venš, _سیاه_, 
   {{0x26c7a0ca,0x656880bf,0x3ce6806d,0xb87b0063}},	//   gino_, _ppdh, _skov_, llít, 
   {{0xceb30052,0x3cde9989,0x628e20cb,0x127b00c6}},	//   שיו_, खवले_, _inbo, _קאלע, 
   {{0x98a38b29,0x7d0b8265,0xb4be947a,0x5c749c39}},	//   _кисе, _cigs, ुचे_, улит, 
   {{0x26c7a0cc,0xaf069f08,0x2d85a0cd,0x6ef200c0}},	//   bino_, _апал, _erle_, væbn, 
   {{0x26c7a0ce,0xc3330039,0x442920cf,0x60c40050}},	//   cino_, סות_, zba_, _amim, 
   {{0x7c29a0d0,0x44291e36,0x403520d1,0x2d858183}},	//   bber, yba_, ленс, _grle_, 
   {{0x30a720d2,0x4429008b,0x9346a0d3,0x6abf03ff}},	//   тров, xba_, _анде, _एग्र, 
   {{0x2d8c0e87,0x58d420d4,0x442920d5,0xbfa282a5}},	//   åden_, роят, vba_, _çêdi, 
   {{0x41dd9108,0xddda8116,0x6e388610,0x60c4012c}},	//   _नुकस, _natū, navb, _emim, 
   {{0x555820d6,0x26cd05c3,0x7b0920d7,0xd308812f}},	//   каря_, đeo_, _džul, _dệt_, 
   {{0x78a0a0d8,0x629a8259,0x628e20d9,0x442920da}},	//   _nomv, ljto, _anbo, uba_, 
   {{0x09bd06df,0x1be3032d,0x93f520db,0x6d4a81ed}},	// [10d0] ्प्य, _कुशल_, упац, hrfa, 
   {{0xf1a720dc,0x26c78065,0x442920dd,0x3d9520de}},	//   крен, xino_, sba_, _биор, 
   {{0x26c7a0df,0xd01193fb,0x81e480b2,0x25a50172}},	//   vino_, ملا_, পের_, älld_, 
   {{0x673b1041,0xf1c30116,0x7fd5a0e0,0x26c7a0e1}},	//   šuju, _rašė_, лілі, wino_, 
   {{0x7c2982a5,0x78a08a07,0xb4c1071c,0x3ea10079}},	//   vber, _domv, ्ची_, _koht_, 
   {{0x644284e0,0x7d0b8c20,0x4df5a0e2,0x7c29a0e3}},	//   _adoi, _sigs, ляйт, wber, 
   {{0x26c7a0e4,0x925820e5,0x7d0b949b,0x3ceda0e6}},	//   rino_, _шарт_, _pigs, tlev_, 
   {{0x7eb4855a,0xf7739435,0xff5f0093,0xb87b0a5e}},	//   _ràpe, _پار_, ktî_, ilís, 
   {{0x26c7a0e7,0x1309a0e8,0x81e800b2,0xdce500f3}},	//   pino_, нний_, মেদ_, _arhī, 
   {{0xd7f8a0e9,0x3cff81df,0x3ceda0ea,0x6b6701a8}},	//   _рус_, smuv_, slev_, mīgā, 
   {{0xa0a620eb,0x2455806f,0xb87b0ca1,0x68fba0ec}},	//   ганд, _مناس, roín, _khud, 
   {{0xff5f01b2,0xc32400b2,0x5fc502f4,0xd3088279}},	//   ftî_, _পিসি_, _लेहल, _sệt_, 
   {{0x7ae5044f,0x4c9a8eee,0x2a7c855a,0x27ed817c}},	//   koht, _רבנו, _favb_, _jyen_, 
   {{0x1bb888f7,0x99858063,0x290d80bc,0x7ae5019b}},	//   _جامع_, _ملتو, _liea_, joht, 
   {{0xdefa00b6,0x27ed8206,0x270f80c3,0xc8798214}},	//   дың_, _lyen_, ादुर_, _ekşi_, 
   {{0xeb9a172e,0x7b090885,0x60c420ed,0x27ed8149}},	//   ниб_, _džum, _umim, _oyen_, 
   {{0x63bba0ee,0x2f1986e0,0x8b260116,0x27eda0ef}},	// [10e0] nzun, _nèg_, удзе, _nyen_, 
   {{0xfeba007b,0xb87b0170,0x68e9a0f0,0x63bba0f1}},	//   _ساخت_, slít, _aked, izun, 
   {{0x35a6004c,0x673b007e,0x6724061c,0x27ed86e4}},	//   _санг, šujt, _htij, _ayen_, 
   {{0xd7faa0f2,0x270f807a,0x25a51c9b,0x68fba0f3}},	//   нул_, ादूर_, älle_, _chud, 
   {{0xe3b220f4,0x7e7e20f5,0xbea68448,0xde5881e2}},	//   _طرح_, _kapp, ладк, валі_, 
   {{0x7e7e0208,0x24800b75,0xddc718d4,0xf12400dd}},	//   _japp, ldim_, lejš, _نظری, 
   {{0x7e7e20f6,0x7b0917fc,0xccf8801b,0x217520f7}},	//   _mapp, _ožuj, _opět_, _кутр, 
   {{0xddc720f8,0x248020f9,0x26ca20fa,0x3a3a20fb}},	//   nejš, ndim_, hibo_, lapp_, 
   {{0xa3de8611,0x63a9a0fc,0x26ca20fd,0x1bd48aad}},	//   _दुख_, gyen, kibo_, ропя, 
   {{0xafe48004,0x7e7e20fe,0x5a3482df,0x9e658139}},	//   _боғл, _napp, шнот, _نامن, 
   {{0xddc89041,0xbfa2824a,0xd917819b,0x39138d29}},	//   _hadž, _çêbi, лья_, ймэр, 
   {{0x657a868e,0x7e7e20ff,0x61ee03df,0x2cad8039}},	//   _isth, _aapp, _mybl, cked_, 
   {{0xa3e401a2,0x7e7e02fa,0xdb0419f5,0x248002a1}},	//   _पुल_, _bapp, nzió, ddim_, 
   {{0xff5f02a5,0x4b7b80c6,0x7e7e2100,0xddc8a101}},	//   rtî_, _נאוו, _capp, _madž, 
   {{0xff5f059e,0x7e7e2102,0xccfb04c7,0x61ee0341}},	//   stî_, _dapp, ећа_, _nybl, 
   {{0xb4c1036c,0x64562103,0x38c90068,0x61f5a104}},	//   ्चे_, ggyi, _جاتی_, üzle, 
   {{0x36d5036d,0x5a352105,0xddc880d7,0x92590077}},	// [10f0] _вопр, инат, _nadž, каат_, 
   {{0x26ca2106,0x2f198246,0xccf8801b,0x68e9a107}},	//   cibo_, _règ_, _zpět_, _sked, 
   {{0xdd95005a,0x657a822a,0x4975004a,0x386901bb}},	//   _таны, _nsth, рлес, _kbar_, 
   {{0xf7718629,0x7e7e2108,0xddc72109,0x4bc5210a}},	//   قات_, _zapp, cejš, _көзг, 
   {{0x443b008c,0x69dc07d6,0x2ab6066b,0x3869210b}},	//   maq_, _exre, _sæbe_, _mbar_, 
   {{0x443b210c,0x3a298269,0x6b6700f3,0x171c00c6}},	//   laq_, _đapo_, rīgā, עווע, 
   {{0x7d0f0068,0x5e5800c6,0x4035a10d,0x290d84e2}},	//   _kics, טיגע_, _вебс, _tiea_, 
   {{0x0b45a10e,0x63bba10f,0x443b008a,0x58d580f0}},	//   анин, tzun, naq_, _тобт, 
   {{0x3f8901df,0x2cada110,0x60cba111,0x7c2d2112}},	//   _nrau_, rked_, migm, ibar, 
   {{0x4e7887db,0x2cada113,0x7c2d0004,0x52a9a114}},	//   _محمد_, sked_, hbar, твом_, 
   {{0x63a9a115,0x67242116,0x7c2d2117,0xe8fa2118}},	//   syen, _stij, kbar, кло_, 
   {{0x254101e2,0xa3b51137,0x7e7e2119,0x764500db}},	//   dėl_, जना_, _sapp, _adhy, 
   {{0x442da11a,0x7e7e211b,0xddc7211c,0x26ca211d}},	//   mbe_, _papp, vejš, tibo_, 
   {{0x7c3b98bb,0x442da11e,0xf30681b2,0x387fa11f}},	//   laur, lbe_, şûrê_, _laur_, 
   {{0xceb28c2d,0x3f89002d,0x3cfd81c8,0x3c420019}},	//   חים_, _erau_, _khwv_, _lévő_, 
   {{0x442d8246,0x3f890392,0x14262120,0xed570077}},	//   nbe_, _frau_, рдам, јот_, 
   {{0x3f892121,0x24802122,0x032308f9,0x7e7e2123}},	// [1100] _grau_, rdim_, ждун, _tapp, 
   {{0x236000fa,0x7c3b8010,0x6b842124,0x6281a125}},	//   rtij_, haur, rvig, ndlo, 
   {{0x6e3c0072,0x6aa39fa2,0x7c2d2126,0x7c3ba127}},	//   marb, _monf, bbar, kaur, 
   {{0x443b008c,0x442da128,0x2480053a,0x6e3c2129}},	//   caq_, jbe_, qdim_, larb, 
   {{0x7d04212a,0x442d8f4e,0x6fd680fe,0x7ccd80f3}},	//   mmis, dbe_, جزائ, _mērķ, 
   {{0x4420212b,0x7d04212c,0x6b8b0142,0x442da12d}},	//   lci_, lmis, ægge, ebe_, 
   {{0x40969309,0x6143212e,0x38568086,0xb5a38741}},	//   _крат, _мера, _възс, жрый, 
   {{0x8fa68002,0x387f8124,0x3cfd822a,0x78a4031e}},	//   _кабе, _gaur_, _chwv_, _noiv, 
   {{0x7d04212f,0x6aa3a130,0x4425008a,0x3d1680a1}},	//   imis, _bonf, _əl_, _पूरे_, 
   {{0x29182131,0xfaa6a132,0xf1eb0439,0x2ee78097}},	//   _kura_, ршин, _जुड़_, conf_, 
   {{0x6e3c2133,0x442da134,0x81e800cf,0x44202135}},	//   darb, bbe_, মের_, kci_, 
   {{0x3866a136,0x29182137,0x7c2d2138,0xd5778039}},	//   nfor_, _mura_, xbar, _כתבה_, 
   {{0x291801bb,0x7d040079,0x442018d4,0x78a400ef}},	//   _lura_, dmis, dci_, _doiv, 
   {{0x44200066,0xa1588db1,0x6e3c2139,0x7d04213a}},	//   eci_, _баку_, garb, emis, 
   {{0xd6d81ae0,0x7c22a13b,0x443b02d1,0x7d0f213c}},	//   ртя_, _kfor, taq_, _pics, 
   {{0x7d04213d,0x44220149,0xb0350251,0x7c2d213e}},	//   gmis, _cfk_, _униш, ubar, 
   {{0x7c2d213f,0x443b2140,0x68ed2141,0x8afd800d}},	// [1110] rbar, raq_, _ikad, stře, 
   {{0x442da142,0x7c2d2143,0x19ab13c9,0x387f8385}},	//   zbe_, sbar, ктеп_, _saur_, 
   {{0x29182144,0xa2d813d2,0x7c228524,0x443b072f}},	//   _cura_, _मदर्, _ofor, paq_, 
   {{0x44202145,0x386987a2,0x7c9500fe,0x9b6b0103}},	//   cci_, ýar_, _الحص, _ишга_, 
   {{0x3cf405d9,0x291813e0,0x44392146,0x2b440a1c}},	//   ंतरे_, _eura_, _ies_, _мэрг, 
   {{0x44392147,0x7cd3802d,0x63ad2148,0x7d078019}},	//   _hes_, mări, myan, _éjsz, 
   {{0x44392149,0x20d20038,0x63ad214a,0x27fa80a1}},	//   _kes_, lšie_, lyan, ępna_, 
   {{0xec798e48,0x442d81ed,0x9c5986f1,0x3cfd827e}},	//   упи_, ube_, ушку_, _qhwv_, 
   {{0x6e3c214b,0x7c220530,0x60db804f,0x6d55214c}},	//   yarb, ñori, _ijum, huza, 
   {{0x4439214d,0x7c3ba14e,0x442da14f,0x2b4d80a6}},	//   _les_, saur, sbe_, rrec_, 
   {{0x7c228324,0x44390324,0x63ad090b,0x6d41829f}},	//   _ffor, _oes_, hyan, _uvla, 
   {{0x44392150,0x63ad2151,0x6d550065,0x3494a152}},	//   _nes_, kyan, duza, _махр, 
   {{0xef198066,0x20d20038,0x442006f4,0x6e3c2153}},	//   _już_, jšie_, vci_, tarb, 
   {{0xed5a2154,0x63ad1134,0x249fa155,0x68ed2156}},	//   лог_, dyan, ljum_, _ekad, 
   {{0x3ea581e5,0x7d040073,0x78a4036d,0x44392157}},	//   _molt_, tmis, _toiv, _bes_, 
   {{0x44392158,0x25a500f9,0x6e3c2159,0x3a38215a}},	//   _ces_, älla_, sarb, _serp_, 
   {{0x4439215b,0x4420215c,0x7e750fb9,0x64a30f70}},	// [1120] _des_, rci_, bezp, чата, 
   {{0x4420215d,0x3f8f0077,0x7c39824a,0x4439215e}},	//   sci_, _água_, _lewr, _ees_, 
   {{0xc6930052,0x4439215f,0x290001df,0x8fc5003d}},	//   _זאת_, _fes_, _khia_, _هزین, 
   {{0x7c39a160,0x92d800cf,0x291204da,0xa14b0068}},	//   _newr, াতে_, _jiya_, اسلے_, 
   {{0x26c8805a,0x38668a76,0x63ad2161,0x80ca80b2}},	//   аған_, rfor_, cyan, িকল্, 
   {{0x7c22a162,0x2912007b,0x44392163,0xdee38715}},	//   _sfor, _liya_, _zes_, почи, 
   {{0x0586a164,0x11da00fe,0x29120684,0x237d80f6}},	//   сулм, _صورة_, _oiya_, _aswj_, 
   {{0x0cb880cf,0x291204f0,0x3ce08131,0x4439006c}},	//   ুক্ত, _niya_, čivo_, _xes_, 
   {{0x7c399cac,0xdfcf8013,0x64a6a165,0x99858162}},	//   _dewr, _كيف_, _қада, kalų_, 
   {{0x25618068,0x68ed0926,0x9e66803d,0x2900040a}},	//   ból_, _skad, _دارن, _ahia_, 
   {{0xf09f00a6,0x76488324,0x7cd38123,0x63ad2166}},	//   tjà_, _iddy, zări, zyan, 
   {{0x29000028,0x7c22872c,0x63ad2167,0x7c39a168}},	//   _chia_, _ufor, yyan, _gewr, 
   {{0x29002169,0x7d1a8109,0x29120093,0x33f693fb}},	//   _dhia_, _huts, _diya_, _اساس, 
   {{0x4439216a,0x7d1a9cf7,0x20d201ac,0x6d55216b}},	//   _ses_, _kuts, všie_, tuza, 
   {{0x7cfe816c,0x2ca682f4,0xa49b055a,0x6e3aa16c}},	//   përd, _kood_, _biòp, _metb, 
   {{0x4439216d,0x63ad216e,0x6ca4216f,0x6d552170}},	//   _qes_, tyan, пруж, ruza, 
   {{0x44392171,0xab87009f,0x7d1aa172,0x7b1416c0}},	// [1130] _ves_, щувк, _luts, здух, 
   {{0x2d8ca173,0x63ad0579,0x44392174,0x20d200e9}},	//   _orde_, ryan, _wes_, ršie_, 
   {{0x44392175,0x63ad2176,0x7d1aa177,0xb5f2004a}},	//   _tes_, syan, _nuts, _жүрі, 
   {{0x76488324,0x20d201ac,0x4395009f,0x515b83dd}},	//   _addy, pšie_, _дамс, רכאו, 
   {{0xf7458123,0x291e011e,0x63ad00bf,0x2d8c93c5}},	//   цело, _étan_, qyan, _arde_, 
   {{0x25618068,0x7d1a82a6,0x6b8d9190,0xa3d60ab3}},	//   tól_, _buts, _šago, िपर_, 
   {{0x3ea5811d,0x79a4004a,0x629500bb,0x2ca6a00a}},	//   _volt_, _ерте, _inzo, _bood_, 
   {{0xc325a178,0x25618068,0x60dba179,0x0325a17a}},	//   омик, ról_, _ujum, один, 
   {{0x2ca6a17b,0x2912024a,0x7b090269,0x249f807f}},	//   _dood_, _riya_, _džuv, rjum_, 
   {{0x6285217c,0x291204f0,0x7d1aa17d,0x02c5836a}},	//   ndho, _siya_, _futs, ійно, 
   {{0xe0da0605,0x2169a17e,0x7d1aa17f,0xd4e7836a}},	//   иво_, шини_, _guts, _люди, 
   {{0x2ca68052,0x29001123,0x3f8d816c,0xd00a2180}},	//   _good_, _qhia_, _kreu_, иене_, 
   {{0x443fa181,0x332b93d3,0x2bd08079,0x6d43a182}},	//   mau_, _сцен_, _तइया, lsna, 
   {{0x443fa183,0x645ba184,0x6729a185,0x6b89a186}},	//   lau_, lgui, _mtej, mveg, 
   {{0x29002187,0x29122188,0x2d8c2189,0x6b89a18a}},	//   _thia_, _tiya_, íde_, lveg, 
   {{0x443fa18b,0x6283852a,0xed5a0974,0x628511e9}},	//   nau_, _hano, лоҳ_, edho, 
   {{0x42ca0bd7,0x5aca1718,0x6b89a18c,0x6283a18d}},	// [1140] аган_, алам_, nveg, _kano, 
   {{0x386d8354,0x443fa18e,0x2ca01a73,0x6283a18f}},	//   _aber_, hau_, sjid_, _jano, 
   {{0x443fa190,0xdca6067f,0x64a62191,0xb05b0172}},	//   kau_, _дани, _дана, miär, 
   {{0x186aa192,0x443fa193,0xa06aa194,0x7d1aa195}},	//   ради_, jau_, рада_, _ruts, 
   {{0x443fa196,0x27e0a197,0x44322198,0x3f8da199}},	//   dau_, çin_, mby_, _creu_, 
   {{0x6283a19a,0x7d1aa19b,0x4432219c,0x29068109}},	//   _nano, _puts, lby_, smoa_, 
   {{0x68eb91bf,0x0163219d,0x443f811a,0x6d43a19e}},	//   bogd, _окро, fau_, gsna, 
   {{0xa3ae0808,0x443f8324,0x5c98809f,0x2005008a}},	//   _कथा_, gau_, ския_, əlif_, 
   {{0x3f8da19f,0xae7a836d,0x6283a1a0,0xac92804a}},	//   _greu_, _всех_, _bano, зақш, 
   {{0x62839725,0x78a285c8,0x7d1aa1a1,0x645b90e1}},	//   _cano, ljov, _tuts, agui, 
   {{0x443fa1a2,0xe29a810b,0x69c121a3,0x38600097}},	//   bau_, _chưa_, _žlez, _bcir_, 
   {{0x78a2a1a4,0x6d58a1a5,0x628384e2,0xbb1b0093}},	//   njov, muva, _eano, _krît, 
   {{0x6283a1a6,0x6440a1a7,0x443221a8,0x6d58841a}},	//   _fano, mami, dby_, luva, 
   {{0x6283a1a9,0x3ce9808d,0x2bd08056,0x7c2621aa}},	//   _gano, čave_, _तेया, _afkr, 
   {{0xa3d021ab,0xeca709d9,0x7d029455,0x9c8301d2}},	//   _वेब_, ојан, _khos, íčov, 
   {{0xd49821ac,0x44321be7,0x6aaa01ed,0x19bb8039}},	//   ору_, gby_, öffn, _כמוב, 
   {{0x6283a1ad,0x7cd38166,0xdfd101be,0x26cca1ae}},	// [1150] _yano, căru, _سيد_, _omdo_, 
   {{0x291ca1af,0x6440a1b0,0x6d58a1b1,0x4424801c}},	//   _kuva_, hami, kuva, hcm_, 
   {{0x443221b2,0xceb2096e,0x6440a1b3,0x6729800d}},	//   bby_, _ניט_, kami, _stej, 
   {{0x5d7a00c6,0x3f8d80a6,0x26d121b4,0x6d58a1b5}},	//   _פארק, _preu_, lizo_, duva, 
   {{0x6440a1b6,0x443f8116,0x291ca1b7,0x7b640e05}},	//   dami, vau_, _luva_, _отре, 
   {{0x8af00816,0x6d43a1b8,0x442680de,0x443fa1b9}},	//   stər, tsna, _afo_, wau_, 
   {{0x443fa1ba,0x628380de,0x7c3d21ae,0x60cd21bb}},	//   tau_, _rano, _kesr, _omam, 
   {{0x6440a1bc,0x6283a1bd,0x6d43a1be,0x3f8da1bf}},	//   gami, _sano, rsna, _treu_, 
   {{0x443f8360,0x6d43a1c0,0x7c3d21c1,0x38a200a1}},	//   rau_, ssna, _mesr, _góry_, 
   {{0x443fa1c2,0x78a98622,0x60cd21c3,0x628383ad}},	//   sau_, _hoev, _amam, _qano, 
   {{0x443221c4,0x6283a1c5,0x443fa1c6,0x7d028089}},	//   yby_, _vano, pau_, _fhos, 
   {{0x6283a1c7,0x291c8bbe,0xe1f880a6,0x44248ca2}},	//   _wano, _duva_, өгө_, ccm_, 
   {{0x7d09a1c8,0x69c18068,0x6283a1c9,0x4432003e}},	//   mmes, szle, _tano, vby_, 
   {{0x7d09a1ca,0x78bb85cb,0x443d824a,0x26d1083d}},	//   lmes, _lluv, _hew_, gizo_, 
   {{0xde0321cb,0x4432026b,0x443d8401,0x6da621cc}},	//   епри, tby_, _kew_, чива, 
   {{0xdca321cd,0x7d098214,0x032621ce,0x61fc8214}},	//   наси, nmes, здан, ürle, 
   {{0x443221cf,0xeb9721d0,0x26d1020d,0x6d4101fb}},	// [1160] rby_, пит_, bizo_, álar, 
   {{0x443221d1,0x443da1d2,0x09e60b29,0xb87b21d3}},	//   sby_, _lew_, позн, gníf, 
   {{0x6440a1d4,0x7d09a1d5,0x78a28149,0x7cfe89b8}},	//   yami, kmes, tjov, hëra, 
   {{0x443d804d,0xd12f07db,0x6e3e02ef,0x6440a1d6}},	//   _new_, امن_, _hepb, xami, 
   {{0x6440a1d7,0x8af0008a,0x2cbf80ed,0x7d09a1d8}},	//   vami, stəq, dhud_, dmes, 
   {{0x6d58a1d9,0xab270574,0x6440a1da,0xd9460188}},	//   tuva, _хора_, wami, _неги, 
   {{0x7d02a1db,0xda788038,0x6440a1dc,0x20569ad9}},	//   _phos, veď_, tami, _нтар, 
   {{0x6d58a1dd,0x443d80db,0x78bba1de,0x20558188}},	//   ruva, _cew_, _gluv, _отур, 
   {{0x6440a1df,0xe737836d,0x6d58a1e0,0x291c9bcd}},	//   rami, _нет_, suva, _suva_, 
   {{0xc333004d,0xbebb09b8,0x6d589615,0x7d028309}},	//   עות_, hpër, puva, _whos, 
   {{0x7d02a1e1,0x2eeea1e2,0x443d8039,0x7afd8093}},	//   _thos, moff_, _few_, îsta, 
   {{0x443da1e3,0xdfd50116,0xf8bf01d2,0x38bb09b8}},	//   _gew_, домы, uhé_, _bëra_, 
   {{0x26d1022d,0xb8e501cc,0x2d8c00c0,0xdcb1012f}},	//   tizo_, _एत_, æden_, ểm_, 
   {{0xba178013,0x2eeea1e4,0x7bc421e5,0x6b828191}},	//   _فيها_, noff_, dziu, _isog, 
   {{0x443da1e6,0xdd9421e7,0x26d121e8,0x35e400f0}},	//   _yew_, нары, rizo_, ецтв, 
   {{0x6aaaa1e9,0x60cd21ea,0x443d8610,0x26d121eb}},	//   _hoff, _umam, _xew_, sizo_, 
   {{0x6aaaa1ec,0x2bc70cca,0x5b1504bc,0xe8030353}},	// [1170] _koff, _रेखा, дмат, रेखा_, 
   {{0x7b090259,0x6aaaa1ed,0x6d488252,0x6288a1ee}},	//   _ažur, _joff, _ovda, nddo, 
   {{0x2d8c0088,0x6aaaa1ef,0xe139004a,0x7d09a1f0}},	//   ådet_, _moff, ізді_, ymes, 
   {{0x92bf00b2,0x6d5519ff,0x98a60166,0x315783f3}},	//   ুকে_, mrza, mplă_, ליבן_, 
   {{0x24890318,0x7b090269,0x629883c5,0x443d8c50}},	//   mdam_, _džur, _onvo, _rew_, 
   {{0x443d81bb,0x248921f1,0x6b8d01d7,0x672d0ca2}},	//   _sew_, ldam_, mvag, _mtaj, 
   {{0xa3b50066,0x58d5836a,0x78a982b5,0x236921f2}},	//   जनक_, _жовт, _toev, ltaj_, 
   {{0xe3b9a1f3,0xb87b011e,0x6add0353,0x628721f4}},	//   жби_, alíz, _मदुर, _hajo, 
   {{0xa3e78938,0x236921f5,0xf770803f,0x7d09a1f6}},	//   _मुख_, ntaj_, _مال_, rmes, 
   {{0x88bd000d,0x443da1f7,0xeab180fe,0x25e88787}},	//   zpět, _wew_, ئعة_, _चुकी_, 
   {{0x7643a1f8,0x443d9cac,0x41b495fd,0x672d21f9}},	//   many, _tew_, есят, _ataj, 
   {{0x6298a1fa,0x6d550043,0x628721fb,0x7643a1fc}},	//   _envo, drza, _lajo, lany, 
   {{0xa49b010b,0x7d1e0024,0x6d55085a,0xd7ea02c3}},	//   _phòn, _sups, erza, імге_, 
   {{0x7643a1fd,0x62870b8c,0x6aaaa1fe,0xe299802d}},	//   nany, _najo, _goff, _фак_, 
   {{0x672d21ff,0x9fa02200,0xd5751875,0x23691981}},	//   _etaj, _méér_, нуть, etaj_, 
   {{0x7643a201,0xc10600fe,0x38bb09b8,0x7bc402fe}},	//   hany, _توبي, _tëra_, tziu, 
   {{0x52aa2202,0x76439304,0x248601ac,0xd5b800f3}},	// [1180] овам_, kany, ľom_, šā_, 
   {{0x62872203,0x764392ec,0x290483ad,0x0f570309}},	//   _cajo, jany, _shma_, _קיים_, 
   {{0x7643a204,0x673b803d,0x7e7c2205,0x5e9b0309}},	//   dany, _awuj, merp, _וביק, 
   {{0x6d5c2206,0xbfa282a5,0x6aaa9d89,0x628709ec}},	//   mura, _çêki, _चक्र, _eajo, 
   {{0x7643a207,0x6d5c1734,0x62888360,0xb906a208}},	//   fany, lura, yddo, _पद_, 
   {{0x395a2209,0x76439bfe,0x3ced0524,0x6700220a}},	//   pups_, gany, čeve_, ोगिक_, 
   {{0x6d5c220b,0xf983220c,0x6aaaa20d,0x998780ce}},	//   nura, _игро, _roff, _menų_, 
   {{0x2ebb08bd,0x6aaaa20e,0x2eee8766,0x7e7c220f}},	//   _उत्त, _soff, soff_, herp, 
   {{0x7643a210,0xda7a8495,0x7eb48a1c,0x60c28733}},	//   bany, оян_, _làpi, mhom, 
   {{0x3ce9803a,0xd250807b,0x7643829a,0x60c2a211}},	//   čava_, دند_, cany, lhom, 
   {{0x28f90612,0x62888324,0x64442212,0x7e7c2213}},	//   зень_, rddo, kaii, derp, 
   {{0x6d5c2214,0x236900a1,0x67208ca2,0x7cfe816c}},	//   dura, ytaj_, _kumj, mëro, 
   {{0x6aaaa215,0x6f1700db,0xfc3f0149,0x60dd2216}},	//   _toff, _pixc, _reí_, rnsm, 
   {{0x6d5c0010,0x6298a217,0x7e7c2218,0x6d472219}},	//   fura, _unvo, gerp, tsja, 
   {{0x6287221a,0x60c29d1e,0x7eb4855a,0xa49b0064}},	//   _rajo, khom, _càpi, _fhòl, 
   {{0x7643a21b,0x6d47221c,0x6287221d,0xb4fb221e}},	//   zany, rsja, _sajo, ्षेप_, 
   {{0x2489221f,0x7643a220,0x2d9e02ae,0x2d8c072c}},	// [1190] rdam_, yany, äter_, åder_, 
   {{0x6d5c2220,0x23692221,0x9af500fe,0x78ad06a8}},	//   bura, rtaj_, ركات, _hoav, 
   {{0x23692222,0x7643a223,0x6d5c2224,0x6b8d2225}},	//   staj_, vany, cura, svag, 
   {{0x2bd02226,0x7643a227,0xe80c2228,0xe0df01e9}},	//   _सेवा, wany, सेवा_, nnò_, 
   {{0x7d0d2229,0x7643a22a,0xf388801c,0x6287222b}},	//   mmas, tany, _nợ_, _tajo, 
   {{0x7d0d222c,0x4429222d,0xddde222e,0x6605a22f}},	//   lmas, lca_, _hapš, нпла, 
   {{0x7643a230,0x3f8480f3,0x44292231,0x4923004c}},	//   rany, _esmu_, oca_, _рӯзҳ, 
   {{0x7d0d2232,0x7643a233,0x60c2a234,0xb385a235}},	//   nmas, sany, chom, елил, 
   {{0x7643a236,0x7cfe80f8,0x7d0d2237,0xfe758077}},	//   pany, përn, imas, _плаќ, 
   {{0x3eac8060,0x1306836d,0x6d5c2238,0xde97806f}},	//   _godt_, нный_, yura, _تجرب, 
   {{0xe4a7a239,0xd12e8182,0x4429223a,0x98bf0116}},	//   _ордо, یمی_, kca_, nutė_, 
   {{0x7641811d,0xf9920273,0xb4e9000d,0x7eb480a6}},	//   _hely, ארט_, मको_, _ràpi, 
   {{0xeb999b08,0x4429223b,0x42cd80b2,0x6d5c223c}},	//   _хил_, dca_, রকৌশ, wura, 
   {{0x91e5923d,0x09e5a23d,0x6d5c223e,0xa3d0223f}},	//   _поле, _полн, tura, _वेष_, 
   {{0x7641a240,0x44292241,0xa3d38353,0x998580d8}},	//   _mely, fca_, _हेत_, _ألبو, 
   {{0x44292242,0x442b2243,0x7d0d2244,0x78ad01cb}},	//   gca_, _cfc_, gmas, _goav, 
   {{0x42562245,0x6d5c2246,0x245a82d2,0x6b890105}},	// [11a0] етет, sura, lümü_, _šegr, 
   {{0x44292247,0x160f89af,0xb05b2248,0x7d0d2249}},	//   aca_, ाधार_, nhän, amas, 
   {{0x60c2a24a,0x6d5c224b,0x8c460f6c,0x2726001c}},	//   thom, qura, _пене, _hôn_, 
   {{0x4429224c,0x70f680fe,0x7eb00079,0x53a6224d}},	//   cca_, رسائ, _täps, _замб, 
   {{0xb87b001b,0x20d2007e,0xa2b4801b,0x74160063}},	//   lníc, jšim_, ेसम्, _سوسا, 
   {{0x7cfe80f8,0x60c28504,0x2726224e,0x7c2ba24f}},	//   tëro, shom, _môn_, _afgr, 
   {{0x91e61de0,0xf388801c,0x629c2250,0x27262251}},	//   _чове, _sợ_, _inro, _lôn_, 
   {{0x7ae38a63,0x75218685,0x7c29875d,0xd3a68988}},	//   _ajnt, _dulz, gcer, ероп, 
   {{0xdcfa8123,0xa343855a,0x2b438a1c,0x63a42252}},	//   _astă, лээл, лээг, nxin, 
   {{0x44292253,0xf3888028,0x7641a254,0x7d0d17f8}},	//   zca_, _vợ_, _gely, zmas, 
   {{0x7cfe80f8,0x6d1f0439,0x1dcf010c,0x44292255}},	//   qëro, _मूंग_, _हेंत, yca_, 
   {{0xb87b003e,0x8d559691,0x7c29a256,0x254c81d2}},	//   dníc, _штуч, ccer, měl_, 
   {{0xe29aa257,0xe80c05d9,0xb05b01ed,0x78ad01cb}},	//   _над_, सेला_, bhän, _voav, 
   {{0x442900a1,0x68e401ce,0x6f1d8036,0x64429a6e}},	//   wca_, _ejid, _èsce, _heoi, 
   {{0x6f1aa258,0x7d0d1757,0x44292259,0x212d01d2}},	//   _mitc, tmas, tca_, _čeho_, 
   {{0xdc880aad,0x6f1a8531,0x4429225a,0xccf810f3}},	//   нсул_, _litc, uca_, ећу_, 
   {{0x4429225b,0x7d0d17bc,0x98bf002d,0x6d589199}},	// [11b0] rca_, rmas, astă_, hrva, 
   {{0xa3d00365,0xb5f3005a,0xb87b0410,0x68fd225c}},	//   _वेळ_, _бүгі, bníc, llsd, 
   {{0x395e80a6,0x7641a25d,0x442b225e,0xd99900fe}},	//   nuts_, _rely, _tfc_, بنات_, 
   {{0x7641a25f,0x628aa260,0x5fd28079,0xe2730188}},	//   _sely, _lafo, _देहल, _өкмө, 
   {{0x16738004,0x1e73804a,0x81bc81a8,0x2726012f}},	//   лқар, лғас, ucēj, _xôn_, 
   {{0x7521a261,0x20d20524,0x69d5009b,0xf6538068}},	//   _pulz, všim_, _येथी, ائش_, 
   {{0xada5a262,0x35a5a263,0x644280fe,0x6d4aa264}},	//   тайл, тайг, _beoi, gsfa, 
   {{0xeb99a265,0xe7d2a266,0x644280d8,0x3ce987ad}},	//   дии_, _देवप, _ceoi, čavo_, 
   {{0x0b4295e6,0xb87b026b,0x26c103b8,0x628aa267}},	//   анын, zníc, _olho_, _bafo, 
   {{0x68f62268,0x29092269,0x628a811a,0x7eb01610}},	//   _skyd, _ahaa_, _cafo, _näpp, 
   {{0xd5bb8004,0x09e58c55,0x395e8741,0x91e5a26a}},	//   _эса_, тонн, guts_, тоне, 
   {{0x2d98852f,0xb87b027b,0x6442a26b,0xe3b0815e}},	//   _área_, vníc, _geoi, _گرم_, 
   {{0xb05b00f9,0xb90a0439,0x773a0253,0xbb1b0610}},	//   mhäl, _मद_, ьянс_, _asîm, 
   {{0xb87b003e,0x395e881e,0x798200a1,0x628a811a}},	//   tníc, buts_, łowi, _gafo, 
   {{0xe643226c,0xbea309d9,0x26c100e9,0x200400e9}},	//   респ, шарк, _dlho_, ťmi_, 
   {{0x248da26d,0xb87b026b,0x2726001c,0x98bf0166}},	//   ndem_, rníc, _tôn_, rstă_, 
   {{0x46ea0bc6,0x142304bc,0xb87b0170,0x2c070a64}},	// [11c0] _один_, рдум, sníc, _शरणं_, 
   {{0x86b3005a,0x63a4226e,0x1d2602bb,0x63a6810d}},	//   _кәсі, rxin, _имом, äkni, 
   {{0x26d8226f,0x6724019b,0xc96606f1,0xae570309}},	//   miro_, _huij, твей, _בסיס_, 
   {{0x799500a1,0x26d82270,0x38cb8aa8,0xd7fa87e4}},	//   _drzw, liro_, وانی_, мул_, 
   {{0x6d5a0116,0xf0930080,0xe7d28076,0x23d08034}},	//   štad, ינא_, _देशप, _तेंद, 
   {{0x26d8040e,0x248d81bb,0x6d4a84a5,0x6d588170}},	//   niro_, edem_, tsfa, trva, 
   {{0xe9a32271,0x71a30fbe,0x4095864e,0x628aa272}},	//   _карп, _карз, _өртт, _rafo, 
   {{0x7cfe80f8,0x26d800bb,0xb8668267,0x628aa273}},	//   përm, hiro_, _جاسو, _safo, 
   {{0x2c6d0019,0x2004805d,0x26d82274,0xc4d30039}},	//   lódó_, _uzmi_, kiro_, יגה_, 
   {{0xbe858743,0x395ea275,0x2480060a,0x69c882ae}},	//   _مجمو, tuts_, heim_, tzde, 
   {{0x9f4f007f,0x26d82276,0x6442a277,0x628a83ad}},	//   _ágú_, diro_, _teoi, _vafo, 
   {{0x26d82278,0xe3baa279,0x9f35004a,0x68e2843a}},	//   eiro_, _обе_, лемі, nnod, 
   {{0x35a8800f,0x26d810e1,0x26c1022a,0x628aa27a}},	//   _कपड़, firo_, _plho_, _tafo, 
   {{0xbc1b8039,0x26d8227b,0x6b84227c,0x290f83ad}},	//   _חודש, giro_, dwig, zmga_, 
   {{0x1df81878,0x91070103,0x09070a53,0x2ca902f4}},	//   веры_, _ичид, _ичим, tjad_, 
   {{0x20d20bfc,0x545407c5,0xa3d681cc,0xba178309}},	//   jših_, ивст, _सधा_, _בחוץ_, 
   {{0x3a75227d,0x68e2803e,0xc2990e61,0x26d8227e}},	// [11d0] ллар, dnod, нках_, biro_, 
   {{0x26d8029a,0x5a34217a,0x3f890269,0x78bd227f}},	//   ciro_, инут, _isau_, lksv, 
   {{0x68e382ba,0x68e28324,0xceb204fc,0x7bc98341}},	//   éndo, fnod, _היי_, zzeu, 
   {{0x61fc2280,0x78bd200a,0x68e282ad,0x5c07055a}},	//   _dyrl, nksv, gnod, _аяга, 
   {{0xb9ff81b7,0x78bd0a44,0x27e9a281,0xe9ff0106}},	//   _उर्फ_, iksv, çan_, _trắc_, 
   {{0x7d1d1bbd,0x623409c5,0x7c2d18a2,0x7e6381df}},	//   _hiss, _веру, lcar, ugnp, 
   {{0xc9842282,0x4519a283,0x68e2a284,0x72d406f1}},	//   _кути, нция_, bnod, _торф, 
   {{0x7c2d2285,0x7d1d01bb,0xdb1e0170,0xc485a286}},	//   ncar, _jiss, _švéd, улик, 
   {{0x7d1d2287,0x248da288,0xb05b2248,0xec768116}},	//   _miss, rdem_, rhäl, упы_, 
   {{0x248d93fd,0x7bc981ed,0x236da289,0x89a9a28a}},	//   sdem_, rzeu, rtej_, еков_, 
   {{0x291e02c0,0xdd919435,0x186a228b,0xa922877a}},	//   _état_, _دوا_, нани_, йдэл, 
   {{0x7c2d228c,0x26d8228d,0xd5ba80c6,0x25f700c9}},	//   jcar, wiro_, _אזעל, _एड़ी_, 
   {{0xe28ea28e,0x1cb8807b,0x7c2d228f,0x442da290}},	//   _ла_, _جالب_, dcar, mce_, 
   {{0x442da291,0x7c3ba292,0x7d1d2293,0x35d8802a}},	//   lce_, lbur, _aiss, _भेड़, 
   {{0x6281a294,0x649a00b5,0x7d1d2295,0x26d82274}},	//   melo, нтар_, _biss, riro_, 
   {{0x442da296,0x77862297,0x6281a298,0xa7d60743}},	//   nce_, _близ, lelo, _متخص, 
   {{0x68e28533,0x03a32299,0xe29a0077,0x60c4229a}},	// [11e0] vnod, бито, наа_, _ilim, 
   {{0xc3328052,0x7bc00816,0x6281a29b,0xdd0407de}},	//   צוב_, _ümum, nelo, ırır, 
   {{0x442d800d,0x2d961abb,0x7d1d229c,0x25a50005}},	//   kce_, _српс, _fiss, ällt_, 
   {{0x64a6229d,0x6281a29e,0x7c2d229f,0x5ca60ee7}},	//   _сама, helo, ccar, _симб, 
   {{0x6281a2a0,0x442da2a1,0x60c422a2,0x7c3ba2a3}},	//   kelo, dce_, _mlim, dbur, 
   {{0x6281a2a4,0x7cfe89b8,0x6d5c22a5,0x44220a07}},	//   jelo, mëri, orra, _hgk_, 
   {{0x6281a2a6,0x644622a7,0x442202fa,0x3cff80bf}},	//   delo, _keki, _kgk_, fluv_, 
   {{0x628e22a8,0x7c3ba2a9,0x442fa2aa,0x44220766}},	//   _habo, gbur, _cfg_, _jgk_, 
   {{0x28a80bb6,0x628e22ab,0x6281a2ac,0xb4e48758}},	//   गानि, _kabo, felo, _नदी_, 
   {{0x60c422ad,0x4974971a,0x62818622,0x64460004}},	//   _alim, алос, gelo, _leki, 
   {{0x628e22ae,0x60c421ae,0x442d801b,0x6d418324}},	//   _mabo, _blim, bce_, _gwla, 
   {{0x3866a2af,0x442d809f,0x7cfe80f8,0x628e0d51}},	//   ngor_, cce_, këri, _labo, 
   {{0xb4c085b7,0x7c22a2b0,0x78bd22b1,0x7cfe816c}},	//   ँसी_, _igor, rksv, jëri, 
   {{0x442d0d99,0x7d1d0073,0x628e1d84,0x442222b2}},	//   _że_, _siss, _nabo, _agk_, 
   {{0x644605ab,0x7d1d22b3,0x60c40208,0x403522b4}},	//   _beki, _piss, _flim, _кейс, 
   {{0x60c422b5,0x644622b6,0x442209fb,0x3f89027e}},	//   _glim, _ceki, _cgk_, _tsau_, 
   {{0x7d1d22b7,0x6d5c22b8,0x628e22b9,0xb6c4075d}},	// [11f0] _viss, arra, _babo, рөөд, 
   {{0x7d1d1b9a,0x628e10e1,0x442da2ba,0xf8bf001b}},	//   _wiss, _cabo, zce_, lké_, 
   {{0x7d1d22bb,0x442da2bc,0x628e0770,0xb87b00fe}},	//   _tiss, yce_, _dabo, nnío, 
   {{0x7c22a2bd,0xf8bf22be,0x6281a2bf,0x38bb016c}},	//   _ngor, nké_, zelo, _bëri_, 
   {{0x442d92c9,0x8fa5a2c0,0x07a58634,0x3669a2c1}},	//   vce_, рале, ралн, вало_, 
   {{0x7c229909,0x8d5584f9,0x0555a2c2,0x442da2c3}},	//   _agor, атич, атия, wce_, 
   {{0x6281a2c4,0x644622c5,0x442d910f,0x56b800c6}},	//   velo, _yeki, tce_, רפון_, 
   {{0x628e0131,0x6281a2c6,0xed64026b,0x4735a020}},	//   _zabo, welo, leží_, _внас, 
   {{0x442da2c7,0x6281a2c8,0xe7308f94,0x6449a2c9}},	//   rce_, telo, _فصل_, raei, 
   {{0x442da2ca,0x7c3ba2cb,0x60c422cc,0x27ff853a}},	//   sce_, sbur, _slim, _iyun_, 
   {{0x6281a2cd,0xceb880a1,0x442f891e,0x442d9144}},	//   relo, _więc_, _tfg_, pce_, 
   {{0x6281a2ce,0x656382fd,0x27ff8927,0x272b806d}},	//   selo, munh, _kyun_, _køn_, 
   {{0x7bcd22cf,0x6281a2d0,0x644622d1,0xfaa5a2d2}},	//   jzau, pelo, _reki, _вало, 
   {{0x644622d3,0x41b5122f,0x98ab0029,0xed5a0b6f}},	//   _seki, ंहास, ībā_, ког_, 
   {{0x68fba2d4,0xb8cc00b2,0x628e22d5,0x63bba2d6}},	//   _okud, _গত_, _rabo, lyun, 
   {{0xf8bf22d7,0xdcfc0025,0x60c422d8,0x27ff83d2}},	//   cké_, tvrđ, _ulim, _oyun_, 
   {{0x644622d9,0x63bba2da,0x63a9a2db,0x26c581e0}},	// [1200] _veki, nyun, nxen, _ollo_, 
   {{0xc8798816,0x64460640,0x68e9a2dc,0xed461a59}},	//   _abş_, _weki, _ajed, _кноп, 
   {{0x644622dd,0x44220b14,0xada60004,0x63bb8a3e}},	//   _teki, _tgk_, _танл, hyun, 
   {{0x7cfe8210,0x290d81e0,0xe73a84bc,0x26c5809f}},	//   përi, _chea_, вед_, _allo_, 
   {{0x7cfe80f8,0x1634809f,0x68e982cf,0xddd8801b}},	//   qëri, беля, _djed, devš, 
   {{0xf8bf01d2,0x68fba2de,0x7c22a2df,0x62980033}},	//   zké_, _ekud, _sgor, ôvod, 
   {{0x65638659,0x91e322e0,0x20d20033,0x290d8097}},	//   gunh, _доре, lšiu_, _fhea_, 
   {{0x26c585da,0x5fa6009b,0xb4c095ad,0x320a22e1}},	//   _ello_, खमाल, ँसे_, _izby_, 
   {{0xef1a9972,0x041800b2,0x63bb8019,0xcb6780d8}},	//   _ама_, ধুরী_, gyun, لميه_, 
   {{0x291f802d,0xb27381bc,0x657e00f0,0x63ab0617}},	//   _ziua_, ольш, _opph, ägni, 
   {{0xd90f040c,0x2247a2e2,0x26dca2e3,0xadf218e0}},	//   ویت_, _denk_, mivo_, _आँगन_, 
   {{0x64a3a2e4,0x26dc8f91,0x7648a2e5,0xddc501d2}},	//   _маха, livo_, _hedy, _schů, 
   {{0xdb02835b,0x69c58079,0x27ed0214,0xf8bf06ba}},	//   _groß, _ühen, çen_, rké_, 
   {{0xf8bf03e0,0x764880a1,0x75288889,0x2247a2e6}},	//   ské_, _jedy, _kudz, _genk_, 
   {{0xd5b804c9,0xe3e88a87,0x7528a2e7,0x24590c41}},	//   аст_, _পরিব, _judz, лавь_, 
   {{0xc05b036a,0x75288889,0x7bcd22e8,0x25de8079}},	//   _рік_, _mudz, tzau, _कइनी_, 
   {{0x75288066,0x2bba0034,0x53990656,0x2d9a22e9}},	// [1210] _ludz, jącą_, ывая_, _erpe_, 
   {{0x68e9a2ea,0x68fba2eb,0x69c102f4,0xd7fc0309}},	//   _sjed, _skud, _ülek, _בהחל, 
   {{0x272b872c,0xc8ab809f,0x248481bb,0x63a48065}},	//   _søn_, къде_, kemm_, _áinf, 
   {{0xf7719389,0xa49b0a67,0xe0d080d8,0x859a0309}},	//   كات_, _chòt, وزن_, _עשרו, 
   {{0x2bde1470,0x644d04bb,0x2d8c83b9,0x68e980f8}},	//   _नेपा, maai, _asde_, _vjed, 
   {{0x6563a2ec,0x644d06a4,0x20d20a63,0xb87b01d2}},	//   tunh, laai, lšit_, dním, 
   {{0x68e98301,0xa8a7a2ed,0x785782e5,0x290da2ee}},	//   _tjed, _крак, _نیاز_, _thea_, 
   {{0x68e98025,0x628522ef,0x6563a2f0,0x224786e0}},	//   _ujed, leho, runh, _senk_, 
   {{0x1c4281bc,0x7b0681c2,0x2d8c83df,0x7ebd868e}},	//   чным, rðun, _esde_, _lèpi, 
   {{0x63a984e0,0x68f982a1,0x6563a2f1,0x2cad82cf}},	//   rxen, lowd, punh, sjed_, 
   {{0x63bb97b9,0x386d97a2,0x7fd782c3,0x66c20033}},	//   syun, _kcer_, _сіңі, _dôkl, 
   {{0x297a0130,0x6721a2f2,0x397a0039,0x60dd22f3}},	//   נטרא, _hilj, נטרנ, gism, 
   {{0xeaaea0f2,0x443fa2f4,0x8ca480a1,0x6d450128}},	//   _ей_, mbu_, कारो, _awha, 
   {{0x443fa2f5,0x62851190,0x6d45013b,0x6b89a2f6}},	//   lbu_, jeho, _bwha, mweg, 
   {{0x80b880cf,0xdca622f7,0x2d95157b,0x62850142}},	//   _আগস্, бави, ортс, deho, 
   {{0x70b6800f,0x443fa2f8,0x6721a2f9,0x6da6004a}},	//   _अकेल, nbu_, _lilj, _ғима, 
   {{0x03a3013a,0x6b89a2fa,0x1d071afe,0x78a406e0}},	// [1220] пито, nweg, сети_, _iniv, 
   {{0x443f8004,0x62851920,0x2d9a0043,0x290781b2}},	//   hbu_, geho, _trpe_, înan_, 
   {{0x657e22fb,0x78a40e87,0x499a1878,0x76489654}},	//   _upph, _kniv, ытая_, _redy, 
   {{0x764e0371,0x7648a2fc,0x443f8519,0x7528a2fd}},	//   laby, _sedy, jbu_, _rudz, 
   {{0x7d0422fe,0x5fd28079,0x4b550086,0x7528a2ff}},	//   mlis, _देखल, _мърт, _sudz, 
   {{0x7d042300,0x66fa0ab2,0xf1ca800d,0x386d80e5}},	//   llis, ृतिक_, ानमन, _ecer_, 
   {{0x26dca301,0x171b0273,0x6721a302,0x2d982303}},	//   rivo_, נוצע, _dilj, nvre_, 
   {{0x6cd487db,0x7d042304,0x44320052,0x60dd2305}},	//   تقبا, nlis, ncy_, xism, 
   {{0xe81a1d62,0x60c2a2f9,0x47c680b0,0x26dca306}},	//   नेमा_, mkom, _убав, pivo_, 
   {{0x60c2937c,0x6601836a,0x39ae808a,0x60dd00db}},	//   lkom, _fylk, ləsi_, wism, 
   {{0x443fa307,0x8afb00c6,0x69c582f4,0xff5f0c50}},	//   bbu_, רהיי, _ühel, wrî_, 
   {{0x23602308,0x7d040004,0x66cb0214,0x26da2309}},	//   krij_, jlis, _müke, _ampo_, 
   {{0x4426a30a,0xe6c4812b,0xb87b026b,0x7d0401ac}},	//   _igo_, _þjóð, lník, dlis, 
   {{0x7d1600e9,0x60dd0578,0x39ae808a,0xff5f0610}},	//   emys, sism, həsi_, rrî_, 
   {{0x6d5a003a,0x60c2a30b,0xd6d8230c,0xb87b00e9}},	//   štan, kkom, стя_, nník, 
   {{0xd904a0f4,0x60c2a30d,0xf98f80fe,0x7d04230e}},	//   _سی_, jkom, _أبو_, glis, 
   {{0x2d8c0142,0x60c2837c,0x764e230f,0x644d2310}},	// [1230] æder_, dkom, baby, raai, 
   {{0x7d042311,0x443fa312,0x7afa8e79,0x32552313}},	//   alis, zbu_, nott, івер, 
   {{0x7d042314,0x443fa315,0x4426a316,0x6d340193}},	//   blis, ybu_, _ogo_, _неэф, 
   {{0x62852317,0x4426a318,0x60c282b7,0x212a0089}},	//   seho, _ngo_, gkom, _dubh_, 
   {{0xd366a319,0x672985cb,0x443f826b,0x6285231a}},	//   _ته_, _quej, vbu_, peho, 
   {{0x24ab00b2,0xe5a5a31b,0xa3be8e2d,0x60c2a31c}},	//   _ঐতিহ, жики, ीनन_, akom, 
   {{0x7afaa31d,0x6721a31e,0x68ed231f,0x4426813b}},	//   dott, _vilj, _ojad, _bgo_, 
   {{0x6b89a320,0x2d810129,0x39ae82d1,0x60c2a321}},	//   tweg, _mphe_, cəsi_, ckom, 
   {{0x443fa322,0x63ad2323,0x7b1001ed,0x44268149}},	//   rbu_, nxan, bäud, _dgo_, 
   {{0x66018d99,0x443fa324,0xb87b05e1,0x63ad2325}},	//   _tylk, sbu_, lníh, ixan, 
   {{0x00862326,0x7d042327,0x6b8981ed,0x4ea48103}},	//   олно, ylis, sweg, _эрта, 
   {{0x2eb42328,0xc9520080,0x63ad072f,0x7d0403ad}},	//   ुस्त, ומט_, kxan, xlis, 
   {{0xfc4601ac,0x764e2329,0x60c98232,0x68ed232a}},	//   šíka_, taby, _mlem, _djad, 
   {{0x61458fdd,0x443200a1,0x7afaa32b,0x7d04008b}},	//   _дека, wcy_, cott, wlis, 
   {{0x60c9a32c,0x7d04232d,0x644ba32e,0x7cfe80f8}},	//   _olem, tlis, _kegi, përt, 
   {{0x78a4232f,0x764e1c0a,0x0ce800b2,0xb05b1b36}},	//   _univ, saby, পত্ত, lkän, 
   {{0x272f0876,0x7d042330,0xb87b003e,0xeb970008}},	// [1240] _gün_, rlis, zník, оит_, 
   {{0xda6600fe,0x443200a1,0xdc3c9f49,0x60db9c5a}},	//   تاري, scy_, váčk, _amum, 
   {{0x1d0a0720,0x645980a1,0x60c296f3,0x39ae808a}},	//   _вени_, _odwi, tkom, təsi_, 
   {{0xb87b003e,0x644ba331,0x7afa8019,0x63ad02d1}},	//   vník, _negi, zott, bxan, 
   {{0x39ae808a,0x2bd9a332,0x888d00c6,0x60c98112}},	//   rəsi_, _बेला, טראַ, _dlem, 
   {{0x8f9b1c9c,0x6146116d,0xb87b026b,0x60c2a333}},	//   ייני, _мега, tník, skom, 
   {{0x2bde00c1,0xb05b0172,0x7afaa334,0x60c9a335}},	//   _नेता, dkän, vott, _flem, 
   {{0x41272336,0x60c98c05,0xb87b2337,0xa067930c}},	//   _фото_, _glem, rník, _маса_, 
   {{0x7afa8068,0x2aaa9309,0x8e76a338,0x644ba339}},	//   tott, атно_, _мужч, _degi, 
   {{0x2906a33a,0x7cfe80f8,0x8af0008a,0x6459a33b}},	//   lloa_, tërs, qsəd, _edwi, 
   {{0x7afaa33c,0x27308028,0xe8950123,0x63ad0fde}},	//   rott, _hàn_, пань, zxan, 
   {{0x6ab70ab2,0x4426a33d,0x2d9ea33e,0xbebb016c}},	//   _आक्र, _ugo_, _irte_, yqës, 
   {{0x6d5a0b8c,0x69c10079,0x3ce903d0,0xdb2482f4}},	//   štal, _ülev, vnav_, öpäe, 
   {{0xdefb112d,0x20050029,0x27308028,0x2bd5001b}},	//   рым_, āli_, _màn_, _ठेगा, 
   {{0x2730a33f,0x6288a340,0xc8bc8d64,0x2ebc80b2}},	//   _làn_, medo, ्घाट, _অগাষ, 
   {{0x6288a341,0x95c9005a,0x70b98079,0x63ad2342}},	//   ledo, ауға_, _आवेल, txan, 
   {{0x60c02343,0xb87b001b,0x68fd016c,0x2730812f}},	// [1250] ömme, vníh, mosd, _nàn_, 
   {{0x6288a344,0x63ad2345,0x21248064,0xb5f302c3}},	//   nedo, rxan, _aimh_, _жүгі, 
   {{0xdc3f026b,0x672d016c,0xb87b01d2,0x19ab00a6}},	//   líčk, _huaj, tníh, штап_, 
   {{0xd04f0816,0x2730a346,0x26f5a347,0x397b80c6}},	//   ticə, _bàn_, ेत्र_, שטאנ, 
   {{0x2d9ea348,0x6d488199,0xf745a349,0x3ea58103}},	//   _arte_, _awda, чело, зилг, 
   {{0x2730a34a,0x644ba34b,0x628893e0,0x672d00f8}},	//   _dàn_, _segi, jedo, _muaj, 
   {{0x6288a34c,0x6b8d0a44,0x2d9e8131,0x672d016c}},	//   dedo, lwag, _crte_, _luaj, 
   {{0x60dba34d,0x60c9a34e,0x6295234f,0xe78782bb}},	//   _umum, _ulem, _hazo, _музо, 
   {{0x644ba350,0x6b8d2351,0x62952352,0x7cfe816c}},	//   _vegi, nwag, _kazo, tërr, 
   {{0xdd95a353,0x3ed580fe,0x6288a354,0x69c58079}},	//   _назы, _عقار, gedo, _ühek, 
   {{0x644ba355,0x62952356,0xb05b1b36,0xe29982bb}},	//   _tegi, _mazo, rkän, _ҳал_, 
   {{0x6b8d2357,0xb05b0341,0x68fd2358,0x7bc08294}},	//   kwag, skän, gosd, bymu, 
   {{0x24892359,0xa3d3809b,0xe299a35a,0x672d0685}},	//   deam_, _हेच_, _гал_, _cuaj, 
   {{0x6295235b,0x6d5a0934,0x2cb90064,0x6288a016}},	//   _nazo, štam, _aosd_, cedo, 
   {{0x2d9e003e,0x6da31afe,0x764380e5,0x6d550019}},	//   íte_, нира, ibny, gsza, 
   {{0x01c300cf,0x5fbd8673,0xd7bd8076,0x2cb90064}},	//   ্পাদ, ्नाल, ्नाच, _cosd_, 
   {{0x6295235c,0xab660be1,0x672d1049,0x673b827e}},	// [1260] _bazo, явал, _guaj, _ntuj, 
   {{0x0e66235d,0x479b0052,0x3f9213b3,0x6295235e}},	//   _экон, _פייס, _isyu_, _cazo, 
   {{0x69c1a35f,0x98b08284,0x2730801c,0x3ebb0039}},	//   nyle, šači_, _sàn_, _הציב, 
   {{0x7762a360,0x7ae1a361,0x6b8d2362,0x186aa363}},	//   trox, hilt, bwag, сади_, 
   {{0x7ae1a364,0x64440399,0xfc3f17e5,0x43930116}},	//   kilt, mbii, _unía_, _заўс, 
   {{0x62889877,0x996401d2,0x62952365,0x2b402366}},	//   xedo, může_, _gazo, mpic_, 
   {{0x28af06d7,0x6b82a367,0xb0cc1d89,0x7ebd875d}},	//   टामि, _spog, ासाग, _rèpt, 
   {{0x2d9e8043,0x2124a368,0x62888324,0x66cb008a}},	//   _vrte_, _uimh_, wedo, _müka, 
   {{0xfc3f82ba,0x62952369,0x5b14a36a,0x0b8a804c}},	//   ñía_, _yazo, ммит, ёсии_, 
   {{0x7ae1a36b,0xb6c88068,0x7afe236c,0x7f3b8039}},	//   gilt, _بارے_, nopt, _לעמו, 
   {{0x6d5a003a,0x2d9e8124,0x68fd236d,0x6b8d236e}},	//   štaj, _urte_, tosd, zwag, 
   {{0xeafa0693,0x68e2a36f,0x6288a370,0x2ca6a371}},	//   ्तुत_, niod, sedo, _unod_, 
   {{0x7ae1a372,0xfaa6a373,0x8c43a374,0x672d00f8}},	//   bilt, _надо, _чече, _quaj, 
   {{0x628880f8,0x0ebe8bda,0x672d016c,0x96eb2375}},	//   qedo, ्सिड, _vuaj, сьма_, 
   {{0x24892376,0x672504bb,0xf29793b1,0x3ebe1987}},	//   team_, _vihj, _זכור_, ötta_, 
   {{0x6d552377,0x23692378,0x6b8d2379,0xfbde009b}},	//   rsza, tuaj_, twag, _नेहम, 
   {{0x6d550068,0x68e2a37a,0xa3be854d,0x6295237b}},	// [1270] ssza, diod, ीनि_, _pazo, 
   {{0x6b8d237c,0x92940166,0x88bd8034,0xb05b01ab}},	//   rwag, науц, _ciśn, chär, 
   {{0xc1788116,0x673b80e5,0x64440371,0x7d028063}},	//   ntė_, _stuj, bbii, _okos, 
   {{0xa3be823b,0xc5f2004d,0x2ec5a37d,0x6295237e}},	//   ीना_, _ידי_, वस्त, _wazo, 
   {{0x6295237f,0x635e0166,0x644f01a8,0x041b05a2}},	//   _tazo, tănţ, _ieci, _ফ্রী_, 
   {{0x60cd2380,0x25de800d,0x7afe2381,0xc33200c6}},	//   _llam, _केही_, copt, _בוך_, 
   {{0x644f1b4e,0x60cd2382,0xf6508158,0xb05b019b}},	//   _keci, _olam, ائه_, tkäl, 
   {{0x68e2802d,0x2ee301f0,0x387fa383,0xe8948116}},	//   ciod, hijf_, _ubur_, _пась, 
   {{0x644f2384,0xeb99a385,0x7ae1a386,0x645d0149}},	//   _meci, цип_, tilt, _mdsi, 
   {{0x78bba387,0x69c10079,0x66cf80f0,0x1306819b}},	//   _houv, _üles, _bøke, мный_, 
   {{0x78bba388,0xa88a2389,0x7ae1a38a,0x44390a5e}},	//   _kouv, ойна_, rilt, _ofs_, 
   {{0xafe6036a,0xa3ad001b,0x7ae1a38b,0xd00a03b8}},	//   домл, कमा_, silt, жеме_, 
   {{0x78bba38c,0xb8e61d89,0x66d00172,0x7d1ba38d}},	//   _mouv, _एव_, _läke, mmus, 
   {{0x78bba38e,0x60cd0079,0x7d099419,0x644f016f}},	//   _louv, _elam, lles, _aeci, 
   {{0xcb128052,0x644f003d,0x442b02ef,0x66d00008}},	//   _שלו_, _beci, _bgc_, _näke, 
   {{0x78bba38f,0x7afe034e,0x68e28065,0xb05b2390}},	//   _nouv, wopt, xiod, shär, 
   {{0x073a00fe,0xb05b01ed,0x03262391,0x64442392}},	// [1280] _بسبب_, phär, ддан, rbii, 
   {{0x244c001c,0x7d09a393,0x273b8166,0x050005a2}},	//   ếm_, hles, _mână_, ্দের_, 
   {{0x2734036d,0x2d9c0019,0x63a90208,0x644f2394}},	//   _hän_, _éve_, _ġene, _feci, 
   {{0x588381bc,0x7d098019,0x78bb82c0,0x60cd00bf}},	//   выша, jles, _couv, _xlam, 
   {{0x78bb8401,0x2d85834e,0xba560086,0xd5af80df}},	//   _douv, _aple_, _отвъ, یفه_, 
   {{0x273400f9,0xbea3a395,0x68e2a396,0x44390294}},	//   _män_, качк, siod, _zfs_, 
   {{0x27340172,0x7d098d9d,0x3d0a8076,0x2619902c}},	//   _län_, fles, ातले_, येली_, 
   {{0x78bba397,0x1ee8811d,0x6abc007f,0x9972801b}},	//   _gouv, _کوئی_, _horf, těže_, 
   {{0x66cf80f0,0x69c10587,0x2d85a398,0x60cd0304}},	//   _søke, _üler, _eple_, _rlam, 
   {{0x60cd2399,0xc17a87c5,0xf7d78080,0x7d1b86b5}},	//   _slam, оїм_, _חומש_, amus, 
   {{0xa50a8aad,0xb05b1e4a,0x7c39843a,0xa2d4a39a}},	//   _дежа_, skäm, _ffwr, योग्, 
   {{0x7d09a39b,0x2bd981b7,0x22498934,0xab2a84bc}},	//   cles, _बेका, _đake_, _дода_, 
   {{0xad1b8273,0xe81a108e,0x644f239c,0x6d588eb9}},	//   _וואר, नेला_, _reci, lsva, 
   {{0x644f239d,0x3941239e,0x3207811a,0x4439239f}},	//   _seci, yphs_, _fyny_, _sfs_, 
   {{0x63a2a3a0,0x6728a3a1,0x6d58a3a2,0x27fa80a1}},	//   _hron, _midj, nsva, ępny_, 
   {{0x60cd23a3,0xc983802d,0x629aa3a4,0x6ee905c3}},	//   _ulam, _руши, ldto, džbe, 
   {{0x66d008b4,0x5b1523a5,0xbf0ea3a6,0x63a2807b}},	// [1290] _säke, емат, िताभ_, _jron, 
   {{0xd251046d,0x671609ca,0x78bba3a7,0x62988004}},	//   انا_, _दीपक_, _souv, _javo, 
   {{0x78bba3a8,0x25de8365,0x7d00a3a9,0x644f23aa}},	//   _pouv, _केली_, koms, _teci, 
   {{0x6298a3ab,0x901588cf,0x200923ac,0x63a28c8e}},	//   _lavo, нфлі, _kyai_, _oron, 
   {{0x6abc23ad,0x8e85839c,0xe8d803dd,0x6d5aa3ae}},	//   _forf, егле, וואר_, _avta, 
   {{0x6abc0324,0x2bd9802a,0x7a318063,0xda7e1f4a}},	//   _gorf, _बेगा, _műté, íďte_, 
   {{0xdce88186,0x63a2a3af,0xd5b18a57,0x7d09a3b0}},	//   _ardı, _aron, افع_, tles, 
   {{0x273b802d,0xe3b9a3b1,0x9f518019,0x212900bf}},	//   _până_, зби_, ából_, _niah_, 
   {{0x7d1ba3b2,0x7d09a3b3,0x03259fd0,0x6593808a}},	//   rmus, rles, ндин, _məhə, 
   {{0xeab18013,0x394589ba,0xaad980a1,0x7dee0019}},	//   اعة_, нног, योंक, nősé, 
   {{0x6298a3b4,0x212900bf,0x69c523b5,0x7d1ba3b6}},	//   _davo, _biah_, nyhe, pmus, 
   {{0x0ef80562,0xf9da00c6,0x629aa3b7,0x6d43837f}},	//   ंक्स_, פֿיל, adto, mpna, 
   {{0x63a2a3b8,0x21291c44,0xada303ad,0x35a303ad}},	//   _gron, _diah_, қатл, қатг, 
   {{0x248d858f,0x27340172,0xe3b080dd,0x290b0183}},	//   leem_, _vän_, _خرم_, alca_, 
   {{0x57bd83ce,0xdd92194c,0x2cbda3b9,0x48e623ba}},	//   ्नुह, دوز_, _kowd_, _покв, 
   {{0x248d87b8,0x942623bb,0x050000b2,0x91fc81a8}},	//   neem_, ембе, ্দ্র_, rgāt, 
   {{0x3860006b,0x6abc23bc,0x290223bd,0xc4d280c6}},	// [12a0] _idir_, _porf, moka_, אגן_, 
   {{0x248d806c,0x290214af,0x68e609e2,0xe29723be}},	//   heem_, loka_, likd, нау_, 
   {{0xa3bc0503,0x67288265,0xa84a80d8,0x6abc23bf}},	//   _अथक_, _ridj, كلام_, _vorf, 
   {{0x232a099f,0x290223c0,0x25a5006d,0x2615083c}},	//   _номи_, noka_, ælle_, _धरती_, 
   {{0x66e6940f,0x645623c1,0x1c1c23c2,0x6abc23c3}},	//   нода, mayi, पेशल_, _torf, 
   {{0x645623c4,0x6d58a3c5,0x290223c6,0xd1ca02c3}},	//   layi, tsva, hoka_, _елге_, 
   {{0x6728a3c7,0x290223c8,0xe9f98106,0x248d81df}},	//   _vidj, koka_, _đế_, feem_, 
   {{0x6298a3c9,0x6d58a3ca,0x6728a3cb,0xdd8e8019}},	//   _savo, rsva, _widj, لوڈ_, 
   {{0x290223cc,0x6298a3cd,0x1e86a3ce,0xf318804c}},	//   doka_, _pavo, _плам, моиш_, 
   {{0x645623cf,0xdce380f3,0x21290120,0x2fc6a3d0}},	//   hayi, runā, _siah_, myog_, 
   {{0xfbcf82e5,0x200900e5,0x28f90765,0x629880de}},	//   لتی_, _syai_, день_, _vavo, 
   {{0x63a28147,0x290223d1,0x38600097,0x629882d9}},	//   _tron, goka_, _cdir_, _wavo, 
   {{0x09dd0baf,0xbfa80cfb,0x6298a3d2,0x240a8004}},	//   _मध्य, нтре_, _tavo, _энди_, 
   {{0x3860008c,0x63ad839f,0x61eb8019,0x3ebea3d3}},	//   _edir_, _šang, állá, _jott_, 
   {{0x290223d4,0x3a3780c6,0xe29b80c6,0x3eac80db}},	//   boka_, _ארום_, _זשור, _mndt_, 
   {{0x3ebea3d5,0x645623d6,0xade38079,0xb05b019b}},	//   _lott_, gayi, _कइसन_, kkäi, 
   {{0x3a7523d7,0x7dee0068,0xe7e081d1,0x66cb0085}},	// [12b0] клар, tősé, _खेला_, _yükl, 
   {{0x6911a3d8,0x3a7423d9,0x63bd872c,0x3ebe8a63}},	//   gåen, ллур, øsni, _nott_, 
   {{0xa5f903b6,0x645623da,0x1df90008,0x7ae523db}},	//   _цену_, bayi, _цены_, riht, 
   {{0xf771812a,0xb5f2005a,0xa90784de,0x248d822a}},	//   لات_, _түсі, ربان, xeem_, 
   {{0x7d0d23dc,0x3ebea3dd,0x57bd81d2,0xadfc0034}},	//   mlas, _bott_, ्नेह, _एडऑन_, 
   {{0x7d0d1e7f,0x290223de,0x66d00341,0xaca78063}},	//   llas, zoka_, _käka, کھئے_, 
   {{0x6d5a0025,0x1af423df,0x257a80f8,0x3ebe8495}},	//   štav, _спря, gël_, _dott_, 
   {{0x7d0d23e0,0x2fc68009,0x6b848166,0x3eac92fb}},	//   nlas, byog_, _ţiga, _endt_, 
   {{0x58d495e6,0x66d000f9,0x3f8901c8,0x98a80123}},	//   _сотт, _läka, _npau_, _lună_, 
   {{0x7d0d23e1,0x3ebea3e2,0x248d9e59,0x23690284}},	//   hlas, _gott_, seem_, iraj_, 
   {{0x290223e3,0xa06a23e4,0x3de100cf,0x7d0d23e5}},	//   toka_, мана_, _মুসল, klas, 
   {{0x48e6038f,0x6f0396ef,0xa2a1a3e6,0x23690308}},	//   томв, lonc, _कोर्, kraj_, 
   {{0xe28ea3e7,0x290223e8,0x2bd9810c,0x6449a3e9}},	//   _ка_, roka_, _बेचा, mbei, 
   {{0x6f03a3ea,0x8a059afe,0x98a80123,0x645623eb}},	//   nonc, _изле, _bună_, wayi, 
   {{0x290223ec,0x645606d0,0x649a004c,0xfc3f0033}},	//   poka_, tayi, мтар_, _kníh_, 
   {{0x320a1cb1,0x6449a3ed,0x443d80db,0xa0a30fbe}},	//   _ryby_, nbei, _jfw_, _ваъд, 
   {{0x645623ee,0x6f03a3ef,0xa50723f0,0x6911a3f1}},	// [12c0] rayi, konc, тета_, tåen, 
   {{0x62818519,0x4a4318e6,0x645623f2,0x69c582f4}},	//   nflo, инув, sayi, _ühes, 
   {{0x56e3005a,0x7d0d23f3,0x6d4183ec,0x645623f4}},	//   _тұрғ, blas, _ntla, payi, 
   {{0xf74687ae,0x3ebea3f5,0x00e68086,0x4feaa3f6}},	//   ведо, _sott_, ъжен, ммен_, 
   {{0xd7ef8013,0x6f0380ef,0x7d0423f7,0x3ebea3f8}},	//   يكم_, fonc, mois, _pott_, 
   {{0x7d0423f9,0xa2a1a3fa,0x6d5a01ac,0x442fa3fb}},	//   lois, _कोल्, štau, _agg_, 
   {{0x180f0365,0x6d5c04a5,0x1ae30e05,0x442fa3fc}},	//   _सर्व_, nsra, _торм, _bgg_, 
   {{0x629c23fd,0x7d0423fe,0x22498934,0xd3a6a3ff}},	//   _haro, nois, _đaka_, вроп, 
   {{0x629c2400,0xcb679020,0x4f26a401,0x6d4180bc}},	//   _karo, вање_, _адаб, _etla, 
   {{0x60c0a402,0x68e42403,0x629c2404,0x629e2405}},	//   _homm, _amid, _jaro, ndpo, 
   {{0x629c2406,0xf484807b,0x7d04036d,0x7d0d0004}},	//   _maro, _ماشی, kois, ylas, 
   {{0x629c2407,0xcfa98019,0x7793003d,0x6d5c2408}},	//   _laro, _تاہم_, لیبا, dsra, 
   {{0x7d042409,0x629c0129,0xb4c091a6,0xeaba8692}},	//   dois, _oaro, ुसी_, _ойд_, 
   {{0x752b8065,0x76588010,0x60c0a40a,0x79588fbe}},	//   _zigz, navy, _lomm, _зикр_, 
   {{0x2fcd003a,0xd6d8036a,0x7d0d240b,0x3cff240c}},	//   šeg_, ття_, tlas, लवले_, 
   {{0x60c0a40d,0x78ad240e,0x2369240f,0x4aa68353}},	//   _nomm, _unav, traj_, _कोतव, 
   {{0x7d0d2410,0x7b3280a1,0x69c8a411,0xe7bd80b2}},	// [12d0] rlas, _dług, lyde, _অধ্য, 
   {{0x7d0d2412,0xade38079,0xfde38079,0x629c1658}},	//   slas, _कइलन_, _कइलस_, _caro, 
   {{0x7d0d2413,0x60c0a414,0x7d042415,0x6f0200fe}},	//   plas, _bomm, bois, _íoca, 
   {{0x60c0a416,0x7d0d0004,0x48e180b2,0x4fd5804a}},	//   _comm, qlas, যক্র, лжет, 
   {{0x6f0385da,0x629c2138,0x973580dd,0x60c0a417}},	//   tonc, _faro, اکرا, _domm, 
   {{0x629c2418,0x60c08bd4,0x442f82ef,0x26c10c4e}},	//   _garo, _eomm, _sgg_, _joho_, 
   {{0xceb40464,0x26c12419,0xf0758019,0xfce5a41a}},	//   ייס_, _moho_, _میاں_, локо, 
   {{0x629c241b,0x60c0a41c,0x39460a63,0x26c1241d}},	//   _zaro, _gomm, ćost_, _loho_, 
   {{0x6449a41e,0x7c3b8012,0x57f5a41f,0x27e080fe}},	//   rbei, rcur, _спат, úint_, 
   {{0x26c10573,0x3ce901ea,0x68e42420,0xa3bb0073}},	//   _noho_, hiav_, _smid, _अपन_, 
   {{0x6281a421,0xaad9878b,0x59ca9131,0x6d41a422}},	//   rflo, योगक, ानगर, _utla, 
   {{0xf746028e,0x628181c2,0x20c200d8,0x6fa785c9}},	//   лемо, sflo, _cóip_, चिपू, 
   {{0x6b65a423,0x2d0f8365,0x7b06807f,0x4b7980c6}},	//   _скла, ातील_, rður, _נאַו, 
   {{0xe296a424,0x249fa425,0x249d81c8,0x5a478ad0}},	//   _баш_, ldum_, _hawm_, _рэда, 
   {{0xa0a62426,0x7d040008,0x249d81ea,0x629c0504}},	//   _байд, tois, _kawm_, _raro, 
   {{0x249f812b,0x68e4051d,0x629c2427,0x97c61fbc}},	//   ndum_, _umid, _saro, _مقبو, 
   {{0xcb6720f2,0x60c0a428,0x237fa429,0xca86242a}},	// [12e0] лате_, _romm, ntuj_, лгай, 
   {{0xda650013,0x249d9123,0x6d5a04e0,0x8f9b0039}},	//   لامي, _lawm_, átas, _טיפי, 
   {{0x629c242b,0x60c0a42c,0x2cafa42d,0x7d04242e}},	//   _varo, _pomm, _ongd_, pois, 
   {{0x249d81df,0xa09a80d8,0x629c242f,0x237fa430}},	//   _nawm_, عضاء_, _waro, ktuj_, 
   {{0x629c2431,0x44240015,0x69c88034,0x69da8217}},	//   _taro, _àm_, zyde, zzte, 
   {{0xb8cba432,0x3b0a0008,0x2ca00079,0x4e7a00c6}},	//   _को_, _чего_, ldid_, גאַצ, 
   {{0x60c0a433,0x8d868741,0x57d001d2,0x45d4a434}},	//   _tomm, уулд, हनुह, ройс, 
   {{0xbd87864d,0x2ca02435,0x249d806c,0x7658a436}},	//   انين_, ndid_, _cawm_, savy, 
   {{0xc6768061,0xe646a437,0x66d000f9,0x63a42438}},	//   _مطاب, _безп, _räkn, nvin, 
   {{0x69c88c3e,0x69da835b,0x63ad826b,0xe45f0008}},	//   tyde, tzte, _šanc, _ylös_, 
   {{0x249d81df,0x26c12439,0x7c869f73,0xd2b70039}},	//   _fawm_, _roho_, _буле, אלית_, 
   {{0xa3e50689,0x8dfb8039,0x249d81df,0x2739807b}},	//   _भइल_, _אהבת, _gawm_, _yèn_, 
   {{0x69da8068,0x63a40a44,0x81bc00cf,0xf09f00a6}},	//   szte, jvin, েছি_, rdà_, 
   {{0x11d6803f,0x3ce6827e,0x99d68275,0x539b84fc}},	//   _متعد, _hmov_, _متعا, _ניוו, 
   {{0x7f441951,0x58d5243a,0x1df80241,0x249d806c}},	//   _etiq, _войт, геры_, _yawm_, 
   {{0x290f00d8,0x20f88162,0x2bd18bd4,0x84c402fd}},	//   _óga_, yčia_, दैवा, бљуд, 
   {{0x26c10a93,0x395e834a,0x63a4243b,0x4a55243c}},	// [12f0] _toho_, lsts_, gvin, икас, 
   {{0xa5c5004a,0xb05b01ed,0x66d0010d,0x3ce901df}},	//   _көбе, rkäu, _jäkl, siav_, 
   {{0x4615007b,0x66d00172,0x63a4243d,0xb035a43e}},	//   _خودر, _mäkl, avin, анеш, 
   {{0x6d45243f,0x237f8034,0x5c070495,0x395ea440}},	//   _itha, ytuj_, _бяга, ists_, 
   {{0x644d2441,0xc9840103,0x0a6b2442,0x249d822a}},	//   mbai, _қури, _први_, _rawm_, 
   {{0x395e8029,0xddc5a443,0x644d2444,0x249d827e}},	//   ksts_, ибли, lbai, _sawm_, 
   {{0xa56480fe,0xfc3180fe,0xb05b019b,0x249f82d1}},	//   مدين, يحة_, nkäs, tdum_, 
   {{0xff1580cf,0x644d0109,0x386080fe,0xdb06068e}},	//   াদেশ_, nbai, óirt_, _arkè, 
   {{0x395e8188,0x249f86c8,0x6d450128,0x7d1d068e}},	//   ests_, rdum_, _ltha, _mhss, 
   {{0x752f0066,0x644d03bf,0x237f80a1,0x6d452445}},	//   _licz, hbai, rtuj_, _otha, 
   {{0x249d81ea,0x2a760039,0x6d45037a,0x25b9819c}},	//   _tawm_, בעתך_, _ntha, _جهاد_, 
   {{0x68eb8d55,0x20562446,0xe73a2447,0x63a403dc}},	//   nigd, штор, кем_, yvin, 
   {{0x6d452448,0xb8ee000f,0x10a3024f,0xa3e50079}},	//   _atha, _शक_, циян, _भेल_, 
   {{0x443fa449,0x63a40199,0x7d1d0064,0x68eb8009}},	//   lcu_, vvin, _ahss, higd, 
   {{0x5046005a,0x2d53802d,0xa01b0019,0xddc3244a}},	//   _кейб, nţe_, lföl, обри, 
   {{0x1c46244b,0x8a14803d,0x47c607c5,0x6d45244c}},	//   рнам, _اظها, _вбив, _dtha, 
   {{0x6d45244d,0x6f070183,0x68eba44e,0x2ca00079}},	// [1300] _etha, bojc, digd, rdid_, 
   {{0x55e6244f,0xf8bf0035,0x0ea49529,0x60c42450}},	//   _вооб, rmée_, _गोंड, _hoim, 
   {{0x765c2451,0x2d9a098f,0xd1760c30,0x290684e2}},	//   mary, _uspe_, рызы, tooa_, 
   {{0x270e8cca,0x64a62452,0x4fc6a453,0x39a58029}},	//   ित्र_, _тама, исла, _mēs_, 
   {{0xbc19004a,0x60c42454,0x443fa455,0x02b580c9}},	//   _бірі_, _moim, dcu_, _अचंभ, 
   {{0x5d66a456,0x765c2457,0x658a8816,0x60c42458}},	//   атиз, nary, _rəhb, _loim, 
   {{0xdce18214,0x69c7806d,0xddc3a459,0x6d450064}},	//   _aslı, øjel, ranş, _xtha, 
   {{0x399b0130,0x0ca78008,0x656e0caf,0x798e068e}},	//   _בילד, атьи_, irbh, _ipbw, 
   {{0x765c245a,0x225800d0,0xafe68cc5,0xdb060c02}},	//   kary, _kerk_, _тоал, _arké, 
   {{0x78a2a45b,0x79a6a45c,0x0f7b83dd,0xf2c6a45d}},	//   ldov, арме, _באמב, рсин, 
   {{0x3a370052,0x765c245e,0x2258245f,0x6f070024}},	//   ירים_, dary, _merk_, vojc, 
   {{0x60c40cb4,0x1beaa460,0x395ea461,0x69de0122}},	//   _coim, _идеи_, rsts_, izpe, 
   {{0xd7fb025c,0x3949a462,0x77f4a463,0x60c42464}},	//   тун_, _čase_, _अशोक_, _doim, 
   {{0x0eeb15db,0x28dd82f4,0xb05b0656,0x7e78a465}},	//   тьми_, _मतभि, tkäs, ngvp, 
   {{0x3f822466,0x7afda467,0xeda42468,0xdef82469}},	//   atku_, éste, ошто, рыя_, 
   {{0x04c900fe,0x78a2a46a,0xdce700a1,0x60d6246b}},	//   دوري_, jdov, kują, _glym, 
   {{0x644d246c,0x765c246d,0x656e0c8c,0x94190d41}},	// [1310] rbai, bary, arbh, ужат_, 
   {{0xf1a720e2,0x6e950013,0xf699246e,0x644d0015}},	//   ирен, _الدا, _свој_, sbai, 
   {{0x20f88533,0x28cc110f,0x3ce781aa,0x6d45246f}},	//   rčin_, ासचि, _जगले_, _utha, 
   {{0xa3c7a470,0x628500d8,0x271f8492,0xcd340843}},	//   _उथल_, sfho, यग्र_, _گریب, 
   {{0x443f8284,0xa3bb15c5,0x2d8300fa,0x07a5a471}},	//   vcu_, _अपि_, ltje_, салн, 
   {{0x4aa6807a,0xaaa6a472,0x6b9d0065,0x6442840a}},	//   _कोलव, _कोलक, _issg, _afoi, 
   {{0x2d832473,0xad589878,0xe299805a,0x443fa474}},	//   ntje_, арых_, қан_, tcu_, 
   {{0xfdf80039,0x66cf8142,0x84f900da,0x20f8826b}},	//   ימוש_, _køkk, ्किट_, nčil_, 
   {{0x60c4006b,0x68e9a475,0x1309a152,0x443fa476}},	//   _roim, _imed, лний_, rcu_, 
   {{0x443f8012,0xd7f8a477,0x236da478,0xa01b2479}},	//   scu_, _тус_, rrej_, rföl, 
   {{0xa0a6247a,0x66cf8142,0x39e9a47b,0x60d6247c}},	//   банд, _løkk, удно_, _plym, 
   {{0x236d8bfc,0x26c5a47d,0xa01b010d,0x90c8247e}},	//   prej_, _holo_, pföl, рғиз_, 
   {{0xfaa581e2,0x60c40008,0x6f1e011e,0x66cf80f0}},	//   _гало, _voim, _phpc, _nøkk, 
   {{0x6459a47f,0x3f822480,0x78a28f91,0x291f81df}},	//   _hewi, rtku_, zdov, _lhua_, 
   {{0x60c40185,0x64599098,0x68e9810d,0x63ab80db}},	//   _toim, _kewi, _omed, _hrgn, 
   {{0xeb9a2481,0x26c5a482,0xb05b2483,0xcd2a2484}},	//   либ_, _lolo_, skär, ужбе_, 
   {{0x63bb8659,0x2d8300fa,0x22582485,0x5baa0162}},	// [1320] nxun, atje_, _perk_, ыкам_, 
   {{0x68fba486,0x6459a487,0xf4128464,0x68e9a488}},	//   _ajud, _lewi, לפן_, _amed, 
   {{0x68fb8172,0x2722801c,0xdb042489,0x63a4811e}},	//   _bjud, _hưng_, nvié, _áinv, 
   {{0x225801d9,0x291fa48a,0x64598324,0x2cbfa48b}},	//   _werk_, _chua_, _newi, jjud_, 
   {{0x0eea836a,0x26c58038,0x7d09a48c,0x96eaa48d}},	//   льки_, _bolo_, does, лька_, 
   {{0x52752164,0xdb0282fd,0xdce70034,0x78a082b9}},	//   _мусу, _proí, rują, _wamv, 
   {{0x2b46a48e,0x644300a1,0x6b84248f,0x6459a490}},	//   _stoc_, śnie, ltig, _bewi, 
   {{0x63ab82fa,0xdce70034,0xa7fb011e,0xd497a491}},	//   _brgn, pują, lañe, брь_, 
   {{0x68e380f8,0x64598324,0xd2508013,0x26c580de}},	//   ënde, _dewi, ونة_, _folo_, 
   {{0x63ab006d,0x63a92492,0x6b842493,0x6d4a872d}},	//   ågni, _šenk, itig, ppfa, 
   {{0x2d9880ef,0x6b842494,0x7d09a495,0xd9fa01d2}},	//   _ère_, htig, boes, ्थित_, 
   {{0x6459a496,0x6b842497,0x2d9ea498,0x2ed10c2e}},	//   _gewi, ktig, _iste_, हस्त, 
   {{0xdfd8009f,0x61e0008a,0x765aa499,0x27228106}},	//   бър_, _əmla, _kety, _cưng_, 
   {{0x81de00cf,0xd9fa01cf,0xf40000b2,0xeaf58c7a}},	//   _তখন_, ्थात_, ্ধার_, ीकृत_, 
   {{0x2d9e800d,0x765aa49a,0x6b840e45,0x691881ce}},	//   _jste_, _mety, etig, víen, 
   {{0x2d830a44,0x6b84249b,0x2eeea49c,0x6288a49d}},	//   rtje_, ftig, hiff_, lfdo, 
   {{0x6b84249e,0x2d83249f,0x3ea124a0,0x6c5400a6}},	// [1330] gtig, stje_, _taht_, якту, 
   {{0x8c1b8c2d,0x68e9a4a1,0x290b24a2,0x765aa4a3}},	//   רומי, _smed, loca_, _nety, 
   {{0xfd1f010b,0x399aa4a4,0x753a835b,0x6b8424a5}},	//   _thì_, _jūs_, _nutz, atig, 
   {{0x26c5a4a6,0x7e688217,0x291f806c,0x48158f74}},	//   _solo_, _addp, _qhua_, омес, 
   {{0x66048186,0x765a90bd,0x49180115,0x2d9e8109}},	//   şikl, _bety, זקאל_, _aste_, 
   {{0x35c9a4a7,0x645f24a8,0x321ca4a9,0x3ec48ff6}},	//   игло_, laqi, _ozvy_, зишҳ, 
   {{0x765a8210,0x26c5a4aa,0x291fa4ab,0xd05d008a}},	//   _dety, _volo_, _thua_, sisə, 
   {{0x629724ac,0x93458274,0x645f008a,0x645981b2}},	//   lexo, оние, naqi, _qewi, 
   {{0x2d9ea4ad,0x8c6480fe,0x26c5a4ae,0xdcfc00f3}},	//   _este_, سطين, _tolo_, ntrā, 
   {{0x05ba24af,0x399a8029,0xdddc0019,0x386924b0}},	//   _उपलब, _būs_, zerű, _adar_, 
   {{0xe8fa24b1,0x29031a90,0x7d09a4b2,0x63bb811e}},	//   ило_, čkan_, poes, sxun, 
   {{0x160400da,0x297a00c6,0x7985011a,0x63ab868c}},	//   _शुगर_, סטרא, ithw, _trgn, 
   {{0xa3bb815e,0x68fd0217,0x940580df,0x63ab8036}},	//   _حاضر_, érda, _بوشه, _urgn, 
   {{0x386924b3,0x673ba4b4,0x63a9a4b5,0x9a298166}},	//   _edar_, _muuj, mven, _колб_, 
   {{0x63a9a4b6,0x845a24b7,0x629724a9,0x6da31495}},	//   lven, ират_, dexo, мира, 
   {{0x63a9a4b8,0x9e3ca337,0x6aa3811a,0x161e80c9}},	//   oven, _maďa, _hanf, येटर_, 
   {{0xab6600f0,0x63a4a4b9,0x6b8424ba,0x6aa380ca}},	// [1340] ювал, _áint, utig, _kanf, 
   {{0x6b8424bb,0x78a4027e,0x63a9a4bc,0x38690507}},	//   rtig, _haiv, iven, _zdar_, 
   {{0x6aa3a4bd,0x28af000d,0x78a4019b,0x9e3c80e9}},	//   _manf, _जोडि, _kaiv, _naďa, 
   {{0x765aa4be,0x6aa3a4bf,0xac760019,0x78a40149}},	//   _sety, _lanf, _بادش, _jaiv, 
   {{0x78a424c0,0x765aa4c1,0x63a980fa,0x6b8408c6}},	//   _maiv, _pety, jven, qtig, 
   {{0x356aa4c2,0x63a9a4c3,0x78a424c4,0x645d807f}},	//   арин_, dven, _laiv, ðsin, 
   {{0x20d7a4c5,0xd54780b0,0xa96724c6,0xe6da810c}},	//   _için_, опје_, _мира_, _भतीज, 
   {{0x66cb046b,0x94aa909e,0xdb0b8432,0x2fcf87c5}},	//   _yüks, ртка_, _urgê, bygg_, 
   {{0x3949a4c7,0x6aa3a4c8,0xfb868116,0xdb040a1c}},	//   _časa_, _banf, цыйн, nviï, 
   {{0xcb1a80b0,0x6aa3811a,0x63a4a4c9,0x386900bf}},	//   јќи_, _canf, _šins, _sdar_, 
   {{0x09f88013,0x7afda4ca,0x3f868569,0x2d9e8109}},	//   صفحة_, ésta, ltou_, _uste_, 
   {{0x63a99641,0x7aef82ba,0x29030284,0x78a40036}},	//   bven, éctr, čkao_, _caiv, 
   {{0x4ea724cb,0x3f86a4cc,0x63a9802d,0x6035808a}},	//   орва, ntou_, cven, _həmç, 
   {{0xa3ae0e4f,0x387f24cd,0x3f86a4ce,0xe297a4cf}},	//   किन_, żur_, itou_, _мач_, 
   {{0x78178ab2,0x290b24d0,0x7b1001ed,0x75228027}},	//   _तर्क_, poca_, häus, _khoz, 
   {{0x628e24d1,0xd5a489b9,0x38690024,0xd6da04bc}},	//   _abbo, _یہ_, _udar_, атӣ_, 
   {{0x28ab8d64,0x3d0b807a,0x645f00f8,0x68ed0295}},	// [1350] _घोषि, ावते_, raqi, _imad, 
   {{0x238e00f3,0x7e990019,0xb87b011e,0x248924d2}},	//   dējā_, _اندر_, eníx, sfam_, 
   {{0xdcfc0029,0x62970065,0x3958011a,0x0e9a0309}},	//   strā, rexo, _cwrs_, _השתל, 
   {{0x23668025,0xe5a584c9,0x798524d3,0x6ee924d4}},	//   _ovoj_, ҷики, rthw, džbi, 
   {{0x7d0d24d5,0x645d24d6,0xba7700fe,0xa4f9009b}},	//   moas, _iesi, _واست, ्कीच_, 
   {{0x645d24d7,0x6da59495,0x7d0d03da,0x63a9a4d8}},	//   _hesi, зика, loas, vven, 
   {{0xb146040c,0x645d24d9,0x6aa38401,0x68ed24da}},	//   _فیلم_, _kesi, _ranf, _omad, 
   {{0x7d0d24db,0xdd8e80fe,0x2ec81ac2,0x66d0019b}},	//   noas, اوي_, _रक्त, _väki, 
   {{0x645d24dc,0x3f86a4dd,0x6aa3a4de,0x63a980ef}},	//   _mesi, ctou_, _panf, uven, 
   {{0x68ed24df,0x645d24e0,0x443924e1,0x6721a4e2}},	//   _amad, _lesi, _lgs_, _uhlj, 
   {{0x60db84fb,0x4efa80c6,0xaf0880d8,0x66dd868e}},	//   _klum, _פלעג, _بقلم_, _cèke, 
   {{0x21060cca,0x645d24e3,0x44390009,0x2b4b0128}},	//   रवेश_, _nesi, _ngs_, _otcc_, 
   {{0x60c982a6,0x087680c6,0x78a424e4,0xe45680c6}},	//   _moem, הערט_, _vaiv, _זינט_, 
   {{0x443924e5,0x7529a4e6,0x60dba4e7,0x68ed0587}},	//   _ags_, lmez, _llum, _emad, 
   {{0x60dba4e8,0x2cf913d2,0x645d24e9,0x78a424ea}},	//   _olum, ्कूल_, _besi, _taiv, 
   {{0x0b4604f9,0x645d0beb,0x60c9a4eb,0x201e0816}},	//   знан, _cesi, _noem, ətin_, 
   {{0x7d160615,0x2d8782f4,0xdb0ba4ec,0xfc0324ed}},	// [1360] rlys, htne_, _argé, епто, 
   {{0x60db8916,0x2d87a4ee,0x691d0429,0x7d1624ef}},	//   _alum, ktne_, néen, slys, 
   {{0x7d160072,0x60c983ec,0x60dba4f0,0x2d93011e}},	//   plys, _boem, _blum, _gpxe_, 
   {{0xe0438dc7,0x645d24f1,0x7d0d24f2,0x6843a4f3}},	//   енци, _gesi, coas, енца, 
   {{0xdc370273,0x765e24f4,0x3f868065,0x6d45a4f5}},	//   _מאכט_, _kepy, utou_, íhan, 
   {{0xdee3a4f6,0xa3e50d6d,0x2d87839f,0x7522a4f7}},	//   ночи, _भेट_, ftne_, _shoz, 
   {{0x23668f4d,0x3f86a4f8,0x645d24f9,0x3ea5a4fa}},	//   _svoj_, stou_, _yesi, _dalt_, 
   {{0x60db803b,0x2900022d,0x3f86a4fb,0x18a3a4fc}},	//   _glum, _njia_, ptou_, _пасм, 
   {{0x613a001b,0x3ea587c5,0x66dd847f,0x225ca4fd}},	//   _důle, _falt_, _sèke, _pevk_, 
   {{0x6da68542,0x3ea5a4fe,0xfc3f011e,0x68ed24ff}},	//   _низа, _galt_, _maía_, _smad, 
   {{0xa7fb0217,0xdd8f8691,0x1ea9a500,0x7416a501}},	//   daña, _مول_, _باقي_, _کوشا, 
   {{0xfce38e06,0x693704b1,0x23669871,0x09f70309}},	//   _похо, _kćer, _tvoj_, למים_, 
   {{0x645d2502,0x7d0d2503,0xa3cd871c,0xbff822b4}},	//   _resi, voas, रहण_, зеях_, 
   {{0x645d2504,0x63a280bb,0xa7fb2505,0xdefb001d}},	//   _sesi, _ison, gaña, сым_, 
   {{0xa3e5000f,0x56780008,0x7d0d2506,0x765e017c}},	//   _भेज_, ября_, toas, _depy, 
   {{0x68ed02d7,0x5fbea507,0x7aee01f0,0x95c9004a}},	//   _umad, ्हाल, _ambt, буға_, 
   {{0xd90f0a0e,0x645d2508,0x7d0d002d,0xa7fb1671}},	// [1370] _لیگ_, _vesi, roas, baña, 
   {{0x63a2a509,0x645d250a,0x60dba50b,0x7d0d250c}},	//   _mson, _wesi, _slum, soas, 
   {{0x645d250d,0x63a282fa,0x68fd250e,0x60db8ee3}},	//   _tesi, _lson, onsd, _plum, 
   {{0x3ce0250f,0x63a2a510,0x629aa511,0x68fd2512}},	//   chiv_, _oson, heto, nnsd, 
   {{0x6d4a00f8,0xdcfc0123,0x63a282ee,0x6d5a89ec}},	//   _çfar, stră, _nson, _awta, 
   {{0x629aa513,0x658a8816,0x63ad2514,0x2ca92515}},	//   jeto, _təhl, mvan, ldad_, 
   {{0x63ad15ae,0x3ea5a516,0xa1942517,0x63a2a518}},	//   lvan, _valt_, _парч, _ason, 
   {{0x63ad2519,0x2d87a51a,0x66d0010d,0x2ca9251b}},	//   ovan, rtne_, _häkt, ndad_, 
   {{0x75298208,0x290f825f,0x63ad251c,0x2d87a51d}},	//   rmez, moga_, nvan, stne_, 
   {{0xa3ae150f,0x3945856b,0x2bdf001b,0xe3ca8149}},	//   कित_, мног, पैया, _soñó_, 
   {{0x7f4d052f,0x66d0010d,0x6dd5804e,0x63a2a51e}},	//   _ataq, _mäkt, _تقاض, _eson, 
   {{0x290fa51f,0x63ad2520,0x39408121,0x2ca6813b}},	//   noga_, kvan, _čist_, _gaod_, 
   {{0x2ca92521,0x691d00ef,0x272401ed,0xe79c02d2}},	//   ddad_, péen, höne_, _düğü, 
   {{0x63ad2522,0x2ca90217,0x6b89a523,0xe29680a6}},	//   dvan, edad_, mteg, _жаш_, 
   {{0x386d8354,0x290f8131,0x6f0e003e,0x6b898124}},	//   _oder_, koga_, robc, lteg, 
   {{0xf8e214ba,0x386d816c,0x2eda8f21,0xa7fb0149}},	//   _पतिय, _nder_, _भत्त, saña, 
   {{0xfa8e801c,0x6aa70a63,0x59cb812d,0xccf28039}},	// [1380] _mừng_, _bajf, ाहवर, דכן_, 
   {{0xe2972524,0x386d80f6,0xb05b1dba,0x63a6a525}},	//   мау_, _ader_, hjäl, ækni, 
   {{0xe820807a,0xd62a01bc,0x88868a4b,0x63ad2526}},	//   _बरहा_, _фоне_, длеж, avan, 
   {{0xa3bf802a,0xa3cda527,0x61ee811e,0x657c0656}},	//   ीहा_, रहा_, úbli, murh, 
   {{0x38600af6,0x6aa88324,0x8cdb00da,0x66e6a528}},	//   _meir_, yddf, नसरो, мода, 
   {{0x473380f0,0x386da529,0x3860252a,0x629a811e}},	//   вніс, _eder_, _leir_, xeto, 
   {{0xc6930052,0xe820807a,0x290fa52b,0x657c00bf}},	//   דאו_, _बरवा_, boga_, nurh, 
   {{0x32db8093,0x3eba00bf,0xdc138083,0x629aa52c}},	//   _rêya_, _lnpt_, _ağır, weto, 
   {{0xd90d8283,0x629aa52d,0xa6868103,0xfa8e8106}},	//   _این_, teto, _олад, _dừng_, 
   {{0xb6cb811d,0x7b3280a1,0x38600a5e,0x68e2a52e}},	//   _والے_, _tłum, _aeir_, lhod, 
   {{0x9486a52f,0x629aa530,0x658a8816,0x66d01998}},	//   _жылд, reto, _məhk, _läks, 
   {{0xa3de1032,0x63a2a531,0x63ad03d2,0x75498019}},	//   तना_, _tson, yvan, őszö, 
   {{0x8c43a532,0x386000fe,0xe7842533,0x3eba00db}},	//   _рече, _deir_, куро, _bnpt_, 
   {{0xe1ef9692,0x7ce30073,0x3eba011e,0x63ad2534}},	//   اسی_, _kõrg, _cnpt_, vvan, 
   {{0x9f342535,0xdc3a07fa,0xc32780fe,0x290fa536}},	//   тері, _açık, _تكون_, yoga_, 
   {{0x63ad2537,0xadf18689,0x44222538,0x38602539}},	//   tvan, _अइसन_, _bzk_, _geir_, 
   {{0x2ca917e4,0x68e284e1,0x290fa53a,0xa7fb0530}},	// [1390] rdad_, dhod, voga_, maño, 
   {{0x26cca53b,0x60cd253c,0xcf271652,0x63ad253d}},	//   _nodo_, _hoam, _تربي, rvan, 
   {{0x63ad253e,0x6b898109,0x290fa53f,0x63bb0105}},	//   svan, zteg, toga_, _šund, 
   {{0xf4230a1c,0x63ad01f0,0xf86980d8,0x2fe402d2}},	//   _үзүү, pvan, سمتي_, _örgü_, 
   {{0x26cca540,0x6aa706c3,0xfa8e801c,0x752d2541}},	//   _bodo_, _tajf, _rừng_, mmaz, 
   {{0x752d0068,0x26cc833b,0xaaad802a,0x290fa542}},	//   lmaz, _codo_, _झोंक, soga_, 
   {{0x0445a543,0x27e6840a,0x3d0ba544,0x68e2a4fd}},	//   нейн, azon_, ावले_, bhod, 
   {{0x68e28fb9,0x27e682d2,0x60cd0050,0x4c85a545}},	//   chod, bzon_, _noam, хлив, 
   {{0x7e63a546,0x248d868c,0xe3b18c85,0x38602547}},	//   panp, rfem_, ارب_, _reir_, 
   {{0x0c2290ea,0x7c228a63,0x5fbea548,0x38602549}},	//   ымын, _dzor, ्हरल, _seir_, 
   {{0x6b89a54a,0xfa8e8028,0x78a982f4,0x46c3001b}},	//   steg, _từng_, _kaev, शानह, 
   {{0xc6890757,0x26c7803b,0x98b880f3,0x7e61a54b}},	//   _לא_, ljno_, _kurā_, _help, 
   {{0xbd2c896e,0x9522811d,0x6d41a54c,0x752d0934}},	//   _וואָ, _حکوم, _hula, dmaz, 
   {{0x68e28a93,0x78a9a54d,0x6da6254e,0xd36ea54f}},	//   zhod, _laev, нига, _اهو_, 
   {{0x6d41a550,0x38602551,0x7d09029f,0x44222552}},	//   _jula, _teir_, česn, _szk_, 
   {{0x6d41a553,0x64a32554,0xdca32453,0x76938646}},	//   _mula, ласа, ласи, lıyı, 
   {{0xeb9710b5,0xac070002,0x68e29ee3,0x6d41a555}},	// [13a0] нит_, ента_, vhod, _lula, 
   {{0xe9ff810b,0x7d1b82ae,0x7e61a556,0xdb0b8217}},	//   _giải_, hlus, _nelp, _orgí, 
   {{0x7d1ba557,0xae5b0052,0xd9108068,0x6d41a558}},	//   klus, _מכיר, لیس_, _nula, 
   {{0xa01b00f9,0x38608013,0x26cc8162,0x68e281d2}},	//   mför, úir_, _sodo_, uhod, 
   {{0x6d41a559,0xa01b0172,0x26cca55a,0x7d1b82f4}},	//   _aula, lför, _podo_, dlus, 
   {{0x6d41a55b,0xb5a6a55c,0x6e94a55d,0x3da681e5}},	//   _bula, ерий, тику, ериб, 
   {{0x68e28f6b,0x6d41a55e,0x40969ea1,0xa01b255f}},	//   phod, _cula, _прат, nför, 
   {{0x629e2560,0x6d41a561,0xf8bf0019,0x7ce302f4}},	//   lepo, _dula, rmék_, _võrg, 
   {{0x26cc9151,0xa2c40ed9,0x6d41a562,0x2904a563}},	//   _todo_, राप्, _eula, _ijma_, 
   {{0x7c2292b2,0x6d41a564,0x60cd2565,0xa01b0172}},	//   _vzor, _fula, _soam, kför, 
   {{0x6d41a566,0x7c228034,0x5cd687c5,0x7d1ba567}},	//   _gula, _wzor, _підх, blus, 
   {{0x660907fa,0xa01b0172,0x7d1ba568,0xfbe0002a}},	//   şekk, dför, clus, फनाम, 
   {{0x7c228a5a,0x60cd01cb,0x673a81cb,0x6d41a569}},	//   _uzor, _voam, _kitj, _zula, 
   {{0x629e256a,0x66d00172,0x661aa56b,0x673a837f}},	//   jepo, _säkr, _kytk, _jitj, 
   {{0xa7fb1310,0x6594256c,0xdd940ceb,0xa2c4256d}},	//   paño, лару, лары, रान्, 
   {{0x57b5256e,0xf48400a6,0x752d011e,0x6aaa86d1}},	//   _абит, луун, umaz, _haff, 
   {{0x752d256f,0x6aaaa570,0x2f1600c0,0xd3711d06}},	// [13b0] rmaz, _kaff, tægt_, شها_, 
   {{0x6aaaa571,0x629e2572,0xff5000d8,0x78a9854d}},	//   _jaff, gepo, _اخي_, _saev, 
   {{0x07360309,0x7d1b843a,0x317ea573,0x661a8656}},	//   _שאתם_, ylus, nutz_, _nytk, 
   {{0x6ee200e9,0x6d41a574,0x98bd034e,0x00000000}},	//   _vôbe, _rula, _ouvč_, --, 
   {{0x6d41a575,0x07a599dc,0x317e81ed,0x7ce30079}},	//   _sula, талн, hutz_, _võrd, 
   {{0x6d41a576,0xa3ae0689,0xcf9400c6,0x629e2577}},	//   _pula, किर_, רטס_, cepo, 
   {{0xf2d2015c,0xdcfa8876,0x6b8d062a,0x7d1b8073}},	//   _דעם_, _artı, ltag, tlus, 
   {{0xdb0608af,0x6281a578,0x24868064,0xdb1b811e}},	//   _erkä, wglo, _ccom_, rxuí, 
   {{0x7d1ba579,0x7e61a57a,0x6aaa8371,0x6b8d1c6c}},	//   rlus, _telp, _baff, ntag, 
   {{0x6aaaa57b,0x7d1ba57c,0x9e678068,0xccf881d2}},	//   _caff, slus, _سائن, _svět_, 
   {{0x7d1ba57d,0x05748125,0x6d418786,0xc0e6257e}},	//   plus, _ماند, _uula, вонк, 
   {{0xe37584a0,0x63ad88dc,0xa01b010d,0x6b8d257f}},	//   _алды, _šanu, vför, ktag, 
   {{0xa8568039,0x660486c8,0x9cd68309,0x62952580}},	//   כירה_, şikt, _שונה_, _obzo, 
   {{0xe1f1840c,0x6b8d2581,0x249fa582,0x658a8816}},	//   _پست_, dtag, leum_, _səhi, 
   {{0xe7372583,0x213b2584,0x8d6304c7,0x925880d8}},	//   тер_, _fiqh_, ивре, _أشهر_, 
   {{0xa3ae023b,0xa01b2585,0x2cada586,0x6aaaa587}},	//   किल_, rför, nded_, _zaff, 
   {{0x93432588,0xa01b00f9,0xcb672589,0x6b8d1134}},	// [13c0] инте, sför, кате_, gtag, 
   {{0xf1fa258a,0xa01b010d,0x8c3d8fde,0x249fa58b}},	//   وعات_, pför, leşd, heum_, 
   {{0x629e258c,0xfaa3258d,0xcb1283dd,0xa2c415ad}},	//   repo, рахо, סלב_, राब्, 
   {{0x629e258e,0x673aa58f,0x080a80df,0x1b4a03ad}},	//   sepo, _sitj, وزشي_, _озми_, 
   {{0x2cada590,0x673aa591,0x2ca00079,0xa07385cf}},	//   dded_, _pitj, meid_, ргіч, 
   {{0xc7d70052,0x2ca0138f,0xf4130039,0x63a42592}},	//   כוני_, leid_, _כפר_, mwin, 
   {{0x6aaaa593,0x5fa9000f,0x888482e5,0x63a42594}},	//   _raff, _चैनल, _میان, lwin, 
   {{0x4420801c,0x2ca002f4,0x249f83df,0xfd0f80d8}},	//   _ơi_, neid_, geum_, يجي_, 
   {{0xccf30052,0x2b4600fe,0x63a42595,0x673a81bb}},	//   יכה_, íoch_, nwin, _titj, 
   {{0x2ca02596,0x21292597,0x2d9a072c,0x63ab006d}},	//   heid_, _shah_, _oppe_, ægni, 
   {{0x60f92598,0x63a42599,0xfbcf8c0b,0xc27b1176}},	//   ення_, hwin, متی_, וריי, 
   {{0x6aaaa59a,0x63a4259b,0x6b8d259c,0xcd369866}},	//   _waff, kwin, ytag, _شراب, 
   {{0x6aaa82a1,0x44208106,0x4432a59d,0x2ca002f4}},	//   _taff, _ái_, _ày_, deid_, 
   {{0x4426840e,0x2d47259e,0x2902085a,0x6b8d259f}},	//   _izo_, _põe_, anka_, vtag, 
   {{0x63a425a0,0x19a7864e,0x44268050,0x69dca5a1}},	//   ewin, _атып_, _hzo_, øred, 
   {{0x6b8d25a2,0x200901df,0x2ca0054d,0xba378309}},	//   ttag, _txai_, geid_, _בטוח_, 
   {{0xbab902cb,0x3949807e,0x63a425a3,0x613a80ac}},	// [13d0] нгах_, _časi_, gwin, _půln, 
   {{0x6b8d25a4,0x24730028,0x7a40026b,0xbb1900fe}},	//   rtag, ệm_, vští, رياض_, 
   {{0x6b8d25a5,0x45d525a6,0x2ca025a7,0x7afda5a8}},	//   stag, _сонс, beid_, ésti, 
   {{0xf7719ae3,0x63a40889,0xf2df002d,0x2ca00097}},	//   مات_, bwin, _atât_, ceid_, 
   {{0xd7f58bb3,0x747a0039,0x78ad02f4,0x7f198116}},	//   ызды, _אנרג, _maav, ніку_, 
   {{0x6d4525a9,0x753d25aa,0x6f1525ab,0x3ebea5ac}},	//   _kuha, _hisz, nozc, _cntt_, 
   {{0x44268573,0x6d45041a,0x753d0019,0x29880e21}},	//   _azo_, _juha, _kisz, _исто_, 
   {{0x644d25ad,0xf3f98123,0x60dd093c,0xd9288166}},	//   ncai, laţi_, jksm, _ацул_, 
   {{0x249f8385,0xe7968139,0x2cada5ae,0x58d483ad}},	//   reum_, _مالک, rded_, _тотт, 
   {{0x63ad803a,0xdb0400b0,0x628525af,0x2fd90324}},	//   _šans, rviç, ngho, dysg_, 
   {{0x5dd588a4,0x44268371,0xa2c403f2,0x644d00db}},	//   _حقائ, _ezo_, रात्, kcai, 
   {{0xcea90c2d,0x78ad0065,0xf4878251,0x63a40c20}},	//   _מי_, _caav, _јужн, ywin, 
   {{0x645ba5b0,0x7f44161e,0x776081df,0x8e760103}},	//   mbui, _quiq, _xwmx, лувч, 
   {{0x6d4525b1,0x201e00f3,0x99d581ae,0xf3f98166}},	//   _buha, āti_, _متبا, jaţi_, 
   {{0xfce625b2,0x2ca00079,0xe296809f,0x63a425b3}},	//   гово, teid_, _сащ_, wwin, 
   {{0x30ae80b2,0x6d4525b4,0x03a60fbe,0xee370aad}},	//   _কক্স, _duha, либо, унс_, 
   {{0x68e425b5,0x2ca025b6,0x0c2625b7,0x6d4525b8}},	// [13e0] _ilid, reid_, уман, _euha, 
   {{0xa2c425b9,0x2ca00073,0x63a40461,0x6aa180db}},	//   राध्, seid_, rwin, nelf, 
   {{0x3f8225ba,0x6d45029a,0x394f802d,0x2d9a0172}},	//   luku_, _guha, _însă_, _uppe_, 
   {{0x7d7b0130,0x74550574,0x600a8116,0xa3e380a1}},	//   _אנטו, _върх, ннем_, नना_, 
   {{0x7d0425bb,0xa2c405c9,0x6d4525bc,0x3f8225bd}},	//   mnis, राद्, _zuha, nuku_, 
   {{0xf3f9802d,0x9f34804a,0x765c25be,0xe16600d8}},	//   caţi_, шелі, nbry, _مدري, 
   {{0x7d0d92b2,0x3f820232,0x68e425bf,0x23670269}},	//   časn, huku_, _olid, ćnje_, 
   {{0x3374a5c0,0x3f8225c1,0x7d041419,0x442697a2}},	//   агир, kuku_, nnis, _pzo_, 
   {{0xd70a81f5,0x7d0425c2,0x3f8212ef,0xb5c6804a}},	//   _знае_, inis, juku_, _әйел, 
   {{0xbda6807b,0x78ad01c4,0x7d0425c3,0x68e425c4}},	//   _محصو, _saav, hnis, _alid, 
   {{0x7d040eb9,0x79948692,0x527b00c6,0x765c23ca}},	//   knis, шинф, ענטא, dbry, 
   {{0x3386a5c5,0x27e625c6,0x6d4525c7,0x3f8225c8}},	//   _букв, _żona_, _ruha, fuku_, 
   {{0x6d4525c9,0x3f8225ca,0x60dd25cb,0x64428347}},	//   _suha, guku_, rksm, _igoi, 
   {{0x6d4525cc,0x7d0425cd,0x6234a5ce,0xf1a68340}},	//   _puha, enis, _келу, _брин, 
   {{0x59a40066,0x753d25cf,0x78ad1562,0x7afaa5d0}},	//   _गैलर, _pisz, _taav, mitt, 
   {{0x7afaa5d1,0x545525d2,0x3f8225d3,0x6d4525d4}},	//   litt, рват, buku_, _vuha, 
   {{0x753d0068,0x644d25d5,0xf3f98123,0xe020810c}},	// [13f0] _visz, rcai, taţi_, _बरगद_, 
   {{0x644d25d6,0x7afaa5d7,0x657a0a5e,0x35f525d8}},	//   scai, nitt, áthc, _впор, 
   {{0x753d0068,0x4394005a,0x7d0402ae,0x658a808a}},	//   _tisz, _қарс, bnis, _məhs, 
   {{0x7afaa5d9,0x6aa18a44,0xe82082f4,0x3ea32261}},	//   hitt, zelf, _बरखा_, lejt_, 
   {{0x629898d4,0x938b25da,0x2d910109,0xd5b88e1b}},	//   _obvo, _ясна_, ltze_, _arā_, 
   {{0xd9f6902c,0x4b7a03f3,0x6fb6a47e,0x60c0834e}},	//   ुपात_, _באשו, шҳур_, _enmm, 
   {{0x2d8309d8,0x7afaa5db,0x249900bf,0x2d910122}},	//   nuje_, ditt, _kbsm_, ntze_, 
   {{0xeb99a5dc,0x09e1078b,0x2909004f,0x67d591e0}},	//   вии_, पनीय, _njaa_, _кобу, 
   {{0x2d830c3f,0xacc681e5,0xb4d58bda,0xe787a5dd}},	//   huje_, ргыз_, _सकी_, _љубо, 
   {{0x3ae400f9,0x6442a5de,0x7afaa5df,0x3f820284}},	//   _köpa_, _egoi, gitt, vuku_, 
   {{0x41060947,0x20c604da,0xdeba83dd,0x7d0425e0}},	//   изов, айнм, _שמעל, ynis, 
   {{0x3c478013,0x6aa187b8,0xab9580f0,0xf53080d8}},	//   _إضاف, self, _виді, _فإن_, 
   {{0x3949a2e3,0x7d040081,0xf7460f4c,0x7d04a5e1}},	//   _času_, vnis, рего, čist, 
   {{0x3f82003b,0x69daa5e2,0x26d3011e,0x7afa8495}},	//   ruku_, byte, _coxo_, citt, 
   {{0x7d0425e3,0x3f8225e4,0x6da61a59,0x765c25e5}},	//   tnis, suku_, шива, rbry, 
   {{0x3f8225e6,0x81bd00b2,0x26f285c9,0x7ce302f4}},	//   puku_, েনা_, _अग्र_, _põra, 
  
   {{0x26d303b9,0x7d041c6c,0x5a6625e7,0x626603b8}},	// [1400] _foxo_, rnis, икаб, иваа, 
   {{0x2d8325e8,0x42560e19,0xeb9725e9,0x394786a4}},	//   buje_, ртат, риф_, _kuns_, 
   {{0x50668daa,0x867b00c6,0x7e7b0039,0xc6930039}},	//   атла, _בריו, _באיז, _ואת_, 
   {{0xe7b30c0b,0xa2c40b30,0x7afaa5ea,0x7c96077a}},	//   _امید, राह्, zitt, _троц, 
   {{0x27e0830b,0x39478659,0x442425eb,0x213f82ef}},	//   áin_, _luns_, _ám_, _diuh_, 
   {{0x78a2a5ec,0xa2e60008,0x64428048,0xdd9aa5ed}},	//   seov, _тогд, _sgoi, вши_, 
   {{0x356784a0,0x3947a5ee,0x7afa8576,0xf8bf00ef}},	//   арын_, _nuns_, vitt, llée_, 
   {{0xd94325ef,0x3d10a5f0,0x394025f1,0x63b99725}},	//   _фети, ावें_, _niis_, _brwn, 
   {{0x6676807b,0x7afaa5f2,0xb4d6809b,0x2b468106}},	//   _ندار, titt, _हवी_, _quoc_, 
   {{0xf2d300c6,0xf2df0106,0x69daa5f3,0x4ac90fa9}},	//   ַער_, _luân_, tyte, रायव, 
   {{0x7afa9655,0x394783b9,0x6f18a5f4,0x26d325a8}},	//   ritt, _cuns_, movc, _roxo_, 
   {{0x7afaa5f5,0x2d83003e,0x39498533,0x394784e0}},	//   sitt, vuje_, _čast_, _duns_, 
   {{0xcb548275,0x6d48a5f6,0x658a8816,0x893780c6}},	//   _انتظ, _huda, _təhs, ירטע_, 
   {{0xdefb01e2,0x6d48a592,0x6f18a5f7,0x3ce681df}},	//   тым_, _kuda, novc, _hlov_, 
   {{0x998480fe,0x69da816c,0x272980d8,0x3ea3016c}},	//   _العو, qyte, núna_, rejt_, 
   {{0x6d48a576,0x3ea325f8,0x657a00fe,0xf8bf25f9}},	//   _muda, sejt_, átha, rmés_, 
   {{0x3a751b24,0xc2991c66,0x213f8645,0x26d30065}},	// [1410] йлар, лках_, _riuh_, _toxo_, 
   {{0xa2c40795,0x291925fa,0x68fd25fb,0xddc38123}},	//   राष्, losa_, lisd, nanţ, 
   {{0xc98725fc,0xf9f900d8,0x6f18a5fd,0x80cb81a2}},	//   рузи, دفاع_, dovc, _सचदे, 
   {{0x68fd1a05,0xb4d5a208,0x112880f0,0x6d570122}},	//   nisd, _सके_, аючи_, _itxa, 
   {{0x38691f07,0x2d9ea5fe,0x6d480170,0x291902fb}},	//   _mear_, _apte_, ídav, iosa_, 
   {{0x6d48a5ff,0xef188ad0,0x9a842600,0x386900d8}},	//   _buda, амі_, _мусл, _lear_, 
   {{0x29192601,0x6d48a602,0xa2c40c91,0x7ae700bf}},	//   kosa_, _cuda, रार्, _iljt, 
   {{0x6d48a603,0x24892604,0xf2df001c,0xe91980f0}},	//   _duda, ngam_, _xuân_, _собі_, 
   {{0xdd02061c,0x6d48a605,0x39402606,0xcdc5a607}},	//   šuću, _euda, _riis_, раққ, 
   {{0x39402608,0x76450324,0x6d48a609,0xcac98d6e}},	//   _siis_, _nghy, _fuda, угое_, 
   {{0x186a2282,0x6d5701c8,0x2919260a,0x6b8401f0}},	//   лани_, _ntxa, fosa_, zuig, 
   {{0xcd968039,0x3869260b,0x2919260c,0x6288a49d}},	//   _לדעת_, _cear_, gosa_, agdo, 
   {{0xe8f7260d,0x39400079,0x6d57163b,0x69cea60e}},	//   сля_, _viis_, _atxa, øber, 
   {{0x7c2b8025,0x63a9a60f,0x6d48a610,0xddc38123}},	//   _izgr, mwen, _yuda, canţ, 
   {{0x63a9a611,0x6d48a612,0x39402613,0x649a19a6}},	//   lwen, _xuda, _tiis_, лтар_, 
   {{0x3991a614,0xf2df0028,0x6b842615,0xb4d59e8b}},	//   más_, _quân_, tuig, _सको_, 
   {{0x3991811d,0x60c42616,0xe29a2617,0x63a9a618}},	// [1420] lás_, _inim, лаа_, nwen, 
   {{0x16aa0cd9,0xff2607e4,0x386919a4,0x7b1d875d}},	//   _свои_, _ымпо, _zear_, cèut, 
   {{0xe29702cb,0x38692619,0x63a9a61a,0xbed700c6}},	//   сах_, _year_, hwen, _הויז_, 
   {{0xb4d68e7b,0x6d5c0d30,0x6d48a61b,0x63a9a61c}},	//   _हवे_, mpra, _ruda, kwen, 
   {{0x6d48a61d,0x351b0052,0xdefa81e5,0x64460128}},	//   _suda, _תוכנ, лык_, _igki, 
   {{0x3ce6826b,0x39918019,0x7524261e,0x6ffc00f3}},	//   _slov_, kás_, lliz, mācī, 
   {{0x60c40025,0x6d5c0246,0xfe6f8061,0x6f18a61f}},	//   _onim, npra, ردو_, rovc, 
   {{0x39918068,0x442207b8,0x3b548675,0xdbdd00e9}},	//   dás_, _kyk_, окир, zšír, 
   {{0x96969d51,0x64460645,0xddc3802d,0x6f18a620}},	//   _греш, _mgki, tanţ, povc, 
   {{0x6d48a621,0x49748f4c,0x38690304,0x2ca4a622}},	//   _tuda, олос, _sear_, semd_, 
   {{0x629c0210,0x442207b8,0xddc38123,0xba9b03f3}},	//   _mbro, _lyk_, ranţ, נסטי, 
   {{0x23c802f4,0xa19385cf,0x7aef8741,0x63a981ca}},	//   रमाद, чаюч, èctr, bwen, 
   {{0x7afe012b,0x5f942180,0xd7fb0741,0x53a39a91}},	//   kipt, пият, уун_, _нацб, 
   {{0x29192623,0x39918019,0xb5fc8208,0x7afe016c}},	//   sosa_, bás_, _reġj, jipt, 
   {{0x29192624,0x1dbda23f,0x6d5c213d,0xf3ff0da7}},	//   posa_, ्मयत, gpra, _peão_, 
   {{0x99860066,0x44222625,0xddc380f3,0x657c856e}},	//   łoś_, _byk_, nanš, _århu, 
   {{0x8b5800d8,0x629c0097,0x24892626,0x2d730a63}},	// [1430] مجلس_, _bbro, rgam_, sće_, 
   {{0x75242627,0x2d732628,0x3a75004a,0x3f86811e}},	//   aliz, pće_, ілер, duou_, 
   {{0x75242629,0x66d00008,0x7f3c00c6,0x1a9b80c6}},	//   bliz, _näky, _געזו, ריבע, 
   {{0x63a9a62a,0x9bc7027a,0xad27042b,0x3869812b}},	//   ywen, _лёгк, _درخو, úar_, 
   {{0x39918068,0x7c22a62b,0x63a981b2,0x7f49a62c}},	//   zás_, _nyor, xwen, _queq, 
   {{0x8d558002,0xab5b02ae,0xe739a62d,0xb579a62e}},	//   отич, _prüf, шел_, ащих_, 
   {{0xc05b805a,0x6d42a62f,0xed59a630,0x63bd00db}},	//   _біз_, _bioa, шой_, _hrsn, 
   {{0x7cfe9523,0x6d42a631,0x68e2a632,0x63bd0259}},	//   tūra, _cioa, ckod, _krsn, 
   {{0x69dc8c05,0x63a98a44,0x4fc7a633,0x63bb0105}},	//   øren, uwen, _усва, _šunj, 
   {{0x60c4003a,0x3991a634,0x81d480cf,0x68e9800d}},	//   _snim, tás_, _সেই_, _hled, 
   {{0x3ea78618,0x63a98504,0x68e9a635,0x5455832a}},	//   ment_, swen, _kled, _двет, 
   {{0x2d87a636,0x3ea0806a,0x6d5c007e,0x3ea7a637}},	//   mune_, đite_, vpra, lent_, 
   {{0x7c228068,0x7d248008,0xb05b0172,0x7c2ba638}},	//   _gyor, _эффе, tjär, _uzgr, 
   {{0x442206a4,0x6d5c2639,0xfaa28188,0x68e2a63a}},	//   _ryk_, tpra, _жашо, zkod, 
   {{0x3ea782c0,0x82378267,0x7d09a63b,0x290d8065}},	//   ient_, _ارشا, ones, _ojea_, 
   {{0x7d1ba63c,0xe45a032a,0x3958263d,0x2a6a00f6}},	//   nous, ржа_, _rtrs_, _sebb_, 
   {{0x3ea7a63e,0xa11300fe,0x2a7800db,0x7524263f}},	// [1440] kent_, _تويت, _pdrb_, rliz, 
   {{0x68fba640,0x2d87a641,0x6d5c2642,0x3ea7a643}},	//   _amud, kune_, ppra, jent_, 
   {{0x8c461418,0x7afe2644,0x3ea7a645,0x2d87a646}},	//   _мене, ript, dent_, june_, 
   {{0x4fc681bc,0x3f868f3a,0xa99a80c6,0x2d8796f4}},	//   жска, tuou_, יבער, dune_, 
   {{0x7d1b81e0,0x7d09068c,0xddc3808d,0xbba88895}},	//   dous, čest, vanš, _कनेक, 
   {{0x7afe08fb,0x3ea78c3d,0x68e2a647,0x6f1c2648}},	//   qipt, gent_, skod, norc, 
   {{0xbb431248,0xc44881a1,0xf9878275,0x30768a09}},	//   _церк, میان_, _تب_, _муас, 
   {{0xd497a649,0x7d1ba64a,0x151780fe,0xd25080df}},	//   орь_, gous, يزية_, کند_, 
   {{0x3ea7a64b,0x39448108,0xcb0aa64c,0xe7a90034}},	//   bent_, _iims_, иход_, _चैंप, 
   {{0x3ea7a64d,0x2126a64e,0x7d09a64f,0xb5fc81bb}},	//   cent_, lloh_, anes, _leġi, 
   {{0x2d87a650,0x3958a651,0x6e93803d,0x7d1ba652}},	//   cune_, ërs_, _آلما, bous, 
   {{0x7d1ba653,0xeb9a8ad5,0x6d5aa654,0x6ec281cc}},	//   cous, _вид_, _itta, लाकु, 
   {{0x776202d1,0x6f1c2655,0x5ead85a2,0x7afc24fd}},	//   _çoxl, forc, চারে, _omrt, 
   {{0x3f508028,0x6f1c0024,0x6131837c,0x63a28129}},	//   _màu_, gorc, måle, _ipon, 
   {{0xd5b81de0,0x3eb3008a,0xfc3f801b,0x2b4b01e9}},	//   ост_, _vaxt_, žít_, _succ_, 
   {{0x3ea7a656,0x7d00a657,0x1fa72658,0x9f6b10f3}},	//   zent_, nims, _дрог, _кроз_, 
   {{0x9647077a,0x200c0816,0x3ea7a659,0x4394265a}},	// [1450] _мэнд, şdir_, yent_, матс, 
   {{0x7d09a65b,0x6d5a8bbb,0x68fba65c,0xd25b265d}},	//   znes, _otta, _smud, рца_, 
   {{0x3ea7a65e,0x7d00a65f,0xdcf50034,0xa2b281d2}},	//   vent_, kims, erzą, _असन्, 
   {{0x63a2a660,0x76550034,0x394489b2,0x7d1b8065}},	//   _opon, lczy, _cims_, xous, 
   {{0x6d5aa661,0x7d09a662,0x98c60284,0x995401d2}},	//   _atta, vnes, šući_, _výše_, 
   {{0x2d87a663,0x643a0273,0x63ad06d0,0x2ca92664}},	//   tune_, _לערנ, mwan, lead_, 
   {{0x63ad2665,0x7d1ba666,0x3ea78219,0x69dc872c}},	//   lwan, tous, rent_, ørel, 
   {{0x3ea7a667,0x68fba668,0x2ca92669,0x2d87a66a}},	//   sent_, _umud, nead_, rune_, 
   {{0xff538b95,0x7d1ba66b,0x63ad266c,0x6d5a82ee}},	//   _آخر_, rous, nwan, _etta, 
   {{0x2ca9266d,0x63a000f9,0xdd008029,0x291da66e}},	//   head_, _ämne, ētāj, lowa_, 
   {{0x63ad266f,0x386da670,0x7d1ba671,0x63a2a672}},	//   hwan, _keer_, pous, _epon, 
   {{0x63ad2673,0x237594f9,0x7aeaa674,0x7cf10072}},	//   kwan, _فاتح, _elft, _hårf, 
   {{0x386d938a,0xb5fc8208,0x63ad2675,0x7cee8097}},	//   _meer_, _reġi, jwan, _dùrd, 
   {{0x386da676,0x63ad0232,0x291da677,0x27328123}},	//   _leer_, dwan, howa_, când_, 
   {{0x1dbd88dd,0xa928826b,0x09e5a678,0xed5a0fbe}},	//   ्मित, ližš, _хойн, соб_, 
   {{0x2ca90064,0x7afc06f4,0x6f1c016f,0x386d8387}},	//   gead_, _smrt, sorc, _neer_, 
   {{0xfc3f04e0,0x291d80a1,0x63ad2679,0x2d83267a}},	// [1460] _saír_, dowa_, gwan, arje_, 
   {{0x2902267b,0xe81f875c,0x78b6267c,0x6b960172}},	//   lika_, _बड़ा_, _hayv, rtyg, 
   {{0xb87b08a3,0x5ba880da,0x399504ff,0x6edb0309}},	//   chís, _कन्व, gås_, _החיפ, 
   {{0x2902267d,0x2fc001a3,0x63ad267e,0x3eaa01ab}},	//   nika_, _krig_, bwan, lebt_, 
   {{0x4cbb0052,0x2d98267f,0xdcfc0029,0x6b8985a2}},	//   _הזכו, ltre_, strē, jueg, 
   {{0x29022680,0x6d462681,0xb4b4810c,0x6b842682}},	//   hika_, _hika, _छोड़_, mrig, 
   {{0x29022683,0x6d462684,0x2d982685,0x291da686}},	//   kika_, _kika, ntre_, bowa_, 
   {{0xe0559272,0x94aa8be6,0x6eeb0816,0x6d4604c4}},	//   _قیمت_, стка_, _müba, _jika, 
   {{0x6d462687,0x29022688,0x6b842689,0x7f4a8267}},	//   _mika, dika_, nrig, _طلاق_, 
   {{0x386d8a44,0x61e1a68a,0x248d83b8,0xdb0d03b8}},	//   _zeer_, fyll, agem_, rvaç, 
   {{0x2902268b,0x6b84268c,0x6d5a99b8,0xbc6a803d}},	//   fika_, hrig, _utta, _همان_, 
   {{0x63ad0066,0x2fc00324,0xc058004a,0x9f4e0170}},	//   ywan, _brig_, зір_, žným_, 
   {{0x613f0029,0x386981c2,0xb4db0741,0x27328123}},	//   _jūli, ðari_, _diàl, pând_, 
   {{0x4426a68d,0xa3c209d7,0x6d46036d,0xa3c00562}},	//   _iyo_, ्मन_, _aika, ंटन_, 
   {{0x26da0574,0x6d46268e,0xcb138273,0x2902268f}},	//   _dopo_, _bika, _אלס_, bika_, 
   {{0x6d462690,0xe81e12b9,0x44268371,0x2d8300f8}},	//   _cika, _युवा_, _kyo_, rrje_, 
   {{0x2d9c19e7,0x6d462691,0xa87c0052,0x57c6809b}},	// [1470] _även_, _dika, _האחר, लमोह, 
   {{0x63ad059d,0x6eef8022,0x7cea003e,0x39951101}},	//   rwan, _købe, _výra, tås_, 
   {{0x68ed0802,0x63ad03ec,0x6d462692,0x291da693}},	//   _klad, swan, _fika, towa_, 
   {{0xf1c0010b,0xf7718629,0x399500f9,0xddde001b}},	//   ương_, نات_, rås_, _nepř, 
   {{0x68ed1f4a,0x291da694,0x6eef8142,0x799701df}},	//   _mlad, rowa_, _løbe, stxw, 
   {{0x386d81d9,0x291da695,0x6d462592,0xd24680fe}},	//   _weer_, sowa_, _zika, _لن_, 
   {{0xfe708dac,0xc9842696,0x4426a697,0x67218bfc}},	//   اده_, _пути, _ayo_, _vklj, 
   {{0x7d0d204c,0x4426a698,0x61120f30,0x29022699}},	//   nnas, _byo_, kāla, xika_, 
   {{0x248da69a,0x4426829a,0xdb1d269b,0x61e1811a}},	//   rgem_, _cyo_, _arsé, wyll, 
   {{0x6721803a,0x68ed269c,0x7cf1269d,0x7d0d0324}},	//   _uklj, _alad, _hård, hnas, 
   {{0x29022550,0x68ed149e,0x6f03a69e,0x60db8246}},	//   tika_, _blad, minc, _koum, 
   {{0x68ed269f,0x61e1a6a0,0x7d0d0269,0xe45f010d}},	//   _clad, ryll, jnas, _snön_, 
   {{0x61e18360,0x6d4626a1,0xdb0f26a2,0x26da26a3}},	//   syll, _rika, _escé, _popo_, 
   {{0x68ed26a4,0x2d9826a5,0x290226a6,0x6d4626a7}},	//   _elad, ttre_, sika_, _sika, 
   {{0xceb287a6,0xf74326a8,0x60c9a6a9,0x290226aa}},	//   כים_, теро, _onem, pika_, 
   {{0xd1320bb7,0x2d9826ab,0x7d0d007f,0x60dba6ac}},	//   _جمع_, rtre_, gnas, _noum, 
   {{0xeb9726ad,0x26da26ae,0x6f038103,0xddc726af}},	// [1480] мит_, _topo_, kinc, rajš, 
   {{0x6d460318,0xa01b26b0,0x60c9a6b1,0x7c260170}},	//   _wika, rgöt, _anem, _vykr, 
   {{0x6d4626b2,0x6f03a6b3,0x644b81e9,0x8102002a}},	//   _tika, dinc, _oggi, _लगाओ_, 
   {{0x6b8426b4,0x61e30f4a,0x236000fa,0xa3bf801b}},	//   prig, ønla, ppij_, ुमा_, 
   {{0x4f579fbc,0x60db8c43,0x6f0391ae,0x75298e02}},	//   وجود_, _doum, finc, dlez, 
   {{0x644b8574,0x7d0426b5,0x7529a6b6,0x75228bfc}},	//   _aggi, liis, elez, _skoz, 
   {{0x1ea980fe,0x4096a6b7,0x7ae30008,0xa01b26b8}},	//   ثاني_, _орат, önte, ngör, 
   {{0x7529a6b9,0x29028172,0x4426a6ba,0x629e26bb}},	//   glez, _öka_, _pyo_, lfpo, 
   {{0x3866a6bc,0x6f0383bf,0xdb040065,0x2aaaa6bd}},	//   mbor_, binc, lviñ, отно_, 
   {{0x68ed0798,0x6d5e003b,0x2b4780a6,0x65c6809f}},	//   _slad, _otpa, _cinc_, _обза, 
   {{0x6d5e8a93,0x68ed0022,0x7d0426be,0x7cf110bd}},	//   ípad, _plad, kiis, _håre, 
   {{0x80e080cf,0x4426a6bf,0x7cf10072,0xf503a6c0}},	//   পোর্, _tyo_, _kåre, _изхо, 
   {{0x68ed0284,0x7d0426c1,0x6d5e26c2,0x59b0805f}},	//   _vlad, diis, _atpa, _जनवर, 
   {{0xe8df801c,0x68ed26c3,0x29000129,0x3f9926c4}},	//   _miền_, _wlad, _emia_, rtsu_, 
   {{0x442d26c5,0xc3488028,0x7d0406b5,0xdd9426c6}},	//   _še_, _nổi_, fiis, кары, 
   {{0x3998a6c7,0x7d0426c8,0x30a704d9,0x403526c9}},	//   més_, giis, _цркв, _пейс, 
   {{0xe667017d,0x3998a6ca,0x6f0397f8,0x6e2883cd}},	// [1490] _отно, lés_, yinc, _lydb, 
   {{0x7d0d26cb,0x4ac9000f,0x3f8687ce,0x35b526cc}},	//   snas, राइव, drou_, _збор, 
   {{0x6f03a6cd,0x3998a6ce,0xa2c42074,0xceb200c6}},	//   vinc, nés_, राज्, _גיי_, 
   {{0x3015a6cf,0x6f03a6d0,0x4f958123,0x61360149}},	//   ндер, winc, ерку, rálg, 
   {{0x3f868f3a,0x7cf100f9,0x394926d1,0xa875805a}},	//   grou_, _vård, _mias_, _үлгі, 
   {{0x3949027e,0x8ca180a1,0x6d580035,0x6b8d0ca2}},	//   _lias_, क्नो, _évac, muag, 
   {{0x6f038b53,0x7bc2a6d2,0xada5a6d3,0x60dba6d4}},	//   rinc, _arou, хайл, _toum, 
   {{0x3949006c,0x3998a6d5,0x6f03a6d6,0x3f86a6d7}},	//   _nias_, dés_, sinc, brou_, 
   {{0x0b458004,0xa2c4009b,0x7bc2a6d8,0x61360170}},	//   ннин, राच्, _crou, nále, 
   {{0xa3c20cca,0x752980ac,0x30148166,0x39490587}},	//   ्मत_, slez, _рдур, _aias_, 
   {{0x394926d9,0x3998a6da,0x2b478767,0x91e5a6db}},	//   _bias_, gés_, _vinc_, хоне, 
   {{0x290fa6dc,0x7bc2a6dd,0xf8bf003e,0x394926de}},	//   nnga_, _frou, blém_, _cias_, 
   {{0x394926df,0x7bc2a6e0,0x2b4780a6,0x290fa6e1}},	//   _dias_, _grou, _tinc_, inga_, 
   {{0xfbd08068,0x6136026b,0x3998a6e2,0x2cada6e3}},	//   _ختم_, dále, bés_, leed_, 
   {{0x18a61691,0x64a626e4,0x35a326e5,0x39988188}},	//   _займ, нава, ларг, cés_, 
   {{0x7cea0a93,0x2d878c8c,0x2cad82fb,0x290026e6}},	//   _výro, irne_, need_, _umia_, 
   {{0x7d0426e7,0x613626e8,0x6b9ba6e9,0xccf280c6}},	// [14a0] riis, ráld, ntug, אכן_, 
   {{0x7d0426ea,0x6ab88103,0x2cb9011e,0x3949027e}},	//   siis, _xavf, _easd_, _zias_, 
   {{0x6d5e26eb,0x3949027e,0x8886a6ec,0x7cf11284}},	//   _utpa, _yias_, ележ, _såre, 
   {{0xa3c2002a,0x7053807b,0x3f86a6ed,0xdd2f001b}},	//   ्मद_, هنما, trou_, pěšn, 
   {{0x39988068,0x2d87a6ee,0x78a426ef,0x3c770309}},	//   zés_, erne_, _mbiv, _אתכם_, 
   {{0x290fa6f0,0x399880ef,0x7bc48116,0x7cf119b8}},	//   anga_, yés_, _šiuo, _våre, 
   {{0xf987a6f1,0xc69300c6,0x186a804c,0x212b011a}},	//   _حب_, טאג_, _нави_, ylch_, 
   {{0xe8df810b,0x61469d9a,0x6143a6f2,0x7cee8097}},	//   _tiền_, _чеба, _беса, _bùra, 
   {{0x02e401d1,0xdccf8028,0x394926f3,0x69c3a6f4}},	//   _गवाह_, _tỉnh_, _rias_, _arne, 
   {{0x3998a6f5,0x7bc2a670,0x93fb03dd,0x78a426f6}},	//   tés_, _vrou, פליי, _abiv, 
   {{0x0d868873,0x394926f7,0xb05b0341,0x69c38a63}},	//   _член, _pias_, ndäg, _crne, 
   {{0x3998a6f8,0xa3c226f9,0xfc648c0b,0x7bc2a6fa}},	//   rés_, ्मा_, _شخصی, _trou, 
   {{0x3998a6fb,0x394926fc,0xa30b811d,0x201e024a}},	//   sés_, _vias_, _کرنے_, ştin_, 
   {{0x8c43a6fd,0x3998a6fe,0x26de804f,0x9f350e57}},	//   _сече, pés_, _joto_, тегі, 
   {{0x39491123,0x3eba26ff,0x62830530,0xf1a38123}},	//   _tias_, _dapt_, ónom, _брын, 
   {{0x6b8d2700,0x0ccf00b2,0x8c3d81b2,0x81d605a2}},	//   tuag, রস্ত, weşi, িনা_, 
   {{0x60cd029a,0x3eba002d,0x26cc8109,0x7d028269}},	// [14b0] _inam, _fapt_, _ondo_, _mmos, 
   {{0x78bd0615,0x78a41689,0x26dea701,0x2d8e8269}},	//   ldsv, _zbiv, _noto_, kufe_, 
   {{0xab5b02ae,0x290f8bed,0x7d02a702,0x7b0b01a8}},	//   _grün, tnga_, _omos, kļuv, 
   {{0x82341389,0x78bd0c0c,0xa95400f0,0xd47900c6}},	//   اركا, ndsv, укці, _קאָל, 
   {{0x27e68068,0x78bd1130,0x60cd004f,0x26dea703}},	//   gyon_, idsv, _mnam, _boto_, 
   {{0x7d02a704,0xe8df8028,0x752d2705,0x26de833b}},	//   _amos, _biển_, llaz, _coto_, 
   {{0x30a7a706,0x62342707,0x9f590093,0x5b140223}},	//   _прав, _беру, îyên_, _смрт, 
   {{0x6b9ba708,0x7cf58685,0x09e480b2,0x81c885a2}},	//   ttug, _márg, _ফেভা, োনা_, 
   {{0x249fa709,0x2cada70a,0xe7848325,0xf69984c7}},	//   rfum_, reed_, _бухо, _овај_, 
   {{0x6b9ba70b,0x60cd270c,0x78bba70d,0xa2e5875d}},	//   rtug, _anam, _hauv, тоод, 
   {{0x3f8fa70e,0x6723a70f,0x6b9ba710,0x60cd0149}},	//   lugu_, monj, stug, _bnam, 
   {{0x60cd0097,0xa3d1001b,0x65618504,0x69c383d0}},	//   _cnam, वमा_, _itlh, _vrne, 
   {{0x3ae40172,0x78bb80ef,0xe299a711,0xfe7800a6}},	//   _köpt_, _mauv, _жал_, нүп_, 
   {{0x290680b4,0x0204805a,0x6d4ba712,0x60cd2713}},	//   zioa_, _өзін, _higa, _enam, 
   {{0x27e694c9,0x3f8f859d,0x6d4ba714,0x7c962715}},	//   zyon_, hugu_, _kiga, крац, 
   {{0x6d4ba716,0x3f8f812c,0x6723a717,0xfbe70106}},	//   _jiga, kugu_, honj, _thể_, 
   {{0x6d4ba718,0x03262719,0x69c1a71a,0x442b00f6}},	// [14c0] _miga, вдан, lvle, _cyc_, 
   {{0x6d4ba71b,0x394a026b,0x3f8f88cb,0x03a3271c}},	//   _liga, _časy_, dugu_, рифо, 
   {{0xe2971b78,0x26dea71d,0x6723a71e,0x65618504}},	//   тах_, _roto_, donj, _ntlh, 
   {{0x6b8980fa,0xe78681e2,0xa9670ee7,0x21671f73}},	//   kreg, вуко, тица_, тици_, 
   {{0xa2b28365,0x26dea71f,0xa8570039,0x26c8804a}},	//   _असल्, _poto_, דינה_, нған_, 
   {{0x6723a720,0x6b89864a,0x57fb0039,0x7bc60519}},	//   gonj, dreg, ולנו, _irku, 
   {{0x27e6a721,0x6d4ba722,0x66e38077,0x7bc081df}},	//   syon_, _biga, роја, wvmu, 
   {{0x399c0741,0x6abc2723,0x6b89a724,0x6d4ba725}},	//   mís_, _harf, freg, _ciga, 
   {{0x6d4ba726,0x26de803e,0x6b89a727,0x29048208}},	//   _diga, _toto_, greg, _imma_, 
   {{0x613188b4,0x78bb8533,0x60cd2728,0x78a28463}},	//   håll, _zauv, _snam, lfov, 
   {{0xa2c30dcf,0x399c0916,0x6abc2729,0x68e0a72a}},	//   रयत्, nís_, _marf, _komd, 
   {{0x6d4b84c0,0x7bc6272b,0x7cf581ce,0x92ae00b2}},	//   _giga, _orku, _cárd, কায়_, 
   {{0xe9ff810b,0x399c00fe,0x7bd601df,0x7cf58063}},	//   _phải_, hís_, jxyu, _sárg, 
   {{0x3d95272c,0x6d4ba72d,0xdd950741,0x6595272e}},	//   лигр, _ziga, лагы, лагу, 
   {{0x5e58036a,0x09e384d9,0x7bc6272f,0x5b150fbe}},	//   тися_, _војн, _arku, ҳмат, 
   {{0x6d4b81e0,0x518383ad,0xc983a730,0x8c6413b7}},	//   _xiga, _туша, _туши, итуд, 
   {{0x6d408008,0x6abc2731,0xe9ff8106,0x6d582732}},	// [14d0] imma, _barf, _thải_, _évan, 
   {{0x29048816,0x78bb82c0,0xe8df8028,0x6136012b}},	//   _amma_, _sauv, _miễn_, mála, 
   {{0xce330c0b,0x224708af,0xd36680df,0x61360019}},	//   _خودک, änk_, _گه_, lála, 
   {{0xfc640574,0xf8bf2733,0x3f8fa734,0xfc3f06c9}},	//   _върн, ndé_, tugu_, _maíz_, 
   {{0xd3668158,0x6d4ba735,0x7084805a,0x61360019}},	//   _ده_, _riga, ргіз, nála, 
   {{0x6d4ba736,0x6abc2737,0x7e7880f3,0x539a04fc}},	//   _siga, _garf, gavp, _אישו, 
   {{0x6723a738,0x81d40c1f,0x613600fe,0x399c2739}},	//   ronj, _корх, hála, cís_, 
   {{0x6b89a73a,0xe3b9a73b,0x2602809b,0x69c709fb}},	//   treg, еби_, _वेळी_, _irje, 
   {{0x6d4ba73c,0x6723a73d,0xecc505a2,0x1b49a73e}},	//   _viga, ponj, _একাড, нзии_, 
   {{0x6b89a73f,0xe8df810b,0x61e88324,0xe9d98340}},	//   rreg, _diễn_, fydl, еко_, 
   {{0x049587db,0x394d8b7e,0x6d4ba740,0x7c2b80a1}},	//   _ملاح, _kies_, _tiga, _wygr, 
   {{0x6b898ed0,0x69c1a741,0xa6e2812b,0x201e02d2}},	//   preg, rvle, _öðru, ştim_, 
   {{0x7d09a742,0x394d94a2,0x613619df,0x75242743}},	//   mies, _mies_, gála, voiz, 
   {{0x272981e0,0xe299a744,0x69c72745,0x24990128}},	//   múns_, _чак_, _orje, _acsm_, 
   {{0x52398273,0xd3368309,0xe7370086,0x26ca811e}},	//   _אײַנ, _גרסה_, уер_, _óboe_, 
   {{0x7d09a746,0x399c2747,0x394d8208,0xa3c00562}},	//   nies, vís_, _nies_, ंटल_, 
   {{0x42ca0537,0x4ab78365,0x2d8a0269,0x69c72748}},	// [14e0] нган_, _असाव, srbe_, _arje, 
   {{0x80a00611,0xa3d48066,0xe2972749,0x2cbd827e}},	//   ग्रे, हमत_, лау_, _lawd_, 
   {{0x6abc274a,0x869b0130,0x8cbf032d,0x7ce30079}},	//   _varf, _אייז, _लोको, _võrr, 
   {{0x399c21d3,0x2cbd822a,0x6ae0801b,0x50ba819c}},	//   rís_, _nawd_, _पक्र, عداد_, 
   {{0xb8dc9e12,0x394da74b,0xdee6a74c,0x66e686f1}},	//   _अस_, _dies_, лоди, лода, 
   {{0xd5baa74d,0x2d808029,0x3f598a1c,0xf36683ad}},	//   еси_, ņiem_, _dèu_, қтин, 
   {{0x7d09a74e,0xc693025e,0x69c7061c,0xd13280d8}},	//   fies, צאה_, _grje, _همس_, 
   {{0x2904822d,0xfc3f060e,0x7d09a74f,0x6283811a}},	//   _umma_, _raíz_, gies, _adno, 
   {{0x4e96830b,0x27298659,0xd2508013,0x12e6804a}},	//   _مشار, gúns_, ينة_, гінг, 
   {{0x7cf804e0,0x61e88172,0xe8df801c,0x61360019}},	//   _fírg, tydl, _viễn_, vála, 
   {{0x7d09a750,0x39150947,0x6eef83cd,0x28f92751}},	//   bies, имор, _møbl, вень_, 
   {{0x2d91029a,0x8c3d802d,0x3ebe80f0,0x7d09a752}},	//   vuze_, teşt, _hatt_, cies, 
   {{0x8cbf0066,0xead48241,0x3ebea753,0xf8bf2754}},	//   _लोगो, _воль, _katt_, rdé_, 
   {{0x8c3d802d,0x4383a6f1,0x613600fe,0xef1f07de}},	//   reşt, _الوق, rála, mrük_, 
   {{0x61362755,0x8c3d802d,0x6d5802c0,0x4a5b83dd}},	//   máln, seşt, _éval, _אדוו, 
   {{0x69c700f8,0x628a0530,0xdb1981ed,0xa99b8309}},	//   _rrje, ófon, _erwä, _נבחר, 
   {{0xe8df810b,0x3a752756,0x1bd40086,0xa3e4902c}},	// [14f0] _hiện_, илар, ботя, नहि_, 
   {{0x6136038b,0xe8df8028,0x7d0986f7,0x3ebe99b8}},	//   náln, _kiện_, zies, _natt_, 
   {{0x3860012b,0xc3338052,0xa2c9009b,0x28c690c2}},	//   _yfir_, צוע_, _होण्, _रोहि, 
   {{0x290b050d,0x7cf58019,0x80d80c2e,0x2fc901b0}},	//   nica_, _márc, याये, _krag_, 
   {{0x394da757,0x7d09a758,0xdb0f060e,0x1be70004}},	//   _vies_, vies, _escá, _сўнг, 
   {{0x236902f0,0x7d09a759,0x2cbd81df,0xb4db0304}},	//   mpaj_, wies, _sawd_, _bhàg, 
   {{0x7d09a75a,0x1dc585c9,0x6d4f1098,0x3ebea75b}},	//   ties, विधत, _kica, _datt_, 
   {{0x56948c1f,0x2bc91379,0x6d5702dc,0x3b858004}},	//   _ҳафт, रिपा, _muxa, алиг, 
   {{0x6e959f1b,0x3ebe81bb,0x3ced9c31,0x2fc901df}},	//   _визу, _fatt_, rkev_, _nrag_, 
   {{0x6d4f01c8,0x7d09a75c,0x4255824b,0x7cf5995a}},	//   _lica, sies, штит, _bárc, 
   {{0x290b275d,0x7cf80068,0x6b8d275e,0xa06a275f}},	//   fica_, _híre, hrag, кана_, 
   {{0x6d4f2760,0xe8df8028,0x61fa0073,0xe0462761}},	//   _nica, _diện_, _ütle, инни, 
   {{0x0836069d,0xf367920f,0x6136056c,0x69dc8255}},	//   рхня, _стен, báln, ører, 
   {{0x32459da8,0x7d0600f6,0x7cf800d8,0x3f670ff6}},	//   _келг, _smks, _míre, риро_, 
   {{0x7ae3830b,0x6d4f12d9,0x649a2762,0xd62a2763}},	//   _iont, _bica, ктар_, тове_, 
   {{0x6b8d2764,0xb4e3809b,0x055518c7,0xa2cd809b}},	//   frag, _नको_, стря, ताक्, 
   {{0x6d4f2765,0x6b8d2766,0x4256164e,0xdbd982fd}},	// [1500] _dica, grag, атет, _açúc, 
   {{0x8ccc8066,0x68e4041a,0x6d570065,0xff7b00c6}},	//   _दोनो, _hoid, _fuxa, _שטימ, 
   {{0x6d4f00b0,0x61361553,0x442f8162,0x3ebea20d}},	//   _fica, nálo, _lyg_, _ratt_, 
   {{0x7ae3a767,0xdbdc003e,0x3ead0024,0x3ebea768}},	//   _lont, lšíc, đete_, _satt_, 
   {{0x3ebe8519,0xc7a39700,0x3869a769,0x78b080ce}},	//   _patt_, жичк, ñara_, _įkvė, 
   {{0x7ae39e06,0x7cf80013,0x290b002d,0xdfcf80fe}},	//   _nont, _díre, zica_, بيه_, 
   {{0x6ef48a67,0x7cf80a5e,0x442fa76a,0xd5b080d8}},	//   _càba, _tírd, _ayg_, سفة_, 
   {{0x290b0659,0x7ae38649,0x3ea0801b,0x62830407}},	//   xica_, _aont, řit_, ónov, 
   {{0x2bc90102,0x7ae381ba,0x6136003e,0x60c2a76b}},	//   रिया, _bont, táln, mdom, 
   {{0x60c0a76c,0xdbdc026b,0x60c28116,0x68e4276d}},	//   _hamm, jšíc, ldom, _aoid, 
   {{0x6136276e,0x7ae3a76f,0x7e7700bf,0x68e42770}},	//   ráln, _dont, _rexp, _boid, 
   {{0xb3568a0e,0x03a68782,0x68e404e0,0x60c0a771}},	//   _پیدا_, _видо, _coid, _jamm, 
   {{0x6d4f2772,0xe8010a81,0x7cf10b83,0xeb97a773}},	//   _rica, _लेखा_, _dårl, _вич_, 
   {{0x6b8d2774,0xe8df8028,0x6d5725a8,0x7e7c2775}},	//   vrag, _tiện_, _puxa, garp, 
   {{0xe5c40b34,0x5bb68f2c,0x13b69ac2,0xab5b2776}},	//   осто, _अनुव, _अनुभ, _trük, 
   {{0x2fc68025,0x9875167d,0x60c0a777,0xb4c10079}},	//   kvog_, _улиц, _namm, ंये_, 
   {{0x56950cc5,0xa2cb8076,0x7cf58063,0x2fc903df}},	// [1510] _лапт, _थोड्, _jára, _urag_, 
   {{0x6b8d2778,0xf9c70b82,0x6d4f2779,0x60c2a77a}},	//   rrag, ищен, _wica, edom, 
   {{0x3958277b,0x6d4f277c,0xb4db277d,0xc3480086}},	//   _curs_, _tica, _diàr, ряте_, 
   {{0x6b82803b,0x60c290bd,0x60c0a77e,0x26c102a6}},	//   _ovog, gdom, _camm, _haho_, 
   {{0x7d0d00a1,0x7cf58a5b,0x2366827e,0x60c088b6}},	//   mias, _nára, _ntoj_, _damm, 
   {{0xaf0480f0,0x3958277f,0x442fa780,0x60c28034}},	//   опіл, _furs_, _ryg_, adom, 
   {{0x7ae3a781,0x6b8281e0,0x29090008,0xa5098077}},	//   _ront, _avog, _omaa_, лека_, 
   {{0xeb998664,0x7d0d062d,0x61360063,0x201e0123}},	//   гии_, nias, gáll, ştii_, 
   {{0x7ae3a782,0x69ca8324,0x57f583b8,0xb4db0064}},	//   _pont, _arfe, _упат, _ghàe, 
   {{0x81e280cf,0x7d0d2783,0x6136052f,0x6b828284}},	//   _নেই_, hias, tálo, _dvog, 
   {{0x68e42784,0x7e7c007f,0x7ae3a785,0x60c08640}},	//   _poid, varp, _vont, _yamm, 
   {{0x5f0503ce,0x7ae38283,0x26d301e0,0x673e00f8}},	//   होस्_, _wont, _anxo_, _shpj, 
   {{0x7ae3a786,0x68e40008,0x7e7c2787,0x6b659096}},	//   _tont, _void, tarp, _укла, 
   {{0x7afaa788,0x60c2a789,0xc5b70a1c,0x290902ef}},	//   chtt, zdom, өрсө, _emaa_, 
   {{0xf8bf0422,0x61462257,0x9985864d,0xa2db278a}},	//   glés_, _лека, _البو, नान्, 
   {{0x6ab78ab2,0x3d08009b,0x2b590065,0x7e7c06a0}},	//   _असुर, _सगळे_, _busc_, sarp, 
   {{0x6d44278b,0x60c08eb9,0x7cfc8068,0xdbdc026b}},	// [1520] rmia, _ramm, _férf, pšíc, 
   {{0x60c08f76,0x3f820053,0x6d44278c,0xeb9804bc}},	//   _samm, msku_, smia, лиғ_, 
   {{0x7cf807bc,0xc879a78d,0x394001df,0xe3b200df}},	//   _círc, _beş_, _khis_, _کرج_, 
   {{0x60c295b7,0x03a603a3,0x53a62299,0x2bbc82f4}},	//   udom, _лимо, _ламб, ्टमा, 
   {{0x3f82278e,0x44240028,0x81e600b2,0xbbb6824c}},	//   nsku_, _âm_, _বেশ_, _अनेक, 
   {{0xb8ef9089,0x273f278f,0x3ce00121,0x63a42790}},	//   _वो_, rîng_, ljiv_, mtin, 
   {{0x7bcba791,0xa3c2000c,0x6b82a792,0x60c08912}},	//   _argu, ्मक_, _svog, _tamm, 
   {{0xdb1d0172,0x273f024a,0x18a3847d,0x3ce00533}},	//   _ersä, mîne_, _насм, njiv_, 
   {{0x3f820025,0x241881bc,0xda7a9feb,0xe73a8077}},	//   jsku_, ропы_, лян_, _беа_, 
   {{0x3f82005d,0x4ace032d,0x7d0d2793,0x3f5d0106}},	//   dsku_, _होमव, zias, _rìu_, 
   {{0x63a42794,0x273f024a,0xd2508c93,0x7bcba795}},	//   htin, nîne_, بند_, _ergu, 
   {{0x3a370052,0x63a42796,0x6b828043,0xfce3998a}},	//   מרים_, ktin, _tvog, _нохо, 
   {{0x6d5a9a28,0x273f01b2,0x7bcb8533,0x3940068e}},	//   _huta, hîne_, _grgu, _dhis_, 
   {{0x6d5aa797,0x61360019,0xdefb004a,0x273f01b2}},	//   _kuta, nálj, уым_, kîne_, 
   {{0xc27b896e,0x6d5a8308,0x3ce6822a,0x2b590269}},	//   _גרוי, _juta, _koov_, _susc_, 
   {{0x6d5aa798,0x26c12799,0xdb060019,0xa4f102d2}},	//   _muta, _waho_, _eskü, _dışı_, 
   {{0x63a4279a,0x28d60d64,0xc879824a,0x3ce6a79b}},	// [1530] gtin, धारि, _reş_, _moov_, 
   {{0x629aa79c,0x7d0d279d,0xda670013,0xbb1b01b2}},	//   ngto, sias, صائي, _evîn, 
   {{0x7cfc811d,0xb9b508a0,0x6d5aa79e,0x9962026b}},	//   _kérd, تماع, _nuta, _píše_, 
   {{0x212b279f,0xd011803f,0x63a424fd,0xb4db0097}},	//   noch_, ولا_, btin, _dhàc, 
   {{0x6d5aa7a0,0x656880f8,0x63a427a1,0x7d1d01f0}},	//   _auta, _atdh, ctin, _ijss, 
   {{0x6d5aa7a2,0x273f024a,0x39838214,0x7cf5833b}},	//   _buta, bîne_, yıs_, _cárn, 
   {{0x78ad0025,0x6d5aa7a3,0x2d8327a4,0x212b01ac}},	//   _obav, _cuta, nsje_, koch_, 
   {{0xab65963a,0x6d5a81d7,0x2d8301f0,0x212b0033}},	//   овил, _duta, isje_, joch_, 
   {{0x212b27a5,0x290fa7a6,0xeab9a7a7,0x7ae701df}},	//   doch_, miga_, айп_, _kojt, 
   {{0x290fa7a8,0xf6f58182,0xdb1d0172,0x13098008}},	//   liga_, _بزرگ, _ursä, рной_, 
   {{0xd9460e2e,0x6d5aa7a9,0xf7488013,0x7ae7068c}},	//   жени, _guta, _اللي_, _mojt, 
   {{0x63a427aa,0x3f82003b,0x290fa7ab,0xa4f7803d}},	//   ytin, tsku_, niga_, _دکتر_, 
   {{0xe73a1ac1,0x3f8403e0,0x7cf58019,0xbbeb803f}},	//   ием_, ému_, _háro, _حرام_, 
   {{0x3f8227ac,0x290fa7ad,0x7cf58019,0x291927ae}},	//   rsku_, higa_, _káro, ansa_, 
   {{0x39400757,0xdd920275,0x7bc9a7af,0xddc31ae0}},	//   _this_, ظور_, lveu, мбри, 
   {{0x63a427b0,0x3f82006a,0x4c6a27b1,0x273f01b2}},	//   ttin, psku_, риан_, vîne_, 
   {{0x290fa7b2,0x63a427b3,0x130a21e7,0x6ef00079}},	// [1540] diga_, utin, анай_, _läbi, 
   {{0x63a427b4,0x2d9100a1,0xdcfc00f3,0x78ad27b5}},	//   rtin, brze_, turē, _zbav, 
   {{0x7cf5803e,0x60c427b6,0x5bb6800d,0xfce627b7}},	//   _náro, _kaim, _अन्व, _доно, 
   {{0xeb9a27b8,0x6d5aa7b9,0x63a427ba,0x273f024a}},	//   _ким_, _ruta, ptin, rîne_, 
   {{0x3946a7bb,0x60c427bc,0x6d5aa7bd,0xdb040e45}},	//   rmos_, _maim, _suta, ntië, 
   {{0x3946939c,0x6d5aa7be,0x248027bf,0x60c427c0}},	//   smos_, _puta, laim_, _laim, 
   {{0x2d9827c1,0x290fa7c2,0x6b8427c3,0x6d5aa7c4}},	//   nure_, biga_, lsig, _quta, 
   {{0x443d82ae,0x3eb801ed,0x6d5c8e22,0x7e7aa7c5}},	//   _bzw_, hert_, _éram, _wetp, 
   {{0x6b8427c6,0x3eb827c7,0xa686839c,0x14a68dcf}},	//   nsig, kert_, _млад, क्षण, 
   {{0x61360019,0xe73a934a,0x2d9827c8,0x212b01ed}},	//   lálh, _тез_, kure_, woch_, 
   {{0xa2db0d64,0xd62a8008,0x7cfca7c9,0x3eb827ca}},	//   नात्, _тоже_, _pérd, dert_, 
   {{0x60c40540,0x613d007f,0x61360019,0x69c8810d}},	//   _caim, féla, nálh, rvde, 
   {{0xd83b077a,0x60c427cb,0x6b840043,0x7cf585e1}},	//   рэн_, _daim, jsig, _záro, 
   {{0x6b84006d,0x2d83093c,0x3eb801e3,0x69ce27cc}},	//   dsig, tsje_, gert_, _orbe, 
   {{0x290fa7cd,0x7ae727ce,0x6d42a7cf,0x41e68bb4}},	//   yiga_, _rojt, _khoa, _філа, 
   {{0x24f8104c,0x24581a59,0x7aea80f3,0x290fa7d0}},	//   онсы_, жать_, žotā, xiga_, 
   {{0x20020066,0x6b8427d1,0x7cfc80ef,0x69de27d2}},	// [1550] czki_, gsig, _gére, expe, 
   {{0x3eb8055a,0xdb040035,0x2d980a39,0x28ac002a}},	//   cert_, ntiè, bure_, ट्ठि, 
   {{0x290fa7d3,0x6d3527d4,0x7ae727d5,0x80b000cf}},	//   tiga_, _неоф, _vojt, য়ার্, 
   {{0x52b7a7d6,0x6b840149,0x02b781cc,0x7cf80065}},	//   _अस्स, bsig, _अस्न, _tíra, 
   {{0x290fa7d7,0x69ce27d8,0x3f9927d9,0x9f3580f0}},	//   riga_, _erbe, nusu_, педі, 
   {{0x290fa7da,0x6d42852a,0x7cf5a7db,0xed59a7dc}},	//   siga_, _ahoa, _páro, бок_, 
   {{0x3f9900fd,0x290f822d,0x2bc914a0,0xb8878229}},	//   husu_, piga_, रिवा, _муай, 
   {{0x7cf58068,0xd5ae80fe,0x61360170,0x7bcf0a63}},	//   _váro, افي_, rálk, _krcu, 
   {{0x2d988172,0x2d9827dd,0x3ec48008,0x48fa80c6}},	//   _åren_, zure_, östä_, _פּלא, 
   {{0x613627de,0x60c427df,0x7bc980ef,0x613d27e0}},	//   máli, _saim, rveu, véla, 
   {{0x3eb827e1,0x7c2280f6,0x2d9827e2,0x60c427e3}},	//   vert_, _exor, xure_, _paim, 
   {{0x3ea127e4,0x6b8427e5,0x3eb802ae,0x7cfc922b}},	//   _acht_, ysig, wert_, _pére, 
   {{0xe28ea7e6,0x26c58365,0x68e99a5f,0x3eb827e7}},	//   _па_, _kalo_, _moed, tert_, 
   {{0xb8f30611,0x2d9827e8,0x60c427e9,0x6d49a7ea}},	//   _हो_, ture_, _waim, lmea, 
   {{0x26c5a7eb,0x6281a7ec,0x60c427ed,0x57b880a1}},	//   _malo_, malo, _taim, _इन्ह, 
   {{0x3ea127ee,0xab660241,0x3eb8036a,0x7d1ba7ef}},	//   _echt_, звал, sert_, nnus, 
   {{0x7cfc8ca1,0x24800caf,0x2d982416,0x6d498c8c}},	// [1560] _hérc, raim_, sure_, imea, 
   {{0x2d98009f,0x6b8427f0,0x26c59e0d,0x6d4980d8}},	//   pure_, rsig, _nalo_, hmea, 
   {{0x68fba7f1,0x68e9a7f2,0x14bd824c,0xc21907c5}},	//   _blud, _boed, ्याण, оєї_, 
   {{0x7cfc8659,0x628183ec,0x7cf58019,0x4fc68e71}},	//   _mérc, halo, _bárm, зска, 
   {{0x7e7e007f,0x68e281bb,0xe73a83bd,0x273f024a}},	//   _kepp, rjod, бед_, lîna_, 
   {{0x6d5e27f3,0x62818524,0x6daa8816,0x6d42a7f4}},	//   _kupa, jalo, _fəal, _shoa, 
   {{0x434327f5,0x273f02a5,0x6281a7f6,0xbb4327f7}},	//   _черв, nîna_, dalo, _черк, 
   {{0x68e9a7f8,0x7cf59a5a,0x7e7e27f9,0x7d1ba7fa}},	//   _goed, _fárm, _lepp, gnus, 
   {{0x6d5e27fb,0x26c58bdf,0x61361355,0x3866811e}},	//   _lupa, _falo_, cáli, mcor_, 
   {{0x6281a7fc,0xe3afa7fd,0x6d428b3f,0x26c5a7fe}},	//   galo, اري_, _whoa, _galo_, 
   {{0xd48f95da,0x386d08a3,0x672e0bfc,0x3f86a4dd}},	//   _пр_, ñero_, dobj, lsou_, 
   {{0x64a684bc,0x3f9927ff,0x7b66804a,0x3866a800}},	//   _хада, tusu_, _етке, ncor_, 
   {{0x6d5e2801,0xddc88269,0x7e7e01e9,0x3f86a802}},	//   _aupa, _jedž, _bepp, nsou_, 
   {{0xb4db2803,0xddc881e2,0x628a8142,0x6d5e0881}},	//   _chàn, _medž, _udfo, _bupa, 
   {{0x28dd0687,0xa2a1809b,0x1df81747,0x3f992804}},	//   यादि, _खात्, перы_, susu_, 
   {{0x2eb9823b,0x645a0123,0x291ca805,0x3f992806}},	//   _इस्त, _ştir, éval_, pusu_, 
   {{0x201e2807,0x68e98360,0xddc888dc,0x3f86801b}},	// [1570] ştir_, _roed, _nedž, jsou_, 
   {{0x68fb80f3,0x798503ec,0x7cf80019,0xd25b01e2}},	//   _slud, tshw, _hírl, сца_, 
   {{0x68fba808,0xaaae8c01,0x68e98b05,0xf1c201a8}},	//   _plud, ज्यक, _poed, jušā_, 
   {{0xf9900743,0x301593c9,0x61362809,0x7e7e280a}},	//   ابل_, мдер, táli, _zepp, 
   {{0x2b931ad1,0x26c58504,0x68e98622,0x37aba80b}},	//   _سیاس, _palo_, _voed, стен_, 
   {{0xe8da00ab,0x2bb6810c,0xddc88265,0x68e98d55}},	//   _बच्च, _अनजा, _dedž, _woed, 
   {{0x6281a80c,0x26c5a80d,0x68e9a80e,0x7cf80149}},	//   valo, _valo_, _toed, _oírl, 
   {{0x6281a80f,0xed56809f,0x26c5a810,0xddc88269}},	//   walo, мощ_, _walo_, _fedž, 
   {{0x6d4984d8,0xa2a18b30,0x0b458103,0xddc8a811}},	//   rmea, _खाद्, мнин, _gedž, 
   {{0xff5380fe,0x386901c2,0x273f024a,0x6d49a26b}},	//   _أخر_, _afar_, yîna_, smea, 
   {{0x387f9cf5,0x7aeaa812,0x7cee8540,0x63a484ab}},	//   _keur_, _doft, _cùrs, _ţint, 
   {{0x6d5e2813,0x273f01b2,0xc6890080,0xdb040728}},	//   _rupa, vîna_, _כא_, rtié, 
   {{0x6d5e2814,0xfaa5a815,0x387fa816,0x73e487c5}},	//   _supa, _жало, _meur_, _поїз, 
   {{0x387f83e9,0x63a9a817,0x3cfd81df,0x2bbc801b}},	//   _leur_, mten, _hlwv_, ्टरा, 
   {{0x64a619da,0x7cfca818,0x6da32819,0xdca60103}},	//   мава, _héra, кира, мави, 
   {{0x273f02a5,0x249f812b,0x2056281a,0x69c3a81b}},	//   rîna_, ngum_, _отпр, _isne, 
   {{0xb4db0147,0xe8df810b,0x0fc315e6,0xb4be00a1}},	// [1580] _thàn, _chọn_, _айын, _इसी_, 
   {{0x6138a81c,0xb0c68aed,0x63a9a81d,0x2d87872c}},	//   míli, _रोजग, iten, ksne_, 
   {{0xddd8829f,0x63a9a81e,0x80a510af,0x9965004a}},	//   kavš, hten, _कामे, етіл, 
   {{0x7cf5801b,0x63a9a81f,0x69c38a63,0x0cd885a2}},	//   _dárk, kten, _msne, _তত্ত, 
   {{0x387fa820,0xddd8829f,0x6ef48741,0x2ca00128}},	//   _deur_, davš, _hàbi, mgid_, 
   {{0xbd6a8274,0x386687ef,0x6136007f,0x6b9b8128}},	//   орие_, scor_, málu, duug, 
   {{0xfaa30014,0x63a9802d,0x94188816,0xf987811d}},	//   _шаро, eten, ərə_, _جب_, 
   {{0x7aea97b6,0x387fa821,0x672118d7,0x2ca02822}},	//   _soft, _geur_, člji, ngid_, 
   {{0x63a9a823,0x7aea8123,0x7cfc8035,0x6b9b8dfe}},	//   gten, _poft, _céra, guug, 
   {{0x7aea80f8,0x78a403b9,0x69c8011e,0x7cfc8035}},	//   _qoft, _aciv, _ádes, _déra, 
   {{0x611c83d0,0xb4db0097,0x612802d2,0x61152824}},	//   včlj, _bhàl, kıld, едну, 
   {{0x61e30172,0x63a9a825,0xb4db0097,0x1e7202c3}},	//   änli, bten, _chàl, ңғыс, 
   {{0x628e2826,0x69c3a827,0x7cfca828,0x63a9a829}},	//   _odbo, _esne, _géra, cten, 
   {{0xaff980c6,0x4426a82a,0xa3d2282b,0x2fd2282c}},	//   פּרי, _ixo_, विन_, _dryg_, 
   {{0x6d4600db,0x9e341cd4,0xe93b0936,0xb4db0097}},	//   _bhka, верч, _وسعت_, _fhàl, 
   {{0x3ea9868b,0x2902282d,0x628e011a,0x2b58282e}},	//   đati_, chka_, _adbo, _airc_, 
   {{0x6138a82f,0x7cfc811e,0x2b5800ca,0xa87c0309}},	// [1590] cíli, _xéra, _birc_, _ואחר, 
   {{0x2d8506c9,0x7bcd1610,0x68ed253c,0x28dd2830}},	//   áles_, rvau, _hoad, यावि, 
   {{0x63a9a831,0x387f80ef,0x2d9ca832,0x68ed0122}},	//   zten, _peur_, juve_, _koad, 
   {{0x78bd2833,0x63a9a834,0xf77180a7,0x09b100b2}},	//   nesv, yten, هات_, ছিলা, 
   {{0x2b58011e,0x6d4d2835,0x645d0009,0x68ed0347}},	//   _firc_, mmaa, _igsi, _moad, 
   {{0xd246a836,0x6d4d2837,0x68ed2838,0x61360019}},	//   _من_, lmaa, _load, lált, 
   {{0x62852839,0x6138a83a,0x63a9a83b,0x7cfca83c}},	//   maho, zíli, wten, _séra, 
   {{0x6285283d,0xd658004d,0x6d4d283e,0x61360019}},	//   laho, ויות_, nmaa, nált, 
   {{0x60dba83f,0x75228269,0xe3b69747,0x249fa840}},	//   _inum, _djoz, ебы_, rgum_, 
   {{0x62852841,0xe3c88028,0x7cf5a842,0x64428269}},	//   naho, _dự_, _mári, _dzoi, 
   {{0x44392843,0xa0a604bc,0xc3320115,0x44269155}},	//   _lys_, нанд, רוי_, _exo_, 
   {{0xcea9004d,0xb4be2844,0x7cfca845,0x62852846}},	//   _לי_, _इसे_, _hérn, haho, 
   {{0xb8e80066,0x68ed1e52,0x62852847,0x60c981ba}},	//   _उस_, _doad, kaho, _maem, 
   {{0x6d460210,0x6561a848,0x6d59a849,0x6138a84a}},	//   _shka, _kulh, _hiwa, ríli, 
   {{0x6d59a84b,0x65618077,0x6138a84c,0xe81680a1}},	//   _kiwa, _julh, síli, _देना_, 
   {{0x656180b0,0x6d4d284d,0x07a6167d,0x6b96284e}},	//   _mulh, gmaa, _заин, tryg, 
   {{0x44260003,0x61280a08,0x7cf5a84f,0x28dd06d7}},	// [15a0] ço_, rıld, _cári, यारि, 
   {{0x60dba850,0x28ac2851,0x6d59a852,0xa8570039}},	//   _anum, ट्रि, _liwa, _איפה_, 
   {{0x753b826b,0x29002853,0x499a0bb9,0x5ec880b2}},	//   kluz, _klia_, ятая_, লামে, 
   {{0x44391f56,0x6d4d0e1b,0x60c9816f,0x6d46019b}},	//   _fys_, cmaa, _caem, _uhka, 
   {{0xf1c9801c,0x62852854,0xe73a959f,0x087700c6}},	//   _lạ_, baho, пед_, גענט_, 
   {{0x7bc6003b,0xe5c6930c,0x8f9b00c6,0xe8020de3}},	//   _isku, есио, פיצי, रैया_, 
   {{0xe3c8810b,0x32431b24,0x6d59997b,0x2bd28f82}},	//   _sự_, _берг, _biwa, तिभा, 
   {{0x6d59824a,0x2d981127,0x60c980db,0xed5784c7}},	//   _ciwa, irre_, _gaem, ној_, 
   {{0x6d59a855,0x53c90503,0xd90d842b,0x6b898077}},	//   _diwa, रिएश, _بین_, gseg, 
   {{0x68ed2856,0xf1c98106,0x55e687c5,0x23d281cc}},	//   _soad, _bạ_, _позб, तिबद, 
   {{0xf8dd1131,0xe8b588f1,0x7d042857,0x13170039}},	//   यालय, nışı, khis, תחיל_, 
   {{0xe3c8810b,0x78a2a858,0x7d042859,0x6b89a85a}},	//   _tự_, ngov, jhis, bseg, 
   {{0x66f4807a,0x04578013,0x7d04285b,0x6285285c}},	//   _अवाक_, _كلمة_, dhis, yaho, 
   {{0x6d598017,0x3ea50019,0x2900285d,0x4439285e}},	//   _ziwa, ült_, _elia_, _rys_, 
   {{0x7bc600f8,0x6d4d285f,0x645d0128,0x29000149}},	//   _asku, tmaa, _pgsi, _flia_, 
   {{0x7d042860,0xf98f9d1b,0x23b79108,0xa8a6824a}},	//   ghis, _ابو_, _अहमद, şkêş_, 
   {{0x6d4d2861,0x62852862,0x613626f1,0x7aee0129}},	// [15b0] rmaa, taho, rált, _bobt, 
   {{0x2d8ca863,0x6d4d2864,0x7cf58077,0xadf501e2}},	//   _ovde_, smaa, _vári, _апош, 
   {{0x7bc600b4,0x3949088a,0x443907b8,0xa5c2005a}},	//   _esku, _khas_, _wys_, _көте, 
   {{0x7d042865,0x62852866,0x443900a1,0x38c98019}},	//   chis, saho, _tys_, بائی_, 
   {{0x6d59924b,0x2d8c8269,0x7cfca733,0xbea5a867}},	//   _riwa, _avde_, _aéro, валк, 
   {{0x63ad04c0,0xa3c006d7,0x6d59a868,0x7cfc868e}},	//   mtan, ूटर_, _siwa, _béro, 
   {{0xb8b380b6,0x50b1122f,0x60c9a869,0x69160170}},	//   _бөлі, जभाष, _taem, dšen, 
   {{0x9258286a,0x6b89a86b,0x7cfca86c,0x69c70677}},	//   _част_, tseg, _déro, _isje, 
   {{0x6d598010,0x3f8b00a1,0x2d8c82d2,0xd46880d8}},	//   _viwa, jscu_, _evde_, رحيم_, 
   {{0x63ad286d,0x466ba86e,0xdb0081fb,0xa3d2093e}},	//   itan, _храм_, ttmá, वित_, 
   {{0x6b89a86f,0x29002870,0x63ad2871,0x39492872}},	//   sseg, _plia_, htan, _bhas_, 
   {{0x69d51092,0xdb00826b,0x39492873,0xdddc008d}},	//   _mrze, rtmá, _chas_, jarš, 
   {{0x63ad2874,0xc95280c6,0x75290183,0x39490a67}},	//   jtan, ימט_, čezl, _dhas_, 
   {{0x69c70310,0x78a2803b,0x69d50034,0xf1c98106}},	//   _osje, zgov, _orze, _tạ_, 
   {{0x7d042875,0x386da876,0x28aa06ce,0x98ad808b}},	//   this, _ofer_, _कापि, _gieħ_, 
   {{0x2cbf8324,0x6283a877,0x7aee075d,0x394902a1}},	//   neud_, _heno, _sobt, _ghas_, 
   {{0x63ad2878,0xa3d2024c,0x6283a879,0x7aee022a}},	// [15c0] gtan, विध_, _keno, _pobt, 
   {{0x7d04287a,0x1303287b,0x6283a87c,0x386da87d}},	//   shis, азум, _jeno, _afer_, 
   {{0x62839b3e,0x7d0403ec,0x63ad287e,0x1d0a01f5}},	//   _meno, phis, atan, _жени_, 
   {{0x63ad0bed,0xe8b58180,0x69d50034,0x28aa287f}},	//   btan, rışı, _drze, _काफि, 
   {{0x10a39639,0x98a3a880,0x69d52881,0x66e6a882}},	//   ричн, риче, _erze, кода, 
   {{0x6283a883,0x473388cf,0xa3d58cdb,0x7cfca884}},	//   _neno, аніс, हिन_, _péro, 
   {{0x78b6026b,0xe29700b0,0x27e0802d,0x69d500a1}},	//   _obyv, _јас_, ţin_, _grze, 
   {{0x7cfca885,0x80ca8bf5,0x3f4f0199,0xaae001d2}},	//   _véro, _सोचे, _jżur_, नावक, 
   {{0x62838ccb,0x9eaa80b0,0xfd0f807b,0xf8bf1b15}},	//   _beno, _оваа_, تجو_, nnée_, 
   {{0x38602886,0x80a50073,0x7cf800d8,0xe6c580d8}},	//   _agir_, _काहे, _díri, _متمي, 
   {{0x69240053,0x26de8052,0xe8169108,0x63ad0109}},	//   rđen, _into_, _देता_, ztan, 
   {{0x63ad0d86,0xd90f0267,0x2906a887,0x7cf800d8}},	//   ytan, تیب_, nhoa_, _fíri, 
   {{0x26cca888,0x69162889,0xd838077a,0x4394a88a}},	//   _kado_, pšen, вэр_, _салс, 
   {{0x6283a88b,0xd7f82202,0x8c4389c4,0xb8fa288c}},	//   _geno, тую_, _тече, _डो_, 
   {{0x6288a88d,0xdddc026b,0x29068504,0x26cc813b}},	//   mado, tarš, khoa_, _mado_, 
   {{0x26cc852f,0x6924288e,0xd498167e,0xf8bf011e}},	//   _lado_, nđel, кру_, roés_, 
   {{0x2919288f,0x63ad2890,0xf4840370,0x63a0846a}},	// [15d0] misa_, utan, русн, numn, 
   {{0x69d50639,0x6288a891,0x291912c5,0x26cc84e0}},	//   _prze, nado, lisa_, _nado_, 
   {{0xc8aa007a,0x7cf5a892,0x60cd2893,0xf8aa010c}},	//   _कामट, _záru, _kaam, _कामय, 
   {{0x29192894,0x63ad2895,0x63a0a896,0x60cd2897}},	//   nisa_, ptan, kumn, _jaam, 
   {{0xb8cb922f,0x26cc822d,0x60cd2898,0x7cf58de8}},	//   _खा_, _bado_, _maam, _márt, 
   {{0x6288a899,0x69d50066,0xa3d68d64,0x6d5d289a}},	//   jado, _trze, ाटन_, _hisa, 
   {{0x26cc9151,0x2919289b,0x7cf8289c,0xdc698692}},	//   _dado_, kisa_, _síri, найд_, 
   {{0x23ab8142,0x7d028052,0x2906a89d,0x6283a89e}},	//   tøj_, _clos, choa_, _seno, 
   {{0x6b8d0003,0x6d5d289f,0x6283a1c2,0x7cfca8a0}},	//   nsag, _misa, _peno, _kérj, 
   {{0x6d5d0689,0x61280085,0x26cca8a1,0xa3ab00c9}},	//   _lisa, dıla, _gado_, _गमन_, 
   {{0x60cd28a2,0x628380e9,0x291928a3,0x0596804e}},	//   _baam, _veno, fisa_, _مانگ, 
   {{0x6d5d068b,0x60cd01e0,0x7cf580fe,0x63a08a11}},	//   _nisa, _caam, _cárt, bumn, 
   {{0x3ce0807a,0x776404e0,0xe8f728a4,0xb4db0048}},	//   कारे_, _quix, уля_, _ghài, 
   {{0xe5a628a5,0x6288a8a6,0x6da628a7,0x7d02805d}},	//   лиги, cado, лига, _zlos, 
   {{0x6d5d0e3b,0x291928a8,0x60cd06b5,0xd62710e6}},	//   _bisa, bisa_, _faam, горе_, 
   {{0x291928a9,0x6d5d28aa,0xa0a604bc,0x65650112}},	//   cisa_, _cisa, _саид, _duhh, 
   {{0x032628ab,0x612805ee,0x6d5d28ac,0x93aa046d}},	// [15e0] гдан, cıla, _disa, عارف_, 
   {{0xf8bf02c0,0x78a9833b,0x656528ad,0x91e628ae}},	//   rnée_, _acev, _fuhh, лозе, 
   {{0x6d5d00de,0x2d9528af,0x60cd28b0,0x29068129}},	//   _fisa, _кряс, _yaam, thoa_, 
   {{0x613d0b0f,0x6d5d28b1,0xfce604bc,0xbfaa8a54}},	//   téli, _gisa, _сомо, етке_, 
   {{0x6f188053,0x6288a8b2,0xb4c028b3,0x752428b4}},	//   tivc, yado, ंजी_, mniz, 
   {{0xa3c128b5,0x2919012c,0x6288a8b6,0x6d5d28b7}},	//   ंबर_, zisa_, xado, _zisa, 
   {{0xe1e7a8b8,0x612802bc,0x7d03002d,0x6d4b8269}},	//   _اس_, zıla, _însc, _bhga, 
   {{0x7cfca106,0x80d4092c,0xb88704e0,0x26cc83df}},	//   _térm, _बोले, _muíñ, _wado_, 
   {{0x6288852f,0x2904a8b9,0x60cd0a2f,0x291915fe}},	//   tado, _ilma_, _raam, visa_, 
   {{0x60cd28ba,0x248900fa,0xc87987de,0x291900bc}},	//   _saam, zaam_, _inşa_, wisa_, 
   {{0x63a08533,0x291928bb,0x69160116,0x2258a8bc}},	//   sumn, tisa_, pšel, ärk_, 
   {{0x612803d2,0x6b8d00ef,0x6b9ba8bd,0x443d811a}},	//   tıla, ysag, brug, _fyw_, 
   {{0x6288a8be,0x60cd28bf,0x68fd28c0,0x33f6a8c1}},	//   pado, _vaam, rksd, _حساس, 
   {{0x61280186,0x6d5d28c2,0x291903ec,0x60cd1d60}},	//   rıla, _sisa, sisa_, _waam, 
   {{0x60cd28c3,0xbcfb00ef,0xb8870065,0x69da14a6}},	//   _taam, _liée, _cuíñ, _šten, 
   {{0x612807fa,0x69ca81bb,0x6b8d28c4,0x2fc901df}},	//   pıla, _isfe, tsag, _tsag_, 
   {{0x6d5d28c5,0x5b1528c6,0x6d408413,0x28aa19b2}},	// [15f0] _visa, амат, ilma, _काति, 
   {{0x6d5d01fc,0xa3d5853d,0x2bb7810c,0x6b8d28c7}},	//   _wisa, हित_, _अहसा, rsag, 
   {{0x6b8d11c3,0x6d5d28c8,0xba4728c9,0x26c328ca}},	//   ssag, _tisa, ухай, mejo_, 
   {{0x26c328cb,0xc91380b2,0xd7d583b8,0x4fd5894b}},	//   lejo_, িক্ত_, ижењ, ижет, 
   {{0xdb0428cc,0xafe5a8cd,0xa2d0009b,0x8e8580ce}},	//   stiá, ролл, _डोक्, агле, 
   {{0x26c328ce,0xa3d206d7,0x6d40a8cf,0x26d10269}},	//   nejo_, विर_, elma, ndzo_, 
   {{0x6ead000d,0x5a440ad0,0xba740068,0x6b82844e}},	//   _जानु, _гэта, _چاہت, _awog, 
   {{0x2d678533,0xb465831c,0x6b9b8e66,0x2d9e206c}},	//   _uđem_, шкил, trug, šteg_, 
   {{0x69d8a8d0,0xf770807b,0x4b86a8d1,0x62870d77}},	//   _arve, _فال_, айын_, _kejo, 
   {{0x26c30ecf,0x6b9ba8d2,0x212928d3,0x82f5865b}},	//   jejo_, rrug, _ajah_, рчиц, 
   {{0x628728d4,0x69d8803a,0x394d827e,0x26c3053b}},	//   _mejo, _crve, _khes_, dejo_, 
   {{0x69d8803a,0x6b9b803b,0x33d588cf,0x69de81ac}},	//   _drve, prug, _вікт, _špec, 
   {{0x95548c0b,0x21290265,0x290c0116,0x3cff81df}},	//   _اخلا, _djah_, ėda_, mkuv_, 
   {{0x7cf58068,0xe299961a,0x3ced9f03,0x6287001b}},	//   _társ, _рак_, ljev_, _nejo, 
   {{0x2d988d32,0x21a5a8d5,0x2cb90064,0x2d5183d0}},	//   _året_, _тийм, _bbsd_, _ušes_, 
   {{0x25ed8e4f,0x942628d6,0x88830086,0x7d09a8d7}},	//   _अपनी_, амбе, _длъж, nhes, 
   {{0xf77207db,0xed5728d8,0x4aaa28d9,0x03a628da}},	// [1600] _باب_, рот_, ккан_, ризо, 
   {{0x7d1ba8db,0x7cf58530,0x752400bf,0x969628dc}},	//   hius, _márq, sniz, _триш, 
   {{0x7d1ba8dd,0x395f9637,0x41aa0b29,0xa2a700c9}},	//   kius, _bius_, твен_, _चार्, 
   {{0x613d28de,0x53a61371,0x3cff81df,0x6f1c0036}},	//   bélu, _камб, jkuv_, lirc, 
   {{0x7d09a8df,0x67d4a8e0,0x7d0328e1,0x3ced861c}},	//   dhes, солу, _însa, djev_, 
   {{0x628728e2,0x98ab00a1,0x63a428e3,0x7cfc8019}},	//   _gejo, mocą_, muin, _térk, 
   {{0x63a428e4,0x7d1b811e,0xb23a00fe,0x4420802d}},	//   luin, fius, _شكرا_, _ţi_, 
   {{0x6b828246,0x92a600a1,0x7d1b8495,0x395f8036}},	//   _pwog, _wyłą, gius, _gius_, 
   {{0x7cf5995a,0xdcef0533,0x6d4081c2,0x6f1c01ab}},	//   _párr, žeće, rlma, kirc, 
   {{0x7cfca8e5,0x2d9c81d2,0x2fc98733,0x212928e6}},	//   _méri, prve_, çage_, _sjah_, 
   {{0x63a41625,0x7d1ba8e7,0x3ced8269,0xf2d900c6}},	//   huin, bius, bjev_, אַרל, 
   {{0x7d1ba8e8,0x63a428e9,0xb4c503f0,0x6738a8ea}},	//   cius, kuin, _एसे_, lovj, 
   {{0x8c43a46e,0x315780c6,0xe66714eb,0x7cf58149}},	//   _деце, ייטן_, итво, _tárr, 
   {{0x63a428eb,0x6568a8ec,0x31678036,0x46de28ed}},	//   duin, _kudh, _funz_, मागह, 
   {{0x26d10066,0x628728ee,0x26c328ef,0x5186a8f0}},	//   rdzo_, _rejo, rejo_, _тула, 
   {{0x6568a8f1,0x26c328f2,0x3f8f811a,0x628728f3}},	//   _mudh, sejo_, ysgu_, _sejo, 
   {{0x63a410f7,0x18698004,0x2d581a59,0x6287008d}},	// [1610] guin, қали_, рить_, _pejo, 
   {{0x883c0039,0x6e2d8214,0x673893e0,0x7cfc80ef}},	//   _בתחו, şabi, jovj, _déri, 
   {{0x75d5019c,0xb4db0540,0x6738a8f4,0x65688927}},	//   _ايجا, _bhàt, dovj, _nudh, 
   {{0x7cfca8f5,0xa3d68758,0xb12580b2,0xb4db0097}},	//   _féri, ाटा_, বত্ব_, _chàt, 
   {{0x63a40123,0x395f875d,0x7f198091,0x37ab9662}},	//   cuin, _vius_, ліку_, ттен_, 
   {{0x65689c26,0x16a998cd,0x67388662,0xa3d581aa}},	//   _budh, увки_, govj, हिस_, 
   {{0x394da8f6,0xa19428f7,0xdcfb0d64,0xc5d58091}},	//   _thes_, _марч, _एकाध_, сіль, 
   {{0x2ca928f8,0xbb1b024a,0x51840ff8,0x28cf95ad}},	//   ngad_, _xwîn, _фура, _सोचि, 
   {{0x291da8f9,0x3ced8ecf,0x7d1ba8fa,0x7d09a8fb}},	//   miwa_, rjev_, rius, rhes, 
   {{0x291d80fd,0xddde0f91,0xfe708bb7,0x7305a8fc}},	//   liwa_, _lepš, _قدم_, споз, 
   {{0xdb0403b8,0x6568a8fd,0x657701ea,0x63a401f0}},	//   stiç, _gudh, _ntxh, zuin, 
   {{0x291da8fe,0x21391377,0x050905a2,0x14ca833f}},	//   niwa_, gosh_, রচুর_, _مهمی_, 
   {{0xeb99a8ff,0xdb0b806d,0xc50c80c6,0x9fd605a2}},	//   _сил_, _opgø, _בלאָ, সঙ্গ, 
   {{0xa3c10964,0x65688642,0x291da900,0x644b98d7}},	//   ंबई_, _yudh, hiwa_, _izgi, 
   {{0x7ae3a901,0x291d80fd,0x7cfca902,0x6b5008b4}},	//   _innt, kiwa_, _séri, lägg, 
   {{0x7cfca903,0x2ca90172,0x291d8010,0x3c6601e2}},	//   _péri, ggad_, jiwa_, скаг, 
   {{0x09b201ff,0x612805ee,0x68e42904,0x291d8010}},	// [1620] ीब्य, nılm, _inid, diwa_, 
   {{0x63a412dc,0x7cfc82c0,0xb4db0304,0x2ca9013b}},	//   ruin, _véri, _bhàs, agad_, 
   {{0x63a42905,0x28dd009b,0x8db600f0,0x291d804f}},	//   suin, याचि, _успі, fiwa_, 
   {{0x98a6a906,0x7cfca907,0x612802d2,0x291da908}},	//   сиде, _téri, kılm, giwa_, 
   {{0x1fb6a909,0x65688927,0xc7a389c5,0x29020008}},	//   ссер, _sudh, зичк, ikka_, 
   {{0x6128008a,0x6d44290a,0x4dbe80b2,0xa3bd00c9}},	//   dılm, llia, ্মসূ, _आहत_, 
   {{0x38698053,0x6d440324,0x6738a90b,0x291d8010}},	//   žara_, olia, rovj, biwa_, 
   {{0x539894b2,0x69ce290c,0xbb7489c5,0x232a04bc}},	//   авия_, _isbe, огиј, _роҳи_, 
   {{0x2d8502ba,0x673882cf,0x442f83b9,0x6d44290d}},	//   ález_, povj, _cxg_, ilia, 
   {{0x6d4424dc,0x78ad290e,0x35c48a09,0x68e4290f}},	//   hlia, _scav, _мазҳ, _anid, 
   {{0xe3afa0f4,0xdd92807b,0x6d440116,0x81b600b2}},	//   وری_, _روش_, klia, জিক_, 
   {{0xd8430507,0x00000000,0x00000000,0x00000000}},	//   _ničí_, --, --, --, 
   {{0x2d910066,0xff66024a,0xb0aa000f,0x6d44011a}},	//   wsze_, şîne_, _कारग, dlia, 
   {{0xa3d5a910,0x291da911,0x69dc2912,0x98be00f3}},	//   हिर_, ziwa_, _orre, ētā_, 
   {{0x68f60daa,0x7af50e63,0x8cda009b,0x2d852913}},	//   _foyd, _rozt, _पोहो, èle_, 
   {{0x6d440574,0x2d9125aa,0xbc792914,0x68e4239f}},	//   glia, rsze_, рбах_, _gnid, 
   {{0x290909ec,0x36d52118,0x69dc2915,0x7af52916}},	// [1630] _ilaa_, _допр, _arre, _pozt, 
   {{0x326703b6,0xa26704bc,0x2d9100a1,0xaa672917}},	//   став, съал, psze_, стак, 
   {{0x291d83b5,0x612803d2,0x7d030166,0x628a84e2}},	//   tiwa_, zılm, _înso, _mefo, 
   {{0xdb0980fe,0x61280a08,0x628aa918,0x6ca71bd8}},	//   iteá, yılm, _lefo, _урож, 
   {{0x69dc2919,0x6298a91a,0x291da91b,0xcf9b84c7}},	//   _erre, _odvo, riwa_, ује_, 
   {{0x7d0d0068,0x291da91c,0xab5b0019,0x6f878103}},	//   lhas, siwa_, _csüt, _ҳужж, 
   {{0x24e98574,0xace9a91d,0xceb404fc,0x28aa0f2c}},	//   имки_, имка_, פיק_, _कालि, 
   {{0x28d90bb6,0x612806c8,0x2fcd81ea,0x7d1f0103}},	//   _बोलि, tılm, _tseg_, niqs, 
   {{0x628aa91e,0xa49b017c,0x1309a91f,0x212d868e}},	//   _befo, _alòk, иний_, _ijeh_, 
   {{0x61280186,0x6906011e,0x4225a5b2,0xe2998a6a}},	//   rılm, _cóen, ждов, јан_, 
   {{0x90c6036d,0x7d0d11ea,0x60c600f3,0x6d44011a}},	//   обне, khas, tekm, ylia, 
   {{0xf9920052,0x7bcf2920,0x61282921,0x69da2922}},	//   ורט_, _oscu, pılm, _štek, 
   {{0x3c47803f,0x7529802d,0x7d0d003d,0x6b5008af}},	//   _اضاف, mnez, dhas, läge, 
   {{0x2bcf908a,0x26c7a923,0xa3d68a29,0x628aa924}},	//   _तैया, neno_, ाटर_, _gefo, 
   {{0x6281a925,0x7bcf002d,0x96631285,0x2ee580bf}},	//   mblo, _ascu, дкре, _mnlf_, 
   {{0x68e4052f,0xd4671d6a,0x7d0d2926,0x6281a927}},	//   _unid, жите_, ghas, lblo, 
   {{0x8c431aa0,0x26c7a928,0x24802929,0x6d56292a}},	// [1640] дете, keno_, rbim_, rmya, 
   {{0x681c0029,0xc8aa032d,0x61fe292b,0xb0aa197c}},	//   rādī, _काँट, typl, _काँग, 
   {{0x50668004,0x673c292c,0x7d0d292d,0x26c78f5f}},	//   отла, morj, bhas, deno_, 
   {{0xdb0400fe,0x31ba80c6,0x409682c3,0x7cfc833f}},	//   ntiú, יזענ, ірет, _yéru, 
   {{0xa3ce09d7,0x1eca87b4,0x765f8816,0x26c7a92e}},	//   _शनि_, илди_, əyyə, feno_, 
   {{0xdd9aa92f,0x7d040008,0x26c782fb,0x69ce00bc}},	//   аши_, lkis, geno_, _tsbe, 
   {{0x32432930,0xb0aa2931,0xaa4315e6,0x69dc2932}},	//   _жерг, _कांग, _жерл, _urre, 
   {{0x61e10068,0x3ea0a933,0x90c3a934,0x7d042935}},	//   _álla, şit_, _обсе, nkis, 
   {{0xd0078b29,0x63b62936,0x2f0b806d,0x26c7a937}},	//   _дете_, ntyn, _søge_, beno_, 
   {{0x39468422,0x26c7a938,0x2909004f,0x39400162}},	//   llos_, ceno_, _slaa_, _akis_, 
   {{0xd48f8b06,0x26d32939,0x7d04293a,0xdb040217}},	//   _ор_, _raxo_, kkis, guié, 
   {{0x394682ae,0x26d3293b,0x88b10184,0x657a8063}},	//   nlos_, _saxo_, ریخچ, _itth, 
   {{0xc86400f0,0xdb0980d8,0x628a8027,0xab2a8715}},	//   дтри, steá, _tefo, _кода_, 
   {{0x3ce681c8,0x62988131,0x3940149b,0x7c2da93c}},	//   _hnov_, _udvo, _ekis_, _žarg, 
   {{0x7d0d293d,0xf27b8052,0x394681e2,0x7cfca93e}},	//   thas, _דרוש, klos_, _fért, 
   {{0xdb0400fe,0x26c796ce,0x394681df,0x80a5293f}},	//   ctiú, zeno_, jlos_, _काटे, 
   {{0x7d0d2940,0x6b4f806d,0x39468a24,0xdb0d00fe}},	// [1650] rhas, søge, dlos_, staí, 
   {{0x657a8019,0x7d0d2941,0x26c783b9,0x39468728}},	//   _otth, shas, xeno_, elos_, 
   {{0xceb20464,0x69240d69,0x69160bfc,0x7d0401df}},	//   _איי_, rđev, ršev, bkis, 
   {{0x6b500172,0x3946a942,0x7d042943,0x26c7a944}},	//   väge, glos_, ckis, weno_, 
   {{0x657a8766,0x26c7a945,0x66e5a946,0x60dc00c6}},	//   _atth, teno_, зола, יקאנ, 
   {{0x62818142,0x644f01a8,0x3946811e,0xf8bf01d2}},	//   xblo, _izci, alos_, dném_, 
   {{0x26c78131,0x80ac0365,0x39468b27,0x7bc2a947}},	//   reno_, _झाले, blos_, _apou, 
   {{0x39468ca1,0x61360068,0x673c007e,0x6b5001ed}},	//   clos_, bály, zorj, räge, 
   {{0x76450008,0x6281a948,0x3952043a,0x7af88129}},	//   _lyhy, tblo, _rhys_, _bovt, 
   {{0x38692949,0x13098d6e,0x753b80ac,0x7cfca94a}},	//   _agar_, сной_, souz, _sért, 
   {{0x753b8533,0x7d040088,0x7bc2a303,0x673c007e}},	//   pouz, ykis, _epou, vorj, 
   {{0x2fdf805d,0x69d083ff,0x63b6019b,0xbcfb0217}},	//   _krug_, धिजी, ytyn, _sién, 
   {{0x673c294b,0xb4d78353,0x6281a94c,0x4aac0076}},	//   torj, ायी_, pblo, _चालव, 
   {{0x4e1f8611,0x3f9e026b,0x7bda8039,0x657a8396}},	//   _बधाई_, čtu_, _לקנו, _ytth, 
   {{0x386d0305,0x7d04294d,0xdb040035,0xbcfb0217}},	//   žera_, tkis, quié, _vién, 
   {{0x2571807f,0x63b60008,0x673c294e,0x61fc8341}},	//   _mál_, ttyn, sorj, ärle, 
   {{0xeb9a0537,0xf42a01ac,0x2fdf827e,0x7d04294f}},	// [1660] сиз_, _opäť_, _nrug_, rkis, 
   {{0x7d042950,0xa3dc8561,0x27e02951,0x60d62952}},	//   skis, डित_, _irin_, _haym, 
   {{0x9d462658,0x63b62953,0xfbdf01b2,0x60d602d2}},	//   _неод, styn, _erê_, _kaym, 
   {{0x2fdf8022,0x7ae7016c,0x63b62954,0x61360063}},	//   _brug_, _enjt, ptyn, tály, 
   {{0x3946a955,0xe81683b4,0x09a8800c,0x2efa01ed}},	//   rlos_, _देखा_, _कम्य, _kopf_, 
   {{0x26d82956,0x69c39130,0x26ca2957,0xf67a00c6}},	//   ndro_, _opne, nebo_, זאַמ, 
   {{0x629c2958,0x7bc2a959,0x2571811e,0x3946a95a}},	//   _idro, _spou, _cál_, plos_, 
   {{0x399b0039,0x628e295b,0x27e0295c,0x2571801b}},	//   _לילד, _hebo, _orin_, _dál_, 
   {{0x63a9a95d,0x628e0c02,0x6566295e,0x7cfc812b}},	//   guen, _kebo, _mikh, _sérs, 
   {{0xa3ab8066,0x3a7581e5,0x63a4295f,0x877b83dd}},	//   गढ़_, үлөр, irin, _לאמי, 
   {{0x63a42960,0x6446007f,0x27e02961,0x19590116}},	//   hrin, _lyki, _arin_, жаны_, 
   {{0x628e03ec,0x63a9a962,0x7cfca963,0x2906a964}},	//   _lebo, buen, _vérs, nkoa_, 
   {{0xd83b077a,0x63a996b7,0x7cfca93e,0x60c080bf}},	//   сэн_, cuen, _férr, _mbmm, 
   {{0x63a41e95,0x628e1589,0x27e02965,0xa3e0032d}},	//   drin, _nebo, _drin_, थिन_, 
   {{0x2d9e003b,0x27e02966,0xd49b2967,0x29068008}},	//   šten_, _erin_, йра_, kkoa_, 
   {{0xca478013,0x63a42968,0x629c0324,0xf8bf00ef}},	//   _عليه_, frin, _adro, fiée_, 
   {{0x63a42969,0xa3d58066,0x24580008,0x65660504}},	// [1670] grin, हिए_, зать_, _dikh, 
   {{0x628e1f28,0x629c039d,0x290682fe,0x2fdf9473}},	//   _cebo, _cdro, ekoa_, _rrug_, 
   {{0x3207296a,0x6566296b,0x644600bf,0x16350f70}},	//   ány_, _fikh, _eyki, _ценя, 
   {{0x25e085b1,0x6ebf800d,0xf42a01ac,0x5fb103f0}},	//   किनी_, ल्नु, _späť_, _जमाल, 
   {{0xf8bf0035,0x2571a96c,0x6136011e,0x33590166}},	//   ciée_, _sál_, rálx, _мамэ_, 
   {{0x628e10d2,0x290f8daa,0x65660232,0x670d03ff}},	//   _gebo, shga_, _zikh, हसिक_, 
   {{0x69da0ecf,0x30a7a96d,0x20020034,0x60dd8149}},	//   _štev, _нрав, zyki_, _ósmo, 
   {{0x58d4a96e,0x629c09d8,0x63a98109,0x26d81cb1}},	//   _пост, _zdro, tuen, zdro_, 
   {{0x2be014a0,0x1958a0e0,0x68e9a96f,0x29078162}},	//   निया, _хаты_, _ined, ūnas_, 
   {{0x68fba970,0x63a9a971,0x7c26807f,0x68e980e9}},	//   _houd, ruen, úkra, _hned, 
   {{0x68fba972,0x80d700b2,0x98a615c8,0x2bdba973}},	//   _koud, ধান্, мине, बिहा, 
   {{0x27e00cc1,0x26c10265,0x200200a1,0x63a42974}},	//   _prin_, _abho_, tyki_, yrin, 
   {{0x21221fd8,0xe2998e1c,0x63a9a975,0xeb8ea28e}},	//   rikh_, _дал_, quen, _ши_, 
   {{0x6d49a976,0x6723a977,0x29068124,0x63a42978}},	//   llea, ninj, zkoa_, vrin, 
   {{0xdd1c026b,0x63a42979,0x644f8183,0xed168019}},	//   _vážn, wrin, škić, _رہیں_, 
   {{0x63a4297a,0x27e0297b,0x6d49a97c,0x752d297d}},	//   trin, _trin_, nlea, gnaz, 
   {{0x6d49a97e,0xab66297f,0x59d58f21,0xc9530039}},	// [1680] ilea, двал, धिकर, _במה_, 
   {{0x03a30c1f,0x290da980,0x63a42981,0xf8bf0035}},	//   тифо, _alea_, rrin, riée_, 
   {{0x68fba303,0x63a42982,0x656602d7,0x68e98519}},	//   _boud, srin, _tikh, _bned, 
   {{0xc7c68b34,0x628e0410,0x8fa68591,0x4fc6a983}},	//   дски, _webo, даде, дска, 
   {{0x628e2984,0x4c3601e2,0x68fba985,0x2906a986}},	//   _tebo, _цэнт, _doud, rkoa_, 
   {{0xf8bf0019,0x291f80bf,0x29068122,0xdee3a03d}},	//   tnék_, _emua_, skoa_, кочи, 
   {{0x8a060b1c,0x62632987,0x274901b2,0x68fb8429}},	//   _ўзбе, _авра, lînê_, _foud, 
   {{0x25a0a988,0x7afc2989,0x68fba98a,0xe81f8503}},	//   čil_, _hort, _goud, _मेवा_, 
   {{0x6723a98b,0x2749024a,0x644e8034,0xaf2aa98c}},	//   binj, nînê_, ębio, _джаз_, 
   {{0x67238053,0x68fb8a44,0xadba80fe,0xe45703f3}},	//   cinj, _zoud, _وهذا_, ויפט_, 
   {{0x6d49a98d,0xf2d30039,0x3606819c,0xbcfb298e}},	//   blea, דעת_, _تواف, _diéj, 
   {{0x7afc0124,0xcb6a832a,0xf7870da7,0x249d8c4e}},	//   _lort, _даде_, íços_, _gdwm_, 
   {{0xac97807b,0x7afc01b0,0x2d9e298f,0x7d0328e1}},	//   _آنها_, _oort, štel_, _însi, 
   {{0x6d40a990,0x7afc16b9,0xdce280ca,0x2120028b}},	//   loma, _nort, _mioč, _emih_, 
   {{0xa3d689d7,0xdb0081ce,0x7bc601a8,0x6455885a}},	//   ाटक_, cumá, _apku, ęzie, 
   {{0x6d40a991,0x50670aff,0x66f802d2,0x6b50010d}},	//   noma, _отпа, _aşkı, väga, 
   {{0x752d2992,0xdb0d0077,0x3b552993,0x7afc009a}},	// [1690] rnaz, ntaç, екар, _bort, 
   {{0x291fa994,0x68fba995,0xdb0d02fd,0x6d498122}},	//   _smua_, _soud, itaç, zlea, 
   {{0x6d40a996,0x68fba997,0x7afc2998,0xda0e80ab}},	//   koma, _poud, _dort, ानित_, 
   {{0x6d408103,0x2d8301f0,0xa49b0097,0xe7f3885a}},	//   joma, mpje_, _clòt, _आपदा_, 
   {{0x67238025,0x69da003a,0x68fb80ef,0x25750172}},	//   tinj, _štet, _voud, _hål_, 
   {{0x63ad2999,0x7afc299a,0xe7338743,0x68fb96af}},	//   muan, _gort, خصص_, _woud, 
   {{0x67238ecf,0x63ad299b,0xe81fa99c,0x6d40a99d}},	//   rinj, luan, _मेरा_, foma, 
   {{0x25750088,0xdfd59878,0x67d5a719,0x6723a99e}},	//   _mål_, _побы, _побу, sinj, 
   {{0x6d49a99f,0x6d5ba9a0,0x7768811e,0x7afc04da}},	//   rlea, rmua, _fidx, _yort, 
   {{0x7afc1d73,0xa3e0093e,0x6d49a9a1,0xcb1200c6}},	//   _xort, थित_, slea, ָלט_, 
   {{0x6d498ed8,0x7648a9a2,0x7d0f0019,0x6d40a9a3}},	//   plea, _gydy, _olcs, boma, 
   {{0x6d40a9a4,0xdb0980b0,0xe8f72202,0x75d38816}},	//   coma, nteú, елю_, _nəzə, 
   {{0xa3d5807a,0x316929a5,0x7d09a9a6,0x13f48086}},	//   हिओ_, _diaz_, mkes, _изця, 
   {{0x63ad1a28,0x2d9e005d,0x7d09a9a7,0x2749024a}},	//   duan, štem_, lkes, vînê_, 
   {{0x63bba9a8,0x2f1400f9,0x9db9004a,0xed5a29a9}},	//   ltun, _lägg_, мыту_, зов_, 
   {{0x7afc29aa,0xc5f280c6,0x69a48076,0x1da78034}},	//   _sort, נדן_, _किती, _गिनत, 
   {{0x63ad29ab,0x03a329ac,0x60c400bb,0xa49b044e}},	// [16a0] guan, лито, _ibim, _alòs, 
   {{0x28c10056,0x7afc01bb,0x63bba9ad,0x274902a5}},	//   ष्ठि, _qort, itun, rînê_, 
   {{0x63bba9ae,0x7afc125c,0x7d09a9af,0x6d40a9b0}},	//   htun, _vort, kkes, yoma, 
   {{0x26da022d,0x63bba9b1,0x76488324,0x7afc29b2}},	//   _hapo_, ktun, _rydy, _wort, 
   {{0xe7e329b3,0x26da29b4,0x6d4629b5,0x63ad0149}},	//   खिया_, _kapo_, _ikka, cuan, 
   {{0x6b8429b6,0x2d8c80ed,0x26da29b7,0x98c58f30}},	//   mpig, _pwde_, _japo_, ītās_, 
   {{0x60c429b8,0x2d9a9ceb,0xceb300c6,0x63bba9b9}},	//   _obim, épe_, טיג_, etun, 
   {{0x63bba9ba,0x75d3808a,0xc5f30039,0xd9e3802a}},	//   ftun, _xəzə, רדה_, गिनत_, 
   {{0x63bb8b5c,0xd4e38008,0xef1aa9bb,0x41038103}},	//   gtun, ующи, _ема_, _ёзув, 
   {{0x2d6e800d,0x6b4f8142,0xdb0d29bc,0x26da29bd}},	//   _před_, søgn, rtaç, _napo_, 
   {{0x6d4629be,0xdb0402c0,0x95caa9bf,0xdb0d03b8}},	//   _okka, rriè, _хлеб_, staç, 
   {{0x69b180a1,0x7c29008d,0xdb0d02fd,0xdcdf03f0}},	//   _अमरी, _žerm, ptaç, _पोंछ, 
   {{0xb8d9059b,0xa3e4800d,0xa2c129c0,0xdb04011e}},	//   _चा_, _पछि_, र्ड्, ntió, 
   {{0x5453836a,0x6d4629c1,0x26da29c2,0xdef829c3}},	//   _світ, _akka, _capo_, ныс_, 
   {{0x0dc815a1,0x95c80286,0x394229c4,0x7c8702f0}},	//   нути_, нута_, boks_, еузе, 
   {{0x290b034a,0x63ad29c5,0x2b5829c6,0x394200bf}},	//   ības_, tuan, _ahrc_, coks_, 
   {{0x8aa70157,0x69c729c7,0xfaa70e79,0x6b840786}},	// [16b0] еред, _spje, ешен, gpig, 
   {{0x60dd0aa1,0x2fc902eb,0x2575010d,0x82d80123}},	//   ldsm, _ipag_, _tål_, ндус_, 
   {{0xf99307db,0x799aa9c8,0x63bba831,0x67270265}},	//   ابط_, nstw, ztun, mijj, 
   {{0x60dd2570,0x2fc902b1,0x2d810096,0x63bb9606}},	//   ndsm, _kpag_, _ithe_, ytun, 
   {{0xb8c9a9c9,0x63ad29ca,0x69d500a1,0x248929cb}},	//   _गए_, quan, _wsze, mbam_, 
   {{0x6d4d21b1,0x6da586a1,0x4439039d,0x67270269}},	//   llaa, вика, _ixs_, nijj, 
   {{0xa3b3809b,0x7d09a9cc,0x68ed29cd,0x98c7a9ce}},	//   जून_, tkes, _onad, _псал, 
   {{0x63bba9cf,0x4c6988c6,0x629729d0,0x386d8142}},	//   ttun, мийн_, laxo, _uger_, 
   {{0x76b9805a,0x63bb8008,0x7d09a9d1,0xd9d9801b}},	//   _олар_, utun, rkes, बट्ट, 
   {{0x613d0068,0x7d09a9d2,0x63bb8373,0x7522a9d3}},	//   mély, skes, rtun, _emoz, 
   {{0x63bba9d4,0x6d4d29d5,0x3f80002d,0x2d81022a}},	//   stun, klaa, _stiu_, _nthe_, 
   {{0x60db80a6,0xdb2689dc,0x26da29d6,0xbb228093}},	//   _jaum, _یونی, _sapo_, çîrv, 
   {{0x889a8039,0x6d4d29d7,0x26da29d8,0x2f140172}},	//   וברי, dlaa, _papo_, _läge_, 
   {{0x4ed529d9,0x4ad7811d,0xdb0402c0,0xfaa5a9da}},	//   люст, _ساتھ_, prié, _рако, 
   {{0xceb29af4,0x55c5004a,0x63a9a9db,0x656ba9dc}},	//   יים_, ларғ, lren, _kigh, 
   {{0x6d4d29dd,0x26da004f,0x63a9a9de,0x4439055a}},	//   glaa, _wapo_, oren, _bxs_, 
   {{0x26da0116,0x436a29df,0x656ba9e0,0xb46629e1}},	// [16c0] _tapo_, даан_, _migh, ткал, 
   {{0x6d4d29e2,0x613d0019,0x656ba9e3,0x68ed061c}},	//   alaa, dély, _ligh, _znad, 
   {{0x2be0007a,0x63a9a9e4,0x644b8116,0x60dba9e5}},	//   निहा, hren, _lygi, _baum, 
   {{0x63a9829f,0xfbab13d2,0x290029e6,0x656ba9e7}},	//   kren, _चमचम, _joia_, _nigh, 
   {{0x68439747,0x7c2da9e8,0xb4c00c2e,0xdefaa9e9}},	//   анца, _žarn, ूजी_, дый_, 
   {{0xa3c100a1,0x3cda85b7,0x656b8336,0xde58909a}},	//   ूबर_, _खोजे_, _aigh, налі_, 
   {{0xdb040422,0x63a9a9ea,0x28dd9352,0x2be029eb}},	//   stió, eren, _नोकि, निवा, 
   {{0x6d59a9ec,0x290029ed,0x60dba9ee,0x6d4429ef}},	//   _chwa, _noia_, _gaum, noia, 
   {{0x63a990e3,0x6b9b84c0,0xdb04011e,0x5046a9f0}},	//   gren, gsug, ltiñ, _реаб, 
   {{0x6d5983bf,0x68ed001b,0xbcfb011e,0x86ea80d8}},	//   _ehwa, _snad, _viéi, _تعرف_, 
   {{0xdb0404e0,0x63a9a9f1,0x7c2d807f,0x67270269}},	//   ntiñ, aren, _þarn, vijj, 
   {{0x0c26a4c6,0xe8e00028,0x799a80a1,0x94268008}},	//   _имен, _trời_, rstw, _имее, 
   {{0x692b000d,0xc3c4804a,0x291204da,0x67270269}},	//   třeb, _сөйл, _dlya_, tijj, 
   {{0xf8bf06c9,0x4ea40ced,0xe9e68166,0x29120399}},	//   cién_, ирса, _ацио, _elya_, 
   {{0x7e280d6b,0x6d4d29f2,0xf62800f0,0x6e941aa0}},	//   віта_, tlaa, віти_, рису, 
   {{0xe7f3809b,0x69d8a9f3,0x67270269,0x68ed29f4}},	//   _आपला_, _isve, sijj, _unad, 
   {{0x64740a1c,0x545529f5,0xdc550003,0x6d4d00d0}},	// [16d0] ргуу, уват, увањ, rlaa, 
   {{0x6d4d0b7e,0xf1b6a93f,0x6b8282d9,0xe3b000d8}},	//   slaa, _अमान, _mtog, ترف_, 
   {{0x6d4d29f6,0x7b64005a,0x60dba9f7,0x26d129f8}},	//   plaa, ртте, _paum, mezo_, 
   {{0x301584a0,0x26d129f9,0x2600001b,0x290003b9}},	//   лдер, lezo_, रहरी_, _xoia_, 
   {{0xe8d9010b,0x656b8052,0xd91c0273,0x251a0039}},	//   _chỉ_, _righ, וואל, _נושא, 
   {{0x69d89491,0xb87b1355,0x26d10ce5,0x60db883d}},	//   _osve, ndíb, nezo_, _waum, 
   {{0x99679da8,0x60dba9fa,0xdb040ca1,0x2d94a1e7}},	//   _атал, _taum, quiá, арыс, 
   {{0x26d129fb,0x3949027e,0x693c8934,0x3ea9a9fc}},	//   hezo_, _nkas_, včeg, şat_, 
   {{0x26d129fd,0x0b458004,0xe299801d,0x63a9a9fe}},	//   kezo_, лнин, нап_, uren, 
   {{0xe1f9836d,0x63a9a9ff,0x656baa00,0x25788019}},	//   его_, rren, _wigh, _fél_, 
   {{0x7d0d2a01,0x6d59aa02,0xa2ca0a8b,0x26d1011e}},	//   kkas, _thwa, _सॉफ्, dezo_, 
   {{0x38698215,0x69a48c2e,0x6455808a,0x61f82a03}},	//   žaru_, _किरी, əzin, ävli, 
   {{0x03a5aa04,0x53a5aa05,0x7d0d2a06,0x69d88a1c}},	//   _сило, _салб, dkas, _esve, 
   {{0x62952337,0x26d12a07,0x3f9f82b9,0x7529aa08}},	//   _nezo, gezo_, _mvuu_, liez, 
   {{0x64a62a09,0xc0e62a0a,0xdd1d01d2,0xdb26811e}},	//   лава, _бойк, lářs, _ápáx, 
   {{0x7d0d044c,0xa3e02a0b,0x7e7c0217,0x7529aa0c}},	//   gkas, थिल_, scrp, niez, 
   {{0x0aea134a,0x6295063c,0x6eac00a1,0xdb0402fd}},	// [16e0] ндай_, _bezo, _जयपु, nuiç, 
   {{0xb4632a0d,0x7d0d0008,0x8a3a019b,0xdb00aa0e}},	//   скул, akas, няет_, stmö, 
   {{0x62952a0f,0x8886809f,0xd24f00fe,0x9abc8208}},	//   _dezo, глеж, كنك_, fiċj, 
   {{0xdb0401e0,0x8884804a,0xc09689ef,0x25aa87c5}},	//   rtiñ, рғал, اجات, _åbli_, 
   {{0xa3d28639,0x316daa10,0xdb042a11,0x6ac900b2}},	//   _हैं_, _diez_, stiñ, রয়ো, 
   {{0x62952a12,0x6f01aa13,0xaa460f70,0xa8570309}},	//   _gezo, _colc, _бегл, ניסה_, 
   {{0x645d812b,0x6f01809f,0xceb30039,0xe5c698ed}},	//   ýsin, _dolc, ציה_, усло, 
   {{0xd1328bb7,0x386d2a14,0x78a42a15,0x7529963b}},	//   _امر_, žeri_, _ndiv, giez, 
   {{0x5b14aa16,0x28dd800f,0x6f01aa17,0xdb0402fd}},	//   имит, _नोटि, _folc, guiç, 
   {{0x3946aa18,0x78a4288d,0x2578aa19,0x9bbb00c6}},	//   loos_, _adiv, _tél_, עציפ, 
   {{0xaac62a1a,0x80de00cf,0xd250807b,0x7d0d2a1b}},	//   र्यक, যান্, تند_, ykas, 
   {{0xdb0403b8,0x3f8480db,0x26deaa1c,0x644b02f4}},	//   buiç, _ktmu_, _hato_, ügik, 
   {{0xe8d9010b,0xa3b3823b,0xc2e68004,0xed57aa1d}},	//   _giờ_, जूद_, _бўйи, _соц_, 
   {{0x4ea713c9,0x26de9eb4,0x8c1b8039,0xdb1e810d}},	//   ырма, _jato_, _אודי, övän, 
   {{0x62952a1e,0xc27b896e,0x7d028a2f,0x26d12a1f}},	//   _rezo, _ארוי, _koos, rezo_, 
   {{0x9983830b,0x629aaa20,0xf1a980a1,0x26deaa21}},	//   _اليو, lato, _कितन, _lato_, 
   {{0x2418104c,0x62950217,0x26d12a22,0x176b0166}},	// [16f0] готы_, _pezo, pezo_, _проп_, 
   {{0x212b0354,0x27e92a23,0x7d0d2a24,0x830500b2}},	//   lich_, _iran_, skas, োচ্চ_, 
   {{0x466b0103,0xe8d90106,0x9875aa25,0xa2c12a26}},	//   _ярим_, _nhị_, алец, र्ष्, 
   {{0x629aaa27,0x212b0c9f,0x326411a9,0x6f01aa28}},	//   hato, nich_, стув, _solc, 
   {{0x26deaa29,0x4ac48673,0x35ab002a,0xbcfb2a2a}},	//   _bato_, वभाव, _छिड़, _diét, 
   {{0x7ceb08b4,0x656f022d,0xaec480f0,0xde0591bc}},	//   _förä, _hich, йбіл, ипли, 
   {{0x212b0066,0x26deaa2b,0x6f01a1d3,0x656f2a2c}},	//   kich_, _dato_, _volc, _kich, 
   {{0x212b0791,0x63ad2a2d,0x27e92a2e,0xdb040077}},	//   jich_, oran, _oran_, tuiç, 
   {{0x656f2a2f,0x212b0304,0x9ed9809f,0x26de83b8}},	//   _mich, dich_, _имат_, _fato_, 
   {{0x656f2a30,0x0325aa31,0x26deaa32,0x13098008}},	//   _lich, рдон, _gato_, тной_, 
   {{0x63ad2a33,0x27e92a34,0x7529aa35,0x69de826b}},	//   hran, _aran_, piez, _šper, 
   {{0x656f0972,0x212b2a36,0x95678574,0x75ca8816}},	//   _nich, gich_, _създ, _qəze, 
   {{0x63ad0284,0x248daa37,0x5edf00b2,0x33879225}},	//   jran, mbem_, মানে, _суев, 
   {{0x7d02822a,0x656f2a38,0x6b89aa39,0x27e92a3a}},	//   _zoos, _aich, mpeg, _dran_, 
   {{0xde0310b5,0x63ad2a3b,0x27e92a3c,0x656f2a3d}},	//   опри, eran, _eran_, _bich, 
   {{0x63ad2a3e,0xac862a3f,0x212b01ac,0x69c1aa40}},	//   fran, ргал, cich_, mtle, 
   {{0x27e92a41,0x656f2a42,0x998d256a,0x03262a43}},	// [1700] _gran_, _dich, _ćeš_, адан, 
   {{0x6d5d2a44,0x656f20c0,0x2d858027,0x60c9aa45}},	//   _ehsa, _eich, _otle_, _abem, 
   {{0x63ad2a46,0xa2bd80c3,0x2d8583ec,0xb87b016f}},	//   aran, _शान्, _ntle_, ldía, 
   {{0x629aaa47,0xfce60daa,0x2ba6908a,0x26de840b}},	//   zato, _томо, _खिला, _sato_, 
   {{0x26c880b6,0x7d02aa48,0xb87b060e,0xdb09816f}},	//   лған_, _roos, ndía, nteó, 
   {{0x656f2a49,0x69c1a3ca,0x6d4b84e2,0x394681df}},	//   _zich, ktle, _akga, soos_, 
   {{0x656f0daa,0xfaa32a4a,0x26de80de,0xdd97aa4b}},	//   _yich, _фасо, _vato_, ашы_, 
   {{0x629a807b,0x6143aa4c,0x9cca81e2,0xd943aa4d}},	//   wato, _деса, тыка_, _деси, 
   {{0x26deaa4e,0x212b2a4f,0x2fc0022a,0x629aaa50}},	//   _tato_, vich_, _nqig_, tato, 
   {{0xe8d9010b,0x68e0aa51,0x5b14836d,0x31782a52}},	//   _thị_, _hamd, смот, _kurz_, 
   {{0x2904aa53,0x257c0013,0x13cf00cf,0xbcfb2a54}},	//   _koma_, _níl_, রিয়, _miér, 
   {{0x27e90206,0x68e288d6,0x2904aa55,0x64468587}},	//   _pran_, ndod, _joma_, ükis, 
   {{0x212b2a56,0x2f1400f9,0xd83b062d,0x656f2a57}},	//   rich_, _säga_, тэн_, _rich, 
   {{0x656f2a58,0x2904aa59,0x212b0c9f,0x69dc007e}},	//   _sich, _loma_, sich_, _osre, 
   {{0x656f022d,0x2d850622,0x35e405cf,0x69c1893c}},	//   _pich, ële_, оцтв, ctle, 
   {{0x5c752a5a,0x2f140073,0x2904aa5b,0x6298aa5c}},	//   слат, _väga_, _noma_, _hevo, 
   {{0x2129022c,0x656f2a5d,0x68e28324,0xd3711351}},	// [1710] _imah_, _vich, ddod, سها_, 
   {{0xf1da8066,0x656f02ae,0x59da9379,0x63ad2a5e}},	//   _बनान, _wich, _बनार, rran, 
   {{0x63ad176c,0x656f2a5f,0x644f00a1,0xc69202f9}},	//   sran, _tich, _wyci, _מאי_, 
   {{0x2904aa60,0x63ad2a61,0xc8798085,0x68e0811a}},	//   _coma_, pran, _başa_, _camd, 
   {{0x27e9aa62,0x68e0aa63,0x752d2a64,0x6b5d8429}},	//   ían_, _damd, miaz, lège, 
   {{0x6298aa65,0x81cd80cf,0x7bdd0052,0x752d2a66}},	//   _nevo, রিত_, _issu, liaz, 
   {{0x63a2aa67,0x51840c1f,0xe7f38066,0x692b001b}},	//   _avon, _мута, _आपका_, vřen, 
   {{0xce380c2d,0x752d2a68,0x25a9aa69,0x657a00d8}},	//   יאות_, niaz, čal_, íthi, 
   {{0x62989591,0xe784aa6a,0x3015aa6b,0x7de08068}},	//   _bevo, _духо, _удар, tásá, 
   {{0x69c1aa6c,0xf7708013,0x6b89aa6d,0xc2e98068}},	//   ttle, _قال_, rpeg, اعظم_, 
   {{0x7c3b012b,0x395f81df,0x6b89aa6e,0xa2e58103}},	//   _þurf, _khus_, speg, _ҳолд, 
   {{0xa3d281d1,0x443d81df,0x628e807f,0x9f8402bb}},	//   _हैक_, _txw_, ðbor, оҳид, 
   {{0xe28e8b29,0x4385830b,0x752d2a6f,0x7d1baa70}},	//   _на_, _التق, diaz, mhus, 
   {{0x6298a670,0xe7fa809b,0x212903d9,0xe299aa71}},	//   _gevo, ्हता_, _emah_, _сак_, 
   {{0xba9a8052,0x63a2886a,0x7bdd1a9d,0x1a658139}},	//   _עסקי, _zvon, _assu, _دیدی_, 
   {{0x31a382bc,0x15b8005a,0x61431285,0x2bac0a64}},	//   mız_, лығы_, _неща, _चिदा, 
   {{0x42ca2a72,0x2904aa73,0xed5700b0,0x68e0aa74}},	// [1720] лган_, _roma_, сот_, _ramd, 
   {{0x2904aa75,0x6281aa76,0x65640097,0x394d868e}},	//   _soma_, nclo, smih, _akes_, 
   {{0x31a3aa77,0xdb0984e0,0x7d1baa78,0x7bdd0ca7}},	//   nız_, nteñ, khus, _essu, 
   {{0xd83a9f43,0x752d2a79,0x395faa7a,0x75ca808a}},	//   лэл_, ciaz, _chus_, _nəza, 
   {{0xe1e78a0e,0x68e2aa7b,0x7d1baa7c,0xc7968193}},	//   _کس_, rdod, dhus, ёрды, 
   {{0x290482d9,0x99762a7d,0x6e93aa7e,0xdb04016f}},	//   _woma_, _гуаш, пишу, briá, 
   {{0x63a2812b,0x69dc0a5a,0xacf89248,0x6d41012b}},	//   _svon, _usre, инку_, élag, 
   {{0x629e2a7f,0x7d1baa80,0x186aa9bb,0x75ca808a}},	//   lapo, ghus, _баби_, _cəza, 
   {{0x44202a81,0x7d0601e2,0xa3b383ca,0x77e20a64}},	//   nzi_, _moks, जूल_, गटोक_, 
   {{0xbea3aa82,0x629e2a83,0x752d2a84,0x6281aa85}},	//   _наук, napo, ziaz, gclo, 
   {{0x60f92a86,0x9cca8bb1,0x14ca8008,0x8afb0080}},	//   ання_, _была_, _были_, אליז, 
   {{0xeb9aaa87,0x629e02eb,0x63a2897e,0xe8d90106}},	//   _бид_, hapo, _tvon, _thọ_, 
   {{0x2571805d,0x629e2a88,0x6ebf800f,0x6298aa89}},	//   _ušla_, kapo, ल्कु, _tevo, 
   {{0x44202a8a,0x657aaa8b,0x543b80c6,0x1ddc98fe}},	//   dzi_, _kuth, _געדא, _मनात, 
   {{0x918688f7,0x50c88353,0x44202a8c,0xdd94001d}},	//   _اجتم, रभाष, ezi_, засы, 
   {{0x21292a8d,0x657a8889,0x7a0a808a,0x40350d29}},	//   _umah_, _muth, rətd, _мейс, 
   {{0x2d580157,0x657aaa8e,0x60cd2a8f,0xba9907c5}},	// [1730] сить_, _luth, _ibam, иває_, 
   {{0x3f8902fd,0x394b1fc8,0x2499013b,0x2dd52a90}},	//   _itau_, locs_, _wesm_, _джор, 
   {{0xe5c72a91,0x395f81df,0x657a847f,0x44202a92}},	//   _успо, _phus_, _nuth, azi_, 
   {{0x26ccaa93,0x63b62a94,0x44202a95,0x764482d2}},	//   _abdo_, buyn, bzi_, ğiyl, 
   {{0x7bc41474,0x2b930c0b,0x657a8052,0x60cd2a96}},	//   ctiu, _ریاس, _auth, _mbam, 
   {{0x6b8d2a97,0x079c0039,0xdb231b36,0x31a38083}},	//   mpag, נסול, örän, yız_, 
   {{0x45198f83,0x60cd2a98,0x6b8d2a99,0xe8d90028}},	//   иция_, _obam, lpag, _nhỏ_, 
   {{0x518409db,0x69c52a9a,0xc9840692,0x6b8d2a9b}},	//   _хура, mthe, _хури, opag, 
   {{0xfc31830b,0x31d18503,0x3f891123,0x7d1b837c}},	//   بحث_, तब्ध, _ntau_, rhus, 
   {{0x657aaa9c,0x693c98d4,0x7d1baa9d,0x60cd2a9e}},	//   _futh, nčen, shus, _abam, 
   {{0x44202a9f,0x3f890271,0xb87b2aa0,0x657aaaa1}},	//   zzi_, _atau_, rdín, _guth, 
   {{0xe56e836a,0xc6892aa2,0x69c50d02,0x291da6ba}},	//   _із_, _יא_, ithe, nhwa_, 
   {{0x31a383d2,0xeb998a53,0x81c100b2,0x505a1023}},	//   sız_, _тил_, ্টি_, ршня_, 
   {{0x6b8d2aa3,0x212f8c9f,0xe3b0aaa4,0x69c52aa5}},	//   dpag, high_, _سره_, kthe, 
   {{0x366a2118,0x693c8170,0x78a9aaa6,0x7ae381cb}},	//   раво_, dčen, _odev, _iant, 
   {{0x7ae3aaa7,0x44200124,0x2d780183,0x81c100b2}},	//   _hant, tzi_, _očev_, ্টা_, 
   {{0x7ae3aaa8,0x629e04b7,0x66e60003,0x7d060b83}},	// [1740] _kant, tapo, _допа, _voks, 
   {{0x7ae3957e,0x78a98012,0x249f81c8,0x7bc42aa9}},	//   _jant, _adev, haum_, rtiu, 
   {{0x44200068,0x7bc42aaa,0xe9da2aab,0x68e42aac}},	//   szi_, stiu, рке_, _kaid, 
   {{0x6b8d2aad,0x26d82aae,0x657aaaaf,0x290207ad}},	//   bpag, lero_, _ruth, njka_, 
   {{0x2ca02ab0,0x657aaab1,0x795d040c,0x7ae3aab2}},	//   maid_, _suth, néwa, _oant, 
   {{0xfdfe0e78,0x26d82ab3,0xf413004d,0x7ae3aab4}},	//   _उपास_, nero_, _חפש_, _nant, 
   {{0x63a42ab5,0x27edaab6,0x629c0029,0xd5b080fe}},	//   lsin, _eren_, _iero, رفة_, 
   {{0x7ae39be1,0x26d82ab7,0x68e40048,0x291daab8}},	//   _aant, hero_, _naid, chwa_, 
   {{0xa2ca2851,0x629c2ab9,0x26d82aba,0xdddc01de}},	//   स्थ्, _kero, kero_, jbrž, 
   {{0x629c2abb,0x26d82abc,0xbcfb00fe,0x3d18aabd}},	//   _jero, jero_, _mhéa, _déwa_, 
   {{0x7ae3aabe,0x629c2abf,0x26d82ac0,0xdb0986c9}},	//   _dant, _mero, dero_, creí, 
   {{0x645c808c,0x2ca00079,0x7c65803d,0x68e42ac1}},	//   ərin, jaid_, _کامل, _caid, 
   {{0x7ae3aac2,0xb4d693d2,0xc05b005a,0x26d82ac3}},	//   _fant, ाजी_, рін_, fero_, 
   {{0xa3d78611,0x629c2ac4,0x26d82698,0xf6518068}},	//   ाबर_, _nero, gero_, _آئے_, 
   {{0xd49b0b29,0x6b8d2ac5,0x68e42ac6,0xc1c900a1}},	//   ира_, wpag, _faid, _रहेग, 
   {{0x68e42ac7,0x7ae3aac8,0x25ad20c9,0x63a42ac9}},	//   _gaid, _zant, čel_, fsin, 
   {{0xbcfb0013,0x63a42aca,0x26d82acb,0x7ae3aacc}},	// [1750] _chéa, gsin, bero_, _yant, 
   {{0x68e400fd,0xbcfb030b,0xa3ac000f,0x6b8d2acd}},	//   _zaid, _dhéa, _गिर_, rpag, 
   {{0xa2bd81aa,0x212f80fe,0x291daace,0x13d380b2}},	//   _शास्, tigh_, thwa_, ়িয়, 
   {{0xa2ca824c,0xbcfb0013,0x2ca02acf,0x69c52ad0}},	//   त्त्, _fhéa, caid_, rthe, 
   {{0x629c2ad1,0xf484003d,0x212f8caf,0x2fc6aad2}},	//   _fero, _تاپی, righ_, gtog_, 
   {{0x291daad3,0x629c2ad4,0x2d959664,0x212f80d8}},	//   shwa_, _gero, прис, sigh_, 
   {{0x7ae3aad5,0x6ecd000c,0x6d44aad6,0x61ee0a63}},	//   _rant, द्यु, čian, _grbl, 
   {{0x7ae393ca,0x27edaad7,0x62852ad8,0xd4d9836a}},	//   _sant, _tren_, lcho, ські_, 
   {{0x26c105cb,0x629c012c,0x27edaad9,0x249f925c}},	//   _ocho_, _yero, _uren_, raum_, 
   {{0x62852ada,0x629c2adb,0x68e42adc,0x26c1022a}},	//   ncho, _xero, _said, _ncho_, 
   {{0xdb0d02ba,0x26d82add,0x68e42ade,0x63a42adf}},	//   ntañ, vero_, _paid, zsin, 
   {{0x26c10077,0x7c2d9cd6,0x9f4481e0,0x63a42ae0}},	//   _acho_, _žaru, _irmá_, ysin, 
   {{0x7ae3aae1,0x26d82ae2,0x68e42ae3,0x2ca00073}},	//   _tant, tero_, _vaid, vaid_, 
   {{0x7ae3827e,0x62852ae4,0x25ac026b,0xbbe9804e}},	//   _uant, jcho, ádlo_, _پرچم_, 
   {{0x26d82ae5,0x62852ae6,0xdb0d00ef,0x68e42ae7}},	//   rero_, dcho, traî, _taid, 
   {{0x629c2ae8,0x63a42ae9,0x26d82aea,0xb4e629c0}},	//   _sero, tsin, sero_, पये_, 
   {{0xa507009f,0xd467039c,0xa4430103,0x61ee2aeb}},	// [1760] чета_, зите_, ентд, _srbl, 
   {{0x63a42aec,0x2ca02aed,0x6b500172,0x6aa18bbf}},	//   rsin, said_, vägs, nalf, 
   {{0x629c2aee,0x2ca018c3,0x41b615e6,0x63a415c1}},	//   _vero, paid_, ясат, ssin, 
   {{0x63a42aef,0xbcfb00fe,0x629c2af0,0xa9679083}},	//   psin, _théa, _wero, пиха_, 
   {{0x28c11131,0x4abda37d,0x62850170,0xdb0406a4}},	//   ष्टि, ्भाव, bcho, nsië, 
   {{0x657e0889,0x65629e34,0x45d4aaf1,0xa9a62af2}},	//   _kuph, _shoh, докс, _нигд, 
   {{0x3981aaf3,0xc1da800f,0xdb040172,0x7c240123}},	//   _nós_, _बनेग, rriä, lzir, 
   {{0xdce42af4,0x48e38b34,0xb4d6947a,0x7d042af5}},	//   kmič, _посв, ाजे_, njis, 
   {{0xd943869a,0x7c242af6,0x6143aaf7,0xa2bd98fe}},	//   _чети, nzir, _чета, _शाश्, 
   {{0x645c8816,0xdce427f1,0xfbcf80a7,0xef178008}},	//   əril, dmič, اتي_, _ему_, 
   {{0xa2c10562,0x6562aaf8,0x58d90bb9,0x867581e2}},	//   र्ट्, _thoh, одня_, _жыцц, 
   {{0xdb1baaf9,0x78a2852a,0x2d570214,0x62851cb1}},	//   rtuá, naov, rçek_, zcho, 
   {{0x506404c7,0x75ca808a,0xdb1b82fd,0x39400531}},	//   етра, _məzm, stuá, _djis_, 
   {{0x39818013,0x6aa1875d,0xf53f0af6,0x7077004e}},	//   _fós_, calf, _sjå_, _کاغذ, 
   {{0x78a28ae0,0x97579176,0x661400ac,0x9f4400ac}},	//   kaov, פילו_, _čeká, ímá_, 
   {{0xd23b804d,0x7d040210,0xe9450267,0x2a3b8309}},	//   _לגול, gjis, _ترتی, _לעומ, 
   {{0x62852afa,0x2b510265,0x3ce68a63,0x6f010063}},	// [1770] tcho, _pkzc_, _maov_, ölcs, 
   {{0x212daafb,0x501c0309,0x6285149c,0xc35402f0}},	//   _smeh_, _לוחו, ucho, екуј, 
   {{0xceb2096e,0x6285115d,0xcb138273,0x69c8855a}},	//   _ביי_, rcho, עלע_, ntde, 
   {{0xf8bf2afc,0x62852afd,0x7c240c0e,0xb4d6832d}},	//   ngé_, scho, bzir, ाजो_, 
   {{0xdb0d0f61,0x3164811b,0xf8bf0035,0xdee5aafe}},	//   stañ, _dhmz_, liés_, доли, 
   {{0x8ae4036a,0x3ea32aff,0xdb0d02fd,0x644019bf}},	//   _післ, najt_, duaç, _žmig, 
   {{0x31648269,0xa3e5000d,0x6569ab00,0x7777008b}},	//   _fhmz_, पटक_, tmeh, _mixx, 
   {{0xfdf80039,0x7ae72b01,0x78ad0a39,0x3d18868e}},	//   לצות_, _hajt, _ndav, _déwo_, 
   {{0x6aa1ab02,0x6569ab03,0x04778068,0x7ae7007e}},	//   talf, rmeh, _ہلاک_, _kajt, 
   {{0x394f80f3,0x398183b8,0xc9a9819b,0x78ad0232}},	//   logs_, _pós_, овое_, _adav, 
   {{0xd9462b04,0x7ae72b05,0x7d1d2b06,0xa96a2b07}},	//   дени, _majt, _olss, жина_, 
   {{0xcea9004d,0x7ae72b08,0x3981a8b6,0xf8bf0035}},	//   _כי_, _lajt, _vós_, diés_, 
   {{0xd9aa01a2,0x69ce8610,0xbcfb00ef,0xe7f0a23f}},	//   _चट्ट, çber, _phén, चिया_, 
   {{0xdb0980fe,0x69d500fa,0xf8bf0035,0xdce41a46}},	//   breá, _opze, fiés_, rmič, 
   {{0xbb528501,0xdb0d0013,0xc10600fe,0x28c6002a}},	//   _جنوب, graí, _يوتي, _वापि, 
   {{0x2cbf8079,0x2919016c,0x7d0b8063,0x2d53ab09}},	//   ngud_, ërat_, _jogs, mães_, 
   {{0x7bc9ab0a,0x3ce60038,0x63bbab0b,0x7d042b0c}},	// [1780] nteu, ľov_, nuun, rjis, 
   {{0xe8d90147,0xa3cf1b71,0x44630077,0x3ce600e9}},	//   _thể_, _शहर_, твув, žov_, 
   {{0xaacfaa1a,0xa50a2b0d,0x78a280de,0x3ce92070}},	//   त्यक, _дена_, taov, bdav_, 
   {{0xdb0d007f,0x7bc9ab0e,0x3cf9011e,0x693c8033}},	//   stað, kteu, _gnsv_, mček, 
   {{0xd12f840c,0x10a3ab0f,0x98a389c4,0x87da9d1b}},	//   جمن_, тичн, тиче, تباس_, 
   {{0x63bbab10,0x6d448116,0xaacf810e,0x758a87c5}},	//   duun, čiam, त्मक, осив_, 
   {{0x7d0bab11,0x60c4029f,0x98a90269,0x69c8ab12}},	//   _bogs, _ocim, _smač_, xtde, 
   {{0xdb0d0077,0x7ae726af,0x63bbab13,0xfbaa8656}},	//   tuaç, _zajt, fuun, отой_, 
   {{0x7d0b839d,0xaec6ab14,0x7ae701df,0x693c80ac}},	//   _dogs, _обал, _yajt, yčej, 
   {{0x1f63ab15,0x764d8186,0x60c40077,0x59d20624}},	//   _акум, şaya, _acim, _सहार, 
   {{0xe1352b16,0x19592b17,0x69351d65,0xdb042b18}},	//   енны, заны_, енну, friú, 
   {{0x26dcab19,0x7d0b80bf,0x27f22b1a,0xdb040035}},	//   levo_, _gogs, _bryn_, ssiè, 
   {{0x7bc9ab1b,0x78a08a3e,0xf8bf00ef,0x69c8ab1c}},	//   cteu, _memv, rgé_, stde, 
   {{0xdef8005a,0xdb0d2b1d,0x26dc82fb,0xf8bf0429}},	//   мыс_, traí, nevo_, tiés_, 
   {{0xcad78052,0x7ae70019,0x3ea32b1e,0xa4d5109a}},	//   _חוות_, _rajt, rajt_, нові, 
   {{0x7ae72b1f,0xa2ca8d6d,0x78ad0284,0xf8bf00ef}},	//   _sajt, त्र्, _udav, riés_, 
   {{0x29190029,0x24580008,0x7ae72b20,0x60dd0c20}},	// [1790] ūras_, дать_, _pajt, mesm, 
   {{0x60dd2b21,0x26dcab22,0xbcfb2b23,0xc8798123}},	//   lesm, jevo_, _théo, _iaşi_, 
   {{0x7ae72b24,0x26dcab25,0x51840116,0x85750008}},	//   _vajt, devo_, вуча, _плох, 
   {{0x25f4825d,0x60dd2b26,0x256181c2,0x63b62b27}},	//   ्मनी_, nesm, kóla_, bryn, 
   {{0x24b600c6,0xf8bf00ef,0x7ae72b28,0x9f3587c5}},	//   _אהרן_, chée_, _tajt, неді, 
   {{0x2b0003ff,0x2f18819b,0x6283008d,0xe7b2002a}},	//   राणु_, мочь_, žnob, _जिसप, 
   {{0x60dd2b29,0x6aa52b2a,0x62888217,0x9f400097}},	//   kesm, mahf, dcdo, _criù_, 
   {{0x7bc9ab2b,0x656d2b2c,0x63bbab2d,0x3ea12b2e}},	//   tteu, nmah, tuun, _leht_, 
   {{0x2fc901df,0x656d0122,0x68fbab2f,0x6d4280ca}},	//   _nqag_, imah, _inud, _djoa, 
   {{0x291f827e,0x656d2b30,0x26dc8495,0x7bc9ab31}},	//   _hlua_, hmah, cevo_, rteu, 
   {{0x68e99fd8,0xf2d200c6,0x656d0484,0x68fb8bdd}},	//   _kaed, נעט_, kmah, _knud, 
   {{0xaacf024c,0x4acf06df,0x7bc980ef,0x656d0269}},	//   स्तक, स्तव, pteu, jmah, 
   {{0x7c3b2b32,0x395e00f3,0x290d83ec,0x6aa500bf}},	//   _žurn, ēts_, _moea_, kahf, 
   {{0x6d5b8210,0x644600db,0x63a9ab33,0xbcfb047f}},	//   llua, _rxki, msen, _dhém, 
   {{0xceb29af4,0x63a9a3ca,0xf8bf026b,0x523983f3}},	//   טים_, lsen, riér_, _מײַנ, 
   {{0x2edc800d,0x63b62b34,0xfce32b35,0x693c81ac}},	//   _यस्त, tryn, лосо, rček, 
   {{0x6d5bab36,0x63a99af2,0x6b4b0063,0xc2b610f3}},	// [17a0] ilua, nsen, lügy, ељењ, 
   {{0x3ea1035b,0x63a9ab37,0x656d2b38,0x78a61acb}},	//   _geht_, isen, amah, lakv, 
   {{0x64a620ca,0xda0f83ff,0x81cd80b2,0x26dcab39}},	//   _пана, ाहित_, রিক_, vevo_, 
   {{0x92c20a87,0xc7c69c02,0x63a9ab3a,0x4fc6810a}},	//   ্যে_, ески, ksen, еска, 
   {{0xb05b010d,0x26dcab3b,0x98ab0123,0x6d5bab3c}},	//   lfär, tevo_, lică_, dlua, 
   {{0x63a9ab3d,0xde588162,0x290d817c,0x36d4ab3e}},	//   dsen, малі_, _eoea_, токр, 
   {{0xd9109ad1,0xe3570464,0x78a6003b,0x26dcab3f}},	//   _پیش_, _נשלח_, kakv, revo_, 
   {{0xafe696dc,0x628a8269,0x26dc8265,0xd90d8843}},	//   _побл, _sffo, sevo_, _ویل_, 
   {{0xcf469bda,0x6459ab40,0x26dc8495,0x657980bc}},	//   _знай, _cywi, pevo_, _diwh, 
   {{0x21202b41,0x7a0a808a,0xef1981bb,0xb87b0432}},	//   _alih_, bətl, _tuża_, ndív, 
   {{0x22588142,0x6d5bab42,0x63a9ab43,0x673500f8}},	//   ærk_, blua, asen, vizj, 
   {{0x60c2ab44,0x28c60f2c,0x98ab0123,0x2d812b45}},	//   ngom, _वाणि, dică_, _ruhe_, 
   {{0xd7fb2b46,0xac9780d8,0x2d812b47,0x6459811a}},	//   чун_, _أنها_, _suhe_, _gywi, 
   {{0x98ab0123,0xb05b0617,0xb6e42b48,0x60dd2b49}},	//   fică_, ffär, люск, sesm, 
   {{0x2489039d,0xa01b0019,0xaa57ab4a,0xd5672b4b}},	//   tcam_, nböz, _пишу_, етап, 
   {{0x7aeaab4c,0x6d40ab4d,0x81cd80cf,0x92bd00b2}},	//   _haft, nnma, রিখ_, _আসে_, 
   {{0x24892b4e,0x7aeaab4f,0x7ff700d8,0x6d40ab50}},	// [17b0] rcam_, _kaft, _أسعا, inma, 
   {{0x79a70bb3,0xdbc78079,0x24892b51,0xdb0982fd}},	//   ерде, _tööp, scam_, rreç, 
   {{0x6b82809f,0xc3338039,0x291f822a,0x24892b52}},	//   _luog, נוע_, _plua_, pcam_, 
   {{0x75242b53,0x9f5206e4,0x41d201a2,0x7aeaab54}},	//   chiz, _aryè_, _सहरस, _laft, 
   {{0x25718131,0x5eaa80b2,0x3d0489fe,0x672380f8}},	//   _ušli_, চ্ছে, वाने_, thnj, 
   {{0x44292b55,0x6d40ab56,0x141a0309,0x45d59106}},	//   mza_, enma, _חושב, вцит, 
   {{0x7d0f0063,0xb89580d8,0x5a440166,0x66188033}},	//   _kocs, _للأع, _бэта, _čaká, 
   {{0x63a9ab57,0x6723816c,0x44292b58,0x7a0a808a}},	//   tsen, shnj, oza_, rətl, 
   {{0x6d5b9a28,0x777aab59,0x25a08131,0x98ab0123}},	//   rlua, _fitx, ćila_, zică_, 
   {{0x44292b5a,0x765a80f8,0x7aea8c43,0x291901b2}},	//   iza_, _fyty, _caft, êran_, 
   {{0x7aeaab5b,0x3ea7ab5c,0x63a9ab5d,0x7bcd019b}},	//   _daft, mant_, ssen, htau, 
   {{0x3ea797c1,0x63a9873f,0xbcfb0927,0x61f50f4e}},	//   lant_, psen, _dhék, _mrzl, 
   {{0xa3e59470,0x7d099287,0x44292b5e,0x88e300b2}},	//   _पनि_, mjes, jza_, যাংক, 
   {{0x44292b5f,0x3ea7ab60,0x7d09ab61,0x98ab002d}},	//   dza_, nant_, ljes, tică_, 
   {{0x7d0f2b62,0x80d28bb6,0x44292b63,0xed5a2b64}},	//   _bocs, ण्डे, eza_, дов_, 
   {{0x3d0483f0,0x98ab0123,0x7d09ab65,0x44290269}},	//   वाये_, rică_, njes, fza_, 
   {{0x75ca8816,0xed570003,0x2726001c,0x03a604bc}},	// [17c0] _vəzi, тот_, _nông_, тизо, 
   {{0x693cab66,0x3ea7ab67,0x752400bb,0x81bc80f3}},	//   nčev, jant_, shiz, dzēj, 
   {{0x44290012,0x3ea7ab68,0x7d1bab69,0x7d09ab6a}},	//   aza_, dant_, kkus, kjes, 
   {{0xdd94805a,0x6ec4a8b3,0x27260106,0x44292b6b}},	//   ңалы, _राहु, _bông_, bza_, 
   {{0x27260147,0x44290066,0x2ba91461,0x7c29ab6c}},	//   _công_, cza_, _चौपा, jzer, 
   {{0x3ea7ab6d,0xcf9300c6,0xef1980a1,0x27260106}},	//   gant_, סטו_, _dużo_, _dông_, 
   {{0x20008cc1,0x7de6804a,0x3da380a6,0x644e808a}},	//   ţii_, тілд, арыб, əbiy, 
   {{0x7aea8615,0x7d09ab6e,0xaacf910f,0x7d1b9882}},	//   _saft, gjes, त्सक, gkus, 
   {{0x3ea7ab6f,0x6aa3ab70,0x6d408d75,0xafe3ab71}},	//   bant_, _benf, rnma, _котл, 
   {{0x3ea7ab72,0x5186831c,0x2d6e801b,0xd764803d}},	//   cant_, кума, _přes_, _صنای, 
   {{0xc333004d,0x691387fa,0x44292b73,0xaad40c64}},	//   שות_, _içer, zza_, ठ्यक, 
   {{0x78a4137f,0x44292b74,0x3f84ab75,0x7bcd0162}},	//   _ceiv, yza_, _kumu_, ytau, 
   {{0xead496f0,0x99640d29,0x3f8480bf,0x7c298034}},	//   _боль, ртэл, _jumu_, czer, 
   {{0x7bc0ab76,0x07a40325,0x3f8482ee,0x8233804e}},	//   mumu, раён, _mumu_, اریا, 
   {{0x7bc0ab77,0x5faf007a,0x4b7b80c6,0x44292b78}},	//   lumu, _झटकल, _קאוו, wza_, 
   {{0x44292b79,0x7bcd0008,0x3ea79008,0xaac61984}},	//   tza_, ttau, zant_, र्घक, 
   {{0x2d58036d,0x8aa70b9c,0x3ea7ab7a,0x44292b7b}},	// [17d0] тить_, вред, yant_, uza_, 
   {{0xd5a489b9,0x44292b7c,0x8c3d82bc,0x7bcd2b7d}},	//   _وہ_, rza_, daşl, rtau, 
   {{0x3ea7ab7e,0x44292b7f,0x9a84075d,0x8af78816}},	//   vant_, sza_, руул, _şəki, 
   {{0x7bc0ab80,0x442900db,0x21392b81,0x9f4909b2}},	//   kumu, pza_, nish_, _braç_, 
   {{0x7bc0ab82,0x7d099287,0x68ed2b83,0x14d60080}},	//   jumu, vjes, _maad, _גורל_, 
   {{0x68ed2b84,0x657d2b85,0x7bc0ab86,0x63ad2b87}},	//   _laad, _hish, dumu, msan, 
   {{0x3ea7ab88,0x657d2b89,0xed59ab8a,0x41e42b8b}},	//   rant_, _kish, нок_, _кіта, 
   {{0x3ea7ab8c,0x68ed2b8d,0x2ca92b8e,0xa3e99872}},	//   sant_, _naad, naad_, едиа_, 
   {{0x7d09ab8f,0x60c98265,0xbcfb0013,0x3ea790f4}},	//   rjes, _icem, _chéi, pant_, 
   {{0x657d0004,0x63ad2b90,0x78a42b91,0x645d2b92}},	//   _lish, isan, _seiv, _mysi, 
   {{0x68ed00fd,0x7c29811d,0xc6928273,0x7d09ab93}},	//   _baad, szer, _האב_, pjes, 
   {{0x3ea59d5f,0x8c3d8186,0x657d2b94,0xbcfb00fe}},	//   _helt_, laşm, _nish, _fhéi, 
   {{0xb8ec13a7,0x7bc0ab95,0x2ca90c20,0x68ed1185}},	//   _ला_, cumu, daad_, _daad, 
   {{0x63ad0e87,0x248dab96,0x2d85ab97,0xf53981ac}},	//   dsan, lcem_, _kule_, liť_, 
   {{0x27e92b98,0x1dc6a973,0x63bb80f3,0x7ae1ab99}},	//   _esan_, रूपत, lrun, melt, 
   {{0x28d3007a,0x68ed012c,0xaacf86fb,0xf53981ac}},	//   ध्दि, _gaad, त्रक, niť_, 
   {{0x69c1ab9a,0x2d85ab9b,0xb7be80cf,0x63ad2b9c}},	// [17e0] lule, _lule_, _ইন্ট, gsan, 
   {{0x7ae1ab9d,0x2900027e,0x29122b9e,0xb87b0019}},	//   nelt, _hnia_, _hoya_, rdít, 
   {{0x63bb835b,0x2b89810b,0x69c1ab9f,0xe8d90028}},	//   hrun, _lúc_, nule, _nhớ_, 
   {{0x645d23ca,0x657d2ba0,0x29120396,0xd026804a}},	//   _fysi, _gish, _joya_, лмей, 
   {{0x69c1aba1,0xe73a82d4,0xf53981ac,0x7ae1aba2}},	//   hule, нед_, diť_, kelt, 
   {{0x6d441d3f,0x6d59aba3,0x69c1aba4,0x6d560004}},	//   lnia, _akwa, kule, loya, 
   {{0x63bb82ae,0x25a0829f,0x657d2ba5,0x7ae1aba6}},	//   erun, ćilo_, _yish, delt, 
   {{0x69c1aba7,0x2d85aba8,0x6d442ba9,0x39ae8116}},	//   dule, _dule_, nnia, vęs_, 
   {{0x68ed2baa,0x63bb8aa1,0xd90d8068,0x6d442bab}},	//   _raad, grun, _تین_, inia, 
   {{0x68ed2bac,0x7bc0abad,0x29002bae,0x7c3b2baf}},	//   _saad, rumu, _ania_, _žurk, 
   {{0x69c1abb0,0xdd8f807b,0x2d85abb1,0x7bc0abb2}},	//   gule, _فول_, _gule_, sumu, 
   {{0x6d44006c,0x7bc0abb3,0x63ad2bb4,0x92e000b2}},	//   jnia, pumu, ysan, থায়_, 
   {{0x9cd78052,0x68ed0a2f,0x657d2bb5,0x290000a1}},	//   _תודה_, _vaad, _rish, _dnia_, 
   {{0x69dc2bb6,0x2d858010,0x6d448116,0x7aee022a}},	//   _opre, _yule_, čiau, _nabt, 
   {{0x69c1abb7,0x657d2bb8,0x693cabb9,0x645d2bba}},	//   cule, _pish, nčes, _sysi, 
   {{0x63ad2bbb,0x6d562bbc,0x657d0004,0x34952bbd}},	//   tsan, goya, _qish, раар, 
   {{0x2ca92a18,0x27e91f1c,0x2b89801c,0x9f400149}},	// [17f0] raad_, _usan_, _xúc_, _crió_, 
   {{0x61f88533,0xf5398038,0x29122bbe,0x6b5d8741}},	//   _krvl, ziť_, _zoya_, tègi, 
   {{0x6d442bbf,0x645d2bc0,0x7aee01c8,0x657d2bc1}},	//   bnia, _wysi, _dabt, _tish, 
   {{0x417480fe,0x2ba915ad,0x57f5abc2,0x645d0034}},	//   مانس, _चौथा, ипет, _tysi, 
   {{0xf5398038,0x69c1abc3,0x2d85abc4,0x636b0646}},	//   viť_, zule, _sule_, tünd, 
   {{0x7d0d2bc5,0xc5f980cf,0x2d85abc6,0xbcfb17e5}},	//   ljas, _অথবা_, _pule_, _chév, 
   {{0xf53981ac,0x28c603ff,0x2ba9000d,0x7c2d2bc7}},	//   tiť_, _वालि, _चौता, lzar, 
   {{0x3ea582ae,0xdb042bc8,0xa3b9010c,0xa3e923c2}},	//   _welt_, brió, _घटा_, _मना_, 
   {{0x7c2d2bc9,0xdcfa8029,0x7ae1abca,0xf53981ac}},	//   nzar, _attē, telt, riť_, 
   {{0x69c1abcb,0xadf7120a,0x63bbabcc,0x29120232}},	//   tule, ुमान_, rrun, _soya_, 
   {{0x8e848013,0x6d440324,0xf53981ac,0xa2ca06ee}},	//   _المه, ynia, piť_, स्ट्, 
   {{0x69c1a186,0x63bbabcd,0x6d59abce,0x7ae1abcf}},	//   rule, prun, _ukwa, selt, 
   {{0x53a5abd0,0xe28eabd1,0x6d442bd2,0x6d4481ac}},	//   _талб, _ма_, vnia, čiat, 
   {{0x69c1abd3,0x9a8783ad,0xf77226f1,0x38692bd4}},	//   pule, _судл, تاج_, _dzar_, 
   {{0xada61b78,0xe8d90028,0x7aee01bb,0x29122bd5}},	//   рабл, _giữ_, _rabt, _toya_, 
   {{0x7aee18c5,0xef86168e,0x06af80b2,0x778615eb}},	//   _sabt, _клип, চ্চি, _клиз, 
  
   {{0x69dc2bd6,0x2d982bd7,0x6d442bd8,0xafe6124a}},	// [1800] _spre, spre_, rnia, _топл, 
   {{0x6aa70269,0x256181c2,0x442dabd9,0x69dc2bda}},	//   _cejf, fólk_, ize_, _ppre, 
   {{0x09e60e79,0xfc3f01ce,0x7d0d0269,0x8886abdb}},	//   роен, _veía_, bjas, алеж, 
   {{0x316d83e9,0x442d8858,0xdb04195a,0x2900a505}},	//   _chez_, kze_, trió, ñia_, 
   {{0x7aee2bdc,0x442dabdd,0xe8d9001c,0x3d04902c}},	//   _tabt, jze_, _nhờ_, वासे_, 
   {{0x442dabde,0x6b8480fe,0x5804804a,0xe2970a80}},	//   dze_, _éigi, _қозғ, _вар_, 
   {{0xe1e78067,0x32070008,0x69dc00e9,0x61360183}},	//   _بس_, änyt_, _upre, ršlj, 
   {{0x7c3b029f,0x6283abdf,0xa96a86c5,0x387f0183}},	//   _žuri, _agno, _риба_, žuri_, 
   {{0x673c01c4,0x394682ba,0xe8d90028,0xeb06abe0}},	//   kirj, mnos_, _chờ_, ачно, 
   {{0x3d0483ca,0xdb04011e,0x7dfc8166,0x661c12b4}},	//   वाहे_, oriñ, _păsă, kyrk, 
   {{0x7980abe1,0xdb098728,0x442d8399,0x7c2d0cff}},	//   _kimw, gueñ, aze_, zzar, 
   {{0x7529abe2,0x3946abe3,0x63a2abe4,0x6d44abe5}},	//   chez, nnos_, _twon, čias, 
   {{0x442d8d99,0x7d02abe6,0x63a2abe7,0x50670940}},	//   cze_, _inos, _uwon, ртна, 
   {{0xdced026b,0xa2c2000d,0x7bdb83dd,0x3d04abe8}},	//   rmač, _लाग्, _סקוו, वावे_, 
   {{0xdb00abe9,0xfd880014,0xa6978039,0xeca70223}},	//   gsmå, иёти_, שכלה_, ијан, 
   {{0x7c2d2bea,0xdb0401e0,0x80c1009b,0x39468019}},	//   tzar, driñ, _वाटे, jnos_, 
   {{0x29e8002d,0x39592beb,0x7bc42bec,0x67da81a8}},	// [1810] _aşa_, moss_, guiu, nājā, 
   {{0x7d0d2bed,0x3946abee,0xa91d80ca,0xf8ef83ca}},	//   sjas, enos_, _miže, _घोड़ा_, 
   {{0x442dabef,0x6ecd8c2e,0x7c2d2bf0,0x798080bb}},	//   zze_, _साबु, szar, _bimw, 
   {{0x3946abf1,0xe45f019b,0x7d0280bc,0x442dabf2}},	//   gnos_, _työ_, _nnos, yze_, 
   {{0x6126007f,0xa91d85c3,0x6d5d149b,0x693c8a63}},	//   _jóla, _niže, _iksa, tčer, 
   {{0x66e58f70,0x3946a0c5,0xc69500c6,0x7d0281cb}},	//   сока, anos_, זאַ_, _anos, 
   {{0x7ae52bf3,0x7afa01c2,0xa3a9abf4,0x753b82d7}},	//   meht, _ótta, गीन_, tiuz, 
   {{0x442dabf5,0x4c698036,0x7ae50912,0x69c52bf6}},	//   tze_, лийн_, leht, muhe, 
   {{0x850880b6,0x3d08007a,0xc9528c2d,0x442dabf7}},	//   рдың_, हाते_, _זמן_, uze_, 
   {{0x442d8b45,0x7d028bfc,0x78a9abf8,0xb87b2bf9}},	//   rze_, _enos, _heev, teín, 
   {{0x442dabfa,0x5d8580fe,0x673c007e,0x6d4480e9}},	//   sze_, _الصل, virj, čiar, 
   {{0x61262bfb,0x2d6802ae,0xe8d90106,0x7ae5016c}},	//   _bóla, eßen_, _thờ_, heht, 
   {{0xdb0981ce,0xed59807e,0x249f8da7,0x27261659}},	//   sueñ, mož_, mbum_, _aôna_, 
   {{0x6d5d2bfc,0x61261a93,0x539a8052,0x249fabfd}},	//   _aksa, _dóla, _עיצו, lbum_, 
   {{0xdb098c5e,0xd6272154,0x6370135d,0xe164003d}},	//   queñ, боре_, läng, _وضعی, 
   {{0x6ab79108,0x2ba9000f,0x4c861ea1,0x8a168039}},	//   _आयुर, _चौहा, слав, _לחצו_, 
   {{0xd6c30019,0x798080bb,0x673c007e,0x636202fd}},	// [1820] _کمپی, _rimw, pirj, lôni, 
   {{0xadf98611,0x6ac600fe,0x6d5d2bfe,0xdb0424ce}},	//   ्मान_, إقام, _eksa, isiç, 
   {{0x69c502a5,0x63702bff,0x1efb00c6,0x27ed86e4}},	//   guhe, häng, _עלטע, _asen_, 
   {{0xa2d80562,0x1d0a2c00,0xdb042c01,0x984a9023}},	//   _नॉर्, _семи_, rriñ, ляла_, 
   {{0x3946a88d,0xaab80267,0x33b51747,0x7bc42c02}},	//   rnos_, _نگار_, _мёрт, quiu, 
   {{0x7d028d69,0x26ca2c03,0x65642c04,0x3946a8e8}},	//   _snos, ngbo_, llih, snos_, 
   {{0x3d04800c,0xe7af00a1,0x2d82004f,0xe8d9012f}},	//   वाले_, _जौनप, _kike_, _nhở_, 
   {{0x77868008,0x71268275,0xf8b0803d,0x5bb8ac05}},	//   _глаз, _ارسل, _آکا_, алия_, 
   {{0x63702c06,0x602689b2,0x7d02807e,0xa3cb0758}},	//   gäng, _удаа, _vnos, रूप_, 
   {{0x2d822c07,0xaaa80379,0x636203b8,0x7b398170}},	//   _like_, गरिक, fôni, lňuj, 
   {{0xd5b9836a,0xdee3ac08,0xfbcf8267,0x712700fe}},	//   _всі_, _хохи, وتی_, مرحل, 
   {{0x59c92c09,0xa2d80023,0x7d028024,0x63701cc7}},	//   ांतर, न्त्, _unos, länd, 
   {{0xa2d3a8b5,0x39592c0a,0x26d82c0b,0xc7b81164}},	//   _बॉक्, ross_, ffro_, йёр_, 
   {{0x4374807b,0x6e942c0c,0x4ac700da,0xe5c706f1}},	//   _بهتر, зиру, _लाइव, йсбо, 
   {{0xa3cb09fe,0xd047008a,0x2d822c0d,0xe1898106}},	//   रंभ_, _əməl, _bike_, _hẳn_, 
   {{0x3eae835b,0x6370135d,0x6aaaa1ee,0x95c9004a}},	//   haft_, händ, _heff, луға_, 
   {{0x2d820aaf,0x78a9ac0e,0x06e400b2,0xe509802a}},	// [1830] _dike_, _reev, মাজি, वाति_, 
   {{0x9a8706f1,0x69c52c0f,0xbcfb2c10,0x2d820da7}},	//   суал, tuhe, _chér, _eike_, 
   {{0x3cfe807a,0x78a9822a,0xa3a90a29,0x2ba9010c}},	//   _शोभे_, _peev, _गौर_, _चौरा, 
   {{0x69c52c11,0x69c080da,0x5c070be6,0x6aaa819b}},	//   ruhe, _विनी, _ляга, _leff, 
   {{0xf77191db,0xd009ac12,0x63620432,0x6b9b9127}},	//   وات_, реле_, zôni, xpug, 
   {{0xa2d80bf5,0x43942c13,0x6aaaac14,0xd5dd002a}},	//   न्द्, _харс, _neff, _पहाड़, 
   {{0x171c0273,0x9f448149,0x78a9ac15,0xf592ac16}},	//   רווע, _armó_, _teev, ولوج, 
   {{0x58d4876c,0xe3b9ac17,0x60db829a,0x63700172}},	//   _ност, аби_, _ubum, täng, 
   {{0x9817807b,0x63a901b2,0x798a81ed,0x395f8109}},	//   _ابزا, _çend, _aufw, _ikus_, 
   {{0x637008af,0x21292c18,0xdb160008,0x636202fd}},	//   räng, _alah_, styö, tôni, 
   {{0x7a69ac19,0x9f4901ed,0x752d0889,0x63702c1a}},	//   ринг_, _spaß_, khaz, säng, 
   {{0x628300e9,0x63700617,0x63622c1b,0x2ee780bc}},	//   ľnoh, mäne, rôni, lenf_, 
   {{0xeaaea0eb,0x6d49ac1c,0xbf87801c,0x2d822c1d}},	//   _ой_, mnea, _điển_, _rike_, 
   {{0xe299ac1e,0x1ddd80da,0x321eac1f,0xd5b800f3}},	//   _так_, _महात, byty_, šām_, 
   {{0x6b83ac20,0x395fac21,0x6d49ac22,0xad3a07c5}},	//   _iing, _okus_, onea, ачає_, 
   {{0x6d49ac23,0x6b83ac24,0x39b580f3,0x4d66109a}},	//   nnea, _hing, mās_, ікав, 
   {{0x656402c7,0x6f172c25,0x6d49806b,0x39b58029}},	// [1840] rlih, _foxc, inea, lās_, 
   {{0x6b83ac26,0x6b8bac27,0x6d498089,0xf7720a57}},	//   _jing, _mugg, hnea, _تاب_, 
   {{0x637019e7,0x39b5834a,0x6b83ac28,0xe29701bc}},	//   vänd, nās_, _ming, цах_, 
   {{0x6b83ac29,0x752d2c2a,0x69c18336,0x80668086}},	//   _ling, chaz, irle, овеж, 
   {{0x63702bff,0x394d8269,0xbcfb0035,0x69c181ed}},	//   tänd, _djes_, _thér, hrle, 
   {{0x6b83ac2b,0xd5baac2c,0x39b58029,0x44320027}},	//   _ning, аси_, kās_, mzy_, 
   {{0x39b5834a,0x63702c2d,0x44200019,0xeea9804a}},	//   jās_, ränd, lyi_, стік_, 
   {{0x6d499625,0x63700172,0x6b83ac2e,0x39b580f3}},	//   gnea, sänd, _aing, dās_, 
   {{0x44202c2f,0x6b83ac30,0x25a9805d,0x73fa80b2}},	//   nyi_, _bing, ćala_, েন্ট_, 
   {{0x6b8382ef,0x37d000b2,0x212913fd,0xa3cb1461}},	//   _cing, িবার, _slah_, रंत_, 
   {{0x39b580f3,0xaacf0492,0x9258ac31,0x28f91c4a}},	//   gās_, स्टक, сант_, бень_, 
   {{0x394d0003,0x6b83ac32,0xe8d90028,0x6b8bac33}},	//   ões_, _eing, _phố_, _fugg, 
   {{0xb97b8130,0x798403df,0x21290269,0x4420029a}},	//   ינטי, _diiw, _vlah_, jyi_, 
   {{0x7d060116,0x443200a1,0x39b581a8,0xa49b055a}},	//   _anks, dzy_, bās_, _enòl, 
   {{0x752d02d9,0x21290160,0xdef801e2,0x39b580f3}},	//   thaz, _tlah_, цыя_, cās_, 
   {{0x6d40ac34,0x6b83ac35,0x2129022c,0x4add0a64}},	//   nima, _zing, _ulah_, न्नव, 
   {{0x2d8c8131,0x44200019,0x6126011e,0x6b83ac36}},	// [1850] _lude_, gyi_, _móll, _ying, 
   {{0x6d40ac37,0x2d8c8a44,0x74150019,0x6b838da7}},	//   hima, _oude_, _ہوجا, _xing, 
   {{0x6d40ac38,0x7c208324,0x752d02d9,0x44322c39}},	//   kima, hymr, phaz, azy_, 
   {{0x6d40ac3a,0xdb098013,0x7c20872c,0x442000bb}},	//   jima, iseá, kymr, byi_, 
   {{0x44320066,0x6d40ac3b,0x3d08000f,0x2d8cac3c}},	//   czy_, dima, हारे_, _aude_, 
   {{0x2d8cac3d,0x78ad2c3e,0x68fa00f3,0x3eba00f6}},	//   _bude_, _leav, ētdi, _xdpt_, 
   {{0x6d40ac3f,0x69c8ac40,0x6b8b91c3,0x6d498d0d}},	//   fima, jude, _sugg, tnea, 
   {{0x395f8024,0x39b580f3,0x6d40ac41,0x61260065}},	//   _ukus_, vās_, gima, _cóll, 
   {{0x3eac806d,0x7f5c0217,0xb4e91e57,0x61262c42}},	//   _fedt_, yorq, _यसै_, _sólo, 
   {{0x39b58029,0x6b83ac43,0x6d498c94,0xfbd204fc}},	//   tās_, _qing, snea, עתי_, 
   {{0x644d81e2,0x6b83ac44,0xc4cb00a1,0x44322c45}},	//   _žaid, _ving, िलाओ, zzy_, 
   {{0x70c6009b,0xdce99527,0x644302a5,0x39b580f3}},	//   वलेल, dmeć, şniy, rās_, 
   {{0x3f85ac46,0x39b581a8,0x3f8d89b2,0x7f5c0702}},	//   _kilu_, sās_, _jueu_, torq, 
   {{0x2d96123d,0x69c88f78,0x6b838010,0xe7e385b7}},	//   зрас, bude, _uing, _गहना_, 
   {{0x80ab0a87,0xe7372c47,0x78bb805d,0x3f858385}},	//   _কার্, чер_, _oduv, _milu_, 
   {{0x80da00b2,0x3f858519,0x44322c48,0x78ad01f0}},	//   _বোর্, _lilu_, tzy_, _geav, 
   {{0x75242c49,0xc1db80da,0x3b182c4a,0x7af50109}},	// [1860] rkiz, _बहुग, _porq_, _bazt, 
   {{0x44322430,0x68f62c4b,0x39422c4c,0x44202c4d}},	//   rzy_, _hayd, liks_, ryi_, 
   {{0x2730810b,0xe9da2c4e,0x44320066,0x68f60214}},	//   _hàng_, ске_, szy_, _kayd, 
   {{0x3f8d81e0,0xd910804e,0x39422c4f,0x68f62c50}},	//   _bueu_, خیر_, niks_, _jayd, 
   {{0x6d40ac51,0x68f60103,0xa3cb0439,0x78a2ac52}},	//   vima, _mayd, रूद_, rbov, 
   {{0x7af500b4,0x2d8cac53,0x27308106,0x3f85811b}},	//   _gazt, _pude_, _màng_, _cilu_, 
   {{0x91e32c54,0x6d40ac55,0x09e30837,0x7d19839d}},	//   _поре, tima, _порн, _bows, 
   {{0x5398ac56,0xdb98ac57,0x69c8809a,0xa2aa1352}},	//   овия_, ович_, vude, टरव्, 
   {{0x27308028,0x7bc9ac58,0x63b60072,0x7ae89c41}},	//   _nàng_, gueu, nsyn, tedt, 
   {{0x59d00066,0x6d40ac59,0xaacc2c5a,0x798e29fd}},	//   _हमार, sima, ालिक, _kubw, 
   {{0xc4869966,0x6d40ac5b,0x78ad0079,0x68f609c7}},	//   _елек, pima, _peav, _bayd, 
   {{0x6f1aaa00,0xa91d80ca,0x2730812f,0x394202f4}},	//   _hotc, _ližn, _bàng_, giks_, 
   {{0xc05b2c5c,0xb4e88079,0x27308028,0x69c8ac5d}},	//   сін_, मजी_, _càng_, sude, 
   {{0x2730801c,0x7bc40162,0xdb098149,0x69c8ac5e}},	//   _dàng_, driu, breñ, pude, 
   {{0x68f603d2,0xa4d50bb4,0x78ad2c5f,0x7bc40079}},	//   _fayd, мові, _teav, eriu, 
   {{0x6f1a82b9,0x7bc40036,0x5ec585a2,0x8d740609}},	//   _lotc, friu, ল্পে, فاقا, 
   {{0x6c542c60,0xdcfa8029,0xc1580052,0x31ae80b2}},	// [1870] екту, _attī, _משהו_, _কমিশ, 
   {{0x798e0640,0xfaf88e1b,0x60dd2c61,0x6f1aac62}},	//   _bubw, ndī_, lfsm, _notc, 
   {{0x79a41c71,0xa3b929c0,0xa2cfac63,0x69c80764}},	//   ерче, _घटक_, _दास्, _ådel, 
   {{0x3f85850d,0x81df05a2,0xba742c64,0x65628191}},	//   _silu_, তিল_, رالت, _nkoh, 
   {{0xe0d08f94,0x7bc400a6,0x7d19ac65,0x6d4d02f4}},	//   ازم_, criu, _rows, mnaa, 
   {{0xdb1b8569,0x6d5f2c66,0x05b1009b,0x6562ac67}},	//   truí, loqa, _जबाब, _akoh, 
   {{0x7d1980a1,0x25a9829f,0x6d4d1998,0xc5d58994}},	//   _pows, ćalo_, onaa, філь, 
   {{0x6d4d2c68,0x27ff8269,0xe8d9001c,0xa3e10076}},	//   nnaa, _trun_, _khổ_, _दहा_, 
   {{0x47d58013,0x3f85822c,0x68eb90f1,0x27ffac69}},	//   _زيار, _tilu_, megd, _urun_, 
   {{0x81c200cf,0x290927d1,0x80d9800c,0x27308106}},	//   ্বর_, _anaa_, फ्रे, _ràng_, 
   {{0x13e600cf,0x39422c6a,0x68f62c6b,0x1dc68439}},	//   নিয়, tiks_, _payd, रूआत, 
   {{0xd7d1ac6c,0x68f62c6d,0x254580f3,0xe7d181a2}},	//   _समाच, _qayd, tēlu_, _समाप, 
   {{0x6d4d2c6e,0x636b0a08,0x39422c6f,0x69c501ed}},	//   dnaa, tünl, riks_, hrhe, 
   {{0x6569ac70,0x27308028,0x6b658103,0x6d4d2c71}},	//   lleh, _vàng_, _юкла, enaa, 
   {{0x212d8271,0x8e5500b6,0x4ac700da,0xa91d8c0e}},	//   _oleh_, етті, _लाजव, _nižo, 
   {{0x6d4d2c72,0x27308106,0xadf08079,0x1d072c73}},	//   gnaa, _tàng_, _अईसन_, меси_, 
   {{0xd46706a1,0x63ad81b2,0x04432257,0x3b862c74}},	// [1880] дите_, _çand, ветн, длаг, 
   {{0x63b6072c,0x212d811e,0x6d4d2c75,0xdcfd00f3}},	//   rsyn, _aleh_, anaa, _visā, 
   {{0x212d83bf,0x2eaa009b,0xfe7200d8,0x63b62c76}},	//   _bleh_, करीत, _جدة_, ssyn, 
   {{0xeb9f072c,0x7bc40179,0x2d5701bb,0x53a90076}},	//   _brød_, priu, għed_, _चौकश, 
   {{0x69c503c5,0x6f1aac77,0x9f49055a,0x6d4424b4}},	//   arhe, _potc, _graó_, miia, 
   {{0xdd9aac78,0x9e068ced,0x212d8120,0x2d86811a}},	//   оши_, дчил, _eleh_, _sioe_, 
   {{0x66e00079,0xdce40170,0x80cf001b,0xa3b0ac79}},	//   ख्यक_, hlič, _थाले, टीन_, 
   {{0x6ba50172,0xdce4007e,0x6d440269,0x9bf4ac7a}},	//   _åtgä, klič, niia, езич, 
   {{0xf8639525,0x7c242c7b,0xd8d78273,0xa3a98076}},	//   _авто, nyir, _קומט_, गील_, 
   {{0x6126012b,0x39402c7c,0x7f4381e9,0xdce40170}},	//   _fólk, _amis_, cinq, dlič, 
   {{0x8e4a80fe,0x6569839d,0xa2cf8d4a,0x7c2400bb}},	//   _بلاك_, bleh, _दार्, hyir, 
   {{0xf3888028,0x212d80f6,0x291b0129,0x0c268aad}},	//   _lợi_, _xleh_, _qoqa_, _омен, 
   {{0x1bf289d7,0xdce4026b,0x60dd007f,0x28d1a208}},	//   _अनिल_, glič, rfsm, _हासि, 
   {{0xf53f1120,0x399383b8,0x442480a1,0x636f872c}},	//   _små_, _fãs_, mym_, lønn, 
   {{0x1df8125e,0x4424ac7d,0x6d4d2c7e,0x200d0123}},	//   меры_, lym_, tnaa, ţei_, 
   {{0xdce42c7f,0x7af8ac80,0x6d4d022c,0xa91d89bb}},	//   blič, _havt, unaa, _rižo, 
   {{0x4424ac81,0x6d4d0161,0x4ea72c82,0x7af881df}},	// [1890] nym_, rnaa, _орна, _kavt, 
   {{0xdb1606e0,0x2fc6ac83,0x656080d8,0x2d9e806d}},	//   nsyè, drog_, homh, _otte_, 
   {{0x69da8008,0x212d81f7,0x69cf8034,0x29d896d1}},	//   ntte, _pleh_, ąceg, néa_, 
   {{0x69da836d,0x3cfe80da,0x636f80f0,0x7c2400bb}},	//   itte, _शोले_, jønn, byir, 
   {{0x7feb87db,0x93270bb7,0x637008c5,0x68ebac84}},	//   تراف_, _قرآن, männ, regd, 
   {{0x44248324,0x7d1d0019,0x7af8ac85,0x7df3808a}},	//   dym_, _hoss, _navt, _həsə, 
   {{0x656983ec,0x628301ac,0xf388801c,0x212d83d0}},	//   tleh, ľnos, _gợi_, _tleh_, 
   {{0x628310d4,0x2fc6805d,0x7d1d036d,0x98a01527}},	//   žnos, brog_, _joss, _ilić_, 
   {{0x7d1d2c86,0x7df38816,0x2d9e8073,0x3d048562}},	//   _moss, _məsə, _ette_, वाजे_, 
   {{0x8c9f80da,0x3f9f80db,0x7af8811b,0x6569ac87}},	//   _ग्रो, _ituu_, _cavt, sleh, 
   {{0xa96a0ff8,0xcb1204fc,0x63702c88,0x216a2c89}},	//   зина_, אלי_, känn, зини_, 
   {{0x7d1d0003,0xfe6e803d,0xdce4007e,0x4424ac8a}},	//   _noss, _اگه_, tlič, bym_, 
   {{0xb4278604,0x442480a1,0x7d0b81db,0xdce40284}},	//   _تعاو, cym_, _ings, ulič, 
   {{0xdb1b8e74,0x75298019,0x798981b0,0x8c1a825e}},	//   bruá, lkez, _liew, _מוני, 
   {{0x7bdbac8b,0xdd920275,0x3d04809b,0x61462c8c}},	//   ltuu, اور_, वाचे_, _пека, 
   {{0x798980a1,0x7d1d2c8d,0xdce413aa,0x5ec105a2}},	//   _niew, _coss, plič, শ্লে, 
   {{0x7d1d2c8e,0x98a00f64,0x7bdbac8f,0x68e42c90}},	// [18a0] _doss, _alić_, ntuu, _ibid, 
   {{0x7d0b897e,0xbfa2024a,0x3ced822a,0x272b8764}},	//   _lngs, _şêwa, heev_, _sønn_, 
   {{0x7d1d0c6a,0x3cfb1855,0x3f920010,0xe8d9001c}},	//   _foss, _लोके_, _huyu_, _chỗ_, 
   {{0x69c3060e,0x7bdbac91,0x2fc68305,0x59d20a8b}},	//   ánea, ktuu, trog_, दंबर, 
   {{0x7f46ac92,0xd43600fe,0xe73f02fd,0x68e42c93}},	//   недж, _أعجب, spõe_, _mbid, 
   {{0x69daac94,0xa8478b95,0x57f390f3,0x44248507}},	//   ytte, علوم_, упшт, vym_, 
   {{0x44248066,0x68e42c95,0x61262c96,0x628e0128}},	//   wym_, _obid, _eóli, _igbo, 
   {{0x612603c3,0x98a92c97,0x4424ac98,0x2fc6ac99}},	//   _fóli, _plač_, tym_, prog_, 
   {{0x3946ac9a,0x2734010d,0x63a42c9b,0x849780fe}},	//   mios_, _känd_, npin, رئيس_, 
   {{0x656086de,0x68e42c9c,0x394680ce,0x3075ac9d}},	//   somh, _abid, lios_, _русс, 
   {{0xc3331eef,0x2bc292c2,0xfbc2ac9e,0x38691a28}},	//   רות_, _शिवा, _शिवम, _syar_, 
   {{0x3946ac9f,0x69daaca0,0x98a900e9,0x6374875d}},	//   nios_, rtte, _tlač_, fànc, 
   {{0x7d1d2ca1,0x629c00f8,0x5f9411f2,0x7bdb80fa}},	//   _ross, _ofro, лият, ctuu, 
   {{0x656600db,0x999e8019,0x254c81d2,0x539b83dd}},	//   _akkh, sztő_, děli_, _ציוו, 
   {{0x7d1d2ca2,0x39468116,0xdd95024f,0x7d0baca3}},	//   _poss, kios_, табы, _yngs, 
   {{0x9d1819dc,0x59c5800c,0xc4cb06d7,0x7df382d1}},	//   ност_, _वितर, िलेख, _qəsə, 
   {{0x39469a5a,0xf2c709d4,0xeb930313,0xdb0d03b8}},	// [18b0] dios_, есен, اظر_, nsaç, 
   {{0x69c882da,0xdb0d2a62,0x7989aca4,0xd011804e}},	//   orde, trañ, _siew, یلا_, 
   {{0xa2d88baf,0x2004aca5,0xa7fd8019,0x2734010d}},	//   _मान्, _armi_, _gyűj, _säng_, 
   {{0x68fd2ca6,0x3946aca7,0x69c8865e,0x27e902fa}},	//   ndsd, gios_, irde, _kpan_, 
   {{0x79898052,0x656d0a7e,0x2ca92ca8,0x69c8aca9}},	//   _view, mlah, mbad_, hrde, 
   {{0x2d8b05a2,0x2ca90bed,0x6d58024a,0x3669a1d0}},	//   _hice_, lbad_, _êvar, мало_, 
   {{0x75298068,0x8d55acaa,0xed59a9f0,0x7d0b8269}},	//   tkez, ктич, мок_, _pngs, 
   {{0x39469151,0x7bdb819b,0x68fd2cab,0x2ca92cac}},	//   cios_, ttuu, jdsd, nbad_, 
   {{0x80a2287f,0x7529acad,0x69c880d0,0x2d932cae}},	//   _क्षे, rkez, erde, _luxe_, 
   {{0x2d8b003a,0x7bdbacaf,0x3eb30052,0x69ca03b8}},	//   _lice_, rtuu, _next_, áfeg, 
   {{0x7bdbacb0,0x81df00cf,0x68fbacb1,0x27e92cb2}},	//   stuu, তিক_, _kaud, _apan_, 
   {{0x2eaa0f21,0x63748741,0x3f9200f6,0x26c1013b}},	//   कर्त, tànc, _puyu_, _adho_, 
   {{0x69c89752,0x656d026b,0x20042cb3,0x68fbacb4}},	//   arde, dlah, ími_, _maud, 
   {{0x2d8b0089,0x27e900e5,0xf1d18188,0x80a2071c}},	//   _aice_, _dpan_, _көмө, _क्रे, 
   {{0xa3d40365,0x63bd018a,0x2d8b2cb5,0x16590f4c}},	//   सून_, _avsn, _bice_, ерть_, 
   {{0x2be59640,0x291f802d,0x68fbacb6,0x394684e0}},	//   _कहां_, _noua_, _naud, xios_, 
   {{0x3cf4a23f,0x63bbacb7,0xb87b2cb8,0x3946a71d}},	// [18c0] ्यते_, nsun, rfíc, vios_, 
   {{0x63a42cb9,0x6f1e02cf,0x5fb70039,0x81e480b2}},	//   rpin, _uopc, _שהיא_, নির_, 
   {{0x39468530,0x63a42cba,0x68fbacbb,0x2ca92cbc}},	//   tios_, spin, _baud, bbad_, 
   {{0x3eb81ce9,0x63a42cbd,0xd5b80029,0xc7c69e98}},	//   lart_, ppin, šās_, вски, 
   {{0x3946acbe,0x68fbacbf,0x291f8012,0x2d802cc0}},	//   rios_, _daud, _doua_, mmie_, 
   {{0x394681e2,0x63bbacc1,0xfaa313d1,0x2d8b0123}},	//   sios_, dsun, _варо, _zice_, 
   {{0xdef8805a,0x3946a091,0x41aa08cf,0x68fb80ef}},	//   дық_, pios_, _іван_, _faud, 
   {{0x7afc2cc2,0x29dc0422,0x68fbacc3,0x3eb80048}},	//   _hart, mía_, _gaud, hart_, 
   {{0x29dc2a62,0x63bbacc4,0x06b800b2,0x3eb82cc5}},	//   lía_, gsun, _জানি, kart_, 
   {{0x68fbacc6,0x5b148974,0x7afc0109,0x7763811e}},	//   _zaud, умот, _jart, conx, 
   {{0x27e901b0,0x29dc0422,0x69c880d0,0x7c3a0816}},	//   _span_, nía_, urde, _ətra, 
   {{0x7afc0210,0x64a6a8ab,0xf8bf0019,0x7bc9acc7}},	//   _lart, _рада, mkék_, breu, 
   {{0xb8eb007a,0xdb040422,0xb4ae9628,0x29dc2cc8}},	//   _लय_, nsió, करी_, hía_, 
   {{0x0ccb0bc3,0xcf9380c6,0x63a2acc9,0x3eb82cca}},	//   िल्म, יטש_, _iton, gart_, 
   {{0x80d3800f,0x29dc01ce,0xb8d905a2,0xb87b011e}},	//   _डाले, jía_, _চা_, teís, 
   {{0x29dc02ba,0xa3e6809b,0xdb1b8077,0x7afc2ccb}},	//   día_, _पहा_, truç, _aart, 
   {{0x3eb32ccc,0x3eb80523,0x656d0058,0x25a98024}},	// [18d0] _text_, bart_, rlah, ćali_, 
   {{0x29dc0422,0x7afc2ccd,0xe4e281c7,0x656d2cce}},	//   fía_, _cart, क्ति_, slah, 
   {{0x29dc0c5e,0x2d8b0025,0x61262ccf,0x68e2843a}},	//   gía_, _tice_, _vólv, ffod, 
   {{0x63a2acd0,0x59c598fe,0x7afc2cd1,0x23c28258}},	//   _oton, _विसर, _eart, _शिंद, 
   {{0xb8db8439,0x69dc2cd2,0x3f8c81bb,0x63a2acd3}},	//   _आज_, _eqre, _bidu_, _nton, 
   {{0x7afc2cd4,0x29dc0422,0x44290fb4,0x543a00c6}},	//   _gart, bía_, mya_, _טערא, 
   {{0x29dc0422,0x63a2acd5,0x3a840116,0x74d78034}},	//   cía_, _aton, _вытв, _यादृ, 
   {{0x63bbacd6,0x7bc9acd7,0x16b0010c,0x7afc2cd8}},	//   tsun, treu, _जज्ब, _zart, 
   {{0xa855acd9,0xbab581bc,0x7bc9acda,0x0ed300da}},	//   _скач, лёны, ureu, _तांड, 
   {{0x63bbacdb,0x89a99c36,0x386dacdc,0x7bc9acdd}},	//   rsun, нков_, _iyer_, rreu, 
   {{0x63bbacde,0x44292cdf,0x3eb82ce0,0xf9860e1c}},	//   ssun, hya_, vart_, лгоо, 
   {{0x7fd62ce1,0x7bc9802d,0x44292ce2,0x8fa62ce3}},	//   лігі, preu, kya_, ламе, 
   {{0xa2e58ceb,0x1ae593c9,0x59c59d15,0x6721ace4}},	//   _болд, _болм, _विवर, _kolj, 
   {{0x44292ce5,0x3cfd81df,0x7d1bace6,0x6d49ace7}},	//   dya_, _hawv_, ljus, liea, 
   {{0xceb29af4,0xa2d8ace8,0x29dc0818,0x44292ce9}},	//   מים_, _मात्, xía_, eya_, 
   {{0x7afc2cea,0x29dc0422,0xb4ce2ceb,0x5c160008}},	//   _sart, vía_, रले_, льзу, 
   {{0x7c3bacec,0x44292ced,0x3eb80733,0x6b8d8013}},	// [18e0] nzur, gya_, part_, _éags, 
   {{0x57fb0052,0x3cfd9123,0x7d1b8073,0x7afc00f8}},	//   _טלפו, _lawv_, hjus, _qart, 
   {{0x7afc0bb1,0x386dacee,0xf77200dd,0x65c1005a}},	//   _vart, _ayer_, _پاک_, _мұра, 
   {{0x29dc16c7,0x7afc2cef,0x44290563,0x3cfd806c}},	//   ría_, _wart, bya_, _nawv_, 
   {{0x7afc2cf0,0x6846acf1,0x6d460186,0x29dc02ba}},	//   _tart, ында, _imka, sía_, 
   {{0xa2d8904b,0xdb0416b7,0x29dc2cf2,0x78b60217}},	//   _माध्, rsió, pía_, _leyv, 
   {{0xf41f825b,0xeea9805a,0x7afeacbe,0x672185c3}},	//   ään_, ттік_, _ópti, _dolj, 
   {{0xb4ae89d7,0x3cfd806c,0x60c4202c,0x80d6009b}},	//   करे_, _cawv_, _ndim, _भाषे, 
   {{0x7c29acf3,0x3cfd81df,0x3ea6825c,0x6721ab1e}},	//   gyer, _dawv_, _бизг, _folj, 
   {{0xa3b585d9,0xef8386a1,0x60c42cf4,0x23659190}},	//   _जबर_, _глуп, _adim, golj_, 
   {{0xe693830b,0x6e938013,0x5e938013,0x41551081}},	//   _المد, _الما, _المط, ивос, 
   {{0x3cfd81df,0x7c29acf5,0x67218265,0x6ed70a42}},	//   _gawv_, byer, _zolj, _बाहु, 
   {{0x63a2acf6,0x69c09131,0x386d00c0,0x752d2cf7}},	//   _uton, _विकी, æer_, vkaz, 
   {{0xdef82cf8,0x88bd80a1,0x7bfb8039,0x44292cf9}},	//   лыс_, _kośc, _נפוצ, vya_, 
   {{0x2bc718fe,0x44291c62,0x752d0103,0xd2b7acfa}},	//   _लिहा, wya_, tkaz, _גלות_, 
   {{0x44292cfb,0x798280a1,0x06c600b2,0x752d0033}},	//   tya_, jmow, শ্লি, ukaz, 
   {{0x752d0004,0x7522858f,0x4429017c,0xdb040065}},	// [18f0] rkaz, _mooz, uya_, esiñ, 
   {{0x44292cfc,0x394b2cfd,0x752d0010,0x68ff2cfe}},	//   rya_, lics_, skaz, _haqd, 
   {{0x3207026b,0xeb9f0f4a,0xdb580008,0x7c3bacff}},	//   íny_, _grøn_, уют_, zzur, 
   {{0x20092b2a,0xb4ae81cc,0x9a8409b2,0x7c3b8034}},	//   _krai_, करो_, суул, yzur, 
   {{0xe8d90028,0x06b800b2,0xa29500f0,0x3cfd827e}},	//   _chứ_, _জাতি, _вагі, _rawv_, 
   {{0x3cfd81ea,0x9294062d,0x8cad01d2,0x7094ac08}},	//   _sawv_, _гарц, जरको, _ғафф, 
   {{0x23658bfc,0x3cfd81df,0x7bcd01c2,0xf2040086}},	//   volj_, _pawv_, lrau, _лято, 
   {{0x20090116,0x68ff2d00,0x7c3bad01,0xf8b98587}},	//   _orai_, _naqd, tzur, _उजिय, 
   {{0x75ec0068,0x36d5ad02,0xa3cb0562,0x394b2d03}},	//   _közö, _возр, रंट_, dics_, 
   {{0xff538013,0xef67809f,0x81e800b2,0x7c298d73}},	//   _اخر_, _събо, বির_, ryer, 
   {{0x78b62d04,0x394b2d05,0x88bd80a1,0xb0b983ff}},	//   _peyv, fics_, _gośc, _उजाग, 
   {{0x637000f9,0x291d9bd9,0x394b0741,0x7bcd2d06}},	//   tänk, njwa_, gics_, krau, 
   {{0x656b8027,0x2739847f,0x23658bbe,0x68e980df}},	//   _ikgh, _cèng_, polj_, _mbed, 
   {{0xfaa59ba8,0x82a5836d,0x7bcd2d07,0x20092d08}},	//   _тако, _такж, drau, _drai_, 
   {{0xdefa1922,0x29560574,0x63a9ad09,0xa0a62d0a}},	//   ның_, _въпр, lpen, _кайд, 
   {{0xf388810b,0x27edad0b,0x63a9ad0c,0x200902fe}},	//   _hợp_, _open_, open, _frai_, 
   {{0x63a9ad0d,0x7bcd2d0e,0x29002d0f,0xfc0300a6}},	// [1900] npen, grau, _iaia_, опто, 
   {{0x2d8fad10,0x60dbad11,0x29122d12,0x68e9ad13}},	//   _lige_, _acum, _hnya_, _abed, 
   {{0xa2d880da,0xe9da2d14,0x80a68604,0xaadd85b1}},	//   _मास्, тке_, لمان, _मानक, 
   {{0x7bcd2d15,0xa3e68bf5,0x57a680a6,0x3be5802a}},	//   brau, _पहल_, ашка, _कहूँ_, 
   {{0xdefa836d,0x798280a1,0x7600ad16,0x63a981f0}},	//   вый_, rmow, kázá, jpen, 
   {{0x2d8f8b10,0xd00f9b1d,0x29002d17,0xe80703ff}},	//   _aige_, بله_, _laia_, शिता_, 
   {{0xd5b783a7,0x636b05ee,0x6d562d18,0x2d8fa61b}},	//   асы_, rünt, onya, _bige_, 
   {{0xe8d90028,0xa3ea032d,0x6d562d19,0x29002d1a}},	//   _thứ_, _महा_, nnya, _naia_, 
   {{0x61e90024,0x2aaa8634,0x63a9ad1b,0x8cd780da}},	//   _ćeli, ктно_, gpen, _यारो, 
   {{0x29022d1c,0x8ca680da,0x320a0170,0x2d8f8af6}},	//   edka_, _ट्रो, _krby_, _eige_, 
   {{0x2bc2920d,0x6da3a4c2,0x6d562d1d,0x29002d1e}},	//   _शिका, _диха, knya, _baia_, 
   {{0x38c90267,0xdd8f806f,0x57a702bb,0x0c868188}},	//   دادی_, _قول_, ишга, _кылм, 
   {{0xc05b00b6,0xe53b8052,0x2006ad1f,0x291200db}},	//   тін_, _בתאר, nvoi_, _dnya_, 
   {{0x28a70b30,0x394b2d20,0x2912022c,0x200902c0}},	//   _क्रि, sics_, _enya_, _vrai_, 
   {{0x6893007b,0x68ff0103,0x3cdd8353,0x29002d21}},	//   _ویدئ, _taqd, क्के_, _faia_, 
   {{0x7bcd2d22,0x20090028,0x29000109,0xc0cb2d23}},	//   trau, _trai_, _gaia_, _руке_, 
   {{0x3949029f,0xe4f9ad24,0x3cde8034,0x61fc03ad}},	// [1910] _imas_, ्यति_, _गाने_, _asrl, 
   {{0x27340073,0x60db8123,0x6d5603ec,0xfaa72d25}},	//   _täna_, _scum, anya, ршан, 
   {{0x81e480b2,0xa3cb122f,0xa2dd12e1,0x63a98109}},	//   নিক_, रूज_, _पाठ्, zpen, 
   {{0x291200db,0x27398035,0x637dad26,0x3015a9f0}},	//   _xnya_, _mène_, mène, йдер, 
   {{0x8387125e,0x00c8804a,0x2d8fad27,0x98e480d8}},	//   _выве, рлік_, _rige_, تكنو, 
   {{0x2d8fad28,0x7c2d068e,0x7bc0ad29,0x8c3d8093}},	//   _sige_, myar, dsmu, ncşe, 
   {{0x80c200cf,0x2cadad2a,0x7c2d2d2b,0x78bd2d2c}},	//   ষ্ট্, tbed_, lyar, kasv, 
   {{0x26080365,0x28a70a78,0x58d4ad2d,0x68e982f0}},	//   हिती_, _क्लि, _мост, _ubed, 
   {{0x7c2d059d,0xe29984a0,0x40349ddc,0x2cadad2e}},	//   nyar, лап_, _детс, rbed_, 
   {{0x7de7836a,0xf5e780f0,0x39492d2f,0x29002d30}},	//   _відд, _відм, _amas_, _saia_, 
   {{0xa2d8ad31,0xe8d90028,0x29120a11,0x7c2d2d32}},	//   _मार्, _chữ_, _pnya_, hyar, 
   {{0x63700617,0x3cde802a,0x6d958033,0x049580d8}},	//   räni, _गाये_, _všad, _الإح, 
   {{0x290001e0,0x6c8580fe,0xdced0854,0x7c2d01d7}},	//   _vaia_, _الشم, jmađ, jyar, 
   {{0x39492d33,0x442dad34,0xb6a30103,0x3ea30103}},	//   _emas_, mye_, зирл, зирг, 
   {{0x442dad35,0xe5a62d36,0x6f01ad37,0x29120645}},	//   lye_, сиби, _malc, _tnya_, 
   {{0x6d4d1793,0xe0da04c7,0xdced2d38,0x291227d1}},	//   giaa, _сви_, rmağ, _unya_, 
   {{0x442dad39,0x7c2d0068,0xec7a0dc7,0x443fad3a}},	// [1920] nye_, gyar, упа_, nzu_, 
   {{0xa2dd2097,0x8a3a0008,0x7c248015,0x442dad3b}},	//   _पाण्, ляет_, _àire, iye_, 
   {{0xb4f981aa,0xd910807b,0xdce405c3,0x442d816c}},	//   ्याय_, ویس_, jlić, hye_, 
   {{0xe29704b6,0x7c2d2be1,0x6d4d0a44,0xf77f12b6}},	//   _ҳар_, byar, ciaa, rtçe_, 
   {{0xa2d890ff,0x572509dc,0x291283d2,0x442dad3c}},	//   _माल्, _طریق, ıya_, jye_, 
   {{0xe29709db,0x442dad3d,0x7d042d3e,0x443fad3f}},	//   _гар_, dye_, ldis, dzu_, 
   {{0xe7f48bc3,0xa2dd09f8,0x442d8399,0xa3d40562}},	//   _इनका_, _पात्, eye_, सूर_, 
   {{0x7d042d40,0xc0e3ad41,0x442d8246,0x7bc68116}},	//   ndis, _носк, fye_, škum, 
   {{0x442dad42,0x7d042d43,0x78a28170,0x6f01ad44}},	//   gye_, idis, mcov, _falc, 
   {{0xdced0131,0x7d040008,0x6023ad45,0x78a28170}},	//   vlač, hdis, _эдуа, lcov, 
   {{0x69c1a24f,0x9952001b,0x442dad46,0x386003ad}},	//   gsle, lář_, aye_, _axir_, 
   {{0x78a2803e,0x442dad47,0xd25786d5,0x753b8010}},	//   ncov, bye_, сць_, chuz, 
   {{0x7d042d48,0x6725036d,0xc8672d49,0x50672d4a}},	//   ddis, _pohj, стни, стна, 
   {{0x6d5a2d4b,0x7bd62d4c,0xd6d82554,0xa8578309}},	//   étan, duyu, йтс_, מיכה_, 
   {{0xdced0284,0x6d4d2d4d,0x80d89239,0x9577003d}},	//   slač, tiaa, डलाइ, مدرض, 
   {{0xdced0bfc,0x394903b8,0x7d042d4e,0x78a29f49}},	//   plač, _umas_, gdis, jcov, 
   {{0xac182d4f,0x24182d50,0x6d4d2d51,0xa3d41855}},	// [1930] боту_, боты_, riaa, सूल_, 
   {{0x7c2d2d52,0x6d4d02e0,0x70d1810c,0xfb8415c2}},	//   ryar, siaa, हल्ल, пыхн, 
   {{0x7c2d2d53,0x637d80a6,0x7d042d54,0x442d8401}},	//   syar, lènc, bdis, zye_, 
   {{0x2730810b,0x26de82ba,0x7bd6028b,0xcebc008a}},	//   _hành_, _acto_, buyu, _şəxs_, 
   {{0x68ed2d55,0x675402e5,0x26de80bc,0x81e480b2}},	//   _mbad, _ذخیر, _bcto_, নিট_, 
   {{0x7a3f8068,0xe7369bc4,0x442dad56,0xf6500068}},	//   _játé, жеш_, vye_, _آئی_, 
   {{0xf770807b,0x6f01ad57,0x68ed2d58,0x78a2ad59}},	//   راه_, _valc, _obad, bcov, 
   {{0x442d8246,0x443f8109,0x27308106,0x6f018034}},	//   tye_, tzu_, _lành_, _walc, 
   {{0x63ad2d5a,0x60c98533,0x4ad48365,0x7dea808a}},	//   npan, _idem, _दाखव, _vəsa, 
   {{0xa1c5869a,0x443fad5b,0x442dad5c,0x68ed01d5}},	//   обод, rzu_, rye_, _abad, 
   {{0x442dad5d,0x2d5701d0,0x63ad00db,0xe784a8fc}},	//   sye_, għek_, hpan, _хуто, 
   {{0xa3ea0a29,0x63ad2d5e,0x69c18e80,0xa96a2d5f}},	//   _महल_, kpan, rsle, рима_, 
   {{0x41c583ca,0x637d8741,0x3cde80da,0x6d4bad60}},	//   _विकस, gènc, _गाते_, _imga, 
   {{0xee3a0974,0x69c380f3,0x2cbfad61,0x2a8e808a}},	//   анг_, _tvne, laud_, bəb_, 
   {{0x27308028,0x78bb80ef,0x6da302bb,0x6603062d}},	//   _dành_, _oeuv, диса, мпра, 
   {{0x78bbad62,0x0d991878,0x2fcd0bfc,0x95992d63}},	//   _neuv, стры_, šega_, стру_, 
   {{0xccf28377,0x637d80a6,0x03262a04,0x63ad0e3b}},	// [1940] וכן_, cènc, одан, gpan, 
   {{0x60c996b7,0x7bd62d64,0xe3b705cf,0x91eda20a}},	//   _adem, ruyu, юбу_, _जहाज_, 
   {{0xe1fa2930,0x6d4bad65,0x63ad00d8,0x48e10056}},	//   рге_, _omga, apan, _कामो_, 
   {{0x7d040fde,0xa50a124a,0x1d0a2d66,0x200dad67}},	//   qdis, _тема_, _теми_, _brei_, 
   {{0x78a299d6,0x26c8804a,0x7af72d68,0x200dad69}},	//   rcov, йған_, bext, _crei_, 
   {{0x200d82ae,0x7d02ad6a,0x60c9ad6b,0x78a2ad6c}},	//   _drei_, _saos, _edem, scov, 
   {{0xa3dc8258,0x6449012b,0x3f4d0269,0x7d02ad6d}},	//   तून_, _þeir, džul_, _paos, 
   {{0x200d81ed,0x6374875d,0x03c6ad6e,0x7bc40162}},	//   _frei_, màni, осом, osiu, 
   {{0x81bc0a87,0x7bc42d6f,0x741480fe,0x64408131}},	//   _আমি_, nsiu, سودا, uzmi, 
   {{0x2904ad70,0x799c029a,0x637d8741,0xba0a8086}},	//   _hama_, _kurw, vènc, ахме_, 
   {{0x2904a207,0x81e800b2,0x13b300b2,0x2cbfad71}},	//   _kama_, বিক_, টওয়, baud_, 
   {{0x09cf00cf,0xe8d90028,0x2906ad72,0x637d80a6}},	//   _রহমা, _thử_, ndoa_, tènc, 
   {{0x2904ad73,0x644080bf,0x6abc0352,0x63700656}},	//   _mama_, qzmi, _oerf, näns, 
   {{0x290483a1,0x637d8188,0x6abc2d74,0x26dc862d}},	//   _lama_, rènc, _nerf, ngvo_, 
   {{0xe8d9001c,0xdcbb23df,0x637d80a6,0xda6f80f0}},	//   _chợ_, ища_, sènc, _ця_, 
   {{0x5c992d75,0xa3ae8bb6,0x27e6ad76,0x68ed2d77}},	//   ская_, _ओझा_, kton_, _ubad, 
   {{0x6abc2d78,0x63700172,0xdfdb009f,0x27e6816c}},	// [1950] _berf, jäns, _тъй_, jton_, 
   {{0xc7b22d79,0xd3711c98,0x63ad2d7a,0x6abc2d7b}},	//   _רבי_, رها_, rpan, _cerf, 
   {{0x6abc0a76,0x78bb82c0,0x63701cec,0x63748741}},	//   _derf, _peuv, vänt, gàni, 
   {{0x7af72d7c,0x2904ad7d,0x61e52d7e,0x64400208}},	//   sext, _cama_, rthl, _żmie, 
   {{0xd009ad7f,0x01e080cf,0x251a04fc,0x2d892d80}},	//   селе_, ববিদ, _הורא, mmae_, 
   {{0x200d802d,0xe3b200c6,0x69d703b9,0xb6a5ad81}},	//   _vrei_, _אױך_, puxe, чикл, 
   {{0x27e6825b,0x67288025,0x09af80b2,0x6b9d0b5c}},	//   aton_, _dodj, _কিভা, _husg, 
   {{0x200d802d,0xe3b9ad82,0x2904ad83,0x2ee1259f}},	//   _trei_, бби_, _gama_, _lchf_, 
   {{0xdb1b8432,0x27ff83f0,0x1c0e01a2,0x395f82ef}},	//   ssuí, _usun_, सियल_, _ijus_, 
   {{0x4a45a9ac,0x2904ad84,0x466bad85,0x656d12e9}},	//   знов, _zama_, _крем_, hoah, 
   {{0x69c52d86,0xe8038cca,0x2904ad87,0x6b950093}},	//   nshe, लिका_, _yama_, _mizg, 
   {{0x69c52d88,0x6723ad89,0x7dea808a,0x21290149}},	//   ishe, ljnj, _məsl, _coah_, 
   {{0x88bd80a1,0x2ee100bc,0x200f15b9,0x246489b8}},	//   _rośl, _bchf_, _ágil_, rëmë_, 
   {{0x69c702cf,0x395f8172,0x26080076,0x2d9c0063}},	//   _ovje, _ljus_, हिली_, _évek_, 
   {{0x6b9d035b,0x69c52d8a,0x656d040a,0x6b402d8b}},	//   _ausg, jshe, foah, _högg, 
   {{0xe9a89c98,0x69c52d8c,0x6abc024a,0x6d5bad8d}},	//   _بدون_, dshe, _serf, nnua, 
   {{0x2904ad8e,0x2ef82d8f,0x42ca0748,0xf9930309}},	// [1960] _rama_, perf_, йган_, _ארה_, 
   {{0x799c1b45,0x7bc428a4,0x63748741,0x1ddb8439}},	//   _purw, rsiu, tàni, _यमंत, 
   {{0xa2dd2d90,0x6abc2d91,0x7bc42d92,0x4ae20365}},	//   _पार्, _verf, ssiu, _पाठव, 
   {{0x236717fc,0x69c71190,0x0edc001b,0x27e6ad93}},	//   čnja_, _dvje, _बाँड, tton_, 
   {{0x67288f97,0x2904803b,0x2906ad94,0x6abc21c2}},	//   _podj, _vama_, rdoa_, _terf, 
   {{0x395f86e4,0x63701801,0x43930116,0x7d062d95}},	//   _ejus_, räns, _паўс, _haks, 
   {{0x2904ad96,0x7d062d97,0x27e6ad98,0x6728a945}},	//   _tama_, _kaks, ston_, _vodj, 
   {{0x7d062d99,0x27e6ad9a,0x06c600b2,0x75242d9b}},	//   _jaks, pton_, শ্চি, njiz, 
   {{0x69c72d9c,0x0edc0492,0x64440371,0x44202d9d}},	//   _zvje, _बांड, nzii, nxi_, 
   {{0x3cde8e78,0x883b8039,0xbec280f3,0x44200741}},	//   _गावे_, _התמו, šība, ixi_, 
   {{0x76438066,0x75241098,0x58d5120f,0x26cc8324}},	//   czny, kjiz, монт, _iddo_, 
   {{0xf48781a1,0x60c2804f,0x79840232,0x3ebead9e}},	//   _کامی, naom, _chiw, _hett_, 
   {{0xa2dd2d9f,0x656d01cb,0xfc3f033b,0x7984047f}},	//   _पाल्, voah, _afín_, _dhiw, 
   {{0x3da72da0,0x7d0600ed,0x64442da1,0x2d9e812f}},	//   зраб, _aaks, dzii, _kute_, 
   {{0x7afaada2,0x6b952da3,0x249900bf,0x2d9eada4}},	//   mett, _rizg, _pgsm_, _jute_, 
   {{0x3ebeada5,0x69daada6,0xb4c9000d,0xb4d7024c}},	//   _lett_, mute, ैले_, सले_, 
   {{0x69c70310,0x439502d4,0x69daada7,0x60cd12d6}},	// [1970] _svje, даас, lute, _idam, 
   {{0x7afaada8,0x69c501ba,0x2bd49108,0x3ebeada9}},	//   nett, tshe, _दिना, _nett_, 
   {{0x6d4095fe,0x26c3007e,0x7afa8495,0x6aa52daa}},	//   khma, majo_, iett, rchf, 
   {{0x7afaadab,0x69c52dac,0x26c32dad,0xac192dae}},	//   hett, rshe, lajo_, _дому_, 
   {{0x4addadaf,0x7afaabcf,0x69daadb0,0x3ebe8a8d}},	//   _मालव, kett, hute, _bett_, 
   {{0x7afaa5db,0xe29a8106,0x2d9eadb1,0x3ebe8a1c}},	//   jett, _ngư_, _bute_, _cett_, 
   {{0x69c70310,0x69daadb2,0x4177842b,0x7afaadb3}},	//   _uvje, jute, _فارس, dett, 
   {{0x2d9e80b4,0x69daadb4,0x60cd2db5,0xbe3c0309}},	//   _dute_, dute, _ndam, מעות, 
   {{0x7afaadb6,0xb4ad908a,0x387fadb7,0x6d5b8109}},	//   fett, _कभी_, _uzur_, rnua, 
   {{0x60cd2db8,0x7afaadb9,0x6fd2800f,0x26c30ecf}},	//   _adam, gett, _सितं, jajo_, 
   {{0x2d9e9c2b,0x26c30bfc,0x69daadba,0x7764875d}},	//   _gute_, dajo_, gute, éixe, 
   {{0x6d40adbb,0x27340172,0x7e7eab00,0xf1b203f3}},	//   chma, _tänk_, üppe, כסט_, 
   {{0x7d06034a,0xa2e58ceb,0x6b400172,0x44200208}},	//   _raks, _жолд, _höge, xxi_, 
   {{0x7afaadbc,0xdb0b8172,0x6d4f2dbd,0x26c3007e}},	//   cett, _avgö, _amca, gajo_, 
   {{0x7d062dbe,0x2d9e02c0,0x4df500f0,0x2d9622e4}},	//   _paks, ête_, нятт, драс, 
   {{0xe3ba21f3,0x44200109,0x4432019b,0x2bd49669}},	//   жба_, txi_, tyy_, _दिमा, 
   {{0x26c3129b,0x9b0602d4,0x7dea8816,0x73062dbf}},	// [1980] bajo_, мзад, _rəsm, мпаз, 
   {{0x7d098008,0x5fd3002a,0x753d0063,0x60c2804f}},	//   hdes, _तितल, _elsz, waom, 
   {{0x7d062dc0,0xf1a5005a,0x00e6836a,0x3ebe8af6}},	//   _taks, ерін, джен, _rett_, 
   {{0x3ebe8578,0x7d09adc1,0x3cf98034,0x70d88076}},	//   _sett_, jdes, ्यों_, डलेल, 
   {{0xf746adc2,0x2d9e8ccf,0x8fa38d4e,0x69daadc3}},	//   медо, _sute_, ваче, zute, 
   {{0x69daadc4,0xeb9f0c05,0x437500f0,0xb8658936}},	//   yute, _prøv_, _зуст, رانو, 
   {{0x7afaadc5,0x629c01de,0x8a031309,0x7d09876a}},	//   vett, _igro, _изре, fdes, 
   {{0x7afaadc6,0x3f858cb7,0x7d09adc7,0x4906802a}},	//   wett, _ehlu_, gdes, _सोचो_, 
   {{0x7afaadc8,0x671e89d7,0x3ebeadc9,0x7ae38129}},	//   tett, पादक_, _tett_, _bcnt, 
   {{0x60c0adca,0x6d408004,0x48e1007a,0xf772a6f1}},	//   _hemm, shma, _काहो_, _شاء_, 
   {{0x7afaadcb,0x60c082a1,0x7d09adcc,0x26c32dcd}},	//   rett, _kemm, bdes, vajo_, 
   {{0x92be80cf,0x69daadce,0x60c08519,0xeb9a84bc}},	//   ইলে_, rute, _jemm, _дид_, 
   {{0xb9072dcf,0x4420859e,0x7afaadd0,0x629c2dd1}},	//   _पा_, _çi_, pett, _ogro, 
   {{0x69daadd2,0x60c0add3,0xb8d60c2e,0xdce98524}},	//   pute, _lemm, _च्_, tleć, 
   {{0xe5c41309,0x26c30bfc,0x2d86801c,0xf206809f}},	//   ксто, rajo_, _khoe_, _цяло, 
   {{0x60c0add4,0x9d18206d,0xab5d8034,0xd7fb2dd5}},	//   _nemm, мост_, duży, _дуо_, 
   {{0xdce9829f,0x63adadd6,0x213900db,0x21268bbe}},	// [1990] sleć, _çant, mksh_, djoh_, 
   {{0x32110066,0xdb0982fd,0x629c0097,0xd37b0116}},	//   _przy_, mpeã, _cgro, іча_, 
   {{0xe8d9010b,0xd25b0762,0xe8070cca,0x7d098008}},	//   _chủ_, цца_, शिका_, ydes, 
   {{0xa2d88560,0x65628210,0x60c0811e,0x6d4f0269}},	//   _माझ्, _njoh, _cemm, _umca, 
   {{0x7ac7130c,0x60c0a2f8,0xdce40214,0x6f08868e}},	//   _осве, _demm, lliğ, _badc, 
   {{0x26c10791,0xaadd89ca,0xdc1480cf,0x6d9101ac}},	//   _jeho_, _माइक, িহাস_, _sťah, 
   {{0x60c0add7,0x58d5828e,0x3d10810c,0xdce40214}},	//   _femm, _повт, _दोहे_, nliğ, 
   {{0x60c0add8,0x69c8add9,0x28db2dda,0x7d09819b}},	//   _gemm, dsde, _भागि, udes, 
   {{0x7d09addb,0x2d992ddc,0x47d58013,0x6d5a02c0}},	//   rdes, _mise_, _سيار, étai, 
   {{0x4225839a,0x18a3005a,0x26c100e9,0x2d992ddd}},	//   едов, ғарм, _neho_, _lise_, 
   {{0x78a4a4c7,0x4ae2141c,0x9f8a8008,0x443980f3}},	//   žive, _पासव, töön_, šs_, 
   {{0x2d992dde,0x68fd2ddf,0x186a2de0,0xa06a02f0}},	//   _nise_, gesd, зами_, зама_, 
   {{0x2d8dade1,0xff5f01b2,0x26c1013b,0x4fa30fbe}},	//   mmee_, rsîn_, _beho_, лияв, 
   {{0xa357807b,0x613a875d,0xeb9882c3,0x2d992de2}},	//   _تخصص, _aïll, _жиі_, _aise_, 
   {{0xe61709fc,0xf53f037c,0xa3e212b9,0x2d992de3}},	//   ндр_, _blå_, नून_, _bise_, 
   {{0x6283803b,0x7159004a,0x68e40166,0x6d958533}},	//   _izno, _орыс_, _ucid, _ošam, 
   {{0x4ad38503,0x2d992de4,0xe7da80cf,0x7bc9ade5}},	// [19a0] _दयाव, _dise_, _ধন্য, nseu, 
   {{0x60c0ade6,0x394001c8,0xe8d9001c,0xfaa32de7}},	//   _semm, _hlis_, _phủ_, гафо, 
   {{0xdebb0115,0x53368273,0xda1f8f2c,0x60c080db}},	//   _ממיל, ענען_, यमित_, _pemm, 
   {{0xe1ff80a1,0xeb9a2de8,0x5976803d,0x97c6ade9}},	//   łów_, _ним_, رداز, ейде, 
   {{0x6d562dea,0x7bcfadeb,0x63a411f8,0xed50803d}},	//   miya, ácul, qqin, یپت_, 
   {{0x6d562dec,0x629c003a,0xe8d90028,0x9e06aded}},	//   liya, _ugro, _thủ_, ечил, 
   {{0x7bcbadee,0xe3632af7,0xceb30052,0x60c0adef}},	//   _avgu, _скри, ניה_, _temm, 
   {{0xe297035d,0x6d562df0,0x60c62df1,0xd1768188}},	//   _час_, niya, jakm, _чыгы, 
   {{0xe3af8f2a,0x60c60a11,0x1be790f3,0x69de2df2}},	//   یری_, dakm, едњи_, lupe, 
   {{0xfd1f0028,0x39402df3,0x8fa384bc,0x3f9a2df4}},	//   _nhìn_, _alis_, _сафе, _nipu_, 
   {{0x6d441098,0x4dd6adf5,0xb5f2804a,0x68fd2df6}},	//   khia, _ستاس, _сүйі, tesd, 
   {{0xfc66809f,0x68e2adf7,0x88bd80a1,0xdced00d7}},	//   _пълн, ngod, _dośw, mlać, 
   {{0x6d562df8,0x54338158,0x69de2df9,0xb4bc801b}},	//   diya, _مرور, hupe, अरी_, 
   {{0x69de2dfa,0xb9c68013,0xae0d007a,0xa3ea01d1}},	//   kupe, _كتبه, हिलन_, _महज_, 
   {{0x2d990053,0x63a2adfb,0x6d562dfc,0xbb8380fe}},	//   _pise_, _huon, fiya, _حلوي, 
   {{0x63a2adfd,0x6d562dfe,0x6d4414b2,0xdce40214}},	//   _kuon, giya, ghia, rliğ, 
   {{0x2ca92dff,0x63a2819b,0x26c12e00,0x68e2ae01}},	// [19b0] rcad_, _juon, _teho_, dgod, 
   {{0x63a29b66,0x5f9510f3,0x7a4682ef,0x69de0531}},	//   _muon, _шипт, _gété, fupe, 
   {{0x63a2ae02,0x6d562e03,0xda6700fe,0xaa6702bb}},	//   _luon, biya, رائي, хтак, 
   {{0x6d442e04,0xa2dd0ff4,0x637d8246,0x3ce6822a}},	//   chia, _पाक्, vènm, _ncov_, 
   {{0x7c842e05,0x63a2ae06,0xdee5ae07,0x66e5ae08}},	//   _буре, _nuon, воли, вола, 
   {{0x98a90265,0xbec280f3,0x7d0d2e09,0x68e2811e}},	//   _mlađ_, šīna, ldas, agod, 
   {{0xae14023b,0x7bdf0396,0x659c02ef,0xc1790116}},	//   डियन_, luqu, _kōha, ntės_, 
   {{0x63a2ae0a,0x7d0d2e0b,0x27340172,0xacbb00ef}},	//   _buon, ndas, _hänt_, _goût, 
   {{0x2d8d8b7e,0x2734010d,0x6b40010d,0x7bc9ae0c}},	//   rmee_, _känt_, _höga, useu, 
   {{0x6d562e0d,0x7bc9ae0e,0x63a2ae0f,0x78ad0741}},	//   ziya, rseu, _duon, _afav, 
   {{0x216a1cbd,0xa96a1171,0x7bc9ae10,0x39400206}},	//   дини_, дина_, sseu, _plis_, 
   {{0x26c7ae11,0x8fa62e12,0x7afe19e8,0x6d561dc1}},	//   lano_, каме, zept, xiya, 
   {{0xeb8ea7f5,0xf9928273,0xa3a88365,0x7d0d2e13}},	//   _ви_, ירט_, _खूप_, ddas, 
   {{0x26c7ae14,0x7529a56a,0x9a15ac60,0x41d12226}},	//   nano_, ljez, _афиш, _हिंस, 
   {{0x6d562e15,0x6d440324,0x65c32e16,0xb87b0728}},	//   tiya, thia, ибра, rgía, 
   {{0xe8d90028,0x26c7ae17,0x75298889,0x7d0d2e18}},	//   _phụ_, hano_, njez, gdas, 
   {{0x26c7ae19,0x7d0ba841,0x6d441637,0x7afe002d}},	// [19c0] kano_, _mags, rhia, tept, 
   {{0x6d4401c8,0x6d562e1a,0x60c4275b,0x7c2680f9}},	//   shia, siya, _heim, äkri, 
   {{0xb6d90273,0x60c4127a,0x7dea808a,0x3ed900c6}},	//   _אַרט, _keim, _təsi, _אַרא, 
   {{0xa3e201b7,0x7d0b84f0,0x69de2e1b,0x7afe2e1c}},	//   नंद_, _nags, rupe, sept, 
   {{0xb90aae1d,0x26c7ae1e,0x7989807b,0x87e3819b}},	//   _मा_, fano_, _dhew, ающе, 
   {{0x6a860188,0x4add809b,0x3d162973,0xdbdb81c2}},	//   _алга, _मागव, _पोते_, _ráðg, 
   {{0x2d9c0068,0x63a2ae1f,0x248080f3,0x7d0b9661}},	//   _éves_, _suon, _šim_, _bags, 
   {{0x2175875d,0x3d19854d,0x6b9c1725,0x644981ed}},	//   _буур, भागे_, _hirg, fzei, 
   {{0x26c7ae20,0x7d0b9384,0x07a684c3,0x46ea804a}},	//   bano_, _dags, _разн, _одан_, 
   {{0xdced003a,0x39468077,0x63a2ae21,0x7d0d0019}},	//   plać, lhos_, _vuon, zdas, 
   {{0x2bd48fec,0x53d4809b,0x7d0d1ab0,0x6b9c2e22}},	//   _दिवा, _दिवश, ydas, _mirg, 
   {{0x394680b0,0xdd968275,0x63a2ae23,0x518710f3}},	//   nhos_, _شجاع, _tuon, ђуна, 
   {{0x9346813a,0x14d78130,0x1bd4946c,0xf7730604}},	//   _инде, _יואל_, _соля, لاس_, 
   {{0x69d300da,0x5333878a,0x6d428129,0x6b9c2e24}},	//   _डिली, _вешт, _hloa, _nirg, 
   {{0x752f0066,0xa4d5036a,0x7e86801b,0x2fc02e25}},	//   _pocz, лові, _úspě, _ewig_, 
   {{0xb4cd009b,0x60c42e26,0xe7d280da,0x354407c5}},	//   रणे_, _geim, _सिंप, ахув, 
   {{0x65940994,0x2458036d,0x7d0d224b,0x6b9c2e27}},	// [19d0] рату, вать_, rdas, _birg, 
   {{0x26c790b2,0x7d0d039d,0x7cde0123,0x7989ae28}},	//   xano_, sdas, tărâ, _shew, 
   {{0x26c7ae29,0xfaa4004c,0x6b9c2e2a,0xe659002d}},	//   vano_, ршун, _dirg, _чинч_, 
   {{0x69da8094,0x26c7ae2b,0x06d800b2,0x7d009c76}},	//   irte, wano_, দ্দি, jems, 
   {{0x26c7ae2c,0x7d0080d7,0x7dea808a,0x69da81ed}},	//   tano_, dems, _məsu, hrte, 
   {{0x386981d0,0xa03c0039,0x7d0bae2d,0x6d4286a8}},	//   ħar_, ועדפ, _sags, _aloa, 
   {{0x78a48025,0x7d0b98bd,0xa3a88bc3,0x7989ae2e}},	//   živa, _pags, _खूब_, _thew, 
   {{0xf3ffae2f,0x26c7ae30,0x3946ae31,0xb4ad8365}},	//   ção_, sano_, chos_, कडे_, 
   {{0xeb99ae32,0x26c7ae33,0x69daae34,0xd176004a}},	//   нии_, pano_, erte, ғыны, 
   {{0x6449835b,0x4add8023,0x60c42e35,0x753b801b}},	//   rzei, _माओव, _seim, skuz, 
   {{0x7d0bae36,0x52d000cf,0x2bc486d7,0x6449ae37}},	//   _tags, স্কৃ, लीबा, szei, 
   {{0x26c5ae38,0xe4cb803d,0xb87b2e39,0x2e3a80c6}},	//   _helo_, _آبان_, rgín, _אגענ, 
   {{0x69daae3a,0xb4df809b,0xdb0f0530,0xfd1f0106}},	//   arte, तली_, _etcé, _chìm_, 
   {{0x25a581d0,0xe8e081d2,0x26c5805d,0x200900f6}},	//   _kull_, _पञ्च, _jelo_, _dsai_, 
   {{0x60c42e3b,0x16098b30,0x68e98934,0x39592e3c}},	//   _teim, विटर_, _oced, biss_, 
   {{0x2d8b09d8,0x2cad8039,0xf8a8010c,0x26c5ae3d}},	//   _chce_, nced_, _गलिय, _lelo_, 
   {{0x61e1ae3e,0xc9530052,0xac8612f9,0x7bcd1917}},	// [19e0] lull, _למה_, угал, gsau, 
   {{0x7d00a312,0x29022e3f,0x491c000d,0x68e989e6}},	//   zems, leka_, याको_, _aced, 
   {{0x61e1ae40,0xe0da89e4,0x248600e9,0x290d84e2}},	//   null, еве_, ťom_, _baea_, 
   {{0x29022e41,0x69ce9e52,0x9fca8008,0x106a87e4}},	//   neka_, ábei, егда_, нией_, 
   {{0x6b9c2e42,0x26c5ae43,0x7e7e2e44,0x290d84e2}},	//   _tirg, _belo_, _hypp, _daea_, 
   {{0x61e18210,0x26c5a4c7,0x26ca04c0,0x29020a99}},	//   kull, _celo_, nabo_, heka_, 
   {{0x21200025,0x26c5ae45,0x3946839d,0x290223d6}},	//   _onih_, _delo_, phos_, keka_, 
   {{0x9d220a87,0x290204b1,0x61e1ae46,0x26ca12c5}},	//   _নতুন_, jeka_, dull, habo_, 
   {{0x7866ae47,0x26c5ae48,0x26ca2e49,0x7d00ae4a}},	//   _сказ, _felo_, kabo_, rems, 
   {{0x25a5ae4b,0x26c5ae4c,0x69da807e,0x3d19809b}},	//   _full_, _gelo_, trte, _मोठे_, 
   {{0x61e1ae4d,0xa5c4804a,0x63a62e4e,0x03770309}},	//   gull, _төле, _lukn, רתית_, 
   {{0x26c58ecf,0x613f1473,0x64a6ae4f,0x7dea8816}},	//   _zelo_, _gëll, _сада, _dəst, 
   {{0x3f9eae50,0x54368743,0x63a6013b,0x26c59840}},	//   _kitu_, _حرار, _nukn, _yelo_, 
   {{0x26c5811e,0x26ca1a78,0xa2948612,0x92948e29}},	//   _xelo_, gabo_, _калі, _калц, 
   {{0x1df801bc,0x61e1ae51,0x29022e52,0x3f9eae53}},	//   леры_, cull, beka_, _mitu_, 
   {{0x2d800bcc,0x7bcd2e54,0x290201d7,0x99d38019}},	//   glie_, tsau, ceka_, _اتوا, 
   {{0x20092e55,0x5c991747,0x26ca2e56,0x36d525b2}},	// [19f0] _usai_, ткая_, babo_, _копр, 
   {{0xd4982bdb,0x7bcd2e57,0x3ea10128,0x6d5a2e58}},	//   урс_, rsau, _ught_, étar, 
   {{0x798d2e59,0x2d800e3f,0x7dea808a,0x057900d8}},	//   _khaw, blie_, _xəst, _لمدة_, 
   {{0x26c58524,0x3015ae5a,0x98c780fe,0x25a5ae5b}},	//   _selo_, идер, اغان, _rull_, 
   {{0xf7719389,0x26c5ae5c,0x25a5809f,0xd0099ae0}},	//   يات_, _pelo_, _sull_, теле_, 
   {{0x29021173,0x3f9e80f3,0x61e1ae5d,0xddc88162}},	//   zeka_, _citu_, yull, _dydž, 
   {{0x6b40035b,0x29020531,0x3f9eae5e,0xed598410}},	//   _mögl, yeka_, _ditu_, tiž_, 
   {{0xd6580052,0xb4df8bc4,0x613f00f8,0x61e1ae5f}},	//   טיות_, तले_, _qëll, vull, 
   {{0xa3e5922f,0x0b458daa,0x44290916,0x93459c58}},	//   बंध_, инин, nxa_, иние, 
   {{0x2902022d,0x61e1ae60,0x3f9eae61,0x44292e62}},	//   weka_, tull, _gitu_, ixa_, 
   {{0x29022e63,0x69262e64,0x7a699e1f,0xe1260c0a}},	//   teka_, амна, тинг_, амни, 
   {{0x273d010b,0x798d2e65,0x5c75ad85,0x60cb90bc}},	//   _hình_, _chaw, _клет, nagm, 
   {{0x29022e66,0x798d2e67,0x6d498b10,0x26ca2e68}},	//   reka_, _dhaw, mhea, tabo_, 
   {{0x61e1ae69,0x29022e6a,0x6d49ae6b,0xfe462e6c}},	//   pull, seka_, lhea, анго, 
   {{0x273d010b,0x26ca2e6d,0x63a62e6e,0x29022e6f}},	//   _mình_, rabo_, _sukn, peka_, 
   {{0x20560d92,0x9663005a,0x63a62e70,0x26ca2e71}},	//   _втор, ікте, _pukn, sabo_, 
   {{0x7c3b94da,0x6f03ae72,0x0c2611e0,0x78a92b66}},	// [1a00] nyur, kenc, шман, ževc, 
   {{0x6f03ae73,0xdcfb8533,0x973c8105,0x6d958162}},	//   jenc, dluč, _kiće, _išau, 
   {{0x6f03ae74,0x6edb0039,0xa3e5a8b3,0x2d800733}},	//   denc, _בחיפ, बूत_, plie_, 
   {{0xaae20365,0x3f9e8369,0xc05a804a,0x387f8112}},	//   _पाकक, _situ_, кіл_, _byur_, 
   {{0x6d49896b,0x273d010b,0x7d042e75,0xe819122f}},	//   dhea, _bình_, meis, दिया_, 
   {{0x7d042e76,0x2612ae77,0x69c38039,0xed5900e9}},	//   leis, थिली_, _owne, ďže_, 
   {{0x3f9e8010,0x6fd280da,0xbd6a9c39,0x96b980a6}},	//   _vitu_, _सिकं, крие_, уучу_, 
   {{0x6d4984d8,0xc0e3ae78,0x7d040008,0x2d9980a6}},	//   ghea, _моск, neis, гөчө_, 
   {{0x6f039098,0xdee6ae79,0xc34a809f,0x798d2e7a}},	//   benc, _вози, вяне_, _rhaw, 
   {{0x7d0412fa,0x798d2e7b,0x79828052,0x973c9527}},	//   heis, _shaw, llow, _biće, 
   {{0x6d498089,0x7d041db0,0x6b40010d,0x6d460656}},	//   bhea, keis, _rögl, _olka, 
   {{0x6d49896b,0x798d022a,0x7bc286e0,0x92578656}},	//   chea, _qhaw, _twou, рают_, 
   {{0x58872e7c,0x7522ae7d,0x7d042e7e,0x44290208}},	//   рына, _inoz, deis, xxa_, 
   {{0x6d462e7f,0x6d40ae80,0xc05800f0,0x79a697c8}},	//   _alka, lkma, рію_, _крие, 
   {{0xd378803b,0x798d01ea,0x69c38360,0xdcfbae81}},	//   moć_, _thaw, _gwne, zluč, 
   {{0x929b8052,0x7c872e82,0x7d042e83,0x644d00b4}},	//   _ביות, аузе, geis, tzai, 
   {{0xf8bf2e84,0xdfd100fe,0xfaa72e85,0x30340fbe}},	// [1a10] mbé_, _عيد_, ашен, _меъё, 
   {{0x6d462e86,0xd3788259,0x44292e87,0x6f0384e0}},	//   _elka, noć_, rxa_, xenc, 
   {{0x3f83003a,0x387f8a3e,0x5559164d,0x98bf8215}},	//   mlju_, _syur_, _баня_, _smuđ_, 
   {{0x6d498097,0xae1a0039,0x6d40ae88,0x3166ae89}},	//   xhea, _עורכ, jkma, gnoz_, 
   {{0xd3788d87,0x6b81811a,0x1b0f00b2,0xf807a385}},	//   koć_, yllg, সাবে_, рчен, 
   {{0xd246803f,0x6da58370,0x75228e0b,0x6d4096f3}},	//   _فن_, бика, _anoz, ekma, 
   {{0x6d4995ea,0xed59ae8a,0x6f03ae8b,0x60cb820e}},	//   thea, лок_, renc, pagm, 
   {{0x23672e70,0x7c29ae8c,0x6f03ae8d,0x8938ae8e}},	//   čnju_, txer, senc, _кпсс_, 
   {{0x273d010b,0x3245004a,0x973c808d,0x61e52e8f}},	//   _tình_, _теңг, _siće, luhl, 
   {{0x6aa48180,0x6d49ae90,0x60c9ae91,0x973c8533}},	//   _şifr, shea, _heem, _piće, 
   {{0xdce98fdf,0x60c9ae92,0x6d49ae93,0x61e500e5}},	//   sleđ, _keem, phea, nuhl, 
   {{0x75228269,0x973c8a63,0xa3e201a2,0xfc339ac4}},	//   _gnoz, _viće, नूँ_, _وحش_, 
   {{0x442983e9,0x8d7488a0,0x7d042e94,0xd3a7a819}},	//   _ça_, _بالا, veis, _треп, 
   {{0x63bb8e04,0x2cbf86de,0x02398bb7,0x7d0402ae}},	//   mpun, lbud_, _مثبت_, weis, 
   {{0x7d042e95,0x68fb9bae,0x78a90ecf,0x19b59fbc}},	//   teis, _obud, ževa, _احتج, 
   {{0x60c9ae96,0x90c6164e,0x2b5800ca,0xed571164}},	//   _neem, _убие, _smrc_, бос_, 
   {{0x436a075d,0x3f830a5a,0x63bbae97,0x44260077}},	// [1a20] гаан_, blju_, npun, ão_, 
   {{0x29122e98,0x7d04041a,0xe29a19d4,0x68fb89ec}},	//   _haya_, seis, газ_, _abud, 
   {{0x29122e99,0x993a88cf,0x60c9ae9a,0x2cbf860b}},	//   _kaya_, ляду_, _beem, kbud_, 
   {{0xc6930052,0x63bbae9b,0x6d460103,0x68fb8097}},	//   _מאת_, kpun, _ulka, _cbud, 
   {{0x8ff78013,0xe73a91f1,0xdfcf80fe,0x69d581d2}},	//   مرور_, лед_, فين_, ázej, 
   {{0x63bba19e,0x6d59ae9c,0x61e52e9d,0x29122e9e}},	//   dpun, _amwa, buhl, _laya_, 
   {{0x60c981df,0x200d8ac8,0xceb303dd,0x8f9b0eee}},	//   _feem, _esei_, ליג_, ניצי, 
   {{0x63bba6bb,0x73d883ad,0xfc468507,0x5fe0832d}},	//   fpun, адир_, šími_, _निपल, 
   {{0x6d40ae9f,0x63bb9075,0x61fb0a63,0x68468741}},	//   rkma, gpun, _ćuli, _унаа, 
   {{0xdb042ea0,0x68ed1587,0x6d40aea1,0x2912013b}},	//   mpió, _scad, skma, _aaya_, 
   {{0x3f83003b,0x7c248116,0x8e8680fe,0x29122ea2}},	//   vlju_, _šird, _الاه, _baya_, 
   {{0x291200f6,0x73e681e2,0x60c981df,0xddcb01bb}},	//   _caya_, _годз, _xeem, ġiżl, 
   {{0x637d875d,0x27e68347,0x3f830c0e,0x25e60587}},	//   tènt, nuon_, tlju_, जूसी_, 
   {{0xc90580c9,0x830305a2,0x2e1806e4,0xf8bf0063}},	//   _रस्म_, _উচ্চ_, _bčf_, sbé_, 
   {{0x2c748019,0x2bc483ff,0x291212f3,0x2000017c}},	//   _دیکھ_, लीरा, _faya_, _epii_, 
   {{0x29122ea3,0x52838013,0x78a49287,0x27e6aea4}},	//   _gaya_, _عليك, živj, kuon_, 
   {{0xfd4f0028,0x994800a7,0x3f83039f,0x26ce80de}},	// [1a30] _khiế, _دليل_, plju_, kafo_, 
   {{0x63ad2ea5,0x39490170,0x60c9aea6,0x27e6aea7}},	//   rqan, _hlas_, _seem, duon_, 
   {{0x39492ea8,0x56952ea9,0x27ff802d,0x29122eaa}},	//   _klas_, _фант, _spun_, _yaya_, 
   {{0x61e503ad,0x2cbf8341,0x399b2eab,0x63bbaeac}},	//   ruhl, xbud_, _būsi_, ypun, 
   {{0xb4e501aa,0x63ad03ad,0x9f99abe0,0x6aa90166}},	//   नली_, qqan, авду_, _şefu, 
   {{0x70b52ead,0x3949016f,0xfd4f0106,0x60c9812c}},	//   ंडुल, _llas_, _nhiế, _weem, 
   {{0x60c9abac,0x27ff80bf,0x39492eae,0x2cbfaeaf}},	//   _teem, _wpun_, _olas_, tbud_, 
   {{0x63bb803b,0x2bd4908a,0x68fbaeb0,0x6d4d2eb1}},	//   tpun, _दिखा, _ubud, nhaa, 
   {{0x6fe081ff,0x69da08b4,0x29121a28,0x2cbf81a3}},	//   _नियं, _åter, _raya_, rbud_, 
   {{0x29120271,0xfd4f010b,0x6d4d2eb2,0x63bbaeb3}},	//   _saya_, _chiế, hhaa, rpun, 
   {{0x63bbaeb4,0x29120ac4,0x7cd98019,0x39492eb5}},	//   spun, _paya_, _نواز_, _blas_, 
   {{0x78a9029f,0x6d59859d,0x39492eb6,0x7c248a5a}},	//   ževn, _umwa, _clas_, _šire, 
   {{0x6d4d124e,0x29121671,0x224d01d2,0x232984fa}},	//   dhaa, _vaya_, _řekl_, _воли_, 
   {{0x39492eb7,0x6da62eb8,0x6569aeb9,0x973c8a63}},	//   _elas_, жива, lneh, _kića, 
   {{0xad5a2eba,0x63abaebb,0x2912022c,0xa3e5810c}},	//   арах_, _hugn, _taya_, बूर_, 
   {{0x63a3ad2c,0x6569aebc,0x6d4d2ebd,0x6d430123}},	//   _hinn, nneh, ghaa, _înal, 
   {{0x63a3aebe,0x443faebf,0x442d84e0,0x42ca0004}},	// [1a40] _kinn, nyu_, nxe_, иган_, 
   {{0x6fe081ff,0x261a81d1,0x63a3aec0,0x7c2480fe}},	//   _निबं, _मछली_, _jinn, _áire, 
   {{0x64a62ec1,0x63ab8172,0x2d8c2ec2,0x316d8269}},	//   _мана, _lugn, ïdes_, _bjez_, 
   {{0x63a3aec3,0x6d4d0a44,0x443faec4,0x98a681e4}},	//   _linn, chaa, kyu_, циде, 
   {{0xee02a40c,0x186a8004,0xd70a8188,0x63ab82b1}},	//   लब्ध_, шади_, инде_, _nugn, 
   {{0x17548f4c,0xd04e008a,0x501b04fc,0x6d442ec5}},	//   явля, ükəs, יונו, lkia, 
   {{0x79460066,0xd94687b6,0x6146a9ac,0x26ceaec6}},	//   _równ, _деви, _дева, rafo_, 
   {{0x6d4401e2,0x63abaec7,0x7d162ec8,0xdb040530}},	//   nkia, _bugn, ndys, mpiñ, 
   {{0x63a3a670,0xdce40053,0x443faec9,0xeb069a59}},	//   _binn, jnič, gyu_, очно, 
   {{0x63a38649,0xba548251,0x63abaeca,0x6d5f03ad}},	//   _cinn, звој, _dugn, ziqa, 
   {{0x39492ecb,0x442d84e0,0x6283811a,0x6d44019b}},	//   _plas_, axe_, _cyno, kkia, 
   {{0x63a3812b,0xdb038093,0x6283811a,0x80b50353}},	//   _einn, _jinê, _dyno, ंडें, 
   {{0x63a398d6,0xfd4f010b,0xcb6a80b0,0x61e1811e}},	//   _finn, _thiế, _каде_, arll, 
   {{0xdced0c0e,0xf48781fa,0x26cc884c,0x937780d8}},	//   vlađ, _بامی, _jedo_, _وصور_, 
   {{0x26ccaecc,0x6d5f2ecd,0x6d4d0461,0x661e0375}},	//   _medo_, tiqa, thaa, _crpk, 
   {{0x9f528093,0xb4e52ece,0x39492ecf,0x91b780dd}},	//   îyê_, नले_, _ulas_, _بطور_, 
   {{0xe873119c,0x6d4d2ed0,0x6d5f2ed1,0xb2ab0a5f}},	// [1a50] _زندگ, rhaa, riqa, атеж_, 
   {{0xce95009f,0x26cc8265,0x2bdd910f,0xdceb868c}},	//   _напъ, _nedo_, _मिसा, _čičk, 
   {{0x60cd153c,0x6cea93d2,0xdced0284,0xdb038093}},	//   _keam, _टांग_, slađ, _binê, 
   {{0xdd868068,0x60c2a2a9,0x6d5f0103,0x6d441936}},	//   _سو_, gbom, qiqa, ckia, 
   {{0x26ccaed2,0x880780dd,0x2be2102c,0x6d5d2ed3}},	//   _bedo_, تظام, _पिया, _imsa, 
   {{0x26d12ed4,0x60cd065e,0x26ccaed5,0x973c80ca}},	//   nazo_, _leam, _cedo_, _pića, 
   {{0x63a3aed6,0xc33203dd,0x3ea2899f,0x63ab8352}},	//   _rinn, _אום_, нишг, _sugn, 
   {{0x60cd2ed7,0x26d1052a,0x442d8a01,0x63abaed8}},	//   _neam, hazo_, txe_, _pugn, 
   {{0x6569aed9,0xb4bb908a,0x399b0029,0xb4ab8d64}},	//   rneh, _अभी_, _jūsu_, _खली_, 
   {{0x442d84e0,0x399b0029,0xdce42eda,0x6d932edb}},	//   rxe_, _mūsu_, vnič, lçad, 
   {{0x63a3aedc,0x6d442edd,0xd9100068,0x98b0068b}},	//   _vinn, ykia, ہیں_, šača_, 
   {{0xdce4003a,0x6d93057a,0x216a2ede,0xa96a2edf}},	//   tnič, nçad, сими_, сима_, 
   {{0x6d4b877f,0x60cd1625,0x661e0252,0xe81e9379}},	//   _ilga, _deam, _srpk, पिया_, 
   {{0x26cc1dfb,0x7d09aee0,0x61e8aee1,0x63a38540}},	//   údo_, lees, budl, _uinn, 
   {{0x61462ee2,0x65c6009f,0xd94602e2,0x23c581b2}},	//   _нека, ябва, _неки, bêjî_, 
   {{0x60cd2ee3,0x7d09aee4,0x2a3a8039,0xdce416b4}},	//   _geam, nees, _לעצמ, pnič, 
   {{0x26d12ee5,0x6d442ee6,0x2fc9043a,0x7d162ee7}},	// [1a60] bazo_, rkia, _gwag_, rdys, 
   {{0xe8190562,0x7d098008,0x78a98495,0x8afc80a1}},	//   दिरा_, hees, _agev, mięc, 
   {{0x6d4b8004,0x23660533,0x7d09aee8,0x42560b73}},	//   _olga, đoj_, kees, чтат, 
   {{0x4c6a2ee9,0xdb04269b,0x7e7301b2,0xfaf88f30}},	//   _гимн_, rpiñ, şepê, lnīt_, 
   {{0x2d822059,0x98a70a5a,0x8afc80a1,0x26ccaeea}},	//   _ikke_, šića_, nięc, _pedo_, 
   {{0x6d930432,0x6d4ba1dc,0xa2bb29a6,0x60c2aeeb}},	//   açad, _alga, शुद्, sbom, 
   {{0x78ad803b,0x26ccaeec,0x64409122,0x7d09aeed}},	//   žava, _vedo_, wymi, fees, 
   {{0x5bb8aeee,0x3f878284,0x6440aeef,0x7d09800b}},	//   олия_, alnu_, tymi, gees, 
   {{0x6fb68629,0x7bd62ef0,0x60cd2ef1,0x26cc959b}},	//   _رمضا, nsyu, _ream, _tedo_, 
   {{0x60cd2ef2,0xff24803d,0x29000123,0x656082a1}},	//   _seam, _تبری, _abia_, simh, 
   {{0x628781d0,0xc3330039,0x7bd600e5,0x60cd0079}},	//   żjon, תות_, hsyu, _peam, 
   {{0x39468116,0x26d10010,0xf8cc852b,0x673a8027}},	//   nkos_, wazo_, ारिय, _hotj, 
   {{0x26d10ce5,0x61e8aef3,0x315783dd,0x60cd2ef4}},	//   tazo_, sudl, ליטן_, _veam, 
   {{0xd7f81c66,0x973c8bbe,0x2d8209ec,0x673a9473}},	//   чую_, _mićo, _akke_, _jotj, 
   {{0x50ccaef5,0x8afb8052,0x26d12ef6,0xf8cc8ab2}},	//   ाराष, _להגי, razo_, ाराय, 
   {{0x2d582ef7,0xe8d90106,0x6b40007f,0x2fc9013b}},	//   пись_, _thự_, _mögu, _twag_, 
   {{0x26d10659,0x67289190,0xb0c309af,0x6b40007f}},	// [1a70] pazo_, _ondj, _व्यग, _lögu, 
   {{0x29190265,0xe1ab83f0,0x399203b9,0xdb03855a}},	//   ldsa_, _घूँघ, ráse_, _cinè, 
   {{0x7d0986b5,0xdb0b809a,0x7f3c0039,0x62868034}},	//   yees, _utgå, _לעזו, ękow, 
   {{0x6728808d,0xbcfb06b8,0x3946982d,0x6d5d2ef8}},	//   _andj, _ejér, gkos_, _umsa, 
   {{0xdb1b85da,0x248693e2,0x29d88028,0x6d932ef9}},	//   spué, _nyom_, hĩa_, rçad, 
   {{0xe9ff810b,0x7d09aefa,0xdb0286c9,0x69d88086}},	//   _loại_, wees, _otoñ, _ovve, 
   {{0x7d09aefb,0xed5981bc,0x290b2efc,0x673a861c}},	//   tees, жой_, keca_, _dotj, 
   {{0x656d2efd,0x63af0081,0x25de85c9,0xe3b9aefe}},	//   nnah, _kucn, _गिरी_, оби_, 
   {{0x69d8aeff,0x7d09af00,0x2bdd8365,0x290b2f01}},	//   _avve, rees, _मिळा, deca_, 
   {{0x9906092c,0xe9d987ae,0x4a45940f,0x7d09af02}},	//   षज्ञ_, око_, днов, sees, 
   {{0x63a700fa,0x779082e5,0xdb0381d2,0x6d4b82b1}},	//   _mijn, _حیوا, _jiné, _tlga, 
   {{0x69d803b8,0xe6c601a2,0x6b400172,0x63a72f03}},	//   ávei, वर्ज, _högt, _lijn, 
   {{0x7d5680c6,0xdb03af04,0x69d8af05,0x657c9435}},	//   _קינד_, _liné, _evve, _írha, 
   {{0x394daf06,0x62658826,0x77638065,0x212902ef}},	//   _lles_, _овла, ninx, _enah_, 
   {{0x8fa318e1,0x8afc80a1,0x656d2493,0xdef90116}},	//   таре, sięc, fnah, чыў_, 
   {{0x1987009f,0x63af0c0e,0xa1870086,0x8afc8034}},	//   _общи_, _bucn, _обща_, pięc, 
   {{0x7984022d,0x63a70a44,0x2486822a,0x63af00ca}},	// [1a80] _ikiw, _bijn, _xyom_, _cucn, 
   {{0x394d802d,0x7bd60058,0xdb0988a3,0xdb0383df}},	//   _ales_, rsyu, mpeó, _biné, 
   {{0xdb03af07,0x69c19acc,0x6b520142,0x973c8a63}},	//   _ciné, nple, _lægg, _sićo, 
   {{0x39468116,0x395f8065,0x2004af08,0x63bd0050}},	//   ukos_, _cmus_, _ppmi_, _ftsn, 
   {{0x3946af09,0x63a700fa,0x6b40007f,0x7763811e}},	//   rkos_, _fijn, _sögu, finx, 
   {{0xd5ba9830,0x394d8ed0,0x5694af0a,0x3946863b}},	//   оси_, _eles_, налт, skos_, 
   {{0x44222f0b,0x53a700da,0x4393004c,0x394d8161}},	//   _hrk_, _कूटश, _раёс, _fles_, 
   {{0xb4e883ff,0x69c19d1a,0x63a701f0,0x2d800036}},	//   बले_, dple, _zijn, noie_, 
   {{0xd90d8c0b,0xa2a203f2,0x64440371,0x25a691b0}},	//   _دین_, _कृत्, nyii, _viol_, 
   {{0x79842f0c,0x5a3490e6,0x4c9283ad,0x25f68034}},	//   _akiw, енот, ниқс, _एमपी_, 
   {{0x6b4000f9,0x290b0607,0x656d2f0d,0x212900e5}},	//   _högs, teca_, ynah, _pnah_, 
   {{0x0566af0e,0x1c46af0f,0x78a4a52e,0x2d4706b0}},	//   _ювен, _онем, živu, _põem_, 
   {{0xb8d70624,0x6d43002d,0x290b2f10,0x7d028269}},	//   _जल_, _înai, reca_, _ibos, 
   {{0x290b029f,0x2bb501ff,0x63af0533,0x5ee080b2}},	//   seca_, _अंबा, _rucn, প্রে, 
   {{0xd9f281b7,0x3da701e2,0x27e6af11,0x290b2f12}},	//   _अमित_, драб, hron_, peca_, 
   {{0xa3e5807a,0x994402bc,0x63af1146,0x21f88385}},	//   बूक_, mış_, _pucn, méh_, 
   {{0x63a7174e,0xdb03af13,0x994407de,0x6f170149}},	// [1a90] _pijn, _siné, lış_, _taxc, 
   {{0x27e6af14,0x656d2f15,0x44221593,0x7f591892}},	//   dron_, snah, _drk_, _хаос_, 
   {{0x27e685cb,0x39920019,0x994408f1,0x21f8822c}},	//   eron_, lása_, nış_, néh_, 
   {{0x63a700fa,0x26de8347,0x7c22af16,0x6b44817c}},	//   _wijn, _adto_, _oror, _dògi, 
   {{0x7d0d2f17,0x80278013,0x78ad829f,0x5ed380b2}},	//   meas, برام, žavo, _সাবে, 
   {{0xf77381be,0xae03009b,0x7d0d2f18,0x76438008}},	//   خاص_, _लहान_, leas, tyny, 
   {{0x753d2377,0x77638916,0x27e6af19,0xc17788f7}},	//   _kosz, rinx, aron_, _قدرت, 
   {{0x7643af1a,0x92942f1b,0x7d0d2f1c,0x78ad0128}},	//   ryny, _расц, neas, _ngav, 
   {{0x79960324,0x7643819b,0x99858063,0xf8b28eee}},	//   _rhyw, syny, _élő_, _תשמ_, 
   {{0x7d0d2f1d,0x6b4000f9,0x39920019,0x69c1af1e}},	//   heas, _högr, dása_, tple, 
   {{0x26c78bfc,0x7d0d0008,0xe1f693b7,0x7c22a980}},	//   mbno_, keas, нгэ_, _eror, 
   {{0x361a8039,0x69c1af1f,0x7c228065,0x261180ca}},	//   _מועד, rple, _fror, _išo_, 
   {{0x2d802f20,0x69c1af21,0x291e001b,0xdb06056c}},	//   voie_, sple, ěta_, _luká, 
   {{0x6d4f122b,0xcc3a896e,0x7d1b8073,0x6b40007f}},	//   _alca, _מענט, ldus, _lögr, 
   {{0x236580f9,0xd0408816,0x7d0d1a6e,0xd5b21ae3}},	//   milj_, _demə, feas, افر_, 
   {{0x7d1b8689,0xdb09860e,0x27e6af22,0x7984004f}},	//   ndus, mpeñ, yron_, _ukiw, 
   {{0x6b520142,0xec772f23,0x490000c9,0xb4db0097}},	// [1aa0] _læge, епт_, ष्णो_, _alàs, 
   {{0x27e6af24,0xb4db0097,0xc48300a6,0x44221d65}},	//   vron_, _blàs, улук, _vrk_, 
   {{0x00e6af25,0xb4db075d,0x2d730259,0x7d0d2f26}},	//   ежен, _clàs, mćen_, beas, 
   {{0x27e6af27,0x61e30068,0xe0d294f9,0x057614f9}},	//   tron_, ánla, ازا_, _ساجد, 
   {{0x14d70052,0x588384ce,0x27e6af28,0x673e2f29}},	//   _אוכל_, лыша, uron_, _kopj, 
   {{0x7bc42f2a,0xf0930273,0x7c24af2b,0x27e6af2c}},	//   mpiu, אנד_, _širo, rron_, 
   {{0x99440816,0x27e6af2d,0x39920019,0x38728123}},	//   xış_, sron_, zása_, _ţară_, 
   {{0x78a90024,0xe9a3805a,0x69dc29de,0x442029d2}},	//   ževi, _басп, _ivre, ovi_, 
   {{0x3076941a,0x7d19af2e,0x6b81835b,0x442000a6}},	//   _чувс, _daws, folg, nvi_, 
   {{0xf0638340,0x994403d2,0x44202f2f,0xb5f2804a}},	//   _скуп, tış_, ivi_, _бүкі, 
   {{0x44202f30,0xdb072f31,0x2fc01725,0x2bc4af32}},	//   hvi_, _dijè, _atig_, लीजा, 
   {{0x4420003b,0x39920068,0x9944107f,0x613f00f8}},	//   kvi_, tása_, rış_, _pëlq, 
   {{0x53b5009b,0x5694004a,0x673e00bc,0x6562813b}},	//   _अंधश, ғатт, _bopj, _imoh, 
   {{0x4ea72f33,0x7d1980a1,0x4420008d,0x6d48024a}},	//   ерба, _zaws, dvi_, êdan, 
   {{0x753d1c2a,0x3ea52f34,0x7d0d2f35,0x44202f36}},	//   _posz, ält_, teas, evi_, 
   {{0x69daaf37,0xdb06026b,0x2bb51628,0x3ceb00c9}},	//   mste, _ruká, _अंदा, टलें_, 
   {{0x97a70286,0x69dc2100,0xb4db0a67,0x656283ec}},	// [1ab0] _прол, _avre, _blàr, _mmoh, 
   {{0x6f1aaf38,0x7d1b8bbe,0x200900db,0x69daa85f}},	//   _natc, zdus, _ipai_, oste, 
   {{0x64410816,0x69daa9b2,0x44202f39,0x7d0d2f3a}},	//   _əliy, nste, avi_, peas, 
   {{0x69daaf3b,0xf99f06e0,0x6b818063,0x2d8684e2}},	//   iste, nmè_, zolg, _nkoe_, 
   {{0xb9099353,0x7d19af3c,0x69dc2f3d,0x417489ef}},	//   _मय_, _raws, _evre, دالس, 
   {{0x2d8693fd,0xdcfb86f3,0x656283ec,0xdce98269}},	//   _akoe_, rouč, _amoh, rneč, 
   {{0x6b819890,0xc8f58574,0xda051379,0x69daaf3e}},	//   volg, _извъ, _रहित_, jste, 
   {{0x26d300f8,0xb8b2804a,0xab64038e,0x387e0034}},	//   _lexo_, _көші, rmüş, ętrz_, 
   {{0x69daaf3f,0xeb99af40,0x81c300b2,0x6d49af41}},	//   este, мии_, _এটি_, rkea, 
   {{0x26d30207,0x69daaf42,0x69c51da2,0x290faf43}},	//   _nexo_, fste, ophe, lega_, 
   {{0x2bd1875c,0x2fc02570,0x28c3009b,0x291b2f44}},	//   _दौरा, _stig_, _व्हि, _baqa_, 
   {{0x290f8ecf,0x291daf45,0x81c300cf,0x186a27dc}},	//   nega_, ndwa_, _এটা_, дами_, 
   {{0x39590210,0x3de380b2,0x2d8d8766,0x6594877a}},	//   ërsa_, _মহিল, mlee_, _сацу, 
   {{0x290faf46,0xdf15036a,0x3f830708,0x6f1a811e}},	//   hega_, льсь, goju_, _xatc, 
   {{0x290f8ecf,0x5ed400cf,0x26d3011e,0x628a843a}},	//   kega_, _তাদে, _dexo_, _gyfo, 
   {{0x290faf47,0x44202f48,0xa2a226f9,0x25ab0036}},	//   jega_, tvi_, _कृष्, _cicl_, 
   {{0xd4671afe,0xc4d28273,0x290f8073,0x6da328a7}},	// [1ac0] вите_, יגן_, dega_, рита, 
   {{0x212d83e8,0x7bdb8008,0x39400097,0x7bc4062d}},	//   _aneh_, isuu, _hois_, rpiu, 
   {{0x26d82f49,0xab5b02ae,0xe8fa81e2,0xa9a68086}},	//   maro_, _stüc, дле_, вижд, 
   {{0x290faf4a,0x26d80318,0x6f1a8b3f,0xd7e6909a}},	//   gega_, laro_, _satc, віко, 
   {{0xa41c80cf,0x394003e9,0x3166a932,0x212d807e}},	//   _তথ্য_, _mois_, rioz_, _dneh_, 
   {{0x6d932f4b,0xbcfb000d,0x9e06af4c,0x26d82f4d}},	//   nçan, _jmén, вчил, naro_, 
   {{0x6704256d,0x6f0307fa,0x69dc006a,0x2dd780fe}},	//   श्यक_, _önce, _uvre, نبية_, 
   {{0x290f829f,0x1514af4e,0x6f1a8039,0x38c889dc}},	//   cega_, удия, _watc, _ساری_, 
   {{0xa8879da8,0x98a39e4b,0x69daaf4f,0xdb0f0065}},	//   _айта_, _вите, wste, _sucé, 
   {{0x69da859a,0x3940006b,0x26d82f50,0x5fdc0787}},	//   tste, _aois_, jaro_, _बिजल, 
   {{0xe7379a50,0x39402f51,0x69daaf52,0x28f90765}},	//   _шеф_, _bois_, uste, нень_, 
   {{0x69da9013,0x26d303bc,0x7c2d868b,0xbcfb00ef}},	//   rste, _sexo_, _šare, _amén, 
   {{0x39402f53,0x6d562a00,0x69da8469,0x50642f54}},	//   _dois_, dhya, sste, атра, 
   {{0x26d82f55,0x44268347,0x973c868c,0x628aaf56}},	//   garo_, _iro_, _bići, _tyfo, 
   {{0x394003e9,0x3f832f57,0xdb07024a,0x1df8104c}},	//   _fois_, roju_, _bijî, керы_, 
   {{0x2d84af58,0x4426af59,0x63ad81e9,0x6e25061c}},	//   nome_, _kro_, _èanc, _vrhb, 
   {{0x290faf5a,0xdb0701b2,0x26d82f5b,0x27e097b2}},	// [1ad0] vega_, _dijî, baro_, šinj_, 
   {{0x9952003e,0x26d801d7,0x61e30019,0x2d8d80bf}},	//   máš_, caro_, ánlo, zlee_, 
   {{0x6d5c81e2,0x290faf5c,0x02a71a91,0x2d84af5d}},	//   _įran, tega_, трам, kome_, 
   {{0x4426af5e,0xe5350008,0x2d848162,0xa6cf85a2}},	//   _oro_, _семь, jome_, _রাইট, 
   {{0xb4c12f5f,0x290faf60,0xdee59fe3,0x6d4d2f61}},	//   ुरी_, rega_, голи, mkaa, 
   {{0x290f8689,0x20d1810b,0x77848118,0x6d4d2f62}},	//   sega_, ại_, аліз, lkaa, 
   {{0x7bc2af63,0x4426af64,0x2d84af65,0x80d280b2}},	//   _atou, _aro_, fome_, _হার্, 
   {{0xdb0d16b7,0x6d4d2f66,0x7d1d2f67,0x2d84af68}},	//   mpañ, nkaa, _jass, gome_, 
   {{0x7d1d1af2,0x4426af69,0x39402f6a,0x98a008dc}},	//   _mass, _cro_, _rois_, _inić_, 
   {{0x7d1d2f6b,0x7bdbaf6c,0x96ca8562,0xdced0024}},	//   _lass, rsuu, _स्पॉ, dnač, 
   {{0x39402f6d,0x6d4d2f66,0xd94615c8,0x4426af6e}},	//   _pois_, kkaa, гени, _ero_, 
   {{0x4426843a,0x2d84af6f,0x6d4d2f70,0x26d82f71}},	//   _fro_, come_, jkaa, waro_, 
   {{0xeb8eaf72,0x4426af73,0x26d82f74,0x39402f75}},	//   _ги_, _gro_, taro_, _vois_, 
   {{0x973c8105,0x06e580b2,0x6569af76,0x59d0801b}},	//   _pići, প্রি, lieh, थीहर, 
   {{0x7d1d2f77,0xfce62d4f,0xa50a1c58,0x26d82f78}},	//   _bass, лово, нева_, raro_, 
   {{0x7d1d2f79,0x39990068,0x291e0029,0x6d4d2f7a}},	//   _cass, tése_, ētas_, gkaa, 
   {{0x26d82f7b,0x2e178816,0x5f76003d,0x25a02f7c}},	// [1ae0] paro_, _dəfə_, _مادر, rmil_, 
   {{0x46f60e79,0x6d56029a,0xdcf49527,0x79862f7d}},	//   _счит, shya, _čačk, lokw, 
   {{0x7d1d2f7e,0x6d4d092f,0x29d187ad,0xdb0a84b4}},	//   _fass, bkaa, nša_, _difè, 
   {{0x394081c2,0x631400b2,0x79862f7f,0x6d932f80}},	//   ðis_, সাইট_, nokw, nçal, 
   {{0x6f1e011d,0xe3b207f1,0x7f46af81,0x61fe2f82}},	//   _kapc, _درج_, ледж, stpl, 
   {{0x779180dd,0x7c24086e,0x798621c3,0x7d1d2f83}},	//   قیقا, mvir, hokw, _zass, 
   {{0xe2972f84,0x5fe0823b,0x29d1a4c7,0xdced0802}},	//   _бар_, _निकल, jša_, znač, 
   {{0x44269470,0x69de2f85,0x74149b1d,0x645b81f0}},	//   _pro_, mspe, لوبا, fzui, 
   {{0x7c242f86,0x136a8591,0x69de2f87,0x7f418821}},	//   nvir, ешни_, lspe, _folq, 
   {{0xa3e5908a,0x93fb0130,0xbcfb02c0,0xe3bf81e0}},	//   _फिर_, עליי, _amél, íña_, 
   {{0x19590abf,0xe1352f88,0xaa948ba0,0x49751a59}},	//   ваны_, анны, ринч, илос, 
   {{0x25f3807a,0x4426af89,0x63ae034e,0x69de00fe}},	//   ्झरी_, _tro_, _libn, ispe, 
   {{0x44268bfc,0x68e4011a,0x644682f4,0xc8672f8a}},	//   _uro_, _ddid, äkid, утни, 
   {{0x2b8f02ae,0x7d1d2f8b,0x69de2f8c,0x7c2910f1}},	//   rück_, _sass, kspe, _šero, 
   {{0x7d042f8d,0xd9048068,0x27e01321,0x6d4d0ac1}},	//   ffis, _ٹی_, _evin_, tkaa, 
   {{0x6298803a,0xb4c12f8e,0x69de0e87,0x7d1d2f8f}},	//   _izvo, ुरे_, dspe, _qass, 
   {{0x81b680cf,0x7afda06c,0x69c8a102,0x7d1d2f90}},	// [1af0] _ছবি_, đstv, lpde, _vass, 
   {{0x7d1d2f91,0x656982ae,0x6d4d02e0,0x6e28837c}},	//   _wass, zieh, skaa, _ordb, 
   {{0x7d1d2f92,0x5ed380b2,0x69de2f93,0x6db181a8}},	//   _tass, _সালে, gspe, _jāat, 
   {{0xf8bf02c0,0xa3e58625,0x973c839f,0x7ff594f9}},	//   ncé_, _फिल_, _miću, لستا, 
   {{0x6d93057a,0x6e289a6e,0x69de0166,0xdb0d033b}},	//   nçam, _ardb, aspe, spañ, 
   {{0x6d5801e2,0xb8ec80da,0x99d70a57,0x645b83ad}},	//   _įvai, _श्_, _مترا, vzui, 
   {{0xb8db80cf,0x8d558a4b,0x6569af94,0xf8c980ef}},	//   _আজ_, итич, tieh, _créé_, 
   {{0xf1a49339,0xdce40284,0x29d18533,0x79a48077}},	//   _грун, rnić, vša_, _груе, 
   {{0x1c429878,0x8508804a,0xdb0f122b,0x656984fb}},	//   жным, удың_, _lucí, rieh, 
   {{0xe787af95,0x7bdf02fd,0x506484da,0x60d62f96}},	//   _субо, isqu, _утса, _seym, 
   {{0x60d6024a,0xdb0e024a,0x29d1af97,0x5efe80a1}},	//   _peym, _bibê, uša_, _शॉट्_, 
   {{0xb4e428b5,0xdb03860e,0xfe7085b6,0x6026257e}},	//   _नये_, _diná, _عدل_, адма, 
   {{0xb4c38a9a,0xdb0e02a5,0x79860093,0x291f804f}},	//   ्री_, _dibê, rokw, _maua_, 
   {{0xfaa5af98,0x2d8b001b,0x7bc9af99,0xdb038efd}},	//   _кало, _akce_, mpeu, _finá, 
   {{0x7d042f9a,0x597604f6,0xbea612a5,0x23bb824a}},	//   tfis, _выпу, равк, _hêj_, 
   {{0x7c2401e2,0x2c0980a1,0x27e0882b,0x63ae2f9b}},	//   tvir, _वहां_, šini_, _sibn, 
   {{0xdee610b5,0xab662bdb,0x7d04007f,0x5ee080cf}},	// [1b00] _копи, авал, rfis, প্টে, 
   {{0x68fbaf9c,0x69de2c83,0x212000bf,0xb4c38f21}},	//   _acud, tspe, _haih_, ्रु_, 
   {{0xbd8a003f,0x7c242f9d,0x399c80fe,0xa3b61493}},	//   _لندن_, svir, híse_, _चूर_, 
   {{0xb4db0028,0x4fc6af9e,0x65662f9f,0x6d430123}},	//   _hoàn, аска, _umkh, _înap, 
   {{0x628e2fa0,0x63ae2fa1,0x44242fa2,0x779482e5}},	//   _wybo, _tibn, _ém_, میرا, 
   {{0x7c2480fe,0x69de2fa3,0x2d9d8027,0xd7078741}},	//   _áiri, pspe, _ahwe_, инче_, 
   {{0x91e3029e,0x25af8a63,0xdb0e016c,0xcb67002d}},	//   _море, _bigl_, _libë, _таре_, 
   {{0x27e9834a,0x7c2d8053,0xa534878a,0x399c80d8}},	//   šana_, _šara, снич, físe_, 
   {{0xef1a8aff,0x60cdafa4,0x973c80d7,0xf8bf00ef}},	//   _има_, ñame, _siću, ndée_, 
   {{0x3b549225,0x3944875d,0xd00f80fe,0x316b0034}},	//   скор, _homs_, _تلك_, wicz_, 
   {{0xe81e825d,0x26dcafa5,0x44e880b2,0x7c2901bb}},	//   पिका_, mavo_, ক্ষক_, _ġerm, 
   {{0x7bc6003b,0x26dcafa6,0x99672fa7,0x2b06070c}},	//   _otku, lavo_, ртол, स्तु_, 
   {{0xb4d2afa8,0x7afc00d7,0xf8bf2fa9,0x2868004c}},	//   वरी_, _ocrt, rcé_, арро_, 
   {{0xe78729da,0x200501bb,0x26dcafaa,0xa5f9216f}},	//   румо, ċli_, navo_, легу_, 
   {{0x139b84fc,0x539b8039,0x629880d7,0x93790a09}},	//   _שבוע, _שיוו, _uzvo, ҳбат_, 
   {{0x3944881e,0x3a2d2fab,0xac190741,0x48670086}},	//   _noms_, _čep_, лобу_, _въоб, 
   {{0x9fe180b2,0x798d0447,0x3f878a08,0xe7ee010c}},	// [1b10] _মঙ্গ, _ikaw, yonu_, _जिया_, 
   {{0xf2c71d8c,0x7bdf02c0,0x26dcafac,0x2ef52fad}},	//   рсан, rsqu, javo_, _узор, 
   {{0xd1b80068,0x26dc8116,0x79a7afae,0x6f150217}},	//   لانا_, davo_, арде, mezc, 
   {{0x3944afaf,0x8c480180,0xc10580fe,0xdb0e06e0}},	//   _coms_, _bağı, صوتي, _libè, 
   {{0xdc35015c,0x656d0112,0x2cbf82d1,0x80c6832d}},	//   _האָט_, miah, vcud_, ाड़े, 
   {{0x8c480186,0x656d2fb0,0x6f152fb1,0x6dbc007e}},	//   _dağı, liah, nezc, _očal, 
   {{0xb87b1877,0x6b52006d,0x291fafb2,0x19ab90ea}},	//   laíd, _mægl, _taua_, _атап_, 
   {{0x798d01c8,0xb4c38dcf,0xe3bf81e0,0x656d2fb3}},	//   _nkaw, ्रे_, íño_, niah, 
   {{0x69c71287,0x212005b5,0x26dc807e,0x3f87afb4}},	//   _htje, _raih_, bavo_, ponu_, 
   {{0xda0e2c63,0x798d2fb5,0x26dc81e9,0x437487c5}},	//   _सहमत_, _akaw, cavo_, жуют, 
   {{0xe69580fe,0x39920019,0x442b0269,0x6f150e7c}},	//   _الاد, lási_, _lrc_, dezc, 
   {{0x6721afb6,0x8c480a08,0xf65282f9,0x7bc9afb7}},	//   _halj, _yağı, _מצב_, ppeu, 
   {{0x4ca580b2,0x6721afb8,0xe81b03b4,0x798d068e}},	//   _গ্রু, _kalj, _पैदा_, _dkaw, 
   {{0x20022fb9,0x69c702cf,0x672180db,0x6d5bafba}},	//   rtki_, _otje, _jalj, lhua, 
   {{0xceb281dc,0xed5a16d2,0xe9d98daa,0xa6e3007f}},	//   לים_, гов_, _ёки_, íðar, 
   {{0xdb038093,0x26dcafbb,0x7afc0265,0xc2128309}},	//   _binç, zavo_, _scrt, _זהה_, 
   {{0x64a32fbc,0xdca30103,0x657603b7,0x7c3bafbd}},	// [1b20] зата, зати, rnyh, nxur, 
   {{0x39448b7e,0x7c2bafbe,0xb05b0172,0xef1a04c7}},	//   _soms_, _mrgr, rbät, _смо_, 
   {{0x260184e0,0x442b00a6,0x6d5b8766,0x26dc8162}},	//   jóo_, _erc_, khua, vavo_, 
   {{0x00da803f,0xd91080dd,0x10a6891a,0x6d5b827e}},	//   ابات_, بیر_, биен, jhua, 
   {{0xdcfb829f,0x7d162fbf,0xdb0e00ef,0x5ec980b2}},	//   jluđ, meys, _libé, _রয়ে, 
   {{0xa09b0273,0x06d880cf,0x6d462fc0,0x7d162fc1}},	//   ניסט, _সাহি, _hoka, leys, 
   {{0x6d462fc2,0xdee68974,0x7c2b811a,0x60c41127}},	//   _koka, _ҳози, _argr, _ofim, 
   {{0x75242fc3,0x2fda840c,0x6d462fc4,0x6fb6807b}},	//   ndiz, _مورد_, _joka, _همرا, 
   {{0xfbaaa45d,0x7524004f,0x3eaa8396,0x6721816c}},	//   лтой_, idiz, _ºbto_, _falj, 
   {{0x69c103e9,0xd00f8f36,0x8c1b0039,0x60c28039}},	//   _élec, _سلم_, נויי, lcom, 
   {{0xd9152353,0x60c904e0,0x6115104c,0x71792af2}},	//   одны, ñemo, одну, ибор_, 
   {{0x27e0805d,0xf53f0172,0x6d5bafc5,0xdb0e0421}},	//   šinu_, _ihåg_, chua, _dibé, 
   {{0xbfb6810b,0xc0581583,0x60dd2fc6,0xd467930c}},	//   _điểm_, бір_, rasm, _лице_, 
   {{0x3f8a2fc7,0x442b02ef,0x6d462fc8,0x26da0149}},	//   gobu_, _rrc_, _aoka, _cepo_, 
   {{0x26da2fc9,0x6d462fca,0x6f1505cb,0x7522840a}},	//   _depo_, _boka, rezc, _kaoz, 
   {{0x22ae808c,0x6d40afcb,0x6a4a808a,0x2b9416f7}},	//   mək_, njma, rəfd, bäck_, 
   {{0x6d9303e9,0x69c712fb,0xb4b9000f,0x656d2fcc}},	// [1b30] nçai, _stje, _चली_, riah, 
   {{0x656d01ac,0xb87b273a,0x6b4d8149,0x6d4606a8}},	//   siah, raíd, _púgi, _eoka, 
   {{0xfbda892c,0x644d0238,0x821500fe,0x50b5a0e2}},	//   _मौसम, syai, تواص, ослу, 
   {{0x39920068,0x6d5bab42,0x6dbc005d,0x752281ac}},	//   tási_, xhua, _očaj, _naoz, 
   {{0x6721999b,0x261b807a,0x6d4080d7,0xf8078123}},	//   _palj, _मनही_, djma, счен, 
   {{0x7c2d8533,0x44291fb4,0xf41f019b,0x2fc90128}},	//   _šaro, mva_, _isä_, _mtag_, 
   {{0x6721803b,0x69c71287,0xe81b282b,0x67238053}},	//   _valj, _utje, _पैसा_, rdnj, 
   {{0x1be9ac0c,0x60c2afcd,0xdd9180fe,0x44292fce}},	//   адии_, ccom, بوع_, ova_, 
   {{0xe3b6ad50,0x7bcd2fcf,0x6721afd0,0x27e080fe}},	//   обы_, npau, _talj, áint_, 
   {{0x44292fd1,0x1957805a,0x6d5b91fb,0x98ad80e9}},	//   iva_, _тағы_, shua, _hneď_, 
   {{0x4427842b,0x4429041a,0x60db80e5,0xdce9abe5}},	//   _گراف, hva_, _keum, lieč, 
   {{0x4429003b,0x6d5b81df,0xdce98a63,0xe43581fa}},	//   kva_, qhua, dneć, _وفاد, 
   {{0x6d462fd2,0x2bb50d6d,0xdce9afd3,0x26da0ca2}},	//   _roka, _अंगा, nieč, _pepo_, 
   {{0x7c29afd4,0x6d462fd5,0xbf9b0077,0x83fd8019}},	//   mver, _soka, stên, rződ, 
   {{0x22ae808c,0xdb0e059e,0x3f8a026b,0x614604bc}},	//   cək_, _bibî, robu_, _мека, 
   {{0xed5708c6,0xdce98116,0x7c29afd6,0x9f46811e}},	//   оос_, kieč, over, iroá_, 
   {{0x06d900cf,0x6d462fd7,0xdb0e02a5,0x0b4604bc}},	// [1b40] _তারি, _voka, _dibî, онан, 
   {{0x6d462694,0x68e9afd8,0x75241c65,0x1b1780b2}},	//   _woka, _aded, sdiz, তাকে_, 
   {{0x7c29917a,0x44292fd9,0xe8220f2c,0x8afc80a1}},	//   hver, ava_, मिका_, mięt, 
   {{0x60c295b7,0x7c29afda,0x629c20c9,0xf1a9803d}},	//   ucom, kver, _vzro, مانه_, 
   {{0xb4d62fdb,0x7c29afdc,0x88169b1d,0x68e9afdd}},	//   हरी_, jver, تباط, _dded, 
   {{0x05ea9e45,0x60c2afde,0xe3a785b6,0x8afc80a1}},	//   афии_, scom, _زر_, nięt, 
   {{0xd6d9afdf,0xda0e0938,0x629c003b,0xd5b7af88}},	//   сті_, _सहित_, _uzro, осы_, 
   {{0x7c290043,0x29002fe0,0x7c29afe1,0x201f82ef}},	//   _šeri, _ncia_, fver, _fsui_, 
   {{0x7c29afe2,0x8d5b03f3,0x8b6680d8,0x2124afe3}},	//   gver, יכקי, قادم, _iamh_, 
   {{0xb4d61470,0xeb4aafe4,0x3f7680a1,0xa3dc2347}},	//   हरु_, рчик_, dług_, णीय_, 
   {{0x2b4783e9,0x79950f6c,0x06d900b2,0x2c0600b2}},	//   _donc_, зинф, _তালি, রিয়ে_, 
   {{0x81bc834a,0xb4b9023b,0x22ae8816,0x44292fe5}},	//   lvēk, _चले_, rək_, yva_, 
   {{0x2006afe6,0xdb0381b2,0x22ae8829,0x3205885d}},	//   ntoi_, _jinû, sək_, atly_, 
   {{0x6d932fe7,0xdefb2fe8,0x21248304,0x7c3b0a1c}},	//   nçav, шым_, _lamh_, _àuri, 
   {{0xb4d60baf,0xd25080fe,0xc4db04c7,0x3205afe9}},	//   हरू_, _سنة_, иђа_, ctly_, 
   {{0x21248097,0xb87b02fd,0x395d81df,0x6ecb29eb}},	//   _namh_, raíb, xhws_, _त्रु, 
   {{0x29192fea,0x4c94019b,0x0cab0847,0x94ab1560}},	// [1b50] mesa_, дитс, ртви_, ртва_, 
   {{0x29192feb,0x60dbafec,0x6f188934,0x7bcd00cc}},	//   lesa_, _seum, jevc, rpau, 
   {{0x3915afed,0x92681102,0x44292fee,0x7bcd0116}},	//   змер, орца_, sva_, spau, 
   {{0x68fd1956,0x28f88765,0xdb0b810d,0x7c29851d}},	//   ngsd, жець_, _utgö, yver, 
   {{0x25a92fef,0x67250079,0x3949011e,0xdb1baff0}},	//   mmal_, _kahj, _moas_, squé, 
   {{0x9a8728fc,0x7c29aff1,0x29192ff2,0x3949058f}},	//   _дубл, vver, hesa_, _loas_, 
   {{0xd90f8068,0x63bd2ff3,0x2006aff4,0x7c29893c}},	//   _لیا_, _husn, atoi_, wver, 
   {{0x25a902ae,0x29192ff5,0x67250e53,0xea000106}},	//   nmal_, jesa_, _lahj, _hiếp_, 
   {{0x29192ff6,0xc10480fe,0x7c2980ef,0x657e80ef}},	//   desa_, _توقي, uver, épha, 
   {{0x63bd1552,0x25a901ed,0x7d0988b6,0x290001e9}},	//   _musn, hmal_, sfes, _scia_, 
   {{0x29192ff7,0x39490569,0x25a92ff8,0x29000149}},	//   fesa_, _boas_, kmal_, _pcia_, 
   {{0x39490659,0x29192ff9,0x7c29affa,0x9f42001b}},	//   _coas_, gesa_, pver, mské_, 
   {{0x63bd01df,0xdb03affb,0x9f420410,0x63bb01e0}},	//   _nusn, _minú, lské_, _éunh, 
   {{0x442fac66,0x00000000,0x00000000,0x00000000}},	//   _irg_, --, --, --, 
   {{0x9f4203e0,0x6da62ffc,0x2bb5000f,0x442f82fa}},	//   nské_, зива, _अंजा, _hrg_, 
   {{0xf992007b,0x7ae1affd,0x442f8a11,0x63bd0324}},	//   _ثبت_, lalt, _krg_, _busn, 
   {{0x29c18028,0x27e9affe,0xaaba0a85,0xb4662a4c}},	// [1b60] _hóa_, šanj_, مدار_, чкал, 
   {{0xdb0b811e,0x8b231d65,0xed160034,0xdb1d0610}},	//   _augú, ндуе, _łódź_, _husê, 
   {{0x63b50e02,0x9f420170,0xdb19847f,0xb6bb0309}},	//   _dizn, jské_, _cuwé, _לציי, 
   {{0x7ae1afff,0x2d8081ac,0xa6d880b2,0x63bd3000}},	//   halt, čiek_, _সাইট, _fusn, 
   {{0x1818807b,0x7ae18f10,0x63bd02ef,0xdb19868e}},	//   تراک_, kalt, _gusn, _tuwè, 
   {{0xbb4a0013,0x7bcb2f9c,0x291902ee,0x2006b001}},	//   _الآن_, ígue, zesa_, rtoi_, 
   {{0x7ae19047,0x442f84a5,0x6f188e02,0x29193002}},	//   dalt, _arg_, revc, yesa_, 
   {{0x6d440d77,0x442f8a00,0xd90d8267,0x7cf68a08}},	//   njia, _brg_, _نیم_, dürü, 
   {{0x9f5900f9,0x29193003,0x06e200b2,0x63bd04da}},	//   ltså_, vesa_, _বানি, _xusn, 
   {{0x442f8a3e,0x44223004,0x3254b005,0x68e283ec}},	//   _drg_, _msk_, двор, laod, 
   {{0x442f82da,0xc3330377,0x29193006,0x6d5609ec}},	//   _erg_, גות_, tesa_, kkya, 
   {{0x26de8786,0x463b80c6,0x7ae19562,0x68e2b007}},	//   _heto_, _לעבע, aalt, naod, 
   {{0x26de80f8,0x7ae1b008,0x24aa80b2,0x63603009}},	//   _keto_, balt, _গ্রহ, _göng, 
   {{0x27e683e9,0xd370807b,0x7ae1b00a,0xbb43974b}},	//   ison_, _جهت_, calt, _печк, 
   {{0x39920019,0x2919300b,0x63b50284,0x2cb900db}},	//   tást_, pesa_, _rizn, _pgsd_, 
   {{0x26deb00c,0x63b50103,0x9cfa85a2,0x5d9901e2}},	//   _leto_, _sizn, _আসুন_, ікаў_, 
   {{0x68ed300d,0x68e2b00e,0x25a9300f,0x27e68bbe}},	// [1b70] _idad, daod, rmal_, json_, 
   {{0x02a70ee7,0x6d5f0daa,0x8aa705e9,0x25a901ed}},	//   прем, shqa, пред, smal_, 
   {{0x2b0e8023,0x60cda6a2,0x98bf8123,0xfe1b8439}},	//   त्यु_, ñamo, _nouă_, _भैंस_, 
   {{0x1a680f2a,0x63bd3010,0x9f42026b,0x7c22b011}},	//   سیقی_, _tusn, vské_, _osor, 
   {{0x26deb012,0xea00010b,0xbcfb0065,0x7d0d3013}},	//   _beto_, _tiếp_, _alég, mfas, 
   {{0x9f42003e,0x7c2d3014,0xe73691e3,0x61fa83ec}},	//   tské_, mvar, деш_, kutl, 
   {{0x7ae1b015,0x442fb016,0x26de80bf,0xa3df8758}},	//   valt, _srg_, _deto_, धीन_, 
   {{0x7d0d20ee,0x98bf802d,0x27e9028d,0x9f42027b}},	//   nfas, _două_, _ovan_, rské_, 
   {{0x6b5f82a5,0xb4bd8365,0x7ae1b017,0x7c2d3018}},	//   _lêge, _आली_, talt, nvar, 
   {{0x6360046b,0x04ff80b2,0x68ed0889,0x7cf68085}},	//   _gönd, ্যের_, _adad, türü, 
   {{0x7c22b019,0x27e906e0,0x6d5d0960,0x987000e9}},	//   _esor, _avan_, _olsa, rúča_, 
   {{0x7ae1a89c,0x442f87ad,0x29e78c61,0xdb060065}},	//   salt, _trg_, rđa_, _yukó, 
   {{0x7ae1b01a,0xeb8eb01b,0x442fb01c,0x7d1b8429}},	//   palt, _аи_, _urg_, meus, 
   {{0xdfcf0013,0x6d4b97e4,0x442db01d,0x61fab01e}},	//   شيف_, _hoga, mve_, butl, 
   {{0xab28846d,0xdb1b9877,0x7d0d301f,0x7c2d0162}},	//   _رسول_, nquí, ffas, evar, 
   {{0x7529b020,0x6d4bb021,0x78bb822d,0xe5a32da0}},	//   ndez, _joga, _nguv, виси, 
   {{0x9f5faf9c,0x63600172,0x7c2d3022,0x2fcd822a}},	// [1b80] _aquí_, _löne, gvar, _nteg_, 
   {{0x7d1bad71,0xdcdaa93f,0xa3df83ff,0x64a4004a}},	//   heus, _यज्ञ, धीय_, даға, 
   {{0x75263023,0xc87f02ae,0x7d1bb024,0x6d4b9d1a}},	//   _takz, raße_, keus, _ooga, 
   {{0x63603025,0x98a086e2,0xa49b0a1c,0x6f1c3026}},	//   _sönd, žič_, _icòn, lerc, 
   {{0xd0108275,0x44223027,0xa3f880b2,0x442d80f8}},	//   الت_, _usk_, _অন্য_, jve_, 
   {{0x27e6896b,0x60c9b028,0x442003b5,0x7d0294c8}},	//   rson_, _efem, mwi_, _scos, 
   {{0xe1e7811d,0x442db029,0x26deb02a,0x656f0324}},	//   _جس_, eve_, _veto_, _ymch, 
   {{0x6f1c302b,0x636007fa,0x6d4b9b0d,0xfaa304bc}},	//   herc, _döne, _coga, _расо, 
   {{0x26deb02c,0xe3bf01e0,0xea000106,0x4420011a}},	//   _teto_, _xuñ_, _khắp_, nwi_, 
   {{0x6d930803,0x68e0b02d,0x2912034e,0x61fab02e}},	//   nçar, _hemd, _abya_, tutl, 
   {{0x6d4bb02f,0x7d2780f9,0x442db030,0xdd8fb031}},	//   _foga, örsä, ave_, _аш_, 
   {{0x7d1b8380,0x442db032,0x68e08269,0x7c2281cb}},	//   ceus, bve_, _jemd, _tsor, 
   {{0xab2a9225,0xf7730851,0x7c228f64,0x442000bb}},	//   _мода_, ناس_, _usor, jwi_, 
   {{0x636007fa,0x6f1c3033,0x44203034,0x6d4bb035}},	//   _yöne, gerc, dwi_, _zoga, 
   {{0x672880f8,0xb87b288d,0x7d0d25b3,0x7dc782d2}},	//   _madj, caín, tfas, _kısa, 
   {{0xbcfb3036,0x6d4b8659,0x06e200b2,0x68ed3037}},	//   _amér, _xoga, _বাণি, _udad, 
   {{0x97a727d3,0x7d0d3038,0x6f1c3039,0xb87b00fe}},	// [1b90] _орол, rfas, berc, maío, 
   {{0x6f1c303a,0x67288a06,0xb87b0013,0xe5c7303b}},	//   cerc, _nadj, laío, _осмо, 
   {{0x2fcdb03c,0x442db03d,0x2bdf070c,0x7d1bb03e}},	//   _steg_, zve_, _पौरा, yeus, 
   {{0xb4bd8365,0x8aa422f7,0x63b894cf,0xb87b00fe}},	//   _आले_, труд, _livn, naío, 
   {{0xe739b03f,0x27e9b040,0xdd910068,0x6d4b9567}},	//   зел_, éan_, _لوگ_, _roga, 
   {{0x25a68019,0x6d4bb041,0x212909fb,0xb87b00d8}},	//   _ahol_, _soga, _laah_, haío, 
   {{0xf7708743,0x995c803e,0x7ae53042,0xe61182e5}},	//   جان_, síš_, maht, اشت_, 
   {{0x442db043,0x6f1c003e,0x6934b044,0x9425a589}},	//   tve_, zerc, _инсу, емие, 
   {{0x442db045,0x291db046,0x7d1bb047,0x75298019}},	//   uve_, mewa_, reus, rdez, 
   {{0x291d822d,0x4a4586a1,0x1b1d00cf,0x7d1bb048}},	//   lewa_, енов, নাকে_, seus, 
   {{0x44203049,0x63b88524,0x442db04a,0x6d4b8015}},	//   zwi_, _divn, sve_, _toga, 
   {{0x2fc00741,0x9952026b,0x25b919a4,0x291d8232}},	//   _puig_, sáž_, _nisl_, newa_, 
   {{0x25adb04b,0x394d87b8,0xdbd7041a,0xf1b9ab66}},	//   mmel_, _moes_, _jäät, _miš_, 
   {{0x7ae518c5,0x291d9e0d,0xf62629df,0x442006e4}},	//   jaht, hewa_, ндго, vwi_, 
   {{0x699624b1,0x59b9807a,0xba5280fe,0x39990019}},	//   _прих, _ईंटर, _منوع, zési_, 
   {{0xa0a6304c,0xb87b0013,0xa2cd092c,0xf1b98024}},	//   _пайд, caío, दुस्, _niš_, 
   {{0x248604e0,0xac860f9c,0x291db04d,0x2bdb001b}},	// [1ba0] çom_, хгал, dewa_, मीला, 
   {{0x395fb04e,0xe6258028,0x442010b6,0x6b5200c0}},	//   _alus_, _đông_, rwi_, _nægt, 
   {{0x26d8304f,0xa2a50560,0x6728b050,0x68e0982d}},	//   mbro_, _करण्, _radj, _pemd, 
   {{0x29020572,0x8c461639,0x39990019,0x67288bfc}},	//   ngka_, _земе, tési_, _sadj, 
   {{0x394db051,0xdb1881b2,0x6728b052,0xea00012f}},	//   _does_, _divê, _padj, _thắp_, 
   {{0x2d800066,0x69dc0432,0x6720054d,0x395fb053}},	//   lnie_, _twre, मजिक_, _elus_, 
   {{0xfaa304c9,0x56938613,0x6383009f,0x395f81bb}},	//   _баро, лашт, _сгра, _flus_, 
   {{0x291d8111,0xd00a90c3,0x248681e0,0xa53480cb}},	//   cewa_, _небе_, _pxom_, тнич, 
   {{0x9f8688cf,0x63b89b67,0xfbcf815e,0x21290050}},	//   _згад, _pivn, یتی_, _raah_, 
   {{0x5a348e29,0x7c3b1355,0x2d803054,0x3f850c0e}},	//   внот, _áure, hnie_, čluk_, 
   {{0x7d0608b4,0x28f920f2,0xb87b00fe,0x3f911144}},	//   _ocks, мень_, taío, vozu_, 
   {{0x25d9840c,0xea00010b,0x7c263055,0xa3c0000d}},	//   _آهنگ_, _nhập_, _oskr, ँदा_, 
   {{0x2d800066,0xdd8f8158,0xb87b00fe,0xd8380bee}},	//   dnie_, _اون_, raío, нэр_, 
   {{0x4426b056,0x61fe003b,0x2d8000a1,0xb87b00fe}},	//   _iso_, kupl, enie_, saío, 
   {{0xbe883057,0x249f008d,0xdb03801b,0x59b09ede}},	//   есте_, _šum_, _jiný, जगार, 
   {{0x2d803058,0x65640318,0xba9b8039,0xb7c502bb}},	//   gnie_, ghih, _מסוי, _ироқ, 
   {{0x4426808d,0x26d802fb,0x7ae51998,0x24180193}},	// [1bb0] _jso_, bbro_, taht, ноты_, 
   {{0x6d5a08fb,0xd6db3059,0x2d800034,0x6e2500bc}},	//   ëtar, _эти_, anie_, _tshb, 
   {{0xf7718c0b,0x395fa65e,0x6e250004,0xa4d90f4c}},	//   یات_, _plus_, _ushb, _одну_, 
   {{0xdbd7036d,0x44268124,0x60b59fbc,0x2d8000a1}},	//   _päät, _oso_, نمائ, cnie_, 
   {{0xb8e9807a,0xbcfb02ba,0x7ae5036d,0x291db05a}},	//   _ईल_, _eléc, paht, rewa_, 
   {{0x394d81b0,0x291db05b,0x6d4f0214,0x2129884c}},	//   _woes_, sewa_, _hoca, žah_, 
   {{0x4426b05c,0x291da91b,0x6d4f305d,0x6b52006d}},	//   _aso_, pewa_, _koca, _vægt, 
   {{0x69c78f6a,0x7415846d,0x1da71461,0x6a4a82d1}},	//   íjem, نوعا, _कीमत, rəfl, 
   {{0x5184b05e,0xc98482bb,0x26cc8027,0x3b8583ad}},	//   _сура, _сури, _ffdo_, клиг, 
   {{0x6d5c8093,0x2d8025cf,0x799d01ed,0x6b5201c2}},	//   _îran, znie_, elsw, _hægr, 
   {{0x44269e3a,0x96ca8562,0x36d48008,0x68e60473}},	//   _eso_, _स्टॉ, _сохр, takd, 
   {{0x27e9834a,0x29028172,0x4ad1871c,0x6dbc13a5}},	//   šanu_, _ökat_, _द्रव, _očar, 
   {{0xf1b28fcc,0xd24e80dd,0x8b25b05f,0x6444011e}},	//   יסט_, منی_, _адле, xxii, 
   {{0x06e200b2,0x7bc002fd,0x3ebe07c5,0x6d5ba986}},	//   _বাহি, _émui, øtt_, lkua, 
   {{0x6d4f3060,0xdee311fa,0x2d800066,0xfce60175}},	//   _boca, роси, tnie_, ково, 
   {{0x7ae3b061,0x2bc3101e,0x6d5bb062,0x26d83063}},	//   _hent, _वंशा, nkua, sbro_, 
   {{0xc9530052,0x69c3b064,0x78a40524,0xe3ba1afe}},	// [1bc0] _כמה_, _hune, _uziv, дба_, 
   {{0x7ae3b065,0x69c3ae6a,0x27e00106,0xe3633066}},	//   _jent, _kune, _iwin_, акуи, 
   {{0x6d4f0013,0x69c3b067,0x6dbc0bfc,0xdb1886e0}},	//   _foca, _june, _včas, _divè, 
   {{0x69c3b068,0x61fe3069,0x3f858269,0x727902bb}},	//   _mune, rupl, _ajlu_, хсус_, 
   {{0x69c3b06a,0xf7468003,0xdb0bb06b,0x7c26005d}},	//   _lune, кедо, _bugü, _uskr, 
   {{0x68e40d76,0x7d04306c,0x7ae3b06d,0x6d4f0685}},	//   _leid, lgis, _nent, _zoca, 
   {{0x91e3306e,0x27ed8052,0x69c38181,0x752b8a63}},	//   _восе, _even_, _nune, _bagz, 
   {{0x68e4011a,0x443200de,0x59b4864e,0x6d4f306f}},	//   _neid, ovy_, _сөзс, _xoca, 
   {{0x7ae39fe1,0x63bc3070,0x7c2401ab,0x27ed81f7}},	//   _bent, _kirn, nwir, _gven_, 
   {{0x69c3b071,0x63bc02a1,0x3a2780db,0x4426807e}},	//   _bune, _jirn, _bsnp_, _vso_, 
   {{0x68e43072,0x21791747,0x69c381e9,0x7ae3a016}},	//   _beid, ейны_, _cune, _dent, 
   {{0x442681ea,0x4ba4804a,0x7c241453,0x7ae3aeed}},	//   _tso_, _өлең, kwir, _eent, 
   {{0x7ae3b073,0x58870ff9,0x68e40c9f,0x60cd8728}},	//   _fent, тына, _deid, ñami, 
   {{0x7ae3b074,0x6562b075,0x63bc0a63,0x629c013b}},	//   _gent, _hloh, _nirn, _oyro, 
   {{0xe5c43076,0xd3788533,0x68e40013,0x69c3b077}},	//   исто, mić_, _feid, _gune, 
   {{0x7ae3b078,0x798280a1,0x7d043079,0x9f59026b}},	//   _zent, jnow, ggis, musí_, 
   {{0x63bc307a,0x6c54307b,0x752d307c,0x7c24037a}},	// [1bd0] _birn, акту, rdaz, gwir, 
   {{0x7ae38659,0x629c307d,0x68e40d00,0x7d04307e}},	//   _xent, _byro, _zeid, agis, 
   {{0x3f830533,0xdb050013,0x27edb07f,0x6562b080}},	//   mnju_, gmhá, _sven_, _oloh, 
   {{0xd378861e,0x6d4f0269,0x7c24029a,0x9f4203d5}},	//   hić_, _uoca, bwir, mská_, 
   {{0xd3788025,0x7ae8b081,0x629c0bed,0x9f4205e1}},	//   kić_, kadt, _eyro, lská_, 
   {{0xd378803a,0x6562b082,0x66e284bc,0x2d868027}},	//   jić_, _aloh, боша, _ajoe_, 
   {{0x63603083,0xd378803a,0x9f42003e,0x2d550142}},	//   _könn, dić_, nská_, _fået_, 
   {{0xdb1d0a93,0x2d550142,0xb8b3804a,0x661a8766}},	//   _musí, _gået_, _көлі, _dptk, 
   {{0x7ae384e4,0x6d5bb084,0x69c3b085,0x3f8313e0}},	//   _pent, rkua, _sune, knju_, 
   {{0xd378861e,0xe9d99081,0x29028172,0x69c481ac}},	//   gić_, нко_, _ökar_, _čier, 
   {{0x3f83003a,0xc3320273,0xdb1c024a,0xdb03860e}},	//   dnju_, זוי_, _birê, _sinó, 
   {{0x69c38105,0x2909122b,0x7412803d,0x9f420170}},	//   _vune, _ccaa_, جویا, dská_, 
   {{0x68e42c6a,0xdb1c02a5,0xd3788dd6,0xe9e980e9}},	//   _veid, _dirê, bić_, dnúť_, 
   {{0x68e41013,0x44323086,0xd37880a1,0x2d993087}},	//   _weid, vvy_, cić_, _akse_, 
   {{0x68e43088,0x39990019,0x2bdfa8b5,0x31790034}},	//   _teid, tést_, पीरा, bisz_, 
   {{0xdb1c02a5,0x63bc3089,0x96d4122f,0x2d961747}},	//   _girê, _sirn, _ब्रॉ, ургс, 
   {{0x09cc009b,0x3f832e70,0x9db9004a,0x629c1cb1}},	// [1be0] ाऱ्य, bnju_, тыру_, _syro, 
   {{0x7c24308a,0x4432308b,0xfbcd00b2,0x87260008}},	//   rwir, rvy_, _লিখত, _смож, 
   {{0xe8fab08c,0x2002308d,0x7c24308e,0x64400a63}},	//   еле_, luki_, swir, _šmid, 
   {{0xdb1882a5,0x629c027b,0xd3788dd6,0x786a8019}},	//   _nivî, _vyro, zić_, _növé, 
   {{0x4424044e,0x63bc308f,0x20023090,0xe3c88106}},	//   _èm_, _tirn, nuki_, _mực_, 
   {{0xe3c88028,0xdb1c00f8,0x31668019,0x96a8001b}},	//   _lực_, _mirë, shoz_, _गराउ, 
   {{0xd378803a,0x6b63163a,0xd6d9b091,0xb90a80cf}},	//   vić_, _укра, тті_, _মা_, 
   {{0x7bc63092,0xdb1881b2,0x3f830081,0x1db40365}},	//   _kuku, _civî, znju_, ंगित, 
   {{0xd378803b,0x2167b093,0x7bc63094,0xe64483d2}},	//   tić_, _сити_, _juku, ılığ, 
   {{0x96d43095,0x20023096,0x7bc601ca,0x39403097}},	//   _ब्लॉ, duki_, _muku, _anis_, 
   {{0xd378803b,0x7bc63098,0xdb0380fe,0x3f833099}},	//   rić_, _luku, _ghní, vnju_, 
   {{0x2ee5863c,0x40351878,0xe3c88028,0x9f42026b}},	//   _zelf_, аемс, _cực_, vská_, 
   {{0x8d938013,0x3f830024,0x7bc6309a,0x69c100ef}},	//   _النش, tnju_, _nuku, _élev, 
   {{0x9f42026b,0x317900a1,0x28e3012e,0x636001fb}},	//   tská_, sisz_, परहि, _sönn, 
   {{0x58d50574,0x31790066,0x3f830131,0x539b8eee}},	//   _койт, pisz_, rnju_, _ריוו, 
   {{0x7bc6309b,0x58392452,0x3f83029f,0x9f42026b}},	//   _buku, _азия_, snju_, rská_, 
   {{0x7bc6077e,0x3f8317fc,0x80cd85a2,0x3375309c}},	// [1bf0] _cuku, pnju_, ারম্, агар, 
   {{0x7bc6309d,0x9f4200ac,0x332e837f,0xa3e68a9a}},	//   _duku, pská_, _jafx_, यीय_, 
   {{0xfaa7309e,0x212d8120,0xb4db0097,0xe9e98033}},	//   ушан, _paeh_, _cnàc, pnúť_, 
   {{0xdc34026b,0x27ed0131,0x38358196,0x2ee58039}},	//   _zúča, šenu_, инер, _self_, 
   {{0x7bc61c0a,0x3b0a0a1c,0x50458495,0x63600829}},	//   _guku, _fcbq_, релб, _könl, 
   {{0xdb188093,0x6d4d309f,0x29068109,0xb0d580da}},	//   _sivî, ljaa, agoa_, _ड्रग, 
   {{0xf1a785e9,0x7bc601ed,0xd056008a,0xf1c98106}},	//   _бран, _zuku, _deyə, _mạc_, 
   {{0x442b30a0,0x6d4d28c3,0xf1c98028,0x528400fe}},	//   _ksc_, njaa, _lạc_, _الفك, 
   {{0x6fb985c2,0x7bc62c66,0xab65b0a1,0x2ee5b0a2}},	//   _агар_, _xuku, ивил, _telf_, 
   {{0xce6b9afe,0x69c730a3,0xd7a4000f,0x68eb84fb}},	//   _пред_, _kuje, _खींच, lagd, 
   {{0x216a2437,0x6723898f,0xa96a130c,0x443930a4}},	//   вини_, menj, вина_, _lrs_, 
   {{0x69c704ba,0x67238bfc,0xdc3401ac,0x442b00f6}},	//   _muje, lenj, _súča, _osc_, 
   {{0x6603b0a5,0xe3c88028,0x25e30562,0xf1c9801c}},	//   lunk, _vực_, टीसी_, _bạc_, 
   {{0x7bc630a6,0xdee328a7,0x6723b0a7,0x66e30103}},	//   _ruku, жори, nenj, жора, 
   {{0x7bc630a8,0x13da80cf,0x200205b5,0x6603b0a9}},	//   _suku, _দিয়, suki_, nunk, 
   {{0x7bc60a97,0x6723b0aa,0x64468172,0x394030ab}},	//   _puku, henj, åkig, _unis_, 
  
   {{0x6723b0ac,0x644984e0,0x69d50124,0x6603933e}},	// [1c00] kenj, nxei, _atze, hunk, 
   {{0x6603b0ad,0x4439097e,0xaaba0267,0x6569b0ae}},	//   kunk, _drs_, ندار_, hheh, 
   {{0x443930af,0x7ae730b0,0x69c70053,0x6723882b}},	//   _ers_, _dejt, _cuje, denj, 
   {{0x7bc62b58,0xe3c8801c,0xdb0f293e,0x443930b1}},	//   _tuku, _lựa_, _bucó, _frs_, 
   {{0x33d530b2,0x6a4a8816,0x2906b0b3,0x38609853}},	//   _гіст, rəfi, rgoa_, áir_, 
   {{0x752f00a1,0x6723b0b4,0x25e3010c,0x78a98269}},	//   _zacz, genj, टीवी_, _dzev, 
   {{0x69c18549,0x25fd8fec,0x7c2d8f07,0x9f590035}},	//   _रंगी, रंगी_, _šarp, ursé_, 
   {{0x3f98001b,0xdb1c2303,0xa6e9801c,0x7ae730b5}},	//   horu_, _sirè, _ngươ, _zejt, 
   {{0x442b011e,0x6723b0b6,0xdb0730b7,0x69c70269}},	//   _xsc_, benj, _gijó, _zuje, 
   {{0x4aaa30b8,0x6723803a,0x69c0b0b9,0x7c398128}},	//   _कराव, cenj, _hime, _drwr, 
   {{0x69c10068,0x195905bc,0x69c0b0ba,0x777c08c6}},	//   _élet, ганы_, _kime, dirx, 
   {{0x506730bb,0xf1c98106,0x69c0b0bc,0x2c5e00f3}},	//   атга, _sạc_, _jime, _kādā_, 
   {{0xb8cf0416,0x938a809f,0x8ca20de3,0x6d4281cb}},	//   _कर_, _иска_, _खरगो, _inoa, 
   {{0x69c0b0bd,0x3f98029f,0x09d700b2,0x6d4d00fa}},	//   _lime, goru_, _হিসা, wjaa, 
   {{0x7ae730be,0x752f0034,0xdef801e2,0xa1871b75}},	//   _rejt, _pacz, шыя_, _выпл, 
   {{0x81c40a87,0x69c0b0bf,0x672380d7,0x442b00a6}},	//   _এবং_, _nime, zenj, _psc_, 
   {{0x69c730c0,0x6d4d30c1,0x628e0004,0x61fe1185}},	// [1c10] _suje, rjaa, _axbo, erpl, 
   {{0x34a7023b,0x69c0b0c2,0x443930c3,0x2418104c}},	//   _खरीद, _aime, _vrs_, рофы_, 
   {{0x69c0b0c4,0x5f00800f,0x6723b0c5,0x6d42b0c6}},	//   _bime, _राज्_, venj, _onoa, 
   {{0xdd86840c,0x98a98533,0x443930c7,0xdb0f0149}},	//   _رو_, žač_, _trs_, _pucó, 
   {{0x7ae70038,0x443930c8,0x6723884c,0xe8f8ab8b}},	//   _tejt, _urs_, tenj, рлі_, 
   {{0x442930c9,0x2fc901ea,0x69c730ca,0x6603abf0}},	//   mwa_, _muag_, _tuje, tunk, 
   {{0x6723829f,0x442930cb,0x2fc901ea,0xdb1c024a}},	//   renj, lwa_, _luag_, _kirî, 
   {{0x67238259,0x6603b0cc,0x99858013,0xf8bf30cd}},	//   senj, runk, _الرو, ndés_, 
   {{0xeb99b0ce,0x442930cf,0x1c429878,0x681a80f3}},	//   лии_, nwa_, зным, gādā, 
   {{0x69c0a2d8,0x6569b0d0,0x442930d1,0x68e986b5}},	//   _zime, sheh, iwa_, _heed, 
   {{0x442930d2,0xb6358275,0xed358166,0x657bb0d3}},	//   hwa_, _دفاع, _гэлэ, piuh, 
   {{0x442930d4,0x68e9840a,0x3b848741,0xce68924a}},	//   kwa_, _jeed, йлөг, _труд_, 
   {{0x343881a1,0xa2e800cf,0x68e9b0d5,0x2fc901c8}},	//   _پسند_, _পাসও, _meed, _cuag_, 
   {{0x59cf8a4d,0x442930d6,0x50d80f5a,0x98a08a5a}},	//   _संपर, dwa_, _भ्रष, žić_, 
   {{0xdb1c01b2,0x442930d7,0x7c298461,0x66e6004a}},	//   _birî, ewa_, lwer, _қона, 
   {{0xbf9b03b8,0x68e98039,0x442930d8,0x3f9830d9}},	//   quên, _need, fwa_, soru_, 
   {{0x442930c9,0x69c0b0da,0x7c298a45,0x75242cc6}},	// [1c20] gwa_, _rime, nwer, reiz, 
   {{0x69c0a71f,0x06e200b2,0x290d8123,0x2b43055a}},	//   _sime, _বাকি, _acea_, _cnjc_, 
   {{0xcf57004d,0xe1fa30db,0xe80a807a,0x442930dc}},	//   _הבית_, уге_, हूना_, awa_, 
   {{0x44290557,0xdb1c059e,0xb4e692b9,0x7c29b0dd}},	//   bwa_, _girî, _बजे_, kwer, 
   {{0x7bcfa8b6,0x69c0b0de,0x7d09953f,0x63600172}},	//   ícul, _vime, dges, _jönk, 
   {{0x69dab0df,0xaa4630e0,0xb4c28353,0x8bff85a2}},	//   ypte, _легл, ्ड्_, ্বান_, 
   {{0x69c0b0e1,0x68e9b0e2,0xf8bf0f5b,0x6b6330e3}},	//   _time, _feed, ndér_, _экра, 
   {{0x7c29b0e4,0xf3f88004,0xdb18860e,0xea00001c}},	//   fwer, аниш_, _viví, _chấp_, 
   {{0x7866a4c6,0x7c29b0e5,0x8066920f,0xa6c000b2}},	//   _указ, gwer, _уваж, ্রিয়, 
   {{0x681a8029,0x6e3caa62,0x261900a1,0x7d09b0e6}},	//   rādā, _árbo, _पहली_, ages, 
   {{0x442930e7,0x6b9b00c6,0xcb9b1176,0x213202ef}},	//   zwa_, רשיד, רסיט, _bayh_, 
   {{0xd90f1692,0x7c29b0e8,0x442930e9,0x2fc901c8}},	//   ریخ_, bwer, ywa_, _puag_, 
   {{0x34a7009b,0x2fc901df,0xf8baa9eb,0x91ca80c3}},	//   _खरेद, _quag_, ेशिय, _संवै, 
   {{0x44290206,0x2fc9006c,0xd7f8019b,0x69dab0ea}},	//   vwa_, _vuag_, щую_, ppte, 
   {{0xf1c98028,0x7aea802d,0x44290208,0x4b7b8eee}},	//   _hạn_, _ieft, wwa_, _תאוו, 
   {{0x442930eb,0x7aeab0ec,0x2fc930ed,0x46d90353}},	//   twa_, _heft, _tuag_, _ब्रह, 
   {{0x68e9b0ee,0xd05d0816,0xf8bf30ef,0x442930f0}},	// [1c30] _reed, yasə, rdés_, uwa_, 
   {{0x442930f1,0x7aea803b,0x69cab0f2,0xf1c98106}},	//   rwa_, _jeft, _kufe, _mạn_, 
   {{0x442930f3,0x9d190123,0x201f8123,0x7d0986a4}},	//   swa_, _конт_, _spui_, yges, 
   {{0x69ca8edc,0xe7050267,0x442930f4,0x3f9eb0f5}},	//   _mufe, _اسکی, pwa_, _aktu_, 
   {{0x1fb993c9,0x442930f6,0x260681d1,0xf1c9801c}},	//   алды_, qwa_, सूसी_, _nạn_, 
   {{0xe739a52f,0x7c2f0574,0x7aeab0f7,0x45d5828e}},	//   рек_, _iscr, _neft, оцит, 
   {{0x7d098ec7,0x636d8ca1,0x7c299752,0x68e982f4}},	//   tges, _húng, wwer, _teed, 
   {{0xf1c98147,0xed5984c9,0xf7739272,0x7c29b0f8}},	//   _bạn_, рои_, _کار_, twer, 
   {{0x7d09b0f9,0x69d8acbb,0x7c2981f0,0x25fd903a}},	//   rges, _atve, uwer, रूजी_, 
   {{0x7c29b0fa,0x7d09b0fb,0x6d9330fc,0x32058170}},	//   rwer, sges, lħad, tuly_, 
   {{0xdce2803b,0xea00001c,0x2d891155,0xe12630fd}},	//   _zloč, _thấp_, knae_, омни, 
   {{0x26138077,0x24198008,0xdb0180ef,0x7bdbb0fe}},	//   mão_, _воды_, illé, ppuu, 
   {{0x656d003d,0x26138077,0xb87b0207,0xafe30103}},	//   dhah, lão_, daís, моял, 
   {{0x88ba8039,0x78ad0bbe,0x53349938,0xfe4616dd}},	//   יזרי, _dzav, _нечт, онго, 
   {{0x3ebe30ff,0x443db100,0x7bcbb101,0x261382fd}},	//   ätt_, _hrw_, _hugu, não_, 
   {{0x7bc38e3b,0x7bcbaae2,0x656d02b7,0x2d8902fa}},	//   _hinu, _kugu, ghah, gnae_, 
   {{0x7bcbb102,0x64a33103,0x7bc3b104,0x261382fd}},	// [1c40] _jugu, дата, _kinu, hão_, 
   {{0xaac986df,0xdb188019,0x7bcbb105,0x7bc39ae2}},	//   रशिक, _kivá, _mugu, _jinu, 
   {{0x442f82fa,0x261382fd,0x7bcbb106,0x2d9e0035}},	//   _lsg_, jão_, _lugu, îtes_, 
   {{0xdce285c3,0x26138077,0x8c461a72,0x02aa1352}},	//   _ploč, dão_, _деме, _करीन, 
   {{0x6b9a8daa,0x274a80b5,0x2eeeb107,0x6d463108}},	//   yotg, ичко_, taff_, _inka, 
   {{0x442202fa,0x7bc3b109,0x29d7037f,0x26138432}},	//   _ipk_, _ninu, _bħad_, fão_, 
   {{0x7bcbac62,0x2eeeb10a,0x261383b8,0xf1c9801c}},	//   _augu, raff_, gão_, _sạn_, 
   {{0x54549711,0x7bc38073,0x7bcbb10b,0x44220bd4}},	//   звит, _ainu, _bugu, _kpk_, 
   {{0x68e2b10c,0xa0679224,0xa2be1820,0x7bc385b3}},	//   mbod, _дата_, _वृत्, _binu, 
   {{0x7bcb8109,0xb4db00a6,0x2d680214,0x261382fd}},	//   _dugu, _anàl, rşey_, bão_, 
   {{0x78ad0019,0x7bc3b10d,0x261383b8,0x316905de}},	//   _szav, _dinu, cão_, _plaz_, 
   {{0x7bc3807f,0xdb1d02ae,0xdb18826b,0x443d80bb}},	//   _einu, _zusä, _divá, _frw_, 
   {{0x7bcb8c02,0x64400533,0x67270519,0x60c90a63}},	//   _gugu, _šmin, tejj, žemo, 
   {{0x6d46310e,0x3f9c8025,0x7bc3b10f,0x5334a8e0}},	//   _anka, novu_, _ginu, _хект, 
   {{0x69d8b110,0xdb1c011e,0x44223111,0x95cb3112}},	//   _utve, _cirí, _apk_, руга_, 
   {{0x3f9c8043,0x31690053,0x44223113,0xdb1c060e}},	//   hovu_, _ulaz_, _bpk_, _dirí, 
   {{0xb87b2cbe,0x261383b8,0x78ad0410,0x636d8065}},	// [1c50] raís, zão_, _uzav, _fúnd, 
   {{0x656d3114,0xfaa7140f,0x27e93115,0x6d463116}},	//   shah, ошен, _iwan_, _enka, 
   {{0x68ed025f,0xa2be0b36,0x26138077,0x27e926ba}},	//   _kead, _वृद्, xão_, _hwan_, 
   {{0xa2daa93f,0x61e701df,0x26138432,0x27e93117}},	//   पुत्, _vwjl, vão_, _kwan_, 
   {{0xd6bd00cf,0xf7458fe7,0x442200bf,0xb8d38353}},	//   _অভিয, зело, _gpk_, _ऑर_, 
   {{0x26138003,0x3f9c8025,0xdfce8013,0x7d0d3118}},	//   tão_, govu_, ديو_, lgas, 
   {{0x7c22b119,0x59c693d2,0x7bc3b11a,0xf9938275}},	//   _apor, _रंगर, _rinu, _قبر_, 
   {{0x261380b0,0x7d0d311b,0x7bcbb11c,0x442fb11d}},	//   rão_, ngas, _pugu, _psg_, 
   {{0x261380b0,0xa3e6807a,0x7c2d311e,0x7bc3b11f}},	//   são_, यील_, nwar, _pinu, 
   {{0x59cf8964,0x261383b8,0x31b60f2c,0x6d930208}},	//   _संदर, pão_, ृद्ध, nħab, 
   {{0xe299b120,0x7c2d3121,0x27e93122,0x7bc3b123}},	//   сан_, hwar, _awan_, _vinu, 
   {{0xbea8803d,0x68ed0d0d,0x50cb98fe,0x27e93124}},	//   _بهمن_, _cead, िशिष, _bwan_, 
   {{0x7bc3b125,0xf1c9810b,0x8d74807b,0xdb1c011e}},	//   _tinu, _tạo_, _تالا, _sirí, 
   {{0x81e10a87,0x442db126,0x7c2d3127,0x7529b128}},	//   _দিন_, mwe_, dwar, leez, 
   {{0x442db129,0x27e9020e,0x68ed0b10,0xdcfb8081}},	//   lwe_, _ewan_, _fead, gnuć, 
   {{0x60c98ce9,0x7d0d1027,0xdb1c03b3,0x3f9c8a7a}},	//   _ngem, ggas, _virí, zovu_, 
   {{0x7c2d0208,0x442db12a,0x2b5814f8,0xed57312b}},	// [1c60] gwar, nwe_, _porc_, чот_, 
   {{0x083b0052,0x7d0d312c,0x4422312d,0x6d599547}},	//   _פעיל, agas, _vpk_, _lowa, 
   {{0xa926b12e,0xb6a300ef,0x3126801d,0x442db12f}},	//   здел, éâtr, здег, hwe_, 
   {{0x442daae2,0x6d462458,0xc7c68251,0xfc3f01fb}},	//   kwe_, _unka, пски, _frí_, 
   {{0x07a69309,0x6846b130,0x442d859d,0x68e2b131}},	//   падн, янда, jwe_, rbod, 
   {{0xe3a78bb7,0x501b0039,0x21200645,0x1b0300b2}},	//   _سر_, מונו, _lbih_, র্বে_, 
   {{0x7d1bb132,0x2cc18816,0x442d81b0,0xbcfb00d8}},	//   ffus, ərdə_, ewe_, _sléi, 
   {{0x3f9c8259,0x6b818013,0x69ce0123,0x7d7880fe}},	//   sovu_, eilg, _iube, تمبر_, 
   {{0x442daae5,0x68ed3133,0x6d59b134,0xdcfb8265}},	//   gwe_, _read, _dowa, znuć, 
   {{0x69ce30c9,0x68ed3135,0xb4ac800d,0x27f7800d}},	//   _kube, _sead, _गरी_, ření_, 
   {{0x52138d29,0xcfc400b2,0x442daa92,0xe3b88646}},	//   ндэт, ্ঠান, awe_, rmı_, 
   {{0x442da3d6,0x7c2297fc,0x798280a1,0x69ce3136}},	//   bwe_, _tpor, niow, _mube, 
   {{0x7c22b137,0x4346a2f7,0x69ce3138,0x6b81b139}},	//   _upor, _недв, _lube, bilg, 
   {{0xc7c4313a,0x6d59b13b,0x6b5f8093,0xb90423a6}},	//   есси, _zowa, _bêgu, _प्_, 
   {{0xd788810b,0x68ed0073,0x21201041,0x69ce060e}},	//   yển_, _tead, _fbih_, _nube, 
   {{0xbcfb313c,0x27e9313d,0x7c2d313e,0x7aee19a4}},	//   _llév, _twan_, twar, _aebt, 
   {{0x94ab1969,0x7d0d313f,0x2d581a59,0x69ce3140}},	// [1c70] ства_, rgas, чить_, _aube, 
   {{0x212b3141,0x69ce3142,0x3dc680bf,0x65a58063}},	//   lech_, _bube, _liow_, róhi, 
   {{0x69ce3143,0x442d823c,0x200b00d7,0x35b53144}},	//   _cube, zwe_, luci_, _обор, 
   {{0xfc3f3145,0x6b818103,0x212b3146,0x69ce3147}},	//   _trí_, zilg, nech_, _dube, 
   {{0xf7708f2a,0x442d82a5,0x6d59847f,0x20193148}},	//   گان_, xwe_, _rowa, ntsi_, 
   {{0x6d59b149,0x7bdd314a,0x25a9314b,0xf09400c6}},	//   _sowa, _itsu, llal_, ענס_, 
   {{0xf770806f,0x6d59a694,0xa3c29b00,0x69ce060b}},	//   دان_, _powa, ्दन_, _gube, 
   {{0x442dad47,0x61fa007f,0x798280a1,0x7bc70149}},	//   twe_, _ætla, ciow, _hiju, 
   {{0x442d85ab,0x200b0043,0x6b818004,0x212b001b}},	//   uwe_, juci_, tilg, dech_, 
   {{0xe1f99711,0x442db14c,0x7bcf314d,0xdb1c0019}},	//   ого_, rwe_, _mucu, _kirá, 
   {{0x7bcf314e,0x6b818004,0x442db14f,0x3f833150}},	//   _lucu, rilg, swe_, diju_, 
   {{0x7bdd0d9b,0xdb1c033b,0x37e205a2,0x5ec505a2}},	//   _otsu, _mirá, _বিবর, ্রাই, 
   {{0x02aa13d2,0x59cf85b1,0x7bdd01ea,0x200b00d7}},	//   _कर्न, _संवर, _ntsu, guci_, 
   {{0x3f830025,0x39491550,0xdb1c0149,0x6b81b151}},	//   giju_, _enas_, _oirá, qilg, 
   {{0x7bcf03e9,0xada628cd,0x6372006d,0xad5a3152}},	//   _aucu, давл, _hæng, орах_, 
   {{0x7bcf0012,0xdb18836d,0x2d8db153,0xc69283f3}},	//   _bucu, _eivä, nnee_, דאל_, 
   {{0xe73a252f,0x3f831527,0x7bc73154,0x7bcf0c02}},	// [1c80] _деп_, biju_, _biju, _cucu, 
   {{0x39490025,0x09e60c89,0x6372006d,0x316d86e4}},	//   _znas_, дожн, _mæng, _alez_, 
   {{0x7bc703d4,0x63720022,0x7bdd02a6,0x2176b155}},	//   _diju, _læng, _etsu, мудр, 
   {{0x6e3ca891,0x7aee3156,0xdb1c033b,0xfc4a94d7}},	//   _árbi, _webt, _dirá, ntíð_, 
   {{0xb4ac800d,0xdfcf8c85,0x7bc70183,0x629500bf}},	//   _गरे_, لين_, _fiju, _exzo, 
   {{0x212b0a9a,0x26d83157,0x3dc680bf,0x6d5d810d}},	//   zech_, ncro_, _siow_, ösan, 
   {{0x69dc2516,0x63600019,0x200b3158,0xdb1c0065}},	//   _utre, _dönt, zuci_, _girá, 
   {{0xd8268a6a,0x63648a1c,0x602682f0,0x6d560192}},	//   _одби, _iòni, _одба, njya, 
   {{0xf8b2810c,0xae0282f4,0x212b00ac,0x657a0733}},	//   _जरिय, रूजन_, vech_, éthy, 
   {{0xd370846c,0x200b029f,0x6eb68691,0xdb0a8a5e}},	//   اهد_, vuci_, _قصائ, _bhfá, 
   {{0xc3331af4,0x3f83005d,0x212b001b,0x25a03159}},	//   דות_, viju_, tech_, koil_, 
   {{0x80fb256d,0x6372006d,0x6360010d,0x6364875d}},	//   ्लेख_, _fæng, _köns, _mòni, 
   {{0x6d5c81b2,0x3f830259,0x212b315a,0xd8380aad}},	//   _îraq, tiju_, rech_, мэр_, 
   {{0x200b0024,0x2d84b15b,0xa2948ad0,0x4426804f}},	//   ruci_, lime_, _палі, _ipo_, 
   {{0x290f818a,0x7bcf315c,0x200b0497,0x212b1f49}},	//   ygga_, _sucu, suci_, pech_, 
   {{0x394905da,0x2d84b15d,0x26170077,0x7bcf315e}},	//   _unas_, nime_, rço_, _pucu, 
   {{0x36d5179c,0x60cd01d7,0x9f4205e1,0x8f0e83ff}},	// [1c90] _попр, _igam, lský_, _सांझ_, 
   {{0x25a918d4,0x4426b15f,0x316d8a63,0x2006b160}},	//   slal_, _mpo_, _slez_, droi_, 
   {{0x9f42027b,0xdeb2005a,0x2d84b161,0x60cd3162}},	//   nský_, _бұры, kime_, _kgam, 
   {{0x4adf2ce8,0x39498422,0x4426807b,0xdb1c0019}},	//   _प्रव, ñas_, _opo_, _virá, 
   {{0x4426b163,0x752d002d,0x636d80fe,0x60cd3164}},	//   _npo_, meaz, _lúna, _mgam, 
   {{0x752d002d,0xbcfb0077,0x6d5d3165,0x2d84811e}},	//   leaz, _elét, _hosa, eime_, 
   {{0x4426b166,0x6d5d3167,0x69ca812e,0x3ea28004}},	//   _apo_, _kosa, _संगी, лишг, 
   {{0x60cd3168,0x636000f9,0x752d002d,0x2d84b169}},	//   _ngam, _föns, neaz, gime_, 
   {{0x6d5d316a,0x6442b16b,0xa2d606df,0x442680db}},	//   _mosa, _croi, मुक्, _cpo_, 
   {{0x64429579,0x60cd2233,0x6d5d316c,0xf1c9801c}},	//   _droi, _agam, _losa, _hại_, 
   {{0x4426b16d,0x80c200da,0x2d84b16e,0x636d80d8}},	//   _epo_, रेने, bime_, _cúna, 
   {{0x6442b16f,0x6d5d3170,0x5c7587ae,0x752d0123}},	//   _froi, _nosa, _плет, jeaz, 
   {{0x6d4bb171,0xeb8eb172,0x60db9173,0xec6e8e19}},	//   _inga, _би_, _mfum, _сп_, 
   {{0xf1c9810b,0x27ed8f93,0xa3c08562,0x443f9fb4}},	//   _lại_, _mwen_, ंगण_, mvu_, 
   {{0x6d5d3173,0x69ce8e75,0x60cd0065,0x443fb174}},	//   _bosa, íbet, _fgam, lvu_, 
   {{0x6d5d3175,0x753bb176,0xed573177,0xf65280c6}},	//   _cosa, nduz, нос_, נצן_, 
   {{0x6d5d3178,0x443f82ee,0x2fdf806c,0xf1ac12cf}},	// [1ca0] _dosa, nvu_, _ntug_, _टीएन, 
   {{0x25a03179,0x656f317a,0x60dbb17b,0x27e00116}},	//   soil_, _elch, _afum, _itin_, 
   {{0x752d00de,0x6d5d02a6,0x0906b17c,0x6d4bb17d}},	//   beaz, _fosa, епен, _onga, 
   {{0x2d84b17e,0x443f803b,0x7e6100f9,0x7986317f}},	//   xime_, kvu_, älpe, nikw, 
   {{0x403490e6,0x69c99fd9,0x63a1b180,0x2d84b181}},	//   телс, _diee, koln, vime_, 
   {{0x6d4bb182,0x6d5d0232,0xf1ca012f,0x4426b183}},	//   _anga, _zosa, _dại_, _rpo_, 
   {{0xe2973184,0xe5c6b185,0x443f9145,0x27ed8064}},	//   _зар_, нсио, evu_, _ewen_, 
   {{0x9f42003e,0xd5b7b186,0xdb1c0ad8,0x6da389c5}},	//   vský_, нсы_, _birç, лија, 
   {{0x6d4b8645,0x6372006d,0x70af12b9,0x7986004f}},	//   _dnga, _tænd, _घरेल, dikw, 
   {{0x8883aa6a,0x2d84b187,0x5c738f9c,0x752d002d}},	//   _служ, sime_, ульт, zeaz, 
   {{0x27e00318,0xa294909a,0x7e9a8a85,0x2a6a8063}},	//   _atin_, тані, _عنصر_, ább_, 
   {{0x32029410,0x6442b188,0x9f422337,0x67d5286e}},	//   čky_, _troi, rský_, кому, 
   {{0x38668741,0x752d0123,0x4426b189,0x63a1b18a}},	//   nyor_, veaz, _upo_, boln, 
   {{0x6d5d318b,0x533384bc,0x44320324,0x66010019}},	//   _sosa, _бешт, dwy_, álko, 
   {{0x79a709ea,0x752d318c,0x673ab18d,0x56940103}},	//   _прие, teaz, _matj, гарт, 
   {{0x8d84075d,0x60cd2d32,0xe5340241,0xbcfb0c65}},	//   гууд, _ugam, лесь, _alér, 
   {{0x752d0012,0x7bcab18e,0x6d5d318f,0xfbd3006f}},	// [1cb0] reaz, _kifu, _vosa, اتر_, 
   {{0x673aa628,0x752d002d,0x60dbb190,0x7bca804f}},	//   _natj, seaz, _sfum, _jifu, 
   {{0x6d5d0013,0x69c98029,0x61fab191,0x443f85e1}},	//   _tosa, _piee, nstl, zvu_, 
   {{0x7ff581a1,0xbcfb0068,0x27ed86e0,0x7bcab192}},	//   نستا, _elér, _pwen_, _lifu, 
   {{0xa3c283ce,0xa3c0b193,0x673ab194,0x29d70208}},	//   ्दा_, ंगा_, _batj, _għan_, 
   {{0x6d4b921a,0xdb0500d8,0x7bca8a99,0x79862045}},	//   _snga, rmhó, _nifu, zikw, 
   {{0xed59a9e9,0x6d4b921a,0xc8838610,0x63a1b195}},	//   дой_, _pnga, _beşê_, voln, 
   {{0xf1ca010b,0x92e900cf,0x60dba2a2,0xf1a4a914}},	//   _tại_, _যায়_, _ufum, _брун, 
   {{0x02c98b30,0x210401e2,0xe89480f0,0x656982ae}},	//   रश्न, nčių_, _бать, rkeh, 
   {{0x4a458e72,0x7bcab196,0x200fb197,0x0b4281e2}},	//   внов, _cifu, mugi_, аньн, 
   {{0x200fb198,0x3f87b199,0x6aaa8324,0x779087f1}},	//   lugi_, minu_, _cyff, _دیوا, 
   {{0x3f87b19a,0x6d4bb19b,0x212f8269,0x69dc8a5e}},	//   linu_, _unga, negh_, írea, 
   {{0x63a18ecf,0x8d74b19c,0xb0a5319d,0x61e48524}},	//   poln, _حالا, _गुदग, _čile, 
   {{0x25adb19e,0xa283803d,0x25bf8123,0x6aaa8064}},	//   llel_, _میخو, lmul_, _fyff, 
   {{0xbea60002,0x6aaa811a,0xe3c88106,0xdce40183}},	//   тавк, _gyff, _cựu_, skič, 
   {{0x395fb19f,0x1614000f,0x7bca9e0d,0x44320034}},	//   _nous_, तंबर_, _zifu, twy_, 
   {{0xccf28130,0xf773003d,0x3f87b1a0,0x61fc039f}},	// [1cc0] יכן_, _چاپ_, kinu_, _svrl, 
   {{0x44322b40,0x200f8079,0x31caad31,0xc88701ed}},	//   rwy_, dugi_, िद्ध, ößer_, 
   {{0x3f878284,0xf5060286,0xc33284fc,0x7ae58079}},	//   dinu_, _изно, שוב_, _õhtu, 
   {{0xcfe680cf,0xb81619b2,0x4a5a8039,0x200f9870}},	//   _নিবন, _तमाम_, ודעו, fugi_, 
   {{0x395fb1a1,0x394d8791,0x261486d7,0x2d9200bf}},	//   _dous_, _dnes_, नूनी_, mnye_, 
   {{0x394db1a2,0x3f87807f,0xbf9b00ef,0x2d9200e5}},	//   _enes_, ginu_, quêt, lnye_, 
   {{0x6e288d7c,0xe9d7099f,0x7bca93f1,0x6aa301ed}},	//   _qpdb, _акс_, _rifu, ünft, 
   {{0x7bcab1a3,0x2d9231a4,0x644619bf,0x31600122}},	//   _sifu, nnye_, _krki, _noiz_, 
   {{0x3f878024,0x2d9200bf,0xbfc6b1a5,0xd0e30c74}},	//   binu_, inye_, _абак, _क्षण_, 
   {{0x3f8780d7,0x27e6852a,0x6446008d,0x2d9200f6}},	//   cinu_, mpon_, _mrki, hnye_, 
   {{0x27e6b1a6,0xcb130039,0xc2248267,0x2d9214c7}},	//   lpon_, בלת_, اکتو, knye_, 
   {{0xfce6b1a7,0x644631a8,0x798400db,0x25a6820e}},	//   _родо, _orki, _cmiw, _ukol_, 
   {{0x4432834e,0x7d02b1a9,0x27e6b1aa,0x2d9200bf}},	//   _èy_, _idos, npon_, dnye_, 
   {{0x29d70208,0x257503cd,0x27e680ed,0x79840640}},	//   _bħal_, _måle_, ipon_, _emiw, 
   {{0x644631ab,0x316003ad,0x636d80d8,0xfbb78309}},	//   _arki, _foiz_, _múnl, _שפות_, 
   {{0x518713e6,0x64460183,0x3915167d,0x81e100b2}},	//   _шула, _brki, _смир, _দিল_, 
   {{0x95c80be6,0x0dc831ac,0x5bb9104c,0x644488dc}},	// [1cd0] тура_, тури_, елая_, _šiij, 
   {{0x395fb1ad,0xdb01b1ae,0x6b7400a6,0x47352326}},	//   _sous_, golè, алуу, _снос, 
   {{0x3f87803a,0x29d731af,0x644631b0,0x7d0281ac}},	//   vinu_, _għal_, _erki, _odos, 
   {{0x7d0280f8,0x64460269,0x3a38040a,0x67d5b1b1}},	//   _ndos, _frki, _dsrp_, году, 
   {{0x395f9d9b,0x3f87b1b2,0x25750172,0xdce285c3}},	//   _vous_, tinu_, _våld_, _zloć, 
   {{0x753d011d,0xa2be00da,0xa3b2810c,0xf1ca001c}},	//   _hasz, _वृक्, _झील_, _hạt_, 
   {{0x395f8700,0x443931b3,0x753d2bf0,0x63768166}},	//   _tous_, _hss_, _kasz, _mând, 
   {{0x2249803b,0x656d31b4,0x394d80a6,0x3f87b19a}},	//   _čak_, nkah, _unes_, sinu_, 
   {{0x51848b7c,0x69d531b5,0xcfab8068,0x3af5909a}},	//   _тура, _huze, _قائم_, лянс, 
   {{0x25bf802d,0x25ad8170,0x4439200a,0x69d531b6}},	//   smul_, slel_, _mss_, _kuze, 
   {{0x7515830b,0x198a0b29,0x443931b7,0xa18a00cb}},	//   _مواض, ебни_, _lss_, ебна_, 
   {{0x753d0d99,0x4439009a,0x69d531b8,0x78ad31b9}},	//   _nasz, _oss_, _muze, _byav, 
   {{0x69d531ba,0xaac3000d,0x2d8931bb,0xe44e8e05}},	//   _luze, वेतक, diae_, _уж_, 
   {{0x6d4f31bc,0xdb1c01b2,0xe2998c98,0x77ad811e}},	//   _anca, _dirû, _пал_, fúxi, 
   {{0xa3c2800f,0x656d0645,0x443931bd,0x2d9231be}},	//   ्दर_, fkah, _ass_, tnye_, 
   {{0x6d5b825f,0x656d2712,0x2614809b,0x442b31bf}},	//   njua, gkah, नंती_, _bpc_, 
   {{0x443931c0,0x0326005a,0xe3ba31c1,0x9f4f807f}},	// [1ce0] _css_, лдан, еба_, yrgð_, 
   {{0x6d4f31c2,0x68f6008a,0x442b31c3,0x63768123}},	//   _enca, _heyd, _dpc_, _gând, 
   {{0x6146b1c4,0xd946a100,0x471b00c6,0x2d9200bf}},	//   лежа, лежи, _אויג, pnye_, 
   {{0x443931c5,0x2d890065,0xed5731c6,0x673e31c7}},	//   _fss_, ciae_, _бою_, _hapj, 
   {{0x68f60180,0x7761891e,0x443931c8,0x63a531c9}},	//   _meyd, _bolx, _gss_, bohn, 
   {{0x27f20324,0x27e68385,0xfaa6014f,0x8fa3b1ca}},	//   _mwyn_, rpon_, _баго, баче, 
   {{0x27e6b1cb,0x09cf80ab,0xe1e78019,0x7c2b80f3}},	//   spon_, _संगठ, _دس_, _apgr, 
   {{0x442031cc,0x420a02d4,0x6a8304da,0x443926ba}},	//   oti_, _онҳо_, _улса, _yss_, 
   {{0x442031cd,0xa3c28365,0x7bce0575,0x69d500b4}},	//   nti_, ्दल_, _kibu, _zuze, 
   {{0x442031ce,0x3f8a022d,0xa0a4b1cf,0x673e0019}},	//   iti_, jibu_, _бағд, _napj, 
   {{0x44200ad4,0xdd8f8c0b,0x6b7b09be,0x63768123}},	//   hti_, _کون_, גרינ, _rând, 
   {{0x84468bb7,0x7bce31d0,0x7d0280a1,0xddb68019}},	//   _مختل, _libu, _udos, _صحاب, 
   {{0x442031d1,0x68f60004,0x3cd58103,0x69c280db}},	//   jti_, _deyd, _тўхт, imoe, 
   {{0x443931d2,0x447b896e,0x7bce00bb,0x78ad0191}},	//   _rss_, _אנדע, _nibu, _vyav, 
   {{0x7afa836d,0xd5bb0a5f,0x2904805d,0x442031d3}},	//   matt, еса_, _odma_, eti_, 
   {{0x442031d4,0x61fe23ca,0x63a501ed,0xb4db0a1c}},	//   fti_, dspl, wohn, _anàr, 
   {{0x656d31d5,0x442b01e0,0x442031d6,0x7bce1d76}},	// [1cf0] rkah, _qpc_, gti_, _bibu, 
   {{0x4439029f,0x59d901b7,0x34d1964f,0x753d0034}},	//   _vss_, _बंदर, _हल्द, _wasz, 
   {{0x5a35157d,0xdb0182a5,0x442031d7,0x7afa82fb}},	//   рнет, kolî, ati_, iatt, 
   {{0x7afab1d8,0x4439040a,0x673e0677,0xe9ab8184}},	//   hatt, _tss_, _zapj, ردان_, 
   {{0x68f98066,0xda01007a,0x442031d9,0xb97c0273}},	//   rawd, _लटकत_, cti_, ענדי, 
   {{0x6d478029,0xf74584f9,0x6d40b1da,0xa0668a54}},	//   ējam, реко, edma, раша_, 
   {{0x7afab1db,0x7f3c00c6,0xff0481da,0xb87b011e}},	//   datt, געוו, сячн, ncíb, 
   {{0xdb15011e,0x518796d3,0x656280ca,0x7bce31dc}},	//   _tizó, _суга, _cooh, _zibu, 
   {{0x6d5b9a28,0x236301df,0xeb998ff6,0x28c701a2}},	//   rjua, _kojj_, кии_, रेमि, 
   {{0x7afab1dd,0x25a08f4e,0x4225a0dc,0x212931de}},	//   gatt, čila_, адов, _abah_, 
   {{0xe299b1df,0x68f6059e,0x442031e0,0x491a02f4}},	//   тан_, _peyd, zti_, _भादो_, 
   {{0x213f93bd,0x442031e1,0x68f6008c,0x186a0f4c}},	//   _jauh_, yti_, _qeyd, вами_, 
   {{0x3f8a022d,0x671c80ab,0x44201adf,0x290c07de}},	//   tibu_, _नामक_, xti_, ğda_, 
   {{0xcb6684fa,0xb4c19108,0x7afa8086,0x213f80e5}},	//   _ваше_, ंधी_, catt, _lauh_, 
   {{0x3f8a022d,0x7bce1a28,0x0fc300f0,0x24f6178c}},	//   ribu_, _ribu, ійсн, ичар, 
   {{0x4420231d,0x3f8a31e2,0xb04a099f,0x257185e1}},	//   tti_, sibu_, _азиз_, _málo_, 
   {{0x3b862b67,0x44201bde,0x63860432,0x31bc801b}},	// [1d00] алаг, uti_, агаа, níze_, 
   {{0x44201129,0xfbdf0147,0x39401123,0x61fe1e4a}},	//   rti_, _trên_, _hais_, tspl, 
   {{0x201fb1e3,0x4aab807a,0x394031e4,0x69c280d0}},	//   _aqui_, _घुमव, _kais_, tmoe, 
   {{0xc8ca8158,0x61fe31e5,0x636d816f,0x394031e6}},	//   نوان_, rspl, _búnk, _jais_, 
   {{0x39401a9d,0x7bce04c0,0x69c2b1e7,0x61fe31e8}},	//   _mais_, _tibu, rmoe, sspl, 
   {{0x394031e9,0x9e068613,0x656280db,0x42e70077}},	//   _lais_, ачил, _sooh, _вмро_, 
   {{0x9c87026b,0xbcfb068e,0xdb018093,0x290483df}},	//   počí, _moén, tolî, _tdma_, 
   {{0x5d549972,0x394031ea,0xfaa60325,0x644300a1}},	//   скит, _nais_, _баҳо, łnie, 
   {{0x7afab1eb,0x6d40af8c,0xf3f7824f,0x68ed83b9}},	//   tatt, rdma, аныш_, ñade, 
   {{0x395201e5,0xf366920f,0x7b668fe7,0x656280db}},	//   _anys_, ртин, ртие, _wooh, 
   {{0x7afab1ec,0x1b0300cf,0x0bb70039,0x394031ed}},	//   ratt, র্কে_, שלים_, _bais_, 
   {{0x644901e2,0x7afa9284,0x394031ee,0xac0a8188}},	//   _šeim, satt, _cais_, _анда_, 
   {{0x394031ef,0x7afa9c17,0xc86431f0,0x637682fd}},	//   _dais_, patt, отри, _cânc, 
   {{0x93fb8052,0x7afaad00,0x3ea98166,0xd7f80d6e}},	//   _ילדי, qatt, şate_, шую_, 
   {{0x394002c0,0x63a8b1f1,0x96f831f2,0xf1bf8033}},	//   _fais_, modn, рест_, žšia_, 
   {{0x69d89056,0xda5b8052,0x21290111,0x63a8b1f3}},	//   _iuve, _יכול, _ubah_, lodn, 
   {{0x54b901bc,0x7af881df,0xf4d8025c,0x68fd31f4}},	// [1d10] угая_, _kevt, рмуш_, masd, 
   {{0x8ae7036a,0x69d880f8,0x28c700a1,0x7af88ba7}},	//   ріал, _kuve, रेणि, _jevt, 
   {{0xcfe200cf,0x213f8766,0x69da0019,0x394001df}},	//   _বিএন, _pauh_, _étel, _yais_, 
   {{0x291931f5,0x63a8b1f6,0x68fd31f7,0x3940006c}},	//   ngsa_, hodn, nasd, _xais_, 
   {{0xdee584bc,0x8d5a0052,0x69d8b1f8,0x504583b8}},	//   боли, _עכשי, _luve, селб, 
   {{0x69d882c0,0xcc3a0273,0xdc3a0273,0x543a00c6}},	//   _ouve, _געשט, _געשר, _געשא, 
   {{0x798b8010,0x69d8b1f9,0x81e105a2,0x925831fa}},	//   pigw, _nuve, _দিক_, _карт_, 
   {{0xf1ca0106,0x7bc531fb,0xe299804a,0x06980309}},	//   _nạp_, lmhu, ғам_, ידום_, 
   {{0x394000fd,0x3b85a8d9,0x7989804f,0x69d88035}},	//   _rais_, йлиг, _imew, _auve, 
   {{0xf7739692,0x4ea79349,0x63a8b1fc,0x394031fd}},	//   _بار_, _креа, godn, _sais_, 
   {{0xa96a2e07,0x216a0004,0x394031fe,0x636d8019}},	//   гина_, гини_, _pais_, _júni, 
   {{0x394000e5,0xdb05010d,0x249d81c8,0x636d961e}},	//   _qais_, llhä, _txwm_, _múni, 
   {{0x63a8886a,0xab29b1ff,0x39403200,0xb900110f}},	//   bodn, _бола_, _vais_, _तल_, 
   {{0x2bdb023b,0x66e305c2,0x53348b1b,0xdee30ed4}},	//   _बढ़ा, зора, _мечт, зори, 
   {{0x394001ea,0x69d8b201,0xa50a07ba,0x261828b5}},	//   _tais_, _guve, лева_, बंधी_, 
   {{0xf1d026f9,0xa19309d9,0x1c030073,0x442f80f6}},	//   _सूचन, _најч, _लिखल_, _kpg_, 
   {{0xb87b3202,0x13060188,0x69d881ed,0x35a6004c}},	// [1d20] rcíc, йзам, _zuve, _ҳанг, 
   {{0xf3f98a87,0x26180562,0x46f61645,0x7989804f}},	//   _আমার_, बंदी_, _учит, _amew, 
   {{0x6e46040c,0x20020d86,0x69d88659,0x257181c2}},	//   _انجم, lski_, _xuve, _páll_, 
   {{0x9f4907e9,0x442f811b,0xdb01a203,0xed5a0741}},	//   _hvað_, _opg_, dolí, _сом_, 
   {{0x7f41a584,0x7bd9803d,0x68e40ca2,0xbf9b0429}},	//   _balq, _nuwu, _mfid, prêt, 
   {{0x7f418659,0x6d440124,0xb87b0530,0x39408116}},	//   _calq, ldia, ncía, žis_, 
   {{0x644bb203,0x7c243204,0x41b6803d,0x65be816c}},	//   _argi, ltir, _همسر, hëhe, 
   {{0x25a0a6c5,0x63a880a1,0xb99680fe,0x657ba849}},	//   čilo_, wodn, _الرب, ghuh, 
   {{0x7c243205,0x69d8b206,0x69c08008,0x65663207}},	//   ntir, _suve, _ihme, _mokh, 
   {{0x20020284,0x4f658013,0x65660232,0x68e43208}},	//   dski_, _والف, _lokh, _afid, 
   {{0x195909b2,0x7c240004,0x442f8ac4,0xe1353209}},	//   ааны_, htir, _epg_, онны, 
   {{0x3f8e8010,0x656602b9,0x637b0610,0x7afe033f}},	//   lifu_, _nokh, _zînd, hapt, 
   {{0x6d440360,0x63a8803a,0x7afe320a,0x68fd320b}},	//   ddia, podn, kapt, rasd, 
   {{0x7f41b20c,0x60d60019,0x9f52817c,0x3f8e8010}},	//   _xalq, _egym, èyè_, nifu_, 
   {{0x41e68743,0x6566320d,0xf1ca001c,0xdb1c00d8}},	//   _استف, _bokh, _tạp_, _ghré, 
   {{0x16198365,0x66150124,0xd0110bca,0x5694320e}},	//   नंतर_, ruzk, _قلب_, част, 
   {{0xdd1c8170,0xac190370,0x6d4284e2,0x7c2400ed}},	// [1d30] kážk, розу_, _maoa, gtir, 
   {{0x63600068,0x69c0b20f,0x66150124,0x25a90766}},	//   _köny, _ahme, puzk, soal_, 
   {{0x6d440b62,0x7c243210,0xd25100d8,0xce591106}},	//   bdia, atir, بنا_, _танц_, 
   {{0xac193211,0x68e2aebd,0x7c243212,0x798f0e0b}},	//   _кому_, gcod, btir, nicw, 
   {{0x7c24011e,0x7afe3213,0x27e90108,0x442480bf}},	//   ctir, bapt, _jtan_, jtm_, 
   {{0x69c0b214,0x7afe3215,0x2d9a8019,0xdb01b216}},	//   _ehme, capt, épen_, tolí, 
   {{0xdb18826b,0x442f897e,0x7bd99b45,0x65660232}},	//   _chví, _spg_, _suwu, _yokh, 
   {{0x24099ac1,0xdb01b217,0x68e2b218,0x442f9725}},	//   ании_, rolí, ccod, _ppg_, 
   {{0x1c429878,0x75ca80a1,0x0b598241,0x3f8e804f}},	//   дным, _języ, арны_, bifu_, 
   {{0x68e43219,0x657b8010,0x645b811e,0x644b80ca}},	//   _sfid, shuh, rxui, _vrgi, 
   {{0x200200a1,0xcb120c2d,0xeab180fe,0x64448265}},	//   wski_, ולי_, بعة_, _šiit, 
   {{0x2002003b,0x68fb82c0,0x443d806c,0x7c240004}},	//   tski_, _jeud, _tsw_, ytir, 
   {{0x442f8065,0x443d81ed,0x7afe0103,0xbee5009b}},	//   _upg_, _usw_, yapt, कडून_, 
   {{0x7d1bb21a,0x947488a4,0x68fb8c9f,0x257c00d8}},	//   lgus, _عدنا, _leud, _míle_, 
   {{0xfc3f16b7,0xdce40f63,0x27e9321b,0x212db21c}},	//   _así_, nkić, _etan_, _obeh_, 
   {{0x20021527,0x7c24321d,0x75298086,0x291f806c}},	//   pski_, ttir, nfez, _ncua_, 
   {{0xab66321e,0x3366306e,0x61e903d0,0x6449b21f}},	// [1d40] овал, оваг, _čela, nvei, 
   {{0x6d443220,0x25750172,0xb7d7004e,0x212d868e}},	//   sdia, _håll_, _گویا_, _abeh_, 
   {{0xe0dab221,0x7afe3222,0xdce40770,0x65663223}},	//   аве_, rapt, jkić, _tokh, 
   {{0x01aa8188,0x671c82f4,0x64430034,0x27e9010d}},	//   шкек_, _नाहक_, łnia, _ytan_, 
   {{0x68fbb224,0x68ed860e,0x4fc68940,0x3f8eb225}},	//   _deud, ñada, оска, tifu_, 
   {{0x68e28fd1,0x7d1bb226,0x69d83227,0x7c3b8c20}},	//   scod, egus, íves, dwur, 
   {{0xe2971a09,0xdd1c8170,0x3f8eb228,0x7afc0166}},	//   _дар_, rážk, rifu_, _iert, 
   {{0x186a8004,0x3f8e9d60,0xdb088400,0x7ae90a63}},	//   _каби_, sifu_, modé, _đeti, 
   {{0x7afc3229,0x69dc322a,0x660381df,0xe81603ca}},	//   _kert, _hure, asnk, _तमगा_, 
   {{0x69dc322b,0xe4570273,0x442480f6,0x3946b22c}},	//   _kure, קייט_, rtm_, ldos_, 
   {{0xc4e69401,0x798f322d,0x6d42840a,0x3946b22e}},	//   _джей, ticw, _taoa, odos_, 
   {{0x69dc322f,0x3946b230,0x7afc163b,0x2120017c}},	//   _mure, ndos_, _lert, _ccih_, 
   {{0x81ba00b2,0x3946b231,0x7dd58116,0x84968019}},	//   _অংশ_, idos_, _išsa, _بجائ, 
   {{0x69dc0659,0x25a997b2,0x67389190,0xdb1c011e}},	//   _oure, čale_, nevj, _miró, 
   {{0xccfb10f3,0xb7bb0432,0x55590495,0xed8b27b8}},	//   ића_, stão, бавя_, асак_, 
   {{0xdb1c011e,0x394481a8,0x7d00b232,0x7afc3233}},	//   _oiró, _nams_, nams, _aert, 
   {{0x7afc1077,0x27e93234,0x0bd500fe,0x2139016c}},	// [1d50] _bert, _utan_, سياح, mesh_, 
   {{0x69dc3235,0x7afc1bb1,0x20193236,0x67388cb7}},	//   _bure, _cert, musi_, jevj, 
   {{0x20191040,0x7afc3237,0xea00001c,0x28c71ede}},	//   lusi_, _dert, _đảo_, रेरि, 
   {{0x69dc3238,0x3f910053,0xf55900fe,0x7d008c0e}},	//   _dure, lizu_, _الحب_, jams, 
   {{0x69dc3239,0x66e59224,0x2019182f,0xa3ca809b}},	//   _eure, пола, nusi_, लगा_, 
   {{0x7afc323a,0x3946852f,0x213900f8,0xdb019553}},	//   _gert, ados_, hesh_, kolá, 
   {{0x7bdd323b,0xee39899f,0x69dc0109,0x7c390214}},	//   _husu, ёни_, _gure, şarı, 
   {{0x7bdd323c,0x201916f9,0x7afc323d,0x7c3bb23e}},	//   _kusu, kusi_, _zert, twur, 
   {{0x2019323f,0x7bdd3240,0x7d1bb241,0x69dc323d}},	//   jusi_, _jusu, rgus, _zure, 
   {{0x6449b242,0x7bdd3243,0x2571807f,0x20193244}},	//   rvei, _musu, _máli_, dusi_, 
   {{0xcb12096e,0x2b1c85d9,0x6449b245,0x7ae50015}},	//   עלט_, _मारु_, svei, icht, 
   {{0xac198bb1,0x291db246,0x20193247,0xdb0a80fe}},	//   _году_, ngwa_, fusi_, _bhfó, 
   {{0x7bdd3248,0x20193249,0xdce2808d,0x5ed080b2}},	//   _nusu, gusi_, _glođ, _স্পে, 
   {{0xdb1c0064,0xc31105a2,0x636d8a5e,0x798d10fd}},	//   _chrì, স্তি_, _cúnt, _emaw, 
   {{0xed5a0873,0xdb01b24a,0x272f83d2,0x3ebe06b3}},	//   бов_, colá, mını_, ått_, 
   {{0x7afc1598,0x2019324b,0x63720142,0x7bdd324c}},	//   _sert, busi_, _tænk, _busu, 
   {{0x7afc324d,0x2902324e,0xdca315ac,0x7bdd0166}},	// [1d60] _pert, maka_, еати, _cusu, 
   {{0x29020455,0xef860cac,0x272f8646,0x04fc00b2}},	//   laka_, _хлоп, nını_, ইলের_, 
   {{0x7afc324f,0x19ba9a59,0x7dc58530,0x7bdd0065}},	//   _vert, будь_, mósf, _eusu, 
   {{0x35a60692,0x7ae5030b,0x7afc3250,0x69d60722}},	//   _хамг, acht, _wert, _jiye, 
   {{0x7afc03a1,0x2d923251,0x672d80d7,0x25ad8387}},	//   _tert, miye_, đajn, doel_, 
   {{0x69dc3252,0x29023253,0xa3c2800d,0x2d923254}},	//   _ture, haka_, ्दछ_, liye_, 
   {{0x6d463255,0x272f8085,0xfaa33256,0x25ad8120}},	//   _kaka, dını_, _заро, foel_, 
   {{0x6d463257,0x2d923258,0x290209da,0x7ec70019}},	//   _jaka, niye_, jaka_, lépé, 
   {{0x6d460872,0x7bdd0004,0x66188170,0xb4c880da}},	//   _maka, _xusu, suvk, ोखे_, 
   {{0x6d462d35,0x6843b259,0xfc2f9b23,0x2019325a}},	//   _laka, _януа, احي_, vusi_, 
   {{0x2d92325b,0x2902325c,0x69d6325d,0x213900f8}},	//   kiye_, faka_, _biye, tesh_, 
   {{0x6d46325e,0x2019325f,0x637b024a,0x644a00f3}},	//   _naka, tusi_, _mîna, āfij, 
   {{0x69d63260,0x2d920214,0x69c400db,0x2139016c}},	//   _diye, diye_, _dhie, resh_, 
   {{0x20193261,0x6d460786,0x321a2430,0x1be3002a}},	//   rusi_, _aaka, kupy_, _कंबल_, 
   {{0x29023262,0x7bdd3263,0x4ea43264,0x644f0183}},	//   baka_, _susu, ерта, _srci, 
   {{0x29020215,0x20193265,0x6d461fd8,0x2d92029a}},	//   caka_, pusi_, _caka, giye_, 
   {{0x071c9e12,0x6d463266,0x5c99027a,0xea000028}},	// [1d70] _नांव_, _daka, цкая_, _đạo_, 
   {{0xe3b88876,0xa87c0039,0x7ae501ed,0xad272501}},	//   nlı_, _לאחר, ucht, _کردو, 
   {{0x7bd53267,0x32070068,0x6d463268,0x68ed82ba}},	//   _vizu, ény_, _faka, ñado, 
   {{0x44268065,0x637307fa,0x7ae501ed,0x64428008}},	//   _oqo_, _sını, scht, _osoi, 
   {{0x25ad80d0,0xb4d909fe,0xe3b88214,0x4426b269}},	//   voel_, ाशी_, klı_, _nqo_, 
   {{0x4429326a,0x2902326b,0xe80e83ca,0x637b01b2}},	//   mta_, zaka_, _सिरा_, _fîna, 
   {{0x6d46326c,0x29022d47,0xee3980f0,0xc33200c6}},	//   _yaka, yaka_, іни_, _שול_, 
   {{0x4429326d,0xd6580039,0x5ebf00b2,0x290202fe}},	//   ota_, ליות_, _আলাই, xaka_, 
   {{0x2902326e,0xe3b888f1,0x2d838116,0x69d6326f}},	//   vaka_, flı_, ėje_, _riye, 
   {{0x442917dc,0x29023270,0x2d923271,0x69d6203f}},	//   ita_, waka_, ziye_, _siye, 
   {{0x29023272,0x44293273,0x272f9068,0x62853274}},	//   taka_, hta_, rını_, nzho, 
   {{0x442908b6,0x272f846b,0x72078019,0xe3b882d1}},	//   kta_, sını_, _ہفتہ_, alı_, 
   {{0x29023275,0x6d463276,0xa01b0068,0x3b0992b0}},	//   raka_, _raka, szön, _дело_, 
   {{0x6d463277,0x29023278,0x44293279,0x6f03b27a}},	//   _saka, saka_, dta_, nanc, 
   {{0x2d92327b,0x6d46327c,0x4429327d,0x2902327e}},	//   tiye_, _paka, eta_, paka_, 
   {{0x6d49b27f,0x60dbb280,0x44290dc1,0xed57099f}},	//   ndea, _ngum, fta_, мос_, 
   {{0x2d923281,0x6d463282,0x6d49803c,0x65640a00}},	// [1d80] riye_, _vaka, idea, rjih, 
   {{0x6d463283,0x2d923284,0x7c29b285,0x6d498f9e}},	//   _waka, siye_, iter, hdea, 
   {{0x6d463286,0x44293287,0x7c29b288,0x673c1faf}},	//   _taka, ata_, hter, merj, 
   {{0x27e0025b,0x44293289,0x3d1805d9,0xe3b886c8}},	//   _kuin_, bta_, _फाटे_, zlı_, 
   {{0x44291951,0x7d0411a5,0x27e003e9,0xe3b88186}},	//   cta_, mais, _juin_, ylı_, 
   {{0x7d04328a,0x6d59b28b,0x673c328c,0x2900328d}},	//   lais, _anwa, nerj, _leia_, 
   {{0x7c29b28e,0x27edb28f,0xa3c38c2e,0x656bb290}},	//   eter, _eten_, ्षन_, _bogh, 
   {{0x7d043291,0x7c29b292,0x257880ef,0x753b804f}},	//   nais, fter, _vélo_, geuz, 
   {{0x673c1b4e,0x7c29b293,0x2b47b294,0x6f03b295}},	//   kerj, gter, _banc_, banc, 
   {{0xa0a4805a,0x6f0381b1,0x7d0412fa,0x2d988019}},	//   _жағд, canc, hais, őre_, 
   {{0x7d043296,0x656b8cb4,0xa3dea8b3,0x81bd0029}},	//   kais, _fogh, _दूर_, stēm, 
   {{0x661c3297,0x6d608170,0xe3b887de,0x7d043298}},	//   durk, ávač, slı_, jais, 
   {{0x44293299,0xdb088530,0x29002e8c,0x27e00304}},	//   xta_, lodí, _deia_, _cuin_, 
   {{0xe3b88816,0x27e0329a,0x81bd00f3,0x4429329b}},	//   qlı_, _duin_, otēk, vta_, 
   {{0xdfd416f0,0x67d4329c,0xd9049ad1,0x79a71aa0}},	//   торы, тору, _پی_, _орие, 
   {{0x7d04329d,0x656b8519,0x6285084c,0xb4d90bd4}},	//   gais, _xogh, vzho, ाशे_, 
   {{0x673c329e,0x6f039375,0x7bd8b29f,0x637f82a5}},	// [1d90] berj, yanc, _kivu, _wêne, 
   {{0x752d32a0,0x31a403d2,0xa3c3b2a1,0x644d32a2}},	//   sfaz, mıza_, ्षय_, rvai, 
   {{0x7c29b2a3,0x7d0432a4,0x644d32a5,0xdb1c32a6}},	//   zter, bais, svai, _virð, 
   {{0x6f03b2a7,0x7645029a,0xf9d980c6,0x1fe680b2}},	//   wanc, _ishy, פֿעל, _নিজস, 
   {{0x394932a8,0x656b8649,0x06f30ab2,0x442932a9}},	//   _maas_, _rogh, _अभाव_, qta_, 
   {{0xf1ca001c,0x656b80fe,0xa3e400da,0x70529367}},	//   _dạy_, _sogh, _पंत_, انوا, 
   {{0x81bd0029,0xd90f80dd,0x45d580ba,0x6d49b2aa}},	//   rtēj, _نیا_, нцит, tdea, 
   {{0x79828066,0x7c2991b7,0x6f03b2ab,0x1c45b2ac}},	//   chow, tter, sanc, еним, 
   {{0x7c29b2ad,0x27ed836a,0xfc48801c,0x2b478497}},	//   uter, _uten_, _cử_, _panc_, 
   {{0x6d498540,0x61e907ad,0xc48286f1,0x2d8c0429}},	//   sdea, _čelj, ульк, édez_, 
   {{0x673c32ae,0x7bd8b2af,0x68e48024,0x39491fb3}},	//   verj, _divu, žide, _baas_, 
   {{0x6d59811a,0x92df80b2,0xf99f32b0,0x27e01153}},	//   _unwa, তরে_, gnè_, _puin_, 
   {{0x673c32b1,0x661c03d9,0x6007036a,0xa3db000f}},	//   terj, wurk, нням_, _ढंग_, 
   {{0x661c32b2,0xfaa58bb9,0x201d813b,0xfbc5819b}},	//   turk, _пало, iuwi_, _ябло, 
   {{0xf7728115,0x6f01b2b3,0x290024ed,0xdb018341}},	//   נקל_, _melc, _teia_, rolä, 
   {{0x27e002b5,0x61ee86c9,0x673c03d0,0x2d9f80ef}},	//   _tuin_, íble, serj, nnue_, 
   {{0x7d04295c,0x673c01bb,0xdee632b4,0xfc488028}},	// [1da0] rais, perj, _попи, _xử_, 
   {{0x7d0432b5,0x60c432b6,0x8fa615a6,0x317f868e}},	//   sais, _izim, _سمجه, _aluz_, 
   {{0xdb1c003e,0xe9da32b7,0xc33282f9,0x4efb0039}},	//   _chrá, чке_, רוב_, _מהיו, 
   {{0xfbdf00ef,0x4aaf0076,0x307a03f3,0xdb088507}},	//   _prêt_, _जुळव, ּאַנ, vodí, 
   {{0xb8e8903a,0x6f01b2b8,0x26180034,0x26c701d2}},	//   _उर_, _belc, बंकी_, _únor_, 
   {{0x38cb8c0b,0x3dc6b2b9,0x60c422a2,0xdfcf8830}},	//   سانی_, _show_, _mzim, مين_, 
   {{0xfc48810b,0x53a332ba,0xf99f017c,0x6f01b2bb}},	//   _sử_, _сарб, ynè_, _delc, 
   {{0x7bd8836d,0xfaa60004,0x5d54b2bc,0x8c66839a}},	//   _sivu, _жаҳо, ткит, етод, 
   {{0x60c42911,0x7f488103,0x10a38a6a,0x394932bd}},	//   _nzim, _tadq, _битн, _raas_, 
   {{0x644600db,0xf8bf0035,0x29068129,0x25a0084c}},	//   _mski, ngée_, laoa_, hnil_, 
   {{0xc3331af4,0x60c432be,0x7bd8b2bf,0x25a003d0}},	//   אות_, _azim, _vivu, knil_, 
   {{0xfc48810b,0xf2c38ff9,0x4c86809f,0x546a8086}},	//   _tử_, ысын, _плев, _наем_, 
   {{0xb9090611,0xdb0883b8,0xc95384fc,0x25718063}},	//   _बल_, godã, אמר_, _vált_, 
   {{0xa3c38ed9,0x60c400f3,0x25a08bfc,0x394932c0}},	//   ्षण_, _dzim, čilu_, _waas_, 
   {{0x394932c1,0x60c4012c,0x644632c2,0x27e68ced}},	//   _taas_, _ezim, _aski, hqon_, 
   {{0xd5b832c3,0x25a003d0,0x7d028050,0x257c00ac}},	//   есу_, gnil_, _jeos, _dílo_, 
   {{0x2ef50574,0x68ed0180,0xe802801b,0x637b0093}},	// [1db0] _изпр, _ifad, रीमा_, _fînl, 
   {{0xc5f680b2,0x200b0d01,0x8aa70326,0x889c0039}},	//   _ঘটনা_, msci_, нред, _מבחי, 
   {{0x644632c4,0xd5df800f,0x321eb2c5,0xdd9100df}},	//   _eski, _पूंज, nuty_, _نود_, 
   {{0x1a6801fa,0x3978b2c6,0x25a02580,0x27e68294}},	//   ریقی_, нсію_, cnil_, fqon_, 
   {{0x2d84b2c7,0x6f01b2c8,0x6d5d32c9,0x05b600df}},	//   dhme_, _pelc, _insa, _شگفت_, 
   {{0x7bdf83e9,0x7c2d0210,0x656f035b,0x39498e4c}},	//   _équi, mtar, _hoch, žas_, 
   {{0xfbdf0077,0xe7088158,0x637201c2,0x61dc00da}},	//   _três_, رتون_, _vænt, यदृष, 
   {{0x6d4d32ca,0x6f01838c,0x7dd58116,0x49049b1d}},	//   ndaa, _welc, _išsk, _موفق, 
   {{0x200b00d7,0x7d02802d,0x6f018217,0x44392736}},	//   jsci_, _deos, _telc, _jps_, 
   {{0x656f32cb,0x7c2d32cc,0x24890043,0x6d4d32cd}},	//   _loch, itar, izam_, hdaa, 
   {{0xfaa5a0e2,0x6a8682c0,0x7c2d32ce,0x69c981ea}},	//   тано, _réfé, htar, _khee, 
   {{0x656f32cf,0x7d02b2d0,0x2d9f8036,0xdc5381fa}},	//   _noch, _geos, qnue_, _مرتک, 
   {{0x6d4d0371,0x7c2d016c,0xa9a320eb,0x8ccd8034}},	//   ddaa, jtar, рияд, देशो, 
   {{0x6d4bb2d1,0x24891b01,0x6d5d32d2,0x1ae28a28}},	//   _haga, dzam_, _ansa, _кошм, 
   {{0x656f32d3,0x6d4bb2d4,0x7c2d32d5,0x201932d6}},	//   _boch, _kaga, etar, arsi_, 
   {{0x656f0018,0x7c2d2d33,0x6d4bb2d7,0x443932d8}},	//   _coch, ftar, _jaga, _bps_, 
   {{0x6d4bb2d9,0x25a032da,0x7c2d32db,0x1ae632dc}},	// [1dc0] _maga, rnil_, gtar, возм, 
   {{0x6d5d32dd,0xa3c1823b,0x6f07003a,0x6d4b86bc}},	//   _ensa, ंति_, cajc, _laga, 
   {{0x442db2de,0xbcfb32df,0x3f98005d,0x6d4d0766}},	//   hte_, _poét, miru_, bdaa, 
   {{0x6d4bb2e0,0x3f981b52,0x656f32e1,0xa113902a}},	//   _naga, liru_, _goch, لومت, 
   {{0x69c9822a,0x7c2d32e2,0xa3c1b2e3,0x69db8741}},	//   _dhee, ctar, ंता_, _diue, 
   {{0x442032e4,0x442d8f44,0x3f9832e5,0x656f32e6}},	//   mui_, dte_, niru_, _zoch, 
   {{0x442032e7,0x6d4bb2e8,0x442db2e9,0x26dc026b}},	//   lui_, _baga, ete_, _úvod_, 
   {{0x752432ea,0x7bdc32eb,0xdd978188,0x657ba712}},	//   ngiz, _hiru, кшы_, gkuh, 
   {{0x442db2ec,0x61e900d7,0x442032ed,0x75e78214}},	//   gte_, _čeli, nui_, _hızl, 
   {{0x2d8488fb,0x671c81aa,0x61e382bc,0x2019029f}},	//   shme_, _नाटक_, _bunl, vrsi_, 
   {{0xdee3b2ee,0x4420025f,0x442db2ef,0xf3638a48}},	//   _тохи, hui_, ate_, ртын, 
   {{0x442db2f0,0x6d4bb2f1,0x7c2d32f2,0x7dc5901f}},	//   bte_, _gaga, ytar, rósc, 
   {{0x442d8c39,0x656f32f3,0x442032f4,0x7c2d32f5}},	//   cte_, _roch, jui_, xtar, 
   {{0x6d40b2f6,0x442032f7,0x656f32f8,0x2904b2f9}},	//   lema, dui_, _soch, _lema_, 
   {{0x35e4036a,0x443902f0,0xda6f8574,0x6d4b81d5}},	//   ицтв, _sps_, _тя_, _yaga, 
   {{0x7c2d32fa,0x672d8131,0x6d409419,0x656f03ad}},	//   ttar, đaji, nema, _qoch, 
   {{0x54550bb1,0x442032fb,0x6d4d02b5,0x7bdc32fc}},	// [1dd0] ыват, gui_, rdaa, _biru, 
   {{0x09cb8f5a,0x2d821169,0x6d408073,0x656f2a58}},	//   िष्य, _elke_, hema, _woch, 
   {{0x442db2fd,0x7bdc32fe,0x69c981c8,0x6d40b2ff}},	//   zte_, _diru, _phee, kema, 
   {{0x7c2d08fb,0x6d5d0e3b,0x6d40b300,0x44203301}},	//   ptar, _unsa, jema, bui_, 
   {{0x2904859e,0x6d4bb302,0x442db303,0x7bdc3304}},	//   _dema_, _raga, xte_, _firu, 
   {{0x6d4bb305,0x7dd581e2,0x442d826b,0x25a6828b}},	//   _saga, _išsi, vte_, _ajol_, 
   {{0x69c9b306,0xc794803d,0x6abc011a,0x43943307}},	//   _thee, جشنب, _gyrf, _тарс, 
   {{0x26dc0080,0x6f0501d2,0x7bdc3308,0xa3e78258}},	//   וקומ, _lehc, _ziru, _मंद_, 
   {{0x7bca9389,0x442db309,0xf1bf0038,0xc6bf00cf}},	//   _bhfu, ute_, dlá_, _আলোচ, 
   {{0xe1f987ef,0x9ee980fe,0x6d4bb30a,0x200980f3}},	//   нго_, _أفضل_, _waga, šais_, 
   {{0x6d4bb30b,0x35f5aa1d,0x656984b1,0xadf5964d}},	//   _taga, _спер, pjeh, _спеш, 
   {{0x2904b30c,0xdb089ceb,0x2904330d,0x216a2c13}},	//   _xema_, rodá, úma_, хими_, 
   {{0x394d8324,0x442d816c,0xd9100019,0x7c648019}},	//   _maes_, qte_, میں_, _ناول, 
   {{0x749aaaa2,0x649a8273,0x3ced8bfc,0x7d09b194}},	//   _אינפ, _אינה, lcev_, laes, 
   {{0xe1f18283,0x2000330e,0x98a403d2,0x3f98330f}},	//   _است_, _wwii_, ımı_, riru_, 
   {{0x7d098025,0x44201d28,0x0ce200b2,0x3ced8bfc}},	//   naes, tui_, বর্ত, ncev_, 
   {{0x3f980131,0x26180079,0x644488dc,0x53ca3310}},	// [1de0] piru_, बूजी_, _šiiz, егам_, 
   {{0xdd04107b,0x2904b311,0x39423312,0x44203313}},	//   ısın, _sema_, leks_, rui_, 
   {{0xeb96896e,0x44203314,0xdca31400,0x79843315}},	//   נדער_, sui_, _ғари, _kliw, 
   {{0x673b005d,0x39421998,0x44203316,0xd46a2326}},	//   đuje, neks_, pui_, _зиме_, 
   {{0x44203317,0x6d40af8c,0xe3b10019,0x2904804f}},	//   qui_, vema, صرے_, _vema_, 
   {{0xa2e307ae,0x6fb4000f,0x7d063318,0x39420079}},	//   _горд, ंकिं, _heks, heks_, 
   {{0x7d063319,0xfbde011e,0x63768166,0x7984331a}},	//   _keks, _iiª_, _mânt, _oliw, 
   {{0x53a604b6,0x782680fe,0xe5c68e71,0x746a8008}},	//   _раҳб, _معطل, ысло, еров_, 
   {{0x6d40b31b,0x3942331c,0xd1b3807b,0x644d8a63}},	//   rema, deks_, _اینک, _šair, 
   {{0x6d8784ba,0x6d40b31d,0x7984331e,0xff248068}},	//   _añad, sema, _aliw, _خبری, 
   {{0x4ebf00cf,0xa49b0097,0x39e7b31f,0xaace8079}},	//   _আল্ল, _aeòl, льян_, हेंक, 
   {{0x99673320,0x6fc00617,0xfce6ac7a,0x25bf8166}},	//   утол, böck, _содо, clul_, 
   {{0xa3e40562,0xe81c0073,0x33f68166,0xa49b0540}},	//   _पूल_, भंगा_, _счес, _ceòl, 
   {{0xead48e61,0x63768123,0xf1bf0407,0x60dd8033}},	//   _коль, _cânt, slá_, _úsme, 
   {{0xa3c3920a,0xa3c1b321,0x7d063322,0x3da73323}},	//   ्षर_, ंतर_, _beks, граб, 
   {{0xdd9413c9,0x9e430170,0xa49b0a67,0x7984085a}},	//   басы, žďov, _feòl, _gliw, 
   {{0x290b0524,0x7d062f1e,0xbcfb0530,0x33f400fe}},	// [1df0] maca_, _deks, _anéc, مسلس, 
   {{0x290b3324,0x7d0602b1,0x69df016c,0x395f82e4}},	//   laca_, _eeks, _hiqe, _snus_, 
   {{0x3ebe98e3,0x7d063325,0x394db326,0xdb08807f}},	//   _nytt_, _feks, _paes_, lldó, 
   {{0x4dfa0273,0x3547109a,0x313587c5,0x6b9a83ad}},	//   _שפרא, _схов, редр, hitg, 
   {{0x3ced807e,0xd7058e09,0x7d09b327,0xada58033}},	//   vcev_, азли, vaes, nkúš, 
   {{0x88c700cf,0x290b3328,0x3ebe920e,0x69df3329}},	//   _এলাক, haca_, _bytt_, _liqe, 
   {{0x6d4f01c1,0xd5ae011d,0x27780039,0x25bf8123}},	//   _kaca, _رہے_, רגון_, tlul_, 
   {{0x290b0524,0x395fb32a,0x2d890722,0x656d332b}},	//   jaca_, _unus_, nhae_, njah, 
   {{0xb81ca56d,0xe7e1023b,0x0d828118,0x87278604}},	//   _नियम_, _गंगा_, ільн, _معام, 
   {{0x637b02a5,0xbb2282a5,0x69cd02ef,0x308480d8}},	//   _bîni, şîni, _ahae, _الكف, 
   {{0x39420073,0x49ca23ff,0x69df024a,0x69cd0097}},	//   teks_, клон_, _biqe, _bhae, 
   {{0x2496807b,0x290b332c,0x69cd332d,0x672d8131}},	//   انید_, gaca_, _chae, đaju, 
   {{0x7dc58207,0x6b65ac92,0x764e807f,0x7d06007f}},	//   lóso, _вкла, _ábyr, _reks, 
   {{0x87b9069a,0x39420689,0x6459b32e,0x6d4f02ef}},	//   густ_, seks_, _irwi, _aaca, 
   {{0x290b13bd,0xe81c810c,0x7d06332f,0x3ebe007f}},	//   baca_, _निभा_, _peks, ætt_, 
   {{0x6d4f3330,0x290b023c,0x69cd0013,0x79841e0d}},	//   _caca, caca_, _ghae, _uliw, 
   {{0xb4660a53,0x7d060af6,0x13063331,0x81bd01a8}},	// [1e00] шкал, _veks, изам, rtēt, 
   {{0x7bc18360,0x644b807b,0x425609c5,0x6d4f0304}},	//   nllu, _msgi, итет, _eaca, 
   {{0x7d060578,0x00e69ba8,0x6d4f0015,0x4a463332}},	//   _teks, ажен, _faca, рнев, 
   {{0x6d4f023c,0x6e3e00bf,0x3160833b,0x2d891a76}},	//   _gaca, _ippb, ñiz_, chae_, 
   {{0x60c98034,0x6d443333,0x2f18b334,0x33d607c5}},	//   _czem, meia, голь_, _вівт, 
   {{0x248db158,0x2d8000a1,0x60c9b335,0x6d4f3336}},	//   dzem_, lkie_, _dzem, _zaca, 
   {{0xfaa317ac,0xeb973337,0x1c188079,0xe8e00106}},	//   _даро, _тир_, _दिहल_, _muối_, 
   {{0x2d8007b8,0xe817009b,0x290b0e7c,0xad6680fe}},	//   nkie_, _तिला_, xaca_, شابه, 
   {{0x290b003b,0x6b9a84da,0x533495e6,0x44322125}},	//   vaca_, titg, бепт, nty_, 
   {{0x44323338,0x61e09101,0x290b3339,0x443d80db}},	//   ity_, _himl, waca_, _dpw_, 
   {{0x2d8007b8,0x0cc312b9,0x4432333a,0x3f9cb33b}},	//   kkie_, _शर्म, hty_, mivu_, 
   {{0x443209d8,0x60c08008,0x3f9cb33c,0x7bc1b33d}},	//   kty_, _kymm, livu_, allu, 
   {{0x7bce00bf,0x6d44333e,0xdbdc81d2,0x2d8680bc}},	//   _ohbu, deia, lšíh, _iloe_, 
   {{0x6d4f333f,0xe8e00028,0xdb050172,0x7c243340}},	//   _saca, _cuối_, llhö, duir, 
   {{0x8de83341,0x290b0024,0x6d4f3342,0xada580e9}},	//   ифта_, paca_, _paca, skúš, 
   {{0x69c88029,0xdb1c00d8,0x261801cc,0xccf802f0}},	//   _ūden, _ghrú, _फिरी_, ићу_, 
   {{0x4424b343,0x6562803e,0x7bce0265,0x799d04e2}},	// [1e10] num_, _mnoh, _bhbu, misw, 
   {{0x6d4f1734,0x25a9b344,0x799d01f4,0x8c1b8039}},	//   _waca, čali_, lisw, כומי, 
   {{0x60c9811d,0x6d4f3345,0x442484c0,0x27e93346}},	//   _szem, _taca, hum_, _huan_, 
   {{0x2d803347,0x799d034e,0x79a4b348,0x27e93349}},	//   ckie_, nisw, орче, _kuan_, 
   {{0x765a8066,0x4424b34a,0x27e902fe,0x7bc1b34b}},	//   _arty, jum_, _juan_, yllu, 
   {{0xbb85030b,0x4424b34c,0x7d0d307e,0x2d86b086}},	//   _السي, dum_, laas, _aloe_, 
   {{0x6fcd81ac,0x27e9334d,0x799d334e,0x69c2b34f}},	//   júce, _luan_, kisw, bloe, 
   {{0x6fcdb350,0x7d0d3351,0x4424812b,0x248d8741}},	//   dúce, naas, fum_, tzem_, 
   {{0x4424b352,0x60c0b353,0xe3b9b354,0x799d03ec}},	//   gum_, _gymm, лби_, disw, 
   {{0x64a580b6,0xd7748013,0x5f748013,0x2d8680db}},	//   _қала, _والع, _والر, _eloe_, 
   {{0x7d0d3355,0xe9da0021,0x248da5aa,0x26c101df}},	//   kaas, лко_, szem_, _nyho_, 
   {{0x27e91f98,0x186a3356,0x44323357,0x4424b358}},	//   _buan_, гами_, yty_, bum_, 
   {{0x4424b359,0x4432335a,0x3bd59cd4,0x55528068}},	//   cum_, xty_, _люкс, _رپور, 
   {{0x291e22d9,0xa027012b,0x27e9335b,0x7529b35c}},	//   şta_, _stöð, _duan_, lgez, 
   {{0xc9f5846d,0x51f59f3b,0xfaa2b35d,0x644981ed}},	//   _استع, _استر, _нашо, lwei, 
   {{0x7d0d335e,0x7529b35f,0x7c243360,0x63bc3361}},	//   gaas, ngez, tuir, _skrn, 
   {{0xd4670cb8,0x1ddf800f,0x69c280d0,0x644982ae}},	// [1e20] бите_, _पूछत, vloe, nwei, 
   {{0x44323362,0x2d801afa,0x64a602d4,0x212d860b}},	//   rty_, skie_, _ҳама, _aceh_, 
   {{0x44323363,0x6449b364,0x7c24029f,0x7d0d3365}},	//   sty_, hwei, suir, baas, 
   {{0x4424b366,0x7d0d09ec,0x588682c3,0x7529893c}},	//   yum_, caas, йыла, jgez, 
   {{0x7c243367,0xdb01b368,0xe80b800f,0x3a259130}},	//   quir, noló, _सौदा_, hulp_, 
   {{0xe82000ab,0x44203369,0x6449811a,0x9f400a1c}},	//   _बिना_, mri_, dwei, _juià_, 
   {{0x528600fe,0xa248130d,0x4424b36a,0x4420336b}},	//   _الأك, _خیال_, wum_, lri_, 
   {{0x4420336c,0x9f41024a,0x3f9cb33a,0x75299e35}},	//   ori_, _cihê_, sivu_, ggez, 
   {{0x4420336d,0x12e6804a,0x6449b36e,0x3946b36f}},	//   nri_, йінг, gwei, meos_, 
   {{0x4424b370,0x44203371,0xdb018d3b,0x3946b372}},	//   rum_, iri_, doló, leos_, 
   {{0x7d0d0640,0x44203373,0xed06803d,0x799d0129}},	//   yaas, hri_, _هواپ, tisw, 
   {{0x27e93374,0x798280a1,0x3946a769,0x442481c2}},	//   _puan_, nkow, neos_, pum_, 
   {{0x27e93375,0x543387f1,0x39520039,0x799d00bc}},	//   _quan_, _فرور, _days_, risw, 
   {{0x799d01c1,0x7d0d3376,0x3e58044e,0x92588dbe}},	//   sisw, waas, _bčt_, _вакт_, 
   {{0x44203377,0x7d0d3378,0x7a1c0123,0x877b8080}},	//   eri_, taas, nătă, נאלי, 
   {{0x27e93379,0x63bab37a,0xe9a409c5,0xb8cf00b2}},	//   _tuan_, lotn, _најп, _কর_, 
   {{0x4420337b,0xe8200073,0xdb01b37c,0x539901bc}},	// [1e30] gri_, _बिया_, coló, авая_, 
   {{0x7d0d3365,0xdce982cf,0x5b15004a,0x3e5806e0}},	//   saas, vječ, імет, _fčt_, 
   {{0x26c701ac,0x39468530,0x27f8807e,0xdb17011e}},	//   _áno_, feos_, _črna_, noxé, 
   {{0x41c92830,0xdce9a628,0x59c9092c,0xf1c90f2c}},	//   रतिस, tječ, रतिर, रतिन, 
   {{0xa0698286,0x63bab37d,0xa3d51c10,0x25a9337e}},	//   рала_, kotn, _момч, mnal_, 
   {{0xaded93d2,0x36198008,0x66fb06df,0xdce982cf}},	//   _चंदन_, ацию_, ्रिक_, rječ, 
   {{0x3cdb807a,0xdce99287,0x752981f0,0x994d80e9}},	//   खेने_, sječ, tgez, môžu_, 
   {{0x25a9337f,0x4c85836a,0xe579b380,0x6449b381}},	//   nnal_, жлив, рзи_, twei, 
   {{0xe10100cf,0x61ea81ed,0x7529b382,0xa49b0a67}},	//   ্লাহ_, _aufl, rgez, _beòi, 
   {{0x290fb383,0x6449b384,0x645d2e70,0xeb9985fd}},	//   laga_, rwei, _mrsi, рио_, 
   {{0x395203e9,0x89aa036d,0x6449a9e4,0x60cd3385}},	//   _pays_, иков_, swei, _azam, 
   {{0x44203386,0xdb01b387,0x61ea8429,0x68e9252e}},	//   yri_, toló, _dufl, žedn, 
   {{0xcb6984bc,0x77770199,0xe8e0012f,0x25a90507}},	//   _вале_, _boxx, _ruồi_, dnal_, 
   {{0x44203388,0x60cd3389,0x290fb38a,0x661a0407}},	//   vri_, _dzam, haga_, átko, 
   {{0xb87b273a,0x66e304bc,0xe296b38b,0x645d338c}},	//   scíp, дора, _маш_, _arsi, 
   {{0x4420338d,0xa3c38ab2,0xa0a6338e,0x2d8db38f}},	//   tri_, ्षक_, _майд, nhee_, 
   {{0x44203390,0x7d0b8068,0x290fb391,0x9f84019b}},	// [1e40] uri_, _megs, daga_, töä_, 
   {{0x44203392,0x76418022,0x2bcf800c,0x7989b393}},	//   rri_, _oply, _सीमा, _alew, 
   {{0x79828066,0x644f3394,0x44203395,0x8a06004a}},	//   tkow, _esci, sri_, ізде, 
   {{0x44203396,0x5f46042b,0xed5a3397,0x290faf49}},	//   pri_, _انگل, _том_, gaga_, 
   {{0x3946a88d,0x7982b398,0x61e43399,0x63ba8103}},	//   reos_, rkow, _miil, yotn, 
   {{0xdfcf8013,0x394682ba,0x798280a1,0xceb4808a}},	//   نين_, seos_, skow, şəm_, 
   {{0x63baa826,0x3946860e,0x290fb39a,0xa3d7071c}},	//   votn, peos_, baga_, ागर_, 
   {{0x6d56339b,0x25a002b1,0x61e4019b,0x290fb39c}},	//   ndya, niil_, _niil, caga_, 
   {{0x98a38a66,0x60c4339d,0x7c360889,0x61ea802d}},	//   _жите, _nyim, ntyr, _sufl, 
   {{0x25a91c31,0xd37ab39e,0x63a880db,0x61e40097}},	//   znal_, рчи_, undn, _aiil, 
   {{0xa2a001ff,0x63bab39f,0x326680f0,0x195933a0}},	//   _गेम्, rotn, ітов, баны_, 
   {{0x63bab3a1,0xdb170065,0x60c40a39,0x6fc48a1c}},	//   sotn, roxé, _byim, dòci, 
   {{0xb8f30365,0x63ba807e,0x9f4902fd,0xdb01875d}},	//   _वर_, potn, _itaú_, rolò, 
   {{0x290fb3a2,0xa294909a,0x60cd007e,0x656602d7}},	//   zaga_, _налі, _vzam, _ankh, 
   {{0x290f9443,0x6933001b,0xdb23807f,0x3f8301c2}},	//   yaga_, _přeč, _þrát, rkju_, 
   {{0xf1a4005a,0x48151309,0x3f8333a3,0x1b0400b2}},	//   _орын, _емис, skju_, _লাগে_, 
   {{0x6ebb0611,0x25a9082c,0x60cd33a4,0xe8e0001c}},	// [1e50] _शुरु, rnal_, _uzam, _buổi_, 
   {{0xd25b33a5,0x645d0043,0x290fb3a6,0x69c0acbb}},	//   ице_, _vrsi, waga_, _akme, 
   {{0xdced0a5a,0x290fb3a7,0xdb0701c2,0x25a002f4}},	//   ljač, taga_, _skjó, biil_, 
   {{0xb9e8004a,0x2b8086e0,0x518495c2,0x6d8799a4}},	//   іміз_, _wòch_, муча, _añan, 
   {{0x290fb3a8,0x644f33a9,0x7d0b81b0,0x6446808a}},	//   raga_, _usci, _regs, çkil, 
   {{0x44292999,0x290fb3aa,0xd34300dd,0x637f83b8}},	//   mua_, saga_, _تفسی, _têni, 
   {{0x442933ab,0x64428ed0,0xf96bb3ac,0xf1a7877a}},	//   lua_, _apoi, _край_, _дран, 
   {{0x752d023c,0xe79580dd,0x3cf780a1,0xed59b3ad}},	//   ngaz, _کارک, ीरें_, kože_, 
   {{0xdced006a,0xd7f88b59,0x1c428193,0x68e9808b}},	//   jjač, _дух_, еным, _iged, 
   {{0xdced0524,0x7d0b9759,0x2d8db3ae,0x69d9b3af}},	//   djač, _wegs, shee_, lmwe, 
   {{0x44291123,0x4b7c0273,0x76418170,0x61e41610}},	//   hua_, יאזו, _uply, _piil, 
   {{0x442933b0,0xe8028c64,0x248000e5,0x644f806d}},	//   kua_, रीका_, yyim_, æcis, 
   {{0x442933b1,0xeb8eb3b2,0x2d9d80bb,0x27e5aa00}},	//   jua_, _зи_, _imwe_, _kiln_, 
   {{0x44292994,0x7c298217,0x752d0495,0xdce40533}},	//   dua_, muer, egaz, ljić, 
   {{0x96632385,0x61e433b3,0x7c2981eb,0x63a1b3b4}},	//   нкре, _tiil, luer, miln, 
   {{0x68e98d17,0x752d1fe4,0xdce404c2,0x4429004f}},	//   _nged, ggaz, njić, fua_, 
   {{0x442933b5,0x25a002fa,0x8c4308db,0xd467130c}},	// [1e60] gua_, riil_, нете, пите_, 
   {{0xe7ef810c,0x63a1b3b6,0x213f8580,0x68e9b3b7}},	//   _चढ़ा_, niln, _abuh_, _aged, 
   {{0x7c3623ca,0x24920066,0x44290123,0x24800a3e}},	//   styr, szym_, aua_, syim_, 
   {{0xb4ea807a,0x27ed80b2,0x290d802d,0x73e605c2}},	//   _मले_, _buen_, _ceea_, _номз, 
   {{0x7d0433b8,0xa3cb9ebe,0xe8e00028,0x63a1b3b9}},	//   mbis, लता_, _tuổi_, kiln, 
   {{0x26c5800d,0x27ed8124,0xfbc78743,0x7c29b3ba}},	//   _bylo_, _duen_, _ست_, duer, 
   {{0x63a1b3bb,0x6b6333bc,0x68edb3bd,0xa3c18079}},	//   diln, _якра, žada, ूतन_, 
   {{0x7c2986b8,0xb608801b,0x7f8b008a,0x7d0433be}},	//   fuer, jišť, _müqa, nbis, 
   {{0x7c298607,0xdb050530,0x9f458093,0x7d0433bf}},	//   guer, cohó, _milê_, ibis, 
   {{0x5ede80cf,0x39401cba,0xfbbe171b,0x63a1a204}},	//   নুষে, _abis_, ्तिम, giln, 
   {{0x27ed80b4,0x442933c0,0xa3e401d1,0x7c240103}},	//   _zuen_, zua_, _पूछ_, hrir, 
   {{0xed59803e,0x7c2984fb,0x63be027b,0xa3e793d2}},	//   tože_, buer, hopn, _मूक_, 
   {{0x63a1aa33,0x7c2985da,0x5334b3c1,0xc86433c2}},	//   biln, cuer, _желт, нтри, 
   {{0x61ee03e9,0x6281b3c3,0x7c242b66,0x442933c4}},	//   _oubl, bylo, drir, vua_, 
   {{0xdced0043,0x7bda807f,0x433b8039,0x777ab3c5}},	//   sjač, mmtu, _העוב, _motx, 
   {{0x442933c6,0x7c2433c7,0x7d0413b3,0x557433c8}},	//   tua_, frir, gbis, нгст, 
   {{0x09c909d7,0x9f45824a,0x3f8c846b,0x7c2433c9}},	// [1e70] रतीय, _dilê_, _oldu_, grir, 
   {{0x442933ca,0x798d027e,0x44248caf,0x61ee0170}},	//   rua_, _hlaw, irm_, _bubl, 
   {{0xdd9515e6,0x442933cb,0xb6068024,0x659511ec}},	//   _жаны, sua_, nošć, _жану, 
   {{0x15f205d9,0xdd86803f,0x442933cc,0x7dc5852f}},	//   _आंतर_, _شو_, pua_, pósi, 
   {{0x27edb3cd,0xdb170818,0x4429009f,0x628190ab}},	//   _quen_, loxí, qua_, zylo, 
   {{0x798d0324,0x777a80a6,0x3f9e80bf,0x3dc90087}},	//   _llaw, _cotx, _cmtu_, llaw_, 
   {{0x63a1af48,0x61ee029f,0x7c29ac65,0x4424808b}},	//   viln, _gubl, wuer, erm_, 
   {{0x7c29b3ce,0xb60685c3,0x63a18034,0x3dc91290}},	//   tuer, došć, wiln, nlaw_, 
   {{0x63a1b3cf,0x320102b1,0x39400065,0x47358103}},	//   tiln, lphy_, _rbis_, _онас, 
   {{0x798d33d0,0x7c29b3d1,0x79860598,0x645b8161}},	//   _alaw, ruer, wkkw, rvui, 
   {{0x7c299c69,0x63a18bfc,0xb6068e00,0xa91d8c0e}},	//   suer, riln, gošć, _alži, 
   {{0x7c298396,0x7e7e8172,0x2d9d829a,0xa96a04c7}},	//   puer, äppe, _umwe_, цима_, 
   {{0x798d33d2,0x63a1b3d3,0xbcfb00e9,0x3dc90347}},	//   _dlaw, piln, _inéh, dlaw_, 
   {{0x8c42968e,0x798d02ef,0x61fb0ba7,0x7c2433d4}},	//   _реше, _elaw, _čuln, vrir, 
   {{0xafe333d5,0x37e319c0,0xe73723f6,0x7d0f0063}},	//   торл, торг, ьер_, _becs, 
   {{0x61ee33d6,0x99520116,0x25adb3d7,0xe817009b}},	//   _rubl, ršų_, nnel_, _तिचा_, 
   {{0x7d0433d8,0xdca333d9,0x63be007e,0x6fcd80e9}},	// [1e80] rbis, вати, topn, júco, 
   {{0x25bf834e,0x7c2433da,0x387f01ab,0x7dea80ce}},	//   houl_, rrir, äure_, _kęst, 
   {{0xa49b0064,0xdb1c0304,0x68ed8033,0x3dc9043a}},	//   _beòs, _bhrò, ľadn, blaw_, 
   {{0x7c240086,0x3dc933db,0xdb1c1b09,0x2f0a8034}},	//   prir, claw_, _phró, _mógł_, 
   {{0xb8f69089,0x7bc387d8,0x7bc8807f,0xdb1c0064}},	//   _हर_, _oknu, yldu, _dhrò, 
   {{0xdb1a826b,0xbcfb03d9,0x61ee02f4,0x9f45817c}},	//   poté, _anéh, _tubl, _jilè_, 
   {{0x2b58008d,0x69c433dc,0x61fc0524,0x9f8d01c2}},	//   _iarc_, _okie, _utrl, nþá_, 
   {{0xa53496c0,0x2d9202fa,0xb6068533,0x29c4011e}},	//   хнич, nhye_, vošć, iñas_, 
   {{0x7e878116,0xa8c38103,0x2906b3dd,0x20c3b3de}},	//   _įspū, _айтд, mboa_, _айтм, 
   {{0x69d600db,0x798d33df,0x69c42037,0xb6068533}},	//   _ahye, _slaw, _akie, tošć, 
   {{0xa2c195ad,0xd01380cf,0x3218826b,0x798d01ea}},	//   _रुद्, _সময়_, éry_, _plaw, 
   {{0xe4a695eb,0xc486b3e0,0x68e48269,0xb6068c0e}},	//   _орло, _олек, židu, rošć, 
   {{0xa3e7823b,0xbf0a009b,0xc0582ce1,0x10741e0a}},	//   _मंच_, वरून_, мір_, вляю, 
   {{0x0efb33e1,0x2b5833e2,0x47cc80b2,0x533480a6}},	//   ्रेस_, _narc_, াদকী, _чект, 
   {{0x9e340188,0x52bf0c2e,0x9f4586e4,0x69c4008b}},	//   керч, _्रेस, _dilè_, _fkie, 
   {{0x58d533e3,0x9487005a,0x3dc90128,0xcdd802f0}},	//   _пойт, мызд, ulaw_, дњу_, 
   {{0x68ed0065,0x7d02033b,0x3dc933e4,0x6d428050}},	// [1e90] _igad, ñosa, rlaw_, _mboa, 
   {{0x6d978123,0x69dd33e5,0xdb0180c0,0xdb1c0a67}},	//   nţar, lmse, anlæ, _shrò, 
   {{0xb50e802a,0x7d0f33e6,0xe1f01866,0xdb1c0c9f}},	//   सराय_, _tecs, لسن_, _phrò, 
   {{0x320133e7,0x7dc5b3e8,0x645c80f3,0x68ed80e9}},	//   rphy_, nóst, ārij, ľado, 
   {{0x68ed826b,0x2b5833e9,0x2019019b,0x6008909a}},	//   žado, _farc_, nssi_, днім_, 
   {{0x657d33ea,0x7c2d33eb,0x7e559bc4,0xa49b0304}},	//   _hosh, muar, етиц, _feòr, 
   {{0x7c2d04c4,0xee398d38,0x2bbe093e,0x199581bc}},	//   luar, їни_, ्तरा, _завя, 
   {{0x68ed33ec,0x657d33ed,0x63a50883,0x6d878122}},	//   _ngad, _josh, lihn, _iñak, 
   {{0x657d33ee,0x3834898e,0x7c2d33ef,0xed598934}},	//   _mosh, _интр, nuar, rdž_, 
   {{0x69c433f0,0x68ed33f1,0xa3bf05b7,0x61e9b3f2}},	//   _skie, _agad, ँकि_, _hiel, 
   {{0x61e9b3f3,0xa2d3009b,0x60c982fa,0x2d8900db}},	//   _kiel, भेच्, _hyem, kkae_, 
   {{0x7c2d33f4,0x657d33f5,0xa3cf81a2,0x602629df}},	//   kuar, _nosh, _वीर_, ндма, 
   {{0x61e9b3f6,0xdb088530,0x656bb3f7,0xbcfb00fe}},	//   _miel, godó, _ingh, _gnéi, 
   {{0x61e9834a,0x7c2d33f8,0x7c3bb3f9,0xdb1e016c}},	//   _liel, duar, mtur, ropë, 
   {{0x657d0b1c,0x6d59b3fa,0x442db3fb,0x69d6016c}},	//   _bosh, _kawa, lue_, _thye, 
   {{0x6d5bb3fc,0x6d59846a,0x61e9b3fd,0x69c433fe}},	//   ndua, _jawa, _niel, _ukie, 
   {{0x2b5833ff,0x6d59b400,0x7c2d3401,0x6aa806ee}},	// [1ea0] _parc_, _mawa, guar, कप्र, 
   {{0x2912059e,0x2d92029a,0x6d5b80bf,0x7c3b99a4}},	//   _heya_, shye_, hdua, itur, 
   {{0x61e9b402,0x3ea63403,0x29120027,0xa9269e98}},	//   _biel, _чинг, _keya_, едел, 
   {{0x61e9b404,0x6d59a0ab,0xb17b0172,0xc05aa0e0}},	//   _ciel, _nawa, rmåg, зік_, 
   {{0xc7c698ed,0x4fc6b405,0x61e9890a,0x7d160ced}},	//   нски, нска, _diel, mays, 
   {{0x7d161761,0x656bb406,0xfaa60d66,0x2906a60c}},	//   lays, _angh, _заго, sboa_, 
   {{0x6d59b407,0x657d0004,0x1dcb87b0,0xd04e808a}},	//   _bawa, _yosh, ातंत, _ədəb, 
   {{0x7d160786,0x6d59b408,0x61e9808b,0xdd97b409}},	//   nays, _cawa, _giel, ешь_, 
   {{0x6d59b40a,0x442daccd,0x7c3ba849,0x73d8854e}},	//   _dawa, gue_, gtur, мдир_, 
   {{0x09c90baf,0x61e9b40b,0x1e969309,0xa0a3b40c}},	//   रत्य, _ziel, _прер, _сауд, 
   {{0x200d835b,0x0c7381a1,0x7c2d340d,0x2912340e}},	//   _zwei_, ندید, zuar, _beya_, 
   {{0x6d59b40f,0x6e2e3410,0xdce606e4,0xdb050093}},	//   _gawa, dubb, _ankč, gihê, 
   {{0x7c3b9c9d,0x7bc1b411,0x69dd3412,0x29123413}},	//   ctur, bolu, rmse, _deya_, 
   {{0x7bc1802d,0x6d59b414,0x20191610,0x212002ef}},	//   colu, _zawa, rssi_, _edih_, 
   {{0x5d6725e9,0x6d59b415,0xdb1a8188,0x86243416}},	//   нтаз, _yawa, notí, льте, 
   {{0x7d1608c6,0x657d3417,0xdb01b418,0x7c2201bb}},	//   gays, _qosh, vilé, ġorn, 
   {{0x61e9b419,0x63a5341a,0xb81ca1ab,0x6d4d341b}},	// [1eb0] _riel, tihn, _निगम_, reaa, 
   {{0x7c2d2932,0x61e9b41c,0x6e2e341d,0x3df5341e}},	//   ruar, _siel, bubb, _изос, 
   {{0x61e9b41f,0x657d08c6,0x442d8109,0xdb18810d}},	//   _piel, _tosh, zue_, _ikvä, 
   {{0x63a51b52,0x1c218689,0x61e9816c,0x27ff89fb}},	//   sihn, _मिलल_, _qiel, _ptun_, 
   {{0x61e9b420,0x6d59b421,0x7c2d3422,0x29d900fe}},	//   _viel, _rawa, quar, méad_, 
   {{0x61e9b423,0x6d598421,0xdce99287,0xbea58720}},	//   _wiel, _sawa, ljeć, калк, 
   {{0x44293424,0x61e9b425,0xead4019b,0xdb0181b2}},	//   lra_, _tiel, _борь, filî, 
   {{0x7c3b81dd,0x44293426,0x442db427,0x6d5980bf}},	//   ttur, ora_, tue_, _qawa, 
   {{0x44293428,0xe43280fe,0x7bc1b429,0x6d5bb42a}},	//   nra_, لفيد, tolu, rdua, 
   {{0x4429193a,0x6d59b42b,0x442db42c,0x394fb42d}},	//   ira_, _wawa, rue_, legs_, 
   {{0x09d60a87,0x6d59b42e,0x7bc1b42f,0x316d839f}},	//   _সংবা, _tawa, rolu, _knez_, 
   {{0x44293430,0xdb1e02c6,0x7bc1b431,0x656bb432}},	//   kra_, ropé, solu, _ungh, 
   {{0x442db433,0x2912017e,0x8edf00cf,0x44293434}},	//   que_, _veya_, _ব্লগ, jra_, 
   {{0x44293435,0x701380b2,0x7c29a3ca,0x317f834e}},	//   dra_, _সমাজ_, mrer, _louz_, 
   {{0x44293436,0x65b301d0,0x6da6161a,0x7d163437}},	//   era_, għho, вива, tays, 
   {{0x7d09ad01,0x89360a57,0x6e2e3438,0x12e880c6}},	//   nbes, _شعبا, rubb, _אַפּ, 
   {{0x44293439,0xa91d803b,0x7d16343a,0x28de0562}},	// [1ec0] gra_, _možd, rays, नेशि, 
   {{0x6e2e2eff,0x7d1616d4,0x0686343b,0x316d82ef}},	//   pubb, says, _агон, _anez_, 
   {{0x4429343c,0x7c2982ae,0xdce982cf,0x7d09876a}},	//   ara_, hrer, bjeć, kbes, 
   {{0x29d900fe,0x7d1604da,0x6fcd8a5e,0x637e80ac}},	//   céad_, qays, lúch, _záně, 
   {{0x7d09b43d,0x317f8401,0xe9478063,0x25789f4a}},	//   dbes, _douz_, ئرمی, _gély_, 
   {{0x5ead80cf,0xfaa604bc,0x7c29b43e,0xce6ab43f}},	//   য়েছে, _ҷаҳо, drer, дрид_, 
   {{0x6ae000cf,0x53a32060,0x7c29b440,0xfaa6004c}},	//   _প্রো, _тарб, erer, _раво, 
   {{0x6ce68d6b,0x7d09b441,0x7c298da7,0x5d549b2e}},	//   кіпе, gbes, frer, укит, 
   {{0xc0458275,0x7c29b442,0xdb1c01d2,0x395b0ced}},	//   _مخلو, grer, _zkrá, _raqs_, 
   {{0xf4130052,0x20068363,0xf366b443,0xd0078166}},	//   ספת_, mpoi_, ттин, _рефе_, 
   {{0xc3331af4,0x79808889,0x44293444,0x7d09b445}},	//   בות_, _komw, zra_, bbes, 
   {{0x7c29b446,0x316d3447,0x6f188bfc,0x442906bc}},	//   brer, ñez_, lavc, yra_, 
   {{0x44290519,0xe9df0065,0x79808889,0xdce98677}},	//   xra_, rmú_, _momw, vjeć, 
   {{0x44293448,0x9e353449,0x547b8039,0x79808889}},	//   vra_, легч, _קטגו, _lomw, 
   {{0xb8ca05b1,0x4429344a,0x2bb1809b,0x2bec0353}},	//   _गे_, wra_, ीकरा, _अंजू_, 
   {{0x44290696,0xa91d826b,0x7bc710bd,0x7e65344b}},	//   tra_, _kože, _skju, _vrhp, 
   {{0xdb1c344c,0x2919344d,0x6f188081,0xdcfb8284}},	// [1ed0] _skrá, masa_, kavc, skuć, 
   {{0xa91d803b,0x4ea71a72,0x8f55036a,0xdce99287}},	//   _može, _арма, _свої, sjeć, 
   {{0x4429344e,0x6f188524,0x61ed344f,0xa91d8183}},	//   sra_, davc, _kial, _lože, 
   {{0x44293450,0x29193451,0x673b0131,0xaa642b67}},	//   pra_, nasa_, đuju, штук, 
   {{0xa3c28560,0x61ed1982,0xa91d8524,0x6d5d3452}},	//   ंवा_, _mial, _nože, _iasa, 
   {{0x29191b52,0x7522b453,0x2489027e,0x2d82b454}},	//   hasa_, _adoz, myam_, öken_, 
   {{0x6d5d3455,0x29191314,0xe5a59096,0x7bc53456}},	//   _kasa, kasa_, лики, mohu, 
   {{0x7c29b457,0x29190215,0x61ed3458,0xe459930c}},	//   trer, jasa_, _nial, ежи_, 
   {{0x60cd3459,0x6f1880d7,0xa91d8f63,0x2919345a}},	//   _nyam, bavc, _vožd, dasa_, 
   {{0x7c29ae8c,0x6d5d345b,0x2bd90787,0x490b800d}},	//   rrer, _lasa, _बीमा, ारको_, 
   {{0x61ed345c,0x6fcd81ac,0x60cd073e,0x656f345d}},	//   _bial, júci, _ayam, _onch, 
   {{0x6d5d345e,0x2919345f,0x60cd1d76,0x7c29b460}},	//   _nasa, gasa_, _byam, prer, 
   {{0x44299aae,0x9b4585b6,0x343980c6,0x0d860103}},	//   _ía_, _منشو, _נײַע, қлан, 
   {{0x9474806f,0x656f11b7,0x443fb461,0x63a88215}},	//   _خدما, _anch, mtu_, cidn, 
   {{0xa2ca89d7,0x29193462,0x61ed16fd,0x2258806d}},	//   _सुप्, basa_, _fial, ærkt_, 
   {{0xed571be8,0x5bbe0dcf,0x61ed3463,0x5de63464}},	//   лос_, ्त्व, _gial, ужба, 
   {{0x443f90fd,0x69c63465,0x2bf680c6,0xbcfb0a1c}},	// [1ee0] ntu_, moke, ָמען_, _anés, 
   {{0x443fb466,0x69c63467,0xa09b03f3,0xe29a0c98}},	//   itu_, loke, _נייט, наз_, 
   {{0x443fb468,0x201f8188,0x35a63469,0x6da6346a}},	//   htu_, _avui_, _банг, _бина, 
   {{0x25a93367,0x6d5d346b,0x05560d66,0x644b80c0}},	//   cial_, _gasa, _стоя, _opgi, 
   {{0xdefa825b,0x443fb46c,0xa2ca9ede,0xbcfb033b}},	//   ный_, jtu_, _सुन्, _enés, 
   {{0x6d5d04a9,0xdb1c006d,0x69c6346d,0x7c2b14d7}},	//   _zasa, _skræ, hoke, ágre, 
   {{0x6d5d346e,0xb8eb800c,0xbb3b00c6,0x4432022c}},	//   _yasa, _रु_, _רעלי, luy_, 
   {{0xa91d85c3,0x6d5d02dc,0x69c6346f,0x6f18b470}},	//   _pože, _xasa, joke, savc, 
   {{0x61ed030b,0x63a88172,0x20e303f2,0x6f18b471}},	//   _rial, tidn, _गणेश_, pavc, 
   {{0x40938013,0xdeb0805a,0x25a93472,0x2d823473}},	//   _الكر, _құқы, zial_, _loke_, 
   {{0xf363b474,0x443fb475,0x69c63476,0x3f813477}},	//   стын, atu_, foke, _rohu_, 
   {{0x443fb478,0x443203d9,0x6288b479,0xa91d807e}},	//   btu_, kuy_, rydo, _tože, 
   {{0x2919347a,0x629ab47b,0x61ed347c,0x44320217}},	//   rasa_, szto, _vial, juy_, 
   {{0x6d5d0455,0x60cd15f3,0x4432347d,0x291929f4}},	//   _sasa, _vyam, duy_, sasa_, 
   {{0x6d5d347e,0xcddb1020,0x69c6347f,0x6d443480}},	//   _pasa, ења_, boke, ffia, 
   {{0x55580163,0x2d5809ba,0x6d5d3481,0x24893482}},	//   лася_, лись_, _qasa, tyam_, 
   {{0x6d5d3483,0x7bdc0089,0xdb0882fd,0x656080d8}},	// [1ef0] _vasa, _bhru, vidê, idmh, 
   {{0x6d5d3484,0x25a93485,0x7bdc0cb4,0x69c9b486}},	//   _wasa, sial_, _chru, _skee, 
   {{0x6d5d3487,0x443f8124,0x7ceb8019,0xdeb2005a}},	//   _tasa, ztu_, _körü, _дұры, 
   {{0x656f3488,0x44323489,0x6d5d0c8c,0x3d0e80a1}},	//   _unch, buy_, _uasa, सरों_, 
   {{0x65360273,0x443fb48a,0xf3ff02fd,0xb8fd9669}},	//   _דארף_, xtu_, _irão_, _डर_, 
   {{0x61f5348b,0x8ae70d6b,0xdb01b48c,0xdb0883b8}},	//   _tuzl, _бібл, tilí, sidê, 
   {{0xed59b48d,0x69dbb48e,0xb3c815c2,0x61fc811e}},	//   вой_, _thue, _слёз_, írll, 
   {{0x443f91f6,0x1425b48f,0x7c2d3463,0x7bdc03d5}},	//   ttu_, адим, orar, _zhru, 
   {{0x998480fe,0x443fb490,0x69c63491,0xa91d807e}},	//   _القو, utu_, voke, _tožb, 
   {{0x4a45b492,0x395fb493,0x443fb494,0x25a6b495}},	//   анов, _haus_, rtu_, _emol_, 
   {{0xa2cb3095,0x69c63496,0x2fc7b497,0x395fb498}},	//   _तुम्, toke, mong_, _kaus_, 
   {{0x9f49007f,0x7de7804a,0x7c2d3499,0x39490097}},	//   _stað_, _сізд, krar, _cbas_, 
   {{0x69c6349a,0xa2a710c7,0xeb8eb49b,0x2d82007e}},	//   roke, _टेस्, _ди_, _roke_, 
   {{0x7d1bb49c,0x2fc7b49d,0x395f81c8,0xa2e581e5}},	//   laus, nong_, _laus_, _колд, 
   {{0x66e6349e,0xeab00a87,0x69c60010,0xa3c2b49f}},	//   рова, _কর্ম, poke, ंवर_, 
   {{0x7ceb9068,0x2fc7b4a0,0x6b83b4a1,0x442d809f}},	//   _görü, hong_, _hong, ore_, 
   {{0x6b83b4a2,0x2fc7b4a3,0x7c2d0beb,0x6db70131}},	// [1f00] _kong, kong_, grar, pćan, 
   {{0x442db4a4,0x6b83b4a5,0xb6a60746,0x2fc7b4a6}},	//   ire_, _jong, _виол, jong_, 
   {{0x6f1c0607,0x6b83b4a7,0x442db4a8,0x2fc7b4a9}},	//   marc, _mong, hre_, dong_, 
   {{0xd946b4aa,0x442db4ab,0x7d1b9db0,0xdb1c0172}},	//   реди, kre_, jaus, _skrä, 
   {{0x61e281bb,0x7c2d002d,0x395f827e,0x442db4ac}},	//   rmol, crar, _daus_, jre_, 
   {{0x442d8e80,0x2fc7b4ad,0x4420060b,0x6b83b4ae}},	//   dre_, gong_, msi_, _nong, 
   {{0x395f827e,0xf8d3293f,0x91e683b8,0x6d478a63}},	//   _faus_, _सर्प, _вове, đjan, 
   {{0x442db4af,0x44200193,0x6f1c34b0,0x6b839f6b}},	//   fre_, osi_, harc, _aong, 
   {{0x57ea84a0,0x6b83b4b1,0x442d88b6,0x2fc7b4b2}},	//   _адам_, _bong, gre_, bong_, 
   {{0x442034b3,0xbea688cf,0x46a6809f,0x2fc7b4b4}},	//   isi_, _казк, _казв, cong_, 
   {{0x6b83b4b5,0x442db4b6,0x6440b4b7,0x6f1c34b8}},	//   _dong, are_, stmi, darc, 
   {{0x442db4b9,0x442034ba,0x8c46a1cb,0x7d1b8052}},	//   bre_, ksi_, _веде, caus, 
   {{0xfce68aff,0x6f1c2d7e,0x6b83b4bb,0x442034bc}},	//   _тодо, farc, _fong, jsi_, 
   {{0x6f1c22db,0x7c2d0012,0x8c1b83dd,0x6b838af6}},	//   garc, vrar, _יודי, _gong, 
   {{0x7c22b4bd,0x7bc8b4be,0x316034bf,0x61418019}},	//   _hvor, modu, _faiz_, náló, 
   {{0x4420022d,0x6b83b4c0,0x39152819,0x527b84fc}},	//   fsi_, _zong, _умир, _ינוא, 
   {{0x2fc7b4ad,0x7d0d34c1,0xe4e7036a,0x6b8380bb}},	// [1f10] yong_, rbas, рівн, _yong, 
   {{0x7c2d19a4,0x395fb4c2,0x6f1c34c3,0xd9bf83ff}},	//   rrar, _saus_, carc, एक्ट, 
   {{0x395fb4c4,0x442034c5,0x2bbe0439,0x442d8063}},	//   _paus_, asi_, ्तजा, zre_, 
   {{0x442034c6,0x442db4c7,0x2fc78b7b,0xdb088741}},	//   bsi_, yre_, wong_, sidè, 
   {{0x442034c8,0x2fc7844d,0x557600c6,0x395f81df}},	//   csi_, tong_, _הערן_, _vaus_, 
   {{0x442db4c9,0x645d34ca,0x06b280b2,0x7d02b4cb}},	//   vre_, _issi, য়েছি, _afos, 
   {{0x22950013,0xa6c997bb,0x7c22b4cc,0x395f806c}},	//   _الأس, ылка_, _avor, _taus_, 
   {{0x6b83b4cd,0x56b80039,0x2fc7b4ce,0x43950229}},	//   _song, יפון_, song_, _таҳс, 
   {{0x442dab88,0x6b83b4cf,0x7f8b0816,0x2fc7b4d0}},	//   ure_, _pong, _hüqu, pong_, 
   {{0x442d864f,0x291db4d1,0x31600b14,0x7c22b4d2}},	//   rre_, lawa_, _saiz_, _dvor, 
   {{0xa2ca809b,0x442d8019,0x6b83b4d3,0x6f1c34d4}},	//   _सुद्, sre_, _vong, varc, 
   {{0x442da805,0x291db4d5,0xd00a1e4b,0x442034d6}},	//   pre_, nawa_, леме_, ysi_, 
   {{0x6f1c34d7,0x8d5a8039,0x4420008a,0x31601ef8}},	//   tarc, _תכני, xsi_, _vaiz_, 
   {{0x291db4d8,0x6b838010,0x6b9aa2fa,0x649a004a}},	//   hawa_, _uong, chtg, ңтар_, 
   {{0x645d2224,0x291db4d9,0x2d9634da,0x7c228252}},	//   _assi, kawa_, брас, _zvor, 
   {{0x442034db,0x6da30071,0x6f1c34dc,0x2b4a00db}},	//   tsi_, писа, sarc, _sbbc_, 
   {{0x7b068068,0x442034dd,0x249f82cf,0x291db4de}},	// [1f20] _érté, usi_, nzum_, dawa_, 
   {{0x442031cd,0xa91db4df,0xa3dd80da,0x61e60bbf}},	//   rsi_, _roža, _थीम_, lmkl, 
   {{0x645d34e0,0xdb070019,0x25adb4e1,0x644f0149}},	//   _essi, ámár, kiel_, _epci, 
   {{0x291db4e2,0x3866806a,0xf1a5836a,0xa91d9144}},	//   gawa_, tvor_, орін, _poža, 
   {{0x53c78808,0x442034e3,0x25ad81ac,0x6d5634e4}},	//   रकाश, qsi_, diel_, meya, 
   {{0x6d562a06,0x60db8265,0x38cb803d,0xd8d700c6}},	//   leya, _dzum, دامی_, זונט_, 
   {{0x25ad82da,0x3f858ff0,0x7c22b4e5,0xe29a34e6}},	//   fiel_, _dolu_, _svor, _сав_, 
   {{0x656434e7,0xdd97adbf,0x6143b4e8,0xd943b4e9}},	//   ndih, йшы_, _неса, _неси, 
   {{0x91e38775,0x76438058,0x644434ea,0x3f858269}},	//   _хоте, atny, ntii, _folu_, 
   {{0x5c5b00c6,0x69df00f8,0x3f85839f,0x290200a1}},	//   נדיק, _shqe, _golu_, ecka_, 
   {{0xa91d92b2,0x64d5002a,0x25ad974d,0x6d5634eb}},	//   _možn, _दर्श, biel_, keya, 
   {{0x7c228507,0x25adb4ec,0x6444041a,0x7bc8b4ed}},	//   _tvor, ciel_, ktii, sodu, 
   {{0x399b0210,0xa3d80624,0x3f858085,0x6d560627}},	//   _nëse_, ाता_, _yolu_, deya, 
   {{0x0a948d6b,0x291d80a1,0xdbf1001b,0x2ca00269}},	//   _малю, zawa_, _příl, dzid_, 
   {{0xa14380f3,0x291d8896,0xfdc4002a,0xd6d9085a}},	//   šķir, yawa_, वकूफ, ęło_, 
   {{0x6d5600df,0x95cb0188,0x6d9c8a5e,0x69cd34ee}},	//   geya, ууга_, _déag, _ukae, 
   {{0x5fba94ba,0x212916ac,0x644400ed,0x4dd400d8}},	// [1f30] ेवाल, _idah_, gtii, ستفس, 
   {{0xdea40f2a,0x291db39d,0x6f1ab4ef,0x200902d9}},	//   _کیفی, wawa_, _netc, _itai_, 
   {{0x6d561928,0xd6d9003d,0x72b900d8,0x9f8402f4}},	//   beya, _خودش_, جهاز_, töö_, 
   {{0x6ab90c2e,0x291d804f,0x8f5500df,0x2d8680bc}},	//   _आशीर, uawa_, _انگش, _nooe_, 
   {{0xf770842b,0x25adb4f0,0x6d9c80fe,0xaacf910f}},	//   کان_, viel_, _méad, _सुनक, 
   {{0x291db4f1,0x3f69804c,0x6d4b8645,0x25ad9752}},	//   sawa_, рико_, _sbga, wiel_, 
   {{0x29020172,0xfebb815e,0x623434f2,0x19958162}},	//   ycka_, داشت_, _неру, _давя, 
   {{0x200903bf,0x7dc58019,0x23633117,0x7643b4f3}},	//   _otai_, lósz, _hajj_, rtny, 
   {{0xa2b901b7,0x25adb4f4,0x92e680b2,0xb17b0072}},	//   ्थव्, riel_, যুৎ_, rmål, 
   {{0x42259966,0xb17b0ff7,0x25adb4f5,0x764380db}},	//   одов, smål, siel_, ptny, 
   {{0x80d100cf,0x6d5634f6,0x25adb4f7,0x09b580c6}},	//   সেম্, yeya, piel_, ַפֿט_, 
   {{0x6d9cb4f8,0x6444019b,0x684603ad,0xbc758a50}},	//   _réag, ytii, онма, _وهاب, 
   {{0xe45f025b,0x10a334f9,0x6d5634fa,0x65642f47}},	//   _myös_, диян, veya, vdih, 
   {{0x6d56162c,0x1af385a2,0x6d498a5e,0x212934fb}},	//   weya, _আজকে_, lfea, _edah_, 
   {{0x59c98a9a,0xba77807b,0x2d8007b8,0xb8d108dd}},	//   िकार, _داشت, tjie_, _टे_, 
   {{0x6444036d,0x753ba601,0x29d900d8,0xdcfb8533}},	//   ttii, nguz, néal_, kjuč, 
   {{0x92d600cf,0xd4671972,0x3b8601e4,0x8c4334fc}},	// [1f40] _হলে_, оите_, олаг, мете, 
   {{0x213f80e5,0xa91db4fd,0x6d56044e,0x644434fe}},	//   _acuh_, _božo, seya, rtii, 
   {{0xe8fab4ff,0x64443500,0x290484e2,0x69cb9afb}},	//   але_, stii, _pfma_, foge, 
   {{0x6f1a82e8,0x64443501,0x7d1f02d1,0x3860008b}},	//   _setc, ptii, caqs, _ksir_, 
   {{0xe0568275,0xa91d807e,0x29d900d8,0x386d89e6}},	//   تخاب, _tožn, déal_, _crer_, 
   {{0x4432011a,0x9e0694b9,0x7c243502,0x7d043503}},	//   mry_, очил, msir, lcis, 
   {{0xdd9a84b6,0x41ca26f9,0x69cbb504,0xbf9b0035}},	//   иши_, रवास, boge, mpêt, 
   {{0x69cbb505,0xed59942b,0x7d043506,0x44323507}},	//   coge, kožu_, ncis, ory_, 
   {{0x7c243508,0xdb1e006d,0xc31e80b2,0x6d9c80d8}},	//   nsir, ropæ, _দাবি_, _réad, 
   {{0x7792807b,0x0b8ab509,0x7c24350a,0x44320766}},	//   _زیبا, рсии_, isir, iry_, 
   {{0x9d46817d,0x2009350b,0x44320170,0xe3b8a459}},	//   _межд, _stai_, hry_, rnı_, 
   {{0x96338612,0x443201b0,0x7c24350c,0xa194109a}},	//   _ініц, kry_, ksir, даюч, 
   {{0x92d600cf,0xa2ca800c,0x9f4c801b,0x7c240524}},	//   _হলো_, _सुर्, _lidí_, jsir, 
   {{0x442685c3,0x443210ab,0xc05800f0,0x69cb82ae}},	//   _ivo_, dry_, цію_, zoge, 
   {{0x4426b50d,0x69cb82ee,0xddab0123,0x61fc066c}},	//   _hvo_, yoge, атал_, _nurl, 
   {{0x21290365,0x7c24350e,0x394002a6,0x4432120a}},	//   _udah_, fsir, _gcis_, fry_, 
   {{0xb9c40013,0x6fca8562,0x78a288dc,0x3959350f}},	// [1f50] _تقيي, ाकां, jzov, mess_, 
   {{0x09b38560,0x69cb8371,0x39593510,0x63ba81ed}},	//   ंच्य, woge, less_, nntn, 
   {{0x44323511,0xe7f9009b,0x46d20d57,0xd175801d}},	//   ary_, ंदवा_, _दुपह, зылы, 
   {{0x44268025,0x39593512,0xe1f82b8b,0x4432099a}},	//   _ovo_, ness_, ігі_, bry_, 
   {{0xa069aa4c,0x18699d48,0xa2cb3513,0xf994025e}},	//   сала_, сали_, _तुर्, ורף_, 
   {{0x7d1d18fb,0x69cbb514,0x23fa0039,0x29dc811e}},	//   _hess, soge, _להשא, ríaa_, 
   {{0x61fc3515,0x442680de,0xc7b40039,0xa3d800da}},	//   _gurl, _avo_, ובס_, ातर_, 
   {{0xc4859309,0xac858a53,0x4c858703,0xf1c00507}},	//   злик, згил, злив, čák_, 
   {{0x7d1d11c3,0xe3b1803f,0x937980fe,0x29d93516}},	//   _mess, فرد_, مصدر_, réal_, 
   {{0xf8ae80dd,0x29dc85cb,0x798980d0,0x6379a5e9}},	//   _حکم_, nían_, _hoew, ссир_, 
   {{0x4426803b,0x799bb517,0x8a058116,0xdb08891e}},	//   _evo_, _kluw, язне, cidí, 
   {{0x7d1d1f7e,0x764700c0,0xe61080df,0xbcfb003d}},	//   _ness, dtjy, _ششم_, _saén, 
   {{0xb4fa8039,0x764b8116,0x92b590ac,0xdb018656}},	//   _הפני, žnyč, تحکا, tilä, 
   {{0xfaa5a3f0,0x7c2404da,0x44323518,0xed59a101}},	//   _нало, vsir, vry_, lež_, 
   {{0x70b895ad,0x7d1d02ae,0x29dc860e,0x2d963519}},	//   _अश्ल, _bess, dían_, прас, 
   {{0xf99f351a,0x3959351b,0x7c24051e,0x7d1d351c}},	//   chè_, cess_, tsir, _cess, 
   {{0x7d1d351d,0x443203ec,0x7d04351e,0xb602011e}},	// [1f60] _dess, ury_, rcis, ñába, 
   {{0x4432351f,0xa01b0008,0xe7f93520,0x29dc8685}},	//   rry_, pyör, ंदरा_, gían_, 
   {{0x4efb0052,0xe7170052,0x61e41637,0x7c243521}},	//   _להיו, _מחיר_, _khil, ssir, 
   {{0xc693096e,0xd7fa8826,0x7d1d3522,0xdb08aaf9}},	//   _נאר_, бук_, _gess, vidí, 
   {{0x29dc82ba,0xa304004a,0x61e40c8c,0xed5991cf}},	//   bían_, _жүзе, _mhil, dež_, 
   {{0xc7a38223,0x61fc0004,0xa2a73523,0x29dc860e}},	//   ничк, _turl, _टेक्, cían_, 
   {{0x442687e9,0x656602b9,0x7d1d3524,0xdb1e01ed}},	//   _svo_, _kakh, _yess, ropä, 
   {{0x2abb0039,0x2d9fb525,0x4426931f,0x25a000db}},	//   _המלא, ghue_, _pvo_, nhil_, 
   {{0x65663526,0x3a3a0208,0x2122047f,0xdb08a69b}},	//   _makh, lupp_, dakh_, sidí, 
   {{0xe44f8013,0x65663527,0x61e43528,0x6f1e0533}},	//   اضي_, _lakh, _ahil, _nepc, 
   {{0x39590208,0x25a00481,0x61e40c8c,0xfbab8034}},	//   tess_, khil_, _bhil, टोधम, 
   {{0x65663529,0x61e4352a,0x442681c2,0xada3a9df}},	//   _nakh, _chil, _tvo_, _пахл, 
   {{0x7d1d352b,0xa91da98f,0x61e418df,0x3959352c}},	//   _ress, _božj, _dhil, ress_, 
   {{0x6d9c8013,0x3959352d,0x7d1d352e,0xa91db52f}},	//   _féac, sess_, _sess, _rožm, 
   {{0x7d1d00b0,0x65663530,0xd3e582e5,0x29dc8530}},	//   _pess, _bakh, _تقوی, vían_, 
   {{0x61e43531,0xbcfb03b9,0xdb08875d,0x98b901a8}},	//   _ghil, _gaél, lidà, nesī_, 
   {{0x6ecd0f82,0x29dc8530,0x6c543532,0x69cf0170}},	// [1f70] _दुरु, tían_, нкту, moce, 
   {{0x7d1d0c20,0x69c0811b,0x889c0309,0x7e6100c0}},	//   _wess, _ajme, _לבחי, ælps, 
   {{0x29dc8422,0x7d1d3533,0xecf90612,0xbb8400fe}},	//   rían_, _tess, _менш_, علمي, 
   {{0x25a03534,0x6f1e3535,0x69cf2e8d,0xbcfb02ef}},	//   chil_, _zepc, noce, _kaém, 
   {{0xa3ccb536,0x1b2280b2,0x6d4d00db,0x23780105}},	//   लवा_, _মানে_, mfaa, _fnrj_, 
   {{0x2d8b061e,0x65663537,0x6d4d3538,0x21221651}},	//   _hoce_, _zakh, lfaa, zakh_, 
   {{0x656602d7,0xb8f4ad9f,0x6b83007f,0x443b3539}},	//   _yakh, _सु_, öngu, luq_, 
   {{0x6d4d353a,0x2409b53b,0x6d9c80ef,0x799b80e5}},	//   nfaa, онии_, _réac, _uluw, 
   {{0xcc8980df,0x3f818341,0x1c428656,0xd469b53c}},	//   زنده_, öhus_, вным, ципе_, 
   {{0x61e42cce,0x2d8b0065,0x69d9b53d,0x7d038063}},	//   _shil, _loce_, llwe, _bíró, 
   {{0x52db353e,0x61e4353f,0x7e7e8172,0xed598257}},	//   _भरोस, _phil, äppt, pež_, 
   {{0x2d8b3540,0x69cf3541,0xdb088432,0x2d829b2a}},	//   _noce_, goce, tidã, öket_, 
   {{0x65663542,0xa3bf2910,0x81c200b2,0x69d98129}},	//   _rakh, ुका_, ্গল_, ilwe, 
   {{0x82358c0b,0x6723b543,0x61e40052,0xe299b544}},	//   _قربا, nanj, _whil, _мал_, 
   {{0x02058004,0x61e43545,0x2d8b0131,0x25a003a5}},	//   _ўзин, _thil, _boce_, thil_, 
   {{0x6569852a,0x6723b546,0x291f822a,0x68fb8421}},	//   ndeh, hanj, _neua_, _ngud, 
   {{0x6449b547,0x67238f4e,0xbfc610e6,0x2d8b3548}},	// [1f80] ntei, kanj, _обик, _doce_, 
   {{0x61b89ac2,0x65660232,0xd9b886ee,0x212d80bf}},	//   ेक्ष, _wakh, ेक्ट, _adeh_, 
   {{0x6da6005a,0x23678bfc,0x64498e53,0x35a633de}},	//   _жина, _manj_, htei, _жанг, 
   {{0xe0daa763,0x2d8b32c8,0x6449b549,0x3a3a354a}},	//   ове_, _goce_, ktei, rupp_, 
   {{0x2603929b,0xdcb9036d,0x4fc6b54b,0xc7c69892}},	//   _año_, _ещё_, мска, мски, 
   {{0x09bb053d,0x31bb237d,0x6d42802d,0x65699130}},	//   _उद्य, _उद्ध, _scoa, edeh, 
   {{0x9f4c811e,0x6e3c0149,0xc34e8106,0x45d48e31}},	//   _cidá_, nurb, _bổng_, нокс, 
   {{0x7176840c,0xc34e801c,0x6449b54c,0x21200050}},	//   _تهرا, _cổng_, ftei, _neih_, 
   {{0xe043b54d,0x13f490ea,0x29e8808a,0x69cf354e}},	//   _инти, нзия, _uşaq_, voce, 
   {{0x6723803b,0x9696809f,0x752400de,0x547b03f3}},	//   canj, _ореш, haiz, קטיו, 
   {{0x69cf354f,0xa3e606d7,0xd3370039,0x752401cb}},	//   toce, _पठन_, וריה_, kaiz, 
   {{0x3872120e,0x7c3b8d00,0x75240269,0x2b9b8093}},	//   _bryr_, buur, jaiz, _vêca_, 
   {{0x3f8cae80,0x14e2a074,0x2d8b001b,0xdb1c07f2}},	//   _kodu_, _परिण, _roce_, _skrý, 
   {{0xeaaf842b,0x61ee01ac,0xac97807b,0x36d52a16}},	//   اعی_, _ďale, _تنها_, еогр, 
   {{0x2bbf156f,0x3f8cb550,0xdce28770,0x9f45811e}},	//   ्वसा, _modu_, _maoč, _pilú_, 
   {{0x23678864,0xa2ad800d,0x7bdab551,0x7d160a91}},	//   _zanj_, ुपर्, lltu, gbys, 
   {{0x2d8b16eb,0xf1bf026b,0x33753552,0xab750103}},	// [1f90] _voce_, mná_, нгар, нгаш, 
   {{0xdce2861e,0xf1bf027b,0xa3e48056,0x291f8741}},	//   _naoč, lná_, _भीम_, _seua_, 
   {{0x443b2d00,0x6e3c2f31,0xaad4802a,0xe3c300b2}},	//   suq_, curb, _ठुमक, ্গলব, 
   {{0x59f9896e,0xf1bf0efd,0xa91d97b2,0x672386a2}},	//   פּעד, nná_, _koži, wanj, 
   {{0x67238025,0x443b09e2,0x3f8c8170,0xdb0e033f}},	//   tanj, quq_, _bodu_, _ombè, 
   {{0xf77180fe,0xa3dd80a1,0x28b201a2,0x23dda8ed}},	//   طات_, _थीं_, ीपति, _नींद, 
   {{0x6723b553,0x92c280b2,0xe91980f0,0xa91db554}},	//   ranj, ্ধু_, _нові_, _loži, 
   {{0x6449b555,0xf1bf05e1,0x6d40b556,0x212d82fa}},	//   ttei, jná_, ggma, _udeh_, 
   {{0x44293557,0xf1bf0791,0x65699b06,0x23679a90}},	//   nsa_, dná_, rdeh, _panj_, 
   {{0x44293558,0x6449b559,0x7c3bb55a,0x2d8280f9}},	//   isa_, rtei, ruur, öker_, 
   {{0x4429355b,0xd9463144,0xc34e8028,0xfbd20039}},	//   hsa_, нени, _tổng_, רתי_, 
   {{0x5694b55c,0x3f878024,0x216a355d,0x6449b55e}},	//   _шахт, ljnu_, чими_, ptei, 
   {{0xaacf8a9a,0x442915f1,0xb90814a1,0x25bf802d}},	//   _सुरक, jsa_, _भर_, mnul_, 
   {{0x6601b55f,0x7d0991f4,0x44293560,0x7c29b561}},	//   _kulk, lces, dsa_, mser, 
   {{0x44292f92,0x6601836d,0x7c29b562,0xe299b563}},	//   esa_, _julk, lser, _хай_, 
   {{0x66018103,0xf1bf0170,0x44293564,0x6d9c9f64}},	//   _mulk, cná_, fsa_, _léan, 
   {{0x7c29b565,0x64a3163d,0x44293566,0xb4ea009b}},	// [1fa0] nser, гата, gsa_, मधे_, 
   {{0xa3c1800f,0x6721844f,0x6d9cb567,0xf40180cf}},	//   ्कि_, _nelj, _néan, _এবার_, 
   {{0x44293568,0x1b1f00b2,0xdb1c0034,0x7d098034}},	//   asa_, _পাশে_, _skró, kces, 
   {{0x7d0980d7,0x4429210c,0x9965804a,0xf1a99d06}},	//   jces, bsa_, ктіл, وانه_, 
   {{0x1b1f00cf,0x44293569,0xe814009b,0x6721b3b6}},	//   _পারে_, csa_, तीचा_, _belj, 
   {{0x6d9c80fe,0x7c29b56a,0x67218bfc,0x7dde80f8}},	//   _céan, dser, _celj, tëso, 
   {{0x6d9c830b,0xa3b501d4,0xa3bf0a9f,0xa2e3356b}},	//   _déan, _जगत_, ुकर_, _борд, 
   {{0xa2ca8ab3,0x7dde80f8,0x7bc3b56c,0x66018162}},	//   _सुग्, rëso, _ajnu, _dulk, 
   {{0x7c29b56d,0xf1bf0a5b,0xb7da85b6,0xe73ab56e}},	//   gser, vná_, _فورا_, _неа_, 
   {{0xc45380fe,0x1fb58198,0x6d9cb56f,0x7ae384e2}},	//   اضيع, _исхр, _géan, _bznt, 
   {{0xf1bf003e,0x7c2989ec,0x68e43570,0x7dde816c}},	//   tná_, aser, _azid, qëso, 
   {{0x44293571,0x672180d7,0xa91db572,0x23a40172}},	//   ysa_, _zelj, _poži, _höjd_, 
   {{0x55778273,0xf1bf003e,0xa3d007b0,0x6601b573}},	//   _רעדן_, rná_, शवा_, _zulk, 
   {{0xe47b8130,0x5334b574,0xf1bf026b,0x68e43575}},	//   _מרדכ, _рект, sná_, _dzid, 
   {{0x68e41a4d,0xf1bf026b,0x44293576,0x67e0010d}},	//   _ezid, pná_, wsa_, möjl, 
   {{0x44293577,0x13d580b2,0xa3e48c2e,0xa91d83d0}},	//   tsa_, _হওয়, _भीत_, _toži, 
   {{0x24580008,0x41c40c85,0x98b90162,0x8e20804a}},	// [1fb0] нать_, _حقيق, mesį_, тiк_, 
   {{0x69dd0015,0x23a40172,0x236a0149,0xf11980c9}},	//   llse, _nöjd_, _cabj_, दर्द_, 
   {{0x44293578,0xa2d40f2c,0x6d9cad71,0x3a3e82fa}},	//   ssa_, _बुद्, _réan, nutp_, 
   {{0x44293579,0xc984b348,0x5184b57a,0x7c29b57b}},	//   psa_, лучи, луча, yser, 
   {{0x349400ce,0x657d357c,0x6601b57d,0x6721ad89}},	//   _баяр, _insh, _sulk, _pelj, 
   {{0x7c29b57e,0x6601b57f,0x6d5f1837,0xb17b0341}},	//   vser, _pulk, leqa, llåd, 
   {{0x644d3580,0x6721b581,0xbbbf138e,0x7c29b582}},	//   ltai, _velj, ्वीक, wser, 
   {{0x6d5f10a3,0x7c29b583,0x67273584,0x644d3585}},	//   neqa, tser, hajj, otai, 
   {{0x6721b586,0x644d3587,0x9f530188,0xa3b50671}},	//   _telj, ntai, _així_, _जगा_, 
   {{0x6601b588,0x7d0981e9,0x4375b589,0x67272aea}},	//   _tulk, sces, туит, jajj, 
   {{0x644d358a,0x7c29b58b,0x2d891b95,0x61e982a6}},	//   htai, sser, kjae_, _khel, 
   {{0xe2969339,0x7c298531,0x644d358c,0x60dbb58d}},	//   таю_, pser, ktai, _kyum, 
   {{0x656d358e,0x6d5f0766,0x2ca9358f,0x8c45b590}},	//   ddah, deqa, jzad_, _реле, 
   {{0x656b8013,0x644d3591,0x2d8f8a44,0x69dd0079}},	//   _hagh, dtai, _hoge_, alse, 
   {{0x443fb592,0x644d0162,0x6d460128,0x9f4580d8}},	//   luu_, etai, _pcka, _chlé_, 
   {{0xdde9003d,0xfce6164d,0x2d8fb593,0x656d3594}},	//   فرقه_, вобо, _joge_, gdah, 
   {{0x60dbb595,0x656bb596,0x443f90e9,0xdb1a816f}},	// [1fc0] _nyum, _magh, nuu_, cotó, 
   {{0x4e0608f9,0x656b8094,0xe29a3597,0x657d012c}},	//   _изоб, _lagh, маз_, _ensh, 
   {{0x23a400f9,0x6a86009f,0x644d0336,0x3ea63598}},	//   _nöje_, ължа, atai, _ринг, 
   {{0x61e9b599,0x443f9a19,0xc05a805a,0x656b98bd}},	//   _chel, kuu_, дік_, _nagh, 
   {{0xd0078574,0x92bd80cf,0x644d2f6a,0x61e9b59a}},	//   вече_, _আরো_, ctai, _dhel, 
   {{0xdefab409,0x6d44359b,0x244b806d,0xafdb03cd}},	//   мый_, lgia, døm_, støv, 
   {{0x764e359c,0x6459817c,0x61fb8166,0xacbb0429}},	//   ntby, _apwi, _fiul, _jeûn, 
   {{0x6d44359d,0xd49a84bc,0x61fbb59e,0x2d8f81ce}},	//   ngia, дро_, _giul, _coge_, 
   {{0x80e101ff,0x656bb59f,0x443f804f,0x9f4c819b}},	//   _नरें, _dagh, guu_, _pidä_, 
   {{0x6d44248a,0xb4e2812d,0x5fb68079,0xa91d811b}},	//   hgia, _धरी_, _अगिल, _dožu, 
   {{0x75228265,0x46d235a0,0x656bb5a1,0x19950994}},	//   _teoz, _दुलह, _fagh, ганя, 
   {{0x2004a684,0x80d100b2,0x61e980f8,0xf2d313b1}},	//   _kumi_, _সৃষ্, _xhel, יעת_, 
   {{0x8c4380f1,0x1d0796df,0x656d35a2,0xb17b010d}},	//   _вече, _речи_, vdah, vlåd, 
   {{0xc7c4088c,0xa2cb009b,0x6440b5a3,0x4fc435a4}},	//   асси, _तुझ्, mumi, асса, 
   {{0x6440b5a5,0xa3c1812e,0x6d9c80fe,0x2004b5a6}},	//   lumi, ्कर_, _léam, _lumi_, 
   {{0x6d440574,0xa2b80f21,0x644d036d,0xa3b5075c}},	//   ggia, ्पन्, ttai, _जगह_, 
   {{0x6d9c9579,0x656d35a7,0x6440b5a8,0x3b55041f}},	// [1fd0] _réal, rdah, numi, лкар, 
   {{0x644d35a9,0x61fbb5aa,0xbbbf000c,0x765a8034}},	//   rtai, _siul, ्वेक, _opty, 
   {{0x6440822d,0x61e983ec,0xce9502bb,0x60dba736}},	//   humi, _phel, _санъ, _syum, 
   {{0x6440b5ab,0x99d180b2,0x657d35ac,0x61e98129}},	//   kumi, িষ্ক, _unsh, _qhel, 
   {{0x7c842a1d,0x64408029,0x656bb5ad,0x200480bb}},	//   _куре, jumi, _ragh, _cumi_, 
   {{0xb60583e0,0x6440b5ae,0x7d0d35af,0x2004b5b0}},	//   hláš, dumi, lcas, _dumi_, 
   {{0x656b98bd,0x61e9b5b1,0x28da1131,0x7d0d02fb}},	//   _pagh, _thel, _युनि, ocas, 
   {{0x4efc0052,0x443f8008,0x3949022a,0xa91d8131}},	//   ולוג, tuu_, _ncas_, _požu, 
   {{0x6440b5b2,0xa3d8009b,0xa3c18b30,0x60dbb5b3}},	//   gumi, ातच_, ्कल_, _uyum, 
   {{0x443fb3cc,0x244b872c,0xceeb8a57,0x7d0d0097}},	//   ruu_, røm_, _قران_, hcas, 
   {{0xe299b5b4,0x386935b5,0x656bb5b6,0x20049536}},	//   хан_, _asar_, _tagh, _zumi_, 
   {{0x98b20816,0xe5708604,0x6440b5b7,0x443f84bb}},	//   _sayı_, _وطن_, bumi, puu_, 
   {{0xad9b1e52,0x644092dd,0x7c2d0341,0xc8b61588}},	//   _miúd, cumi, jsar, усны, 
   {{0x442db5b8,0x7c2d0bfa,0x39490a1c,0x6c328063}},	//   mse_, dsar, _ecas_, _افوا, 
   {{0x442db5b9,0xd5ac8068,0x3869013b,0x7d1b8090}},	//   lse_, _رہی_, _esar_, obus, 
   {{0xceb283dd,0x442db5ba,0x2900011e,0x69c38063}},	//   צין_, ose_, _ugia_, énel, 
   {{0x442db5bb,0x69db0273,0x707700fe,0x7c3b8065}},	// [1fe0] nse_, _אַזו, _مميز_, nrur, 
   {{0x442db5bc,0x6d9c80fe,0x1c1bb2e3,0x442fb5bd}},	//   ise_, _réam, पीएल_, _mvg_, 
   {{0x6440b5be,0x442db5bf,0x77f70039,0xdb9a80c6}},	//   zumi, hse_, _תמיד_, עסער, 
   {{0x442db5c0,0x9f5a06e0,0x7d0d02fb,0xafdb03cd}},	//   kse_, _sipè_, ccas, støt, 
   {{0x64e2823b,0x25d70039,0x442db5c1,0x69c2b5c2}},	//   _परेश, _תוכן_, jse_, rnoe, 
   {{0x38cb9272,0x442db5c3,0xb7d280b2,0x6440b5c4}},	//   رانی_, dse_, াষ্ট, vumi, 
   {{0xfaa60974,0x7bcb32df,0x499482e5,0x316d80bf}},	//   _саво, égue, _پیشر, _faez_, 
   {{0x6440b5c5,0x6d9c80fe,0x6281008d,0x7d1bb5c6}},	//   tumi, _téam, _šlog, gbus, 
   {{0x5b26ad75,0xd32698e4,0x442db5c7,0x1e86805a}},	//   льна, льни, gse_, _әлем, 
   {{0x6440b5c8,0xf366a349,0x7fd6a0e0,0x3946b5c9}},	//   rumi, утин, _сібі, lgos_, 
   {{0x442db5ca,0x7c2d0029,0xafdb072c,0x7dde816c}},	//   ase_, zsar, ktør, hësi, 
   {{0x3946b5cb,0x7dde816c,0x442f82fb,0xbcfb0580}},	//   ngos_, kësi, _fvg_, _kaét, 
   {{0x7c3b802d,0xc5f38039,0x442db5cc,0x660502f4}},	//   crur, _הדף_, cse_, _suhk, 
   {{0x6ed61e2d,0x66051fa0,0xb8fd35a0,0xb8dd03ca}},	//   _मुहु, _puhk, _तँ_, _आध_, 
   {{0x442235cd,0x7c2d1917,0x394900bf,0x7dde816c}},	//   _awk_, wsar, _tcas_, tësh, 
   {{0x63ba83e0,0x7c2d052a,0x442214c7,0x27ec80f6}},	//   litn, tsar, _bwk_, _lhdn_, 
   {{0x386903bc,0x7d0d18a2,0x69c382c0,0x26de80db}},	// [1ff0] _usar_, rcas, énem, _lyto_, 
   {{0x212b35ce,0x3946b5cf,0x63ba9c35,0x44f435d0}},	//   lach_, egos_, nitn, спус, 
   {{0x7c2d35d1,0x61ed35d2,0x316d8149,0xf1ca0f8a}},	//   ssar, _khal, _paez_, रवचन, 
   {{0x212b35d3,0x7c2d35d4,0x442db5d5,0xd5671d51}},	//   nach_, psar, yse_, _стоп, 
   {{0x39498029,0x1869817f,0x63ba9637,0x61ed12dc}},	//   ļas_, тали_, kitn, _mhal, 
   {{0x212b0089,0x656f35d6,0xe736b5d7,0x25a935d8}},	//   hach_, _hach, аеш_, lhal_, 
   {{0x656f35d9,0x212b1a5e,0x244f06c8,0x3ea5b5da}},	//   _kach, kach_, lüm_, рийг, 
   {{0x442db5db,0x629a8da2,0x212b0034,0x2bbf0bc2}},	//   tse_, dyto, jach_, ्वका, 
   {{0x212b35ce,0x291db5dc,0x656f35dd,0x442db5de}},	//   dach_, mbwa_, _mach, use_, 
   {{0x656f35df,0xe7a983ce,0x61ed35e0,0x63bab5e1}},	//   _lach, _कतिप, _ahal, gitn, 
   {{0x61ed35e2,0x26e4000d,0x4acf87b0,0xf9862b71}},	//   _bhal, _गरेर_, _सुखव, агно, 
   {{0x656f35e3,0x442db5e4,0x645d35e5,0x442f84e0}},	//   _nach, pse_, _opsi, _tvg_, 
   {{0x61ed35e6,0x764381e5,0x15f48501,0x25a905c7}},	//   _dhal, luny, _اسلح, dhal_, 
   {{0x629ab5e7,0x656f35e8,0x63ba9c35,0x7fd6004a}},	//   byto, _aach, citn, рімі, 
   {{0x656f3542,0xb8fd0964,0x645d0116,0x212b35e9}},	//   _bach, _तु_, _apsi, bach_, 
   {{0x7dde8210,0x61ed35ea,0x3d2000a1,0x25a90c9f}},	//   tësi, _ghal, बरें_, ghal_, 
  
   {{0x656f35eb,0x032635ec,0x8c4635ed,0x044600f0}},	// [2000] _dach, идан, резе, резн, 
   {{0x7dde8210,0x656f0b10,0xd76402e5,0x69db8c4e}},	//   rësi, _each, _اندی, _akue, 
   {{0x32078188,0x656f35ee,0x34e28b45,0x76438a00}},	//   _juny_, _fach, _पर्द, juny, 
   {{0x25a910c6,0x39468116,0xd2e603b4,0x7dde816c}},	//   chal_, ugos_, _करीब_, pësi, 
   {{0x39469f28,0x7dde80f8,0x8eb3003d,0xa91da05a}},	//   rgos_, qësi, _همیش, _požr, 
   {{0x656f35ef,0x81bd0029,0x394685cb,0x087700c6}},	//   _zach, lsēt, sgos_, יענט_, 
   {{0x656f35f0,0x76438dc3,0x5694b5f1,0xee868741}},	//   _yach, guny, сайт, рыло, 
   {{0x63bab5f2,0x6d5606e0,0x645d02fb,0x25a035f3}},	//   witn, nfya, _ypsi, nkil_, 
   {{0x88bd8066,0x2fd80172,0x77638065,0xef86b5f4}},	//   _jeśl, korg_, benx, _клап, 
   {{0x29120010,0x386980f8,0x26de801b,0x321a01e9}},	//   _afya_, çare_, _tyto_, oppy_, 
   {{0x212b35f5,0xc33307a6,0x61ed35f6,0x7643b5f7}},	//   tach_, חות_, _phal, cuny, 
   {{0x7d028025,0x7c2280a1,0x29dc8530,0x61e28786}},	//   _ugos, _twor, mías_, nlol, 
   {{0x212b35f8,0x29dc8530,0x6728b5f9,0xa49b0a1c}},	//   rach_, lías_, _kedj, _agòn, 
   {{0x212b35d3,0x656f35fa,0x2d8235fb,0x644f80a6}},	//   sach_, _sach, _anke_, àcie, 
   {{0x656f35fc,0x61ed1f98,0x6728b5fd,0x29dc8530}},	//   _pach, _thal, _medj, nías_, 
   {{0x67288081,0x61ed004f,0x656f35fe,0xdda8002d}},	//   _ledj, _uhal, _qach, атул_, 
   {{0x2fd835ff,0x656f3600,0x25a93601,0x61e28128}},	// [2010] borg_, _vach, rhal_, dlol, 
   {{0x656f3602,0x67288301,0x9f5e8210,0xa3e681c7}},	//   _wach, _nedj, _ditë_, पति_, 
   {{0x656f3603,0x68e98019,0x2001013b,0x7ff41d06}},	//   _tach, _szed, _iihi_, _بسيا, 
   {{0x656f1b0d,0x76439c8a,0x29dc860e,0x2cad80db}},	//   _uach, vuny, días_, yzed_, 
   {{0xe739b604,0xa3e680c9,0xa2d88562,0x68e08324}},	//   гел_, पता_, _नुस्, _cymd, 
   {{0x785a8029,0x7643a55b,0x29dc82ba,0x8a17007b}},	//   dāvā, tuny, fías_, _نظرا, 
   {{0xf7708743,0x29dc85cb,0xed5996c6,0x77638065}},	//   بان_, gías_, гой_, renx, 
   {{0xa3b30611,0x7643a896,0x2fd800fa,0x0d859c78}},	//   जोर_, runy, zorg_, слин, 
   {{0xbee403ce,0x7643b605,0x68e0811a,0x69d9b606}},	//   _गर्न_, suny, _gymd, mowe, 
   {{0xe7848c1f,0x76438b64,0xed598131,0x29dc8728}},	//   _мухо, puny, diže_, bías_, 
   {{0x29dc860e,0x6b953607,0xd5758116,0x752d3608}},	//   cías_, _mozg, _гуль, kaaz, 
   {{0x35f5b609,0x6d59829a,0x200900f6,0x67288269}},	//   _упер, _ubwa, _buai_, _zedj, 
   {{0xd24e842b,0x200900f6,0x2fd801c2,0xf1b283f3}},	//   ونی_, _cuai_, torg_, לסט_, 
   {{0x443fb60a,0x200900bf,0x6d49b60b,0xf4128039}},	//   mru_, _duai_, lgea, _צפו_, 
   {{0x78c1008c,0x66e6360c,0x453602bb,0xdb1ab60d}},	//   _əvvə, сова, йхат, zitë, 
   {{0x6d49951d,0x29008116,0x394d81df,0xdce40131}},	//   ngea, žiai_, _nces_, ndić, 
   {{0x6d498336,0x69d980a1,0x7984020e,0x2009360e}},	// [2020] igea, dowe, _iniw, _guai_, 
   {{0x25a0360f,0x68e0810d,0x31722c66,0x65643610}},	//   skil_, _rymd, _hayz_, seih, 
   {{0x29dc84e0,0x443fb584,0x490680fe,0x67288bbe}},	//   xías_, hru_, مواق, _redj, 
   {{0x61469225,0x5d860013,0x70530a0e,0xd764015e}},	//   седа, _الحل, _بنیا, _انگی, 
   {{0x6b950269,0xe3b10068,0x6728808d,0xdb0e011e}},	//   _fozg, سرے_, _pedj, _embá, 
   {{0x443fb611,0x29dc922b,0x23658265,0xdb1a816c}},	//   dru_, tías_, jelj_, ritë, 
   {{0x44321526,0x443fb612,0x9f520149,0xe29718d9}},	//   lsy_, eru_, _huyó_, _лар_, 
   {{0x29dc96b7,0x98a6b613,0x443fb614,0x15fa0bf5}},	//   rías_, _либе, fru_, ्दिर_, 
   {{0xdb1ab615,0x443fb616,0x44323617,0x29dc8530}},	//   lité, gru_, nsy_, sías_, 
   {{0x6d498064,0x320a3618,0x44323619,0x29dc833b}},	//   agea, _kuby_, isy_, pías_, 
   {{0xa3d90f53,0x15f8122f,0x200903bf,0xdd8fa3be}},	//   ावत_, ंगार_, _suai_, _еш_, 
   {{0x443fb050,0x394d361a,0x7dde816c,0x63be361b}},	//   bru_, ües_, tësu, hipn, 
   {{0x443f8012,0x2009361c,0x6ac40f2c,0x80da85a2}},	//   cru_, _quai_, वपुर, _বৃত্, 
   {{0x7dde80f8,0x33f68223,0x443201b0,0x44268889}},	//   rësu, _учес, dsy_, _iwo_, 
   {{0x9f5e80ef,0x3da709dd,0x69d9804f,0xdced0215}},	//   _cité_, браб, yowe, rdač, 
   {{0x7bdab61d,0xd131003d,0x200900f6,0xb88601d2}},	//   lotu, _کمک_, _tuai_, _spíš, 
   {{0x6eda807a,0x7dde80f8,0xdcfd0269,0xb6068a07}},	// [2030] _पुसु, qësu, _posđ, lišć, 
   {{0x6ac401c7,0x68ed361e,0x4426b61f,0xa3b300a1}},	//   वपूर, _izad, _mwo_, जों_, 
   {{0x69d9b620,0x3cde009b,0x7bc8b621,0xdd9520e0}},	//   towe, _कुठे_, indu, _даны, 
   {{0x1959b622,0xa159b623,0x127b80c6,0x443fb624}},	//   рады_, раду_, טאבע, yru_, 
   {{0xf09f0741,0x69d9b625,0x6d5d3626,0x3c44077a}},	//   nyà_, rowe, _ibsa, _нэрв, 
   {{0x8cdc800f,0x645c802d,0x01cf00b2,0xa2b803ff}},	//   _पड़ो, ăril, রতিদ, ्पश्, 
   {{0x35f8040c,0x4426929c,0xdb1a80ef,0x7bda9b75}},	//   _خرید_, _awo_, cité, dotu, 
   {{0xa2b81e57,0x4426a698,0xd0d5809f,0x8459b627}},	//   ्पर्, _bwo_, _добъ, арот_, 
   {{0x6d49806b,0x386d8052,0x442682fa,0x320a0170}},	//   rgea, _user_, _cwo_, _zuby_, 
   {{0x443fb628,0x6d49ab11,0x212f8304,0xdb0e01c2}},	//   rru_, sgea, lagh_, _embæ, 
   {{0x68ed1d46,0x6d5d0a93,0x198a3629,0x6602808d}},	//   _azad, _obsa, абни_, _fiok, 
   {{0xe56e8daa,0x443fb62a,0x6594804c,0x66028036}},	//   _ўз_, pru_, _наху, _giok, 
   {{0xa3d9059b,0x4426b62b,0x23658183,0x629e00a1}},	//   ावा_, _gwo_, pelj_, zypo, 
   {{0x6d4f009f,0x25bf8123,0x6b8380f0,0x212f8097}},	//   _acca, liul_, _unng, hagh_, 
   {{0x2d96362c,0xa50a362d,0xd62a1102,0x68ed012c}},	//   орас, иева_, робе_, _ezad, 
   {{0x44320573,0xdb1a82c0,0x25bf802d,0x386000bb}},	//   tsy_, vité, niul_, _tpir_, 
   {{0x249f9db5,0x212f8064,0x290501d2,0xe73a064e}},	// [2040] nyum_, dagh_, ělat_, _кеп_, 
   {{0xdb1ab62e,0x4432362f,0x0fc3004a,0x212280c3}},	//   tité, rsy_, _ойын, मर्श_, 
   {{0xed5a00b0,0x826a254e,0x3dc902b1,0x7a0880ac}},	//   _кон_, раев_, bnaw_, _pěti, 
   {{0x00e68e2e,0xe9dab630,0xdb1ab631,0x7bda8ca2}},	//   ожен, шке_, rité, zotu, 
   {{0x25bf802d,0x7bda804f,0x25ad833f,0x7bc881c2}},	//   diul_, yotu, dhel_, yndu, 
   {{0x4426829a,0x2d99b632,0xc7a39afe,0x8fa39bcb}},	//   _rwo_, ösen_, мичк, маче, 
   {{0x59ca09f8,0xe29a0692,0x245406a0,0xf8bf0429}},	//   ाचार, _тав_, läm_, mbée_, 
   {{0x2cbf0105,0x25adb633,0x2d92029a,0xdc1e80b2}},	//   _žudi_, ghel_, njye_, _দিবস_, 
   {{0xc5f307a6,0x938a81bd,0x2717001b,0x7bdab634}},	//   ודה_, асна_, nění_, totu, 
   {{0xa3e4810c,0xa3ea00c3,0x7ae384e2,0x442681f0}},	//   _भीख_, मति_, _bynt, _vwo_, 
   {{0x7ae38324,0x86c680fe,0xf1bf01e0,0xddc88269}},	//   _cynt, _بيان, tiá_, _irdž, 
   {{0xb606b635,0x44268052,0x25bf802d,0x29008116}},	//   rišć, _two_, ciul_, žiau_, 
   {{0x4426859d,0x7bdab636,0x25d9803d,0xcf0002d1}},	//   _uwo_, potu, _اهنگ_, əşən_, 
   {{0xc6a71e9a,0x4374803d,0x271701d2,0x68ed0170}},	//   орби, _رهبر, dění_, _vzad, 
   {{0x3ea50019,0x7ae3811a,0xa3d90587,0xed598533}},	//   ált_, _gynt, ावस_, liža_, 
   {{0x321e847f,0xdb1703b9,0x518728a5,0x463b83f3}},	//   mpty_, rixí, _фука, יעלע, 
   {{0x5fbc801b,0x030e883c,0x68ed3637,0x6d9c80d8}},	// [2050] ्चाल, _सलाह_, _uzad, _héas, 
   {{0x69dd3638,0x09d38bf9,0xd37100d8,0x1fa70e31}},	//   lose, तव्य, عها_, _фриг, 
   {{0xdb019610,0xc32405a2,0xf0b8033f,0x65a30587}},	//   silö, _পাখি_, _هایش_, _jõhk, 
   {{0xe0d3840c,0x6b988f4a,0x45d50d29,0x249f80bf}},	//   وزش_, _lovg, _хомс, yyum_, 
   {{0x320481cb,0x29090128,0x95160039,0xdb1e0a1c}},	//   _dimy_, _mgaa_, _מקרא_, kipè, 
   {{0x81c30a87,0x2d9900bb,0x6cfa0039,0x1b2280b2}},	//   ্তি_, _hose_, _לפרס, _মাঝে_, 
   {{0x2d9927dd,0x69dd3639,0x67ed8019,0x25bf8166}},	//   _kose_, kose, gúja, tiul_, 
   {{0x6d4d1376,0xdceb8208,0x2909363a,0x2d86840a}},	//   ngaa, _jogħ, _ngaa_, _cnoe_, 
   {{0x65a30073,0x81c300cf,0x25bf802d,0x2d9912e3}},	//   _põhj, ্তা_, riul_, _mose_, 
   {{0x5ba98320,0xdceb8208,0x26d30217,0x7ae38d75}},	//   ском_, _logħ, _oxxo_, _pynt, 
   {{0x69cbb63b,0x95cb9ffb,0xe9da363c,0x249fb63d}},	//   onge, _куда_, йко_, syum_, 
   {{0x2005822d,0x69dd016c,0x186a15db,0x69cbb63e}},	//   _hili_, gose, бами_, nnge, 
   {{0x69cbb63f,0xda0b8034,0x6d4d249d,0x2005b640}},	//   inge, _सूरत_, dgaa, _kili_, 
   {{0xd9b8800c,0x6d4d3641,0x2d99068e,0xa4fa8309}},	//   _अष्ट, egaa, _aose_, _פלסט, 
   {{0x2d99029a,0x2005b642,0x59db86df,0x76438645}},	//   _bose_, _mili_, यकार, nrny, 
   {{0xf992003f,0x2005b643,0x6d4d3644,0x2d99009f}},	//   _سبب_, _lili_, ggaa, _cose_, 
   {{0xdb1e3645,0x02c4009b,0x6ac40379,0x764380db}},	// [2060] qipë, वप्न, वप्र, hrny, 
   {{0x6d4d1dca,0x6569b646,0x395fb647,0xa3cb8076}},	//   agaa, heeh, _abus_, रचि_, 
   {{0x66e605c2,0x2d993648,0x479b0273,0x98b0805d}},	//   _хона, _fose_, _הייס, đači_, 
   {{0x7bc18b60,0x6d9c80fe,0xddc88770,0x80da80b2}},	//   hilu, _léar, _srdž, _বৃষ্, 
   {{0xd12f8dac,0xa3bd8365,0x75243649,0x212d89fb}},	//   امه_, ीचा_, mbiz, _deeh_, 
   {{0x2611810b,0x2005b64a,0xdb1e364b,0x644980a6}},	//   _báo_, _cili_, kipé, duei, 
   {{0xa3d91de2,0x2005b59f,0x26118028,0x4420364c}},	//   ावर_, _dili_, _cáo_, lpi_, 
   {{0x7bde364d,0xdcebb64e,0x66060208,0x77ab008a}},	//   lopu, _xogħ, _jikk, _müxa, 
   {{0x6449ae62,0x6d9c80d8,0x7643b64f,0x44203650}},	//   guei, _béar, arny, npi_, 
   {{0x0b8a836d,0x316009fb,0x6d9c80d8,0x66063651}},	//   ссии_, _abiz_, _céar, _likk, 
   {{0xe4d69ad1,0x46db010c,0x6d4d0ea5,0x6d9c80d8}},	//   _کتاب, _मुंह, ygaa, _déar, 
   {{0xdb1ab652,0x6d9c8396,0x20058889,0xfbc400b2}},	//   mití, _véas, _zili_, ্তিত, 
   {{0x644983e9,0x7bc1b653,0x20058004,0x7bde019b}},	//   cuei, bilu, _yili_, kopu, 
   {{0x225980a1,0x200588c6,0x6d9c8a5e,0x69dd3654}},	//   ńska_, _xili_, _géar, sose, 
   {{0x6d4d285f,0x6a1380fe,0xe3c400b2,0xdb1e00fe}},	//   tgaa, _كبير, ্তাব, cipé, 
   {{0x66060068,0xdd940a54,0x91e410f3,0x1c118353}},	//   _cikk, насы, _поје, _डूडल_, 
   {{0x66063655,0xa3d90073,0x53992338,0x442000ed}},	// [2070] _dikk, ावल_, овая_, gpi_, 
   {{0x25ef05d9,0x337409eb,0x2a6302fa,0x7bde00db}},	//   _आठवी_, нгур, _ppjb_, gopu, 
   {{0x35f514b9,0xdb0181ed,0x44203656,0x2d993657}},	//   _опор, chlä, api_, _tose_, 
   {{0x69cbb658,0x64440079,0xdb1e019b,0x69c2b659}},	//   unge, brii, enpä, gioe, 
   {{0x2005822d,0x200d8086,0x3ce681df,0x77770519}},	//   _pili_, _quei_, _nyov_, _kaxx, 
   {{0xdee59830,0x69dab65a,0xdb23003d,0x66e582bb}},	//   моли, _íten, _سوری, мола, 
   {{0x7bc18208,0xe730902a,0x4439365b,0x6d5b80bf}},	//   vilu, اصه_, _hvs_, tfua, 
   {{0x69c2891e,0x2005b65c,0x395f8347,0x6449b65d}},	//   cioe, _wili_, _ubus_, tuei, 
   {{0x2005b65e,0x7bc1b65f,0x387f8ced,0x752f0034}},	//   _tili_, tilu, _urur_, _mecz, 
   {{0x752f00a1,0x26118106,0x799ba00a,0xad9b0a5e}},	//   _lecz, _táo_, _houw, _siúl, 
   {{0x44200109,0x799b8401,0x6903008a,0x753d0034}},	//   zpi_, _kouw, ətdə, _odsz, 
   {{0x5ec100b2,0x799bb660,0x7bc1b661,0x44203662}},	//   _শুভে, _jouw, silu, ypi_, 
   {{0x66063663,0x7bc1b664,0x6d9c80fe,0x64499b69}},	//   _rikk, pilu, _téar, quei, 
   {{0x660606de,0x69c28109,0x02c58188,0x777702fb}},	//   _sikk, zioe, _ойло, _caxx, 
   {{0x66e33665,0x66060388,0x7a08800d,0x1db183ff}},	//   вора, _pikk, _děts, _जतात, 
   {{0x69bf89d7,0x3dcd8519,0x64441562,0xd3788105}},	//   लोमी, nnew_, trii, moća_, 
   {{0x7bde3666,0x5f76046d,0xdb1a8547,0x61e43667}},	// [2080] topu, _قادر, zití, _ikil, 
   {{0x44393668,0xfaa602bb,0x6606249d,0x64443669}},	//   _dvs_, мазо, _wikk, rrii, 
   {{0x81c300cf,0x6606366a,0x7c360341,0x799b8a44}},	//   ্তর_, _tikk, ssyr, _bouw, 
   {{0x64a60bb3,0xdca60103,0x6444366b,0xa06a8103}},	//   _жама, _жами, prii, жада_, 
   {{0x69c28122,0x799bb66c,0x2a6d0a63,0x61e40da9}},	//   rioe, _douw, _ćebe_, _mkil, 
   {{0x4375366d,0x7a0c0123,0xd378ae70,0x69c3b66e}},	//   _пуст, _aşte, koća_, éner, 
   {{0x7c2b811a,0xa3db29c0,0xd29902c3,0x799b817c}},	//   _awgr, डकर_, _етті_, _fouw, 
   {{0x5c74974b,0x65a30073,0x6b9c366f,0x61e43670}},	//   елит, _põhi, _horg, _nkil, 
   {{0x69c0b671,0x6b9c3672,0xdb1c068e,0xbeeb0353}},	//   _imme, _korg, _amré, _टर्न_, 
   {{0x61e40010,0xf36691bc,0x7ac6b673,0x7d0b8578}},	//   _akil, фтин, дсме, _eggs, 
   {{0xa3b60e78,0x3ddf8a44,0x6b9c3674,0xbcfb00d8}},	//   _जतन_, bouw_, _morg, _mbéa, 
   {{0x6b9c0c8c,0x9e658068,0x61f61122,0x2378034e}},	//   _lorg, _سامن, _chyl, _larj_, 
   {{0x6b9c01b0,0x0cc900b2,0x65628191,0x00000000}},	//   _oorg, _শর্ত, _iboh, --, 
   {{0xead4b675,0x6b9c0d38,0x2cb08646,0xe4c780df}},	//   _поль, _norg, ıldı_, _تصمی, 
   {{0xbd0580ef,0x69c0b676,0xf8ae004e,0x9f5e8050}},	//   _théâ, _omme, لکی_, _mità_, 
   {{0xfaa7803d,0xdb1aad0f,0xc5f881a8,0x96f815ac}},	//   _تجهی, lità, _spēj_, фест_, 
   {{0x3cfc0122,0x6b9c3677,0x94ab06d5,0xdce980d7}},	// [2090] рvv_, _borg, цтва_, rdeć, 
   {{0x7c2d82a5,0x69c0b678,0x799b834e,0x4439037c}},	//   _çare, _amme, _souw, _vvs_, 
   {{0x65628170,0x6b9c3679,0xafdb07c5,0x69cf0036}},	//   _oboh, _dorg, nrøm, once, 
   {{0x77b000f9,0x34951700,0x442b0432,0x67352160}},	//   _växe, _замр, _twc_, lazj, 
   {{0x6b9c291e,0x2d8b02d2,0x7e620bbe,0x799b893c}},	//   _forg, _ince_, _ćopi, _vouw, 
   {{0x69c0b67a,0xdce407fa,0x644d000e,0x673524cd}},	//   _emme, ldiğ, muai, nazj, 
   {{0x644d3580,0x4ae401e2,0x16a9b67b,0x9ea9957d}},	//   luai, _аўта, явки_, явка_, 
   {{0x6b9c367c,0xc8c08365,0x7bc5367d,0xdce40214}},	//   _zorg, _शेवट, lihu, ndiğ, 
   {{0x4439b67e,0x644d367f,0x3ddf81f0,0x290d82fb}},	//   és_, nuai, rouw_, _igea_, 
   {{0x61e42d8b,0x3dcd8497,0x69cf265e,0x7bc53680}},	//   _skil, snew_, ence, nihu, 
   {{0x25a90068,0xfaa5b681,0x2d8b1c7d,0x644d00d8}},	//   kkal_, хано, _once_, huai, 
   {{0x9f478170,0x22598034,0x6dc78a57,0x7d0b80ca}},	//   dlné_, ńsko_, _غزال, _uggs, 
   {{0x320902b1,0xa5c6807f,0x6abd117e,0x7bc53682}},	//   _diay_, sjóð, ्पुर, kihu, 
   {{0x644d3683,0xdb1a89b2,0x2d9db684,0x3cf50353}},	//   duai, cità, _howe_, ्धने_, 
   {{0x645bb685,0x24598393,0x2d9d803d,0x7a0901d2}},	//   ltui, lèm_, _kowe_, _větr, 
   {{0x65aa003e,0x657980f6,0x06070193,0x3209001c}},	//   _výho, _jawh, енск_, _giay_, 
   {{0xd46716aa,0x04430ed5,0x68e9aabd,0xdb1aa809}},	// [20a0] ните_, летн, _nyed, litá, 
   {{0x69c63686,0x2d8b03b9,0x6abd0b45,0x213fb687}},	//   like, _ence_, ्पूर, _aduh_, 
   {{0x6b9c02ae,0xdb1ab688,0x814680fe,0xb146b689}},	//   _vorg, nitá, فنان, енел, 
   {{0x2d9d80a1,0xe8fa94b9,0x645bb2bd,0x68e989ec}},	//   _nowe_, пле_, ktui, _byed, 
   {{0x6b9c368a,0x644d0766,0x764e0cde,0xd7e68116}},	//   _torg, cuai, luby, ніко, 
   {{0x7c24368b,0x290d8065,0x69c6368c,0x6283b68d}},	//   mpir, _egea_, hike, _orno, 
   {{0x9e06b68e,0xfa67179a,0x569496a2,0xda0b832d}},	//   нчил, _парк_, тайт, _संगत_, 
   {{0xd5b7ae47,0x69c0b68f,0xf3908028,0xc6930377}},	//   есь_, _umme, _cảnh_, ראה_, 
   {{0x69c63690,0x6283b691,0x7c243692,0x61e2b693}},	//   dike, _arno, npir, mool, 
   {{0x39403694,0x61e2b695,0x765c00a1,0xafdb03cd}},	//   _adis_, lool, ktry, trøm, 
   {{0x6283803a,0x69c63696,0xf8bf812b,0xdb1ab697}},	//   _crno, fike, _þér_, gitá, 
   {{0x248005c3,0x69c63698,0x765c01a3,0xed5a96ab}},	//   kvim_, gike, dtry, _ход_, 
   {{0xfbcf82e5,0x644d0bdf,0x3f9eb699,0xdce402d2}},	//   شتی_, xuai, _kotu_, vdiğ, 
   {{0x8c1b896e,0x3940369a,0x229480fe,0x7c24007e}},	//   _צווי, _edis_, _للتس, dpir, 
   {{0x61e2b69b,0x61eba070,0xfe700068,0x777ab69c}},	//   kool, ylgl, یدہ_, _matx, 
   {{0x644d369d,0x3f9eb69e,0x69c6369f,0xf0a68106}},	//   tuai, _lotu_, cike, _đành_, 
   {{0x3cfc30b8,0x798d022d,0xdce407fa,0x321136a0}},	// [20b0] लेले_, _inaw, rdiğ, _suzy_, 
   {{0x25a936a1,0x657bb6a2,0x644d0336,0x38691580}},	//   skal_, zduh, ruai, _ipar_, 
   {{0x644d36a3,0x32551248,0xc3338039,0x61e2b6a4}},	//   suai, твер, רוע_, fool, 
   {{0x7aea89b8,0x27e336a5,0x2472034e,0x00000000}},	//   _myft, lojn_, _fņm_, --, 
   {{0x7aeab6a6,0x777ab6a7,0x6579b6a8,0xf390812f}},	//   _lyft, _batx, _rawh, _rảnh_, 
   {{0xf7718250,0x69c636a9,0x10a2b6aa,0xe1938741}},	//   شات_, zike, ришн, _өлгө, 
   {{0x61e2b6ab,0x0675b6ac,0xd91581e2,0x69c636ad}},	//   bool, туля, _адбы, yike, 
   {{0xd6ce8013,0xfc3f826b,0x61e2b6ae,0x645b819b}},	//   تقى_, ším_, cool, ttui, 
   {{0x69c636af,0x2a6780f6,0x777ab6b0,0x657b813b}},	//   vike, _spnb_, _fatx, rduh, 
   {{0x09ca0560,0x645b8b7e,0x798d36b1,0x5ed700b2}},	//   ाच्य, rtui, _anaw, _ধরনে, 
   {{0x69c636b2,0x645bb6b3,0x2fc7b6b4,0x6579b6b5}},	//   tike, stui, ming_, _tawh, 
   {{0x62838265,0xf8bf0065,0x765c36b6,0x2012047f}},	//   _vrno, rbén_, vtry, _puyi_, 
   {{0x7529b6b7,0x7c24068e,0x98a48162,0x69c636b8}},	//   mbez, xpir, _temą_, rike, 
   {{0x7c3b80e5,0x6449b6b9,0x64468105,0x798d02b9}},	//   msur, mrei, škic, _enaw, 
   {{0xed5a33e3,0x66e624b1,0x2c1980cf,0xd00720f2}},	//   мов_, това, _দিয়ে_, тере_, 
   {{0x2fc7b6ba,0x7d1b8284,0x661c8019,0xceb284fc}},	//   hing_, ncus, _érke, ביל_, 
   {{0x2fc78636,0xff2610b5,0xe8fa0574,0x64a31f43}},	// [20c0] king_, _импо, _юли_, аата, 
   {{0x2fc79c44,0x7c2436bb,0x6449b6bc,0x7c3bb6bd}},	//   jing_, rpir, irei, isur, 
   {{0x2fc796f5,0x24800025,0x6449b6be,0x61e2b365}},	//   ding_, svim_, hrei, tool, 
   {{0x6cc604a0,0x6449b6bf,0x3ea78324,0x18a6904c}},	//   _айма, krei, dynt_, каем, 
   {{0x205684a0,0x2fc7b6c0,0xb82280cf,0x61e28079}},	//   ттер, fing_, _নিহত_, rool, 
   {{0x6449b6c1,0xb17b0172,0x2fc7b6c2,0x35c8002a}},	//   drei, llåt, ging_, _रगड़, 
   {{0x973cb6c3,0x163780fe,0x61e2b6c4,0x660bb6c5}},	//   _noće, نسية_, pool, _bigk, 
   {{0x6449b6c6,0xd01a00cf,0x557481f5,0x442f80bf}},	//   frei, তীয়_, угит, _bwg_, 
   {{0x2fc798bd,0x6449a3ed,0x7aea8172,0xe817000f}},	//   bing_, grei, _syft, _धंधा_, 
   {{0x2fc7b6c7,0x69c436c8,0x6e3e0a63,0x442fb2b8}},	//   cing_, _amie, _ovpb, _dwg_, 
   {{0x386916bd,0xf1f60034,0x195936c9,0x7c3b8309}},	//   _spar_, ीगढ़_, наны_, asur, 
   {{0x6449b6ca,0x973c8265,0x200cb6cb,0x79a7120f}},	//   brei, _doće, _hidi_, трое, 
   {{0xc058005a,0xe1ff05cb,0xeb9a8014,0x6e2219ff}},	//   кір_, rmó_, _оид_, _čoba, 
   {{0x9f530188,0x2618801c,0x3869816c,0x7c2d81b2}},	//   _això_, _kéo_, çari_, _çara, 
   {{0xf8bf0003,0x4ea436cc,0xc6a40175,0x200cb6cd}},	//   mbém_, арта, арти, _midi_, 
   {{0x7c22b6ce,0x798d36cf,0x995518c0,0x200c81d2}},	//   _ktor, _unaw, _скиц, _lidi_, 
   {{0x2fc78052,0x6abd01a2,0x69c380ef,0x9f43016c}},	// [20d0] ying_, ्प्र, ènem, nojë_, 
   {{0x69c422e1,0x68ed36d0,0x8aa736d1,0x7bc880bc}},	//   _zmie, _iyad, кред, nidu, 
   {{0x9f5e836d,0x2fc7b6d2,0x26188429,0x75d50c85}},	//   _mitä_, ving_, _néo_, _ميدا, 
   {{0xc692015c,0x7bc8825f,0x7c22b6d3,0xdd952d50}},	//   _האט_, hidu, _otor, _самы, 
   {{0x2fc7b6d4,0x7bc8b6d5,0x248681df,0xafdb00c0}},	//   ting_, kidu, _nrom_, gsøg, 
   {{0x657d36d6,0xfc3f803e,0x26188106,0x442f822a}},	//   _hash, šík_, _béo_, _rwg_, 
   {{0x7c22b6d7,0x657d36d8,0xcf9409be,0x6e958851}},	//   _ator, _kash, יטס_, العا, 
   {{0x657d0210,0x7c3b8436,0xed5984bc,0x442f822a}},	//   _jash, tsur, хои_, _pwg_, 
   {{0x2fc7b6d9,0x657d36da,0x75299fd8,0x7c3bb6db}},	//   ping_, _mash, rbez, usur, 
   {{0x6449b6dc,0x7c3bb6dd,0x69c436de,0x7d1b91c3}},	//   rrei, rsur, _smie, scus, 
   {{0x7c228124,0x68ed36df,0x6449b6e0,0x61fbb05b}},	//   _etor, _ayad, srei, _khul, 
   {{0x2486804d,0x657d36e1,0x442f81ea,0x6449b285}},	//   _from_, _nash, _twg_, prei, 
   {{0x3fc8007b,0x8c458b9c,0x7bc8b6e2,0x2d8fb6e3}},	//   ندسی_, _селе, bidu, _inge_, 
   {{0x7bc8b6e4,0xf53980e9,0x657d36e5,0x442236e6}},	//   cidu, lať_, _aash, _rtk_, 
   {{0x657d36e7,0x44220b07,0x69c401bb,0xfc3f0a1c}},	//   _bash, _stk_, _tmie, _aví_, 
   {{0x25adb6e8,0x69c41a5e,0xf53980e9,0x60db808a}},	//   nkel_, _umie, nať_, _oxum, 
   {{0x657d36e9,0xb17b010d,0x60db8027,0xac8615c2}},	// [20e0] _dash, rlåt, _nxum, ыгал, 
   {{0xb3468077,0x9f5e0008,0xb17b120e,0xdb1e011e}},	//   moçõ, ötä_, blås, fipá, 
   {{0x25adb6ea,0x3ea636eb,0x533680c6,0xf53980e9}},	//   kkel_, _синг, רנען_, kať_, 
   {{0x657d36ec,0x61fb9db7,0x3ea508d5,0x22470170}},	//   _gash, _chul, älte_, ánka_, 
   {{0xe8949339,0xf539b6ed,0x4422025f,0x261a000f}},	//   раль, dať_, _utk_, _मंडी_, 
   {{0xafdb0022,0x2d8fb6ee,0x61e9b6ef,0x9f43016c}},	//   rsøg, _ange_, _ekel, vojë_, 
   {{0x200c803b,0x67388ecf,0x657d287a,0x61e60269}},	//   _vidi_, ravj, _yash, kokl, 
   {{0x9f5e836d,0xd49a95a0,0x6d5636f0,0x7bc880a1}},	//   _sitä_, еро_, ngya, widu, 
   {{0xa84a88f7,0x5692805a,0x61e600f3,0x161602f4}},	//   _سلام_, рақт, dokl, _दूसर_, 
   {{0x9f4300f8,0x291236f1,0x99860162,0x958682c3}},	//   rojë_, _agya_, kslų_, _әлде, 
   {{0x7bc8b6f2,0x68ed0363,0xdb1a8a86,0x9f43016c}},	//   ridu, _syad, vitä, sojë_, 
   {{0x2eb08bf5,0x7bc8b6f3,0x2486b6f4,0x2d8004ab}},	//   जनीत, sidu, _trom_, jdie_, 
   {{0x7bc8b6f5,0x21390d89,0xc2e38004,0x8c439b27}},	//   pidu, rash_, _қўши, _гече, 
   {{0x2a660034,0x14d78309,0x2912012c,0x21390c80}},	//   łoby_, _גודל_, _egya_, sash_, 
   {{0x657d36f6,0x0ba7004a,0x39448149,0xdb1ab6f7}},	//   _pash, қшам, _odms_, ritä, 
   {{0x6d562d42,0x61e60a3e,0x657d36f8,0xb5a40162}},	//   ggya, cokl, _qash, бруй, 
   {{0x657d36f9,0xeb4b36fa,0xdb1ab6fb,0xf53f36fc}},	// [20f0] _vash, ечек_, pitä, _slås_, 
   {{0x91fd0029,0x61fb9f45,0xf53981ac,0x657d36fd}},	//   stād, _shul, zať_, _wash, 
   {{0x657d36fe,0x3a750ceb,0x20d40c0b,0x92590008}},	//   _tash, рлер, _نتیج, тает_, 
   {{0x657d36ff,0x6e250097,0x57dd8076,0x00000000}},	//   _uash, _ithb, यव्ह, --, 
   {{0xf539b6ed,0x752d1431,0x4f958370,0xd5b18279}},	//   vať_, mbaz, ирку, _lúc_, 
   {{0x44293700,0x3f698944,0x225980a1,0x61fb82fa}},	//   mpa_, тико_, ński_, _whul, 
   {{0x61fbb701,0xf53981ac,0x25ad8079,0xfd1180fe}},	//   _thul, tať_, tkel_, يجة_, 
   {{0x1c4582cd,0xa445a31b,0x44293702,0x644d0096}},	//   аним, анид, opa_, orai, 
   {{0x44290d9c,0x69cbb703,0x644d0649,0x9848809f}},	//   npa_, mige, nrai, _бяха_, 
   {{0x69cb84ff,0x44293704,0x5ba9973e,0xf53981ac}},	//   lige, ipa_, тком_, sať_, 
   {{0x644d0a55,0x27e7b705,0xd6d18a85,0x25b08063}},	//   hrai, monn_, _بقا_, álló_, 
   {{0x2d8f8c05,0x69cb95cb,0x660f3706,0x91e63707}},	//   _unge_, nige, _nick, роме, 
   {{0x6e2500fe,0x753bb657,0x80c001d2,0xac278166}},	//   _athb, mauz, _लेखे, _сфек, 
   {{0x644d3708,0x7c29b709,0x753bb70a,0xdcfb9527}},	//   drai, mper, lauz, nduč, 
   {{0xa91d8a93,0xe7370ad5,0x7c29859e,0x09b5809b}},	//   _každ, рес_, lper, ंसाठ, 
   {{0x63a3b70b,0x644d370c,0xf53f0088,0x248d370d}},	//   _honn, frai, _slår_, _šema_, 
   {{0x63a3b70e,0x2d8004fd,0x644d370f,0x69cba3a2}},	// [2100] _konn, rdie_, grai, dige, 
   {{0x443fb710,0xdcfb8d90,0xdb0183cd,0x63a3b711}},	//   isu_, jduč, rklæ, _jonn, 
   {{0x63a3b712,0x69cbb713,0x673c1781,0x973c8284}},	//   _monn, fige, marj, _noća, 
   {{0x8886a26c,0x673c3714,0x63a380d8,0x7c29b715}},	//   илеж, larj, _lonn, kper, 
   {{0x6604044f,0x644d0d0d,0x261c0065,0x91fd00f3}},	//   mmik, crai, _hío_, ltāc, 
   {{0x673c3716,0x7c29b717,0x63a3b718,0x66043719}},	//   narj, dper, _nonn, lmik, 
   {{0x69cbb71a,0x2956809f,0x2eb080c9,0xafdb072c}},	//   bige, _възр, जनेत, prøv, 
   {{0xd378803b,0x91e39afe,0x261c06c9,0xef1880f3}},	//   moći_, _досе, _mío_, _daļa_, 
   {{0x26168066,0x673c371b,0x63a3b71c,0x261c0685}},	//   _पूरी_, karj, _bonn, _lío_, 
   {{0x673c371d,0xeb06ad4f,0x63a38213,0x7980829a}},	//   jarj, ично, _conn, _hamw, 
   {{0x6d460a93,0x7980b2be,0x673c371e,0x63a3b71f}},	//   _odka, _kamw, darj, _donn, 
   {{0x7c26003a,0x44293720,0x63a38bd4,0x7982b721}},	//   _otkr, ypa_, _eonn, ndow, 
   {{0x7980b722,0xcfa73723,0x84638086,0x63a3b724}},	//   _mamw, ашви, _дъще, _fonn, 
   {{0x4426b725,0x63a3b726,0x644d03e9,0x69cbb727}},	//   _ito_, _gonn, vrai, zige, 
   {{0x7c26063b,0xc3fb8039,0x644083cd,0x7a138166}},	//   _atkr, _שלוש, lsmi, _bătu, 
   {{0xa91d829f,0x4426b728,0x63a3b729,0x644d372a}},	//   _kaže, _kto_, _zonn, trai, 
   {{0x63a382ee,0x752d372b,0x61ed2035,0x69cbb72c}},	// [2110] _yonn, rbaz, _ikal, vige, 
   {{0x644d372d,0x4429372e,0x4426b72f,0x69d880ef}},	//   rrai, rpa_, _mto_, éven, 
   {{0x69cbb730,0x79809c0a,0x386d8123,0x644d3731}},	//   tige, _bamw, _sper_, srai, 
   {{0x4426b732,0x443fb733,0xf5951001,0x6440b734}},	//   _oto_, ysu_, _الحج, ksmi, 
   {{0x4426b735,0x702280cf,0xfd960039,0x61ed083d}},	//   _nto_, _নিউজ_, _הדרך_, _mkal, 
   {{0x9f4780f8,0x6440b736,0x628ab737,0xa295109a}},	//   monë_, dsmi, _orfo, _лагі, 
   {{0x4426b738,0x3f811fd8,0x61ed3739,0x6442b73a}},	//   _ato_, _mahu_, _okal, _avoi, 
   {{0x81bd034a,0x63a3b73b,0x7c2983be,0x973c83c4}},	//   spēj, _sonn, tper, _voća, 
   {{0xb4f533e1,0x27e78246,0x63a3b73c,0x69c98ca2}},	//   _आरोप_, ponn_, _ponn, _imee, 
   {{0x7c29b73d,0xd7fb836d,0x61ed373e,0x4426b73f}},	//   rper, _руб_, _akal, _dto_, 
   {{0x443fb740,0x4426b741,0x673c3742,0x63a3b743}},	//   ssu_, _eto_, varj, _vonn, 
   {{0x261c02ba,0x443fb744,0x63a3812c,0x95c8b745}},	//   _río_, psu_, _wonn, _куча_, 
   {{0x673c3746,0x628a835b,0x3f811f8e,0x973c805d}},	//   tarj, _erfo, _bahu_, _moćn, 
   {{0x61ed3747,0x17c804bc,0x23268e29,0x64a2a477}},	//   _ekal, рҳои_, _лоши_, _хаша, 
   {{0xdfcf00fe,0x65b58170,0xa91db748,0x673c3749}},	//   ريف_, _záha, _zaže, rarj, 
   {{0x973c803a,0x673c374a,0xd01f80b2,0xdb01a248}},	//   _noćn, sarj, নীয়_, rklä, 
   {{0x6da302bd,0x436a0a1c,0x3f81011b,0x673c374b}},	// [2120] чита, лаан_, _fahu_, parj, 
   {{0xa3ca8b2f,0x261c0530,0x7980b74c,0x69c9b74d}},	//   रोप_, _tío_, _samw, _amee, 
   {{0xdb1a84e0,0x9f4c801c,0x8e8600fe,0x79808232}},	//   titú, _đoàn_, _الجه, _pamw, 
   {{0xe9dab74e,0xe93aa6f1,0x8d560d66,0x6d4600c0}},	//   ыке_, اسات_, _уточ, _udka, 
   {{0xa3e791a6,0x7982b625,0x6000374f,0x515b0309}},	//   पवा_, rdow, römf, רכנו, 
   {{0xc059836a,0xd9a5009b,0xd49a8103,0xdefa8008}},	//   рії_, _ऑक्ट, ғри_, лый_, 
   {{0x44268025,0x2d823750,0xa91db751,0x65b597e5}},	//   _sto_, _kake_, _saže, _sáha, 
   {{0x6440a1d1,0xa91d8116,0xd5b780a6,0x25a03752}},	//   tsmi, _paže, йсы_, njil_, 
   {{0x2d820052,0x77b00172,0x5bb8b753,0xe0da90f3}},	//   _make_, _växj, илия_, _сва_, 
   {{0xa91d805d,0x61ed3754,0xd37a8b29,0xf8bf00ef}},	//   _važe, _skal, учи_, ncée_, 
   {{0x77ab008a,0x9f8d01d2,0x25a000db,0xc7b38309}},	//   _müxt, uží_, kjil_, _צבע_, 
   {{0xf2c395e6,0xdb1c012b,0x2d82024a,0x64563755}},	//   ясын, _umræ, _nake_, kuyi, 
   {{0xafdb072c,0x673a8008,0x5c068994,0xf8b9075d}},	//   drør, _ketj, _ляка, рөй_, 
   {{0x6234876c,0x439493d3,0x7bcf80ef,0x82338019}},	//   _деку, _факс, écut, _کروا, 
   {{0x25a6b756,0x673a82a6,0x61ed3757,0x7bca81d7}},	//   _kool_, _metj, _tkal, _imfu, 
   {{0x673ab758,0x61ed3759,0x7bdc0519,0x21f90507}},	//   _letj, _ukal, _ajru, mého_, 
   {{0x3f811b4e,0x21f9003e,0x64a40003,0x69cf375a}},	// [2130] _tahu_, lého_, паѓа, mice, 
   {{0x261a00a1,0x673a9130,0x69c98d55,0xdb03834e}},	//   _मूवी_, _netj, _smee, _bonè, 
   {{0x21f90791,0xdb0380a6,0x02d90f36,0x1df90193}},	//   ného_, _conè, جواب_, _вены_, 
   {{0xd378803a,0x25a681cc,0x9f4c801c,0x6456375b}},	//   moću_, _nool_, _đoán_, buyi, 
   {{0x3dcdb75c,0x973caa14,0x21f90170,0x673a872c}},	//   view_, _voćn, hého_, _betj, 
   {{0x21f90a93,0x7c2d2ccd,0x2d822be2,0xb4b50492}},	//   kého_, mpar, _zake_, जनी_, 
   {{0x2d822dfd,0x201302a1,0x660586f1,0x998900a1}},	//   _yake_, _mixi_, опка, _miał_, 
   {{0x0c25b75d,0x942588db,0x69c9b75e,0x7bcab75f}},	//   омин, омие, _umee, _amfu, 
   {{0x7c2d3760,0xe3b9832f,0x57d58077,0x673a8027}},	//   npar, иби_, _доаѓ, _fetj, 
   {{0x39493761,0xdb0382ef,0xd378843e,0xfbc587c5}},	//   _adas_, _honé, koću_, ібно, 
   {{0xe9da2118,0x395f88dc,0x63a73762,0xd6db89e4}},	//   ико_, _kcus_, _mojn, _ста_, 
   {{0x69d9b763,0x61ebb764,0x69cf06e4,0x39490149}},	//   nnwe, nogl, gice, _cdas_, 
   {{0x09a7807a,0x7a13802d,0x0bb8855a,0x201319a4}},	//   _खवैय, _cătr, ртөө_, _bixi_, 
   {{0x2d823765,0xe7373766,0x44079ddc,0x23bb8093}},	//   _sake_, жер_, _учеб, _bêje_, 
   {{0x2d823767,0x442db768,0x7643b769,0x3206813b}},	//   _pake_, lpe_, nsny, ymoy_, 
   {{0x28c50e4f,0x6d5bb76a,0x60000172,0x6b83b76b}},	//   _लेकि, ngua, döme, _hang, 
   {{0x6b83b76c,0x90c31565,0xfaf80029,0x442d8246}},	// [2140] _kang, _объе, _šī_, npe_, 
   {{0xdb1c0088,0x6b839da1,0x442db76d,0x7a0c8816}},	//   _områ, _jang, ipe_, _işti, 
   {{0x6da606bf,0x798402ef,0x2d820052,0xe5a6376e}},	//   _дина, _kaiw, _take_, _дини, 
   {{0xa96a972e,0x216a84bc,0xdb03b76f,0x442d8766}},	//   рида_, риди_, _coné, kpe_, 
   {{0x63a70043,0x79843770,0x00da9af6,0xa3ca8492}},	//   _fojn, _maiw, جبات_, रोड_, 
   {{0x661a819b,0xe79390f3,0x25a6b771,0x5f93b772}},	//   _putk, дишњ, _sool_, дишт, 
   {{0xd5ba8456,0x179b0052,0xdb1a80f8,0x8f9b0115}},	//   иси_, ייסב, shtë, ייסי, 
   {{0x6b8381d9,0x21f90f43,0x746a9be8,0x7984305c}},	//   _aang, vého_, аров_, _naiw, 
   {{0x64443773,0x764380e5,0x442d82b1,0x442002d1}},	//   nsii, asny, gpe_, nqi_, 
   {{0x6b83a855,0x7053807b,0x661ab774,0x64440008}},	//   _cang, _آنلا, _tutk, isii, 
   {{0x25a6b775,0x7a0c8fde,0x7414803d,0x442db776}},	//   _tool_, _aşti, _کوتا, ape_, 
   {{0x21f9003e,0x64440e53,0xd46ab777,0x6b83b778}},	//   rého_, ksii, _виде_, _eang, 
   {{0x6d40b779,0x3866860b,0xdd8f8604,0x6b83b77a}},	//   mama, ntor_, _جون_, _fang, 
   {{0x6d40b77b,0xa91d8116,0xb4c8936a,0x69cf377c}},	//   lama, _maža, ोपी_, sice, 
   {{0x63a701b2,0x69cf377d,0xa91d839f,0x6602b526}},	//   _rojn, pice, _laža, _khok, 
   {{0x6d40b77e,0x6b83b649,0xdd940ff9,0x9f4780df}},	//   nama, _zang, масы, roné_, 
   {{0x6b83b77f,0xa91d803b,0x5455009f,0xb4b5036c}},	// [2150] _yang, _naža, яват, जने_, 
   {{0x7c2d3780,0x6d40b781,0x6b83b782,0xc2e900b2}},	//   rpar, hama, _xang, _কৃষি_, 
   {{0x6d40b783,0x7a400013,0x250909dc,0x65aa05e1}},	//   kama, _rátá, _گردی_, _výhr, 
   {{0xa3ca8102,0xf67a0273,0xbd6b1878,0x1a9b80c6}},	//   रोत_, _פארמ, _трое_, ייבע, 
   {{0x6d40b784,0x61ebb785,0x859a0039,0xf1b40039}},	//   dama, rogl, _השרו, וסף_, 
   {{0xa91d9770,0x3e4581a8,0xec360309,0xf8bf0065}},	//   _daža, tēt_, _מאשר_, lbés_, 
   {{0x6d40b786,0x44393787,0x3135a5c5,0x628e0259}},	//   fama, _hws_, _невр, _grbo, 
   {{0x6602b788,0x6d409c1c,0x753d0066,0x31790066}},	//   _chok, gama, _jesz, jesz_, 
   {{0x6b83860b,0x442db789,0x3866b78a,0x6d5bb3f4}},	//   _pang, upe_, ctor_, rgua, 
   {{0x69dd03e9,0x753d1074,0x6d5bb78b,0xdb0701b2}},	//   éren, _lesz, sgua, _rojê, 
   {{0x656f1410,0x656982ae,0x4439378c,0xddc880f3}},	//   _obch, pfeh, _lws_, žoša, 
   {{0x6d40b78d,0x442d8e59,0x7bda8008,0x3f85a5f1}},	//   cama, ppe_, antu, _halu_, 
   {{0x4439150d,0x3f85b78e,0x7bda822a,0xe981004a}},	//   _nws_, _kalu_, bntu, тқын, 
   {{0x6609b78f,0x61a88693,0x6b83b790,0x79843791}},	//   lmek, _कक्ष, _uang, _waiw, 
   {{0x753d0068,0x44393792,0xcf9280c6,0xa3b89d06}},	//   _besz, _aws_, עטל_, _ظاهر_, 
   {{0x3f858271,0x317900a1,0xf1bf026b,0x9c263793}},	//   _lalu_, cesz_, chá_, здад, 
   {{0xa5073794,0x39420073,0x75241f6e,0x38668ced}},	// [2160] зета_, maks_, rciz, xtor_, 
   {{0x6d40b795,0x0e661c78,0xb9033796,0x44203797}},	//   zama, _екон, _язык, rqi_, 
   {{0x6d40b798,0x442b3799,0x753d0019,0xa91d80d7}},	//   yama, _etc_, _fesz, _saža, 
   {{0x6d40a856,0x3866b79a,0x628e043e,0x80cd902c}},	//   xama, ttor_, _vrbo, _देहे, 
   {{0x6d40b79b,0xd90d8267,0x3f85b79c,0x44201a57}},	//   vama, لیف_, _balu_, qqi_, 
   {{0x6d4bb79d,0x3866b79e,0x66029b86,0xa91d805d}},	//   _adga, rtor_, _shok, _važa, 
   {{0x6d40b2ff,0x7bce379f,0x7c2b80f3,0x59dc2973}},	//   tama, _imbu, _atgr, मचार, 
   {{0x80cd81aa,0xbcfb269b,0xdef98ad0,0x9adb0039}},	//   _देवे, _ibér, цыі_, _החלט, 
   {{0x6d40b7a0,0xa91d8024,0x661e00d7,0x6d4b00d8}},	//   rama, _kažn, _lupk, ógai, 
   {{0x6d40b7a1,0xad9b001c,0x3f85b7a2,0x7ae38129}},	//   sama, _nhún, _galu_, _bxnt, 
   {{0x21fc801b,0x7bce00e5,0x290037a3,0x21790193}},	//   ního_, _mmbu, _azia_, ойны_, 
   {{0xa91d8524,0x25bfb7a4,0x6d40b7a5,0x80ab00b2}},	//   _lažn, chul_, qama, _চেষ্, 
   {{0x2ac282c0,0x4420802d,0x26099108,0x3a20a492}},	//   _bébé_, _îi_, ागरी_, _čipu_, 
   {{0xad9b010b,0xefc819eb,0x03a3a7a7,0xdfdb01e9}},	//   _chún, пуск_, _пичо, съм_, 
   {{0x442b00bc,0x443903df,0x248200f6,0x394237a6}},	//   _stc_, _sws_, _askm_, baks_, 
   {{0x8d84075d,0x22f78039,0x9df90994,0x44391725}},	//   нууд, _מזון_, інат_, _pws_, 
   {{0x753d0068,0xf8bf08a6,0x23bb824a,0xa91d8116}},	// [2170] _vesz, rbés_, _hêja_, _bažn, 
   {{0x6ad080b2,0x442b0106,0x051d05a2,0x4439200a}},	//   _সুযো, _vtc_, তরের_, _vws_, 
   {{0x753d0068,0xa91d81e2,0x22470063,0x69dd37a7}},	//   _tesz, _dažn, énk_, onse, 
   {{0x6aaa00f9,0x7bce37a8,0x3135b7a9,0x4439022a}},	//   äffa, _embu, федр, _tws_, 
   {{0xc5fb0693,0x3f858095,0x656d35e8,0x2d9937aa}},	//   ्षीय_, _palu_, mfah, _inse_, 
   {{0xab8437ab,0x1408009b,0xbcfb00fe,0xdfd180d8}},	//   _пуск, वगृह_, _gcéa, ضيع_, 
   {{0x21fc801b,0x6609b7ac,0x63a3007f,0x3f85b7ad}},	//   cího_, tmek, önnu, _valu_, 
   {{0x6d5f00f6,0x2d8937ae,0x75fe816c,0x629a2e70}},	//   ngqa, ndae_, tëza, _štog, 
   {{0x91fd0029,0x394d80d7,0x6609b7af,0xf09f8035}},	//   rtāl, _ides_, rmek, _çà_, 
   {{0x63aa811a,0x765500a1,0xe3b180d8,0xdb1ab7b0}},	//   _cofn, krzy, ئرة_, ditó, 
   {{0x91e637b1,0xf1c4801b,0x394210ae,0x2d990889}},	//   доне, लोकन, taks_, _onse_, 
   {{0x6d4b8142,0x44b5ae85,0xbcb58b1b,0x68f6019b}},	//   _udga, _обес, _обещ, _pyyd, 
   {{0xe87c046b,0xa91d80d7,0xa3ca83f2,0x21fc81d2}},	//   _düşü, _lažo, रोह_, zího_, 
   {{0x39420073,0x3fcc00b2,0x21290050,0x2d9937b2}},	//   saks_, লক্ষ, _efah_, _anse_, 
   {{0x394d829f,0xa91d8e02,0xdb03826b,0x248db7b3}},	//   _odes_, _ražn, _koní, lvem_, 
   {{0xbcfb00fe,0x394d847f,0x21761935,0x68f60656}},	//   _scéa, _ndes_, _цукр, _tyyd, 
   {{0xa91d8025,0xd46723a5,0xdcfd0029,0x64468284}},	// [2180] _pažn, мите_, _pasā, škiv, 
   {{0x973cb7b4,0x657bb7b5,0x6b870a63,0x394d8a1c}},	//   _voćk, heuh, _cajg, _ades_, 
   {{0xa91d803b,0x38cb007b,0xa3af0689,0xf8bf37b6}},	//   _važn, _هایی_, _ओकर_, ncén_, 
   {{0x20058572,0xbbaa950f,0xe8fab7b7,0x765c00bb}},	//   _ahli_, _चक्क, оле_, mury, 
   {{0x394037b8,0x7bc18b5d,0x6c7504bc,0x6b8737b9}},	//   _meis_, khlu, _пурх, _fajg, 
   {{0x394037ba,0x443210ab,0x6d4437bb,0x394d8008}},	//   _leis_, mpy_, laia, _edes_, 
   {{0xd90d8068,0x5a55009f,0x9e06b7bc,0x2e4a8086}},	//   لیہ_, _пъту, мчил, цяло_, 
   {{0x77b480a6,0xdb03848a,0x6d441580,0x973c8c0e}},	//   _màxi, _coní, naia, _moći, 
   {{0xa06ab7bd,0x7f438191,0xf1bd8034,0x33298093}},	//   _фаза_, banq, ्फरन, _şaxa_, 
   {{0x765c37be,0x7bc1b7bf,0x0a6ab7c0,0x6d440122}},	//   kury, ghlu, орми_, haia, 
   {{0x6d44025f,0x973c80d7,0x213f8385,0x452a8166}},	//   kaia, _noći, _yeuh_, _джен_, 
   {{0x850688a0,0x225185e1,0xa194109a,0x24800766}},	//   _قوان, ázka_, ваюч, kwim_, 
   {{0xc86437c1,0x69dd37c2,0x394000fe,0x6d4437c3}},	//   ктри, rnse, _deis_, daia, 
   {{0x7d028533,0x765500a1,0x7bc1b7c4,0x6004875d}},	//   _izos, trzy, chlu, lòmb, 
   {{0x9a83805a,0xc1ee80da,0x05b280da,0x69c282a6}},	//   _ауыл, जवाब_, _जवाब, khoe, 
   {{0xa91d8029,0x6d4437c5,0x973c8a63,0x69d60063}},	//   _ražo, gaia, _doći, ézet, 
   {{0x656d02ae,0x439537c6,0xe9df00e9,0x261683f0}},	// [2190] rfah, наас, mnú_, _पूछी_, 
   {{0x2d8906a4,0x765c00bb,0xe9df00e9,0x09d78076}},	//   sdae_, bury, lnú_, ढच्य, 
   {{0x77b00172,0x33f4010d,0x6d4437c7,0x248d81d2}},	//   _växt, växt_, baia, zvem_, 
   {{0xd5a685b6,0xe9df37c8,0x6d4437c9,0x397c03f3}},	//   _صف_, nnú_, caia, ַטונ, 
   {{0xe7eb807a,0xe3b88214,0x394d816c,0xe4e700f0}},	//   टवला_, kkı_, _vdes_, _цінн, 
   {{0x660d37ca,0xe9df00fe,0x01c98019,0x65bcb7cb}},	//   lmak, hnú_, _کورٹ_, _réha, 
   {{0xfe718a0e,0x7f43818e,0xdb03b7cc,0x7bc1827e}},	//   ادت_, ranq, _poní, vhlu, 
   {{0x660d37cd,0x2247027b,0x394db7ce,0x91fd00f3}},	//   nmak, ánku_, _udes_, stāj, 
   {{0xe9df01ac,0x60000172,0xa924826b,0x799bb7cf}},	//   dnú_, dömn, _úžas, _inuw, 
   {{0xf7709692,0x3940139c,0x42c9b474,0xa3caa21e}},	//   _نام_, _seis_, згон_, रोल_, 
   {{0xeb920273,0xa3b70689,0xe299b7d0,0x660d37d1}},	//   אָר_, _जवन_, чан_, kmak, 
   {{0x3ce08025,0xdb07012b,0x29d200d7,0x1df90353}},	//   _žive_, _hljó, ršao_, ंतोष_, 
   {{0xbcfb1ed3,0x777c0065,0x6e2180bf,0x6d440da7}},	//   _scén, terx, _hulb, vaia, 
   {{0x6d440111,0x7529b7d2,0x29d20269,0xb4cb83ca}},	//   waia, lcez, pšao_, रछी_, 
   {{0x670f800c,0xa91d8024,0x6449b7d3,0x5275855a}},	//   ाधिक_, _pažl, lsei, _чулу, 
   {{0x660d37d4,0x973c80ca,0x6e21afd6,0x386902a1}},	//   gmak, _voći, _mulb, _fqar_, 
   {{0x6449b7d5,0xb7b3075d,0x6d4437d6,0x765c37d7}},	// [21a0] nsei, _өөрч, raia, sury, 
   {{0x7c2b37d8,0x6d4437d9,0x26cc0569,0x64498a67}},	//   ígra, saia, údos_, isei, 
   {{0xc0a9007b,0x6d4421c1,0x69c2b7da,0x443db705}},	//   _فایل_, paia, thoe, _lww_, 
   {{0xdca637db,0xe046b4fc,0x64a600cd,0x5066b7dc}},	//   _зами, енди, _зама, етка, 
   {{0x442428e1,0x69c28e45,0x248000f6,0x65bc82ef}},	//   _îm_, rhoe, qwim_, _béhn, 
   {{0x61e41146,0x69c2b7dd,0x6449b7de,0xc7a39a2b}},	//   _ljil, shoe, dsei, личк, 
   {{0x539b0052,0x442237df,0xa3dd02f4,0x644b86b3}},	//   _צילו, _huk_, तचर_, _avgi, 
   {{0x38cb80dd,0x9f4a0410,0x4422019e,0xa91d807e}},	//   _کافی_, dobí_, _kuk_, _lažj, 
   {{0x69c0b7e0,0x44220116,0x91fd00f3,0x63ae0131}},	//   _ilme, _juk_, stāk, _kobn, 
   {{0xa3ca8d99,0x61e4022d,0x442f8a00,0x7ac691e3}},	//   रों_, _ajil, _dtg_, есме, 
   {{0x19591e37,0x442237e1,0xe3b883d2,0x6e21b7e2}},	//   маны_, _luk_, rkı_, _gulb, 
   {{0x644982ae,0x3946b7e3,0xcc88801c,0x3ce6822a}},	//   bsei, naos_, _tớ_, _txov_, 
   {{0x44220b5b,0x61e437e4,0x98b80086,0xe9df00e9}},	//   _nuk_, _djil, елят_, rnú_, 
   {{0xc5fb0611,0x6d4f26ba,0x6446807e,0x8c1b8309}},	//   ्ष्य_, _sdca, škis, _זוגי, 
   {{0x442237e5,0x660d37e6,0x201a02ef,0x2bf7825e}},	//   _auk_, tmak, _dipi_, _רמון_, 
   {{0x7c228008,0x61e4016c,0x3946b7e7,0x6b8ab7e8}},	//   _kuor, _gjil, jaos_, _hafg, 
   {{0x660d37e9,0x44221e48,0x6ad900c9,0x3946b7ea}},	// [21b0] rmak, _cuk_, भप्र, daos_, 
   {{0x69c0b7eb,0x442237ec,0x7c228086,0xdb15011e}},	//   _alme, _duk_, _muor, _alzá, 
   {{0xdb038170,0xdb188217,0x660d37ed,0xd25b37ee}},	//   _koná, _olví, pmak, яца_, 
   {{0xa2d50560,0x3e4c800d,0x28d290ff,0x24868269}},	//   _येण्, dět_, _देहि, _osom_, 
   {{0x7c22ad50,0xf8b337ef,0xdb038065,0x7f4180f8}},	//   _nuor, ुनिय, _moná, _pelq, 
   {{0x2d8b0a87,0x9a8737f0,0x7989868e,0x69c0b7f1}},	//   _hace_, _публ, _waew, _elme, 
   {{0x2d8b263d,0x973c8183,0x44220109,0x60000341}},	//   _kace_, _noću, _zuk_, döml, 
   {{0x25a937f2,0x2d8b029f,0x442f9fd8,0x6449b7f3}},	//   njal_, _jace_, _ptg_, tsei, 
   {{0x7c22809f,0x6d42802d,0x1c42b7f4,0x752981e9}},	//   _cuor, _deoa, аным, rcez, 
   {{0x61f637f5,0x8b95ad85,0x6449b7f6,0x320906a8}},	//   _skyl, трич, rsei, _ahay_, 
   {{0x13098008,0xa2e5825c,0x3209013b,0x920d0034}},	//   ьной_, тонд, _bhay_, सगंज_, 
   {{0x7c22809f,0x442fb7f7,0x201a0786,0x62950bbe}},	//   _fuor, _ttg_, _sipi_, _mrzo, 
   {{0x9f4a026b,0x6446931f,0xef1880f3,0xbb8580d8}},	//   sobí_, škir, _daļu_, _للشي, 
   {{0x442206a4,0x2b4303d0,0x7fd602c3,0x61fd0294}},	//   _ruk_, _nejc_, тімі, alsl, 
   {{0xf74309e4,0x442237f8,0x201a37f9,0xdb071ee9}},	//   ресо, _suk_, _vipi_, _bojí, 
   {{0xc6928115,0x63ae37fa,0xdb070217,0x2d8b37fb}},	//   סאן_, _sobn, _cojí, _cace_, 
   {{0x201a37fc,0xab66159f,0x68fbb7fd,0x63ae01df}},	// [21c0] _tipi_, квал, _nyud, _pobn, 
   {{0x291fa106,0x44220024,0x2d8b00db,0x35c60034}},	//   _agua_, _vuk_, _eace_, रोज़, 
   {{0x68fbb7fe,0xcf570052,0x0f570273,0x2d8b37ff}},	//   _ayud, _בבית_, _ביים_, _face_, 
   {{0xa7fb01e0,0x68fbb800,0x2c6b80c0,0x2d8b01d7}},	//   ruñe, _byud, kød_, _gace_, 
   {{0xf9930115,0x64430a5a,0x2d80002d,0x3946b801}},	//   ירא_, ćnic, meie_, raos_, 
   {{0x60048246,0x6d4283b9,0x2d8007c5,0x656401c2}},	//   fòma, _seoa, leie_, lgih, 
   {{0xfaa33802,0x7c22836d,0x2d8b3803,0xe12691bc}},	//   _каро, _suor, _yace_, _амби, 
   {{0x656417ef,0xa2c59115,0x5e5700c6,0x2d8b011e}},	//   ngih, ानन्, דיקע_, _xace_, 
   {{0x29048269,0x68fbb804,0x6d428587,0x7dde8f30}},	//   _uzma_, _gyud, _veoa, nīsi, 
   {{0x7c228008,0x212000bf,0x320908c6,0x61e2b805}},	//   _vuor, _agih_, _shay_, lnol, 
   {{0x2d8001b0,0xdea3804e,0xd7ef80fe,0xa5b300c9}},	//   keie_, _نیوی, _بكل_, _इकलौ, 
   {{0x61e2b806,0x7c228008,0xb6d980c6,0x2486806c}},	//   nnol, _tuor, _אַנט, _tsom_, 
   {{0x3f8cb807,0x7c2d86c8,0x2d8b3808,0xdca68ff6}},	//   _kadu_, _çarp, _race_, _шади, 
   {{0xb8cb2548,0x7dde81a8,0x65bc82ef,0x6b8a80c0}},	//   _गप_, dīsi, _méhm, _uafg, 
   {{0x8c1b8115,0x32090028,0x2d8b3809,0xf1b98bfc}},	//   _קווי, _thay_, _pace_, _hiše_, 
   {{0x69c6035b,0xdb1ab80a,0xf1b9868b,0x320902b1}},	//   chke, chtá, _kiše_, _uhay_, 
   {{0x33750021,0x25a9380b,0xa5f825ed,0x61e2b80c}},	// [21d0] лгар, rjal_, тету_, dnol, 
   {{0x1ae700b2,0xe1ff380d,0x248d0269,0x2d8b02d9}},	//   _করবে_, lló_, _šems_, _wace_, 
   {{0x798d380e,0x68fbb80f,0x2d8b3810,0x2d8d8da9}},	//   _kaaw, _syud, _tace_, ydee_, 
   {{0x61e2b811,0xe1ff0019,0x3f9eb812,0xfb1580c6}},	//   gnol, nló_, _antu_, אַנט_, 
   {{0x80cd8066,0x040d801c,0x645f0103,0x798d0786}},	//   _देखे, _cườn, quqi, _maaw, 
   {{0xa91d8116,0x69d88606,0xa5bb293e,0x3f8cb813}},	//   _maži, éver, _bióg, _cadu_, 
   {{0xf770a8b8,0xf1b98265,0x44293814,0x661d3815}},	//   تان_, _aiše_, lqa_, _kisk, 
   {{0x661d3816,0x0d85a5e9,0x644d3817,0x3ea98d87}},	//   _jisk, улин, osai, ćat_, 
   {{0xa3b7007a,0x7afc00f8,0xad9b00fe,0x644d3818}},	//   _जवा_, _zyrt, _chúi, nsai, 
   {{0x3f8cb819,0x09dc0365,0xfce3899f,0x69d9b81a}},	//   _gadu_, मच्य, лоқо, liwe, 
   {{0xd94622f7,0xd57589fc,0x6146354b,0xa96a26a8}},	//   лени, _буль, лена, нина_, 
   {{0x7c9585b6,0x644d381b,0x6000010d,0x69d9b81c}},	//   _مشتا, ksai, römm, niwe, 
   {{0xeb8eb81d,0x753bb81e,0x798d004f,0x6d49b81f}},	//   _ли_, mbuz, _daaw, maea, 
   {{0x69c63820,0xfce60229,0xe80403ca,0xe1ff0217}},	//   shke, қозо, _शीशा_, aló_, 
   {{0x6b81a6dd,0xe1ff3821,0x661d3822,0x3ebe007f}},	//   melg, bló_, _bisk, átt_, 
   {{0x61e2982b,0x88863823,0x69d9804f,0x3f8c3824}},	//   xnol, _ближ, jiwe, ždu_, 
   {{0xb0d280a1,0x69c43825,0x645bb826,0x7c29b827}},	// [21e0] _देंग, _ilie, nrui, nqer, 
   {{0x3ea60470,0xdb0380ef,0x798d331a,0x69c42d1c}},	//   _биог, _conç, _zaaw, _hlie, 
   {{0x661d15fe,0x644d3828,0x50d6803d,0x7c363829}},	//   _fisk, asai, گزار, spyr, 
   {{0x3f8ca69c,0x91fd0029,0x249f0024,0xa91d8f91}},	//   _sadu_, stāv, _šume_, _zaži, 
   {{0x7bc38073,0x644d382a,0x69c401ac,0x6d4601a8}},	//   _olnu, csai, _mlie, _ieka, 
   {{0x91fd0029,0x61e2b82b,0x5f9481e5,0x6d46382c}},	//   ltāt, snol, рикт, _heka, 
   {{0x6d46382d,0x2605807a,0x69c4382e,0xf1c1026b}},	//   _keka, _हीही_, _olie, ášky_, 
   {{0x5454b82f,0x645bb830,0x26278269,0x040d801c}},	//   авит, frui, _gđom_, _tườn, 
   {{0xa2d9a507,0x7bc6863b,0x973c808d,0x89d582c3}},	//   _फेब्, ūkum, _anće, _тірш, 
   {{0xf1b9803b,0x1ae70a87,0x6d4605fc,0xef91807b}},	//   _više_, _করতে_, _leka, _ویند, 
   {{0x69c43831,0xb34582fd,0xd377862d,0x798d02b1}},	//   _blie, _seçã, учы_, _paaw, 
   {{0x645b93c7,0x0446b832,0x8c46908c,0xf1a73833}},	//   brui, _бедн, _беде, урон, 
   {{0x645bb834,0x201eb835,0x107403dc,0xa91d8116}},	//   crui, _kiti_, бляю, _paži, 
   {{0xa3e8a9c9,0x69d9b17f,0x9294b836,0x5334824f}},	//   _यदि_, ziwe, _вакц, _тект, 
   {{0xdd9b00b6,0x6d463837,0x4426822d,0x7bda836d}},	//   нша_, _beka, _huo_, mitu, 
   {{0x6d463838,0x44268116,0x644d3839,0x7c26383a}},	//   _ceka, _kuo_, tsai, _bukr, 
   {{0x661d2ae3,0x24580008,0x2455003d,0x6298b83b}},	// [21f0] _visk, лать_, شناس, _hrvo, 
   {{0x644d383c,0x4429383d,0x661d383e,0xf2c7004a}},	//   rsai, rqa_, _wisk, лсен, 
   {{0x644d383f,0x661d3840,0x6d463841,0x442911d3}},	//   ssai, _tisk, _feka, sqa_, 
   {{0xdd950ff9,0x7bdab842,0x75229e0d,0x3ebe0c05}},	//   _тамы, hitu, _ngoz, øtte_, 
   {{0x201e8053,0x44268ad0,0xa0a5b843,0x44293844}},	//   _biti_, _nuo_, ралд, qqa_, 
   {{0x6d463845,0x65b5803e,0x201eb846,0x62988019}},	//   _zeka, _náhr, _citi_, _orvo, 
   {{0x74d90f21,0xda05009b,0x8c0a80b2,0x79828065}},	//   _नेतृ, रतात_, রদান_, beow, 
   {{0x4426820e,0xf2d204fc,0x201e8162,0x225c0033}},	//   _buo_, _ועל_, _eiti_, ávke_, 
   {{0x6298836d,0x44268053,0x61fb9e0d,0x05a68008}},	//   _arvo, _cuo_, _ikul, рвый_, 
   {{0xf77388f7,0x69c43847,0x7bdab848,0x6721805d}},	//   _دار_, _slie, gitu, _uglj, 
   {{0x69c43849,0x62988215,0x61e9836a,0x6b81b84a}},	//   _plie, _crvo, _kjel, relg, 
   {{0x6298829f,0x6b81b84b,0x645b949e,0x201ea8b7}},	//   _drvo, selg, prui, _ziti_, 
   {{0x6d460025,0x03a5831c,0x69c40b7e,0x628aae62}},	//   _reka, _вило, _vlie, _esfo, 
   {{0x6d460839,0x7bdab84c,0x91fd00f3,0x7bc8b84d}},	//   _seka, citu, tuāc, chdu, 
   {{0x61fb9f7b,0x7c26384e,0x69c401bb,0xd62a384f}},	//   _okul, _sukr, _tlie, тобе_, 
   {{0xf1bf0a93,0x65b581ac,0x61e9b59a,0x09e30e79}},	//   cká_, _záhr, _njel, _мощн, 
   {{0x0b463850,0x9f5e8008,0x93463851,0x6fc5809b}},	// [2200] инан, _yhtä_, инае, वसां, 
   {{0x2d8fb852,0x67ff82a5,0x61fbb853,0x75fe80f8}},	//   _lage_, bêji, _akul, rëzi, 
   {{0x61e98677,0x3ea60103,0xa9268e0e,0xed5a0123}},	//   _bjel, _тинг, адел, _ион_, 
   {{0x201eb854,0xc05a8d6b,0x61e99287,0x25adb855}},	//   _siti_, вік_, _cjel, jjel_, 
   {{0x61e98310,0x201eb856,0x25a20469,0xd3788081}},	//   _djel, _piti_, _inkl_, liće_, 
   {{0x91fd034a,0xd90d80dd,0x7c2480fe,0x3ce087ad}},	//   ntār, ریل_, _éiri, _živo_, 
   {{0x44268574,0x4b7b0c2d,0x7bdab857,0x201eb858}},	//   _suo_, _שאלו, vitu, _viti_, 
   {{0x4426b859,0x2d920206,0x61e994fe,0xbcfb00fe}},	//   _puo_, ndye_, _gjel, _scéi, 
   {{0x2d8f8022,0x201eb11f,0xbc6780fe,0x290001df}},	//   _dage_, _titi_, لمين_, _nyia_, 
   {{0x62988b9f,0x90e5803d,0xc5e3385a,0x201e8166}},	//   _prvo, _اسفن, _गद्य_, _uiti_, 
   {{0xe7e3807a,0xbeaa807b,0xf1b98bfc,0x3f830162}},	//   कचरा_, _جهان_, _hiša_, veju_, 
   {{0x4426b7ab,0x7bdab85b,0x28db950f,0xdebb8130}},	//   _tuo_, situ, _मेडि, _שמאל, 
   {{0x6e28827b,0xe3af81a1,0xdb0e0214,0x75d380d8}},	//   _hudb, سری_, _albü, _بينا, 
   {{0x2d84b85c,0xf1bf003e,0xf1b9839f,0xc7c4385d}},	//   leme_, ská_, _miša_, осси, 
   {{0x394b385e,0x69dd385f,0x7bd880bb,0x3dc93860}},	//   pacs_, éres, _imvu, thaw_, 
   {{0xdcfb83d2,0xf99f1bf3,0x2d84b861,0xfa339652}},	//   nduğ, rmès_, neme_, _برود, 
   {{0x69dd3862,0xf1b9b863,0x6e288a07,0x600d8728}},	// [2210] mise, _niša_, _ludb, lúme, 
   {{0x61fbb864,0x3dc9006c,0x60c00c05,0x69dd1419}},	//   _skul, shaw_, ømme, lise, 
   {{0x2003003a,0xe6950013,0x6e950013,0xf1b988dc}},	//   mlji_, _الجد, _الجا, _aiša_, 
   {{0x628680a1,0xa5bb033b,0xdb0e0217,0xfbdf0093}},	//   łkow, _dióc, _albó, _avêt_, 
   {{0x2d84803e,0x3494024f,0x9f51001b,0x260a9a6c}},	//   deme_, _даяр, hozí_, ातनी_, 
   {{0x69dd3865,0x39490caf,0x7dde80f3,0x490a1016}},	//   hise, _leas_, zīst, _सरसो_, 
   {{0x2d8fb866,0x320d804d,0x69dd3867,0x61e99287}},	//   _page_, _they_, kise, _tjel, 
   {{0x59f98008,0x61fbb868,0x3940807f,0xc7b88533}},	//   _себя_, _ukul, ðist_, _viđa_, 
   {{0x7bc704e1,0x69dd3869,0x26c181ac,0x63b50c0e}},	//   _klju, dise, šho_, _kozn, 
   {{0x6e288368,0x25bfb86a,0x3949011e,0x84e5804a}},	//   _fudb, skul_, _aeas_, _қолж, 
   {{0x2d8fb86b,0x69dd386c,0x7dde8029,0x63b5386d}},	//   _tage_, fise, tīst, _mozn, 
   {{0xd3788252,0x69dd386e,0x63b50934,0x2d849f46}},	//   viće_, gise, _lozn, ceme_, 
   {{0x27f8386f,0x39490089,0x7bc73870,0xec3580c6}},	//   torn_, _deas_, _olju, _פאַר_, 
   {{0xd3788284,0x69dd3871,0xdc3680c6,0x6569b872}},	//   tiće_, aise, _האסט_, lgeh, 
   {{0xada61c02,0x6da603a3,0x75fe816c,0x63bcb873}},	//   бавл, бива, rëzv, örne, 
   {{0x6569b874,0x249f01de,0x7bc73875,0xd3788284}},	//   ngeh, _šuma_, _alju, riće_, 
   {{0x61f980a1,0x0c23187e,0xd3788934,0x7bc705c3}},	// [2220] dowl, змун, siće_, _blju, 
   {{0x7bc1b876,0x65bc82c0,0x7f8600fe,0xd3788284}},	//   nklu, _véhi, _الدن, piće_, 
   {{0x63b53877,0xdceb80f3,0xdb0e06e4,0xce9581a8}},	//   _dozn, _angļ, _albò, šējā_, 
   {{0x629a2c96,0x27e980d8,0xdb1c010d,0x9f58016c}},	//   _átom, éann_, _omrö, korë_, 
   {{0x6e288025,0x28d2824c,0x66043878,0xdb0a811e}},	//   _sudb, _देखि, mlik, _mofá, 
   {{0x824a319c,0x66043879,0xdfd080fe,0x23272456}},	//   _مشرف_, llik, بيت_, _гори_, 
   {{0x7bde387a,0x69dd387b,0x8f9b0039,0xddcb8269}},	//   mipu, yise, טיסי, _šiši, 
   {{0x7bde0b64,0x6604387c,0x63b50038,0x69cba9e4}},	//   lipu, nlik, _zozn, chge, 
   {{0xe3bf0818,0xf8bf0f5b,0xdcfb83d2,0x660406a4}},	//   _xuño_, ncét_, rduğ, ilik, 
   {{0x7bde040c,0x325485e9,0xdee6b87d,0x69dd387e}},	//   nipu, овор, _лози, wise, 
   {{0x69dd387f,0x66043880,0xd5afb881,0x93fb00c6}},	//   tise, klik, _ес_, רליי, 
   {{0x645d82ba,0x7bde003d,0x31c7019b,0xba9b03dd}},	//   ásic, hipu, ссов, אסטי, 
   {{0x7bde3882,0x66043883,0x107424cb,0x39490530}},	//   kipu, dlik, пляю, _veas_, 
   {{0x69dd3734,0x7bc182ae,0xcc578115,0x629c3884}},	//   sise, cklu, _פסוק_, _orro, 
   {{0x98a5107b,0x7bde3885,0x7bdb8039,0x91fd00f3}},	//   ğlı_, dipu, _תקוו, trād, 
   {{0x98a50186,0x66043886,0x1ae700b2,0x7d028399}},	//   şlı_, glik, _করলে_, _kyos, 
   {{0x2003005d,0x545500f0,0xe9df00d8,0x93270063}},	// [2230] plji_, юват, miú_, مران, 
   {{0x65698093,0x7bde3887,0x61ed2570,0xad9b00fe}},	//   zgeh, gipu, _hjal, _chúr, 
   {{0x63b513ea,0x387fb888,0x7c2d03ad,0x7bc703d0}},	//   _vozn, _spur_, sqar, _vlju, 
   {{0xdb038038,0xe9df00fe,0x225c026b,0x3949b889}},	//   _ponú, niú_, ávka_, úas_, 
   {{0x7c2d008b,0x628e388a,0x629c388b,0x27e9860e}},	//   qqar, _esbo, _erro, éano_, 
   {{0x4439388c,0x7bc70043,0xdd2681b2,0x9848a338}},	//   _its_, _ulju, _pêşi, сяца_, 
   {{0x61ed388d,0x6569b874,0x7d02b88e,0x3ffc03f3}},	//   _ojal, tgeh, _ayos, אפגע, 
   {{0x442305ab,0xe4598b34,0xf8bf388f,0x61ed3890}},	//   _hij_, ажи_, ncés_, _njal, 
   {{0x6569b874,0xa3b00562,0xdb1a80fe,0x6e22b891}},	//   rgeh, टॉक_, chtú, _diob, 
   {{0xd7fbb892,0xa3d3800f,0x61ed3893,0x44233894}},	//   _суб_, सों_, _ajal, _jij_, 
   {{0xf7709692,0x4423063c,0x656f009f,0xf98604f9}},	//   _سال_, _mij_, _occh, огно, 
   {{0x7c3bb895,0x4423006c,0x216a3896,0x644301de}},	//   ppur, _lij_, шими_, ćnij, 
   {{0x61ed3897,0x44393898,0x69c98269,0x79863899}},	//   _djal, _nts_, _mlee, rekw, 
   {{0xee3a389a,0x4423022a,0xd9b6986b,0x61b6b89b}},	//   инг_, _nij_, _अक्ट, _अक्ष, 
   {{0x61ed389c,0x6d4b85b5,0x6604389d,0x80db00b2}},	//   _fjal, _kega, tlik, _যুদ্, 
   {{0x61ed389e,0x8066123d,0x2251803e,0xe5a319dc}},	//   _gjal, _движ, ázku_, миси, 
   {{0x44231edd,0x6604389f,0x7bde38a0,0xd3788024}},	// [2240] _bij_, rlik, tipu, lića_, 
   {{0x660438a1,0x3f8793e0,0x6d4bb8a2,0x69db8e7c}},	//   slik, jenu_, _lega, _amue, 
   {{0x660438a3,0x7bde38a4,0x443938a5,0xd378805d}},	//   plik, ripu, _ets_, nića_, 
   {{0x7bde38a6,0x64a638a7,0x0906802d,0x4439040a}},	//   sipu, _дама, опен, _fts_, 
   {{0x7c2bb8a8,0x44233269,0x6e22b8a9,0xd378b8aa}},	//   _nugr, _fij_, _riob, hića_, 
   {{0x6d59b8ab,0xc05980f0,0xd3788284,0xa09b03dd}},	//   _adwa, сії_, kića_, יינט, 
   {{0x60048188,0xeb910273,0xd37881de,0x628e020e}},	//   nòmi, _אָן_, jića_, _usbo, 
   {{0x4423063c,0xd378803a,0x5d5480ba,0x7c239a64}},	//   _zij_, dića_, чкит, _ainr, 
   {{0x6d4bb8ac,0x4423022a,0xb7e6b8ad,0x6d598371}},	//   _dega, _yij_, _джак, _ddwa, 
   {{0x3f878259,0xd3788131,0x61ed0726,0x4423006c}},	//   cenu_, fića_, _sjal, _xij_, 
   {{0x6d4bb8ae,0xc33302f9,0xd3788043,0x69c98008}},	//   _fega, וות_, gića_, _ylee, 
   {{0x7c23a493,0x6e228269,0x78a201a8,0xfec205a2}},	//   _einr, _uiob, _šova, োপাধ, 
   {{0xa5078b29,0xe9df0013,0x6443005d,0xc95384fc}},	//   _деца_, riú_, ćnik, ומר_, 
   {{0x29050029,0xd3788131,0xe9df00fe,0x442b38af}},	//   āla_, bića_, siú_, _ruc_, 
   {{0xcddb1abb,0xc95b0004,0x442300fa,0x7c2b83a6}},	//   ања_, _кўп_, _rij_, _zugr, 
   {{0x442301c8,0x442b0741,0x7dce8304,0xa4d507c5}},	//   _sij_, _puc_, _dùsg, побі, 
   {{0x4423027e,0x61fd38b0,0x92e700cf,0x7e6701df}},	// [2250] _pij_, mosl, _পরে_, sujp, 
   {{0x442338b1,0x69c9b8b2,0x7a33008b,0x6b88b8b3}},	//   _qij_, _slee, _aħta, nedg, 
   {{0x69c9b8b4,0x44232b24,0x8ae7036a,0x443902fa}},	//   _plee, _vij_, ціал, _wts_, 
   {{0x4423063c,0x61fd38b5,0xbcfb00e9,0x442b0106}},	//   _wij_, nosl, _dcér, _tuc_, 
   {{0x442338b6,0x8fa58d6b,0x443938b7,0x69c983c5}},	//   _tij_, зале, _uts_, _vlee, 
   {{0x6d4b888a,0x29048324,0x94ba0039,0x9f4780ef}},	//   _sega, _dyma_, _המשת, onné_, 
   {{0x9258069a,0x3f878284,0xed59b8b8,0x21290a3e}},	//   _март_, renu_, бой_, _ogah_, 
   {{0xd378803a,0xd90e8068,0x2d89047f,0x78a6b8b9}},	//   vića_, ئیے_, neae_, _škve, 
   {{0x2054b8ba,0x6d4bb8bb,0x478b8008,0x3f87931f}},	//   _октя, _vega, _всем_, penu_, 
   {{0xd378806a,0x63b881df,0x394db8bc,0xf1b98269}},	//   tića_, _covn, _hees_, _hoš_, 
   {{0x88bd80b2,0x7bc5145f,0x9f4e03d5,0x6b9538bd}},	//   _অধিক, ikhu, áním_, _mazg, 
   {{0xf1b9803b,0x22470f43,0xd3788024,0x20010a00}},	//   _još_, ánky_, rića_, _akhi_, 
   {{0xa3dc05d9,0x394dac91,0xd3788131,0xd9bd80b2}},	//   तोड_, _mees_, sića_, _আগাম, 
   {{0x394db8be,0x443f97bc,0x4375896e,0xf1b9805d}},	//   _lees_, mpu_, _זײַן_, _loš_, 
   {{0x443fb8bf,0x6012007f,0xc33283f3,0x61fd31f3}},	//   lpu_, væmd, _אוו_, bosl, 
   {{0xc8bd89d7,0x25a60422,0x394d827e,0x69cf026b}},	//   ्नाट, ñol_, _nees_, chce, 
   {{0x6b95011b,0x2ea883fc,0x443f817c,0xdd8f0bca}},	// [2260] _bazg, _कप्त, npu_, دوق_, 
   {{0xdb0383e9,0x389b0115,0x60001dba,0x3a24b8c0}},	//   _anné, _פיינ, röms, _simp_, 
   {{0xf1b98bfc,0xd36f0158,0x394d9be7,0xc7b88533}},	//   _boš_, اهم_, _bees_, _rođ_, 
   {{0xa96a8daa,0x69c60576,0x3f8a38c1,0x394db8c2}},	//   сида_, nkke, lebu_, _cees_, 
   {{0x6d441dec,0x394db8c3,0x68438940,0xd00ab8c4}},	//   mbia, _dees_, енча, беде_, 
   {{0x6d440116,0x3f9838c5,0x6e2602b1,0x64560481}},	//   lbia, ndru_, _hikb, msyi, 
   {{0x3a248012,0x63b8a3e1,0x09cc0365,0xd946a1d0}},	//   _timp_, _rovn, ासाठ, _неви, 
   {{0x394d81b0,0x6fcb0a05,0x3f8a38c6,0x3a24816f}},	//   _gees_, _müca, hebu_, _uimp_, 
   {{0x69dd02c0,0x645638c7,0x443f82b1,0x48ce05a2}},	//   èrem, nsyi, gpu_, রপুর, 
   {{0x5a349340,0x6f668077,0x799609ec,0x3f8a0105}},	//   мнот, _ѕвез, _aayw, jebu_, 
   {{0xa5bb0207,0x7f3b8039,0x799602b1,0x60c2a103}},	//   _biól, _העבו, _bayw, lyom, 
   {{0x61e2b8c8,0x394d822a,0x25a6811a,0xdceb03d0}},	//   niol, _xees_, _unol_, _žičn, 
   {{0x60c2b8c9,0xdca3a5c5,0x64a3b8ca,0x61fd1c48}},	//   nyom, _паци, _паца, rosl, 
   {{0xb7bd802d,0x3f8a38cb,0x6fbe80da,0x61e2b8cc}},	//   _puţi, gebu_, ्सिं, hiol, 
   {{0xbcfb011e,0x64408e45,0xddd038cd,0x61e2b8ce}},	//   _acép, lpmi, _šeši, kiol, 
   {{0xb8e30a87,0x6d4438cf,0x76550034,0x69c601ab}},	//   _এই_, gbia, rszy, ckke, 
   {{0x57f51285,0x394db8d0,0x9f5c8610,0x6602b8d1}},	// [2270] _опит, _rees_, rovê_, _mkok, 
   {{0xfe6e1ad1,0xa3d7000f,0x60cf0a08,0x76550034}},	//   دگی_, ़ों_, ınmı, pszy, 
   {{0x6d4438d2,0x394db8d3,0x6b9502d2,0xdb18892f}},	//   bbia, _pees_, _vazg, _sovê, 
   {{0x61e28495,0x394d827e,0x27e301f0,0x3ebe38d4}},	//   giol, _qees_, lijn_, ätte_, 
   {{0x394d93ff,0x315800c6,0x60c28019,0xf1b9a4fd}},	//   _vees_, ליאן_, gyom, _hišk_, 
   {{0x394d84fd,0x27e301f0,0x98a29054,0x10a2b8d5}},	//   _wees_, nijn_, тише, тишн, 
   {{0x6d4f31f5,0xdd91811d,0x69c60b83,0x629a38d6}},	//   _keca, ہوں_, ykke, _štov, 
   {{0xf1948157,0x8459b8d7,0x7c2737a5,0x6d4f0524}},	//   _пись, орот_, _hijr, _jeca, 
   {{0x8554803d,0x225800d4,0x6f0901d2,0x3a3c959b}},	//   ریور_, _zvrk_, řech, _atvp_, 
   {{0x6d4f38d8,0x443fb8d9,0xd24383ad,0x0ae9819b}},	//   _leca, rpu_, нмоқ, ждой_, 
   {{0x7c2f0cc1,0xa18a2f9e,0xa3ae37ef,0x69cd0324}},	//   _lucr, обна_, कात_, _blae, 
   {{0x443f9024,0x69cd38da,0x6d4f38db,0x88e638dc}},	//   ppu_, _clae, _neca, джме, 
   {{0xc4fb803d,0x69c6019b,0x6e26037f,0x6609b8dd}},	//   _اعضا_, rkke, _rikb, mlek, 
   {{0x69cd06a8,0x661bb8de,0x8b0381d2,0x7d0638df}},	//   _elae, lmuk, ářsk, _ryks, 
   {{0xf7720a0e,0x2bda807b,0x6d4f378a,0x442fb8e0}},	//   _یاد_, _بانک_, _beca, _hug_, 
   {{0x4427b8e1,0x6d4f38e2,0x7e61007f,0x6609b8e3}},	//   _hin_, _ceca, álpa, nlek, 
   {{0xe3ba0d4e,0x6d442e35,0xfce30198,0x442fb8e4}},	// [2280] оба_, rbia, вото, _jug_, 
   {{0x8bf100cf,0x64560dc6,0x660982a6,0x7d060116}},	//   _জীবন_, rsyi, hlek, _vyks, 
   {{0x442fb8e5,0x9f5c80f8,0xbcfb047f,0x6eb5053d}},	//   _lug_, sovë_, _adéd, _उपयु, 
   {{0x4427b8e6,0x6609b8e7,0x9f5c83d5,0x661b80bf}},	//   _lin_, jlek, mové_, jmuk, 
   {{0x9f5c803e,0xa3bf89af,0x645d8170,0x443d81df}},	//   lové_, ीसा_, ásil, _ntw_, 
   {{0x4427b8e8,0x8fa3ad85,0x7625004c,0x2f148116}},	//   _nin_, каче, _омӯз, ндлё, 
   {{0xdb03a891,0x9f5c827b,0x34b88bf5,0xd6d080fe}},	//   _monó, nové_, ेन्द, طقة_, 
   {{0xd5b0830b,0x0086855a,0x27e301f0,0x661b9840}},	//   افة_, _олбо, zijn_, gmuk, 
   {{0x4427b8e9,0x442f8666,0x9f5c826b,0xf41f0341}},	//   _bin_, _cug_, hové_, _isär_, 
   {{0x63bc0a7c,0x9f5c83e0,0x39468116,0xa3d880a1}},	//   _jorn, kové_, lbos_, ठों_, 
   {{0xbcfb38ea,0x9f5c826b,0x2fd7803d,0x69cd38eb}},	//   _idée, jové_, _تولد_, _plae, 
   {{0x4427b8ec,0x63bc38ed,0x9f5c8410,0x3ce08284}},	//   _ein_, _lorn, dové_, _živu_, 
   {{0x6d4f15b9,0x29f8b8b9,0x443d80db,0xdb188065}},	//   _reca, mčad_, _gtw_, _mové, 
   {{0x6d4f1b4e,0x4427b8ee,0x9f4300f8,0xdb038396}},	//   _seca, _gin_, mijë_, _conó, 
   {{0xd5bb38ef,0x7c2f38f0,0xdb03811e,0x9f5c85e1}},	//   оса_, _sucr, _donó, gové_, 
   {{0x4427b8f1,0xdb18827b,0x29f88533,0xca2980c6}},	//   _zin_, _nové, nčad_, _צופֿ, 
   {{0x4427b8f2,0x6d4f38f3,0x6297811e,0x84150086}},	// [2290] _yin_, _veca, _áxor, емах, 
   {{0x2fc7010b,0x44278028,0x60c000f9,0x9f5c826b}},	//   _ông_, _xin_, ämme, bové_, 
   {{0x3d0583ce,0x386680f6,0x63bc38f4,0xddc38123}},	//   _हुने_, eror_, _dorn, nunţ, 
   {{0x6d5d006d,0x290900db,0x6eae001b,0xf1b985c3}},	//   _udsa, _kyaa_, ीहरु, _kiši_, 
   {{0xdd3a0052,0x63bc0833,0x660994c0,0x798b80bb}},	//   _מערכ, _forn, vlek, regw, 
   {{0x2d990504,0xe739b8f5,0xe61180df,0xa6958a6a}},	//   _hase_, чек_, گشت_, ериј, 
   {{0x4427b8f6,0x2d9938f7,0x27e981de,0x442fb8f8}},	//   _rin_, _kase_, đan_, _sug_, 
   {{0x4427b8f9,0xdcf38105,0xdceb81d0,0xfc3f00fe}},	//   _sin_, šače, _jagħ, _tríd_, 
   {{0x9c25b8fa,0x6609b8fb,0x661b85b5,0xdceb81d0}},	//   ндид, rlek, rmuk, _magħ, 
   {{0xe3b1830b,0x63bc0818,0xe8bd8562,0x2d9938fc}},	//   ارة_, _xorn, ्नीच, _lase_, 
   {{0x290902ef,0x4427b8fd,0x6609b8fe,0x2bb180a1}},	//   _ayaa_, _vin_, plek, जाबा, 
   {{0x442fb8ff,0x9f5c826b,0xf99f0246,0x9f4780d8}},	//   _tug_, vové_, blèm_, inní_, 
   {{0x4427b900,0x30750ded,0x1c4485cf,0x2ec81e57}},	//   _tin_, курс, _анім, रन्त, 
   {{0x9f5c803e,0x4427b901,0x6aae80d8,0xd0120851}},	//   tové_, _uin_, óifí, الس_, 
   {{0xa3ae287f,0xb90723a6,0x56930004,0xf8bd800d}},	//   कास_, _ये_, лаёт, ्नुप, 
   {{0x9f5c803e,0x2d993902,0x212d80e5,0xdb1c00ef}},	//   rové_, _case_, _ngeh_, _forê, 
   {{0xa3c38365,0x3dd20360,0x9f5c803e,0x7de8801b}},	// [22a0] _एका_, rhyw_, sové_, měst, 
   {{0x61e60b75,0xdcea8131,0xfc3f0013,0x395fb903}},	//   likl, šiće, _dtí_, _adus_, 
   {{0xa3dc05b1,0x63bc01ed,0x160fa208,0x66008ca2}},	//   तोष_, _vorn, ातार_, yomk, 
   {{0x61e60254,0x2d993904,0x629a00ca,0xfb1683f3}},	//   nikl, _gase_, _štos, ײַבט_, 
   {{0x63bc3905,0xe8948cf7,0xa927836a,0x3f9a3906}},	//   _torn, таль, ніше_, _kapu_, 
   {{0x2d9918d4,0x2d803907,0xdb03875d,0x64443908}},	//   _zase_, lfie_, _anní, mpii, 
   {{0xaade810c,0x3f9a3554,0xdb1c016c,0x61e63909}},	//   _फेंक, _mapu_, _morë, kikl, 
   {{0xceb30052,0x6d56390a,0xa3ae122f,0x3f9a00f3}},	//   ריה_, naya, काव_, _lapu_, 
   {{0x442a390b,0x61e6390c,0x18678077,0xd175adbf}},	//   _kib_, dikl, _пати_, _шыры, 
   {{0x6d56390d,0x442a058f,0x3a291a28,0xb34692c1}},	//   haya, _jib_, _siap_, diçõ, 
   {{0x6d56390e,0x78a4390f,0xd25787c5,0x2ca002f4}},	//   kaya, _ariv, нця_, hvid_, 
   {{0x442a3910,0x6d560d77,0x78a43911,0x3e7a816c}},	//   _lib_, jaya, _briv, mët_, 
   {{0x7dca003e,0x3e7a8210,0x6d563912,0x1ae700cf}},	//   _výsl, lët_, daya, _করছে_, 
   {{0x442a3913,0xf1b98024,0xb4be8353,0x78a43914}},	//   _nib_, _viši_, ीनी_, _driv, 
   {{0x2d990206,0x3a2919f1,0x2d803915,0x3e7a80f8}},	//   _pase_, _tiap_, ffie_, nët_, 
   {{0xdd9413c9,0x6d563916,0x32538574,0xb3468077}},	//   ласы, gaya, _свър, biçõ, 
   {{0x442a0401,0x3e7a80f8,0xdb15026b,0x24f80153}},	// [22b0] _bib_, hët_, _vozí, енты_, 
   {{0x442a3917,0x3e7a8210,0x667200df,0xdb1c3918}},	//   _cib_, kët_, دگیر, _korè, 
   {{0x442a3919,0xdcebb1af,0x6d56391a,0x3e7a80f8}},	//   _dib_, _tagħ, baya, jët_, 
   {{0x6d56033f,0x356b0c1f,0x2003391b,0x799d391c}},	//   caya, _эрон_, loji_, ndsw, 
   {{0x660d391d,0x249f03b8,0x442a391e,0x9f5c81b2}},	//   mlak, _éum_, _fib_, rovî_, 
   {{0x660d391f,0x61e63920,0xdee584c7,0x442a3921}},	//   llak, zikl, коли, _gib_, 
   {{0xa3ae0de3,0x34c98bf5,0x3e7a816c,0xddd4808d}},	//   कार_, िन्द, gët_, _šaši, 
   {{0x442a3922,0x4ce280b2,0x660d3923,0x4c85b2dc}},	//   _zib_, _পড়ু, nlak, влив, 
   {{0x61e606de,0xc8e00562,0x442a3924,0x7c2ab925}},	//   vikl, _पेंट, _yib_, _bifr, 
   {{0xad9b01fb,0xd7598bb7,0x660d3926,0x6d563385}},	//   _skúl, _آلات_, hlak, zaya, 
   {{0x6d563927,0xa96a3928,0x7c2ab929,0x216a2138}},	//   yaya, мина_, _difr, мини_, 
   {{0xe3b18c0b,0x660d0024,0x6d56068e,0x27e7b92a}},	//   ارک_, jlak, xaya, linn_, 
   {{0xeb8e9a09,0x660d392b,0x1a6581a1,0x61e6392c}},	//   _ки_, dlak, ریکی_, rikl, 
   {{0x20030ecf,0x6d56090b,0xb34683b8,0x777703b9}},	//   goji_, waya, riçõ, _ccxx, 
   {{0x6d56392d,0xb34683b8,0x07a309d9,0x6e2b8128}},	//   taya, siçõ, јасн, _kigb, 
   {{0x442a1123,0x660d13b3,0x27e78048,0x799bb92e}},	//   _sib_, glak, hinn_, _nauw, 
   {{0xa3ae09d7,0x6d561c44,0x442a01c8,0xb8b3005a}},	// [22c0] काल_, raya, _pib_, _көрі, 
   {{0x6d56392f,0x442a3930,0xa3dc0066,0x80db3931}},	//   saya, _qib_, तों_, _যুক্, 
   {{0x6d563932,0x442a027e,0x799bb933,0x7c36016c}},	//   paya, _vib_, _bauw, sqyr, 
   {{0x442a01fc,0x5e570273,0xe8eab934,0x6e2b8199}},	//   _wib_, _ביטע_, ммед_, _nigb, 
   {{0x442a01ea,0xf1b9a4d4,0xf772803f,0x6d49b935}},	//   _tib_, _nišu_, لاغ_, dbea, 
   {{0x27e7b936,0x3e7a80f8,0xf09303dd,0x6e2b8064}},	//   ginn_, tët_, ינד_, _aigb, 
   {{0xf1b98269,0xbcfb3937,0xd6cf80a7,0x7dc30079}},	//   _aišu_, _idéa, يقه_, _tõst, 
   {{0x3e7a88fb,0x6b9c2e61,0x2bca9ac2,0x3f8e804f}},	//   rët_, _harg, िस्थ, sefu_, 
   {{0xb4be91b4,0xb4cc81ff,0x6b9c3938,0xd3788284}},	//   ीने_, रने_, _karg, lići_, 
   {{0x61e43939,0x69c0b93a,0xf1b98215,0x27e78c9f}},	//   _amil, _home, _dišu_, cinn_, 
   {{0x6d499d63,0xd6c48c0b,0xa3e392b9,0xa3c38073}},	//   bbea, _حمای, _नगर_, _एकर_, 
   {{0x6b9c36e9,0xdb1c393b,0x3869b93c,0x7dd59c86}},	//   _larg, _coré, šare_, _cásd, 
   {{0xdb1517e5,0x9f478093,0xdb1c393d,0x2d86868e}},	//   _mozá, dinê_, _doré, _iboe_, 
   {{0x61e4393e,0x5ba38574,0xa3e1824c,0xbcfb00fe}},	//   _emil, _връз, नोद_, _ndéa, 
   {{0x660d393f,0x27ed003a,0x9e07036a,0x20033940}},	//   tlak, đen_, вчал, roji_, 
   {{0xd378805d,0x2ba68c2e,0x59670086,0x973c811b}},	//   dići_, _कोता, _ръка, _inću, 
   {{0x660d1598,0xa3ae00da,0x629a3941,0x24580008}},	// [22d0] rlak, कां_, _štop, кать_, 
   {{0x6b9c1151,0xd3789527,0x39593942,0xfc3f0530}},	//   _carg, fići_, lass_, _cría_, 
   {{0x6b9c3943,0x69c0b944,0x799bb945,0x65628033}},	//   _darg, _bome, _pauw, _odoh, 
   {{0x249f0105,0xf99f06e0,0xf1b98a07,0xa11580d8}},	//   _šumu_, ndè_, _ništ_, هوات, 
   {{0xa06993d3,0x27e7b946,0x69cb83c5,0x0085899f}},	//   хала_, tinn_, rkge, улло, 
   {{0x6b9c3947,0xd378829f,0x628a806d,0x8699b948}},	//   _garg, bići_, _opfo, етит_, 
   {{0x27e7b949,0x69c0b94a,0x2bb1807a,0x7dd5b94b}},	//   rinn_, _fome, जासा, _láse, 
   {{0x27e7b94c,0x2ca68533,0x69c0b94d,0xf1b98024}},	//   sinn_, _brod_, _gome, _pišu_, 
   {{0x6d49b94e,0x9f47816c,0x3f910109,0x6b9c02d2}},	//   rbea, ninë_, kezu_, _yarg, 
   {{0x69c0b94f,0x6d498c9f,0xf1b985c3,0x6b9c0a1c}},	//   _zome, sbea, _višu_, _xarg, 
   {{0x39ea0b29,0x4226228e,0xdb1c0569,0x44211b0d}},	//   едно_, лдов, _poré, imh_, 
   {{0x9f4e003e,0x186a1248,0x7dca0407,0xa06a3950}},	//   čník_, нами_, _výsk, нама_, 
   {{0xc60f86d7,0xa91d8116,0x6fcb01ed,0xd37880d7}},	//   ातीय_, _pažy, _küch, zići_, 
   {{0xdee63951,0xaae4803d,0x66e63952,0xd70a024f}},	//   гоги, اسیو, гога, енге_, 
   {{0x9f47824a,0xf743009f,0x2d9db953,0x24990050}},	//   tinê_, сесо, _kawe_, _assm_, 
   {{0xd3788053,0x2d9fb954,0xa01b0019,0x29560086}},	//   vići_, ndue_, gtöb, _съкр, 
   {{0x638609b2,0x3b863955,0x9f47b956,0xd4673957}},	// [22e0] лгаа, ллаг, rinê_, лите_, 
   {{0x69c0b958,0xd3788131,0x3ce68073,0x5eff00c9}},	//   _some, tići_, _जइसे_, _शुक्_, 
   {{0x68fb8818,0x69c0a51d,0x6b9c3959,0x8b5680c6}},	//   _axud, _pome, _varg, ריעס_, 
   {{0xc693096e,0x6b9c0ada,0x44210649,0x2d9dabe1}},	//   _פאר_, _warg, amh_, _nawe_, 
   {{0x2d92325b,0x17548c8b,0x3a2d8387,0xd7e68deb}},	//   meye_, авля, _diep_, ліко, 
   {{0x6fcb02ae,0x78a28170,0x69c0b95a,0xd3788533}},	//   _rück, rvov, _wome, pići_, 
   {{0x6442b95b,0x9e069e1f,0x2480395c,0xb4cc8a64}},	//   _stoi, лчил, ltim_, रन्_, 
   {{0x2d92325b,0x225c026b,0xa3d686d7,0x25a0395d}},	//   neye_, ávku_, _सतह_, ndil_, 
   {{0xf746a880,0x7c2e395e,0x2d9db95f,0x7f46829e}},	//   _безо, _kibr, _dawe_, _безж, 
   {{0x7c2e3960,0x32068009,0x248002b1,0xdcef068c}},	//   _jibr, looy_, itim_, šeće, 
   {{0x3f910053,0x8646aa09,0x8d86a56e,0x058683ad}},	//   vezu_, _снеж, _булд, _булм, 
   {{0x24803961,0x7c2e3962,0xf651811d,0x2d9db963}},	//   ktim_, _libr, _گئے_, _gawe_, 
   {{0x7c2e0013,0x3f910081,0x3f9eb964,0x24803965}},	//   _oibr, tezu_, _katu_, jtim_, 
   {{0x39400269,0x3f9eb966,0x7c2e02ef,0x7d068587}},	//   _efis_, _jatu_, _nibr, üksu, 
   {{0x6298803a,0xa3ae05c9,0x2d9db114,0x8bc702bb}},	//   _usvo, काई_, _yawe_, қсад, 
   {{0xf99307db,0x7c2e00fe,0x3f9e80f3,0x9f4780f8}},	//   _طبع_, _aibr, _latu_, tinë_, 
   {{0x442e81d0,0x3b553967,0x442100db,0xdb18840a}},	// [22f0] _kif_, икар, tmh_, _hovà, 
   {{0x9f478210,0x3f9eaeb2,0x7c2e03b9,0x3a2d8294}},	//   rinë_, _natu_, _cibr, _siep_, 
   {{0x06bf00cf,0x9f4780f8,0x9388063e,0xa5bb293e}},	//   _উইকি, sinë_, ыста_, _biót, 
   {{0x7dd5a8a6,0x9f47b968,0xd37885c3,0xe45f007f}},	//   _másc, pinë_, miću_, _tvö_, 
   {{0x3f9e8484,0xd37881de,0xb284004a,0x9f47b59a}},	//   _batu_, liću_, _қырк, liné_, 
   {{0xdcfd0029,0x7c2e3969,0xf7719240,0xfe458e5a}},	//   _lasī, _gibr, زات_, анко, 
   {{0x45d59972,0x3f9eacc6,0xd3788131,0x3a2d812f}},	//   ицит, _datu_, niću_, _tiep_, 
   {{0x6d4d02b5,0xb88681d2,0x4465b96a,0x442eb96b}},	//   nbaa, _sníž, авив, _aif_, 
   {{0x851fb96c,0x61eb809f,0xed598942,0x3f9e8a63}},	//   मेंट_, migl, raž_, _fatu_, 
   {{0x2d9db114,0xa5bb00fe,0x2d92396d,0x7c2e0a68}},	//   _wawe_, _fhóg, zeye_, _xibr, 
   {{0x629ea0f8,0x6d4d0622,0xd3788533,0x6b600063}},	//   _špor, kbaa, jiću_, lágí, 
   {{0x9f47b96e,0xd3788024,0x78a9b96f,0x61ebb970}},	//   diné_, diću_, _krev, nigl, 
   {{0x9f5c803e,0x20078073,0x6d5b8bd4,0xc2ec00b2}},	//   lová_, ooni_, maua, _করছি_, 
   {{0x2007b971,0xd3788131,0x6d5bb972,0x61eb81e9}},	//   noni_, fiću_, laua, higl, 
   {{0xed5a0cd9,0xd9460daa,0x9f5c803e,0x2d923973}},	//   ков_, _кейи, nová_, teye_, 
   {{0x7bc3812b,0x38608284,0x2007b974,0x78a9b975}},	//   _honu, širi_, honi_, _orev, 
   {{0x7bc3b976,0x2007b977,0x69d60068,0x2d92325b}},	// [2300] _konu, koni_, _ilye, reye_, 
   {{0x2007b978,0x69aa05d9,0x9f5c827b,0x2d923979}},	//   joni_, _जोती, ková_, seye_, 
   {{0x7f5c397a,0x3f9eb97b,0xeb97397c,0x2007a513}},	//   marq, _ratu_, рих_, doni_, 
   {{0x3f9e8271,0xa96a8004,0x22518f6a,0x6d5b85b5}},	//   _satu_, тида_, ázky_, jaua, 
   {{0x78a9b97d,0x386080fe,0x64a30a1c,0x7c2e397e}},	//   _crev, éir_, _даяа, _tibr, 
   {{0x78a9a51d,0x7f5c1951,0x7bc3b97f,0x6000019b}},	//   _drev, narq, _nonu, tömy, 
   {{0x61ebb980,0x442eb981,0xd176819b,0xd9108184}},	//   bigl, _rif_, _вызы, _کیش_, 
   {{0x3f9e80fd,0x69d98ef8,0xa3ae007a,0x69c41474}},	//   _watu_, chwe, काक_, _noie, 
   {{0x3f9e9e3e,0x030b80a1,0x2007b0dd,0xd3788183}},	//   _tatu_, _सुबह_, boni_, ziću_, 
   {{0x9f5c826b,0xa5bb00fe,0x2007b982,0x8bc68a90}},	//   bová_, _thóg, coni_, рсид, 
   {{0x195913c9,0x1fb5ada0,0x7bc3b983,0x98a2008a}},	//   ланы_, _устр, _donu, dakı_, 
   {{0xd378803a,0x644601de,0x6d5bb984,0x973c8bbe}},	//   viću_, _otki, caua, _daće, 
   {{0x9098067a,0xa3e7000f,0x2b06b985,0x7dd13986}},	//   авят_, _बगल_, _सुरु_, _såso, 
   {{0xd378aa14,0x9f4780df,0x921714ba,0x628e1130}},	//   tiću_, tiné_, _धीरज_, _opbo, 
   {{0xc6a420e2,0x69d624b5,0xd7f803da,0x799f3987}},	//   орти, _flye, руя_, _taqw, 
   {{0xd3788284,0xcdd804c7,0x9f47833f,0x69c40109}},	//   riću_, ању_, riné_, _goie, 
   {{0xdce60876,0xf94a0273,0x6d4d03c5,0x2007b988}},	// [2310] _bakı, _געפֿ, rbaa, yoni_, 
   {{0x6d4d156c,0xd79500fe,0x3ceb009b,0x69c400fa}},	//   sbaa, _الدخ, _घेणे_, _zoie, 
   {{0x69d9b989,0x644607fa,0x6d4d0d55,0x2007b98a}},	//   thwe, _etki, pbaa, voni_, 
   {{0xf993803d,0x7dd8001b,0x9f5c8170,0x69c40065}},	//   تبط_, _píse, vová_, _xoie, 
   {{0xf99f00a6,0x2d8b01df,0x61ebb98b,0x18a5b98c}},	//   llès_, _ibce_, rigl, салм, 
   {{0x61ebb98d,0x9f5ca337,0x69d9b162,0x78a9839f}},	//   sigl, tová_, shwe, _vrev, 
   {{0x44390c3e,0x2007b98e,0x6d5bb98f,0xe61f001c}},	//   _hus_, roni_, taua, _khô_, 
   {{0x78a9b990,0x7bc3b991,0x2007b992,0x44393993}},	//   _trev, _sonu, soni_, _kus_, 
   {{0x7bc3b994,0x61e9b995,0x2007b996,0xdce607fa}},	//   _ponu, _imel, poni_, _yakı, 
   {{0x4439150d,0xa3e18e4f,0x7bc3b997,0x395d941e}},	//   _mus_, नों_, _qonu, laws_, 
   {{0x44391123,0x6449b998,0x44313999,0x2d8b2315}},	//   _lus_, spei, _miz_, _obce_, 
   {{0x4439075d,0x3cfd81c8,0x7bc382d9,0x6449b669}},	//   _ous_, _txwv_, _wonu, ppei, 
   {{0x4439006c,0xc8848180,0x53a5802d,0x61e98504}},	//   _nus_, cağı_, _галб, _mmel, 
   {{0x7bdab6be,0x6d59b99a,0x61fb8284,0x248f80bf}},	//   chtu, _hewa, _ljul, _ipgm_, 
   {{0x4439399b,0xdb18811d,0x6d59b99c,0x7dd5803e}},	//   _aus_, _tová, _kewa, _zása, 
   {{0xfe4604bc,0x25bf8421,0x443100f3,0xdce602d2}},	//   инҳо, njul_, _aiz_, _sakı, 
   {{0x4431399d,0x6d598a00,0x4439399e,0x2b580019}},	// [2320] _biz_, _mewa, _cus_, _perc_, 
   {{0x4439399f,0x61e9b9a0,0x6d59877e,0xf1a9803d}},	//   _dus_, _amel, _lewa, یانه_, 
   {{0x4439007c,0x44310077,0x6fd00172,0x479b03dd}},	//   _eus_, _diz_, _läck, _גייס, 
   {{0x261739a1,0x29f88c0e,0xa3a80f82,0x201eb9a2}},	//   nçol_, rčao_, _खोर_, _shti_, 
   {{0x1cba0313,0x4fc68c4c,0xc7c688f9,0x06e580cf}},	//   _صاحب_, йска, йски, _পুলি, 
   {{0x161c023b,0x43750974,0x61e9b9a3,0x200a276a}},	//   _भीतर_, _муст, _emel, nobi_, 
   {{0x443939a4,0x8fa680b6,0x6d59b6e8,0xe0df01e9}},	//   _zus_, _қаже, _bewa, zzò_, 
   {{0xdef89922,0x443901ea,0x6d5980bf,0x6fd0135d}},	//   лық_, _yus_, _cewa, _bäck, 
   {{0x6d5996ac,0x443901ea,0x200a0524,0x73d88004}},	//   _dewa, _xus_, kobi_, идир_, 
   {{0x9b588077,0x6fd0010d,0x44310065,0x249d817c}},	//   шиот_, _däck, _xiz_, _dswm_, 
   {{0x66099130,0x51f900f0,0x200a03d0,0xe56a8692}},	//   boek, иною_, dobi_, _биед_, 
   {{0x6d59b9a5,0x7bda89f4,0xf2d300c6,0x38608a63}},	//   _gewa, shtu, פער_, širu_, 
   {{0x6e3ab9a6,0x2fc583ad,0xb87b0033,0x63bca6b0}},	//   _hutb, _yolg_, dzíc, örns, 
   {{0xa3a809d7,0x6d5981b2,0x3fe705a2,0x03a38166}},	//   _खोल_, _zewa, পক্ষ, _ничо, 
   {{0x443939a7,0xd35b8c2d,0x48e90079,0xe2468250}},	//   _sus_, _גדול, _चेरो_, _اختي, 
   {{0x44310b53,0x443939a8,0xdb0a875d,0x395d827e}},	//   _siz_, _pus_, _infà, xaws_, 
   {{0xf1f800dd,0x71f80851,0x320b00a1,0x4439006c}},	// [2330] _دعوت_, _دروس_, mocy_, _qus_, 
   {{0x6fd002ae,0x66098a44,0x443939a9,0x44311799}},	//   _näch, zoek, _vus_, _qiz_, 
   {{0x6fb5003d,0x443101d2,0xe5350153,0x4439003d}},	//   _همکا, _viz_, _мень, _wus_, 
   {{0x4439150d,0x7dd10022,0x6fcb0214,0x7dd8011e}},	//   _tus_, _måsk, _vücu, _vísc, 
   {{0x7dca027b,0x9ccb3186,0x44390073,0x6d5f2167}},	//   _výst, _сына_, _uus_, maqa, 
   {{0x644d0d71,0x6d5993bd,0x6fd000f9,0x6e3a8128}},	//   mpai, _sewa, _räck, _butb, 
   {{0x2fc58b7e,0x7ac439aa,0x6d59b9ab,0x644d39ac}},	//   _volg_, _есте, _pewa, lpai, 
   {{0x1c45a471,0xa2d786ce,0x61e981ac,0xa4458fbe}},	//   оним, मनस्, _umel, онид, 
   {{0x644d39ad,0x22478bd4,0x6609b9ae,0x386080d8}},	//   npai, _stnk_, roek, áirt_, 
   {{0x7ff78275,0xdb1c1365,0xd2658b1b,0x6d5f2450}},	//   _اسرا, _horá, окой, haqa, 
   {{0x6d59b9af,0xdb1c296a,0x78ad39b0,0x3a2000bf}},	//   _tewa, _korá, _arav, _phip_, 
   {{0x6fd00172,0x249d827e,0x6285043a,0xee2eb9b1}},	//   _täck, _tswm_, itho, _ін_, 
   {{0x394d0e75,0x628539b2,0xdb1c39b3,0x200a03ad}},	//   ñesa_, htho, _morá, tobi_, 
   {{0x34b2840c,0x2329b9b4,0xdbf1808a,0xab2981e4}},	//   _آموز, _коли_, dəçi, _кола_, 
   {{0xa2e58004,0x628539b5,0x443fb9b6,0x200a39b7}},	//   _фойд, jtho, lqu_, robi_, 
   {{0x63a3b9b8,0x69dd035b,0x7dd58068,0xdd920bb7}},	//   _hann, chse, _máso, بور_, 
   {{0x63a3b9b9,0x62850324,0x7bc739ba,0x973c8a63}},	// [2340] _kann, etho, _boju, _laća, 
   {{0x63a3b9bb,0xad9b39bc,0xf1bf03b9,0xe3b739bd}},	//   _jann, _skút, nmán_, обу_, 
   {{0x63a3b9be,0x7bc70533,0x3f9804d3,0xe29a39bf}},	//   _mann, _doju, meru_, рае_, 
   {{0x63a3b9c0,0x63a50015,0xdb1c1127,0x29f880ca}},	//   _lann, adhn, _corá, pčam_, 
   {{0x92bc0a87,0x66010f5b,0x628539c1,0x91a0012f}},	//   েছে_, élke, atho, _chỉ_, 
   {{0x63a3b9c2,0x466ab9c3,0x6d44196a,0x661639c4}},	//   _nann, арим_, lcia, llyk, 
   {{0xdb1c00d8,0xdd2781b2,0x628507d1,0xd90d8019}},	//   _forá, _pêşx, ctho, نیہ_, 
   {{0x6d442fba,0x26c08053,0x39428073,0x63a39185}},	//   ncia, ćio_, _üks_, _aann, 
   {{0x63a3b9c5,0x2249b9c6,0x6d4439c7,0x3f9839c8}},	//   _bann, _čaka_, icia, keru_, 
   {{0x69c28b7e,0x3f98003b,0x63a39f99,0x7dd1134f}},	//   ljoe, jeru_, _cann, _påsk, 
   {{0x61ef39c9,0x63a3b9ca,0x1fb5b9cb,0x69dd016c}},	//   ticl, _dann, _эстр, thse, 
   {{0x78ad39cc,0x984b025c,0x69c2b9cd,0x51f80193}},	//   _prav, ияга_, njoe, жнюю_, 
   {{0x63a3b9ce,0x7dd5a337,0x3f983611,0xa3c3809b}},	//   _fann, _záso, feru_, _एकच_, 
   {{0xa3ce81b7,0x3f98008d,0x6560b9cf,0x7ddc80ef}},	//   _रवि_, geru_, lamh, _dése, 
   {{0x9f34005a,0xbcfb03b8,0x661639d0,0x53438103}},	//   дері, _idéi, flyk, _ўхша, 
   {{0x7dd5803e,0xd5b80a46,0x78ad39d1,0x63a39160}},	//   _násl, осу_, _trav, _zann, 
   {{0x61ed0131,0x3f9839d2,0x63a3b9d3,0xad9b01ac}},	// [2350] _imal, beru_, _yann, _skús, 
   {{0x644d0f9e,0x6d5f0fde,0xdb1c0019,0x57f4019b}},	//   rpai, saqa, _sorá, _опыт, 
   {{0x644d39d4,0xdd910013,0x5a350485,0x61ed007e}},	//   spai, _كود_, чнет, _kmal, 
   {{0x628539d5,0x6d44009f,0xfe9a00c6,0x6d5f20ad}},	//   rtho, ccia, _פירמ, qaqa, 
   {{0x6d5d00f3,0x628539d6,0x660d01cb,0x61ed39d7}},	//   _iesa, stho, moak, _mmal, 
   {{0x6d5d39d8,0x1da395ad,0x6285068e,0x660d06a8}},	//   _hesa, _खोजत, ptho, loak, 
   {{0x63a3b9d9,0x6d5d39da,0x61ed39db,0x7c3d39dc}},	//   _rann, _kesa, _omal, _husr, 
   {{0x63a3b014,0x3f9839dd,0x6d5d2ce4,0xbca580fe}},	//   _sann, zeru_, _jesa, كمبي, 
   {{0x6d5d39de,0x63a3b9df,0xb4d5883c,0x6e22b9e0}},	//   _mesa, _pann, सने_, _dhob, 
   {{0x7ddc83e9,0x61ed39e1,0x660d052a,0x443fb9e2}},	//   _rése, _amal, hoak, rqu_, 
   {{0x63a3b9e3,0x443f82c0,0xe8e10028,0x3f98115b}},	//   _vann, squ_, _đều_, veru_, 
   {{0x63a3b9e4,0x6d5d39e5,0xdb1c0142,0x3f9839e6}},	//   _wann, _nesa, _foræ, weru_, 
   {{0x7c3d39e7,0x63a3b9e8,0x6e29872c,0x2fda02fa}},	//   _nusr, _tann, mmeb, _plpg_, 
   {{0xf8a5840c,0x2bbb830b,0x61ed39e9,0x69db87d6}},	//   _یک_, _خاصة_, _emal, _llue, 
   {{0x6d5d1b4e,0x7c3d02ae,0xa3b524af,0xe9df00d8}},	//   _besa, _ausr, झाई_, bhú_, 
   {{0xf0661a2b,0x3f9839ea,0x1c4639eb,0xe61a0dbe}},	//   _екип, seru_, знам, ёда_, 
   {{0x6d5d39ec,0xdb1c00f8,0x3f9839ed,0x7c3d00db}},	// [2360] _desa, _korç, peru_, _cusr, 
   {{0x6d4439ee,0x69db836d,0xe81b802a,0x66160aa1}},	//   scia, _alue, _पीला_, slyk, 
   {{0x69c2892f,0x8c1a8039,0xe297320e,0x160b8c2e}},	//   tjoe, צועי, зах_, हकार_, 
   {{0x6d5d39ef,0x21678251,0x236a0128,0xf41f01ab}},	//   _gesa, зици_, _wdbj_, _spät_, 
   {{0xf5370052,0x2d820172,0x6e2982f4,0xb4d58587}},	//   _מרכז_, _icke_, dmeb, सनो_, 
   {{0x569499f7,0x6e949d9a,0x244087df,0x9f5c8033}},	//   дакт, дику, _ròm_, lovú_, 
   {{0x6e22b9f0,0xcf268013,0x69dba4b5,0x6d5d39f1}},	//   _phob, أرشي, _flue, _yesa, 
   {{0xe9a3b9f2,0x21a3839c,0x7c3d1098,0xade380f0}},	//   _пасп, _писм, _yusr, ецьк, 
   {{0xdb1c0083,0x28168063,0xd49aac08,0xdcebb9f3}},	//   _borç, _فورس, ёри_, _bagı, 
   {{0x46a69339,0x6560b9f4,0x61ed0039,0xa01b0008}},	//   _назв, samh, _smal, ttöm, 
   {{0xe9df0013,0x6e22b9f5,0xbeaa80df,0x9f5c8033}},	//   thú_, _thob, _دهان_, kovú_, 
   {{0x3946939c,0xdb03803d,0x26170214,0x7d028109}},	//   ncos_, _manè, rçok_, _txos, 
   {{0xdb1c281c,0x39468ca1,0x660d052a,0x7dd801d2}},	//   _forç, icos_, voak, _písn, 
   {{0x9257807b,0xdc378273,0xaa6691ca,0xa5bb39f6}},	//   _کشور_, _זאגט_, _етик, _chón, 
   {{0x6d5d39f7,0x7c3d003b,0x9f4a0396,0xdb05016c}},	//   _pesa, _susr, cibí_, rdhë, 
   {{0x61ed39f8,0x442303bf,0x42fb8039,0xe1ab8c2e}},	//   _umal, _shj_, _להוס, _घोंघ, 
   {{0x660d39f9,0x394939fa,0x6d5d39fb,0x7bca82d7}},	// [2370] roak, _ifas_, _vesa, _kofu, 
   {{0x6d5d0399,0x6e9901bd,0x3946b9fc,0xdd9985e1}},	//   _wesa, _двор_, ecos_, zeň_, 
   {{0xaadc85d9,0x386939fd,0xdb58019b,0x7bcab207}},	//   मनिक, _hvar_, яют_, _mofu, 
   {{0xd1319240,0x61fd39fe,0x3869009a,0x23c8801b}},	//   نما_, nnsl, _kvar_, ाउँद, 
   {{0xdd99803e,0x8fa5b9ff,0x92bd00b2,0x07a5ba00}},	//   veň_, дале, ইনে_, далн, 
   {{0x25a92da5,0xb4d903f0,0x39468149,0x09668093}},	//   ldal_, ़नी_, acos_, _çînê_, 
   {{0x24890068,0x443d868e,0x5692878a,0x9f478217}},	//   ltam_, _suw_, вајт, giná_, 
   {{0x9627034a,0x53341d51,0x25a93a01,0x25a68c8c}},	//   _uzņē, _чест, ndal_, _caol_, 
   {{0x24893a02,0xf1bf1ce0,0x7dd5807f,0xea000106}},	//   ntam_, rmál_, _hásk, _ngại_, 
   {{0x63a72f69,0x320f8052,0xdd99826b,0x7ddc811e}},	//   _jajn, logy_, seň_, _pésc, 
   {{0x25a93a03,0xdd998170,0x25a68103,0x3ed59001}},	//   kdal_, peň_, _faol_, _تقار, 
   {{0x77638a68,0x25a68c8c,0x672193e0,0x24893a04}},	//   lanx, _gaol_, _izlj, ktam_, 
   {{0x7dd5803e,0x395fba05,0xb87b0019,0xa5bb001c}},	//   _lásk, _meus_, szín, _phón, 
   {{0x63a73a06,0x0c24836a,0x7dd800e9,0x24890019}},	//   _najn, _змін, _píso, dtam_, 
   {{0x16a7038f,0xe7371880,0xe7e58079,0x25a922f8}},	//   мври_, дер_, _कतना_, fdal_, 
   {{0x200eba07,0xcb128039,0x601683b8,0x261382fd}},	//   zofi_, _שלה_, râmi, mãos_, 
   {{0x224d003a,0x39a681e2,0x63a70019,0xdb03807b}},	// [2380] _čeka_, _jūsų_, _bajn, _sanè, 
   {{0x39a681e2,0x6721ba08,0xafdb072c,0x25a607ad}},	//   _mūsų_, _ozlj, spør, žol_, 
   {{0x395f8120,0x7ddc868e,0xea01012f,0x629e200a}},	//   _beus_, _lésa, _quầy_, uwpo, 
   {{0xfc3f0217,0x395f8097,0xbcfb0a1c,0xdb03ba09}},	//   _fuí_, _ceus_, _adéu, _cané, 
   {{0x395fba0a,0x5fd20066,0x63a700a1,0x18679bcf}},	//   _deus_, _हवाल, _fajn, дачи_, 
   {{0x25a680fe,0x63a73a0b,0x5f9384bc,0xb03380f0}},	//   _saol_, _gajn, вишт, вніш, 
   {{0xc7b88028,0xdb1c0172,0x69d880f8,0x61fd2622}},	//   _vnđ_, _borå, ëves, ynsl, 
   {{0x395fba0c,0x746aa7dc,0x44383a0d,0x2d803a0e}},	//   _geus_, оров_, _hir_, ngie_, 
   {{0x443802a5,0xd49a87c5,0x61e2ba0f,0x6f0d838e}},	//   _kir_, іри_, mhol, ğaca, 
   {{0x5f76846d,0x1b2100b2,0x7ddc80ef,0x61e28a6f}},	//   _زائر, _বলতে_, _désa, lhol, 
   {{0x38690088,0x44383a10,0x33770039,0xc7b384fc}},	//   _svar_, _mir_, ועים_, _שבע_, 
   {{0xc33307a6,0x61e2836a,0xdb0701b2,0x44383a11}},	//   כות_, nhol, _bajê, _lir_, 
   {{0x7dd108b4,0xdd8f8c0b,0x2ca00238,0x44380c9f}},	//   _måst, _خون_, jwid_, _oir_, 
   {{0x4438008b,0x7dd103b7,0x6fdd868e,0x7522963b}},	//   _nir_, _låst, _kèca, _izoz, 
   {{0x38c50210,0x61e2ba12,0xe61300fe,0x63a73a13}},	//   _bërë_, khol, نشر_, _rajn, 
   {{0xdd9415e6,0xe81f05b1,0x2d803a14,0x44383a15}},	//   касы, _मीरा_, ggie_, _air_, 
   {{0x44381e78,0x61e28142,0x395f80a6,0xb4d900a1}},	// [2390] _bir_, dhol, _reus_, ़ने_, 
   {{0x395f90f7,0x3f9c9041,0x7dd5ba16,0xd838889d}},	//   _seus_, jevu_, _pásk, _nič_, 
   {{0x44383a17,0x24893a18,0xe1ff17e4,0x395f875d}},	//   _dir_, stam_, onó_, _peus_, 
   {{0x7c38ba19,0x20113a1a,0x44383a1b,0x6602ba1c}},	//   _livr, lozi_, _eir_, _njok, 
   {{0x7b67025b,0x63a7003b,0x386980fe,0x395f8741}},	//   _отве, _tajn, éar_, _veus_, 
   {{0x4438036a,0x187c0039,0x7c388269,0x48e080b2}},	//   _gir_, קטוב, _nivr, বপূর, 
   {{0x776384e0,0x395fba1d,0x9268005a,0x260b86df}},	//   ranx, _teus_, _орта_, ावली_, 
   {{0x442c9130,0xd5b188a0,0x6fdd8741,0xdcef08f1}},	//   emd_, افظ_, _dèca, _hacı, 
   {{0x20112d47,0x51848ff6,0xd8388a63,0x6012006d}},	//   kozi_, _шура, _fič_, kæmp, 
   {{0x7dd58019,0xdb03824a,0x2cad8039,0x3f9c8215}},	//   _mási, _danî, rved_, cevu_, 
   {{0x656f22a1,0xd24e842b,0x7dd821d3,0xb81b8034}},	//   _odch, ینی_, _sísm, _पीएम_, 
   {{0x7dd8026b,0x6602816c,0x644f061c,0x69c6022a}},	//   _písm, _gjok, _otci, ujke, 
   {{0x764190bc,0x7dd58170,0x65640008,0x261702fd}},	//   _huly, _nási, vaih, nçou_, 
   {{0x20113a1e,0x661baa01,0x6d49ba1f,0x60c49610}},	//   gozi_, lluk, lcea, äimi, 
   {{0xdb0382a5,0x66e6140f,0x442782ae,0xdee60605}},	//   _zanî, хова, _ihn_, хови, 
   {{0x7dd5939c,0xa3a81052,0x7641ba20,0xd24e80fe}},	//   _bási, _खोज_, _muly, _اني_, 
   {{0x4438059e,0x2011059d,0x65642783,0xfce3023d}},	// [23a0] _pir_, bozi_, raih, гото, 
   {{0x661bab86,0xfc3f00fe,0x085704fc,0x26e580b2}},	//   hluk, _arís_, _רבים_, _কখনো_, 
   {{0x44383a21,0x7dd10c3e,0x442782fa,0xdb1c01ac}},	//   _vir_, _påst, _mhn_, _horú, 
   {{0x44383a22,0x3f85ba23,0xceb302f9,0x2a6a8019}},	//   _wir_, _aclu_, _עיר_, ábbi_, 
   {{0x44380711,0x61e28060,0x661bba24,0xdb07047f}},	//   _tir_, rhol, dluk, _lajè, 
   {{0x442c06e0,0x4427ba25,0x6602ba26,0x7641ba27}},	//   _òd_, _nhn_, _sjok, _buly, 
   {{0xfc032058,0x61e2ba28,0x6996ba29,0xe2970cf5}},	//   _спро, phol, _прах, _пар_, 
   {{0x661bb198,0x291e00a1,0x3f9c8265,0x69d9992c}},	//   gluk, ętaj_, sevu_, ckwe, 
   {{0x09e38e61,0xb4da810c,0x7bce3a2a,0xdb18ba2b}},	//   _сотн, ठने_, _kobu, _invé, 
   {{0x7bce0123,0x236580ca,0xdb57ba2c,0x3ea9885a}},	//   _jobu, galj_, нюю_, łata_, 
   {{0x7c3880ef,0x7641ba2d,0x442c80fa,0x7bce3a2e}},	//   _vivr, _guly, rmd_, _mobu, 
   {{0x7982ba2f,0x225c003e,0x61368a08,0xf1a72e6c}},	//   ngow, ávky_, _gülü, хрон, 
   {{0x20113a30,0x23658934,0xe3b2803d,0x799d1893}},	//   tozi_, balj_, _مرغ_, resw, 
   {{0xb8c90d99,0x644fa89c,0x2ca6811a,0x799d3a31}},	//   _गई_, ície, _isod_, sesw, 
   {{0x20113a32,0x7a3e8162,0x6e941ac1,0xe28f80d8}},	//   rozi_, _būte, лиру, _هذي_, 
   {{0x63aaaac9,0x8d8400a6,0x34951b43,0x20112da6}},	//   _hafn, лууд, кабр, sozi_, 
   {{0x7dd83a33,0x7bce3a34,0x3a290347,0x7ddc83df}},	// [23b0] _získ, _bobu, _ihap_, _léso, 
   {{0x63aa812b,0xdce0ba35,0x6442ba36,0x7bce3a37}},	//   _jafn, jamč, _muoi, _cobu, 
   {{0xa0360039,0x29d782d2,0xbb8400d8,0x63aa8050}},	//   _שאתה_, _uçak_, المي, _mafn, 
   {{0x6562ba38,0xcb1380c6,0x9f58007f,0x7ae582f4}},	//   _neoh, אלע_, lorð_, _ühte, 
   {{0xf9940039,0x7641ba39,0x69d9ba3a,0xa0a5801d}},	//   טרף_, _suly, rkwe, талд, 
   {{0x62988387,0x69d9ba3b,0x63aa807f,0x3f8301c2}},	//   _opvo, skwe, _nafn, ngju_, 
   {{0x2365839f,0x5f058495,0x628b04ab,0x9f478656}},	//   valj_, ъзка, ăgos, vinä_, 
   {{0xceb40273,0x7ddc82c0,0x7bce3a3c,0x9f5c8170}},	//   ריק_, _déso, _zobu, mový_, 
   {{0x661b9b52,0x2365b870,0xa5bb0ca1,0x9f5c826b}},	//   rluk, talj_, _dióx, lový_, 
   {{0x6d4980fe,0x1a65815e,0xe50203ff,0x9aa40019}},	//   scea, نیتی_, लपति_, _جمہو, 
   {{0x386db4bd,0x9f5c826b,0xb17b072c,0x2617289c}},	//   _hver_, nový_, rhån, nços_, 
   {{0x999880f3,0x186a20e2,0xa06a25b2,0x3a293a3d}},	//   _kurš_, мами_, мама_, _chap_, 
   {{0x44278111,0x9f5c8170,0x23658183,0xd13200d8}},	//   _thn_, hový_, palj_, شمس_, 
   {{0xb4bf8365,0xdb0a824a,0x9f5c8410,0x29f897b2}},	//   ीही_, _mafê, kový_, nčar_, 
   {{0xfaa5ba3e,0x9f5c8170,0x248dba3f,0x91a00106}},	//   _райо, jový_, ltem_, _thì_, 
   {{0x386d8052,0x9f5c826b,0x98be0214,0x7bce3162}},	//   _over_, dový_, ştı_, _sobu, 
   {{0xd467038f,0x248dba40,0xb3862423,0x9f5801c2}},	// [23c0] ките_, ntem_, клал, borð_, 
   {{0x7dd83a41,0xeafa0250,0x248dba42,0x7bce3a43}},	//   _mísi, ورات_, item_, _qobu, 
   {{0x386d809f,0x66e62c78,0xdb1c0097,0x03a325e9}},	//   _aver_, _рона, _yorù, рихо, 
   {{0x7ddcba44,0xdb18803e,0xe9da80f0,0x7bce3a45}},	//   _réso, _nový, ьке_, _wobu, 
   {{0x80be8562,0xe894971a,0x7bce3a46,0xe0e080b2}},	//   ्हें, уаль, _tobu, বপ্ন, 
   {{0xdfcf864d,0x248dba47,0x6562ba48,0x9f5c8a5b}},	//   يين_, dtem_, _seoh, bový_, 
   {{0x6fdd80a6,0x9e068a53,0x386d8039,0x973c8bbe}},	//   _tècn, кчил, _ever_, _jaći, 
   {{0x5f16807a,0x752601df,0x25a00540,0x442a00db}},	//   _पुण्_, _kzkz, neil_, _hhb_, 
   {{0xc5f30052,0x98a38188,0xdb018681,0x3a29013b}},	//   ידה_, _ките, ndlæ, _rhap_, 
   {{0x32020038,0x7c3c0208,0x660dba49,0x25a03a4a}},	//   enky_, _jirr, čaka, heil_, 
   {{0x0d8682a4,0xe9f92313,0x5a35174b,0x37ba00b2}},	//   _ален, енні_, лнот, ুসার, 
   {{0xcb1304fc,0x973c8105,0x39400e0b,0x91a00279}},	//   ילת_, _naći, _cgis_, _phí_, 
   {{0x386d3a4b,0x6abf009b,0xab94805a,0x248d855a}},	//   éer_, _एप्र, _билі, ctem_, 
   {{0xdb1c03cd,0x7c3c3a4c,0xd7c900df,0x20050587}},	//   _forø, _nirr, روزه_, õli_, 
   {{0x88cb00b2,0x973c97a2,0x1af080b2,0xb5fc8199}},	//   _লেখক, _baći, _ঘুরে_, _ewġe, 
   {{0x3253809f,0x9f5c826b,0x25a00c9f,0x7c3c0097}},	//   _твър, vový_, geil_, _airr, 
   {{0x80be8066,0x443cb4c6,0x7c3c3a4d,0x43950a3d}},	// [23d0] ्हों, _kiv_, _birr, лаас, 
   {{0x9f5c803e,0x3b54146c,0x6fdd8741,0x442a0a63}},	//   tový_, икур, _rèco, _chb_, 
   {{0x443cba4e,0x20031527,0x7dd58170,0x9f580093}},	//   _miv_, mnji_, _zásu, kirê_, 
   {{0xe7e581ff,0x443ca398,0x26170803,0x973c81de}},	//   कसभा_, _liv_, rços_, _gaći, 
   {{0x7dd5ba4f,0x9f5c826b,0xdfd59d65,0x56e102c3}},	//   _mást, sový_, лоды, _тұңғ, 
   {{0x443cba50,0x7dd581ce,0x9f5c8507,0x0e050ff6}},	//   _niv_, _lást, pový_, _рӯҳо, 
   {{0x6e3d3a51,0xf1a7ba52,0x4e9580fe,0x764500db}},	//   _kisb, _иран, اشتر, _juhy, 
   {{0x7dd5803e,0x248d8068,0x26c9805d,0x069680fe}},	//   _nást, ttem_, ćao_, انية_, 
   {{0x6e3d3a53,0x31348940,0xb17b00f9,0xa5bb0013}},	//   _misb, _ветр, rhål, _chói, 
   {{0x7dd8012b,0x2003029f,0x248dba54,0xb17b0172}},	//   _vísi, jnji_, rtem_, shål, 
   {{0x7d1d00f9,0x1603120a,0x17f880fe,0xdb038063}},	//   _lyss, रचार_, _شركة_, _taní, 
   {{0x64b59367,0x6e3d203b,0x66e60dbe,0x61f9813b}},	//   _محتر, _nisb, қоба, niwl, 
   {{0x6d5b9b4e,0x443cba55,0x25a03a56,0x6fd4875d}},	//   mbua, _fiv_, veil_, _tàct, 
   {{0x443c8142,0x291e00f3,0x2a6c8108,0x75fe80f3}},	//   _giv_, āta_, bsdb_, vīzi, 
   {{0xdee32696,0x25a03a57,0x6e3d3a58,0x442a3a59}},	//   бори, teil_, _bisb, _rhb_, 
   {{0x443c829f,0x7dd58207,0x64a63a5a,0x52748537}},	//   _ziv_, _gást, лаба, _тушу, 
   {{0x2905046b,0x7c3c3a5b,0x25a03a5c,0xe3ba0004}},	// [23e0] şlar_, _pirr, reil_, нба_, 
   {{0x7dd585e1,0xfc3f00fe,0x25a00c9f,0x24803a5d}},	//   _zást, _tsín_, seil_, ruim_, 
   {{0x7645047f,0xdb0a89b2,0x61e4068e,0x7c3c3a5e}},	//   _guhy, _cafè, _klil, _virr, 
   {{0x00e6974b,0x7cda01a8,0xaa5709ef,0x067b03f3}},	//   лжен, _pārā, النا_, _אנטל, 
   {{0xb4cd807a,0xd9178163,0x66043a5f,0x7c3c01bb}},	//   रहो_, льш_, mnik, _tirr, 
   {{0x66043a60,0x6281ba61,0x63a1829f,0xeeaaa1cb}},	//   lnik, kulo, jeln, етик_, 
   {{0x63a1ba62,0x69dd0008,0x65661098,0xdb018172}},	//   deln, ykse, _kekh, ndlä, 
   {{0x443c9123,0x66043a63,0x64463a64,0x6e3d06b0}},	//   _siv_, nnik, _kuki, _xisb, 
   {{0x69c0ba65,0x443c81c8,0xa3e8023b,0x600a8b29}},	//   _inme, _piv_, _बता_, _знам_, 
   {{0xda7aba66,0x644601d5,0x644fa4dd,0x61e43a67}},	//   ням_, _muki, ícia, _alil, 
   {{0xd00f803f,0x66043a68,0x443cba69,0x64463a6a}},	//   _علم_, knik, _viv_, _luki, 
   {{0x15469317,0x69dd036d,0xa01b0008,0xe135019b}},	//   _седм, ukse, ytös, инны, 
   {{0x20030024,0x443c81c8,0x5c56813f,0x7dd581ce}},	//   tnji_, _tiv_, _стеф, _vást, 
   {{0x6281921f,0x53349b24,0x63a1829f,0x7d1d3a6b}},	//   bulo, _келт, celn, _ryss, 
   {{0x6281ba6c,0x64463a6d,0x9f3500f0,0x539b8039}},	//   culo, _auki, реві, _ניהו, 
   {{0x5d550dec,0x20030053,0x7d1d1b36,0x66043a6e}},	//   ркат, snji_, _pyss, gnik, 
   {{0xd37b34ff,0x6e3d3a6f,0xf99000fe,0x8f55003d}},	// [23f0] ече_, _visb, _ربي_, _پنجش, 
   {{0x69c0ba70,0x0a6b0188,0x6d4d093c,0x64463a71}},	//   _anme, ерди_, scaa, _duki, 
   {{0x66040ecf,0xac940004,0xdb038efd,0x63ae027e}},	//   bnik, _қарш, _kaná, _dabn, 
   {{0x6d42ba72,0xdb0aba73,0x629c3a74,0x5fc32e77}},	//   _ngoa, _café, _dpro, शावल, 
   {{0x79c989dc,0x60168123,0x601f82fd,0x4773804a}},	//   _یوسف_, tâmp, lêmi, йқау, 
   {{0x629c0065,0x3d18800f,0x69c0ba75,0x244981fb}},	//   _fpro, _पड़े_, _enme, _rúm_, 
   {{0x6d5b8816,0x64460265,0x65663a76,0xd3440019}},	//   tbua, _zuki, _yekh, _اہمی, 
   {{0x660d8bfc,0x9f58016c,0x78a9822a,0x9f4100e9}},	//   čako, tirë_, _tsev, _dlhé_, 
   {{0x63a1ba77,0x6d5bba78,0xa787815e,0x78a990f1}},	//   teln, rbua, _مشاو, _usev, 
   {{0x8d2880b6,0x6281ba79,0xdb188422,0x66043a7a}},	//   ының_, tulo, _enví, znik, 
   {{0xc7c48103,0x02063a7b,0x3b098b29,0xdb038cd7}},	//   _усти, изон, тено_, _baná, 
   {{0x63a1ba7c,0x660409e2,0xd9f780da,0x601f82fd}},	//   seln, xnik, ूचित_, dêmi, 
   {{0x7dd8000d,0x63a1ba7d,0x6281ba7e,0x3d0400a1}},	//   _míst, peln, sulo, _रखें_, 
   {{0x66040066,0x64463114,0x7dd8026b,0xdb03ba7f}},	//   wnik, _ruki, _líst, _eaná, 
   {{0x316b0066,0x09e60a5f,0x21763a80,0x656600bf}},	//   bacz_, _войн, _купр, _pekh, 
   {{0xe9df01ac,0x260b89af,0x06073a81,0x290d811e}},	//   ckú_, ावटी_, анск_, _oxea_, 
  
   {{0xf1bf0cd7,0xa01b1f55,0xddd880d7,0x629c3a82}},	// [2400] rmát_, rtör, nuvš, _spro, 
   {{0x6604068b,0x63ae01df,0x65663a83,0x6b560692}},	//   snik, _qabn, _wekh, ртах, 
   {{0xb1468e19,0x65660108,0x66043a84,0x877b025e}},	//   анел, _tekh, pnik, _באיי, 
   {{0x20180b74,0x64463a85,0xfc48801c,0x2d96070d}},	//   lori_, _tuki, _lửa_, _трос, 
   {{0x4fc69225,0x629c00a1,0xc7c68690,0x3a2d868e}},	//   иска, _wpro, иски, _dhep_, 
   {{0xdb07000d,0x20183a86,0xfc48801c,0x22400587}},	//   _zají, nori_, _nửa_, _liik_, 
   {{0xb76580f0,0x7ddc80ef,0xa5f8891a,0x4667ba87}},	//   стій, _hési, леку_, арым_, 
   {{0xd5b7ba88,0x9f4a01b2,0x20183a89,0x9fa381c2}},	//   ась_, tibû_, hori_, síðu_, 
   {{0xad9b007f,0x644000ef,0x22478149,0x5f16ad9f}},	//   _sjúk, _émis, _aunk_, _पुर्_, 
   {{0xfc488028,0x6609005d,0x9f4a024a,0x60e88a08}},	//   _cửa_, čeki, ribû_, ırmı, 
   {{0xb4db0028,0x20183a8a,0x91fd00f3,0xa6ca80fe}},	//   _ngàn, dori_, ksāt, _جوال_, 
   {{0x0583ba8b,0xd49aab48,0x7dd807ef,0xdb1c101f}},	//   _душм, _арк_, _míss, _horó, 
   {{0xfbcf87f1,0x7648ba8c,0x245481ae,0x291f81df}},	//   ستی_, _hudy, _انتس, _xyua_, 
   {{0xb7f88b30,0xd7fb3a8d,0x76488232,0x7a2382f4}},	//   ्चिम_, тум_, _kudy, võtm, 
   {{0xdb038019,0x62350591,0xdb1c378b,0x5f1a1016}},	//   _taná, _леку, _moró, _मुद्_, 
   {{0x3c2b83cd,0x764882b9,0x5d780656,0xdb188a1c}},	//   røve_, _mudy, ийся_, _invà, 
   {{0x20180524,0x22a80214,0x44213a8e,0x409500fe}},	// [2410] bori_, _aşk_, tlh_, _الخر, 
   {{0x7ddc82c0,0x3a3f80db,0xdb0e003d,0x201834cb}},	//   _dési, _siup_, _kabè, cori_, 
   {{0x24848128,0xa5bb00d8,0x3a2d812f,0x2bc93a8f}},	//   humm_, _bhót, _phep_, राबा, 
   {{0x29d7838e,0x32190e96,0xc2443a90,0xe1f0ba91}},	//   _açar_, nosy_, інік, وسن_, 
   {{0x7dd81355,0x656d2bf3,0xdce2808d,0xe80e03ca}},	//   _víst, maah, _beoč, _सदमा_, 
   {{0xf7718629,0xab840a75,0x656d24b4,0x764880a1}},	//   سات_, _муск, laah, _budy, 
   {{0x9f5802a5,0x212981ac,0xfc488106,0x61fd3a92}},	//   kirî_, ťah_, _rửa_, kisl, 
   {{0xfc488028,0x61fd3a93,0x798d006c,0x644fba94}},	//   _sửa_, jisl, _ncaw, ício, 
   {{0x442e8265,0x62853a95,0x20183a96,0x799b97ef}},	//   _bhf_, luho, yori_, _ibuw, 
   {{0x53c9ba97,0x63a5022c,0x7dd58217,0xdb0e017c}},	//   угом_, nehn, _vásq, _babè, 
   {{0x216a1975,0xa96a130c,0xae7880f0,0x7a238079}},	//   лини_, лина_, _всіх_, võtj, 
   {{0xdb038077,0x9f58024a,0x442e807f,0x6fdd8035}},	//   _lanç, girî_, _ehf_, _sèch, 
   {{0xeb999972,0x656d3a98,0x63c281d2,0x91ba8309}},	//   _бил_, daah, ávní, אמרי, 
   {{0x7ddc82c6,0xd91a8039,0xb4e393d2,0x764889fb}},	//   _rési, רושל, ननी_, _yudy, 
   {{0x799bba99,0x20183a9a,0x66e33a9b,0x6729000d}},	//   _obuw, rori_, пора, řejn, 
   {{0xfbdf001c,0xbb3a80c6,0x7ddc8530,0xa2c4854d}},	//   _quên_, _געצי, _pési, िमर्, 
   {{0xbddb00ef,0x7bd50214,0xdb18ba9c,0xeb9a0b92}},	// [2420] _sièc, _bozu, _invá, лиа_, 
   {{0xbddb03e9,0xdb039252,0x9f860d53,0xdb0e3a9d}},	//   _pièc, _canç, _угод, _habé, 
   {{0xfe7211db,0xb87b0068,0xe5a613de,0x69c412d5}},	//   _عدد_, szít, _лини, _knie, 
   {{0x69d63a9e,0xed360166,0xc8b50068,0x3eb80a07}},	//   _joye, _гэгэ, _الیک, mvrt_, 
   {{0x69d63a9f,0x7bc38399,0xdb1c3aa0,0x69c400a1}},	//   _moye, _onnu, _poró, _mnie, 
   {{0x6e243aa1,0xa09b0115,0x69d63aa2,0x62853aa3}},	//   llib, ריסט, _loye, buho, 
   {{0x2291baa4,0x3eb8007e,0x7ddc855a,0x1be70cbf}},	//   ják_, nvrt_, _mésv, _удри_, 
   {{0x7bc3baa5,0x5454baa6,0x61fd04e0,0xfbc90f2c}},	//   _annu, овит, xisl, राथम, 
   {{0x61fd003e,0xdce28265,0xf1c3801b,0x7bd53aa7}},	//   visl, _teoč, šší_, _yozu, 
   {{0xb274a532,0xd4979747,0x248000d8,0x3a7480a6}},	//   олош, ёры_, irim_, олор, 
   {{0x61fd0038,0x69d63aa8,0x441b00c6,0x69c40208}},	//   tisl, _boye, רויס, _bnie, 
   {{0x61e2baa9,0x14c83aaa,0x7bc3baab,0xd46a80b0}},	//   nkol, रमाण, _ennu, _биде_, 
   {{0xdca38dc7,0x321910ab,0xdb0501b2,0xdce6008b}},	//   _наци, rosy_, gehê, _dekċ, 
   {{0xdb018019,0x3219052a,0xb8d12d9f,0x2291baac}},	//   zelé, sosy_, _ऐन_, bák_, 
   {{0x61e2baad,0x7bd51929,0xdb0a8246,0xf40000b2}},	//   kkol, _rozu, _enfò, ্তার_, 
   {{0x6e243aae,0xbcfb0019,0x9f478170,0x78ad1a7b}},	//   glib, _idéz, diný_, _tsav, 
   {{0x63a53aaf,0x7bd5008a,0xe1ff3ab0,0xdb018019}},	// [2430] tehn, _pozu, mió_, velé, 
   {{0xe1ff13f2,0xa5bb00d8,0x62853ab1,0xdb1c269b}},	//   lió_, _chór, tuho, _enrí, 
   {{0xa6ab0bb7,0xdb018019,0xe7c780a1,0x7bd50265}},	//   _صادق_, telé, लासप, _vozu, 
   {{0xe1ff0188,0x201ebab2,0x78bbbab3,0x61e2bab4}},	//   nió_, _akti_, _pruv, gkol, 
   {{0xdb018019,0x3ea100db,0xb97c03dd,0xa5bb00d8}},	//   relé, _hpht_, רנדי, _fhór, 
   {{0xf2e71996,0x66090284,0x7e559960,0x22918063}},	//   _любо, čeku, отиц, yák_, 
   {{0xb7dc00c6,0xdb0187da,0xdddc0bbe,0x7522bab5}},	//   רקוי, pelé, lurš, _ayoz, 
   {{0x2291aaf9,0xec798873,0x91a9012f,0xdb0e0610}},	//   vák_, апи_, _nhà_, _kabî, 
   {{0xe1ff3ab6,0xb4e380a1,0x69d63ab7,0x61fbb7cf}},	//   dió_, नने_, _roye, _imul, 
   {{0x69c4323f,0x69d600ef,0x2291a96a,0xdb0e3ab8}},	//   _snie, _soye, ták_, _sabé, 
   {{0xd5ae807b,0x232984bc,0x645bbab9,0xe299baba}},	//   رفی_, рони_, spui, шан_, 
   {{0x5ed280cf,0xe1ff3abb,0xbba60562,0x27fa3abc}},	//   _থেকে, gió_, _ऑस्क, _smpn_, 
   {{0x69d63abd,0xdb0e01b2,0x776e02d1,0x9f45babe}},	//   _voye, _nabî, tabx, _allé_, 
   {{0xa2e5a28e,0x3eb80259,0x61e2babf,0x61e9bac0}},	//   _молд, tvrt_, zkol, _llel, 
   {{0xe1ff00b2,0x61fb8ca7,0xdb1c012b,0x7f430ef2}},	//   bió_, _omul, _norð, держ, 
   {{0xe1ff3ac1,0x6609bac2,0x644b859d,0x69c43ac3}},	//   ció_, nnek, _kugi, _unie, 
   {{0x6e240058,0x656b8068,0xb87b0068,0x644b8a63}},	// [2440] rlib, _megh, szír, _jugi, 
   {{0x9f580013,0xdb070068,0x644bbac4,0x6443bac5}},	//   oirí_, _sajá, _mugi, _jini, 
   {{0x44258224,0x9d46236a,0x661ba56b,0x644bbac6}},	//   ill_, _менд, kouk, _lugi, 
   {{0xa926838f,0x66098a63,0x661b819b,0x24801428}},	//   одел, jnek, jouk, prim_, 
   {{0x61e2bac7,0xa7aa8103,0x764283ad,0x9f5ca52e}},	//   rkol, икда_, _rioy, livé_, 
   {{0x61e982a6,0x66098122,0x6443bac8,0xdb1c01c2}},	//   _elel, enek, _nini, _forð, 
   {{0x644b8116,0x98a38162,0xfe6fbac9,0x656b82fb}},	//   _augi, _ąją_, ندي_, _begh, 
   {{0x9343036a,0xd49a84b6,0x644bbaca,0x4425bacb}},	//   _інте, аро_, _bugi, ell_, 
   {{0x6443bacc,0xe1ff06c9,0x644b91f4,0x9f478217}},	//   _bini, vió_, _cugi, ginó_, 
   {{0x7ddc83e9,0x6443bacd,0xbea68325,0xa2f480f0}},	//   _résu, _cini, _мазк, зпоч, 
   {{0xe1ff05cb,0x661bbace,0xe3b88214,0x3eb88063}},	//   tió_, bouk, llık_, _ért_, 
   {{0x201c8a06,0x644bbacf,0x6443925c,0x6ce6a8c9}},	//   lovi_, _fugi, _eini, _міле, 
   {{0xe1ff05cb,0xa92b005a,0xe3b88214,0x64439f99}},	//   rió_, ріне_, nlık_, _fini, 
   {{0xbebc834a,0xe1ff0188,0x6443bad0,0x3a203ad1}},	//   _dzīv, sió_, _gini, _ekip_, 
   {{0x3dc68052,0x23c90353,0x356b3ad2,0x3a26bad3}},	//   _know_, रासद, иран_, klop_, 
   {{0x63a8bad4,0x7a120029,0x64438103,0x6288bad5}},	//   ledn, tāte, _zini, mudo, 
   {{0x628880b2,0x34943ad6,0x7bd8bad7,0x290c01b2}},	// [2450] ludo, матр, _kovu, şdar_, 
   {{0xa2be86df,0x61fbbad8,0x9f3528c9,0x60c000c0}},	//   षिप्, _smul, _непі, æmme, 
   {{0x201c803b,0x62888305,0x7afc80fe,0x6609bad9}},	//   dovi_, nudo, úrth, ynek, 
   {{0xdb18810d,0xdb0a840a,0xda780091,0x660080ac}},	//   _invä, _mafà, іях_, jimk, 
   {{0x4425bada,0x998d81ac,0x201c839f,0xf7f4003d}},	//   yll_, _tiež_, fovi_, _رسید, 
   {{0x63a88081,0x201c8131,0xa2a6000f,0x644bbadb}},	//   jedn, govi_, _टैक्, _rugi, 
   {{0x644bbadc,0xfbd20052,0x6443badd,0x661bbade}},	//   _sugi, _אתם_, _rini, touk, 
   {{0x2bc913d2,0x25a90015,0x63b52b52,0x4155904c}},	//   रावा, neal_, _hazn, _хвас, 
   {{0x6443badf,0x201c8024,0x24893ae0,0x321d8034}},	//   _pini, bovi_, nuam_, mowy_, 
   {{0x25a9115e,0x644388c6,0x7bd8bae1,0x656ba771}},	//   heal_, _qini, _covu, _wegh, 
   {{0x7bd8bae2,0x316dbae3,0x63b53ae4,0x4425bae5}},	//   _dovu, _keez_, _mazn, rll_, 
   {{0x63b500d7,0x644bbae6,0x38691e56,0x3d958634}},	//   _lazn, _tugi, _bwar_, _хидр, 
   {{0xdb1899e7,0x6443b11f,0x63a882f0,0x25a93ae7}},	//   _anvä, _tini, bedn, deal_, 
   {{0x386901d0,0x628889d8,0x9f5cbae8,0x2a678432}},	//   _dwar_, budo, tivé_, _twnb_, 
   {{0xf1bf0013,0xfaa28574,0x62888ca1,0xe7f38073}},	//   mlán_, _защо, cudo, _अतना_, 
   {{0x201c8024,0x7bc7185a,0x25a93ae9,0x40963aea}},	//   zovi_, _anju, geal_, _ерот, 
   {{0xdca33aeb,0x321d80a1,0x248903bf,0x64a30181}},	// [2460] нати, dowy_, guam_, ната, 
   {{0xa0970115,0x660097fb,0xdb1c0341,0x32023aec}},	//   _צדיק_, zimk, _morö, liky_, 
   {{0x201c8053,0x386902ae,0xdce08284,0x3ce60a5b}},	//   vovi_, _zwar_, pamć, šov_, 
   {{0x8c463aed,0x32020b35,0x63a880a1,0x628f80a1}},	//   _неме, niky_, zedn, ńcow, 
   {{0xd7c78e7b,0x25d7096e,0xe89482cb,0x63b53aee}},	//   लांच, _זוכן_, фаль, _fazn, 
   {{0xdb0e0422,0xdb0a80f9,0xdb0381b2,0x7416015e}},	//   _habí, _infö, _qanû, _روزا, 
   {{0xcfb600b2,0xfbc90c64,0x3a26baef,0xa01b1e4a}},	//   ঞাপন, रारम, plop_, krön, 
   {{0xf64f803d,0x764600db,0xdb0380e9,0x7bd883ad}},	//   دئو_, _jiky, _fanú, _sovu, 
   {{0x7bd88524,0x201c803a,0x6600baf0,0x32021865}},	//   _povu, povi_, rimk, diky_, 
   {{0x6288baf1,0x9f4781e9,0x7ddc82fd,0xb05b010d}},	//   tudo, sinò_, _péss, lväg, 
   {{0x63a89b0a,0xa75b8039,0x61358019,0x32023af2}},	//   redn, _הדבר, pülé, fiky_, 
   {{0xdb0e03ce,0x6288806d,0xddcb0269,0x80b38034}},	//   _nabí, rudo, _žiža, _इनमे, 
   {{0x7bd8baf3,0x68e28103,0x2fda048a,0x246581b2}},	//   _tovu, nyod, _bopg_, rêmî_, 
   {{0xd7f80123,0xf1bf3af4,0xa01b0063,0x2d9c0063}},	//   пус_, clán_, ltöz, ővel_, 
   {{0x752f0d99,0xa3b585b7,0x25a90c8c,0x24528106}},	//   _szcz, _चोट_, teal_, _hâm_, 
   {{0x63b5003a,0xe3b882bc,0x6a1528c9,0x65641840}},	//   _sazn, ldı_, _імпу, gbih, 
   {{0x61ed3af5,0xb4e73af6,0x67ef8142,0x73d93af7}},	// [2470] _ilal, बने_, _høje, одар_, 
   {{0xe3b882bc,0x25a93af8,0x67250008,0x68e2baf9}},	//   ndı_, seal_, _tyhj, dyod, 
   {{0x98b9046b,0x25a93afa,0x2489006c,0x2452801c}},	//   ması_, peal_, suam_, _lâm_, 
   {{0x7a3f1523,0x9f580207,0x2295009a,0x62970109}},	//   _būti, mirá_, råk_, rtxo, 
   {{0x656f0324,0x248906b0,0x321dbafb,0x7a1200f3}},	//   _iech, quam_, rowy_, nāta, 
   {{0xb8d58611,0x656f3afc,0x7bc70245,0x98b90a08}},	//   _जन_, _hech, _unju, nası_, 
   {{0x656f0004,0xdce600f3,0x9f581f28,0x60c0bafd}},	//   _kech, _iekā, nirá_, _ermm, 
   {{0x644f0b64,0x660d3afe,0x2003022c,0x64473aff}},	//   _kuci, nnak, hiji_, _hiji, 
   {{0x98b90186,0x64473b00,0xf1bf0e7c,0xdcfd06c8}},	//   kası_, _kiji, tlán_, _kası, 
   {{0x656f3b01,0x61ed3b02,0x20033b03,0x64470010}},	//   _lech, _alal, jiji_, _jiji, 
   {{0x64473b04,0x3202026b,0xdb088741,0x26c101c8}},	//   _miji, tiky_, nedè, _nrho_, 
   {{0x656f3b05,0x471a896e,0x645d232c,0x69db83e9}},	//   _nech, _וועג, _otsi, _joue, 
   {{0x25098283,0x660d05c3,0x645d1123,0x32022519}},	//   _برای_, dnak, _ntsi, riky_, 
   {{0xdcfd07fa,0xdb0e0dd4,0x69dbaf75,0xdce600f3}},	//   _nası, _sabí, _loue, _nekā, 
   {{0x645d3b06,0x656f3b07,0x9f583b08,0x69c9bb09}},	//   _atsi, _bech, rirà_, _onee, 
   {{0x660d3b0a,0x656f204e,0x61ed068e,0xdb0a80d8}},	//   gnak, _cech, _glal, _uafá, 
   {{0x20030d69,0x644f0574,0x656f3b0b,0x64473b0c}},	// [2480] biji_, _cuci, _dech, _biji, 
   {{0x644f3b0d,0x9f459ff2,0x64a4005a,0x9f58060e}},	//   _duci, _allí_, маға, birá_, 
   {{0xe2971b78,0x6d598c50,0x656f03bc,0x64473b0e}},	//   дах_, _ofwa, _fech, _diji, 
   {{0x6d4bbb0f,0xa9679f73,0x79a389c5,0x644f0495}},	//   _ngga, дица_, врше, _fuci, 
   {{0x66043b10,0xd6cf803d,0x7a238079,0xe3b883d2}},	//   miik, یقه_, võtt, ydı_, 
   {{0x66040f65,0x6d4bbb11,0x6a860004,0xb05b0172}},	//   liik, _agga, _олга, sväg, 
   {{0x2452bb12,0x656f03ad,0x7a2382f4,0x69db8429}},	//   _sâm_, _yech, tõtt, _foue, 
   {{0x98b90085,0xc8838214,0x1dc58bc2,0x69dbbb13}},	//   zası_, üğü_, वागत, _goue, 
   {{0x7bdc3b14,0x98b90816,0xdb1c040a,0xe3b882d1}},	//   _koru, yası_, _eorô, tdı_, 
   {{0x61ed10f1,0x88bd80a1,0x32000050,0xc0a99866}},	//   _slal, _myśl, _amiy_, _عاقل_, 
   {{0x2003029f,0xddcb803b,0xdd8f8ba0,0xe3b882bc}},	//   viji_, žišt, _иш_, rdı_, 
   {{0x2452810b,0x7c6694f9,0x9f58018e,0xd25781e2}},	//   _tâm_, _قاتل, virá_, ьць_, 
   {{0x656f3b15,0x60f801bc,0x64c8000f,0x660d01ac}},	//   _rech, дняя_, रमोश, vnak, 
   {{0x656f3b16,0x9f5828cc,0x67ef80c0,0x645d068e}},	//   _sech, tirá_, _tøje, _rtsi, 
   {{0x656f3b17,0xa3d20624,0x75ea003e,0x98b90180}},	//   _pech, वान_, _význ, rası_, 
   {{0x20030284,0x6e20a19a,0x64473b18,0x9f583b19}},	//   siji_, nomb, _siji, rirá_, 
   {{0x656f3b1a,0x660d090b,0x644726a6,0x69db80ef}},	// [2490] _vech, rnak, _piji, _roue, 
   {{0x7bdc3b1b,0xfe710068,0x656f02ae,0x644f0c0e}},	//   _coru, _مگر_, _wech, _vuci, 
   {{0x7bdc12c9,0x6e20bb1c,0x64473b1d,0x69dbbb1e}},	//   _doru, komb, _viji, _poue, 
   {{0x7bdc017c,0x3e7a8029,0xdb08bb1f,0xd13180d8}},	//   _eoru, dīt_, gedé, هما_, 
   {{0xa069a4cb,0x1869a0e2,0x645d3b20,0x6e29bb21}},	//   чала_, чали_, _utsi, vleb, 
   {{0x63b8bb22,0x7bdc10a5,0xdb070741,0x76b382d1}},	//   _navn, _goru, _majú, _həyə, 
   {{0xfc48810b,0x26c183ce,0xd6d19fc1,0xb6a5bb23}},	//   _gửi_, ího_, اقع_, хийл, 
   {{0x6e20a714,0x44213b24,0x22988019,0x7bdc0214}},	//   gomb, loh_, dék_, _zoru, 
   {{0x7bdc017e,0x6e29b837,0xdb018a5b,0x44213b25}},	//   _yoru, rleb, delá, ooh_, 
   {{0xf6e79ca8,0xa3d2059b,0x44212716,0x629abb26}},	//   _оцен, वाय_, noh_, ftto, 
   {{0x63b88025,0x21291a28,0xdb15026b,0x6e20bb27}},	//   _davn, _ayah_, _bazé, bomb, 
   {{0x61f9aa77,0x7bca8371,0x6d4ba5fb,0x44213b28}},	//   _çalı, _enfu, _ugga, hoh_, 
   {{0x4421060b,0x1c399747,0x629a8008,0x64a581e2}},	//   koh_, _езды_, atto, _чала, 
   {{0xcc768115,0xf1b98a63,0x2298bb29,0x212905bd}},	//   _טענה_, _laš_, bék_, _dyah_, 
   {{0x44210058,0x6da616df,0x5f1a010c,0x66043b2a}},	//   doh_, нива, _मुख्_, tiik, 
   {{0x7bdc2a77,0x25ad8622,0xc1ba00a7,0x22493b2b}},	//   _soru, neel_, _رابط_, _giak_, 
   {{0x7bdc3b2c,0x660426e7,0xdb1881b2,0x76b3808a}},	// [24a0] _poru, riik, _navê, _dəyə, 
   {{0x7bdc0816,0xa09b0273,0x25ad9130,0x66043b2d}},	//   _qoru, _צייט, heel_, siik, 
   {{0xf1b9803b,0x386d868e,0x2bb7807a,0x79a693c9}},	//   _baš_, _awer_, _असना, ерле, 
   {{0x60c43b2e,0xdb18824a,0xd910804e,0x9f5c811e}},	//   _krim, _bavê, لیز_, riví_, 
   {{0xf1238bc6,0x44211098,0x25ad8387,0x9f458741}},	//   льшо, boh_, deel_, _allà_, 
   {{0x3e7a8029,0x44213b2f,0x2298bb30,0xdb188093}},	//   tīt_, coh_, yék_, _davê, 
   {{0x4438035b,0x63b8882b,0x6e20bb31,0x629a8064}},	//   _ihr_, _ravn, tomb, xtto, 
   {{0x3e7a80f3,0x63b88ece,0x443807a2,0x32078063}},	//   rīt_, _savn, _hhr_, ényt_, 
   {{0x3e7a8029,0x248d857a,0x22490238,0x2cb20324}},	//   sīt_, guem_, _riak_, nwyd_, 
   {{0x22988068,0xa87b8052,0xa01b08c5,0x60298093}},	//   ték_, _מאמר, tröm, rêmê, 
   {{0x60c43b32,0x05669683,0x44380064,0xda77bb33}},	//   _arim, _звен, _mhr_, няя_, 
   {{0x2298bb34,0xddea803d,0x60c43b35,0xf8bf0170}},	//   rék_, _عرضه_, _brim, tvé_, 
   {{0xebe6b57a,0xf8bf02c0,0x291e22d9,0x44213b36}},	//   _подп, uvé_, ştan_, yoh_, 
   {{0xf8bf00ef,0xdb18816c,0x2cb2011a,0x2298bb37}},	//   rvé_, _javë, dwyd_, pék_, 
   {{0x443e835b,0x60c43b38,0x6e262069,0x25a0043a}},	//   mmt_, _erim, _bkkb, ffil_, 
   {{0x7c3e1355,0x644abb39,0x442ca6b0,0x60c404fb}},	//   empr, _hifi, lld_, _frim, 
   {{0x44213b3a,0x644abb3b,0x60c40d75,0x69cd004f}},	// [24b0] toh_, _kifi, _grim, _inae, 
   {{0x7a363b3c,0x1602009b,0x62888036,0x644a82a1}},	//   ráte, रोबर_, ordo, _jifi, 
   {{0xa5f93b3d,0x644a81cb,0x442c81c2,0x44383b3e}},	//   _жену_, _mifi, ild_, _dhr_, 
   {{0x44213b3f,0x443e81ab,0x644abb40,0x225c15b1}},	//   soh_, hmt_, _lifi, ívka_, 
   {{0x25ad9169,0x644a803c,0xed598131,0x44210883}},	//   veel_, _oifi, ndže_, poh_, 
   {{0x9f4585cb,0x44211a84,0x644abb41,0x660281d7}},	//   _allá_, qoh_, _nifi, _amok, 
   {{0xf1a7a5da,0x79a781e2,0x25adbb42,0xf1b981f7}},	//   _пран, _прае, teel_, _taš_, 
   {{0x6e2d3b43,0xa91d8092,0x2bc9001b,0x248dbb44}},	//   nlab, _adže, राका, tuem_, 
   {{0x6e2d0052,0x8cc400a1,0x628881ce,0x644abb45}},	//   ilab, रियो, erdo, _bifi, 
   {{0xa5bb012b,0x6e2d0504,0x69cd3b46,0x248902fd}},	//   _skól, hlab, _anae, iram_, 
   {{0xa3d20365,0xd2440004,0x24891ef3,0x60c40497}},	//   वात_, лмоқ, hram_, _srim, 
   {{0xd70d83ff,0x442c81f0,0xe8ff024a,0x24890fe3}},	//   िपीठ_, ald_, rbûn_, kram_, 
   {{0x2489296b,0x248dbb47,0xe3ae898b,0x7c218bd4}},	//   jram_, quem_, _кб_, polr, 
   {{0x2007bb48,0x6569872c,0x7a38bb49,0x1304804a}},	//   nini_, lbeh, míte, _өзім, 
   {{0xd62a3b4a,0xa5961711,0x91fd00f3,0x6e2d378b}},	//   дове_, кращ, mpān, flab, 
   {{0x2007bb4b,0x6e2d3b4c,0xa6e9801c,0x6569bb4d}},	//   hini_, glab, _trươ, nbeh, 
   {{0x200780fd,0xb9070a87,0xe3ba1ae0,0xa50716d2}},	// [24c0] kini_, _যে_, мба_, вета_, 
   {{0x2007bb4e,0x64a33b4f,0x2bd21131,0x6e2d3b50}},	//   jini_, рафа, साधा, alab, 
   {{0xee3a062e,0x44278238,0xd259109a,0xeb973b51}},	//   _оно_, _mkn_, еці_, тих_, 
   {{0x58869747,0x24890da7,0x6d5b81df,0x656981f0}},	//   выка, bram_, jcua, jbeh, 
   {{0xa3d22c63,0x2007bb52,0x443ea6b0,0xdce40131}},	//   वाद_, fini_, ymt_, obič, 
   {{0x2007bb53,0x4438035b,0x443e034e,0x656980e9}},	//   gini_, _uhr_, _òt_, ebeh, 
   {{0x60090524,0x644abb54,0xa3d58aed,0x63bc2c1c}},	//   nžma, _rifi, हान_, _iarn, 
   {{0x4427ae3e,0x644abb55,0x6adb00b2,0x54b8bb56}},	//   _akn_, _sifi, _যেকো, егия_, 
   {{0x61e0806b,0x41d6000c,0x44278a00,0x229c026b}},	//   _ioml, धानस, _bkn_, lík_, 
   {{0x3866bb57,0x442c8052,0x2bb7809b,0x63bc3b58}},	//   mpor_, uld_, _असणा, _jarn, 
   {{0x443ea1d1,0x229c03e0,0x764b8068,0x442cbb59}},	//   rmt_, ník_, _figy, rld_, 
   {{0x24890960,0x8b0781d2,0x63bc03ad,0x6e2d011e}},	//   yram_, _skří, _larn, xlab, 
   {{0x69df0103,0x63bc00bf,0x6ba7810d,0x442c80bf}},	//   _voqe, _oarn, ärgå, pld_, 
   {{0xdb03bb5a,0x4427811e,0x69cd011a,0x61e0bb5b}},	//   _canó, _gkn_, _wnae, _loml, 
   {{0x2bb78365,0xdceb80f3,0x5c378080,0xdb0196f7}},	//   _असता, _iegā, _שטוב_, gelä, 
   {{0x24893b5c,0x518719eb,0x61e08103,0x229c0170}},	//   tram_, _рука, _noml, dík_, 
   {{0x6e2d3b5d,0x2007bb5e,0x63bc3b5f,0x7bda822a}},	// [24d0] rlab, yini_, _barn, ojtu, 
   {{0x3179011d,0x24893b60,0xd37880a1,0x6e2d3b61}},	//   lasz_, rram_, nać_, slab, 
   {{0xf09f01c3,0x63bc3b62,0x16229d62,0x78a980e9}},	//   ltà_, _darn, मवार_, _spev, 
   {{0xd378bb63,0xf650011d,0xdb1c01b2,0xa5f93a97}},	//   hać_, _گئی_, _karê, _чему_, 
   {{0x2007bb64,0xd37880a1,0xf09f1f2e,0x3c398035}},	//   tini_, kać_, ntà_, lève_, 
   {{0xe739bb65,0xb4df009b,0xf09f360e,0x1e95bb66}},	//   нел_, तही_, ità_, грир, 
   {{0x20078b75,0xed5996f0,0xd3788066,0x9f5105cb}},	//   rini_, ной_, dać_, lizó_, 
   {{0x200789d6,0x26c5803b,0xe3b8808a,0x63bc3b67}},	//   sini_, _vrlo_, dlıq_, _zarn, 
   {{0xdd118186,0x2007bb68,0xdd918068,0x9f5101ce}},	//   _düşm, pini_, لوں_, nizó_, 
   {{0x7a388de8,0x3a292f08,0x2007bb69,0x7c250170}},	//   ríte, _akap_, qini_, nohr, 
   {{0x81b68a87,0x420a1ccf,0x224d81e2,0xf09f009f}},	//   জার_, енно_, _kiek_, età_, 
   {{0x3a2900bf,0xdb08833b,0x6ec08673,0x75ea01d2}},	//   _ckap_, cedí, विरु, _výzk, 
   {{0x22478414,0x4427bb6a,0xdb1c1334,0x229c0170}},	//   ínky_, _tkn_, _carê, zík_, 
   {{0x66098602,0x25bd811a,0x224dbb6b,0xdb1c01b2}},	//   liek, _hawl_, _liek_, _darê, 
   {{0x4425bb6c,0x98a50029,0x249fbb6d,0xd757004e}},	//   mol_, ālā_, ltum_, الفت_, 
   {{0x6609834a,0x229c012b,0xe1f2007b,0x25bfbb6e}},	//   niek, vík_, _دست_, ndul_, 
   {{0xfbb788dd,0x61e0bb6f,0xd57505cf,0x63bc1c35}},	// [24e0] _असाम, _roml, русь, _parn, 
   {{0x44258360,0x229c3b70,0x69a02332,0x61e0bb71}},	//   nol_, tík_, ग्री, _soml, 
   {{0x64a30599,0xdee63b72,0x5186bb73,0x63bc3b74}},	//   _қара, _сони, гула, _varn, 
   {{0x4425bb75,0xa3d20f2c,0x249faca3,0xd3788034}},	//   hol_, वाह_, ktum_, zać_, 
   {{0x4425b455,0x63bc3b76,0xdb18824a,0x7a1c81d2}},	//   kol_, _tarn, _navî, jčte, 
   {{0xb4c20b30,0x2ca00e87,0x4425bb77,0x3866bb78}},	//   ्मी_, mtid_, jol_, rpor_, 
   {{0x2ca03110,0x4425bb75,0x3866bb79,0x09a980cf}},	//   ltid_, dol_, spor_, ওয়া, 
   {{0xd3788d99,0x200a1e78,0xb05b0172,0xa3d2058e}},	//   wać_, hibi_, dvän, वाव_, 
   {{0x7ddc811d,0x644e3b7a,0x44258324,0x2ca02d29}},	//   _kész, _kibi, fol_, ntid_, 
   {{0x4425bb7b,0x3a2680d0,0x1958005a,0x224d81f0}},	//   gol_, loop_, ғары_, _ziek_, 
   {{0x9e6695d8,0xa91d8265,0xc3fb00c6,0x6609bb7c}},	//   _свед, _idža, גליש, biek, 
   {{0x644e3b7d,0xf09f0574,0xf2d30273,0xdb1c024a}},	//   _libi, ttà_, צער_, _parê, 
   {{0x4425bb7e,0x79840324,0x3dc0011a,0x7d7b83f3}},	//   bol_, _ddiw, ddiw_, _טראג, 
   {{0x4425bb7f,0xf09f01c3,0xc3568574,0xf41f0172}},	//   col_, rtà_, _съдъ, _iväg_, 
   {{0x3a268d55,0xa36f80e9,0xf09f3b80,0xd90f003d}},	//   koop_, äčši, stà_, تیک_, 
   {{0x2bd29131,0x270e8816,0xb4c2036c,0x442a3b81}},	//   तावा, _mən_, ्मू_, _akb_, 
   {{0x644e3b82,0x9f4100f8,0x33751f57,0xa91d839f}},	// [24f0] _bibi, _kohë_, игар, _odža, 
   {{0x644e3b83,0x320b3b84,0x6609bb85,0xbcfb011e}},	//   _cibi, licy_, ziek, _aféc, 
   {{0x644e3b86,0xddd00214,0x9e35167d,0x4155bb87}},	//   _dibi, _çeşi, _венч, авес, 
   {{0xac953b88,0x320b0034,0x4425bb89,0x4c9503ad}},	//   _камш, nicy_, zol_, _кимс, 
   {{0x656d1040,0x4425bb8a,0xa3e5a548,0x2ca0043a}},	//   mbah, yol_, _नवल_, ctid_, 
   {{0xdceb8123,0xba770a57,0x9f51808a,0x660980a1}},	//   _legă, _مارت, _özü_, wiek, 
   {{0x224da4a4,0x6609bb8b,0x5884805a,0xb3d20365}},	//   _tiek_, tiek, _қыта, सारख, 
   {{0x656d3b8c,0xfbb78066,0x249fbb8d,0x4425bb8e}},	//   nbah, _असहम, ttum_, wol_, 
   {{0x4425bb8f,0x25bfbb90,0xec769747,0x20ce81c2}},	//   tol_, rdul_, апы_, rðið_, 
   {{0xa3ab01b7,0x6609bb91,0x249fbb92,0x60c9bb93}},	//   _कॉम_, siek, rtum_, _irem, 
   {{0x249fbb94,0xddc701e2,0x216a2c78,0xc5d5a313}},	//   stum_, gpjū, кини_, _віль, 
   {{0x4425bb95,0xb05b00f9,0x249f81c2,0xd9462e05}},	//   sol_, rvän, ptum_, иени, 
   {{0x69d801aa,0x777702fa,0xed4ebb96,0x7a1200f3}},	//   याबी, _bexx, _фо_, nāti, 
   {{0x88bd80a1,0x248dbb97,0x18671acf,0x4425bb98}},	//   _wyśw, mrem_, рари_, qol_, 
   {{0x7ddc811d,0x645b929b,0xf7461a59,0x200a3b99}},	//   _rész, lqui, рево, ribi_, 
   {{0xdd921c98,0x05663b9a,0x8e553b9b,0x644e3b9c}},	//   تور_, рван, стрі, _sibi, 
   {{0x7a361553,0x9f4780fe,0xa3d20353,0x248d80db}},	// [2500] láto, ghnú_, वाल_, nrem_, 
   {{0x907b0273,0x7bc1bb9d,0x2ca01120,0x187b00c6}},	//   _שטיי, ndlu, rtid_, _שטיב, 
   {{0x2ca03b9e,0xe29a3b9f,0x7a360cd7,0xdb1503b8}},	//   stid_, тае_, náto, _razã, 
   {{0x657bb9cd,0x60c98469,0x7ae31be6,0xb05b0172}},	//   jauh, _brem, änta, kväl, 
   {{0x6846bba0,0xe046ac17,0x270e808a,0xf8b80079}},	//   анда, анди, _sən_, ेटिय, 
   {{0x24803ba1,0x76440214,0x7a360cd7,0xdb073ba2}},	//   msim_, lmiy, káto, _cajó, 
   {{0x44443ba3,0x60c9bba4,0x7a3d3ba5,0x645b8149}},	//   mm_, _erem, léte, equi, 
   {{0x60c98b07,0xe5c696d2,0x806680f0,0x6ca6869d}},	//   _frem, рско, _вваж, арож, 
   {{0x2bd2800d,0x7a388aee,0x6aa90269,0x44443ba6}},	//   ताला, cíta, _ćefi, om_, 
   {{0x69c080de,0x44443ba7,0x69c282b5,0xdb1c06e0}},	//   _hame, nm_, ldoe, _parè, 
   {{0x44443ba8,0x78ad003b,0x656d00ed,0x78a28ae0}},	//   im_, _spav, ybah, ltov, 
   {{0x61e40089,0x26170208,0x248dbba9,0xa3d20079}},	//   _coil, għol_, brem_, वाँ_, 
   {{0x78a28507,0x69c0bbaa,0xfeb80f2a,0x98b80be1}},	//   ntov, _mame, یافت_, алят_, 
   {{0x44443bab,0xb4c20a42,0x8c4387e4,0xdb18bbac}},	//   jm_, ्मै_, _дече, _haví, 
   {{0x69c08012,0xc987296d,0x61e41b0d,0x7c28bbad}},	//   _oame, _купи, _foil, modr, 
   {{0x44443bae,0x81ab8a87,0x5d55038f,0xdb0508b4}},	//   em_, _কোন_, скат, nehå, 
   {{0xa3d20073,0x78a2bbaf,0x656d3bb0,0x78ad0269}},	// [2510] वां_, jtov, rbah, _upav, 
   {{0xf3673bb1,0x764406b5,0x6380001b,0x6fb509dc}},	//   ртан, amiy, vání, _امدا, 
   {{0x60c9b7b4,0xdb1501ac,0x69c0b0f1,0x645b8685}},	//   _srem, _bazá, _bame, zqui, 
   {{0xb5a71b17,0xc987a085,0x44443bb2,0xdb18801b}},	//   _трой, ружи, am_, _naví, 
   {{0x69d8009b,0x7c2880f8,0x7a3603c3,0xb05b010d}},	//   याती, kodr, záto, kväm, 
   {{0x645d82ba,0x6562840a,0xa3d20a42,0xafe2819b}},	//   ísim, _afoh, वाः_, зошл, 
   {{0x69c0bbb3,0x75ea026b,0x657b820e,0x7a38bbb4}},	//   _fame, _výzv, tauh, síta, 
   {{0x660d3bb5,0x248dbbb6,0x69c0bbb7,0xff1804fc}},	//   niak, trem_, _game, יקות_, 
   {{0x32f7808a,0xf1bf00e9,0x9f41068e,0x60c99887}},	//   məyə_, hlás_, _dohé_, _urem, 
   {{0x61e422b8,0x69c0bbb8,0x248dbbb9,0x660d0109}},	//   _soil, _zame, rrem_, hiak, 
   {{0x645bbbba,0x61e43bbb,0x69c0bbbc,0x660d3bbd}},	//   squi, _poil, _yame, kiak, 
   {{0x7a36038b,0x245b8077,0x444408c6,0x186a27dc}},	//   ráto, _têm_, zm_, лами_, 
   {{0x660d04c4,0x61e402c0,0x6e29811e,0xfd568039}},	//   diak, _voil, moeb, _השני_, 
   {{0x7afe3bbe,0x76aa8816,0x7a3d0019,0x7c28b78b}},	//   yzpt, _həya, véte, codr, 
   {{0x670d83ce,0x229580fe,0xe45f010d,0x660d0fad}},	//   िपटक_, _العس, _dröm_, fiak, 
   {{0x78a2803e,0x4444150d,0x6459bbbf,0x660d3bc0}},	//   ytov, wm_, _kuwi, giak, 
   {{0x228387fa,0x764422d9,0x5baa3bc1,0x78a2826b}},	// [2520] lık_, rmiy, лкам_, xtov, 
   {{0x44441123,0x69c087d2,0x24803bc2,0x76443bc3}},	//   um_, _same, rsim_, smiy, 
   {{0x69c09d24,0x62818437,0xdcef0029,0x7d090524}},	//   _pame, nslo, _vecā, _žest, 
   {{0x44443bc4,0xe8fabbc5,0x5ca601c0,0x6579bbc6}},	//   sm_, лле_, _лимб, _newh, 
   {{0x69c2bbc7,0x1754829d,0x9f41047f,0xb3b7b89b}},	//   rdoe, овля, _rohé_, _असंख, 
   {{0x69c080fd,0x78a2bbc8,0x22583bc9,0xab2a15d8}},	//   _wame, rtov, _turk_, _бога_, 
   {{0x69c0bbca,0x78a2bbcb,0x9f45824a,0x76aa808a}},	//   _tame, stov, _holê_, _bəya, 
   {{0x8a06bbcc,0x78a2bbcd,0x22838214,0x6459820e}},	//   _узбе, ptov, dık_, _buwi, 
   {{0x628380d7,0x7c28965d,0xb87b0019,0x7a388063}},	//   _avno, todr, nyít, líto, 
   {{0x660d0109,0x2cbd82b1,0x6459bbce,0x6253008b}},	//   ziak, _dswd_, _duwi, _għos, 
   {{0x02a38b82,0xdb05010d,0x22588610,0x6e299659}},	//   прям, pehå, êrk_, boeb, 
   {{0x7f3b8273,0x22403bcf,0x224680bf,0x200e82d1}},	//   _געבו, _chik_, nmok_, lifi_, 
   {{0x660d3bd0,0x25b7803d,0x2240033f,0x9f410033}},	//   viak, _دهند_, _dhik_, _dlhý_, 
   {{0x765aa0fc,0x26cc8a63,0xb4e48076,0xb4d48076}},	//   _kuty, _krdo_, नही_, हमी_, 
   {{0xa3d583b4,0xa3cc30b8,0x6b7b83dd,0x4b7b8115}},	//   हार_, _शोध_, _גרונ, _גאוו, 
   {{0xdb1c0093,0x765a812c,0xf1bf0019,0x7bcb01a8}},	//   _parî, _muty, rlás_, ēgum, 
   {{0xc4b681ff,0x660d3bd1,0x200e8050,0xae023bd2}},	// [2530] _अनोख, riak, kifi_, रोइन_, 
   {{0x660d3bd3,0x3a2d81b0,0x60cd0191,0x41a5000c}},	//   siak, _skep_, _iram, ग्रस, 
   {{0x1dc43bd4,0xbddb06e0,0x660d3bd5,0x3169833b}},	//   _लोकत, _chèc, piak, ñazo_, 
   {{0x60cd3bd6,0x3f9e80ef,0xdb1c3bd7,0x34950fbe}},	//   _kram, _actu_, _tarî, _қаҳр, 
   {{0x200e8129,0x26ccbbd8,0xf8c903f0,0x27e583d0}},	//   fifi_, _ardo_, िटिय, _poln_, 
   {{0x26cc8053,0x765abbd9,0x6281bbda,0x26c78183}},	//   _brdo_, _buty, yslo, tvno_, 
   {{0x6e29bbdb,0x518784bc,0x7bd53bdc,0xa91d8265}},	//   toeb, _гуза, _inzu, _idžm, 
   {{0x7d0907e9,0xfe6c89b2,0xdb0a82ae,0x25a93bdd}},	//   _þess, _үү_, _dafü, nfal_, 
   {{0x38690076,0xa3bd3bde,0xa3d58f2c,0x200e84e2}},	//   _ntar_, _आसा_, हाल_, bifi_, 
   {{0x7bc5007b,0x228387fa,0x52a989e4,0x98178bca}},	//   ndhu, tık_, авом_, _ابرا, 
   {{0x60cd3bdf,0xbf1580fe,0xa3ab03f2,0x28c78439}},	//   _aram, _بواب, क्य_, लिवि, 
   {{0x6459bbe0,0x75f5a337,0x60cd3be1,0x98a6065b}},	//   _tuwi, _zázn, _bram, оиме, 
   {{0x7a36026b,0x89360743,0x6281a129,0x6459813b}},	//   látk, تعدا, sslo, _uuwi, 
   {{0xcb6980f0,0x6281bbe2,0x8db502c3,0x9f4586b0}},	//   _таке_, pslo, үсті, _rolê_, 
   {{0x26cc139c,0x7bc3802d,0x60cd3be3,0xe299bbe4}},	//   ído_, _ianu, _eram, _тай_, 
   {{0x60cd3be5,0x7bd502ae,0x660b80bf,0x61fd01ab}},	//   _fram, _anzu, _jmgk, chsl, 
   {{0x7bc3bbe6,0x69d63be7,0x64a33be8,0x7a360170}},	// [2540] _kanu, _inye, мата, hátk, 
   {{0x69c40109,0x38a43be9,0x7bc53bea,0x602600f0}},	//   _haie, mör_, gdhu, _єдна, 
   {{0x75f5bbeb,0x7bc3a8ac,0x2bce0365,0xf74601e4}},	//   _názo, _manu, _होणा, _фено, 
   {{0xa3d58ef4,0x69c40122,0x19a982c3,0x69c63bec}},	//   हाँ_, _jaie, йтіп_, ndke, 
   {{0x7989811a,0x2db70039,0x7a388019,0x636681d2}},	//   _ddew, _ולכן_, síto, nční, 
   {{0x7a38bbed,0x629701e0,0x7bc3bbee,0xdb1c06c9}},	//   píto, buxo, _nanu, _harí, 
   {{0x81e68a87,0x38a42c06,0x5694bbef,0xf1ca000c}},	//   যোগ_, hör_, чайт, ियान, 
   {{0x85f70273,0x2bce2074,0x7bc382b1,0x442e8a6c}},	//   ַציע_, _होता, _aanu, _skf_, 
   {{0xdb1c3bf0,0xa3d5a23f,0x6283026b,0x1da6a226}},	//   _marí, हां_, ánov, क्षत, 
   {{0xe9ff8028,0x7a360013,0x69d606ae,0xdb1c011e}},	//   _kiến_, láth, _anye, _larí, 
   {{0x6fde01a9,0x69c43bf1,0x38693bf2,0x61e28149}},	//   मानं, _baie, _star_, ojol, 
   {{0x38a43bf3,0x60cd3bf4,0x7a3600d8,0x69c41f3e}},	//   för_, _pram, náth, _caie, 
   {{0x38a40172,0x107412f6,0xa3ab00da,0x7a3d00ef}},	//   gör_, мляю, क्ड_, géta, 
   {{0x7bc3bbf5,0x69d63bf6,0x248681f7,0xe9ff812f}},	//   _ganu, _enye, _ivom_, _phẫn_, 
   {{0x98ac00f3,0x226380e9,0x61e283cd,0xdb1c1127}},	//   ādā_, ľské_, kjol, _barí, 
   {{0x442cbbf7,0x2d580157,0xc3338130,0x69c40122}},	//   lod_, жить_, _קוק_, _gaie, 
   {{0x80ba9855,0x290200a1,0xa8028214,0xdb1c060e}},	// [2550] _शैले, czka_, şıyo, _darí, 
   {{0x69a71108,0x442cbbf8,0xe9ff8028,0x7bc38fde}},	//   ट्री, nod_, _biến_, _xanu, 
   {{0x20113bf9,0xdb1c242d,0x2c608246,0x7bc53bfa}},	//   mizi_, _farí, _lòd_, rdhu, 
   {{0x24868025,0x5bb783f2,0x2011331e,0x442cbbfb}},	//   _ovom_, _अस्व, lizi_, hod_, 
   {{0x442cbbfc,0x7e6203d0,0x3f69bbfd,0x6e2d3bfe}},	//   kod_, _čopi, било_, moab, 
   {{0xcc760130,0x20113bff,0x657d3c00,0x442cbc01}},	//   _מעשה_, nizi_, _hesh, jod_, 
   {{0x657d13ee,0xfd4c8028,0x533436cc,0x645d0010}},	//   _kesh, _triể, _жерт, _husi, 
   {{0x645d3283,0x657d3c00,0x645536d0,0xf0768068}},	//   _kusi, _jesh, _hizi, _کیوں_, 
   {{0x7bc38cae,0x64550557,0x442c8324,0x657d00f8}},	//   _panu, _kizi, fod_, _mesh, 
   {{0x7a36139c,0x442cbc02,0x657d3c03,0x7bc38816}},	//   máti, god_, _lesh, _qanu, 
   {{0x69c43c04,0x64553c05,0x7bc3abaa,0x645d3c06}},	//   _paie, _mizi, _vanu, _lusi, 
   {{0x38a43c07,0x61e9bc08,0x3d0f8076,0x273480d8}},	//   tör_, _joel, _तेथे_, súnú_, 
   {{0x645d01e2,0x442cbc09,0x61e9bc0a,0x7bc3bc0b}},	//   _nusi, bod_, _moel, _tanu, 
   {{0x764986c8,0x7fd53c0c,0x7a3d3c0d,0x644f875d}},	//   lmey, місі, réta, ïcid, 
   {{0x61fbbc0e,0x645d1bde,0x290225cf,0x657d03ad}},	//   _olul, _ausi, szka_, _besh, 
   {{0xd90d040c,0x645d3c0f,0xe8863c10,0x661bbc11}},	//   ایی_, _busi, _егип, nnuk, 
   {{0x64553c12,0x657d3c13,0xdb0a812b,0xdb1c3c14}},	// [2560] _bizi, _desh, _hafð, _varí, 
   {{0x645501d2,0x6b81bc15,0x2d800035,0x7a360432}},	//   _cizi, nalg, saie_, dáti, 
   {{0x1dbd9820,0x64553c16,0x628529dd,0x61e98504}},	//   ्यात, _dizi, gsho, _boel, 
   {{0x442cbc17,0x6d59bc18,0x61e9bc19,0xa3cc010c}},	//   zod_, _ngwa, _coel, _शोर_, 
   {{0x61e98b7e,0x442cbc1a,0xed52003d,0x6b81bc1b}},	//   _doel, yod_, _سپس_, kalg, 
   {{0x62851d23,0xe9ff8028,0x2609800f,0x4adbad9f}},	//   bsho, _tiến_, ़ोसी_, यमाव, 
   {{0x8c43262e,0x24868025,0x04430632,0xe2973c1c}},	//   _чере, _svom_, _черн, _нар_, 
   {{0xd49a9309,0xceb30052,0x645d02d1,0x645528b7}},	//   бро_, גיה_, _yusi, _zizi, 
   {{0x38c8840c,0x442cbc1d,0x7d043c1e,0x290280f9}},	//   _بازی_, tod_, nzis, _åka_, 
   {{0xe7d700b2,0x7e6d8f63,0xcfaa803d,0x6e2d03b9}},	//   _হত্য, ćapr, _دارم_, zoab, 
   {{0x644880f3,0x39403c1f,0xa1953c20,0x20113c21}},	//   rmdi, _azis_, манч, vizi_, 
   {{0x24868053,0x442cbc22,0x7a388170,0x61e9811e}},	//   _tvom_, sod_, dítk, _xoel, 
   {{0xa92b004a,0x50672f9e,0xc8672395,0x6b81bc23}},	//   сіне_, ятна, ятни, balg, 
   {{0x645d3c24,0xdb1881b2,0x1ae200cf,0xdb0e3c25}},	//   _rusi, _navç, _গেছে_, _jabó, 
   {{0x645d2c3b,0xa3e02fa8,0x657d1e34,0xa3c20ef4}},	//   _susi, थान_, _pesh, ्यन_, 
   {{0x63babc26,0x64553c27,0x645d3c28,0xa4d500f0}},	//   letn, _sizi, _pusi, мобі, 
   {{0x629aa127,0x657d00f8,0x271880a1,0x61e99185}},	// [2570] luto, _vesh, धपुर_, _roel, 
   {{0x62853c29,0x64550004,0xf0450267,0x78fc0039}},	//   tsho, _qizi, _تعبی, _לפחו, 
   {{0x64553c2a,0x3f830025,0x629a9151,0x61e98504}},	//   _vizi, maju_, nuto, _poel, 
   {{0x2fc58c05,0x62853c2b,0x3915a909,0x645d3c2c}},	//   _salg_, rsho, ммер, _tusi, 
   {{0x645d036d,0x645510eb,0x61e99d0d,0x629ab81f}},	//   _uusi, _tizi, _voel, huto, 
   {{0x63babc2d,0x629abc2e,0x7a360170,0x2ca9010d}},	//   jetn, kuto, ráti, mtad_, 
   {{0x2ca93c2f,0x61e98387,0x6b81bc30,0x2fc58255}},	//   ltad_, _toel, valg, _valg_, 
   {{0x629abc31,0x61fbbc32,0x3f831eb2,0x798d3c33}},	//   duto, _ulul, haju_, _ndaw, 
   {{0x3f83003a,0x2ca93c34,0x76498214,0x7bc73c35}},	//   kaju_, ntad_, rmey, _kaju, 
   {{0x3f83003a,0x9f638008,0xdb1c3821,0x798d0232}},	//   jaju_, ävät_, _hará, _adaw, 
   {{0x3f83003a,0x7bc70cf6,0x629aa2a9,0x7a3d026b}},	//   daju_, _maju, guto, rétn, 
   {{0x7bc72736,0x2ca93c36,0x7bd8bc37,0xa91d8a63}},	//   _laju, ktad_, _envu, _adži, 
   {{0xa3c88e78,0xb4bc00a1,0x63ba83df,0xa3c23c38}},	//   _लोक_, _आने_, betn, ्यम_, 
   {{0xfd108743,0xdb0e0065,0x2d9f8432,0x3f833c39}},	//   _حجم_, _xabó, lgue_, gaju_, 
   {{0xe9ff8028,0xb6a30188,0x67ef806d,0x3ea30188}},	//   _nhắn_, кирл, _højs, кирг, 
   {{0xa3ab030a,0xee3a0d6b,0x51560e08,0x60090269}},	//   क्स_, іна_, _отпу, džmu, 
   {{0x3f830025,0xd0408816,0xbc6a08f7,0x2ca93c3a}},	// [2580] baju_, _ermə, زمان_, gtad_, 
   {{0x3f830025,0x60c43c3b,0x7d043c3c,0xdb1c0741}},	//   caju_, _isim, rzis, _parà, 
   {{0x03a302d4,0x09e69a91,0xdb1c3c3d,0x386d80df}},	//   тихо, можн, _bará, _ater_, 
   {{0xdb1c2deb,0xdb0e3c3e,0x25ad81f0,0xe80a24af}},	//   _cará, _sabó, jfel_, होरा_, 
   {{0x7a3882b6,0x307a00c6,0xdb0e262c,0x61fd09b8}},	//   níti, קאַנ, _pabó, ërli, 
   {{0x60c40010,0x3860115e,0x7a363c3f,0x7bc720f0}},	//   _msim, _muir_, mátu, _gaju, 
   {{0xa3c880d5,0x62630692,0xdb1c3c40,0x25adbc41}},	//   _लोग_, _авса, _fará, ffel_, 
   {{0xdb1c038b,0x3f8300d7,0x683f82a5,0x629abc42}},	//   _gará, zaju_, rêda, vuto, 
   {{0x80a68c0b,0x7bc73c43,0x60c43c44,0x063703f3}},	//   _زمان, _yaju, _nsim, ונקט_, 
   {{0xa3d58f53,0x427486b0,0x79808610,0xdb1c3c45}},	//   हाग_, нгос, _hemw, _zará, 
   {{0x3f830025,0x59d00079,0x7bc8bc46,0xe2151b75}},	//   vaju_, _तोहर, rddu, емны, 
   {{0x629abc47,0x51f81747,0x27ec80e9,0x63baa75b}},	//   ruto, днюю_, _hodn_, setn, 
   {{0x38601521,0x3f83003a,0xd90f0f2a,0x2d84bc48}},	//   _cuir_, taju_, شید_, mame_, 
   {{0x629abc49,0x67ef8142,0x2d84bc4a,0x59dd001b}},	//   puto, _højr, lame_, याहर, 
   {{0x3f830025,0x60c401c4,0x7bc73c4b,0xa01b0341}},	//   raju_, _esim, _raju, lsök, 
   {{0x3f830053,0x7c3abc4c,0x7bc73c4d,0x4d7b80c6}},	//   saju_, lltr, _saju, ַרבע, 
   {{0x6458bc4e,0xe81fbc4f,0x7bc73c50,0x5c990193}},	// [2590] _kivi, _बदला_, _paju, якая_, 
   {{0x2ca93c51,0x2c640172,0x2d84bc52,0x59dd009b}},	//   rtad_, _död_, hame_, यावर, 
   {{0xa3ab0561,0x6fdd8365,0x3a2fbc53,0x2ca93c54}},	//   क्ष_, पासू, togp_, stad_, 
   {{0x6458bc55,0xdb26007b,0x61ed01ba,0x2d848116}},	//   _livi, رونی, _joal, jame_, 
   {{0x7bc73c56,0x61ed3c57,0x9f5800fe,0x6d5d0009}},	//   _taju, _moal, mhrá_, _igsa, 
   {{0x764d09d1,0x645886a8,0x07a28591,0x2489001a}},	//   lmay, _nivi, гашн, msam_, 
   {{0x25ad8012,0x49bb807b,0x82a401e5,0x9f458741}},	//   tfel_, _وارد_, _иште, _allò_, 
   {{0xcf58004d,0xa3ab09d7,0x2d84bc58,0x764d0b50}},	//   ובות_, क्र_, game_, nmay, 
   {{0x2d9fbc59,0xed5982cf,0x24893c5a,0x6458bc5b}},	//   rgue_, ježe_, nsam_, _bivi, 
   {{0x3ec4836d,0x69cbbc5c,0x5ba980c4,0x248901cb}},	//   ästä_, ldge, чком_, isam_, 
   {{0xa91d807e,0x61ed3c5d,0x3d0f8034,0x764d02d2}},	//   _deže, _boal, _तेरे_, kmay, 
   {{0x69cb850a,0xc7a90c2d,0x25e0809b,0x60c40131}},	//   ndge, _לב_, काणी_, _psim, 
   {{0xe9ff810b,0x7e618387,0x69c9bc5e,0x645886a8}},	//   _nhận_, _hulp, _maee, _fivi, 
   {{0x7a38bc5f,0xb8e8001b,0x2c640172,0x7e61bc60}},	//   ríti, _ईन_, _röd_, _kulp, 
   {{0xf6261480,0x6e290170,0x1da6802a,0x45d617c8}},	//   едво, čebn, क्कत, нцат, 
   {{0x6458bc61,0x71a30325,0xfce63c62,0x442300db}},	//   _zivi, _баъз, нобо, _ajj_, 
   {{0xdd8f0c93,0x24891917,0x60c4004f,0x79863c63}},	// [25a0] صول_, gsam_, _usim, makw, 
   {{0x61ed063c,0x26c5836a,0x2d84bc64,0x7aea010d}},	//   _zoal, _oslo_, zame_, äfto, 
   {{0x6e3bbc65,0xdb1c0077,0x2bf68273,0x8f9b00c6}},	//   klub, _març, עמען_, _ציטי, 
   {{0x312693c9,0xeac98028,0xa926bc66,0x79863c67}},	//   ндег, _mẹ_, ндел, nakw, 
   {{0xdb1a80f8,0x6b850766,0x2d8480e9,0x27fe82fa}},	//   tetë, bahg, vame_, _pltn_, 
   {{0x656bbc68,0x2d8202a5,0xfaa63c69,0x2d848e0b}},	//   _afgh, _heke_, _паго, wame_, 
   {{0x75f8026b,0x4df4353e,0x2d84bc6a,0x32000004}},	//   _nízk, _इकाई_, tame_, _oliy_, 
   {{0x6458bc6b,0x63be3c6c,0x433b0273,0xc1ca0bf5}},	//   _sivi, lepn, _זעלב, ियोग, 
   {{0xdb1c3c6d,0x76598324,0x79863c6e,0x61ed3c6f}},	//   _barç, _diwy, dakw, _roal, 
   {{0xdee68605,0xa01b08b4,0x61ed17bc,0x764d3c70}},	//   _пози, rsök, _soal, zmay, 
   {{0x6458922b,0x629e001a,0x798606b5,0x59dd001b}},	//   _vivi, nupo, fakw, यालर, 
   {{0x2d82029f,0xdb1a8019,0x6288bc71,0xdcc8801c}},	//   _neke_, neté, rsdo, _tỉ_, 
   {{0xa3c23c72,0x66040d3a,0x61ed0573,0xed598533}},	//   ्या_, dhik, _voal, teže_, 
   {{0x2bd7823b,0xa91dbc73,0xdb1c3c74,0xd499804a}},	//   _भोपा, _idžt, _garç, _ірі_, 
   {{0x764d0960,0x79862714,0x2d8202a6,0xed59959b}},	//   tmay, bakw, _beke_, reže_, 
   {{0xbddb02c0,0xe9ff801c,0x7bdc01ed,0x7bcabc75}},	//   _thèm, _phận_, _anru, _hafu, 
   {{0xdbf98066,0x76aa8816,0x4c942a04,0x764d3c76}},	// [25b0] _głów, _dəyi, литс, rmay, 
   {{0xb60381ac,0x7bca8800,0xb60685c3,0xdd868063}},	//   čšin, _jafu, lešć, _ھو_, 
   {{0x7bca8cf9,0x24893c77,0x764d0a05,0xb05b0341}},	//   _mafu, ssam_, pmay, sväs, 
   {{0x66043759,0x38a9bc78,0xe9ff8106,0x7bcabc79}},	//   chik, túr_, _thận_, _lafu, 
   {{0x8fa59a91,0x69cbbc7a,0x28f887c5,0x491180c9}},	//   вале, rdge, нець_, _देशो_, 
   {{0x7bca819f,0xe739bc7b,0x79862ae2,0x673a8c20}},	//   _nafu, мел_, zakw, _bytj, 
   {{0x44210064,0x38a980d8,0x2d820093,0xd00eadf5}},	//   mnh_, súr_, _yeke_, تلو_, 
   {{0x53341ac8,0xa91da4d4,0xed59a338,0x9b5804bc}},	//   _сест, _vežb, мой_, _чист_, 
   {{0xdb1c3c7c,0x6e3bbc7d,0x7bcaa679,0xf1bf00e9}},	//   _parç, rlub, _bafu, deá_, 
   {{0x75f5803e,0x79863c7e,0x6e3bbc7f,0x7bca86b0}},	//   _názv, wakw, slub, _cafu, 
   {{0xf1dd0560,0x91f581aa,0x3f878024,0x798622a2}},	//   यांन, _आवाज_, manu_, takw, 
   {{0x22490206,0xa5bb007f,0x1515bc80,0x44210097}},	//   _chak_, _sjón, _идея, hnh_, 
   {{0x2d823c81,0xd9e380b2,0x63b50677,0x2249068e}},	//   _reke_, _মতাম, _obzn, _dhak_, 
   {{0xdb1a8068,0x35a7800f,0x3dcdbc82,0x2d823c83}},	//   zeté, _गाड़, ldew_, _seke_, 
   {{0x44333c84,0x2d823c85,0x66043c86,0x7986175e}},	//   dox_, _peke_, thik, pakw, 
   {{0x6b83bc87,0x25bf82b0,0xf1bf00fe,0xdb0181ed}},	//   _heng, neul_, ceá_, rflä, 
   {{0x2cada6d9,0x6b83bc88,0x44333c89,0x7bca8557}},	// [25c0] nted_, _keng, fox_, _yafu, 
   {{0x395fb7ba,0x2d823c8a,0x66043c8b,0x0e6600b5}},	//   _agus_, _weke_, shik, _икон, 
   {{0x6b839ecb,0x395f8645,0x66040232,0x8c3d808a}},	//   _meng, _bgus_, phik, muşd, 
   {{0x629e3c8c,0x20183c8d,0xb33c8208,0x63be3abc}},	//   rupo, liri_, ngħa, sepn, 
   {{0x629e3c8e,0x2cadbc8f,0x3f878e02,0x18679afe}},	//   supo, jted_, fanu_, вачи_, 
   {{0x3f87bc90,0x6b83bc91,0xe9ff8028,0xf1e4010c}},	//   ganu_, _neng, _phản_, गाड़_, 
   {{0x1ae326db,0xcac73a97,0x2ca01130,0xa2e33c92}},	//   _корм, _игре_, luid_, _корд, 
   {{0x645c3c93,0x20183c94,0x7c3e2129,0x7bcabc95}},	//   _hiri, hiri_, llpr, _safu, 
   {{0x645c3c96,0x20183c97,0x7bcabc98,0x44383c99}},	//   _kiri, kiri_, _pafu, _kkr_, 
   {{0x6b83bc9a,0x69a50365,0x20183c9b,0x44383c9c}},	//   _ceng, _काही, jiri_, _jkr_, 
   {{0x6b839ecb,0xcfa99b23,0x25bfbc9d,0x2fde83b9}},	//   _deng, _سالم_, beul_, _intg_, 
   {{0xc3330757,0x7a38852f,0x7bcab283,0xdb150170}},	//   יות_, pítu, _wafu, _nazý, 
   {{0x6b83b9fe,0x2cad8052,0x20183c9e,0x7bcabc9f}},	//   _feng, cted_, firi_, _tafu, 
   {{0x6b83bca0,0xdb1703b8,0x660281ba,0x3eba02fa}},	//   _geng, nexã, _hlok, _bppt_, 
   {{0x6602a40a,0xbe883ca1,0x6d460109,0x44333ca2}},	//   _klok, ксте_, _azka, vox_, 
   {{0x443ebca3,0x645c3ca4,0xa91dbca5,0x60d600f8}},	//   llt_, _airi, _leža, _frym, 
   {{0x645c066c,0x20183ca6,0x73d93ca7,0x6b83bca8}},	// [25d0] _biri, biri_, ндар_, _yeng, 
   {{0x33740e19,0x32190fac,0x201827a3,0x46ac002a}},	//   игур, lisy_, ciri_, _चहचह, 
   {{0x443ebca9,0x44333caa,0x99998a54,0x3f87bcab}},	//   ilt_, rox_, екет_, vanu_, 
   {{0x443e82ae,0x645c3cac,0xa2940deb,0x92941747}},	//   hlt_, _eiri, раці, рацц, 
   {{0x69349ea1,0x3f87bcad,0xa91dbcae,0xe1348116}},	//   анцу, tanu_, _beža, анцы, 
   {{0x645c3caf,0x6602bcb0,0x13a7015e,0x765d3cb1}},	//   _giri, _alok, _جنسی_, _hisy, 
   {{0x6b83bcb2,0x7a388068,0x2be014a0,0xed59b93c}},	//   _reng, gíts, नारा, deža_, 
   {{0x20183cb3,0x3f87bcb4,0x645c31dc,0x7d09bcb5}},	//   ziri_, sanu_, _ziri, tzes, 
   {{0x6b83953c,0x629abcb6,0x765d2d35,0x893788a4}},	//   _peng, erto, _misy, _شعرا, 
   {{0x60c9bcb7,0x645c2305,0x6602836d,0x2cadbcb8}},	//   _isem, _xiri, _elok, rted_, 
   {{0x2cadbcb9,0x6602bcba,0x6b83bcbb,0x7d099074}},	//   sted_, _flok, _veng, szes, 
   {{0x6b83bcbc,0x2018037a,0x3f85bcbd,0x443ebcbe}},	//   _weng, wiri_, _helu_, alt_, 
   {{0x25e08561,0x20183cbf,0x657b90aa,0x6b88bcc0}},	//   कारी_, tiri_, mbuh, badg, 
   {{0x9d1a8273,0x5ebb00cf,0x60c9bcc1,0x765d0c2a}},	//   _אונט, _উপজে, _msem, _aisy, 
   {{0x20183cc2,0x657b829f,0x3f85bcc3,0x7bc18f03}},	//   riri_, obuh, _melu_, melu, 
   {{0x645c3cc4,0x20183cc5,0x657b8128,0xa3cc0c2e}},	//   _siri, siri_, nbuh, _शोज_, 
   {{0x271f8938,0x765d3cc6,0x248dbcc7,0x443803bf}},	// [25e0] यपुर_, _disy, nsem_, _pkr_, 
   {{0x7bc1bcc8,0x64a4004a,0x645c3cc9,0xdb15011e}},	//   nelu, лаға, _qiri, _nazó, 
   {{0x645c3cca,0x60c9bccb,0xa91d9a90,0x200789b8}},	//   _viri, _asem, _reža, dhni_, 
   {{0x7a3d1151,0x645c3ccc,0x3f8a3ccd,0x533680c6}},	//   téti, _wiri, labu_, אנען_, 
   {{0x645c3cce,0x7bc1b6a3,0x3f85bccf,0x44383cd0}},	//   _tiri, kelu, _belu_, _tkr_, 
   {{0x3f85bcd1,0x67d48ad3,0x7a3d0429,0x645c0540}},	//   _celu_, року, réti, _uiri, 
   {{0x60c9bcd2,0x7bc1bcd3,0x3f85bcd4,0x6602bcd5}},	//   _esem, delu, _delu_, _plok, 
   {{0x44278269,0x7bce3cd6,0x3f8a3cd7,0x629a80e9}},	//   _ajn_, _habu, habu_, vrto, 
   {{0xa91d86e2,0x2fde80e5,0xed598131,0x7a3881ae}},	//   _teža, _tntg_, teža_, síts, 
   {{0x7bc18461,0x443ebcd8,0x2007bcd9,0x78a2964d}},	//   gelu, ult_, chni_, muov, 
   {{0x7bce3cda,0xed598269,0xd43700c6,0x32193cdb}},	//   _mabu, reža_, רטיי_, tisy_, 
   {{0x7bce3cdc,0x5fe29820,0xd7e28076,0x25e08076}},	//   _labu, पावल, पावच, काळी_, 
   {{0x7bc1bcdd,0x78a281e9,0x765d00bf,0x69cf010d}},	//   belu, nuov, _risy, rdce, 
   {{0x7bce3cde,0xdb1abcdf,0xb8ed03fc,0xbcfb011e}},	//   _nabu, letí, _रन_, _ofér, 
   {{0x3219099a,0xa91dbce0,0xf3f90123,0x78a296e6}},	//   pisy_, _nežn, _îţi_, huov, 
   {{0xe6640482,0x7bce0786,0x55753ce1,0x2bc7002a}},	//   стро, _aabu, ргат, रजभा, 
   {{0x3f8a022d,0x261610ff,0x7bce06d0,0x69c28c05}},	// [25f0] babu_, _नगरी_, _babu, deoe, 
   {{0x59dd009b,0x5d540746,0x26e49ea4,0xa91d81ac}},	//   याकर, скут, _कपूर_, _bežn, 
   {{0x753d0066,0xdb152f9c,0x7afa8f76,0x63a500d8}},	//   _wysz, _razó, nytt, rghn, 
   {{0x3f85806a,0x2614009b,0xdb15016f,0x2d8680bc}},	//   _selu_, नोदी_, _sazó, _neoe_, 
   {{0xa3d486ce,0x7afa8d75,0x225900ac,0x00000000}},	//   हया_, hytt, írky_, --, 
   {{0xb8cd92b9,0xb4c101ff,0xa3ac01b7,0xa3c219d7}},	//   _कम_, ंबी_, _गाय_, ्यः_, 
   {{0x7bc1802d,0x2c6980e9,0x69c29d1a,0x3f85808b}},	//   velu, _súd_, beoe, _velu_, 
   {{0x7bce3ce2,0x20078004,0x6b870bbe,0x7bc1a094}},	//   _zabu, shni_, _hejg, welu, 
   {{0x81ce0a87,0xccf20273,0x3f85bce3,0xb882000d}},	//   রাম_, ַכט_, _telu_, říze, 
   {{0x3ea300f8,0x5e8781e2,0x1da781aa,0x248dbce4}},	//   kujt_, _будз, _गावत, rsem_, 
   {{0xab299018,0x200581bb,0x248db9a1,0xa72000b2}},	//   тона_, _illi_, ssem_, _ধর্ম_, 
   {{0x186a0ce3,0xdb052c06,0x7bc1bce5,0xc04903dd}},	//   ками_, behö, selu, _חז_, 
   {{0x39490066,0x3f8a3ce6,0x7d0d0c0e,0x2b158079}},	//   _czas_, tabu_, jzas, _फेरु_, 
   {{0x2bd505d9,0x7d0d2694,0x248082a5,0x661b8116}},	//   _डोला, dzas, _çima_, liuk, 
   {{0x539a8039,0x3f8a3ce7,0x7bce3ce8,0xe73a0cc5}},	//   _סיקו, rabu_, _rabu, тев_, 
   {{0x7bce3ce9,0x3f8a004f,0x75f58170,0xa91db3ad}},	//   _sabu, sabu_, _zázr, _režn, 
   {{0xd4671972,0xed5a00b0,0x64a63cea,0x91e40974}},	// [2600] иите_, тоа_, раза, _воқе, 
   {{0x7bce0004,0x4f962299,0x2d9c024a,0x25ab008b}},	//   _qabu, _триу, şve_, _eccl_, 
   {{0x4aaa2930,0xbf9b0130,0x6441bceb,0x213f8766}},	//   ткен_, _בייש, illi, _ayuh_, 
   {{0x7bce0557,0xbcfb0019,0x2005bcec,0xe8fabced}},	//   _wabu, _igén, _alli_, кле_, 
   {{0x7fe9130d,0xe7e29b00,0xb5fb011e,0x225f8385}},	//   _شریف_, पालप, _fiáb, _diuk_, 
   {{0xdb170065,0x7afa819b,0x224dbcee,0x758217aa}},	//   sexá, yytt, _ehek_, _ыңға, 
   {{0x9e06bcef,0x368793c9,0xe5c6bcf0,0x42d505cf}},	//   ичил, асын_, аспо, _літу, 
   {{0xa01b26b8,0x64418008,0x88818068,0xa2c303ff}},	//   nsör, elli, _کیون, रबर्, 
   {{0xafe6bcf1,0xdd94804a,0xa06a819b,0x07a68ed4}},	//   _коал, _ғалы, _раза_, _вазн, 
   {{0x34b70052,0xe9ff810b,0xf366a6ec,0x690883d2}},	//   ספים_, _phần_, штин, ırdı, 
   {{0xa3ab141c,0x8aa38b82,0x03d70080,0x7bd900c6}},	//   क्ट_, оряд, בוים_, אַרק, 
   {{0xf2d30273,0x9f5800fe,0x6609bcf2,0x6441bcf3}},	//   קער_, bhrú_, chek, alli, 
   {{0x1bd48574,0xc31a00cf,0xa92b004a,0xe9470a43}},	//   _голя, _তুমি_, тіне_, рхно, 
   {{0xe9ff8028,0x2005007f,0x9f4c8170,0x331780df}},	//   _thần_, óli_, _lodí_, ازید_, 
   {{0x2286bcf4,0x543980c6,0xc66809d9,0xf8ae0139}},	//   _тулг, _געװא, иште_, وکی_, 
   {{0x442a3cf5,0x7a280a05,0xe9df0065,0x443c80ca}},	//   _ajb_, nıtl, flúe_, _hkv_, 
   {{0xf36701f5,0x39490284,0x442a3cf6,0x201cbcf7}},	// [2610] атен, _uzas_, _bjb_, kivi_, 
   {{0x60cd3cf8,0x442a0bbe,0x81ce00b2,0x224d816c}},	//   _isam, _cjb_, রাণ_, _shek_, 
   {{0xb5fb011e,0xa91d8a63,0x5975a9c3,0xd1759662}},	//   _viáb, _pežo, былу, былы, 
   {{0x38691663,0xa2d7bcf9,0x644e19a4,0xdb0192fb}},	//   _kuar_, यित्, _ehbi, rflø, 
   {{0x98c7bcfa,0xe9df04e0,0x442a060b,0xe9ff801c}},	//   рсел, clúe_, _fjb_, _nhấn_, 
   {{0x38693cfb,0x25a93cfc,0x60cd083d,0x7e68868e}},	//   _muar_, lgal_, _msam, _budp, 
   {{0x3869102e,0x6609bcfd,0xa91d8183,0x22943323}},	//   _luar_, thek, _težo, _миря, 
   {{0xc485bcfe,0x25a93cff,0xf1cf810c,0x5bc7122f}},	//   блик, ngal_, _सोचन, _रघुव, 
   {{0x201c8533,0x999f826b,0xe9ff8106,0x202481c2}},	//   bivi_, _chuť_, _chấn_, ðrið_, 
   {{0x75f59053,0xf09f1872,0x6609bd00,0x2005bd01}},	//   _vázq, drà_, shek, _ulli_, 
   {{0xd7f89339,0x60cd3d02,0x6609a9f2,0x7c2200ef}},	//   _тут_, _asam, phek, éori, 
   {{0xa3de0365,0x60cd00bf,0x7bc5016c,0xe1f80229}},	//   _दोन_, _bsam, hehu, рҳи_, 
   {{0xed4ebd03,0x3ce981b2,0x7bc523ae,0xa3e803f0}},	//   _хо_, _çav_, kehu, _मचल_, 
   {{0x6d4bbd04,0x438580fe,0x18670a09,0x183580c6}},	//   _izga, _الثق, сари_, מאָל_, 
   {{0x60cd3d05,0xa3ab0d4a,0xf09f075d,0x249f9afb}},	//   _esam, क्छ_, arà_, lrum_, 
   {{0x25a93d06,0x4d663d07,0x38693d08,0x249fbd09}},	//   ggal_, скав, _fuar_, orum_, 
   {{0x61e43d0a,0x69c63d0b,0xe3ba2105,0x7a3d007f}},	// [2620] _inil, meke, лба_, rétt, 
   {{0x25a900fe,0xf1bf00fe,0x7bc53d0c,0x657f01df}},	//   agal_, nnán_, gehu, abqh, 
   {{0xa3b92f5f,0x60dbbd0d,0x7a280214,0x59dd0587}},	//   _अउर_, _arum, yıtl, याचर, 
   {{0x69c63d0e,0x61f60004,0xdb1a8813,0x7a3d3d0f}},	//   neke, _joyl, netá, létr, 
   {{0x201cbd10,0x2d803d11,0x10a3bd12,0x98a3920f}},	//   tivi_, mbie_, зичн, зиче, 
   {{0x60dba4f2,0x76441b40,0x69c63d13,0x7a3d3d14}},	//   _drum, lliy, heke, nétr, 
   {{0xfaa33d15,0x69c63d16,0x201c9429,0x443a058d}},	//   _наро, keke, rivi_, mop_, 
   {{0x44443d17,0x60dbbd18,0x5c748605,0xa3c2007a}},	//   ll_, _frum, олит, ्यक_, 
   {{0x69c63d19,0x8cdb01a2,0x60dbbd1a,0x2a6a00bf}},	//   deke, नियो, _grum, _hubb_, 
   {{0xda7a8dcd,0x44443d1b,0x443a000b,0xf09f0086}},	//   лям_, nl_, nop_, vrà_, 
   {{0x44441eca,0x61f609d6,0x76443d1c,0x69c63d1d}},	//   il_, _boyl, kliy, feke, 
   {{0x64a6b05f,0x69c63d1e,0x4444143e,0xf09f1f2e}},	//   _гада, geke, hl_, trà_, 
   {{0x443a3d1f,0x41aa108e,0x63bc084c,0x4444128f}},	//   kop_, _कारस, _obrn, kl_, 
   {{0x3e6e000d,0x44443d20,0xf09f1a99,0x6e3d00bf}},	//   _být_, jl_, rrà_, _sksb, 
   {{0xd5bb0fc8,0x69c60f05,0x7c3abd21,0x76443d22}},	//   лса_, beke, motr, fliy, 
   {{0x44440ac6,0x60cd01ba,0x7c3a80de,0x69c63168}},	//   el_, _tsam, lotr, ceke, 
   {{0x32090c46,0x6fa9809b,0x7bc53d23,0x3f8eb33b}},	// [2630] _ilay_, _घालू, tehu, kafu_, 
   {{0x44443d24,0x7b6709dd,0x7c3abd25,0x764409ec}},	//   gl_, стае, notr, aliy, 
   {{0x7c28bd26,0x76443d27,0x2ca00079,0xb9958a57}},	//   indr, bliy, arid_, قلاب, 
   {{0xddc1802d,0x7c3a80de,0x80cc00b2,0x7a2802d1}},	//   _mulţ, hotr, ামর্, yıtm, 
   {{0x44440324,0x7c3abd28,0xb05b00e9,0x443a3d29}},	//   bl_, kotr, dväz, bop_, 
   {{0x7c3abd2a,0x69c63d2b,0x63bc00db,0x249fbd2c}},	//   jotr, zeke, _gbrn, vrum_, 
   {{0x41aa0f82,0x2d8b02fa,0x1dda810c,0x32093d2d}},	//   _कालस, _kece_, _मोहत, _olay_, 
   {{0xa3e7007a,0xf1d9000f,0xd346003d,0x64451d01}},	//   भाव_, _बोलन, _بیمه_, llhi, 
   {{0x7c3abd2e,0xdb1e0123,0x60dbbd2f,0x69c63d30}},	//   fotr, cepâ, _urum, veke, 
   {{0x32093d31,0x69c63d32,0x61e43d33,0x249fbd34}},	//   _alay_, weke, _snil, rrum_, 
   {{0x69c63d35,0x2fc7bd36,0x5fae809b,0x26c101df}},	//   teke, meng_, _घातल, _npho_, 
   {{0x2d8b029f,0x2fc7bd37,0x7c2880de,0x3ea78741}},	//   _nece_, leng_, andr, munt_, 
   {{0x6e3b8024,0x660d003d,0x29042025,0x443a1134}},	//   moub, dhak, áma_, yop_, 
   {{0x2fc7bd38,0x78a60284,0xee3f00e9,0x290c00a1}},	//   neng_, rukv, _aký_, ąda_, 
   {{0x4444006d,0xdb1abd39,0x69c63d3a,0x764407de}},	//   vl_, petá, peke, tliy, 
   {{0x3d150689,0x2fc7bd3b,0xe57a22c2,0x2d8b3d3c}},	//   _नइखे_, heng_, рза_, _cece_, 
   {{0x2d8b10f3,0x76440816,0x2fc78de5,0x44443141}},	// [2640] _dece_, rliy, keng_, tl_, 
   {{0x44443d3d,0x2fc78ce9,0xeb9a2395,0xa91d83d0}},	//   ul_, jeng_, риж_, _težj, 
   {{0x443a3d3e,0x42ca0ceb,0x2fc7bd3f,0x660d0112}},	//   rop_, рген_, deng_, bhak, 
   {{0x660d3d40,0xa3d58066,0xe0dabd41,0x3a3f9243}},	//   chak, ाएँ_, иве_, _ckup_, 
   {{0x443a3d42,0x2fc7bd43,0x7e62811e,0x7c288578}},	//   pop_, feng_, _riop, yndr, 
   {{0x2bae938e,0x7e62bd44,0x2fc7bd45,0xdc3987de}},	//   ज्ञा, _siop, geng_, kçıl, 
   {{0x491a800d,0x23273d46,0xe2970e08,0x6fad000f}},	//   _मेरो_, _дори_, _мар_, _जासू, 
   {{0x16378013,0x7ae10068,0xd5b789ba,0x52750dbe}},	//   يسية_, _álta, ось_, _хуру, 
   {{0xa3d58066,0x7c3a852a,0xf6530039,0x2fc783ec}},	//   ाएं_, totr, וצה_, beng_, 
   {{0x22400019,0x3ea7817c,0x224681bb,0x60cd9c1a}},	//   _akik_, bunt_, llok_, çame, 
   {{0x7c3a852a,0x32093d47,0xdd8f9c83,0x8e728103}},	//   rotr, _play_, _ош_, _ўқиш, 
   {{0x7c3abd48,0x601000f9,0x80ac083c,0x78a28170}},	//   sotr, _jämf, _जमशे, orov, 
   {{0x7c3abd49,0xfbcf87f1,0xd2580ad0,0x2d8b3d4a}},	//   potr, رتی_, юць_, _rece_, 
   {{0x6e20bd4b,0xd83b0bee,0x39450029,0x1673004a}},	//   limb, рэм_, āls_, мқор, 
   {{0x28d1800c,0x660d3d4c,0x2246ae9e,0x65798035}},	//   _दैनि, thak, klok_, _éché, 
   {{0x2246bd4d,0xdb1c02ae,0xa5bb01c2,0x1dbc99d7}},	//   jlok_, _darü, _njót, ्जित, 
   {{0x2d8b0053,0x660d3d4e,0x31690019,0x2fc7bd4f}},	// [2650] _vece_, rhak, _igaz_, yeng_, 
   {{0x660d059d,0x6e20bd50,0xd37b0004,0xdb1c3d51}},	//   shak, himb, рча_, _naró, 
   {{0x3f9105d5,0x660d3d52,0x6e20bbbc,0xa91d8bfc}},	//   mazu_, phak, kimb, _težk, 
   {{0x3f91005d,0xdce982f0,0x2fc781ba,0x2a648dc6}},	//   lazu_, zbeđ, weng_, _cimb_, 
   {{0x2fc7bd53,0x78a2826b,0xdb1c016f,0x3f8cbd54}},	//   teng_, grov, _baró, _bedu_, 
   {{0xf7718629,0xdb1c01e0,0xa3da93d2,0x7bc88375}},	//   رات_, _caró, _ढोल_, jedu, 
   {{0x2fc7bd55,0x4421084c,0x78a281cb,0x63b405e1}},	//   reng_, mih_, arov, žený, 
   {{0xc4859174,0x3ea7bd56,0x2fc783ec,0xed59ac7f}},	//   плик, runt_, seng_, leži_, 
   {{0x629c84e0,0x2fc7bd57,0x6e298f59,0x442e8a63}},	//   áron, peng_, rneb, _bjf_, 
   {{0xa91dbd58,0x3ea7bd59,0xdc398a08,0x7bc8bd5a}},	//   _neži, punt_, tçıl, gedu, 
   {{0x7bd53d5b,0xf8a90115,0x6e20bd5c,0x661d3318}},	//   _mazu, _תש_, bimb, _omsk, 
   {{0xdeba8039,0xdb1c0034,0x06c380b2,0xdb1a819b}},	//   _למעל, _zaró, ্মদি, detä, 
   {{0x44213d5d,0x3e71bd5e,0xa5bb012b,0xa91dab66}},	//   kih_, _hát_, _ljós, _beži, 
   {{0x442102fa,0xed59b8d6,0x913a80c6,0x7bc8bd5f}},	//   jih_, ježi_, מערק, cedu, 
   {{0x26de01e0,0xa3c10f2c,0xbb428b93,0xdee337bd}},	//   íto_, ्जन_, _пешк, нори, 
   {{0x799b807b,0x3e71801c,0x386d81b0,0x8afa8309}},	//   _nduw, _mát_, _ouer_, _להצי, 
   {{0x66042f41,0x7bd53d60,0x3e71bd61,0x44213d62}},	// [2660] rkik, _bazu, _lát_, fih_, 
   {{0x66043d63,0x7bd50012,0x6e20b6b7,0x04460c07}},	//   skik, _cazu, zimb, чезн, 
   {{0x3f8c882b,0xe6460a4b,0x38b604ef,0xb5fb0019}},	//   _redu_, _неоп, lær_, _kiál, 
   {{0x23720029,0x3f8cbd64,0x7bc88122,0x38c88139}},	//   _šajā_, _sedu_, zedu, قاتی_, 
   {{0x44210271,0x69d63d65,0x38b600b9,0x2d923d66}},	//   bih_, _maye, nær_, maye_, 
   {{0x442113ea,0x2d923d67,0x25adb285,0x3e71bd68}},	//   cih_, laye_, egel_, _bát_, 
   {{0xc0598d38,0x7bc8bd69,0xdb1c0530,0x3e718106}},	//   ції_, vedu, _varó, _cát_, 
   {{0x3e71826b,0x78a2bd6a,0x25adbd6b,0x69d62e9c}},	//   _dát_, prov, ggel_, _naye, 
   {{0x6e20bd6c,0x7bd53d6d,0x7bc8bd6e,0xb4d69306}},	//   rimb, _yazu, tedu, ाटे_, 
   {{0x6e20bd6f,0x798d3086,0x2d9200bb,0x6d4600f6}},	//   simb, _seaw, haye_, _myka, 
   {{0x69d63d70,0x600b0816,0x60c43d71,0x26debd72}},	//   _baye, _nüma, _apim, _urto_, 
   {{0x69d63d73,0xa3de0ab2,0x38b60eb9,0xb05b0892}},	//   _caye, _दोस_, fær_, hwät, 
   {{0xb5fb2cbe,0x2d923d74,0x7bc8bd75,0x5c06809f}},	//   _diál, daye_, pedu, _няка, 
   {{0xdb1a8008,0xba73803d,0x545380f0,0x960503c9}},	//   tetä, بایت, _звіт, रस्ट_, 
   {{0x645a812b,0x69c081ac,0x98be00f3,0x3bbb9176}},	//   mmti, _obme, ātā_, _המוד, 
   {{0x443ebd76,0x442113d9,0x2d92029a,0x7e6600bf}},	//   lot_, wih_, gaye_, _cikp, 
   {{0x42380c2d,0xa91d803b,0x200c8103,0xed598105}},	// [2670] _מנהל_, _teži, _oldi_, teži_, 
   {{0x443ebd77,0xf0920c2d,0x442cbd78,0x69d63a83}},	//   not_, _שני_, nnd_, _zaye, 
   {{0x2d923d79,0x44213d7a,0x7bd5002d,0x386d868e}},	//   baye_, rih_, _vazu, _suer_, 
   {{0x44212e61,0xa2a483ff,0x200c8a1f,0x661d3d7b}},	//   sih_, _किन्, _aldi_, _umsk, 
   {{0xddc4107b,0x386d8077,0x89378013,0x3e718028}},	//   lmiş, _quer_, أعضا, _sát_, 
   {{0xd3668013,0x443e8029,0x442101a5,0x7c3e01e9}},	//   _له_, jot_, qih_, copr, 
   {{0x443ebd7c,0x6e2d3d7d,0x5334005a,0x29022430}},	//   dot_, onab, _зерт, zyka_, 
   {{0x6e2d02ee,0x442c95c1,0x6448b1e7,0xcfcd80b2}},	//   nnab, end_, eldi, লাইন, 
   {{0x69cbbd7e,0x62988086,0x69d63d7f,0x4c358162}},	//   mege, _avvo, _raye, дэнт, 
   {{0x443ebd80,0x69d9ac14,0x69d63d81,0x69cbb58b}},	//   got_, ldwe, _saye, lege, 
   {{0x61fbbd82,0x81d700b2,0x69d63d83,0xdb1c007f}},	//   _koul, সান_, _paye, _jarð, 
   {{0xa3c1007a,0x29020066,0x61fb8008,0x69cbbd84}},	//   ्जड_, tyka_, _joul, nege, 
   {{0x200403b8,0x51553d85,0x2d9206e4,0x6e2d011a}},	//   êmio_, етру, vaye_, dnab, 
   {{0xb8f61071,0x2d923d86,0x61fba671,0xb5fb060e}},	//   _सन_, waye_, _loul, _diám, 
   {{0xf7430782,0x7c3e0081,0x7f430008,0x2d923d87}},	//   веро, vopr, верж, taye_, 
   {{0x237801de,0x6e2d3d88,0x249900bf,0x7649bd89}},	//   _sfrj_, gnab, _bvsm_, nley, 
   {{0x7c3e3d8a,0x2d923d8b,0x69cbbd8c,0x60c43d8d}},	// [2680] topr, raye_, dege, _upim, 
   {{0x2d8f8c83,0x61e9bd8e,0xa91d8a63,0x2d923d8f}},	//   _lege_, _anel, _ježu, saye_, 
   {{0x61fbbd90,0x764996de,0x320da68f,0x6281834e}},	//   _boul, kley, _bley_, nplo, 
   {{0x61fb882f,0x69cbb285,0x6b8e0109,0x443ebd91}},	//   _coul, gege, _webg, zot_, 
   {{0x443e8004,0x64488bfa,0x442c807f,0x61fbbd92}},	//   yot_, yldi, ynd_, _doul, 
   {{0xd12f9b1d,0x6e243d93,0x443ebd94,0x656b82fb}},	//   جمه_, liib, xot_, _aggh, 
   {{0x443e86f4,0xdb1c007f,0x61fb9ec9,0x2d8fbd95}},	//   vot_, _garð, _foul, _bege_, 
   {{0xd49a90da,0xceb30052,0x3ea0801b,0x442cbd96}},	//   оро_, דיה_, čit_, wnd_, 
   {{0x7d0402ee,0x64a383b8,0x2d8fbd97,0x442cbd98}},	//   nyis, вања, _dege_, tnd_, 
   {{0x442c8052,0xed598677,0x61fb92f3,0x9f5a09b8}},	//   und_, ježu_, _zoul, _copë_, 
   {{0x443ebd99,0xa3c10056,0x442caef8,0x61fbbd9a}},	//   rot_, ्जत_, rnd_, _youl, 
   {{0x20ca0562,0x7d040008,0x2d998149,0x84ea89ef}},	//   िबंध, kyis, óset_, _وفاق_, 
   {{0xb4bd194e,0x6e243d9b,0x9cb380d8,0xdb1e25cc}},	//   _आहे_, diib, _لمنت, lepä, 
   {{0xa29483ba,0xdb1e02fd,0x443e8103,0x2d8f96ff}},	//   _закі, cepç, qot_, _zege_, 
   {{0x80d5800f,0x69cbbd9c,0x683f01d2,0xc5fb0077}},	//   _मैने, yege, vádě, оѓа_, 
   {{0xddc40085,0xc3338039,0x7640bd9d,0x7bd8bd9e}},	//   rmiş, _שוק_, nomy, _havu, 
   {{0x61fbbd9f,0x69cbbda0,0x5455010a,0x7bd8bda1}},	// [2690] _roul, vege, еват, _kavu, 
   {{0x69cbbda2,0x61e9bda3,0x61fbbda4,0x2a69022a}},	//   wege, _snel, _soul, _hiab_, 
   {{0x69cbbda5,0x61fbbda6,0x2a69006c,0x7bd88889}},	//   tege, _poul, _kiab_, _mavu, 
   {{0xdb1c007f,0x764080a1,0xe4a70123,0xd9f9af9e}},	//   _varð, jomy, _орго, янец_, 
   {{0x61fb82c0,0xf1c1054d,0x69d9800b,0x7d1600a1}},	//   _voul, ष्यन, rdwe, czys, 
   {{0x61fbbda7,0x2a6901c8,0x78ab8d55,0x7bd8af68}},	//   _woul, _liab_, rugv, _navu, 
   {{0x61fbbda8,0x7649bda9,0x69cbb1f1,0x2007bdaa}},	//   _toul, tley, pege, rkni_, 
   {{0xb8d580cf,0x61e9bccb,0x2a69022a,0x6ec2002a}},	//   _জন_, _unel, _niab_, _लहसु, 
   {{0x3e753dab,0xdd91811d,0x7bd89c0a,0x3949022a}},	//   _låt_, نوں_, _bavu, _nyas_, 
   {{0x3707a385,0x7649bdac,0xaf0789c5,0x6281b83e}},	//   _очев, sley, _очек, tplo, 
   {{0x3e750172,0x76499460,0x7bd8bdad,0xdbcc94d7}},	//   _nåt_, pley, _davu, róðu, 
   {{0x2a69022a,0x7afc8172,0xb5fb0063,0x13d805a2}},	//   _ciab_, ärta, _diák, সায়, 
   {{0xa3c10561,0x7bd88519,0xed598131,0x2a69017c}},	//   ्जा_, _favu, težu_, _diab_, 
   {{0x7bd8bdae,0x66099eeb,0x39490128,0x3d188034}},	//   _gavu, lkek, _dyas_, _बेटे_, 
   {{0x20c3005a,0x6441bdaf,0x7bc394c7,0x6e2402ee}},	//   _ұйым, moli, _ibnu, tiib, 
   {{0x7d04036d,0xee3a00f0,0x6441bdb0,0x7bd88655}},	//   tyis, їна_, loli, _zavu, 
   {{0xdca31787,0x44259b0d,0x7bd8829a,0x64a33db1}},	// [26a0] лати, oil_, _yavu, лата, 
   {{0x7d160d99,0xa3e70758,0x4425bdb2,0x68e43db3}},	//   rzys, भाग_, nil_, _irid, 
   {{0xa3b78365,0x387fbdb4,0xad9b3db5,0x68e417a2}},	//   _छान_, _atur_, _clús, _hrid, 
   {{0x44259950,0xa2d51ede,0x68e43db6,0x2a69027e}},	//   hil_, णिज्, _krid, _xiab_, 
   {{0x4425bdb7,0x6441bb2c,0x394901df,0xc0e395c2}},	//   kil_, koli, _xyas_, лоцк, 
   {{0x4425890b,0x2ab88068,0xe8d9001c,0x6441882b}},	//   jil_, yéb_, _ngờ_, joli, 
   {{0x6441bdb8,0x69c43db9,0x0cd0150f,0xa3e713d3}},	//   doli, _obie, _हनुम, _ядра_, 
   {{0x6ed3808c,0x7bd8bdba,0x68e40269,0xe7e080da}},	//   _xəbə, _savu, _orid, _गोरा_, 
   {{0x6441bdbb,0xddde00f3,0xf8d495ad,0x2a6903df}},	//   foli, _atpū, _धनिय, _riab_, 
   {{0x69c43dbc,0x64418324,0x2a691123,0x600b0085}},	//   _abie, goli, _siab_, _cüml, 
   {{0xa3b6801b,0x2a6901df,0xdb1c091e,0x625880d8}},	//   ङ्ग_, _piab_, _obrí, ríof, 
   {{0xdc128180,0xc3330039,0x44258caf,0x7bd8b595}},	//   rşıl, טות_, ail_, _wavu, 
   {{0x6e22bdbd,0x68e43dbe,0xf2c3805a,0x3d1895ad}},	//   _imob, _crid, _ұсын, _बेचे_, 
   {{0x4425bdbf,0x20d60f6b,0x6ed38816,0x6441bdc0}},	//   cil_, džić_, _səbə, coli, 
   {{0x9f34005a,0x68e43dc1,0x2a69027e,0x80c400b2}},	//   гері, _erid, _tiab_, শিষ্, 
   {{0x45d407c5,0x68e43dc2,0xe7e7802a,0x44d2034e}},	//   лосс, _frid, _टोना_, _bņ_, 
   {{0x61ed3dc3,0x629aa2cc,0x629c0816,0x68e40676}},	// [26b0] _inal, lsto, _avro, _grid, 
   {{0x69cf017e,0x69c422e1,0x600b03f7,0xdb01bdc4}},	//   lece, _zbie, _kümm, rflö, 
   {{0xd011011d,0x61ed3dc5,0xdb1a806d,0x81da80b2}},	//   _ملک_, _knal, getø, ়ান_, 
   {{0x69cf3dc6,0xdbd70912,0x629abdc7,0x7c250269}},	//   nece, _sääs, isto, sihr, 
   {{0x629c3dc8,0xdbd70413,0x4425bdc9,0xfd9602f9}},	//   _evro, _pääs, yil_, _בדרך_, 
   {{0x6355069a,0x44258816,0x44251cc7,0x764d3dca}},	//   _авгу, xil_, _öl_, llay, 
   {{0x629a803a,0x25bfbdcb,0x4425bdcc,0x61ed03ad}},	//   jsto, tful_, vil_, _onal, 
   {{0x4425bdcd,0x78a48024,0x69cf061c,0x2d890108}},	//   wil_, šiva, jece, nbae_, 
   {{0x6441875f,0x629a81ac,0x6fb200a1,0x442300bf}},	//   toli, esto, _जालं, _kmj_, 
   {{0x2367003a,0x61ed3dce,0x62853dcf,0x69db8124}},	//   žnju_, _anal, opho, _haue, 
   {{0x15b98ceb,0x764d07fa,0x4425bdd0,0x68e417a2}},	//   _жылы_, klay, ril_, _srid, 
   {{0x68e43dd1,0x4425bdd2,0xa2c40ab2,0xf2d200c6}},	//   _prid, sil_, _रहस्, בעט_, 
   {{0x4425bdd3,0x66068019,0x764d3dd4,0x22423dd5}},	//   pil_, ökke, dlay, rokk_, 
   {{0x7fd5004a,0x64a28a09,0x4425bdd6,0x68e40bbf}},	//   лісі, _таша, qil_, _vrid, 
   {{0x69cf07bc,0xa0673dd7,0x629abdd8,0x80b38353}},	//   bece, тара_, csto, उंडे, 
   {{0x64588210,0x764d0660,0x940c0816,0xf1bf033b}},	//   _zhvi, glay, ələr_, lián_, 
   {{0x2ca91527,0xdc6a0692,0xdd8f08a4,0x05660346}},	// [26c0] grad_, даад_, زول_, тван, 
   {{0x61ed0f2c,0x7bc1bdd9,0x764d321d,0x6d4b8540}},	//   _znal, nflu, alay, _myga, 
   {{0xe2970be6,0x69db81ed,0x442300ca,0x764d3dda}},	//   вах_, _baue, _dmj_, blay, 
   {{0x764d0217,0x3ced0183,0x69db9fc8,0x2ca902f4}},	//   clay, _ševe_, _caue, brad_, 
   {{0x69db99e8,0xa967b590,0xd7fa8166,0x21678aff}},	//   _daue, вица_, дуй_, вици_, 
   {{0xbcfb0068,0x442300f6,0x25daa910,0x63830cc5}},	//   _egés, _gmj_, _खोजी_, _вгра, 
   {{0x48ee8066,0x69cf07fa,0x59dd944a,0x8c3d82d2}},	//   _आपको_, yece, _नोकर, nuşu, 
   {{0x44442531,0x7bdc3ddb,0xe5c688be,0x3f983ddc}},	//   lo_, _haru, тско, haru_, 
   {{0x2603a8d4,0x7bdc2736,0x629abddd,0x6258a8b6}},	//   _años_, _karu, wsto, ríod, 
   {{0x7bdc03df,0x629a8a45,0x7bde000b,0x61ed068b}},	//   _jaru, tsto, ndpu, _snal, 
   {{0x7bdc3dde,0x44443ddf,0x6e22839d,0x60148741}},	//   _maru, io_, _tmob, _càme, 
   {{0x44443de0,0x7bdc3de1,0x3f933de2,0x7e6b8128}},	//   ho_, _laru, _sexu_, _gigp, 
   {{0x44443de3,0x3e78bde4,0x69dd3de5,0xf1bf195a}},	//   ko_, _hét_, rdse, bián_, 
   {{0x44443de6,0x3e788068,0x629a8615,0x69cf3de7}},	//   jo_, _két_, psto, sece, 
   {{0x44443de8,0x5f943de9,0xa3ac0353,0x78bd0c0c}},	//   do_, рист, _गाज_, stsv, 
   {{0x61ed3dea,0x44443deb,0x3ce6805d,0x58d50dee}},	//   _unal, eo_, _krov_, _боит, 
   {{0x7bdc3dec,0x444409ec,0x68e29527,0x764d2657}},	// [26d0] _baru, fo_, jvod, rlay, 
   {{0x600b0186,0x7bdc3ded,0x69dbbdee,0x2ca93def}},	//   _mümk, _caru, _saue, rrad_, 
   {{0x764d3df0,0xf8bf00ef,0x3e78801c,0xf367001d}},	//   play, lté_, _nét_, ттан, 
   {{0xc3338052,0x68e20029,0xb05b08af,0x6010010d}},	//   בוע_, _šodi, städ, _jämn, 
   {{0x44443df1,0xf8bf2d26,0x7bdc3df2,0x3ce6806c}},	//   bo_, nté_, _faru, _nrov_, 
   {{0x601008b4,0x7bdc3901,0xf8bf00ef,0x8c3d82d2}},	//   _lämn, _garu, ité_, nuşt, 
   {{0x8cdb0c64,0x64453df3,0x20012c66,0x3e7883df}},	//   निको, mohi, _mohi_, _cét_, 
   {{0x6445138b,0x660d3df4,0x7bdc3df5,0x60100172}},	//   lohi, nkak, _zaru, _nämn, 
   {{0xc104bdf6,0x2919872d,0x7bdc2be1,0x660d1921}},	//   _پولي, _åsa_, _yaru, ikak, 
   {{0x7bdc22db,0x6b950024,0x22490b14,0x644500de}},	//   _xaru, _jezg, _akak_, nohi, 
   {{0x3f983df7,0x7bc1bdf8,0x660d34b3,0xdd91803d}},	//   varu_, rflu, kkak, _هوا_, 
   {{0x64453df9,0x9d199311,0x6b950610,0x3f983dfa}},	//   hohi, _поет_, _lezg, waru_, 
   {{0x44443dfb,0x64a5bdfc,0x3ce68bfa,0x625880fe}},	//   yo_, _сала, _grov_, líoc, 
   {{0x44443dfd,0x3e718038,0x31568273,0x6e29bdfe}},	//   xo_, _ešte_, טירן_, lieb, 
   {{0xc05a00b6,0xdb1c0a93,0x6da620e2,0x3e78801c}},	//   дің_, _obrá, лива, _xét_, 
   {{0x44443dff,0x7bdc3e00,0x660d04f0,0x2bc606d7}},	//   wo_, _saru, gkak, र्ना, 
   {{0x7d09be01,0xf8bf02c0,0x1bea04bc,0xe45a0aff}},	// [26e0] nyes, cté_, ндаи_, ежа_, 
   {{0x78a90934,0x201300db,0x444418ef,0x6e2981ab}},	//   ševc, _glxi_, uo_, hieb, 
   {{0x7bdc08cc,0x91e6b144,0x81d700b2,0x2cbf8079}},	//   _varu, ложе, সার_, htud_, 
   {{0x44443e02,0x7bdc3e03,0x3e78be04,0xe984be05}},	//   so_, _waru, _rét_, рқан, 
   {{0x44443e06,0x859b0052,0x692693c9,0x7bdc3e07}},	//   po_, _אשכו, ымда, _taru, 
   {{0xd6da9a2b,0xa2a4809b,0x44443e08,0xa0678103}},	//   ети_, _किल्, qo_, гача_, 
   {{0x5fb2007a,0x62588013,0x7c28be09,0x645c00e9}},	//   _जाईल, ríob, vidr, _ihri, 
   {{0x3ce688b6,0xa5bd8162,0xf8bf0507,0x7c2887b2}},	//   _prov_, liųj, yté_, widr, 
   {{0x27ef800d,0x7c28be0a,0x20180b62,0x645c02d7}},	//   ální_, tidr, khri_, _khri, 
   {{0xd12f87db,0x610a80f3,0x660d1580,0x629e00ca}},	//   _عمل_, _vēlā, zkak, ospo, 
   {{0xa6868189,0x2bc62544,0xfbc60f8a,0x7c28be0b}},	//   _след, र्या, र्यम, ridr, 
   {{0x54e688f7,0xf8bf26ce,0xee3abe0c,0x9f5ebe0d}},	//   _مستق, tté_, _яне_, _noté_, 
   {{0xf8bf02c0,0x7b66805a,0x02d11115,0x645c3e0e}},	//   uté_, _өтке, _सन्न, _ohri, 
   {{0x2bc60561,0xddd00524,0xf8bf02c0,0x9f4c8050}},	//   र्मा, _češk, rté_, _andé_, 
   {{0xf8bf3e0f,0x6b7b8130,0xdce083d2,0x644500de}},	//   sté_, _ארונ, mamı, vohi, 
   {{0x66028073,0xdce083d2,0x629e3e10,0xf8bf00ef}},	//   _jook, lamı, dspo, pté_, 
   {{0x58d50bb3,0x64453e11,0x660d3e12,0x645c0089}},	// [26f0] _топт, tohi, rkak, _bhri, 
   {{0x6b9a80a6,0xbd681878,0x6602be13,0x645c3e14}},	//   natg, урсе_, _look, _chri, 
   {{0x629e3e15,0xdddc0533,0xdb1a811e,0x645c1a6e}},	//   gspo, sprš, metó, _dhri, 
   {{0xfde91352,0xb5fb0e22,0x660289ec,0x2bc618cb}},	//   _ऑफिस_, _ciát, _nook, र्बा, 
   {{0x69df3e16,0x64453e17,0x26cc813b,0x645c065e}},	//   _maqe, pohi, _apdo_, _fhri, 
   {{0x60cd3e18,0x60103e19,0x645c0336,0x3ddd80e5}},	//   _mpam, _näml, _ghri, _saww_, 
   {{0x6602be1a,0x629e008d,0xe57180fe,0x6e29be1b}},	//   _book, cspo, يطة_, tieb, 
   {{0x82378013,0x62588013,0x7aea0142,0x60cd1edf}},	//   _إرسا, ríoc, æfte, _opam, 
   {{0xf1bf003e,0x6e29be1c,0x1fa79afe,0xdd998170}},	//   riál_, rieb, _брег, raň_, 
   {{0x60dba5b1,0x2cbf8154,0x6e29be1d,0x68e98199}},	//   _isum, rtud_, sieb, _ired, 
   {{0x7996024a,0xfbd20039,0x60cd3c86,0x2cbfbe1e}},	//   _peyw, חתי_, _apam, stud_, 
   {{0x0166067a,0xaab682f4,0x998f8162,0xb345855a}},	//   икно, _अमरक, mogų_, _alçà, 
   {{0xe0d7009f,0x201800e5,0x291d8a99,0x2d8dbe1f}},	//   авя_, thri_, nzwa_, mbee_, 
   {{0xb8ee023b,0x6b9a855a,0x6d5980f6,0x6e2600bf}},	//   _रह_, catg, _izwa, _smkb, 
   {{0x44d68d99,0x69df00f8,0xd62a07ba,0x9f5e81d2}},	//   _zł_, _faqe, вове_, _poté_, 
   {{0x78a90ecf,0x0d863e20,0xed5a04b6,0x3ced0183}},	//   ševa, рлан, воб_, _ševa_, 
   {{0x8fa618dc,0x249fbe21,0x142616ed,0x629e3e22}},	// [2700] _капе, nsum_, адам, wspo, 
   {{0x389b00c6,0x2246be23,0x69c982ee,0x03a63e24}},	//   _שיינ, wook_, _abee, рижо, 
   {{0x60dba546,0xf1eb01d1,0xdef90ad0,0x69df00bf}},	//   _asum, _जोड़_, _быў_, _yaqe, 
   {{0x68e9937c,0x00e69996,0xb05b0172,0x249f80e5}},	//   _bred, ижен, ptäc, ksum_, 
   {{0x68e9b4b6,0x22469397,0x66029d1a,0x60100008}},	//   _cred, rook_, _rook, _lämm, 
   {{0xb8ce8416,0xa2e6036d,0x2cadb9fa,0x4427be25}},	//   _कि_, _когд, dred_, _nmn_, 
   {{0xe297360c,0x68e99e88,0xfaa31d8c,0x7aa3099f}},	//   _вас_, _ered, _маро, _мирз, 
   {{0x68e98088,0x2d80147e,0x28da8073,0x3e7c001b}},	//   _fred, ncie_, _मैथि, _mít_, 
   {{0x68e9be26,0x6b9a80a6,0x999901ac,0xfbc60a42}},	//   _gred, tatg, nosť_, र्थम, 
   {{0x5fb2007a,0xe3b8907f,0x60c2be27,0x66028bd4}},	//   _जागल, lnız_, mtom, _wook, 
   {{0x2d803e28,0x61e0be29,0x33770039,0x6b9a8748}},	//   kcie_, _kaml, יעים_, ratg, 
   {{0x61e2be2a,0x2bc60f21,0x6ab681d1,0x2cadbe2b}},	//   ndol, र्ता, _अमीर, bred_, 
   {{0x61e0b91d,0x3e719689,0x63bc00d7,0x6b9abe2c}},	//   _maml, _išta_, _ocrn, patg, 
   {{0x61e2836d,0x44278bd4,0x2d8000a1,0x999900e9}},	//   hdol, _gmn_, ecie_, dosť_, 
   {{0x6448be2d,0xf09f1870,0xdb1abe2e,0x07080fbe}},	//   modi, ssà_, retó, ахти_, 
   {{0x24892556,0x6b988093,0xfe7700a6,0x61e0be2f}},	//   tpam_, _hevg, лүү_, _naml, 
   {{0x60cd0c88,0x442cbe30,0x61e2811a,0x3f9c8b80}},	// [2710] _upam, oid_, ddol, kavu_, 
   {{0x6448be31,0x4ada8073,0x442cbe32,0x3f9c94a6}},	//   nodi, _बनाव, nid_, javu_, 
   {{0x2bc60795,0xb5fb3e33,0xd3783e34,0x25a6be35}},	//   र्धा, _diár, рчу_, _odol_, 
   {{0x68e9be36,0xa3e70625,0x2d8002fb,0x799d3e37}},	//   _pred, _मोर_, ccie_, nasw, 
   {{0x69bc009b,0x442cbe38,0x95080068,0x8467009f}},	//   ष्टी, kid_, _پہلے_, _въве, 
   {{0x68e9be39,0x6e2d3e3a,0xe739be3b,0xc7c7a9df}},	//   _vred, liab, лел_, рсди, 
   {{0x2486be3c,0x7d0d3e3d,0x61e0858f,0x2d993e3e}},	//   _atom_, lyas, _faml, _kese_, 
   {{0x61e08578,0x249f858f,0x68e990bd,0x625880fe}},	//   _gaml, tsum_, _tred, líon, 
   {{0xa3ab0d99,0x2d993e3f,0x7d0d3e40,0x442cbe41}},	//   _गया_, _mese_, nyas, fid_, 
   {{0x6e2d2eb2,0x249fbe42,0x2d993e43,0xf8ae803d}},	//   hiab, rsum_, _lese_, _سکه_, 
   {{0x9cf98a87,0x249fbe44,0x81da80cf,0x8c1a0039}},	//   েছেন_, ssum_, ়ার_, רותי, 
   {{0x2d993e45,0x442cbe46,0xf53f010d,0x2005be47}},	//   _nese_, aid_, _oxå_, _holi_, 
   {{0xeb8e80b5,0xddc6029f,0x44278645,0x6c8580fe}},	//   _ни_, _nikš, _tmn_, _التم, 
   {{0x999901ac,0x7d0d189c,0x6b988269,0x2005be48}},	//   vosť_, dyas, _gevg, _joli_, 
   {{0x2d993e49,0x81bf00cf,0xddc60116,0x81cd00b2}},	//   _bese_, ীয়_, _aikš, রয়_, 
   {{0x3f9c8e02,0x2d990530,0x2ca03e4a,0xdb1702fd}},	//   zavu_, _cese_, tsid_, nexõ, 
   {{0x2d993e4b,0x2aa38816,0x7fd60d6b,0x2d803e4c}},	// [2720] _dese_, lıb_, _ліні, rcie_, 
   {{0x61e0837c,0xe7e782f4,0x25e8083c,0x80ad0f21}},	//   _saml, _टोला_, _चोरी_, _जिते, 
   {{0xe80d0066,0x2ca002f4,0x2aa38816,0x2a60027e}},	//   _सकता_, ssid_, nıb_, _khib_, 
   {{0x60c2be4d,0x442cb05b,0x6e2d3e4e,0x753d8034}},	//   ttom, zid_, ciab, ższy, 
   {{0x2005be4f,0xdb1e0019,0x81da80b2,0x225f868e}},	//   _boli_, lepü, ়াল_, _dhuk_, 
   {{0x60c2be50,0x66063e51,0xf0930309,0xdb018a5e}},	//   rtom, _hokk, לנד_, ngló, 
   {{0x66061998,0x442a3e52,0x60c2bb59,0x20058913}},	//   _kokk, _imb_, stom, _doli_, 
   {{0x6b98a657,0x442cbe53,0xd5ba8ded,0x3f9a0934}},	//   _sevg, wid_, уск_, _lepu_, 
   {{0x8fa6be54,0x38cb815e,0xa3b3809b,0x2005be55}},	//   _газе, _مالی_, टलं_, _foli_, 
   {{0xb5fb010b,0x442a0265,0xdbf0801b,0x66060aa1}},	//   _khác, _jmb_, _tříd, _lokk, 
   {{0x442cbe56,0xe9f90163,0x6448be57,0x95ca80f0}},	//   rid_, анні_, rodi, _була_, 
   {{0x6448be58,0x442c8689,0x6606012b,0x661b822d}},	//   sodi, sid_, _nokk, chuk, 
   {{0xa3b8023b,0x6b98824a,0x442a039d,0x2486be59}},	//   छला_, _tevg, _omb_, _utom_, 
   {{0x3f9a3e5a,0x7d0d3e5b,0x442c808b,0xa3e7002a}},	//   _cepu_, vyas, qid_, _मों_, 
   {{0x2d993e5c,0x877b82f9,0x59c88562,0x5333be5d}},	//   _pese_, ראלי, रभार, _нешт, 
   {{0x442a1418,0x7d0d3e5e,0xb5fb00d8,0xe6671a5c}},	//   _amb_, tyas, _sháb, стго, 
   {{0x628714d7,0x2d993e5f,0x442a3e60,0x26c30bfc}},	// [2730] _stjo, _vese_, _bmb_, stjo_, 
   {{0x224b3e61,0x6e2d058f,0x68ed3e62,0x7d0d3e63}},	//   lock_, siab, _irad, ryas, 
   {{0x7d0d3e64,0x68ed0410,0x2005be65,0x625880fe}},	//   syas, _hrad, _roli_, ríon, 
   {{0x415586f1,0x09ab00cf,0x66063e66,0x3abb80c6}},	//   овес, গ্রা, _gokk, רמאנ, 
   {{0xed4689b9,0x09e300cf,0x26debcee,0x2aa3808a}},	//   _آپ_, যাপা, _asto_, zıb_, 
   {{0x2aa38816,0xa29506d5,0x68ed0010,0x186984fa}},	//   yıb_, _магі, _mrad, шали_, 
   {{0x661b8627,0xb05b0008,0x66063e67,0x2a66827e}},	//   thuk, ytän, _yokk, bmob_, 
   {{0xf2d2096e,0xc485a633,0x7bd73e68,0x99803e69}},	//   _קען_, олик, lexu, _omiš_, 
   {{0x2bc61d15,0x26de929b,0xe3b19f3b,0xe61680f0}},	//   र्वा, _esto_, ورد_, ідь_, 
   {{0x661bbe6a,0x2aa3808a,0x42c9804c,0x2a600103}},	//   shuk, tıb_, агон_, _shib_, 
   {{0x68ed0fbc,0x78a9005d,0xb05b0008,0xd7f8801c}},	//   _arad, ševl, ttän, _khăn_, 
   {{0x2a6001c8,0x2aa3808a,0xb6868019,0xdd1e80ac}},	//   _qhib_, rıb_, _بھول_, _síťo, 
   {{0x786008b4,0x03a59acf,0x7e7a893c,0xb05b3e6b}},	//   höve, _дило, _zutp, rtän, 
   {{0xb05b3e6c,0x799b9cf5,0x66063e6d,0x68ed3e6e}},	//   stän, _leuw, _sokk, _drad, 
   {{0xdee33e6f,0x66e33e70,0x442a0199,0x2a60006c}},	//   мори, мора, _rmb_, _thib_, 
   {{0x68ed3e71,0x224b1efa,0x78a41545,0xe1ff0530}},	//   _frad, cock_, _tviv, lmón_, 
   {{0xad66007b,0x64430bfc,0x3f9a3e72,0x8f7605cf}},	// [2740] زاره, čnin, _tepu_, _муні, 
   {{0x61e63e73,0xb5fb012f,0x66063e74,0x80d70034}},	//   ldkl, _phác, _wokk, यबरे, 
   {{0x61e402b7,0x59c1010e,0x86463e75,0x799b8504}},	//   _kail, ष्कर, _множ, _beuw, 
   {{0xd7f88106,0x8884804a,0x6258811e,0x3f858166}},	//   _chăn_, зғал, cíol, _aflu_, 
   {{0x25a03e76,0xe8949b78,0x6846be05,0x10a3bb51}},	//   mail_, чаль, онда, дичн, 
   {{0x4aa98560,0x76aabe77,0xacd90273,0xeeaab64c}},	//   _किंव, атив_, _פֿרי, атик_, 
   {{0xdefa80a6,0x02c309b2,0xa01b019b,0x09b205a2}},	//   рыл_, _ойро, mpöt, ট্যা, 
   {{0x78ad8025,0x25a03e78,0x6146961a,0x6b9c3e79}},	//   šava, nail_, _деба, _herg, 
   {{0x07a68188,0x625880fe,0x6b9c0079,0x7aee007e}},	//   _маан, níom, _kerg, _hrbt, 
   {{0x25a004d8,0x136a9b35,0x3eb800f8,0x6b9c3e7a}},	//   hail_, ишни_, kurt_, _jerg, 
   {{0x61e415ea,0xa5bb0077,0x25a03e7b,0x68ed3e7c}},	//   _bail, _imóv, kail_, _srad, 
   {{0x68ed01e2,0x61e43e7d,0x201a00e7,0xba2b00f0}},	//   _prad, _cail, _alpi_, ріод_, 
   {{0x25a012dc,0xcd368c72,0x660f96c1,0x61e43e7e}},	//   dail_, _براب, öcke, _dail, 
   {{0xcbd500cf,0x3eb83e7f,0x6b9c3e80,0x7c2aa493}},	//   _হচ্ছ, furt_, _nerg, _umfr, 
   {{0x09d000cf,0xdb4f80f0,0x61e41f4f,0x25a03e81}},	//   িয়া, _цю_, _fail, fail_, 
   {{0x3ead0791,0x61e43e82,0x25a00015,0x7bce01bb}},	//   čet_, _gail, gail_, _abbu, 
   {{0x6b9c3e83,0x68ed3e84,0xc05b036a,0xd37b00b5}},	// [2750] _berg, _urad, _він_, аче_, 
   {{0xa2a48ab2,0x6b9c3e85,0x7c3abe86,0x61e40109}},	//   _किञ्, _cerg, nntr, _zail, 
   {{0x926bbe20,0x23c2800f,0x25a00013,0x6b9c3e87}},	//   арда_, _शानद, bail_, _derg, 
   {{0x25a00094,0x7c3abe88,0x9259819b,0x6b9c0f89}},	//   cail_, hntr, щает_, _eerg, 
   {{0x6b9c3e89,0xc5fa0039,0x6d5d1e5d,0xd9458cbf}},	//   _ferg, _הפרט, _uzsa, џели, 
   {{0x3abb040c,0x6b9c385e,0xa6958251,0x66e58103}},	//   _پاسخ_, _gerg, приј, зока, 
   {{0xa195836a,0x199589dd,0x9f4103df,0x7e628a4c}},	//   _навч, _навя, _bahé_, _bhop, 
   {{0x7c3ab78b,0x6b9c0109,0xd6ce80fe,0xbcfb3e8a}},	//   entr, _zerg, اقي_, _izéb, 
   {{0x69d9be8b,0x6d4301ed,0x6b9c03ad,0x81198675}},	//   mewe, ßnah, _yerg, _ужас_, 
   {{0x69d9be8c,0x4b2588cf,0x9422be8d,0x3e718269}},	//   lewe, змов, емье, _tšto_, 
   {{0x81e500cf,0xef2000a1,0xb05b010d,0x32091659}},	//   নান_, ążki_, rtäl, _boay_, 
   {{0xb05b08b4,0x7a363e8e,0x7c3abe8f,0x6eca82d1}},	//   stäl, kšte, antr, _məbl, 
   {{0x25a002c0,0x59750a48,0xd175001d,0x61e60c20}},	//   vail_, дыру, дыры, rdkl, 
   {{0x61e402d7,0x2d9d8e0b,0x7c94803d,0x601d86e0}},	//   _wail, _hewe_, _آشنا, _fème, 
   {{0x61e43e90,0x81b380b2,0x4e1f810c,0x25a0125f}},	//   _tail, জ্য_, _बताई_, tail_, 
   {{0x2cb201b0,0xe7370166,0x69d9a00a,0xac862914}},	//   tryd_, чес_, jewe, згал, 
   {{0x6b9c3e91,0x69d9be92,0x5baa15c2,0x3eb83e93}},	// [2760] _perg, dewe, йкам_, surt_, 
   {{0x2d9d87b8,0xdce600f3,0x25a0115e,0x625880d8}},	//   _lewe_, _iekļ, sail_, ríom, 
   {{0x5186be94,0x6b9c1e8c,0x877b0039,0x9f970039}},	//   пула, _verg, _לאיי, _מדיה_, 
   {{0x6b9c1b06,0x69d98461,0xe8fabe95,0x63a1be96}},	//   _werg, gewe, йле_, haln, 
   {{0x6b9c3e97,0x3dc380cf,0xb5fb001c,0xc5c380b2}},	//   _terg, ্যাল, _khán, ্যাপ, 
   {{0x3013805a,0xfaa63e98,0xac0a0004,0x7e62be99}},	//   ндір, _наго, _унга_, _shop, 
   {{0xeab680b2,0x8c1b0039,0x7c2e22ed,0x69d99b9a}},	//   _জন্ম, _פולי, _imbr, bewe, 
   {{0x91e3be9a,0x66043e9b,0x44f493a1,0x2d9d8bd4}},	//   _посе, njik, дпис, _cewe_, 
   {{0x2ba683ce,0x63a18533,0x2d9d803d,0x81e500b2}},	//   jící_, faln, _dewe_, নাম_, 
   {{0xd48fbe9c,0xb05b036d,0x9f45824a,0xdee68fbe}},	//   _үр_, ttäm, _malê_, _нози, 
   {{0x81df80cf,0x31603e9d,0xe1d9036a,0xeee4803d}},	//   তার_, _aziz_, одні_, _تغذی, 
   {{0xa194109a,0xddc88265,0x0e668188,0x250b804e}},	//   наюч, _hudž, _экен, _گرمی_, 
   {{0xd6258013,0xf1a40162,0xb05b3e9e,0x3f9e80f8}},	//   _تعلي, эрэн, stäm, _ketu_, 
   {{0x7a360a5b,0x7afc96c1,0x63a1be9f,0xb5fb3ea0}},	//   všte, ärts, caln, _chán, 
   {{0x3f9ebea1,0x7bdabea2,0xddc88265,0x628aa3ae}},	//   _metu_, metu, _mudž, _utfo, 
   {{0x7bdabea3,0x3f9e9b5f,0x660400f8,0x6443007e}},	//   letu, _letu_, gjik, čnim, 
   {{0x442e840a,0x69d9bea4,0xb05b3ea5,0xb5fb2dff}},	// [2770] _kmf_, vewe, ntäk, _fhán, 
   {{0x7bdabea6,0x705500df,0x69d9bea7,0xf778837f}},	//   netu, _زنجا, wewe, _daħk_, 
   {{0x69d9824a,0x442e839f,0x34d9800d,0xd7f8801c}},	//   tewe, _mmf_, _भन्द, _chăm_, 
   {{0x7a3616ad,0x7bda9c08,0x63a1ba5f,0xf1bf3ea8}},	//   pšte, hetu, zaln, ngá_, 
   {{0xddc8bea9,0x7bdaaff9,0x37e5beaa,0x7e7e01e9}},	//   _budž, ketu, долг, _zupp, 
   {{0x69d98889,0xacfa0039,0x78ad839f,0x2d9d86a4}},	//   sewe, _והשכ, šavo, _sewe_, 
   {{0x63a18ecf,0x7bdabeab,0xb05b0008,0x4421040a}},	//   valn, detu, ttäj, mhh_, 
   {{0x601000f9,0x44333eac,0x26c787ad,0xdefb804a}},	//   _hämt, lix_, rtno_, _қыз_, 
   {{0xe8ff81b2,0x26c78bfc,0x7e699120,0x9f5e8217}},	//   _çû_, stno_, rmep, _votá_, 
   {{0x2d9d822d,0x7bdabead,0x6010010d,0x60148304}},	//   _wewe_, getu, _jämt, _nàmh, 
   {{0x387f9d0d,0x569484c7,0xfbcf0102,0x04ef85a2}},	//   _huur_, _захт, स्यम, য়নের_, 
   {{0x63a1beae,0x3f9e8010,0xdcf990ac,0x387fbeaf}},	//   saln, _zetu_, _وفات_, _kuur_, 
   {{0x7e7e0213,0x63a19fac,0x7bdab7bb,0x3f9e822d}},	//   _supp, paln, betu, _yetu_, 
   {{0x2281807f,0x387f8387,0x7e7e197e,0x2bcf0bc2}},	//   _tók_, _muur_, _pupp, स्मा, 
   {{0x59c60365,0x9f4581b2,0x8c42a45c,0x41c60034}},	//   _वापर, _salê_, _шеше, _वापस, 
   {{0x25bfbeb0,0x4433075d,0x2b0a801b,0x75240122}},	//   ngul_, eix_, ाहरु_, tziz, 
   {{0xb5fb010b,0xdca33eb1,0x64a313d3,0xc796004a}},	// [2780] _thán, кати, ката, _орны, 
   {{0x661d16a3,0xdb0181b2,0x442100e5,0x7e7e3eb2}},	//   _elsk, valê, ghh_, _tupp, 
   {{0x2bcf8dcf,0x78a98574,0x78ad8305,0x9f45816c}},	//   त्या, _avev, šavl, _dalë_, 
   {{0x4421097e,0xd3788131,0x387fbeb3,0x81e505a2}},	//   ahh_, meće_, _buur_, নাথ_, 
   {{0xd3789146,0x7bda804f,0x9f45816c,0x02da893e}},	//   leće_, yetu, _falë_, _बन्न, 
   {{0x387f8387,0xd7f8801c,0xd0108c85,0x2bcfbeb4}},	//   _duur_, _thăm_, طلب_, त्मा, 
   {{0x7bdabeb5,0x6a83064e,0xa3e72548,0xd3788934}},	//   vetu, _алса, _मोट_, neće_, 
   {{0x78a9003a,0x973c803b,0x3f9e822d,0x9f458401}},	//   ševi, _neće, _wetu_, _malè_, 
   {{0x7bdabeb6,0xe3ce8028,0x47c684c7,0x60101b36}},	//   tetu, _dựng_, _обав, _jäms, 
   {{0x69c43eb7,0xf0638162,0x7ae38129,0xa3de0056}},	//   _acie, _акуп, _bsnt, ढ़ि_, 
   {{0x0bb70052,0xd378a56a,0x2259019b,0xe2f887c5}},	//   ולים_, jeće_, зины_, чені_, 
   {{0xd378803b,0x442e9917,0xdd908830,0x261882ef}},	//   deće_, _wmf_, _صوت_, _kéom_, 
   {{0x200cbeb8,0xb4bd02f4,0xa3de010c,0xf1bf0149}},	//   _kodi_, _इमे_, ढ़ा_, rgá_, 
   {{0xd7f83eb9,0x200c86e0,0x443330a2,0xb8f729eb}},	//   мус_, _jodi_, xix_, _सह_, 
   {{0x200cbeba,0x45d5047d,0xe6dca4af,0x76878214}},	//   _modi_, новс, _मनोज, _kıya, 
   {{0x59c60611,0x645a8324,0xf1d0001c,0x601001ed}},	//   _वायर, llti, _hạng_, _sämt, 
   {{0x69dd3ebb,0x44333ebc,0x443e8c9f,0x2d580bc6}},	// [2790] mese, tix_, ont_, дить_, 
   {{0x443ea330,0x200c811a,0xc86700fe,0xdefb3186}},	//   nnt_, _nodi_, _تطبي, _дым_, 
   {{0x443ebebd,0x44333a43,0xf1d00028,0x387f8079}},	//   int_, rix_, _mạng_, _suur_, 
   {{0x443e82ae,0x442121ae,0xa29400f0,0x201e94b2}},	//   hnt_, shh_, таці, _alti_, 
   {{0x629c3ebe,0x44333ebf,0x200cbec0,0x78bd1127}},	//   _ewro, pix_, _bodi_, nusv, 
   {{0xb9079089,0x85740d6b,0x649a0052,0x200ca199}},	//   _बन_, _шлях, _מישה, _codi_, 
   {{0x7ac40dec,0x63a53ec1,0x69dd3ec2,0x200cb26f}},	//   _исте, mahn, kese, _dodi_, 
   {{0x443ebec3,0xceb42aa2,0x63a52896,0x261c00fe}},	//   ent_, דיק_, lahn, _líon_, 
   {{0x2bcf2a1a,0x9f45826b,0x61fb82b1,0x2ca91460}},	//   स्था, _malé_, _inul, nsad_, 
   {{0xd3788024,0x69c411c3,0x63a53ec4,0x443ebec5}},	//   zeće_, _scie, nahn, gnt_, 
   {{0xf1d0001c,0x61fbbec6,0x69dd30b1,0x61e9bec7}},	//   _dạng_, _knul, fese, _kael, 
   {{0x2bcf0de3,0x443ebec8,0x69dd3ec9,0x200cb69a}},	//   स्ता, ant_, gese, _zodi_, 
   {{0x973c8053,0x61e9822d,0xa1550574,0xb5fb01e0}},	//   _veće, _mael, върш, _chám, 
   {{0xfaa5a0d2,0xdb1c0013,0x63a51b52,0x201e0e5b}},	//   _зако, _scrí, jahn, óti_, 
   {{0x63a51c44,0x8c1a8039,0xd3789527,0x6010010d}},	//   dahn, _מוסי, teće_, _säms, 
   {{0x69dd3eca,0x20183ecb,0x61e9becc,0x9f45becd}},	//   cese, skri_, _nael, _valè_, 
   {{0x2edc800d,0xd3788131,0x15f2810c,0x63a53ece}},	// [27a0] _मन्त, reće_, _अफसर_, fahn, 
   {{0x61fbbecf,0x6fd387fa,0x7bc1bed0,0xaf9a0008}},	//   _anul, nıcı, nglu, _этих_, 
   {{0x3f983ed1,0x23c6024c,0x2bc61306,0x61e984e2}},	//   mbru_, र्गद, र्गा, _bael, 
   {{0x645510e2,0x2bcf824c,0xdb0181ac,0xfbcf8a64}},	//   _ekzi, त्ता, galé, त्तम, 
   {{0x63a53ed2,0x443ebed3,0x6d5982ea,0x200cbed4}},	//   bahn, ynt_, _nywa, _podi_, 
   {{0x69dd3ed5,0xb05b036d,0x7bc185c3,0x63a509fb}},	//   zese, ttäi, jglu, cahn, 
   {{0x8c433ed6,0x69dd3ed7,0xd6d78153,0x765b86c9}},	//   _сере, yese, еты_, fluy, 
   {{0x61e9803c,0x2bc28073,0x443ebed8,0xa3d2bed9}},	//   _gael, _शाहा, wnt_, ह्न_, 
   {{0x59a70066,0x69dd3eda,0x7d040065,0x290280f8}},	//   _ख़बर, vese, nxis, _çka_, 
   {{0x69dd3edb,0xe8d78039,0x443ebedc,0x3a203edd}},	//   wese, _אומר_, unt_, _alip_, 
   {{0xa1953ede,0x69dd3edf,0x600f83cd,0x61e9bee0}},	//   канч, tese, _tømr, _yael, 
   {{0xf2d30273,0x765b85da,0x3a200028,0x2bc7007a}},	//   נער_, cluy, _clip_, _लाभा, 
   {{0x6e240010,0x63a53ee1,0x09e300b2,0x7bde3ee2}},	//   dhib, yahn, যালা, kepu, 
   {{0xb05b0008,0x60100172,0x69dd3ee3,0xb803bee4}},	//   htäv, _sämr, sese, लायम_, 
   {{0x387a0269,0xc22183b4,0x63a50121,0x69dd3ee5}},	//   _dipr_, _मतलब_, vahn, pese, 
   {{0x6e242371,0x63a51b52,0x7a360ba7,0x09d580b2}},	//   ghib, wahn, pšta, _সোনা, 
   {{0xd9049692,0xa5bb011e,0xb87b01fb,0x63a53ee6}},	// [27b0] _ای_, _alóc, rvís, tahn, 
   {{0x2ca90265,0x2bd80034,0xf8bf0149,0x78ad1659}},	//   rsad_, ड़गा, mué_, _ivav, 
   {{0xa8580052,0x63a51c44,0x2ca93ee7,0x61e9bee8}},	//   _איזה_, rahn, ssad_, _pael, 
   {{0x63a53ee1,0x6e243ee9,0x92b400d8,0x798d0199}},	//   sahn, chib, احلا, _jfaw, 
   {{0x2604920a,0x60103eea,0x2ca903ad,0x9f5a034e}},	//   वानी_, _kämp, qsad_, _anpè_, 
   {{0x7bde0012,0xec350273,0xdb01a88d,0xe05780dd}},	//   cepu, _יאָר_, salé, ریات_, 
   {{0xf4c280cf,0x61e98504,0x3dc680bc,0x2a69040a}},	//   ্টোব, _tael, _bcow_, _ohab_, 
   {{0xe8d9001c,0x60103eeb,0x660f21d6,0x62880065}},	//   _ngữ_, _lämp, _jock, _édoa, 
   {{0x6fd38a05,0xe1ff0034,0x9f5a017c,0x5a449451}},	//   tıcı, lmów_, _enpè_, _сэра, 
   {{0x2a692e9e,0x660f264d,0xa93483b8,0xed5783ad}},	//   _ahab_, _lock, _сеуш, моқ_, 
   {{0x2329beec,0xab298d08,0x7bc1a225,0xbb45beed}},	//   фони_, фона_, rglu, тенк, 
   {{0x6595a326,0x8d878086,0x7aea006d,0x2a690097}},	//   _раду, _чужд, æfti, _chab_, 
   {{0xf8bf3eee,0x2a69047f,0x261c00d8,0x9f458093}},	//   gué_, _dhab_, _díol_, _xalî_, 
   {{0x2bcb8a09,0x6eca8829,0xc0e33eef,0x00000000}},	//   _худо_, _səbi, јорк, --, 
   {{0x07a33ef0,0x8fa3354b,0x317fbef1,0x6e243ef2}},	//   расн, расе, _oguz_, thib, 
   {{0x63a3bef3,0x68e28324,0x7bd501ed,0xf8bf0035}},	//   _henn, ywod, _abzu, bué_, 
   {{0x6441bef4,0x7bde3ef5,0x6e243ef6,0x6283bef7}},	// [27c0] onli, tepu, rhib, _huno, 
   {{0x7d04024a,0x62838412,0x6441bef8,0xd3788284}},	//   rxis, _kuno, nnli, leća_, 
   {{0x81e50a87,0x260480da,0x63a386bc,0xb05b036d}},	//   নার_, वामी_, _menn, ttäv, 
   {{0x63a3bef9,0x7bde0137,0x6283befa,0x644181ed}},	//   _lenn, sepu, _muno, hnli, 
   {{0xe3a78529,0x0cbc80b2,0x69c2befb,0x92cd80b2}},	//   _پر_, _অন্ত, rgoe, রিয়_, 
   {{0x09d600cf,0x63a3befc,0x64418a44,0xb05b0008}},	//   _তোমা, _nenn, jnli, stäv, 
   {{0x29008012,0x973c80d7,0x69d60aa6,0xc5eb80b2}},	//   ţia_, _beća, _obye, কানা_, 
   {{0xd3788301,0x2bcf920a,0x644196af,0x661b8318}},	//   jeća_, त्सा, enli, gkuk, 
   {{0x81e88a87,0x70dc0365,0xd3788025,0x2486030b}},	//   বাদ_, यबोल, deća_, íomh_, 
   {{0x63a3befd,0xe7c980a1,0x2bc6001b,0x6283befe}},	//   _cenn, _रायप, र्चा, _buno, 
   {{0x63a381a3,0x62838012,0x6d448038,0x0c7380fe}},	//   _denn, _cuno, _žiad, جديد, 
   {{0x68f63eff,0xf8bf00ef,0x6283a0ff,0x6441b97f}},	//   _bryd, tué_, _duno, anli, 
   {{0xc05b036a,0xac0a8f5e,0x63a3bf00,0xa3d480a6}},	//   дів_, _онда_, _fenn, _болч, 
   {{0x63a3bf01,0x660f3f02,0xd9180008,0x6e22bf03}},	//   _genn, _sock, тью_, _hlob, 
   {{0x6283bf04,0x6e228257,0x63a8a52e,0x2a69027e}},	//   _guno, _klob, madn, _thab_, 
   {{0x78ad8024,0x33778039,0xd5b81595,0x62810035}},	//   šavi, _בתוך_, ксу_, _éloi, 
   {{0x2bcf8365,0xf8bf3f05,0xfbcf81d2,0x63a382ee}},	// [27d0] त्वा, qué_, त्वम, _yenn, 
   {{0x61ed3f06,0x6e228741,0xddc43f07,0x27fe80db}},	//   _haal, _llob, rmiš, _nntn_, 
   {{0xe7ec00da,0x61ed3f08,0x660f0533,0xe29800f0}},	//   _छोटा_, _kaal, _tock, ває_, 
   {{0x61ed09ec,0x63a89396,0xc3338039,0x645e3f09}},	//   _jaal, hadn, סוף_, alpi, 
   {{0x61ed3f0a,0x25a93f0b,0x394980b0,0x66098301}},	//   _maal, maal_, ças_, vjek, 
   {{0xd378803a,0xa3d2aead,0x973c94d5,0x25a93f0c}},	//   zeća_, _हॉल_, _seća, laal_, 
   {{0x63a386bc,0x4ae40103,0x973c8215,0x7a2601c2}},	//   _renn, _кўта, _peća, _hóte, 
   {{0x61ed3f0d,0x25a913bf,0xdb0380ef,0xa3cf06df}},	//   _naal, naal_, _fenê, व्र_, 
   {{0x69cc826b,0x7e7d3f0e,0x628397b9,0xd3788284}},	//   ílež, _misp, _suno, veća_, 
   {{0x7bc53f0f,0x6283bf10,0x6609bf11,0x25a91bca}},	//   nghu, _puno, sjek, haal_, 
   {{0x63a3bf12,0xc5d5836a,0xa9a60ec3,0x61ed02ee}},	//   _venn, _біль, линд, _baal, 
   {{0xb5fb0013,0x63a3953f,0x68f60324,0x6e22bf13}},	//   _fhái, _wenn, _pryd, _glob, 
   {{0x25a93f14,0x61ed093c,0x04c880d8,0x7a26016f}},	//   daal_, _daal, _لوني_, _nóte, 
   {{0x6283bf15,0x68f601b0,0x60db8eca,0xf7788208}},	//   _tuno, _vryd, _mpum, _taħt_, 
   {{0x18671f7e,0xa3aa000f,0xb05b0005,0x61ed0214}},	//   уари_, _गजब_, kräf, _faal, 
   {{0x2bcf88bd,0xc6928273,0x61ed012c,0xfbcfbf16}},	//   त्रा, מאל_, _gaal, त्रम, 
   {{0x05663f17,0x4d660116,0xfbb783ff,0xdd8f0743}},	// [27e0] уван, укав, _आयाम, سول_, 
   {{0x69c9802d,0x309b0c2d,0x389b0115,0x61ed0371}},	//   _acee, _רשימ, _ריינ, _zaal, 
   {{0x3ce58066,0x61ed0640,0x81e880b2,0x25a93f18}},	//   _जैसे_, _yaal, বাস_, baal_, 
   {{0x69c60421,0xb05b02ae,0x63a8807e,0xebe3004a}},	//   ngke, stät, zadn, _қосп, 
   {{0xc05a81e2,0x522d00c6,0x9f45918d,0xa3cf0353}},	//   нік_, וואַ, _dalí_, _वॉक_, 
   {{0x8a06805a,0x6e229f4a,0xcaa600fe,0x3a26b00f}},	//   _өзге, _slob, _مصري, shop_, 
   {{0x44443dab,0x63a8a2e3,0x94230b9c,0xdd8482c3}},	//   mn_, vadn, _умре, қықп, 
   {{0x443a3f19,0x44443f1a,0xd49a84bc,0x201c8934}},	//   lip_, ln_, нро_, skvi_, 
   {{0x444406da,0x61ed3f1b,0x394690f3,0x2ba80673}},	//   on_, _raal, _снаг, गरपा, 
   {{0x44443f1c,0x443a0afa,0x76443f1d,0x60c2bf1e}},	//   nn_, nip_, hniy, muom, 
   {{0x44443f1f,0x26048b30,0x61ed3f20,0x25a9093c}},	//   in_, वादी_, _paal, yaal_, 
   {{0xc33307a6,0x6eca8816,0xb5fb0013,0x63a8bf21}},	//   מות_, _qəbu, _thái, sadn, 
   {{0x7e7d09f1,0x443a3f22,0xdddb8a08,0x61ed3f23}},	//   _risp, kip_, lmuş, _vaal, 
   {{0x4394bf24,0x44443f25,0x61ed3f26,0x443a06e0}},	//   _такс, jn_, _waal, jip_, 
   {{0x25a91169,0x61ed3f27,0x7c3aaa16,0x7e7d02a5}},	//   taal_, _taal, mitr, _pisp, 
   {{0x5eb980b2,0x92b38a57,0x6eca808a,0x60c2bf28}},	//   _আহমে, _احوا, _həbs, kuom, 
   {{0x61e2bf29,0x7e7d0029,0x25a903c5,0x7a2601c2}},	// [27f0] deol, _visp, raal_, _fótb, 
   {{0x7c3a8573,0xddc98214,0x857405cf,0x4735201f}},	//   nitr, kleş, слух, _внос, 
   {{0xb05b1be6,0x25a91bca,0x78bc80f3,0x7e7d3f2a}},	//   träf, paal_, _ārva, _tisp, 
   {{0x7c3a8573,0x973c9199,0x3e410116,0x09e300b2}},	//   hitr, _pećn, kėti_, যাকা, 
   {{0x44443113,0x7c3a80de,0x9f4781d2,0x26d1163b}},	//   bn_, kitr, rdní_, ltzo_, 
   {{0x660d3f2b,0x3e4101e2,0xb5fb3f2c,0x25a9807e}},	//   ljak, dėti_, _cháv, _žal_, 
   {{0xdb03bf2d,0x7c3a852a,0xdb01bf2e,0x26d1163b}},	//   _genè, ditr, talí, ntzo_, 
   {{0xed59b57a,0x645704e0,0x25a68caf,0x660d3f2f}},	//   кой_, loxi, _ceol_, njak, 
   {{0x387e8fa0,0x7c3a852a,0xac858077,0xf1bf00d8}},	//   _fitr_, fitr, јгол, thán_, 
   {{0xdb01bf30,0x2cadbf31,0x9f35805a,0x660d1610}},	//   salí, rsed_, _кезі, hjak, 
   {{0x7f849389,0x81e88a87,0x2a6d9e29,0x69cc800d}},	//   _المن, বার_, _kheb_, _हामी, 
   {{0xd5758e61,0x26c306c9,0xc86904fc,0x20010128}},	//   _куль, dujo_, _חן_, _anhi_, 
   {{0x64a59022,0xeb8ea5b2,0xdca5bf32,0x62873f33}},	//   _тала, _ми_, _тали, _lujo, 
   {{0x7c3abf34,0x7c288015,0x63a7001b,0xa06a245e}},	//   citr, chdr, _nejn, тага_, 
   {{0x44440b83,0x81ab80b2,0xdee63f35,0x28b20079}},	//   vn_, _খান_, шови, _जिकि, 
   {{0xe8fa0b6f,0x44443f36,0x644f80ef,0x2249016c}},	//   _али_, wn_, écif, _gjak_, 
  
   {{0x7d1bbf37,0x628702c0,0x443a0481,0x5587055a}},	// [2800] nyus, _aujo, tip_, рбум_, 
   {{0x44443f38,0x64570065,0x26c30e7c,0x63a715c5}},	//   un_, goxi, bujo_, _cejn, 
   {{0x44443f39,0x63a701df,0x67bb0039,0x395f80ed}},	//   rn_, _dejn, _במיק, _ayus_, 
   {{0xb05b0354,0xe7d201aa,0xe984804a,0x7c3a81cb}},	//   träg, द्रप, сқан, zitr, 
   {{0x260481c7,0x61e2bf3a,0x444422f8,0xae0982f4}},	//   वासी_, reol, pn_, वानन_, 
   {{0x443a00f8,0xdca31fd0,0x25a680fe,0x61e2bf3b}},	//   qip_, _фари, _seol_, seol, 
   {{0x212093ea,0x7c3a8573,0x60c2827a,0x973c8131}},	//   ših_, vitr, suom, _većo, 
   {{0xdb03acbe,0xfe6f80a7,0xddc98214,0xdddb9321}},	//   _gené, ودي_, rleş, rmuş, 
   {{0x394d0066,0x87da8f2a,0x7c28bf3c,0x7c3a80de}},	//   żesz_, _لباس_, thdr, titr, 
   {{0x62808004,0xdb088932,0xbcfb0019,0x7ed680f0}},	//   _himo, ladé, _szék, _відч, 
   {{0x752d01dd,0x7c3a8573,0x233881e2,0x6280bf3d}},	//   zzaz, ritr, упны_, _kimo, 
   {{0x7c3abf3e,0xdb0384e0,0xdd8f8019,0xd25800f0}},	//   sitr, _xené, _قوم_, иця_, 
   {{0x0494864d,0x7c948013,0x7c3abbb3,0x62808f91}},	//   _التح, _التص, pitr, _mimo, 
   {{0x6280bf3f,0xd83b0123,0x251b8eee,0x79840640}},	//   _limo, тэм_, _בודא, _egiw, 
   {{0x6f1c0324,0xbe883f40,0xb5a72c05,0x63a7007e}},	//   gyrc, исте_, ирай, _rejn, 
   {{0x4b7b8130,0x5695005a,0x30a70e06,0x628084c0}},	//   _באוו, _қамт, _кров, _nimo, 
   {{0x73d90bb3,0xb05b0172,0x9f45826b,0x8bd913e6}},	// [2810] лдар_, träd, _malá_, лмас_, 
   {{0x6e29bf41,0x6280bf42,0x628704ce,0x68ed3f43}},	//   zheb, _aimo, _pujo, _isad, 
   {{0x19b9ac60,0x2d8280e9,0x2bd8a830,0x660293f4}},	//   гуль_, ľkej_, ब्या, _onok, 
   {{0x62870f63,0x2a6d827e,0x645c0401,0x4975972b}},	//   _vujo, _qheb_, _ekri, блес, 
   {{0x6280bf44,0x26dea8a6,0xb5fb00d8,0x8cf40116}},	//   _dimo, _apto_, _dhát, _дзяц, 
   {{0x09e300b2,0x6602bf45,0x7a263f46,0x1d160309}},	//   যাটা, _anok, _móta, _הקשר_, 
   {{0xdb0386c9,0x2a7f8766,0xdb01856c,0x31698033}},	//   _tené, _tiub_, kalá, ťaz_, 
   {{0xb8cd80cf,0xf2d204fc,0x6280bf47,0x3dc91460}},	//   _কম_, _מעל_, _gimo, ngaw_, 
   {{0x6e29bf48,0x7a2600d8,0x2bc28f21,0xbc19bf49}},	//   rheb, _nóta, _शाखा, гіні_, 
   {{0x9814807b,0x9b44011d,0x68fb8124,0x6e29b162}},	//   _وبلا, _انہو, _irud, sheb, 
   {{0x44210cf6,0xdce78186,0x68ed3f4a,0x682b0816}},	//   ikh_, ımız, _asad, _müdd, 
   {{0xdb018019,0x6eca808a,0x442102ef,0xf8bf075d}},	//   galá, _təbr, hkh_, fré_, 
   {{0x2604bf4b,0xe61a0004,0x291daa07,0xc9560008}},	//   वारी_, қда_, nywa_, стны, 
   {{0x765d0ef3,0x3cfe01d2,0xc2c880df,0xe3b892b6}},	//   _aksy, _čtv_, دبیل_, lkın_, 
   {{0xd62a0327,0x66f9810e,0xf99f01e9,0xdb0a80c0}},	//   гове_, ्मिक_, bbè_, _adfæ, 
   {{0x645c0bfa,0x442109ec,0xf8bf003e,0x0d861cf8}},	//   _skri, ekh_, bré_, слан, 
   {{0x61e63f4c,0xcc88810b,0x44383f4d,0x6280bf4e}},	// [2820] mekl, _lớn_, _pmr_, _rimo, 
   {{0x69db85cb,0x4427877e,0x61e63f4f,0x3b0a2a7e}},	//   _abue, _jln_, lekl, лезо_, 
   {{0xfc3f0188,0x6d4f118d,0x25ad8c0c,0x60c613fd}},	//   _avís_, _exca, kael_, lukm, 
   {{0x68fb8615,0x80cb00cf,0x61e63f50,0xd2598deb}},	//   _brud, িবর্, nekl, аці_, 
   {{0x25a003a1,0x6280a891,0x25ad811a,0xddcd1341}},	//   mbil_, _vimo, dael_, llaş, 
   {{0x25a03f51,0x645c2d77,0xe447bf52,0x44383f53}},	//   lbil_, _ukri, _رض_, _umr_, 
   {{0x6280bf54,0xddcd0085,0x03a30a09,0x61e60214}},	//   _timo, nlaş, _хисо, kekl, 
   {{0x61e61190,0x7e64020e,0x25a004ff,0x71c5804c}},	//   jekl, nlip, nbil_, _масҷ, 
   {{0xa9268008,0x44278f4f,0x61e63f55,0x998d8a63}},	//   _удал, _bln_, dekl, _umeš_, 
   {{0xddcd0214,0xf8bf00ef,0xb3468da7,0xe8248063}},	//   klaş, vré_, jeçõ, _بذری, 
   {{0xdb01bf56,0x5c5b00c6,0x7a2613eb,0x2bf70309}},	//   talá, רדיק, _sóta, זמין_, 
   {{0xad9b0077,0x5d868013,0x2604809b,0x5b7b03dd}},	//   _anún, _الإل, वाळी_, טריא, 
   {{0xfdf78039,0x44213f57,0x661dbe6b,0xf8bf3f58}},	//   _לצאת_, ykh_, öske, uré_, 
   {{0xa2c098cb,0x96eb0bb9,0xf8bf3f59,0x7a263f5a}},	//   _विप्, льба_, rré_, _vóta, 
   {{0x443e8ee3,0x6fda800f,0x501b8039,0x543b80c6}},	//   mit_, प्यू, נולו, _געגא, 
   {{0x645abf5b,0x7bdc3f5c,0xe8d90028,0x61e63f5d}},	//   loti, _abru, _ngủ_, cekl, 
   {{0x68ed052f,0x2bcf89de,0x84151f57,0x973c8ba7}},	// [2830] _usad, त्का, омах, _bećk, 
   {{0x44273f5e,0x645abf5f,0x3ce0800f,0x97a73f60}},	//   ón_, noti, _कहने_, _урил, 
   {{0x6448bf61,0x3a29000b,0xfa898106,0x443e83df}},	//   indi, _klap_, _lẫn_, iit_, 
   {{0x443ebf62,0xc1b71855,0x1df90008,0x7e643f63}},	//   hit_, _अयोग, _темы_, clip, 
   {{0x443ebf64,0x645abf65,0x7a360131,0x65628e0b}},	//   kit_, koti, ušti, _nyoh, 
   {{0x62988b9f,0x443ebf66,0x63aa812b,0x645abf67}},	//   _otvo, jit_, _nefn, joti, 
   {{0xa3be9379,0x443ebf68,0x645abf69,0x65628bed}},	//   ेलन_, dit_, doti, _ayoh, 
   {{0xe619bf6a,0x7a36003a,0x644882f6,0x68fbaf5d}},	//   рди_, pšti, endi, _trud, 
   {{0x442788bd,0x25adbf6b,0x645a990e,0x6448bf6c}},	//   _pln_, rael_, foti, fndi, 
   {{0x443ebf6d,0xfa89810b,0xddcd05ee,0x63aa8324}},	//   git_, _dẫn_, ylaş, _cefn, 
   {{0xcb69bf6e,0x63aa8360,0x27e7bf6f,0x6e2d3f70}},	//   ране_, _defn, menn_, khab, 
   {{0x69cbb1f5,0x27e7bf71,0x60c62d53,0x64488010}},	//   ngge, lenn_, tukm, andi, 
   {{0xe3aebf72,0x645abf73,0x61e63f74,0xa3aa2910}},	//   _об_, boti, rekl, _गजल_, 
   {{0x442cbf75,0x61e60ec9,0x645abf76,0xeb999eea}},	//   chd_, sekl, coti, _тик_, 
   {{0xa3d28066,0x26c7bf77,0x224d860b,0x61e63f78}},	//   _हॉट_, nuno_, _ojek_, pekl, 
   {{0x22b580f3,0xddcd08f1,0x27e7bf79,0x7649bf7a}},	//   māk_, rlaş, henn_, nney, 
   {{0x3ea0805d,0x7e64133a,0x22b580f3,0x81d300b2}},	// [2840] ćiti_, rlip, lāk_, _হোক_, 
   {{0x25a03f7b,0xebe30b34,0x27e78fe3,0x224d868e}},	//   sbil_, моуп, jenn_, _ajek_, 
   {{0x27e786e4,0xd24f004e,0x22b580f3,0x0aea1662}},	//   denn_, _سنی_, nāk_, рдей_, 
   {{0xe8fab08c,0x443ebf7c,0x6e2d03ec,0xddcd002d}},	//   иле_, zit_, chab, rmaţ, 
   {{0x3ead003a,0x64489384,0x645a8004,0x28f8b8ca}},	//   ćete_, yndi, yoti, сель_, 
   {{0x443ebf7d,0x224d80e5,0x64890183,0x973c8269}},	//   xit_, _ejek_, _džid, _heći, 
   {{0xdcf60085,0x26c7bf7e,0xdb03b78b,0x9f4ca3f5}},	//   mayı, guno_, _bení, _andò_, 
   {{0xdcf60186,0x443ebf7f,0x7649813b,0xdb0381d2}},	//   layı, wit_, gney, _cení, 
   {{0x443ebf80,0x62988025,0x645abf81,0xdb03801b}},	//   tit_, _stvo, toti, _dení, 
   {{0x186a8574,0xfa898028,0x47c39207,0xd378829f}},	//   _тази_, _vẫn_, _обув, leći_, 
   {{0x443e8ee3,0x2bcf136a,0x7e9180f3,0x1bfb00c6}},	//   rit_, स्टा, _tāpa, בליב, 
   {{0x2d9287fa,0x443ebf82,0xed5aa8a9,0x95c79ac8}},	//   _üye_, sit_, _кое_, _душа_, 
   {{0x443eba8c,0xda7b8052,0xb4e91989,0x51843f83}},	//   pit_, ינטר, _मने_, дура, 
   {{0x76408116,0x22b580f3,0xc05b0efb,0x443e97f3}},	//   limy, bāk_, рім_, qit_, 
   {{0x261c030b,0x60c2bf84,0x69cb8c05,0x56943f85}},	//   _níos_, hrom, ygge, даст, 
   {{0x2bdd0c2e,0x60c2803e,0xd378805d,0x27e7834e}},	//   न्ना, krom, jeći_, zenn_, 
   {{0xd378803b,0xe7870974,0x98be002d,0x6e2d3f86}},	// [2850] deći_, _муно, ătă_, rhab, 
   {{0x60c2bf87,0x6e2d3f88,0x26c7bf89,0xf3671004}},	//   drom, shab, yuno_, отен, 
   {{0x2c00007a,0xce5906b0,0x261c00d8,0x7649bf8a}},	//   राजू_, _ганц_, _cíos_, yney, 
   {{0x76498610,0x26c78ca2,0x9f4c89b2,0xcb138eee}},	//   xney, vuno_, _cadí_, ולע_, 
   {{0x260809d7,0x8cc209ca,0x22b580f3,0x22a78019}},	//   हारी_, _लियो, zāk_, zők_, 
   {{0xf8078d66,0xd3e300dd,0x261c03b9,0x26c7811a}},	//   ючен, _تقسی, _fíos_, tuno_, 
   {{0x224d8142,0xd00e80fe,0xdb03801b,0xd3788259}},	//   _tjek_, الى_, _pení, beći_, 
   {{0x925884bc,0xdb08a6e8,0x0609b1c1,0x3e6181c2}},	//   _даст_, gadí, сник_, jótt_, 
   {{0x27e7bf8b,0xe4d680fe,0xdb0386c9,0x443c8149}},	//   penn_, كويت_, _vení, _bmv_, 
   {{0x1fa786f1,0x22a78019,0x26c79460,0x870780fe}},	//   _фраг, tők_, puno_, _وبال, 
   {{0xa3dd2851,0xdb03910d,0x98b0006a,0x2bdd1306}},	//   थ्य_, _tení, đača_, न्या, 
   {{0x22b5834a,0x2c6d0f6a,0x26f9875c,0x8c95804a}},	//   rāk_, _vždy_, ्मीर_, _еркі, 
   {{0xed4e84bc,0x48fe80c1,0x787200c0,0x601d834e}},	//   _чо_, लियो_, hæve, _fèmt, 
   {{0xd3788081,0x3ce080a1,0x261c00fe,0xfe7981d2}},	//   zeći_, _कहते_, _níor_, lmů_, 
   {{0x6441bf8c,0x44ed0a93,0x973c8284,0x91cc801b}},	//   mili, _až_, _peći, _हालै, 
   {{0x261c3f30,0xe1ff02ba,0xa2c092b9,0x798988da}},	//   _ríos_, llón_, _वित्, _ngew, 
   {{0x973c803b,0x52db81aa,0x261c0013,0xd378829f}},	// [2860] _veći, _बहुस, _síos_, veći_, 
   {{0x44ed3f8d,0xb4633f8e,0x29003f8f,0x6e243f90}},	//   _dž_, екул, _iria_, skib, 
   {{0x61f63f91,0xd378805d,0xdcf60646,0x6297833b}},	//   _kayl, teći_, rayı, _éxod, 
   {{0x6441bf92,0x7aba8039,0xcc88801c,0x64892aeb}},	//   hili, מצעו, _sớm_, _džib, 
   {{0x6441bf93,0x201a3f94,0xd3788053,0x26d83f95}},	//   kili, _kopi_, reći_, ltro_, 
   {{0xd378829f,0x44259862,0x6441804f,0xb05b01ed}},	//   seći_, jkl_, jili, hrän, 
   {{0x6441bf96,0xdb089a6a,0xd3788533,0x442580f6}},	//   dili, tadí, peći_, dkl_, 
   {{0x60c2bf97,0x682b107f,0x26c50024,0xa3d9a328}},	//   prom, _müda, šlog_, ड्स_, 
   {{0xdb088507,0x628e3f98,0xbcfb3f99,0x7640bf9a}},	//   radí, _hubo, _nyél, rimy, 
   {{0x628e3f9b,0x7ae384e2,0x26ca0371,0x39498065}},	//   _kubo, _bpnt, kubo_, úase_, 
   {{0x644f83e9,0x46a386bf,0x61f60bed,0x28af000f}},	//   écia, _захв, _bayl, जीनि, 
   {{0xb05b00f9,0x7ae101ed,0x645e252e,0xdb0382fd}},	//   grän, _älte, hopi, _senã, 
   {{0x628e3f9c,0x21671339,0x2baf00a1,0x290039a1}},	//   _lubo, ятог, टरमा, _cria_, 
   {{0xb8f53f9d,0x629c3f9e,0x645e0375,0x201a043a}},	//   _हम_, _otro, jopi, _copi_, 
   {{0x629c827b,0xf1c6009b,0x628e0745,0xb05b3f9f}},	//   írod, _वाचन, _nubo, brän, 
   {{0x29003fa0,0xade280da,0x61f63fa1,0x9f4c840a}},	//   _fria_, _कॉमन_, _gayl, _madà_, 
   {{0x3209345e,0x629c3fa2,0xbcfb0068,0x91bc0039}},	// [2870] _inay_, _atro, _azér, _המחי, 
   {{0x628e33a6,0x44ed3fa3,0x69dd3fa4,0x26ca00ed}},	//   _bubo, _vž_, lfse, bubo_, 
   {{0x41d180a1,0x7e62bfa5,0x26ca01e9,0x628e0c65}},	//   _हादस, _okop, cubo_, _cubo, 
   {{0x628e003b,0x682f8142,0x69cf3fa6,0x3a26820e}},	//   _dubo, _møde, ngce, gkop_, 
   {{0x44ed3fa7,0xa3be8687,0xbcfb0019,0xd37880d7}},	//   _už_, ेला_, _ezér, meću_, 
   {{0x44250360,0x23c303e9,0x9f478f6a,0x7a3601ac}},	//   _ôl_, _déjà_, lené_, nštr, 
   {{0xe81e93d2,0x764d3fa8,0x320902d2,0x64419419}},	//   _बकरा_, onay, _onay_, vili, 
   {{0xc7448013,0x64418360,0xdb03826b,0x764d3fa9}},	//   عضوي, wili, _nená, nnay, 
   {{0x3d000ec1,0x8508805a,0xdb01bfaa,0x280881d2}},	//   रिये_, здың_, mblé, átní_, 
   {{0x61f6182b,0xe7b582e5,0x32093fab,0x628e0103}},	//   _sayl, _آماد, _anay_, _yubo, 
   {{0x61f602bc,0xb05b1cc7,0x3a2dbfac,0x1b1f00b2}},	//   _payl, trän, _klep_, _যেতে_, 
   {{0x6441bfad,0x2900009b,0x2574012b,0xd3789689}},	//   sili, _pria_, _júlí_, jeću_, 
   {{0x6441bfae,0x9f478038,0xd37881de,0x645e0010}},	//   pili, dené_, deću_, yopi, 
   {{0x3e458029,0xaac589ca,0x26d8009f,0x7e698298}},	//   rētu_, _विपक, ttro_, llep, 
   {{0x61f63faf,0x683000f9,0x18672dc2,0x2ba381a2}},	//   _tayl, _rädd, фари_, _ख्या, 
   {{0x29000741,0x764d0318,0x628e3fb0,0x26ca17a2}},	//   _tria_, gnay, _rubo, rubo_, 
   {{0x629c3fb1,0x628e003a,0x2240001a,0x2bd4810c}},	// [2880] _stro, _subo, _imik_, _दामा, 
   {{0xd7ca003d,0x764d3fb2,0x6d4480e9,0x4681004a}},	//   _بوده_, anay, _žiak, _ұқса, 
   {{0x645e3fb3,0x9f47803e,0x2bdd001b,0x63bc905c}},	//   ropi, bené_, न्धा, órni, 
   {{0x7e699929,0xfaf800f3,0x63ae3fb4,0xb1468179}},	//   jlep, _šīs_, _webn, мнел, 
   {{0x5fc985d9,0x2bc703f0,0x249d81df,0x08979b23}},	//   _राखल, _लाचा, _ntwm_, وضوع_, 
   {{0x7e62bfb5,0x628e3b93,0x0ee20bf5,0x2bdd2931}},	//   _skop, _tubo, _पहाड, न्दा, 
   {{0x44443fb6,0x629c12fb,0x61ebbfb7,0xdb830c41}},	//   mi_, _utro, begl, _агри, 
   {{0x26c0bfb8,0x2487803c,0x64891527,0x7e69bfb9}},	//   čio_, _ainm_, _užic, glep, 
   {{0xdb088659,0x752402ee,0x01d78313,0x83fc8677}},	//   dadá, nyiz, _توقع_, hođe, 
   {{0x44443fba,0x83fc8301,0x9f47bfbb,0xd3788284}},	//   ni_, kođe, zené_, zeću_, 
   {{0xcc888147,0x44443fbc,0x764d3fbd,0xd6cf806f}},	//   _mới_, ii_, ynay, _نقل_, 
   {{0x44443fbe,0xc7b8803b,0x7e628215,0x64a688fc}},	//   hi_, _dođe_, _ukop, _жада, 
   {{0x9f478a5b,0x7e60a7f2,0x69dd007f,0x69cf200a}},	//   vené_, momp, rfse, rgce, 
   {{0x61eb8066,0x7e60924b,0x656f81ed,0x601d847f}},	//   zegl, lomp, üche, _jèmp, 
   {{0x83fc803a,0x290d002d,0x2bf3809b,0x9f47bfbf}},	//   gođe, ţea_, _असतं_, tené_, 
   {{0x44443fc0,0x41e70d6b,0x7e60852a,0x5c991747}},	//   ei_, _ціка, nomp, зкая_, 
   {{0x44443fc1,0x5c750008,0x78a2aa14,0xd378829f}},	// [2890] fi_, елат, jpov, reću_, 
   {{0x78a2803e,0x83fc8053,0x9f4c026b,0x7e6082a6}},	//   dpov, bođe, ždá_, homp, 
   {{0xf1b9803b,0xb5fd84c2,0xf36704bc,0x64890116}},	//   _loše_, loše, фтан, _džia, 
   {{0x44443fc2,0x68300172,0xdb1c269b,0x7d02bfc3}},	//   ai_, _väde, _acró, _oros, 
   {{0x44443fc4,0x5d85319c,0xb5fd85c3,0x0ef780a1}},	//   bi_, _سلسل, noše, ंट्स_, 
   {{0x61eb8bfc,0x160d009b,0x661d092f,0x46f587c5}},	//   segl, हावर_, _hosk, ечит, 
   {{0x661d036d,0xa2c08bc2,0x64453fc5,0x7b643fc6}},	//   _kosk, _विष्, mihi, _атте, 
   {{0x7d02bfc7,0x64451372,0x798d0c88,0x661d0008}},	//   _bros, lihi, _ngaw, _josk, 
   {{0x7e698111,0xdfdb809f,0xb5fd8f63,0x7d0293e7}},	//   rlep, _мъж_, joše, _cros, 
   {{0xa2c09137,0xa2c40365,0x7d02bfc8,0x64453fc9}},	//   _विश्, ांच्, _dros, nihi, 
   {{0x7d02a986,0x31690996,0xdb039e2f,0x78ad3fca}},	//   _eros, _ayaz_, _menç, _awav, 
   {{0x44443092,0x83fc8025,0xb87b122b,0x64453fcb}},	//   zi_, vođe, ntíf, hihi, 
   {{0x44443fcc,0x660b8283,0xfce5836a,0x644511c5}},	//   yi_, _ingk, _чоло, kihi, 
   {{0x26c7809f,0x7af50019,0x6e29872c,0x95cc808a}},	//   orno_, _oszt, lkeb, _çərç, 
   {{0x44441129,0xdee33fcd,0x64453fce,0xbcfb0019}},	//   vi_, лори, dihi, _szép, 
   {{0x44443b18,0x26128bf5,0x83fc805d,0x9f583fcf}},	//   wi_, थायी_, rođe, ndré_, 
   {{0x61e40124,0x661d1a5e,0x660b8645,0x7af50019}},	// [28a0] _ibil, _dosk, _mngk, _aszt, 
   {{0x44442e35,0x76440640,0x64453fd0,0x799b89ec}},	//   ui_, siiy, gihi, _afuw, 
   {{0x4fd7096e,0xe7c983f0,0x7fd70273,0x660bbfd1}},	//   _אויב_, _राजप, _אויס_, _ongk, 
   {{0xcc888147,0x3ce08073,0x09c700b2,0x6ad00034}},	//   _với_, _कहले_, ষ্ঠা, _हमीर, 
   {{0x44440a3e,0x47b300cf,0x61e4022d,0x644502b7}},	//   pi_, _জাতী, _mbil, bihi, 
   {{0xcc88810b,0x660b860b,0x25dda37d,0x44441282}},	//   _tới_, _angk, क्सी_, qi_, 
   {{0x61e40025,0x78a28081,0x7e60bfd2,0xdb0a806d}},	//   _obil, spov, tomp, _udfø, 
   {{0x78a280ca,0x6fd2a8b5,0x7d09011e,0x5fd28076}},	//   ppov, _सावं, _áesc, _सावल, 
   {{0x7e60bfd3,0x5454baea,0x02e0001b,0xfd128629}},	//   romp, квит, _नहुन, اجع_, 
   {{0x660b951e,0xccf30039,0x7e60bfd4,0xf1b98a63}},	//   _engk, רכז_, somp, _voše_, 
   {{0x200cbfd5,0x6fd70079,0xaa59173e,0xdb0e20c5}},	//   _indi_, _बाबू, дину_, _bebé, 
   {{0x5ab7096e,0x7d02bb7b,0xfe7282e5,0x200c8786}},	//   עלכע_, _tros, _صدا_, _hndi_, 
   {{0x442e8c05,0x201ebfd6,0x64453fd7,0x661d3fd8}},	//   _tlf_, _koti_, yihi, _rosk, 
   {{0x61e40504,0xb5fd87ad,0xdb070063,0xf9f100b2}},	//   _ebil, roše, _lejá, টাইল_, 
   {{0x661d12b2,0xadf4823b,0xa3d9baf6,0x201ebfd9}},	//   _posk, _आसान_, _डॉट_, _moti_, 
   {{0x201ebfda,0x27fa0065,0xdb0e047f,0x78ad2e71}},	//   _loti_, _eapn_, _gebé, _twav, 
   {{0xf1bf056c,0x8bc7243c,0x76428531,0xb05b0341}},	// [28b0] nkám_, есед, _mmoy, nräk, 
   {{0x201ead48,0x69c08820,0x61e41190,0xd37b1c39}},	//   _noti_, _adme, _zbil, пче_, 
   {{0x64453fdb,0xdb03a121,0x8f350166,0xb5fd97a2}},	//   rihi, _venç, _ренц, nošc, 
   {{0x61fd3014,0x200c94da,0x61ef26dd,0x68edbfdc}},	//   ndsl, _andi_, necl, çado, 
   {{0xd366807b,0x25a93fdd,0x7e6d0cad,0xa5bb3fde}},	//   _چه_, mbal_, mlap, _flór, 
   {{0xd366807b,0x7e6d3fdf,0xdb188065,0x28980039}},	//   _نه_, llap, _adví, עדון_, 
   {{0x6c5422b4,0xe4543fe0,0xf4560080,0x8f9c00c6}},	//   _скру, _скры, _יישר_, ליגי, 
   {{0x2499a891,0x60c481e2,0x59d88353,0x200cbfe1}},	//   ísmo_, šima, _डायर, _endi_, 
   {{0x9f47bfe2,0x9f4a0741,0xdb0a83b9,0x25dd8b30}},	//   mení_, rebé_, _defí, क्षी_, 
   {{0x9f47800d,0x7e6d3fe3,0xb5fb3fe4,0x6e298072}},	//   lení_, hlap, _skál, skeb, 
   {{0x61fbbfe5,0x68300073,0xbf1581a1,0x6fdf00da}},	//   _kaul, _näda, _جواب, _पॉइं, 
   {{0x660b93bd,0x201ebfe6,0xa6968115,0x61fbbfe7}},	//   _ungk, _zoti_, _סכנה_, _jaul, 
   {{0x25a93635,0x463a8273,0x29040382,0xdb0e0093}},	//   dbal_, _קענע, íma_, _nebî, 
   {{0x61fbbfe8,0x6a78891e,0x69a23fe9,0x25dd853d}},	//   _laul, mífe, _क्री, क्री_, 
   {{0xf1b38625,0x998f8116,0x61e40890,0x6443bfea}},	//   ुणान, nigų_, _tbil, _imni, 
   {{0x61e40024,0x9f478410,0xe8d18439,0xdb038008}},	//   _ubil, jení_, _समूच, _venä, 
   {{0x9f47803e,0x0d863feb,0x44313fec,0xc7b881f7}},	// [28c0] dení_, тлан, _blz_, _lođa_, 
   {{0xe0b70fcc,0x03a60103,0x232a3fed,0x64890162}},	//   _שליט_, тижо, мози_, _džio, 
   {{0x2bd4807a,0x61fbbfee,0x3ea63fef,0xe9dabff0}},	//   _दासा, _baul, _шинг, дке_, 
   {{0x98a6bff1,0x201e8206,0x64890259,0x831a80c6}},	//   виде, _soti_, _užin, וועז, 
   {{0x201ebff2,0xdb0a81e0,0x83fc8269,0xc05a8994}},	//   _poti_, _refí, hođa, мік_, 
   {{0x03a33ff3,0x26ce816f,0xf1bf0507,0x6b9c0da7}},	//   _виро, tufo_, vkám_, _ufrg, 
   {{0x6266831c,0x0443007d,0x201ebff4,0xddcd0123}},	//   _авва, _терн, _voti_, noaş, 
   {{0x9f47800d,0x61fbbff5,0x35f4a5b2,0xd49a804c}},	//   cení_, _gaul, упир, мро_, 
   {{0x29048012,0x201e802d,0x9f498170,0xd910804e}},	//   _urma_, _toti_, čkám_, _دیش_, 
   {{0xfa8a0028,0x200cbff6,0x1e1f03f0,0xa84a80be}},	//   _mẫu_, _undi_, _यक्ष_, _غلام_, 
   {{0x83fc8131,0x61e283ec,0x61fbb8d1,0x1db23ff7}},	//   gođa, ofol, _yaul, जरात, 
   {{0x27e9861e,0xf2d30273,0x61e295c3,0x6cc68a54}},	//   đane_, סער_, nfol, _айда, 
   {{0x9f45826b,0xcc888106,0x6a78811e,0x2e37825e}},	//   _malý_, _bớt_, cífe, _בראש_, 
   {{0x9f47800d,0xdb0501c2,0x69b480da,0xf1b98a63}},	//   zení_, rahú, आरडी, _moša_, 
   {{0x7e6d3ff8,0x25a93ff9,0xf1b9805d,0x442cbffa}},	//   tlap, tbal_, _loša_, mkd_, 
   {{0x2d8f006d,0x61e2bffb,0x64438034,0xe65407c5}},	//   øge_, jfol, _zmni, авсь, 
   {{0x25a60422,0x3ea9803b,0x9f47800d,0x23b6800f}},	// [28d0] ñola_, ćati_, vení_, _आजाद, 
   {{0x61fbbffc,0x7e6d1970,0x6448bffd,0x25a93ffe}},	//   _saul, slap, nidi, sbal_, 
   {{0x61fbbfff,0x68e9809f,0x61e29614,0x9f478407}},	//   _paul, _sped, ffol, tení_, 
   {{0x26d1011e,0x6e36026b,0x61fb80e5,0xe1ff4000}},	//   muzo_, chyb, _qaul, ndó_, 
   {{0xdca680fe,0x6e2d004f,0xe0df23f5,0x660f0bbe}},	//   _دى_, mkab, ntò_, _inck, 
   {{0xb5fd80f3,0x61fbc001,0xf1b9811b,0x9f4783d5}},	//   doša, _waul, _doša_, sení_, 
   {{0x61fbc002,0x6448c003,0x3669c004,0x81cb00b2}},	//   _taul, didi, нако_, র্য_, 
   {{0x83fc803b,0x6e2d4005,0xc7b88024,0xc69400c6}},	//   vođa, nkab, _vođa_, סאפ_, 
   {{0x6448852a,0x4bd981e2,0xf1b98f07,0x41559a2c}},	//   fidi, ньня_, _goša_, _свас, 
   {{0x6448c006,0x6e95964d,0x628d0097,0x62954007}},	//   gidi, _бижу, _aiao, _kuzo, 
   {{0x2bd49e12,0x6e2d4008,0xe2861dd8,0xeab98c98}},	//   _दारा, kkab, ллои, эйн_, 
   {{0xe9df00fe,0x83fc81de,0xa0a61da8,0x62952c95}},	//   siún_, rođa, ламд, _muzo, 
   {{0x6448c009,0x7d09029f,0x628d400a,0xfd108158}},	//   bidi, _šesn, _diao, _وجه_, 
   {{0xddc4001b,0x9f430008,0xdb03aa41,0x7a26400b}},	//   dliš, kejä_, _menú, _rótu, 
   {{0x75298019,0xae17971b,0xd5b786d7,0x3ebe007f}},	//   lyez, थापन_, _इजाज, étt_, 
   {{0x661b9b52,0x6e2d044c,0xe6430e71,0x81cb00b2}},	//   njuk, gkab, бесп, র্ব_, 
   {{0x7529c001,0x753bc00c,0x62950109,0xec7a400d}},	// [28e0] nyez, nzuz, _auzo, епа_, 
   {{0x26d12066,0x63b5039f,0x661b9998,0xbc6a0743}},	//   buzo_, _cezn, hjuk, رمان_, 
   {{0x49ca974b,0xd62a400e,0x6e2d05ca,0x61e287c5}},	//   елен_, _зоне_, bkab, tfol, 
   {{0x78a42fc7,0x6448c00f,0xb05b010d,0x7afca60e}},	//   _ktiv, zidi, tsäg, ærti, 
   {{0x28f88ef2,0xad9b01ac,0xdb018170,0x627c0034}},	//   тель_, _vnút, valý, _głoś, 
   {{0x7d044010,0xdb038803,0xb8dc8079,0xb5fd80f3}},	//   mvis, _denú, _आब_, voša, 
   {{0x62950215,0x69c402fb,0xdb188170,0xa3d789af}},	//   _guzo, _odie, _odvá, िलन_, 
   {{0xb5fd8029,0xceb30039,0x64488324,0x69d609f7}},	//   toša, זיה_, widi, _भाषी, 
   {{0x2fd68013,0x81cb00cf,0x8fa69349,0x7d040088}},	//   _متاح, র্ড_, _базе, nvis, 
   {{0x69c40124,0xb5fd80f3,0x2a668318,0x9f45a62c}},	//   _adie, roša, loob_, _caló_, 
   {{0x78a40077,0xd7938013,0xe2154011,0x2f56b4da}},	//   _ativ, _المخ, амны, _стас, 
   {{0xa2cc1052,0xb5fdc012,0x6448a122,0x2a66858f}},	//   _हिन्, lošn, sidi, noob_, 
   {{0x6448c013,0xa2c09306,0x9f47803e,0xe1ff4014}},	//   pidi, _विक्, mená_, rdó_, 
   {{0x6e22aeb2,0x9f47803e,0x6282827e,0xb5fd8269}},	//   _hoob, lená_, hmoo, nošn, 
   {{0xd9048529,0xf8d1c015,0x6e22c016,0xae098023}},	//   _کی_, _सम्प, _koob, वाचन_, 
   {{0x63b54017,0xadf98bf5,0x69c0033b,0xddc4008d}},	//   _sezn, ्ययन_, ómet, tliš, 
   {{0x6e2281df,0xdb0e060e,0xd3a70da7,0xbcfb2855}},	// [28f0] _moob, _debí, греп, _nyét, 
   {{0x68ed4018,0xad9b0ed0,0x6e2d0142,0x224b4019}},	//   _ipad, _saúd, skab, lick_, 
   {{0x81cb00b2,0xe29800f0,0x7d04401a,0x09bc80b2}},	//   র্ণ_, гає_, avis, _ইউজা, 
   {{0x98a99527,0xa4d511af,0x6e22c01b,0xdb070172}},	//   šač_, _комі, _noob, _rejä, 
   {{0x212b401c,0x61ff02a1,0x90e48158,0x9f478a5b}},	//   nych_, _maql, مسون, dená_, 
   {{0x63ba9199,0x4394401d,0x2ca9003d,0x41268008}},	//   jatn, _гарс, mpad_, рошо_, 
   {{0x6e22c01e,0xac58004c,0x59c5009b,0xc7d80080}},	//   _boob, _сарф_, वणार, אווי_, 
   {{0x6e22c01f,0x0609968e,0x212b01ac,0x44230502}},	//   _coob, тник_, kych_, _hoj_, 
   {{0xe616a52f,0x4423150d,0x680b8029,0x63ba8a7e}},	//   рды_, _koj_, _pēdē, fatn, 
   {{0x4423003b,0x3ce59089,0x1c45a4c2,0x212b4020}},	//   _joj_, _कहीं_, рном, dych_, 
   {{0x4423261f,0xdb1a824a,0x6e229abc,0x9f45c021}},	//   _moj_, latê, _foob, _való_, 
   {{0x442301ea,0xa2d628b3,0xfe9a8039,0x224b4022}},	//   _loj_, मंत्, _סינמ, gick_, 
   {{0x63ba8484,0xd1760ceb,0x61e9c023,0x25adc024}},	//   batn, рыны, _mbel, mbel_, 
   {{0x80cd89d7,0x7d041348,0x98a0803b,0x442301ea}},	//   _सिने, vvis, šić_, _noj_, 
   {{0x61e98945,0xc447811d,0x6fd703ff,0xbb4281b3}},	//   _obel, _لیکن_, _बारू, _мешк, 
   {{0x7c2387bc,0x35a6055a,0x7d044025,0xada609b2}},	//   _honr, рааг, tvis, раал, 
   {{0x212b0066,0xa4464026,0x1c464027,0x656f011a}},	// [2900] cych_, анад, анам, _cych, 
   {{0x629e939c,0x69db85da,0x61e9c028,0x442301ea}},	//   _époc, _acue, _abel, _coj_, 
   {{0xb87b4029,0x68fbc02a,0x25adc02b,0x2bdda074}},	//   stíc, _asud, kbel_, _माना, 
   {{0x27ed003b,0x09e6af95,0x2cbf99f1,0xcc888028}},	//   đene_, родн, ksud_, _lớp_, 
   {{0x6e22c02c,0x6282b0ee,0x9f47826b,0x6f088a5b}},	//   _roob, rmoo, vená_, _srdc, 
   {{0x3ec68008,0x6e22c02d,0x61e9c02e,0x5694c02f}},	//   асиб, _soob, _ebel, бакт, 
   {{0x63ba803a,0x212b00a1,0x9f584030,0xb87b060e}},	//   vatn, zych_, ndrà_, ntía, 
   {{0x27e98025,0x2c0a0365,0x63ba846a,0xdb1a81b2}},	//   đana_, _होतं_, watn, batê, 
   {{0x63ba89d8,0x80a68267,0x15e2809b,0x088a804a}},	//   tatn, _ضمان, क्षर_, _абай_, 
   {{0x7c23c031,0x61ff0004,0x3cf9083c,0x212b0170}},	//   _conr, _saql, _उनसे_, vych_, 
   {{0x212b0d99,0x25ad92c0,0x64890215,0xdfcf80d8}},	//   wych_, bbel_, _džih, _زين_, 
   {{0x2ca94032,0xfce68175,0xade2b3e1,0x212b0e4a}},	//   ypad_, _водо, क्शन_, tych_, 
   {{0x224b4033,0x63bac034,0xf99f0741,0x984b0086}},	//   rick_, patn, rcè_, вява_, 
   {{0x212b4020,0x656f000d,0x26c50284,0xf1a705c9}},	//   rych_, _rych, šlom_, _क्रन, 
   {{0x44234035,0xf8bf2a19,0xc058036a,0xe29780b0}},	//   _roj_, ssé_, рія_, _кај_, 
   {{0x4423027e,0xdd940c30,0x7a360162,0xdda80123}},	//   _soj_, жаты, kšty, итул_, 
   {{0x442301c8,0xdb050013,0xb5fdc036,0xd49815d8}},	// [2910] _poj_, rbhí, došl, арх_, 
   {{0x656f027b,0x61e98a11,0x44232b42,0x6298c037}},	//   _vych, _sbel, _qoj_, _kuvo, 
   {{0xd7dc023b,0xed59803b,0x44230666,0x656f00a1}},	//   _बातच, maže_, _voj_, _wych, 
   {{0xed598524,0x63b8801b,0x62988103,0x2ca9010d}},	//   laže_, _levn, _muvo, ppad_, 
   {{0x44234038,0x3ce5810c,0x20014039,0xe1ff403a}},	//   _toj_, _कहें_, _kahi_, llós_, 
   {{0x9f5801ce,0x63b880f0,0x81dd00b2,0x764d047f}},	//   ldrá_, _nevn, ড়ি_, liay, 
   {{0x26c19410,0x2001028b,0x6298c03b,0xad9b02fd}},	//   ého_, _mahi_, _nuvo, _gaúc, 
   {{0x7c23c03c,0xa2c0825d,0x9f5806b8,0x26c9806a}},	//   _sonr, _विज्, ndrá_, čao_, 
   {{0x81dd00cf,0xdd91811d,0xeb998188,0x68fb868b}},	//   ড়া_, _ہوا_, лип_, _usud, 
   {{0xc6e78d38,0x200100b4,0x7c3abf91,0x6a761a5a}},	//   _відп, _nahi_, ghtr, táfo, 
   {{0x26c5029f,0x2a7f827e,0xd6db84c7,0xe36595db}},	//   šloj_, _khub_, _шта_, скни, 
   {{0x69d9c03d,0xf59580fe,0x81cb00b2,0x8d9580fe}},	//   ngwe, _الإج, র্স_, _الإش, 
   {{0x2001403e,0xbca5803d,0x66ea82d1,0x764d05d8}},	//   _bahi_, _امتي, _təkc, diay, 
   {{0x7c3ac03f,0x07a315e5,0x8fa32326,0x22490238}},	//   chtr, зарн, заре, _emak_, 
   {{0xe7374040,0xc879024a,0xdb1c0170,0x2ca68128}},	//   бер_, îşa_, _odrá, _ztod_, 
   {{0x2a7f81df,0xb05b249b,0xf1b9c041,0xb87b161e}},	//   _nhub_, tsäc, _neš_, rtía, 
   {{0x13ea11ec,0xb87b0530,0x629881ed,0x25a00c43}},	// [2920] лмай_, stía, _zuvo, rcil_, 
   {{0x8ccf80a1,0xd37e8043,0x9f47c042,0x09b005a2}},	//   _दिनो, šćem_, cenç_, _কাটা, 
   {{0xfdf9a544,0xdb0a82ae,0xb05b4043,0xadf9800c}},	//   ्यास_, _gefä, rrät, ्यान_, 
   {{0xd5b90008,0xb05b0172,0xd186af9e,0xf1b997a2}},	//   _всё_, srät, блей, _ceš_, 
   {{0xa3d79306,0x69db00c6,0xb05b010d,0xe918c044}},	//   िला_, אַוו, prät, ролі_, 
   {{0xdca30014,0x64a30f9c,0x33d5036a,0x66044045}},	//   _хари, _хара, _міст, ldik, 
   {{0xb5fd8025,0x2ca68088,0x68e280e7,0xe8190795}},	//   pošl, _stod_, stod, दाता_, 
   {{0xb8ce8a87,0x660405ca,0x60c40131,0x91e38b29}},	//   _কি_, ndik, _ovim, _носе, 
   {{0x63b88f6a,0x6298b8cd,0x09df05a2,0x68300341}},	//   _pevn, _suvo, _বোঝা, _vädj, 
   {{0x96ba94be,0x22494046,0x443800db,0xa3ca06ce}},	//   _буду_, _smak_, _jlr_, ोलि_, 
   {{0x6e96a6f1,0xe69680fe,0x60c284fb,0x7d0b8f89}},	//   _الصا, _الصد, lsom, _ergs, 
   {{0xe7178052,0x7c3a80f8,0x80dd00cf,0xc33302f9}},	//   _לחבר_, shtr, যবস্, פור_, 
   {{0x63be2e61,0x60c2c047,0x9e6580fe,0xa3ca2ece}},	//   kapn, nsom, _بالن, ोला_, 
   {{0xf1db0108,0x60c29492,0x25de9ac2,0xdb1c006d}},	//   _भावन, isom, _गाडी_, _idræ, 
   {{0x63be1a28,0x9f47c048,0xddc98269,0x2bdd98cb}},	//   dapn, renç_, lleš, _माता, 
   {{0x66028079,0x224905c3,0x44380097,0x200102a8}},	//   _jaok, _umak_, _alr_, _wahi_, 
   {{0x5fc88aed,0x20014049,0x61ed1460,0x443800bf}},	// [2930] रणाल, _tahi_, _ibal, _blr_, 
   {{0x7bdac04a,0x60c28e87,0xb6069527,0x4438404b}},	//   ngtu, dsom, lašć, _clr_, 
   {{0x62808265,0xd37b404c,0x999980a6,0x6604404d}},	//   _bhmo, уча_, акет_, bdik, 
   {{0x62808885,0x2a7f822a,0x6602ac97,0x49758123}},	//   _chmo, _qhub_, _naok, олес, 
   {{0x61ed404e,0x4ac5007a,0x7bc3012b,0xf1b984e1}},	//   _mbal, _लटकव, ónus, _veš_, 
   {{0xc60100cf,0x9ea9920f,0x16a99525,0xbcfb00ef}},	//   _একটা_, авка_, авки_, _exéc, 
   {{0xe7399ae0,0x62358008,0x4639c04f,0x660295b0}},	//   рей_, _деву, ичия_, _baok, 
   {{0x82378f94,0xe7f580a1,0x7bda8387,0x25de809b}},	//   _ارسا, _इसका_, egtu, _गाणी_, 
   {{0x6e3b825f,0x7e6982b5,0xddc9807e,0x998d9092}},	//   rhub, roep, gleš, _fleš_, 
   {{0x61ed129c,0x7e6982fa,0x6e3b81d7,0x72c58123}},	//   _abal, soep, shub, обоз, 
   {{0x60c4003b,0xfbd204fc,0x9f5e859e,0x7c270a63}},	//   _svim, ותי_, _hatî_, _mojr, 
   {{0x3cfd9123,0x6e3b8129,0xa2cc0624,0x7c27016c}},	//   _tswv_, qhub, _हिस्, _lojr, 
   {{0xb87b1357,0x644f82c0,0x63be0645,0x9f478008}},	//   rtín, écis, yapn, senä_, 
   {{0x6e3981df,0xb5fd8463,0x61ed4050,0xdb1ac051}},	//   _hlwb, košk, _ebal, matî, 
   {{0x7d09c052,0xb5fd8053,0x81b900b2,0x96950482}},	//   lves, jošk, _চার_, зруш, 
   {{0x4427c053,0x27ed003b,0xee374054,0x78a9801b}},	//   _hon_, đena_, онс_, _otev, 
   {{0x66044055,0x4427c056,0x63be4057,0x9c260591}},	// [2940] rdik, _kon_, tapn, одад, 
   {{0x44279e87,0x2aed80ab,0xf202802a,0xf77201fa}},	//   _jon_, _जहाँ_, _रोज़_, _ياد_, 
   {{0x44278700,0xdb1501b2,0x290dc058,0x6d4086e4}},	//   _mon_, _wezî, _area_, zzma, 
   {{0x4427c059,0x290dc05a,0xe4da003d,0x60c2c05b}},	//   _lon_, _brea_, _پوست_, tsom, 
   {{0x208a8004,0x290db60e,0xa88aacf8,0xdb1ac05c}},	//   айди_, _crea_, айда_, raté, 
   {{0x4427c05d,0xb8f28f8a,0x764b8324,0x29000766}},	//   _non_, _वि_, _amgy, _msia_, 
   {{0xab2a0021,0x71a68974,0x60c2c05e,0xdb1a8385}},	//   _това_, _мавз, ssom, paté, 
   {{0x44278b3a,0x27f8405f,0x290d811e,0x69d6120d}},	//   _aon_, hern_, _frea_, _भागी, 
   {{0x4427c060,0xe4e6836a,0x629c4061,0x25eb8689}},	//   _bon_, ційн, _huro, _अउरी_, 
   {{0x4427c062,0x44e2812b,0x63bc0060,0x39420265}},	//   _con_, rð_, _jern, dzks_, 
   {{0x629c00b0,0x44278052,0x2be20bc4,0xa3e20611}},	//   _juro, _don_, _पाना, _धान_, 
   {{0x64894063,0x629c4064,0x63bc02ae,0x3c3bc065}},	//   _uživ, _muro, _lern, _rêve_, 
   {{0x4427c066,0x3204c067,0x27f84068,0xc21800f0}},	//   _fon_, _mamy_, fern_, ією_, 
   {{0x44279ae6,0x9f4c027b,0x27f83e19,0xb87b00d8}},	//   _gon_, ždý_, gern_, rtío, 
   {{0xd5bb0ce8,0x764b8324,0x629c4069,0x623538ca}},	//   иса_, _ymgy, _nuro, _неку, 
   {{0x26cd003b,0x4427c06a,0x61ed175e,0xc7b885c3}},	//   čeo_, _zon_, _ubal, _dođi_, 
   {{0x4427c06b,0x2d8f0354,0x63bc406c,0xdb03860e}},	// [2950] _yon_, äge_, _bern, _fenó, 
   {{0xf1d8a851,0xfbab406d,0x645ac06e,0x63bc406f}},	//   _डाउन, ртай_, nnti, _cern, 
   {{0x63bc4070,0xdb1c024a,0xb87b026f,0x26d84071}},	//   _dern, _herê, ntím, curo_, 
   {{0xb5fd8ecf,0x290d802d,0xf9c7836a,0x629c4072}},	//   rošk, _prea_, іщен, _duro, 
   {{0x361a04fc,0xddc880a1,0xdb18811e,0xf990902a}},	//   _הורד, łośc, _devé, نبه_, 
   {{0x63bc4073,0x290d802d,0x629c1f97,0x7bce8207}},	//   _gern, _vrea_, _furo, óbul, 
   {{0x629c4074,0xf1b98131,0x443ec075,0x9f478033}},	//   _guro, _loši_, dht_, lenú_, 
   {{0xf1bf87e9,0x4427c076,0x682f8c05,0x443e81ed}},	//   _þá_, _son_, _nødv, eht_, 
   {{0x27f84077,0x3245804a,0x7bca8065,0x9f580093}},	//   yern_, _деңг, _bdfu, gerê_, 
   {{0x443e804d,0xed59804a,0x290000db,0x44278103}},	//   ght_, _қол_, _rsia_, _qon_, 
   {{0x44278972,0xa822803d,0x63a502ae,0xdb0e01ed}},	//   _von_, _سکون, ichn, _gebä, 
   {{0x9f58024a,0x2005c078,0xeaae8bb3,0xdb038659}},	//   berê_, _hali_, _үй_, _senó, 
   {{0x2005ae3e,0x4427c079,0x27f8407a,0x443e865e}},	//   _kali_, _ton_, tern_, bht_, 
   {{0x443e8c16,0x26d8407b,0x25bd824a,0x9f5a0495}},	//   cht_, turo_, _hewl_, _papà_, 
   {{0xe7ed994e,0xe737407c,0x7bc1b312,0x63bc0d69}},	//   च्या_, пер_, malu, _rern, 
   {{0x7bc19b4e,0x2005aabd,0x63bc024a,0x629a00ef}},	//   lalu, _lali_, _sern, _étoi, 
   {{0x63bc1b52,0x29000058,0xdb18922b,0x2bca0a48}},	// [2960] _pern, _usia_, _revé, йлап_, 
   {{0x3204852a,0x224d80f6,0x26d8407d,0xe8f70db1}},	//   _samy_, _amek_, puro_, _эль_, 
   {{0xeb970c89,0x179b0115,0x6296407e,0x629c407f}},	//   чих_, _לייב, _kiyo, _quro, 
   {{0x63bc007b,0x629606a6,0x9f582da3,0xd36f1351}},	//   _wern, _jiyo, yerê_, دهم_, 
   {{0xe5720bb7,0x63bc4080,0x2005c081,0x645ac082}},	//   _سطح_, _tern, _bali_, ynti, 
   {{0x66064083,0x2005c084,0x9f582da3,0x94260188}},	//   _hakk, _cali_, verê_, _эмге, 
   {{0x2005c085,0x81d400cf,0x5f93c086,0xed59ab66}},	//   _dali_, স্য_, ништ, važa_, 
   {{0x225a8013,0x442a4087,0x9f580093,0x7e64808d}},	//   _الرد_, _hob_, terê_, čipo, 
   {{0x6d440574,0xf8bf3b34,0x66064088,0x442a4089}},	//   nzia, nyét_, _makk, _kob_, 
   {{0x20058ad0,0x7bde2cb2,0x6489408a,0x81b900b2}},	//   _gali_, ngpu, _užit, _চাই_, 
   {{0x442a408b,0x6296408c,0xddcd001b,0x62840048}},	//   _mob_, _biyo, hlaš, _bhio, 
   {{0x443e88fb,0x442a408d,0x6284408e,0x0e9b8039}},	//   sht_, _lob_, _chio, _השאל, 
   {{0x6296408f,0x58872d50,0x7bc1c090,0x9f5e80a6}},	//   _diyo, зыва, balu, _matí_, 
   {{0x6d440066,0x27ed003a,0xc9538052,0x442a4091}},	//   dzia, đeno_, תמש_, _nob_, 
   {{0x6284003c,0x7e6d0986,0x3ce681df,0x66064092}},	//   _fhio, toap, _hqov_, _bakk, 
   {{0x644e4093,0x33778052,0xf4a800cf,0x66064094}},	//   _ambi, _מתוך_, _ওয়েব, _cakk, 
   {{0x81c28a87,0x6a7d0422,0x7e6d002d,0x8d7700fe}},	// [2970] ংলা_, léfo, roap, سارا, 
   {{0x442a006c,0x62964095,0x225f818a,0x78ad2a9d}},	//   _cob_, _ziyo, _sjuk_, _itav, 
   {{0x3cf9108a,0x63a5011a,0x660628d2,0x62964096}},	//   _उनके_, rchn, _fakk, _yiyo, 
   {{0xdb0e024a,0x63a54097,0xe9df4098,0x644e02ee}},	//   _hebû, schn, ngú_, _embi, 
   {{0x20058889,0x8c3b035b,0x3ce6822a,0x9984801b}},	//   _pali_, _auße, _nqov_, _domů_, 
   {{0x7d0d4099,0x6a761355,0x66ea808a,0x7c2a834e}},	//   mvas, ráfi, _təkl, _nofr, 
   {{0x7d02c09a,0x7bc19450,0x2005c09b,0x7d0d409c}},	//   _asos, valu, _vali_, lvas, 
   {{0x2d99872c,0x442a06d8,0x78ad409d,0x7bc1c09e}},	//   øse_, _zob_, _otav, walu, 
   {{0x7bc1c09f,0xc987c0a0,0x799b8128,0xd0d48086}},	//   talu, _хуви, _iguw, _потъ, 
   {{0x62960004,0x7c2a8324,0x628440a1,0xdb0e0093}},	//   _siyo, _cofr, _shio, _nebû, 
   {{0x37e300cf,0xb05b00f9,0x7bc1c0a2,0x6fd7009b}},	//   য়ার, rsäl, ralu, _बाजू, 
   {{0x7bc1c0a3,0xc7b88053,0x63ad82a5,0x1c0a009b}},	//   salu, _dođu_, _şand, _होईल_, 
   {{0xed4e82d4,0x7bc1c0a4,0xdb1c00f8,0xdb1e0530}},	//   _ро_, palu, _perë, rapé, 
   {{0x40950873,0xb8f618fe,0x6609c0a5,0x660640a6}},	//   ерст, _हि_, ldek, _sakk, 
   {{0xdee340a7,0x62840094,0xe73a0008,0xdb1c40a8}},	//   кори, _thio, цев_, _verë, 
   {{0x442a40a9,0x644e00e5,0x6d440109,0xa3a98ab2}},	//   _sob_, _smbi, tzia, गुर_, 
   {{0x442a40aa,0x15fd0034,0x660640ab,0x6e2400db}},	// [2980] _pob_, उज़र_, _vakk, rjib, 
   {{0x6d4440ac,0x660640ad,0xe61904bc,0x6609819b}},	//   rzia, _wakk, одӣ_, hdek, 
   {{0x7d090f5f,0x660640ae,0xdb1c40af,0xf1b98131}},	//   _šest, _takk, _keré, _lošu_, 
   {{0x7df9800c,0x8c48008a,0xa2d5c0b0,0xceb304fc}},	//   ्योग_, _başç, _भिन्, _שיר_, 
   {{0x442a027e,0x81cb00b2,0x201a00db,0x10a38782}},	//   _tob_, র্ক_, _knpi_, вичн, 
   {{0x76aa9750,0x644e097e,0xeeaac05e,0x60c9807e}},	//   отив_, _umbi, отик_, _dvem, 
   {{0xe80f2851,0xd3721c98,0x6441896b,0xdb1a89e6}},	//   ायता_, _شهر_, dhli, tatí, 
   {{0x60c90533,0x7c2ac0b1,0x81d400b2,0x291202ef}},	//   šemi, _sofr, স্ত_, _orya_, 
   {{0x998d826b,0xdb1ac0b2,0x69c080f3,0xab5c80f3}},	//   _pleť_, ratí, _ieme, daļa, 
   {{0x69c0c0b3,0x2904b584,0x682f8255,0x61e41b3a}},	//   _heme, _isma_, _døds, _acil, 
   {{0x69c0c0b4,0xda1a0562,0x291221ae,0xdb1a8530}},	//   _keme, धांत_, _arya_, patí, 
   {{0x69c0c0b5,0x51873fef,0x78a09fb4,0x682f8255}},	//   _jeme, дуга, _kumv, _føds, 
   {{0x69c09b52,0x3946c0b6,0xf8ae015e,0x656f81ed}},	//   _meme, nzos_, یکی_, ücht, 
   {{0x6441c0b7,0xdb0e40b8,0x69c0c0b9,0x59db0076}},	//   chli, _qebû, _leme, _भाकर, 
   {{0xfe730604,0x76410116,0x7793003d,0x32670086}},	//   ندر_, ūlym, ضیحا, _отив, 
   {{0x27e98025,0x69c0c0ba,0xdb15026b,0xe508801c}},	//   đani_, _neme, _nezá, _kỷ_, 
   {{0xa2da8baf,0x3d11807a,0x61fd40bb,0xddc40d33}},	// [2990] पूर्, तिये_, mesl, bliž, 
   {{0x69c0891e,0x320900ed,0x660982d2,0x4ea702c3}},	//   _aeme, _haay_, zdek, _орма, 
   {{0x60c9803b,0x69c0c0bc,0x29048b64,0x3ce940bd}},	//   _svem, _beme, _asma_, stav_, 
   {{0xfe350273,0x61fd40be,0xdb18801b,0xdb05356f}},	//   _נאָך_, nesl, _neví, nché, 
   {{0x69c08dc1,0xadd604fc,0x9f580610,0x29048128}},	//   _deme, _אורח_, nerî_, _csma_, 
   {{0x75160273,0x9f0580fe,0xa3b08587,0xa3e30587}},	//   _אַלע_, فوتو, टुम_, _नञि_, 
   {{0x69c0c0bf,0x7bc540c0,0x66099130,0x20d5807f}},	//   _feme, mahu, tdek, _búið_, 
   {{0x69c091ce,0x7bc540c1,0x9f580610,0xb87b40c2}},	//   _geme, lahu, kerî_, luíd, 
   {{0x6441aad8,0xdb188170,0x2904c0c3,0x6e2b892f}},	//   thli, _deví, _gsma_, _vogb, 
   {{0xc984c0c4,0x69c0c0c5,0x7bc50e3b,0x0d82824f}},	//   _руси, _zeme, nahu, ылын, 
   {{0x69c0bbdf,0x35b591af,0x3209034e,0xdb1c3f99}},	//   _yeme, _збер, _baay_, _peré, 
   {{0xcb120273,0x61fd00d0,0x6a788207,0x683480a6}},	//   אלט_, gesl, tífi, _ràdi, 
   {{0x7bc5044c,0xdb1c01b2,0x78a081df,0x9f5801b2}},	//   kahu, _nerî, _xumv, gerî_, 
   {{0xf8b28039,0xe3d500b2,0x6830010d,0x7e7bc0c6}},	//   רשם_, স্তব, _räds, llup, 
   {{0xdb1c03c3,0x3a3fc0c7,0x61fd40c8,0x7bc540c9}},	//   _teré, _olup_, besl, dahu, 
   {{0xa49b00a6,0x61e40183,0xdb0381ed,0x7e7b9060}},	//   _pròp, _ucil, _benö, nlup, 
   {{0xc6928fcc,0x69c0902b,0x7afb21de,0x224040ca}},	// [29a0] ראן_, _reme, _ćuta, _ilik_, 
   {{0x69c63e35,0x7bc540cb,0xdb1a8019,0x6cd300d8}},	//   lake, gahu, latá, اقلا, 
   {{0x69c09cc9,0xe1fa84a0,0x645e165e,0x673500a1}},	//   _peme, зге_, rnpi, cyzj, 
   {{0xe64640cc,0x69c640cd,0x518689fc,0x4ad1009b}},	//   _чемп, nake, нула, _हिरव, 
   {{0x76560816,0xa3cf8795,0xdb1c02a5,0x7bc540ce}},	//   miyy, षणा_, _gerî, bahu, 
   {{0x69c640cf,0x7656008c,0x26dcc0d0,0x3013805a}},	//   hake, liyy, tuvo_, лдір, 
   {{0x444437ba,0x69c6040c,0x81cb00cf,0x8c1b0273}},	//   mh_, kake, র্ট_, _צולי, 
   {{0x76560816,0x3a3f868b,0x7e7bc0d1,0x69c640d2}},	//   niyy, _glup_, glup, jake, 
   {{0xd2578115,0x69c640d3,0x40a88068,0xdb1c02a5}},	//   _נשמה_, dake, _آخری_, _xerî, 
   {{0x44440147,0xb05b00f9,0x9f47826b,0x224002ff}},	//   nh_, rsäk, lený_, _alik_, 
   {{0x44440385,0x3fc9807b,0x1de10ec1,0x99620093}},	//   ih_, _آگهی_, _फालत, têşa_, 
   {{0x61e2c0d4,0xb5fb0068,0xa2d30f5a,0xdb1ac0af}},	//   ngol, _aján, _डिस्, gatá, 
   {{0x764440d5,0x76560816,0xdb0534f8,0x61fd0926}},	//   dhiy, diyy, rché, resl, 
   {{0x44442aff,0x2c1680a1,0x7c2e40d6,0x798440d7}},	//   jh_, ताओं_, _nobr, _dziw, 
   {{0x44442976,0xb5fd80d7,0x69c640d8,0xb87b0e74}},	//   dh_, pošt, bake, ktív, 
   {{0x444440d9,0x442e850a,0xa2d5800d,0x69c640da}},	//   eh_, _hof_, _भित्, cake, 
   {{0x7bc540db,0x5c7505c2,0x25a940dc,0x9f478a5b}},	// [29b0] tahu, влат, rcal_, dený_, 
   {{0xddeb007b,0x444440dd,0x3a2d81f0,0xe1ff07d6}},	//   _کرده_, gh_, _soep_, leó_, 
   {{0xa3e20073,0x7bc540de,0x442ec0df,0xb3e216a6}},	//   _धार_, rahu, _mof_, _पारख, 
   {{0x7bc50c3f,0x444440e0,0x764402d7,0x442ec0e1}},	//   sahu, ah_, chiy, _lof_, 
   {{0x444415bd,0x661d40e2,0xd0099aa1,0x26cc8265}},	//   bh_, _insk, деле_, _avdo_, 
   {{0x444440e3,0x81cb00cf,0x69c640e4,0xb87b40e5}},	//   ch_, র্চ_, zake, quíd, 
   {{0xe8220d64,0xd9d900cf,0x1c0a005f,0x9f47826b}},	//   माता_, ধ্যম, _होटल_, bený_, 
   {{0x660d40e6,0x7c2e0f43,0x645704e0,0x60cd0215}},	//   ndak, _zobr, lixi, _ovam, 
   {{0x7e7b8111,0xe1ff0019,0xe81e810c,0x26cc82fa}},	//   rlup, deó_, पाशा_, _evdo_, 
   {{0x22400af6,0x69c640e7,0x76560816,0x442e843a}},	//   _slik_, wake, ziyy, _cof_, 
   {{0x2fc7c0e8,0x69c640e9,0xdb1a8068,0xdb0a82ae}},	//   mang_, take, tatá, _gefü, 
   {{0x2fc7c0ea,0x444400f8,0x3eaa803e,0x98a640eb}},	//   lang_, zh_, žité_, киме, 
   {{0x1d098d74,0xf1bf0019,0x7656008a,0x6e3b9e0d}},	//   _цели_, pján_, viyy, mkub, 
   {{0x2fc7c0ec,0x765640ed,0x69c640ee,0x6d45808a}},	//   nang_, wiyy, sake, _əhal, 
   {{0x69c640ef,0xe45680c6,0x660b8128,0x645740f0}},	//   pake, _ביסט_, _kagk, dixi, 
   {{0xadf9941c,0x2fc7c0f1,0xb17b0172,0x444402a1}},	//   ्यटन_, hang_, mgån, wh_, 
   {{0x444440f2,0xed5721f3,0x660b84f0,0x7c2e40f3}},	// [29c0] th_, вот_, _magk, _pobr, 
   {{0x661d40f4,0x2fc7a5c9,0xb5fb007f,0x444440f5}},	//   _ensk, jang_, _hjál, uh_, 
   {{0x7bc3849d,0x2fc78c2a,0x3cedc0f6,0x444440f7}},	//   _menu, dang_, htev_, rh_, 
   {{0x444440f8,0x660b84b7,0xb21b0216,0x6289c0f9}},	//   sh_, _nagk, rlæg, _cheo, 
   {{0x61f600f8,0x2fc7c0fa,0x9f4780e9,0x69c440fb}},	//   _mbyl, fang_, rený_, _meie, 
   {{0x2fc7c0fc,0x69c440fd,0x7bc3c0fe,0xb87b03b8}},	//   gang_, _leie, _nenu, stív, 
   {{0x4420810b,0x2d80863b,0x7d0440ff,0x660bc100}},	//   _đi_, _šie_, lwis, _bagk, 
   {{0x27ed0025,0x6289c101,0x69c400f3,0x2619956f}},	//   đeni_, _gheo, _neie, भागी_, 
   {{0x2fc7c102,0x18a6977b,0x7bc3b0fb,0xa0a6afed}},	//   bang_, _разм, _benu, _разд, 
   {{0x2fc781c1,0x7bc3c103,0xdb1c0149,0xdb1a82d2}},	//   cang_, _cenu, _lerí, natç, 
   {{0x201e81d0,0x60cd1afb,0x6aa48a63,0xdb188063}},	//   _inti_, _svam, _čifs, _bevá, 
   {{0x200cc104,0x7d044105,0x05e103ff,0xddcd0034}},	//   _hadi_, kwis, _फाइब, ział, 
   {{0xe80f0365,0x6a7d02c0,0x200cc106,0x69c44107}},	//   ायला_, néfi, _kadi_, _deie, 
   {{0x200cc108,0xd7f82772,0x78a401f0,0xc8640fbe}},	//   _jadi_, кус_, _duiv, атси, 
   {{0x45d51d6a,0x7bc8c109,0x200cc10a,0x69c4410b}},	//   ловс, madu, _madi_, _feie, 
   {{0x6d0e01ff,0x200c8004,0x7bc8c10c,0x7bc3c10d}},	//   सिंग_, _ladi_, ladu, _zenu, 
   {{0xd904a0f4,0x2fc796a5,0x2d58036d,0x62898360}},	// [29d0] _بی_, yang_, вить_, _rheo, 
   {{0xda2105d9,0x76429614,0x6289c10e,0x201e8645}},	//   यावत_, _lloy, _sheo, _nnti_, 
   {{0x6457410f,0xddcd00a1,0xd3a44110,0x2fc7800b}},	//   rixi, riał, рруп, vang_, 
   {{0x2fc7c111,0xdd2182a5,0x2259037c,0x661d0885}},	//   wang_, _nîşa, nisk_, _unsk, 
   {{0x2fc79bb0,0x4dda0052,0x7bc8c112,0xb87b122b}},	//   tang_, _אחרו, kadu, btít, 
   {{0xd366c113,0xa2cc4114,0x7bc88079,0x7642c115}},	//   _هه_, _हिच्, jadu, _aloy, 
   {{0x2fc79b47,0x660b9923,0x200c840c,0x7bc3c116}},	//   rang_, _pagk, _dadi_, _renu, 
   {{0xc3321b4c,0x6d498124,0x201ec117,0x224682ff}},	//   _פון_, tzea, _enti_, chok_, 
   {{0x7bc39f8e,0x2fc7c118,0x225923ca,0x6e298a00}},	//   _penu, pang_, disk_, rjeb, 
   {{0xb5fb012b,0x7bc8c119,0x69c4411a,0x200cc11b}},	//   _sjál, gadu, _seie, _gadi_, 
   {{0x78a403e9,0x7bc3c11c,0x2259037c,0xc73580dd}},	//   _suiv, _venu, fisk_, _حفاظ, 
   {{0x2259037c,0x76429cac,0xb17b010d,0xd8388533}},	//   gisk_, _gloy, rgån, _viče_, 
   {{0x7bc3c11d,0xfe70846d,0x7bc8bec2,0x51560d29}},	//   _tenu, _بدل_, badu, утну, 
   {{0xdb1c0422,0x6cd28604,0x7bc8a53b,0x25adc11e}},	//   _serí, _اقوا, cadu, lcel_, 
   {{0xdb1c28b6,0xe81901d1,0x61e9c11f,0xe8f7004a}},	//   _perí, दाजा_, _ocel, _ұлы_, 
   {{0x28dc1e12,0x3ea58cc1,0x25adc120,0x6d410816}},	//   _बिपि, _mult_, ncel_, _əlav, 
   {{0xdb0a812b,0x3a20363d,0xdb1c4121,0x45863310}},	// [29e0] _hefð, _inip_, _verí, угав, 
   {{0x7d044122,0x61e999b7,0x6600803e,0x657d00f8}},	//   rwis, _acel, zemk, _dysh, 
   {{0x200c8025,0x59b8007a,0x7ae1c123,0xddc98025}},	//   _radi_, _आभार, nult, dlež, 
   {{0x66ea8816,0x53a3172e,0x2fc583b9,0x7bc88c48}},	//   _məkt, _ҳарб, _aelg_, zadu, 
   {{0x200c8645,0x7ae1c124,0x44310bdf,0x9f5801e9}},	//   _padi_, hult, _foz_, lerà_, 
   {{0x240a0004,0x648b1e52,0xdcfd00f3,0x53a3306e}},	//   _янги_, güid, _uzsā, _гарб, 
   {{0xdc674125,0xf1ba0028,0xa3e9009b,0x9f5801e9}},	//   _сард_, _đơn_, _यात_, nerà_, 
   {{0xe297c126,0x200c8497,0x96349bc2,0x7e640079}},	//   _бас_, _wadi_, рниц, nnip, 
   {{0x200c8484,0x4f26805a,0x216784c7,0x7bc8c127}},	//   _tadi_, _әдеб, _бити_, tadu, 
   {{0xcb1f80da,0xf1b98269,0x201e8318,0x61e9801b}},	//   यमंड_, _inša_, _unti_, _zcel, 
   {{0x2259037c,0xa3e58365,0xb89380fe,0x7e641569}},	//   tisk_, _फार_, _اللع, knip, 
   {{0xd915062d,0x9f584128,0xdb0502fd,0x80c18353}},	//   адмы, derà_, lchã, रीवे, 
   {{0x2259037c,0x7bc8bb25,0xf1bf0019,0x3ea580fa}},	//   risk_, padu, lják_, _zult_, 
   {{0x2259037c,0xb5fb0410,0xe7e300b2,0xbddb047f}},	//   sisk_, _ukáz, য়্য, _clèn, 
   {{0x645ac129,0x81dc80cf,0x2259037c,0x7ae19658}},	//   miti, ত্য_, pisk_, cult, 
   {{0x4431412a,0x35b5309c,0x443ec12b,0x442c810d}},	//   _soz_, рбар, lkt_, ljd_, 
   {{0x5455124a,0xe822007a,0xa3e9075c,0xdc5504d9}},	// [29f0] ават, माशा_, _याद_, авањ, 
   {{0xe7e081ff,0x61e9809f,0xb87b05cb,0x645ab53f}},	//   _नागप, _scel, dríg, niti, 
   {{0x443ec12c,0xed59893a,0x61e993e0,0xdb0e01ed}},	//   ikt_, raži_, _pcel, _gebü, 
   {{0x645ac12d,0xdb1c0077,0x27ed005d,0x39159645}},	//   hiti, _serã, đenu_, имер, 
   {{0x25ea150f,0x628d12dc,0x3ea5c12e,0xfc3f00d8}},	//   _छाती_, _mhao, _sult_, _dtír_, 
   {{0x443e863c,0x645ac12f,0x20114130,0xdb188008}},	//   jkt_, jiti, ndzi_, _kevä, 
   {{0xfc3f02ba,0x645ac131,0xdb1c03b8,0x2fc5c132}},	//   _guía_, diti, _verã, _velg_, 
   {{0xceb40464,0x6e2d4133,0xe6198004,0x443e98ab}},	//   זיק_, njab, тди_, ekt_, 
   {{0x645ac134,0x7bc70b62,0x1c4596bc,0x87e7846d}},	//   fiti, _keju, иним, _مثال, 
   {{0x1c1f8d26,0x69cbc135,0x7bc74136,0xdb1c0065}},	//   बाइल_, lage, _jeju, _herá, 
   {{0x3f67c137,0xcb69930c,0x38ab83cd,0x200303d5}},	//   _стаб, тане_, _hør_, deji_, 
   {{0x628d1b0d,0x69cbc138,0x660f0005,0x7bc738f3}},	//   _chao, nage, _nack, _leju, 
   {{0x645ac139,0x628d0b10,0x9f580ed0,0xfe7088a0}},	//   biti, _dhao, derá_, _عدم_, 
   {{0x443ebf1a,0x69cbc13a,0x7ae1c13b,0x9f58403b}},	//   ckt_, hage, pult, terà_, 
   {{0x660f413c,0x69cbc13d,0x38ab872c,0x628d0015}},	//   _back, kage, _lør_, _fhao, 
   {{0x628d0089,0x660f0bbe,0x7aee826b,0x9f58413e}},	//   _ghao, _cack, žití, gerá_, 
   {{0xb05b1cec,0xdb1881b2,0x7afc189f,0x648681c2}},	// [2a00] tsät, _pevç, _sprt, iðin, 
   {{0x7d0b807b,0x9f58360e,0x7bc70149,0xb87b413f}},	//   _msgs, perà_, _ceju, luín, 
   {{0xb05b08af,0x86b3005a,0x9f584140,0x660f4141}},	//   rsät, _мәті, berá_, _fack, 
   {{0x9f581151,0x660f029f,0x38ab8a76,0xed598024}},	//   cerá_, _gack, _bør_, lažu_, 
   {{0x03a64142,0x7649c143,0x3940c144,0x645ac145}},	//   _виго, dhey, áis_, yiti, 
   {{0x66042304,0x645ac146,0x26dc9d7b,0xf1bf0019}},	//   leik, xiti, trvo_, tják_, 
   {{0xe7ee023b,0x1c1fa544,0x23274147,0x69cbc148}},	//   _जाना_, बाईल_, _кори_, bage, 
   {{0x38ab8a76,0x261983fc,0x69cbc149,0x036707c5}},	//   _før_, _मोदी_, cage, _тиск_, 
   {{0x6143c14a,0x38ab8022,0xed598284,0x645ac14b}},	//   _дета, _gør_, kažu_, titi, 
   {{0x628d0094,0x69d6414c,0x9f5800e9,0x7d199cac}},	//   _shao, _adye, zerá_, _drws, 
   {{0x443ec14d,0x63a380f6,0x3dc680f6,0x660415c2}},	//   rkt_, _dgnn, _teow_, keik, 
   {{0x443e819d,0x645ac14e,0x6282a84d,0x2efe8269}},	//   skt_, siti, nloo, _iptf_, 
   {{0x645a8cf9,0x9f5803b8,0xc05b00f0,0x68e48048}},	//   piti, verá_, вів_, àidh, 
   {{0x69cbc14f,0xc05b4150,0x62828504,0x69d600ed}},	//   zage, тім_, hloo, _edye, 
   {{0x628d0b10,0x69cbc151,0x9f580207,0x44f0aff0}},	//   _thao, yage, terá_, là_, 
   {{0x7bc7025f,0xf8a689af,0xb05b019b,0xe61f0106}},	//   _seju, खदाय, tsäs, _khôi_, 
   {{0x660f00f9,0x7bc705b5,0xdb050a5b,0x95c80479}},	// [2a10] _vack, _peju, dchá, руса_, 
   {{0xdb1c0422,0x6d4d0a44,0x69cb8e54,0x38ab83cd}},	//   _será, rzaa, wage, _rør_, 
   {{0x69cbc152,0xa2f54153,0x6282a205,0x38ab8af6}},	//   tage, спеч, floo, _sør_, 
   {{0xceb2015c,0x80db800f,0x62829fd9,0x44f0840a}},	//   _מיט_, _निदे, gloo, kà_, 
   {{0xdb1c0dfa,0xe9d8c154,0xe7ee0439,0x81d400b2}},	//   _verá, ркі_, _जामा_, স্ক_, 
   {{0x44f0c155,0xdb0500d8,0x81ad05a2,0x3f69961f}},	//   dà_, achá, গরি_, лило_, 
   {{0xdb1c03b3,0x61ed4156,0x6282800b,0x41e785cf}},	//   _terá, _ocal, bloo, _віза, 
   {{0x38ab872c,0x683d8741,0x6aa09cf3,0x7d0b8128}},	//   _tør_, _mèdi, _gimf, _psgs, 
   {{0x6486812b,0xf80780f0,0x7980811a,0x7649c157}},	//   rðin, _вчен, _gymw, rhey, 
   {{0x1c45c158,0x308580fe,0xe0df01e9,0x61ed0c65}},	//   сном, _الطف, drò_, _acal, 
   {{0x78a985a2,0xb87b01e0,0x9f5800a6,0xe0df02fb}},	//   _huev, tuín, merç_, erò_, 
   {{0x3b8489b2,0x78a1c159,0xbddb0050,0x66ea82d1}},	//   өлөг, _hilv, _blèm, _təkr, 
   {{0xd17603a7,0x78a986c9,0x25bf96ac,0x6604415a}},	//   сыны, _juev, mbul_, veik, 
   {{0x78a986c9,0x25bfc15b,0x7e7d415c,0xf1bf0432}},	//   _muev, lbul_, _aksp, abá_, 
   {{0x6604415d,0xa2d30d64,0x7d09c15e,0xddcb2a14}},	//   teik, _डिग्, lwes, _šiša, 
   {{0x25bf87fa,0x290dc15f,0xed598305,0xdb1c01b2}},	//   nbul_, _osea_, sažu_, _herç, 
   {{0x78a9a8d4,0x66044160,0xddc98034,0x7c3500e2}},	// [2a20] _nuev, reik, wieś, _bozr, 
   {{0xeb9a0537,0xdd8f05b6,0x6282839d,0x61fbbab5}},	//   гиз_, رول_, wloo, _abul, 
   {{0xe73a4161,0xdb1c4162,0x25bfc163,0xb09b0039}},	//   _сен_, _merç, kbul_, _תייר, 
   {{0xd91081a1,0x7d09c164,0xb87b4165,0x6b7a80c6}},	//   ویز_, kwes, críb, ארענ, 
   {{0xc05ac166,0x6441c167,0x78a9833b,0xd7fa99a6}},	//   лік_, kkli, _cuev, гуй_, 
   {{0x78a1834a,0x6447005d,0xdb1ac168,0x6282beaf}},	//   _cilv, _glji, ratú, sloo, 
   {{0x6282c169,0x645e29e2,0x64418172,0x7ff380fe}},	//   ploo, mipi, dkli, سسوا, 
   {{0x44f081dd,0xc8e0800f,0x44b480f0,0x6f1a807e}},	//   tà_, _निपट, обис, _vrtc, 
   {{0xdb1c416a,0xa49b0741,0x7afb0e02,0x68e6072d}},	//   _berç, _pròx, _ćuti, jukd, 
   {{0x44f0c16b,0x61fb80f8,0x645e416c,0x15ea83ff}},	//   rà_, _zbul, nipi, _टावर_, 
   {{0x7f86830b,0x6d410816,0x547b0039,0x92952389}},	//   _الان, _əlaq, רטיו, жанц, 
   {{0xc3331af4,0x7a3f0210,0xe61f0028,0xa5bb3b19}},	//   לות_, _këti, _thôi_, _anón, 
   {{0x6da38c93,0x645e416d,0xdb1c0008,0xb87b011e}},	//   _عموم, kipi, _herä, buíl, 
   {{0x6441c16e,0xdb1c416f,0x69c014d7,0xc9870103}},	//   ckli, _gerç, ðmer, _қуйи, 
   {{0x623502d4,0x7c352430,0x466b0e31,0xc0580deb}},	//   _меку, _rozr, грам_, сія_, 
   {{0x7bca87e9,0x4caa00b2,0x64470259,0x68e6013b}},	//   _hefu, _চৌধু, _slji, bukd, 
   {{0x69cf4170,0x7c350038,0x7cd9003d,0x7bca80bf}},	// [2a30] mace, _pozr, شواز_, _kefu, 
   {{0x69cf0018,0x4d981db0,0x6aaac171,0x645e4172}},	//   lace, скую_, _kuff, gipi, 
   {{0xe7ee00d5,0xe9f90028,0x25a683b8,0x78a983b9}},	//   _जाता_, _giả_, _ogol_, _suev, 
   {{0x7bca8504,0xa49b017c,0x7d09a077,0xb87b03e2}},	//   _lefu, _asòt, ywes, bríc, 
   {{0x61fbc173,0x7bd880d7,0x7d09824a,0x78a18b4e}},	//   _vbul, _odvu, xwes, _pilv, 
   {{0x8aa711f1,0x02a70ad0,0xdb1c00f9,0xe7398f6c}},	//   _град, _грам, _berä, иел_, 
   {{0x81d40a87,0xa6b480b2,0x80dbb3e1,0xd1bb80d8}},	//   স্ট_, _টিউট, _निवे, _ماذا_, 
   {{0xee39a282,0x764d17ef,0x7d09c174,0x61fb8655}},	//   рни_, nhay, twes, _ubul, 
   {{0x82348bb7,0x78a18a71,0xdb1c4065,0x89378501}},	//   _عرفا, _tilv, _perç, _اعزا, 
   {{0xf990940d,0x7d09c175,0x2249045a,0x25bfc176}},	//   _سبق_, rwes, _alak_, sbul_, 
   {{0x6441c177,0x2007c178,0xdb1c4179,0x69cf417a}},	//   rkli, meni_, _gerä, face, 
   {{0x81e200cf,0x6441c17b,0x7d09c17c,0x645e417d}},	//   ন্ন_, skli, pwes, zipi, 
   {{0x7e7b8053,0x764d033f,0xdb1c0077,0xe7ee0079}},	//   moup, dhay, _terç, _जादा_, 
   {{0x7bcaac32,0x2249417e,0x7e698217,0x7e7bc17f}},	//   _gefu, _elak_, lnep, loup, 
   {{0x07a30f49,0x032580f0,0x2bbfb2a1,0x8fa30703}},	//   дарн, _єдин, _श्या, даре, 
   {{0x38af0972,0x764d0f34,0x2007c180,0xb87b4181}},	//   _für_, ghay, heni_, tríc, 
   {{0x645e4018,0x3ea20172,0xe45a1161,0x2007ad0c}},	// [2a40] tipi, _vikt_, ажа_, keni_, 
   {{0x62864182,0x2a6d82ef,0x2a7f82ef,0xc8e080c9}},	//   llko, _ajeb_, _akub_, _निबट, 
   {{0x6da61c10,0x41aa81f5,0x764d047f,0x7e7b801b}},	//   _мина, авен_, bhay, koup, 
   {{0x645e4183,0x764d0103,0x387e82fa,0xb5fb01c2}},	//   sipi, chay, _sktr_, _sjáv, 
   {{0xa3e98560,0xe80f009b,0x645e4184,0x6b838b07}},	//   यला_, ायचा_, pipi, _lyng, 
   {{0xd6dac185,0x2007c186,0xdb1c0008,0x764407de}},	//   ати_, geni_, _perä, lkiy, 
   {{0x44f4036d,0x27e087fa,0x81e200b2,0x44444187}},	//   lä_, ğin_, ন্য_, mk_, 
   {{0xa5349507,0x44384188,0x27e0c189,0x91e605b7}},	//   знич, _hor_, şin_, _कागज_, 
   {{0x44f4036d,0x746a8a19,0xc6930c2d,0xd406ada0}},	//   nä_, иров_, ואה_, ояни, 
   {{0x4444418a,0x81e200b2,0x4438024a,0xb35480f0}},	//   nk_, ন্ম_, _jor_, зкош, 
   {{0x44440e45,0x4438418b,0x6b838360,0x28c68f5a}},	//   ik_, _mor_, _cyng, रीरि, 
   {{0x81dc8a87,0xb5fb00b2,0x4438418c,0x64a6c18d}},	//   ত্র_, _imág, _lor_, _дада, 
   {{0x443804fd,0x4444418e,0x7e608839,0x44f4036d}},	//   _oor_, kk_, mimp, jä_, 
   {{0x444405ab,0x6aaac18f,0x44f40008,0x7d028431}},	//   jk_, _tuff, dä_, _ipos, 
   {{0x69cf0380,0x6b83811a,0xd838c190,0x644a80db}},	//   pace, _gyng, _moč_, _ilfi, 
   {{0x2007c191,0x7e60c192,0x44444193,0x38af12eb}},	//   zeni_, nimp, ek_, _tür_, 
   {{0x44384194,0xa3ae802a,0x5d5501f5,0xd7fb376e}},	// [2a50] _bor_, _कला_, чкат, _кун_, 
   {{0x44383a05,0x64dd8365,0x68e29bc7,0xf8bf4195}},	//   _cor_, _मिसळ, drod, mpé_, 
   {{0x44384196,0x7e60c197,0x764d00ed,0xf8bf2671}},	//   _dor_, kimp, phay, lpé_, 
   {{0x2007c198,0xc3338273,0x444404fe,0x7c38c199}},	//   weni_, ווע_, ak_, _lovr, 
   {{0x44380757,0x2ca3063c,0x2007c19a,0x68e280a1}},	//   _for_, _tijd_, teni_, grod, 
   {{0x4438419b,0x6d408116,0xf8bf0035,0xd7fbb46a}},	//   _gor_, dyma, ipé_, руд_, 
   {{0xe739c19c,0x44298028,0x7d0d419d,0x3ffc0273}},	//   сей_, _đa_, lwas, יפגע, 
   {{0xb0dc05d9,0x2007c19e,0x4438419f,0x28dc0056}},	//   _बिलग, seni_, _zor_, _बिलि, 
   {{0xdb05035b,0x81e200cf,0x7d0d41a0,0x83fcb58f}},	//   schä, ন্ড_, nwas, ziđe, 
   {{0xbebc80f3,0x764441a1,0x28e0a347,0xb5fd8183}},	//   _brīd, zkiy, _निति, diše, 
   {{0x7c38809f,0x59cf8b30,0x7d0d41a2,0x7d02c1a3}},	//   _dovr, _हजार, hwas, _epos, 
   {{0x60c980bb,0x7d0d0371,0x83fc8024,0x7e609637}},	//   _kwem, kwas, viđe, cimp, 
   {{0x216704bc,0x6f1e0bbe,0x69cd00ca,0xa56780df}},	//   зияи_, _srpc, _deae, _بدان, 
   {{0x6b838920,0x44f40008,0xe73a104c,0x60c9c1a4}},	//   _tyng, vä_, бег_, _mwem, 
   {{0xcb6689e4,0xaa4627b1,0x4427c1a5,0x60c986b5}},	//   _наше_, _некл, _inn_, _lwem, 
   {{0x44f4025b,0x443841a6,0x6f1e05c3,0xb87b033b}},	//   tä_, _sor_, _vrpc, rría, 
   {{0x7644117f,0x7d0d149b,0x28e081a2,0x6e398519}},	// [2a60] rkiy, gwas, _निधि, _mowb, 
   {{0x444441a7,0x69db8149,0x8b962819,0x764441a8}},	//   uk_, _adue, преч, skiy, 
   {{0x443841a9,0xf62601f5,0x6d4080a1,0x7d1b8079}},	//   _vor_, _едно, zyma, hvus, 
   {{0x44440072,0xdca600b5,0x645c01f0,0x78ad027e}},	//   sk_, _нами, _wmri, _yuav, 
   {{0x4427c1aa,0xf1a9803d,0x291f80fe,0x69c296f3}},	//   _onn_, زانه_, _crua_, rboe, 
   {{0x68e2a13c,0x69db811e,0x69c28e45,0x645c41ab}},	//   rrod, _edue, sboe, _umri, 
   {{0x7d02c1ac,0xa91d826b,0x1c020562,0x7bdc2736}},	//   _spos, _vyža, _रॉयल_, _idru, 
   {{0x4427c1ad,0x81e20a87,0x7c38c1ae,0x6d408da2}},	//   _ann_, ন্ত_, _sovr, tyma, 
   {{0x7c388b8c,0x7bce0d9c,0x48e3839c,0x291f816c}},	//   _povr, _kebu, _потв, _grua_, 
   {{0x7e60c1af,0xb5fd861e,0x6d409bc7,0x5fd0801b}},	//   simp, više, ryma, _सजिल, 
   {{0x291241b0,0x7e60c1b1,0x60c98a44,0xf366af4c}},	//   _asya_, pimp, _zwem, ятин, 
   {{0x44278362,0x7bce41b2,0x78ad01df,0x3ce901df}},	//   _enn_, _lebu, _puav, yuav_, 
   {{0xdcf7840c,0x7d028770,0x58d40014,0x7c38807e}},	//   _فروش_, _upos, ноят, _tovr, 
   {{0x7bce41b3,0xb90505b1,0xb5fd8942,0xa8a41647}},	//   _nebu, _पट_, riše, ерск, 
   {{0x54338267,0xf647004a,0xff041e07,0xabfb8309}},	//   _سرور, пхан, нятн, _ההור, 
   {{0x7d0d41b4,0xb5fd8121,0xf8bf00ef,0x26df0215}},	//   twas, piše, ppé_, čuo_, 
   {{0x59c3032d,0x7bce41b5,0x3a290363,0x9c392a25}},	// [2a70] _व्यर, _bebu, _inap_, опат_, 
   {{0x81e200cf,0xfbab41b6,0x200a02fd,0x6609c1b7}},	//   ন্দ_, стай_, cebi_, zeek, 
   {{0x75290131,0x64451dca,0x3d0e93d2,0x9f5e8ed8}},	//   _šezd, rkhi, _तैसे_, _mató_, 
   {{0xdb15026b,0xfd1f001c,0xdb1ab7b0,0xa3dc8f2c}},	//   _sezó, _trì_, lató, तृत_, 
   {{0xe1f09f3b,0xb5fb012b,0x9f5106c9,0x7e6d41b8}},	//   اسم_, _fjár, pezó_, mnap, 
   {{0x7bce30fb,0xdb1ac1b9,0x4174803d,0x6609c1ba}},	//   _gebu, nató, رانس, week, 
   {{0x66098ca7,0xae1e812e,0xac941bc4,0x9f5e840a}},	//   teek, _मोहन_, _чарш, _tatý_, 
   {{0xda1d1e12,0x7bdc211c,0x7e6d2776,0x7d1b8079}},	//   _बोलत_, _zdru, nnap, tvus, 
   {{0x5fbf000d,0xe7ee0689,0x660983c5,0xd7bf0d6d}},	//   ्राल, _जाला_, reek, ्राच, 
   {{0x68e4830b,0x6609c1bb,0x5ee58034,0xbb45be75}},	//   áide, seek, _टिप्_, деок, 
   {{0x7e6d1153,0x3ea6811e,0x91e641bc,0x6e39817c}},	//   knap, _fiot_, моне, _towb, 
   {{0xd9ff812e,0xb87b00d8,0x19b90123,0x3a290304}},	//   ोजित_, frío, зурь_, _cnap_, 
   {{0x7e6d41bd,0xdb0a80f9,0xdb038149,0x68eb8347}},	//   dnap, _affä, _igní, nugd, 
   {{0xdb1ac1be,0xe8008f8a,0xa91d8170,0x67218c0e}},	//   gató, ल्पा_, _lyžo, _krlj, 
   {{0x81e58a87,0xa0a341bf,0x7bce41c0,0x98a33e34}},	//   ব্য_, тард, _rebu, тире, 
   {{0x7bce1cba,0x2ca7c1c1,0x67218131,0xb5fb011e}},	//   _sebu, _hind_, _mrlj, _amáb, 
   {{0x1be18079,0x7bce02fa,0x628441c2,0x2bb203f0}},	// [2a80] _खयाल_, _pebu, _ikio, _जलदा, 
   {{0x1daa0056,0x7bce0829,0x672197a2,0x8b6a0086}},	//   _कलकत, _qebu, _orlj, оизв_, 
   {{0x38b419e7,0x28e083ff,0x65c621cc,0x2ca7c1c3}},	//   _här_, _निहि, _обна, _mind_, 
   {{0x1bf0010c,0x7bce41c4,0x2ca7c1c5,0xdb188170}},	//   _चावल_, _webu, _lind_, _nevý, 
   {{0x7bce41c6,0x83fc8269,0xb17b03b7,0x644f81a8}},	//   _tebu, hiđa, lgår, īcij, 
   {{0x7bdc003b,0x224dc1c7,0x59cc800d,0x46d2010c}},	//   _udru, _elek_, ारहर, _तबाह, 
   {{0x38b400f9,0x224dba8f,0xb17b04ff,0x644e41c8}},	//   _lär_, _flek_, ngår, _ilbi, 
   {{0x442084e4,0xe297805a,0x442a38b9,0x67218259}},	//   _şi_, _жас_, _hnb_, _drlj, 
   {{0x38b419e7,0x7c3c2bfe,0x6d4416ac,0xd8388284}},	//   _när_, _korr, nyia, _liči_, 
   {{0xdb1c072c,0x6284004f,0x7c3c0122,0x67218524}},	//   _berø, _akio, _jorr, _frlj, 
   {{0x9e3c826b,0x67218105,0x60c29d65,0x9f5e875d}},	//   _buďt, _grlj, lpom, _obté_, 
   {{0x38b408af,0x81e200b2,0x2ca780fa,0x60c28034}},	//   _bär_, ন্স_, _eind_, opom, 
   {{0x2ca7c1c9,0xa3c00353,0xdb1ac1ca,0x644e0495}},	//   _find_, ीरा_, tató, _olbi, 
   {{0x38b419e7,0x7c3c41cb,0x628402fe,0x9c5780d8}},	//   _där_, _norr, _ekio, _يجوز_, 
   {{0xe800994e,0x9f5f07fa,0x7522826b,0xb5fd8024}},	//   ल्या_, _ürün_, _hroz, liša, 
   {{0x644e0124,0x443c8ec8,0x569441cc,0x7e64013b}},	//   _albi, _hov_, васт, giip, 
   {{0x443cc1cd,0x6602807b,0xdb1ac1ce,0x60c2877b}},	// [2a90] _kov_, _mbok, catò, jpom, 
   {{0x7c3c41cf,0xe3b886c8,0x6f05001c,0x225f806d}},	//   _corr, ncı_, _tphc, _smuk_, 
   {{0x443cc08b,0x224da17b,0x7c3c41d0,0x60cd00db}},	//   _mov_, _plek_, _dorr, _hwam, 
   {{0x60cd2dfd,0x443cc1d1,0x644e41d2,0x442a41d3}},	//   _kwam, _lov_, _elbi, _enb_, 
   {{0x7c3c3f12,0xa8038214,0x6e3d0128,0x67218524}},	//   _forr, _çıkt, _iosb, _srlj, 
   {{0x67218053,0x60cd41d4,0x7c3c41d5,0x6602c1d6}},	//   _prlj, _mwam, _gorr, _abok, 
   {{0x3949a4a4,0xddc40bfc,0x2ca781b2,0x60cd012c}},	//   šas_, lniš, _rind_, _lwam, 
   {{0x2ca78354,0x439441d7,0x83fc829f,0x75228c0e}},	//   _sind_, _расс, viđa, _broz, 
   {{0x7522a9de,0xd7fbc1d8,0x2ca7c1d9,0x6e3d1473}},	//   _croz, _муж_, _pind_, _mosb, 
   {{0x660d41da,0xfc31830b,0x443c950d,0x20cd41db}},	//   heak, احة_, _cov_, dži_, 
   {{0x2ca79752,0x443cc1dc,0x60cd41dd,0xda6616c0}},	//   _vind_, _dov_, _awam, евни, 
   {{0x23bf8758,0x2bbf9306,0xee2e8ad0,0xfbbf8561}},	//   _श्रद, _श्रा, _ён_, _श्रम, 
   {{0xed4ec1de,0x7522c1df,0x1bf0007a,0xddc41c2e}},	//   _со_, _groz, _चालल_, jniš, 
   {{0x6aa99759,0xddc413ea,0x26de0024,0x653a80c6}},	//   _lief, dniš, štom_, _מענד, 
   {{0x44f98246,0xfe780188,0xdb188065,0x6619a4cd}},	//   lè_, дүн_, _devó, _kawk, 
   {{0x661bc1e0,0xb17b0e87,0x62840ca2,0x443c806c}},	//   nduk, rgår, _ukio, _zov_, 
   {{0xfce30774,0x60cd012c,0xa507130c,0x44f986e0}},	// [2aa0] лото, _gwam, нета_, nè_, 
   {{0x78fb0052,0x443c81ea,0x395704fc,0x7e7b0284}},	//   _צפיו, _xov_, _נשים_, čupa, 
   {{0x7c3c41e1,0x6d441307,0x7989844e,0x6aa9c1e2}},	//   _vorr, syia, _ayew, _bief, 
   {{0xddc40ecf,0x7ae32c16,0x661bae70,0x2bb206d7}},	//   bniš, ánta, jduk, _जलवा, 
   {{0xa3e9009b,0x442a41e3,0x5183b6fa,0x28f8a4cb}},	//   _याच_, _tnb_, луша, фель_, 
   {{0x75249ef8,0x98a389c4,0x10a3a068,0xb87b011e}},	//   _šizo, гиче, гичн, buíu, 
   {{0x91e69700,0x443c81ea,0x09e6836a,0x7989c1e4}},	//   _пове, _rov_, _повн, _eyew, 
   {{0x7522c1e5,0x443cc1e6,0xfaa3814f,0xb87b41e7}},	//   _proz, _sov_, _басо, quív, 
   {{0x443c81c8,0x6ecc810c,0xc8ca9d06,0x09cc8056}},	//   _pov_, _सबकु, _روان_, ारीय, 
   {{0xa2b4807a,0x60cd3114,0x61f615b7,0x07a691af}},	//   _ईंद्, _rwam, _acyl, _зазн, 
   {{0x443cc1e8,0xdee3c1e9,0xddc4007e,0xcf1200b2}},	//   _vov_, _бохи, zniš, হমুদ_, 
   {{0xb5fdc1ea,0x7649c1eb,0xdc3c8043,0x7522c1ec}},	//   lišn, ckey, _išču, _troz, 
   {{0x81a900cf,0x443c9e29,0x261981d1,0x39468019}},	//   খুন_, _tov_, _मोटी_, nyos_, 
   {{0x201a41ed,0xb87b0065,0xb5fdc1ee,0x7c2ac1ef}},	//   _capi_, prím, unšv, _unfr, 
   {{0x45d503a3,0x660d41f0,0x141b8309,0xb6e40c98}},	//   ковс, teak, _מוגב, лютк, 
   {{0x6d1c00da,0xddc40f4e,0xbddb0a1c,0x60cd2066}},	//   निंग_, tniš, _alèr, _twam, 
   {{0x30a70084,0x313507b6,0xb87b01c2,0x22ac81d2}},	// [2ab0] _пров, _репр, nrík, _věku_, 
   {{0xb5fd8053,0xddc4007e,0x798980db,0x63ba9687}},	//   jišn, rniš, _ryew, nctn, 
   {{0xb5fd803b,0x28b71885,0xddc40131,0x5b241878}},	//   dišn, _इंडि, sniš, льца, 
   {{0x44f986e0,0xd8388a07,0xddc40998,0x3cea0076}},	//   yè_, _miču_, pniš, _चमचे_, 
   {{0xca7494f9,0x201a41f1,0xdb01855a,0x00000000}},	//   دالغ, _yapi_, nclò, --, 
   {{0x6bd40c72,0x290909ec,0xd942c1f2,0x201a02fe}},	//   _متفر, _mpaa_, реши, _xapi_, 
   {{0x6aa981ed,0xd8388183,0x79c980fe,0x39468786}},	//   _tief, _niču_, _يوسف_, ayos_, 
   {{0x9a8489b2,0x44f986e0,0xa2958116,0x9f4c8a1c}},	//   _буул, tè_, _рабі, _abdó_, 
   {{0x7649c1f3,0x30158692,0xb5fd8215,0x60db804f}},	//   rkey, _идар, bišn, _uvum, 
   {{0x1c45c1f4,0xd8388a63,0x44f9844e,0x26de0063}},	//   тном, _biču_, rè_, átok_, 
   {{0x201a1f8e,0x9f049367,0x3a3f86e0,0x290900db}},	//   _rapi_, _مولو, _koup_, _apaa_, 
   {{0x216a41f5,0x201a01fc,0xa96a2a91,0x44f9c1f6}},	//   дими_, _sapi_, дима_, pè_, 
   {{0xd1760ff9,0x212400fe,0x6486807f,0x9f5801fb}},	//   тыны, ímh_, gðis, rfrí_, 
   {{0x66e600b0,0xed5684c7,0x26c10027,0x3a3fa913}},	//   кога, _још_, _btho_, _loup_, 
   {{0xe1ff3c14,0xfc3f0bdf,0x627a02bb,0x1779019b}},	//   mión_, _luís_, _осиё_, есть_, 
   {{0x80d280cf,0xe5f3002d,0x201a0010,0x224b0ce7}},	//   _সমস্, văţă, _wapi_, ckck_, 
   {{0x201a3af0,0xb87b04e0,0xbea341f7,0x28dc0de3}},	// [2ac0] _tapi_, tuít, ратк, _बिटि, 
   {{0xe1ff1310,0xf1a701d2,0x3eab0e0b,0x224002fe}},	//   nión_, _गणतन, _eict_, _hoik_, 
   {{0xb5fd805d,0x3a3f834e,0x3e7a8f30,0x8fa602fd}},	//   višn, _boup_, līte_, _јане, 
   {{0x3a3f82c0,0x20058bed,0x91e6c1f8,0xb87b41f9}},	//   _coup_, _abli_, тоде, buís, 
   {{0x6f08811e,0x2444007f,0x99dd817c,0xc7b88105}},	//   _spdc, _sömu_, _alňs, _lađe_, 
   {{0x75360d7c,0xdb1c0068,0x3ea041fa,0xb7d880d8}},	//   mxyz, _kerü, lmit_, روبا_, 
   {{0xc7b8805d,0xb5fd839f,0x7c2e41fb,0xe8e0001c}},	//   _nađe_, rišn, _inbr, _ước_, 
   {{0x20058269,0xeb97262e,0x9f580149,0xdd94a10a}},	//   _ebli_, _рис_, leró_, лайы, 
   {{0x4a758bb3,0x2eeec1fc,0x527591e0,0x5ea380d8}},	//   _сырт, suff_, _суру, جميل, 
   {{0xe1ff41fd,0xe7ee009b,0x9f580396,0x515b8080}},	//   gión_, _जागा_, neró_, _חכמו, 
   {{0x8fa68166,0x3d178034,0x225206a4,0xdc3c80ca}},	//   _раже, _बैठे_, _blyk_, _ušču, 
   {{0x28b70562,0xb87b01ac,0xdb1c41fe,0xacbb0035}},	//   _इंदि, prík, _heró, _brûl, 
   {{0xe1ff04e0,0x81cc00b2,0xb87b016f,0x7c2e1d1a}},	//   bión_, _লাখ_, nsíg, _onbr, 
   {{0xe1ff41ff,0x5453c200,0xd838829f,0x14d78273}},	//   ción_, _квіт, _tiču_, _יודל_, 
   {{0x386d0301,0x44d00066,0x3eab02fa,0x9f5801ce}},	//   đer_, eń_, _pict_, deró_, 
   {{0x320f0068,0x02a4027a,0x5bcb19d7,0x7c2e4201}},	//   _úgy_, _крым, िर्व, _anbr, 
   {{0xf1b98043,0x9a6800fe,0x3c490093,0x5c7509c1}},	// [2ad0] _jaše_, _جميل_, _nîvê_, глат, 
   {{0x7ae34202,0xa5bb4203,0x5454109a,0x7bc582f4}},	//   ánto, _anót, авут, _õhut, 
   {{0x629f0495,0xe81d80da,0x6aad004f,0xd3a70deb}},	//   _èpos, _योगा_, _kiaf, трап, 
   {{0x3ce90bfc,0xe45f00f9,0x20114204,0x798d0371}},	//   prav_, _stöd_, lezi_, _kyaw, 
   {{0x26dec205,0xc7b80284,0x6aad01cb,0x91058d6e}},	//   _avto_, žđe_, _miaf, упле, 
   {{0x20114206,0xe1ff02ba,0x2444010d,0x764d4207}},	//   nezi_, xión_, _döms_, lkay, 
   {{0x27e98180,0x8aa78a48,0x788a0610,0x93884208}},	//   ğan_, _арад, _hêvî, _аста_, 
   {{0x27e9c189,0x1dd3007a,0x442e839d,0x765801e2}},	//   şan_, तरित, _anf_, _įvyk, 
   {{0x798d1734,0xe1ff17e5,0x2a64809f,0xac858ba0}},	//   _nyaw, tión_, _търг, лгил, 
   {{0x661d1ab8,0xec768ceb,0x69d9c209,0x3ea000f8}},	//   _lask, лпы_, lawe, zmit_, 
   {{0x7bd51cf0,0x25af80e5,0x3246064e,0x9f5801e9}},	//   _mezu, _tggl_, генг, herò_, 
   {{0xe1ff16c7,0xceb2804d,0x661d2736,0x69d9822d}},	//   sión_, _היא_, _nask, nawe, 
   {{0xfce5c20a,0x6aad420b,0x798d00bb,0x827683f3}},	//   _соло, _diaf, _cyaw, רערע_, 
   {{0x44fd0086,0x7e698116,0x201101d5,0x764d09ec}},	//   dì_, liep, gezi_, ekay, 
   {{0x69d9c20c,0xcfd880cf,0xb87b0f3a,0x6aad420d}},	//   kawe, _সামন, tuír, _fiaf, 
   {{0x661d408b,0x69d9c20e,0xe3cd00b2,0x764d0f34}},	//   _cask, jawe, _লাগব, gkay, 
   {{0x3ea0420f,0x661d068b,0x62864210,0x7bd54211}},	// [2ae0] rmit_, _dask, moko, _bezu, 
   {{0x62864212,0x09cc9131,0xdb1c0019,0x69d64213}},	//   loko, ार्य, _terü, _heye, 
   {{0x272382bc,0x6e3bc214,0x69d64215,0x91d0802a}},	//   _nın_, kjub, _keye, दरलै, 
   {{0x2485c216,0x69d9c217,0x629bc218,0x9f410685}},	//   holm_, gawe, _chuo, _echó_, 
   {{0x1ae03af6,0x186aae08,0xa06ac219,0x91e3861d}},	//   _पटकथ, нади_, нада_, соче, 
   {{0x69d6421a,0x6286421b,0x7bd5421c,0x6d5b8766}},	//   _leye, hoko, _gezu, dzua, 
   {{0xeb97421d,0x6286421e,0xdb1c033b,0x69d9c21f}},	//   _бир_, koko, _veró, bawe, 
   {{0x660402f0,0xf1b9ba35,0x60c44220,0x61e44221}},	//   nfik, _paše_, _otim, _ndil, 
   {{0x2011073e,0xb21b03cd,0xacb490f3,0x29568086}},	//   yezi_, klær, јбољ, _съвр, 
   {{0xf1b9a01e,0x10a68004,0x4cc380b2,0xe64487de}},	//   _vaše_, _сизн, _শিশু, ılış, 
   {{0x60c44222,0xaa591ecf,0x798d0238,0x4394c223}},	//   _atim, вину_, _syaw, ранс, 
   {{0x201ec224,0x2011381e,0xe45287f1,0xc3330039}},	//   _hati_, wezi_, _گفتگ, צור_, 
   {{0x201ec225,0x661d4226,0x20114227,0x61e4011a}},	//   _kati_, _rask, tezi_, _ddil, 
   {{0x61e40a40,0x661d4228,0x3cf18170,0x9f5801e9}},	//   _edil, _sask, ňový_, verò_, 
   {{0x7bdac229,0x661d422a,0x201e888a,0x2011422b}},	//   matu, _pask, _mati_, rezi_, 
   {{0x201ec22c,0x7bd5422d,0x6286422e,0x764280db}},	//   _lati_, _sezu, coko, _jooy, 
   {{0x764d422f,0xdb0501ed,0xdddb81d2,0x3209013b}},	// [2af0] rkay, schü, nouš, _ibay_, 
   {{0x201ec230,0x69c0c231,0x661d4232,0xd37b4233}},	//   _nati_, _afme, _wask, нче_, 
   {{0x7bd50ba7,0x5b15006e,0x8af9029e,0x69d9aa07}},	//   _vezu, рмет, тнес_, tawe, 
   {{0x7bdac234,0x7f3a00c6,0x2129016c,0xb5f202c3}},	//   hatu, _סערו, _krah_, _мүсі, 
   {{0x7bdac235,0x201ec236,0x69d9c237,0x6728847f}},	//   katu, _bati_, rawe, _ardj, 
   {{0xe800aa1a,0xd2d719df,0xd009c238,0xb3468214}},	//   ल्ला_, _مغرب, теке_, _kaçı, 
   {{0xe7398b0b,0x201ec239,0x7bdac23a,0xe454104c}},	//   тей_, _dati_, datu, _укры, 
   {{0x8aa4c23b,0xddc280a1,0xa267809f,0xb87b031e}},	//   _груд, _iloś, _съгл, crív, 
   {{0xee36c23c,0x7bdac23d,0x6e3b80e5,0xb5fd89b6}},	//   рны_, fatu, rjub, lišk, 
   {{0x6e3bc23e,0x201e80f8,0x442121d6,0x6286423f}},	//   sjub, _gati_, ndh_, woko, 
   {{0x44212976,0x62864240,0x2129047a,0xb5fd89b6}},	//   idh_, toko, _arah_, nišk, 
   {{0x69263723,0x201ec241,0x3cee8076,0x5156198a}},	//   амма, _zati_, _आमचे_, атгу, 
   {{0x62864242,0x7bdac243,0x44314244,0x8e8480fe}},	//   roko, batu, _onz_, _النه, 
   {{0x7bdac245,0x9f58007f,0x25bfc246,0x6c7980c6}},	//   catu, ferð_, lcul_, _שאַפ, 
   {{0x07a605fd,0x62860b9f,0x45d61c10,0x9f58007f}},	//   равн, poko, ицат, gerð_, 
   {{0x25bf85b5,0x13da80b2,0x64554247,0x6443c248}},	//   ncul_, _দায়, _alzi, _honi, 
   {{0x6443c249,0x660421c1,0x212924e2,0x248a00db}},	// [2b00] _koni, rfik, _grah_, _pkbm_, 
   {{0x7524424a,0x3eaf8a44,0x6443c24b,0xe45711b6}},	//   rviz, _ligt_, _joni, ажу_, 
   {{0x3a200ad0,0x6443c24c,0xe2868166,0x44310265}},	//   _kaip_, _moni, алжи, _dnz_, 
   {{0x201e803a,0x442115ea,0xa926c24d,0x7bdac24e}},	//   _sati_, adh_, идел, zatu, 
   {{0x201ec24f,0xd3788025,0x7bda8566,0x67288934}},	//   _pati_, maće_, yatu, _srdj, 
   {{0x7ee69fe3,0xdb1c012b,0x76428bd4,0x6443c250}},	//   ацие, _ferð, _sooy, _noni, 
   {{0x7bdac251,0xdb1c012b,0x290d8109,0xd9af8076}},	//   vatu, _gerð, _epea_, टशॉट, 
   {{0xf53f4216,0x7bdaad55,0x963492e8,0x7e76039d}},	//   _igår_, watu, сниц, nnyp, 
   {{0x7bdac252,0xdd978cfb,0xd90e8c0b,0xd49ab7db}},	//   tatu, ишь_, _آیت_, кро_, 
   {{0x656fb7c8,0x76428887,0x3209013b,0x66e6a6db}},	//   úcha, _wooy, _sbay_, _вожа, 
   {{0xc5e880cf,0x0bb70052,0x6f0900a1,0xc7b88183}},	//   ক্ষা_, ילים_, łecz, _gađa_, 
   {{0x3ced8088,0x7bdac253,0xaa674254,0xd3789527}},	//   brev_, satu, рток, jaće_, 
   {{0x7bdac255,0xdfdb009f,0x6443c256,0xd37885c3}},	//   patu, къв_, _foni, daće_, 
   {{0x27ed035b,0x644389bb,0x588701e2,0xdca390f3}},	//   ßen_, _goni, рыма, _дачи, 
   {{0x67d504b6,0x80d881d1,0x09d780b2,0xe0df1870}},	//   _қону, _नौसे, _হাসা, ssò_, 
   {{0xb5fd8116,0x27ed0214,0xe65400f0,0x443e810d}},	//   višk, şen_, овсь, ljt_, 
   {{0xf1b9c257,0x69dd4258,0xc7b80284,0x656d81ac}},	// [2b10] _naša_, mase, žđa_, _ľahk, 
   {{0x69dd4259,0x57f5061a,0xa80287de,0x2a69027e}},	//   lase, _упот, çıla, _hmab_, 
   {{0xfbab1a97,0x94a8425a,0xd3788ba7,0xbebc81a8}},	//   ттай_, ртта_, baće_, _drīk, 
   {{0xdb1c07e9,0x69dd425b,0xb5fd89b6,0xc7b8829f}},	//   _verð, nase, rišk, _rađa_, 
   {{0x645a94c7,0x634a8816,0xb5fd8116,0xe4a703b8}},	//   khti, lənd, sišk, _врво, 
   {{0x69dd425c,0x89348068,0xe2d90068,0xb87b161e}},	//   hase, تعما, _مارچ_, crít, 
   {{0x81e200cf,0x6d4d425d,0x3669c00e,0x2d8f80c0}},	//   ন্ট_, lyaa, лако_, _syge_, 
   {{0x644392c7,0xe619c25e,0x80b800cf,0x69dd425f}},	//   _soni, уди_, _অবস্, jase, 
   {{0x6443c260,0xb5fd8ec9,0x4bd9909a,0x25bf8123}},	//   _poni, niši, льня_, rcul_, 
   {{0x628d1e0d,0x25bfc261,0x6d4d09ec,0x2ab7008b}},	//   _akao, scul_, iyaa, _aħbi_, 
   {{0xd7958013,0x6443c262,0x3a2003bf,0x7e6d2944}},	//   _الاخ, _voni, _paip_, kiap, 
   {{0xc0494263,0x69dd012b,0x6443863c,0x4256124a}},	//   _אז_, gase, _woni, стот, 
   {{0xd3788024,0x6cc58103,0xa3d7349f,0x2f01c264}},	//   vaće_, _уйла, सरा_, lóg_, 
   {{0x645ac265,0x29022480,0xeb998004,0xa076005a}},	//   chti, rtka_, _йил_, сымш, 
   {{0x3a200ad0,0xd378b58f,0xdddb81bb,0xfaa64266}},	//   _taip_, taće_, kluż, _лако, 
   {{0x7bc1c267,0x765bc268,0x69c101d2,0xaac48a50}},	//   lclu, nhuy, ělec, _بتون, 
   {{0xe5a32658,0xd37881de,0x6da34269,0x3ae382d2}},	// [2b20] зити, raće_, зита, lıp_, 
   {{0x3ce0426a,0x68e4040a,0xf1b981f7,0xd378839f}},	//   rsiv_, _ivid, _raša_, saće_, 
   {{0xf1b99862,0x68e40142,0x6d4d0dd8,0xff2604ec}},	//   _saša_, _hvid, ayaa, _умно, 
   {{0xeb971a59,0xe804010c,0x6d4d06b5,0xddcd0123}},	//   щих_, श्रा_, byaa, rnaţ, 
   {{0xcfcf80cf,0x7bc19545,0xdd920604,0x2d840035}},	//   _রাজন, kclu, _روس_, _âme_, 
   {{0xf1b9c26b,0x3ae382d2,0x799b82d7,0x99dd8507}},	//   _vaša_, kıp_, _dzuw, _voňa, 
   {{0x69dd426c,0x76460116,0x7bd8c26d,0x6b63426e}},	//   yase, _koky, _revu, _екра, 
   {{0x6e24426f,0xdb1c0172,0x645d80f8,0xceb30039}},	//   ndib, _berö, ësin, היה_, 
   {{0x7d044270,0x764601e2,0x69dd01cc,0x7bd88a63}},	//   ntis, _moky, vase, _pevu, 
   {{0x7bde26a7,0xb4d6000d,0x409680fe,0xe7f285b7}},	//   napu, _सबै_, _الطر, _घाटा_, 
   {{0x69dd4271,0x7d0429d2,0x68e40efe,0x539880f0}},	//   tase, htis, _avid, рвня_, 
   {{0x645ab6fe,0x7d041284,0x7ae30530,0xf3638785}},	//   shti, ktis, ánti, ятын, 
   {{0x7bde4272,0xd90f007b,0x64430172,0x68e2c273}},	//   kapu, رید_, önik, nsod, 
   {{0x80b800b2,0x634a808a,0x69dd2a24,0x68e90a63}},	//   _অবশ্, tənd, sase, šedo, 
   {{0xf77311d2,0x6fda0f53,0x7646013b,0x7e6d4274}},	//   ساس_, _बजरं, _boky, tiap, 
   {{0x8afc80a1,0xdceb0a5b,0x7d044275,0x6e241882}},	//   rzęd, žičk, ftis, gdib, 
   {{0x76464276,0x32d28093,0x68e40e1b,0x26de1553}},	// [2b30] _doky, bûyî_, _gvid, átor_, 
   {{0x7e6d1fd8,0xb5fd8533,0xf8b50353,0x68e2c277}},	//   siap, riši, ंदीप, dsod, 
   {{0x6d4d04c4,0xb87b0065,0x6e2402eb,0xb5fd808d}},	//   syaa, brír, bdib, mišv, 
   {{0x09ad00cf,0x200c9cf5,0x9989003b,0xa3c90439}},	//   _ক্যা, _abdi_, _znaš_, ैरह_, 
   {{0xab620186,0x645885da,0xe9d88ad0,0x7d044278}},	//   _çünk, _olvi, скі_, ctis, 
   {{0x3ae38214,0x1ec9ad85,0x7ff5803d,0xd8dc0eee}},	//   yıp_, алки_, زستا, נקור, 
   {{0x8fa2a819,0xaad7802a,0xb87b0149,0x70b50034}},	//   маше, _भौंक, nríq, ंदुल, 
   {{0x245b83e9,0x44234279,0x6447427a,0x6e22c27b}},	//   _même_, _haj_, _hoji, _caob, 
   {{0x4423427c,0x64470025,0x628ba051,0x1fa61e57}},	//   _kaj_, _koji, mogo, _खण्ड, 
   {{0x628bc27d,0xdb1c116b,0x69db8120,0x3d098787}},	//   logo, _verö, _heue, _वहीं_, 
   {{0xeb99c27e,0x68e40533,0x6490036d,0xbb4595fd}},	//   рин_, _svid, päiv, ценк, 
   {{0x4423427f,0x64474280,0x7bde4281,0x7bc1c282}},	//   _laj_, _loji, zapu, sclu, 
   {{0x7bde2fb0,0xe820800d,0x229c8170,0xa3a92d9f}},	//   yapu, _यसमा_, níka_, खेत_, 
   {{0x44234283,0x9f5800ef,0x6e228b9f,0x60c99e0d}},	//   _naj_, lgré_, _zaob, _mtem, 
   {{0xe29a1c92,0xa7aa4284,0x61e99ca4,0xf1b98bfc}},	//   _как_, рква_, _odel, _našo_, 
   {{0x69db835b,0x61e9803d,0x7bde175e,0x6e2429de}},	//   _neue, _ndel, wapu, udib, 
   {{0x64470259,0x7bde2712,0x0eb6000f,0x628bc285}},	// [2b40] _boji, tapu, _आंकड, dogo, 
   {{0x76598324,0x44234286,0x61e9c287,0x64474288}},	//   _llwy, _caj_, _adel, _coji, 
   {{0xb724007b,0x7c238741,0x8fa60c98,0xe73a4289}},	//   _عکسه, _manr, _фане, _тен_, 
   {{0x2018428a,0x7afd8066,0x212000e5,0x6b7a80c6}},	//   leri_, ństw, _ksih_, ברענ, 
   {{0x4423428b,0x64a6428c,0x00868741,0x69c284e0}},	//   _faj_, _мама, олдо, rcoe, 
   {{0x6e22aaf4,0x2018428d,0xab2a21f3,0x2912022d}},	//   _saob, neri_, _кога_, _mpya_, 
   {{0xf8bf8a44,0x6609a1d1,0x68e2c28e,0x628b8385}},	//   _één_, ffek, ssod, bogo, 
   {{0x442301ea,0x7bdc428f,0x68e2c290,0xe3b88180}},	//   _zaj_, _heru, psod, rdım_, 
   {{0x7bdc04c4,0x7c23c291,0xd3789190,0x442301c8}},	//   _keru, _banr, daća_, _yaj_, 
   {{0x2018003b,0xddc40f91,0x344a98dc,0x4423006c}},	//   jeri_, jniž, рчин_, _xaj_, 
   {{0x7bdc1b4e,0x6e228b10,0x64900008,0x61e9806d}},	//   _meru, _taob, läis, _ydel, 
   {{0xbebc8029,0xf1b1810c,0x7bdc4292,0xbddb0035}},	//   _brīv, ुँचन, _leru, _poèm, 
   {{0xe5348db1,0x2906c293,0x6490019b,0xddcd01d2}},	//   _хель, ntoa_, näis, chař, 
   {{0x201821fc,0x7c23811a,0xe3af8019,0x270e808a}},	//   geri_, _ganr, عری_, _gənc_, 
   {{0x466b4294,0x6abc00e5,0x64474295,0xcddb09d9}},	//   арам_, _nurf, _roji, иња_, 
   {{0x44234296,0x64900008,0x7bdc4297,0x7c23817c}},	//   _saj_, käis, _aeru, _zanr, 
   {{0x7bdc4298,0x20184299,0x4423429a,0x628b8524}},	// [2b50] _beru, beri_, _paj_, vogo, 
   {{0xb5fd803b,0x2018429b,0x7bdc429c,0x69dbc29d}},	//   lišt, ceri_, _ceru, _seue, 
   {{0x442301ea,0x60c9880c,0x7bdc429e,0x6447429f}},	//   _vaj_, _stem, _deru, _voji, 
   {{0x61fd23ca,0xf1b9807e,0xb87b02fd,0x78bb87d7}},	//   ngsl, _vašo_, juíz, _puuv, 
   {{0x44230025,0x3ea9036d,0x61fd42a0,0x64470103}},	//   _taj_, mmat_, igsl, _toji, 
   {{0x7bdc0461,0x3ea93610,0x44b4009f,0xb5fd807e}},	//   _geru, lmat_, _обяс, hišt, 
   {{0x7bc542a1,0xa2ab85c9,0x69db81ed,0x645d89b8}},	//   mchu, जगद्, _teue, ësim, 
   {{0xee399e5a,0xe9df87e9,0xb5fd9144,0x9a84855a}},	//   сни_, _þú_, jišt, _жуул, 
   {{0x195881bc,0x7bdc42a2,0x1c0b000d,0x1a68803d}},	//   _даты_, _yeru, स्थल_, _بینی_, 
   {{0x200100fd,0x75298068,0x7bc542a3,0x98a9011b}},	//   _nchi_, rvez, nchu, _brač_, 
   {{0xf989015c,0x3ea91a28,0x7c23c2a4,0x260c122f}},	//   _ער_, kmat_, _vanr, ड्डी_, 
   {{0xc86904fc,0x98a90f63,0x67218183,0x20183142}},	//   _גן_, _drač_, _islj, weri_, 
   {{0x201842a5,0x3ea90b14,0xd3788131,0x7c238646}},	//   teri_, dmat_, raća_, _tanr, 
   {{0x3940819b,0xb5fd8ba7,0x2a7f83d0,0x64901615}},	//   äisi_, rišu, _ljub_, häir, 
   {{0x2bd18365,0x7bdc1264,0x201842a6,0x43758273}},	//   _द्या, _reru, reri_, _מײַן_, 
   {{0x7bdc088a,0x3ea90287,0x98a008dc,0xb5fd8183}},	//   _seru, gmat_, _orić_, cišt, 
   {{0x7bdc42a7,0x959a0320,0x201842a8,0x056639ee}},	// [2b60] _peru, ству_, peri_, чван, 
   {{0x14231450,0xf1bf02b6,0x69c60927,0xe9f90106}},	//   ндум, ndán_, lcke, _thả_, 
   {{0x7bdc42a9,0x2ba70503,0xdc9a80c6,0x68f981f0}},	//   _veru, केला, ציעל, euwd, 
   {{0x6490036d,0xb87b01e0,0x645e42aa,0xfc3f01e0}},	//   täis, xuíz, shpi, _xuíz_, 
   {{0x7bdc03bf,0xc5f30130,0xa9a6a9df,0x3a26800b}},	//   _teru, _אדר_, чидд, rdop_, 
   {{0x7bc52979,0xb5fd868b,0x2a7fb5a2,0x6e26020e}},	//   cchu, zišt, _ejub_, _hakb, 
   {{0x2906c2ab,0x64a342ac,0x63830251,0x98a00bbe}},	//   stoa_, _чара, _згра, _erić_, 
   {{0x444442ad,0xb86680dd,0xa534c2ae,0x649042af}},	//   lj_, _کارو, днич, päis, 
   {{0x444401ea,0xb5fdab22,0xfc3f161e,0x6e2642b0}},	//   oj_, višt, _ruíz_, _makb, 
   {{0x444442b1,0x3ea90004,0x3b54c1f4,0x61e2c2b2}},	//   nj_, zmat_, дкор, laol, 
   {{0x444401c8,0x443801b0,0xb5fd9144,0x04fe80b2}},	//   ij_, _mnr_, tišt, ্টের_, 
   {{0x6aa430d6,0x7f3b8039,0x20012573,0x61e2c2b3}},	//   _chif, _לעבו, _schi_, naol, 
   {{0xb5fd803b,0x32193cdb,0x444400f6,0x7bc542b4}},	//   rišt, resy_, kj_, ychu, 
   {{0x8c438675,0x042080b2,0xb5fd811b,0x61e281cb}},	//   _пече, বাহী_, sišt, haol, 
   {{0xb5fd801b,0xe9ff801c,0x61e2c2b5,0x6e2642b6}},	//   pišt, _loạn_, kaol, _bakb, 
   {{0x444442b7,0x7afac2b8,0x5f9442b9,0x6aa40481}},	//   ej_, mutt, хист, _ghif, 
   {{0x7bc50232,0x7afac2ba,0x628f01ac,0x28b700da}},	// [2b70] tchu, lutt, moco, _इंटि, 
   {{0x5ba70746,0x60cd42bb,0x628f0c65,0x7c289558}},	//   през, _itam, loco, nddr, 
   {{0xead9005a,0x7afaac94,0x7bc5041d,0x644a8027}},	//   імді_, nutt, rchu, _mofi, 
   {{0x44441123,0x7bc542bc,0x27e342bd,0x7ae500f8}},	//   aj_, schu, lajn_, rsht, 
   {{0xa95480f0,0x92b48061,0x08c4804a,0xf1b980ca}},	//   нкці, رحما, ебін, _hašk_, 
   {{0xf770840c,0x7afac2be,0x60cd1e0d,0xe0d085b6}},	//   گاه_, kutt, _mtam, ازن_, 
   {{0x9ea98002,0x69c600f9,0x16a98175,0x752d42bf}},	//   овка_, ycke, овки_, lvaz, 
   {{0x61ed42c0,0x7c2742c1,0x7afaa31d,0xa29480f0}},	//   _ndal, _hajr, dutt, _засі, 
   {{0x68e480fe,0x3e6a803d,0x60cd020d,0xa3a9001b}},	//   áidt, تجوی_, _ntam, खेर_, 
   {{0x61ed42c2,0x644ac2c3,0x6aa442c4,0x8b0780ac}},	//   _adal, _cofi, _shif, _naří, 
   {{0x60cd42c5,0x1c020b45,0x67218593,0x3ebe87c5}},	//   _atam, र्टल_, _uslj, _gutt_, 
   {{0x628f0065,0x60db8a39,0x68e99e89,0x76968610}},	//   goco, _kwum, _kved, rûyê, 
   {{0x752d029f,0x660d0919,0x98a48123,0xb5fb05e1}},	//   jvaz, dfak, _urmă_, _mlád, 
   {{0x764b8068,0x6e298cfd,0x7afa80e7,0x7c2742c6}},	//   _hogy, ldeb, butt, _najr, 
   {{0x628f0645,0x28dd8bb6,0x92e880fe,0xe1ff42c7}},	//   boco, नीति, _فريق_, giós_, 
   {{0x44279fa9,0x444401ea,0x644aa094,0x661b8553}},	//   _han_, wj_, _zofi, neuk, 
   {{0x44278d75,0x7c272859,0x644ac2c8,0xfce30008}},	// [2b80] _kan_, _bajr, _yofi, кото, 
   {{0x44441123,0xee3904bc,0x44278039,0x660d14c7}},	//   uj_, онӣ_, _jan_, afak, 
   {{0x4427c2c9,0x6e2642ca,0x7d09c2cb,0xe1ff41ca}},	//   _man_, _takb, htes, ciós_, 
   {{0x4427c2cc,0x8b07801b,0x7d09c2cd,0xe1ff00a1}},	//   _lan_, _zaří, ktes, chód_, 
   {{0x09e38482,0x4427812f,0xe3e380b2,0x61e2c2ce}},	//   точн, _oan_, _মানব, raol, 
   {{0x4427c2cf,0x645c04a5,0xdfcf80a7,0x64a61f43}},	//   _nan_, _ulri, ليه_, _цага, 
   {{0xc87f8093,0x63bc0a63,0x61e28036,0xeb971e07}},	//   îşan_, _igrn, paol, _жир_, 
   {{0x44279ed5,0x03a30a19,0x27e334d2,0x661b804f}},	//   _aan_, _рисо, zajn_, geuk, 
   {{0x4427c2d0,0x948695e6,0x628f1e52,0xe7cfbfe9}},	//   _ban_, дынд, voco, _स्वप, 
   {{0x4427c2d1,0x61e08172,0x69df008b,0x7afac2d2}},	//   _can_, _heml, _seqe, tutt, 
   {{0x4427c2d3,0x764b8019,0x68e98257,0x61e0c2d4}},	//   _dan_, _fogy, _zved, _keml, 
   {{0xc7b8c2d5,0x60c0c2d6,0x7afaadb6,0x4427c2d7}},	//   _nađi_, _kumm, rutt, _ean_, 
   {{0x27e30131,0xe8058ec1,0x69df01b2,0x7d0982e8}},	//   tajn_, _रामा_, _veqe, ctes, 
   {{0x4427c2d8,0xa3dfc2d9,0x60c0c2da,0x7afac2db}},	//   _gan_, तरण_, _mumm, putt, 
   {{0x764bc2dc,0x27e30208,0x69df01b2,0x2bdd0076}},	//   _yogy, rajn_, _teqe, यरसा, 
   {{0x61ed42dd,0x4427c2de,0x61e0856e,0xfe1480da}},	//   _udal, _zan_, _neml, _थॉमस_, 
   {{0x4427c2df,0x60c0c2e0,0x60cd3b3f,0xd7d001ff}},	// [2b90] _yan_, _numm, _utam, _त्वच, 
   {{0x201c803b,0x752d2f92,0x4427c2e1,0x69c980fa}},	//   jevi_, rvaz, _xan_, _sfee, 
   {{0xa3a90d99,0x68e9c2e2,0xc7d60052,0xd3711f3b}},	//   खें_, _sved, _אותי_, دها_, 
   {{0xa4d500f0,0x3a290161,0x5ba40123,0xd3a4068d}},	//   _помі, _jaap_, труз, труп, 
   {{0xb5fb003e,0xe6ed81ac,0x3a291e06,0xcce700fe}},	//   _vlád, _väčš, _maap_, _تسجي, 
   {{0x07a5839c,0x8fa58873,0xa1580309,0x78fc0309}},	//   налн, нале, ובדה_, קלופ, 
   {{0x4427c2e3,0x2eb59246,0x3eb91438,0x26c142e4}},	//   _ran_, нсис, _kist_, _juho_, 
   {{0x4427c2e5,0x6d258e29,0x7bca92ca,0x2d99019b}},	//   _san_, едиз, _affu, _kyse_, 
   {{0x68e9827b,0x6fca9137,0x3eb942e6,0xe5798008}},	//   _uved, _स्कू, _mist_, язи_, 
   {{0xf1b9c2e7,0x3eb942e8,0x201cc2e9,0x224dc2ea}},	//   _naši_, _list_, cevi_, _hoek_, 
   {{0x4427c2eb,0xe29a42ec,0x09ad00b2,0xdbdc81fb}},	//   _van_, зан_, _ক্লা, ráði, 
   {{0x4427859e,0x7bca812c,0xc3320080,0x61e081b2}},	//   _wan_, _effu, אוט_, _xeml, 
   {{0x3ead8f76,0xdb1c00f9,0xddc98029,0x4427b6b8}},	//   mmet_, _ifrå, cieš, _tan_, 
   {{0x3eadc2ed,0x4427c2ee,0x26c117ef,0x3eb90097}},	//   lmet_, _uan_, _buho_, _aist_, 
   {{0x3eb942ef,0x4ac690af,0x6a9600f0,0x66c782d2}},	//   _bist_, _रूपव, _приє, _yıka, 
   {{0xe9da0188,0x09da00b2,0xb5fb1ff9,0xe61f00e9}},	//   _эки_, _থাকা, _aláb, _skôr_, 
   {{0x61e642f0,0x33f60aa7,0x0d862286,0x3ead8394}},	// [2ba0] makl, ечес, хлан, imet_, 
   {{0x3eadc2f1,0x61e642f2,0x60c0c2f3,0xa3df9855}},	//   hmet_, lakl, _rumm, तरि_, 
   {{0x224d8b7e,0x09d780cf,0x60c0c2f4,0xb34682fd}},	//   _boek_, _হাজা, _summ, maçõ, 
   {{0x2cb80354,0x3ead80f8,0xb34683b8,0x224d8265}},	//   _wird_, jmet_, laçõ, _coek_, 
   {{0x645b0068,0x3eadc2f5,0x201cc2f6,0x601382d2}},	//   áció, dmet_, tevi_, kımı, 
   {{0xd6dac2f7,0xeee7007b,0x20c6001c,0xddc98bf3}},	//   пти_, _تغیی, _môi_, vieš, 
   {{0x03a30bd7,0x4c93031c,0x442a027e,0x53a3135a}},	//   _биро, _сиёс, _iab_, _барб, 
   {{0x963486a1,0x442a42f8,0x3eb901b2,0x60c0c2f9}},	//   тниц, _hab_, _xist_, _tumm, 
   {{0x06e08625,0x644e0066,0x61e61db5,0x442a42fa}},	//   _गौरव_, _kobi, dakl, _kab_, 
   {{0x224d863c,0x54549972,0xddc9c2fb,0x644e42fc}},	//   _zoek_, твот, rieš, _jobi, 
   {{0x442a42fd,0x7afe42fe,0x3ea6816c,0xb3468432}},	//   _mab_, nupt, _thot_, daçõ, 
   {{0x26c1068c,0xf1b98a63,0x2456007f,0x20c60106}},	//   _ruho_, _saši_, _dæmi_, _bôi_, 
   {{0x2bd1810c,0x7e64047f,0x26c142ff,0x442a02fd}},	//   _द्वा, dhip, _suho_, _oab_, 
   {{0x442a006c,0x644e3982,0x3eb9036a,0xb346c300}},	//   _nab_, _nobi, _sist_, gaçõ, 
   {{0xf1b9b52f,0x61f4010d,0x5f954301,0x443f012f}},	//   _vaši_, ådlö, тивт, _đu_, 
   {{0x78bac302,0x61e60214,0x3a293f91,0x439b8039}},	//   _litv, cakl, _uaap_, _מבוג, 
   {{0x442a4192,0x3eb94303,0x8d770f36,0x442c811a}},	// [2bb0] _bab_, _vist_, رارا, odd_, 
   {{0x442a2e7a,0x645ac304,0xb3468077,0xe8058c2e}},	//   _cab_, nkti, caçõ, _राधा_, 
   {{0x442a01ea,0x442cc305,0x443c8a63,0x2d9906a4}},	//   _dab_, idd_, _mnv_, _wyse_, 
   {{0x7e640889,0x59758188,0x7c2ac306,0x442a3cee}},	//   chip, кылу, _lafr, _eab_, 
   {{0x442a408b,0x6e3d01ed,0x26dec307,0x9980008d}},	//   _fab_, _insb, _awto_, _kaiš_, 
   {{0x644e1848,0xa3bc9032,0x442a4308,0x80d380b2}},	//   _gobi, _अलग_, _gab_, _সিদ্, 
   {{0x7d0d4309,0xddcd0123,0x81e705a2,0xdb1c0927}},	//   ltas, ciaţ, _পান_, _ngrè, 
   {{0xb34680b0,0x442c8360,0x3eb9c30a,0x443cc30b}},	//   zaçõ, edd_, öst_, _anv_, 
   {{0x2284c30c,0x3eadc30d,0x5187839c,0x442a430e}},	//   _сург, rmet_, _чува, _yab_, 
   {{0x09e100b2,0x3eadc30f,0x442a006c,0x7d0d4310}},	//   _ভাষা, smet_, _xab_, itas, 
   {{0x6fca800f,0x61e64311,0x601382bc,0x68ed4312}},	//   _स्टू, takl, rımı, _avad, 
   {{0x27e7c313,0x161128b3,0x799b80db,0x7d0d4314}},	//   lann_, _डॉलर_, _kyuw, ktas, 
   {{0xed4ea279,0x61e64315,0x6e2d0399,0xb3468077}},	//   _то_, rakl, ddab, taçõ, 
   {{0x27e78013,0x7d0d0142,0x38a40172,0x10a63aea}},	//   nann_, dtas, föra_, тигн, 
   {{0x442a4316,0x644e3e28,0xb3468077,0xdee32819}},	//   _rab_, _robi, raçõ, иори, 
   {{0x442a01ea,0x20c6010b,0x644e4317,0x27e7afe1}},	//   _sab_, _tôi_, _sobi, hann_, 
   {{0xd040808c,0x442a1123,0x6e2ba841,0x644e4318}},	// [2bc0] _etmə, _pab_, _magb, _pobi, 
   {{0x442a01ea,0x61e4275b,0xe3b888f1,0x3f9a099a}},	//   _qab_, _heil, mdır_, _typu_, 
   {{0x2c139855,0x442a4319,0xbddb3f2d,0x27e7c31a}},	//   त्यं_, _vab_, _poèt, dann_, 
   {{0x6aa9c31b,0x60c4260f,0x6e2ba841,0x7afe163e}},	//   _chef, _kuim, _nagb, rupt, 
   {{0x442a01ea,0x442ca196,0x644e431c,0x7d0d15b7}},	//   _tab_, ydd_, _tobi, ctas, 
   {{0xcee91ad1,0x9f47824a,0x27e7c31d,0x442a2469}},	//   _ترین_, manê_, gann_, _uab_, 
   {{0x8a06904e,0x9f4781b2,0xb8c9903a,0x7c2ac31e}},	//   _изве, lanê_, _गी_, _rafr, 
   {{0xfaa6c31f,0x66041598,0x61e44320,0x442c8324}},	//   _рабо, ngik, _neil, wdd_, 
   {{0xd378806a,0x27e7c321,0x47e180b2,0xa3d600ab}},	//   maći_, bann_, _নারী, _सभा_, 
   {{0x78ba8622,0xdb1c00ef,0x27e79b09,0x6b9c343a}},	//   _uitv, _agré, cann_, _kyrg, 
   {{0x6fd88758,0x442c8360,0x61e44322,0x9f4782a5}},	//   _न्यू, rdd_, _beil, hanê_, 
   {{0xd3788a5a,0x6f798273,0x6282c1ba,0x7d0d4323}},	//   naći_, _אָנג, nnoo, ytas, 
   {{0x61e44324,0x60c40b10,0x9403010c,0x6e20c325}},	//   _deil, _cuim, _लालच_, memb, 
   {{0x6e20c326,0x9f47824a,0xe5a3bd85,0xa2ca9646}},	//   lemb, danê_, _тичи, _संप्, 
   {{0x7e62c327,0x61e44328,0x260f871c,0x2003016c}},	//   _klop, _feil, थ्वी_, rgji_, 
   {{0x60c40728,0x7d0d06bc,0x61e44329,0x80d380b2}},	//   _fuim, ttas, _geil, _সিস্, 
   {{0xa5070008,0x39440172,0x7d00c32a,0x16df95ad}},	// [2bd0] ъявл, ämst_, nums, _नब्ब, 
   {{0x7d0d432b,0xbbdd0562,0x6e20c32c,0xd37b432d}},	//   rtas, यरेक, hemb, мче_, 
   {{0x27e7c32e,0xddc600a1,0x7e62813b,0x39468065}},	//   vann_, _dokł, _olop, exos_, 
   {{0x6e20c32f,0x7d00c330,0x27e7c331,0x628287d7}},	//   jemb, kums, wann_, gnoo, 
   {{0xe9d881e2,0x7d00c332,0x6e208371,0x27e7c333}},	//   ткі_, jums, demb, tann_, 
   {{0x6e2ba2ec,0xfa2380b2,0x6282892f,0xaa201239}},	//   _sagb, ফাইল_, anoo, _बस्छ_, 
   {{0x6e2b98bd,0x27e7c334,0x628281df,0x44214335}},	//   _pagb, rann_, bnoo, meh_, 
   {{0x44214336,0x27e7c337,0xddcd0029,0x05a70bb6}},	//   leh_, sann_, skaņ, _खराब, 
   {{0xe616804a,0x27e7c338,0x61e43818,0xf1b980f3}},	//   уды_, pann_, _reil, _pašu_, 
   {{0x44214339,0x60c40622,0xe9f9001c,0x61e42f89}},	//   neh_, _ruim, _thẻ_, _seil, 
   {{0x91e62af7,0x6e2bc33a,0x60c40d37,0xf1b9850d}},	//   лоне, _tagb, _suim, _vašu_, 
   {{0x4421433b,0xcd35842b,0x9f47824a,0x7f589164}},	//   heh_, _مرتب, yanê_, _шахс_, 
   {{0x61e4433c,0x645d8210,0x290f83ad,0x9f47816c}},	//   _veil, ësis, ntga_, kanë_, 
   {{0xe3b882bc,0x44211287,0x26c5c33d,0x9f4781b2}},	//   rdır_, jeh_, _kulo_, vanê_, 
   {{0x61e4433e,0x9f47c33f,0x91e38079,0x212900bf}},	//   _teil, wanê_, खराज_, _esah_, 
   {{0xa20610e9,0x9f47824a,0x26c5c340,0x75244341}},	//   _спид, tanê_, _mulo_, twiz, 
   {{0x0eb90bb1,0x96b909fc,0xe9f9001c,0x20760a09}},	// [2be0] туры_, туру_, _nhẹ_, _бунё, 
   {{0x6e20c342,0x29024343,0x9f47c344,0x75240e0b}},	//   zemb, muka_, ranê_, rwiz, 
   {{0x29024345,0xe1fa8a54,0x6e20c346,0xd37884c2}},	//   luka_, еге_, yemb, taći_, 
   {{0x1efb03dd,0x26d84347,0x1c1383ff,0xc986b2bc}},	//   _אלטע, mpro_, त्तल_, лули, 
   {{0x29024348,0x6282c349,0x4421434a,0xed573753}},	//   nuka_, rnoo, beh_, _боя_, 
   {{0x3cf98066,0xb87b00b0,0x3ea0434b,0x66c787fa}},	//   ोंने_, ssív, llit_, _tıkl, 
   {{0x26c5c34c,0xe8162c79,0x29020861,0xb8eb94a0}},	//   _culo_, द्या_, huka_, _रू_, 
   {{0x7c2e05da,0x368790ea,0xe3c10a08,0x4ea68a48}},	//   _habr, лсын_, ğış_, ырла, 
   {{0x6e20b136,0x5986c34d,0x634a8816,0x7c2e434e}},	//   remb, _слаб, məni, _kabr, 
   {{0x634a808a,0x7ea58019,0x3e7a80f3,0x7c2e434f}},	//   ləni, rópa, tīts_, _jabr, 
   {{0x7d00c350,0x7c2e1cd8,0x6e208232,0x3ea04351}},	//   sums, _mabr, pemb, klit_, 
   {{0x7c2e4352,0xfce6c353,0xa29508cf,0x2902100d}},	//   _labr, _бодо, рамі, fuka_, 
   {{0x6e93864d,0xf1b98269,0x44214354,0x667b80c6}},	//   _النا, _hašr_, yeh_, _אטאק, 
   {{0x36d50f5e,0xe1ff033b,0x6d46819b,0x5334873f}},	//   иогр, chón_, äkau, _вект, 
   {{0xe7f7950f,0x395f0bf3,0x442e8172,0x2bda801b}},	//   ीलता_, šus_, _iaf_, _म्या, 
   {{0x9f459f13,0x3ea04355,0x44210c02,0x442ec356}},	//   _belê_, glit_, weh_, _haf_, 
   {{0x3cee0066,0x21294357,0x4421174c,0xf8bf02c0}},	// [2bf0] ेंगे_, _usah_, teh_, rvés_, 
   {{0x442ec358,0x225d982d,0x35b4401d,0xb5fb0530}},	//   _jaf_, wkwk_, сбур, _glán, 
   {{0x2baa0365,0x9f4780f8,0x442104a6,0x442ec359}},	//   _करणा, ranë_, reh_, _maf_, 
   {{0x44211663,0x60cd9a5a,0x27e588dc,0x644806e0}},	//   seh_, íamo, _seln_, _òdin, 
   {{0x7c2e435a,0x9f45c35b,0x4421435c,0x6145b4ff}},	//   _fabr, _gelê_, peh_, рела, 
   {{0x7c2e1981,0x46f5c35d,0x442ec35e,0x3f9e826b}},	//   _gabr, ачит, _naf_, _bytu_, 
   {{0xf77193fb,0x36698e21,0xe7e6009b,0x29021887}},	//   غات_, како_, करता_, zuka_, 
   {{0xee39c35f,0x7c2e16ce,0xbb840013,0x7c21c360}},	//   тни_, _zabr, _الفي, welr, 
   {{0xddc3804a,0x81eb00b2,0x656d4361,0x9f43001b}},	//   _құпи, মলা_, nzah, dají_, 
   {{0x9f6b8021,0xd3788885,0x26c5c362,0x9f47c363}},	//   _през_, haću_, _tulo_, hané_, 
   {{0x9f47c363,0x290201d5,0x6aad0064,0x68fd000b}},	//   kané_, wuka_, _bhaf, ersd, 
   {{0x61eb8c6e,0x6f0398c5,0x6aad4364,0x29024365}},	//   nagl, munc, _chaf, tuka_, 
   {{0x9f47c366,0xb5fb003e,0x6f03a383,0x8c45c367}},	//   dané_, _plán, lunc, _веле, 
   {{0x29024368,0x442ec369,0x05a880f0,0x61eb952c}},	//   ruka_, _gaf_, _свій_, hagl, 
   {{0x66e6436a,0xfaa6223d,0x2902305a,0x7c2e0a63}},	//   роба, _како, suka_, _rabr, 
   {{0x442ec36b,0xdbdf012b,0x7afcc36c,0x7e7b80e5}},	//   _zaf_, _síðu, árte, niup, 
  
   {{0x6d5b81c8,0x7c2e2383,0x3ea0007f,0x69c414b2}},	// [2c00] nyua, _pabr, rlit_, _igie, 
   {{0xa7fc82bc,0x6f03c36d,0x3ea0436e,0x2baa02f4}},	//   _alın, kunc, slit_, _करदा, 
   {{0x6287003e,0x9f47c36f,0xf7460ca0,0x6d5b80db}},	//   čkov, bané_, _тено, hyua, 
   {{0xeb972be0,0x2c640172,0x62864167,0x6f038c0e}},	//   ших_, _döda_, nnko, dunc, 
   {{0xd826899f,0x7bc38086,0x7c2e4370,0xb17d80e9}},	//   идди, _ognu, _tabr, _deťo, 
   {{0x7d0441c2,0xa073836a,0x6f03c371,0xceb4008a}},	//   muis, огіч, func, lmə_, 
   {{0x7d044372,0x53aa06d7,0xa2ca8964,0x6f03c373}},	//   luis, _करिश, _संध्, gunc, 
   {{0xa2cb09fe,0xd1768188,0x6289816c,0x2bd211a6}},	//   _तंत्, _кызы, _gjeo, दुरा, 
   {{0x9f43001b,0x7d044374,0x6d5b81df,0xbebc81a8}},	//   vají_, nuis, gyua, _krīz, 
   {{0x9f47c375,0x442eb01e,0x62864376,0xb806803d}},	//   manî_, _qaf_, enko, _خبره, 
   {{0xe9f90028,0x6f03c377,0x9f47c378,0x7d044379}},	//   _chế_, cunc, yané_, huis, 
   {{0xc3330052,0x7e698889,0x7d04437a,0x442ec37b}},	//   קור_, chep, kuis, _waf_, 
   {{0x9f47c37c,0x442e977f,0x7d04437d,0x61f60324}},	//   vané_, _taf_, juis, _ddyl, 
   {{0x786201ac,0x0377804e,0x7d04437e,0x251b8080}},	//   _dôvo, احیت_, duis, _סווא, 
   {{0xe8160365,0x9f47c37f,0xb4c0000d,0xf0b400f0}},	//   द्धा_, tané_, ँदै_, ійсь, 
   {{0x798d1123,0x9f478093,0x2c640172,0x5f943ccf}},	//   _txaw, kanî_, _röda_, цист, 
   {{0x7d044380,0x764d1dca,0x9f47c381,0xd90482e5}},	// [2c10] guis, rjay, rané_, _تی_, 
   {{0xe8160795,0x9f47c382,0xea00001c,0x98650068}},	//   द्दा_, sané_, _trải_, _ایسے_, 
   {{0x61ebc383,0x9f47c363,0x5b153823,0x656d01ab}},	//   tagl, pané_, смет, szah, 
   {{0x09bb00cf,0x7d0402fb,0xe8f580fe,0xdddb8269}},	//   _অ্যা, buis, مستخ, knuš, 
   {{0x3cfe0066,0xe1f8805a,0x8d840c5c,0x200c8a39}},	//   _लिये_, ргі_, _дурд, _bcdi_, 
   {{0x2bcb02d4,0x6f038ba7,0xf1bf0063,0x6d5b81df}},	//   _шумо_, tunc, ldás_, vyua, 
   {{0xda359878,0x61eb8318,0x7e6982a6,0xb5fb0396}},	//   _левы, pagl, thep, _llám, 
   {{0x44314384,0x64550004,0x7ea5811e,0x9f478610}},	//   _haz_, _hozi, rópo, banî_, 
   {{0xee36827a,0x44314385,0x95998241,0x2aff0056}},	//   сны_, _kaz_, ытку_, शंकु_, 
   {{0x44310ecf,0x3c65836d,0xb465836d,0x629982ee}},	//   _jaz_, ског, скол, lowo, 
   {{0x61e98073,0x6d5bc386,0x7e69c387,0x2012808a}},	//   _keel, syua, phep, əyi_, 
   {{0x645531f3,0x99808038,0x786201ac,0x201a00bf}},	//   _lozi, žiť_, _pôvo, _sbpi_, 
   {{0x61e98073,0xf6528039,0x61e4a4e0,0xd5489351}},	//   _meel, _מצא_, ðili, _نجوم_, 
   {{0xe9f9010b,0x1c030689,0x753680c6,0x64554388}},	//   _thế_, _लागल_, _לאנד_, _nozi, 
   {{0x4425c389,0x6443c38a,0xa1c4005a,0x9f478610}},	//   mel_, _inni, _мұнд, zanî_, 
   {{0x9f47824a,0x61e9c38b,0x9f458410,0x7d040e79}},	//   yanî_, _neel, _celé_, tuis, 
   {{0x6299c38c,0x4431438d,0x64550284,0x75298a44}},	// [2c20] dowo, _baz_, _bozi, nwez, 
   {{0x64550077,0x4431438e,0x9f4781b2,0x22920170}},	//   _cozi, _caz_, vanî_, váky_, 
   {{0x645500d7,0x61e9c38f,0x291f8008,0xddcb8034}},	//   _dozi, _beel, _apua_, _mogł, 
   {{0x7529ba76,0x4425c390,0x7d0433b3,0x9f478093}},	//   kwez, hel_, puis, tanî_, 
   {{0x4425c391,0x60c19bbd,0x44314392,0x61e98b7e}},	//   kel_, _bilm, _faz_, _deel, 
   {{0xd2598029,0xbb460bc6,0x9f47824a,0xd90d80dd}},	//   _viņa_, _легк, ranî_, ئیل_, 
   {{0xe80e8e78,0x60c1aa3d,0x0dc88a09,0xf1bf00e9}},	//   _साठा_, _dilm, қуқи_, ndár_, 
   {{0x442582b5,0x61e9af6c,0x629980a1,0x6609c393}},	//   eel_, _geel, cowo, ggek, 
   {{0x4425c394,0x8966a824,0x443103d2,0x64550004}},	//   fel_, _укаж, _yaz_, _yozi, 
   {{0xddc28f6a,0x4425c395,0x61e9c396,0x26c24397}},	//   _umož, gel_, _zeel, _liko_, 
   {{0xfd0f80dd,0xb4db0741,0xf743c398,0x212003d9}},	//   وجی_, _gràf, _нефо, _apih_, 
   {{0x32670e48,0x6443c399,0x212000db,0x466980f0}},	//   стов, _enni, _bpih_, _крім_, 
   {{0x4bc4855a,0x4425c39a,0x60c1c39b,0xb5fb011e}},	//   _мөнг, bel_, _yilm, _imáx, 
   {{0x4425c39c,0x26c2439d,0x27ee81c2,0x588702c3}},	//   cel_, _aiko_, nafn_, сыма, 
   {{0x44313e28,0x27ff0186,0xeac9801c,0x6455439e}},	//   _raz_, ğun_, _hẹn_, _rozi, 
   {{0x6455439f,0x26c20269,0x4431024a,0xea00001c}},	//   _sozi, _ciko_, _saz_, _trại_, 
   {{0x54553348,0x44311151,0xdc5510f3,0x26c202b1}},	// [2c30] оват, _paz_, овањ, _diko_, 
   {{0xe78743a0,0x2a69027e,0x4431008a,0x61e9c3a1}},	//   _гумо, _hlab_, _qaz_, _seel, 
   {{0x64551943,0x61e9c3a2,0x94a80574,0x50d40068}},	//   _vozi, _peel, стта_, _وزیر, 
   {{0x4425c3a3,0x60c1844f,0x61ef43a4,0x26c20e0b}},	//   zel_, _silm, nacl, _giko_, 
   {{0x6299c3a5,0x60c985cb,0x44311d01,0xe3e800cf}},	//   rowo, _quem, _taz_, _পারব, 
   {{0x212d8bfc,0x60c18004,0x2a690103,0x81e180b2}},	//   _vseh_, _qilm, _llab_, _দাও_, 
   {{0x4425c3a6,0x2bdf1b71,0x786b07fa,0xb8d08758}},	//   vel_, _प्या, _güve, _टी_, 
   {{0x442585d3,0xbec6804a,0x0f7c0039,0x8265847f}},	//   wel_, іңіз_, טרול, _بهرن, 
   {{0x60c18022,0x4425c3a7,0x61ef011e,0x6609b8fe}},	//   _tilm, tel_, dacl, rgek, 
   {{0x66099636,0x2a69209d,0x212b011a,0xec798fbe}},	//   sgek, _alab_, dwch_, рпо_, 
   {{0x2dd5ba66,0x4425c3a8,0x7e6d1455,0x2a6900ca}},	//   _джер, rel_, khap, _blab_, 
   {{0x4425c3a9,0x753d0068,0xd6ab85b6,0xee2e8103}},	//   sel_, _orsz, _صدام_, _ўн_, 
   {{0xa4f78267,0x7e6d033f,0x212b043a,0x2d8a8093}},	//   _اکبر_, dhap, gwch_, şber_, 
   {{0x6443807f,0x8c458a63,0x4425c3aa,0x26c243ab}},	//   _unni, _феке, qel_, _siko_, 
   {{0x81ea80b2,0x18a343ac,0x1fb543ad,0xe81b8076}},	//   _মাস_, фарм, зстр, प्या_, 
   {{0x00ca43ae,0x2a69013b,0x8afc8034,0xf1bf011e}},	//   _клик_, _glab_, rzęt, meán_, 
   {{0x63a38324,0xec7a1ac8,0xf1bf00fe,0x1bea04bc}},	// [2c40] _hynn, апа_, leán_, идаи_, 
   {{0x0c2343af,0x63a3c3b0,0x67218024,0x3e6702f4}},	//   ммун, _kynn, _oplj, _võta_, 
   {{0x49ca9c10,0x26c243b1,0xeac9801c,0x7e6d0927}},	//   ален_, _tiko_, _mẹo_, bhap, 
   {{0x7e6d43b2,0xe81600c9,0x09e38077,0x63a3c3b3}},	//   chap, द्रा_, доцн, _mynn, 
   {{0xdfd495c2,0x2ba68353,0xb4db0064,0xb5fd8033}},	//   полы, _ऑर्थ, _cràd, chši, 
   {{0x6e360116,0x3a2680db,0x29068027,0x00000000}},	//   ldyb, seop_, ruoa_, --, 
   {{0xed508019,0x3e6ac3b4,0x29068129,0x42d60a4f}},	//   کھا_, ишин_, suoa_, _фігу, 
   {{0x6e36205e,0x63ae0269,0x67220269,0xf1bf00fe}},	//   ndyb, _izbn, _ćojl, deán_, 
   {{0xceb304fc,0xddc280a1,0xd00a84c7,0xd25980f3}},	//   ויה_, _umoż, _везе_, _ziņo_, 
   {{0x31e3009b,0x09e30d6d,0x0bf3a43a,0x3374c3b5}},	//   पर्ध, पर्य, мпью, згор, 
   {{0x2a693930,0x63a38360,0x61ef43b6,0x20d0801c}},	//   _plab_, _cynn, tacl, _hài_, 
   {{0x61e2c3b7,0xb5fb03d5,0x212b011a,0x63b58170}},	//   nbol, _vlák, twch_, ýzna, 
   {{0xa2ca85d9,0x26ccc3b8,0x17e200b2,0x61ef43b9}},	//   _सूर्, _hudo_, _বাড়ি, racl, 
   {{0x80dd00cf,0x26cc816c,0x212b011a,0x61ef02fb}},	//   _বিদ্, _kudo_, rwch_, sacl, 
   {{0x63a38360,0x8f34407c,0x61e2c3ba,0x7e6d02a6}},	//   _gynn, мерц, kbol, thap, 
   {{0xfb8780df,0x6458c3bb,0xa1951935,0x60dd2216}},	//   _بدهی, _hovi, _найч, ppsm, 
   {{0x9f479ee3,0x61e28142,0x6458c3bc,0x7e6d43bd}},	// [2c50] vaní_, dbol, _kovi, rhap, 
   {{0x97154269,0x6458839f,0x61ed13e7,0x7e6d43be}},	//   _емоц, _jovi, _heal, shap, 
   {{0xd49801c6,0x6458c3bf,0x7e6d43c0,0x8c2580cf}},	//   іру_, _movi, phap, বাচন_, 
   {{0x20d08147,0x56951177,0x7c28c3c1,0x6458c3c2}},	//   _bài_, _хамт, hedr, _lovi, 
   {{0xdd86830b,0x20d08028,0xcfbd00b2,0x9f47826b}},	//   _أو_, _cài_, _অভিন, raní_, 
   {{0x20d08028,0x60cd0103,0x61ed43c3,0x629d43c4}},	//   _dài_, _muam, _leal, hoso, 
   {{0x61e2c3c5,0x26cc8215,0xdb0385e1,0x752d43c6}},	//   bbol, _cudo_, _ozná, lwaz, 
   {{0x2902018a,0x26cc8217,0x7c3543c7,0x69db1671}},	//   yrka_, _dudo_, _hazr, ñuel, 
   {{0x7c289799,0xd840026b,0x63a3c3c8,0xb5fb00fe}},	//   fedr, íčky_, _synn, _clái, 
   {{0x7c28889c,0x26ccc3c9,0x60dbc3ca,0xf1bf00d8}},	//   gedr, _fudo_, _itum, teán_, 
   {{0x61ed1895,0xeb99825c,0x628b95f3,0x7c3543cb}},	//   _beal, син_, ongo, _mazr, 
   {{0x628b8504,0x213f89bb,0xf1bf00fe,0x61ed0b24}},	//   nngo, _kruh_, reán_, _ceal, 
   {{0x7c28c3cc,0xf1bf00fe,0x752d118e,0x20d08106}},	//   bedr, seán_, jwaz, _xài_, 
   {{0x60db8801,0x7d09c3cd,0x653a80c6,0x7c3543ce}},	//   _mtum, mues, _לענד, _nazr, 
   {{0x61ed43cf,0xbbaa07b0,0x7d09c3d0,0xf74343d1}},	//   _feal, _करेक, lues, неро, 
   {{0x64472896,0xc6c31b17,0x61ed0089,0x644680f3}},	//   _anji, ейск, _geal, ēkie, 
   {{0x2bd2a1ab,0xf1bf00fe,0x60cd00f6,0x7d09816c}},	// [2c60] _सलमा, neál_, _guam, nues, 
   {{0x39400069,0x7e6443d2,0xeb9a0188,0x673e061c}},	//   _iris_, skip, биз_, _trpj, 
   {{0xe805abe8,0x6d4b0172,0xf8b30039,0x20d0801c}},	//   _राजा_, ägar, _רשת_, _sài_, 
   {{0x394043d3,0x644743d4,0xf53f0af6,0x765980a1}},	//   _kris_, _enji, _frå_, _nowy, 
   {{0xf53f01a3,0x7c3500bf,0x463b00c6,0x7d09816c}},	//   _grå_, _fazr, _העכע, jues, 
   {{0xb8f4a527,0x26cc85cb,0x61e2c3d5,0x20d0801c}},	//   _सं_, _pudo_, sbol, _vài_, 
   {{0x7c28c3d6,0xd6d7a909,0x7522b748,0x91e6c3d7}},	//   vedr, пты_, _spoz, _нове, 
   {{0x20d0810b,0x80dd00cf,0xfaa380f0,0x394043d8}},	//   _tài_, _বিস্, _засо, _oris_, 
   {{0x6458c3d9,0x2ab20019,0x7d09c3da,0x394001df}},	//   _povi, kább_, gues, _nris_, 
   {{0x26cc80b0,0x7d0443db,0xf0448267,0x6282c3dc}},	//   _tudo_, iris, _تعری, lioo, 
   {{0xdee3998a,0x60cd025f,0x61ed0689,0xe61a8f9b}},	//   _зохи, _suam, _peal, _где_, 
   {{0x7d0443dd,0xe81f054d,0x7c28c3de,0xaf4980fe}},	//   kris, म्ना_, sedr, _بشكل_, 
   {{0x752d059e,0x68e9859e,0x629d43df,0x8c4692b0}},	//   xwaz, _xwed, roso, _неде, 
   {{0x629d43e0,0x7d0443e1,0x61e00083,0x80e185a2}},	//   soso, dris, ımla, _নিম্, 
   {{0xda0d823b,0x25afc3e2,0x60c502f4,0x61ed43e3}},	//   _हालत_, _zzgl_, _vihm, _teal, 
   {{0x443f07fa,0x752d43e4,0x7d0443e5,0x7c350284}},	//   _şu_, twaz, fris, _sazr, 
   {{0xe7cc807a,0x224901ac,0x660d43e6,0xba3b0d2e}},	// [2c70] ाशाप, _inak_, rgak, roïd, 
   {{0x628b811a,0x291901df,0x752d43e7,0xb4db277f}},	//   wngo, mtsa_, rwaz, _aràc, 
   {{0xaac70c93,0x7d0429d2,0x290b315c,0x752d3210}},	//   ستان, aris, luca_, swaz, 
   {{0xe3b00013,0x7d180013,0x68e98318,0x37e680b2}},	//   ارك_, éasá, _pwed, _নাগর, 
   {{0x6e29c3e8,0x9f47826b,0x29190870,0x20d300c9}},	//   veeb, daná_, ntsa_, _धूमध, 
   {{0x3ea943e9,0xf9940273,0x8fa5832a,0xc7a580f0}},	//   llat_, ערס_, мале, милк, 
   {{0xe80e83f0,0xb8f48ec1,0x12c780b2,0x7659c3ea}},	//   _सारा_, _सू_, _শব্দ, _powy, 
   {{0xd877840c,0xb4db0188,0x7d0980f8,0x645cc3eb}},	//   _کارب, _gràc, tues, örin, 
   {{0x60dbc3ec,0x63a7016c,0x61e4833b,0x290b43ed}},	//   _utum, _hyjn, ñile, juca_, 
   {{0x22491424,0x7d0980f8,0x2a6dc3ee,0x7870019b}},	//   _anak_, rues, _hleb_, _käve, 
   {{0x6ee7c3ef,0x2ab20068,0x7d0980f8,0xa22a43f0}},	//   _رسال, vább_, sues, ожна_, 
   {{0x394023ca,0x7d09929b,0x38a402ae,0x7d04007f}},	//   _pris_, pues, hört_, yris, 
   {{0x7d09c3f1,0x3ea943f2,0x66c782d2,0xbbaa0bf9}},	//   ques, dlat_, _fıkr, _कर्क, 
   {{0x80dd0a87,0x224943f3,0x638585e9,0xcb6982f0}},	//   _বিশ্, _enak_, _огла, _мале_, 
   {{0x07a30a4b,0xc7951878,0xb8d50073,0xe29f007f}},	//   варн, ерты, _छी_, boð_, 
   {{0xe1ff1f49,0xecea1655,0x38a401c2,0xe05800df}},	//   lkón_, ждал_, vöru_, _کیست_, 
   {{0x32d38028,0x14c8007b,0xe80e81aa,0xbea343f4}},	// [2c80] _hãy_, سهای_, _साला_, татк, 
   {{0x26cc139c,0xe72a0692,0xa2e60656,0x81ea85a2}},	//   ídos_, _доод_, дожд, _মাই_, 
   {{0x3ea93afd,0xb4db00a6,0x98a9068c,0x3e7a81a8}},	//   blat_, _pràc, _građ_, sūti_, 
   {{0x41aa8fe7,0xb5fb0a5b,0x7d041bb1,0x224900f6}},	//   овен_, _sláv, pris, _xnak_, 
   {{0x9f47803e,0x20d4041a,0xb5fb43f5,0x62828079}},	//   vaná_, _jäi_, _cláu, rioo, 
   {{0xd6da847b,0x62828073,0xbddb068e,0x2a6d82ef}},	//   оти_, sioo, _anèh, _eleb_, 
   {{0x443843f6,0xdca31d9a,0x9f47c3f7,0x645c43f8}},	//   _iar_, _рари, taná_, _iori, 
   {{0x44380926,0x645c43f9,0xa3c39137,0x1d3488f9}},	//   _har_, _hori, ्शन_, ения, 
   {{0x645c003b,0x443843fa,0x64c896a6,0x9f47c3fb}},	//   _kori, _kar_, रदेश, raná_, 
   {{0x645c43fc,0x628081df,0x6aa443fd,0x68e29659}},	//   _jori, _hmmo, _akif, mpod, 
   {{0x645c43fe,0xd37a80f0,0x44381bb1,0xda0a0625}},	//   _mori, ючи_, _mar_, वलंत_, 
   {{0xaacf8561,0x443843ff,0x6ab60324,0x05668012}},	//   _संरक, _lar_, _chyf, _овен, 
   {{0x3ea90daa,0xa2ca800c,0x7c3e811e,0x8d73ba91}},	//   vlat_, _संक्, _ópro, _لاوا, 
   {{0x645c1d27,0x44384400,0xb9072f5f,0xdbf30a08}},	//   _nori, _nar_, _पऽ_, _işçi, 
   {{0xc0580612,0x442cc401,0x67d40188,0x25ad20c9}},	//   фія_, med_, тосу, _šel_, 
   {{0x442cc402,0x7c38c403,0x645c00de,0x3ea94404}},	//   led_, _havr, _aori, ulat_, 
   {{0x645c28a5,0x442c811a,0x44380309,0x7c3882d2}},	// [2c90] _bori, oed_, _bar_, _kavr, 
   {{0x6280c405,0x645c4406,0x3ea9001b,0x44381251}},	//   _ammo, _cori, slat_, _car_, 
   {{0x44384407,0x645c4408,0x2a6d81df,0x7c38c409}},	//   _dar_, _dori, _pleb_, _mavr, 
   {{0x23df0f0a,0x442cc40a,0x68ed440b,0xdd140038}},	//   _प्रद, hed_, _kwad, _súťa, 
   {{0x6025a47b,0x645c37f1,0x26de8086,0x6d448116}},	//   едла, _fori, _atto_, _šian, 
   {{0x3e71803e,0x442cc40c,0x7d0d0111,0x4438440d}},	//   _máte_, jed_, muas, _gar_, 
   {{0x442c804d,0x7d0d41af,0x8fa2c40e,0x6d42c40f}},	//   ded_, luas, лаше, _aroa, 
   {{0x4438003b,0xbb48007b,0x9f45826b,0x645c0109}},	//   _zar_, _تلفن_, _celá_, _zori, 
   {{0x44384410,0xddc2a988,0x38b6072c,0x442cc411}},	//   _yar_, _ploš, lære_, fed_, 
   {{0xe4518013,0x765d4412,0x6aa40255,0x645c0103}},	//   اضة_, _losy, _skif, _xori, 
   {{0x7c3897f8,0xe2860c27,0x6d42c413,0x09c80dcf}},	//   _davr, елни, _eroa, रख्य, 
   {{0x7d0d05b5,0x644ac414,0xdb1e81d2,0x68ed4415}},	//   kuas, _enfi, áván, _bwad, 
   {{0x764b8068,0x4423252e,0x6d428123,0x442cc416}},	//   _ingy, _obj_, _groa, bed_, 
   {{0x60c88816,0x2bdf030a,0x442cb051,0xa06a4417}},	//   _xidm, _प्ला, ced_, чага_, 
   {{0x645c4418,0x7c2380f6,0x765d068e,0x68ed4419}},	//   _rori, _ibnr, _bosy, _ewad, 
   {{0x7c38829f,0x998d0131,0x4438441a,0x7ea58226}},	//   _zavr, žeš_, _sar_, cópt, 
   {{0x4438441b,0xeb1f80d5,0x6286441c,0x645c441d}},	// [2ca0] _par_, _बहुत_, miko, _pori, 
   {{0x6286441e,0x69dbc41f,0x7d1b8008,0x645c03ad}},	//   liko, _afue, itus, _qori, 
   {{0x44384420,0xb5fb4421,0x645c4422,0x9f4300e9}},	//   _var_, _clás, _vori, zajú_, 
   {{0xe2979a91,0xfce604c3,0x62864423,0x442cc424}},	//   нах_, _помо, niko, zed_, 
   {{0x44384425,0xa9678dc7,0x2167839c,0x645c4426}},	//   _tar_, ница_, ници_, _tori, 
   {{0x9f4301ac,0x62864427,0xdfcf80fe,0x29068109}},	//   vajú_, hiko, ميه_, rroa_, 
   {{0x62864428,0xab271046,0x442c8052,0x6e398009}},	//   kiko, _пора_, ved_, _bawb, 
   {{0x7c38803b,0xb65b0273,0x6d42c429,0x442cc42a}},	//   _savr, ִדיש, _proa, wed_, 
   {{0x442c804d,0xb5fb442b,0x2dd780fe,0x6e39834e}},	//   ted_, _klár, ربية_, _dawb, 
   {{0x6aa280d0,0x99808116,0x9f4300e9,0x764bc42c}},	//   loof, žių_, rajú_, _engy, 
   {{0x442cc42d,0x6286442e,0x141b00c6,0x68ed442f}},	//   red_, fiko, הויב, _swad, 
   {{0x442cc430,0x62864431,0x2bd29016,0xed5a974b}},	//   sed_, giko, _सलवा, _ное_, 
   {{0x58d4031c,0x2418804a,0xac188188,0x442c8039}},	//   лоят, _жолы_, _жолу_, ped_, 
   {{0x765d4432,0xd25980f3,0x7413803d,0x6aa29a5f}},	//   _sosy, _viņi_, _موها, hoof, 
   {{0x5334b144,0x62861c0a,0xc90d801b,0x36d54433}},	//   _рейт, biko, _सम्म_, тобр, 
   {{0x68ed4434,0x7d0d1338,0x7bce0128,0x7bdc4435}},	//   _twad, tuas, _agbu, _afru, 
   {{0x6e2d1f07,0xe59802c3,0x569402c3,0x9f4a0da7}},	// [2cb0] reab, екті_, уатт, rabá_, 
   {{0xb5fb030b,0xb4ab000f,0x7bdac436,0x6e2d0685}},	//   _clár, खते_, nctu, seab, 
   {{0x68fb8024,0x9f4c81b2,0x229c8170,0xf99009dc}},	//   _svud, _sedî_, líky_, _نبی_, 
   {{0x7d0d0111,0x636b8063,0x61cb99d7,0x21290106}},	//   puas, lönö, िशेष, _kpah_, 
   {{0x229c83d5,0x7d0d0036,0x865a025e,0xe0d887c5}},	//   níky_, quas, _חדרי, еві_, 
   {{0x38b625a1,0x1ae685a2,0x7afaafd6,0x644306b0}},	//   pære_, _কিনে_, kstt, ônid, 
   {{0x201a8741,0x62864437,0xd00e80d8,0xdb1506e4}},	//   òpia_, yiko, زلي_, _egzò, 
   {{0x62864438,0x7c238645,0x7d1bc439,0x21290481}},	//   xiko, _sbnr, ttus, _opah_, 
   {{0xee36827a,0x44ef24cd,0x26d30bdf,0x58d580f0}},	//   тны_, nż_, _luxo_, _розт, 
   {{0x446588be,0x2bb80439,0x58d48aff,0x290fc43a}},	//   твов, _अरमा, _софт, muga_, 
   {{0xe29a236a,0x7d1ba608,0x6286443b,0xfbd20052}},	//   дан_, stus, tiko, יתי_, 
   {{0x7ea5c43c,0x225f86e0,0x2001443d,0xa3b90d64}},	//   róps, _jouk_, _adhi_, _चरन_, 
   {{0x6286443e,0x3eadc43f,0xa56480fe,0x2dc78103}},	//   riko, mlet_, _مدون, _яқин_, 
   {{0x3ea093a5,0x26d3011e,0x291d804f,0x9f5101b2}},	//   čite_, _buxo_, itwa_, razî_, 
   {{0x44ef0066,0x8fa64440,0x26d301e0,0x07a63ced}},	//   eż_, таве, _cuxo_, тавн, 
   {{0x7bdc4441,0x7aed80a1,0x26cb17a2,0x291d86e0}},	//   _sfru, _łatw, _cico_, ktwa_, 
   {{0xc5f28464,0x7d09c442,0x26cb4443,0x21760dbe}},	// [2cc0] ידן_, nres, _dico_, _шукр, 
   {{0xb4db4444,0x3eadc445,0x69c2001b,0x1f660ad3}},	//   _tràn, hlet_, रेणी, _аком, 
   {{0x3eadc446,0x26cb330d,0x7d0981ed,0x78a3c447}},	//   klet_, _fico_, hres, donv, 
   {{0x7d09c448,0x5186bcea,0x290f8371,0x6d448116}},	//   kres, кула, fuga_, _šiam, 
   {{0xfe750a48,0xc05a80f0,0x6aa2c449,0x78a3c44a}},	//   _сүт_, дій_, roof, fonv, 
   {{0x7afc2628,0xa3c39379,0x7d09c44b,0x80e180b2}},	//   _tvrt, ्शा_, dres, _নিশ্, 
   {{0x7c3c0b3a,0x644e444c,0xb4c000a1,0x3eadc44d}},	//   _iarr, _inbi, ुदी_, flet_, 
   {{0x80e18a87,0x7d09c44e,0x290f81d5,0x6d460265}},	//   _নির্, fres, buga_, _krka, 
   {{0x7c3c444f,0x7d099c7d,0x291d8034,0x08c6c450}},	//   _karr, gres, ctwa_, _абан, 
   {{0x7c3c00b4,0x225fc451,0x6d46008d,0x25e280da}},	//   _jarr, _zouk_, _mrka, _ट्री_, 
   {{0x7c3c43bd,0xd7a98d64,0xd25102e5,0x3ead8e80}},	//   _marr, _चुपच, مند_, blet_, 
   {{0x7c3c0124,0x7d09a1d3,0x6d464452,0x9e6695d8}},	//   _larr, bres, _orka, _швед, 
   {{0x9553803d,0xa2d40353,0x51844453,0x316d033b}},	//   _نخوا, _बूस्, аура, áez_, 
   {{0x588715e6,0x26d301e0,0x8cd6010c,0x9f5801b2}},	//   тыма, _puxo_, _बढ़ो, marê_, 
   {{0x54338604,0x26cb0207,0x443c827e,0xd25980f3}},	//   _ضرور, _pico_, _iav_, _ziņu_, 
   {{0x443ec454,0x443cc08b,0x3cfe000f,0x644e4455}},	//   ldt_, _hav_, _लिखे_, _anbi, 
   {{0x80dd00cf,0x443c81c8,0x349509b2,0x27f821d1}},	// [2cd0] _বিক্, _kav_, гаар, barn_, 
   {{0x443ec456,0x7c3c393a,0x290f859d,0x443cb84e}},	//   ndt_, _carr, vuga_, _jav_, 
   {{0x7c3c0188,0x443cc457,0x6d464458,0x3e71807f}},	//   _darr, _mav_, _erka, _láta_, 
   {{0x443cc459,0x7c3c0b10,0x99848116,0x69dd0019}},	//   _lav_, _earr, _namų_, ncse, 
   {{0x9f58024a,0x7c3c445a,0x3eadc45b,0xe8df8106}},	//   jarê_, _farr, vlet_, _trọn_, 
   {{0x443cc45c,0x7c3c1643,0x3ead81b2,0x9f580093}},	//   _nav_, _garr, wlet_, darê_, 
   {{0x28da09ca,0x6e3d03ad,0x6d4600e9,0x291dc45d}},	//   _यूनि, _kasb, _zrka, stwa_, 
   {{0x443e80fa,0x7e6d445e,0x3ebfc45f,0x7c3c4460}},	//   edt_, nkap, umut_, _zarr, 
   {{0x22848bd7,0x3ebfc461,0xacc98004,0x6e3d4462}},	//   _тург, rmut_, нгиз_, _masb, 
   {{0x443c806c,0x3eadc463,0x3e71c464,0x649d80a6}},	//   _cav_, slet_, _dáta_, nèix, 
   {{0x443c81c8,0x4615902a,0x7e6d4465,0x27f84466}},	//   _dav_, _موار, kkap, varn_, 
   {{0x7d09c3bf,0x3f7a8273,0x6e3d4467,0xe0c900c6}},	//   pres, _אָדע, _nasb, _זײ_, 
   {{0x32368273,0x81ac00b2,0x321e0034,0x443e811e}},	//   נטשן_, কেন_, ęty_, bdt_, 
   {{0x4095189e,0x443cc468,0x81ea80b2,0xe73a019b}},	//   арст, _gav_, _মাছ_, нег_, 
   {{0xd62a2a6b,0x6e3d3d9d,0xdc9a8080,0x61f9896d}},	//   нове_, _basb, _איסל, kawl, 
   {{0x7e6d4469,0x7c3c446a,0x442780bf,0x6aa9808d}},	//   gkap, _sarr, _hbn_, _nkef, 
   {{0x0c261a72,0x26c0446b,0x443c81c8,0xa507446c}},	// [2ce0] лман, rmio_, _yav_, лета_, 
   {{0x443c9123,0x7c3c0519,0xb46310be,0x786f83cd}},	//   _xav_, _qarr, бкул, _søvn, 
   {{0x7c3e446d,0x61f61c03,0xa3b903ff,0x7c3c446e}},	//   rdpr, _keyl, _चरण_, _varr, 
   {{0x2ca5c46f,0x6d460934,0x9f5801b2,0x998d80a1}},	//   hold_, _trka, yarê_, _oceń_, 
   {{0x7c3c4470,0x64430077,0x6abb8064,0x442780d4}},	//   _tarr, ônic, _dhuf, _obn_, 
   {{0x61f6038e,0x4427a1d6,0x3e7180d8,0x60d6013b}},	//   _leyl, _nbn_, _ráta_, _muym, 
   {{0x6d444471,0x9f584472,0x3ea4c473,0xbddb055a}},	//   lvia, darë_, tomt_, _inèr, 
   {{0xa3b9007a,0x7ae302b6,0x443cc474,0xfaa6c475}},	//   _चरत_, ínte, _sav_, _сабо, 
   {{0x5c74a0f2,0x6143c476,0x443cc477,0x6d4400a6}},	//   илит, _лета, _pav_, nvia, 
   {{0xd5c08611,0x290b00d7,0x19b99a91,0x3ea4872c}},	//   शेषज, vrca_, _русь_, somt_, 
   {{0x443ec478,0x26d882a5,0x5fa4007a,0x68e44479}},	//   rdt_, _îro_, _खुलल, _atid, 
   {{0x201a0199,0x673a9190,0x61f60d7c,0xd7f8812f}},	//   _acpi_, _istj, _ceyl, _xoăn_, 
   {{0x443cc47a,0x6d4401ac,0x2ca5c47b,0x6c548077}},	//   _tav_, jvia, bold_, _вклу, 
   {{0x443cc47c,0x6d3b8039,0x9f4780e9,0xb8fd447d}},	//   _uav_, _נתונ, vanú_, _तं_, 
   {{0xb4c08e5e,0xb4c2802a,0x99990019,0x68e406e0}},	//   ंगी_, ्दी_, reső_, _etid, 
   {{0x58d50021,0xe80e89ca,0x6e3d037f,0x4ea700a6}},	//   _коит, _साझा_, _qasb, урга, 
   {{0xb4db0741,0xb804920d,0x260a03f0,0x6e3d447e}},	// [2cf0] _tràm, रणाम_, िलजी_, _vasb, 
   {{0x7e6d447f,0x78700172,0x9ed90cc5,0x673a82f4}},	//   skap, _jävl, _имот_, _ostj, 
   {{0x6e3d00f6,0xe7eb009b,0x649d80a6,0xd4984480}},	//   _tasb, _ज्या_, rèix, урт_, 
   {{0x39494481,0x61f602d1,0xb4c2c482,0xbddb055a}},	//   _kras_, _xeyl, ्दु_, _enèr, 
   {{0x61f9be2b,0x38bb81b2,0x673a808b,0xc5fa0309}},	//   rawl, hêre_, _astj, _בפרט, 
   {{0x2166b4e6,0x1bd40bbb,0x7d0d4483,0xa3d44484}},	//   риши_, _горя, mras, _горч, 
   {{0x6fcc80da,0x38bb81b2,0x2ca59120,0x9f5809b8}},	//   ाशगं, jêre_, vold_, varë_, 
   {{0x39493125,0x7e628603,0x2ca5c485,0x9f4c8da7}},	//   _oras_, _coop, wold_, _sedã_, 
   {{0x7ae48025,0xb4c299b2,0x9f5800f8,0x7d0d4486}},	//   _čita, ्दू_, tarë_, nras, 
   {{0x3ea080d7,0x4b25c487,0x4c85c488,0x0325c489}},	//   čita_, амов, рлов, адон, 
   {{0xeb99c48a,0x68e40053,0x39490481,0x7d0d0004}},	//   тин_, _stid, _aras_, hras, 
   {{0x80dd0a87,0xfaa62917,0x61460e71,0x628b843a}},	//   _বিজ্, рамо, аема, nigo, 
   {{0xe297448b,0x9f58448c,0x201a03b9,0x61e9011e}},	//   рая_, maré_, _pcpi_, ñela, 
   {{0x7d0d448d,0x78700172,0xd4668b6f,0x7e62c48e}},	//   dras, _gävl, _више_, _zoop, 
   {{0xb8fd15ef,0xe7e50bda,0x39490e22,0xe8172347}},	//   _तू_, कड़ा_, _eras_, _तारा_, 
   {{0xddc91862,0x7e62808b,0x63ae06fd,0xc7a30077}},	//   _šošt, _xoop, _rybn, циск, 
   {{0x7d0d448f,0xac8604ea,0x291f81df,0x39490fe3}},	// [2d00] gras, агал, _nqua_, _gras_, 
   {{0xd12f00dd,0x26cfc490,0x0eb8009b,0x55c502c3}},	//   _کمی_, _ligo_, _आठवड, сауғ, 
   {{0x2bab85b7,0x2abc8e7c,0x7d0d4491,0xdddd0019}},	//   _घुमा, híbe_, aras, _első, 
   {{0x9f4c826b,0x9f580217,0x644180db,0x6da607c5}},	//   _nedá_, jaré_, hdli, _вима, 
   {{0x44e9852f,0x7d0d1efa,0x22404492,0x290083b8}},	//   _nº_, cras, _maik_, éia_, 
   {{0x20184493,0x26cf82fa,0x40349664,0x37069e07}},	//   ngri_, _aigo_, секс, ачив, 
   {{0x7e62c494,0x26cfc495,0x628bc496,0x291f82fb}},	//   _poop, _bigo_, bigo, _equa_, 
   {{0x224016f8,0x644182ae,0xeb9700f0,0x26cf8854}},	//   _naik_, edli, _тис_, _cigo_, 
   {{0x26cf939c,0xd5b789ba,0x61ed86c9,0xf8bf0429}},	//   _digo_, ись_, ñale, ltée_, 
   {{0xb4c08066,0xdd94805a,0x8c66c497,0x5346c498}},	//   ंगे_, _қалы, ртид, ахма, 
   {{0x22401b4e,0x22520a00,0x3e750172,0x39468116}},	//   _baik_, _bnyk_, _låta_, lvos_, 
   {{0xc5f080cf,0xbd87842b,0x39494499,0x1bf283b4}},	//   _টাকা_, انین_, _pras_, _आजकल_, 
   {{0x787000f9,0xcd368267,0x224000bf,0x39468065}},	//   _tävl, _خراب, _daik_, nvos_, 
   {{0x83f8a5c5,0x27fc83cd,0xe9df449a,0x7d0d449b}},	//   _секс_, navn_, scú_, vras, 
   {{0x1cbb8273,0x443332b8,0x06fd81d2,0x2240449c}},	//   _שמוע, vex_, žívá_, _faik_, 
   {{0x39490422,0x27fc8f4a,0xaa2d019b,0x2c190076}},	//   _tras_, havn_, ämää_, _पाहू_, 
   {{0xddc40284,0x61fd03ad,0x6aad38d1,0x61ef00bf}},	// [2d10] tkiš, masl, _ikaf, mbcl, 
   {{0xe1ff0034,0xc3cb00d8,0x61fd10a3,0xeaca012f}},	//   tków_, نظام_, lasl, _hẹp_, 
   {{0x4433449d,0x628b8ed0,0x389c09be,0x1da7449e}},	//   rex_, tigo, _ביזנ, _कुरत, 
   {{0x7d0d449f,0xde5908cf,0xa3e68f5a,0xdb1c033b}},	//   pras, _самі_, युत_, _agró, 
   {{0x394982ba,0x0dcb00b0,0x3ce6822a,0x26cfc4a0}},	//   ías_, _јуни_, _ntov_, _rigo_, 
   {{0x26cfc4a1,0xb4c2801b,0xb4c09231,0x656d013b}},	//   _sigo_, ्दो_, ंगो_, myah, 
   {{0xb4c283ce,0x656d0660,0x43940014,0x61fd0124}},	//   ्दै_, lyah, _дарс, kasl, 
   {{0xee39c4a2,0x9a8489b2,0x9f58024a,0x51878103}},	//   уни_, _дуул, karî_, _куза, 
   {{0x26cf8818,0x656d44a3,0xc485a8d9,0x88078c72}},	//   _vigo_, nyah, йлик, _نظام, 
   {{0x7d028533,0x3e7181ac,0x6aad2b7b,0x9f5844a4}},	//   _dvos, _táto_, _akaf, darî_, 
   {{0x42ca01e5,0x644189e5,0x44258129,0x224044a5}},	//   лгон_, rdli, rfl_, _paik_, 
   {{0xc869096e,0x2721af9c,0x6f1544a6,0x2d7f8034}},	//   _אן_, món_, duzc, _płeć_, 
   {{0x272188cd,0xa5098605,0x2c6980e9,0xeaca012f}},	//   lón_, _села_, _súdu_, _dẹp_, 
   {{0x656d013b,0x645cc4a7,0xb4db0540,0xafe303ad}},	//   dyah, örit, _grài, зорл, 
   {{0x27218659,0xdee60a90,0x66e644a8,0x224000f6}},	//   nón_, соби, соба, _taik_, 
   {{0x442a44a9,0x61fd0f63,0xaad006d7,0x9f580093}},	//   _sbb_, casl, _सूचक, barî_, 
   {{0xed570a19,0x442a44aa,0x2721c4ab,0x69d60063}},	// [2d20] бот_, _pbb_, hón_, _igye, 
   {{0x98a90116,0x6289804f,0xa3ab8880,0x2721c4ac}},	//   _ypač_, _ameo, कअप_, kón_, 
   {{0x290244ad,0x2721c4ae,0xf8bf0035,0x7e7b8531}},	//   lska_, jón_, utée_, khup, 
   {{0x27218ca9,0x786b008a,0xd9fa03ff,0xf8bf00ef}},	//   dón_, _qüvv, ्णित_, rtée_, 
   {{0x186a8daa,0x195880b6,0xa06ac4af,0xceb4008a}},	//   лади_, ралы_, лада_, mlə_, 
   {{0xfce344b0,0x2721c464,0x290244b1,0x7644008a}},	//   _хоро, fón_, iska_, ldiy, 
   {{0x6d4b8124,0x272182ba,0x3946c4b2,0x444444b3}},	//   _arga, gón_, svos_, md_, 
   {{0x764444b4,0x22968013,0x3ea0803a,0x9f58024a}},	//   ndiy, _الرس, čito_, yarî_, 
   {{0x752444b5,0x2d8044b6,0x444438b2,0xf8b8824f}},	//   ntiz, nzie_, od_, _көк_, 
   {{0xd6d288a0,0xb865b19c,0x2902029f,0x61e28086}},	//   _فقط_, _والو, dska_, lcol, 
   {{0x6d4bc4b7,0x27218dd4,0xceb4008a,0xae208d64}},	//   _erga, cón_, klə_, _यापन_, 
   {{0x6d4481e2,0x44443fc1,0x9c8701d2,0x6d898019}},	//   _šiau, hd_, _kočá, امیہ_, 
   {{0x0c73807b,0xd041808a,0x61e40065,0x05a700da}},	//   زدید, _ailə, _dfil, _कुंब, 
   {{0x2d800d99,0x69d6011d,0xd041808c,0x4444063c}},	//   dzie_, _egye, _bilə, jd_, 
   {{0x44442196,0x1bfb8052,0x93fb8115,0xaae68743}},	//   dd_, _גלוב, _גלוי, _استو, 
   {{0x44442ad0,0xa19514b2,0x5f94029e,0x656d058d}},	//   ed_, _майч, чист, tyah, 
   {{0x27218422,0x9257031c,0x9f47826b,0x44440a44}},	// [2d30] zón_, _вақт_, daný_, fd_, 
   {{0x444444b8,0x656d44b9,0x80dc80a1,0xd37b0fe7}},	//   gd_, ryah, _पढ़े, лче_, 
   {{0x272181e0,0x45d52d2d,0x656d44ba,0x57b2004a}},	//   xón_, _монс, syah, _жұрт, 
   {{0x444444bb,0x7ae485c3,0x656d17b9,0x2721816f}},	//   ad_, _čitl, pyah, vón_, 
   {{0xae1a0273,0xd5a689dc,0x444402fa,0x248a040a}},	//   _דורכ, _آف_, bd_, _fmbm_, 
   {{0xd7fbc4bc,0x2721995a,0x26da004f,0x628f04ab}},	//   ууд_, tón_, _yupo_, hico, 
   {{0x645544bd,0x3209028b,0x628f44be,0x7e7b9455}},	//   _inzi, _oday_, kico, thup, 
   {{0x272188d3,0x628f0524,0x61e28cff,0x62898ca2}},	//   rón_, jico, ccol, _umeo, 
   {{0x2721995a,0xb5fb44bf,0xada2a47e,0x644502a8}},	//   són_, _bláz, маъл, odhi, 
   {{0x644544c0,0x27218530,0x61fb822c,0x61e444c1}},	//   ndhi, pón_, _heul, _sfil, 
   {{0xe82009d7,0x628f139c,0x76440816,0x68f60360}},	//   _बाबा_, fico, ydiy, _swyd, 
   {{0x29020131,0x60db9f30,0x628f44c2,0x26da03fd}},	//   tska_, _kuum, gico, _rupo_, 
   {{0x61fb8385,0x787004bb,0xddc2c4c3,0x26da0217}},	//   _meul, _hävi, _zlož, _supo_, 
   {{0x60dbc4c4,0x61fb8120,0x38b6006d,0x7870019b}},	//   _muum, _leul, mærk_, _kävi, 
   {{0x61e295b7,0xe73a2f0a,0xceb4008a,0x6d49c4c5}},	//   ycol, шев_, tlə_, lvea, 
   {{0x6443c4c6,0x645544c7,0x752444c8,0xee3a09d9}},	//   _hani, _anzi, ttiz, јна_, 
   {{0x6443c4c9,0x9f478a93,0xa3c383ca,0x76440816}},	// [2d40] _kani, vaný_, ्शक_, rdiy, 
   {{0x629986a4,0x3e788cc7,0xa3bd8439,0x444440f2}},	//   enwo, _méta_, _आरा_, ud_, 
   {{0x673e0310,0x752444ca,0x61fbbc9d,0xe9dac4cb}},	//   _uspj, stiz, _beul, аке_, 
   {{0x444444cc,0x645513f4,0x6443c4cd,0x61fb8120}},	//   sd_, _enzi, _lani, _ceul, 
   {{0x81ac00cf,0x61e2c4ce,0x2c7b859e,0x394dc4cf}},	//   কের_, rcol, _zêde_, _cres_, 
   {{0x6443c4d0,0x61e29931,0xb902aceb,0xd90d803d}},	//   _nani, scol, _नं_, ایل_, 
   {{0x394d97e4,0x25e1007a,0xe3a781a1,0xdfcf80fe}},	//   _eres_, _कलमी_, _آر_, نيه_, 
   {{0xddc298d4,0x628f4146,0x61fb9fe1,0x394019fc}},	//   _vlož, xico, _geul, _osis_, 
   {{0x7d0444d1,0x6443c4d2,0xd49ac147,0x261b8056}},	//   nsis, _bani, иро_, _यारी_, 
   {{0x6443c4d3,0x7d0444d4,0x2246c4d5,0xe46a9c36}},	//   _cani, isis, ldok_, ршил_, 
   {{0xddc28802,0x628f08b3,0x39400162,0x9f5c8507}},	//   _ulož, tico, _asis_, kavé_, 
   {{0x2246b0ae,0x7d0444d6,0xd3778116,0x0dcac4d7}},	//   ndok_, ksis, ючы_, _кули_, 
   {{0x628f44d8,0x2126825f,0x6443c4d9,0x66008645}},	//   rico, ntoh_, _fani, mamk, 
   {{0x628f273a,0x6443c4da,0xfbcf82e5,0x95f515ad}},	//   sico, _gani, عتی_, ेण्ट_, 
   {{0x368b44db,0x628f44dc,0x6f188103,0x81ac00b2}},	//   асан_, pico, nuvc, কেল_, 
   {{0xcb138c2d,0x44e08246,0x6600843c,0x7c2e44dd}},	//   _חלק_, _kò_, namk, _abbr, 
   {{0xd9048a0e,0x7d0402b7,0x95cb032a,0x3940013b}},	// [2d50] _جی_, gsis, рува_, _gsis_, 
   {{0x44e0c4de,0x61fb82c0,0x6443ad04,0x66009663}},	//   _mò_, _seul, _xani, hamk, 
   {{0x44e0c4df,0x68e99476,0x291944e0,0x3e7180fe}},	//   _lò_, _sted, lusa_, _fáth_, 
   {{0x9f45803e,0x6600a4bd,0x7c2e29ef,0xb4db0540}},	//   _celý_, jamk, _ebbr, _bràt, 
   {{0x2919022c,0x66008a00,0x2a6944e1,0x44e08401}},	//   nusa_, damk, _moab_, _nò_, 
   {{0x64554032,0xbca500fe,0x68e980e9,0x38b6006d}},	//   _unzi, _رمزي, _vted, værk_, 
   {{0xf7718743,0x6443829f,0x2cac8324,0x61fbc4e2}},	//   عات_, _rani, dodd_, _teul, 
   {{0x394daa41,0x44e0c4e3,0xe1ff812b,0x29190896}},	//   _tres_, _bò_, _þó_, kusa_, 
   {{0x6443c4e4,0x44e0a33f,0x798280a1,0x2cac8324}},	//   _pani, _cò_, czow, fodd_, 
   {{0x629d44e5,0xc48283dc,0x291918a2,0x6443a4a8}},	//   éron, ельк, dusa_, _qani, 
   {{0xf1a9015c,0x22920116,0xa3ab95ad,0x324644e6}},	//   _עס_, eška_, _कुश_, пенг, 
   {{0x64439f8e,0xe29a44e7,0x44e086e0,0x394002fa}},	//   _wani, сам_, _fò_, _psis_, 
   {{0x6443c4e8,0x2eaa811d,0xbbb8000d,0x5ed280b2}},	//   _tani, _اپنی_, _अर्क, _সবচে, 
   {{0xf09f4042,0x628d040a,0x26c24472,0xb87b00e9}},	//   dràs_, _emao, _shko_, dpís, 
   {{0xa06a005a,0x1fb5255d,0xeb969346,0x38ca0019}},	//   _ғана_, дстр, _ниш_, لاڑی_, 
   {{0x3940150d,0x3e6e007f,0x7d0444e9,0x6d4f344b}},	//   _tsis_, _nýtt_, tsis, _brca, 
   {{0x2919360e,0x320200de,0x9f5c8170,0xed5744ea}},	// [2d60] cusa_, maky_, ravé_, пот_, 
   {{0x7d0444eb,0xf5070b99,0x3d13a910,0x320244ec}},	//   rsis, янул_, _दिने_, laky_, 
   {{0x9f45c4ed,0x2baf002a,0x7ae497a2,0x9f478507}},	//   _meló_, _जुदा, _čitk, ybná_, 
   {{0x32022519,0x81ac00b2,0xfaa3c4ee,0xf8bf44ef}},	//   naky_, কেঃ_, нахо, ntén_, 
   {{0x2fda00bf,0x6d4f00ca,0x9f58075d,0xb4db0c9f}},	//   _kgpg_, _grca, larà_, _dràs, 
   {{0x6f188004,0x38b6007f,0x79828034,0x44e0c4f0}},	//   tuvc, færi_, rzow, _rò_, 
   {{0x44e0c4f1,0xa3ab80ab,0x9f580741,0x6600c4f2}},	//   _sò_, _कुल_, narà_, tamk, 
   {{0x443a44f3,0x44e0c4f4,0x6f188004,0x32020170}},	//   lep_, _pò_, ruvc, jaky_, 
   {{0xa3c9800c,0x764644f5,0x9f5a03df,0x1dbe1129}},	//   लेस_, _maky, _depé_, ्धित, 
   {{0x628d0b10,0x443a44f6,0xa3e68353,0x2292007e}},	//   _smao, nep_, युं_, vška_, 
   {{0x59a510c7,0xd25102e5,0x200c811a,0x44e0817c}},	//   _गुजर, نند_, _iddi_, _wò_, 
   {{0x443a03fd,0x9f580741,0x7646012c,0x44e0c4f7}},	//   hep_, darà_, _naky, _tò_, 
   {{0x443a44f8,0xc05b00f0,0x442ec4f9,0x41c70034}},	//   kep_, бів_, _tbf_, रेंस, 
   {{0x291944fa,0x443a02cf,0xdd3b8039,0x764600ed}},	//   rusa_, jep_, _לעדכ, _aaky, 
   {{0xb5fd84e1,0x64588cff,0x443a44fb,0x3ae18028}},	//   ljša, _invi, dep_, _góp_, 
   {{0x291944fc,0xfbb78052,0x81ac00b2,0x26deae71}},	//   pusa_, _מפות_, কেই_, _muto_, 
   {{0x2d58036d,0x26dec4fd,0xa5bb011e,0xb5fd807e}},	// [2d70] пить_, _luto_, _abór, njša, 
   {{0x443a01db,0x6448c4fe,0x9f580741,0xf09f075d}},	//   gep_, nddi, barà_, rràs_, 
   {{0x200344ff,0x9f580741,0x6448811a,0x290680bc}},	//   maji_, carà_, iddi, esoa_, 
   {{0x7c3a8573,0x2ea80365,0x6d4f029f,0x63b5026b}},	//   hetr, ककृत, _trca, _vyzn, 
   {{0xa0698479,0x7c3ac500,0x9f581a5a,0x6d4f0166}},	//   жала_, ketr, mará_, _urca, 
   {{0x26dec501,0x443a4502,0x9f582091,0x660b80e5}},	//   _buto_, cep_, lará_, _sdgk, 
   {{0xa6c987ae,0x6d428065,0x44230766,0x6d4d1fd9}},	//   олка_, _asoa, _icj_, lvaa, 
   {{0x9f582091,0x24e9b84f,0x442c81f0,0xa3c2812e}},	//   nará_, омии_, efd_, ्धन_, 
   {{0x64470dc6,0x6d4d2cb0,0x20034503,0x200c811e}},	//   _kaji, nvaa, kaji_, _fddi_, 
   {{0x7c3a953f,0x64470284,0x20030010,0xd90d8019}},	//   getr, _jaji, jaji_, _میچ_, 
   {{0x64474504,0x2909036d,0xe8171d4a,0x68ed305a}},	//   _maji, _avaa_, _ताजा_, _atad, 
   {{0x6458c505,0x64474506,0xdd8e8267,0x9f584507}},	//   _envi, _laji, اوی_, jará_, 
   {{0xda1f153a,0x764617bc,0xe8f71339,0x9f582cbe}},	//   _भारत_, _raky, мля_, dará_, 
   {{0x64470cf6,0xf8bf3220,0x9f580741,0x20034508}},	//   _naji, stén_, tarà_, gaji_, 
   {{0x4aad807a,0xa3c985b1,0x68ed0004,0xdca2c509}},	//   टकाव, लेश_, _etad, _шаши, 
   {{0x9f580a7c,0x7649c50a,0x4423017c,0x61ed811e}},	//   gará_, ndey, _acj_, ñall, 
   {{0x443a44f8,0x7529b616,0xdb0e001b,0x9f580741}},	// [2d80] tep_, ntez, _vybí, sarà_, 
   {{0x64472203,0x69db9334,0x7e7d0097,0xe73a10f3}},	//   _caji, _ague, _elsp, _део_, 
   {{0x443a450b,0xaec614b9,0x7646450c,0x9f581a5a}},	//   rep_, _обол, _taky, bará_, 
   {{0x9f580b0f,0x443a450d,0xe297a5b7,0x2906c50e}},	//   cará_, sep_, мах_, tsoa_, 
   {{0x6448a196,0xd130842b,0x76499afc,0x660416c9}},	//   yddi, امت_, ddey, maik, 
   {{0x6604450f,0x29068659,0xd6ea8b29,0x6447298e}},	//   laik, rsoa_, офил_, _gaji, 
   {{0x2906c510,0x7bdc4511,0xdfd080d8,0x7c3ac512}},	//   ssoa_, _igru, ديث_, vetr, 
   {{0x66044513,0x2003022d,0x667b00c6,0xc956836d}},	//   naik, zaji_, ַװיג, _отзы, 
   {{0x9f5e80f8,0x6f1c3e71,0xe1238a09,0x2d848284}},	//   _ketë_, hurc, _имти, uzme_, 
   {{0x9f5e8210,0x9f584514,0x3e78800d,0x26de801b}},	//   _jetë_, zará_, _této_, _tuto_, 
   {{0xd62ab957,0x6448c515,0x66044516,0xa3c98076}},	//   _може_, rddi, kaik, लेल_, 
   {{0x7c3ac517,0x6f1c02ae,0x62829fd9,0x2003004f}},	//   setr, durc, nhoo, waji_, 
   {{0x941e023b,0x20034518,0x7c3a852a,0x9f582cbe}},	//   _पांच_, taji_, petr, vará_, 
   {{0xddcd1146,0x58d40a90,0x656f81ed,0x7bdc003d}},	//   jkaš, коят, äche, _ngru, 
   {{0x9f58139c,0x26c6c519,0xe8202ceb,0xb4ca8076}},	//   tará_, _khoo_, _बारा_, लगी_, 
   {{0x4ea41972,0x64471a76,0x7bdc3119,0x66041335}},	//   вруа, _saji, _agru, gaik, 
   {{0x9f582106,0xdd9401bc,0xa5bb011e,0x6447016c}},	// [2d90] rará_, ваты, _ecón, _paji, 
   {{0x31560052,0x6d4d451a,0x9f582cbe,0x3e71807f}},	//   _ניתן_, rvaa, sará_, _hátt_, 
   {{0x6604451b,0x9f582891,0xf8bf0077,0xa5bb00fe}},	//   baik, pará_, ntém_, _gcón, 
   {{0xb4ca8503,0xfd5e8106,0x387e8036,0x6d4d093c}},	//   लगु_, _quyể, _altr_, pvaa, 
   {{0x224901d9,0xc6160052,0x50b581bc,0x801807f1}},	//   _maak_, _אחרי_, нску, _عزیز_, 
   {{0x26d9451c,0x68e0c51d,0x2b4309b2,0x7d1b8656}},	//   _hiso_, _dumd, _tsjc_, vuus, 
   {{0xfd5e8028,0x7afc011a,0x38b603cd,0x9f5c8507}},	//   _tuyể, _gwrt, mært_, baví_, 
   {{0x26c6c51e,0x06098e08,0x7d1b82ee,0x6282c51f}},	//   _choo_, чник_, tuus, choo, 
   {{0xf5488028,0x7649a2d9,0xdc3a8816,0x0c95b05f}},	//   _cụ_, rdey, _açıq, ешня, 
   {{0x2728824a,0x7529c520,0x660400de,0x2a7f81ea}},	//   bûn_, rtez, zaik, _hlub_, 
   {{0x442115bd,0xa3c9875c,0x7d1b8e53,0xe8d68039}},	//   igh_, लें_, suus, _נוער_, 
   {{0xbbdc000f,0x26d90bfc,0x395201b0,0x25a08121}},	//   _बल्क, _niso_, _prys_, _žile_, 
   {{0xed59b380,0x66042249,0xb5fd8a63,0xceb28309}},	//   _хол_, vaik, ljšo, _גיא_, 
   {{0xd11c13d2,0x660402b9,0x2a6dc521,0xf1b98170}},	//   भूषण_, waik, _loeb_, _myš_, 
   {{0xc7b2896e,0x7d098c05,0x2baf00ab,0x2a7f8816}},	//   ָבן_, lses, _जुला, _olub_, 
   {{0x291da207,0x9f5c1d93,0x6833907b,0x7bc38024}},	//   kuwa_, _því_, lıdı, _iznu, 
   {{0x66044522,0x26d94523,0xafe6167d,0xf8af8c2e}},	// [2da0] raik, _diso_, _попл, टवाय, 
   {{0x660436a3,0x6457a